/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import processing.app.Base;
import processing.app.Mode;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.data.StringDict;
import processing.data.StringList;

public class ExamplesContribution
extends LocalContribution {
    private StringList modeList;

    public static ExamplesContribution load(File folder) {
        return new ExamplesContribution(folder);
    }

    private ExamplesContribution(File folder) {
        super(folder);
        if (this.properties != null) {
            this.modeList = ExamplesContribution.parseModeList(this.properties);
        }
    }

    public static boolean isCompatible(Base base, StringDict props) {
        return ExamplesContribution.isCompatible(base.getActiveEditor().getMode(), props);
    }

    public static boolean isCompatible(Mode mode, StringDict props) {
        String currentIdentifier = mode.getIdentifier();
        StringList compatibleList = ExamplesContribution.parseModeList(props);
        if (compatibleList.size() == 0) {
            return !mode.requireExampleCompatibility();
        }
        return compatibleList.hasValue(currentIdentifier);
    }

    public static boolean isCompatible(Base base, File exampleFolder) {
        StringDict props = ExamplesContribution.loadProperties(exampleFolder, ContributionType.EXAMPLES);
        if (props != null) {
            return ExamplesContribution.isCompatible(base, props);
        }
        return false;
    }

    public static void loadMissing(Base base) {
        File examplesFolder = Base.getSketchbookExamplesFolder();
        List<ExamplesContribution> contribExamples = base.getContribExamples();
        HashMap<File, ExamplesContribution> existing = new HashMap<File, ExamplesContribution>();
        for (ExamplesContribution contrib : contribExamples) {
            existing.put(contrib.getFolder(), contrib);
        }
        File[] potential = ContributionType.EXAMPLES.listCandidates(examplesFolder);
        if (potential != null) {
            for (File folder : potential) {
                if (existing.containsKey(folder)) continue;
                contribExamples.add(new ExamplesContribution(folder));
            }
        }
    }

    @Override
    public ContributionType getType() {
        return ContributionType.EXAMPLES;
    }

    public StringList getModeList() {
        return this.modeList;
    }
}

