/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.StatusPanelDetail;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class ContributionTab
extends JPanel {
    static final int FILTER_WIDTH = Toolkit.zoom(180);
    Base base;
    ContributionType contribType;
    ManagerFrame managerFrame;
    Contribution.Filter filter;
    JComboBox<String> categoryChooser;
    ListPanel listPanel;
    StatusPanel statusPanel;
    FilterField filterField;
    JLabel categoryLabel;
    JLabel loaderLabel;
    JPanel errorPanel;
    JTextPane errorMessage;
    JButton tryAgainButton;
    JButton closeButton;
    String category;
    JProgressBar progressBar;

    public ContributionTab(ManagerFrame dialog) {
        this.managerFrame = dialog;
        this.base = dialog.base;
    }

    public ContributionTab(ManagerFrame frame, ContributionType type) {
        this(frame);
        this.contribType = type;
        this.filter = contrib -> contrib.getType() == this.contribType;
        this.statusPanel = new StatusPanel(this);
        this.listPanel = new ListPanel(this, this.filter, false, new ListPanel.ContributionColumn[0]);
        ContributionListing.getInstance().addListPanel(this.listPanel);
    }

    public void rebuildLayout(boolean error, boolean loading) {
        this.setLayout();
        this.listPanel.setVisible(!loading);
        this.loaderLabel.setVisible(loading);
        this.errorPanel.setVisible(error);
        this.listPanel.fireChange();
        this.validate();
        this.repaint();
    }

    protected void setLayout() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(false);
            this.createComponents();
            this.buildErrorPanel();
            this.loaderLabel = new JLabel(Toolkit.getLibIcon("manager/loader.gif"));
            this.loaderLabel.setOpaque(false);
            this.loaderLabel.setBackground(Color.WHITE);
        }
        int scrollBarWidth = this.listPanel.getScrollBarWidth();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGap(ManagerFrame.STATUS_WIDTH).addComponent(this.filterField, FILTER_WIDTH, FILTER_WIDTH, FILTER_WIDTH).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.categoryChooser, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH, ManagerFrame.AUTHOR_WIDTH).addGap(scrollBarWidth)).addComponent(this.loaderLabel).addComponent(this.listPanel).addComponent(this.errorPanel).addComponent(this.statusPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.categoryChooser).addComponent(this.filterField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.loaderLabel).addComponent(this.listPanel)).addComponent(this.errorPanel).addComponent(this.statusPanel, -2, -1, -2));
        layout.linkSize(1, this.categoryChooser, this.filterField);
        layout.setHonorsVisibility(this.listPanel, false);
        layout.setHonorsVisibility(this.categoryChooser, false);
        this.setBackground(Color.WHITE);
        this.setBorder(null);
    }

    private void createComponents() {
        this.categoryLabel = new JLabel(Language.text("contrib.category"));
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.categoryChooser.setFont(ManagerFrame.NORMAL_PLAIN);
        this.updateCategoryChooser();
        this.categoryChooser.addItemListener(e -> {
            this.category = (String)this.categoryChooser.getSelectedItem();
            if (ManagerFrame.ANY_CATEGORY.equals(this.category)) {
                this.category = null;
            }
            this.filterLibraries(this.category, this.filterField.filters);
        });
        this.filterField = new FilterField();
    }

    protected void buildErrorPanel() {
        this.errorPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.errorPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.errorPanel.setLayout(layout);
        this.errorMessage = new JTextPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setText("<html><body><center>Could not connect to the Processing server.<br>Contributions cannot be installed or updated without an Internet connection.<br>Please verify your network connection again, then try connecting again.</center></body></html>");
        Dimension dim = new Dimension(550, 60);
        this.errorMessage.setMaximumSize(dim);
        this.errorMessage.setMinimumSize(dim);
        this.errorMessage.setOpaque(false);
        this.closeButton = Toolkit.createIconButton("manager/close");
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.addActionListener(e -> this.managerFrame.rebuildTabLayouts(false, false));
        this.tryAgainButton = new JButton("Try Again");
        this.tryAgainButton.setFont(ManagerFrame.NORMAL_PLAIN);
        this.tryAgainButton.addActionListener(e -> {
            this.managerFrame.rebuildTabLayouts(false, true);
            this.managerFrame.downloadAndUpdateContributionListing();
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.errorMessage).addComponent(this.tryAgainButton, StatusPanel.BUTTON_WIDTH, StatusPanel.BUTTON_WIDTH, StatusPanel.BUTTON_WIDTH)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.closeButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.errorMessage).addComponent(this.closeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tryAgainButton));
        this.errorPanel.setBackground(Color.PINK);
        this.errorPanel.validate();
    }

    private Set<String> listCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Contribution c : ContributionListing.getInstance().allContributions) {
            if (!this.filter.matches(c)) continue;
            for (String category : c.getCategories()) {
                categories.add(category);
            }
        }
        return categories;
    }

    protected void updateCategoryChooser() {
        if (this.categoryChooser != null) {
            this.categoryChooser.removeAllItems();
            Set<String> categories = this.listCategories();
            if (categories.size() == 1 && categories.contains("Unknown")) {
                this.categoryChooser.setVisible(false);
            } else {
                this.categoryChooser.addItem(ManagerFrame.ANY_CATEGORY);
                Object[] list = (String[])categories.toArray(String[]::new);
                Arrays.sort(list);
                for (Object category : list) {
                    this.categoryChooser.addItem((String)category);
                }
                this.categoryChooser.setVisible(true);
            }
        }
    }

    protected void filterLibraries(String category, List<String> filters) {
        this.listPanel.filterLibraries(category, filters);
    }

    protected void updateContributionListing() {
        Editor editor = this.base.getActiveEditor();
        if (editor != null) {
            ArrayList<Library> libraries = new ArrayList<Library>(editor.getMode().contribLibraries);
            String sketchbookPath = Base.getSketchbookLibrariesFolder().getAbsolutePath();
            for (Library lib : editor.getMode().coreLibraries) {
                if (!lib.getLibraryPath().startsWith(sketchbookPath)) continue;
                libraries.add(lib);
            }
            ArrayList<Contribution> contributions = new ArrayList<Contribution>(libraries);
            contributions.addAll(this.base.getToolContribs());
            contributions.addAll(this.base.getModeContribs());
            contributions.addAll(this.base.getContribExamples());
            ContributionListing.getInstance().updateInstalledList(contributions);
        }
    }

    public void updateStatusDetail(StatusPanelDetail detail) {
        this.statusPanel.updateDetail(detail);
    }

    protected void updateAll() {
        Collection<StatusPanelDetail> collection = this.listPanel.detailForContrib.values();
        for (StatusPanelDetail detail : collection) {
            detail.update();
        }
        this.listPanel.model.fireTableDataChanged();
    }

    protected boolean hasUpdates() {
        return this.listPanel.getRowCount() > 0;
    }

    public boolean filterHasFocus() {
        return this.filterField != null && this.filterField.hasFocus();
    }

    class FilterField
    extends JTextField {
        List<String> filters;

        public FilterField() {
            super("");
            final JLabel filterLabel = new JLabel("Filter");
            filterLabel.setFont(ManagerFrame.NORMAL_PLAIN);
            filterLabel.setOpaque(false);
            this.setFont(ManagerFrame.NORMAL_PLAIN);
            filterLabel.setIcon(Toolkit.getLibIconX("manager/search"));
            final JButton removeFilter = Toolkit.createIconButton("manager/remove");
            removeFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            removeFilter.setBorderPainted(false);
            removeFilter.setContentAreaFilled(false);
            removeFilter.setCursor(Cursor.getDefaultCursor());
            removeFilter.addActionListener(e -> {
                this.setText("");
                ContributionTab.this.filterField.requestFocusInWindow();
            });
            this.setOpaque(false);
            GroupLayout fl = new GroupLayout(this);
            this.setLayout(fl);
            fl.setHorizontalGroup(fl.createSequentialGroup().addComponent(filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(removeFilter));
            fl.setVerticalGroup(fl.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(fl.createParallelGroup().addComponent(filterLabel).addComponent(removeFilter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE));
            removeFilter.setVisible(false);
            this.filters = new ArrayList<String>();
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (FilterField.this.getText().isEmpty()) {
                        filterLabel.setVisible(true);
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    filterLabel.setVisible(false);
                }
            });
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    removeFilter.setVisible(!FilterField.this.getText().isEmpty());
                    FilterField.this.applyFilter();
                }
            });
        }

        public void applyFilter() {
            String filter = this.getText().toLowerCase();
            this.filters = Arrays.asList(filter.split(" "));
            ContributionTab.this.filterLibraries(ContributionTab.this.category, this.filters);
        }
    }
}

