/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import processing.app.Base;
import processing.app.Library;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.ToolContribution;
import processing.core.PApplet;
import processing.data.StringDict;

public class ContributionListing {
    static volatile ContributionListing singleInstance;
    static final String LISTING_URL = "https://download.processing.org/contribs";
    static final String LOCAL_FILENAME = "contribs.txt";
    File listingFile;
    Set<ListPanel> listPanels = new HashSet<ListPanel>();
    final List<AvailableContribution> advertisedContributions = new ArrayList<AvailableContribution>();
    Map<String, Contribution> librariesByImportHeader = new HashMap<String, Contribution>();
    Set<Contribution> allContributions = new LinkedHashSet<Contribution>();
    boolean listDownloaded;
    ReentrantLock downloadingListingLock = new ReentrantLock();

    private ContributionListing() {
        this.listingFile = Base.getSettingsFile(LOCAL_FILENAME);
        if (this.listingFile.exists()) {
            EventQueue.invokeLater(() -> this.setAdvertisedList(this.listingFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContributionListing getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<ContributionListing> clazz = ContributionListing.class;
        synchronized (ContributionListing.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new ContributionListing();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    private void setAdvertisedList(File file) {
        this.listingFile = file;
        this.advertisedContributions.clear();
        this.advertisedContributions.addAll(ContributionListing.parseContribList(this.listingFile));
        for (Contribution contribution : this.advertisedContributions) {
            this.addContribution(contribution);
        }
    }

    protected void updateInstalledList(List<Contribution> installed) {
        for (Contribution contribution : installed) {
            Contribution existingContribution = this.getContribution(contribution);
            if (existingContribution != null) {
                if (existingContribution == contribution) continue;
                this.replaceContribution(existingContribution, contribution);
                continue;
            }
            this.addContribution(contribution);
        }
    }

    protected void replaceContribution(Contribution oldLib, Contribution newLib) {
        if (oldLib != null && newLib != null) {
            if (oldLib.getImports() != null) {
                for (String importName : oldLib.getImports()) {
                    if (!this.getLibrariesByImportHeader().containsKey(importName)) continue;
                    this.getLibrariesByImportHeader().put(importName, newLib);
                }
            }
            this.allContributions.remove(oldLib);
            this.allContributions.add(newLib);
            for (ListPanel listener : this.listPanels) {
                listener.contributionChanged(oldLib, newLib);
            }
        }
    }

    private void addContribution(Contribution contribution) {
        if (contribution.getImports() != null) {
            for (String importName : contribution.getImports()) {
                this.getLibrariesByImportHeader().put(importName, contribution);
            }
        }
        this.allContributions.add(contribution);
        for (ListPanel listener : this.listPanels) {
            listener.contributionAdded(contribution);
        }
    }

    protected void removeContribution(Contribution contribution) {
        if (contribution.getImports() != null) {
            for (String importName : contribution.getImports()) {
                this.getLibrariesByImportHeader().remove(importName);
            }
        }
        this.allContributions.remove(contribution);
        for (ListPanel listener : this.listPanels) {
            listener.contributionRemoved(contribution);
        }
    }

    private Contribution getContribution(Contribution contribution) {
        for (Contribution c : this.allContributions) {
            if (!c.getName().equals(contribution.getName()) || c.getType() != contribution.getType()) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AvailableContribution getAvailableContribution(Contribution info) {
        List<AvailableContribution> list = this.advertisedContributions;
        synchronized (list) {
            for (AvailableContribution advertised : this.advertisedContributions) {
                if (advertised.getType() != info.getType() || !advertised.getName().equals(info.getName())) continue;
                return advertised;
            }
        }
        return null;
    }

    protected void addListPanel(ListPanel listener) {
        this.listPanels.add(listener);
    }

    public void downloadAvailableList(Base base, ContribProgress progress) {
        new Thread(() -> {
            this.downloadingListingLock.lock();
            try {
                URL url = new URL(LISTING_URL);
                File tempContribFile = Base.getSettingsFile("contribs.tmp");
                if (tempContribFile.exists() && !tempContribFile.canWrite() && !tempContribFile.setWritable(true, false)) {
                    System.err.println("Could not set " + tempContribFile + " writable");
                }
                ContributionManager.download(url, base.getInstalledContribsInfo(), tempContribFile, progress);
                if (!progress.isCanceled() && !progress.isException()) {
                    if (this.listingFile.exists()) {
                        this.listingFile.delete();
                    }
                    if (tempContribFile.renameTo(this.listingFile)) {
                        this.listDownloaded = true;
                        try {
                            EventQueue.invokeAndWait(() -> {
                                this.setAdvertisedList(this.listingFile);
                                base.setUpdatesAvailable(this.countUpdates(base));
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            cause.printStackTrace();
                        }
                    }
                }
            }
            catch (MalformedURLException e) {
                progress.setException(e);
                progress.finished();
            }
            finally {
                this.downloadingListingLock.unlock();
            }
        }, "Contribution List Downloader").start();
    }

    protected boolean hasUpdates(Contribution contrib) {
        if (!contrib.isInstalled()) {
            return false;
        }
        AvailableContribution advertised = this.getAvailableContribution(contrib);
        if (advertised == null) {
            return false;
        }
        return advertised.getVersion() > contrib.getVersion() && advertised.isCompatible(Base.getRevision());
    }

    protected String getLatestPrettyVersion(Contribution contrib) {
        AvailableContribution newestContrib = this.getAvailableContribution(contrib);
        if (newestContrib == null) {
            return null;
        }
        return newestContrib.getPrettyVersion();
    }

    protected boolean isDownloaded() {
        return this.listDownloaded;
    }

    private static List<AvailableContribution> parseContribList(File file) {
        String[] lines;
        ArrayList<AvailableContribution> outgoing = new ArrayList<AvailableContribution>();
        if (file != null && file.exists() && (lines = PApplet.loadStrings((File)file)) != null) {
            int start = 0;
            while (start < lines.length) {
                int end2;
                String type = lines[start];
                ContributionType contribType = ContributionType.fromName(type);
                if (contribType == null) {
                    System.err.println("Error in contribution listing file on line " + (start + 1));
                    for (end2 = ++start; end2 < lines.length && !lines[end2].trim().isEmpty(); ++end2) {
                    }
                    start = end2 + 1;
                    continue;
                }
                for (end2 = ++start; end2 < lines.length && !lines[end2].trim().isEmpty(); ++end2) {
                }
                String[] contribLines = PApplet.subset((String[])lines, (int)start, (int)(end2 - start));
                StringDict contribParams = Util.readSettings(file.getName(), contribLines);
                outgoing.add(new AvailableContribution(contribType, contribParams));
                start = end2 + 1;
            }
        }
        return outgoing;
    }

    public int countUpdates(Base base) {
        int count = 0;
        for (ModeContribution mc : base.getModeContribs()) {
            if (!this.hasUpdates(mc)) continue;
            ++count;
        }
        if (base.getActiveEditor() != null) {
            for (Library lib : base.getActiveEditor().getMode().contribLibraries) {
                if (!this.hasUpdates(lib)) continue;
                ++count;
            }
            for (Library lib : base.getActiveEditor().getMode().coreLibraries) {
                if (!this.hasUpdates(lib)) continue;
                ++count;
            }
        }
        for (ToolContribution tc : base.getToolContribs()) {
            if (!this.hasUpdates(tc)) continue;
            ++count;
        }
        for (ExamplesContribution ec : base.getContribExamples()) {
            if (!this.hasUpdates(ec)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Contribution> getLibrariesByImportHeader() {
        return this.librariesByImportHeader;
    }
}

