/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import processing.app.Language;
import processing.app.Util;
import processing.app.contrib.ContributionType;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public abstract class Contribution {
    static final String IMPORTS_PROPERTY = "imports";
    static final String CATEGORIES_PROPERTY = "categories";
    static final String MODES_PROPERTY = "modes";
    static final String AUTHORS_PROPERTY = "authors";
    static final String UNKNOWN_CATEGORY = "Unknown";
    static final Set<String> validCategories = new HashSet<String>(Arrays.asList("3D", "Animation", "Data", "Geometry", "GUI", "Hardware", "I/O", "Math", "Renderer", "Simulation", "Sound", "Typography", "Utilities", "Video & Vision", "Other"));
    static final String FOUNDATION_AUTHOR = "The Processing Foundation";
    protected StringList categories;
    protected String name;
    protected String authors;
    protected String url;
    protected String sentence;
    protected String paragraph;
    protected int version;
    protected String prettyVersion;
    protected long lastUpdated;
    protected int minRevision;
    protected int maxRevision;
    protected StringList imports;

    protected StringList getCategories() {
        return this.categories;
    }

    protected String getCategoryStr() {
        StringBuilder sb = new StringBuilder();
        for (String category : this.categories) {
            sb.append(category);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    protected boolean hasCategory(String category) {
        if (category != null) {
            for (String c : this.categories) {
                if (!category.equalsIgnoreCase(c)) continue;
                return true;
            }
        }
        return false;
    }

    protected StringList getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthorList() {
        return this.authors;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public int getVersion() {
        return this.version;
    }

    public void setPrettyVersion(String pretty) {
        if (pretty != null && (pretty.equals("null") || pretty.length() == 0)) {
            pretty = null;
        }
        this.prettyVersion = pretty;
    }

    public String getPrettyVersion() {
        return this.prettyVersion;
    }

    public String getBenignVersion() {
        return this.prettyVersion != null ? this.prettyVersion : "";
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public int getMinRevision() {
        return this.minRevision;
    }

    public int getMaxRevision() {
        return this.maxRevision;
    }

    public boolean isCompatible(int versionNum) {
        return (this.maxRevision == 0 || versionNum <= this.maxRevision) && versionNum >= this.minRevision;
    }

    public abstract ContributionType getType();

    public String getTypeName() {
        return this.getType().toString();
    }

    public abstract boolean isInstalled();

    boolean isRestartFlagged() {
        return false;
    }

    boolean isDeletionFlagged() {
        return false;
    }

    boolean isUpdateFlagged() {
        return false;
    }

    public boolean isFoundation() {
        return FOUNDATION_AUTHOR.equals(this.authors);
    }

    public static StringDict loadProperties(File contribFolder, ContributionType type) {
        File propertiesFile = new File(contribFolder, type.getPropertiesName());
        if (propertiesFile.exists()) {
            return Util.readSettings(propertiesFile);
        }
        return null;
    }

    static StringList parseCategories(StringDict properties) {
        StringList outgoing = new StringList();
        String categoryStr = properties.get(CATEGORIES_PROPERTY);
        if (categoryStr != null) {
            String[] listing;
            for (String category : listing = PApplet.trim((String[])PApplet.split((String)categoryStr, (char)','))) {
                if (!validCategories.contains(category)) continue;
                category = Contribution.translateCategory(category);
                outgoing.append(category);
            }
        }
        if (outgoing.size() == 0) {
            outgoing.append(UNKNOWN_CATEGORY);
        }
        return outgoing;
    }

    static StringList parseImports(StringDict properties) {
        StringList outgoing = new StringList();
        String importStr = properties.get(IMPORTS_PROPERTY);
        if (importStr != null) {
            String[] importList;
            for (String importName : importList = PApplet.trim((String[])PApplet.split((String)importStr, (char)','))) {
                if (importName.isEmpty()) continue;
                outgoing.append(importName);
            }
        }
        return outgoing.size() > 0 ? outgoing : null;
    }

    static StringList parseModeList(StringDict properties) {
        String unparsedModes = properties.get(MODES_PROPERTY);
        if ("null".equals(unparsedModes)) {
            properties.remove(MODES_PROPERTY);
            unparsedModes = null;
        }
        StringList outgoing = new StringList();
        if (unparsedModes != null) {
            outgoing.append(PApplet.trim((String[])PApplet.split((String)unparsedModes, (char)',')));
        }
        return outgoing;
    }

    private static String translateCategory(String cat) {
        String cleaned = cat.replaceAll("[\\W]+", "_").toLowerCase();
        return Language.text("contrib.category." + cleaned);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Contribution) {
            Contribution that = (Contribution)o;
            return this.name.equalsIgnoreCase(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public String toString() {
        return this.getName() + " @" + Integer.toHexString(super.hashCode());
    }

    public static interface Filter {
        public boolean matches(Contribution var1);
    }
}

