/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Messages;

public class WebServer {
    static final int HTTP_OK = 200;
    static final int HTTP_NOT_FOUND = 404;
    static final int HTTP_BAD_METHOD = 405;
    private final Vector<Worker> threads = new Vector();
    static final int WORKERS = 5;
    private final int port;
    private final ZipFile zip;
    private final Map<String, ZipEntry> entries;
    static final int BUFFER_SIZE = 8192;
    static final byte[] EOL = new byte[]{13, 10};
    static final Map<String, String> contentTypes = new ConcurrentHashMap<String, String>();

    public WebServer(File zipFile, int port) throws IOException {
        this.zip = new ZipFile(zipFile);
        this.port = port;
        this.entries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> en = this.zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            this.entries.put(entry.getName(), entry);
        }
        for (int i = 0; i < 5; ++i) {
            Worker w = new Worker();
            Thread t = new Thread((Runnable)w, "Web Server Worker #" + i);
            t.start();
            this.threads.addElement(w);
        }
        new Thread(() -> {
            try {
                ServerSocket ss = new ServerSocket(port);
                while (true) {
                    Socket s = ss.accept();
                    Vector<Worker> vector = this.threads;
                    synchronized (vector) {
                        if (this.threads.isEmpty()) {
                            Worker ws = new Worker();
                            ws.setSocket(s);
                            new Thread((Runnable)ws, "additional worker").start();
                        } else {
                            Worker w = this.threads.elementAt(0);
                            this.threads.removeElementAt(0);
                            w.setSocket(s);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }).start();
    }

    public String getPrefix() {
        return "http://localhost:" + this.port + "/";
    }

    public static void main(String[] args) {
        try {
            new WebServer(new File(args[0]), 8053);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        contentTypes.put("", "content/unknown");
        contentTypes.put(".css", "text/css");
        contentTypes.put(".csv", "text/csv");
        contentTypes.put(".eot", "application/vnd.ms-fontobject");
        contentTypes.put(".gif", "image/gif");
        contentTypes.put(".html", "text/html");
        contentTypes.put(".ico", "image/x-icon");
        contentTypes.put(".jpeg", "image/jpeg");
        contentTypes.put(".jpg", "image/jpeg");
        contentTypes.put(".js", "text/javascript");
        contentTypes.put(".json", "application/json");
        contentTypes.put(".md", "text/markdown");
        contentTypes.put(".mdx", "text/mdx");
        contentTypes.put(".mtl", "text/plain");
        contentTypes.put(".obj", "text/plain");
        contentTypes.put(".otf", "font/otf");
        contentTypes.put(".pde", "text/plain");
        contentTypes.put(".png", "image/png");
        contentTypes.put(".svg", "image/svg+xml");
        contentTypes.put(".tsv", "text/tab-separated-values");
        contentTypes.put(".ttf", "font/ttf");
        contentTypes.put(".txt", "text/plain");
        contentTypes.put(".vlw", "application/octet-stream");
        contentTypes.put(".woff", "font/woff");
        contentTypes.put(".woff2", "font/woff2");
        contentTypes.put(".xml", "application/xml");
        contentTypes.put(".yml", "text/yaml");
        contentTypes.put(".zip", "application/zip");
    }

    class Worker
    implements Runnable {
        byte[] buffer = new byte[8192];
        private Socket socket = null;

        Worker() {
        }

        synchronized void setSocket(Socket s) {
            this.socket = s;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            while (true) {
                if (this.socket == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                try {
                    this.handleClient();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.socket = null;
                Vector<Worker> vector = WebServer.this.threads;
                synchronized (vector) {
                    if (WebServer.this.threads.size() >= 5) {
                        return;
                    }
                    WebServer.this.threads.addElement(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleClient() throws IOException {
            BufferedInputStream is = new BufferedInputStream(this.socket.getInputStream());
            PrintStream ps = new PrintStream(this.socket.getOutputStream());
            this.socket.setSoTimeout(10000);
            this.socket.setTcpNoDelay(true);
            for (int i = 0; i < 8192; ++i) {
                this.buffer[i] = 0;
            }
            try {
                int i;
                int index;
                boolean doingGet;
                int length = 0;
                block6: while (length < 8192) {
                    int r = ((InputStream)is).read(this.buffer, length, 8192 - length);
                    if (r == -1) {
                        return;
                    }
                    int i2 = length;
                    length += r;
                    while (i2 < length) {
                        if (this.buffer[i2] == 10 || this.buffer[i2] == 13) break block6;
                        ++i2;
                    }
                }
                if (this.buffer[0] == 71 && this.buffer[1] == 69 && this.buffer[2] == 84 && this.buffer[3] == 32) {
                    doingGet = true;
                    index = 4;
                } else if (this.buffer[0] == 72 && this.buffer[1] == 69 && this.buffer[2] == 65 && this.buffer[3] == 68 && this.buffer[4] == 32) {
                    doingGet = false;
                    index = 5;
                } else {
                    ps.print("HTTP/1.0 405 unsupported method type: ");
                    ps.write(this.buffer, 0, 5);
                    ps.write(EOL);
                    ps.flush();
                    this.socket.close();
                    return;
                }
                for (i = index; i < length && this.buffer[i] != 32; ++i) {
                }
                String path = new String(this.buffer, index, i - index);
                ZipEntry entry = WebServer.this.entries.get(path.substring(1));
                boolean ok = this.printHeaders(ps, path, entry);
                if (entry != null) {
                    InputStream stream = WebServer.this.zip.getInputStream(entry);
                    if (doingGet && ok) {
                        this.sendFile(stream, ps);
                    }
                } else {
                    this.send404(ps);
                }
            }
            finally {
                this.socket.close();
            }
        }

        boolean printHeaders(PrintStream ps, String path, ZipEntry entry) throws IOException {
            int status;
            if (entry == null) {
                status = 404;
                ps.print("HTTP/1.0 404 Not Found");
            } else {
                status = 200;
                ps.print("HTTP/1.0 200 OK");
            }
            ps.write(EOL);
            Messages.log("From " + this.socket.getInetAddress().getHostAddress() + ": GET " + path + " --> " + status);
            ps.print("Server: Processing Reference Server");
            ps.write(EOL);
            ps.print("Date: " + new Date());
            ps.write(EOL);
            if (entry != null) {
                if (!entry.isDirectory()) {
                    ps.print("Content-length: " + entry.getSize());
                    ps.write(EOL);
                    ps.print("Last Modified: " + new Date(entry.getTime()));
                    ps.write(EOL);
                    String name = entry.getName();
                    int ind = name.lastIndexOf(46);
                    String contentType = "application/x-unknown-content-type";
                    if (ind > 0) {
                        contentType = contentTypes.getOrDefault(name.substring(ind), contentType);
                    }
                    ps.print("Content-type: " + contentType);
                } else {
                    ps.print("Content-type: text/html");
                }
                ps.write(EOL);
            }
            ps.write(EOL);
            return status == 200;
        }

        void send404(PrintStream ps) throws IOException {
            ps.write(EOL);
            ps.write(EOL);
            ps.print("<html><body><h1>404 Not Found</h1>");
            ps.print("The requested resource was not found.</body></html>");
            ps.write(EOL);
            ps.write(EOL);
        }

        void sendFile(InputStream is, PrintStream ps) throws IOException {
            try (InputStream inputStream = is;){
                int n;
                while ((n = is.read(this.buffer)) > 0) {
                    ps.write(this.buffer, 0, n);
                }
            }
        }
    }
}

