/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.platform.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.StringDict;

public class Platform {
    static DefaultPlatform inst;
    static Map<String, Integer> platformIndices;
    static int nativeBits;
    static StringDict supportedVariants;
    protected static File processingRoot;

    public static boolean isAvailable() {
        return inst != null;
    }

    public static void init() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Platform.isMacOS()) {
                platformClass = Class.forName("processing.app.platform.MacPlatform");
            } else if (Platform.isWindows()) {
                platformClass = Class.forName("processing.app.platform.WindowsPlatform");
            } else if (Platform.isLinux()) {
                platformClass = Class.forName("processing.app.platform.LinuxPlatform");
            }
            inst = (DefaultPlatform)platformClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Messages.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", e);
        }
    }

    public static void initBase(Base base) throws Exception {
        inst.initBase(base);
    }

    public static void setLookAndFeel() throws Exception {
        inst.setLookAndFeel();
    }

    public static void setInterfaceZoom() throws Exception {
        inst.setInterfaceZoom();
    }

    public static float getSystemZoom() {
        return inst == null ? 1.0f : inst.getSystemZoom();
    }

    public static File getSettingsFolder() throws Exception {
        return inst.getSettingsFolder();
    }

    public static File getDefaultSketchbookFolder() throws Exception {
        return inst.getDefaultSketchbookFolder();
    }

    public static void saveLanguage(String languageCode) {
        inst.saveLanguage(languageCode);
    }

    public static void openURL(String url) {
        try {
            inst.openURL(url);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening URL", "Could not open the URL\n" + url, e);
        }
    }

    public static boolean openFolderAvailable() {
        return inst.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            inst.openFolder(file);
        }
        catch (Exception e) {
            Messages.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), e);
        }
    }

    public static String getNativeArch() {
        return System.getProperty("os.arch");
    }

    public static String getVariant() {
        return Platform.getName() + "-" + Platform.getNativeArch();
    }

    public static StringDict getSupportedVariants() {
        return supportedVariants;
    }

    public static String getName() {
        return PConstants.platformNames[PApplet.platform];
    }

    public static int getIndex(String platformName) {
        int index = platformName.indexOf(45);
        if (index != -1) {
            platformName = platformName.substring(0, index);
        }
        return platformIndices.getOrDefault(platformName, -1);
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").contains("Linux");
    }

    public static File getContentFile(String name) {
        if (processingRoot == null) {
            String decodedPath;
            URL pathURL = Base.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                decodedPath = pathURL.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                Messages.showError("Missing File", "Could not access a required file:\n<b>" + name + "</b>\nYou may need to reinstall Processing.", e);
                return null;
            }
            if (decodedPath.contains("/app/bin")) {
                File build = new File(decodedPath, "../../build").getAbsoluteFile();
                if (Platform.isMacOS()) {
                    processingRoot = new File(build, "macos/work/Processing.app/Contents/Java");
                } else if (Platform.isWindows()) {
                    processingRoot = new File(build, "windows/work");
                } else if (Platform.isLinux()) {
                    processingRoot = new File(build, "linux/work");
                }
            } else {
                File jarFolder = new File(decodedPath).getParentFile();
                if (jarFolder.getName().equals("lib")) {
                    processingRoot = jarFolder.getParentFile();
                } else if (Platform.isMacOS()) {
                    processingRoot = jarFolder;
                }
                if (processingRoot == null || !processingRoot.exists()) {
                    System.err.println("Could not find lib folder via " + jarFolder.getAbsolutePath() + ", switching to user.dir");
                    processingRoot = new File("");
                }
            }
        }
        return new File(processingRoot, name);
    }

    public static File getJavaHome() {
        if (Platform.isMacOS()) {
            File[] plugins = Platform.getContentFile("../PlugIns").listFiles((dir, name) -> dir.isDirectory() && name.contains("jdk") && !name.startsWith("."));
            return new File(plugins[0], "Contents/Home");
        }
        return Platform.getContentFile("java");
    }

    public static String getJavaPath() {
        String javaPath = "bin/java" + (Platform.isWindows() ? ".exe" : "");
        File javaFile = new File(Platform.getJavaHome(), javaPath);
        try {
            return javaFile.getCanonicalPath();
        }
        catch (IOException e) {
            return javaFile.getAbsolutePath();
        }
    }

    public static boolean deleteFile(File file) throws IOException {
        try {
            FileUtils fu = FileUtils.getInstance();
            if (fu.hasTrash()) {
                fu.moveToTrash(new File[]{file});
                return true;
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
        if (file.isDirectory()) {
            Util.removeDir(file);
            return true;
        }
        return file.delete();
    }

    public static void setenv(String variable, String value) {
        inst.setenv(variable, value);
    }

    public static String getenv(String variable) {
        return inst.getenv(variable);
    }

    public static int unsetenv(String variable) {
        return inst.unsetenv(variable);
    }

    static {
        platformIndices = new HashMap<String, Integer>();
        platformIndices.put("windows", 1);
        platformIndices.put("macos", 2);
        platformIndices.put("linux", 3);
        nativeBits = 32;
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            if (bits.equals("64")) {
                nativeBits = 64;
            }
        } else if (System.getProperty("java.vm.name").contains("64")) {
            nativeBits = 64;
        }
        supportedVariants = new StringDict((String[][])new String[][]{{"macos-x86_64", "macOS (Intel 64-bit)"}, {"macos-aarch64", "macOS (Apple Silicon)"}, {"windows-amd64", "Windows (Intel 64-bit)"}, {"linux-amd64", "Linux (Intel 64-bit)"}, {"linux-arm", "Linux (Raspberry Pi 32-bit)"}, {"linux-aarch64", "Linux (Raspberry Pi 64-bit)"}});
    }
}

