/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.Util;
import processing.app.contrib.ContributionType;
import processing.app.contrib.LocalContribution;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;

public class Library
extends LocalContribution {
    static StringDict newToOld = new StringDict((String[][])new String[][]{{"macos-x86_64", "macosx"}, {"windows-amd64", "windows64"}, {"linux-amd64", "linux64"}, {"linux-arm", "linux-armv6hf"}, {"linux-aarch64", "linux-arm64"}});
    protected File libraryFolder;
    protected File examplesFolder;
    protected File referenceFile;
    protected String group;
    StringList packageList;
    Map<String, String[]> exportList;
    String[] baseList;
    String[] androidExportList;
    String nativeLibraryPath;
    public static final String propertiesFileName = "library.properties";
    static FilenameFilter libraryFolderFilter = (dir, name) -> {
        if (name.charAt(0) == '.') {
            return false;
        }
        if (name.equals("CVS")) {
            return false;
        }
        if (name.equals("export.txt")) {
            return false;
        }
        File file = new File(dir, name);
        return !file.isDirectory() || !name.startsWith("macos") && !name.startsWith("windows") && !name.startsWith("linux");
    };
    static FilenameFilter jarFilter = (dir, name) -> {
        if (name.charAt(0) == '.') {
            return false;
        }
        if (new File(dir, name).isDirectory()) {
            return false;
        }
        String lc = name.toLowerCase();
        return lc.endsWith(".jar") || lc.endsWith(".zip");
    };
    protected static FilenameFilter junkFolderFilter = (dir, name) -> {
        if (name.charAt(0) == '.') {
            return false;
        }
        if (name.equals("CVS")) {
            return false;
        }
        return new File(dir, name).isDirectory();
    };

    public static Library load(File folder) {
        try {
            return new Library(folder);
        }
        catch (Error err) {
            err.printStackTrace();
            return null;
        }
    }

    public Library(File folder) {
        this(folder, null);
    }

    private Library(File folder, String groupName) {
        super(folder);
        this.group = groupName;
        this.libraryFolder = new File(folder, "library");
        this.examplesFolder = new File(folder, "examples");
        this.referenceFile = new File(folder, "reference/index.html");
        this.handle();
    }

    protected void handle() {
        this.handleNative();
        this.handleExports();
    }

    private void handleNative() {
        String variant = Platform.getVariant();
        File nativeLibraryFolder = this.libraryFolder;
        File hostLibrary = new File(this.libraryFolder, variant);
        if (hostLibrary.exists()) {
            nativeLibraryFolder = hostLibrary;
        } else {
            String oldName = newToOld.get(variant);
            if (oldName != null && (hostLibrary = new File(this.libraryFolder, oldName)).exists()) {
                nativeLibraryFolder = hostLibrary;
            }
        }
        this.nativeLibraryPath = nativeLibraryFolder.getAbsolutePath();
    }

    private void handleExports() {
        this.exportList = new HashMap<String, String[]>();
        this.baseList = this.libraryFolder.list(libraryFolderFilter);
        for (String variant : Platform.getSupportedVariants().keys()) {
            String[] entries;
            String oldName;
            File variantFolder = new File(this.libraryFolder, variant);
            if (!variantFolder.exists() && (oldName = newToOld.get(variant, null)) != null && (variantFolder = new File(this.libraryFolder, variant)).exists()) {
                Messages.log("Please update " + this.getName() + " for Processing 4. " + variantFolder + " is the older naming scheme.");
            }
            if (!variantFolder.exists() || (entries = Library.listPlatformEntries(this.libraryFolder, variant, this.baseList)) == null) continue;
            this.exportList.put(variant, entries);
        }
        this.packageList = Util.packageListFromClassPath(this.getClassPath());
    }

    static String[] listPlatformEntries(File libraryFolder, String folderName, String[] baseList) {
        String[] entries;
        File folder = new File(libraryFolder, folderName);
        if (folder.exists() && (entries = folder.list((dir, name) -> name.charAt(0) != '.')) != null) {
            String[] outgoing = new String[entries.length + baseList.length];
            for (int i = 0; i < entries.length; ++i) {
                outgoing[i] = folderName + "/" + entries[i];
            }
            System.arraycopy(baseList, 0, outgoing, entries.length, baseList.length);
            return outgoing;
        }
        return null;
    }

    public void addPackageList(Map<String, List<Library>> importToLibraryTable) {
        for (String pkg : this.packageList) {
            List<Library> libraries = importToLibraryTable.get(pkg);
            if (libraries == null) {
                libraries = new ArrayList<Library>();
                importToLibraryTable.put(pkg, libraries);
            } else if (Base.DEBUG) {
                System.err.println("The library found in");
                System.err.println(this.getPath());
                System.err.println("conflicts with");
                for (Library library : libraries) {
                    System.err.println(library.getPath());
                }
                System.err.println("which already define(s) the package " + pkg);
                System.err.println("If you have a line in your sketch that reads");
                System.err.println("import " + pkg + ".*;");
                System.err.println("Then you'll need to first remove one of those libraries.");
                System.err.println();
            }
            libraries.add(this);
        }
    }

    public boolean hasExamples() {
        return this.examplesFolder.exists();
    }

    public File getExamplesFolder() {
        return this.examplesFolder;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.folder.getAbsolutePath();
    }

    public String getLibraryPath() {
        return this.libraryFolder.getAbsolutePath();
    }

    public String getJarPath() {
        return new File(this.libraryFolder, this.folder.getName() + ".jar").getAbsolutePath();
    }

    public String getClassPath() {
        File nativeLibraryFolder;
        StringBuilder cp = new StringBuilder();
        String[] jarHeads = this.libraryFolder.list(jarFilter);
        if (jarHeads != null) {
            for (String jar : jarHeads) {
                cp.append(File.pathSeparatorChar);
                cp.append(new File(this.libraryFolder, jar).getAbsolutePath());
            }
        }
        if (!this.libraryFolder.equals(nativeLibraryFolder = new File(this.nativeLibraryPath)) && (jarHeads = new File(this.nativeLibraryPath).list(jarFilter)) != null) {
            for (String jar : jarHeads) {
                cp.append(File.pathSeparatorChar);
                cp.append(new File(this.nativeLibraryPath, jar).getAbsolutePath());
            }
        }
        return cp.toString();
    }

    public String getNativePath() {
        return this.nativeLibraryPath;
    }

    protected File[] wrapFiles(String[] list) {
        File[] outgoing = new File[list.length];
        for (int i = 0; i < list.length; ++i) {
            outgoing[i] = new File(this.libraryFolder, list[i]);
        }
        return outgoing;
    }

    public File[] getApplicationExports(String variant) {
        String[] list = this.getApplicationExportList(variant);
        return this.wrapFiles(list);
    }

    public String[] getApplicationExportList(String variant) {
        if (this.exportList.isEmpty()) {
            return this.baseList;
        }
        return this.exportList.get(variant);
    }

    public File[] getAndroidExports() {
        return this.wrapFiles(this.androidExportList);
    }

    public boolean isUnsupported(String variant) {
        if (this.exportList.isEmpty()) {
            return false;
        }
        return this.getApplicationExportList(variant) == null;
    }

    public static String findCollision(File folder) {
        File[] jars = PApplet.listFiles((File)folder, (String[])new String[]{"recursive", "extension=jar"});
        if (jars != null) {
            for (File file : jars) {
                try {
                    ZipFile zf = new ZipFile(file);
                    if (zf.getEntry("processing/core/PApplet.class") != null) {
                        return "processing.core";
                    }
                    if (zf.getEntry("processing/app/Base.class") != null) {
                        return "processing.app";
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static List<File> discover(File folder) {
        ArrayList<File> libraries = new ArrayList<File>();
        String[] folderNames = folder.list(junkFolderFilter);
        if (folderNames != null) {
            Arrays.sort(folderNames, String.CASE_INSENSITIVE_ORDER);
            for (String potentialName : folderNames) {
                File baseFolder = new File(folder, potentialName);
                File libraryFolder = new File(baseFolder, "library");
                File libraryJar = new File(libraryFolder, potentialName + ".jar");
                if (!libraryJar.exists()) continue;
                String sanityCheck = Sketch.sanitizeName(potentialName);
                if (!sanityCheck.equals(potentialName)) {
                    String mess = "The library \"" + potentialName + "\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)";
                    Messages.showMessage("Ignoring bad library name", mess);
                    continue;
                }
                String pkg = Library.findCollision(libraryFolder);
                if (pkg != null) {
                    String mess = "The library \"" + potentialName + "\" cannot be used\nbecause it contains the " + pkg + " libraries.\nPlease contact the library author for an update.";
                    Messages.showMessage("Ignoring bad library", mess);
                    File badFolder = new File(baseFolder.getParentFile(), "disabled");
                    boolean success = true;
                    if (!badFolder.exists()) {
                        success = badFolder.mkdirs();
                    }
                    if (!success) continue;
                    File hideFolder = new File(badFolder, baseFolder.getName());
                    success = baseFolder.renameTo(hideFolder);
                    if (success) {
                        System.out.println("Moved " + baseFolder + " to " + hideFolder);
                        continue;
                    }
                    System.err.println("Could not move " + baseFolder + " to " + hideFolder);
                    continue;
                }
                libraries.add(baseFolder);
            }
        }
        return libraries;
    }

    public static List<Library> list(File folder) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        ArrayList<File> librariesFolders = new ArrayList<File>(Library.discover(folder));
        for (File baseFolder : librariesFolders) {
            libraries.add(new Library(baseFolder));
        }
        return libraries;
    }

    @Override
    public ContributionType getType() {
        return ContributionType.LIBRARY;
    }

    public File getReferenceIndexFile() {
        return this.referenceFile;
    }

    public boolean hasReference() {
        return this.referenceFile.exists();
    }
}

