/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import processing.app.Base;

public class Console {
    static PrintStream systemOut;
    static PrintStream systemErr;
    static PrintStream consoleOut;
    static PrintStream consoleErr;
    static OutputStream stdoutFile;
    static OutputStream stderrFile;
    static OutputStream editorOut;
    static OutputStream editorErr;

    public static void startup() {
        if (systemOut != null) {
            new Exception("startup() called more than once").printStackTrace(systemErr);
            return;
        }
        systemOut = System.out;
        systemErr = System.err;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd_HHmmss");
            final String stamp = formatter.format(new Date());
            File consoleDir = Base.getSettingsFile("console");
            if (consoleDir.exists()) {
                File[] stdFiles;
                for (File file : stdFiles = consoleDir.listFiles(new FileFilter(){
                    final String todayPrefix;
                    {
                        this.todayPrefix = stamp.substring(0, 4);
                    }

                    @Override
                    public boolean accept(File file) {
                        String name;
                        if (!file.isDirectory() && ((name = file.getName()).endsWith(".err") || name.endsWith(".out"))) {
                            return !name.startsWith(this.todayPrefix);
                        }
                        return false;
                    }
                })) {
                    file.delete();
                }
            } else {
                consoleDir.mkdirs();
                consoleDir.setWritable(true, false);
            }
            File outFile = new File(consoleDir, stamp + ".out");
            outFile.setWritable(true, false);
            stdoutFile = new FileOutputStream(outFile);
            File errFile = new File(consoleDir, stamp + ".err");
            errFile.setWritable(true, false);
            stderrFile = new FileOutputStream(errFile);
            consoleOut = new PrintStream(new ConsoleStream(false));
            consoleErr = new PrintStream(new ConsoleStream(true));
            System.setOut(consoleOut);
            System.setErr(consoleErr);
        }
        catch (Exception e) {
            stdoutFile = null;
            stderrFile = null;
            consoleOut = null;
            consoleErr = null;
            System.setOut(systemOut);
            System.setErr(systemErr);
            e.printStackTrace();
        }
    }

    public static void setEditor(OutputStream out, OutputStream err) {
        editorOut = out;
        editorErr = err;
    }

    public static void systemOut(String what) {
        systemOut.println(what);
    }

    public static void systemErr(String what) {
        systemErr.println(what);
    }

    public static void shutdown() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        Console.cleanup(consoleOut);
        Console.cleanup(consoleErr);
        Console.cleanup(stdoutFile);
        Console.cleanup(stderrFile);
    }

    private static void cleanup(OutputStream output) {
        try {
            if (output != null) {
                output.flush();
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class ConsoleStream
    extends OutputStream {
        boolean err;
        byte[] single = new byte[1];

        public ConsoleStream(boolean err) {
            this.err = err;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            if (this.err) {
                systemErr.write(b, offset, length);
            } else {
                systemOut.write(b, offset, length);
            }
            this.writeFile(b, offset, length);
            try {
                if (this.err) {
                    if (editorErr != null) {
                        editorErr.write(b, offset, length);
                    }
                } else if (editorOut != null) {
                    editorOut.write(b, offset, length);
                }
            }
            catch (IOException e) {
                e.printStackTrace(systemErr);
            }
        }

        public void writeFile(byte[] b, int offset, int length) {
            OutputStream echo;
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b, offset, length);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void write(int b) {
            this.single[0] = (byte)b;
            this.write(this.single, 0, 1);
        }
    }
}

