Uma variável é o nome que pode fazer referência a um valor específico. Variáveis são declaradas usando a palavra `let` seguida do nome da variável.

Aqui está um exemplo:

```js
let example;
```

A variável acima foi **declarada**, mas ainda não foi definida (ou seja, ainda não faz referência á um valor específico).

Aqui está um exemplo de como definir uma variável, fazendo ela referenciar um valor específico:

```js
let example = 'some string';
```

# OBSERVAÇÃO

Um variável é **declarada** quando usamos `let`, e o `=` é usado para **definir** o valor pelo qual a variável vai fazer referência. 

Coloquialmente dizemos que "criamos uma variável com um valor".

## Desafio:

Crie um arquivo chamado `variables.js`.

No arquivo que foi criado declare uma variável chamada `example`.

**Faça a variável `example` ter o valor igual á `'some string'`.**

Então use o `console.log()` para imprimir a variável `example` no console.

Verifique se o seu programa está correto executando este comando:

`javascripting verify variables.js`
