변수는 특정 값을 참조하는 이름입니다. 변수는 `let`와 변수의 이름으로 선언합니다.

예제를 보세요.

```js
let example;
```

위 변수는 **선언**되었지만, 정의되지는 않았습니다.(아직 특정 값을 참조하지 않았습니다.)

특정 값을 참조하게 만든, 변수를 정의하는 예제입니다.

```js
let example = 'some string';
```

# 주의

변수는 `let`를 사용해 **선언**하고 등호(`=`)를 이용해 참조하는 값을 넣어 **정의**합니다. "변수는 값과 같게 만든다."라고 읽을 수 있습니다.

## 도전 과제

`variables.js`라는 파일을 만듭니다.

그 파일 안에서 `example`라는 변수를 선언합니다.

**`example` 변수를 `'some string'` 값과 같게 만듭니다.**
**Make the variable `example` equal to the value `'some string'`.**

그리고 `console.log()`로 `example` 변수를 콘솔에 출력합니다.

이 명령어를 실행해 프로그램이 올바른지 확인하세요.

`javascripting verify variables.js`
