A variable is a name that can reference a specific value. Variables are declared using `let` followed by the variable's name.

Here's an example:

```js
let example;
```

The above variable is **declared**, but it isn't defined (it does not yet reference a specific value).

Here's an example of defining a variable, making it reference a specific value:

```js
let example = 'some string';
```

# NOTE 

A variable is **declared** using `let` and uses the equals sign to **define** the value that it references. This is colloquially known as "Making a variable equal a value".

## The challenge:

Create a file named `variables.js`.

In that file declare a variable named `example`.

**Make the variable `example` equal to the value `'some string'`.**

Then use `console.log()` to print the `example` variable to the console.

Check to see if your program is correct by running this command:

`javascripting verify variables.js`
