`Область видимості (Scope)` — це множина змінних, об’єктів та функцій до яких ви маєте доступ.

JavaScript має дві області видимості: `глобальну` та `локальну`. Змінні, що оголошені поза визначенням функції є `глобальною` змінною, тож її значення буде доступне для читання та модифікації у всій вашій програмі. Змінну, яка оголошена всередині визначення функції, називають `локальною`. Вона створюється та знищується кожного разу коли функція виконується і її значення не можна отримати поза цієї функції.

Функції, які визначені всередині інших функцій, також відомі як вкладені (nested) функції, мають доступ до області видимості їх батьківських функцій.

Зверніть увагу на коментарі у цьому прикладі:

```js
const a = 4; // a є глобальною змінною, її значення можна отримати з функцій нижче

function foo() {
  let b = a * 3; // b не можу бути доступною поза функцією foo, але доступна у
								// функціях, оголошених всередині foo
  function bar(c) {
    let b = 2; // інша змінна `b` створена всередині функції bar зміна значення
              // цієї змінної `b` не вплине на попередню змінну `b`
    console.log( a, b, c );
  }

  bar(b * 4);
}

foo(); // 4, 2, 48
```
Функції миттєвого (негайного) виклику, або «самовикликаючі» функцій (IIFE, Immediately Invoked Function Expression) є загальною практикою для створення локальних областей видимості
Приклад:
```js
(function(){ // вираз функції оточений круглими дужками
		// змінні оголошені тут
		// не будуть доступними ззовні
})(); // функція відразу ж викликається
```
## Завдання:

Створити файл `scope.js`.

До цього файлу скопіювати такий код:
```js
let a = 1, b = 2, c = 3;

(function firstFunction(){
  let b = 5, c = 6;

  (function secondFunction(){
    let b = 8;

    (function thirdFunction(){
      let a = 7, c = 9;

      (function fourthFunction(){
        let a = 1, c = 8;

      })();
    })();
  })();
})();
```

Використайте ваші знання про `область видимості` змінних та помістіть код нижче в таку функцію зі 'scope.js', щоб результат був рядок `a: 1, b: 8,c: 6`:
```js
console.log(`a: ${a}, b: ${b}, c: ${c}`);
```

Перевірте вашу відповідь запустивши команду:

```bash
javascripting verify scope.js
```
