`Область видимости` описывает множество переменных, объектов, а также функций, к которым есть непосредственный доступ.

JavaScript обладает двумя областями видимости: `глобальной` и `локальной`. Переменная, объявленная снаружи функции, является `глобальной` переменной. Она доступна и изменяема из любого места вашей программы. При объявлении переменной внутри функции мы получаем `локальную` переменную. Она создаётся и удаляется каждый раз при вызове функции. К такой переменной нельзя получить доступ извне функции.

Функции, объявленные внутри других функций, известные также как вложенные (дочерние) функции, имеют доступ к области видимости родительской функции.

Обратите внимание на комментарии к приведённому ниже коду:

```js
const a = 4; // это глобальная переменная, она доступна для функций ниже

function foo() {
  let b = a * 3; // к переменной `b` нет доступа снаружи функции `foo`, но к
                 // этой переменной имеют доступ функции, объявленные внутри `foo`
  function bar(c) {
    let b = 2; // ещё одна переменная `b` создана внутри области видимости
              // функции `bar`, модификации этой новой переменной `b` никак не
             // отразятся на объявленной выше переменной `b`
    console.log( a, b, c );
  }

  bar(b * 4);
}

foo(); // 4, 2, 48
```

Непосредственно выполняемая функция-выражение (IIFE) -- распространённый паттерн создания локальной области видимости.

Например:

```js
(function() { // объявление функции окружено круглыми скобками
  // переменные, объявленные здесь,
  // не будут доступны снаружи
})(); // функция сразу же вызывается
```

## Условия задачи

Создайте файл `scope.js`.

Скопируйте в него следующий код:

```js
let a = 1, b = 2, c = 3;

(function firstFunction(){
  let b = 5, c = 6;

  (function secondFunction(){
    let b = 8;

    (function thirdFunction(){
      let a = 7, c = 9;

      (function fourthFunction(){
        let a = 1, c = 8;

      })();
    })();
  })();
})();
```

Используя полученные знания об `областях видимости`, разместите приведённый ниже код внутри одной из функций, объявленных в `scope.js` так, чтобы на выходе получилось `a: 1, b: 8, c: 6`.

```js
console.log(`a: ${a}, b: ${b}, c: ${c}`);
```

Чтобы удостовериться в правильности решения задачи, запустите следующую команду из терминала:

```bash
javascripting verify scope.js
```
