関数の引数はいくつでも宣言できます。引数はどんな型でも大丈夫です。文字列、数値、配列、オブジェクト、関数さえも引数になり得ます。

たとえば...


```js
function example (firstArg, secondArg) {
  console.log(firstArg, secondArg);
}
```

引数が2つの関数を**呼び出す**には、次のようにします。

```js
example('hello', 'world');
```

上の例を実行すると、ターミナルに `hello world` と出力されるでしょう。

## やってみよう

`function-arguments.js` ファイルを作りましょう。

ファイルの中で、関数 `math` を定義します。引数は三つです。

重要なことがあります。引数名は引数の値を参照するためだけに使います。引数名は好きに決めてかまいません。

`math` 関数は、2番目と3番目の引数を掛け、その結果に1番目の引数を足します。そうして得られた値を返してください。

その後、 `console.log()` の括弧の内側で、 `math()` 関数を呼びます。1番目の引数に数値 `53` を、2番目に `61` を、3番目に `67` を指定してください。

次のコマンドを実行し、あなたのプログラムが正しく動くか確認しましょう。

```bash
javascripting verify function-arguments.js
```
