Цикл for позволяет выполнить заданный блок кода определённое количество раз.
Этот цикл for выводит значение переменной в консоль десять раз:

```js
for (let i = 0; i < 10; i++) {
  // выводим в консоль числа от 0 до 9
  console.log(i)
}
```

Первая часть конструкции цикла for, `let i = 0`, выполняется один раз в начале работы цикла. При этом переменная `i` в данном примере используется для хранения количества итераций цикла.

Условие `i < 10;` проверяется в начале каждой итерации перед выполнением блока кода, заданного внутри цикла. Если условие является верным, то блок кода внутри цикла будет выполнен. В противном случае выполнение цикла завершается. Выражение `i < 10;` задаёт предел выполнения цикла. Цикл будет выполняться до тех пор, пока `i` будет строго меньше `10`.

Последняя часть конструкции цикла for, выражение `i++`, выполняется в конце каждой итерации цикла, увеличивая переменную `i` на 1. Как только `i` достигнет `10`, выполнение цикла прекратится.

## Условие задачи:

Создайте файл `for-loop.js`.

В этом файле объявите переменную `total` и присвойте ей значение `0`.

Объявите вторую переменную -- `limit` и присвойте ей значение `10`.

Создайте цикл for с переменной `i`, начальное значение которой 0. За каждый проход цикла переменная `i` должна увеличиваться на 1. Цикл должен работать до тех пор, пока значение `i` остаётся меньше значения переменной `limit`.

Прибавляйте `i` к переменной `total` в каждой итерации цикла. Чтобы сделать это, воспользуйтесь следующим выражением:

```js
total += i;
```

Воспользуйтесь методом `console.log()`, чтобы вывести значение `total` в терминал после завершения работы цикла.

Чтобы удостовериться в правильности решения задачи, запустите следующую команду из терминала:

```bash
javascripting verify for-loop.js
```
