for ループを使うと、コードの塊を何回も繰り返し実行できます。
次のfor ループはコンソールにログを10回書きます...

```js
for (let i = 0; i < 10; i++) {
  // log the numbers 0 through 9
  console.log(i)
}
```

for ループでは、最初の部分 `let i = 0` をループの最初に一回だけ実行します。
ループを実行した回数を数えるために、変数 `i` を使います。

第二の部分 `i < 10;` は、ループの繰り返し毎にチェックする条件式です。
チェックした式が真の時、ループ内のコードを実行します。
チェックした式が偽の時、ループを終了します。
式 `i < 10;` の場合、 `i` が `10` 未満の間、ループを繰り返します。

最後の部分 `i++` を、ループが終わるたびに実行します。
この式は、ループを一回まわるたびに、変数 `i` の値を `1` 増やします。
`i` が `10` に達すると、ループを終了します。

## やってみよう

`for-loop.js` ファイルを作りましょう。

ファイルの中で、数値 `0` の変数 `total` を定義します。

つづいて、数値 `10` の変数 `limit` を定義します。

forループを作りましょう。変数 `i` を0から始めループのたびに1増やします。
`i` が `limit` より小さい間、ループを続けましょう。

ループを繰り返すたびに、 数値 `i` を `total` に足しましょう。こんな風に...

```js
total += i;
```

ループが終わったら、 `console.log()` を使い、変数 `total` をターミナルに表示しましょう。

次のコマンドを実行し、あなたのプログラムが正しく動くか確認しましょう。

```bash
javascripting verify for-loop.js
```
