Существует множество способов манипуляции массивами.

Одной из распространённых задач является фильтрация массива, позволяющая получить массив с определёнными значениями.

Для этого мы будем использовать метод `.filter()`.

Например:

```js
const pets = ['cat', 'dog', 'elephant'];

const filtered = pets.filter(function (pet) {
  return (pet !== 'elephant');
});
```

Переменная `filtered` теперь будет содержать массив с элементами `cat` и `dog`.

## Условие задачи:

Создайте файл `array-filtering.js`.

В этом файле требуется объявить переменную `numbers`, которой должен быть присвоен следующий массив:

```js
[1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
```

Как было показано выше, объявите переменную `filtered` и присвойте ей результат выполнения `numbers.filter()`.

Функция, которая должна быть передана в виде аргумента методу `.filter()`, будет выглядеть следующим образом:

```js
function evenNumbers (number) {
  return number % 2 === 0;
}
```

Воспользуйтесь командой `console.log()`, чтобы вывести массив `filtered` в консоль.

Чтобы удостовериться в правильности решения задачи, запустите следующую команду из терминала:

```bash
javascripting verify array-filtering.js
```
