/*!
 * 
 *          iclient9-mapboxgl.(http://iclient.supermap.io)
 *          Copyright© 2000 - 2019 SuperMap Software Co.Ltd
 *          license: Apache-2.0
 *          version: v9.1.2
 *         
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 450);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
var SuperMap = exports.SuperMap = window.SuperMap = window.SuperMap || {};
SuperMap.Widgets = window.SuperMap.Widgets || {};

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Util = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                               * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                               * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

__webpack_require__(52);

var Util = exports.Util = _SuperMap.SuperMap.Util = _SuperMap.SuperMap.Util || {};
/**
 * @name Util
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description common 工具类。
 */

/**
 * @description 复制源对象的所有属性到目标对象上，源对象上的没有定义的属性在目标对象上也不会被设置。
 * @example
 * 要复制 SuperMap.Size 对象的所有属性到自定义对象上，使用方法如下:
 *     var size = new SuperMap.Size(100, 100);
 *     var obj = {}；
 *     SuperMap.Util.extend(obj, size);
 * @param {Object} [destination] - 目标对象。
 * @param {Object} source - 源对象，其属性将被设置到目标对象上。
 * @returns {Object} 目标对象。
 */

_SuperMap.SuperMap.Util.extend = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }

        /**
         * IE doesn't include the toString property when iterating over an object's
         * properties with the for(property in object) syntax.  Explicitly check if
         * the source has its own toString property.
         */

        /*
         * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
         * prototype object" when calling hawOwnProperty if the source object
         * is an instance of window.Event.
         */

        var sourceIsEvt = typeof window.Event === "function" && source instanceof window.Event;

        if (!sourceIsEvt && source.hasOwnProperty && source.hasOwnProperty("toString")) {
            destination.toString = source.toString;
        }
    }
    return destination;
};
/**
 * @description 对象拷贝。
 * @param {Object} [des] - 目标对象。
 * @param {Object} soc - 源对象。
 */
_SuperMap.SuperMap.Util.copy = function (des, soc) {
    des = des || {};
    var v;
    if (soc) {
        for (var p in des) {
            v = soc[p];
            if (typeof v !== 'undefined') {
                des[p] = v;
            }
        }
    }
};
/**
 * @description 销毁对象，将其属性置空。
 * @param {Object} [obj] - 目标对象。
 */
_SuperMap.SuperMap.Util.reset = function (obj) {
    obj = obj || {};
    for (var p in obj) {
        if (obj.hasOwnProperty(p)) {
            if (_typeof(obj[p]) === "object" && obj[p] instanceof Array) {
                for (var i in obj[p]) {
                    if (obj[p][i].destroy) {
                        obj[p][i].destroy();
                    }
                }
                obj[p].length = 0;
            } else if (_typeof(obj[p]) === "object" && obj[p] instanceof Object) {
                if (obj[p].destroy) {
                    obj[p].destroy();
                }
            }
            obj[p] = null;
        }
    }
};

/**
 * @description 获取 HTML 元素数组。
 * @returns {Array.<HTMLElement>} HTML 元素数组。
 */
_SuperMap.SuperMap.Util.getElement = function () {
    var elements = [];

    for (var i = 0, len = arguments.length; i < len; i++) {
        var element = arguments[i];
        if (typeof element === 'string') {
            element = document.getElementById(element);
        }
        if (arguments.length === 1) {
            return element;
        }
        elements.push(element);
    }
    return elements;
};

/**
 * @description instance of 的跨浏览器实现。
 * @param {Object} o - 对象。
 * @returns {boolean} 是否是页面元素。
 */
_SuperMap.SuperMap.Util.isElement = function (o) {
    return !!(o && o.nodeType === 1);
};

/**
 * @description 判断一个对象是否是数组。
 * @param {Object} a - 对象。
 * @returns {boolean} 是否是数组。
 */
_SuperMap.SuperMap.Util.isArray = function (a) {
    return Object.prototype.toString.call(a) === '[object Array]';
};

/**
 * @description 从数组中删除某一项。
 * @param {Array} array - 数组。
 * @param {Object} item - 数组中要删除的一项。
 * @returns {Array} 执行删除操作后的数组。
 */
_SuperMap.SuperMap.Util.removeItem = function (array, item) {
    for (var i = array.length - 1; i >= 0; i--) {
        if (array[i] === item) {
            array.splice(i, 1);
            //break;more than once??
        }
    }
    return array;
};

/**
 * @description 获取某对象再数组中的索引值。
 * @param {Array} array - 数组。
 * @param {Object} obj - 对象。
 * @returns {number} 某对象再数组中的索引值。
 */
_SuperMap.SuperMap.Util.indexOf = function (array, obj) {
    if (array == null) {
        return -1;
    } else {
        // use the build-in function if available.
        if (typeof array.indexOf === "function") {
            return array.indexOf(obj);
        } else {
            for (var i = 0, len = array.length; i < len; i++) {
                if (array[i] === obj) {
                    return i;
                }
            }
            return -1;
        }
    }
};

/**
 * @description 修改某 DOM 元素的许多属性。
 * @param {HTMLElement} element - 待修改的 DOM 元素。
 * @param {string} [id] - DOM 元素的 ID。
 * @param {SuperMap.Pixel} [px] - 包含 DOM 元素的 style 属性的 left 和 top 属性。
 * @param {SuperMap.Size} [sz] - 包含 DOM 元素的 width 和 height 属性。
 * @param {string} [position] - DOM 元素的 position 属性。
 * @param {string} [border] - DOM 元素的 style 属性的 border 属性。
 * @param {string} [overflow] - DOM 元素的 style 属性的 overflow 属性。
 * @param {number} [opacity] - 不透明度值。取值范围为(0.0 - 1.0)。
 */
_SuperMap.SuperMap.Util.modifyDOMElement = function (element, id, px, sz, position, border, overflow, opacity) {

    if (id) {
        element.id = id;
    }
    if (px) {
        element.style.left = px.x + "px";
        element.style.top = px.y + "px";
    }
    if (sz) {
        element.style.width = sz.w + "px";
        element.style.height = sz.h + "px";
    }
    if (position) {
        element.style.position = position;
    }
    if (border) {
        element.style.border = border;
    }
    if (overflow) {
        element.style.overflow = overflow;
    }
    if (parseFloat(opacity) >= 0.0 && parseFloat(opacity) < 1.0) {
        element.style.filter = 'alpha(opacity=' + opacity * 100 + ')';
        element.style.opacity = opacity;
    } else if (parseFloat(opacity) === 1.0) {
        element.style.filter = '';
        element.style.opacity = '';
    }
};

/**
 * @description Takes an object and copies any properties that don't exist from
 *     another properties, by analogy with SuperMap.Util.extend() from
 *     Prototype.js.
 *
 * @param {Object} [to] - 目标对象。
 * @param {Object} from - 源对象。Any properties of this object that
 *     are undefined in the to object will be set on the to object.
 *
 * @returns {Object} A reference to the to object.  Note that the to argument is modified
 *     in place and returned by this function.
 */
_SuperMap.SuperMap.Util.applyDefaults = function (to, from) {
    to = to || {};
    /*
     * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
     * prototype object" when calling hawOwnProperty if the source object is an
     * instance of window.Event.
     */
    var fromIsEvt = typeof window.Event === "function" && from instanceof window.Event;

    for (var key in from) {
        if (to[key] === undefined || !fromIsEvt && from.hasOwnProperty && from.hasOwnProperty(key) && !to.hasOwnProperty(key)) {
            to[key] = from[key];
        }
    }
    /**
     * IE doesn't include the toString property when iterating over an object's
     * properties with the for(property in object) syntax.  Explicitly check if
     * the source has its own toString property.
     */
    if (!fromIsEvt && from && from.hasOwnProperty && from.hasOwnProperty('toString') && !to.hasOwnProperty('toString')) {
        to.toString = from.toString;
    }

    return to;
};

/**
 * @description 将参数对象转换为 HTTP 的 GET 请求中的参数字符串。例如："key1=value1&key2=value2&key3=value3"。
 * @param {Object} params - 参数对象。
 * @returns {string} HTTP 的 GET 请求中的参数字符串。
 */
_SuperMap.SuperMap.Util.getParameterString = function (params) {
    var paramsArray = [];

    for (var key in params) {
        var value = params[key];
        if (value != null && typeof value !== 'function') {
            var encodedValue;
            if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                /* value is an array; encode items and separate with "," */
                var encodedItemArray = [];
                var item;
                for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                    item = value[itemIndex];
                    encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                }
                encodedValue = encodedItemArray.join(",");
            } else {
                /* value is a string; simply encode */
                encodedValue = encodeURIComponent(value);
            }
            paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
        }
    }

    return paramsArray.join("&");
};

/**
 * @description 给 URL 追加参数。
 * @param {string} url - 待追加参数的 URL 字符串。
 * @param {string} paramStr - 待追加的参数。
 * @returns {string} 新的 URL。
 */
_SuperMap.SuperMap.Util.urlAppend = function (url, paramStr) {
    var newUrl = url;
    if (paramStr) {
        var parts = (url + " ").split(/[?&]/);
        newUrl += parts.pop() === " " ? paramStr : parts.length ? "&" + paramStr : "?" + paramStr;
    }
    return newUrl;
};

/**
 * @description 为了避免浮点精度错误而保留的有效位数。
 * @type {number}
 * @default 14
 */
_SuperMap.SuperMap.Util.DEFAULT_PRECISION = 14;

/**
 * @description 将字符串以接近的精度转换为数字。
 * @param {string} number - 字符串。
 * @param {number} [precision=14] - 精度。
 * @returns {number} 数字。
 */
_SuperMap.SuperMap.Util.toFloat = function (number, precision) {
    if (precision == null) {
        precision = _SuperMap.SuperMap.Util.DEFAULT_PRECISION;
    }
    if (typeof number !== "number") {
        number = parseFloat(number);
    }
    return precision === 0 ? number : parseFloat(number.toPrecision(precision));
};

/**
 * @description 角度转弧度。
 * @param {number} x - 角度。
 * @returns {number} 弧度。
 */
_SuperMap.SuperMap.Util.rad = function (x) {
    return x * Math.PI / 180;
};

/**
 * @description 从 URL 字符串中解析出参数对象。
 * @param {string} url - URL。
 * @returns {Object} 解析出的参数对象。
 */
_SuperMap.SuperMap.Util.getParameters = function (url) {
    // if no url specified, take it from the location bar
    url = url === null || url === undefined ? window.location.href : url;

    //parse out parameters portion of url string
    var paramsString = "";
    if (_SuperMap.SuperMap.String.contains(url, '?')) {
        var start = url.indexOf('?') + 1;
        var end = _SuperMap.SuperMap.String.contains(url, "#") ? url.indexOf('#') : url.length;
        paramsString = url.substring(start, end);
    }

    var parameters = {};
    var pairs = paramsString.split(/[&;]/);
    for (var i = 0, len = pairs.length; i < len; ++i) {
        var keyValue = pairs[i].split('=');
        if (keyValue[0]) {

            var key = keyValue[0];
            try {
                key = decodeURIComponent(key);
            } catch (err) {
                key = unescape(key);
            }

            // being liberal by replacing "+" with " "
            var value = (keyValue[1] || '').replace(/\+/g, " ");

            try {
                value = decodeURIComponent(value);
            } catch (err) {
                value = unescape(value);
            }

            // follow OGC convention of comma delimited values
            value = value.split(",");

            //if there's only one value, do not return as array                    
            if (value.length == 1) {
                value = value[0];
            }

            parameters[key] = value;
        }
    }
    return parameters;
};

/**
 * @description 不断递增计数变量，用于生成唯一 ID。
 * @type {number}
 * @default 0
 */
_SuperMap.SuperMap.Util.lastSeqID = 0;

/**
 * @description 创建唯一 ID 值。
 * @param {string} [prefix] - 前缀。
 * @returns {string} 唯一的 ID 值。
 */
_SuperMap.SuperMap.Util.createUniqueID = function (prefix) {
    if (prefix == null) {
        prefix = "id_";
    }
    _SuperMap.SuperMap.Util.lastSeqID += 1;
    return prefix + _SuperMap.SuperMap.Util.lastSeqID;
};

/**
 * @memberOf SuperMap
 * @description 每单位的英尺数。
 * @type {Object}
 * @constant
 */
_SuperMap.SuperMap.INCHES_PER_UNIT = {
    'inches': 1.0,
    'ft': 12.0,
    'mi': 63360.0,
    'm': 39.3701,
    'km': 39370.1,
    'dd': 4374754,
    'yd': 36
};
_SuperMap.SuperMap.INCHES_PER_UNIT["in"] = _SuperMap.SuperMap.INCHES_PER_UNIT.inches;
_SuperMap.SuperMap.INCHES_PER_UNIT["degrees"] = _SuperMap.SuperMap.INCHES_PER_UNIT.dd;
_SuperMap.SuperMap.INCHES_PER_UNIT["nmi"] = 1852 * _SuperMap.SuperMap.INCHES_PER_UNIT.m;

// Units from CS-Map
_SuperMap.SuperMap.METERS_PER_INCH = 0.02540005080010160020;
_SuperMap.SuperMap.Util.extend(_SuperMap.SuperMap.INCHES_PER_UNIT, {
    "Inch": _SuperMap.SuperMap.INCHES_PER_UNIT.inches,
    "Meter": 1.0 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9001
    "Foot": 0.30480060960121920243 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9003
    "IFoot": 0.30480000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9002
    "ClarkeFoot": 0.3047972651151 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9005
    "SearsFoot": 0.30479947153867624624 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9041
    "GoldCoastFoot": 0.30479971018150881758 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9094
    "IInch": 0.02540000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "MicroInch": 0.00002540000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Mil": 0.00000002540000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Centimeter": 0.01000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Kilometer": 1000.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9036
    "Yard": 0.91440182880365760731 / _SuperMap.SuperMap.METERS_PER_INCH,
    "SearsYard": 0.914398414616029 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9040
    "IndianYard": 0.91439853074444079983 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9084
    "IndianYd37": 0.91439523 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9085
    "IndianYd62": 0.9143988 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9086
    "IndianYd75": 0.9143985 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9087
    "IndianFoot": 0.30479951 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9080
    "IndianFt37": 0.30479841 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9081
    "IndianFt62": 0.3047996 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9082
    "IndianFt75": 0.3047995 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9083
    "Mile": 1609.34721869443738887477 / _SuperMap.SuperMap.METERS_PER_INCH,
    "IYard": 0.91440000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9096
    "IMile": 1609.34400000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9093
    "NautM": 1852.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9030
    "Lat-66": 110943.316488932731 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Lat-83": 110946.25736872234125 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Decimeter": 0.10000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Millimeter": 0.00100000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Dekameter": 10.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Decameter": 10.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Hectometer": 100.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "GermanMeter": 1.0000135965 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9031
    "CaGrid": 0.999738 / _SuperMap.SuperMap.METERS_PER_INCH,
    "ClarkeChain": 20.1166194976 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9038
    "GunterChain": 20.11684023368047 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9033
    "BenoitChain": 20.116782494375872 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9062
    "SearsChain": 20.11676512155 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9042
    "ClarkeLink": 0.201166194976 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9039
    "GunterLink": 0.2011684023368047 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9034
    "BenoitLink": 0.20116782494375872 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9063
    "SearsLink": 0.2011676512155 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9043
    "Rod": 5.02921005842012 / _SuperMap.SuperMap.METERS_PER_INCH,
    "IntnlChain": 20.1168 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9097
    "IntnlLink": 0.201168 / _SuperMap.SuperMap.METERS_PER_INCH, //EPSG:9098
    "Perch": 5.02921005842012 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Pole": 5.02921005842012 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Furlong": 201.1684023368046 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Rood": 3.778266898 / _SuperMap.SuperMap.METERS_PER_INCH,
    "CapeFoot": 0.3047972615 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Brealey": 375.00000000000000000000 / _SuperMap.SuperMap.METERS_PER_INCH,
    "ModAmFt": 0.304812252984505969011938 / _SuperMap.SuperMap.METERS_PER_INCH,
    "Fathom": 1.8288 / _SuperMap.SuperMap.METERS_PER_INCH,
    "NautM-UK": 1853.184 / _SuperMap.SuperMap.METERS_PER_INCH,
    "50kilometers": 50000.0 / _SuperMap.SuperMap.METERS_PER_INCH,
    "150kilometers": 150000.0 / _SuperMap.SuperMap.METERS_PER_INCH
});

//unit abbreviations supported by PROJ.4
_SuperMap.SuperMap.Util.extend(_SuperMap.SuperMap.INCHES_PER_UNIT, {
    "mm": _SuperMap.SuperMap.INCHES_PER_UNIT["Meter"] / 1000.0,
    "cm": _SuperMap.SuperMap.INCHES_PER_UNIT["Meter"] / 100.0,
    "dm": _SuperMap.SuperMap.INCHES_PER_UNIT["Meter"] * 100.0,
    "km": _SuperMap.SuperMap.INCHES_PER_UNIT["Meter"] * 1000.0,
    "kmi": _SuperMap.SuperMap.INCHES_PER_UNIT["nmi"], //International Nautical Mile
    "fath": _SuperMap.SuperMap.INCHES_PER_UNIT["Fathom"], //International Fathom
    "ch": _SuperMap.SuperMap.INCHES_PER_UNIT["IntnlChain"], //International Chain
    "link": _SuperMap.SuperMap.INCHES_PER_UNIT["IntnlLink"], //International Link
    "us-in": _SuperMap.SuperMap.INCHES_PER_UNIT["inches"], //U.S. Surveyor's Inch
    "us-ft": _SuperMap.SuperMap.INCHES_PER_UNIT["Foot"], //U.S. Surveyor's Foot
    "us-yd": _SuperMap.SuperMap.INCHES_PER_UNIT["Yard"], //U.S. Surveyor's Yard
    "us-ch": _SuperMap.SuperMap.INCHES_PER_UNIT["GunterChain"], //U.S. Surveyor's Chain
    "us-mi": _SuperMap.SuperMap.INCHES_PER_UNIT["Mile"], //U.S. Surveyor's Statute Mile
    "ind-yd": _SuperMap.SuperMap.INCHES_PER_UNIT["IndianYd37"], //Indian Yard
    "ind-ft": _SuperMap.SuperMap.INCHES_PER_UNIT["IndianFt37"], //Indian Foot
    "ind-ch": 20.11669506 / _SuperMap.SuperMap.METERS_PER_INCH //Indian Chain
});

/**
 * @memberOf SuperMap
 * @member [SuperMap.DOTS_PER_INCH=96]
 * @description 分辨率与比例尺之间转换的常量。
 * @type {Object}
 */
_SuperMap.SuperMap.DOTS_PER_INCH = 96;

/**
 * @param {number} scale - 比例尺。
 * @returns {number} 返回正常的 scale 值。
 */
_SuperMap.SuperMap.Util.normalizeScale = function (scale) {
    var normScale = scale > 1.0 ? 1.0 / scale : scale;
    return normScale;
};

/**
 * @description 比例尺转分辨率。
 * @param {number} scale - 比例尺。
 * @param {string} [units='degrees'] - 比例尺单位。
 * @returns {number} 分辨率。
 */
_SuperMap.SuperMap.Util.getResolutionFromScale = function (scale, units) {
    var resolution;
    if (scale) {
        if (units == null) {
            units = "degrees";
        }
        var normScale = _SuperMap.SuperMap.Util.normalizeScale(scale);
        resolution = 1 / (normScale * _SuperMap.SuperMap.INCHES_PER_UNIT[units] * _SuperMap.SuperMap.DOTS_PER_INCH);
    }
    return resolution;
};

/**
 * @description 分辨率转比例尺。
 * @param {number} resolution - 分辨率。
 * @param {string} [units='degrees'] - 分辨率单位。
 * @returns {number} 比例尺。
 */
_SuperMap.SuperMap.Util.getScaleFromResolution = function (resolution, units) {

    if (units == null) {
        units = "degrees";
    }

    var scale = resolution * _SuperMap.SuperMap.INCHES_PER_UNIT[units] * _SuperMap.SuperMap.DOTS_PER_INCH;
    return scale;
};

/**
 * @memberOf SuperMap
 * @description 如果 userAgent 捕获到浏览器使用的是 Gecko 引擎则返回 true。
 * @constant
 */
_SuperMap.SuperMap.IS_GECKO = function () {
    var ua = navigator.userAgent.toLowerCase();
    return ua.indexOf("webkit") === -1 && ua.indexOf("gecko") !== -1;
}();

/**
 * @memberOf SuperMap
 * @description 浏览器名称，依赖于 userAgent 属性，BROWSER_NAME 可以是空，或者以下浏览器：
 *     * "opera" -- Opera
 *     * "msie"  -- Internet Explorer
 *     * "safari" -- Safari
 *     * "firefox" -- Firefox
 *     * "mozilla" -- Mozilla
 * @constant
 */
_SuperMap.SuperMap.Browser = function () {
    var name = '',
        version = '',
        device = 'pc',
        uaMatch;
    //以下进行测试
    var ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf("msie") > -1 || ua.indexOf("trident") > -1 && ua.indexOf("rv") > -1) {
        name = 'msie';
        uaMatch = ua.match(/msie ([\d.]+)/) || ua.match(/rv:([\d.]+)/);
    } else if (ua.indexOf("chrome") > -1) {
        name = 'chrome';
        uaMatch = ua.match(/chrome\/([\d.]+)/);
    } else if (ua.indexOf("firefox") > -1) {
        name = 'firefox';
        uaMatch = ua.match(/firefox\/([\d.]+)/);
    } else if (ua.indexOf("opera") > -1) {
        name = 'opera';
        uaMatch = ua.match(/version\/([\d.]+)/);
    } else if (ua.indexOf("safari") > -1) {
        name = 'safari';
        uaMatch = ua.match(/version\/([\d.]+)/);
    }
    version = uaMatch ? uaMatch[1] : '';

    if (ua.indexOf("ipad") > -1 || ua.indexOf("ipod") > -1 || ua.indexOf("iphone") > -1) {
        device = 'apple';
    } else if (ua.indexOf("android") > -1) {
        uaMatch = ua.match(/version\/([\d.]+)/);
        version = uaMatch ? uaMatch[1] : '';
        device = 'android';
    }
    return { name: name, version: version, device: device };
}();

/**
 * @description 获取浏览器相关信息。支持的浏览器包括：Opera，Internet Explorer，Safari，Firefox。
 * @returns {Object} 获取浏览器名称、版本、设备名称。对应的属性分别为 name, version, device。
 */
_SuperMap.SuperMap.Util.getBrowser = function () {
    return _SuperMap.SuperMap.Browser;
};

/**
 * @description 浏览器是否支持 Canvas。
 * @returns {boolean} 获取当前浏览器是否支持 HTML5 Canvas。
 */
_SuperMap.SuperMap.Util.isSupportCanvas = function () {
    var checkRes = true,
        broz = _SuperMap.SuperMap.Util.getBrowser();
    if (document.createElement("canvas").getContext) {
        if (broz.name === 'firefox' && parseFloat(broz.version) < 5) {
            checkRes = false;
        }
        if (broz.name === 'safari' && parseFloat(broz.version) < 4) {
            checkRes = false;
        }
        if (broz.name === 'opera' && parseFloat(broz.version) < 10) {
            checkRes = false;
        }
        if (broz.name === 'msie' && parseFloat(broz.version) < 9) {
            checkRes = false;
        }
    } else {
        checkRes = false;
    }
    return checkRes;
}();

/**
 * @description 判断；浏览器是否支持 Canvas。
 * @returns {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */
_SuperMap.SuperMap.Util.supportCanvas = function () {
    return _SuperMap.SuperMap.Util.isSupportCanvas;
};

//将服务端的地图单位转成SuperMap的地图单位
_SuperMap.SuperMap.INCHES_PER_UNIT["degree"] = _SuperMap.SuperMap.INCHES_PER_UNIT.dd;
_SuperMap.SuperMap.INCHES_PER_UNIT["meter"] = _SuperMap.SuperMap.INCHES_PER_UNIT.m;
_SuperMap.SuperMap.INCHES_PER_UNIT["foot"] = _SuperMap.SuperMap.INCHES_PER_UNIT.ft;
_SuperMap.SuperMap.INCHES_PER_UNIT["inch"] = _SuperMap.SuperMap.INCHES_PER_UNIT.inches;
_SuperMap.SuperMap.INCHES_PER_UNIT["mile"] = _SuperMap.SuperMap.INCHES_PER_UNIT.mi;
_SuperMap.SuperMap.INCHES_PER_UNIT["kilometer"] = _SuperMap.SuperMap.INCHES_PER_UNIT.km;
_SuperMap.SuperMap.INCHES_PER_UNIT["yard"] = _SuperMap.SuperMap.INCHES_PER_UNIT.yd;

/**
 * @description 判断一个 URL 请求是否在当前域中。
 * @param {string} url - URL 请求字符串。
 * @returns {boolean} URL 请求是否在当前域中。
 */
_SuperMap.SuperMap.Util.isInTheSameDomain = function (url) {
    if (!url) {
        return true;
    }
    var index = url.indexOf("//");
    var documentUrl = document.location.toString();
    var documentIndex = documentUrl.indexOf("//");
    if (index === -1) {
        return true;
    } else {
        var protocol;
        var substring = protocol = url.substring(0, index);
        var documentSubString = documentUrl.substring(documentIndex + 2);
        documentIndex = documentSubString.indexOf("/");
        var documentPortIndex = documentSubString.indexOf(":");
        var documentDomainWithPort = documentSubString.substring(0, documentIndex);
        //var documentPort;

        var documentprotocol = document.location.protocol;
        if (documentPortIndex !== -1) {
            // documentPort = +documentSubString.substring(documentPortIndex, documentIndex);
        } else {
            documentDomainWithPort += ':' + (documentprotocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        if (documentprotocol.toLowerCase() !== substring.toLowerCase()) {
            return false;
        }
        substring = url.substring(index + 2);
        var portIndex = substring.indexOf(":");
        index = substring.indexOf("/");
        var domainWithPort = substring.substring(0, index);
        var domain;
        if (portIndex !== -1) {
            domain = substring.substring(0, portIndex);
        } else {
            domain = substring.substring(0, index);
            domainWithPort += ':' + (protocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        var documentDomain = document.domain;
        if (domain === documentDomain && domainWithPort === documentDomainWithPort) {
            return true;
        }
    }
    return false;
};

/**
 * @description 计算 iServer 服务的 REST 图层的显示分辨率，需要从 iServer 的 REST 图层表述中获取 viewBounds、viewer、scale、coordUnit、datumAxis 五个参数，来进行计算。
 * @param {SuperMap.Bounds} viewBounds - 地图的参照可视范围，即地图初始化时默认的地图显示范围。
 * @param {SuperMap.Size} viewer - 地图初始化时默认的地图图片的尺寸。
 * @param {number} scale - 地图初始化时默认的显示比例尺。
 * @param {string} [coordUnit='degrees'] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则系统默认为 WGS84 参考系的椭球体长半轴 6378137。
 * @returns {number} 返回图层显示分辨率。
 */
_SuperMap.SuperMap.Util.calculateDpi = function (viewBounds, viewer, scale, coordUnit, datumAxis) {
    //10000 是 0.1毫米与米的转换。DPI的计算公式：Viewer / DPI *  0.0254 * 10000 = ViewBounds * scale ，公式中的10000是为了提高计算结果的精度，以下出现的ratio皆为如此。
    if (!viewBounds || !viewer || !scale) {
        return;
    }
    var ratio = 10000,
        rvbWidth = viewBounds.getWidth(),
        rvbHeight = viewBounds.getHeight(),
        rvWidth = viewer.w,
        rvHeight = viewer.h;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "degrees";
    var dpi;
    if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
        var num1 = rvbWidth / rvWidth,
            num2 = rvbHeight / rvHeight,
            resolution = num1 > num2 ? num1 : num2;
        dpi = 0.0254 * ratio / resolution / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
    } else {
        var _resolution = rvbWidth / rvWidth;
        dpi = 0.0254 * ratio / _resolution / scale / ratio;
    }
    return dpi;
};

/**
 * @description 将对象转换成 JSON 字符串。
 * @param {Object} obj - 要转换成 JSON 的 Object 对象。
 * @returns {string} 返回转换后的 JSON 对象。
 */
_SuperMap.SuperMap.Util.toJSON = function (obj) {
    var objInn = obj;
    if (objInn == null) {
        return null;
    }
    switch (objInn.constructor) {
        case String:
            //s = "'" + str.replace(/(["\\])/g, "\\$1") + "'";   string含有单引号出错
            objInn = '"' + objInn.replace(/(["\\])/g, '\\$1') + '"';
            objInn = objInn.replace(/\n/g, "\\n");
            objInn = objInn.replace(/\r/g, "\\r");
            objInn = objInn.replace("<", "&lt;");
            objInn = objInn.replace(">", "&gt;");
            objInn = objInn.replace(/%/g, "%25");
            objInn = objInn.replace(/&/g, "%26");
            return objInn;
        case Array:
            var arr = [];
            for (var i = 0, len = objInn.length; i < len; i++) {
                arr.push(_SuperMap.SuperMap.Util.toJSON(objInn[i]));
            }
            return "[" + arr.join(",") + "]";
        case Number:
            return isFinite(objInn) ? String(objInn) : null;
        case Boolean:
            return String(objInn);
        case Date:
            var dateStr = "{" + "'__type':\"System.DateTime\"," + "'Year':" + objInn.getFullYear() + "," + "'Month':" + (objInn.getMonth() + 1) + "," + "'Day':" + objInn.getDate() + "," + "'Hour':" + objInn.getHours() + "," + "'Minute':" + objInn.getMinutes() + "," + "'Second':" + objInn.getSeconds() + "," + "'Millisecond':" + objInn.getMilliseconds() + "," + "'TimezoneOffset':" + objInn.getTimezoneOffset() + "}";
            return dateStr;
        default:
            if (objInn["toJSON"] != null && typeof objInn["toJSON"] === "function") {
                return objInn.toJSON();
            }
            if ((typeof objInn === 'undefined' ? 'undefined' : _typeof(objInn)) === "object") {
                if (objInn.length) {
                    var _arr2 = [];
                    for (var _i = 0, _len = objInn.length; _i < _len; _i++) {
                        _arr2.push(_SuperMap.SuperMap.Util.toJSON(objInn[_i]));
                    }
                    return "[" + _arr2.join(",") + "]";
                }
                var _arr = [];
                for (var attr in objInn) {
                    //为解决SuperMap.Geometry类型头json时堆栈溢出的问题，attr == "parent"时不进行json转换
                    if (typeof objInn[attr] !== "function" && attr !== "CLASS_NAME" && attr !== "parent") {
                        _arr.push("'" + attr + "':" + _SuperMap.SuperMap.Util.toJSON(objInn[attr]));
                    }
                }

                if (_arr.length > 0) {
                    return "{" + _arr.join(",") + "}";
                } else {
                    return "{}";
                }
            }
            return objInn.toString();
    }
};

/**
 * @description 根据比例尺和 dpi 计算屏幕分辨率。
 * @param {number} scale - 比例尺。
 * @param {number} dpi - 图像分辨率，表示每英寸内的像素个数。
 * @param {string} [coordUnit] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则 DPI 默认按照 WGS84 参考系的椭球体长半轴 6378137 来计算。
 * @returns {number} 返回当前比例尺下的屏幕分辨率。
 */
_SuperMap.SuperMap.Util.getResolutionFromScaleDpi = function (scale, dpi, coordUnit, datumAxis) {
    var resolution = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (scale > 0 && dpi > 0) {
        scale = _SuperMap.SuperMap.Util.normalizeScale(scale);
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            //scale = SuperMap.Util.normalizeScale(scale);
            resolution = 0.0254 * ratio / dpi / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
            return resolution;
        } else {
            resolution = 0.0254 * ratio / dpi / scale / ratio;
            return resolution;
        }
    }
    return -1;
};

/**
 * @description 根据 resolution、dpi、coordUnit 和 datumAxis 计算比例尺。
 * @param {number} resolution - 用于计算比例尺的地图分辨率。
 * @param {number} dpi - 图像分辨率，表示每英寸内的像素个数。
 * @param {string} [coordUnit] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则 DPI 默认按照 WGS84 参考系的椭球体长半轴 6378137 来计算。
 * @returns {number} 返回当前屏幕分辨率下的比例尺。
 */
_SuperMap.SuperMap.Util.getScaleFromResolutionDpi = function (resolution, dpi, coordUnit, datumAxis) {
    var scale = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (resolution > 0 && dpi > 0) {
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            scale = 0.0254 * ratio / dpi / resolution / (Math.PI * 2 * datumAxis / 360) / ratio;
            return scale;
        } else {
            scale = 0.0254 * ratio / dpi / resolution / ratio;
            return scale;
        }
    }
    return -1;
};

/**
 * @description 转换查询结果。
 * @param {Object} result - 查询结果。
 * @returns {Object} 转换后的查询结果。
 */
_SuperMap.SuperMap.Util.transformResult = function (result) {
    if (result.responseText && typeof result.responseText === "string") {
        result = JSON.parse(result.responseText);
    }
    return result;
};

/**
 * @description 属性拷贝，不拷贝方法类名(CLASS_NAME)等。
 * @param {Object} [destination] - 拷贝目标。
 * @param {Object} source - 源对象。
 *
 */
_SuperMap.SuperMap.Util.copyAttributes = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 将源对象上的属性拷贝到目标对象上。（不拷贝 CLASS_NAME 和方法）
 * @param {Object} [destination] - 目标对象。
 * @param {Object} source - 源对象。
 * @param {Array.<string>} clip - 源对象中禁止拷贝到目标对象的属性，目的是防止目标对象上不可修改的属性被篡改。
 *
 */
_SuperMap.SuperMap.Util.copyAttributesWithClip = function (destination, source, clip) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            //去掉禁止拷贝的属性
            var isInClip = false;
            if (clip && clip.length) {
                for (var i = 0, len = clip.length; i < len; i++) {
                    if (property === clip[i]) {
                        isInClip = true;
                        break;
                    }
                }
            }
            if (isInClip === true) {
                continue;
            }

            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 克隆一个 Object 对象
 * @param {Object} obj - 需要克隆的对象。
 * @returns {Object} 返回对象的拷贝对象，注意是新的对象，不是指向。
 */
_SuperMap.SuperMap.Util.cloneObject = function (obj) {
    // Handle the 3 simple types, and null or undefined
    if (null === obj || "object" !== (typeof obj === 'undefined' ? 'undefined' : _typeof(obj))) {
        return obj;
    }

    // Handle Date
    if (obj instanceof Date) {
        var copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
    }

    // Handle Array
    if (obj instanceof Array) {
        var _copy = obj.slice(0);
        return _copy;
    }

    // Handle Object
    if (obj instanceof Object) {
        var _copy2 = {};
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) {
                _copy2[attr] = _SuperMap.SuperMap.Util.cloneObject(obj[attr]);
            }
        }
        return _copy2;
    }

    throw new Error("Unable to copy obj! Its type isn't supported.");
};

/**
 * @description 判断两条线段是不是有交点。
 * @param {SuperMap.Geometry.Point} a1 - 第一条线段的起始节点。
 * @param {SuperMap.Geometry.Point} a2 - 第一条线段的结束节点。
 * @param {SuperMap.Geometry.Point} b1 - 第二条线段的起始节点。
 * @param {SuperMap.Geometry.Point} b2 - 第二条线段的结束节点。
 * @returns {Object} 如果相交返回交点，如果不相交返回两条线段的位置关系。
 */
_SuperMap.SuperMap.Util.lineIntersection = function (a1, a2, b1, b2) {
    var intersectValue = null;
    var k1;
    var k2;
    var b = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
    var a = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
    var ab = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
    //ab==0代表两条线断的斜率一样
    if (ab != 0) {
        k1 = b / ab;
        k2 = a / ab;

        if (k1 >= 0 && k2 <= 1 && k1 <= 1 && k2 >= 0) {
            intersectValue = new _SuperMap.SuperMap.Geometry.Point(a1.x + k1 * (a2.x - a1.x), a1.y + k1 * (a2.y - a1.y));
        } else {
            intersectValue = "No Intersection";
        }
    } else {

        if (b == 0 && a == 0) {
            var maxy = Math.max(a1.y, a2.y);
            var miny = Math.min(a1.y, a2.y);
            var maxx = Math.max(a1.x, a2.x);
            var minx = Math.min(a1.x, a2.x);
            if ((b1.y >= miny && b1.y <= maxy || b2.y >= miny && b2.y <= maxy) && b1.x >= minx && b1.x <= maxx || b2.x >= minx && b2.x <= maxx) {
                intersectValue = "Coincident"; //重合
            } else {
                intersectValue = "Parallel"; //平行
            }
        } else {
            intersectValue = "Parallel"; //平行
        }
    }
    return intersectValue;
};

/**
 * @description 获取文本外接矩形宽度与高度。
 * @param {SuperMap.ThemeStyle} style - 文本样式。
 * @param {string} text - 文本内容。
 * @param {Object} element - DOM 元素。
 * @returns {Object} 返回裁剪后的宽度，高度信息。
 */
_SuperMap.SuperMap.Util.getTextBounds = function (style, text, element) {
    document.body.appendChild(element);
    element.style.width = 'auto';
    element.style.height = 'auto';
    if (style.fontSize) {
        element.style.fontSize = style.fontSize;
    }
    if (style.fontFamily) {
        element.style.fontFamily = style.fontFamily;
    }
    if (style.fontWeight) {
        element.style.fontWeight = style.fontWeight;
    }
    element.style.position = 'relative';
    element.style.visibility = 'hidden';
    //fix 在某些情况下，element内的文本变成竖起排列，导致宽度计算不正确的bug
    element.style.display = 'inline-block';
    element.innerHTML = text;
    var textWidth = element.clientWidth;
    var textHeight = element.clientHeight;
    document.body.removeChild(element);
    return {
        textWidth: textWidth,
        textHeight: textHeight
    };
};

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.GetFeatureMode = exports.AggregationQueryBuilderType = exports.AggregationType = exports.TopologyValidatorRule = exports.SummaryType = exports.StatisticAnalystMode = exports.AnalystSizeUnit = exports.AnalystAreaUnit = exports.ClipAnalystMode = exports.ChartType = exports.ClientType = exports.Exponent = exports.VariogramMode = exports.InterpolationAlgorithmType = exports.SearchMode = exports.PixelFormat = exports.StatisticMode = exports.UGCLayerType = exports.LayerType = exports.ColorSpaceType = exports.GridType = exports.TransferPreference = exports.TransferTactic = exports.EditType = exports.DataReturnMode = exports.SurfaceAnalystMethod = exports.SmoothMethod = exports.OutputType = exports.OverlayOperationType = exports.BufferEndType = exports.TurnType = exports.SupplyCenterType = exports.SideType = exports.DirectionType = exports.LabelOverLengthMode = exports.LabelBackShape = exports.AlongLineDirection = exports.FillGradientMode = exports.TextAlignment = exports.ColorGradientType = exports.ThemeType = exports.RangeMode = exports.GraduatedMode = exports.GraphAxesTextDisplayMode = exports.ThemeGraphType = exports.ThemeGraphTextFormat = exports.EngineType = exports.BufferRadiusUnit = exports.Unit = exports.MeasureMode = exports.SpatialRelationType = exports.SpatialQueryMode = exports.JoinType = exports.QueryOption = exports.GeometryType = exports.ServerType = exports.DataFormat = undefined;

var _SuperMap = __webpack_require__(0);

/**
 * @enum DataFormat
 * @memberOf SuperMap
 * @description 服务请求返回结果数据类型
 * @type {string}
 */
var DataFormat = _SuperMap.SuperMap.DataFormat = {
    /** GEOJSON */
    GEOJSON: "GEOJSON",
    /** ISERVER */
    ISERVER: "ISERVER"
}; /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
    * This program are made available under the terms of the Apache License, Version 2.0
    * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
exports.DataFormat = DataFormat;

/**
 * @enum ServerType
 * @memberOf SuperMap
 * @description 服务器类型
 * @type {string}
 */

var ServerType = _SuperMap.SuperMap.ServerType = {
    /** ISERVER */
    ISERVER: "ISERVER",
    /** IPORTAL */
    IPORTAL: "IPORTAL",
    /** ONLINE */
    ONLINE: "ONLINE"
};
exports.ServerType = ServerType;

/**
 * @enum GeometryType
 * @memberOf SuperMap
 * @description 几何对象枚举,定义了一系列几何对象类型。
 * @type {string}
 */

var GeometryType = _SuperMap.SuperMap.GeometryType = {
    /** LINE */
    LINE: "LINE",
    /** LINEM */
    LINEM: "LINEM",
    /** POINT */
    POINT: "POINT",
    /** REGION */
    REGION: "REGION",
    /** POINTEPS */
    POINTEPS: "POINTEPS",
    /** LINEEPS */
    LINEEPS: "LINEEPS",
    /** REGIONEPS */
    REGIONEPS: "REGIONEPS",
    /** ELLIPSE */
    ELLIPSE: "ELLIPSE",
    /** CIRCLE */
    CIRCLE: "CIRCLE",
    /** TEXT */
    TEXT: "TEXT",
    /** RECTANGLE */
    RECTANGLE: "RECTANGLE",
    /** UNKNOWN */
    UNKNOWN: "UNKNOWN"
};
exports.GeometryType = GeometryType;

/**
 * @enum QueryOption
 * @memberOf SuperMap
 * @description 查询结果类型枚举,描述查询结果返回类型，包括只返回属性、只返回几何实体以及返回属性和几何实体。
 * @type {string}
 */

var QueryOption = _SuperMap.SuperMap.QueryOption = {
    /** 属性 */
    ATTRIBUTE: "ATTRIBUTE",
    /** 属性和几何对象 */
    ATTRIBUTEANDGEOMETRY: "ATTRIBUTEANDGEOMETRY",
    /** 几何对象 */
    GEOMETRY: "GEOMETRY"
};
exports.QueryOption = QueryOption;

/**
 * @enum JoinType
 * @memberOf SuperMap
 * @description 关联查询时的关联类型常量。
 * 该类定义了两个表之间的连接类型常量，决定了对两个表之间进行连接查询时，查询结果中得到的记录的情况。
 * @type {string}
 */

var JoinType = _SuperMap.SuperMap.JoinType = {
    /** INNERJOIN */
    INNERJOIN: "INNERJOIN",
    /** LEFTJOIN */
    LEFTJOIN: "LEFTJOIN"
};
exports.JoinType = JoinType;

/**
 * @enum SpatialQueryMode
 * @memberOf SuperMap
 * @description  空间查询模式枚举。该类定义了空间查询操作模式常量。
 * @type {string}
 */

var SpatialQueryMode = _SuperMap.SuperMap.SpatialQueryMode = {
    /** 包含空间查询模式 */
    CONTAIN: "CONTAIN",
    /** 交叉空间查询模式 */
    CROSS: "CROSS",
    /** 分离空间查询模式 */
    DISJOINT: "DISJOINT",
    /** 重合空间查询模式 */
    IDENTITY: "IDENTITY",
    /** 相交空间查询模式 */
    INTERSECT: "INTERSECT",
    /** 无空间查询 */
    NONE: "NONE",
    /** 叠加空间查询模式 */
    OVERLAP: "OVERLAP",
    /** 邻接空间查询模式 */
    TOUCH: "TOUCH",
    /** 被包含空间查询模式 */
    WITHIN: "WITHIN"
};
exports.SpatialQueryMode = SpatialQueryMode;
/**
 * @enum SpatialRelationType
 * @memberOf SuperMap
 * @description  数据集对象间的空间关系枚举。
 * 该类定义了数据集对象间的空间关系类型常量。
 * @type {string}
 */

var SpatialRelationType = _SuperMap.SuperMap.SpatialRelationType = {
    /** 包含关系 */
    CONTAIN: "CONTAIN",
    /** 相交关系 */
    INTERSECT: "INTERSECT",
    /** 被包含关系 */
    WITHIN: "WITHIN"
};
exports.SpatialRelationType = SpatialRelationType;

/**
 * @enum MeasureMode
 * @memberOf SuperMap
 * @type {string}
 * @description  量算模式枚举。
 * 该类定义了两种测量模式：距离测量和面积测量。
 */

var MeasureMode = _SuperMap.SuperMap.MeasureMode = {
    /** 距离测量 */
    DISTANCE: "DISTANCE",
    /** 面积测量 */
    AREA: "AREA"
};
exports.MeasureMode = MeasureMode;

/**
 * @enum Unit
 * @memberOf SuperMap
 * @description  距离单位枚举。
 * 该类定义了一系列距离单位类型。
 * @type {string}
 */

var Unit = _SuperMap.SuperMap.Unit = {
    /**  米 */
    METER: "METER",
    /**  千米 */
    KILOMETER: "KILOMETER",
    /**  英里 */
    MILE: "MILE",
    /**  码 */
    YARD: "YARD",
    /**  度 */
    DEGREE: "DEGREE",
    /**  毫米 */
    MILLIMETER: "MILLIMETER",
    /**  厘米 */
    CENTIMETER: "CENTIMETER",
    /**  英寸 */
    INCH: "INCH",
    /**  分米 */
    DECIMETER: "DECIMETER",
    /**  英尺 */
    FOOT: "FOOT",
    /**  秒 */
    SECOND: "SECOND",
    /**  分 */
    MINUTE: "MINUTE",
    /**  弧度 */
    RADIAN: "RADIAN"
};
exports.Unit = Unit;

/**
 * @enum BufferRadiusUnit
 * @memberOf SuperMap
 * @description  缓冲区距离单位枚举。
 * 该类定义了一系列缓冲距离单位类型。
 * @type {string}
 */

var BufferRadiusUnit = _SuperMap.SuperMap.BufferRadiusUnit = {
    /**  厘米 */
    CENTIMETER: "CENTIMETER",
    /**  分米 */
    DECIMETER: "DECIMETER",
    /**  英尺 */
    FOOT: "FOOT",
    /**  英寸 */
    INCH: "INCH",
    /**  千米 */
    KILOMETER: "KILOMETER",
    /**  米 */
    METER: "METER",
    /**  英里 */
    MILE: "MILE",
    /**  毫米 */
    MILLIMETER: "MILLIMETER",
    /**  码 */
    YARD: "YARD"
};
exports.BufferRadiusUnit = BufferRadiusUnit;

/**
 * @enum EngineType
 * @memberOf SuperMap
 * @description  数据源引擎类型枚举。
 * @type {string}
 */

var EngineType = _SuperMap.SuperMap.EngineType = {
    /** 影像只读引擎类型，文件引擎，针对通用影像格式如 BMP，JPG，TIFF 以及超图自定义影像格式 SIT 等。 */
    IMAGEPLUGINS: "IMAGEPLUGINS",
    /**  OGC 引擎类型，针对于 Web 数据源，Web 引擎，目前支持的类型有 WMS，WFS，WCS。 */
    OGC: "OGC",
    /**  Oracle 引擎类型，针对 Oracle 数据源，数据库引擎。 */
    ORACLEPLUS: "ORACLEPLUS",
    /**  SDB 引擎类型，文件引擎，即 SDB 数据源。 */
    SDBPLUS: "SDBPLUS",
    /**  SQL Server 引擎类型，针对 SQL Server 数据源，数据库引擎 */
    SQLPLUS: "SQLPLUS",
    /**  UDB 引擎类型，文件引擎。 */
    UDB: "UDB"
};
exports.EngineType = EngineType;

/**
 * @enum ThemeGraphTextFormat
 * @memberOf SuperMap
 * @description  统计专题图文本显示格式枚举。
 * @type {string}
 */

var ThemeGraphTextFormat = _SuperMap.SuperMap.ThemeGraphTextFormat = {
    /**  标题。以各子项的标题来进行标注。 */
    CAPTION: "CAPTION",
    /**  标题 + 百分数。以各子项的标题和所占的百分比来进行标注。 */
    CAPTION_PERCENT: "CAPTION_PERCENT",
    /**  标题 + 实际数值。以各子项的标题和真实数值来进行标注。 */
    CAPTION_VALUE: "CAPTION_VALUE",
    /**  百分数。以各子项所占的百分比来进行标注。 */
    PERCENT: "PERCENT",
    /**  实际数值。以各子项的真实数值来进行标注。 */
    VALUE: "VALUE"

};
exports.ThemeGraphTextFormat = ThemeGraphTextFormat;

/**
 * @enum ThemeGraphType
 * @memberOf SuperMap
 * @description  统计专题图类型枚举。
 * @type {string}
 */

var ThemeGraphType = _SuperMap.SuperMap.ThemeGraphType = {
    /**  面积图。 */
    AREA: "AREA",
    /**  柱状图。 */
    BAR: "BAR",
    /**  三维柱状图。 */
    BAR3D: "BAR3D",
    /**  折线图。 */
    LINE: "LINE",
    /**  饼图。 */
    PIE: "PIE",
    /**  三维饼图。 */
    PIE3D: "PIE3D",
    /**  点状图。 */
    POINT: "POINT",
    /**  环状图。 */
    RING: "RING",
    /**  玫瑰图。 */
    ROSE: "ROSE",
    /**  三维玫瑰图。 */
    ROSE3D: "ROSE3D",
    /**  堆叠柱状图。 */
    STACK_BAR: "STACK_BAR",
    /**  三维堆叠柱状图。 */
    STACK_BAR3D: "STACK_BAR3D",
    /**  阶梯图。 */
    STEP: "STEP"
};
exports.ThemeGraphType = ThemeGraphType;

/**
 * @enum GraphAxesTextDisplayMode
 * @memberOf SuperMap
 * @description  统计专题图坐标轴文本显示模式。
 * @type {string}
 */

var GraphAxesTextDisplayMode = _SuperMap.SuperMap.GraphAxesTextDisplayMode = {
    /**  显示全部文本。 */
    ALL: "ALL",
    /**  不显示。 */
    NONE: "NONE",
    /**  显示Y轴的文本。 */
    YAXES: "YAXES"
};
exports.GraphAxesTextDisplayMode = GraphAxesTextDisplayMode;

/**
 * @enum GraduatedMode
 * @memberOf SuperMap
 * @description  专题图分级模式枚举。
 *
 * @type {string}
 */

var GraduatedMode = _SuperMap.SuperMap.GraduatedMode = {
    /**  常量分级模式。 */
    CONSTANT: "CONSTANT",
    /** 对数分级模式。 */
    LOGARITHM: "LOGARITHM",
    /**  平方根分级模式。 */
    SQUAREROOT: "SQUAREROOT"
};
exports.GraduatedMode = GraduatedMode;

/**
 * @enum RangeMode
 * @memberOf SuperMap
 * @description  范围分段专题图分段方式枚举。
 * @type {string}
 */

var RangeMode = _SuperMap.SuperMap.RangeMode = {
    /**  自定义分段法。 */
    CUSTOMINTERVAL: "CUSTOMINTERVAL",
    /**  等距离分段法。 */
    EQUALINTERVAL: "EQUALINTERVAL",
    /**  对数分段法。 */
    LOGARITHM: "LOGARITHM",
    /**  等计数分段法。 */
    QUANTILE: "QUANTILE",
    /**  平方根分段法。 */
    SQUAREROOT: "SQUAREROOT",
    /**  标准差分段法。 */
    STDDEVIATION: "STDDEVIATION"
};
exports.RangeMode = RangeMode;

/**
 * @enum ThemeType
 * @memberOf SuperMap
 * @description  专题图类型枚举。
 * @type {string}
 */

var ThemeType = _SuperMap.SuperMap.ThemeType = {
    /** 点密度专题图。 */
    DOTDENSITY: "DOTDENSITY",
    /** 等级符号专题图。 */
    GRADUATEDSYMBOL: "GRADUATEDSYMBOL",
    /** 统计专题图。 */
    GRAPH: "GRAPH",
    /** 标签专题图。 */
    LABEL: "LABEL",
    /** 分段专题图。 */
    RANGE: "RANGE",
    /** 単值专题图。 */
    UNIQUE: "UNIQUE"
};
exports.ThemeType = ThemeType;

/**
 * @enum ColorGradientType
 * @memberOf SuperMap
 * @description  渐变颜色枚举。
 * @type {string}
 */

var ColorGradientType = _SuperMap.SuperMap.ColorGradientType = {
    /** 黑白渐变色。 */
    BLACK_WHITE: "BLACKWHITE",
    /** 蓝黑渐变色。 */
    BLUE_BLACK: "BLUEBLACK",
    /** 蓝红渐变色。 */
    BLUE_RED: "BLUERED",
    /** 蓝白渐变色。 */
    BLUE_WHITE: "BLUEWHITE",
    /** 青黑渐变色。 */
    CYAN_BLACK: "CYANBLACK",
    /** 青蓝渐变色。 */
    CYAN_BLUE: "CYANBLUE",
    /** 青绿渐变色。 */
    CYAN_GREEN: "CYANGREEN",
    /** 青白渐变色。 */
    CYAN_WHITE: "CYANWHITE",
    /** 绿黑渐变色。 */
    GREEN_BLACK: "GREENBLACK",
    /** 绿蓝渐变色。 */
    GREEN_BLUE: "GREENBLUE",
    /** 绿橙紫渐变色。 */
    GREEN_ORANGE_VIOLET: "GREENORANGEVIOLET",
    /** 绿红渐变色。 */
    GREEN_RED: "GREENRED",
    /** 蓝红渐变色。 */
    GREEN_WHITE: "GREENWHITE",
    /** 粉黑渐变色。 */
    PINK_BLACK: "PINKBLACK",
    /** 粉蓝渐变色。 */
    PINK_BLUE: "PINKBLUE",
    /** 粉红渐变色。 */
    PINK_RED: "PINKRED",
    /** 粉白渐变色。 */
    PINK_WHITE: "PINKWHITE",
    /** 彩虹色。 */
    RAIN_BOW: "RAINBOW",
    /** 红黑渐变色。 */
    RED_BLACK: "REDBLACK",
    /** 红白渐变色。 */
    RED_WHITE: "REDWHITE",
    /** 光谱渐变。 */
    SPECTRUM: "SPECTRUM",
    /** 地形渐变,用于三维显示效果较好。 */
    TERRAIN: "TERRAIN",
    /** 黄黑渐变色。 */
    YELLOW_BLACK: "YELLOWBLACK",
    /** 黄蓝渐变色。 */
    YELLOW_BLUE: "YELLOWBLUE",
    /** 黄绿渐变色。 */
    YELLOW_GREEN: "YELLOWGREEN",
    /** 黄红渐变色。 */
    YELLOW_RED: "YELLOWRED",
    /** 黄白渐变色。 */
    YELLOW_WHITE: "YELLOWWHITE"
};
exports.ColorGradientType = ColorGradientType;

/**
 * @enum TextAlignment
 * @memberOf SuperMap
 * @description  文本对齐枚举。
 * @type {string}
 */

var TextAlignment = _SuperMap.SuperMap.TextAlignment = {
    /** 左上角对齐。 */
    TOPLEFT: "TOPLEFT",
    /** 顶部居中对齐。 */
    TOPCENTER: "TOPCENTER",
    /** 右上角对齐。 */
    TOPRIGHT: "TOPRIGHT",
    /** 基准线左对齐。 */
    BASELINELEFT: "BASELINELEFT",
    /** 基准线居中对齐。 */
    BASELINECENTER: "BASELINECENTER",
    /** 基准线右对齐。 */
    BASELINERIGHT: "BASELINERIGHT",
    /** 左下角对齐。 */
    BOTTOMLEFT: "BOTTOMLEFT",
    /** 底部居中对齐。 */
    BOTTOMCENTER: "BOTTOMCENTER",
    /** 右下角对齐。 */
    BOTTOMRIGHT: "BOTTOMRIGHT",
    /** 左中对齐。 */
    MIDDLELEFT: "MIDDLELEFT",
    /** 中心对齐。 */
    MIDDLECENTER: "MIDDLECENTER",
    /** 右中对齐。 */
    MIDDLERIGHT: "MIDDLERIGHT"
};
exports.TextAlignment = TextAlignment;
/**
 * @enum FillGradientMode
 * @memberOf SuperMap
 * @description  渐变填充风格的渐变类型枚举。
 * @type {string}
 */

var FillGradientMode = _SuperMap.SuperMap.FillGradientMode = {
    /** 无渐变。 */
    NONE: "NONE",
    /** 线性渐变填充。 */
    LINEAR: "LINEAR",
    /** 辐射渐变填充。 */
    RADIAL: "RADIAL",
    /** 圆锥渐变填充。 */
    CONICAL: "CONICAL",
    /** 四角渐变填充。 */
    SQUARE: "SQUARE"
};
exports.FillGradientMode = FillGradientMode;

/**
 * @enum AlongLineDirection
 * @memberOf SuperMap
 * @description  标签沿线标注方向枚举。
 * @type {string}
 */

var AlongLineDirection = _SuperMap.SuperMap.AlongLineDirection = {
    /** 沿线的法线方向放置标签。 */
    NORMAL: "ALONG_LINE_NORMAL",
    /** 从下到上，从左到右放置。 */
    LB_TO_RT: "LEFT_BOTTOM_TO_RIGHT_TOP",
    /** 从上到下，从左到右放置。 */
    LT_TO_RB: "LEFT_TOP_TO_RIGHT_BOTTOM",
    /** 从下到上，从右到左放置。 */
    RB_TO_LT: "RIGHT_BOTTOM_TO_LEFT_TOP",
    /** 从上到下，从右到左放置。 */
    RT_TO_LB: "RIGHT_TOP_TO_LEFT_BOTTOM"
};
exports.AlongLineDirection = AlongLineDirection;

/**
 * @enum LabelBackShape
 * @memberOf SuperMap
 * @description  标签专题图中标签背景的形状枚举。
 * @type {string}
 */

var LabelBackShape = _SuperMap.SuperMap.LabelBackShape = {
    /** 菱形背景，即标签背景的形状为菱形。 */
    DIAMOND: "DIAMOND",
    /** 椭圆形背景，即标签背景的行状为椭圆形。 */
    ELLIPSE: "ELLIPSE",
    /** 符号背景，即标签背景的形状为设定的符号。 */
    MARKER: "MARKER",
    /** 空背景，即不使用任何形状作为标签的背景。 */
    NONE: "NONE",
    /** 矩形背景，即标签背景的形状为矩形。 */
    RECT: "RECT",
    /** 圆角矩形背景，即标签背景的形状为圆角矩形。 */
    ROUNDRECT: "ROUNDRECT",
    /** 三角形背景，即标签背景的形状为三角形。 */
    TRIANGLE: "TRIANGLE"
};
exports.LabelBackShape = LabelBackShape;

/**
 * @enum LabelOverLengthMode
 * @memberOf SuperMap
 * @description  标签专题图中超长标签的处理模式枚举。
 * @type {string}
 */

var LabelOverLengthMode = _SuperMap.SuperMap.LabelOverLengthMode = {
    /** 换行显示。 */
    NEWLINE: "NEWLINE",
    /** 对超长标签不进行处理。 */
    NONE: "NONE",
    /** 省略超出部分。 */
    OMIT: "OMIT"
};
exports.LabelOverLengthMode = LabelOverLengthMode;

/**
 * @enum DirectionType
 * @memberOf SuperMap
 * @description  网络分析中方向枚举。
 * 在行驶引导子项中使用。
 * @type {string}
 */

var DirectionType = _SuperMap.SuperMap.DirectionType = {
    /** 东。 */
    EAST: "EAST",
    /** 无方向。 */
    NONE: "NONE",
    /** 北。 */
    NORTH: "NORTH",
    /** 南。 */
    SOURTH: "SOURTH",
    /** 西。 */
    WEST: "WEST"
};
exports.DirectionType = DirectionType;

/**
 * @enum SideType
 * @memberOf SuperMap
 * @description  行驶位置枚举。
 * 表示在行驶在路的左边、右边或者路上的枚举,该类用在行驶导引子项类中。
 * @type {string}
 */

var SideType = _SuperMap.SuperMap.SideType = {
    /** 路的左侧。 */
    LEFT: "LEFT",
    /** 在路上（即路的中间）。 */
    MIDDLE: "MIDDLE",
    /** 无效值。 */
    NONE: "NONE",
    /** 路的右侧。 */
    RIGHT: "RIGHT"
};
exports.SideType = SideType;

/**
 * @enum SupplyCenterType
 * @memberOf SuperMap
 * @description  资源供给中心类型枚举。
 * 该枚举定义了网络分析中资源中心点的类型，主要用于资源分配和选址分区。
 * 资源供给中心点的类型包括非中心，固定中心和可选中心。固定中心用于资源分配分析； 固定中心和可选中心用于选址分析；非中心在两种网络分析时都不予考虑。
 * @type {string}
 */

var SupplyCenterType = _SuperMap.SuperMap.SupplyCenterType = {
    /** 固定中心点。 */
    FIXEDCENTER: "FIXEDCENTER",
    /** 非中心点。 */
    NULL: "NULL",
    /** 可选中心点。 */
    OPTIONALCENTER: "OPTIONALCENTER"
};
exports.SupplyCenterType = SupplyCenterType;

/**
 * @enum TurnType
 * @memberOf SuperMap
 * @description  转弯方向枚举。
 * 用在行驶引导子项类中，表示转弯的方向。
 * @type {string}
 */

var TurnType = _SuperMap.SuperMap.TurnType = {
    /** 向前直行。 */
    AHEAD: "AHEAD",
    /** 掉头。 */
    BACK: "BACK",
    /** 终点，不拐弯。 */
    END: "END",
    /** 左转弯。 */
    LEFT: "LEFT",
    /** 无效值。 */
    NONE: "NONE",
    /** 右转弯。 */
    RIGHT: "RIGHT"
};
exports.TurnType = TurnType;

/**
 * @enum BufferEndType
 * @memberOf SuperMap
 * @description  缓冲区分析BufferEnd类型。
 * @type {string}
 */

var BufferEndType = _SuperMap.SuperMap.BufferEndType = {
    /** FLAT */
    FLAT: "FLAT",
    /** ROUND */
    ROUND: "ROUND"
};
exports.BufferEndType = BufferEndType;
/**
 * @enum OverlayOperationType
 * @memberOf SuperMap
 * @description  叠加分析类型枚举。
 * @type {string}
 */

var OverlayOperationType = _SuperMap.SuperMap.OverlayOperationType = {
    /** 操作数据集（几何对象）裁剪被操作数据集（几何对象）。 */
    CLIP: "CLIP",
    /** 在被操作数据集（几何对象）上擦除掉与操作数据集（几何对象）相重合的部分。。 */
    ERASE: "ERASE",
    /**对被操作数据集（几何对象）进行同一操作，即操作执行后，被操作数据集（几何对象）包含来自操作数据集（几何对象）的几何形状。 */
    IDENTITY: "IDENTITY",
    /** 对两个数据集（几何对象）求交，返回两个数据集（几何对象）的交集。 */
    INTERSECT: "INTERSECT",
    /** 对两个面数据集（几何对象）进行合并操作。。 */
    UNION: "UNION",
    /** 对两个面数据集（几何对象）进行更新操作。 */
    UPDATE: "UPDATE",
    /** 对两个面数据集（几何对象）进行对称差操作。 */
    XOR: "XOR"
};
exports.OverlayOperationType = OverlayOperationType;

/**
 * @enum OutputType
 * @memberOf SuperMap
 * @description  分布式分析输出类型枚举。
 * @type {string}
 */

var OutputType = _SuperMap.SuperMap.OutputType = {
    /** INDEXEDHDFS */
    INDEXEDHDFS: "INDEXEDHDFS",
    /** UDB */
    UDB: "UDB",
    /** MONGODB */
    MONGODB: "MONGODB",
    /** PG */
    PG: "PG"
};
exports.OutputType = OutputType;

/**
 * @enum SmoothMethod
 * @memberOf SuperMap
 * @description  光滑方法枚举。
 * 用于从Grid 或DEM数据生成等值线或等值面时对等值线或者等值面的边界线进行平滑处理的方法。
 * @type {string}
 */

var SmoothMethod = _SuperMap.SuperMap.SmoothMethod = {
    /** B 样条法。 */
    BSPLINE: "BSPLINE",
    /** 磨角法。 */
    POLISH: "POLISH"
};
exports.SmoothMethod = SmoothMethod;
/**
 * @enum SurfaceAnalystMethod
 * @memberOf SuperMap
 * @description  表面分析方法枚举。
 * 通过对数据进行表面分析，能够挖掘原始数据所包含的信息，使某些细节明显化，易于分析。
 * @type {string}
 */

var SurfaceAnalystMethod = _SuperMap.SuperMap.SurfaceAnalystMethod = {
    /** 等值线提取。 */
    ISOLINE: "ISOLINE",
    /** 等值面提取。 */
    ISOREGION: "ISOREGION"
};
exports.SurfaceAnalystMethod = SurfaceAnalystMethod;
/**
 * @enum DataReturnMode
 * @memberOf SuperMap
 * @description  数据返回模式枚举。
 * 该枚举用于指定空间分析返回结果模式,包含返回数据集标识和记录集、只返回数据集标识(数据集名称@数据源名称)及只返回记录集三种模式。
 * @type {string}
 */

var DataReturnMode = _SuperMap.SuperMap.DataReturnMode = {
    /** 返回结果数据集标识(数据集名称@数据源名称)和记录集（RecordSet）。 */
    DATASET_AND_RECORDSET: "DATASET_AND_RECORDSET",
    /** 只返回数据集标识（数据集名称@数据源名称）。 */
    DATASET_ONLY: "DATASET_ONLY",
    /** 只返回记录集（RecordSet）。 */
    RECORDSET_ONLY: "RECORDSET_ONLY"
};
exports.DataReturnMode = DataReturnMode;
/**
 * @enum EditType
 * @memberOf SuperMap
 * @description  要素集更新模式枚举。
 * 该枚举用于指定数据服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 * @type {string}
 */

var EditType = _SuperMap.SuperMap.EditType = {
    /** 增加操作。 */
    ADD: "add",
    /** 修改操作。 */
    UPDATE: "update",
    /** 删除操作。 */
    DELETE: "delete"
};
exports.EditType = EditType;

/**
 * @enum TransferTactic
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定公交服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 * @type {string}
 */

var TransferTactic = _SuperMap.SuperMap.TransferTactic = {
    /** 时间短。 */
    LESS_TIME: "LESS_TIME",
    /** 少换乘。 */
    LESS_TRANSFER: "LESS_TRANSFER",
    /** 少步行。 */
    LESS_WALK: "LESS_WALK",
    /** 距离最短。 */
    MIN_DISTANCE: "MIN_DISTANCE"
};
exports.TransferTactic = TransferTactic;

/**
 * @enum TransferPreference
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定交通换乘服务中设置地铁优先、公交优先、不乘地铁、无偏好等偏好设置。
 * @type {string}
 */

var TransferPreference = _SuperMap.SuperMap.TransferPreference = {
    /** 公交汽车优先。 */
    BUS: "BUS",
    /** 地铁优先。 */
    SUBWAY: "SUBWAY",
    /** 不乘坐地铁。 */
    NO_SUBWAY: "NO_SUBWAY",
    /** 无乘车偏好。 */
    NONE: "NONE"
};
exports.TransferPreference = TransferPreference;

/**
 * @enum GridType
 * @memberOf SuperMap
 * @description  地图背景格网类型枚举。
 * @type {string}
 */

var GridType = _SuperMap.SuperMap.GridType = {
    /** 十字叉丝。 */
    CROSS: "CROSS",
    /** 网格线。 */
    GRID: "GRID",
    /** 点。 */
    POINT: "POINT"
};
exports.GridType = GridType;

/**
 * @enum ColorSpaceType
 * @memberOf SuperMap
 * @description  色彩空间枚举。
 * 由于成色原理的不同，决定了显示器、投影仪这类靠色光直接合成颜色的颜色设备和打印机、
 * 印刷机这类靠使用颜料的印刷设备在生成颜色方式上的区别。
 * 针对上述不同成色方式，SuperMap 提供两种色彩空间，
 * 分别为 RGB 和 CMYK。RGB 主要用于显示系统中，CMYK 主要用于印刷系统中。
 * @type {string}
 */

var ColorSpaceType = _SuperMap.SuperMap.ColorSpaceType = {
    /** 该类型主要在印刷系统使用。 */
    CMYK: "CMYK",
    /** 该类型主要在显示系统中使用。 */
    RGB: "RGB"
};
exports.ColorSpaceType = ColorSpaceType;
/**
 * @enum LayerType
 * @memberOf SuperMap
 * @description  图层类型。
 * @type {string}
 */

var LayerType = _SuperMap.SuperMap.LayerType = {
    /** SuperMap UGC 类型图层。如矢量图层、栅格(Grid)图层、影像图层。。 */
    UGC: "UGC",
    /** WMS 图层。 */
    WMS: "WMS",
    /** WFS 图层。 */
    WFS: "WFS",
    /** 自定义图层。 */
    CUSTOM: "CUSTOM"
};
exports.LayerType = LayerType;

/**
 * @enum UGCLayerType
 * @memberOf SuperMap
 * @description  UGC图层类型。
 * @type {string}
 */

var UGCLayerType = _SuperMap.SuperMap.UGCLayerType = {
    /** 专题图层。 */
    THEME: "THEME",
    /** 矢量图层。 */
    VECTOR: "VECTOR",
    /** 栅格图层。。 */
    GRID: "GRID",
    /** 影像图层。 */
    IMAGE: "IMAGE"
};
exports.UGCLayerType = UGCLayerType;

/**
 * @enum StatisticMode
 * @memberOf SuperMap
 * @description  字段统计方法类型。
 * @type {string}
 */

var StatisticMode = _SuperMap.SuperMap.StatisticMode = {
    /** 统计所选字段的平均值。 */
    AVERAGE: "AVERAGE",
    /** 统计所选字段的最大值。 */
    MAX: "MAX",
    /** 统计所选字段的最小值。 */
    MIN: "MIN",
    /** 统计所选字段的标准差 */
    STDDEVIATION: "STDDEVIATION",
    /** 统计所选字段的总和。 */
    SUM: "SUM",
    /** 统计所选字段的方差。 */
    VARIANCE: "VARIANCE"
};
exports.StatisticMode = StatisticMode;

/**
 * @enum PixelFormat
 * @memberOf SuperMap
 * @description  栅格与影像数据存储的像素格式枚举。
 * @type {string}
 */

var PixelFormat = _SuperMap.SuperMap.PixelFormat = {
    /** 每个像元用16个比特(即2个字节)表示。 */
    BIT16: "BIT16",
    /** 每个像元用32个比特(即4个字节)表示。 */
    BIT32: "BIT32",
    /** 每个像元用64个比特(即8个字节)表示，只提供给栅格数据集使用。 */
    BIT64: "BIT64",
    /** 每个像元用4个字节来表示，只提供给栅格数据集使用。 */
    SINGLE: "SINGLE",
    /** 每个像元用8个字节来表示，只提供给栅格数据集使用。 */
    DOUBLE: "DOUBLE",
    /** 每个像元用1个比特表示。 */
    UBIT1: "UBIT1",
    /** 每个像元用4个比特来表示。 */
    UBIT4: "UBIT4",
    /** 每个像元用8个比特(即1个字节)来表示。 */
    UBIT8: "UBIT8",
    /** 每个像元用24个比特(即3个字节)来表示。 */
    UBIT24: "UBIT24",
    /** 每个像元用32个比特(即4个字节)来表示。 */
    UBIT32: "UBIT32"
};
exports.PixelFormat = PixelFormat;

/**
 * @enum SearchMode
 * @memberOf SuperMap
 * @description  内插时使用的样本点的查找方式枚举
 * @type {string}
 */

var SearchMode = _SuperMap.SuperMap.SearchMode = {
    /** 使用 KDTREE 的固定点数方式查找参与内插分析的点。 */
    KDTREE_FIXED_COUNT: "KDTREE_FIXED_COUNT",
    /** 使用 KDTREE 的定长方式查找参与内插分析的点。 */
    KDTREE_FIXED_RADIUS: "KDTREE_FIXED_RADIUS",
    /** 不进行查找，使用所有的输入点进行内插分析。 */
    NONE: "NONE",
    /** 使用 QUADTREE 方式查找参与内插分析的点，仅对样条（RBF）插值和普通克吕金（Kriging）有用。 */
    QUADTREE: "QUADTREE"
};
exports.SearchMode = SearchMode;

/**
 * @enum InterpolationAlgorithmType
 * @memberOf SuperMap
 * @description  插值分析的算法的类型
 * @type {string}
 */

var InterpolationAlgorithmType = _SuperMap.SuperMap.InterpolationAlgorithmType = {
    /** 普通克吕金插值法。 */
    KRIGING: "KRIGING",
    /** 简单克吕金插值法。 */
    SimpleKriging: "SimpleKriging",
    /** 泛克吕金插值法。 */
    UniversalKriging: "UniversalKriging"
};
exports.InterpolationAlgorithmType = InterpolationAlgorithmType;

/**
 * @enum VariogramMode
 * @memberOf SuperMap
 * @description  克吕金（Kriging）插值时的半变函数类型枚举
 * @type {string}
 */

var VariogramMode = _SuperMap.SuperMap.VariogramMode = {
    /** 指数函数。 */
    EXPONENTIAL: "EXPONENTIAL",
    /** 高斯函数。 */
    GAUSSIAN: "GAUSSIAN",
    /** 球型函数。 */
    SPHERICAL: "SPHERICAL"
};
exports.VariogramMode = VariogramMode;

/**
 * @enum Exponent
 * @memberOf SuperMap
 * @description  定义了泛克吕金（UniversalKriging）插值时样点数据中趋势面方程的阶数
 * @type {string}
 */

var Exponent = _SuperMap.SuperMap.Exponent = {
    /** 阶数为1。 */
    EXP1: "EXP1",
    /** 阶数为2。 */
    EXP2: "EXP2"
};
exports.Exponent = Exponent;

/**
 * @enum ClientType
 * @memberOf SuperMap
 * @description token申请的客户端标识类型
 * @type {string}
 */

var ClientType = _SuperMap.SuperMap.ClientType = {
    /** 指定的 IP 地址。 */
    IP: "IP",
    /** 指定的 URL。 */
    REFERER: "Referer",
    /** 发送申请令牌请求的客户端 IP。 */
    REQUESTIP: "RequestIP",
    /** 不做任何验证。 */
    NONE: "NONE",
    /** SERVER。 */
    SERVER: "SERVER",
    /** WEB。 */
    WEB: "WEB"
};
exports.ClientType = ClientType;

/**
 * @enum ChartType
 * @memberOf SuperMap
 * @description 客户端专题图图表类型
 * @type {string}
 */

var ChartType = _SuperMap.SuperMap.ChartType = {
    /** 柱状图。 */
    BAR: "Bar",
    /** 三维柱状图。 */
    BAR3D: "Bar3D",
    /** 圆形图。 */
    CIRCLE: "Circle",
    /** 饼图。 */
    PIE: "Pie",
    /** 散点图。 */
    POINT: "Point",
    /** 折线图。 */
    LINE: "Line",
    /** 环状图。 */
    RING: "Ring"
};
exports.ChartType = ChartType;

/**
 * @enum ClipAnalystMode
 * @memberOf SuperMap
 * @description  裁剪分析模式
 * @type {string}
 */

var ClipAnalystMode = _SuperMap.SuperMap.ClipAnalystMode = {
    /** CLIP。 */
    CLIP: "clip",
    /** INTERSECT。 */
    INTERSECT: "intersect"
};
exports.ClipAnalystMode = ClipAnalystMode;
/**
 * @enum AnalystAreaUnit
 * @memberOf SuperMap
 * @description 分布式分析面积单位
 * @type {string}
 */

var AnalystAreaUnit = _SuperMap.SuperMap.AnalystAreaUnit = {
    /** 平方米。 */
    "SQUAREMETER": "SquareMeter",
    /** 平方千米。 */
    "SQUAREKILOMETER": "SquareKiloMeter",
    /** 公顷。 */
    "HECTARE": "Hectare",
    /** 公亩。 */
    "ARE": "Are",
    /** 英亩。 */
    "ACRE": "Acre",
    /** 平方英尺。 */
    "SQUAREFOOT": "SquareFoot",
    /** 平方码。 */
    "SQUAREYARD": "SquareYard",
    /** 平方英里。 */
    "SQUAREMILE": "SquareMile"
};
exports.AnalystAreaUnit = AnalystAreaUnit;
/**
 * @enum AnalystSizeUnit
 * @memberOf SuperMap
 * @description 分布式分析单位
 * @type {string}
 */

var AnalystSizeUnit = _SuperMap.SuperMap.AnalystSizeUnit = {
    /** 米。 */
    "METER": "Meter",
    /** 千米。 */
    "KILOMETER": "Kilometer",
    /** 码。 */
    "YARD": "Yard",
    /** 英尺。 */
    "FOOT": "Foot",
    /** 英里。 */
    "MILE": "Mile"
};
exports.AnalystSizeUnit = AnalystSizeUnit;

/**
 * @enum StatisticAnalystMode
 * @memberOf SuperMap
 * @description 分布式分析统计模式
 * @type {string}
 */

var StatisticAnalystMode = _SuperMap.SuperMap.StatisticAnalystMode = {
    /** 统计所选字段的最大值。 */
    "MAX": "max",
    /** 统计所选字段的最小值。 */
    "MIN": "min",
    /** 统计所选字段的平均值。 */
    "AVERAGE": "average",
    /** 统计所选字段的总和。 */
    "SUM": "sum",
    /** 统计所选字段的方差。 */
    "VARIANCE": "variance",
    /** 统计所选字段的标准差 */
    "STDDEVIATION": "stdDeviation"
};
exports.StatisticAnalystMode = StatisticAnalystMode;
/**
 * @enum SummaryType
 * @memberOf SuperMap
 * @description 分布式分析聚合类型
 * @type {string}
 */

var SummaryType = _SuperMap.SuperMap.SummaryType = {
    /** 格网聚合。 */
    "SUMMARYMESH": "SUMMARYMESH",
    /** 多边形聚合。 */
    "SUMMARYREGION": "SUMMARYREGION"
};
exports.SummaryType = SummaryType;
/**
 * @enum TopologyValidatorRule
 * @memberOf SuperMap
 * @description  拓扑检查模式枚举。该类定义了拓扑检查操作模式常量。
 * @type {string}
 */

var TopologyValidatorRule = _SuperMap.SuperMap.TopologyValidatorRule = {
    /** 面内无重叠，用于对面数据进行拓扑检查。 */
    REGIONNOOVERLAP: "REGIONNOOVERLAP",
    /** 面与面无重叠，用于对面数据进行拓扑检查。 */
    REGIONNOOVERLAPWITH: "REGIONNOOVERLAPWITH",
    /** 面被面包含，用于对面数据进行拓扑检查。 */
    REGIONCONTAINEDBYREGION: "REGIONCONTAINEDBYREGION",
    /** 面被面覆盖，用于对面数据进行拓扑检查。 */
    REGIONCOVEREDBYREGION: "REGIONCOVEREDBYREGION",
    /** 线与线无重叠，用于对线数据进行拓扑检查。 */
    LINENOOVERLAP: "LINENOOVERLAP",
    /** 线内无重叠，用于对线数据进行拓扑检查。 */
    LINENOOVERLAPWITH: "LINENOOVERLAPWITH",
    /** 点不相同，用于对点数据进行拓扑检查。 */
    POINTNOIDENTICAL: "POINTNOIDENTICAL"
};
exports.TopologyValidatorRule = TopologyValidatorRule;

/**
 * @enum AggregationType
 * @memberOf SuperMap
 * @description  聚合查询枚举类，该类定义了Es数据服务中聚合查询模式常量
 * @type {string}
 */

var AggregationType = _SuperMap.SuperMap.AggregationType = {
    /** 格网聚合类型。 */
    GEOHASH_GRID: "geohash_grid",
    /** 过滤聚合类型。 */
    FILTER: "filter"
};
exports.AggregationType = AggregationType;

/**
 * @enum AggregationType
 * @memberOf SuperMap
 * @description  聚合查询中filter查询枚举类
 * @type {string}
 */

var AggregationQueryBuilderType = _SuperMap.SuperMap.AggregationQueryBuilderType = {
    /** 范围查询。 */
    GEO_BOUNDING_BOX: "geo_bounding_box"
};
exports.AggregationQueryBuilderType = AggregationQueryBuilderType;

/**
 * @enum GetFeatureMode
 * @memberOf SuperMap
 * @description feature 查询方式。
 * @type {string}
 */

var GetFeatureMode = _SuperMap.SuperMap.GetFeatureMode = {
    /** 通过范围查询来获取要素。 */
    BOUNDS: "BOUNDS",
    /** 通过几何对象的缓冲区来获取要素。 */
    BUFFER: "BUFFER",
    /** 通过 ID 来获取要素。 */
    ID: "ID",
    /** 通过空间查询模式来获取要素。 */
    SPATIAL: "SPATIAL",
    /** 通过 SQL 查询来获取要素。 */
    SQL: 'SQL'
};
exports.GetFeatureMode = GetFeatureMode;

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = mapboxgl;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(118);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
/**
 * SuperMap mapboxgl基类
 * 定义命名空间
 */
/**
 * @namespace mapboxgl
 * @category BaseTypes Namespace
 */
/**
 * @namespace mapboxgl.supermap
 * @category BaseTypes Namespace
 */
_mapboxGl2.default.supermap = _mapboxGl2.default.supermap || {};

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.zh = exports.en = exports.Lang = exports.ElasticSearch = exports.ThemeStyle = exports.CartoCSS = exports.TokenServiceParameter = exports.ServerInfo = exports.SecurityManager = exports.KeyServiceParameter = exports.SUtil = exports.LevelRendererVector = exports.Util = exports.Transformable = exports.Storage = exports.SmicText = exports.SmicStar = exports.SmicSector = exports.SmicRing = exports.SmicRectangle = exports.SmicPolygon = exports.SmicPoint = undefined;
exports.SmicIsogon = exports.SmicImage = exports.SmicEllipse = exports.SmicCircle = exports.SmicBrokenLine = exports.Shape = exports.PaintLayer = exports.Painter = exports.Matrix = exports.Math = exports.Log = exports.Http = exports.Handler = exports.Group = exports.Eventful = exports.LevelRendererEvent = exports.Env = exports.Easing = exports.LevelRendererCurve = exports.Config = exports.ComputeBoundingBox = exports.Color = exports.Clip = exports.Area = exports.Animator = exports.Animation = exports.Render = exports.LevelRenderer = exports.FeatureTheme = exports.Sector = exports.FeatureRectangle = exports.FeaturePolygon = exports.Point = exports.FeatureLine = exports.Label = exports.Image = exports.FeatureCircle = exports.ShapeParameters = exports.ShapeFactory = exports.ThemeVector = exports.Ring = exports.RankSymbol = exports.OverlayPoint = exports.Pie = exports.Line = exports.Graph = exports.Circle = exports.Bar3D = exports.Bar = exports.OnlineServiceBase = exports.FilterField = exports.DataItemOrderBy = exports.DataItemType = exports.ServiceStatus = exports.OnlineQueryDatasParameter = exports.OnlineData = exports.Online = exports.VectorClipJobsService = exports.VectorClipJobsParameter = exports.Vector = exports.UpdateTurnNodeWeightService = exports.UpdateTurnNodeWeightParameters = exports.UpdateEdgeWeightService = exports.UpdateEdgeWeightParameters = exports.UGCSubLayer = exports.UGCMapLayer = exports.UGCLayer = exports.TransferSolutionParameters = exports.TransportationAnalystResultSetting = exports.TransportationAnalystParameter = exports.TransferSolutionService = exports.TransferPathService = exports.TransferPathParameters = exports.TransferLine = exports.TopologyValidatorJobsService = exports.TopologyValidatorJobsParameter = exports.TilesetsService = exports.GeometryBatchAnalystService = exports.ThiessenAnalystService = exports.ThiessenAnalystParameters = exports.ThemeUniqueItem = exports.ThemeUnique = exports.ThemeService = exports.ThemeRangeItem = exports.ThemeRange = exports.ThemeParameters = exports.ThemeOffset = exports.ThemeMemoryData = exports.ThemeLabelUniqueItem = exports.ThemeLabelText = exports.ThemeLabelItem = exports.ThemeLabelBackground = exports.ThemeLabelAlongLine = exports.ThemeLabel = exports.ThemeGridUniqueItem = exports.ThemeGridUnique = exports.ThemeGridRangeItem = exports.ThemeGridRange = exports.ThemeGraphText = exports.ThemeGraphSize = undefined;
exports.ThemeGraphItem = exports.ThemeGraphAxes = exports.ThemeGraph = exports.ThemeGraduatedSymbolStyle = exports.ThemeGraduatedSymbol = exports.ThemeFlow = exports.ThemeDotDensity = exports.Theme = exports.TerrainCurvatureCalculationService = exports.TerrainCurvatureCalculationParameters = exports.SurfaceAnalystService = exports.SurfaceAnalystParametersSetting = exports.SurfaceAnalystParameters = exports.SupplyCenter = exports.SummaryRegionJobsService = exports.SummaryRegionJobParameter = exports.SummaryMeshJobsService = exports.SummaryMeshJobParameter = exports.SummaryAttributesJobsService = exports.SummaryAttributesJobsParameter = exports.StopQueryService = exports.StopQueryParameters = exports.SpatialAnalystBase = exports.SingleObjectQueryJobsService = exports.SingleObjectQueryJobsParameter = exports.SetLayerStatusService = exports.SetLayerStatusParameters = exports.SetLayersInfoService = exports.SetLayersInfoParameters = exports.SetLayerInfoService = exports.SetLayerInfoParameters = exports.ServerTheme = exports.ServerTextStyle = exports.ServerStyle = exports.ServerGeometry = exports.ServerFeature = exports.ServerColor = exports.RouteLocatorService = exports.RouteLocatorParameters = exports.RouteCalculateMeasureService = exports.RouteCalculateMeasureParameters = exports.Route = exports.QueryService = exports.QueryParameters = exports.QueryBySQLService = exports.QueryBySQLParameters = exports.QueryByGeometryService = exports.QueryByGeometryParameters = exports.QueryByDistanceService = exports.QueryByDistanceParameters = exports.QueryByBoundsService = exports.QueryByBoundsParameters = exports.ProcessingServiceBase = exports.PointWithMeasure = exports.OverlayGeoJobsService = exports.OverlayGeoJobParameter = exports.OverlayAnalystService = exports.OverlayAnalystParameters = exports.OverlapDisplayedOptions = exports.MappingParameters = exports.OutputSetting = exports.NetworkAnalystServiceBase = exports.MeasureService = exports.MeasureParameters = exports.MathExpressionAnalysisService = exports.MathExpressionAnalysisParameters = exports.MapService = exports.LinkItem = exports.LayerStatus = exports.LabelThemeCell = exports.LabelSymbolCell = exports.LabelMixedTextStyle = exports.LabelMatrixCell = exports.LabelImageCell = exports.KernelDensityJobsService = exports.KernelDensityJobParameter = exports.JoinItem = exports.InterpolationRBFAnalystParameters = exports.InterpolationKrigingAnalystParameters = exports.InterpolationIDWAnalystParameters = exports.InterpolationAnalystService = exports.InterpolationAnalystParameters = exports.UGCImage = exports.Grid = exports.GetLayersInfoService = exports.GetGridCellInfosService = exports.GetGridCellInfosParameters = exports.GetFieldsService = exports.GetFeaturesServiceBase = exports.GetFeaturesParametersBase = exports.GetFeaturesBySQLService = exports.GetFeaturesBySQLParameters = exports.GetFeaturesByIDsService = exports.GetFeaturesByIDsParameters = exports.GetFeaturesByGeometryService = exports.GetFeaturesByGeometryParameters = exports.GetFeaturesByBufferService = exports.GetFeaturesByBufferParameters = exports.GetFeaturesByBoundsService = exports.GetFeaturesByBoundsParameters = undefined;
exports.GeoRelationAnalystService = exports.GeoRelationAnalystParameters = exports.GeometryThiessenAnalystParameters = exports.GeometrySurfaceAnalystParameters = exports.GeometryOverlayAnalystParameters = exports.GeometryBufferAnalystParameters = exports.GeoHashGridAggParameter = exports.GeoDecodingParameter = exports.GeoCodingParameter = exports.GeoBoundingBoxQueryBuilderParameter = exports.GenerateSpatialDataService = exports.GenerateSpatialDataParameters = exports.FindTSPPathsService = exports.FindTSPPathsParameters = exports.FindServiceAreasService = exports.FindServiceAreasParameters = exports.FindPathService = exports.FindPathParameters = exports.FindMTSPPathsService = exports.FindMTSPPathsParameters = exports.FindLocationService = exports.FindLocationParameters = exports.FindClosestFacilitiesService = exports.FindClosestFacilitiesParameters = exports.FilterParameter = exports.FilterAggParameter = exports.FieldStatisticsParameters = exports.FieldStatisticService = exports.FieldParameters = exports.FacilityAnalystUpstream3DService = exports.FacilityAnalystUpstream3DParameters = exports.FacilityAnalystTraceup3DService = exports.FacilityAnalystTraceup3DParameters = exports.FacilityAnalystTracedown3DService = exports.FacilityAnalystTracedown3DParameters = exports.FacilityAnalystStreamService = exports.FacilityAnalystStreamParameters = exports.FacilityAnalystSources3DService = exports.FacilityAnalystSources3DParameters = exports.FacilityAnalystSinks3DService = exports.FacilityAnalystSinks3DParameters = exports.FacilityAnalyst3DParameters = exports.EditFeaturesService = exports.EditFeaturesParameters = exports.DensityKernelAnalystParameters = exports.DensityAnalystService = exports.DatasourceConnectionInfo = exports.DatasetThiessenAnalystParameters = exports.DatasetSurfaceAnalystParameters = exports.DatasetOverlayAnalystParameters = exports.DatasetInfo = exports.DatasetBufferAnalystParameters = exports.DataReturnOption = exports.DataFlowService = exports.ComputeWeightMatrixService = exports.ComputeWeightMatrixParameters = exports.CommonServiceBase = exports.ColorDictionary = exports.ClipParameter = exports.ChartQueryService = exports.ChartQueryParameters = exports.ChartQueryFilterParameter = exports.ChartFeatureInfoSpecsService = exports.BurstPipelineAnalystService = exports.BurstPipelineAnalystParameters = exports.BuffersAnalystJobsService = exports.BuffersAnalystJobsParameter = exports.BufferSetting = exports.BufferDistance = exports.BufferAnalystService = exports.BufferAnalystParameters = exports.AreaSolarRadiationService = exports.AreaSolarRadiationParameters = exports.AggQueryBuilderParameter = exports.AggregationParameter = exports.AddressMatchService = exports.IPortalServicesQueryParam = exports.IPortalServiceBase = exports.IPortalService = exports.IPortalMapsQueryParam = exports.IPortalMap = exports.IPortal = exports.IManagerServiceBase = exports.IManagerCreateNodeParam = exports.IManager = exports.ArrayStatistic = exports.ColorsPickerUtil = exports.FetchRequest = exports.getRequestTimeout = exports.setRequestTimeout = exports.isCORS = exports.setCORS = exports.WKT = exports.JSONFormat = exports.GeoJSON = exports.Format = exports.TimeFlowControl = exports.TimeControlBase = exports.GeometryVector = exports.CommonUtil = undefined;
exports.Size = exports.Pixel = exports.LonLat = exports.Geometry = exports.Feature = exports.Events = exports.Event = exports.DateExt = exports.Credential = exports.Bounds = exports.ArrayExt = exports.FunctionExt = exports.NumberExt = exports.StringExt = exports.Rectangle = exports.Polygon = exports.GeometryPoint = exports.MultiPolygon = exports.MultiPoint = exports.MultiLineString = exports.LineString = exports.LinearRing = exports.GeoText = exports.Curve = exports.Collection = exports.GetFeatureMode = exports.AggregationType = exports.AggregationQueryBuilderType = exports.OutputType = exports.TopologyValidatorRule = exports.StatisticAnalystMode = exports.AnalystSizeUnit = exports.AnalystAreaUnit = exports.ClipAnalystMode = exports.Exponent = exports.VariogramMode = exports.InterpolationAlgorithmType = exports.SummaryType = exports.SearchMode = exports.PixelFormat = exports.StatisticMode = exports.UGCLayerType = exports.LayerType = exports.ClientType = exports.GridType = exports.TransferPreference = exports.TransferTactic = exports.EditType = exports.ChartType = exports.ColorSpaceType = exports.SurfaceAnalystMethod = exports.SmoothMethod = exports.BufferEndType = exports.TurnType = exports.SupplyCenterType = exports.OverlayOperationType = exports.DirectionType = exports.LabelOverLengthMode = exports.LabelBackShape = exports.AlongLineDirection = exports.SideType = exports.FillGradientMode = exports.TextAlignment = exports.ColorGradientType = exports.ThemeType = exports.RangeMode = exports.GraduatedMode = exports.GraphAxesTextDisplayMode = exports.ThemeGraphType = exports.ThemeGraphTextFormat = exports.SpatialQueryMode = exports.BufferRadiusUnit = exports.Unit = exports.DataReturnMode = exports.SpatialRelationType = exports.MeasureMode = exports.EngineType = exports.JoinType = exports.QueryOption = exports.GeometryType = exports.ServerType = exports.DataFormat = exports.SuperMap = exports.ChartViewModel = exports.ChartView = exports.FileReaderUtil = exports.widgetsUtil = exports.PaginationContainer = exports.NavTabsPage = exports.CityTabsPage = exports.IndexTabsPageContainer = exports.PopContainer = exports.AttributesPopContainer = exports.Select = exports.DropDownBox = exports.CommonContainer = exports.MessageBox = exports.FileModel = exports.FileConfig = exports.FileTypes = undefined;

var _SuperMap = __webpack_require__(0);

var _REST = __webpack_require__(2);

var _commontypes = __webpack_require__(448);

var _format = __webpack_require__(445);

var _control = __webpack_require__(443);

var _iManager = __webpack_require__(441);

var _iPortal = __webpack_require__(432);

var _iServer = __webpack_require__(430);

var _online = __webpack_require__(357);

var _security = __webpack_require__(354);

var _thirdparty = __webpack_require__(350);

var _util = __webpack_require__(346);

var _style = __webpack_require__(343);

var _overlay = __webpack_require__(339);

var _widgets = __webpack_require__(323);

var _lang = __webpack_require__(308);

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
exports.FileTypes = _widgets.FileTypes;
exports.FileConfig = _widgets.FileConfig;
exports.FileModel = _widgets.FileModel;
exports.MessageBox = _widgets.MessageBox;
exports.CommonContainer = _widgets.CommonContainer;
exports.DropDownBox = _widgets.DropDownBox;
exports.Select = _widgets.Select;
exports.AttributesPopContainer = _widgets.AttributesPopContainer;
exports.PopContainer = _widgets.PopContainer;
exports.IndexTabsPageContainer = _widgets.IndexTabsPageContainer;
exports.CityTabsPage = _widgets.CityTabsPage;
exports.NavTabsPage = _widgets.NavTabsPage;
exports.PaginationContainer = _widgets.PaginationContainer;
exports.widgetsUtil = _widgets.widgetsUtil;
exports.FileReaderUtil = _widgets.FileReaderUtil;
exports.ChartView = _widgets.ChartView;
exports.ChartViewModel = _widgets.ChartViewModel;
exports.SuperMap = _SuperMap.SuperMap;
exports.DataFormat = _REST.DataFormat;
exports.ServerType = _REST.ServerType;
exports.GeometryType = _REST.GeometryType;
exports.QueryOption = _REST.QueryOption;
exports.JoinType = _REST.JoinType;
exports.EngineType = _REST.EngineType;
exports.MeasureMode = _REST.MeasureMode;
exports.SpatialRelationType = _REST.SpatialRelationType;
exports.DataReturnMode = _REST.DataReturnMode;
exports.Unit = _REST.Unit;
exports.BufferRadiusUnit = _REST.BufferRadiusUnit;
exports.SpatialQueryMode = _REST.SpatialQueryMode;
exports.ThemeGraphTextFormat = _REST.ThemeGraphTextFormat;
exports.ThemeGraphType = _REST.ThemeGraphType;
exports.GraphAxesTextDisplayMode = _REST.GraphAxesTextDisplayMode;
exports.GraduatedMode = _REST.GraduatedMode;
exports.RangeMode = _REST.RangeMode;
exports.ThemeType = _REST.ThemeType;
exports.ColorGradientType = _REST.ColorGradientType;
exports.TextAlignment = _REST.TextAlignment;
exports.FillGradientMode = _REST.FillGradientMode;
exports.SideType = _REST.SideType;
exports.AlongLineDirection = _REST.AlongLineDirection;
exports.LabelBackShape = _REST.LabelBackShape;
exports.LabelOverLengthMode = _REST.LabelOverLengthMode;
exports.DirectionType = _REST.DirectionType;
exports.OverlayOperationType = _REST.OverlayOperationType;
exports.SupplyCenterType = _REST.SupplyCenterType;
exports.TurnType = _REST.TurnType;
exports.BufferEndType = _REST.BufferEndType;
exports.SmoothMethod = _REST.SmoothMethod;
exports.SurfaceAnalystMethod = _REST.SurfaceAnalystMethod;
exports.ColorSpaceType = _REST.ColorSpaceType;
exports.ChartType = _REST.ChartType;
exports.EditType = _REST.EditType;
exports.TransferTactic = _REST.TransferTactic;
exports.TransferPreference = _REST.TransferPreference;
exports.GridType = _REST.GridType;
exports.ClientType = _REST.ClientType;
exports.LayerType = _REST.LayerType;
exports.UGCLayerType = _REST.UGCLayerType;
exports.StatisticMode = _REST.StatisticMode;
exports.PixelFormat = _REST.PixelFormat;
exports.SearchMode = _REST.SearchMode;
exports.SummaryType = _REST.SummaryType;
exports.InterpolationAlgorithmType = _REST.InterpolationAlgorithmType;
exports.VariogramMode = _REST.VariogramMode;
exports.Exponent = _REST.Exponent;
exports.ClipAnalystMode = _REST.ClipAnalystMode;
exports.AnalystAreaUnit = _REST.AnalystAreaUnit;
exports.AnalystSizeUnit = _REST.AnalystSizeUnit;
exports.StatisticAnalystMode = _REST.StatisticAnalystMode;
exports.TopologyValidatorRule = _REST.TopologyValidatorRule;
exports.OutputType = _REST.OutputType;
exports.AggregationQueryBuilderType = _REST.AggregationQueryBuilderType;
exports.AggregationType = _REST.AggregationType;
exports.GetFeatureMode = _REST.GetFeatureMode;
exports.Collection = _commontypes.Collection;
exports.Curve = _commontypes.Curve;
exports.GeoText = _commontypes.GeoText;
exports.LinearRing = _commontypes.LinearRing;
exports.LineString = _commontypes.LineString;
exports.MultiLineString = _commontypes.MultiLineString;
exports.MultiPoint = _commontypes.MultiPoint;
exports.MultiPolygon = _commontypes.MultiPolygon;
exports.GeometryPoint = _commontypes.GeometryPoint;
exports.Polygon = _commontypes.Polygon;
exports.Rectangle = _commontypes.Rectangle;
exports.StringExt = _commontypes.StringExt;
exports.NumberExt = _commontypes.NumberExt;
exports.FunctionExt = _commontypes.FunctionExt;
exports.ArrayExt = _commontypes.ArrayExt;
exports.Bounds = _commontypes.Bounds;
exports.Credential = _commontypes.Credential;
exports.DateExt = _commontypes.DateExt;
exports.Event = _commontypes.Event;
exports.Events = _commontypes.Events;
exports.Feature = _commontypes.Feature;
exports.Geometry = _commontypes.Geometry;
exports.LonLat = _commontypes.LonLat;
exports.Pixel = _commontypes.Pixel;
exports.Size = _commontypes.Size;
exports.CommonUtil = _commontypes.CommonUtil;
exports.GeometryVector = _commontypes.GeometryVector;
exports.TimeControlBase = _control.TimeControlBase;
exports.TimeFlowControl = _control.TimeFlowControl;
exports.Format = _format.Format;
exports.GeoJSON = _format.GeoJSON;
exports.JSONFormat = _format.JSONFormat;
exports.WKT = _format.WKT;
exports.setCORS = _util.setCORS;
exports.isCORS = _util.isCORS;
exports.setRequestTimeout = _util.setRequestTimeout;
exports.getRequestTimeout = _util.getRequestTimeout;
exports.FetchRequest = _util.FetchRequest;
exports.ColorsPickerUtil = _util.ColorsPickerUtil;
exports.ArrayStatistic = _util.ArrayStatistic;
exports.IManager = _iManager.IManager;
exports.IManagerCreateNodeParam = _iManager.IManagerCreateNodeParam;
exports.IManagerServiceBase = _iManager.IManagerServiceBase;
exports.IPortal = _iPortal.IPortal;
exports.IPortalMap = _iPortal.IPortalMap;
exports.IPortalMapsQueryParam = _iPortal.IPortalMapsQueryParam;
exports.IPortalService = _iPortal.IPortalService;
exports.IPortalServiceBase = _iPortal.IPortalServiceBase;
exports.IPortalServicesQueryParam = _iPortal.IPortalServicesQueryParam;
exports.AddressMatchService = _iServer.AddressMatchService;
exports.AggregationParameter = _iServer.AggregationParameter;
exports.AggQueryBuilderParameter = _iServer.AggQueryBuilderParameter;
exports.AreaSolarRadiationParameters = _iServer.AreaSolarRadiationParameters;
exports.AreaSolarRadiationService = _iServer.AreaSolarRadiationService;
exports.BufferAnalystParameters = _iServer.BufferAnalystParameters;
exports.BufferAnalystService = _iServer.BufferAnalystService;
exports.BufferDistance = _iServer.BufferDistance;
exports.BufferSetting = _iServer.BufferSetting;
exports.BuffersAnalystJobsParameter = _iServer.BuffersAnalystJobsParameter;
exports.BuffersAnalystJobsService = _iServer.BuffersAnalystJobsService;
exports.BurstPipelineAnalystParameters = _iServer.BurstPipelineAnalystParameters;
exports.BurstPipelineAnalystService = _iServer.BurstPipelineAnalystService;
exports.ChartFeatureInfoSpecsService = _iServer.ChartFeatureInfoSpecsService;
exports.ChartQueryFilterParameter = _iServer.ChartQueryFilterParameter;
exports.ChartQueryParameters = _iServer.ChartQueryParameters;
exports.ChartQueryService = _iServer.ChartQueryService;
exports.ClipParameter = _iServer.ClipParameter;
exports.ColorDictionary = _iServer.ColorDictionary;
exports.CommonServiceBase = _iServer.CommonServiceBase;
exports.ComputeWeightMatrixParameters = _iServer.ComputeWeightMatrixParameters;
exports.ComputeWeightMatrixService = _iServer.ComputeWeightMatrixService;
exports.DataFlowService = _iServer.DataFlowService;
exports.DataReturnOption = _iServer.DataReturnOption;
exports.DatasetBufferAnalystParameters = _iServer.DatasetBufferAnalystParameters;
exports.DatasetInfo = _iServer.DatasetInfo;
exports.DatasetOverlayAnalystParameters = _iServer.DatasetOverlayAnalystParameters;
exports.DatasetSurfaceAnalystParameters = _iServer.DatasetSurfaceAnalystParameters;
exports.DatasetThiessenAnalystParameters = _iServer.DatasetThiessenAnalystParameters;
exports.DatasourceConnectionInfo = _iServer.DatasourceConnectionInfo;
exports.DensityAnalystService = _iServer.DensityAnalystService;
exports.DensityKernelAnalystParameters = _iServer.DensityKernelAnalystParameters;
exports.EditFeaturesParameters = _iServer.EditFeaturesParameters;
exports.EditFeaturesService = _iServer.EditFeaturesService;
exports.FacilityAnalyst3DParameters = _iServer.FacilityAnalyst3DParameters;
exports.FacilityAnalystSinks3DParameters = _iServer.FacilityAnalystSinks3DParameters;
exports.FacilityAnalystSinks3DService = _iServer.FacilityAnalystSinks3DService;
exports.FacilityAnalystSources3DParameters = _iServer.FacilityAnalystSources3DParameters;
exports.FacilityAnalystSources3DService = _iServer.FacilityAnalystSources3DService;
exports.FacilityAnalystStreamParameters = _iServer.FacilityAnalystStreamParameters;
exports.FacilityAnalystStreamService = _iServer.FacilityAnalystStreamService;
exports.FacilityAnalystTracedown3DParameters = _iServer.FacilityAnalystTracedown3DParameters;
exports.FacilityAnalystTracedown3DService = _iServer.FacilityAnalystTracedown3DService;
exports.FacilityAnalystTraceup3DParameters = _iServer.FacilityAnalystTraceup3DParameters;
exports.FacilityAnalystTraceup3DService = _iServer.FacilityAnalystTraceup3DService;
exports.FacilityAnalystUpstream3DParameters = _iServer.FacilityAnalystUpstream3DParameters;
exports.FacilityAnalystUpstream3DService = _iServer.FacilityAnalystUpstream3DService;
exports.FieldParameters = _iServer.FieldParameters;
exports.FieldStatisticService = _iServer.FieldStatisticService;
exports.FieldStatisticsParameters = _iServer.FieldStatisticsParameters;
exports.FilterAggParameter = _iServer.FilterAggParameter;
exports.FilterParameter = _iServer.FilterParameter;
exports.FindClosestFacilitiesParameters = _iServer.FindClosestFacilitiesParameters;
exports.FindClosestFacilitiesService = _iServer.FindClosestFacilitiesService;
exports.FindLocationParameters = _iServer.FindLocationParameters;
exports.FindLocationService = _iServer.FindLocationService;
exports.FindMTSPPathsParameters = _iServer.FindMTSPPathsParameters;
exports.FindMTSPPathsService = _iServer.FindMTSPPathsService;
exports.FindPathParameters = _iServer.FindPathParameters;
exports.FindPathService = _iServer.FindPathService;
exports.FindServiceAreasParameters = _iServer.FindServiceAreasParameters;
exports.FindServiceAreasService = _iServer.FindServiceAreasService;
exports.FindTSPPathsParameters = _iServer.FindTSPPathsParameters;
exports.FindTSPPathsService = _iServer.FindTSPPathsService;
exports.GenerateSpatialDataParameters = _iServer.GenerateSpatialDataParameters;
exports.GenerateSpatialDataService = _iServer.GenerateSpatialDataService;
exports.GeoBoundingBoxQueryBuilderParameter = _iServer.GeoBoundingBoxQueryBuilderParameter;
exports.GeoCodingParameter = _iServer.GeoCodingParameter;
exports.GeoDecodingParameter = _iServer.GeoDecodingParameter;
exports.GeoHashGridAggParameter = _iServer.GeoHashGridAggParameter;
exports.GeometryBufferAnalystParameters = _iServer.GeometryBufferAnalystParameters;
exports.GeometryOverlayAnalystParameters = _iServer.GeometryOverlayAnalystParameters;
exports.GeometrySurfaceAnalystParameters = _iServer.GeometrySurfaceAnalystParameters;
exports.GeometryThiessenAnalystParameters = _iServer.GeometryThiessenAnalystParameters;
exports.GeoRelationAnalystParameters = _iServer.GeoRelationAnalystParameters;
exports.GeoRelationAnalystService = _iServer.GeoRelationAnalystService;
exports.GetFeaturesByBoundsParameters = _iServer.GetFeaturesByBoundsParameters;
exports.GetFeaturesByBoundsService = _iServer.GetFeaturesByBoundsService;
exports.GetFeaturesByBufferParameters = _iServer.GetFeaturesByBufferParameters;
exports.GetFeaturesByBufferService = _iServer.GetFeaturesByBufferService;
exports.GetFeaturesByGeometryParameters = _iServer.GetFeaturesByGeometryParameters;
exports.GetFeaturesByGeometryService = _iServer.GetFeaturesByGeometryService;
exports.GetFeaturesByIDsParameters = _iServer.GetFeaturesByIDsParameters;
exports.GetFeaturesByIDsService = _iServer.GetFeaturesByIDsService;
exports.GetFeaturesBySQLParameters = _iServer.GetFeaturesBySQLParameters;
exports.GetFeaturesBySQLService = _iServer.GetFeaturesBySQLService;
exports.GetFeaturesParametersBase = _iServer.GetFeaturesParametersBase;
exports.GetFeaturesServiceBase = _iServer.GetFeaturesServiceBase;
exports.GetFieldsService = _iServer.GetFieldsService;
exports.GetGridCellInfosParameters = _iServer.GetGridCellInfosParameters;
exports.GetGridCellInfosService = _iServer.GetGridCellInfosService;
exports.GetLayersInfoService = _iServer.GetLayersInfoService;
exports.Grid = _iServer.Grid;
exports.UGCImage = _iServer.UGCImage;
exports.InterpolationAnalystParameters = _iServer.InterpolationAnalystParameters;
exports.InterpolationAnalystService = _iServer.InterpolationAnalystService;
exports.InterpolationIDWAnalystParameters = _iServer.InterpolationIDWAnalystParameters;
exports.InterpolationKrigingAnalystParameters = _iServer.InterpolationKrigingAnalystParameters;
exports.InterpolationRBFAnalystParameters = _iServer.InterpolationRBFAnalystParameters;
exports.JoinItem = _iServer.JoinItem;
exports.KernelDensityJobParameter = _iServer.KernelDensityJobParameter;
exports.KernelDensityJobsService = _iServer.KernelDensityJobsService;
exports.LabelImageCell = _iServer.LabelImageCell;
exports.LabelMatrixCell = _iServer.LabelMatrixCell;
exports.LabelMixedTextStyle = _iServer.LabelMixedTextStyle;
exports.LabelSymbolCell = _iServer.LabelSymbolCell;
exports.LabelThemeCell = _iServer.LabelThemeCell;
exports.LayerStatus = _iServer.LayerStatus;
exports.LinkItem = _iServer.LinkItem;
exports.MapService = _iServer.MapService;
exports.MathExpressionAnalysisParameters = _iServer.MathExpressionAnalysisParameters;
exports.MathExpressionAnalysisService = _iServer.MathExpressionAnalysisService;
exports.MeasureParameters = _iServer.MeasureParameters;
exports.MeasureService = _iServer.MeasureService;
exports.NetworkAnalystServiceBase = _iServer.NetworkAnalystServiceBase;
exports.OutputSetting = _iServer.OutputSetting;
exports.MappingParameters = _iServer.MappingParameters;
exports.OverlapDisplayedOptions = _iServer.OverlapDisplayedOptions;
exports.OverlayAnalystParameters = _iServer.OverlayAnalystParameters;
exports.OverlayAnalystService = _iServer.OverlayAnalystService;
exports.OverlayGeoJobParameter = _iServer.OverlayGeoJobParameter;
exports.OverlayGeoJobsService = _iServer.OverlayGeoJobsService;
exports.PointWithMeasure = _iServer.PointWithMeasure;
exports.ProcessingServiceBase = _iServer.ProcessingServiceBase;
exports.QueryByBoundsParameters = _iServer.QueryByBoundsParameters;
exports.QueryByBoundsService = _iServer.QueryByBoundsService;
exports.QueryByDistanceParameters = _iServer.QueryByDistanceParameters;
exports.QueryByDistanceService = _iServer.QueryByDistanceService;
exports.QueryByGeometryParameters = _iServer.QueryByGeometryParameters;
exports.QueryByGeometryService = _iServer.QueryByGeometryService;
exports.QueryBySQLParameters = _iServer.QueryBySQLParameters;
exports.QueryBySQLService = _iServer.QueryBySQLService;
exports.QueryParameters = _iServer.QueryParameters;
exports.QueryService = _iServer.QueryService;
exports.Route = _iServer.Route;
exports.RouteCalculateMeasureParameters = _iServer.RouteCalculateMeasureParameters;
exports.RouteCalculateMeasureService = _iServer.RouteCalculateMeasureService;
exports.RouteLocatorParameters = _iServer.RouteLocatorParameters;
exports.RouteLocatorService = _iServer.RouteLocatorService;
exports.ServerColor = _iServer.ServerColor;
exports.ServerFeature = _iServer.ServerFeature;
exports.ServerGeometry = _iServer.ServerGeometry;
exports.ServerStyle = _iServer.ServerStyle;
exports.ServerTextStyle = _iServer.ServerTextStyle;
exports.ServerTheme = _iServer.ServerTheme;
exports.SetLayerInfoParameters = _iServer.SetLayerInfoParameters;
exports.SetLayerInfoService = _iServer.SetLayerInfoService;
exports.SetLayersInfoParameters = _iServer.SetLayersInfoParameters;
exports.SetLayersInfoService = _iServer.SetLayersInfoService;
exports.SetLayerStatusParameters = _iServer.SetLayerStatusParameters;
exports.SetLayerStatusService = _iServer.SetLayerStatusService;
exports.SingleObjectQueryJobsParameter = _iServer.SingleObjectQueryJobsParameter;
exports.SingleObjectQueryJobsService = _iServer.SingleObjectQueryJobsService;
exports.SpatialAnalystBase = _iServer.SpatialAnalystBase;
exports.StopQueryParameters = _iServer.StopQueryParameters;
exports.StopQueryService = _iServer.StopQueryService;
exports.SummaryAttributesJobsParameter = _iServer.SummaryAttributesJobsParameter;
exports.SummaryAttributesJobsService = _iServer.SummaryAttributesJobsService;
exports.SummaryMeshJobParameter = _iServer.SummaryMeshJobParameter;
exports.SummaryMeshJobsService = _iServer.SummaryMeshJobsService;
exports.SummaryRegionJobParameter = _iServer.SummaryRegionJobParameter;
exports.SummaryRegionJobsService = _iServer.SummaryRegionJobsService;
exports.SupplyCenter = _iServer.SupplyCenter;
exports.SurfaceAnalystParameters = _iServer.SurfaceAnalystParameters;
exports.SurfaceAnalystParametersSetting = _iServer.SurfaceAnalystParametersSetting;
exports.SurfaceAnalystService = _iServer.SurfaceAnalystService;
exports.TerrainCurvatureCalculationParameters = _iServer.TerrainCurvatureCalculationParameters;
exports.TerrainCurvatureCalculationService = _iServer.TerrainCurvatureCalculationService;
exports.Theme = _iServer.Theme;
exports.ThemeDotDensity = _iServer.ThemeDotDensity;
exports.ThemeFlow = _iServer.ThemeFlow;
exports.ThemeGraduatedSymbol = _iServer.ThemeGraduatedSymbol;
exports.ThemeGraduatedSymbolStyle = _iServer.ThemeGraduatedSymbolStyle;
exports.ThemeGraph = _iServer.ThemeGraph;
exports.ThemeGraphAxes = _iServer.ThemeGraphAxes;
exports.ThemeGraphItem = _iServer.ThemeGraphItem;
exports.ThemeGraphSize = _iServer.ThemeGraphSize;
exports.ThemeGraphText = _iServer.ThemeGraphText;
exports.ThemeGridRange = _iServer.ThemeGridRange;
exports.ThemeGridRangeItem = _iServer.ThemeGridRangeItem;
exports.ThemeGridUnique = _iServer.ThemeGridUnique;
exports.ThemeGridUniqueItem = _iServer.ThemeGridUniqueItem;
exports.ThemeLabel = _iServer.ThemeLabel;
exports.ThemeLabelAlongLine = _iServer.ThemeLabelAlongLine;
exports.ThemeLabelBackground = _iServer.ThemeLabelBackground;
exports.ThemeLabelItem = _iServer.ThemeLabelItem;
exports.ThemeLabelText = _iServer.ThemeLabelText;
exports.ThemeLabelUniqueItem = _iServer.ThemeLabelUniqueItem;
exports.ThemeMemoryData = _iServer.ThemeMemoryData;
exports.ThemeOffset = _iServer.ThemeOffset;
exports.ThemeParameters = _iServer.ThemeParameters;
exports.ThemeRange = _iServer.ThemeRange;
exports.ThemeRangeItem = _iServer.ThemeRangeItem;
exports.ThemeService = _iServer.ThemeService;
exports.ThemeUnique = _iServer.ThemeUnique;
exports.ThemeUniqueItem = _iServer.ThemeUniqueItem;
exports.ThiessenAnalystParameters = _iServer.ThiessenAnalystParameters;
exports.ThiessenAnalystService = _iServer.ThiessenAnalystService;
exports.GeometryBatchAnalystService = _iServer.GeometryBatchAnalystService;
exports.TilesetsService = _iServer.TilesetsService;
exports.TopologyValidatorJobsParameter = _iServer.TopologyValidatorJobsParameter;
exports.TopologyValidatorJobsService = _iServer.TopologyValidatorJobsService;
exports.TransferLine = _iServer.TransferLine;
exports.TransferPathParameters = _iServer.TransferPathParameters;
exports.TransferPathService = _iServer.TransferPathService;
exports.TransferSolutionService = _iServer.TransferSolutionService;
exports.TransportationAnalystParameter = _iServer.TransportationAnalystParameter;
exports.TransportationAnalystResultSetting = _iServer.TransportationAnalystResultSetting;
exports.TransferSolutionParameters = _iServer.TransferSolutionParameters;
exports.UGCLayer = _iServer.UGCLayer;
exports.UGCMapLayer = _iServer.UGCMapLayer;
exports.UGCSubLayer = _iServer.UGCSubLayer;
exports.UpdateEdgeWeightParameters = _iServer.UpdateEdgeWeightParameters;
exports.UpdateEdgeWeightService = _iServer.UpdateEdgeWeightService;
exports.UpdateTurnNodeWeightParameters = _iServer.UpdateTurnNodeWeightParameters;
exports.UpdateTurnNodeWeightService = _iServer.UpdateTurnNodeWeightService;
exports.Vector = _iServer.Vector;
exports.VectorClipJobsParameter = _iServer.VectorClipJobsParameter;
exports.VectorClipJobsService = _iServer.VectorClipJobsService;
exports.Online = _online.Online;
exports.OnlineData = _online.OnlineData;
exports.OnlineQueryDatasParameter = _online.OnlineQueryDatasParameter;
exports.ServiceStatus = _online.ServiceStatus;
exports.DataItemType = _online.DataItemType;
exports.DataItemOrderBy = _online.DataItemOrderBy;
exports.FilterField = _online.FilterField;
exports.OnlineServiceBase = _online.OnlineServiceBase;
exports.Bar = _overlay.Bar;
exports.Bar3D = _overlay.Bar3D;
exports.Circle = _overlay.Circle;
exports.Graph = _overlay.Graph;
exports.Line = _overlay.Line;
exports.Pie = _overlay.Pie;
exports.OverlayPoint = _overlay.OverlayPoint;
exports.RankSymbol = _overlay.RankSymbol;
exports.Ring = _overlay.Ring;
exports.ThemeVector = _overlay.ThemeVector;
exports.ShapeFactory = _overlay.ShapeFactory;
exports.ShapeParameters = _overlay.ShapeParameters;
exports.FeatureCircle = _overlay.FeatureCircle;
exports.Image = _overlay.Image;
exports.Label = _overlay.Label;
exports.FeatureLine = _overlay.FeatureLine;
exports.Point = _overlay.Point;
exports.FeaturePolygon = _overlay.FeaturePolygon;
exports.FeatureRectangle = _overlay.FeatureRectangle;
exports.Sector = _overlay.Sector;
exports.FeatureTheme = _overlay.FeatureTheme;
exports.LevelRenderer = _overlay.LevelRenderer;
exports.Render = _overlay.Render;
exports.Animation = _overlay.Animation;
exports.Animator = _overlay.Animator;
exports.Area = _overlay.Area;
exports.Clip = _overlay.Clip;
exports.Color = _overlay.Color;
exports.ComputeBoundingBox = _overlay.ComputeBoundingBox;
exports.Config = _overlay.Config;
exports.LevelRendererCurve = _overlay.LevelRendererCurve;
exports.Easing = _overlay.Easing;
exports.Env = _overlay.Env;
exports.LevelRendererEvent = _overlay.LevelRendererEvent;
exports.Eventful = _overlay.Eventful;
exports.Group = _overlay.Group;
exports.Handler = _overlay.Handler;
exports.Http = _overlay.Http;
exports.Log = _overlay.Log;
exports.Math = _overlay.Math;
exports.Matrix = _overlay.Matrix;
exports.Painter = _overlay.Painter;
exports.PaintLayer = _overlay.PaintLayer;
exports.Shape = _overlay.Shape;
exports.SmicBrokenLine = _overlay.SmicBrokenLine;
exports.SmicCircle = _overlay.SmicCircle;
exports.SmicEllipse = _overlay.SmicEllipse;
exports.SmicImage = _overlay.SmicImage;
exports.SmicIsogon = _overlay.SmicIsogon;
exports.SmicPoint = _overlay.SmicPoint;
exports.SmicPolygon = _overlay.SmicPolygon;
exports.SmicRectangle = _overlay.SmicRectangle;
exports.SmicRing = _overlay.SmicRing;
exports.SmicSector = _overlay.SmicSector;
exports.SmicStar = _overlay.SmicStar;
exports.SmicText = _overlay.SmicText;
exports.Storage = _overlay.Storage;
exports.Transformable = _overlay.Transformable;
exports.Util = _overlay.Util;
exports.LevelRendererVector = _overlay.LevelRendererVector;
exports.SUtil = _overlay.SUtil;
exports.KeyServiceParameter = _security.KeyServiceParameter;
exports.SecurityManager = _security.SecurityManager;
exports.ServerInfo = _security.ServerInfo;
exports.TokenServiceParameter = _security.TokenServiceParameter;
exports.CartoCSS = _style.CartoCSS;
exports.ThemeStyle = _style.ThemeStyle;
exports.ElasticSearch = _thirdparty.ElasticSearch;
exports.Lang = _lang.Lang;
exports.en = _lang.en;
exports.zh = _lang.zh;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CommonServiceBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _FetchRequest = __webpack_require__(16);

var _Events = __webpack_require__(42);

var _Credential = __webpack_require__(108);

var _SecurityManager = __webpack_require__(37);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

var _JSON = __webpack_require__(106);

var _BaseTypes = __webpack_require__(52);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.CommonServiceBase
 * @category  iServer
 * @classdesc 对接 iServer 各种服务的 Service 的基类。
 * @param {string} url - 服务地址。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。
 * @param {string} [options.proxy] - 服务代理地址。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
 */
var CommonServiceBase = exports.CommonServiceBase = function () {
    function CommonServiceBase(url, options) {
        _classCallCheck(this, CommonServiceBase);

        var me = this;

        this.EVENT_TYPES = ["processCompleted", "processFailed"];

        this.events = null;

        this.eventListeners = null;

        this.url = null;

        this.urls = null;

        this.proxy = null;

        this.serverType = null;

        this.index = null;

        this.length = null;

        this.options = null;

        this.totalTimes = null;

        this.POLLING_TIMES = 3;

        this._processSuccess = null;

        this._processFailed = null;

        this.isInTheSameDomain = null;

        this.withCredentials = false;

        if (_Util.Util.isArray(url)) {
            me.urls = url;
            me.length = url.length;
            me.totalTimes = me.length;
            if (me.length === 1) {
                me.url = url[0];
            } else {
                me.index = parseInt(Math.random() * me.length);
                me.url = url[me.index];
            }
        } else {
            me.totalTimes = 1;
            me.url = url;
        }

        if (_Util.Util.isArray(url) && !me.isServiceSupportPolling()) {
            me.url = url[0];
            me.totalTimes = 1;
        }

        me.serverType = me.serverType || _REST.ServerType.ISERVER;

        options = options || {};

        _Util.Util.extend(this, options);

        me.isInTheSameDomain = _Util.Util.isInTheSameDomain(me.url);

        me.events = new _Events.Events(me, null, me.EVENT_TYPES, true);
        if (me.eventListeners instanceof Object) {
            me.events.on(me.eventListeners);
        }

        this.CLASS_NAME = "SuperMap.CommonServiceBase";
    }

    /**
     * @function SuperMap.CommonServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    _createClass(CommonServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (_Util.Util.isArray(me.urls)) {
                me.urls = null;
                me.index = null;
                me.length = null;
                me.totalTimes = null;
            }
            me.url = null;
            me.options = null;
            me._processSuccess = null;
            me._processFailed = null;
            me.isInTheSameDomain = null;

            me.EVENT_TYPES = null;
            if (me.events) {
                me.events.destroy();
                me.events = null;
            }
            if (me.eventListeners) {
                me.eventListeners = null;
            }
        }

        /**
         * @function  SuperMap.CommonServiceBase.prototype.request
         * @description: 该方法用于向服务发送请求。
         * @param {Object} options - 参数。
         * @param {string} [options.method='GET'] - 请求方式，包括 "GET"，"POST"，"PUT"，"DELETE"。
         * @param {string} [options.url] - 发送请求的地址。
         * @param {Object} [options.params] - 作为查询字符串添加到 URL 中的一组键值对，此参数只适用于 GET 方式发送的请求。
         * @param {string} [options.data] - 发送到服务器的数据。
         * @param {function} options.success - 请求成功后的回调函数。
         * @param {function} options.failure - 请求失败后的回调函数。
         * @param {Object} [options.scope] - 如果回调函数是对象的一个公共方法，设定该对象的范围。
         * @param {boolean} [options.isInTheSameDomain] - 请求是否在当前域中。
         * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
         */

    }, {
        key: 'request',
        value: function request(options) {
            var me = this;
            options.url = options.url || me.url;
            options.proxy = options.proxy || me.proxy;
            options.withCredentials = options.withCredentials != undefined ? options.withCredentials : me.withCredentials;
            options.isInTheSameDomain = me.isInTheSameDomain;
            //为url添加安全认证信息片段
            var credential = this.getCredential(options.url);
            if (credential) {
                //当url中含有?，并且?在url末尾的时候直接添加token *网络分析等服务请求url会出现末尾是?的情况*
                //当url中含有?，并且?不在url末尾的时候添加&token
                //当url中不含有?，在url末尾添加?token
                var endStr = options.url.substring(options.url.length - 1, options.url.length);
                if (options.url.indexOf("?") > -1 && endStr === "?") {
                    options.url += credential.getUrlParameters();
                } else if (options.url.indexOf("?") > -1 && endStr !== "?") {
                    options.url += "&" + credential.getUrlParameters();
                } else {
                    options.url += "?" + credential.getUrlParameters();
                }
            }

            me.calculatePollingTimes();
            me._processSuccess = options.success;
            me._processFailed = options.failure;
            options.scope = me;
            options.success = me.getUrlCompleted;
            options.failure = me.getUrlFailed;
            me.options = options;
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getCredential
         * @description  获取凭据信息
         * @param {string} url - 服务地址。
         * @returns {SuperMap.Credential} 凭据信息对象。
         */

    }, {
        key: 'getCredential',
        value: function getCredential(url) {
            var keyUrl = url,
                credential = void 0,
                value = void 0;
            switch (this.serverType) {
                case _REST.ServerType.IPORTAL:
                    value = _SecurityManager.SecurityManager.getToken(keyUrl);
                    credential = value ? new _Credential.Credential(value, "token") : null;
                    if (!credential) {
                        value = _SecurityManager.SecurityManager.getKey(keyUrl);
                        credential = value ? new _Credential.Credential(value, "key") : null;
                    }
                    break;
                case _REST.ServerType.ONLINE:
                    value = _SecurityManager.SecurityManager.getKey(keyUrl);
                    credential = value ? new _Credential.Credential(value, "key") : null;
                    break;
                default:
                    //iServer or others
                    value = _SecurityManager.SecurityManager.getToken(keyUrl);
                    credential = value ? new _Credential.Credential(value, "token") : null;
                    break;
            }
            return credential;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlCompleted
         * @description 请求成功后执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlCompleted',
        value: function getUrlCompleted(result) {
            var me = this;
            me._processSuccess(result);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlFailed
         * @description 请求失败后执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlFailed',
        value: function getUrlFailed(result) {
            var me = this;
            if (me.totalTimes > 0) {
                me.totalTimes--;
                me.ajaxPolling();
            } else {
                me._processFailed(result);
            }
        }

        /**
         *
         * @function SuperMap.CommonServiceBase.prototype.ajaxPolling
         * @description 请求失败后，如果剩余请求失败次数不为 0，重新获取 URL 发送请求
         */

    }, {
        key: 'ajaxPolling',
        value: function ajaxPolling() {
            var me = this,
                url = me.options.url,
                re = /^http:\/\/([a-z]{9}|(\d+\.){3}\d+):\d{0,4}/;
            me.index = parseInt(Math.random() * me.length);
            me.url = me.urls[me.index];
            url = url.replace(re, re.exec(me.url)[0]);
            me.options.url = url;
            me.options.isInTheSameDomain = _Util.Util.isInTheSameDomain(url);
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.calculatePollingTimes
         * @description 计算剩余请求失败执行次数。
         */

    }, {
        key: 'calculatePollingTimes',
        value: function calculatePollingTimes() {
            var me = this;
            if (me.times) {
                if (me.totalTimes > me.POLLING_TIMES) {
                    if (me.times > me.POLLING_TIMES) {
                        me.totalTimes = me.POLLING_TIMES;
                    } else {
                        me.totalTimes = me.times;
                    }
                } else {
                    if (me.times < me.totalTimes) {
                        me.totalTimes = me.times;
                    }
                }
            } else {
                if (me.totalTimes > me.POLLING_TIMES) {
                    me.totalTimes = me.POLLING_TIMES;
                }
            }
            me.totalTimes--;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.isServiceSupportPolling
         * @description 判断服务是否支持轮询。
         */

    }, {
        key: 'isServiceSupportPolling',
        value: function isServiceSupportPolling() {
            var me = this;
            return !(me.CLASS_NAME === "SuperMap.REST.ThemeService" || me.CLASS_NAME === "SuperMap.REST.EditFeaturesService");
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessCompleted
         * @description 状态完成，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            result = _Util.Util.transformResult(result);
            this.events.triggerEvent("processCompleted", {
                result: result
            });
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessFailed
         * @description 状态失败，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            result = _Util.Util.transformResult(result);
            var error = result.error || result;
            this.events.triggerEvent("processFailed", {
                error: error
            });
        }
    }, {
        key: '_commit',
        value: function _commit(options) {
            if (options.method === "POST" || options.method === "PUT") {
                if (options.params) {
                    options.url = _Util.Util.urlAppend(options.url, _Util.Util.getParameterString(options.params || {}));
                }
                options.params = options.data;
            }
            _FetchRequest.FetchRequest.commit(options.method, options.url, options.params, {
                headers: options.headers,
                withCredentials: options.withCredentials,
                timeout: options.async ? 0 : null,
                proxy: options.proxy
            }).then(function (response) {
                if (response.text) {
                    return response.text();
                }
                if (response.json) {
                    return response.json();
                }
                return response;
            }).then(function (text) {
                var result = text;
                if (typeof text === "string") {
                    result = new _JSON.JSONFormat().read(text);
                }
                if (!result || result.error || result.code >= 300 && result.code !== 304) {
                    if (result && result.error) {
                        result = {
                            error: result.error
                        };
                    } else {
                        result = {
                            error: result
                        };
                    }
                }
                if (result.error) {
                    var failure = options.scope ? _BaseTypes.FunctionExt.bind(options.failure, options.scope) : options.failure;
                    failure(result);
                } else {
                    result.succeed = result.succeed == undefined ? true : result.succeed;
                    var success = options.scope ? _BaseTypes.FunctionExt.bind(options.success, options.scope) : options.success;
                    success(result);
                }
            }).catch(function (e) {
                var failure = options.scope ? _BaseTypes.FunctionExt.bind(options.failure, options.scope) : options.failure;
                failure(e);
            });
        }
    }]);

    return CommonServiceBase;
}();

_SuperMap.SuperMap.CommonServiceBase = CommonServiceBase;

/**
 * 服务器请求回调函数
 * @callback RequestCallback
 * @example
 * var requestCallback = function (serviceResult){
 *      console.log(serviceResult.result);
 * }
 * new QueryService(url).queryByBounds(param, requestCallback);
 * @param {Object} serviceResult
 * @param {Object} serviceResult.result 服务器返回结果。
 * @param {Object} serviceResult.object 发布应用程序事件的对象。
 * @param {Object} serviceResult.type 事件类型。
 * @param {Object} serviceResult.element 接受浏览器事件的 DOM 节点。
 */

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceBase = undefined;

var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class mapboxgl.supermap.ServiceBase
 * @category  iServer
 * @description mapboxgl.supermap 服务基类。
 * @param {string} url - 与客户端交互的服务地址。 
 * @param {Object} options - 可选参数。
 * @param {string} [options.proxy] - 服务代理地址。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务来源 iServer|iPortal|online。
 * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
 * @fires mapboxgl.supermap.ServiceBase#initialized
 */
var ServiceBase = exports.ServiceBase = function (_mapboxgl$Evented) {
  _inherits(ServiceBase, _mapboxgl$Evented);

  function ServiceBase(url, options) {
    _classCallCheck(this, ServiceBase);

    var _this = _possibleConstructorReturn(this, (ServiceBase.__proto__ || Object.getPrototypeOf(ServiceBase)).call(this));

    _this.options = options || {};
    _this.url = url;
    /**
     * @event mapboxgl.supermap.ServiceBase#initialized
     * @description 构造函数构造成功之后触发。
     * @property {Object} this - this 对象。
     */
    _this.fire('initialized', _this);
    return _this;
  }

  return ServiceBase;
}(_mapboxGl2.default.Evented);

_mapboxGl2.default.supermap.ServiceBase = ServiceBase;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ServerGeometry = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Point = __webpack_require__(23);

var _MultiPoint = __webpack_require__(43);

var _LinearRing = __webpack_require__(38);

var _LineString = __webpack_require__(22);

var _MultiLineString = __webpack_require__(51);

var _Polygon = __webpack_require__(49);

var _MultiPolygon = __webpack_require__(50);

var _ServerStyle = __webpack_require__(13);

var _Route = __webpack_require__(74);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerGeometry
 * @category  iServer  
 * @classdesc 服务端几何对象类。该类描述几何对象（矢量）的特征数据（坐标点对、几何对象的类型等）。基于服务端的空间分析、空间关系运算、查询等 GIS 服务功能使用服务端几何对象。
 * @param {Object} options - 参数。
 * @param {string} options.id - 服务端几何对象唯一标识符。
 * @param {Array.<number>} options.parts - 服务端几何对象中各个子对象所包含的节点个数。
 * @param {Array.<SuperMap.Geometry.Point>} options.points - 组成几何对象的节点的坐标对数组。
 * @param {SuperMap.GeometryType} options.type - 几何对象的类型。
 * @param {SuperMap.ServerStyle} [options.style] - 服务端几何对象的风格。
 */
var ServerGeometry = exports.ServerGeometry = function () {
    function ServerGeometry(options) {
        _classCallCheck(this, ServerGeometry);

        /**
         * @member {string} SuperMap.ServerGeometry.prototype.id
         * @description 服务端几何对象唯一标识符。
         */
        this.id = 0;

        /**
         * @member {SuperMap.ServerStyle} [SuperMap.ServerGeometry.prototype.style]
         * @description 服务端几何对象的风格（ServerStyle）。
         */
        this.style = null;

        /**
         * @member {Array.<number>} SuperMap.ServerGeometry.prototype.parts
         * @description 服务端几何对象中各个子对象所包含的节点个数。<br>
         * 1.几何对象从结构上可以分为简单几何对象和复杂几何对象。
         * 简单几何对象与复杂几何对象的区别：简单的几何对象一般为单一对象，
         * 而复杂的几何对象由多个简单对象组成或经过一定的空间运算之后产生，
         * 如：矩形为简单的区域对象，而中空的矩形为复杂的区域对象。<br>
         * 2.通常情况，一个简单几何对象的子对象就是它本身，
         * 因此对于简单对象来说的该字段为长度为1的整型数组，
         * 该字段的值就是这个简单对象节点的个数。
         * 如果一个几何对象是由几个简单对象组合而成的，
         * 例如，一个岛状几何对象由 3 个简单的多边形组成而成，
         * 那么这个岛状的几何对象的 Parts 字段值就是一个长度为 3 的整型数组，
         * 数组中每个成员的值分别代表这三个多边形所包含的节点个数。
         */
        this.parts = null;

        /**
         * @member {Array.<SuperMap.Geometry.Point>} SuperMap.ServerGeometry.prototype.points
         * @description 组成几何对象的节点的坐标对数组。<br>
         * 1.所有几何对象（点、线、面）都是由一些简单的点坐标组成的，
         * 该字段存放了组成几何对象的点坐标的数组。
         * 对于简单的面对象，他的起点和终点的坐标点相同。<br>
         * 2.对于复杂的几何对象，根据 Parts 属性来确定每一个组成复杂几何对象的简单对象所对应的节点的个数，
         * 从而确定 Points 字段中坐标对的分配归属问题。
         */
        this.points = null;

        /**
         * @member {SuperMap.GeometryType} SuperMap.ServerGeometry.prototype.type
         * @description 几何对象的类型（GeometryType）。
         */
        this.type = null;

        /**
         * @member {Object} SuperMap.ServerGeometry.prototype.prjCoordSys
         * @description 投影坐标参数，现仅在缓冲区分析中有效。
         */
        this.prjCoordSys = null;
        if (options) {
            _Util.Util.extend(this, options);
        }

        this.CLASS_NAME = "SuperMap.ServerGeometry";
    }

    /**
     * @function SuperMap.ServerGeometry.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(ServerGeometry, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.id = null;
            me.style = null;
            me.parts = null;
            me.partTopo = null;
            me.points = null;
            me.type = null;
            me.prjCoordSys = null;
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeometry
         * @description 将服务端几何对象 ServerGeometry 转换为客户端几何对象 Geometry。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeometry',
        value: function toGeometry() {
            var me = this,
                geoType = me.type;
            switch (geoType.toUpperCase()) {
                case _REST.GeometryType.POINT:
                    return me.toGeoPoint();
                case _REST.GeometryType.LINE:
                    return me.toGeoLine();
                case _REST.GeometryType.LINEM:
                    return me.toGeoLinem();
                case _REST.GeometryType.REGION:
                    return me.toGeoRegion();
                case _REST.GeometryType.POINTEPS:
                    return me.toGeoPoint();
                case _REST.GeometryType.LINEEPS:
                    return me.toGeoLineEPS();
                case _REST.GeometryType.REGIONEPS:
                    return me.toGeoRegionEPS();
            }
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoPoint
         * @description 将服务端的点几何对象转换为客户端几何对象。包括 Point、MultiPoint。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoPoint',
        value: function toGeoPoint() {
            var me = this,
                geoParts = me.parts || [],
                geoPoints = me.points || [],
                len = geoParts.length;
            if (len > 0) {
                if (len === 1) {
                    return new _Point.Point(geoPoints[0].x, geoPoints[0].y);
                } else {
                    var pointList = [];
                    for (var i = 0; i < len; i++) {
                        pointList.push(new _Point.Point(geoPoints[i].x, geoPoints[i].y));
                    }
                    return new _MultiPoint.MultiPoint(pointList);
                }
            } else {
                return null;
            }
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoLine
         * @description 将服务端的线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoLine',
        value: function toGeoLine() {
            var me = this,
                geoParts = me.parts || [],
                geoPoints = me.points || [],
                len = geoParts.length;
            if (len > 0) {
                if (len === 1) {
                    var pointList = [];
                    for (var i = 0; i < geoParts[0]; i++) {
                        pointList.push(new _Point.Point(geoPoints[i].x, geoPoints[i].y));
                    }
                    //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                    if (pointList[0].equals(pointList[geoParts[0] - 1])) {
                        return new _LinearRing.LinearRing(pointList);
                    } else {
                        return new _LineString.LineString(pointList);
                    }
                } else {
                    var lineList = [];
                    for (var _i = 0; _i < len; _i++) {
                        var _pointList = [];
                        for (var j = 0; j < geoParts[_i]; j++) {
                            _pointList.push(new _Point.Point(geoPoints[j].x, geoPoints[j].y));
                        }
                        lineList.push(new _LineString.LineString(_pointList));
                        geoPoints.splice(0, geoParts[_i]);
                    }
                    return new _MultiLineString.MultiLineString(lineList);
                }
            } else {
                return null;
            }
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoLineEPS
         * @description 将服务端的线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoLineEPS',
        value: function toGeoLineEPS() {
            var me = this,
                geoParts = me.parts || [],
                geoPoints = me.points || [],
                i,
                j,
                pointList,
                lineList,
                lineEPS,
                len = geoParts.length;
            if (len > 0) {
                if (len === 1) {
                    for (i = 0, pointList = []; i < geoParts[0]; i++) {
                        pointList.push(new _Point.Point(geoPoints[i].x, geoPoints[i].y, geoPoints[i].type));
                    }
                    //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                    if (pointList[0].equals(pointList[geoParts[0] - 1])) {
                        lineEPS = _LineString.LineString.createLineEPS(pointList);
                        return new _LinearRing.LinearRing(lineEPS);
                    } else {
                        lineEPS = _LineString.LineString.createLineEPS(pointList);
                        return new _LineString.LineString(lineEPS);
                    }
                } else {
                    for (i = 0, lineList = []; i < len; i++) {
                        for (j = 0, pointList = []; j < geoParts[i]; j++) {
                            pointList.push(new _Point.Point(geoPoints[j].x, geoPoints[j].y));
                        }
                        lineEPS = _LineString.LineString.createLineEPS(pointList);
                        lineList.push(new _LineString.LineString(lineEPS));
                        geoPoints.splice(0, geoParts[i]);
                    }
                    return new _MultiLineString.MultiLineString(lineList);
                }
            } else {
                return null;
            }
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoLine
         * @description 将服务端的路由线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoLinem',
        value: function toGeoLinem() {
            var me = this;
            return _Route.Route.fromJson(me);
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoRegion
         * @description 将服务端的面几何对象转换为客户端几何对象。类型为 Polygon。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoRegion',
        value: function toGeoRegion() {
            var me = this,
                geoParts = me.parts || [],
                geoTopo = me.partTopo || [],
                geoPoints = me.points || [],
                len = geoParts.length;
            if (len <= 0) {
                return null;
            }
            var polygonArray = [];
            var pointList = [];
            if (len == 1) {
                for (var i = 0; i < geoPoints.length; i++) {
                    pointList.push(new _Point.Point(geoPoints[i].x, geoPoints[i].y));
                }
                polygonArray.push(new _Polygon.Polygon([new _LinearRing.LinearRing(pointList)]));
                return new _MultiPolygon.MultiPolygon(polygonArray);
            }
            //处理复杂面
            var CCWArray = [];
            var areaArray = [];
            var polygonArrayTemp = [];
            var polygonBounds = [];
            //polyon岛洞标识数组，初始都是岛。
            var CCWIdent = [];
            for (var _i2 = 0, pointIndex = 0; _i2 < len; _i2++) {
                for (var j = 0; j < geoParts[_i2]; j++) {
                    pointList.push(new _Point.Point(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
                }
                pointIndex += geoParts[_i2];
                var polygon = new _Polygon.Polygon([new _LinearRing.LinearRing(pointList)]);
                pointList = [];
                polygonArrayTemp.push(polygon);
                if (geoTopo.length === 0) {
                    polygonBounds.push(polygon.getBounds());
                }
                CCWIdent.push(1);
                areaArray.push(polygon.getArea());
            }
            //根据面积排序
            ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo, polygonBounds);
            //iServer 9D新增字段
            if (geoTopo.length === 0) {
                //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
                // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
                // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
                //目标polygon索引列表 -1标示没有被任何polygon包含，
                var targetArray = [];
                for (var _i3 = 1; _i3 < polygonArrayTemp.length; _i3++) {
                    for (var _j = _i3 - 1; _j >= 0; _j--) {
                        targetArray[_i3] = -1;
                        if (polygonBounds[_j].containsBounds(polygonBounds[_i3])) {
                            CCWIdent[_i3] = CCWIdent[_j] * -1;
                            if (CCWIdent[_i3] < 0) {
                                targetArray[_i3] = _j;
                            }
                            break;
                        }
                    }
                }
                for (var _i4 = 0; _i4 < polygonArrayTemp.length; _i4++) {
                    if (CCWIdent[_i4] > 0) {
                        polygonArray.push(polygonArrayTemp[_i4]);
                    } else {
                        polygonArray[targetArray[_i4]].components = polygonArray[targetArray[_i4]].components.concat(polygonArrayTemp[_i4].components);
                        //占位
                        polygonArray.push('');
                    }
                }
            } else {
                //根据面积排序
                //ServerGeometry.bubbleSort(areaArray, polygonArrayTemp,geoTopo);
                polygonArray = new Array();
                for (var _i5 = 0; _i5 < polygonArrayTemp.length; _i5++) {
                    if (geoTopo[_i5] && geoTopo[_i5] == -1) {
                        CCWArray = CCWArray.concat(polygonArrayTemp[_i5].components);
                    } else {
                        if (CCWArray.length > 0 && polygonArray.length > 0) {
                            polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
                            CCWArray = [];
                        }
                        polygonArray.push(polygonArrayTemp[_i5]);
                    }
                    if (_i5 == len - 1) {
                        var polyLength = polygonArray.length;
                        if (polyLength) {
                            polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
                        } else {
                            for (var k = 0, length = CCWArray.length; k < length; k++) {
                                polygonArray.push(new _Polygon.Polygon(CCWArray));
                            }
                        }
                    }
                }
            }
            return new _MultiPolygon.MultiPolygon(polygonArray);
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.toGeoRegionEPS
         * @description 将服务端的面几何对象转换为客户端几何对象。类型为 Polygon。
         * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
         */

    }, {
        key: 'toGeoRegionEPS',
        value: function toGeoRegionEPS() {
            var me = this,
                geoParts = me.parts || [],
                geoTopo = me.partTopo || [],
                geoPoints = me.points || [],
                len = geoParts.length;

            if (len <= 0) {
                return null;
            }
            var polygonArray = [];
            var pointList = [];
            var lineEPS;
            if (len == 1) {
                for (var i = 0; i < geoPoints.length; i++) {
                    pointList.push(new _Point.Point(geoPoints[i].x, geoPoints[i].y));
                }

                lineEPS = _LineString.LineString.createLineEPS(pointList);
                polygonArray.push(new _Polygon.Polygon([new _LinearRing.LinearRing(lineEPS)]));
                return new _MultiPolygon.MultiPolygon(polygonArray);
            }
            //处理复杂面
            var CCWArray = [];
            var areaArray = [];
            var polygonArrayTemp = [];
            var polygonBounds = [];
            //polyon岛洞标识数组，初始都是岛。
            var CCWIdent = [];
            for (var _i6 = 0, pointIndex = 0; _i6 < len; _i6++) {
                for (var j = 0; j < geoParts[_i6]; j++) {
                    pointList.push(new _Point.Point(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
                }
                pointIndex += geoParts[_i6];

                lineEPS = _LineString.LineString.createLineEPS(pointList);
                var polygon = new _Polygon.Polygon([new _LinearRing.LinearRing(lineEPS)]);
                pointList = [];
                polygonArrayTemp.push(polygon);
                if (geoTopo.length === 0) {
                    polygonBounds.push(polygon.getBounds());
                }
                CCWIdent.push(1);
                areaArray.push(polygon.getArea());
            }
            //根据面积排序
            ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo, polygonBounds);
            //iServer 9D新增字段
            if (geoTopo.length === 0) {
                //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
                // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
                // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
                //目标polygon索引列表 -1标示没有被任何polygon包含，
                var targetArray = [];
                for (var _i7 = 1; _i7 < polygonArrayTemp.length; _i7++) {
                    for (var _j2 = _i7 - 1; _j2 >= 0; _j2--) {
                        targetArray[_i7] = -1;
                        if (polygonBounds[_j2].containsBounds(polygonBounds[_i7])) {
                            CCWIdent[_i7] = CCWIdent[_j2] * -1;
                            if (CCWIdent[_i7] < 0) {
                                targetArray[_i7] = _j2;
                            }
                            break;
                        }
                    }
                }
                for (var _i8 = 0; _i8 < polygonArrayTemp.length; _i8++) {
                    if (CCWIdent[_i8] > 0) {
                        polygonArray.push(polygonArrayTemp[_i8]);
                    } else {
                        polygonArray[targetArray[_i8]].components = polygonArray[targetArray[_i8]].components.concat(polygonArrayTemp[_i8].components);
                        //占位
                        polygonArray.push('');
                    }
                }
            } else {
                //根据面积排序
                polygonArray = new Array();
                for (var _i9 = 0; _i9 < polygonArrayTemp.length; _i9++) {
                    if (geoTopo[_i9] && geoTopo[_i9] == -1) {
                        CCWArray = CCWArray.concat(polygonArrayTemp[_i9].components);
                    } else {
                        if (CCWArray.length > 0 && polygonArray.length > 0) {
                            polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
                            CCWArray = [];
                        }
                        polygonArray.push(polygonArrayTemp[_i9]);
                    }
                    if (_i9 == len - 1) {
                        var polyLength = polygonArray.length;
                        if (polyLength) {
                            polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
                        } else {
                            for (var k = 0, length = CCWArray.length; k < length; k++) {
                                polygonArray.push(new _Polygon.Polygon(CCWArray));
                            }
                        }
                    }
                }
            }
            return new _MultiPolygon.MultiPolygon(polygonArray);
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.fromJson
         * @description 将 JSON 对象表示服务端几何对象转换为 ServerGeometry。
         * @param {Object} jsonObject - 要转换的 JSON 对象。
         * @returns {SuperMap.ServerGeometry} 转换后的 ServerGeometry 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            return new ServerGeometry({
                id: jsonObject.id,
                style: _ServerStyle.ServerStyle.fromJson(jsonObject.style),
                parts: jsonObject.parts,
                partTopo: jsonObject.partTopo,
                points: jsonObject.points,
                center: jsonObject.center,
                length: jsonObject.length,
                maxM: jsonObject.maxM,
                minM: jsonObject.minM,
                type: jsonObject.type
            });
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.fromGeometry
         * @description 将客户端 Geometry 转换成服务端 ServerGeometry。
         * @param {SuperMap.Geometry} geometry - 要转换的客户端 Geometry 对象。
         * @returns {SuperMap.ServerGeometry} 转换后的 ServerGeometry 对象。
         */

    }, {
        key: 'fromGeometry',
        value: function fromGeometry(geometry) {
            if (!geometry) {
                return;
            }
            var id = 0,
                parts = [],
                points = [],
                type = null,
                icomponents = geometry.components,
                className = geometry.CLASS_NAME,
                prjCoordSys = { "epsgCode": geometry.SRID };

            if (!isNaN(geometry.id)) {
                id = geometry.id;
            }
            //坑爹的改法，没法，为了支持态势标绘，有时间就得全改
            if (className != "SuperMap.Geometry.LinearRing" && className != "SuperMap.Geometry.LineString" && (geometry instanceof _MultiPoint.MultiPoint || geometry instanceof _MultiLineString.MultiLineString)) {
                var ilen = icomponents.length;
                for (var i = 0; i < ilen; i++) {
                    var partPointsCount = icomponents[i].getVertices().length;
                    parts.push(partPointsCount);
                    for (var j = 0; j < partPointsCount; j++) {
                        points.push(new _Point.Point(icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
                    }
                }
                //这里className不是多点就全部是算线
                type = className == "SuperMap.Geometry.MultiPoint" ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
            } else if (geometry instanceof _MultiPolygon.MultiPolygon) {
                var _ilen = icomponents.length;
                for (var _i10 = 0; _i10 < _ilen; _i10++) {
                    var polygon = icomponents[_i10],
                        linearRingOfPolygon = polygon.components,
                        linearRingOfPolygonLen = linearRingOfPolygon.length;
                    for (var _j3 = 0; _j3 < linearRingOfPolygonLen; _j3++) {
                        var _partPointsCount = linearRingOfPolygon[_j3].getVertices().length + 1;
                        parts.push(_partPointsCount);
                        for (var k = 0; k < _partPointsCount - 1; k++) {
                            points.push(new _Point.Point(linearRingOfPolygon[_j3].getVertices()[k].x, linearRingOfPolygon[_j3].getVertices()[k].y));
                        }
                        points.push(new _Point.Point(linearRingOfPolygon[_j3].getVertices()[0].x, linearRingOfPolygon[_j3].getVertices()[0].y));
                    }
                }
                type = _REST.GeometryType.REGION;
            } else if (geometry instanceof _Polygon.Polygon) {
                var _ilen2 = icomponents.length;
                for (var _i11 = 0; _i11 < _ilen2; _i11++) {
                    var _partPointsCount2 = icomponents[_i11].getVertices().length + 1;
                    parts.push(_partPointsCount2);
                    for (var _j4 = 0; _j4 < _partPointsCount2 - 1; _j4++) {
                        points.push(new _Point.Point(icomponents[_i11].getVertices()[_j4].x, icomponents[_i11].getVertices()[_j4].y));
                    }
                    points.push(new _Point.Point(icomponents[_i11].getVertices()[0].x, icomponents[_i11].getVertices()[0].y));
                }
                type = _REST.GeometryType.REGION;
            } else {
                var geometryVerticesCount = geometry.getVertices().length;
                for (var _j5 = 0; _j5 < geometryVerticesCount; _j5++) {
                    points.push(new _Point.Point(geometry.getVertices()[_j5].x, geometry.getVertices()[_j5].y));
                }
                if (geometry instanceof _LinearRing.LinearRing) {
                    points.push(new _Point.Point(geometry.getVertices()[0].x, geometry.getVertices()[0].y));
                    geometryVerticesCount++;
                }
                parts.push(geometryVerticesCount);
                type = geometry instanceof _Point.Point ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
            }

            return new ServerGeometry({
                id: id,
                style: null,
                parts: parts,
                points: points,
                type: type,
                prjCoordSys: prjCoordSys
            });
        }

        /**
         * @function SuperMap.ServerGeometry.prototype.IsClockWise
         * @description 判断 linearRing 中的点的顺序。返回值大于 0，逆时针；小于 0，顺时针。
         * @param {SuperMap.Geometry} geometry - 要转换的客户端 Geometry 对象。
         * @returns {number} 返回值大于 0，逆时针；小于 0，顺时针。
         */

    }, {
        key: 'IsClockWise',
        value: function IsClockWise(points) {
            var length = points.length;
            if (length < 3) {
                return 0.0;
            }
            var s = points[0].y * (points[length - 1].x - points[1].x);
            points.push(points[0]);
            for (var i = 1; i < length; i++) {
                s += points[i].y * (points[i - 1].x - points[i + 1].x);
            }
            return s * 0.5;
        }
    }, {
        key: 'bubbleSort',
        value: function bubbleSort(areaArray, pointList, geoTopo, polygonBounds) {
            for (var i = 0; i < areaArray.length; i++) {
                for (var j = 0; j < areaArray.length; j++) {
                    if (areaArray[i] > areaArray[j]) {
                        var d = areaArray[j];
                        areaArray[j] = areaArray[i];
                        areaArray[i] = d;
                        var b = pointList[j];
                        pointList[j] = pointList[i];
                        pointList[i] = b;
                        if (geoTopo && geoTopo.length > 0) {
                            var c = geoTopo[j];
                            geoTopo[j] = geoTopo[i];
                            geoTopo[i] = c;
                        }
                        if (polygonBounds && polygonBounds.length > 0) {
                            var f = polygonBounds[j];
                            polygonBounds[j] = polygonBounds[i];
                            polygonBounds[i] = f;
                        }
                    }
                }
            }
        }
    }]);

    return ServerGeometry;
}();

_SuperMap.SuperMap.ServerGeometry = ServerGeometry;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Util = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(4);

var _iclientCommon = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class mapboxgl.supermap.Util
 * @category BaseTypes Util
 * @classdesc 工具类。
 */
var Util = exports.Util = function () {
    function Util() {
        _classCallCheck(this, Util);
    }

    _createClass(Util, null, [{
        key: 'toSuperMapGeometry',


        /**
         * @function mapboxgl.supermap.Util.toSuperMapGeometry
         * @description 将 GeoJSON 对象转为 SuperMap 几何图形。
         * @param {GeoJSONObject} geoJSON - GeoJSON 对象。
         */
        value: function toSuperMapGeometry(geoJSON) {
            if (geoJSON && geoJSON.type) {
                var format = new _iclientCommon.GeoJSON();
                var result = format.read(geoJSON, "FeatureCollection");
                return result[0].geometry;
            }
        }
    }, {
        key: 'toSuperMapBounds',
        value: function toSuperMapBounds(bounds) {
            if (this.isArray(bounds)) {
                //左下右上
                return new _iclientCommon.Bounds(bounds[0], bounds[1], bounds[2], bounds[3]);
            }
            return new _iclientCommon.Bounds(bounds.getWest(), bounds.getSouth(), bounds.getEast(), bounds.getNorth());
        }
    }, {
        key: 'toSuperMapPoint',
        value: function toSuperMapPoint(lnglat) {
            //客户端可传入 geojson 对象 或者 mapboxgl lnglat 点对象,或者是点数组
            if (this.isArray(lnglat)) {
                return new _iclientCommon.GeometryPoint(lnglat[0], lnglat[1]);
            } else if (lnglat.lng && lnglat.lat) {
                return new _iclientCommon.GeometryPoint(lnglat.lng, lnglat.lat);
            }
            return new _iclientCommon.GeometryPoint(lnglat.geometry.coordinates[0], lnglat.geometry.coordinates[1]);
        }

        /**
         * @function mapboxgl.supermap.Util.isArray
         * @description 判断是否为数组格式。
         * @param {Object} obj - 待判断对象。
         * @returns {boolean} 是否是数组。
         */

    }, {
        key: 'isArray',
        value: function isArray(obj) {
            return Object.prototype.toString.call(obj) == '[object Array]';
        }

        /**
         * @function mapboxgl.supermap.Util.toGeoJSON
         * @description 将传入对象转为 GeoJSON 格式。
         * @param {Object} smObj - 待转参数。
         */

    }, {
        key: 'toGeoJSON',
        value: function toGeoJSON(smObj) {
            if (smObj) {
                var format = new _iclientCommon.GeoJSON();
                return format.toGeoJSON(smObj);
            }
        }

        /**
         * @function mapboxgl.supermap.Util.toProcessingParam
         * @description 将 Region 节点数组转为 Processing 服务需要的分析参数。
         * @param {Array} points - Region 各个节点数组。
         * @returns {Object} processing 服务裁剪、查询分析的分析参数。
         */

    }, {
        key: 'toProcessingParam',
        value: function toProcessingParam(points) {
            var geometryParam = {};
            if (points.length < 1) {
                geometryParam = "";
            } else {
                var results = [];
                for (var i = 0; i < points.length; i++) {
                    var point = {};
                    point.x = points[i][0];
                    point.y = points[i][1];
                    results.push(point);
                }
                geometryParam.type = "REGION";
                geometryParam.points = results;
            }
            return geometryParam;
        }

        /**
         * @function mapboxgl.supermap.Util.extend
         * @description 对象拷贝赋值。
         * @param {Object} dest - 目标对象。
         * @param {Object} arguments - 待拷贝的对象。
         * @returns {Object} 赋值后的目标对象。
         */

    }, {
        key: 'extend',
        value: function extend(dest) {
            for (var index = 0; index < Object.getOwnPropertyNames(arguments).length; index++) {
                var arg = Object.getOwnPropertyNames(arguments)[index];
                if (arg == "caller" || arg == "callee" || arg == "length" || arg == "arguments") {
                    continue;
                }
                var obj = arguments[arg];
                if (obj) {
                    for (var j = 0; j < Object.getOwnPropertyNames(obj).length; j++) {
                        var key = Object.getOwnPropertyNames(obj)[j];
                        if (arg == "caller" || arg == "callee" || arg == "length" || arg == "arguments") {
                            continue;
                        }
                        dest[key] = obj[key];
                    }
                }
            }
            return dest;
        }

        /**
         * 检测数据是否为number
         * @param value 值，未知数据类型
         * @returns {boolean}
         */

    }, {
        key: 'isNumber',
        value: function isNumber(value) {
            if (value === '') {
                return false;
            }
            var mdata = Number(value);
            if (mdata === 0) {
                return true;
            }
            return !isNaN(mdata);
        }

        /**
        * 随机生成id
        * @param attr
        * @returns {string}
        */

    }, {
        key: 'newGuid',
        value: function newGuid(attr) {
            var len = attr || 32;
            var guid = "";
            for (var i = 1; i < len; i++) {
                var n = Math.floor(Math.random() * 16.0).toString(16);
                guid += n;
            }
            return guid;
        }
        /**
         * @description 十六进制转 RGBA 格式。
         * @param {Object} hex - 十六进制格式参数。
         * @param {number} opacity -Alpha 参数。
         * @returns {string} 生成的 RGBA 格式。
         */

    }, {
        key: 'hexToRgba',
        value: function hexToRgba(hex, opacity) {
            var color = [],
                rgba = [];
            hex = hex.replace(/#/, "");
            if (hex.length == 3) {
                var tmp = [];
                for (var i = 0; i < 3; i++) {
                    tmp.push(hex.charAt(i) + hex.charAt(i));
                }
                hex = tmp.join("");
            }
            for (var _i = 0; _i < 6; _i += 2) {
                color[_i] = "0x" + hex.substr(_i, 2);
                rgba.push(parseInt(Number(color[_i])));
            }
            rgba.push(opacity);
            return "rgba(" + rgba.join(",") + ")";
        }
    }]);

    return Util;
}();

_mapboxGl2.default.supermap.Util = Util;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SpatialAnalystBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(6);

var _GeoJSON = __webpack_require__(17);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.SpatialAnalystBase
 * @category  iServer SpatialAnalyst
 * @classdesc 空间分析服务基类。
 * @param {string} url - 地址。
 * @param {Object} options - 参数。
 * @extends {SuperMap.CommonServiceBase}
 */
var SpatialAnalystBase = exports.SpatialAnalystBase = function (_CommonServiceBase) {
    _inherits(SpatialAnalystBase, _CommonServiceBase);

    function SpatialAnalystBase(url, options) {
        _classCallCheck(this, SpatialAnalystBase);

        /**
         * @member {SuperMap.DataFormat} [SuperMap.SpatialAnalystBase.prototype.format=SuperMap.DataFormat.GEOJSON]
         * @description 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式，参数格式为 "ISERVER"，"GEOJSON"。
         */
        var _this = _possibleConstructorReturn(this, (SpatialAnalystBase.__proto__ || Object.getPrototypeOf(SpatialAnalystBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.SpatialAnalystBase";
        return _this;
    }

    /**
     * @function SuperMap.SpatialAnalystBase.prototype.destroy
     * @override
     */


    _createClass(SpatialAnalystBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(SpatialAnalystBase.prototype.__proto__ || Object.getPrototypeOf(SpatialAnalystBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _Util.Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                //批量分析时会返回多个结果
                if (_Util.Util.isArray(result)) {
                    for (var i = 0; i < result.length; i++) {
                        result[i] = me.toGeoJSONResult(result[i]);
                    }
                    analystResult = result;
                } else {
                    analystResult = me.toGeoJSONResult(result);
                }
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.toGeoJSONResult
         * @description 将含有 geometry 的数据转换为 GeoJSON 格式。
         * @param {Object} result - 服务器返回的结果对象。
         *
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result) {
                return null;
            }
            //批量叠加分析时结果这样处理
            if (result.result && result.result.resultGeometry) {
                result = result.result;
            }
            var geoJSONFormat = new _GeoJSON.GeoJSON();
            if (result.recordsets) {
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        recordsets[i].features = geoJSONFormat.toGeoJSON(recordsets[i].features);
                    }
                }
            } else if (result.recordset && result.recordset.features) {
                result.recordset.features = geoJSONFormat.toGeoJSON(result.recordset.features);
            }
            if (result.resultGeometry) {
                result.resultGeometry = geoJSONFormat.toGeoJSON(result.resultGeometry);
            }
            if (result.regions) {
                result.regions = geoJSONFormat.toGeoJSON(result.regions);
            }

            return result;
        }
    }]);

    return SpatialAnalystBase;
}(_CommonServiceBase2.CommonServiceBase);

_SuperMap.SuperMap.SpatialAnalystBase = SpatialAnalystBase;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SUtil = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _Area = __webpack_require__(142);

var _Color = __webpack_require__(65);

var _ComputeBoundingBox = __webpack_require__(141);

var _Curve = __webpack_require__(59);

var _Env = __webpack_require__(140);

var _Event = __webpack_require__(139);

var _Http = __webpack_require__(138);

var _Log = __webpack_require__(137);

var _Math = __webpack_require__(136);

var _Matrix = __webpack_require__(135);

var _Util = __webpack_require__(30);

var _Vector = __webpack_require__(58);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SUtil = exports.SUtil = function () {
    function SUtil() {
        _classCallCheck(this, SUtil);
    }

    _createClass(SUtil, null, [{
        key: 'SUtil_smoothBezier',

        /**
         * @function SuperMap.LevelRenderer.SUtil.SUtil_smoothBezier
         * @description 贝塞尔平滑曲线。
         * @private 
         * @param {Array} points - 线段顶点数组。
         * @param {number} smooth - 平滑等级, 0-1。
         * @param {boolean} isLoop - isLoop。
         * @param {Array} constraint - 将计算出来的控制点约束在一个包围盒内，比如 [[0, 0], [100, 100]], 这个包围盒会与整个折线的包围盒做一个并集用来约束控制点。
         * @param {Array} [originalPosition=[0, 0]] - 参考原点。
         * @return {Array} 生成的平滑节点数组。
         */
        value: function SUtil_smoothBezier(points, smooth, isLoop, constraint, originalPosition) {
            if (!originalPosition || originalPosition !== 2) {
                originalPosition = [0, 0];
            }
            var __OP = originalPosition;

            var cps = [];

            var v = [];
            var v1 = [];
            var v2 = [];

            var hasConstraint = !!constraint;
            var min, max;
            if (hasConstraint) {
                min = [Infinity, Infinity];
                max = [-Infinity, -Infinity];
                var _len = points.length;
                for (var i = 0; i < _len; i++) {
                    SUtil.Util_vector.min(min, min, [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
                    SUtil.Util_vector.max(max, max, [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
                }
                // 与指定的包围盒做并集
                SUtil.Util_vector.min(min, min, constraint[0]);
                SUtil.Util_vector.max(max, max, constraint[1]);
            }

            var len = points.length;
            for (var _i = 0; _i < len; _i++) {
                var point = [points[_i][0] + __OP[0], points[_i][1] + __OP[1]];
                var prevPoint = void 0;
                var nextPoint = void 0;

                if (isLoop) {
                    prevPoint = [points[_i ? _i - 1 : len - 1][0] + __OP[0], points[_i ? _i - 1 : len - 1][1] + __OP[1]];
                    nextPoint = [points[(_i + 1) % len][0] + __OP[0], points[(_i + 1) % len][1] + __OP[1]];
                } else {
                    if (_i === 0 || _i === len - 1) {
                        cps.push([points[_i][0] + __OP[0], points[_i][1] + __OP[1]]);
                        continue;
                    } else {
                        prevPoint = [points[_i - 1][0] + __OP[0], points[_i - 1][1] + __OP[1]];
                        nextPoint = [points[_i + 1][0] + __OP[0], points[_i + 1][1] + __OP[1]];
                    }
                }

                SUtil.Util_vector.sub(v, nextPoint, prevPoint);

                // use degree to scale the handle length
                SUtil.Util_vector.scale(v, v, smooth);

                var d0 = SUtil.Util_vector.distance(point, prevPoint);
                var d1 = SUtil.Util_vector.distance(point, nextPoint);
                var sum = d0 + d1;
                if (sum !== 0) {
                    d0 /= sum;
                    d1 /= sum;
                }

                SUtil.Util_vector.scale(v1, v, -d0);
                SUtil.Util_vector.scale(v2, v, d1);
                var cp0 = SUtil.Util_vector.add([], point, v1);
                var cp1 = SUtil.Util_vector.add([], point, v2);
                if (hasConstraint) {
                    SUtil.Util_vector.max(cp0, cp0, min);
                    SUtil.Util_vector.min(cp0, cp0, max);
                    SUtil.Util_vector.max(cp1, cp1, min);
                    SUtil.Util_vector.min(cp1, cp1, max);
                }
                cps.push(cp0);
                cps.push(cp1);
            }

            if (isLoop) {
                cps.push(cps.shift());
            }

            return cps;
        }

        /**
         * @function SuperMap.LevelRenderer.SUtil.SUtil_smoothSpline
         * @description 插值折线。
         * @private 
         * @param {Array} points - 线段顶点数组。
         * @param {boolean} isLoop - isLoop。
         * @param {Array} constraint - 将计算出来的控制点约束在一个包围盒内，比如 [[0, 0], [100, 100]], 这个包围盒会与整个折线的包围盒做一个并集用来约束控制点。
         * @param {Array} originalPosition - 参考原点。默认值：[0, 0]。
         * @return {Array} 生成的平滑节点数组。
         */

    }, {
        key: 'SUtil_smoothSpline',
        value: function SUtil_smoothSpline(points, isLoop, constraint, originalPosition) {
            if (!originalPosition || originalPosition !== 2) {
                originalPosition = [0, 0];
            }
            var __OP = originalPosition;

            var len = points.length;
            var ret = [];

            var distance = 0;
            for (var i = 1; i < len; i++) {
                distance += SUtil.Util_vector.distance([points[i - 1][0] + __OP[0], points[i - 1][1] + __OP[1]], [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
            }

            var segs = distance / 5;
            segs = segs < len ? len : segs;
            for (var _i2 = 0; _i2 < segs; _i2++) {
                var pos = _i2 / (segs - 1) * (isLoop ? len : len - 1);
                var idx = Math.floor(pos);

                var w = pos - idx;

                var p0 = void 0;
                var p1 = [points[idx % len][0] + __OP[0], points[idx % len][1] + __OP[1]];
                var p2 = void 0;
                var p3 = void 0;
                if (!isLoop) {
                    p0 = [points[idx === 0 ? idx : idx - 1][0] + __OP[0], points[idx === 0 ? idx : idx - 1][1] + __OP[1]];
                    p2 = [points[idx > len - 2 ? len - 1 : idx + 1][0] + __OP[0], points[idx > len - 2 ? len - 1 : idx + 1][1] + __OP[1]];
                    p3 = [points[idx > len - 3 ? len - 1 : idx + 2][0] + __OP[0], points[idx > len - 3 ? len - 1 : idx + 2][1] + __OP[1]];
                } else {

                    p0 = [points[(idx - 1 + len) % len][0] + __OP[0], points[(idx - 1 + len) % len][1] + __OP[1]];
                    p2 = [points[(idx + 1) % len][0] + __OP[0], points[(idx + 1) % len][1] + __OP[1]];
                    p3 = [points[(idx + 2) % len][0] + __OP[0], points[(idx + 2) % len][1] + __OP[1]];
                }

                var w2 = w * w;
                var w3 = w * w2;

                ret.push([interpolate(p0[0], p1[0], p2[0], p3[0], w, w2, w3), interpolate(p0[1], p1[1], p2[1], p3[1], w, w2, w3)]);
            }
            return ret;

            // inner Function
            function interpolate(p0, p1, p2, p3, t, t2, t3) {
                var v0 = (p2 - p0) * 0.5;
                var v1 = (p3 - p1) * 0.5;
                return (2 * (p1 - p2) + v0 + v1) * t3 + (-3 * (p1 - p2) - 2 * v0 - v1) * t2 + v0 * t + p1;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.SUtil.SUtil_dashedLineTo
         * @description 虚线 lineTo。
         */

    }, {
        key: 'SUtil_dashedLineTo',
        value: function SUtil_dashedLineTo(ctx, x1, y1, x2, y2, dashLength, customDashPattern) {
            // http://msdn.microsoft.com/en-us/library/ie/dn265063(v=vs.85).aspx
            var dashPattern = [5, 5];
            dashLength = typeof dashLength != 'number' ? 5 : dashLength;

            if (ctx.setLineDash) {
                dashPattern[0] = dashLength;
                dashPattern[1] = dashLength;

                if (customDashPattern && customDashPattern instanceof Array) {
                    ctx.setLineDash(customDashPattern);
                } else {
                    ctx.setLineDash(dashPattern);
                }
                // ctx.setLineDash(dashPattern);

                ctx.moveTo(x1, y1);
                ctx.lineTo(x2, y2);
                return;
            }

            var dx = x2 - x1;
            var dy = y2 - y1;
            var numDashes = Math.floor(Math.sqrt(dx * dx + dy * dy) / dashLength);
            dx = dx / numDashes;
            dy = dy / numDashes;
            var flag = true;
            for (var i = 0; i < numDashes; ++i) {
                if (flag) {
                    ctx.moveTo(x1, y1);
                } else {
                    ctx.lineTo(x1, y1);
                }
                flag = !flag;
                x1 += dx;
                y1 += dy;
            }
            ctx.lineTo(x2, y2);
        }
    }]);

    return SUtil;
}();
// 把所有工具对象放到全局静态变量上，以便直接调用工具方法，
// 避免使用工具时频繁的创建工具对象带来的性能消耗。


SUtil.Util_area = new _Area.Area();
SUtil.Util_color = new _Color.Color();
SUtil.Util_computeBoundingBox = new _ComputeBoundingBox.ComputeBoundingBox();
SUtil.Util_curve = new _Curve.Curve();
SUtil.Util_env = new _Env.Env();
SUtil.Util_event = new _Event.Event();
SUtil.Util_http = new _Http.Http();
SUtil.Util_log = new _Log.Log();
SUtil.Util_math = new _Math.Math();
SUtil.Util_matrix = new _Matrix.Matrix();
SUtil.Util = new _Util.Util();
SUtil.Util_vector = new _Vector.Vector();

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Shape = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Eventful = __webpack_require__(45);

var _Transformable = __webpack_require__(60);

var _Util = __webpack_require__(1);

var _SUtil = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape
 * @category Visualization Theme
 * @classdesc 图形（shape）基类。
 * @extends SuperMap.LevelRenderer.Eventful
 * @extends SuperMap.LevelRenderer.Transformable
 */
var Shape = exports.Shape = function (_SuperMap$mixin) {
    _inherits(Shape, _SuperMap$mixin);

    /**
     * @function SuperMap.LevelRenderer.Shape.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function Shape(options) {
        _classCallCheck(this, Shape);

        var _this = _possibleConstructorReturn(this, (Shape.__proto__ || Object.getPrototypeOf(Shape)).call(this, options));

        options = options || {};
        /**
         * @member {string} SuperMap.LevelRenderer.Shape.prototype.id
         * @description 唯一标识。
         */
        _this.id = null;

        /**
         * @member {Object} SuperMap.LevelRenderer.Shape.prototype.style
         * @description 基础绘制样式。
         * @param {string} style.brushType - 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
         * @param {string} style.color - 填充颜色。默认值："#000000'"。
         * @param {string} style.strokeColor - 描边颜色。默认值："#000000'"。
         * @param {string} style.lineCape - 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
         * @param {number} style.lineWidth - 描边宽度。默认值：1。
         * @param {number} style.opacity - 绘制透明度。默认值：1。
         * @param {number} style.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
         * @param {number} style.shadowColor - 阴影颜色。默认值："#000000'"。
         * @param {number} style.shadowOffsetX - 阴影横向偏移。默认值：0。
         * @param {number} style.shadowOffsetY -  阴影纵向偏移。默认值：0。
         * @param {string} style.text -  图形中的附加文本。默认值：""。
         * @param {string} style.textColor -  文本颜色。默认值："#000000'"。
         * @param {string} style.textFont -  附加文本样式。示例:'bold 18px verdana'。
         * @param {string} style.textPosition -  附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
         * @param {string} style.textAlign -  附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
         * @param {string} style.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
         *
         */
        _this.style = {};

        /**
         * @member {Object} SuperMap.LevelRenderer.Shape.prototype.style.__rect
         * @description 包围图形的最小矩形盒子。
         *
         * @param {number} x - 左上角顶点x轴坐标。
         * @param {number} y - 左上角顶点y轴坐标。
         * @param {number} width - 包围盒矩形宽度。
         * @param {number} height - 包围盒矩形高度。
         */

        /**
         * @member {Object} SuperMap.LevelRenderer.Shape.prototype.highlightStyle
         * @description 高亮样式。
         *
         * @param {string} highlightStyle.brushType - 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
         * @param {string} highlightStyle.color -  填充颜色。默认值："#000000'"。
         * @param {string} highlightStyle.strokeColor - 描边颜色。默认值："#000000'"。
         * @param {string} highlightStyle.lineCape - 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
         * @param {number} highlightStyle.lineWidth - 描边宽度。默认值：1。
         * @param {number} highlightStyle.opacity -  绘制透明度。默认值：1。
         * @param {number} highlightStyle.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
         * @param {number} highlightStyle.shadowColor - 阴影颜色。默认值："#000000'"。
         * @param {number} highlightStyle.shadowOffsetX - 阴影横向偏移。默认值：0。
         * @param {number} highlightStyle.shadowOffsetY - 阴影纵向偏移。默认值：0。
         * @param {string} highlightStyle.text - 图形中的附加文本。默认值：""。
         * @param {string} highlightStyle.textColor - 文本颜色。默认值："#000000'"。
         * @param {string} highlightStyle.textFont - 附加文本样式。示例:'bold 18px verdana'。
         * @param {string} highlightStyle.textPosition - 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
         * @param {string} highlightStyle.textAlign -  附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
         * @param {string} highlightStyle.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
         */
        _this.highlightStyle = null;

        /**
         * @member {Object} SuperMap.LevelRenderer.Shape.prototype.parent
         * @description 父节点，只读属性。<SuperMap.LevelRenderer.Group>
         */
        _this.parent = null;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.__dirty
         * @description {boolean}
         */
        _this.__dirty = true;

        /**
         * @member {Array} SuperMap.LevelRenderer.Shape.prototype.__clipShapes
         * @description {Array}
         * 
         */
        _this.__clipShapes = [];

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.invisible
         * @description 图形是否可见，为 true 时不绘制图形，但是仍能触发鼠标事件。默认值：false。
         */
        _this.invisible = false;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.ignore
         * @description 图形是否忽略，为 true 时忽略图形的绘制以及事件触发。默认值：false。
         */
        _this.ignore = false;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.zlevel
         * @description z 层 level，决定绘画在哪层 canvas 中。默认值：0。
         */
        _this.zlevel = 0;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.draggable
         * @description 是否可拖拽。默认值：false。
         */
        _this.draggable = false;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.clickable
         * @description 是否可点击。默认值：false。
         */
        _this.clickable = false;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.hoverable
         * @description 是否可以 hover。默认值：true。
         */
        _this.hoverable = true;

        /**
         * @member {number} SuperMap.LevelRenderer.Shape.prototype.z
         * @description z值，跟zlevel一样影响shape绘制的前后顺序，z值大的shape会覆盖在z值小的上面，但是并不会创建新的canvas，所以优先级低于zlevel，而且频繁改动的开销比zlevel小很多。默认值：0。
         */
        _this.z = 0;

        //地理扩展
        /**
         * @member {Array} SuperMap.LevelRenderer.Shape.prototype.refOriginalPosition
         * @description 图形参考原点位置，图形的参考中心位置。
         * refOriginalPosition 是长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         *
         * refOriginalPosition 表示图形的参考中心，通常情况下，图形是使用 canvas 的原点位置作为位置参考，
         * 但 refOriginalPosition 可以改变图形的参考位置，例如： refOriginalPosition = [80, 80],
         * 图形圆的 style.x = 20, style.y = 20，那么圆在 canvas 中的实际位置是 [100, 100]。
         *
         * 图形（Shape） 的所有位置相关属性都是以 refOriginalPosition 为参考中心，
         * 也就是说图形的所有位置信息在 canvas 中都是以 refOriginalPosition 为参考的相对位置，只有
         * refOriginalPosition 的值为 [0, 0] 时，形的位置信息才是 canvas 绝对位置。
         *
         * 图形的位置信息通常有：style.pointList，style.x，style.y。
         *
         * refOriginalPosition。默认值是： [0, 0]。
         */
        _this.refOriginalPosition = [0, 0];

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.prototype.refDataID
         * @description 图形所关联数据的 ID。
         *
         */
        _this.refDataID = null;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Shape.prototype.isHoverByRefDataID
         * @description 是否根据 refDataID 进行高亮。用于同时高亮所有 refDataID 相同的图形。
         *
         */
        _this.isHoverByRefDataID = false;

        /**
         *  @member {string} SuperMap.LevelRenderer.Shape.prototype.refDataHoverGroup 
         *  @description 高亮图形组的组名。此属性在 refDataID 有效且 isHoverByRefDataID 为 true 时生效。
         * 一旦设置此属性，且属性值有效，只有关联同一个数据的图形且此属性相同的图形才会高亮。
         *
         */
        _this.refDataHoverGroup = null;

        /**
         * @member {Object} SuperMap.LevelRenderer.Shape.prototype.dataInfo
         * @description 图形的数据信息。
         *
         */
        _this.dataInfo = null;
        _Util.Util.extend(_this, options);
        _this.id = _this.id || _Util.Util.createUniqueID("smShape_");
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape";
        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.getTansform
         * @description 变换鼠标位置到 shape 的局部坐标空间
         *
         */
        _this.getTansform = function () {
            var invTransform = [];

            return function (x, y) {
                var originPos = [x, y];
                // 对鼠标的坐标也做相同的变换
                if (this.needTransform && this.transform) {
                    _SUtil.SUtil.Util_matrix.invert(invTransform, this.transform);

                    _SUtil.SUtil.Util_matrix.mulVector(originPos, invTransform, [x, y, 1]);

                    if (x == originPos[0] && y == originPos[1]) {
                        // 避免外部修改导致的 needTransform 不准确
                        this.updateNeedTransform();
                    }
                }
                return originPos;
            };
        }();

        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(Shape, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.style = null;
            this.highlightStyle = null;
            this.parent = null;
            this.__dirty = null;
            this.__clipShapes = null;
            this.invisible = null;
            this.ignore = null;
            this.zlevel = null;
            this.draggable = null;
            this.clickable = null;
            this.hoverable = null;
            this.z = null;

            this.refOriginalPosition = null;
            this.refDataID = null;
            this.refDataHoverGroup = null;
            this.isHoverByRefDataID = null;
            this.dataInfo = null;
            _get(Shape.prototype.__proto__ || Object.getPrototypeOf(Shape.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.brush
         * @description 绘制图形。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {boolean} isHighlight - 是否使用高亮属性。
         * @param {Function} updateCallback - 需要异步加载资源的 shape 可以通过这个 callback(e),让painter更新视图，base.brush 没用，需要的话重载 brush。
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight) {

            var style = this.beforeBrush(ctx, isHighlight);

            ctx.beginPath();
            this.buildPath(ctx, style);

            switch (style.brushType) {
                /* jshint ignore:start */
                case 'both':
                    this.setCtxGlobalAlpha(ctx, "fill", style);
                    ctx.fill();
                    if (style.lineWidth > 0) {
                        this.setCtxGlobalAlpha(ctx, "stroke", style);
                        ctx.stroke();
                    }
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
                case 'stroke':
                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                    style.lineWidth > 0 && ctx.stroke();
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
                /* jshint ignore:end */
                default:
                    this.setCtxGlobalAlpha(ctx, "fill", style);
                    ctx.fill();
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
            }

            this.drawText(ctx, style, this.style);

            this.afterBrush(ctx);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.beforeBrush
         * @description 具体绘制操作前的一些公共操作。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {boolean} isHighlight - 是否使用高亮属性。
         * @return {Object} 处理后的样式。
         */

    }, {
        key: 'beforeBrush',
        value: function beforeBrush(ctx, isHighlight) {
            var style = this.style;

            if (this.brushTypeOnly) {
                style.brushType = this.brushTypeOnly;
            }

            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {}, this.brushTypeOnly);
            }

            if (this.brushTypeOnly == 'stroke') {
                style.strokeColor = style.strokeColor || style.color;
            }

            ctx.save();

            this.doClip(ctx);

            this.setContext(ctx, style);

            // 设置transform
            this.setTransform(ctx);

            return style;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.afterBrush
         * @description 绘制后的处理。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         *
         */

    }, {
        key: 'afterBrush',
        value: function afterBrush(ctx) {
            ctx.restore();
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.setContext
         * @description 设置 fillStyle, strokeStyle, shadow 等通用绘制样式。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - 样式。
         *
         */

    }, {
        key: 'setContext',
        value: function setContext(ctx, style) {
            var STYLE_CTX_MAP = [['color', 'fillStyle'], ['strokeColor', 'strokeStyle'], ['opacity', 'globalAlpha'], ['lineCap', 'lineCap'], ['lineJoin', 'lineJoin'], ['miterLimit', 'miterLimit'], ['lineWidth', 'lineWidth'], ['shadowBlur', 'shadowBlur'], ['shadowColor', 'shadowColor'], ['shadowOffsetX', 'shadowOffsetX'], ['shadowOffsetY', 'shadowOffsetY']];

            for (var i = 0, len = STYLE_CTX_MAP.length; i < len; i++) {
                var styleProp = STYLE_CTX_MAP[i][0];
                var styleValue = style[styleProp];
                var ctxProp = STYLE_CTX_MAP[i][1];

                if (typeof styleValue != 'undefined') {
                    ctx[ctxProp] = styleValue;
                }
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.doClip
         *
         */

    }, {
        key: 'doClip',
        value: function doClip(ctx) {
            var clipShapeInvTransform = _SUtil.SUtil.Util_matrix.create();

            if (this.__clipShapes) {
                for (var i = 0; i < this.__clipShapes.length; i++) {
                    var clipShape = this.__clipShapes[i];
                    if (clipShape.needTransform) {
                        var m = clipShape.transform;
                        _SUtil.SUtil.Util_matrix.invert(clipShapeInvTransform, m);
                        ctx.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
                    }
                    ctx.beginPath();
                    clipShape.buildPath(ctx, clipShape.style);
                    ctx.clip();
                    // Transform back
                    if (clipShape.needTransform) {
                        var _m = clipShapeInvTransform;
                        ctx.transform(_m[0], _m[1], _m[2], _m[3], _m[4], _m[5]);
                    }
                }
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.getHighlightStyle
         * @description 根据默认样式扩展高亮样式
         * 
         * @param {Object} style - 样式。
         * @param {Object} highlightStyle - 高亮样式。
         * @param {string} brushTypeOnly - brushTypeOnly。
         *
         */

    }, {
        key: 'getHighlightStyle',
        value: function getHighlightStyle(style, highlightStyle, brushTypeOnly) {
            var newStyle = {};
            for (var k in style) {
                newStyle[k] = style[k];
            }

            var highlightColor = _SUtil.SUtil.Util_color.getHighlightColor();
            // 根据highlightStyle扩展
            if (style.brushType != 'stroke') {
                // 带填充则用高亮色加粗边线
                newStyle.strokeColor = highlightColor;
                // SMIC-方法修改 - start
                newStyle.lineWidth = style.lineWidth || 1;
                // 原始代码
                //      newStyle.lineWidth = (style.lineWidth || 1)
                //          + this.getHighlightZoom();
                // 修改代码1
                // if(!style.lineType || style.lineType === "solid"){
                //     newStyle.lineWidth = (style.lineWidth || 1)
                //         + this.getHighlightZoom();
                // }
                // else{
                //     newStyle.lineWidth = (style.lineWidth || 1);
                // }
                // SMIC-方法修改 - end
                newStyle.brushType = 'both';
            } else {
                if (brushTypeOnly != 'stroke') {
                    // 描边型的则用原色加工高亮
                    newStyle.strokeColor = highlightColor;
                    // SMIC-方法修改 - start
                    newStyle.lineWidth = style.lineWidth || 1;
                    // 原始代码
                    //      newStyle.lineWidth = (style.lineWidth || 1)
                    //          + this.getHighlightZoom();
                    // 修改代码1
                    // if(!style.lineType || style.lineType === "solid"){
                    //     newStyle.lineWidth = (style.lineWidth || 1)
                    //         + this.getHighlightZoom();
                    // }
                    // else{
                    //     newStyle.lineWidth = (style.lineWidth || 1);
                    // }
                    // SMIC-方法修改 - end
                } else {
                    // 线型的则用原色加工高亮
                    newStyle.strokeColor = highlightStyle.strokeColor || _SUtil.SUtil.Util_color.mix(style.strokeColor, _SUtil.SUtil.Util_color.toRGB(highlightColor));
                }
            }

            // 可自定义覆盖默认值
            for (var _k in highlightStyle) {
                if (typeof highlightStyle[_k] != 'undefined') {
                    newStyle[_k] = highlightStyle[_k];
                }
            }

            return newStyle;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.getHighlightZoom
         * @description 高亮放大效果参数，当前统一设置为6，如有需要差异设置，通过 this.type 判断实例类型
         *
         */

    }, {
        key: 'getHighlightZoom',
        value: function getHighlightZoom() {
            return this.type != 'text' ? 6 : 2;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.drift
         * @description 移动位置
         *
         * @param {Object} dx - 横坐标变化。
         * @param {Object} dy - 纵坐标变化。
         *
         */

    }, {
        key: 'drift',
        value: function drift(dx, dy) {
            this.position[0] += dx;
            this.position[1] += dy;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.buildPath
         * @description 构建绘制的Path。子类必须重新实现此方法。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - 样式。
         */

    }, {
        key: 'buildPath',
        value: function buildPath(ctx, style) {
            // eslint-disable-line no-unused-vars
            _SUtil.SUtil.Util_log('buildPath not implemented in ' + this.type);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.getRect
         * @description 计算返回包围盒矩形。子类必须重新实现此方法。
         *
         * @param {Object} style - 样式。
         */

    }, {
        key: 'getRect',
        value: function getRect(style) {
            // eslint-disable-line no-unused-vars
            _SUtil.SUtil.Util_log('getRect not implemented in ' + this.type);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.isCover
         * @description 判断鼠标位置是否在图形内。
         *
         * @param {number} x - x。
         * @param {number} y - y。
         */

    }, {
        key: 'isCover',
        value: function isCover(x, y) {
            var originPos = this.getTansform(x, y);
            x = originPos[0];
            y = originPos[1];

            // 快速预判并保留判断矩形
            var rect = this.style.__rect;
            if (!rect) {
                rect = this.style.__rect = this.getRect(this.style);
            }

            if (x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height) {
                // 矩形内
                return _SUtil.SUtil.Util_area.isInside(this, this.style, x, y);
            }

            return false;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.drawText
         * @description 绘制附加文本。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {string} style - 样式。
         * @param {string} normalStyle - normalStyle 默认样式，用于定位文字显示。
         */

    }, {
        key: 'drawText',
        value: function drawText(ctx, style, normalStyle) {
            if (typeof style.text == 'undefined' || style.text === false) {
                return;
            }
            // 字体颜色策略
            var textColor = style.textColor || style.color || style.strokeColor;
            ctx.fillStyle = textColor;

            // 文本与图形间空白间隙
            var dd = 10;
            var al; // 文本水平对齐
            var bl; // 文本垂直对齐
            var tx; // 文本横坐标
            var ty; // 文本纵坐标

            var textPosition = style.textPosition // 用户定义
            || this.textPosition // shape默认
            || 'top'; // 全局默认

            // Smic 方法修改 -start
            var __OP = [];
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                __OP = [0, 0];
            } else {
                __OP = this.refOriginalPosition;
            }
            //原代码：
            // Smic 方法修改 -end

            switch (textPosition) {
                case 'inside':
                case 'top':
                case 'bottom':
                case 'left':
                case 'right':
                    if (this.getRect) {
                        var rect = (normalStyle || style).__rect || this.getRect(normalStyle || style);

                        switch (textPosition) {
                            case 'inside':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y + rect.height / 2;
                                al = 'center';
                                bl = 'middle';
                                if (style.brushType != 'stroke' && textColor == style.color) {
                                    ctx.fillStyle = '#fff';
                                }
                                break;
                            case 'left':
                                tx = rect.x - dd;
                                ty = rect.y + rect.height / 2;
                                al = 'end';
                                bl = 'middle';
                                break;
                            case 'right':
                                tx = rect.x + rect.width + dd;
                                ty = rect.y + rect.height / 2;
                                al = 'start';
                                bl = 'middle';
                                break;
                            case 'top':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y - dd;
                                al = 'center';
                                bl = 'bottom';
                                break;
                            case 'bottom':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y + rect.height + dd;
                                al = 'center';
                                bl = 'top';
                                break;
                        }
                    }
                    break;
                case 'start':
                case 'end':
                    var xStart = 0;
                    var xEnd = 0;
                    var yStart = 0;
                    var yEnd = 0;
                    if (typeof style.pointList != 'undefined') {
                        var pointList = style.pointList;
                        if (pointList.length < 2) {
                            // 少于2个点就不画了~
                            return;
                        }
                        var length = pointList.length;
                        switch (textPosition) {
                            // Smic 方法修改 -start
                            case 'start':
                                xStart = pointList[0][0] + __OP[0];
                                xEnd = pointList[1][0] + __OP[0];
                                yStart = pointList[0][1] + __OP[1];
                                yEnd = pointList[1][1] + __OP[1];
                                break;
                            case 'end':
                                xStart = pointList[length - 2][0] + __OP[0];
                                xEnd = pointList[length - 1][0] + __OP[0];
                                yStart = pointList[length - 2][1] + __OP[1];
                                yEnd = pointList[length - 1][1] + __OP[1];
                                break;
                            //原代码：
                            /*
                             case 'start':
                             xStart = pointList[0][0];
                             xEnd = pointList[1][0];
                             yStart = pointList[0][1];
                             yEnd = pointList[1][1];
                             break;
                             case 'end':
                             xStart = pointList[length - 2][0];
                             xEnd = pointList[length - 1][0];
                             yStart = pointList[length - 2][1];
                             yEnd = pointList[length - 1][1];
                             break;
                             */
                            // Smic 方法修改 -end
                        }
                    } else {
                        // Smic 方法修改 -start
                        xStart = style.xStart + __OP[0] || 0;
                        xEnd = style.xEnd + __OP[0] || 0;
                        yStart = style.yStart + __OP[1] || 0;
                        yEnd = style.yEnd + __OP[1] || 0;
                        //原代码：
                        /*
                         xStart = style.xStart || 0;
                         xEnd = style.xEnd || 0;
                         yStart = style.yStart || 0;
                         yEnd = style.yEnd || 0;
                         */
                        // Smic 方法修改 -end
                    }

                    switch (textPosition) {
                        case 'start':
                            al = xStart < xEnd ? 'end' : 'start';
                            bl = yStart < yEnd ? 'bottom' : 'top';
                            tx = xStart;
                            ty = yStart;
                            break;
                        case 'end':
                            al = xStart < xEnd ? 'start' : 'end';
                            bl = yStart < yEnd ? 'top' : 'bottom';
                            tx = xEnd;
                            ty = yEnd;
                            break;
                    }
                    dd -= 4;
                    if (xStart && xEnd && xStart != xEnd) {
                        tx -= al == 'end' ? dd : -dd;
                    } else {
                        al = 'center';
                    }

                    if (yStart != yEnd) {
                        ty -= bl == 'bottom' ? dd : -dd;
                    } else {
                        bl = 'middle';
                    }
                    break;
                case 'specific':
                    tx = style.textX || 0;
                    ty = style.textY || 0;
                    al = 'start';
                    bl = 'middle';
                    break;
            }

            // Smic 方法修改 -start
            if (style.labelXOffset && !isNaN(style.labelXOffset)) {
                tx += style.labelXOffset;
            }
            if (style.labelYOffset && !isNaN(style.labelYOffset)) {
                ty += style.labelYOffset;
            }
            //原代码：
            // Smic 方法修改 -end

            if (tx != null && ty != null) {
                Shape._fillText(ctx, style.text, tx, ty, style.textFont, style.textAlign || al, style.textBaseline || bl);
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.modSelf
         * @description 图形发生改变
         */

    }, {
        key: 'modSelf',
        value: function modSelf() {
            this.__dirty = true;
            if (this.style) {
                this.style.__rect = null;
            }
            if (this.highlightStyle) {
                this.highlightStyle.__rect = null;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.isSilent
         * @description 图形是否会触发事件，通过 bind 绑定的事件
         */

    }, {
        key: 'isSilent',
        value: function isSilent() {
            return !(this.hoverable || this.draggable || this.clickable || this.onmousemove || this.onmouseover || this.onmouseout || this.onmousedown || this.onmouseup || this.onclick || this.ondragenter || this.ondragover || this.ondragleave || this.ondrop);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype.setCtxGlobalAlpha
         * @description 设置 Cavans 上下文全局透明度
         *
         * @param {Object} _ctx - Cavans 上下文
         * @param {string} type - one of 'stroke', 'fill', or 'reset'
         * @param {Object} style - Symbolizer hash
         */

    }, {
        key: 'setCtxGlobalAlpha',
        value: function setCtxGlobalAlpha(_ctx, type, style) {
            if (type === "fill") {
                _ctx.globalAlpha = typeof style["fillOpacity"] === "undefined" ? typeof style["opacity"] === "undefined" ? 1 : style['opacity'] : style['fillOpacity'];
            } else if (type === "stroke") {
                _ctx.globalAlpha = typeof style["strokeOpacity"] === "undefined" ? typeof style["opacity"] === "undefined" ? 1 : style['opacity'] : style['strokeOpacity'];
            } else {
                _ctx.globalAlpha = typeof style["opacity"] === "undefined" ? 1 : style['opacity'];
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.prototype._fillText
         * @description 填充文本
         */

    }], [{
        key: '_fillText',
        value: function _fillText(ctx, text, x, y, textFont, textAlign, textBaseline) {
            if (textFont) {
                ctx.font = textFont;
            }
            ctx.textAlign = textAlign;
            ctx.textBaseline = textBaseline;
            var rect = Shape._getTextRect(text, x, y, textFont, textAlign, textBaseline);

            text = (text + '').split('\n');

            var lineHeight = _SUtil.SUtil.Util_area.getTextHeight('ZH', textFont);

            switch (textBaseline) {
                case 'top':
                    y = rect.y;
                    break;
                case 'bottom':
                    y = rect.y + lineHeight;
                    break;
                default:
                    y = rect.y + lineHeight / 2;
            }

            for (var i = 0, l = text.length; i < l; i++) {
                ctx.fillText(text[i], x, y);
                y += lineHeight;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape._getTextRect
         * @description 返回矩形区域，用于局部刷新和文字定位
         *
         * @param {string} text - text。
         * @param {number} x - x。
         * @param {number} y - y。
         * @param {string} textFont -  textFont。
         * @param {string} textAlign - textAlign。
         * @param {string} textBaseline - textBaseline。
         * @return {Object} 矩形区域。
         */

    }, {
        key: '_getTextRect',
        value: function _getTextRect(text, x, y, textFont, textAlign, textBaseline) {
            var width = _SUtil.SUtil.Util_area.getTextWidth(text, textFont);
            var lineHeight = _SUtil.SUtil.Util_area.getTextHeight('ZH', textFont);

            text = (text + '').split('\n');

            switch (textAlign) {
                case 'end':
                case 'right':
                    x -= width;
                    break;
                case 'center':
                    x -= width / 2;
                    break;
            }

            switch (textBaseline) {
                case 'top':
                    break;
                case 'bottom':
                    y -= lineHeight * text.length;
                    break;
                default:
                    y -= lineHeight * text.length / 2;
            }

            return {
                x: x,
                y: y,
                width: width,
                height: lineHeight * text.length
            };
        }
    }]);

    return Shape;
}(_SuperMap.SuperMap.mixin(_Eventful.Eventful, _Transformable.Transformable));

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerStyle = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _ServerColor = __webpack_require__(21);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerStyle
 * @category  iServer Map Theme
 * @classdesc 服务端矢量要素风格类。
 * @description 该类用于定义点状符号、线状符号、填充符号风格及其相关属性。
 * @param {Object} options - 参数。
 * @param {SuperMap.FillGradientMode} options.fillGradientMode - 渐变填充风格的渐变类型。
 * @param {SuperMap.ServerColor} [options.fillBackColor=[255,255,255]] - 填充背景颜色。
 * @param {boolean} [options.fillBackOpaque=false] - 背景是否不透明。
 * @param {SuperMap.ServerColor} [options.fillForeColor=[255,0,0]] - 填充颜色。
 * @param {number} [options.fillGradientAngle=0] - 渐变填充的旋转角度。
 * @param {number} [options.fillGradientOffsetRatioX=0] - 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。
 * @param {number} [options.fillGradientOffsetRatioY=0] - 填充中心点相对于填充区域范围中心点的垂直偏移百分比。
 * @param {number} [options.fillOpaqueRate=100] - 填充不透明度。
 * @param {number} [options.fillSymbolID=0] - 填充符号的编码。
 * @param {SuperMap.ServerColor} [options.lineColor] - 矢量要素的边线颜色。默认 lineColor = new ServerColor(0, 0, 0)。
 * @param {number} [options.lineSymbolID=0] - 线状符号的编码。
 * @param {number} [options.lineWidth=1] - 边线的宽度。
 * @param {number} [options.markerAngle=0] - 点状符号的旋转角度。
 * @param {number} [options.markerSize=1] - 点状符号的大小。
 * @param {number} [options.markerSymbolID=-1] - 点状符号的编码。
 */
var ServerStyle = exports.ServerStyle = function () {
  function ServerStyle(options) {
    _classCallCheck(this, ServerStyle);

    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.fillBackColor
     * @description 填充背景颜色。当填充模式为渐变填充时，该颜色为填充终止色。
     */
    this.fillBackColor = new _ServerColor.ServerColor(255, 255, 255);

    /**
     * @member {boolean} [SuperMap.ServerStyle.prototype.fillBackOpaque=false]
     * @description 背景是否不透明。false 表示透明。
     */
    this.fillBackOpaque = false;

    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.fillForeColor
     * @description 填充颜色。当填充模式为渐变填充时，该颜色为填充起始颜色。
     */
    this.fillForeColor = new _ServerColor.ServerColor(255, 0, 0);

    /**
     * @member {SuperMap.FillGradientMode} SuperMap.ServerStyle.prototype.fillGradientMode
     * @description 渐变填充风格的渐变类型。
     */
    this.fillGradientMode = null;

    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientAngle -
     * @description 渐变填充的旋转角度。单位为度，精确到 0.1 度，逆时针方向为正方向。
     */
    this.fillGradientAngle = 0;

    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientOffsetRatioX
     * @description 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。它们的关系如下：设填充区域范围中心点的坐标为（x0, y0），
     *              填充中心点的坐标为（x, y），填充区域范围的宽度为 a，水平偏移百分比为 dx，则 x=x0 + a*dx/100。
     */
    this.fillGradientOffsetRatioX = 0;

    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientOffsetRatioY
     * @description 填充中心点相对于填充区域范围中心点的垂直偏移百分比。它们的关系如下：<br>
     *              设填充区域范围中心点的坐标为（x0, y0），填充中心点的坐标为（x, y），填充区域范围的高度为 b，垂直偏移百分比为 dy，则 y=y0 + b*dx/100。
     */
    this.fillGradientOffsetRatioY = 0;

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.fillOpaqueRate=100]
     * @description 填充不透明度。合法值为 0 - 100 的数值。其中为 0 表示完全透明；
     *              100 表示完全不透明。赋值小于 0 时按照 0 处理，大于 100 时按照 100 处理。
     */
    this.fillOpaqueRate = 100;

    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillSymbolID
     * @description 填充符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于填充符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */
    this.fillSymbolID = 0;

    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.lineColor
     * @description 矢量要素的边线颜色。如果等级符号是点符号，点符号的颜色由 lineColor 控制。
     */
    this.lineColor = new _ServerColor.ServerColor(0, 0, 0);

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.lineSymbolID=0]
     * @description 线状符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */
    this.lineSymbolID = 0;

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.lineWidth=1.0]
     * @description 边线的宽度。单位为毫米，精度到 0.1。
     */
    this.lineWidth = 1;

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerAngle=0]
     * @description 点状符号的旋转角度。以度为单位，精确到 0.1 度，逆时针方向为正方向。
     */
    this.markerAngle = 0;

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerSize=1.0]
     * @description 点状符号的大小。单位为毫米，精度为 0.1。当该属性设置为0时，采用符号默认大小 1.0 显示。
     *              当该属性设置为非法值时，交由服务器默认处理。
     */
    this.markerSize = 1;

    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerSymbolID=-1]
     * @description 点状符号的编码。此编码用于唯一标识各点状符号。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */
    this.markerSymbolID = -1;
    if (options) {
      _Util.Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.ServerStyle";
  }

  /**
   * @function SuperMap.ServerStyle.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(ServerStyle, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      if (me.fillBackColor) {
        me.fillBackColor.destroy();
        me.fillBackColor = null;
      }
      me.fillBackOpaque = null;

      if (me.fillForeColor) {
        me.fillForeColor.destroy();
        me.fillForeColor = null;
      }
      me.fillGradientMode = null;
      me.fillGradientAngle = null;
      me.fillGradientOffsetRatioX = null;
      me.fillGradientOffsetRatioY = null;
      me.fillOpaqueRate = null;
      me.fillSymbolID = null;
      if (me.lineColor) {
        me.lineColor.destroy();
        me.lineColor = null;
      }
      me.lineSymbolID = null;
      me.lineWidth = null;
      me.markerAngle = null;
      me.markerSize = null;
      me.markerSymbolID = null;
    }

    /**
     * @function SuperMap.ServerStyle.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     * @returns {Object} 对应的 JSON 格式对象.
     */

  }, {
    key: 'toServerJSONObject',
    value: function toServerJSONObject() {
      var styleObj = {};
      styleObj = _Util.Util.copyAttributes(styleObj, this);
      //暂时先忽略serverColor往Json的转换
      return styleObj;
    }

    /**
     * @function SuperMap.ServerStyle.fromJson
     * @description 将JSON对象转换为 SuperMap.ServerStyle 对象。
     * @param jsonObject - {Object} 要转换的 JSON 对象。
     * @returns {SuperMap.ServerStyle} 转化后的 SuperMap.ServerStyle 对象。
     */

  }], [{
    key: 'fromJson',
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }
      return new ServerStyle({
        fillBackColor: _ServerColor.ServerColor.fromJson(jsonObject.fillBackColor),
        fillBackOpaque: jsonObject.fillBackOpaque,
        fillForeColor: _ServerColor.ServerColor.fromJson(jsonObject.fillForeColor),
        fillGradientMode: jsonObject.fillGradientMode,
        fillGradientAngle: jsonObject.fillGradientAngle,
        fillGradientOffsetRatioX: jsonObject.fillGradientOffsetRatioX,
        fillGradientOffsetRatioY: jsonObject.fillGradientOffsetRatioY,
        fillOpaqueRate: jsonObject.fillOpaqueRate,
        fillSymbolID: jsonObject.fillSymbolID,
        lineColor: _ServerColor.ServerColor.fromJson(jsonObject.lineColor),
        lineSymbolID: jsonObject.lineSymbolID,
        lineWidth: jsonObject.lineWidth,
        markerAngle: jsonObject.markerAngle,
        markerSize: jsonObject.markerSize,
        markerSymbolID: jsonObject.markerSymbolID
      });
    }
  }]);

  return ServerStyle;
}();

_SuperMap.SuperMap.ServerStyle = ServerStyle;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NetworkAnalystServiceBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(6);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.NetworkAnalystServiceBase
 * @category iServer NetworkAnalyst
 * @classdesc 网络分析服务基类。
 * @description 网络分析服务基类。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。
 * @param {Object} options - 参数。
 *
 */
var NetworkAnalystServiceBase = exports.NetworkAnalystServiceBase = function (_CommonServiceBase) {
    _inherits(NetworkAnalystServiceBase, _CommonServiceBase);

    function NetworkAnalystServiceBase(url, options) {
        _classCallCheck(this, NetworkAnalystServiceBase);

        /**
         * @member {SuperMap.DataFormat} [SuperMap.NetworkAnalystServiceBase.prototype.format=SuperMap.DataFormat.GEOJSON]
         * @description 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式，参数格式为 "ISERVER","GEOJSON"
         */
        var _this = _possibleConstructorReturn(this, (NetworkAnalystServiceBase.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;

        _this.CLASS_NAME = "SuperMap.NetworkAnalystServiceBase";
        return _this;
    }

    /**
     * @function SuperMap.NetworkAnalystServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    _createClass(NetworkAnalystServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(NetworkAnalystServiceBase.prototype.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _Util.Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                analystResult = me.toGeoJSONResult(result);
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.toGeoJSONResult
         * @description 将含有 geometry 的数据转换为 GeoJSON 格式。只处理结果中的路由，由子类实现。
         * @param {Object} result - 服务器返回的结果对象。
         * @returns {GeoJSONObject} GeoJSON 对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            // eslint-disable-line no-unused-vars
            return null;
        }
    }]);

    return NetworkAnalystServiceBase;
}(_CommonServiceBase2.CommonServiceBase);

_SuperMap.SuperMap.NetworkAnalystServiceBase = NetworkAnalystServiceBase;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterParameter = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

__webpack_require__(72);

__webpack_require__(242);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FilterParameter
 * @category iServer
 * @classdesc 查询过滤条件参数类。该类用于设置查询数据集的查询过滤参数。
 * @param {Object} options - 参数。 
 * @param {string} options.attributeFilter - 属性过滤条件。 
 * @param {string} options.name - 查询数据集名称或者图层名称。 
 * @param {Array.<SuperMap.JoinItem>} [options.joinItems] - 与外部表的连接信息 SuperMap.JoinItem 数组。 
 * @param {Array.<SuperMap.LinkItem>} [options.linkItems] - 与外部表的关联信息 SuperMap.LinkItem 数组。 
 * @param {Array.<string>} [options.ids] - 查询 id 数组，即属性表中的 SmID 值。 
 * @param {string} [options.orderBy] - 查询排序的字段，orderBy 的字段须为数值型的。 
 * @param {string} [options.groupBy] - 查询分组条件的字段。 
 * @param {Array.<string>} [options.fields] - 查询字段数组。 
 */
var FilterParameter = exports.FilterParameter = function () {
  function FilterParameter(options) {
    _classCallCheck(this, FilterParameter);

    /**
     * @member {string} SuperMap.FilterParameter.prototype.attributeFilter
     * @description 属性过滤条件。
     * 相当于 SQL 语句中的 WHERE 子句，其格式为：WHERE <条件表达式>，
     * attributeFilter 就是其中的“条件表达式”。
     * 该字段的用法为 attributeFilter = "过滤条件"。
     * 例如，要查询字段 fieldValue 小于100的记录，设置 attributeFilter = "fieldValue < 100"；
     * 要查询字段 name 的值为“酒店”的记录，设置 attributeFilter = "name like '%酒店%'"，等等。
     */
    this.attributeFilter = null;

    /**
     * @member {string} SuperMap.FilterParameter.prototype.name
     * @description 查询数据集名称或者图层名称，根据实际的查询对象而定。
     * 一般情况下该字段为数据集名称，但在进行与地图相关功能的操作时，
     * 需要设置为图层名称（图层名称格式：数据集名称@数据源别名）。
     * 因为一个地图的图层可能是来自于不同数据源的数据集，
     * 而不同的数据源中可能存在同名的数据集，
     * 使用数据集名称不能唯一的确定数据集，
     * 所以在进行与地图相关功能的操作时，该值需要设置为图层名称。
     */
    this.name = null;

    /**
     * @member {Array.<SuperMap.JoinItem>} [SuperMap.FilterParameter.prototype.joinItems]
     * @description 与外部表的连接信息 SuperMap.JoinItem 数组。
     */
    this.joinItems = null;

    /**
     * @member {Array.<SuperMap.LinkItem>} [SuperMap.FilterParameter.prototype.linkItems]
     * @description 与外部表的关联信息 LinkItem 数组。
     */
    this.linkItems = null;

    /**
     * @member {Array.<string>} [SuperMap.FilterParameter.prototype.ids]
     * @description 查询 id 数组，即属性表中的 SmID 值。
     */
    this.ids = null;

    /**
     * @member {string} [SuperMap.FilterParameter.prototype.orderBy]
     * @description 查询排序的字段，orderBy的字段须为数值型的。
     * 相当于 SQL 语句中的 ORDER BY 子句，其格式为：ORDER BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段排序时，该字段的用法为 orderBy = "字段名"；
     * 对多个字段排序时，字段之间以英文逗号进行分割，用法为 orderBy = "字段名1, 字段名2"。
     * 例如，现有一个国家数据集，它有两个字段分别为“SmArea”和“pop_1994”，
     * 分别表示国家的面积和1994年的各国人口数量。
     * 如果要按照各国人口数量对记录进行排序，则 orderBy = "pop_1994"；
     * 如果要以面积和人口进行排序，则 orderBy = "SmArea, pop_1994"。
     */
    this.orderBy = null;

    /**
     * @member {string} [SuperMap.FilterParameter.prototype.groupBy]
     * @description 查询分组条件的字段。
     * 相当于 SQL 语句中的 GROUP BY 子句，其格式为：GROUP BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段分组时，该字段的用法为 groupBy = "字段名"；
     * 对多个字段分组时，字段之间以英文逗号进行分割，用法为 groupBy = "字段名1, 字段名2"。
     * 例如，现有一个全球城市数据集，该数据集有两个字段分别为“Continent”和“Country”，
     * 分别表示某个城市所属的洲和国家。
     * 如果要按照国家对全球的城市进行分组， 可以设置 groupBy = "Country"；
     * 如果以洲和国家对城市进行分组，设置 groupBy = "Continent, Country"。
     */
    this.groupBy = null;

    /**
     * @member {Array.<string>} [SuperMap.FilterParameter.prototype.fields]
     * @description 查询字段数组，如果不设置则使用系统返回的所有字段。
     */
    this.fields = null;
    if (options) {
      _Util.Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.FilterParameter";
  }

  /**
   * @function SuperMap.FilterParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(FilterParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.attributeFilter = null;
      me.name = null;
      if (me.joinItems) {
        for (var i = 0, joinItems = me.joinItems, len = joinItems.length; i < len; i++) {
          joinItems[i].destroy();
        }
        me.joinItems = null;
      }
      if (me.linkItems) {
        for (var _i = 0, linkItems = me.linkItems, _len = linkItems.length; _i < _len; _i++) {
          linkItems[_i].destroy();
        }
        me.linkItems = null;
      }
      me.ids = null;
      me.orderBy = null;
      me.groupBy = null;
      me.fields = null;
    }
  }]);

  return FilterParameter;
}();

_SuperMap.SuperMap.FilterParameter = FilterParameter;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FetchRequest = exports.getRequestTimeout = exports.setRequestTimeout = exports.isCORS = exports.setCORS = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                               * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                               * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


__webpack_require__(439);

__webpack_require__(434);

var _fetchJsonp2 = __webpack_require__(433);

var _fetchJsonp3 = _interopRequireDefault(_fetchJsonp2);

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fetch = window.fetch;
/**
 * @function SuperMap.setCORS
 * @description 设置是否支持跨域。
 * @param {boolean} cors - 是否支持跨域。
 */
var setCORS = exports.setCORS = _SuperMap.SuperMap.setCORS = function (cors) {
    _SuperMap.SuperMap.CORS = cors;
};
/**
 * @function SuperMap.isCORS
 * @description 是否支持跨域。
 * @returns {boolean} 是否支持跨域。
 */
var isCORS = exports.isCORS = _SuperMap.SuperMap.isCORS = function () {
    if (_SuperMap.SuperMap.CORS != undefined) {
        return _SuperMap.SuperMap.CORS;
    }
    return window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest();
};
/**
 * @function SuperMap.setRequestTimeout
 * @description 设置请求超时时间。
 * @param {number} [timeout=45] - 请求超时时间，单位秒。
 */
var setRequestTimeout = exports.setRequestTimeout = _SuperMap.SuperMap.setRequestTimeout = function (timeout) {
    return _SuperMap.SuperMap.RequestTimeout = timeout;
};
/**
 * @function SuperMap.getRequestTimeout
 * @description 获取请求超时时间。
 * @returns {number} 请求超时时间。
 */
var getRequestTimeout = exports.getRequestTimeout = _SuperMap.SuperMap.getRequestTimeout = function () {
    return _SuperMap.SuperMap.RequestTimeout || 45000;
};
var FetchRequest = exports.FetchRequest = _SuperMap.SuperMap.FetchRequest = {
    commit: function commit(method, url, params, options) {
        method = method ? method.toUpperCase() : method;
        switch (method) {
            case 'GET':
                return this.get(url, params, options);
            case 'POST':
                return this.post(url, params, options);
            case 'PUT':
                return this.put(url, params, options);
            case 'DELETE':
                return this.delete(url, params, options);
            default:
                return this.get(url, params, options);
        }
    },
    supportDirectRequest: function supportDirectRequest(url, options) {
        return _Util.Util.isInTheSameDomain(url) || isCORS() || options.proxy;
    },
    get: function get(url, params, options) {
        options = options || {};
        var type = 'GET';
        url = this._processUrl(url, options);
        url = _Util.Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.supportDirectRequest(url, options)) {
            url = url.replace('.json', '.jsonp');
            var config = {
                url: url,
                data: params
            };
            return _SuperMap.SuperMap.Util.RequestJSONPPromise.GET(config);
        }
        if (!this.urlIsLong(url)) {
            return this._fetch(url, params, options, type);
        } else {
            return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
        }
    },

    delete: function _delete(url, params, options) {
        options = options || {};
        var type = 'DELETE';
        url = this._processUrl(url, options);
        url = _Util.Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.supportDirectRequest(url, options)) {
            url = url.replace('.json', '.jsonp');
            var config = {
                url: url += "&_method=DELETE",
                data: params
            };
            return _SuperMap.SuperMap.Util.RequestJSONPPromise.DELETE(config);
        }
        if (this.urlIsLong(url)) {
            return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
        }
        return this._fetch(url, params, options, type);
    },
    post: function post(url, params, options) {
        options = options || {};
        if (!this.supportDirectRequest(url, options)) {
            url = url.replace('.json', '.jsonp');
            var config = {
                url: url += "&_method=POST",
                data: params
            };
            return _SuperMap.SuperMap.Util.RequestJSONPPromise.POST(config);
        }
        return this._fetch(this._processUrl(url, options), params, options, 'POST');
    },

    put: function put(url, params, options) {
        options = options || {};
        url = this._processUrl(url, options);
        if (!this.supportDirectRequest(url, options)) {
            url = url.replace('.json', '.jsonp');
            var config = {
                url: url += "&_method=PUT",
                data: params
            };
            return _SuperMap.SuperMap.Util.RequestJSONPPromise.PUT(config);
        }
        return this._fetch(url, params, options, 'PUT');
    },
    urlIsLong: function urlIsLong(url) {
        //当前url的字节长度。
        var totalLength = 0,
            charCode = null;
        for (var i = 0, len = url.length; i < len; i++) {
            //转化为Unicode编码
            charCode = url.charCodeAt(i);
            if (charCode < 0x007f) {
                totalLength++;
            } else if (0x0080 <= charCode && charCode <= 0x07ff) {
                totalLength += 2;
            } else if (0x0800 <= charCode && charCode <= 0xffff) {
                totalLength += 3;
            }
        }
        return totalLength < 2000 ? false : true;
    },
    _postSimulatie: function _postSimulatie(type, url, params, options) {
        var separator = url.indexOf("?") > -1 ? "&" : "?";
        url += separator + '_method=' + type;
        if (typeof params !== 'string') {
            params = JSON.stringify(params);
        }
        return this.post(url, params, options);
    },

    _processUrl: function _processUrl(url, options) {
        if (this._isMVTRequest(url)) {
            return url;
        }

        if (url.indexOf('.json') === -1 && !options.withoutFormatSuffix) {
            if (url.indexOf("?") < 0) {
                url += '.json';
            } else {
                var urlArrays = url.split("?");
                if (urlArrays.length === 2) {
                    url = urlArrays[0] + ".json?" + urlArrays[1];
                }
            }
        }
        if (options && options.proxy) {
            if (typeof options.proxy === "function") {
                url = options.proxy(url);
            } else {
                url = decodeURIComponent(url);
                url = options.proxy + encodeURIComponent(url);
            }
        }
        return url;
    },

    _fetch: function _fetch(url, params, options, type) {
        options = options || {};
        options.headers = options.headers || {};
        if (!options.headers['Content-Type']) {
            options.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8';
        }
        if (options.timeout) {
            return this._timeout(options.timeout, fetch(url, {
                method: type,
                headers: options.headers,
                body: type === 'PUT' || type === 'POST' ? params : undefined,
                credentials: options.withCredentials ? 'include' : 'omit',
                mode: 'cors',
                timeout: getRequestTimeout()
            }).then(function (response) {
                return response;
            }));
        }
        return fetch(url, {
            method: type,
            body: type === 'PUT' || type === 'POST' ? params : undefined,
            headers: options.headers,
            credentials: options.withCredentials ? 'include' : 'omit',
            mode: 'cors',
            timeout: getRequestTimeout()
        }).then(function (response) {
            return response;
        });
    },

    _fetchJsonp: function _fetchJsonp(url, options) {
        options = options || {};
        return (0, _fetchJsonp3.default)(url, {
            method: 'GET',
            timeout: options.timeout
        }).then(function (response) {
            return response;
        });
    },

    _timeout: function _timeout(seconds, promise) {
        return new Promise(function (resolve, reject) {
            setTimeout(function () {
                reject(new Error("timeout"));
            }, seconds);
            promise.then(resolve, reject);
        });
    },

    _getParameterString: function _getParameterString(params) {
        var paramsArray = [];
        for (var key in params) {
            var value = params[key];
            if (value != null && typeof value !== 'function') {
                var encodedValue;
                if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                    var encodedItemArray = [];
                    var item;
                    for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                        item = value[itemIndex];
                        encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                    }
                    encodedValue = '[' + encodedItemArray.join(",") + ']';
                } else {
                    encodedValue = encodeURIComponent(value);
                }
                paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
            }
        }
        return paramsArray.join("&");
    },

    _isMVTRequest: function _isMVTRequest(url) {
        return url.indexOf('.mvt') > -1 || url.indexOf('.pbf') > -1;
    }
};
_SuperMap.SuperMap.Util.RequestJSONPPromise = {
    limitLength: 1500,
    queryKeys: [],
    queryValues: [],
    supermap_callbacks: {},
    addQueryStrings: function addQueryStrings(values) {
        var me = this;
        for (var key in values) {
            me.queryKeys.push(key);
            if (typeof values[key] !== "string") {
                values[key] = _SuperMap.SuperMap.Util.toJSON(values[key]);
            }
            var tempValue = encodeURIComponent(values[key]);
            me.queryValues.push(tempValue);
        }
    },
    issue: function issue(config) {
        var me = this,
            uid = me.getUid(),
            url = config.url,
            splitQuestUrl = [];
        var p = new Promise(function (resolve) {
            me.supermap_callbacks[uid] = function (response) {
                delete me.supermap_callbacks[uid];
                resolve(response);
            };
        });

        // me.addQueryStrings({
        //     callback: "SuperMap.Util.RequestJSONPPromise.supermap_callbacks[" + uid + "]"
        // });
        var sectionURL = url,
            keysCount = 0; //此次sectionURL中有多少个key
        var length = me.queryKeys ? me.queryKeys.length : 0;
        for (var i = 0; i < length; i++) {
            if (sectionURL.length + me.queryKeys[i].length + 2 >= me.limitLength) {
                //+2 for ("&"or"?")and"="
                if (keysCount == 0) {
                    return false;
                }
                splitQuestUrl.push(sectionURL);
                sectionURL = url;
                keysCount = 0;
                i--;
            } else {
                if (sectionURL.length + me.queryKeys[i].length + 2 + me.queryValues[i].length > me.limitLength) {
                    var leftValue = me.queryValues[i];
                    while (leftValue.length > 0) {
                        var leftLength = me.limitLength - sectionURL.length - me.queryKeys[i].length - 2; //+2 for ("&"or"?")and"="
                        if (sectionURL.indexOf("?") > -1) {
                            sectionURL += "&";
                        } else {
                            sectionURL += "?";
                        }
                        var tempLeftValue = leftValue.substring(0, leftLength);
                        //避免 截断sectionURL时，将类似于%22这样的符号截成两半，从而导致服务端组装sectionURL时发生错误
                        if (tempLeftValue.substring(leftLength - 1, leftLength) === "%") {
                            leftLength -= 1;
                            tempLeftValue = leftValue.substring(0, leftLength);
                        } else if (tempLeftValue.substring(leftLength - 2, leftLength - 1) === "%") {
                            leftLength -= 2;
                            tempLeftValue = leftValue.substring(0, leftLength);
                        }

                        sectionURL += me.queryKeys[i] + "=" + tempLeftValue;
                        leftValue = leftValue.substring(leftLength);
                        if (tempLeftValue.length > 0) {
                            splitQuestUrl.push(sectionURL);
                            sectionURL = url;
                            keysCount = 0;
                        }
                    }
                } else {
                    keysCount++;
                    if (sectionURL.indexOf("?") > -1) {
                        sectionURL += "&";
                    } else {
                        sectionURL += "?";
                    }
                    sectionURL += me.queryKeys[i] + "=" + me.queryValues[i];
                }
            }
        }
        splitQuestUrl.push(sectionURL);
        me.send(splitQuestUrl, "SuperMap.Util.RequestJSONPPromise.supermap_callbacks[" + uid + "]", config && config.proxy);
        return p;
    },

    getUid: function getUid() {
        var uid = new Date().getTime(),
            random = Math.floor(Math.random() * 1e17);
        return uid * 1000 + random;
    },

    send: function send(splitQuestUrl, callback, proxy) {
        var len = splitQuestUrl.length;
        if (len > 0) {
            var jsonpUserID = new Date().getTime();
            for (var i = 0; i < len; i++) {
                var url = splitQuestUrl[i];
                if (url.indexOf("?") > -1) {
                    url += "&";
                } else {
                    url += "?";
                }
                url += "sectionCount=" + len;
                url += "&sectionIndex=" + i;
                url += "&jsonpUserID=" + jsonpUserID;
                if (proxy) {
                    url = decodeURIComponent(url);
                    url = proxy + encodeURIComponent(url);
                }
                (0, _fetchJsonp3.default)(url, {
                    jsonpCallbackFunction: callback,
                    timeout: 30000
                });
            }
        }
    },

    GET: function GET(config) {
        var me = this;
        me.queryKeys.length = 0;
        me.queryValues.length = 0;
        me.addQueryStrings(config.params);
        return me.issue(config);
    },

    POST: function POST(config) {
        var me = this;
        me.queryKeys.length = 0;
        me.queryValues.length = 0;
        me.addQueryStrings({
            requestEntity: config.data
        });
        return me.issue(config);
    },

    PUT: function PUT(config) {
        var me = this;
        me.queryKeys.length = 0;
        me.queryValues.length = 0;
        me.addQueryStrings({
            requestEntity: config.data
        });
        return me.issue(config);
    },
    DELETE: function DELETE(config) {
        var me = this;
        me.queryKeys.length = 0;
        me.queryValues.length = 0;
        me.addQueryStrings({
            requestEntity: config.data
        });
        return me.issue(config);
    }
};

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.GeoJSON = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Vector = __webpack_require__(75);

var _Util = __webpack_require__(1);

var _Bounds = __webpack_require__(28);

var _Collection = __webpack_require__(31);

var _JSON = __webpack_require__(106);

var _Point = __webpack_require__(23);

var _MultiPoint = __webpack_require__(43);

var _LineString = __webpack_require__(22);

var _MultiLineString = __webpack_require__(51);

var _LinearRing = __webpack_require__(38);

var _Polygon = __webpack_require__(49);

var _MultiPolygon = __webpack_require__(50);

var _ServerGeometry = __webpack_require__(8);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Format.GeoJSON
 * @classdesc  GeoJSON 的读和写。使用 {@link SuperMap.Format.GeoJSON} 构造器创建一个 GeoJSON 解析器。
 * @category BaseTypes Format
 * @param {Object} [options] - 参数。
 * @param {string} [options.indent="    "] - 用于格式化输出，indent 字符串会在每次缩进的时候使用一次。
 * @param {string} [options.space=" "] - 用于格式化输出，space 字符串会在名值对的 ":" 后边添加。
 * @param {string} [options.newline="\n"] - 用于格式化输出, newline 字符串会用在每一个名值对或数组项末尾。
 * @param {number} [options.level=0] - 用于格式化输出, 表示的是缩进级别。
 * @param {boolean} [options.pretty=false] - 是否在序列化的时候使用额外的空格控制结构。在 write 方法中使用。
 * @param {boolean} [options.nativeJSON] - 需要被注册的监听器对象。
 * @param {boolean} [options.ignoreExtraDims=true] - 忽略维度超过 2 的几何要素。
 * @extends {SuperMap.Format.JSON}
 */
var GeoJSON = exports.GeoJSON = function (_JSONFormat) {
    _inherits(GeoJSON, _JSONFormat);

    function GeoJSON(options) {
        _classCallCheck(this, GeoJSON);

        /**
         * @member {boolean} [SuperMap.Format.GeoJSON.prototype.ignoreExtraDims=true]
         * @description 忽略维度超过 2 的几何要素。
         */
        var _this = _possibleConstructorReturn(this, (GeoJSON.__proto__ || Object.getPrototypeOf(GeoJSON)).call(this, options));

        _this.ignoreExtraDims = true;

        _this.CLASS_NAME = "SuperMap.Format.GeoJSON";
        /**
         * @member {Object} SuperMap.Format.GeoJSON.prototype.parseCoords 
         * @private
         * @description 一个属性名对应着 GeoJSON 对象的几何类型的对象。每个属性其实都是一个实际上做解析用的方法。
         */
        _this.parseCoords = {
            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.point
             * @description 将一组坐标转成一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的一组坐标。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "point": function point(array) {
                if (this.ignoreExtraDims == false && array.length != 2) {
                    throw "Only 2D points are supported: " + array;
                }
                return new _Point.Point(array[0], array[1]);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipoint
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的坐标组数组。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "multipoint": function multipoint(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _MultiPoint.MultiPoint(points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.linestring
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的坐标组数组。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "linestring": function linestring(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _LineString.LineString(points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multilinestring
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的坐标组数组。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "multilinestring": function multilinestring(array) {
                var lines = [];
                var l = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    lines.push(l);
                }
                return new _MultiLineString.MultiLineString(lines);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.polygon
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "polygon": function polygon(array) {
                var rings = [];
                var r, l;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    r = new _LinearRing.LinearRing(l.components);
                    rings.push(r);
                }
                return new _Polygon.Polygon(rings);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipolygon
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的坐标组数组。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "multipolygon": function multipolygon(array) {
                var polys = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["polygon"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    polys.push(p);
                }
                return new _MultiPolygon.MultiPolygon(polys);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.box
             * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
             * @param {Object} array - GeoJSON 片段中的坐标组数组。
             * @returns {SuperMap.Geometry} 一个几何对象。
             */
            "box": function box(array) {
                if (array.length != 2) {
                    throw "GeoJSON box coordinates must have 2 elements";
                }
                return new _Polygon.Polygon([new _LinearRing.LinearRing([new _Point.Point(array[0][0], array[0][1]), new _Point.Point(array[1][0], array[0][1]), new _Point.Point(array[1][0], array[1][1]), new _Point.Point(array[0][0], array[1][1]), new _Point.Point(array[0][0], array[0][1])])]);
            }

        };
        /**
         * @member {Object} SuperMap.Format.GeoJSON.prototype.extract
         * @private
         * @description 一个属性名对应着GeoJSON类型的对象。其值为相应的实际的解析方法。
         */
        _this.extract = {
            /**
             * @function SuperMap.Format.GeoJSON.extract.feature
             * @description 返回一个表示单个要素对象的 GeoJSON 的一部分。
             * @param {SuperMap.ServerFeature} feature - iServer 要素对象。
             * @returns {Object} 一个表示点的对象。
             */
            'feature': function feature(_feature) {
                var geom = this.extract.geometry.apply(this, [_feature.geometry]);
                var json = {
                    "type": "Feature",
                    "properties": this.createAttributes(_feature),
                    "geometry": geom
                };

                if (_feature.geometry && _feature.geometry.type === 'TEXT') {
                    json.properties.texts = _feature.geometry.texts;
                    json.properties.textStyle = _feature.geometry.textStyle;
                }
                if (_feature.fid) {
                    json.id = _feature.fid;
                }
                if (_feature.ID) {
                    json.id = _feature.ID;
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.geometry
             * @description 返回一个表示单个几何对象的 GeoJSON 的一部分。
             * @param {Object} geometry - iServer 几何对象。
             * @returns {Object} 一个表示几何体的对象。
             */
            'geometry': function geometry(_geometry) {
                if (_geometry == null) {
                    return null;
                }
                if (!_geometry.parts && _geometry.points) {
                    _geometry.parts = [_geometry.points.length];
                }
                var geo = new _ServerGeometry.ServerGeometry(_geometry).toGeometry() || _geometry;
                var geometryType = geo.geometryType || geo.type;
                var data;
                if (geometryType === "LinearRing") {
                    geometryType = "LineString";
                }
                if (geometryType === "LINEM") {
                    geometryType = "MultiLineString";
                }
                data = this.extract[geometryType.toLowerCase()].apply(this, [geo]);
                geometryType = geometryType === 'TEXT' ? 'Point' : geometryType;
                var json;
                if (geometryType === "Collection") {
                    json = {
                        "type": "GeometryCollection",
                        "geometries": data
                    };
                } else {
                    json = {
                        "type": geometryType,
                        "coordinates": data
                    };
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个点对象中返回一个坐标组。
             * @param {SuperMap.Geometry.Point} point - 一个点对象。
             * @returns {Array} 一个表示一个点的坐标组。
             */
            'point': function point(_point) {
                var p = [_point.x, _point.y];
                for (var name in _point) {
                    if (name !== "x" && name !== "y" && _point[name] !== null && !isNaN(_point[name])) {
                        p.push(_point[name]);
                    }
                }
                return p;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个文本对象中返回一个坐标组。
             * @param {Object} geo - 一个文本对象。
             * @returns {Array} 一个表示一个点的坐标组。
             */
            'text': function text(geo) {
                return [geo.points[0].x, geo.points[0].y];
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipoint
             * @description 从一个多点对象中返一个坐标组数组。
             * @param {SuperMap.Geometry.MultiPoint} multipoint - 多点对象。
             * @returns {Array} 一个表示多点的坐标组数组。
             */
            'multipoint': function multipoint(_multipoint) {
                var array = [];
                for (var i = 0, len = _multipoint.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_multipoint.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.linestring
             * @description 从一个线对象中返回一个坐标组数组。
             * @param {SuperMap.Geometry.Linestring} linestring - 线对象。
             * @returns {Array} 一个表示线对象的坐标组数组。
             */
            'linestring': function linestring(_linestring) {
                var array = [];
                for (var i = 0, len = _linestring.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_linestring.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multilinestring
             * @description 从一个多线对象中返回一个线数组。
             * @param {SuperMap.Geometry.MultiLinestring} multilinestring - 多线对象。
             *
             * @returns {Array} 一个表示多线的线数组。
             */
            'multilinestring': function multilinestring(_multilinestring) {
                var array = [];
                for (var i = 0, len = _multilinestring.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [_multilinestring.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.polygon
             * @description 从一个面对象中返回一组线环。
             * @param {SuperMap.Geometry.Polygon} polygon - 面对象。
             * @returns {Array} 一组表示面的线环。
             */
            'polygon': function polygon(_polygon) {
                var array = [];
                for (var i = 0, len = _polygon.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [_polygon.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipolygon
             * @description 从一个多面对象中返回一组面。
             * @param {SuperMap.Geometry.MultiPolygon} multipolygon - 多面对象。
             * @returns {Array} 一组表示多面的面。
             */
            'multipolygon': function multipolygon(_multipolygon) {
                var array = [];
                for (var i = 0, len = _multipolygon.components.length; i < len; ++i) {
                    array.push(this.extract.polygon.apply(this, [_multipolygon.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.collection
             * @description 从一个几何要素集合中一组几何要素数组。
             * @param {SuperMap.Geometry.Collection} collection - 几何要素集合。
             * @returns {Array} 一组表示几何要素集合的几何要素数组。
             */
            'collection': function collection(_collection) {
                var len = _collection.components.length;
                var array = new Array(len);
                for (var i = 0; i < len; ++i) {
                    array[i] = this.extract.geometry.apply(this, [_collection.components[i]]);
                }
                return array;
            }
        };
        return _this;
    }

    /**
     * @function SuperMap.Format.GeoJSON.prototype.read
     * @description 将 GeoJSON 对象或者GeoJSON 对象字符串转换为 SuperMap Feature 对象。
     * @param {GeoJSONObject} json - GeoJSON 对象。
     * @param {string} [type='FeaureCollection'] - 可选的字符串，它决定了输出的格式。支持的值有："Geometry","Feature"，和 "FeatureCollection"，如果此值为null。
     * @param {Function} filter - 对象中每个层次每个键值对都会调用此函数得出一个结果。每个值都会被 filter 函数的结果所替换掉。这个函数可被用来将某些对象转化成某个类相应的对象，或者将日期字符串转化成Date对象。
     * @returns {Object}  返回值依赖于 type 参数的值。
     *     -如果 type 等于 "FeatureCollection"，返回值将会是 {@link SuperMap.Feature.Vector} 数组。
     *     -如果 type 为 "Geometry",输入的 JSON 对象必须表示一个唯一的几何体，然后返回值就会是 {@link SuperMap.Feature.Geometry}。
     *     -如果 type 为 "Feature"，输入的 JSON 对象也必须表示的一个要素，这样返回值才会是 {@link SuperMap.Feature.Vector}。
     */

    _createClass(GeoJSON, [{
        key: 'read',
        value: function read(json, type, filter) {
            type = type ? type : "FeatureCollection";
            var results = null;
            var obj = null;
            if (typeof json == "string") {
                obj = _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'read', this).call(this, json, filter);
            } else {
                obj = json;
            }
            if (!obj) {
                //SuperMap.Console.error("Bad JSON: " + json);
            } else if (typeof obj.type != "string") {
                //SuperMap.Console.error("Bad GeoJSON - no type: " + json);
            } else if (this.isValidType(obj, type)) {
                switch (type) {
                    case "Geometry":
                        try {
                            results = this.parseGeometry(obj);
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "Feature":
                        try {
                            results = this.parseFeature(obj);
                            results.type = "Feature";
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "FeatureCollection":
                        // for type FeatureCollection, we allow input to be any type
                        results = [];
                        switch (obj.type) {
                            case "Feature":
                                try {
                                    results.push(this.parseFeature(obj));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                                break;
                            case "FeatureCollection":
                                for (var i = 0, len = obj.features.length; i < len; ++i) {
                                    try {
                                        results.push(this.parseFeature(obj.features[i]));
                                    } catch (err) {
                                        results = null;
                                        // SuperMap.Console.error(err);
                                    }
                                }
                                break;
                            default:
                                try {
                                    var geom = this.parseGeometry(obj);
                                    results.push(new _Vector.Vector(geom));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                        }
                        break;
                    default:
                        break;
                }
            }
            return results;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.write
         * @description iServer Geometry JSON 对象 转 GeoJSON对象字符串。
         * @param {Object} obj - iServer Geometry JSON 对象。
         * @param {boolean} [pretty=false] - 是否使用换行和缩进来控制输出。
         * @returns {GeoJSONObject} 一个 GeoJSON 字符串，它表示了输入的几何对象，要素对象，或者要素对象数组。
         */

    }, {
        key: 'write',
        value: function write(obj, pretty) {
            return _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'write', this).call(this, this.toGeoJSON(obj), pretty);
        }
        /**
         * @function SuperMap.Format.GeoJSON.prototype.fromGeoJSON
         * @version 9.1.1
         * @description 将 GeoJSON 对象或者GeoJSON 对象字符串转换为iServer Feature JSON。
         * @param {GeoJSONObject} json - GeoJSON 对象。
         * @param {string} [type='FeaureCollection'] - 可选的字符串，它决定了输出的格式。支持的值有："Geometry","Feature"，和 "FeatureCollection"，如果此值为null。
         * @param {Function} filter - 对象中每个层次每个键值对都会调用此函数得出一个结果。每个值都会被 filter 函数的结果所替换掉。这个函数可被用来将某些对象转化成某个类相应的对象，或者将日期字符串转化成Date对象。
         * @returns {Object}  iServer Feature JSON。
         */

    }, {
        key: 'fromGeoJSON',
        value: function fromGeoJSON(json, type, filter) {
            var _this2 = this;

            var feature = this.read(json, type, filter);
            if (!_Util.Util.isArray(feature)) {
                return this._toiSevrerFeature(feature);
            }
            return feature.map(function (element) {
                return _this2._toiSevrerFeature(element);
            });
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.toGeoJSON
         * @version 9.1.1
         * @description 将 iServer Feature JSON 对象转换为 GeoJSON 对象。
         * @param {Object} obj - iServer Feature JSON。
         * @returns {GeoJSONObject}  GeoJSON 对象。
         */

    }, {
        key: 'toGeoJSON',
        value: function toGeoJSON(obj) {
            var geojson = {
                "type": null
            };
            if (_Util.Util.isArray(obj)) {
                geojson.type = "FeatureCollection";
                var numFeatures = obj.length;
                geojson.features = new Array(numFeatures);
                for (var i = 0; i < numFeatures; ++i) {
                    var element = obj[i];
                    if (isGeometry(element)) {
                        var feature = {};
                        feature.geometry = element;
                        geojson.features[i] = this.extract.feature.apply(this, [feature]);
                    } else {
                        geojson.features[i] = this.extract.feature.apply(this, [element]);
                    }
                }
            } else if (isGeometry(obj)) {
                var _feature2 = {};
                _feature2.geometry = obj;
                geojson = this.extract.feature.apply(this, [_feature2]);
            } else {
                geojson = this.extract.feature.apply(this, [obj]);
            }

            function isGeometry(input) {
                return input.hasOwnProperty("parts") && input.hasOwnProperty("points");
            }

            return geojson;
        }
        /**
         *  @function SuperMap.Format.GeoJSON.prototype.isValidType
         *  @description 检查一个 GeoJSON 对象是否和给定的类型相符的合法的对象。
         *  @returns {boolean} GeoJSON 是否是给定类型的合法对象。
         *  @private
         */

    }, {
        key: 'isValidType',
        value: function isValidType(obj, type) {
            var valid = false;
            switch (type) {
                case "Geometry":
                    if (_Util.Util.indexOf(["Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon", "Box", "GeometryCollection"], obj.type) == -1) {
                        // unsupported geometry type
                        //SuperMap.Console.error("Unsupported geometry type: " +
                        // obj.type);
                    } else {
                        valid = true;
                    }
                    break;
                case "FeatureCollection":
                    // allow for any type to be converted to a feature collection
                    valid = true;
                    break;
                default:
                    // for Feature types must match
                    if (obj.type == type) {
                        valid = true;
                    } else {
                        //SuperMap.Console.error("Cannot convert types from " +
                        //obj.type + " to " + type);
                    }
            }
            return valid;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseFeature
         * @description 将一个 GeoJSON 中的 feature 转化成 {@link SuperMap.Feature.Vector}> 对象。
         * @private
         * @param {GeoJSONObject} obj - 从 GeoJSON 对象中创建一个对象。
         * @returns {SuperMap.Feature.Vector} 一个要素。
         */

    }, {
        key: 'parseFeature',
        value: function parseFeature(obj) {
            var feature, geometry, attributes, bbox;
            attributes = obj.properties ? obj.properties : {};
            bbox = obj.geometry && obj.geometry.bbox || obj.bbox;
            try {
                geometry = this.parseGeometry(obj.geometry);
            } catch (err) {
                // deal with bad geometries
                throw err;
            }
            feature = new _Vector.Vector(geometry, attributes);
            if (bbox) {
                feature.bounds = _Bounds.Bounds.fromArray(bbox);
            }
            if (obj.id) {
                feature.fid = obj.id;
            }
            return feature;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseGeometry
         * @description 将一个 GeoJSON 中的几何要素转化成 {@link SuperMap.Geometry} 对象。
         * @param {GeoJSONObject} obj - 从 GeoJSON 对象中创建一个对象。
         * @returns {SuperMap.Geometry} 一个几何要素。
         * @private
         */

    }, {
        key: 'parseGeometry',
        value: function parseGeometry(obj) {
            if (obj == null) {
                return null;
            }
            var geometry;
            if (obj.type == "GeometryCollection") {
                if (!_Util.Util.isArray(obj.geometries)) {
                    throw "GeometryCollection must have geometries array: " + obj;
                }
                var numGeom = obj.geometries.length;
                var components = new Array(numGeom);
                for (var i = 0; i < numGeom; ++i) {
                    components[i] = this.parseGeometry.apply(this, [obj.geometries[i]]);
                }
                geometry = new _Collection.Collection(components);
            } else {
                if (!_Util.Util.isArray(obj.coordinates)) {
                    throw "Geometry must have coordinates array: " + obj;
                }
                if (!this.parseCoords[obj.type.toLowerCase()]) {
                    throw "Unsupported geometry type: " + obj.type;
                }
                try {
                    geometry = this.parseCoords[obj.type.toLowerCase()].apply(this, [obj.coordinates]);
                } catch (err) {
                    // deal with bad coordinates
                    throw err;
                }
            }
            return geometry;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.createCRSObject
         * @description 从一个要素对象中创建一个坐标参考系对象。
         * @param {SuperMap.Feature.Vector} object - 要素对象。
         * @private
         * @returns {GeoJSONObject} 一个可作为 GeoJSON 对象的 CRS 属性使用的对象。
         */

    }, {
        key: 'createCRSObject',
        value: function createCRSObject(object) {
            var proj = object.layer.projection.toString();
            var crs = {};
            if (proj.match(/epsg:/i)) {
                var code = parseInt(proj.substring(proj.indexOf(":") + 1));
                if (code == 4326) {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
                        }
                    };
                } else {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "EPSG:" + code
                        }
                    };
                }
            }
            return crs;
        }
    }, {
        key: '_toiSevrerFeature',
        value: function _toiSevrerFeature(feature) {
            var attributes = feature.attributes;
            var attrNames = [];
            var attrValues = [];
            for (var attr in attributes) {
                attrNames.push(attr);
                attrValues.push(attributes[attr]);
            }
            var newFeature = {
                fieldNames: attrNames,
                fieldValues: attrValues,
                geometry: _ServerGeometry.ServerGeometry.fromGeometry(feature.geometry)
            };
            newFeature.geometry.id = feature.fid;
            return newFeature;
        }
    }, {
        key: 'createAttributes',
        value: function createAttributes(feature) {
            if (!feature) {
                return null;
            }
            var attr = {};
            processFieldsAttributes(feature, attr);
            var exceptKeys = ["fieldNames", "fieldValues", "geometry"];
            for (var key in feature) {
                if (exceptKeys.indexOf(key) > -1) {
                    continue;
                }
                attr[key] = feature[key];
            }

            function processFieldsAttributes(feature, attributes) {
                if (!(feature.hasOwnProperty("fieldNames") && feature.hasOwnProperty("fieldValues"))) {
                    return;
                }
                var names = feature.fieldNames,
                    values = feature.fieldValues;
                for (var i in names) {
                    attributes[names[i]] = values[i];
                }
            }

            return attr;
        }
    }]);

    return GeoJSON;
}(_JSON.JSONFormat);

_SuperMap.SuperMap.Format.GeoJSON = GeoJSON;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ProcessingServiceBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _CommonServiceBase2 = __webpack_require__(6);

var _FetchRequest = __webpack_require__(16);

var _Util = __webpack_require__(1);

var _SecurityManager = __webpack_require__(37);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.ProcessingServiceBase
 * @category  iServer ProcessingService
 * @classdesc 分布式分析服务基类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 分布式分析服务地址。
 * @param {Object} options - 参数。
 * @param {SuperMap.Events} options.events - 处理所有事件的对象。
 * @param {number} options.index - 服务访问地址在数组中的位置。
 * @param {number} options.length - 服务访问地址数组长度。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {Object} [options.eventListeners] - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。
 */
var ProcessingServiceBase = exports.ProcessingServiceBase = function (_CommonServiceBase) {
    _inherits(ProcessingServiceBase, _CommonServiceBase);

    function ProcessingServiceBase(url, options) {
        _classCallCheck(this, ProcessingServiceBase);

        options = options || {};
        /*
         * Constant: EVENT_TYPES
         * {Array.<string>}
         * 此类支持的事件类型
         * - *processCompleted* 创建成功后触发的事件。
         * - *processFailed* 创建失败后触发的事件 。
         * - *processRunning* 创建过程的整个阶段都会触发的事件，用于获取创建过程的状态 。
         */
        options.EVENT_TYPES = ["processCompleted", "processFailed", "processRunning"];

        var _this = _possibleConstructorReturn(this, (ProcessingServiceBase.__proto__ || Object.getPrototypeOf(ProcessingServiceBase)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ProcessingServiceBase";
        return _this;
    }

    /**
     * @function SuperMap.ProcessingServiceBase.prototype.destroy
     * @override
     */


    _createClass(ProcessingServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.getJobs
         * @description 获取分布式分析任务。
         * @param {string} url - 资源地址。
         */

    }, {
        key: 'getJobs',
        value: function getJobs(url) {
            var me = this;
            _FetchRequest.FetchRequest.get(me._processUrl(url), null, {
                proxy: me.proxy
            }).then(function (response) {
                return response.json();
            }).then(function (result) {
                me.events.triggerEvent("processCompleted", {
                    result: result
                });
            }).catch(function (e) {
                me.eventListeners.processFailed({
                    error: e
                });
            });
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.addJob
         * @description 添加分布式分析任务。
         * @param {string} url - 资源根地址。
         * @param {Object} params - 创建一个空间分析的请求参数。
         * @param {string} paramType - 请求参数类型。
         * @param {number} seconds - 开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addJob',
        value: function addJob(url, params, paramType, seconds) {
            var me = this,
                parameterObject = null;
            if (params && params instanceof paramType) {
                parameterObject = new Object();
                paramType.toObject(params, parameterObject);
            }
            var options = {
                proxy: me.proxy,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                withCredentials: me.withCredentials,
                isInTheSameDomain: me.isInTheSameDomain
            };
            _FetchRequest.FetchRequest.post(me._processUrl(url), JSON.stringify(parameterObject), options).then(function (response) {
                return response.json();
            }).then(function (result) {
                if (result.succeed) {
                    me.serviceProcessCompleted(result, seconds);
                } else {
                    me.serviceProcessFailed(result);
                }
            }).catch(function (e) {
                me.serviceProcessFailed({
                    error: e
                });
            });
        }
    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result, seconds) {
            result = _Util.Util.transformResult(result);
            seconds = seconds || 1000;
            var me = this;
            if (result) {
                var id = setInterval(function () {
                    _FetchRequest.FetchRequest.get(me._processUrl(result.newResourceLocation), {
                        _t: new Date().getTime()
                    }).then(function (response) {
                        return response.json();
                    }).then(function (job) {
                        me.events.triggerEvent("processRunning", {
                            id: job.id,
                            state: job.state
                        });
                        if (job.state.runState === 'LOST' || job.state.runState === 'KILLED' || job.state.runState === 'FAILED') {
                            clearInterval(id);
                            me.events.triggerEvent("processFailed", {
                                error: job.state.errorMsg,
                                state: job.state.runState
                            });
                        }
                        if (job.state.runState === 'FINISHED' && job.setting.serviceInfo) {
                            clearInterval(id);
                            me.events.triggerEvent("processCompleted", {
                                result: job
                            });
                        }
                    }).catch(function (e) {
                        clearInterval(id);
                        me.events.triggerEvent("processFailed", {
                            error: e
                        });
                    });
                }, seconds);
            }
        }
    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'serviceProcessFailed', this).call(this, result);
        }

        //为不是以.json结尾的url加上.json，并且如果有token的话，在.json后加上token参数。

    }, {
        key: '_processUrl',
        value: function _processUrl(url) {
            if (url.indexOf('.json') === -1) {
                url += '.json';
            }
            if (_SecurityManager.SecurityManager.getToken(url)) {
                url += '?token=' + _SecurityManager.SecurityManager.getToken(url);
            }
            return url;
        }
    }]);

    return ProcessingServiceBase;
}(_CommonServiceBase2.CommonServiceBase);

_SuperMap.SuperMap.ProcessingServiceBase = ProcessingServiceBase;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.MappingParameters
 * @category  iServer ProcessingService
 * @classdesc 分析后结果可视化的参数类。
 * @param {Object} options - 参数。
 * @param {Array.<SuperMap.ThemeGridRangeItem>} [options.items] - 栅格分段专题图子项数组。
 * @param {number} [options.numericPrecision=1] - 精度，此字段用于设置分析结果标签专题图中标签数值的精度，如“1”表示精确到小数点的后一位。
 * @param {SuperMap.RangeMode} [options.rangeMode=SuperMap.RangeMode.EQUALINTERVAL] - 专题图分段模式。
 * @param {number} [options.rangeCount] - 专题图分段个数。
 * @param {SuperMap.ColorGradientType} [options.colorGradientType=SuperMap.ColorGradientType.YELLOW_RED] - 专题图颜色渐变模式。
 */
var MappingParameters = exports.MappingParameters = function () {
  function MappingParameters(options) {
    _classCallCheck(this, MappingParameters);

    /**
     * @member {Array.<SuperMap.ThemeGridRangeItem>} [SuperMap.MappingParameters.prototype.items]
     * @description 栅格分段专题图子项数组。
     */
    this.items = null;

    /**
     * @member {number} [SuperMap.MappingParameters.prototype.numericPrecision=1]
     * @description 精度，此字段用于设置分析结果标签专题图中标签数值的精度，如“1”表示精确到小数点的后一位。
     */
    this.numericPrecision = 1;

    /**
     * @member {SuperMap.RangeMode} [SuperMap.MappingParameters.prototype.RangeMode=SuperMap.RangeMode.EQUALINTERVAL]
     * @description 专题图分段模式。
     */
    this.rangeMode = _REST.RangeMode.EQUALINTERVAL;

    /**
     * @member {number} [SuperMap.MappingParameters.prototype.rangeCount]
     * @description 专题图分段个数。
     */
    this.rangeCount = "";

    /**
     * @member {SuperMap.ColorGradientType} [SuperMap.MappingParameters.prototype.colorGradientType=SuperMap.ColorGradientType.YELLOW_RED]
     * @description 专题图颜色渐变模式。
     */
    this.colorGradientType = _REST.ColorGradientType.YELLOW_RED;

    _Util.Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.MappingParameters";
  }

  /**
   * @function SuperMap.MappingParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(MappingParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      if (me.items) {
        if (me.items.length > 0) {
          for (var item in me.items) {
            me.items[item].destroy();
            me.items[item] = null;
          }
        }
        me.items = null;
      }
      me.numericPrecision = null;
      me.rangeMode = null;
      me.rangeCount = null;
      me.colorGradientType = null;
    }
  }]);

  return MappingParameters;
}();

_SuperMap.SuperMap.MappingParameters = MappingParameters;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputSetting = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _DatasourceConnectionInfo = __webpack_require__(101);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.OutputSetting
 * @category  iServer ProcessingService
 * @classdesc 分布式分析输出类型设置类。
 * @param {Object} options - 参数。
 * @param {SuperMap.DatasourceConnectionInfo} options.datasourceInfo - 数据源连接信息。
 * @param {string} [options.datasetName='analystResult'] - 结果数据集名称。
 * @param {SuperMap.OutputType} [options.type=SuperMap.OutputType.UDB] - 输出类型。
 * @param {string} [options.outputPath] - 分析结果输出路径。
 */
var OutputSetting = exports.OutputSetting = function () {
  function OutputSetting(options) {
    _classCallCheck(this, OutputSetting);

    /**
     * @member {SuperMap.OutputType} SuperMap.OutputSetting.prototype.type
     * @description 分布式分析的输出类型。
     */
    this.type = _REST.OutputType.UDB;

    /**
     * @member {string} [SuperMap.OutputSetting.prototype.datasetName='analystResult']
     * @description 分布式分析的输出结果数据集名称。
     */
    this.datasetName = "analystResult";

    /**
     * @member {SuperMap.DatasourceConnectionInfo} SuperMap.OutputSetting.prototype.datasourceInfo
     * @description 分布式分析的输出结果数据源连接信息。
     */
    this.datasourceInfo = null;

    /**
     * @member {string} [SuperMap.OutputSetting.prototype.outputPath]
     * @description 分布式分析的分析结果输出路径。
     */
    this.outputPath = "";

    _Util.Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.OutputSetting";
  }

  /**
   * @function SuperMap.OutputSetting.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(OutputSetting, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.type = null;
      me.datasetName = null;
      me.outputPath = null;
      if (me.datasourceInfo instanceof _DatasourceConnectionInfo.DatasourceConnectionInfo) {
        me.datasourceInfo.destroy();
        me.datasourceInfo = null;
      }
    }
  }]);

  return OutputSetting;
}();

_SuperMap.SuperMap.OutputSetting = OutputSetting;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ServerColor = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerColor
 * @category iServer Map Theme
 * @classdesc 颜色类。该类使用三原色（ RGB ）来表达颜色。
 * @param {Object} options - 参数。
 * @param {number} [options.red=255] - 获取或设置红色值。
 * @param {number} [options.green=0] - 获取或设置绿色值。
 * @param {number} [options.blue=0] - 获取或设置蓝色值。
 */
var ServerColor = exports.ServerColor = function () {
    function ServerColor(red, green, blue) {
        _classCallCheck(this, ServerColor);

        /**
         * @member {number} [SuperMap.ServerColor.prototype.red=255]
         * @description 获取或设置红色值。
         */
        this.red = !red && red != 0 ? 255 : red;

        /**
         * @member {number} [SuperMap.ServerColor.prototype.green=0]
         * @description 获取或设置绿色值。
         */
        this.green = green || 0;

        /**
         * @member {number} [SuperMap.ServerColor.prototype.blue=0]
         * @description 获取或设置蓝色值。
         */
        this.blue = blue || 0;

        this.CLASS_NAME = "SuperMap.ServerColor";
    }

    /**
     * @function SuperMap.ServerColor.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(ServerColor, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.red = null;
            me.green = null;
            me.blue = null;
        }

        /**
         * @function SuperMap.ServerColor.formJson
         * @description 将 JSON 对象转化为 ServerColor 对象。
         * @param {Object} jsonObject - 要转换的 JSON 对象。
         * @returns {SuperMap.ServerColor} 转化后的 ServerColor 对象。
         */

    }], [{
        key: "fromJson",
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            var color = new ServerColor();
            var red = 255;
            if (jsonObject.red !== null) {
                red = Number(jsonObject.red);
            }
            color.red = red;

            var green = 0;
            if (jsonObject.green !== null) {
                green = Number(jsonObject.green);
            }
            color.green = green;

            var blue = 0;
            if (jsonObject.blue !== null) {
                blue = Number(jsonObject.blue);
            }
            color.blue = blue;
            return color;
        }
    }]);

    return ServerColor;
}();

_SuperMap.SuperMap.ServerColor = ServerColor;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LineString = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Point = __webpack_require__(23);

var _Curve2 = __webpack_require__(110);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.LineString
 * @classdesc 几何对象线串类。
 * @category BaseTypes Geometry
 * @param {Array.<SuperMap.Geometry.Point>} points - 用来生成线串的点数组。
 * @extends {SuperMap.Geometry.Curve}
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *     new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *     new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *     new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *     new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var roadLine = new SuperMap.Geometry.LineString(points)；
 */
var LineString = exports.LineString = function (_Curve) {
    _inherits(LineString, _Curve);

    function LineString(points) {
        _classCallCheck(this, LineString);

        var _this = _possibleConstructorReturn(this, (LineString.__proto__ || Object.getPrototypeOf(LineString)).call(this, points));

        _this.CLASS_NAME = "SuperMap.Geometry.LineString";
        _this.geometryType = "LineString";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LineString.prototype.removeComponent
     * @description 只有在线串上有三个或更多的点的时候，才会允许移除点（否则结果将会是单一的点）。
     * @param {SuperMap.Geometry.Point} point - 将被删除的点。
     * @returns {boolean} 删除的点。
     */


    _createClass(LineString, [{
        key: 'removeComponent',
        value: function removeComponent(point) {
            // eslint-disable-line no-unused-vars
            var removed = this.components && this.components.length > 2;
            if (removed) {
                _get(LineString.prototype.__proto__ || Object.getPrototypeOf(LineString.prototype), 'removeComponent', this).apply(this, arguments);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getSortedSegments
         * @returns {Array} An array of segment objects.  Segment objects have properties
         *     x1, y1, x2, and y2.  The start point is represented by x1 and y1.
         *     The end point is represented by x2 and y2.  Start and end are
         *     ordered so that x1 < x2.
         */

    }, {
        key: 'getSortedSegments',
        value: function getSortedSegments() {
            var numSeg = this.components.length - 1;
            var segments = new Array(numSeg),
                point1,
                point2;
            for (var i = 0; i < numSeg; ++i) {
                point1 = this.components[i];
                point2 = this.components[i + 1];
                if (point1.x < point2.x) {
                    segments[i] = {
                        x1: point1.x,
                        y1: point1.y,
                        x2: point2.x,
                        y2: point2.y
                    };
                } else {
                    segments[i] = {
                        x1: point2.x,
                        y1: point2.y,
                        x2: point1.x,
                        y2: point1.y
                    };
                }
            }

            // more efficient to define this somewhere static
            function byX1(seg1, seg2) {
                return seg1.x1 - seg2.x1;
            }

            return segments.sort(byX1);
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表。
         * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false，则返回非端点的顶点。如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices;
            if (nodes === true) {
                vertices = [this.components[0], this.components[this.components.length - 1]];
            } else if (nodes === false) {
                vertices = this.components.slice(1, this.components.length - 1);
            } else {
                vertices = this.components.slice();
            }
            return vertices;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculateCircle
         * @description 三点画圆弧。
         * @param {Array.<SuperMap.Geometry.Point>} points - 传入的待计算的初始点串。
         * @returns {Array.<SuperMap.Geometry.Point>} 计算出相应的圆弧控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * var circle = SuperMap.Geometry.LineString.calculateCircle(points);
         */

    }], [{
        key: 'calculateCircle',
        value: function calculateCircle(points) {
            if (points.length < 3) {
                return points;
            }
            var centerPoint = {},
                p1 = points[0],
                p2 = points[1],
                p3 = points[2];
            var R = 0,
                dStep = 0,
                direc = true,
                dRotation = 0,
                dRotationBegin = 0,
                dRotationAngle = 0,
                nSegmentCount = 72,
                circlePoints = [];

            var KTan13 = (p3.y - p1.y) / (p3.x - p1.x);
            var B13 = p3.y - KTan13 * p3.x;
            if (p3.x != p1.x && p3.y != p1.y && p2.y == KTan13 * p2.x + B13 || p3.x == p1.x && p2.x == p1.x || p3.y == p1.y && p2.y == p1.y || p3.x == p1.x && p3.y == p1.y || p3.x == p2.x && p3.y == p2.y || p1.x == p2.x && p1.y == p2.y) {
                circlePoints.push(p1);
                circlePoints.push(p2);
                circlePoints.push(p3);
            } else {
                var D = (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p3.y - p1.y)) - (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p2.y - p1.y));
                var E = 2 * (p2.x - p1.x) * (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) - 2 * (p3.x - p1.x) * (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y));
                var F = 4 * ((p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y));
                centerPoint.x = D / F;
                centerPoint.y = E / F;
                R = Math.sqrt((p1.x - centerPoint.x) * (p1.x - centerPoint.x) + (p1.y - centerPoint.y) * (p1.y - centerPoint.y));

                var dis = (p1.x - p3.x) * (p1.x - p3.x) + (p1.y - p3.y) * (p1.y - p3.y);
                var cons = (2 * R * R - dis) / (2 * R * R);
                cons = cons >= 1 ? 1 : cons;
                cons = cons <= -1 ? -1 : cons;
                dRotationAngle = Math.acos(cons) * 180 / Math.PI;

                if (p3.x == p1.x) {
                    dRotationAngle = centerPoint.x > p1.x && p2.x > p1.x || centerPoint.x < p1.x && p2.x < p1.x ? 360 - dRotationAngle : dRotationAngle;
                } else {
                    dRotationAngle = centerPoint.y > KTan13 * centerPoint.x + B13 && p2.y > KTan13 * p2.x + B13 || centerPoint.y < KTan13 * centerPoint.x + B13 && p2.y < KTan13 * p2.x + B13 ? 360 - dRotationAngle : dRotationAngle;
                }
                dStep = dRotationAngle / 72;

                if (p3.y != p1.y) {
                    if (p3.x == p1.x) {
                        if (p3.y > p1.y) {
                            if (p2.x < p1.x) {
                                direc = false;
                            }
                        } else {
                            if (p2.x > p1.x) {
                                direc = false;
                            }
                        }
                    } else if (p3.x < p1.x) {
                        if (p2.y < KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    } else {
                        if (p2.y > KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    }
                } else {
                    if (p3.x > p1.x) {
                        if (p2.y > p1.y) {
                            direc = false;
                        }
                    } else {
                        if (p2.y < p1.y) {
                            direc = false;
                        }
                    }
                }

                var K10 = (p1.y - centerPoint.y) / (p1.x - centerPoint.x);
                var atan10 = K10 >= 0 ? Math.atan(K10) * 180 / Math.PI : Math.abs(Math.atan(K10) * 180 / Math.PI) + 90;

                var CY = Math.abs(centerPoint.y);
                if (p1.y == CY && CY == p3.y) {
                    if (p1.x < p3.x) {
                        atan10 = atan10 + 180;
                    }
                }

                var newPY = p1.y - centerPoint.y;
                circlePoints.push(p1);
                for (var i = 1; i < nSegmentCount; i++) {
                    dRotation = dStep * i;
                    dRotationBegin = atan10;

                    if (direc) {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin + dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) + dRotation;
                            }
                        } else {
                            if (K10 > 0) {
                                dRotationBegin = dRotationBegin - 180 + dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin + dRotation;
                            }
                        }
                    } else {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) - dRotation;
                            }
                        } else {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - 180 - dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin - dRotation;
                            }
                        }
                    }

                    dRotationBegin = dRotationBegin * Math.PI / 180;
                    var x = centerPoint.x + R * Math.cos(dRotationBegin);
                    var y = centerPoint.y + R * Math.sin(dRotationBegin);
                    circlePoints.push(new _Point.Point(x, y));
                }
                circlePoints.push(p3);
            }
            return circlePoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.createLineEPS
         * @description 根据点的类型画出不同类型的曲线。
         * 点的类型有三种：LTypeArc，LTypeCurve，NONE。
         * @param {Array.<SuperMap.Geometry.Point>} points - 传入的待计算的初始点串。
         * @returns {Array.<SuperMap.Geometry.Point>} 计算出相应的 lineEPS 控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50,"LTypeArc"));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         * var lineEPS = SuperMap.Geometry.LineString.createLineEPS(points);
         */

    }, {
        key: 'createLineEPS',
        value: function createLineEPS(points) {
            var list = [],
                len = points.length;
            if (len < 2) {
                return points;
            }
            for (var i = 0; i < len;) {
                var type = points[i].type;
                if (type == 'LTypeArc') {
                    var listObj = LineString.createLineArc(list, i, len, points);
                    list = listObj[0];
                    i = listObj[1];
                } else {
                    list.push(points[i]);
                    i++;
                }
            }
            return list;
        }
    }, {
        key: 'createLineArc',
        value: function createLineArc(list, i, len, points) {
            if (i == 0) {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            } else if (i == len - 1) {
                var bezierP = [points[i - 1], points[i]],
                    bezierPts = LineString.calculateCircle(bezierP);
                Array.prototype.push.apply(list, bezierPts);
                i++;
            } else {
                var _bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                list.pop();
                Array.prototype.push.apply(list, _bezierPtsObj[0]);
                i = _bezierPtsObj[1] + 1;
            }
            return [list, i];
        }
    }, {
        key: 'addPointEPS',
        value: function addPointEPS(points, i, len, type) {
            var bezierP = [],
                j = i + 1;
            if (i == 0) {
                Array.prototype.push.apply(bezierP, [points[i], points[i + 1]]);
            } else if (i == len - 1) {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i]]);
            } else {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i], points[i + 1]]);
            }
            var bezierPts;
            if (type == 'LTypeCurve') {
                bezierPts = LineString.calculatePointsFBZN(bezierP);
            } else if (type == 'LTypeArc') {
                bezierPts = LineString.calculateCircle(bezierP);
            }
            return [bezierPts, j];
        }
    }]);

    return LineString;
}(_Curve2.Curve);

_SuperMap.SuperMap.Geometry.LineString = LineString;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Point = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Geometry2 = __webpack_require__(27);

var _Bounds = __webpack_require__(28);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.Point
 * @classdesc 点几何对象类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry}
 * @param {float} x - x 坐标。
 * @param {float} y - y 坐标。
 * @param {string} [type = 'Point'] - 用来存储点的类型。
 * @param {float} [tag] - 用来存储额外的属性，比如差值分析中的 Z 值。
 * @example
 * var point = new SuperMap.Geometry.Point(-111.04, 45.68);
 */
var Point = exports.Point = function (_Geometry) {
    _inherits(Point, _Geometry);

    function Point(x, y, type, tag) {
        _classCallCheck(this, Point);

        /**
         * @member {float} SuperMap.Geometry.Point.prototype.x
         * @description 横坐标。
         */
        var _this = _possibleConstructorReturn(this, (Point.__proto__ || Object.getPrototypeOf(Point)).call(this, x, y, type, tag));

        _this.x = parseFloat(x);

        /**
         * @member {float} SuperMap.Geometry.Point.prototype.y
         * @description 纵坐标。
         */
        _this.y = parseFloat(y);

        /**
         * @member {string} SuperMap.Geometry.Point.prototype.tag
         * @description  用来存储额外的属性，比如差值分析中的 Z 值。
         */
        _this.tag = tag || tag == 0 ? parseFloat(tag) : null;

        /**
         * @member {string} SuperMap.Geometry.Point.prototype.tag
         * @description  用来存储点的类型
         */
        _this.type = type || "Point";
        _this.CLASS_NAME = "SuperMap.Geometry.Point";
        _this.geometryType = "Point";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Point.prototype.clone
     * @description 克隆点对象。
     * @returns {SuperMap.Geometry.Point} 克隆后的点对象。
     */


    _createClass(Point, [{
        key: 'clone',
        value: function clone(obj) {
            if (obj == null) {
                obj = new Point(this.x, this.y);
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(obj, this);

            return obj;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.calculateBounds
         * @description 计算点对象的范围。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = new _Bounds.Bounds(this.x, this.y, this.x, this.y);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.equals
         * @description 判断两个点对象是否相等。如果两个点对象具有相同的坐标，则认为是相等的。
         * @example
         * var point= new SuperMap.Geometry.Point(0,0);
         * var point1={x:0,y:0};
         * var result= point.equals(point1);
         * @param {SuperMap.Geometry.Point} geom - 需要判断的点对象。
         * @returns {boolean} 两个点对象是否相等（true 为相等，false 为不等）。
         */

    }, {
        key: 'equals',
        value: function equals(geom) {
            var equals = false;
            if (geom != null) {
                equals = this.x === geom.x && this.y === geom.y || isNaN(this.x) && isNaN(this.y) && isNaN(geom.x) && isNaN(geom.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.move
         * @description 沿着 x、y 轴的正方向上按照给定的位移移动点对象，move 不仅改变了几何对象的位置并且清理了边界缓存。
         * @param {float} x - x 轴正方向上的偏移量。
         * @param {float} y - y 轴正方向上偏移量。
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            this.x = this.x + x;
            this.y = this.y + y;
            this.clearBounds();
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.toShortString
         * @returns {string} 字符串代表点对象。(ex. <i>"5, 42"</i>)
         */

    }, {
        key: 'toShortString',
        value: function toShortString() {
            return this.x + ", " + this.y;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.destroy
         * @description 释放点对象的资源。
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.tag = null;
            _get(Point.prototype.__proto__ || Object.getPrototypeOf(Point.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.getVertices
         * @description 返回点对象的所有顶点的列表。
         * @param {boolean} [nodes] - 对于点对象此参数不起作用，直接返回点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            // eslint-disable-line no-unused-vars
            return [this];
        }
    }]);

    return Point;
}(_Geometry2.Geometry);

_SuperMap.SuperMap.Geometry.Point = Point;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapeParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class  SuperMap.Feature.ShapeParameters
 * @category Visualization Theme
 * @classdesc 图形参数基类，此类不可实例化
 */
var ShapeParameters = exports.ShapeParameters = function () {

  /**
   * @function SuperMap.Feature.ShapeParameters.prototype.constructor
   * @description 图形参数对象。
   * @returns {SuperMap.Feature.ShapeParameters} 图形参数对象。
   */
  function ShapeParameters() {
    _classCallCheck(this, ShapeParameters);

    /**
     * @member {Array} [SuperMap.Feature.ShapeParameters.prototype.refOriginalPosition=[0,0]]
     * @description 图形参考原点位置，图形的参考中心位置。
     * refOriginalPosition 是长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     * refOriginalPosition 表示图形的参考中心，通常情况下，图形是使用 canvas 的原点位置作为位置参考，
     * 但 refOriginalPosition 可以改变图形的参考位置，例如： refOriginalPosition = [80, 80],
     * 图形圆的 style.x = 20, style.y = 20，那么圆在 canvas 中的实际位置是 [100, 100]。
     * 图形（Shape） 的所有位置相关属性都是以 refOriginalPosition 为参考中心，
     * 也就是说图形的所有位置信息在 canvas 中都是以 refOriginalPosition 为参考的相对位置，只有
     * refOriginalPosition 的值为 [0, 0] 时，图形的位置信息才是 canvas 绝对位置。
     * 图形的位置信息通常有：style.pointList，style.x，style.y。
     */
    this.refOriginalPosition = [0, 0];

    /**
     * @member {string} SuperMap.Feature.ShapeParameters.prototype.refDataID
     * @description 图形所关联数据的 ID（<{@link SuperMap.Feature.Vector}> 的 id）。
     */
    this.refDataID = null;

    /**
     * @member {boolean} SuperMap.Feature.ShapeParameters.prototype.isHoverByRefDataID
     * @description 是否根据 refDataID 进行高亮。用于同时高亮所有 refDataID 相同的图形。
     */
    this.isHoverByRefDataID = false;

    /**
     * @member {string} SuperMap.Feature.ShapeParameters.prototype.refDataHoverGroup
     * @description 高亮图形组的组名。此属性在 refDataID 有效且 isHoverByRefDataID 为 true 时生效。
     * 一旦设置此属性，且属性值有效，只有关联同一个数据的图形且此属性相同的图形才会高亮。
     */
    this.refDataHoverGroup = null;

    /**
     * @member {Object} SuperMap.Feature.ShapeParameters.prototype.dataInfo
     * @description 图形携带的附加数据。
     */
    this.dataInfo = null;

    /**
     * @member {boolean} SuperMap.Feature.ShapeParameters.prototype.clickable
     * @description 是否可点击。
     */
    this.clickable = true;

    /**
     * @member {boolean} SuperMap.Feature.ShapeParameters.prototype.hoverable
     * @description 是否可点击。
     */
    this.hoverable = true;

    /**
     * @member {Object} SuperMap.Feature.ShapeParameters.prototype.style
     * @description 图形样式对象，可设样式属性在子类中确定。
     */
    this.style = null;

    /**
     * @member {Object} SuperMap.Feature.ShapeParameters.prototype.highlightStyle
     * @description 高亮样式对象，可设样式属性与 style 的可设样式属性相同。
     */
    this.highlightStyle = {};

    this.CLASS_NAME = "SuperMap.Feature.ShapeParameters";
  }

  /**
   * @function SuperMap.Feature.ShapeParameters.prototype.destroy
   * @description 销毁对象。
   */


  _createClass(ShapeParameters, [{
    key: "destroy",
    value: function destroy() {
      this.refOriginalPosition = null;
      this.refDataID = null;
      this.isHoverByRefDataID = null;
      this.refDataHoverGroup = null;
      this.dataInfo = null;
      this.clickable = null;
      this.hoverable = null;
      this.style = null;
      this.highlightStyle = null;
    }
  }]);

  return ShapeParameters;
}();

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeParameters = ShapeParameters;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ShapeFactory = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Point = __webpack_require__(64);

var _Line = __webpack_require__(63);

var _Polygon = __webpack_require__(62);

var _Rectangle = __webpack_require__(144);

var _Sector = __webpack_require__(61);

var _Label = __webpack_require__(87);

var _Image = __webpack_require__(143);

var _Circle = __webpack_require__(86);

var _SmicPoint = __webpack_require__(85);

var _SmicText = __webpack_require__(84);

var _SmicCircle = __webpack_require__(134);

var _SmicBrokenLine = __webpack_require__(83);

var _SmicImage = __webpack_require__(82);

var _SmicPolygon = __webpack_require__(56);

var _SmicRectangle = __webpack_require__(81);

var _SmicSector = __webpack_require__(133);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class  SuperMap.Feature.ShapeFactory
 * @category Visualization Theme
 * @classdesc 图形工厂类。
 * 目前支持创建的图形有：<br>
 * 用于统计专题图：<br>
 * 点 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Point}> <br>
 * 线 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Line}> <br>
 * 面 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Polygon}> <br>
 * 矩形 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Rectangle}> <br>
 * 扇形 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Sector}> <br>
 * 标签 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Label}> <br>
 * 图片 - 参数对象 <{@link SuperMap.Feature.ShapeParameters.Image}> <br>
 * 用于符号专题图：<br>
 * 圆形 -  参数对象：<{@link SuperMap.Feature.ShapeParameters.Cilcle}>
 */
var ShapeFactory = exports.ShapeFactory = function () {

    /**
     * @function SuperMap.Feature.ShapeFactory.prototype.constructor
     * @description 构建图形工厂对象。
     * @param {Object} shapeParameters - 图形参数对象，<{@link SuperMap.Feature.ShapeParameters}> 子类对象，可选参数。
     * @returns {SuperMap.Feature.ShapeFactory} 返回图形工厂类对象。
     */
    function ShapeFactory(shapeParameters) {
        _classCallCheck(this, ShapeFactory);

        /**
         * @member {Object} SuperMap.Feature.ShapeParameters.prototype.shapeParameters
         * @description  图形参数对象，<{@link SuperMap.Feature.ShapeParameters}> 子类对象。必设参数，默认值 null。
         */
        this.shapeParameters = shapeParameters;

        this.CLASS_NAME = "SuperMap.Feature.ShapeFactory";
    }

    /**
     * @function  SuperMap.Feature.ShapeParameters.prototype.destroy
     * @description 销毁图形工厂类对象。
     */


    _createClass(ShapeFactory, [{
        key: 'destroy',
        value: function destroy() {
            this.shapeParameters = null;
        }

        /**
         * @function  SuperMap.Feature.ShapeParameters.prototype.createShape
         * @description 创建一个图形。具体图形由 shapeParameters 决定。
         * @param {Object} shapeParameters - 图形参数对象，<{@link SuperMap.Feature.ShapeParameters}> 子类对象。
         * 此参数可选，如果使用此参数（不为 null），shapeParameters 属性值将被修改为参数的值，然后再使用 shapeParameters 属性值创建图形；
         * 如果不使用此参数，createShape 方法将直接使用 shapeParameters 属性创建图形。
         * @returns {Object} 图形对象（或 null - 图形创建失败）。
         */

    }, {
        key: 'createShape',
        value: function createShape(shapeParameters) {
            if (shapeParameters) {
                this.shapeParameters = shapeParameters;
            }

            if (!this.shapeParameters) {
                return null;
            }

            var sps = this.shapeParameters;

            if (sps instanceof _Point.Point) {
                // 点
                //设置style
                var style = new Object();
                style["x"] = sps.x;
                style["y"] = sps.y;
                style["r"] = sps.r;

                style = _Util.Util.copyAttributesWithClip(style, sps.style, ['x', 'y']);

                //创建图形
                var shape = new _SmicPoint.SmicPoint();
                shape.style = ShapeFactory.transformStyle(style);
                shape.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(shape, sps, ['x', 'y', 'style', 'highlightStyle']);

                return shape;
            } else if (sps instanceof _Line.Line) {
                // 线
                //检查参数 pointList 是否存在
                if (!sps.pointList) {
                    return null;
                }

                // 设置style
                var _style = new Object();
                _style["pointList"] = sps.pointList;
                _style = _Util.Util.copyAttributesWithClip(_style, sps.style, ['pointList']);

                // 创建图形
                var _shape = new _SmicBrokenLine.SmicBrokenLine();
                _shape.style = ShapeFactory.transformStyle(_style);
                _shape.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape, sps, ['pointList', 'style', 'highlightStyle']);

                return _shape;
            } else if (sps instanceof _Polygon.Polygon) {
                // 面
                //检查参数 pointList 是否存在
                if (!sps.pointList) {
                    return null;
                }

                //设置style
                var _style2 = new Object();
                _style2["pointList"] = sps.pointList;
                _style2 = _Util.Util.copyAttributesWithClip(_style2, sps.style, ['pointList']);

                //创建图形
                var _shape2 = new _SmicPolygon.SmicPolygon();
                _shape2.style = ShapeFactory.transformStyle(_style2);
                _shape2.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape2, sps, ['pointList', 'style', "highlightStyle"]);

                return _shape2;
            } else if (sps instanceof _Rectangle.Rectangle) {
                // 矩形
                //检查参数 pointList 是否存在
                if (!sps.x && !sps.y & !sps.width & !sps.height) {
                    return null;
                }

                //设置style
                var _style3 = new Object();
                _style3["x"] = sps.x;
                _style3["y"] = sps.y;
                _style3["width"] = sps.width;
                _style3["height"] = sps.height;

                _style3 = _Util.Util.copyAttributesWithClip(_style3, sps.style, ['x', 'y', 'width', 'height']);

                //创建图形
                var _shape3 = new _SmicRectangle.SmicRectangle();
                _shape3.style = ShapeFactory.transformStyle(_style3);
                _shape3.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape3, sps, ['x', 'y', 'width', 'height', 'style', 'highlightStyle']);

                return _shape3;
            } else if (sps instanceof _Sector.Sector) {
                // 扇形
                //设置style
                var _style4 = new Object();
                _style4["x"] = sps.x;
                _style4["y"] = sps.y;
                _style4["r"] = sps.r;
                _style4["startAngle"] = sps.startAngle;
                _style4["endAngle"] = sps.endAngle;
                if (sps["r0"]) {
                    _style4["r0"] = sps.r0;
                }

                if (sps["clockWise"]) {
                    _style4["clockWise"] = sps.clockWise;
                }

                _style4 = _Util.Util.copyAttributesWithClip(_style4, sps.style, ['x', 'y', 'r', 'startAngle', 'endAngle', 'r0', 'endAngle']);

                //创建图形
                var _shape4 = new _SmicSector.SmicSector();
                _shape4.style = ShapeFactory.transformStyle(_style4);
                _shape4.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape4, sps, ['x', 'y', 'r', 'startAngle', 'endAngle', 'r0', 'endAngle', 'style', 'highlightStyle']);

                return _shape4;
            } else if (sps instanceof _Label.Label) {
                // 标签
                //设置style
                var _style5 = new Object();
                _style5["x"] = sps.x;
                _style5["y"] = sps.y;
                _style5["text"] = sps.text;

                _style5 = _Util.Util.copyAttributesWithClip(_style5, sps.style, ['x', 'y', 'text']);

                //创建图形
                var _shape5 = new _SmicText.SmicText();
                _shape5.style = ShapeFactory.transformStyle(_style5);
                _shape5.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape5, sps, ['x', 'y', 'text', 'style', 'highlightStyle']);

                return _shape5;
            } else if (sps instanceof _Image.Image) {
                // 图片
                //设置style
                var _style6 = new Object();
                _style6["x"] = sps.x;
                _style6["y"] = sps.y;
                if (sps["image"]) {
                    _style6["image"] = sps.image;
                }
                if (sps["width"]) {
                    _style6["width"] = sps.width;
                }
                if (sps["height"]) {
                    _style6["height"] = sps.height;
                }
                if (sps["sx"]) {
                    _style6["sx"] = sps.sx;
                }
                if (sps["sy"]) {
                    _style6["sy"] = sps.sy;
                }
                if (sps["sWidth"]) {
                    _style6["sWidth"] = sps.sWidth;
                }
                if (sps["sHeight"]) {
                    _style6["sHeight"] = sps.sHeight;
                }

                _style6 = _Util.Util.copyAttributesWithClip(_style6, sps.style, ['x', 'y', 'image', 'width', 'height', 'sx', 'sy', 'sWidth', 'sHeight']);

                //创建图形
                var _shape6 = new _SmicImage.SmicImage();
                _shape6.style = ShapeFactory.transformStyle(_style6);
                _shape6.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape6, sps, ['x', 'y', 'image', 'width', 'height', 'style', 'highlightStyle']);

                return _shape6;
            } else if (sps instanceof _Circle.Circle) {
                //圆形 用于符号专题图
                //设置stytle
                var _style7 = new Object();
                _style7["x"] = sps.x;
                _style7["r"] = sps.r;
                _style7["y"] = sps.y;

                _style7 = _Util.Util.copyAttributesWithClip(_style7, sps.style, ['x', 'y', 'r']);

                //创建图形
                var _shape7 = new _SmicCircle.SmicCircle();
                _shape7.style = ShapeFactory.transformStyle(_style7);
                _shape7.highlightStyle = ShapeFactory.transformStyle(sps.highlightStyle);
                _Util.Util.copyAttributesWithClip(_shape7, sps, ['x', 'y', 'r', 'style', 'highlightStyle', 'lineWidth', 'text', 'textPosition']);

                return _shape7;
            }

            return null;
        }

        /**
         * @function  SuperMap.Feature.ShapeParameters.prototype.transformStyle
         * @description 将用户 feature.style (类 Svg style 标准) 的样式，转换为 levelRenderer 的样式标准（类 CSS-Canvas 样式）
         * @param {Object} style - 用户 style。
         * @returns {Object} 符合 levelRenderer 的 style。
         */

    }], [{
        key: 'transformStyle',
        value: function transformStyle(style) {
            var newStyle = {};

            //字体 ["font-style", "font-variant", "font-weight", "font-size / line-height", "font-family"];
            var fontStr = ["normal", "normal", "normal", "12", "arial,sans-serif"];

            //画笔类型 ["fill", "stroke"];
            var brushType = [true, false];

            for (var ss in style) {
                switch (ss) {
                    case "fill":
                        brushType[0] = style[ss];
                        break;
                    case "fillColor":
                        newStyle["color"] = style[ss];
                        break;
                    case "stroke":
                        brushType[1] = style[ss];
                        break;
                    case "strokeWidth":
                        newStyle["lineWidth"] = style[ss];
                        break;
                    case "strokeLinecap":
                        newStyle["lineCap"] = style[ss];
                        break;
                    case "strokeLineJoin":
                        newStyle["lineJoin"] = style[ss];
                        break;
                    case "strokeDashstyle":
                        newStyle["lineType"] = style[ss];
                        break;
                    case "pointRadius":
                        newStyle["r"] = style[ss];
                        break;
                    case "label":
                        newStyle["text"] = style[ss];
                        break;
                    case "labelRect":
                        newStyle["labelRect"] = style[ss];
                        break;
                    case "fontColor":
                        newStyle["textColor"] = style[ss];
                        break;
                    case "fontStyle":
                        fontStr[0] = style[ss];
                        break;
                    case "fontVariant":
                        fontStr[1] = style[ss];
                        break;
                    case "fontWeight":
                        fontStr[2] = style[ss];
                        break;
                    case "fontSize":
                        var unit = "";
                        if (style[ss] && style[ss].toString().indexOf("px") < 0) {
                            unit = "px";
                        }
                        fontStr[3] = style[ss] + unit;
                        break;
                    case "fontFamily":
                        fontStr[4] = style[ss];
                        break;
                    case "fontOpacity":
                        newStyle["opacity"] = style[ss];
                        break;
                    case "labelPosition":
                        newStyle["textPosition"] = style[ss];
                        break;
                    case "labelAlign":
                        newStyle["textAlign"] = style[ss];
                        break;
                    case "labelBaseline":
                        newStyle["textBaseline"] = style[ss];
                        break;
                    case "labelRotation":
                        newStyle["textRotation"] = style[ss];
                        break;

                    default:
                        newStyle[ss] = style[ss];
                        break;
                }
            }

            //拼接字体字符串
            newStyle["textFont"] = fontStr.join(" ");

            //画笔类型
            if (brushType[0] === true && brushType[1] === false) {
                newStyle["brushType"] = "fill";
            } else if (brushType[0] === false && brushType[1] === true) {
                newStyle["brushType"] = "stroke";
            } else if (brushType[0] === true && brushType[1] === true) {
                newStyle["brushType"] = "both";
            } else {
                newStyle["brushType"] = "fill";
            }

            //默认线宽 1
            if (newStyle["lineWidth"] == null) {
                newStyle["lineWidth"] = 1;
            }

            return newStyle;
        }

        /**
         * @function  SuperMap.Feature.ShapeParameters.prototype.Background
         * @description 创建一个矩形背景框图形对象。
         * @param {SuperMap.Feature.ShapeFactory} shapeFactory - 图形工厂对象，必设参数。
         * @param {Array.<number>} box - 框区域，长度为 4 的一维数组，像素坐标，[left, bottom, right, top]，必设参数。
         * @param {Object} setting - 图表配置参数，必设参数。本函数中图形配置对象 setting 可设属性：
         * @param {Object} setting.backgroundStyle - 背景样式，此样式对象对象可设属性：<SuperMap.Feature.ShapeParameters.Rectangle#style>。
         * @param {Array} [setting.backgroundRadius=[0,0,0,0]] - 背景框矩形圆角半径，可以用数组分别指定四个角的圆角半径，设：左上、右上、右下、左下角的半径依次为 r1、r2、r3、r4，则 backgroundRadius 为 [r1、r2、r3、r4 ]。
         * @returns {Object} 背景框图形，一个可视化图形（矩形）对象。
         */

    }, {
        key: 'Background',
        value: function Background(shapeFactory, box, setting) {
            var sets = setting ? setting : {};

            // 背景框图形参数对象
            var bgSP = new _Rectangle.Rectangle(box[0], box[3], Math.abs(box[2] - box[0]), Math.abs(box[3] - box[1]));

            // 默认样式
            bgSP.style = {
                fillColor: "#f3f3f3"
            };

            // 设置用户 style
            if (sets.backgroundStyle) {
                _Util.Util.copyAttributesWithClip(bgSP.style, sets.backgroundStyle);
            }

            // 设置背景框圆角参数
            if (sets.backgroundRadius) {
                bgSP.style["radius"] = sets.backgroundRadius;
            }

            // 禁止背景框响应事件
            bgSP.clickable = false;
            bgSP.hoverable = false;

            return shapeFactory.createShape(bgSP);
        }

        /**
         * @function  SuperMap.Feature.ShapeParameters.prototype.GraphAxis
         * @description 创建一个统计图表坐标轴图形对象组。
         * @param {SuperMap.Feature.ShapeFactory} shapeFactory - 图形工厂对象，必设参数。
         * @param {Array.<number>} dataViewBox - 统计图表模型的数据视图框，长度为 4 的一维数组，像素坐标，[left, bottom, right, top]，必设参数。
         * @param {Object} setting - 图表配置参数，必设参数。
         * @param {Object} setting.axisStyle - 坐标轴样式，此样式对象对象可设属性：<SuperMap.Feature.ShapeParameters.Line#style>。
         * @param {boolean} [setting.axisUseArrow=false] - 坐标轴是否使用箭头。
         * @param {number} [setting.axisYTick=0] - y 轴刻度数量，0表示不使用箭头。
         * @param {Array.<string>} setting.axisYLabels - y 轴上的标签组内容，标签顺序沿着数据视图框左面条边自上而下，等距排布。例如：["1000", "750", "500", "250", "0"]。
         * @param {Object} setting.axisYLabelsStyle - y 轴上的标签组样式，此样式对象对象可设属性：<SuperMap.Feature.ShapeParameters.Label#style>。
         * @param {Array.<number>} [setting.axisYLabelsOffset=[0,0]] - y 轴上的标签组偏移量。长度为 2 的数组，数组第一项表示 y 轴标签组横向上的偏移量，向左为正，默认值：0；数组第二项表示 y 轴标签组纵向上的偏移量，向下为正，默认值：0。
         * @param {Array.<string>} setting.axisXLabels - x 轴上的标签组内容，标签顺序沿着数据视图框下面条边自左向右排布，例如：["92年", "95年", "99年"]。
         * 标签排布规则：当标签数量与 xShapeInfo 中的属性 xPositions 数量相同（即标签个数与数据个数相等时）, 按照 xPositions 提供的位置在水平方向上排布标签，否则沿数据视图框下面条边等距排布标签。
         * @param {Object} setting.axisXLabelsStyle - x 轴上的标签组样式，此样式对象对象可设属性：<SuperMap.Feature.ShapeParameters.Label#style>。
         * @param {Array.<number>} [setting.axisXLabelsOffset=[0,0]] - x 轴上的标签组偏移量。长度为 2 的数组，数组第一项表示 x 轴标签组横向上的偏移量，向左为正，默认值：0；数组第二项表示 x 轴标签组纵向上的偏移量，向下为正，默认值：0。
         * @param {boolean} setting.useXReferenceLine - 是否使用水平参考线，如果为 true，在 axisYTick 大于 0 时有效，水平参考线是 y 轴刻度在数据视图框里的延伸。
         * @param {Object} setting.xReferenceLineStyle - 水平参考线样式，此样式对象对象可设属性：<SuperMap.Feature.ShapeParameters.Line#style>。
         * @param {number} [setting.axis3DParameter=0] - 3D 坐标轴参数，此属性值在大于等于 15 时有效。
         * @param {Object} xShapeInfo - X 方向上的图形信息对象，包含两个属性。
         * @param {Array.<number>} xShapeInfo.xPositions - 图形在 x 轴方向上的像素坐标值，是一个一维数组，如果图形在 x 方向上有一定宽度，通常取图形在 x 方向上的中心点为图形在 x 方向上的坐标值。
         * @param {number} xShapeInfo.width - 图形的宽度（特别注意：点的宽度始终为 0，而不是其直径）。
         * @returns {Array.<Object>} 统计图表坐标轴图形对象数组。
         */

    }, {
        key: 'GraphAxis',
        value: function GraphAxis(shapeFactory, dataViewBox, setting, xShapeInfo) {
            var dvb = dataViewBox;
            var sets = setting ? setting : {};

            // 参考线图形对象组
            var refLines = [];
            //坐标轴箭头对象组
            var arrows = [];
            // 是否使用参水平考线，默认不使用
            var isAddRefLine = sets.useXReferenceLine ? sets.useXReferenceLine : false;
            // y 轴上的刻度
            var axisytick = sets.axisYTick && !isNaN(sets.axisYTick) ? sets.axisYTick : 0;
            // 坐标轴节点数组
            var pois = [];
            //z 轴箭头数组
            var zArrowPois = [];
            // x,y 轴主干节点数组
            var xMainPois = [];
            if (axisytick == 0) {
                xMainPois.push([dvb[0], dvb[3] - 5]);
                xMainPois.push([dvb[0], dvb[1]]);

                // 3D 坐标轴  第三象限平分线
                if (sets.axis3DParameter && !isNaN(sets.axis3DParameter) && sets.axis3DParameter >= 15) {
                    var axis3DParameter = parseInt(sets.axis3DParameter);
                    var axis3DPoi = [dvb[0] - axis3DParameter, dvb[1] + axis3DParameter];

                    // 添加 3D 轴节点
                    if (sets.axisUseArrow) {
                        // 添加 3D 轴箭头节点坐标
                        //箭头坐标
                        zArrowPois.push([axis3DPoi[0] + 1.5, axis3DPoi[1] - 7.5]);
                        zArrowPois.push([axis3DPoi[0] - 1, axis3DPoi[1] + 1]);
                        zArrowPois.push([axis3DPoi[0] + 7.5, axis3DPoi[1] - 1.5]);
                        //3D轴
                        xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                    } else {
                        xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                    }

                    xMainPois.push([dvb[0], dvb[1]]);
                }
                xMainPois.push([dvb[2] + 5, dvb[1]]);
            } else {
                // 单位刻度长度
                var unitTick = Math.abs(dvb[1] - dvb[3]) / axisytick;
                // 刻度 y 坐标
                var thckY = dvb[3];

                xMainPois.push([dvb[0], thckY - 5]);

                for (var i = 0; i < axisytick; i++) {
                    xMainPois.push([dvb[0], thckY]);
                    xMainPois.push([dvb[0] - 5, thckY]);
                    xMainPois.push([dvb[0], thckY]);

                    // 参考线
                    if (isAddRefLine) {
                        // 参考线参数对象
                        var refLineSP = new _Line.Line([[dvb[0], thckY], [dvb[2], thckY]]);
                        // 参考线默认样式对象
                        refLineSP.style = {
                            strokeColor: "#cfcfcf",
                            strokeLinecap: "butt",
                            strokeLineJoin: "round",
                            strokeWidth: 1
                        };
                        // 禁止事件
                        refLineSP.clickable = false;
                        refLineSP.hoverable = false;
                        // 用户style
                        if (sets.xReferenceLineStyle) {
                            _Util.Util.copyAttributesWithClip(refLineSP.style, sets.xReferenceLineStyle);
                        }
                        // 生成参考线图形对象
                        refLines.push(shapeFactory.createShape(refLineSP));
                    }

                    // y 刻度增量
                    thckY += unitTick;
                }

                xMainPois.push([dvb[0], dvb[1]]);

                // 3D 坐标轴  第三象限平分线
                if (sets.axis3DParameter && !isNaN(sets.axis3DParameter) && sets.axis3DParameter >= 15) {
                    var _axis3DParameter = parseInt(sets.axis3DParameter);
                    var _axis3DPoi = [dvb[0] - _axis3DParameter, dvb[1] + _axis3DParameter];

                    /*
                     // 箭头计算过程
                     var axis3DPoiRef = [axis3DPoi[0] + 7, axis3DPoi[1] - 7];  // 7 是 10 为斜边 cos（45度）时邻边的值
                     var axis3DPoiLT = [axis3DPoiRef[0] - 4, axis3DPoiRef[1] - 4];
                     var axis3DPoiRB = [axis3DPoiRef[0] + 4, axis3DPoiRef[1] + 4];
                     if(sets.axisUseArrow){
                     xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                     xMainPois.push([axis3DPoiLT[0], axis3DPoiLT[1]]);
                     xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                     xMainPois.push([axis3DPoiRB[0], axis3DPoiRB[1]]);
                     xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                     }
                     else{
                     xMainPois.push([axis3DPoi[0], axis3DPoi[1]]);
                     }
                     */

                    // 添加 3D 轴节点
                    if (sets.axisUseArrow) {
                        // 添加 3D 轴和箭头坐标
                        //箭头坐标
                        zArrowPois.push([_axis3DPoi[0] + 1.5, _axis3DPoi[1] - 7.5]);
                        zArrowPois.push([_axis3DPoi[0] - 1, _axis3DPoi[1] + 1]);
                        zArrowPois.push([_axis3DPoi[0] + 7.5, _axis3DPoi[1] - 1.5]);
                        //3D轴
                        xMainPois.push([_axis3DPoi[0], _axis3DPoi[1]]);
                    } else {
                        xMainPois.push([_axis3DPoi[0], _axis3DPoi[1]]);
                    }

                    xMainPois.push([dvb[0], dvb[1]]);
                }

                xMainPois.push([dvb[2] + 5, dvb[1]]);
            }
            // 坐标轴箭头
            if (sets.axisUseArrow) {
                // x 轴箭头节点数组
                var xArrowPois = [[dvb[2] + 5, dvb[1] + 4], [dvb[2] + 13, dvb[1]], [dvb[2] + 5, dvb[1] - 4]];

                // y 轴箭头节点数组
                var yArrowPois = [[dvb[0] - 4, dvb[3] - 5], [dvb[0], dvb[3] - 13], [dvb[0] + 4, dvb[3] - 5]];

                //x轴箭头
                var xSP = new _Polygon.Polygon(xArrowPois);
                xSP.style = { fillColor: "#008acd" };
                _Util.Util.copyAttributesWithClip(xSP.style, sets.axisStyle);
                arrows.push(shapeFactory.createShape(xSP));

                //y轴箭头
                var ySP = new _Polygon.Polygon(yArrowPois);
                ySP.style = { fillColor: "#008acd" };
                _Util.Util.copyAttributesWithClip(ySP.style, sets.axisStyle);
                arrows.push(shapeFactory.createShape(ySP));

                // z轴箭头 坐标轴箭头是否要使用
                if (sets.axis3DParameter && !isNaN(sets.axis3DParameter) && sets.axis3DParameter >= 15) {
                    var zSP = new _Polygon.Polygon(zArrowPois);
                    zSP.style = { fillColor: "#008acd" };
                    _Util.Util.copyAttributesWithClip(zSP.style, sets.axisStyle);
                    arrows.push(shapeFactory.createShape(zSP));
                }
            }
            //不带箭头的坐标轴
            pois = xMainPois;

            // 坐标轴参数对象
            var axisSP = new _Line.Line(pois);
            // 坐标轴默认style
            axisSP.style = {
                strokeLinecap: "butt",
                strokeLineJoin: "round",
                strokeColor: "#008acd",
                strokeWidth: 1
            };
            // 用户 style
            if (sets.axisStyle) {
                _Util.Util.copyAttributesWithClip(axisSP.style, sets.axisStyle);
            }
            // 禁止事件
            axisSP.clickable = false;
            axisSP.hoverable = false;
            // 创建坐标轴图形对象
            var axisMain = [shapeFactory.createShape(axisSP)];

            // Y 轴标签
            var yLabels = [];
            if (sets.axisYLabels && sets.axisYLabels.length && sets.axisYLabels.length > 0) {
                var axisYLabels = sets.axisYLabels;
                var len = axisYLabels.length;

                // 标签偏移量
                var ylOffset = [0, 0];
                if (sets.axisYLabelsOffset && sets.axisYLabelsOffset.length) {
                    ylOffset = sets.axisYLabelsOffset;
                }

                if (len == 1) {
                    // 标签参数对象
                    var labelYSP = new _Label.Label(dvb[0] - 5 + ylOffset[0], dvb[3] + ylOffset[1], axisYLabels[0]);
                    labelYSP.style = {
                        labelAlign: "right"
                    };
                    // 用户 style
                    if (sets.axisYLabelsStyle) {
                        _Util.Util.copyAttributesWithClip(labelYSP.style, sets.axisYLabelsStyle);
                    }
                    // 禁止事件
                    labelYSP.clickable = false;
                    labelYSP.hoverable = false;
                    // 制作标签
                    yLabels.push(shapeFactory.createShape(labelYSP));
                } else {
                    var labelY = dvb[3];
                    // y 轴标签单位距离
                    var yUnit = Math.abs(dvb[1] - dvb[3]) / (len - 1);

                    for (var j = 0; j < len; j++) {
                        // 标签参数对象
                        var _labelYSP = new _Label.Label(dvb[0] - 5 + ylOffset[0], labelY + ylOffset[1], axisYLabels[j]);
                        _labelYSP.style = {
                            labelAlign: "right"
                        };
                        // 用户 style
                        if (sets.axisYLabelsStyle) {
                            _Util.Util.copyAttributesWithClip(_labelYSP.style, sets.axisYLabelsStyle);
                        }
                        // 禁止事件
                        _labelYSP.clickable = false;
                        _labelYSP.hoverable = false;
                        // 制作标签
                        yLabels.push(shapeFactory.createShape(_labelYSP));
                        // y 轴标签 y 方向增量
                        labelY += yUnit;
                    }
                }
            }

            // X 轴标签
            var xLabels = [];
            if (sets.axisXLabels && sets.axisXLabels.length && sets.axisXLabels.length > 0) {
                var axisXLabels = sets.axisXLabels;
                var _len = axisXLabels.length;

                // 标签偏移量
                var xlOffset = [0, 0];
                if (sets.axisXLabelsOffset && sets.axisXLabelsOffset.length) {
                    xlOffset = sets.axisXLabelsOffset;
                }

                // 标签个数与数据字段个数相等等时，标签在 x 轴均匀排列
                if (xShapeInfo && xShapeInfo.xPositions && xShapeInfo.xPositions.length && xShapeInfo.xPositions.length == _len) {
                    var xsCenter = xShapeInfo.xPositions;
                    for (var K = 0; K < _len; K++) {
                        // 标签参数对象
                        var labelXSP = new _Label.Label(xsCenter[K] + xlOffset[0], dvb[1] + xlOffset[1], axisXLabels[K]);
                        // 默认 style
                        labelXSP.style = {
                            labelAlign: "center",
                            labelBaseline: "top"
                        };
                        // 用户 style
                        if (sets.axisXLabelsStyle) {
                            _Util.Util.copyAttributesWithClip(labelXSP.style, sets.axisXLabelsStyle);
                        }
                        // 禁止事件
                        labelXSP.clickable = false;
                        labelXSP.hoverable = false;
                        // 创建标签对象
                        xLabels.push(shapeFactory.createShape(labelXSP));
                    }
                } else {
                    if (_len == 1) {
                        // 标签参数对象
                        var _labelXSP = new _Label.Label(dvb[0] - 5 + xlOffset[0], dvb[1] + xlOffset[0], axisXLabels[0]);
                        // 默认 style
                        _labelXSP.style = {
                            labelAlign: "center",
                            labelBaseline: "top"
                        };
                        // 用户 style
                        if (sets.axisXLabelsStyle) {
                            _Util.Util.copyAttributesWithClip(_labelXSP.style, sets.axisXLabelsStyle);
                        }
                        // 禁止事件
                        _labelXSP.clickable = false;
                        _labelXSP.hoverable = false;
                        // 创建标签对象
                        xLabels.push(shapeFactory.createShape(_labelXSP));
                    } else {
                        var labelX = dvb[0];
                        // x 轴标签单位距离
                        var xUnit = Math.abs(dvb[2] - dvb[0]) / (_len - 1);

                        for (var m = 0; m < _len; m++) {
                            // 标签参数对象
                            var _labelXSP2 = new _Label.Label(labelX + xlOffset[0], dvb[1] + xlOffset[1], axisXLabels[m]);
                            // 默认 style
                            _labelXSP2.style = {
                                labelAlign: "center",
                                labelBaseline: "top"
                            };
                            // 用户 style
                            if (sets.axisXLabelsStyle) {
                                _Util.Util.copyAttributesWithClip(_labelXSP2.style, sets.axisXLabelsStyle);
                            }
                            // 禁止事件
                            _labelXSP2.clickable = false;
                            _labelXSP2.hoverable = false;
                            // 创建标签对象
                            xLabels.push(shapeFactory.createShape(_labelXSP2));
                            // x 轴标签 x 方向增量
                            labelX += xUnit;
                        }
                    }
                }
            }

            // 组装并返回构成坐标轴的图形
            return refLines.concat(axisMain).concat(yLabels).concat(xLabels).concat(arrows);
        }

        /**
         * @function  SuperMap.Feature.ShapeParameters.prototype.ShapeStyleTool
         * @description 一个图形 style 处理工具。此工具将指定的默认 style，通用 style，按 styleGroup 取得的 style 和按数据值 value 范围取得的 style 进行合并，得到图形最终的 style。
         * @param {Object} defaultStyle - 默认style，此样式对象可设属性根据图形类型参考 <{@link SuperMap.Feature.ShapeParameters}> 子类对象的 style 属性。
         * @param {Object} style - 图形对象基础 style，此参数控制图形的基础样式，可设属性根据图形类型参考 <{@link SuperMap.Feature.ShapeParameters}> 子类对象的 style 属性。优先级低于 styleGroup，styleByCodomain。
         * @param {Array.<Object>} styleGroup - 一个 style 数组，优先级低于 styleByCodomain，高于 style。此数组每个元素是样式对象，
         * 其可设属性根据图形类型参考 <{@link SuperMap.Feature.ShapeParameters}> 子类对象的 style 属性。通过 index 参数从 styleGroup 中取 style。
         * @param {Array.<Object>} styleByCodomain - 按数据（参数 value）所在值域范围控制数据的可视化对象样式。
         * (start code)
         * // styleByCodomain 的每个元素是个包含值域信息和与值域对应样式信息的对象，该对象（必须）有三个属性：
         * // start: 值域值下限（包含）;
         * // end: 值域值上限（不包含）;
         * // style: 数据可视化图形的 style，其可设属性根据图形类型参考 <SuperMap.Feature.ShapeParameters> 子类对象的 style 属性。。
         * // dataStyleByCodomain 数组形如：
         * [
         *   {
        *     start:0,
        *     end:250,
        *     style:{
        *          fillColor:"#00CD00"
        *      }
        *  },
         *   {
        *     start:250,
        *     end:500,
        *     style:{
        *          fillColor:"#00EE00"
        *      }
        *  },
         *   {
        *     start:500,
        *     end:750,
        *     style:{
        *          fillColor:"#00FF7F"
        *      }
        *  },
         *   {
        *     start:750,
        *     end:1500,
        *     style:{
        *          fillColor:"#00FF00"
        *      }
        *  }
         * ]
         * (end)
         * @param {number} index - styleGroup 的索引值，用于取出 styleGroup 指定的 style。
         * @param {number} value - 数据值，用于取出 styleByCodomain 指定的 style。
         * @returns {Object} 合并后的样式 （style） 对象。
         */

    }, {
        key: 'ShapeStyleTool',
        value: function ShapeStyleTool(defaultStyle, style, styleGroup, styleByCodomain, index, value) {
            // 用 defaultStyle 初始化 style 对象
            var finalStyle = defaultStyle ? defaultStyle : {};

            // 基础 style
            if (style) {
                _Util.Util.copyAttributesWithClip(finalStyle, style);
            }

            // 按索引赋 style
            if (styleGroup && styleGroup.length && typeof index !== "undefined" && !isNaN(index) && index >= 0) {
                if (styleGroup[index]) {
                    _Util.Util.copyAttributesWithClip(finalStyle, styleGroup[index]);
                }
            }

            // 按值域赋 style
            if (styleByCodomain && styleByCodomain.length && typeof value !== "undefined") {
                var dsc = styleByCodomain;
                var dscLen = dsc.length;
                var v = parseFloat(value);
                for (var i = 0; i < dscLen; i++) {
                    if (dsc[i].start <= v && v < dsc[i].end) {
                        _Util.Util.copyAttributesWithClip(finalStyle, dsc[i].style);
                        break;
                    }
                }
            }

            return finalStyle;
        }
    }]);

    return ShapeFactory;
}();

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeFactory = ShapeFactory;

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Theme = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

__webpack_require__(202);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Theme
 * @category  iServer Map Theme
 * @classdesc 专题图基类。
 * @param {string} type - 专题图类型。
 * @param {Object} options - 参数。
 * @param {SuperMap.ThemeMemoryData} [options.memoryData] - 专题图内存数据。
 */
var Theme = exports.Theme = function () {
    function Theme(type, options) {
        _classCallCheck(this, Theme);

        if (!type) {
            return this;
        }
        /**
         * @member {SuperMap.ThemeMemoryData} SuperMap.Theme.prototype.memoryData
         * @description 专题图内存数据。<br>
         *              用内存数据制作专题图的方式与表达式制作专题图的方式互斥，前者优先级较高。
         *              第一个参数代表专题值，即数据集中用来做专题图的字段或表达式的值；第二个参数代表外部值。在制作专题图时，会用外部值代替专题值来制作相应的专题图。
         */
        this.memoryData = null;

        /**
         * @member {string} SuperMap.Theme.prototype.type
         * @description 专题图类型。
         */
        this.type = type;

        if (options) {
            _Util.Util.extend(this, options);
        }

        this.CLASS_NAME = "SuperMap.Theme";
    }

    /**
     * @function SuperMap.Theme.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(Theme, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.memoryData) {
                me.memoryData.destroy();
                me.memoryData = null;
            }
            me.type = null;
        }

        /**
         * @function SuperMap.Theme.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @returns {Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            //return 子类实现
            return;
        }
    }]);

    return Theme;
}();

_SuperMap.SuperMap.Theme = Theme;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Geometry = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

// import {WKT} from '../format/WKT';
// import {Vector} from './Vector';


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Geometry
 * @category BaseTypes Geometry
 * @classdesc 几何对象类，描述地理对象的几何图形。
 */
var Geometry = exports.Geometry = function () {
    function Geometry() {
        _classCallCheck(this, Geometry);

        this.CLASS_NAME = "SuperMap.Geometry";
        /**
         * @member {string} SuperMap.Geometry.prototype.id
         * @description  此几何对象的唯一标示符。
         *
         */
        this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");

        /**
         * @member {SuperMap.Geometry} SuperMap.Geometry.prototype.parent
         * @description This is set when a Geometry is added as component
         * of another geometry
         */
        this.parent = null;

        /**
         * @member {SuperMap.Bounds} SuperMap.Geometry.prototype.bounds
         * @description 几何对象的范围。
         *
         */
        this.bounds = null;

        /**
         * @member {interger} SuperMap.Geometry.prototype.SRID
         * @description 投影坐标参数。通过该参数，服务器判断 Geometry 对象的坐标参考系是否与数据集相同，如果不同，则在数据入库前进行投影变换。
         * @example
         *   var geometry= new SuperMap.Geometry();
         *   geometry. SRID=4326;
         *
         */
        this.SRID = null;
    }

    /**
     * @function SuperMap.Geometry.prototype.destroy
     * @description 解构 Geometry 类，释放资源。
     */


    _createClass(Geometry, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.bounds = null;
            this.SRID = null;
        }

        /**
         * @function SuperMap.Geometry.prototype.clone
         * @description 创建克隆的几何图形。克隆的几何图形不设置非标准的属性。
         * @returns {SuperMap.Geometry} 克隆的几何图形。
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new Geometry();
        }

        /**
         * @function SuperMap.Geometry.prototype.setBounds
         * @description 设置此几何对象的 bounds。
         * @param {SuperMap.Bounds} bounds - 范围。
         */

    }, {
        key: 'setBounds',
        value: function setBounds(bounds) {
            if (bounds) {
                this.bounds = bounds.clone();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.clearBounds
         * @description 清除几何对象的 bounds。
         * 如果该对象有父类，也会清除父类几何对象的 bounds。
         */

    }, {
        key: 'clearBounds',
        value: function clearBounds() {
            this.bounds = null;
            if (this.parent) {
                this.parent.clearBounds();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.extendBounds
         * @description Extend the existing bounds to include the new bounds.
         * If geometry's bounds is not yet set, then set a new Bounds.
         *
         * @param {SuperMap.Bounds} newBounds - 范围。
         */

    }, {
        key: 'extendBounds',
        value: function extendBounds(newBounds) {
            var bounds = this.getBounds();
            if (!bounds) {
                this.setBounds(newBounds);
            } else {
                this.bounds.extend(newBounds);
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.getBounds
         * @description 获得几何图形的边界。如果没有设置边界，可通过计算获得。
         * @returns {SuperMap.Bounds} 返回的几何对象的边界。
         */

    }, {
        key: 'getBounds',
        value: function getBounds() {
            if (this.bounds == null) {
                this.calculateBounds();
            }
            return this.bounds;
        }

        /**
         * @function SuperMap.Geometry.prototype.calculateBounds
         * @description 重新计算几何图形的边界（需要在子类中实现此方法）。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {}
        //
        // This should be overridden by subclasses.
        //


        /**
         * @function SuperMap.Geometry.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表（需要在子类中实现此方法）。
         * @param {boolean} [nodes] - 如果是 true，线则只返回线的末端点，如果 false，仅仅返回顶点，如果没有设置，则返回顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {} // eslint-disable-line no-unused-vars


        /**
         * @function SuperMap.Geometry.prototype.getArea
         * @description 计算几何对象的面积 ，此方法需要在子类中定义。
         * @returns {float} The area of the collection by summing its parts
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            //to be overridden by geometries that actually have an area
            //
            return 0.0;
        }

        // /**
        //  * @function SuperMap.Geometry.prototype.toString
        //  * @description 返回geometry对象的字符串表述，需要引入{@link SuperMap.Format.WKT}。此方法只能在子类实现，在父类使用会报错。
        //  * @returns {string} geometry对象的字符串表述(Well-Known Text)
        //  */
        // toString() {
        // var string;
        // if (WKT) {
        //     var wkt = new WKT();
        //     string = wkt.write(new Vector(this));
        // } else {
        //     string = Object.prototype.toString.call(this);
        // }
        // return string;
        // }

    }]);

    return Geometry;
}();

_SuperMap.SuperMap.Geometry = Geometry;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Bounds = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Size = __webpack_require__(261);

var _Pixel = __webpack_require__(76);

var _LonLat = __webpack_require__(44);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Bounds
 * @category BaseTypes Geometry
 * @classdesc 表示边界类实例。使用 bounds 之前需要设置 left，bottom，right，top 四个属性，这些属性的初始值为 null。
 * @param {number} [left] - 左边界，注意考虑宽度，理论上小于 right 值。
 * @param {number} [bottom] - 下边界。考虑高度，理论上小于 top 值。
 * @param {number} [right] - 右边界。
 * @param {number} [top] - 上边界。
 * @param {Array.<number>} [array] - [left, bottom, right, top]，如果同时传多个参数，则使用左下右上组成的数组。
 * @example
 * var bounds = new SuperMap.Bounds();
 * bounds.extend(new SuperMap.LonLat(4,5));
 * bounds.extend(new SuperMap.LonLat(5,6));
 * bounds.toBBOX(); // returns 4,5,5,6
 */
var Bounds = exports.Bounds = function () {
    function Bounds(left, bottom, right, top) {
        _classCallCheck(this, Bounds);

        if (_Util.Util.isArray(left)) {
            top = left[3];
            right = left[2];
            bottom = left[1];
            left = left[0];
        }
        /**
         * @member {number} SuperMap.Bounds.prototype.left
         * @description 最小的水平坐标系。
         */
        this.left = left != null ? _Util.Util.toFloat(left) : this.left;

        /**
         * @member {number} SuperMap.Bounds.prototype.bottom
         * @description 最小的垂直坐标系。
         */
        this.bottom = bottom != null ? _Util.Util.toFloat(bottom) : this.bottom;

        /**
         * @member {number} SuperMap.Bounds.prototype.right
         * @description 最大的水平坐标系。
         */
        this.right = right != null ? _Util.Util.toFloat(right) : this.right;

        /**
         * @member {number} SuperMap.Bounds.prototype.top
         * @description 最大的垂直坐标系。
         */
        this.top = top != null ? _Util.Util.toFloat(top) : this.top;

        /**
         * @member {SuperMap.LonLat} SuperMap.Bounds.prototype.centerLonLat
         * @description bounds 的地图空间的中心点。用 getCenterLonLat() 获得。
         */
        this.centerLonLat = null;
        this.CLASS_NAME = "SuperMap.Bounds";
    }

    /**
     * @function SuperMap.Bounds.prototype.clone
     * @description 复制当前 bounds 对象。
     * @example
     * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
     * var bounds2 = bounds1.clone();
     * @returns {SuperMap.Bounds} 返回一个克隆的 bounds。
     */


    _createClass(Bounds, [{
        key: 'clone',
        value: function clone() {
            return new Bounds(this.left, this.bottom, this.right, this.top);
        }

        /**
         * @function SuperMap.Bounds.prototype.equals
         * @description 判断两个 bounds 对象是否相等。
         * @example
         * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
         * var bounds2 = new SuperMap.Bounds(-180,-90,180,90);
         * var isEquals = bounds1.equals(bounds2);
         * @param {SuperMap.Bounds} bounds - 需要进行计较的 bounds。
         * @returns {boolean} 如果 bounds 对象的边和传入的 bounds 一致则返回 true，不一致或传入的 bounds 参数为 NULL 则返回 false。
         */

    }, {
        key: 'equals',
        value: function equals(bounds) {
            var equals = false;
            if (bounds != null) {
                equals = this.left === bounds.left && this.right === bounds.right && this.top === bounds.top && this.bottom === bounds.bottom;
            }
            return equals;
        }

        /**
         * @function SuperMap.Bounds.prototype.toString
         * @description 返回此对象的字符串形式。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,180,90);
         * var str = bounds.toString();
         * @returns {string} 边界对象的字符串表示形式（left,bottom,right,top），例如: "-180,-90,180,90"。
         */

    }, {
        key: 'toString',
        value: function toString() {
            return [this.left, this.bottom, this.right, this.top].join(",");
        }

        /**
         * @function SuperMap.Bounds.prototype.toArray
         * @description 边界对象的数组表示形式。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //array1 = [-180,-90,100,80];
         * var array1 = bounds.toArray();
         * //array1 = [-90,-180,80,100];
         * var array2 = bounds.toArray(true);
         * @param {boolean} [reverseAxisOrder=false] - 是否反转轴顺序。
         * 如果设为 true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
         * @returns {Array.<number>} left, bottom, right, top 数组。
         */

    }, {
        key: 'toArray',
        value: function toArray(reverseAxisOrder) {
            if (reverseAxisOrder === true) {
                return [this.bottom, this.left, this.top, this.right];
            } else {
                return [this.left, this.bottom, this.right, this.top];
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toBBOX
         * @description 取小数点后 decimal 位数字进行四舍五入再转换为 BBOX 字符串。
         * @example
         * var bounds = new SuperMap.Bounds(-1.1234567,-1.7654321,1.4444444,1.5555555);
         * //str1 = "-1.123457,-1.765432,1.444444,1.555556";
         * var str1 = bounds.toBBOX();
         * //str2 = "-1.1,-1.8,1.4,1.6";
         * var str2 = bounds.toBBOX(1);
         * //str2 = "-1.8,-1.1,1.6,1.4";
         * var str2 = bounds.toBBOX(1,true);
         * @param {integer} [decimal=6] - 边界方位坐标的有效数字个数。
         * @param {boolean} [reverseAxisOrder=false] - 是否是反转轴顺序。
         * 如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {string} 边界对象的字符串表示形式，如："5,42,10,45"。
         */

    }, {
        key: 'toBBOX',
        value: function toBBOX(decimal, reverseAxisOrder) {
            if (decimal == null) {
                decimal = 6;
            }
            var mult = Math.pow(10, decimal);
            var xmin = Math.round(this.left * mult) / mult;
            var ymin = Math.round(this.bottom * mult) / mult;
            var xmax = Math.round(this.right * mult) / mult;
            var ymax = Math.round(this.top * mult) / mult;
            if (reverseAxisOrder === true) {
                return ymin + "," + xmin + "," + ymax + "," + xmax;
            } else {
                return xmin + "," + ymin + "," + xmax + "," + ymax;
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toGeometry
         * @description 基于当前边界范围创建一个新的多边形对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //SuperMap.Geometry.Polygon对象
         * var geo = bounds.toGeometry();
         * @returns {SuperMap.Geometry.Polygon} 基于当前 bounds 坐标创建的新的多边形。
         */
        // toGeometry() {
        //     return new Polygon([
        //         new LinearRing([
        //             new Point(this.left, this.bottom),
        //             new Point(this.right, this.bottom),
        //             new Point(this.right, this.top),
        //             new Point(this.left, this.top)
        //         ])
        //     ]);
        // }

        /**
         * @function SuperMap.Bounds.prototype.getWidth
         * @description 获取 bounds 的宽度。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //width = 280;
         * var width = bounds.getWidth();
         * @returns {float} 获取当前 bounds 的宽度（right 减去 left）。
         */

    }, {
        key: 'getWidth',
        value: function getWidth() {
            return this.right - this.left;
        }

        /**
         * @function SuperMap.Bounds.prototype.getHeight
         * @description 获取 bounds 的高度。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //height = 170;
         * var height = bounds.getHeight();
         * @returns {float} 返回边界高度（top 减去 bottom）。
         */

    }, {
        key: 'getHeight',
        value: function getHeight() {
            return this.top - this.bottom;
        }

        /**
         * @function SuperMap.Bounds.prototype.getSize
         * @description 获取边框大小。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var size = bounds.getSize();
         * @returns {SuperMap.Size} 返回边框大小。
         */

    }, {
        key: 'getSize',
        value: function getSize() {
            return new _Size.Size(this.getWidth(), this.getHeight());
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterPixel
         * @description 获取像素格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var pixel = bounds.getCenterPixel();
         * @returns {SuperMap.Pixel} 返回像素格式的当前范围的中心点。
         */

    }, {
        key: 'getCenterPixel',
        value: function getCenterPixel() {
            return new _Pixel.Pixel((this.left + this.right) / 2, (this.bottom + this.top) / 2);
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterLonLat
         * @description 获取地理格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var lonlat = bounds.getCenterLonLat();
         * @returns {SuperMap.LonLat} 返回当前地理范围的中心点。
         */

    }, {
        key: 'getCenterLonLat',
        value: function getCenterLonLat() {
            if (!this.centerLonLat) {
                this.centerLonLat = new _LonLat.LonLat((this.left + this.right) / 2, (this.bottom + this.top) / 2);
            }
            return this.centerLonLat;
        }

        /**
         * @function SuperMap.Bounds.prototype.scale
         * @description 按照比例扩大/缩小出一个新的 bounds。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * var bounds2 = bounds.scale(2);
         * @param {float} [ratio=1] - 需要扩大的比例。
         * @param {(SuperMap.Pixel|SuperMap.LonLat)} [origin] - 扩大时的基准点，默认为当前 bounds 的中心点。
         * @returns {SuperMap.Bounds} 返回通过 ratio、origin 计算得到的新的边界范围。
         */

    }, {
        key: 'scale',
        value: function scale(ratio, origin) {
            ratio = ratio ? ratio : 1;
            if (origin == null) {
                origin = this.getCenterLonLat();
            }

            var origx, origy;

            // get origin coordinates
            if (origin.CLASS_NAME === "SuperMap.LonLat") {
                origx = origin.lon;
                origy = origin.lat;
            } else {
                origx = origin.x;
                origy = origin.y;
            }

            var left = (this.left - origx) * ratio + origx;
            var bottom = (this.bottom - origy) * ratio + origy;
            var right = (this.right - origx) * ratio + origx;
            var top = (this.top - origy) * ratio + origy;

            return new Bounds(left, bottom, right, top);
        }

        /**
         * @function SuperMap.Bounds.prototype.add
         * @description 在当前的 Bounds 上按照传入的坐标点进行平移，返回新的范围。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //bounds2 是新的 bounds
         * var bounds2 = bounds.add(20,10);
         * @param {float} x - 传入坐标点的 x 坐标。
         * @param {float} y - 传入坐标点的 y 坐标。
         * @returns {SuperMap.Bounds} 返回一个新的 bounds，此 bounds 的坐标是由传入的 x，y 参数与当前 bounds 坐标计算所得。
         */

    }, {
        key: 'add',
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Bounds.add cannot receive null values');
            }
            return new Bounds(this.left + x, this.bottom + y, this.right + x, this.top + y);
        }

        /**
         * @function SuperMap.Bounds.prototype.extend
         * @description 在当前 bounds 上扩展 bounds，支持 point，lanlat 和 bounds。扩展后的 bounds 的范围是两者的结合。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //bounds 改变
         * bounds.extend(new SuperMap.LonLat(50,60));
         * @param {(SuperMap.Geometry.Point|SuperMap.LonLat|SuperMap.Bounds)} object - 可以是 point、lonlat 和 bounds。
         */

    }, {
        key: 'extend',
        value: function extend(object) {
            var bounds = null;
            if (object) {
                // clear cached center location
                switch (object.CLASS_NAME) {
                    case "SuperMap.LonLat":
                        bounds = new Bounds(object.lon, object.lat, object.lon, object.lat);
                        break;
                    case "SuperMap.Geometry.Point":
                        bounds = new Bounds(object.x, object.y, object.x, object.y);
                        break;

                    case "SuperMap.Bounds":
                        bounds = object;
                        break;
                }

                if (bounds) {
                    this.centerLonLat = null;
                    if (this.left == null || bounds.left < this.left) {
                        this.left = bounds.left;
                    }
                    if (this.bottom == null || bounds.bottom < this.bottom) {
                        this.bottom = bounds.bottom;
                    }
                    if (this.right == null || bounds.right > this.right) {
                        this.right = bounds.right;
                    }
                    if (this.top == null || bounds.top > this.top) {
                        this.top = bounds.top;
                    }
                }
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.containsLonLat
         * @description 判断传入的坐标是否在范围内。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains1 = true
         * //这里的第二个参数可以直接为 boolean 类型，也就是inclusive
         * var isContains1 = bounds.containsLonLat(new SuperMap.LonLat(40,40),true);
         *
         * //(40,40)在范围内，同样(40+360,40)也在范围内
         * var bounds2 = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains2 = true;
         * var isContains2 = bounds2.containsLonLat(
         *      new SuperMap.LonLat(400,40),
         *      {
         *           inclusive:true,
         *           //全球的范围
         *           worldBounds: new SuperMap.Bounds(-180,-90,180,90)
         *      }
         * );
         * @param {(SuperMap.LonLat|Object)} ll - <SuperMap.LonLat> 对象或者是一个包含 'lon' 与 'lat' 属性的对象。
         * @param {Object} options - 可选参数。
         * @param {boolean} [options.inclusive=true] - 是否包含边界。
         * @param {SuperMap.Bounds} [options.worldBounds] - 如果提供 worldBounds 参数, 如果 ll 参数提供的坐标超出了世界边界（worldBounds），
         *        但是通过日界线的转化可以被包含, 它将被认为是包含在该范围内的。
         * @returns {boolean} 传入坐标是否包含在范围内。
         */

    }, {
        key: 'containsLonLat',
        value: function containsLonLat(ll, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            var contains = this.contains(ll.lon, ll.lat, options.inclusive),
                worldBounds = options.worldBounds;
            //日界线以外的也有可能算包含，
            if (worldBounds && !contains) {
                var worldWidth = worldBounds.getWidth();
                var worldCenterX = (worldBounds.left + worldBounds.right) / 2;
                //这一步很关键
                var worldsAway = Math.round((ll.lon - worldCenterX) / worldWidth);
                contains = this.containsLonLat({
                    lon: ll.lon - worldsAway * worldWidth,
                    lat: ll.lat
                }, { inclusive: options.inclusive });
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsPixel
         * @description 判断传入的像素是否在范围内。直接匹配大小，不涉及像素和地理转换。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains = true
         * var isContains = bounds.containsPixel(new SuperMap.Pixel(40,40),true);
         * @param {SuperMap.Pixel} px - 提供的像素参数。
         * @param {boolean} [inclusive=true] - 是否包含边界。
         * @returns {boolean} 传入的 pixel 在当前边界范围之内。
         */

    }, {
        key: 'containsPixel',
        value: function containsPixel(px, inclusive) {
            return this.contains(px.x, px.y, inclusive);
        }

        /**
         * @function SuperMap.Bounds.prototype.contains
         * @description 判断传入的 x，y 坐标值是否在范围内。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains = true
         * var isContains = bounds.contains(40,40,true);
         * @param {float} x - 传入的 x 坐标值。
         * @param {float} y - 传入的 y 坐标值。
         * @param {boolean} [inclusive=true] - 是否包含边界。
         * @returns {boolean} 传入的 x，y 坐标是否在当前范围内。
         */

    }, {
        key: 'contains',
        value: function contains(x, y, inclusive) {
            //set default
            if (inclusive == null) {
                inclusive = true;
            }

            if (x == null || y == null) {
                return false;
            }

            //x = Util.toFloat(x);
            //y = Util.toFloat(y);

            var contains = false;
            if (inclusive) {
                contains = x >= this.left && x <= this.right && y >= this.bottom && y <= this.top;
            } else {
                contains = x > this.left && x < this.right && y > this.bottom && y < this.top;
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.intersectsBounds
         * @description 判断目标边界范围是否与当前边界范围相交。如果两个边界范围中的任意
         *              边缘相交或者一个边界包含了另外一个就认为这两个边界相交。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var isIntersects = bounds.intersectsBounds(
         *      new SuperMap.Bounds(-170,-90,120,80)
         *  );
         * @param {SuperMap.Bounds} bounds - 目标边界。
         * @param {Object} options - 参数。
         * @param {boolean} [options.inclusive=true] - 边缘重合也看成相交。如果是false，
         *                               两个边界范围没有重叠部分仅仅是在边缘相接（重合），
         *                               这种情况被认为没有相交。
         * @param {SuperMap.Bounds} [options.worldBounds] - 提供了 worldBounds 参数, 如果他们相交时
         *                               是在全球范围内, 两个边界将被视为相交。这仅适用于交叉或完全不在世界范围的边界。
         * @returns {boolean} 传入的 bounds 对象与当前 bounds 相交。
         */

    }, {
        key: 'intersectsBounds',
        value: function intersectsBounds(bounds, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            if (options.worldBounds) {
                var self = this.wrapDateLine(options.worldBounds);
                bounds = bounds.wrapDateLine(options.worldBounds);
            } else {
                self = this;
            }
            if (options.inclusive == null) {
                options.inclusive = true;
            }
            var intersects = false;
            var mightTouch = self.left === bounds.right || self.right === bounds.left || self.top === bounds.bottom || self.bottom === bounds.top;

            // if the two bounds only touch at an edge, and inclusive is false,
            // then the bounds don't *really* intersect.
            if (options.inclusive || !mightTouch) {
                // otherwise, if one of the boundaries even partially contains another,
                // inclusive of the edges, then they do intersect.
                var inBottom = bounds.bottom >= self.bottom && bounds.bottom <= self.top || self.bottom >= bounds.bottom && self.bottom <= bounds.top;
                var inTop = bounds.top >= self.bottom && bounds.top <= self.top || self.top > bounds.bottom && self.top < bounds.top;
                var inLeft = bounds.left >= self.left && bounds.left <= self.right || self.left >= bounds.left && self.left <= bounds.right;
                var inRight = bounds.right >= self.left && bounds.right <= self.right || self.right >= bounds.left && self.right <= bounds.right;
                intersects = (inBottom || inTop) && (inLeft || inRight);
            }
            // document me
            if (options.worldBounds && !intersects) {
                var world = options.worldBounds;
                var width = world.getWidth();
                var selfCrosses = !world.containsBounds(self);
                var boundsCrosses = !world.containsBounds(bounds);
                if (selfCrosses && !boundsCrosses) {
                    bounds = bounds.add(-width, 0);
                    intersects = self.intersectsBounds(bounds, { inclusive: options.inclusive });
                } else if (boundsCrosses && !selfCrosses) {
                    self = self.add(-width, 0);
                    intersects = bounds.intersectsBounds(self, { inclusive: options.inclusive });
                }
            }
            return intersects;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsBounds
         * @description 判断目标边界是否被当前边界包含在内。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var isContains = bounds.containsBounds(
         *      new SuperMap.Bounds(-170,-90,100,80),true,true
         *  );
         * @param {SuperMap.Bounds} bounds - 目标边界。
         * @param {boolean} [partial=false] - 目标边界的任意部分都包含在当前边界中则被认为是包含关系。
         * 如果设为 false，整个目标边界全部被包含在当前边界范围内。
         * @param {boolean} [inclusive=true] - 边缘共享被视为包含。
         * @returns {boolean} 传入的边界被当前边界包含。
         */

    }, {
        key: 'containsBounds',
        value: function containsBounds(bounds, partial, inclusive) {
            if (partial == null) {
                partial = false;
            }
            if (inclusive == null) {
                inclusive = true;
            }
            var bottomLeft = this.contains(bounds.left, bounds.bottom, inclusive);
            var bottomRight = this.contains(bounds.right, bounds.bottom, inclusive);
            var topLeft = this.contains(bounds.left, bounds.top, inclusive);
            var topRight = this.contains(bounds.right, bounds.top, inclusive);

            return partial ? bottomLeft || bottomRight || topLeft || topRight : bottomLeft && bottomRight && topLeft && topRight;
        }

        /**
         * @function SuperMap.Bounds.prototype.determineQuadrant
         * @description 判断传入坐标是否在 bounds 范围内的象限。以 bounds 中心点为坐标原点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //str = "tr";
         * var str = bounds.determineQuadrant(
         *      new SuperMap.LonLat(20,20)
         *  );
         * @param {SuperMap.LonLat} lonlat - 传入的坐标对象。
         * @returns {string} 传入坐标所在的象限（"br" "tr" "tl" "bl" 分别对应"右下"，"右上"，"左上" "左下"）。
         */

    }, {
        key: 'determineQuadrant',
        value: function determineQuadrant(lonlat) {

            var quadrant = "";
            var center = this.getCenterLonLat();

            quadrant += lonlat.lat < center.lat ? "b" : "t";
            quadrant += lonlat.lon < center.lon ? "l" : "r";

            return quadrant;
        }

        /**
         * @function SuperMap.Bounds.prototype.wrapDateLine
         * @description 将当前 bounds 移动到最大边界范围内部（所谓的内部是相交或者内部）。
         * @example
         * var bounds = new SuperMap.Bounds(380,-40,400,-20);
         * var maxExtent = new SuperMap.Bounds(-180,-90,100,80);
         * //新的bounds
         * var newBounds = bounds.wrapDateLine(maxExtent);
         * @param {SuperMap.Bounds} maxExtent - 最大的边界范围（一般是全球范围）。
         * @param {Object} options - 可选选项参数。 
         * @param {float} [options.leftTolerance=0] - left 允许的误差。 
         * @param {float} [options.rightTolerance=0] - right 允许的误差。
         * @returns {SuperMap.Bounds} 克隆当前边界。如果当前边界完全在最大范围之外此函数则返回一个不同值的边界，
         *                            若落在最大边界的左边，则给当前的bounds值加上最大范围的宽度，即向右移动，
         *                            若落在右边，则向左移动，即给当前的bounds值加上负的最大范围的宽度。
         */

    }, {
        key: 'wrapDateLine',
        value: function wrapDateLine(maxExtent, options) {
            options = options || {};

            var leftTolerance = options.leftTolerance || 0;
            var rightTolerance = options.rightTolerance || 0;

            var newBounds = this.clone();

            if (maxExtent) {
                var width = maxExtent.getWidth();
                //如果 newBounds 在 maxExtent 的左边，那么一直向右移动，直到相交或者包含为止，每次移动width
                //shift right?
                while (newBounds.left < maxExtent.left && newBounds.right - rightTolerance <= maxExtent.left) {
                    newBounds = newBounds.add(width, 0);
                }
                //如果 newBounds 在 maxExtent 的右边，那么一直向左移动，直到相交或者包含为止，每次移动width
                //shift left?
                while (newBounds.left + leftTolerance >= maxExtent.right && newBounds.right > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
                //如果和右边相交，左边又在内部，那么再次向左边移动一次
                // crosses right only? force left
                var newLeft = newBounds.left + leftTolerance;
                if (newLeft < maxExtent.right && newLeft > maxExtent.left && newBounds.right - rightTolerance > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
            }

            return newBounds;
        }

        /**
         * @function SuperMap.Bounds.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var obj = bounds.toServerJSONObject();
         * @returns {Object} 返回 JSON 格式的 Object 对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = {
                rightTop: { x: this.right, y: this.top },
                leftBottom: { x: this.left, y: this.bottom },
                left: this.left,
                right: this.right,
                top: this.top,
                bottom: this.bottom
            };
            return jsonObject;
        }

        /**
         *
         * @function SuperMap.Bounds.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为 null，而不是初始值。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * bounds.destroy();
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.left = null;
            this.right = null;
            this.top = null;
            this.bottom = null;
            this.centerLonLat = null;
        }

        /**
         * @function SuperMap.Bounds.fromString
         * @description 通过字符串参数创建新的 bounds 的构造函数。
         * @example
         * var bounds = SuperMap.Bounds.fromString("-180,-90,100,80");
         * @param {string} str - 边界字符串，用逗号隔开（e.g. <i>"5,42,10,45"</i>）。
         * @param {boolean} [reverseAxisOrder=false] - 是否反转轴顺序。
         * 如果设为true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
         * @returns {SuperMap.Bounds} 返回给定的字符串创建的新的边界对象。
         */

    }], [{
        key: 'fromString',
        value: function fromString(str, reverseAxisOrder) {
            var bounds = str.split(",");
            return Bounds.fromArray(bounds, reverseAxisOrder);
        }

        /**
         * @function SuperMap.Bounds.fromArray
         * @description 通过边界框数组创建 Bounds。
         * @example
         * var bounds = SuperMap.Bounds.fromArray([-180,-90,100,80]);
         * @param {Array.<float>} bbox - 边界值数组。（e.g. <i>[5,42,10,45]</i>）。
         * @param {boolean} [reverseAxisOrder=false] - 是否是反转轴顺序。如果设为true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
         * @returns {SuperMap.Bounds} 返回根据传入的数组创建的新的边界对象。
         */

    }, {
        key: 'fromArray',
        value: function fromArray(bbox, reverseAxisOrder) {
            return reverseAxisOrder === true ? new Bounds(bbox[1], bbox[0], bbox[3], bbox[2]) : new Bounds(bbox[0], bbox[1], bbox[2], bbox[3]);
        }

        /**
         * @function SuperMap.Bounds.fromSize
         * @description 通过传入的边界大小来创建新的边界。
         * @example
         * var bounds = SuperMap.Bounds.fromSize(new SuperMap.Size(20,10));
         * @param {SuperMap.Size} size - 传入的边界大小。
         * @returns {SuperMap.Bounds} 返回根据传入的边界大小的创建新的边界。
         */

    }, {
        key: 'fromSize',
        value: function fromSize(size) {
            return new Bounds(0, size.h, size.w, 0);
        }

        /**
         * @function SuperMap.Bounds.oppositeQuadrant
         * @description 反转象限。"t"和"b" 交换，"r"和"l"交换, 如："tl"变为"br"。
         * @param {string} quadrant - 代表象限的字符串，如："tl"。
         * @returns {string} 反转后的象限。
         */

    }, {
        key: 'oppositeQuadrant',
        value: function oppositeQuadrant(quadrant) {
            var opp = "";

            opp += quadrant.charAt(0) === 't' ? 'b' : 't';
            opp += quadrant.charAt(1) === 'l' ? 'r' : 'l';

            return opp;
        }
    }]);

    return Bounds;
}();

_SuperMap.SuperMap.Bounds = Bounds;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Graph = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Bounds = __webpack_require__(28);

var _Theme2 = __webpack_require__(55);

var _ShapeFactory = __webpack_require__(25);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Feature.Theme.Graph
 * @classdesc 统计专题要素基类。
 * @category Visualization Theme
 * @description 此类定义了统计专题要素基础模型，具体的图表模型通过继承此类，在子类中实现 assembleShapes 方法。
 *              统计专题要素模型采用了可视化图形大小自适应策略，用较少的参数控制着图表诸多图形，图表配置对象 <SuperMap.Feature.Theme.Graph.setting> 的基础属性只有 7 个，
 *              它们控制着图表结构、值域范围、数据小数位等基础图表形态。构成图表的图形必须在图表结构里自适应大小。
 *              此类不可实例化，此类的可实例化子类必须实现 assembleShapes() 方法。
 * @extends SuperMap.Feature.Theme
 * @param {SuperMap.Feature.Vector} data - 用户数据。
 * @param {SuperMap.Layer.Theme} layer - 此专题要素所在图层。
 * @param {Array.<string>} fields - data 中的参与此图表生成的字段名称。
 * @param {Object} setting - 图表配置对象。
 * @param {SuperMap.LonLat} [lonlat] - 专题要素地理位置。默认为 data 指代的地理要素 Bounds 中心。
 */
var Graph = exports.Graph = function (_Theme) {
    _inherits(Graph, _Theme);

    function Graph(data, layer, fields, setting, lonlat, options) {
        _classCallCheck(this, Graph);

        /**
         * @member {SuperMap.Feature.ShapeFactory} SuperMap.Feature.Theme.Graph.prototype.shapeFactory
         * @description 内置的图形工厂对象，调用其 createShape 方法创建图形。
         */
        var _this = _possibleConstructorReturn(this, (Graph.__proto__ || Object.getPrototypeOf(Graph)).call(this, data, layer, fields, setting, lonlat, options));

        _this.shapeFactory = new _ShapeFactory.ShapeFactory();

        /**
         * @member {Object} SuperMap.Feature.Theme.Graph.prototype.shapeParameters
         * @description 当前图形参数对象，<SuperMap.Feature.ShapeParameters> 的子类对象。
         */
        _this.shapeParameters = null;

        /**
         * @member {boolean} [SuperMap.Feature.Theme.Graph.prototype.RelativeCoordinate]
         * @description 图形是否已经计算了相对坐标。
         */
        _this.RelativeCoordinate = false;

        /**
         * @member {Object} SuperMap.Feature.Theme.Graph.prototype.setting
         * @description 图表配置对象，该对象控制着图表的可视化显示。
         * @param {number} width - 专题要素（图表）宽度。
         * @param {number} height - 专题要素（图表）高度。
         * @param {Array.<number>} codomain - 值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限。
         * @param {number} [XOffset] - 专题要素（图表）在 X 方向上的偏移值，单位像素。
         * @param {number} [YOffset] - 专题要素（图表）在 Y 方向上的偏移值，单位像素。
         * @param {Array.<number>} [dataViewBoxParameter] - 数据视图框 dataViewBox 参数，它是指图表框 chartBox
         *                                                    （由图表位置、图表宽度、图表高度构成的图表范围框）在左、下，右，上四个方向上的内偏距值。
         * @param {number} [decimalNumber] - 数据值数组 dataValues 元素值小数位数，数据的小数位处理参数，取值范围：[0, 16]。
         *                                       如果不设置此参数，在取数据值时不对数据做小数位处理。
         *             
         */
        _this.setting = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.origonPoint 
         * @description 专题要素（图表）原点，图表左上角点像素坐标，是长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */
        _this.origonPoint = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.chartBox
         * @description 专题要素（图表）区域，即图表框，长度为 4 的一维数组，数组的 4 个元素依次表示图表框左端 x 坐标值、
         *              下端 y坐标值、 右端 x坐标值、 上端 y 坐标值；[left, bottom, right, top]。
         */
        _this.chartBox = null;

        /**
         * @readonly
         * @member {SuperMap.Bounds} SuperMap.Feature.Theme.Graph.prototype.chartBounds
         * @description 图表 Bounds 随着 lonlat、XOffset、YOffset 更新，注意 chartBounds 是图表像素范围，不是地理范围。
         */
        _this.chartBounds = null;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.width 
         * @description 专题要素（图表）宽度 。
         */
        _this.width = null;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.height
         * @description 专题要素（图表）高度 。
         */
        _this.height = null;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.XOffset
         * @description 专题要素（图表）在 X 方向上的偏移值，单位像素。
         */
        _this.XOffset = 0;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.YOffset
         * @description 专题要素（图表）在 Y 方向上的偏移值，单位像素。
         */
        _this.YOffset = 0;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.DVBParameter
         * @description 数据视图框参数，长度为 4 的一维数组（数组元素值 >= 0），[leftOffset, bottomOffset, rightOffset, topOffset]，chartBox 内偏距值。
         *               此属性用于指定数据视图框 dataViewBox 的范围。
         */
        _this.DVBParameter = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.dataViewBox 
         * @description 数据视图框，长度为 4 的一维数组，[left, bottom, right, top]。
         *              dataViewBox 是统计专题要素最核心的内容，它负责解释数据在一个像素区域里的数据可视化含义，
         *              这种含义用可视化图形表达出来，这些表示数据的图形和一些辅助图形组合在一起构成统计专题图表。
         */
        _this.dataViewBox = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.DVBCodomain 
         * @description 数据视图框的内允许展示的数据值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限。
         *              dataViewBox 中允许的数据范围，对数据溢出值域范围情况的处理需要在 assembleShapes 中进行。
         */
        _this.DVBCodomain = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.DVBCenterPoint 
         * @description 数据视图框中心点，长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */
        _this.DVBCenterPoint = null;

        /**
         * @readonly
         * @member {string} SuperMap.Feature.Theme.Graph.prototype.DVBUnitValue 
         * @description 单位值。在 assembleShapes() 中初始化其具体意义，例如：饼图的 DVBUnitValue 可以定义为"360/数据总和"，
         *              折线图的 DVBUnitValue 可以定义为 "DVBCodomain/DVBHeight"。
         */
        _this.DVBUnitValue = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.DVBOrigonPoint 
         * @description 数据视图框原点，数据视图框左上角点，长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */
        _this.DVBOrigonPoint = null;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.DVBWidth 
         * @description 数据视图框宽度。
         */
        _this.DVBWidth = null;

        /**
         * @readonly
         * @member {number} SuperMap.Feature.Theme.Graph.prototype.DVBHeight 
         * @description 数据视图框高度。
         */
        _this.DVBHeight = null;

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.origonPointOffset
         * @description 数据视图框原点相对于图表框的原点偏移量，长度为 2 的一维数组，第一个元素表示 x 偏移量，第二个元素表示 y 偏移量。
         */
        _this.origonPointOffset = null;

        /**
         * @readonly
         * @member {Array.<string>} SuperMap.Feature.Theme.Graph.prototype.fields 
         * @description 数据{SuperMap.Feature.Vector}属性字段。
         */
        _this.fields = fields || [];

        /**
         * @readonly
         * @member {Array.<number>} SuperMap.Feature.Theme.Graph.prototype.dataValues
         * @description 图表展示的数据值，通过 fields 从数据 feature 属性中获得。
         */
        _this.dataValues = null;
        // 图表位置
        if (lonlat) {
            _this.lonlat = lonlat;
        } else {
            // 默认使用 bounds 中心
            _this.lonlat = _this.data.geometry.getBounds().getCenterLonLat();
        }

        // 配置项检测与赋值
        if (setting && setting.width && setting.height && setting.codomain) {
            _this.setting = setting;
        }
        _this.CLASS_NAME = "SuperMap.Feature.Theme.Graph";

        return _this;
    }

    /**
     * @function SuperMap.Feature.Theme.Graph.prototype.destroy
     * @description 销毁专题要素。
     */


    _createClass(Graph, [{
        key: 'destroy',
        value: function destroy() {
            this.shapeFactory = null;
            this.shapeParameters = null;
            this.width = null;
            this.height = null;
            this.origonPoint = null;
            this.chartBox = null;
            this.dataViewBox = null;
            this.chartBounds = null;
            this.DVBParameter = null;
            this.DVBOrigonPoint = null;
            this.DVBCenterPoint = null;
            this.DVBWidth = null;
            this.DVBHeight = null;
            this.DVBCodomain = null;
            this.DVBUnitValue = null;
            this.origonPointOffset = null;
            this.XOffset = null;
            this.YOffset = null;
            this.fields = null;
            this.dataValues = null;
            this.setting = null;
            _get(Graph.prototype.__proto__ || Object.getPrototypeOf(Graph.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.initBaseParameter
         * @description 初始化专题要素（图表）基础参数。在调用此方法前，此类的图表模型相关属性都是不可用的 ，此方法在 assembleShapes 函数中调用。
         *              调用此函数关系到 setting 对象的以下属性。
         * @param {number} width - 专题要素（图表）宽度。
         * @param {number} height - 专题要素（图表）高度。
         * @param {Array.<number>} codomain - 值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限。
         * @param {number} [XOffset] - 专题要素（图表）在 X 方向上的偏移值，单位像素。
         * @param {number} [YOffset] - 专题要素（图表）在 Y 方向上的偏移值，单位像素。
         * @param {Array.<number>} [dataViewBoxParameter] - 数据视图框 dataViewBox 参数，它是指图表框 chartBox。
         *                                     （由图表位置、图表宽度、图表高度构成的图表范围框）在左、下，右，上四个方向上的内偏距值。
         * @param {number} [decimalNumber] - 数据值数组 dataValues 元素值小数位数，数据的小数位处理参数，取值范围：[0, 16]。如果不设置此参数，在取数据值时不对数据做小数位处理。
         * @returns {boolean} 初始化参数是否成功。
         */

    }, {
        key: 'initBaseParameter',
        value: function initBaseParameter() {
            // 参数初始化是否成功
            var isSuccess = true;

            // setting 属性是否已成功赋值
            if (!this.setting) {
                return false;
            }
            var sets = this.setting;
            // 检测 setting 的必设参数
            if (!(sets.width && sets.height && sets.codomain)) {
                return false;
            }

            // 数据
            var decimalNumber = typeof sets.decimalNumber !== "undefined" && !isNaN(sets.decimalNumber) ? sets.decimalNumber : -1;
            var dataEffective = _Theme2.Theme.getDataValues(this.data, this.fields, decimalNumber);
            this.dataValues = dataEffective ? dataEffective : [];

            // 基础参数  width, height, codomain
            this.width = parseFloat(sets.width);
            this.height = parseFloat(sets.height);
            this.DVBCodomain = sets.codomain;

            // 图表偏移
            // if(sets.XOffset) {this.XOffset = sets.XOffset};
            // if(sets.YOffset) {this.YOffset = sets.YOffset};
            this.XOffset = sets.XOffset ? sets.XOffset : 0;
            this.YOffset = sets.YOffset ? sets.YOffset : 0;

            // 其他默认值
            this.origonPoint = [];
            this.chartBox = [];
            this.dataViewBox = [];

            this.DVBParameter = sets.dataViewBoxParameter ? sets.dataViewBoxParameter : [0, 0, 0, 0];

            this.DVBOrigonPoint = [];
            this.DVBCenterPoint = [];
            this.origonPointOffset = [];

            // 图表位置
            this.resetLocation();

            // 专题要素宽度 w
            var w = this.width;
            // 专题要素高度 h
            var h = this.height;
            // 专题要素像素位置 loc
            var loc = this.location;

            // 专题要素像素位置 loc
            this.origonPoint = [loc[0] - w / 2, loc[1] - h / 2];
            // 专题要素原点（左上角）
            var op = this.origonPoint;

            // 图表框（[left, bottom, right, top]）
            this.chartBox = [op[0], op[1] + h, op[0] + w, op[1]];
            // 图表框
            var cb = this.chartBox;

            // 数据视图框参数，它是图表框各方向对应的内偏距
            var dbbP = this.DVBParameter;
            // 数据视图框 （[left, bottom, right, top]）
            this.dataViewBox = [cb[0] + dbbP[0], cb[1] - dbbP[1], cb[2] - dbbP[2], cb[3] + dbbP[3]];
            // 数据视图框
            var dvb = this.dataViewBox;
            //检查数据视图框是否合法
            if (dvb[0] >= dvb[2] || dvb[1] <= dvb[3]) {
                return false;
            }

            // 数据视图框原点
            this.DVBOrigonPoint = [dvb[0], dvb[3]];
            // 数据视图框宽度
            this.DVBWidth = Math.abs(dvb[2] - dvb[0]);
            // 数据视图框高度
            this.DVBHeight = Math.abs(dvb[1] - dvb[3]);
            // 数据视图框中心点
            this.DVBCenterPoint = [this.DVBOrigonPoint[0] + this.DVBWidth / 2, this.DVBOrigonPoint[1] + this.DVBHeight / 2];

            // 数据视图框原点与图表框的原点偏移量
            this.origonPointOffset = [this.DVBOrigonPoint[0] - op[0], this.DVBOrigonPoint[1] - op[1]];

            return isSuccess;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.resetLocation
         * @description 根据地理位置 lonlat 重置专题要素（图表）位置。
         * @param {SuperMap.LonLat} lonlat - 专题要素新的像素中心位置。
         * @returns {Array.<number>} - 新专题要素像素参考位置。长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */

    }, {
        key: 'resetLocation',
        value: function resetLocation(lonlat) {
            if (lonlat) {
                this.lonlat = lonlat;
            }

            // 获取地理位置对应的像素坐标 newLocalLX
            var newLocalLX = this.getLocalXY(this.lonlat);
            // 处理偏移量 XOffset, YOffset
            newLocalLX[0] += this.XOffset;
            newLocalLX[1] += this.YOffset;
            // 将图形位置赋予  location 属性（注意 location 属性表示的是专题要素中心位置）
            this.location = newLocalLX;

            // 更新图表像素 Bounds
            var w = this.width;
            var h = this.height;
            var loc = this.location;
            this.chartBounds = new _Bounds.Bounds(loc[0] - w / 2, loc[1] + h / 2, loc[0] + w / 2, loc[1] - h / 2);

            //重新计算当前渐变色
            this.resetLinearGradient();

            return loc;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.resetLinearGradient
         * @description resetLocation 中调用 图表的相对坐标存在的时候，重新计算渐变的颜色（目前用于二维柱状图渐变色 所以子类实现此方法）。
         */

    }, {
        key: 'resetLinearGradient',
        value: function resetLinearGradient() {}
        //子类实现此方法


        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.shapesConvertToRelativeCoordinate
         * @description 将（构成图表）图形的节点转为相对坐标表示，此函数必须且只能在 assembleShapes() 结束时调用。
         */

    }, {
        key: 'shapesConvertToRelativeCoordinate',
        value: function shapesConvertToRelativeCoordinate() {
            var shapes = this.shapes;
            var shapeROP = this.location;
            for (var i = 0, len = shapes.length; i < len; i++) {
                shapes[i].refOriginalPosition = shapeROP;

                var style = shapes[i].style;

                for (var sty in style) {
                    switch (sty) {
                        case "pointList":
                            var pl = style[sty];
                            for (var j = 0, len2 = pl.length; j < len2; j++) {
                                pl[j][0] -= shapeROP[0];
                                pl[j][1] -= shapeROP[1];
                            }
                            break;
                        case "x":
                            style[sty] -= shapeROP[0];
                            break;
                        case "y":
                            style[sty] -= shapeROP[1];
                            break;
                        default:
                            break;
                    }
                }
            }
            this.RelativeCoordinate = true;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.assembleShapes
         * @description 图形装配函数。抽象方法，可视化子类必须实现此方法。<br>
         *              重写此方法的步骤：<br>
         *              1. 图表的某些特殊配置项（setting）处理，例如多数图表模型需要重新指定 dataViewBoxParameter 的默认值。<br>
         *              2. 调用 initBaseParameter() 方法初始化模型属性值，此步骤必须执行，只有当 initBaseParameter 返回 true 时才可以允许进行后续步骤。<br>
         *              3. 计算图形参数，制作图形，图形组合。在组装图表过程中，应该特别注意数据视图框单位值的定义、数据值溢出值域范围的处理和图形大小自适应。<br>
         *              4. 调用 shapesConvertToRelativeCoordinate() 方法，将图形的坐标值转为相对坐标，此步骤必须执行。
         * @example
         *  //子类实现 assembleShapes() 接口的步骤示例：
         *  assembleShapes: function(){
         *    // 第一步：图表的某些特殊配置项（setting）处理，例如多数图表模型需要重新指定 dataViewBoxParameter 的默认值。此步骤是非必须过程。
         *
         *    // 图表配置对象
         *    var sets = this.setting;
         *    // 默认数据视图框，这里展示在使用坐标轴和不使用坐标轴情况下对数据视图框参数赋予不同的默认值
         *    if(!sets.dataViewBoxParameter){
         *          if(typeof(sets.useAxis) === "undefined" || sets.useAxis){
         *              sets.dataViewBoxParameter = [45, 15, 15, 15];
         *          }
         *          else{
         *                  sets.dataViewBoxParameter = [5, 5, 5, 5];
         *          }
         *    }
         *
         *    // 第二步：初始化图表模型基本参数，只有在图表模型基本参数初始化成功时才可模型相关属性，如 this.dataViewBox、 this.DVBCodomain等。此步骤是必须过程。
         *    if(!this.initBaseParameter()) return;
         *
         *    // 第三步：用图形组装图表，在组装图表过程中，应该特别注意数据视图框单位值的定义、数据值溢出值域范围的处理和图形大小自适应。
         *    // 定义图表数据视图框中单位值的含义，下面行代码表示将数据视图框单位值定义为数据视图框高度上每像素代表的数据值
         *    this.DVBUnitValue =  (this.codomain[1] - this.codomain[0])/this.DVBHeight;
         *    var uv = this.DVBUnitValue;
         *
         *    // 图形参数计算代码......
         *
         *    // 关于图形装配，实际上就是利用图形工程对象 this.shapeFactory 的 createShape() 方法通过图形参数对象创建可视化的图形对象，并把这些图形对象按序添加到模型的图形库（his.shapes）中。下面的代码演示创建一个面图形参数对象，并允许通过图形配置对象设置图形的 style 和 highlightStyle，
         *    var barParams = new SuperMap.Feature.ShapeParameters.Polygon(poiLists);
         *    barParams.style = sets.barStyle? sets.barStyle:{fillColor: "lightblue"};
         *    barParams.highlightStyle = sets.barHoverStyle? sets.barHoverStyle:{fillColor: "blue"};
         *    // 图形携带数据ID信息
         *    barParams.refDataID = this.data.id;
         *    // 创建图形并添加到图表图形数组中
         *    this.shapes.push(this.shapeFactory.createShape(barParams));
         *
         *    // 第四步：调用 shapesConvertToRelativeCoordinate() 方法，将图形库（his.shapes）中的图形转为由相对坐标表示的图形，客户端统计专题图模块从结构上要求可视化图形使用相对坐标，assembleShapes() 函数必须在图形装配完成后调用 shapesConvertToRelativeCoordinate() 函数。此步骤是必须过程。
         *    this.shapesConvertToRelativeCoordinate();
         * },
         */

    }, {
        key: 'assembleShapes',
        value: function assembleShapes() {}
        //子类必须实现此方法


        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.getLocalXY
         * @description 地理坐标转为像素坐标。
         * @param {SuperMap.Lonlat} lonlat - 带转换的地理坐标。
         * @returns 屏幕像素坐标。
         */

    }, {
        key: 'getLocalXY',
        value: function getLocalXY(lonlat) {
            return this.layer.getLocalXY(lonlat);
        }
    }]);

    return Graph;
}(_Theme2.Theme);

/**
 * @function SuperMap.Feature.Theme.getDataValues
 * @description 根据字段名数组获取指定数据（feature）的属性值数组。属性值类型必须为 Number。
 * @param {SuperMap.Feature.Vector} data - 数据。
 * @param {Array.<string>} [fields] - 字段名数组。
 * @param {number} [decimalNumber] - 小数位处理参数，对获取到的属性数据值进行小数位处理。
 * @returns {Array.<string>} 字段名数组对应的属性数据值数组。
 */


_Theme2.Theme.getDataValues = function (data, fields, decimalNumber) {
    if (!data.attributes) {
        return false;
    }

    var fieldsValue = [];

    var attrs = data.attributes;
    for (var i = 0; i < fields.length; i++) {
        for (var field in attrs) {
            if (field !== fields[i]) {
                continue;
            }
            // 数字转换判断
            try {
                if (!isNaN(decimalNumber) && decimalNumber >= 0) {
                    fieldsValue.push(parseFloat(attrs[field].toString()).toFixed(decimalNumber));
                } else {
                    fieldsValue.push(parseFloat(attrs[field].toString()));
                }
            } catch (e) {
                throw new Error("not a number");
            }
        }
    }

    if (fieldsValue.length === fields.length) {
        return fieldsValue;
    } else {
        return false;
    }
};

_SuperMap.SuperMap.Feature.Theme.Graph = Graph;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
/**
 * @private
 * @class  SuperMap.LevelRenderer.Tool.Util
 * @category Visualization Theme
 * LevelRenderer 基础工具类
 *
 */
var Util = exports.Util = function () {

    /**
     * @function SuperMap.LevelRenderer.Tool.Util.constructor
     * @description 构造函数。
     *
     */
    function Util() {
        _classCallCheck(this, Util);

        /**
         * @member {Object} SuperMap.LevelRenderer.Tool.Util.prototype.BUILTIN_OBJECT
         * @description 用于处理merge时无法遍历Date等对象的问题
         */
        this.BUILTIN_OBJECT = {
            '[object Function]': 1,
            '[object RegExp]': 1,
            '[object Date]': 1,
            '[object Error]': 1,
            '[object CanvasGradient]': 1
        };

        /**
         * @member {Object} SuperMap.LevelRenderer.Tool.Util.prototype._ctx
         */
        this._ctx = null;

        /**
         * Property: _canvas
         * {Object}
         */
        this._canvas = null;

        /**
         * Property: _pixelCtx
         * {Object}
         */
        this._pixelCtx = null;

        /**
         * Property: _width
         * {Object}
         */
        this._width = null;

        /**
         * Property: _height
         * {Object}
         */
        this._height = null;

        /**
         * Property: _offsetX
         * {Object}
         */
        this._offsetX = 0;

        /**
         * Property: _offsetY
         * {Object}
         */
        this._offsetY = 0;

        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Util";
    }

    /**
     * @function SuperMap.LevelRenderer.Tool.Util.prototype.clone
     * @description 对一个object进行深度拷贝。
     * 
     * @param {Object} source - 需要进行拷贝的对象。
     * @return {Object} 拷贝后的新对象。
     */


    _createClass(Util, [{
        key: 'clone',
        value: function clone(source) {
            var BUILTIN_OBJECT = this.BUILTIN_OBJECT;
            if ((typeof source === 'undefined' ? 'undefined' : _typeof(source)) == 'object' && source !== null) {
                var result = source;
                if (source instanceof Array) {
                    result = [];
                    for (var i = 0, len = source.length; i < len; i++) {
                        result[i] = this.clone(source[i]);
                    }
                } else if (!BUILTIN_OBJECT[Object.prototype.toString.call(source)]) {
                    result = {};
                    for (var key in source) {
                        if (source.hasOwnProperty(key)) {
                            result[key] = this.clone(source[key]);
                        }
                    }
                }

                return result;
            }

            return source;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.mergeItem
         * @description 合并源对象的单个属性到目标对象。
         *
         * @param {Object} target - 目标对象。
         * @param {Object} source - 源对象。
         * @param {string} key - 键。
         * @param {boolean} overwrite - 是否覆盖。
         * @return {Object} 目标对象
         */

    }, {
        key: 'mergeItem',
        value: function mergeItem(target, source, key, overwrite) {
            var BUILTIN_OBJECT = this.BUILTIN_OBJECT;
            if (source.hasOwnProperty(key)) {
                if (_typeof(target[key]) == 'object' && !BUILTIN_OBJECT[Object.prototype.toString.call(target[key])]) {
                    // 如果需要递归覆盖，就递归调用merge
                    this.merge(target[key], source[key], overwrite);
                } else if (overwrite || !(key in target)) {
                    // 否则只处理overwrite为true，或者在目标对象中没有此属性的情况
                    target[key] = source[key];
                }
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.merge
         * @description 合并源对象的属性到目标对象。
         * 
         * @param {Object} target - 目标对象。
         * @param {Object} source - 源对象。
         * @param {boolean} overwrite - 是否覆盖。
         * @return {Object} 目标对象。
         */

    }, {
        key: 'merge',
        value: function merge(target, source, overwrite) {
            for (var i in source) {
                this.mergeItem(target, source, i, overwrite);
            }

            return target;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.getContext
         * @description 获取 Canvas 上下文。
         * @return {Object} 上下文。
         */

    }, {
        key: 'getContext',
        value: function getContext() {
            if (!this._ctx) {
                this._ctx = document.createElement('canvas').getContext('2d');
            }
            return this._ctx;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.getPixelContext
         * @description 获取像素拾取专用的上下文。
         * @return {Object} 像素拾取专用的上下文。
         */

    }, {
        key: 'getPixelContext',
        value: function getPixelContext() {
            if (!this._pixelCtx) {
                this._canvas = document.createElement('canvas');
                this._width = this._canvas.width;
                this._height = this._canvas.height;
                this._pixelCtx = this._canvas.getContext('2d');
            }
            return this._pixelCtx;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.adjustCanvasSize
         * @description 如果坐标处在_canvas外部，改变_canvas的大小，修改canvas的大小 需要重新设置translate
         *
         * @param {number} x - 横坐标。
         * @param {number} y - 纵坐标。
         *
         */

    }, {
        key: 'adjustCanvasSize',
        value: function adjustCanvasSize(x, y) {
            var _canvas = this._canvas;
            var _pixelCtx = this._pixelCtx;
            var _width = this._width;
            var _height = this._height;
            var _offsetX = this._offsetX;
            var _offsetY = this._offsetY;

            // 每次加的长度
            var _v = 100;
            var _flag;

            if (x + _offsetX > _width) {
                _width = x + _offsetX + _v;
                _canvas.width = _width;
                _flag = true;
            }

            if (y + _offsetY > _height) {
                _height = y + _offsetY + _v;
                _canvas.height = _height;
                _flag = true;
            }

            if (x < -_offsetX) {
                _offsetX = Math.ceil(-x / _v) * _v;
                _width += _offsetX;
                _canvas.width = _width;
                _flag = true;
            }

            if (y < -_offsetY) {
                _offsetY = Math.ceil(-y / _v) * _v;
                _height += _offsetY;
                _canvas.height = _height;
                _flag = true;
            }

            if (_flag) {
                _pixelCtx.translate(_offsetX, _offsetY);
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.getPixelOffset
         * @description 获取像素canvas的偏移量。
         * @return {Object} 偏移量。
         */

    }, {
        key: 'getPixelOffset',
        value: function getPixelOffset() {
            return {
                x: this._offsetX,
                y: this._offsetY
            };
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.indexOf
         * @description 查询数组中元素的index
         * @return {Object} 偏移量。
         */

    }, {
        key: 'indexOf',
        value: function indexOf(array, value) {
            if (array.indexOf) {
                return array.indexOf(value);
            }
            for (var i = 0, len = array.length; i < len; i++) {
                if (array[i] === value) {
                    return i;
                }
            }
            return -1;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Util.prototype.inherits
         * @description 构造类继承关系
         * 
         * @param {Function} clazz - 源类。
         * @param {Function} baseClazz - 基类。
         * @return {Object} 偏移量。
         */

    }, {
        key: 'inherits',
        value: function inherits(clazz, baseClazz) {
            var clazzPrototype = clazz.prototype;

            function F() {}

            F.prototype = baseClazz.prototype;
            clazz.prototype = new F();

            for (var prop in clazzPrototype) {
                clazz.prototype[prop] = clazzPrototype[prop];
            }
            clazz.constructor = clazz;
        }
    }]);

    return Util;
}();

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Collection = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Bounds = __webpack_require__(28);

var _Geometry2 = __webpack_require__(27);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.Collection
 * @classdesc 几何对象集合类，存储在本地的 components 属性中（可作为参数传递给构造函数）。<br>
 *            随着新的几何图形添加到集合中，将不能被克隆，当移动几何图形时，需要指定参照物。<br>
 *            getArea 和 getLength 函数只能通过遍历存储几何对象的 components 数组，总计所有几何图形的面积和长度。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry}
 * @param {Array.<SuperMap.Geometry>} components - 几何对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(10,20);
 * var point2 = new SuperMap.Geometry.Point(30,40);
 * var col = new SuperMap.Geometry.Collection([point1,point2]);
 */
var Collection = exports.Collection = function (_Geometry) {
    _inherits(Collection, _Geometry);

    function Collection(components) {
        _classCallCheck(this, Collection);

        /**
         * @description 存储几何对象的数组。
         * @member {Array.<SuperMap.Geometry>} SuperMap.Geometry.Collection.prototype.components
         */
        var _this = _possibleConstructorReturn(this, (Collection.__proto__ || Object.getPrototypeOf(Collection)).call(this));

        _this.components = [];

        /**
         * @member {Array.<string>} SuperMap.Geometry.Collection.prototype.componentTypes
         * @description components 存储的的几何对象所支持的几何类型数组，为空表示类型不受限制。
         */
        _this.componentTypes = null;
        if (components != null) {
            _this.addComponents(components);
        }
        _this.CLASS_NAME = "SuperMap.Geometry.Collection";
        _this.geometryType = "Collection";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Collection.prototype.destroy
     * @description 销毁几何图形。
     */


    _createClass(Collection, [{
        key: 'destroy',
        value: function destroy() {
            this.components.length = 0;
            this.components = null;
            _get(Collection.prototype.__proto__ || Object.getPrototypeOf(Collection.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.clone
         * @description 克隆当前几何对象。
         * @returns {SuperMap.Geometry.Collection} 克隆的几何对象集合。
         */

    }, {
        key: 'clone',
        value: function clone() {
            var geometry = new Collection();
            for (var i = 0, len = this.components.length; i < len; i++) {
                geometry.addComponent(this.components[i].clone());
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(geometry, this);

            return geometry;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getComponentsString
         * @description 获取 components 字符串。
         * @returns {string} components 字符串。
         */

    }, {
        key: 'getComponentsString',
        value: function getComponentsString() {
            var strings = [];
            for (var i = 0, len = this.components.length; i < len; i++) {
                strings.push(this.components[i].toShortString());
            }
            return strings.join(",");
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.calculateBounds
         * @description 通过遍历数组重新计算边界，在遍历每一子项中时调用 extend 方法。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = null;
            var bounds = new _Bounds.Bounds();
            var components = this.components;
            if (components) {
                for (var i = 0, len = components.length; i < len; i++) {
                    bounds.extend(components[i].getBounds());
                }
            }
            // to preserve old behavior, we only set bounds if non-null
            // in the future, we could add bounds.isEmpty()
            if (bounds.left != null && bounds.bottom != null && bounds.right != null && bounds.top != null) {
                this.setBounds(bounds);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponents
         * @description 给几何图形对象添加元素。
         * @param {Array.<SuperMap.Geometry>} components - 几何对象组件。
         * @example
         * var collection = new SuperMap.Geometry.Collection();
         * collection.addComponents(new SuerpMap.Geometry.Point(10,10));
         */

    }, {
        key: 'addComponents',
        value: function addComponents(components) {
            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = 0, len = components.length; i < len; i++) {
                this.addComponent(components[i]);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponent
         * @description 添加一个几何对象到集合中。如果设置了 componentTypes 类型，则添加的几何对象必须是 componentTypes 中的类型。
         * @param {SuperMap.Geometry} component - 待添加的几何对象。
         * @param {int} [index] - 几何对象插入的位置。
         * @returns {boolean} 是否添加成功。
         */

    }, {
        key: 'addComponent',
        value: function addComponent(component, index) {
            var added = false;
            if (component) {
                if (this.componentTypes == null || _Util.Util.indexOf(this.componentTypes, component.CLASS_NAME) > -1) {

                    if (index != null && index < this.components.length) {
                        var components1 = this.components.slice(0, index);
                        var components2 = this.components.slice(index, this.components.length);
                        components1.push(component);
                        this.components = components1.concat(components2);
                    } else {
                        this.components.push(component);
                    }
                    component.parent = this;
                    this.clearBounds();
                    added = true;
                }
            }
            return added;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponents
         * @description 清除几何对象。
         * @param {Array.<SuperMap.Geometry>} components - 需要清除的几何对象。
         * @returns {boolean} 元素是否被删除。
         */

    }, {
        key: 'removeComponents',
        value: function removeComponents(components) {
            var removed = false;

            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = components.length - 1; i >= 0; --i) {
                removed = this.removeComponent(components[i]) || removed;
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponent
         * @description 从集合中移除一个几何对象。
         * @param {SuperMap.Geometry} component - 要移除的几何对象。
         * @returns {boolean} 几何对象是否移除成功。
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(component) {
            _Util.Util.removeItem(this.components, component);

            // clearBounds() so that it gets recalculated on the next call
            // to this.getBounds();
            this.clearBounds();
            return true;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getArea
         * @description 计算几何对象的面积。注意，这个方法在 {@link SuperMap.Geometry.Polygon} 类中需要重写。
         * @returns {number} 几何图形的面积，是几何对象中所有组成部分的面积之和。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            for (var i = 0, len = this.components.length; i < len; i++) {
                area += this.components[i].getArea();
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.equals
         * @description 判断两个几何图形是否相等。如果所有的 components 具有相同的坐标，则认为是相等的。
         * @param {SuperMap.Geometry} geometry - 需要判断的几何图形。
         * @returns {boolean} 输入的几何图形与当前几何图形是否相等。
         */

    }, {
        key: 'equals',
        value: function equals(geometry) {
            var equivalent = true;
            if (!geometry || !geometry.CLASS_NAME || this.CLASS_NAME !== geometry.CLASS_NAME) {
                equivalent = false;
            } else if (!_Util.Util.isArray(geometry.components) || geometry.components.length !== this.components.length) {
                equivalent = false;
            } else {
                for (var i = 0, len = this.components.length; i < len; ++i) {
                    if (!this.components[i].equals(geometry.components[i])) {
                        equivalent = false;
                        break;
                    }
                }
            }
            return equivalent;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getVertices
         * @description 返回几何对象的所有结点的列表。
         * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false，则返回非端点的顶点如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices = [];
            for (var i = 0, len = this.components.length; i < len; ++i) {
                Array.prototype.push.apply(vertices, this.components[i].getVertices(nodes));
            }
            return vertices;
        }
    }]);

    return Collection;
}(_Geometry2.Geometry);

_SuperMap.SuperMap.Geometry.Collection = Collection;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TemplateBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at/r* http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Widgets.TemplateBase
 * @classdesc 微件公用组件父类，用于约束统一封装的公用组件结构。
 * @version 9.1.1
 * @param {Object} options - 组件配置参数。
 * @param {string} options.id - 组件 dom 元素 id。
 * @category Widgets Common
 */
var TemplateBase = exports.TemplateBase = function () {
    function TemplateBase(options) {
        _classCallCheck(this, TemplateBase);

        options = options ? options : {};
        /**
         * @member {string} [SuperMap.Widgets.TemplateBase.prototype.id=null]
         * @description  组件 dom 元素 id。
         */
        this.id = options.id ? options.id : null;

        /**
         * @member {Element} [SuperMap.Widgets.TemplateBase.prototype.rootContainer=null]
         * @description  组件 dom 元素对象。
         */
        this.rootContainer = null;
    }

    /**
     * @function SuperMap.Widgets.TemplateBase.prototype.getElement
     * @description 获取当前组件元素对象。
     * @return {Element}
     */


    _createClass(TemplateBase, [{
        key: 'getElement',
        value: function getElement() {
            //todo 其实感觉再这里给组件设置不太合理
            if (this.id) {
                this.rootContainer.id = this.id;
            }

            return this.rootContainer;
        }

        /**
         * @function SuperMap.Widgets.TemplateBase.prototype._initView
         * @private
         * @description 初始化模板。
         */

    }, {
        key: '_initView',
        value: function _initView() {}
        //子类实现此方法


        /**
         * @function SuperMap.Widgets.TemplateBase.prototype.showView
         * @description 显示组件。
         */

    }, {
        key: 'showView',
        value: function showView() {
            this.rootContainer.hidden = false;
        }

        /**
         * @function SuperMap.Widgets.TemplateBase.prototype.closeView
         * @description 隐藏组件。
         */

    }, {
        key: 'closeView',
        value: function closeView() {
            this.rootContainer.hidden = true;
        }
    }]);

    return TemplateBase;
}();

_SuperMap.SuperMap.Widgets.TemplateBase = TemplateBase;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterpolationAnalystParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

__webpack_require__(237);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.InterpolationAnalystParameters
 * @category iServer SpatialAnalyst InterpolationAnalyst
 * @classdesc 插值分析参数类。
 * @param {Object} options - 参数。
 * @param {(SuperMap.Bounds|L.Bounds|ol.extent)} options.bounds - 插值分析的范围，用于确定结果栅格数据集的范围。 
 * @param {string} options.outputDatasetName - 插值分析结果数据集的名称。 
 * @param {string} options.outputDatasourceName - 插值分析结果数据源的名称。 
 * @param {string} [options.zValueFieldName] - 存储用于进行插值分析的字段名称，插值分析不支持文本类型的字段。
 * @param {string} [options.dataset] - 用于做插值分析的数据源中数据集的名称。当插值分析类型（InterpolationAnalystType）为 dataset 时，此参数为必选。 
 * @param {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point>} [options.inputPoints] - 用于做插值分析的离散点集合。当插值分析类型（InterpolationAnalystType）为 geometry 时，此参数为必设参数。 
 * @param {number} [options.searchRadius=0] - 查找半径，即参与运算点的查找范围，与点数据集单位相同。 
 * @param {number} [options.zValueScale=1] - 用于进行插值分析值的缩放比率。 
 * @param {number} [options.resolution] - 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。 
 * @param {SuperMap.FilterParameter} [options.filterQueryParameter] - 属性过滤条件。 
 * @param {SuperMap.PixelFormat} [options.pixelFormat] - 指定结果栅格数据集存储的像素格式。 
 * @param {string} [options.InterpolationAnalystType="dataset"] - 插值分析类型（"dataset" 或 "geometry"）。 
 */
var InterpolationAnalystParameters = exports.InterpolationAnalystParameters = function () {
  function InterpolationAnalystParameters(options) {
    _classCallCheck(this, InterpolationAnalystParameters);

    if (!options) {
      return;
    }
    /**
     * @member {(SuperMap.Bounds|L.Bounds|ol.extent)} SuperMap.InterpolationAnalystParameters.prototype.bounds
     * @description 插值分析的范围，用于确定结果栅格数据集的范围。
     * 如果缺省，则默认为原数据集的范围。鉴于此插值方法为内插方法，原数据集的范围内的插值结果才相对有参考价值，
     * 因此建议此参数不大于原数据集范围。
     */
    this.bounds = null;

    /**
     * @member {number} [SuperMap.InterpolationAnalystParameters.prototype.searchRadius=0]
     * @description 查找半径，即参与运算点的查找范围，与点数据集单位相同。
     * 计算某个位置的Z 值时，会以该位置为圆心，以查找范围的值为半径，落在这个范围内的采样点都将参与运算。
     * 该值需要根据待插值点数据的分布状况和点数据集范围进行设置。
     */
    this.searchRadius = 0;

    /**
     * @member {string} SuperMap.InterpolationAnalystParameters.prototype.zValueFieldName
     * @description 数据集插值分析中，用于指定进行插值分析的目标字段名，插值分析不支持文本类型的字段。
     * 含义为每个插值点在插值过程中的权重，可以将所有点此字段值设置为 1，即所有点在整体插值中权重相同。
     * 当插值分析类型（InterpolationAnalystType）为 dataset 时，此为必选参数。
     */
    this.zValueFieldName = null;

    /**
     * @member {number} [SuperMap.InterpolationAnalystParameters.prototype.zValueScale=1]
     * @description 用于进行插值分析值的缩放比率。
     * 参加插值分析的值将乘以该参数值后再进行插值，也就是对进行插值分析的值进行统一的扩大或缩小。
     */
    this.zValueScale = 1;

    /**
     * @member {number} SuperMap.InterpolationAnalystParameters.prototype.resolution
     * @description 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。
     * 该值不能超过待分析数据集的范围边长。
     * 且该值设置时，应该考虑点数据集范围大小来取值，一般为结果栅格行列值（即结果栅格数据集范围除以分辨率），在 500 以内可以较好地体现密度走势。
     */
    this.resolution = null;

    /**
     * @member {SuperMap.FilterParameter} [SuperMap.InterpolationAnalystParameters.prototype.filterQueryParameter]
     * @description 过滤条件，对分析数据集中的点进行过滤，设置为 null 表示对数据集中的所有点进行分析。
     */
    this.filterQueryParameter = null;

    /**
     * @member {string} SuperMap.InterpolationAnalystParameters.prototype.outputDatasetName
     * @description 插值分析结果数据集的名称。 
     */
    this.outputDatasetName = null;

    /**
     * @member {string} SuperMap.InterpolationAnalystParameters.prototype.outputDatasourceName
     * @description 插值分析结果数据源的名称。 
     */
    this.outputDatasourceName = null;

    /**
     * @member {SuperMap.PixelFormat} [SuperMap.InterpolationAnalystParameters.prototype.pixelFormat]
     * @description 指定结果栅格数据集存储的像素格式。支持存储的像素格式有 BIT16、BIT32、DOUBLE、SINGLE、UBIT1、UBIT4、UBIT8、UBIT24、UBIT32。
     */
    this.pixelFormat = null;

    /**
     * @member {string} [SuperMap.InterpolationAnalystParameters.prototype.dataset]
     * @description 用来做插值分析的数据源中数据集的名称，该名称用形如 "数据集名称@数据源别名" 形式来表示。
     * 当插值分析类型（InterpolationAnalystType）为 dataset 时，此参数为必选。
     */
    this.dataset = null;

    /**
     * @member {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point>} [SuperMap.InterpolationAnalystParameters.prototype.inputPoints]
     * @description 用于做插值分析的离散点（离散点包括Z值）集合。
     * 当插值分析类型（InterpolationAnalystType）为 geometry 时，此参数为必设参数。
     * 通过离散点直接进行插值分析不需要指定输入数据集inputDatasourceName，inputDatasetName以及zValueFieldName。
     */
    this.inputPoints = null;

    /**
     * @member {string} [SuperMap.InterpolationAnalystParameters.prototype.InterpolationAnalystType="dataset"]
     * @description  插值分析类型。差值分析包括数据集插值分析和几何插值分析两类，
     *               "dataset" 表示对数据集进行插值分析，"geometry" 表示对离散点数组进行插值分析。
     */
    this.InterpolationAnalystType = "dataset";

    /**
     * @member {Object} SuperMap.InterpolationAnalystParameters.prototype.clipParam
     * @description 对插值分析结果进行裁剪的参数。
     */
    this.clipParam = null;

    _Util.Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.InterpolationAnalystParameters";
  }

  /**
   * @function SuperMap.InterpolationAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(InterpolationAnalystParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.bounds = null;
      me.searchRadius = null;
      me.zValueFieldName = null;
      me.zValueScale = null;

      me.resolution = null;
      me.filterQueryParameter = null;
      me.outputDatasetName = null;
      me.pixelFormat = null;
    }

    /**
     * @function SuperMap.InterpolationAnalystParameters.toObject
     * @param {SuperMap.InterpolationAnalystParameters} interpolationAnalystParameters - 插值分析参数类。
     * @param {SuperMap.InterpolationAnalystParameters} tempObj - 插值分析参数对象。
     * @description 将插值分析参数对象转换成 JSON 对象。
     * @returns JSON 对象。
     */

  }], [{
    key: 'toObject',
    value: function toObject(interpolationAnalystParameters, tempObj) {
      for (var name in interpolationAnalystParameters) {
        if (name === "inputPoints" && interpolationAnalystParameters.InterpolationAnalystType === "geometry") {
          var objs = [];
          for (var i = 0; i < interpolationAnalystParameters.inputPoints.length; i++) {
            var item = interpolationAnalystParameters.inputPoints[i];
            var obj = {
              x: item.x,
              y: item.y,
              z: item.tag
            };
            objs.push(obj);
          }
          tempObj[name] = objs;
        } else {
          tempObj[name] = interpolationAnalystParameters[name];
        }
      }
    }
  }]);

  return InterpolationAnalystParameters;
}();

_SuperMap.SuperMap.InterpolationAnalystParameters = InterpolationAnalystParameters;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerTextStyle = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

var _ServerColor = __webpack_require__(21);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerTextStyle
 * @category  iServer Map Theme
 * @classdesc 服务端文本风格类。
 * @description 该类用于定义文本风格的相关属性。
 * @param {Object} options - 参数。
 * @param {SuperMap.TextAlignment} [options.align=SuperMap.TextAlignment.BASELINECENTER] - 文本的对齐方式。
 * @param {SuperMap.ServerColor} [options.backColor] - 文本的背景色。默认 backColor = new ServerColor(255, 255, 255)。
 * @param {SuperMap.ServerColor} [options.foreColor] - 文本的前景色。默认 foreColor = new ServerColor(0, 0, 0)。
 * @param {boolean} [options.backOpaque=false] - 文本背景是否不透明。
 * @param {boolean} [options.sizeFixed=true] - 文本大小是否固定。
 * @param {number} [options.fontHeight=6] - 文本字体的高度。
 * @param {number} [options.fontWidth=0] - 文本字体的宽度。
 * @param {number} [options.fontWeight=400] - 文本字体的磅数。
 * @param {string} [options.fontName='Times New Roman'] - 文本字体的名称。
 * @param {boolean} [options.bold=false] - 文本是否为粗体字。
 * @param {boolean} [options.italic=false] - 文本是否采用斜体。
 * @param {number} [options.italicAngle=0] - 字体倾斜角度。
 * @param {boolean} [options.shadow=false] - 文本是否有阴影。
 * @param {boolean} [options.strikeout=false] - 文本字体是否加删除线。
 * @param {boolean} [options.outline=false] - 是否以轮廓的方式来显示文本的背景。
 * @param {number} [options.opaqueRate=0] - 注记文字的不透明度。
 * @param {boolean} [options.underline=false] - 文本字体是否加下划线。
 * @param {number} [options.rotation=0.0] -  文本旋转的角度。
 */
var ServerTextStyle = exports.ServerTextStyle = function () {
  function ServerTextStyle(options) {
    _classCallCheck(this, ServerTextStyle);

    /**
     * @member {SuperMap.TextAlignment} [SuperMap.ServerTextStyle.prototype.align= SuperMap.TextAlignment.BASELINECENTER]
     * @description 文本的对齐方式。
     */
    this.align = _REST.TextAlignment.BASELINECENTER;

    /**
     * @member {SuperMap.ServerColor} [SuperMap.ServerTextStyle.prototype.backColor=(255, 255, 255)]
     * @description 文本的背景色。
     */
    this.backColor = new _ServerColor.ServerColor(255, 255, 255);

    /**
     * @member {SuperMap.ServerColor} [SuperMap.ServerTextStyle.prototype.foreColor=(0, 0, 0)]
     * @description 文本的前景色。
     */
    this.foreColor = new _ServerColor.ServerColor(0, 0, 0);

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.backOpaque=false]
     * @description 文本背景是否不透明。true 表示文本背景不透明。
     */
    this.backOpaque = false;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.sizeFixed=true]
     * @description 文本大小是否固定。设置为 true，表示图片为固定像素大小，具体大小请参考 fontHeight。当设为 false 时，图片会随着地图缩放而缩放。
     */
    this.sizeFixed = true;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.fontHeight=6]
     * @description 文本字体的高度，单位与 sizeFixed 有关，当 sizeFixed 为 False 时，即非固定文本大小时使用地图坐标单位，
     *              如地理坐标系下的地图中单位为度；当 sizeFixed 为 True 时，单位为毫米（mm）。
     */
    this.fontHeight = 6;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.fontWidth=0]
     * @description 文本字体的宽度。字体的宽度以英文字符为标准，由于一个中文字符相当于两个英文字符。
     */
    this.fontWidth = 0;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.fontWeight=400]
     * @description 文本字体的磅数。表示粗体的具体数值。取值范围为从0－900之间的整百数。
     */
    this.fontWeight = 400;

    /**
     * @member {string} [SuperMap.ServerTextStyle.prototype.fontName="Times New Roman"]
     * @description 文本字体的名称。
     */
    this.fontName = "Times New Roman";

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.bold=false]
     * @description 文本是否为粗体字。true 表示为粗体。false 表示文本不是粗体字。
     */
    this.bold = false;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.italic=false]
     * @description 文本是否采用斜体。true 表示采用斜体。
     */
    this.italic = false;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.italicAngle=0]
     * @description 字体倾斜角度。正负度之间，以度为单位，精确到0.1度。当倾斜角度为0度，为系统默认的字体倾斜样式。
     *              正负度是指以纵轴为起始零度线，其纵轴左侧为正，右侧为负。允许的最大角度为60，最小-60。大于60按照60处理，小于-60按照-60处理。目前只对标签专题图有效。
     */
    this.italicAngle = 0;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.shadow=false]
     * @description 文本是否有阴影。true 表示给文本增加阴影。false 表示文本没有阴影。
     */
    this.shadow = false;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.strikeout=false]
     * @description 文本字体是否加删除线。true 表示加删除线。false 表示文本字体不加删除线。
     */
    this.strikeout = false;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.outline=false]
     * @description 是否以轮廓的方式来显示文本的背景。true 表示以轮廓的方式来显示文本的背景。false 表示不以轮廓的方式来显示文本的背景。
     */
    this.outline = false;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.opaqueRate=0]
     * @description 注记文字的不透明度。不透明度的范围为0-100。0表示透明。
     */
    this.opaqueRate = 0;

    /**
     * @member {boolean} [SuperMap.ServerTextStyle.prototype.underline=false]
     * @description 文本字体是否加下划线。true 表示加下划线。
     */
    this.underline = false;

    /**
     * @member {number} [SuperMap.ServerTextStyle.prototype.rotation=0.0]
     * @description 文本旋转的角度。逆时针方向为正方向，单位为度，精确到0.1度。
     */
    this.rotation = 0.0;

    if (options) {
      _Util.Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.ServerTextStyle";
  }

  /**
   * @function SuperMap.ServerTextStyle.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(ServerTextStyle, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.align = null;
      if (me.backColor) {
        me.backColor.destroy();
        me.backColor = null;
      }
      if (me.foreColor) {
        me.foreColor.destroy();
        me.foreColor = null;
      }
      me.backOpaque = null;
      me.sizeFixed = null;
      me.fontHeight = null;
      me.fontWidth = null;
      me.fontWeight = null;
      me.fontName = null;
      me.bold = null;
      me.italic = null;
      me.italicAngle = null;
      me.shadow = null;
      me.strikeout = null;
      me.outline = null;
      me.opaqueRate = null;
      me.underline = null;
      me.rotation = null;
    }

    /**
     * @function SuperMap.ServerTextStyle.fromObj
     * @description 从传入对象获服务端文本风格类。
     * @param {Object} obj - 传入对象
     * @returns {SuperMap.ServerTextStyle} 返回服务端文本风格对象
     */

  }], [{
    key: 'fromObj',
    value: function fromObj(obj) {
      var res = new ServerTextStyle(obj);
      _Util.Util.copy(res, obj);
      res.backColor = _ServerColor.ServerColor.fromJson(obj.backColor);
      res.foreColor = _ServerColor.ServerColor.fromJson(obj.foreColor);
      return res;
    }
  }]);

  return ServerTextStyle;
}();

_SuperMap.SuperMap.ServerTextStyle = ServerTextStyle;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransportationAnalystParameter = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _TransportationAnalystResultSetting = __webpack_require__(234);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.TransportationAnalystParameter
 * @category  iServer NetworkAnalyst
 * @classdesc 交通网络分析通用参数类。
 * @description 该类主要用来提供交通网络分析所需的通用参数。
 * 通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息，还可以对分析结果包含的内容进行一些设置。
 * @param {Object} options - 参数。
 * @param {Array.<number>} options.barrierEdgeIDs - 网络分析中障碍弧段的 ID 数组。
 * @param {Array.<number>} options.barrierNodeIDs - 网络分析中障碍点的 ID 数组。
 * @param {string} options.turnWeightField - 转向权重字段的名称。
 * @param {SuperMap.TransportationAnalystResultSetting} options.resultSetting - 分析结果返回内容。
 * @param {Array.<(SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point)>} [options.barrierPoints] - 网络分析中 Point2D 类型的障碍点数组。
 * @param {string} [options.weightFieldName] - 阻力字段的名称。
 */
var TransportationAnalystParameter = exports.TransportationAnalystParameter = function () {
  function TransportationAnalystParameter(options) {
    _classCallCheck(this, TransportationAnalystParameter);

    if (!options) {
      return;
    }
    /**
     * @member {Array.<number>} SuperMap.TransportationAnalystParameter.prototype.barrierEdgeIDs
     * @description 网络分析中障碍弧段的 ID 数组。弧段设置为障碍边之后，表示双向都不通。
     */
    this.barrierEdgeIDs = null;

    /**
     * @member {Array.<number>} SuperMap.TransportationAnalystParameter.prototype.barrierNodeIDs
     * @description 网络分析中障碍点的 ID 数组。结点设置为障碍点之后，表示任何方向都不能通过此结点。
     */
    this.barrierNodeIDs = null;

    /**
     * @member {Array.<(SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point)>}  SuperMap.TransportationAnalystParameter.prototype.barrierPoints
     * @description 网络分析中 Point2D 类型的障碍点数组。障碍点表示任何方向都不能通过此点。</br>
     * 当各网络分析参数类中的 isAnalyzeById 属性设置为 false 时，该属性才生效。
     */
    this.barrierPoints = null;

    /**
     * @member {string} [SuperMap.TransportationAnalystParameter.prototype.weightFieldName]
     * @description 阻力字段的名称，标识了进行网络分析时所使用的阻力字段，例如表示时间、长度等的字段都可以用作阻力字段。
     * 该字段默值为服务器发布的所有耗费字段的第一个字段。
     */
    this.weightFieldName = null;

    /**
     * @member {string} SuperMap.TransportationAnalystParameter.prototype.turnWeightField
     * @description 转向权重字段的名称。
     */
    this.turnWeightField = null;

    /**
     *  @member {SuperMap.TransportationAnalystResultSetting} SuperMap.TransportationAnalystParameter.prototype.resultSetting
     *  @description 分析结果返回内容。
     */
    this.resultSetting = new _TransportationAnalystResultSetting.TransportationAnalystResultSetting();

    _Util.Util.extend(this, options);

    this.CLASS_NAME = "SuperMap.TransportationAnalystParameter";
  }

  /**
   * @function SuperMap.TransportationAnalystParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(TransportationAnalystParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.barrierEdgeIDs = null;
      me.barrierNodeIDs = null;
      me.weightFieldName = null;
      me.turnWeightField = null;
      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }
      if (me.barrierPoints && me.barrierPoints.length) {
        for (var i in me.barrierPoints) {
          me.barrierPoints[i].destroy();
        }
      }
      me.barrierPoints = null;
    }
  }]);

  return TransportationAnalystParameter;
}();

_SuperMap.SuperMap.TransportationAnalystParameter = TransportationAnalystParameter;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

__webpack_require__(15);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.QueryParameters
 * @category  iServer Map QueryResults
 * @classdesc 查询参数基类。距离查询、SQL 查询、几何地物查询等各自的参数均继承此类。
 * @param {Object} options - 参数。
 * @param {Array.<SuperMap.FilterParameter>} options.queryParams - 查询过滤条件参数数组。
 * @param {string} [options.customParams] - 自定义参数，供扩展使用。
 * @param {Object} [options.prjCoordSys] - 自定义参数，供 SuperMap Online 提供的动态投影查询扩展使用。如 {"epsgCode":3857}。
 * @param {number} [options.expectCount=10000] - 期望返回结果记录个数。
 * @param {SuperMap.GeometryType} [options.networkType=SuperMap.GeometryType.LINE] - 网络数据集对应的查询类型。
 * @param {SuperMap.QueryOption} [options.queryOption=SuperMap.ATTRIBUTEANDGEOMETRY] - 查询结果类型枚举类。
 * @param {number} [options.startRecord=0] - 查询起始记录号。
 * @param {number} [options.holdTime=10] - 资源在服务端保存的时间,单位为分钟。
 * @param {boolean} [options.returnCustomResult=false] - 仅供三维使用。
 * @param {boolean} [options.returnFeatureWithFieldCaption = false] - 返回的查询结果要素字段标识是否为字段别名。为 false 时，返回的是字段名；为 true 时，返回的是字段别名。
 */
var QueryParameters = exports.QueryParameters = function () {
  function QueryParameters(options) {
    _classCallCheck(this, QueryParameters);

    if (!options) {
      return;
    }
    /**
     * @member {string} [SuperMap.QueryParameters.prototype.customParams]
     * @description 自定义参数，供扩展使用。
     */
    this.customParams = null;

    /**
     * @member {Object} [SuperMap.QueryParameters.prototype.prjCoordSys]
     * @description 自定义参数，供 SuperMap Online 提供的动态投影查询扩展使用。如 {"epsgCode":3857}
     */
    this.prjCoordSys = null;

    /**
     * @member {number} [SuperMap.QueryParameters.prototype.expectCount=100000]
     * @description 期望返回结果记录个数，默认返回100000条查询记录，
     *              如果实际不足100000条则返回实际记录条数。
     */
    this.expectCount = 100000;

    /**
     * @member {SuperMap.GeometryType} [SuperMap.QueryParameters.prototype.networkType=SuperMap.GeometryType.LINE]
     * @description 网络数据集对应的查询类型，分为点和线两种类型。
     */
    this.networkType = _REST.GeometryType.LINE;

    /**
     * @member {SuperMap.QueryOption} [SuperMap.QueryParameters.prototype.queryOption=SuperMap.QueryOption.ATTRIBUTEANDGEOMETRY]
     * @description 查询结果类型枚举类。
     *              该类描述查询结果返回类型，包括只返回属性、
     *              只返回几何实体以及返回属性和几何实体。
     */
    this.queryOption = _REST.QueryOption.ATTRIBUTEANDGEOMETRY;

    /**
     * @member {Array.<SuperMap.FilterParameter>} SuperMap.QueryParameters.prototype.queryParams
     * @description 查询过滤条件参数数组。
     *              该类用于设置查询数据集的查询过滤参数。
     */
    this.queryParams = null;

    /**
     * @member {number} [SuperMap.QueryParameters.prototype.startRecord=0]
     * @description 查询起始记录号。
     */
    this.startRecord = 0;

    /**
     * @member {number} [SuperMap.QueryParameters.prototype.holdTime=10]
     * @description 资源在服务端保存的时间，单位为分钟。
     */
    this.holdTime = 10;

    /**
     * @member {boolean} [SuperMap.QueryParameters.prototype.returnCustomResult=false]
     * @description 仅供三维使用。
     */
    this.returnCustomResult = false;
    /**
     * @member {boolean} [SuperMap.QueryParameters.prototype.returnFeatureWithFieldCaption=false]
     * @description 返回的查询结果要素字段标识是否为字段别名。为 false 时，返回的是字段名；为 true 时，返回的是字段别名。
     */
    this.returnFeatureWithFieldCaption = false;
    _Util.Util.extend(this, options);

    this.CLASS_NAME = "SuperMap.QueryParameters";
  }

  /**
   * @function SuperMap.QueryParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(QueryParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.customParams = null;
      me.expectCount = null;
      me.networkType = null;
      me.queryOption = null;
      if (me.queryParams) {
        for (var i = 0, qps = me.queryParams, len = qps.length; i < len; i++) {
          qps[i].destroy();
        }
        me.queryParams = null;
      }
      me.startRecord = null;
      me.holdTime = null;
      me.returnCustomResult = null;
      me.prjCoordSys = null;
    }
  }]);

  return QueryParameters;
}();

_SuperMap.SuperMap.QueryParameters = QueryParameters;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SecurityManager = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _FetchRequest = __webpack_require__(16);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @name SecurityManager
 * @memberOf SuperMap
 * @namespace
 * @category Security
 * @description 安全管理中心，提供 iServer,iPortal,Online 统一权限认证管理。
 *  > 使用说明：
 *  > 创建任何一个服务之前调用 {@link SuperMap.SecurityManager.registerToken}或
 *  > {@link SuperMap.SecurityManager.registerKey}注册凭据。
 *  > 发送请求时根据 url 或者服务 id 获取相应的 key 或者 token 并自动添加到服务地址中。
 */
var SecurityManager = exports.SecurityManager = function () {
    function SecurityManager() {
        _classCallCheck(this, SecurityManager);
    }

    _createClass(SecurityManager, null, [{
        key: 'generateToken',


        /**
         * @description 从服务器获取一个token,在此之前要注册服务器信息。
         * @function SuperMap.SecurityManager.generateToken
         * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
         * @param {SuperMap.TokenServiceParameter} tokenParam - token 申请参数。
         * @returns {Promise} 返回包含 token 信息的 Promise 对象。
         */

        value: function generateToken(url, tokenParam) {
            var serverInfo = this.servers[url];
            if (!serverInfo) {
                return;
            }
            return _FetchRequest.FetchRequest.post(serverInfo.tokenServiceUrl, JSON.stringify(tokenParam.toJSON())).then(function (response) {
                return response.text();
            });
        }

        /**
         * @description 注册安全服务器相关信息。
         * @function SuperMap.SecurityManager.registerServers
         * @param {SuperMap.ServerInfo} serverInfos - 服务器信息。
         */

    }, {
        key: 'registerServers',
        value: function registerServers(serverInfos) {
            this.servers = this.servers || {};
            if (!_Util.Util.isArray(serverInfos)) {
                serverInfos = [serverInfos];
            }
            for (var i = 0; i < serverInfos.length; i++) {
                var serverInfo = serverInfos[i];
                this.servers[serverInfo.server] = serverInfo;
            }
        }

        /**
         * @description 服务请求都会自动带上这个 token。
         * @function SuperMap.SecurityManager.registerToken
         * @param {string} url -服务器域名+端口：如http://localhost:8090。
         * @param {string} token - token
         */

    }, {
        key: 'registerToken',
        value: function registerToken(url, token) {
            this.tokens = this.tokens || {};
            if (!url || !token) {
                return;
            }
            var domain = this._getTokenStorageKey(url);
            this.tokens[domain] = token;
        }

        /**
         * @description 注册 key,ids 为数组(存在一个 key 对应多个服务)。
         * @function SuperMap.SecurityManager.registerKey
         * @param {Array} ids - 可以是服务 id 数组或者 url 地址数组或者 webAPI 类型数组。
         * @param {string} key - key
         */

    }, {
        key: 'registerKey',
        value: function registerKey(ids, key) {
            this.keys = this.keys || {};
            if (!ids || ids.length < 1 || !key) {
                return;
            }

            ids = _Util.Util.isArray(ids) ? ids : [ids];
            for (var i = 0; i < ids.length; i++) {
                var id = this._getUrlRestString(ids[0]) || ids[0];
                this.keys[id] = key;
            }
        }

        /**
         * @description 获取服务器信息。
         * @function SuperMap.SecurityManager.getServerInfo
         * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
         * @returns {SuperMap.ServerInfo} 服务器信息。
         */

    }, {
        key: 'getServerInfo',
        value: function getServerInfo(url) {
            this.servers = this.servers || {};
            return this.servers[url];
        }

        /**
         * @description 根据 Url 获取token。
         * @function SuperMap.SecurityManager.getToken
         * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
         * @returns {string} token
         */

    }, {
        key: 'getToken',
        value: function getToken(url) {
            if (!url) {
                return;
            }
            this.tokens = this.tokens || {};
            var domain = this._getTokenStorageKey(url);
            return this.tokens[domain];
        }

        /**
         * @description 根据 Url 获取 key。
         * @function SuperMap.SecurityManager.getKey
         * @param {string} id - id
         * @returns {string} key
         */

    }, {
        key: 'getKey',
        value: function getKey(id) {
            this.keys = this.keys || {};
            var key = this._getUrlRestString(id) || id;
            return this.keys[key];
        }

        /**
         * @description iServer 登录验证。
         * @function SuperMap.SecurityManager.loginiServer
         * @param {string} url - iServer 首页地址，如：http://localhost:8090/iserver。
         * @param {string} username - 用户名。
         * @param {string} password - 密码。
         * @param {boolean} [rememberme=false] - 是否记住。
         * @returns {Promise} 返回包含 iServer 登录请求结果的 Promise 对象。
         */

    }, {
        key: 'loginiServer',
        value: function loginiServer(url, username, password, rememberme) {
            var end = url.substr(url.length - 1, 1);
            url += end === "/" ? "services/security/login.json" : "/services/security/login.json";
            var loginInfo = {
                username: username && username.toString(),
                password: password && password.toString(),
                rememberme: rememberme
            };
            loginInfo = JSON.stringify(loginInfo);
            var requestOptions = {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                }
            };
            return _FetchRequest.FetchRequest.post(url, loginInfo, requestOptions).then(function (response) {
                return response.json();
            });
        }

        /**
         * @description iServer登出。
         * @function SuperMap.SecurityManager.logoutiServer
         * @param {string} url - iServer 首页地址,如：http://localhost:8090/iserver。
         * @returns {Promise} 是否登出成功。
         */

    }, {
        key: 'logoutiServer',
        value: function logoutiServer(url) {
            var end = url.substr(url.length - 1, 1);
            url += end === "/" ? "services/security/logout" : "/services/security/logout";

            var requestOptions = {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                },
                withoutFormatSuffix: true
            };
            return _FetchRequest.FetchRequest.get(url, "", requestOptions).then(function () {
                return true;
            }).catch(function () {
                return false;
            });
        }

        /**
         * @description Online 登录验证。
         * @function SuperMap.SecurityManager.loginOnline
         * @param {string} callbackLocation - 跳转位置。
         * @param {boolean} [newTab=true] - 是否新窗口打开。
         */

    }, {
        key: 'loginOnline',
        value: function loginOnline(callbackLocation, newTab) {
            var loginUrl = SecurityManager.SSO + "/login?service=" + callbackLocation;
            this._open(loginUrl, newTab);
        }

        /**
         * @description iPortal登录验证。
         * @function SuperMap.SecurityManager.loginiPortal
         * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
         * @param {string} username - 用户名。
         * @param {string} password - 密码。
         * @returns {Promise} 返回包含 iPortal 登录请求结果的 Promise 对象。
         */

    }, {
        key: 'loginiPortal',
        value: function loginiPortal(url, username, password) {
            var end = url.substr(url.length - 1, 1);
            url += end === "/" ? "web/login.json" : "/web/login.json";
            var loginInfo = {
                username: username && username.toString(),
                password: password && password.toString()
            };
            loginInfo = JSON.stringify(loginInfo);
            var requestOptions = {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                },
                withCredentials: true
            };
            return _FetchRequest.FetchRequest.post(url, loginInfo, requestOptions).then(function (response) {
                return response.json();
            });
        }

        /**
         * @description iPortal 登出。
         * @function SuperMap.SecurityManager.logoutiPortal
         * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
         * @returns {Promise} 如果登出成功，返回 true;否则返回 false。
         */

    }, {
        key: 'logoutiPortal',
        value: function logoutiPortal(url) {
            var end = url.substr(url.length - 1, 1);
            url += end === "/" ? "services/security/logout" : "/services/security/logout";

            var requestOptions = {
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                },
                withCredentials: true,
                withoutFormatSuffix: true
            };
            return _FetchRequest.FetchRequest.get(url, "", requestOptions).then(function () {
                return true;
            }).catch(function () {
                return false;
            });
        }

        /**
         * @description iManager 登录验证。
         * @function SuperMap.SecurityManager.loginManager
         * @param {string} url - iManager 地址。地址参数为 iManager 首页地址，如： http://localhost:8390/imanager。
         * @param {Object} [loginInfoParams] - iManager 登录参数。
         * @param {string} loginInfoParams.userName - 用户名。
         * @param {string} loginInfoParams.password - 密码。
         * @param {Object} options
         * @param {boolean} [options.isNewTab=true] - 不同域时是否在新窗口打开登录页面。
         * @returns {Promise} 返回包含 iManager 登录请求结果的 Promise 对象。
         */

    }, {
        key: 'loginManager',
        value: function loginManager(url, loginInfoParams, options) {
            if (!_Util.Util.isInTheSameDomain(url)) {
                var isNewTab = options ? options.isNewTab : true;
                this._open(url, isNewTab);
                return;
            }
            var end = url.substr(url.length - 1, 1);
            var requestUrl = end === "/" ? url + "icloud/security/tokens.json" : url + "/icloud/security/tokens.json";
            var params = loginInfoParams || {};
            var loginInfo = {
                username: params.userName && params.userName.toString(),
                password: params.password && params.password.toString()
            };
            loginInfo = JSON.stringify(loginInfo);
            var requestOptions = {
                headers: {
                    'Accept': '*/*',
                    'Content-Type': 'application/json'
                }
            };
            var me = this;
            return _FetchRequest.FetchRequest.post(requestUrl, loginInfo, requestOptions).then(function (response) {
                response.text().then(function (result) {
                    me.imanagerToken = result;
                    return result;
                });
            });
        }

        /**
         * @description 清空全部验证信息。
         * @function SuperMap.SecurityManager.destroyAllCredentials
         */

    }, {
        key: 'destroyAllCredentials',
        value: function destroyAllCredentials() {
            this.keys = null;
            this.tokens = null;
            this.servers = null;
        }

        /**
         * @description 清空令牌信息。
         * @function SuperMap.SecurityManager.destroyToken
         * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
         */

    }, {
        key: 'destroyToken',
        value: function destroyToken(url) {
            if (!url) {
                return;
            }
            var domain = this._getTokenStorageKey(url);
            this.tokens = this.tokens || {};
            if (this.tokens[domain]) {
                delete this.tokens[domain];
            }
        }

        /**
         * @description 清空服务授权码。
         * @function SuperMap.SecurityManager.destroyKey
         * @param {string} url - iServer 首页地址,如：http://localhost:8090/iserver。
         */

    }, {
        key: 'destroyKey',
        value: function destroyKey(url) {
            if (!url) {
                return;
            }
            this.keys = this.keys || {};
            var key = this._getUrlRestString(url) || url;
            if (this.keys[key]) {
                delete this.keys[key];
            }
        }
    }, {
        key: '_open',
        value: function _open(url, newTab) {
            newTab = newTab != null ? newTab : true;
            var offsetX = window.screen.availWidth / 2 - this.INNER_WINDOW_WIDTH / 2;
            var offsetY = window.screen.availHeight / 2 - this.INNER_WINDOW_HEIGHT / 2;
            var options = "height=" + this.INNER_WINDOW_HEIGHT + ", width=" + this.INNER_WINDOW_WIDTH + ",top=" + offsetY + ", left=" + offsetX + ",toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no";
            if (newTab) {
                window.open(url, 'login');
            } else {
                window.open(url, 'login', options);
            }
        }
    }, {
        key: '_getTokenStorageKey',
        value: function _getTokenStorageKey(url) {
            var patten = /(.*?):\/\/([^\/]+)/i;
            var result = url.match(patten);
            if (!result) {
                return url;
            }
            return result[0];
        }
    }, {
        key: '_getUrlRestString',
        value: function _getUrlRestString(url) {
            if (!url) {
                return url;
            }
            var patten = /http:\/\/(.*\/rest)/i;
            var result = url.match(patten);
            if (!result) {
                return url;
            }
            return result[0];
        }
    }]);

    return SecurityManager;
}();

SecurityManager.INNER_WINDOW_WIDTH = 600;
SecurityManager.INNER_WINDOW_HEIGHT = 600;
SecurityManager.SSO = "https://sso.supermap.com";
SecurityManager.ONLINE = "http://www.supermapol.com";
_SuperMap.SuperMap.SecurityManager = SecurityManager;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LinearRing = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _LineString2 = __webpack_require__(22);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Geometry.LinearRing
 * @classdesc 几何对象线环类，是一个特殊的封闭的线串，在每次 addPoint/removePoint 之后会通过添加一个点（此点是复制的第一个点得到的）
 * 作为最后的一个点来自动关闭线环。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.LineString}
 * @param {Array.<SuperMap.Geometry.Point>} points - 组成线性环的点。
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *      new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *      new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *      new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *      new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var linearRing = new SuperMap.Geometry.LinearRing(points);
 */
var LinearRing = exports.LinearRing = function (_LineString) {
    _inherits(LinearRing, _LineString);

    function LinearRing(points) {
        _classCallCheck(this, LinearRing);

        /**
         * @member {Array.<string>} [SuperMap.Geometry.LinearRing.prototype.componentTypes=["SuperMap.Geometry.Point"]]
         * @description components 存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
         * @readonly
         */
        var _this = _possibleConstructorReturn(this, (LinearRing.__proto__ || Object.getPrototypeOf(LinearRing)).call(this, points));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.LinearRing";
        _this.geometryType = "LinearRing";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LinearRing.prototype.addComponent
     * @description 添加一个点到几何图形数组中，如果这个点将要被添加到组件数组的末端，并且与数组中已经存在的最后一个点相同，
     * 重复的点是不能被添加的。这将影响未关闭环的关闭。
     * 这个方法可以通过将非空索引（组件数组的下标）作为第二个参数重写。
     * @param {SuperMap.Geometry.Point} point - 点对象。
     * @param {integer} [index] - 插入组件数组的下标。
     * @returns {boolean} 点对象是否添加成功。
     */


    _createClass(LinearRing, [{
        key: 'addComponent',
        value: function addComponent(point, index) {
            var added = false;

            //remove last point
            var lastPoint = this.components.pop();

            // given an index, add the point
            // without an index only add non-duplicate points
            if (index != null || !point.equals(lastPoint)) {
                added = _get(LinearRing.prototype.__proto__ || Object.getPrototypeOf(LinearRing.prototype), 'addComponent', this).apply(this, arguments);
            }

            //append copy of first point
            var firstPoint = this.components[0];
            _get(LinearRing.prototype.__proto__ || Object.getPrototypeOf(LinearRing.prototype), 'addComponent', this).apply(this, [firstPoint]);

            return added;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.removeComponent
         * @description 从几何组件中删除一个点。
         * @param {SuperMap.Geometry.Point} point - 点对象。
         * @returns {boolean} 点对象是否删除。
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(point) {
            // eslint-disable-line no-unused-vars
            var removed = this.components && this.components.length > 3;
            if (removed) {
                //remove last point
                this.components.pop();

                //remove our point
                _get(LinearRing.prototype.__proto__ || Object.getPrototypeOf(LinearRing.prototype), 'removeComponent', this).apply(this, arguments);
                //append copy of first point
                var firstPoint = this.components[0];
                _get(LinearRing.prototype.__proto__ || Object.getPrototypeOf(LinearRing.prototype), 'addComponent', this).apply(this, [firstPoint]);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getArea
         * @description 获得当前几何对象区域大小，如果是沿顺时针方向的环则是正值，否则为负值。
         * @returns {float} 环的面积。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 2) {
                var sum = 0.0;
                for (var i = 0, len = this.components.length; i < len - 1; i++) {
                    var b = this.components[i];
                    var c = this.components[i + 1];
                    sum += (b.x + c.x) * (c.y - b.y);
                }
                area = -sum / 2.0;
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getVertices
         * @description 返回几何图形的所有点的列表。
         * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false ，则返回非端点的顶点，如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象所有点的列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            return nodes === true ? [] : this.components.slice(0, this.components.length - 1);
        }
    }]);

    return LinearRing;
}(_LineString2.LineString);

_SuperMap.SuperMap.Geometry.LinearRing = LinearRing;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.GetFeaturesServiceBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(6);

var _GeoJSON = __webpack_require__(17);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.GetFeaturesServiceBase
 * @category  iServer Data FeatureResults
 * @classdesc 数据服务中数据集查询服务基类。获取结果数据类型为 Object。包含 result 属性，result 的数据格式根据 format 参数决定为 GeoJSON 或者 iServerJSON。
 * @extends SuperMap.CommonServiceBase
 * @param {string} url - 数据查询结果资源地址。请求数据服务中数据集查询服务，
 * URL应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param {Object} options - 参数。 
 * @param {Object} options.eventListeners - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。 
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。 
 * @param {SuperMap.DataFormat} [options.format=SuperMap.DataFormat.GEOJSON] - 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式。参数格式为 "ISERVER"，"GEOJSON"。
 * @example
 * var myService = new SuperMap.GetFeaturesServiceBase(url, {
 *     eventListeners: {
 *         "processCompleted": getFeatureCompleted,
 *         "processFailed": getFeatureError
 *     }
 * });
 */
var GetFeaturesServiceBase = exports.GetFeaturesServiceBase = function (_CommonServiceBase) {
    _inherits(GetFeaturesServiceBase, _CommonServiceBase);

    function GetFeaturesServiceBase(url, options) {
        _classCallCheck(this, GetFeaturesServiceBase);

        var _this = _possibleConstructorReturn(this, (GetFeaturesServiceBase.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase)).call(this, url, options));

        options = options || {};

        /**
         * @member {boolean} [SuperMap.GetFeaturesServiceBase.prototype.returnContent=true]
         * @description 是否立即返回新创建资源的表述还是返回新资源的 URI。
         * 如果为 true，则直接返回新创建资源，即查询结果的表述。
         * 如果为 false，则返回的是查询结果资源的 URI。
         */
        _this.returnContent = true;

        /**
         * @member {number} [SuperMap.GetFeaturesServiceBase.prototype.fromIndex=0]
         * @description 查询结果的最小索引号。如果该值大于查询结果的最大索引号，则查询结果为空。
         */
        _this.fromIndex = 0;

        /**
         * @member {number} [SuperMap.GetFeaturesServiceBase.prototype.toIndex=19]
         * @description 查询结果的最大索引号。
         * 如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
         */
        _this.toIndex = 19;

        /**
         * @member {number} [SuperMap.GetFeaturesServiceBase.prototype.maxFeatures=1000]
         * @description 进行 SQL 查询时，用于设置服务端返回查询结果条目数量。
         */
        _this.maxFeatures = null;

        /**
         * @member {string} [SuperMap.GetFeaturesServiceBase.prototype.format=SuperMap.DataFormat.GEOJSON]
         * @description 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式。
         * 参数格式为 "ISERVER"，"GEOJSON"。
         */
        _this.format = _REST.DataFormat.GEOJSON;

        _Util.Util.extend(_this, options);
        var me = _this,
            end;
        if (options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);
        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (me.format==="geojson" ) {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end == "/" ? "featureResults.json?" : "/featureResults.json?";

        _this.CLASS_NAME = "SuperMap.GetFeaturesServiceBase";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesServiceBase.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(GetFeaturesServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesServiceBase.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.fromIndex = null;
            me.toIndex = null;
            me.maxFeatures = null;
            me.format = null;
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.processAsync
         * @description 将客户端的查询参数传递到服务端。
         * @param {Object} params - 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters = null,
                firstPara = true;

            me.returnContent = params.returnContent;
            me.fromIndex = params.fromIndex;
            me.toIndex = params.toIndex;
            me.maxFeatures = params.maxFeatures;
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
                firstPara = false;
            }
            var isValidNumber = me.fromIndex != null && me.toIndex != null && !isNaN(me.fromIndex) && !isNaN(me.toIndex);
            if (isValidNumber && me.fromIndex >= 0 && me.toIndex >= 0 && !firstPara) {
                me.url += "&fromIndex=" + me.fromIndex + "&toIndex=" + me.toIndex;
            }

            if (params.returnCountOnly) {
                me.url += "&returnCountOnly=" + params.returnContent;
            }
            jsonParameters = me.getJsonParameters(params);
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.getFeatureComplete
         * @description 查询完成，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _Util.Util.transformResult(result);
            if (me.format === _REST.DataFormat.GEOJSON && result.features) {
                var geoJSONFormat = new _GeoJSON.GeoJSON();
                result.features = geoJSONFormat.toGeoJSON(result.features);
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }
    }]);

    return GetFeaturesServiceBase;
}(_CommonServiceBase2.CommonServiceBase);

_SuperMap.SuperMap.GetFeaturesServiceBase = GetFeaturesServiceBase;

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetFeaturesParametersBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.GetFeaturesParametersBase
 * @category  iServer Data FeatureResults
 * @classdesc 要素查询参数基类。
 * @param {Object} options - 参数。 
 * @param {Array.<string>} options.datasetNames - 数据集集合中的数据集名称列表。 
 * @param {boolean} [options.returnContent=true] - 是否直接返回查询结果。 
 * @param {number} [options.fromIndex=0] - 查询结果的最小索引号。 
 * @param {number} [options.toIndex=19] - 查询结果的最大索引号。 
 */
var GetFeaturesParametersBase = exports.GetFeaturesParametersBase = function () {
  function GetFeaturesParametersBase(options) {
    _classCallCheck(this, GetFeaturesParametersBase);

    /**
     * @member {Array.<string>} SuperMap.GetFeaturesParametersBase.prototype.datasetName
     * @description 数据集集合中的数据集名称列表。
     */
    this.datasetNames = null;

    /**
     * @member {boolean} [SuperMap.GetFeaturesParametersBase.prototype.returnContent=true]
     * @description 是否立即返回新创建资源的表述还是返回新资源的 URI。
     *              如果为 true，则直接返回新创建资源，即查询结果的表述。
     *              如果为 false，则返回的是查询结果资源的 URI。
     */
    this.returnContent = true;

    /**
     * @member {number} [SuperMap.GetFeaturesParametersBase.prototype.fromIndex=0]
     * @description 查询结果的最小索引号。如果该值大于查询结果的最大索引号，则查询结果为空。
     */
    this.fromIndex = 0;

    /**
     * @member {number} [SuperMap.GetFeaturesParametersBase.prototype.toIndex=19]
     * @description 查询结果的最大索引号。如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
     */
    this.toIndex = 19;

    /**
     * @member {boolean} [SuperMap.GetFeaturesParametersBase.prototype.returnCountOnly=false]
     * @description 只返回查询结果的总数。
     */
    this.returnCountOnly = false;

    /**
     * @member {number} [SuperMap.GetFeaturesParametersBase.prototype.maxFeatures=1000]
     * @description 进行 SQL 查询时，用于设置服务端返回查询结果条目数量。
     */
    this.maxFeatures = null;

    /**
     * @member {Object} SuperMap.GetFeaturesParametersBase.prototype.aggregations
     * @description 聚合查询参数，该参数仅支持数据来源 Elasticsearch 服务的数据服务。
     */
    this.aggregations = null;

    _Util.Util.extend(this, options);

    this.CLASS_NAME = "SuperMap.GetFeaturesParametersBase";
  }

  /**
   *
   * @function SuperMap.GetFeaturesParametersBase.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(GetFeaturesParametersBase, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.datasetNames = null;
      me.returnContent = null;
      me.fromIndex = null;
      me.toIndex = null;
      me.maxFeatures = null;
      if (me.aggregation) {
        me.aggregation = null;
      }
    }
  }]);

  return GetFeaturesParametersBase;
}();

_SuperMap.SuperMap.GetFeaturesParametersBase = GetFeaturesParametersBase;

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FacilityAnalyst3DParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FacilityAnalyst3DParameters
 * @category  iServer FacilityAnalyst3D
 * @classdesc 最近设施分析参数基类。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点（或从设施点到事件点）以最小耗费能到达的最佳路径。
 * 设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在 10 分钟内能到达的最近医院，
 * 超过 10 分钟能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起
 * 作用的障碍边、障碍点、转向表、耗费等属性在最近设施分析时同样可设置。
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 *                                                      指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */
var FacilityAnalyst3DParameters = exports.FacilityAnalyst3DParameters = function () {
  function FacilityAnalyst3DParameters(options) {
    _classCallCheck(this, FacilityAnalyst3DParameters);

    /**
     * @member {number} [SuperMap.FacilityAnalyst3DParameters.prototype.edgeID]
     * @description 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
     */
    this.edgeID = null;

    /**
     * @member {number} [SuperMap.FacilityAnalyst3DParameters.prototype.nodeID]
     * @description 指定的结点 ID，edgeID 与 nodeID 必须指定一个。 
     */
    this.nodeID = null;

    /**
     * @member {string} SuperMap.FacilityAnalyst3DParameters.prototype.weightName
     * @description 指定的权值字段信息对象的名称。
     */
    this.weightName = null;

    /**
     * @member {boolean} [SuperMap.FacilityAnalyst3DParameters.prototype.isUncertainDirectionValid=false]
     * @description 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
     *              指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找
     */
    this.isUncertainDirectionValid = false;
    _Util.Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FacilityAnalyst3DParameters";
  }

  /**
   * @function SuperMap.FacilityAnalyst3DParameters.prototype.destroy
   * @override
   */


  _createClass(FacilityAnalyst3DParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.edgeID = null;
      me.nodeID = null;
      me.weightName = null;
      me.isUncertainDirectionValid = null;
    }
  }]);

  return FacilityAnalyst3DParameters;
}();

_SuperMap.SuperMap.FacilityAnalyst3DParameters = FacilityAnalyst3DParameters;

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Events = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Pixel = __webpack_require__(76);

var _Event = __webpack_require__(259);

var _BaseTypes = __webpack_require__(52);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Events
 * @classdesc 事件类。
 * @param {Object} object - 当前事件对象被添加到的 JS 对象。
 * @param {HTMLElement} element - 响应浏览器事件的 DOM 元素。
 * @param {Array.<string>} eventTypes - 自定义应用事件的数组。
 * @param {boolean} [fallThrough=false] - 是否允许事件处理之后向上传递（冒泡），为 false 的时候阻止事件冒泡。
 * @param {Object} options - 事件对象选项。
 */
var Events = exports.Events = function () {
    function Events(object, element, eventTypes, fallThrough, options) {
        _classCallCheck(this, Events);

        /**
         * @member {Array.<string>} SuperMap.Events.prototype.BROWSER_EVENTS
         * @description 支持的事件。
         * @constant
         * @default [
         "mouseover", "mouseout","mousedown", "mouseup", "mousemove",
         "click", "dblclick", "rightclick", "dblrightclick","resize",
         "focus", "blur","touchstart", "touchmove", "touchend","keydown",
         "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup",
         "MSGestureStart", "MSGestureChange", "MSGestureEnd","contextmenu"
         ]
         */
        this.BROWSER_EVENTS = ["mouseover", "mouseout", "mousedown", "mouseup", "mousemove", "click", "dblclick", "rightclick", "dblrightclick", "resize", "focus", "blur", "touchstart", "touchmove", "touchend", "keydown", "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup", "MSGestureStart", "MSGestureChange", "MSGestureEnd", "contextmenu"];

        /**
         * @member {Object} SuperMap.Events.prototype.listeners
         * @description Hashtable of Array(function): events listener functions
         */
        this.listeners = {};

        /**
         * @member {Object} SuperMap.Events.prototype.object
         * @description  发布应用程序事件的对象。
         */
        this.object = object;

        /**
         * @member {HTMLElement} SuperMap.Events.prototype.element
         * @description 接受浏览器事件的 DOM 节点。
         */
        this.element = null;

        /**
         * @member {Array.<string>} SuperMap.Events.prototype.eventTypes
         * @description 支持的事件类型列表。
         */
        this.eventTypes = [];

        /**
         * @member {function} SuperMap.Events.prototype.eventHandler
         * @description 绑定在元素上的事件处理器对象。
         */
        this.eventHandler = null;

        /**
         * @member {boolean} [SuperMap.Events.prototype.fallThrough=false]
         * @description 是否允许事件处理之后向上传递（冒泡），为 false 的时候阻止事件冒泡。
         */
        this.fallThrough = fallThrough;

        /**
         * @member {boolean} [SuperMap.Events.prototype.includeXY=false]
         * @description 判断是否让 xy 属性自动创建到浏览器上的鼠标事件，一般设置为 false，如果设置为 true，鼠标事件将会在事件传递过程中自动产生 xy 属性。
         *              可根据事件对象的 'evt.object' 属性在相关的事件句柄上调用 getMousePosition 函数。这个选项习惯默认为 false 的原因在于，当创建一个
         *              事件对象，其主要目的是管理。在一个 div 的相对定位的鼠标事件，将其设为 true 也是有意义的。这个选项也可以用来控制是否抵消缓存。如果
         *              设为 false 不抵消，如果设为 true，用 this.clearMouseCache() 清除缓存偏移（边界元素偏移，元素在页面的位置偏移）。
         * @example
         *  function named(evt) {
         *        this.xy = this.object.events.getMousePosition(evt);
         *  }
         */
        this.includeXY = false;

        /**
         * @member {Object} SuperMap.Events.prototype.extensions
         * @description 事件扩展。Keys 代表事件类型，values 代表事件对象。
         * @example
         * 以扩展 "foostart" 和 "fooend" 事件为例。展示替换 css 属性为 foo 的元素的 click 事件。
         *
         *   SuperMap.Events.foostart = SuperMap.Class({
        *       initialize: function(target) {
        *           this.target = target;
        *           this.target.register("click", this, this.doStuff, {extension: true});
        *           // only required if extension provides more than one event type
        *           this.target.extensions["foostart"] = true;
        *           this.target.extensions["fooend"] = true;
        *       },
        *       destroy: function() {
        *           var target = this.target;
        *           target.unregister("click", this, this.doStuff);
        *           delete this.target;
        *           // only required if extension provides more than one event type
        *           delete target.extensions["foostart"];
        *           delete target.extensions["fooend"];
        *       },
        *       doStuff: function(evt) {
        *           var propagate = true;
        *           if (SuperMap.Event.element(evt).className === "foo") {
        *               propagate = false;
        *               var target = this.target;
        *               target.triggerEvent("foostart");
        *               window.setTimeout(function() {
        *                   target.triggerEvent("fooend");
        *               }, 1000);
        *           }
        *           return propagate;
        *       }
        *   });
         *   // only required if extension provides more than one event type
         *   SuperMap.Events.fooend = SuperMap.Events.foostart;
         */
        this.extensions = {};

        /**
         * @member {Object} SuperMap.Events.prototype.extensionCount
         */
        this.extensionCount = {};
        /**
         * @member {Object} SuperMap.Events.prototype.clearMouseListener
         */
        this.clearMouseListener = null;

        _Util.Util.extend(this, options);

        if (eventTypes != null) {
            for (var i = 0, len = eventTypes.length; i < len; i++) {
                this.addEventType(eventTypes[i]);
            }
        }

        if (element != null) {
            this.attachToElement(element);
        }

        this.CLASS_NAME = "SuperMap.Events";
    }

    /**
     * @function SuperMap.Events.prototype.destroy
     * @description 移除当前要素 element 上的所有事件监听和处理。
     */


    _createClass(Events, [{
        key: 'destroy',
        value: function destroy() {
            for (var e in this.extensions) {
                if (typeof this.extensions[e] !== "boolean") {
                    this.extensions[e].destroy();
                }
            }
            this.extensions = null;
            if (this.element) {
                _Event.Event.stopObservingElement(this.element);
                if (this.element.hasScrollEvent) {
                    _Event.Event.stopObserving(window, "scroll", this.clearMouseListener);
                }
            }
            this.element = null;

            this.listeners = null;
            this.object = null;
            this.eventTypes = null;
            this.fallThrough = null;
            this.eventHandler = null;
        }

        /**
         * @function SuperMap.Events.prototype.addEventType
         * @description 在此事件对象中添加新的事件类型，如果这个事件类型已经添加过了，则不做任何事情。
         * @param {string} eventName - 事件名。
         */

    }, {
        key: 'addEventType',
        value: function addEventType(eventName) {
            if (!this.listeners[eventName]) {
                this.eventTypes.push(eventName);
                this.listeners[eventName] = [];
            }
        }

        /**
         * @function SuperMap.Events.prototype.attachToElement
         * @description 给 DOM 元素绑定浏览器事件。
         * @param {HTMLDOMElement} element - 绑定浏览器事件的 DOM 元素。
         */

    }, {
        key: 'attachToElement',
        value: function attachToElement(element) {
            if (this.element) {
                _Event.Event.stopObservingElement(this.element);
            } else {
                // keep a bound copy of handleBrowserEvent() so that we can
                // pass the same function to both Event.observe() and .stopObserving()
                this.eventHandler = _BaseTypes.FunctionExt.bindAsEventListener(this.handleBrowserEvent, this);

                // to be used with observe and stopObserving
                this.clearMouseListener = _BaseTypes.FunctionExt.bind(this.clearMouseCache, this);
            }
            this.element = element;
            for (var i = 0, len = this.BROWSER_EVENTS.length; i < len; i++) {
                var eventType = this.BROWSER_EVENTS[i];

                // every browser event has a corresponding application event
                // (whether it's listened for or not).
                this.addEventType(eventType);

                // use Prototype to register the event cross-browser
                _Event.Event.observe(element, eventType, this.eventHandler);
            }
            // disable dragstart in IE so that mousedown/move/up works normally
            _Event.Event.observe(element, "dragstart", _Event.Event.stop);
        }

        /**
         * @function SuperMap.Events.prototype.on
         * @description 在一个相同的范围内注册监听器的方法，此方法调用 register 函数。
         * @example
         * // 注册一个 "loadstart" 监听事件
         * events.on({"loadstart": loadStartListener});
         *
         * // 同样注册一个 "loadstart" 监听事件
         * events.register("loadstart", undefined, loadStartListener);
         *
         * // 同时为对象注册多个监听事件
         * events.on({
         *     "loadstart": loadStartListener,
         *     "loadend": loadEndListener,
         *     scope: object
         * });
         *
         * // 同时为对象注册多个监听事件，多次调用 register 方法
         * events.register("loadstart", object, loadStartListener);
         * events.register("loadend", object, loadEndListener);
         *
         *
         * @param {Object} object - 添加监听的对象。
         */

    }, {
        key: 'on',
        value: function on(object) {
            for (var type in object) {
                if (type !== "scope" && object.hasOwnProperty(type)) {
                    this.register(type, object.scope, object[type]);
                }
            }
        }

        /**
         * @function SuperMap.Events.prototype.register
         * @description 在事件对象上注册一个事件。当事件被触发时，'func' 函数被调用，假设我们触发一个事件，
         *              指定 SuperMap.Bounds 作为 "obj"，当事件被触发时，回调函数的上下文作为 Bounds 对象。
         * @param {string} type - 事件注册者的名字。
         * @param {Object} [obj=this.object] - 对象绑定的回调。
         * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
         * @param {(boolean|Object)} [priority] - 当为 true 时将新的监听加在事件队列的前面。
         */

    }, {
        key: 'register',
        value: function register(type, obj, func, priority) {
            if (type in Events && !this.extensions[type]) {
                this.extensions[type] = new Events[type](this);
            }
            if (func != null && _Util.Util.indexOf(this.eventTypes, type) !== -1) {

                if (obj == null) {
                    obj = this.object;
                }
                var listeners = this.listeners[type];
                if (!listeners) {
                    listeners = [];
                    this.listeners[type] = listeners;
                    this.extensionCount[type] = 0;
                }
                var listener = { obj: obj, func: func };
                if (priority) {
                    listeners.splice(this.extensionCount[type], 0, listener);
                    if ((typeof priority === 'undefined' ? 'undefined' : _typeof(priority)) === "object" && priority.extension) {
                        this.extensionCount[type]++;
                    }
                } else {
                    listeners.push(listener);
                }
            }
        }

        /**
         * @function SuperMap.Events.prototype.registerPriority
         * @description 相同的注册方法，但是在前面增加新的监听者事件查询而代替到方法的结束。
         * @param {string} type - 事件注册者的名字。
         * @param {Object} [obj=this.object] - 对象绑定方面的回调。
         * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
         */

    }, {
        key: 'registerPriority',
        value: function registerPriority(type, obj, func) {
            this.register(type, obj, func, true);
        }

        /**
         * @function SuperMap.Events.prototype.un
         * @description 在一个相同的范围内取消注册监听器的方法，此方法调用 unregister 函数。
         * @example
         * // 移除 "loadstart" 事件监听
         * events.un({"loadstart": loadStartListener});
         *
         * // 使用 "unregister" 方法移除 "loadstart" 事件监听
         * events.unregister("loadstart", undefined, loadStartListener);
         *
         * // 取消对象多个事件监听
         * events.un({
         *     "loadstart": loadStartListener,
         *     "loadend": loadEndListener,
         *     scope: object
         * });
         *
         * // 取消对象多个事件监听，多次调用unregister方法。
         * events.unregister("loadstart", object, loadStartListener);
         * events.unregister("loadend", object, loadEndListener);
         *
         * @param {Object} object - 移除监听的对象。
         */

    }, {
        key: 'un',
        value: function un(object) {
            for (var type in object) {
                if (type !== "scope" && object.hasOwnProperty(type)) {
                    this.unregister(type, object.scope, object[type]);
                }
            }
        }

        /**
         * @function SuperMap.Events.prototype.unregister
         * @description 取消注册。
         * @param {string} type - 事件类型。
         * @param {Object} [obj=this.object] - 对象绑定方面的回调。
         * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
         */

    }, {
        key: 'unregister',
        value: function unregister(type, obj, func) {
            if (obj == null) {
                obj = this.object;
            }
            var listeners = this.listeners[type];
            if (listeners != null) {
                for (var i = 0, len = listeners.length; i < len; i++) {
                    if (listeners[i].obj === obj && listeners[i].func === func) {
                        listeners.splice(i, 1);
                        break;
                    }
                }
            }
        }

        /**
         * @function SuperMap.Events.prototype.remove
         * @description 删除某个事件类型的所有监听，如果该事件类型没有注册，则不做任何操作。
         * @param {string} type - 事件类型。
         */

    }, {
        key: 'remove',
        value: function remove(type) {
            if (this.listeners[type] != null) {
                this.listeners[type] = [];
            }
        }

        /**
         * @function SuperMap.Events.prototype.triggerEvent
         * @description 触发一个特定的注册事件。
         * @param {string} type - 触发事件类型。
         * @param {Event} evt - 事件对象。
         * @returns {boolean} 返回监听对象，如果返回是 false，则停止监听。
         */

    }, {
        key: 'triggerEvent',
        value: function triggerEvent(type, evt) {
            var listeners = this.listeners[type];

            // fast path
            if (!listeners || listeners.length == 0) {
                return undefined;
            }

            // prep evt object with object & div references
            if (evt == null) {
                evt = {};
            }
            evt.object = this.object;
            evt.element = this.element;
            if (!evt.type) {
                evt.type = type;
            }

            // execute all callbacks registered for specified type
            // get a clone of the listeners array to
            // allow for splicing during callbacks
            listeners = listeners.slice();
            var continueChain;
            for (var i = 0, len = listeners.length; i < len; i++) {
                var callback = listeners[i];
                // bind the context to callback.obj
                continueChain = callback.func.apply(callback.obj, [evt]);

                if (continueChain != undefined && continueChain == false) {
                    // if callback returns false, execute no more callbacks.
                    break;
                }
            }
            // don't fall through to other DOM elements
            if (!this.fallThrough) {
                _Event.Event.stop(evt, true);
            }
            return continueChain;
        }

        /**
         * @function SuperMap.Events.prototype.handleBrowserEvent
         * @description 对 triggerEvent 函数的包装，给事件对象设置了 xy 属性（即当前鼠标点的 xy 坐标）。
         * @param {Event} evt - 事件对象。
         */

    }, {
        key: 'handleBrowserEvent',
        value: function handleBrowserEvent(evt) {
            var type = evt.type,
                listeners = this.listeners[type];
            if (!listeners || listeners.length == 0) {
                // noone's listening, bail out
                return;
            }
            // add clientX & clientY to all events - corresponds to average x, y
            var touches = evt.touches;
            if (touches && touches[0]) {
                var x = 0;
                var y = 0;
                var num = touches.length;
                var touch;
                for (var i = 0; i < num; ++i) {
                    touch = touches[i];
                    x += touch.clientX;
                    y += touch.clientY;
                }
                evt.clientX = x / num;
                evt.clientY = y / num;
            }
            if (this.includeXY) {
                evt.xy = this.getMousePosition(evt);
            }
            this.triggerEvent(type, evt);
        }

        /**
         * @function SuperMap.Events.prototype.clearMouseCache
         * @description 清除鼠标缓存。
         */

    }, {
        key: 'clearMouseCache',
        value: function clearMouseCache() {
            this.element.scrolls = null;
            this.element.lefttop = null;
            var body = document.body;
            if (body && !((body.scrollTop != 0 || body.scrollLeft != 0) && navigator.userAgent.match(/iPhone/i))) {
                this.element.offsets = null;
            }
        }

        /**
         * @function SuperMap.Events.prototype.getMousePosition
         * @param {Event} evt - 事件对象。
         * @returns {SuperMap.Pixel} 当前的鼠标的 xy 坐标点。
         */

    }, {
        key: 'getMousePosition',
        value: function getMousePosition(evt) {
            if (!this.includeXY) {
                this.clearMouseCache();
            } else if (!this.element.hasScrollEvent) {
                _Event.Event.observe(window, "scroll", this.clearMouseListener);
                this.element.hasScrollEvent = true;
            }

            if (!this.element.scrolls) {
                var viewportElement = _Util.Util.getViewportElement();
                this.element.scrolls = [viewportElement.scrollLeft, viewportElement.scrollTop];
            }

            if (!this.element.lefttop) {
                this.element.lefttop = [document.documentElement.clientLeft || 0, document.documentElement.clientTop || 0];
            }

            if (!this.element.offsets) {
                this.element.offsets = _Util.Util.pagePosition(this.element);
            }

            return new _Pixel.Pixel(evt.clientX + this.element.scrolls[0] - this.element.offsets[0] - this.element.lefttop[0], evt.clientY + this.element.scrolls[1] - this.element.offsets[1] - this.element.lefttop[1]);
        }
    }]);

    return Events;
}();

_SuperMap.SuperMap.Events = Events;
_SuperMap.SuperMap.Events.prototype.BROWSER_EVENTS = ["mouseover", "mouseout", "mousedown", "mouseup", "mousemove", "click", "dblclick", "rightclick", "dblrightclick", "resize", "focus", "blur", "touchstart", "touchmove", "touchend", "keydown", "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup", "MSGestureStart", "MSGestureChange", "MSGestureEnd", "contextmenu"];

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.MultiPoint = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _Collection2 = __webpack_require__(31);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.MultiPoint
 * @classdesc 几何对象多点类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.Point>} components - 点对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(5,6);
 * var poine2 = new SuperMap.Geometry.Point(7,8);
 * var multiPoint = new SuperMap.Geometry.MultiPoint([point1,point2]);
 */
var MultiPoint = exports.MultiPoint = function (_Collection) {
    _inherits(MultiPoint, _Collection);

    function MultiPoint(components) {
        _classCallCheck(this, MultiPoint);

        /**
         * @member {Array.<string>} [SuperMap.Geometry.MultiPoint.prototype.componentTypes=["SuperMap.Geometry.Point"]]
         * @description components 存储的的几何对象所支持的几何类型数组。
         * @readonly
         */
        var _this = _possibleConstructorReturn(this, (MultiPoint.__proto__ || Object.getPrototypeOf(MultiPoint)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiPoint";
        _this.geometryType = "MultiPoint";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.MultiPoint.prototype.addPoint
     * @description 添加点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.addComponent} 方法。
     * @param {SuperMap.Geometry.Point} point - 添加的点。
     * @param {integer} [index] - 下标。
     */


    _createClass(MultiPoint, [{
        key: 'addPoint',
        value: function addPoint(point, index) {
            this.addComponent(point, index);
        }

        /**
         * @function SuperMap.Geometry.MultiPoint.prototype.removePoint
         * @description 移除点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.removeComponent} 方法。
         * @param {SuperMap.Geometry.Point} point - 移除的点对象。
         */

    }, {
        key: 'removePoint',
        value: function removePoint(point) {
            this.removeComponent(point);
        }
    }]);

    return MultiPoint;
}(_Collection2.Collection);

_SuperMap.SuperMap.Geometry.MultiPoint = MultiPoint;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.LonLat = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.LonLat
 * @category BaseTypes Geometry
 * @classdesc  这个类用来表示经度和纬度对。
 * @param {number} [lon=0.0] - 地图单位上的 X 轴坐标，如果地图是地理投影，则此值是经度，否则，此值是地图地理位置的 x 坐标。
 * @param {number} [lat=0.0] - 地图单位上的 Y 轴坐标，如果地图是地理投影，则此值是纬度，否则，此值是地图地理位置的 y 坐标。
 * @param {Array.<float>} [location] - 如果要同时设置，则使用传入横纵坐标组成的数组。
 * @example
 * var lonLat = new SuperMap.LonLat(30,45);
 */
var LonLat = exports.LonLat = function () {
    function LonLat(lon, lat) {
        _classCallCheck(this, LonLat);

        if (_Util.Util.isArray(lon)) {
            lat = lon[1];
            lon = lon[0];
        }
        /**
         * @member {float} [SuperMap.LonLat.prototype.lon=0.0]
         * @description 地图的单位的 X 轴（横轴）坐标。
         */
        this.lon = lon ? _Util.Util.toFloat(lon) : 0.0;

        /**
         * @member {float} [SuperMap.LonLat.prototype.lat=0.0]
         * @description 地图的单位的 Y 轴（纵轴）坐标。
         */
        this.lat = lat ? _Util.Util.toFloat(lat) : 0.0;
        this.CLASS_NAME = "SuperMap.LonLat";
    }

    /**
     * @function SuperMap.LonLat.prototype.toString
     * @description 返回此对象的字符串形式
     * @example
     * var lonLat = new SuperMap.LonLat(100,50);
     * var str = lonLat.toString();
     * @returns {string} 例如: "lon=100,lat=50"
     */


    _createClass(LonLat, [{
        key: "toString",
        value: function toString() {
            return "lon=" + this.lon + ",lat=" + this.lat;
        }

        /**
         * @function SuperMap.LonLat.prototype.toShortString
         * @description 将经度纬度转换成简单字符串。
         * @example
         * var lonLat = new SuperMap.LonLat(100,50);
         * var str = lonLat.toShortString();
         * @returns {string} 返回处理后的经纬度字符串。例如："100,50"
         */

    }, {
        key: "toShortString",
        value: function toShortString() {
            return this.lon + "," + this.lat;
        }

        /**
         * @function SuperMap.LonLat.prototype.clone
         * @description 复制坐标对象，并返回复制后的新对象。
         * @example
         * var lonLat1 = new SuperMap.LonLat(100,50);
         * var lonLat2 = lonLat1.clone();
         * @returns {SuperMap.LonLat}  返回相同坐标值的新的坐标对象。
         */

    }, {
        key: "clone",
        value: function clone() {
            return new LonLat(this.lon, this.lat);
        }

        /**
         * @function SuperMap.LonLat.prototype.add
         * @description 在已有坐标对象的经纬度基础上加上新的坐标经纬度，并返回新的坐标对象。
         * @example
         * var lonLat1 = new SuperMap.LonLat(100,50);
         * //lonLat2 是新的对象
         * var lonLat2 = lonLat1.add(100,50);
         * @param {float} lon - 传入的经度参数。
         * @param {float} lat - 传入的纬度参数。
         * @returns {SuperMap.LonLat} 返回一个新的 LonLat 对象，此对象的经纬度是由传入的经纬度与当前的经纬度相加所得。
         */

    }, {
        key: "add",
        value: function add(lon, lat) {
            if (lon == null || lat == null) {
                throw new TypeError('LonLat.add cannot receive null values');
            }
            return new LonLat(this.lon + _Util.Util.toFloat(lon), this.lat + _Util.Util.toFloat(lat));
        }

        /**
         * @function SuperMap.LonLat.prototype.equals
         * @description 判断两个坐标对象是否相等。
         * @example
         * var lonLat1 = new SuperMap.LonLat(100,50);
         * var lonLat2 = new SuperMap.LonLat(100,50);
         * var isEquals = lonLat1.equals(lonLat2);
         * @param {SuperMap.LonLat} ll - 需要进行比较的坐标对象。
         * @returns {boolean} 如果LonLat对象的经纬度和传入的经纬度一致则返回true,不一
         *      致或传入的ll参数为NULL则返回false。
         */

    }, {
        key: "equals",
        value: function equals(ll) {
            var equals = false;
            if (ll != null) {
                equals = this.lon === ll.lon && this.lat === ll.lat || isNaN(this.lon) && isNaN(this.lat) && isNaN(ll.lon) && isNaN(ll.lat);
            }
            return equals;
        }

        /**
         * @function SuperMap.LonLat.prototype.wrapDateLine
         * @description 通过传入的范围对象对坐标对象转换到该范围内。
         * 如果经度小于给定范围最小精度，则在原经度基础上加上范围宽度，直到精度在范围内为止，如果经度大于给定范围则在原经度基础上减去范围宽度。
         * 即指将不在经度范围内的坐标转换到范围以内（只会转换 lon，不会转换 lat，主要用于转移到日界线以内）。
         * @example
         * var lonLat1 = new SuperMap.LonLat(420,50);
         * var lonLat2 = lonLat1.wrapDateLine(
         *      new SuperMap.Bounds(-180,-90,180,90)
         *  );
         * @param {SuperMap.Bounds} maxExtent - 最大边界的范围。
         * @returns {SuperMap.LonLat} 将坐标转换到范围对象以内，并返回新的坐标。
         */

    }, {
        key: "wrapDateLine",
        value: function wrapDateLine(maxExtent) {

            var newLonLat = this.clone();

            if (maxExtent) {
                //shift right?
                while (newLonLat.lon < maxExtent.left) {
                    newLonLat.lon += maxExtent.getWidth();
                }

                //shift left?
                while (newLonLat.lon > maxExtent.right) {
                    newLonLat.lon -= maxExtent.getWidth();
                }
            }

            return newLonLat;
        }

        /**
         *
         * @function SuperMap.LonLat.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为 null，而不是初始值。
         * @example
         * var lonLat = new SuperMap.LonLat(100,50);
         * lonLat.destroy();
         */

    }, {
        key: "destroy",
        value: function destroy() {
            this.lon = null;
            this.lat = null;
        }

        /**
         * @function SuperMap.LonLat.fromString
         * @description 通过字符串生成一个 {@link SuperMap.LonLat} 对象。
         * @example
         * var str = "100,50";
         * var lonLat = SuperMap.LonLat.fromString(str);
         * @param {string} str - 字符串的格式：Lon+","+Lat。如："100,50"。
         * @returns {SuperMap.LonLat} 返回一个 {@link SuperMap.LonLat} 对象。
         */

    }], [{
        key: "fromString",
        value: function fromString(str) {
            var pair = str.split(",");
            return new LonLat(pair[0], pair[1]);
        }

        /**
         * @function SuperMap.LonLat.fromArray
         * @description 通过数组生成一个 <SuperMap.LonLat> 对象。
         * @param {Array.<float>} arr - 数组的格式，长度只能为2,：[Lon,Lat]。如：[5,-42]。
         * @returns {SuperMap.LonLat} 返回一个 <SuperMap.LonLat> 对象。
         */

    }, {
        key: "fromArray",
        value: function fromArray(arr) {
            var gotArr = _Util.Util.isArray(arr),
                lon = gotArr && arr[0],
                lat = gotArr && arr[1];
            return new LonLat(lon, lat);
        }
    }]);

    return LonLat;
}();

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
/**
 * @class  SuperMap.LevelRenderer.Eventful
 * @category Visualization Theme
 * @classdesc 事件分发器超类，所有支持事件处理的类均是此类的子类。
 * 此类不可实例化。
 * @private 
 */
var Eventful = exports.Eventful = function () {

    /**
     * @function SuperMap.LevelRenderer.Eventful.prototype.constructor
     * @description 构造函数。对象可以通过 onxxxx 绑定事件。
     * 支持的事件：
     * Symbolizer properties:
     * onclick - {function} 默认值：null。
     * onmouseover - {function} 默认值：null。
     * onmouseout - {function} 默认值：null。
     * onmousemove - {function} 默认值：null。
     * onmousewheel - {function} 默认值：null。
     * onmousedown - {function} 默认值：null。
     * onmouseup - {function} 默认值：null。
     * ondragstart - {function} 默认值：null。
     * ondragend - {function} 默认值：null。
     * ondragenter - {function} 默认值：null。
     * ondragleave - {function} 默认值：null。
     * ondragover - {function} 默认值：null。
     * ondrop - {function} 默认值：null。
     */
    function Eventful() {
        _classCallCheck(this, Eventful);

        /**
         * @member {Object} SuperMap.LevelRenderer.Eventful.prototype._handlers
         * @description 事件处理对象（事件分发器）。
         */
        this._handlers = {};

        this.CLASS_NAME = "SuperMap.LevelRenderer.Eventful";
    }

    /**
     * @function {Object} SuperMap.LevelRenderer.Eventful.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(Eventful, [{
        key: 'destroy',
        value: function destroy() {
            this._handlers = null;
        }

        /**
         * @function SuperMap.LevelRenderer.Eventful.prototype.one
         * @description 单次触发绑定，dispatch后销毁。
         * @param {string} event - 事件名。
         * @param {boolean} handler - 响应函数。
         * @param {Object} context - context。
         * @returns {SuperMap.LevelRenderer.Eventful} this
         */

    }, {
        key: 'one',
        value: function one(event, handler, context) {
            var _h = this._handlers;

            if (!handler || !event) {
                return this;
            }

            if (!_h[event]) {
                _h[event] = [];
            }

            _h[event].push({
                h: handler,
                one: true,
                ctx: context || this
            });

            return this;
        }

        /**
         * @function SuperMap.LevelRenderer.Eventful.prototype.bind
         * @description 绑定事件。
         * @param {string} event - 事件名。
         * @param {boolean} handler - 响应函数。
         * @param {Object} context - context。
         * @returns {SuperMap.LevelRenderer.Eventful} this
         */

    }, {
        key: 'bind',
        value: function bind(event, handler, context) {
            var _h = this._handlers;

            if (!handler || !event) {
                return this;
            }

            if (!_h[event]) {
                _h[event] = [];
            }

            _h[event].push({
                h: handler,
                one: false,
                ctx: context || this
            });

            return this;
        }

        /**
         * @function SuperMap.LevelRenderer.Eventful.prototype.unbind
         * @description 解绑事件。
         * @param {string} event - 事件名。
         * @param {boolean} handler - 响应函数。
         * @returns {SuperMap.LevelRenderer.Eventful} this
         */

    }, {
        key: 'unbind',
        value: function unbind(event, handler) {
            var _h = this._handlers;

            if (!event) {
                this._handlers = {};
                return this;
            }

            if (handler) {
                if (_h[event]) {
                    var newList = [];
                    for (var i = 0, l = _h[event].length; i < l; i++) {
                        if (_h[event][i]['h'] != handler) {
                            newList.push(_h[event][i]);
                        }
                    }
                    _h[event] = newList;
                }

                if (_h[event] && _h[event].length === 0) {
                    delete _h[event];
                }
            } else {
                delete _h[event];
            }

            return this;
        }

        /**
         * @function SuperMap.LevelRenderer.Eventful.prototype.dispatch
         * @description 事件分发。
         * @param {string} type - 事件类型。
         * @returns {SuperMap.LevelRenderer.Eventful} this
         */

    }, {
        key: 'dispatch',
        value: function dispatch(type) {
            if (this._handlers[type]) {
                var args = arguments;
                var argLen = args.length;

                if (argLen > 3) {
                    args = Array.prototype.slice.call(args, 1);
                }

                var _h = this._handlers[type];
                var len = _h.length;
                for (var i = 0; i < len;) {
                    // Optimize advise from backbone
                    switch (argLen) {
                        case 1:
                            _h[i]['h'].call(_h[i]['ctx']);
                            break;
                        case 2:
                            _h[i]['h'].call(_h[i]['ctx'], args[1]);
                            break;
                        case 3:
                            _h[i]['h'].call(_h[i]['ctx'], args[1], args[2]);
                            break;
                        default:
                            // have more than 2 given arguments
                            _h[i]['h'].apply(_h[i]['ctx'], args);
                            break;
                    }

                    if (_h[i]['one']) {
                        _h.splice(i, 1);
                        len--;
                    } else {
                        i++;
                    }
                }
            }

            return this;
        }

        /**
         * @function SuperMap.LevelRenderer.Eventful.prototype.dispatchWithContext
         * @description 带有context的事件分发，最后一个参数是事件回调的 context。
         * @param {string} type - 事件类型。
         * @returns {SuperMap.LevelRenderer.Eventful} this
         */

    }, {
        key: 'dispatchWithContext',
        value: function dispatchWithContext(type) {
            if (this._handlers[type]) {
                var args = arguments;
                var argLen = args.length;

                if (argLen > 4) {
                    args = Array.prototype.slice.call(args, 1, args.length - 1);
                }
                var ctx = args[args.length - 1];

                var _h = this._handlers[type];
                var len = _h.length;
                for (var i = 0; i < len;) {
                    // Optimize advise from backbone
                    switch (argLen) {
                        case 1:
                            _h[i]['h'].call(ctx);
                            break;
                        case 2:
                            _h[i]['h'].call(ctx, args[1]);
                            break;
                        case 3:
                            _h[i]['h'].call(ctx, args[1], args[2]);
                            break;
                        default:
                            // have more than 2 given arguments
                            _h[i]['h'].apply(ctx, args);
                            break;
                    }

                    if (_h[i]['one']) {
                        _h.splice(i, 1);
                        len--;
                    } else {
                        i++;
                    }
                }
            }

            return this;
        }
    }]);

    return Eventful;
}();

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.QueryService = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(6);

var _QueryParameters = __webpack_require__(36);

var _GeoJSON = __webpack_require__(17);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.QueryService
 * @category  iServer Map QueryResults
 * @classdesc 查询服务基类。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。
 * @param {SuperMap.ServerType} options.serverType - 服务器类型，iServer|iPortal|Online。
 * @param {SuperMap.DataFormat} options.format - 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER"，"GEOJSON"。
 * @example
 * var myService = new SuperMap.QueryService(url, {
 *     eventListeners: {
 *	       "processCompleted": queryCompleted,
 *		   "processFailed": queryError
 *		   }
 * };
 */
var QueryService = exports.QueryService = function (_CommonServiceBase) {
    _inherits(QueryService, _CommonServiceBase);

    /**
     * @function SuperMap.QueryService.prototype.constructor
     * @description 查询服务基类构造函数。
     * @param {string} url - 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
     * @param {Object} options -参数。
     * @param {Object} options.eventListeners - 需要被注册的监听器对象。
     */
    function QueryService(url, options) {
        _classCallCheck(this, QueryService);

        /**
         * @member {boolean} SuperMap.QueryService.prototype.returnContent
         * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
         */
        var _this = _possibleConstructorReturn(this, (QueryService.__proto__ || Object.getPrototypeOf(QueryService)).call(this, url, options));

        _this.returnContent = false;

        /**
         * @member {string} SuperMap.QueryService.prototype.format
         * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
         */
        _this.format = _REST.DataFormat.GEOJSON;

        _this.returnFeatureWithFieldCaption = false;

        if (options) {
            _Util.Util.extend(_this, options);
        }

        _this.CLASS_NAME = "SuperMap.QueryService";
        var me = _this,
            end;
        if (!me.url) {
            return _possibleConstructorReturn(_this);
        }
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);

        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (this.format==="geojson") {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end === "/" ? "queryResults.json?" : "/queryResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.QueryService.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(QueryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryService.prototype.__proto__ || Object.getPrototypeOf(QueryService.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.format = null;
        }

        /**
         * @function SuperMap.QueryService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param {SuperMap.QueryParameters} params - 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!(params instanceof _QueryParameters.QueryParameters)) {
                return;
            }
            var me = this,
                returnCustomResult = null,
                jsonParameters = null;
            me.returnContent = params.returnContent;

            jsonParameters = me.getJsonParameters(params);
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
            } else {
                //仅供三维使用 获取高亮图片的bounds
                returnCustomResult = params.returnCustomResult;
                if (returnCustomResult) {
                    me.url += "returnCustomResult=" + returnCustomResult;
                }
            }
            me.returnFeatureWithFieldCaption = params.returnFeatureWithFieldCaption;
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.QueryService.prototype.serviceProcessCompleted
         * @description 查询完成，执行此方法。
         * @param {Object} result - 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _Util.Util.transformResult(result);
            var geoJSONFormat = new _GeoJSON.GeoJSON();
            if (result && result.recordsets) {
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        if (me.returnFeatureWithFieldCaption === true) {
                            recordsets[i].features.map(function (feature) {
                                feature.fieldNames = recordsets[i].fieldCaptions;
                                return feature;
                            });
                        }
                        if (me.format === _REST.DataFormat.GEOJSON) {
                            recordsets[i].features = geoJSONFormat.toGeoJSON(recordsets[i].features);
                        }
                    }
                }
            }

            me.events.triggerEvent("processCompleted", {
                result: result
            });
        }

        /**
         * @function SuperMap.QueryService.prototype.getQueryParameters
         * @description 将 JSON 对象表示的查询参数转化为 QueryParameters 对象。
         * @param {Object} params - JSON 字符串表示的查询参数。
         * @returns {SuperMap.QueryParameters} 返回转化后的 QueryParameters 对象。
         */

    }, {
        key: 'getQueryParameters',
        value: function getQueryParameters(params) {
            return new _QueryParameters.QueryParameters({
                customParams: params.customParams,
                expectCount: params.expectCount,
                networkType: params.networkType,
                queryOption: params.queryOption,
                queryParams: params.queryParams,
                startRecord: params.startRecord,
                prjCoordSys: params.prjCoordSys,
                holdTime: params.holdTime
            });
        }
    }]);

    return QueryService;
}(_CommonServiceBase2.CommonServiceBase);

_SuperMap.SuperMap.QueryService = QueryService;

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.UGCSubLayer = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _UGCMapLayer2 = __webpack_require__(190);

var _JoinItem = __webpack_require__(72);

var _DatasetInfo = __webpack_require__(233);

__webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.UGCSubLayer
 * @category  iServer Map Layer
 * @classdesc 地图服务图层属性信息类。影像图层（Image）、专题图层（ServerTheme）、栅格图层（Grid）、矢量图层（Vector）等图层均继承该类。
 * @extends {SuperMap.UGCMapLayer}
 * @param {Object} options - 参数。 
 * @param {SuperMap.DatasetInfo} options.datasetInfo - 数据集信息。 
 * @param {string} [options.displayFilter] - 图层显示过滤条件。 
 * @param {SuperMap.JoinItem} [options.joinItems] - 连接信息类。 
 * @param {string} [options.representationField] - 存储制图表达信息的字段。 
 * @param {SuperMap.LayerType} [options.ugcLayerType] - 图层类型。
 */
var UGCSubLayer = exports.UGCSubLayer = function (_UGCMapLayer) {
    _inherits(UGCSubLayer, _UGCMapLayer);

    function UGCSubLayer(options) {
        _classCallCheck(this, UGCSubLayer);

        options = options || {};

        /**
         * @member {SuperMap.DatasetInfo} SuperMap.UGCSubLayer.prototype.datasetInfo
         * @description 数据集信息。
         */
        var _this = _possibleConstructorReturn(this, (UGCSubLayer.__proto__ || Object.getPrototypeOf(UGCSubLayer)).call(this, options));

        _this.datasetInfo = null;

        /**
         * @member {string} SuperMap.UGCSubLayer.prototype.displayFilter
         * @description 图层显示过滤条件。
         */
        _this.displayFilter = null;

        /**
         * @member {SuperMap.JoinItem} SuperMap.UGCSubLayer.prototype.joinItems
         * @description 连接信息类。
         */
        _this.joinItems = null;

        /**
         * @member {string} SuperMap.UGCSubLayer.prototype.representationField
         * @description 存储制图表达信息的字段。
         */
        _this.representationField = null;

        /**
         * @member {SuperMap.LayerType} SuperMap.UGCSubLayer.prototype.ugcLayerType
         * @description 图层类型。
         */
        _this.ugcLayerType = null;

        _this.CLASS_NAME = "SuperMap.UGCSubLayer";
        return _this;
    }

    /**
     * @function SuperMap.UGCSubLayer.prototype.fromJson
     * @description 将服务端 JSON 对象转换成当前客户端对象
     * @param {Object} jsonObject - 要转换的 JSON 对象。
     */


    _createClass(UGCSubLayer, [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'fromJson', this).call(this, jsonObject);
            if (this.datasetInfo) {
                this.datasetInfo = new _DatasetInfo.DatasetInfo(this.datasetInfo);
            }
            if (this.joinItems && this.joinItems.length) {
                var newJoinItems = [];
                for (var i = 0; i < this.joinItems.length; i++) {
                    newJoinItems[i] = new _JoinItem.JoinItem(this.joinItems[i]);
                }
                this.joinItems = newJoinItems;
            }
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'destroy', this).call(this);
            _Util.Util.reset(this);
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @returns {Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'toServerJSONObject', this).call(this);
            if (jsonObject.joinItems) {
                var joinItems = [];
                for (var i = 0; i < jsonObject.joinItems.length; i++) {
                    if (jsonObject.joinItems[i].toServerJSONObject) {
                        joinItems[i] = jsonObject.joinItems[i].toServerJSONObject();
                    }
                }
                jsonObject.joinItems = joinItems;
            }
            if (jsonObject.datasetInfo) {
                if (jsonObject.datasetInfo.toServerJSONObject) {
                    jsonObject.datasetInfo = jsonObject.datasetInfo.toServerJSONObject();
                }
            }
            return jsonObject;
        }
    }]);

    return UGCSubLayer;
}(_UGCMapLayer2.UGCMapLayer);

_SuperMap.SuperMap.UGCSubLayer = UGCSubLayer;

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataReturnOption = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.DataReturnOption
 * @category iServer SpatialAnalyst
 * @classdesc 数据返回设置类。
 * @param {Object} options - 参数。 
 * @param {number} [options.expectCount=1000] - 设置返回的最大记录数，小于或者等于 0 时表示返回所有记录数。 
 * @param {string} [options.dataset] - 设置结果数据集标识，当 dataReturnMode 为 {@link SuperMap.DataReturnMode.DATASET_ONLY}或{@link SuperMap.DataReturnMode.DATASET_AND_RECORDSET}时有效，
 *                                   作为返回数据集的名称。该名称用形如“数据集名称@数据源别名”形式来表示。 
 * @param {SuperMap.DataReturnMode} [options.dataReturnMode=SuperMap.DataReturnMode.RECORDSET_ONLY] - 数据返回模式。 
 * @param {boolean} [options.deleteExistResultDataset=true] - 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
 */
var DataReturnOption = exports.DataReturnOption = function () {
  function DataReturnOption(options) {
    _classCallCheck(this, DataReturnOption);

    /**
     * @member {number} [SuperMap.DataReturnOption.prototype.expectCount=1000]
     * @description 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。
     */
    this.expectCount = 1000;

    /**
     * @member {string} [SuperMap.DataReturnOption.prototype.dataset]
     * @description 设置结果数据集标识，当dataReturnMode为 {@link SuperMap.DataReturnMode.DATASET_ONLY}
     * 或{@link SuperMap.DataReturnMode.DATASET_AND_RECORDSET}时有效，
     * 作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。
     */
    this.dataset = null;

    /**
     * @member {SuperMap.DataReturnMode} [SuperMap.DataReturnOption.prototype.dataReturnMode=SuperMap.DataReturnMode.RECORDSET_ONLY]
     * @description 数据返回模式。
     */
    this.dataReturnMode = _REST.DataReturnMode.RECORDSET_ONLY;

    /**
     * @member {boolean} [SuperMap.DataReturnOption.prototype.deleteExistResultDataset=true]
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */
    this.deleteExistResultDataset = true;

    _Util.Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.DataReturnOption";
  }

  /**
   * @function SuperMap.DataReturnOption.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(DataReturnOption, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.expectCount = null;
      me.dataset = null;
      me.dataReturnMode = null;
      me.deleteExistResultDataset = null;
    }
  }]);

  return DataReturnOption;
}();

_SuperMap.SuperMap.DataReturnOption = DataReturnOption;

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Polygon = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _Collection2 = __webpack_require__(31);

__webpack_require__(23);

__webpack_require__(22);

__webpack_require__(38);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.Polygon
 * @classdesc  多边形几何对象类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.LinearRing>} components - 用来生成多边形的线环数组。
 * @example
 * var points =[new SuperMap.Geometry.Point(0,4010338),
 *      new SuperMap.Geometry.Point(1063524,4010338),
 *      new SuperMap.Geometry.Point(1063524,3150322),
 *      new SuperMap.Geometry.Point(0,3150322)
 *  ],
 *  var linearRings = new SuperMap.Geometry.LinearRing(points),
 *  var  region = new SuperMap.Geometry.Polygon([linearRings]);
 */
var Polygon = exports.Polygon = function (_Collection) {
    _inherits(Polygon, _Collection);

    function Polygon(components) {
        _classCallCheck(this, Polygon);

        /**
         * @member {Array.<string>} [SuperMap.Geometry.Polygon.prototype.componentTypes=["SuperMap.Geometry.LinearRing"]]
         * @description components 存储的的几何对象所支持的几何类型数组。
         * @readonly
         */
        var _this = _possibleConstructorReturn(this, (Polygon.__proto__ || Object.getPrototypeOf(Polygon)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.LinearRing"];
        _this.CLASS_NAME = "SuperMap.Geometry.Polygon";
        _this.geometryType = "Polygon";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Polygon.prototype.getArea
     * @description 获得区域面积，从区域的外部口径减去计此区域内部口径算所得的面积。
     * @returns {float} 几何对象的面积。
     */


    _createClass(Polygon, [{
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 0) {
                area += Math.abs(this.components[0].getArea());
                for (var i = 1, len = this.components.length; i < len; i++) {
                    area -= Math.abs(this.components[i].getArea());
                }
            }
            return area;
        }
    }]);

    return Polygon;
}(_Collection2.Collection);

_SuperMap.SuperMap.Geometry.Polygon = Polygon;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiPolygon = undefined;

var _SuperMap = __webpack_require__(0);

var _Collection2 = __webpack_require__(31);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.MultiPolygon
 * @classdesc 几何对象多多边形类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param  {Array.<SuperMap.Geometry.Polygon>} components - 形成 MultiPolygon 的多边形数组。
 * @example
 * var points1 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0)];
 * var points2 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0),new SuperMap.Geometry.Point(3,3),new SuperMap.Geometry.Point(10,10)];
 *
 * var linearRing1 = new SuperMap.Geometry.LinearRing(points1);
 * var linearRing2 = new SuperMap.Geometry.LinearRing(points2);
 *
 * var polygon1 = new SuperMap.Geometry.Polygon([linearRing1]);
 * var polygon2 = new SuperMap.Geometry.Polygon([linearRing2]);
 *
 * var multiPolygon1 = new SuperMap.Geometry.MultiPolygon([polygon1,polygon2]);
 */
var MultiPolygon = exports.MultiPolygon = function (_Collection) {
  _inherits(MultiPolygon, _Collection);

  function MultiPolygon(components) {
    _classCallCheck(this, MultiPolygon);

    /**
     * @member {Array.<string>} [SuperMap.Geometry.MultiPolygon.prototype.componentTypes=["SuperMap.Geometry.Polygon"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */
    var _this = _possibleConstructorReturn(this, (MultiPolygon.__proto__ || Object.getPrototypeOf(MultiPolygon)).call(this, components));

    _this.componentTypes = ["SuperMap.Geometry.Polygon"];
    _this.CLASS_NAME = "SuperMap.Geometry.MultiPolygon";
    _this.geometryType = "MultiPolygon";
    return _this;
  }

  return MultiPolygon;
}(_Collection2.Collection);

_SuperMap.SuperMap.Geometry.MultiPolygon = MultiPolygon;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiLineString = undefined;

var _SuperMap = __webpack_require__(0);

var _Collection2 = __webpack_require__(31);

__webpack_require__(22);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.MultiLineString
 * @classdesc 几何对象多线类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.LineString>} components - LineString 数组。
 * @example
 * var multi = new SuperMap.Geometry.MultiLineString([
 *      new SuperMap.Geometry.LineString([
 *          new SuperMap.Geometry.Point(1, 0),
 *          new SuperMap.Geometry.Point(0, 1)
 *      ])
 *  ]);
 */
var MultiLineString = exports.MultiLineString = function (_Collection) {
  _inherits(MultiLineString, _Collection);

  function MultiLineString(components) {
    _classCallCheck(this, MultiLineString);

    /**
     * @member {Array.<string>} [SuperMap.Geometry.MultiLineString.prototype.componentTypes=["SuperMap.Geometry.LineString"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */
    var _this = _possibleConstructorReturn(this, (MultiLineString.__proto__ || Object.getPrototypeOf(MultiLineString)).call(this, components));

    _this.componentTypes = ["SuperMap.Geometry.LineString"];
    _this.CLASS_NAME = "SuperMap.Geometry.MultiLineString";
    _this.geometryType = "MultiLineString";
    return _this;
  }

  return MultiLineString;
}(_Collection2.Collection);

_SuperMap.SuperMap.Geometry.MultiLineString = MultiLineString;

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ArrayExt = exports.FunctionExt = exports.NumberExt = exports.StringExt = undefined;

var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                           * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                           * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 *@namespace SuperMap
 *@category BaseTypes Namespace
 */

/**
 * @function SuperMap.inherit
 * @description 除了 C 和 P 两个必要参数外，可以传递任意数量的对象，这些对象都将继承C。
 * @memberOf SuperMap
 * @param {Object} C - 继承的类。
 * @param {Object} P - 被继承的父类。
 */
_SuperMap.SuperMap.inherit = function (C, P) {
    var F = function F() {};
    F.prototype = P.prototype;
    C.prototype = new F();
    var i, l, o;
    for (i = 2, l = arguments.length; i < l; i++) {
        o = arguments[i];
        if (typeof o === "function") {
            o = o.prototype;
        }
        _SuperMap.SuperMap.Util.extend(C.prototype, o);
    }
};

/**
 * @function SuperMap.mixin 
 * @description 实现多重继承。
 * @memberOf SuperMap
 * @param {Class|Object} ...mixins - 继承的类。
 */
_SuperMap.SuperMap.mixin = function () {
    for (var _len = arguments.length, mixins = Array(_len), _key = 0; _key < _len; _key++) {
        mixins[_key] = arguments[_key];
    }

    var Mix = function Mix(options) {
        _classCallCheck(this, Mix);

        for (var index = 0; index < mixins.length; index++) {
            copyProperties(this, new mixins[index](options));
        }
    };

    for (var index = 0; index < mixins.length; index++) {
        var mixin = mixins[index];
        copyProperties(Mix, mixin);
        copyProperties(Mix.prototype, mixin.prototype);
        copyProperties(Mix.prototype, new mixin());
    }
    return Mix;

    function copyProperties(target, source) {
        var ownKeys = Object.getOwnPropertyNames(source);
        if (Object.getOwnPropertySymbols) {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source));
        }
        for (var index = 0; index < ownKeys.length; index++) {
            var key = ownKeys[index];
            if (key !== "constructor" && key !== "prototype" && key !== "name" && key !== "length") {
                var desc = Object.getOwnPropertyDescriptor(source, key);
                if (window["ActiveXObject"]) {
                    Object.defineProperty(target, key, desc || {});
                } else {
                    Object.defineProperty(target, key, desc);
                }
            }
        }
    }
};

/**
 * @name String
 * @namespace
 * @memberOf SuperMap
 * @category BaseTypes Util
 * @description 字符串操作的一系列常用扩展函数。
 */
var StringExt = exports.StringExt = _SuperMap.SuperMap.String = {

    /**
     * @function SuperMap.String.startsWith
     * @description 判断目标字符串是否以指定的子字符串开头。
     * @param {string} str - 目标字符串。
     * @param {string} sub - 查找的子字符串。
     * @returns {boolean} 目标字符串以指定的子字符串开头，则返回 true；否则返回 false。
     */
    startsWith: function startsWith(str, sub) {
        return str.indexOf(sub) == 0;
    },

    /**
     * @function SuperMap.String.contains
     * @description 判断目标字符串是否包含指定的子字符串。
     * @param {string} str - 目标字符串。
     * @param {string} sub - 查找的子字符串。
     * @returns {boolean} 目标字符串中包含指定的子字符串，则返回 true；否则返回 false。
     */
    contains: function contains(str, sub) {
        return str.indexOf(sub) != -1;
    },

    /**
     * @function SuperMap.String.trim
     * @description 删除一个字符串的开头和结尾处的所有空白字符。
     * @param {string} str - （可能）存在空白字符填塞的字符串。
     * @returns {string} 删除开头和结尾处空白字符后的字符串。
     */
    trim: function trim(str) {
        return str.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
    },

    /**
     * @function SuperMap.String.camelize
     * @description 骆驼式("-")连字符的字符串处理。
     * 例如："chicken-head" becomes "chickenHead",
     *       "-chicken-head" becomes "ChickenHead"。
     * @param {string} str - 要处理的字符串，原始内容不应被修改。
     * @returns {string}
     */
    camelize: function camelize(str) {
        var oStringList = str.split('-');
        var camelizedString = oStringList[0];
        for (var i = 1, len = oStringList.length; i < len; i++) {
            var s = oStringList[i];
            camelizedString += s.charAt(0).toUpperCase() + s.substring(1);
        }
        return camelizedString;
    },

    /**
     * @function SuperMap.String.format
     * @description 提供带 ${token} 标记的字符串, 返回 context 对象属性中指定标记的属性值。
     * @example
     * 示例：
     * (code)
     * 1、template = "${value,getValue}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:36
     * (end)
     * 示例:
     * (code)
     * 2、template = "$${{value,getValue}}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:"${36}"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = {a: {b:"format"}};
     *         args = null;
     *       返回值:"format"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = null;
     *         args = null;
     *       返回值:"${a.b}"
     * (end)
     * @param {string} template - 带标记的字符串将要被替换。参数 template 格式为"${token}"，此处的 token 标记会替换为 context["token"] 属性的值。
     * @param {Object} [context=window] - 带有属性的可选对象的属性用于匹配格式化字符串中的标记。如果该参数为空，将使用 window 对象。
     * @param {Array} [args] - 可选参数传递给在 context 对象上找到的函数。
     * @returns {string} 从 context 对象属性中替换字符串标记位的字符串。 
     */
    format: function format(template, context, args) {
        if (!context) {
            context = window;
        }

        // Example matching:
        // str   = ${foo.bar}
        // match = foo.bar
        var replacer = function replacer(str, match) {
            var replacement;

            // Loop through all subs. Example: ${a.b.c}
            // 0 -> replacement = context[a];
            // 1 -> replacement = context[a][b];
            // 2 -> replacement = context[a][b][c];
            var subs = match.split(/\.+/);
            for (var i = 0; i < subs.length; i++) {
                if (i == 0) {
                    replacement = context;
                }

                replacement = replacement[subs[i]];
            }

            if (typeof replacement === "function") {
                replacement = args ? replacement.apply(null, args) : replacement();
            }

            // If replacement is undefined, return the string 'undefined'.
            // This is a workaround for a bugs in browsers not properly
            // dealing with non-participating groups in regular expressions:
            // http://blog.stevenlevithan.com/archives/npcg-javascript
            if (typeof replacement == 'undefined') {
                return 'undefined';
            } else {
                return replacement;
            }
        };

        return template.replace(_SuperMap.SuperMap.String.tokenRegEx, replacer);
    },

    /**
     * @member {RegExp} [SuperMap.String.tokenRegEx]
     * @description 寻找带 token 的字符串，默认为 tokenRegEx=/\$\{([\w.]+?)\}/g。
     * @example
     * Examples: ${a}, ${a.b.c}, ${a-b}, ${5}
     */
    tokenRegEx: /\$\{([\w.]+?)\}/g,

    /**
     * @member {RegExp} [SuperMap.String.numberRegEx]
     * @description 判断一个字符串是否只包含一个数值，默认为 numberRegEx=/^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/。
     */
    numberRegEx: /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,

    /**
     * @function SuperMap.String.isNumeric
     * @description 判断一个字符串是否只包含一个数值。
     * @example
     * (code)
     * SuperMap.String.isNumeric("6.02e23") // true
     * SuperMap.String.isNumeric("12 dozen") // false
     * SuperMap.String.isNumeric("4") // true
     * SuperMap.String.isNumeric(" 4 ") // false
     * (end)
     * @returns {boolean} 字符串包含唯一的数值，返回 true；否则返回 false。
     */
    isNumeric: function isNumeric(value) {
        return _SuperMap.SuperMap.String.numberRegEx.test(value);
    },

    /**
     * @function SuperMap.String.numericIf
     * @description 把一个看似数值型的字符串转化为一个数值。
     * @returns {(number|string)} 如果能转换为数值则返回数值，否则返回字符串本身。
     */
    numericIf: function numericIf(value) {
        return _SuperMap.SuperMap.String.isNumeric(value) ? parseFloat(value) : value;
    }

};

/**
 * @name Number
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 数值操作的一系列常用扩展函数。
 */
var NumberExt = exports.NumberExt = _SuperMap.SuperMap.Number = {

    /**
     * @member {string} [SuperMap.Number.decimalSeparator='.']
     * @description 格式化数字时默认的小数点分隔符。
     * @constant
     */
    decimalSeparator: ".",

    /**
     * @member {string} [SuperMap.Number.thousandsSeparator=',']
     * @description 格式化数字时默认的千位分隔符。
     * @constant
     */
    thousandsSeparator: ",",

    /**
     * @function SuperMap.Number.limitSigDigs
     * @description 限制浮点数的有效数字位数。
     * @param {number} num - 浮点数。
     * @param {integer} sig - 有效位数。
     * @returns {number} 将数字四舍五入到指定数量的有效位数。
     */
    limitSigDigs: function limitSigDigs(num, sig) {
        var fig = 0;
        if (sig > 0) {
            fig = parseFloat(num.toPrecision(sig));
        }
        return fig;
    },

    /**
     * @function SuperMap.Number.format
     * @description 数字格式化输出。
     * @param {number} num - 数字。
     * @param {integer} [dec=0]  - 数字的小数部分四舍五入到指定的位数。设置为 null 值时小数部分不变。
     * @param {string} [tsep=','] - 千位分隔符。
     * @param {string} [dsep='.'] - 小数点分隔符。
     * @returns {string} 数字格式化后的字符串。
     */
    format: function format(num, dec, tsep, dsep) {
        dec = typeof dec != "undefined" ? dec : 0;
        tsep = typeof tsep != "undefined" ? tsep : _SuperMap.SuperMap.Number.thousandsSeparator;
        dsep = typeof dsep != "undefined" ? dsep : _SuperMap.SuperMap.Number.decimalSeparator;

        if (dec != null) {
            num = parseFloat(num.toFixed(dec));
        }

        var parts = num.toString().split(".");
        if (parts.length === 1 && dec == null) {
            // integer where we do not want to touch the decimals
            dec = 0;
        }

        var integer = parts[0];
        if (tsep) {
            var thousands = /(-?[0-9]+)([0-9]{3})/;
            while (thousands.test(integer)) {
                integer = integer.replace(thousands, "$1" + tsep + "$2");
            }
        }

        var str;
        if (dec == 0) {
            str = integer;
        } else {
            var rem = parts.length > 1 ? parts[1] : "0";
            if (dec != null) {
                rem = rem + new Array(dec - rem.length + 1).join("0");
            }
            str = integer + dsep + rem;
        }
        return str;
    }
};

if (!Number.prototype.limitSigDigs) {
    /**
     * APIMethod: Number.limitSigDigs
     * 限制浮点数的有效数字位数.
     * @param {integer} sig -有效位数。
     * @returns {integer} 将数字四舍五入到指定数量的有效位数。
     *           如果传入值 为 null、0、或者是负数, 返回值 0。
     */
    Number.prototype.limitSigDigs = function (sig) {
        return NumberExt.limitSigDigs(this, sig);
    };
}

/**
 * @name Function
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 函数操作的一系列常用扩展函数。
 */
var FunctionExt = exports.FunctionExt = _SuperMap.SuperMap.Function = {
    /**
     * @function SuperMap.Function.bind
     * @description 绑定函数到对象。方便创建 this 的作用域。
     * @param {function} func - 输入函数。
     * @param {Object} object - 对象绑定到输入函数（作为输入函数的 this 对象）。
     * @returns {function} object 参数作为 func 函数的 this 对象。
     */
    bind: function bind(func, object) {
        // create a reference to all arguments past the second one
        var args = Array.prototype.slice.apply(arguments, [2]);
        return function () {
            // Push on any additional arguments from the actual function call.
            // These will come after those sent to the bind call.
            var newArgs = args.concat(Array.prototype.slice.apply(arguments, [0]));
            return func.apply(object, newArgs);
        };
    },

    /**
     * @function SuperMap.Function.bindAsEventListener
     * @description 绑定函数到对象，在调用该函数时配置并使用事件对象作为第一个参数。
     * @param {function} func - 用于监听事件的函数。
     * @param {Object} object - this 对象的引用。
     * @returns {function}
     */
    bindAsEventListener: function bindAsEventListener(func, object) {
        return function (event) {
            return func.call(object, event || window.event);
        };
    },

    /**
     * @function SuperMap.Function.False
     * @description 该函数仅仅返回 false。该函数主要是避免在 IE8 以下浏览中 DOM 事件句柄的匿名函数问题。
     * @example
     * document.onclick = SuperMap.Function.False;
     * @returns {boolean}
     */
    False: function False() {
        return false;
    },

    /**
     * @function SuperMap.Function.True
     * @description 该函数仅仅返回 true。该函数主要是避免在 IE8 以下浏览中 DOM 事件句柄的匿名函数问题。
     * @example
     * document.onclick = SuperMap.Function.True;
     * @returns {boolean}
     */
    True: function True() {
        return true;
    },

    /**
     * @function SuperMap.Function.Void
     * @description 可重用函数，仅仅返回 "undefined"。
     * @returns {undefined}
     */
    Void: function Void() {}

};

/**
 * @name Array
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 数组操作的一系列常用扩展函数。
 */
var ArrayExt = exports.ArrayExt = _SuperMap.SuperMap.Array = {

    /**
     * @function SuperMap.Array.filter
     * @description 过滤数组，提供了 ECMA-262 标准中 Array.prototype.filter 函数的扩展。详见：{@link http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/filter}
     * @param {Array} array - 要过滤的数组。
     * @param {function} callback - 数组中的每一个元素调用该函数。</br>
     *     如果函数的返回值为 true，该元素将包含在返回的数组中。该函数有三个参数: 数组中的元素，元素的索引，数组自身。</br>
     *     如果设置了可选参数 caller，在调用 callback 时，使用可选参数 caller 设置为 callback 的参数。</br>
     * @param {Object} [caller] - 在调用 callback 时，使用参数 caller 设置为 callback 的参数。
     * @returns {Array} callback 函数返回 true 时的元素将作为返回数组中的元素。
     */
    filter: function filter(array, callback, caller) {
        var selected = [];
        if (Array.prototype.filter) {
            selected = array.filter(callback, caller);
        } else {
            var len = array.length;
            if (typeof callback != "function") {
                throw new TypeError();
            }
            for (var i = 0; i < len; i++) {
                if (i in array) {
                    var val = array[i];
                    if (callback.call(caller, val, i, array)) {
                        selected.push(val);
                    }
                }
            }
        }
        return selected;
    }

};

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.GeoFeature = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(4);

var _iclientCommon = __webpack_require__(5);

var _ThemeLayer = __webpack_require__(79);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class mapboxgl.supermap.GeoFeatureThemeLayer
 * @category Visualization Theme
 * @classdesc 地理几何专题要素型专题图层。
 * @param {string} name - 图层名。
 * @param {Object} opt_options - 参数。
 * @param {mapboxgl.Map} opt_options.map - 当前 mapboxgl map 对象。
 * @param {string} [opt_options.id] - 专题图层 ID。默认使用 CommonUtil.createUniqueID("themeLayer_") 创建专题图层 ID。
 * @param {boolean} [opt_options.loadWhileAnimating=true] - 是否实时重绘。
 * @param {number} [opt_options.nodesClipPixel=2] - 节点抽稀像素距离。
 * @param {boolean} [opt_options.isHoverAble=false] - 图形是否在 hover 时高亮。
 * @param {boolean} [opt_options.isMultiHover=false] - 是否多图形同时高亮，用于高亮同一个数据对应的所有图形（如：多面）。
 * @param {boolean} [opt_options.isClickAble=true] - 图形是否可点击。
 * @param {boolean} [opt_options.isAllowFeatureStyle=false] -  是否允许 feature 样式（style） 中的有效属性应用到专题图层。
 *                                        禁止对专题要素使用数据（feature）的 style。
 *                                        此属性可强制将数据 feature 的 style 中有效属性应用到专题要素上，且拥有比图层 style 和 styleGroups 更高的优先级，使专题要素
 *                                        的样式脱离专题图层的控制。可以通过此方式实现对特殊数据（feature） 对应专题要素赋予独立 style。
 * @param {number} [opt_options.opacity=1] - 图层透明度。
 * @extends {mapboxgl.supermap.ThemeLayer}
 * @fires mapboxgl.supermap.GeoFeatureThemeLayer#beforefeaturesadded
 */

var GeoFeature = exports.GeoFeature = function (_Theme) {
    _inherits(GeoFeature, _Theme);

    function GeoFeature(name, opt_options) {
        _classCallCheck(this, GeoFeature);

        /**
         * @member {string} mapboxgl.supermap.GeoFeatureThemeLayer.prototype.name 
         * @description 专题图图层名称。
         */
        var _this = _possibleConstructorReturn(this, (GeoFeature.__proto__ || Object.getPrototypeOf(GeoFeature)).call(this, name, opt_options));

        _this.name = null;
        /**
         * @member {SuperMap.ThemeStyle} mapboxgl.supermap.GeoFeatureThemeLayer.prototype.style 
         * @description 专题图图层全局样式。
         */
        _this.style = null;

        /**
         * @member {SuperMap.ThemeStyle} mapboxgl.supermap.GeoFeatureThemeLayer.prototype.highlightStyle 
         * @description 专题图图层高亮样式。
         */
        _this.highlightStyle = null;

        /**
         * @member {number} [mapboxgl.supermap.GeoFeatureThemeLayer.prototype.nodesClipPixel=2]
         * @description 节点抽稀像素距离。
         */
        _this.nodesClipPixel = 2;

        /**
         * @member {boolean} [mapboxgl.supermap.GeoFeatureThemeLayer.prototype.isHoverAble=false]
         * @description 图形是否在 hover 时高亮。
         */
        _this.isHoverAble = false;
        /**
         * @member {boolean} [mapboxgl.supermap.GeoFeatureThemeLayer.prototype.isMultiHover=false]
         * @description 是否多图形同时高亮，用于高亮同一个数据对应的所有图形（如：多面）。
         */
        _this.isMultiHover = false;
        /**
         * @member {boolean} [mapboxgl.supermap.GeoFeatureThemeLayer.prototype.isClickAble=true] 
         * @description  图形是否可点击。
         */
        _this.isClickAble = true;

        /**
         * @member {boolean} [mapboxgl.supermap.GeoFeatureThemeLayer.prototype.isAllowFeatureStyle=false]
         * @description  是否允许 feature 样式（style） 中的有效属性应用到专题图层。</br>
         *               禁止对专题要素使用数据（feature）的 style。此属性可强制将数据 feature 的 style 中有效属性应用到专题要素上，且拥有比图层 style 和 styleGroups 更高的优先级，使专题要素
         *               的样式脱离专题图层的控制。可以通过此方式实现对特殊数据（feature） 对应专题要素赋予独立 style。
         */
        _this.isAllowFeatureStyle = false;
        _iclientCommon.CommonUtil.extend(_this, opt_options);
        _this.cache = opt_options.cache || {};
        _this.cacheFields = opt_options.cacheFields || [];
        _this.maxCacheCount = opt_options.maxCacheCount || 0;
        _this.isCustomSetMaxCacheCount = opt_options.isCustomSetMaxCacheCount === undefined ? false : opt_options.isCustomSetMaxCacheCount;

        return _this;
    }

    /**
     * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.addFeatures
     * @description 添加要素。
     * @param {mapboxgl.supermap.ThemeFeature|SuperMap.ServerFeature} features - 要素对象。
     */


    _createClass(GeoFeature, [{
        key: 'addFeatures',
        value: function addFeatures(features) {
            /**
             * @event mapboxgl.supermap.GeoFeatureThemeLayer#beforefeaturesadded
             * @description 要素添加之前触发。
             * @property {mapboxgl.supermap.ThemeFeature|SuperMap.ServerFeature} features - 被添加的要素。
             */
            _mapboxGl2.default.Evented.prototype.fire('beforefeaturesadded', { features: features });
            //转换 features 形式
            this.features = this.toiClientFeature(features);

            if (!this.isCustomSetMaxCacheCount) {
                this.maxCacheCount = this.features.length * 5;
            }
            //绘制专题要素
            if (this.renderer) {
                this.redrawThematicFeatures(this.map.getBounds());
            }
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.removeFeatures
         * @description 从专题图中删除 feature。这个函数删除所有传递进来的矢量要素。
         * @param {SuperMap.Feature.Vector} features - 要删除的要素对象。
         */

    }, {
        key: 'removeFeatures',
        value: function removeFeatures(features) {
            // eslint-disable-line no-unused-vars
            this.clearCache();
            _ThemeLayer.Theme.prototype.removeFeatures.apply(this, arguments);
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.removeAllFeatures
         * @description 清除当前图层所有的矢量要素。
         */

    }, {
        key: 'removeAllFeatures',
        value: function removeAllFeatures() {
            this.clearCache();
            _ThemeLayer.Theme.prototype.removeAllFeatures.apply(this, arguments);
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.redrawThematicFeatures
         * @description 重绘所有专题要素。
         * @param {mapboxgl.LngLatBounds} extent - 重绘的范围。
         */

    }, {
        key: 'redrawThematicFeatures',
        value: function redrawThematicFeatures(extent) {
            // eslint-disable-line no-unused-vars
            this.clearCache();
            //获取高亮专题要素对应的用户 id
            var hoverone = this.renderer.getHoverOne();
            var hoverFid = null;
            if (hoverone && hoverone.refDataID) {
                hoverFid = hoverone.refDataID;
            }
            //清除当前所有可视元素
            this.renderer.clearAll();

            var features = this.features;
            var cache = this.cache;
            var cacheFields = this.cacheFields;
            var cmZoom = this.map.getZoom();

            var maxCC = this.maxCacheCount;

            for (var i = 0, len = features.length; i < len; i++) {
                var feature = features[i];
                // var feaBounds = feature.geometry.getBounds();
                //
                // //剔除当前视图（地理）范围以外的数据
                // if (extent) {
                //     var bounds = new SuperMap.Bounds(extent.getWest(), extent.getSouth(), extent.getEast(), extent.getNorth());
                //     // if (!bounds.intersectsBounds(feaBounds)) continue;
                // }

                //缓存字段
                var fields = feature.id + "_zoom_" + cmZoom.toString();

                var thematicFeature;

                //判断专题要素缓存是否存在
                if (cache[fields]) {
                    cache[fields].updateAndAddShapes();
                } else {
                    //如果专题要素缓存不存在，创建专题要素
                    thematicFeature = this.createThematicFeature(features[i]);

                    //检查 thematicFeature 是否有可视化图形
                    if (thematicFeature.getShapesCount() < 1) {
                        continue;
                    }

                    //加入缓存
                    cache[fields] = thematicFeature;
                    cacheFields.push(fields);

                    //缓存数量限制
                    if (cacheFields.length > maxCC) {
                        var fieldsTemp = cacheFields[0];
                        cacheFields.splice(0, 1);
                        delete cache[fieldsTemp];
                    }
                }
            }
            this.renderer.render();

            //地图漫游后，重新高亮图形
            if (hoverFid && this.isHoverAble && this.isMultiHover) {
                var hShapes = this.getShapesByFeatureID(hoverFid);
                this.renderer.updateHoverShapes(hShapes);
            }
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.createThematicFeature
         * @description 创建专题要素。
         * @param {SuperMap.Feature.Vector} feature - 要素对象。
         */

    }, {
        key: 'createThematicFeature',
        value: function createThematicFeature(feature) {
            var style = _iclientCommon.CommonUtil.copyAttributesWithClip(this.style);
            if (feature.style && this.isAllowFeatureStyle === true) {
                style = _iclientCommon.CommonUtil.copyAttributesWithClip(feature.style);
            }
            //创建专题要素时的可选参数
            var options = {};
            options.nodesClipPixel = this.nodesClipPixel;
            options.isHoverAble = this.isHoverAble;
            options.isMultiHover = this.isMultiHover;
            options.isClickAble = this.isClickAble;
            options.highlightStyle = _iclientCommon.ShapeFactory.transformStyle(this.highlightStyle);
            //将数据转为专题要素（Vector）
            var thematicFeature = new _iclientCommon.ThemeVector(feature, this, _iclientCommon.ShapeFactory.transformStyle(style), options);
            //直接添加图形到渲染器
            for (var m = 0; m < thematicFeature.shapes.length; m++) {
                this.renderer.addShape(thematicFeature.shapes[m]);
            }
            return thematicFeature;
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.clearCache
         * @description 清除缓存。
         */

    }, {
        key: 'clearCache',
        value: function clearCache() {
            this.cache = {};
            this.cacheFields = [];
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.clear
         * @description  清除的内容包括数据（features）、专题要素和缓存。
         */

    }, {
        key: 'clear',
        value: function clear() {
            this.renderer.clearAll();
            this.renderer.refresh();
            this.removeAllFeatures();
            this.clearCache();
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.getCacheCount
         * @description 获取当前缓存数量。
         * @returns {number} 当前缓存数量。
         */

    }, {
        key: 'getCacheCount',
        value: function getCacheCount() {
            return this.cacheFields.length;
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.setMaxCacheCount
         * @param {number} [cacheCount] - 缓存总数。
         * @description 设置最大缓存条数。
         */

    }, {
        key: 'setMaxCacheCount',
        value: function setMaxCacheCount(cacheCount) {
            if (!isNaN(cacheCount)) {
                this.maxCacheCount = cacheCount;
                this.isCustomSetMaxCacheCount = true;
            }
        }

        /**
         * @function mapboxgl.supermap.GeoFeatureThemeLayer.prototype.setMaxCacheCount
         * @param {number} [featureID=si.refDataID] - 要素 ID。
         * @description 通过 FeatureID 获取 feature 关联的所有图形。如果不传入此参数，函数将返回所有图形。
         */

    }, {
        key: 'getShapesByFeatureID',
        value: function getShapesByFeatureID(featureID) {
            var list = [];
            var shapeList = this.renderer.getAllShapes();
            if (!featureID) {
                return shapeList;
            }
            for (var i = 0, len = shapeList.length; i < len; i++) {
                var si = shapeList[i];
                if (si.refDataID && featureID === si.refDataID) {
                    list.push(si);
                }
            }
            return list;
        }
    }]);

    return GeoFeature;
}(_ThemeLayer.Theme);

_mapboxGl2.default.supermap.GeoFeatureThemeLayer = GeoFeature;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
/**
 * 该文件用于存储一些公用常量
 *
 */
var FileTypes = exports.FileTypes = {
    EXCEL: "EXCEL",
    CSV: "CSV",
    ISERVER: "ISERVER",
    GEOJSON: "GEOJSON",
    JSON: 'JSON'
};
var FileConfig = exports.FileConfig = {
    fileMaxSize: 10 * 1024 * 1024
};

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Theme = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Point = __webpack_require__(23);

var _GeoText = __webpack_require__(109);

var _LonLat = __webpack_require__(44);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class  SuperMap.Feature.Theme
 * @category Visualization Theme
 * @classdesc 专题要素基类，此类不可实例化。
 */
var Theme = exports.Theme = function () {

  /**
   * @function SuperMap.Feature.Theme.prototype.constructor
   * @description 构造函数。
   * @param {Object} data - 用户数据，用于生成可视化 shape，必设参数。
   * @param {SuperMap.Layer.Theme} layer - 此专题要素所在图层，必设参数。
   * @returns {SuperMap.Feature.Theme} 返回一个专题要素。
   */
  function Theme(data, layer) {
    _classCallCheck(this, Theme);

    if (!data) {
      return;
    }
    // layer 必须已经添加到地图, 且已初始化渲染器
    if (!layer || !layer.map || !layer.renderer) {
      return;
    }

    /**
     * @member {string} SuperMap.Feature.Theme.prototype.id
     * @description 专题要素唯一标识。
     */
    this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");

    /**
     * @member {SuperMap.LonLat} SuperMap.Feature.Theme.prototype.lonlat
     * @description 专题要素地理参考位置。子类中必须根据用户数据（或地理位置参数）对其赋值。
     */
    this.lonlat = null;

    /**
     * @member {Array} SuperMap.Feature.Theme.prototype.location
     * @description 专题要素像素参考位置。通常由地理参考位置决定。长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */
    this.location = [];

    /**
     * @readonly
     * @member {Object} SuperMap.Feature.Theme.prototype.data
     * @description 用户数据，用于生成可视化 shape，可在子类中规定数据格式或类型，如：<SuperMap.Feature.Vector>。
     */
    this.data = data;

    /**
     * @readonly
     * @member {Array} SuperMap.Feature.Theme.prototype.shapes
     * @description 构成此专题要素的可视化图形对象数组，数组顺序控制渲染。
     */
    this.shapes = [];

    /**
     * @readonly
     * @member {SuperMap.Layer.Theme} SuperMap.Feature.Theme.prototype.layer
     * @description 此专题要素所在专题图层。
     */
    this.layer = layer;

    this.CLASS_NAME = "SuperMap.Feature.Theme";
  }

  /**
   * @function SuperMap.Feature.Theme.prototype.destroy
   * @description 销毁专题要素。
   */


  _createClass(Theme, [{
    key: 'destroy',
    value: function destroy() {
      this.data = null;
      this.id = null;
      this.lonlat = null;
      this.location = null;
      this.shapes = null;
      this.layer = null;
    }

    /**
     * @function SuperMap.Feature.Theme.prototype.getLocalXY
     * @description 地理坐标转为像素坐标。
     * @param {(SuperMap.Geometry.Point|SuperMap.Geometry.GeoText|SuperMap.LonLat)} coordinate - 地理坐标点。
     * @returns {Array} 长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */

  }, {
    key: 'getLocalXY',
    value: function getLocalXY(coordinate) {
      var resolution = this.layer.map.getResolution();
      var extent = this.layer.map.getExtent();

      if (coordinate instanceof _Point.Point || coordinate instanceof _GeoText.GeoText) {
        var x = coordinate.x / resolution + -extent.left / resolution;
        var y = extent.top / resolution - coordinate.y / resolution;
        return [x, y];
      } else if (coordinate instanceof _LonLat.LonLat) {
        var _x = coordinate.lon / resolution + -extent.left / resolution;
        var _y = extent.top / resolution - coordinate.lat / resolution;
        return [_x, _y];
      } else {
        return null;
      }
    }
  }]);

  return Theme;
}();

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.Theme = Theme;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmicPolygon = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _Shape2 = __webpack_require__(12);

var _Util = __webpack_require__(1);

var _SUtil = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicPolygon
 * @category Visualization Theme
 * @classdesc 多边形。
 * @extends SuperMap.LevelRenderer.Shape
 * @example
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicPolygon({
 *         style: {
 *             // 100x100 的正方形
 *             pointList: [[0, 0], [100, 0], [100, 100], [0, 100]],
 *             color: 'blue'
 *         }
 *   });
 *   levelRenderer.addShape(shape);
 *
 */
var SmicPolygon = exports.SmicPolygon = function (_Shape) {
    _inherits(SmicPolygon, _Shape);

    /**
     * @member {Object} SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.style
     * @description 绘制样式。
     *
     * @param {Array} pointList - 节点数组，二维数组。默认值：null，必设参数。其形式如下：
     * (code)
     * (start code)
     *  [
     *  [10, 20],         //单个节点
     *  [30, 40],
     *  [25, 30]
     *   ]
     * (end)
     * @param {string} style.smooth - 是否做平滑插值, 平滑算法可以选择 "bezier", "spline"。默认值："";
     * @param {number} style.smoothConstraint - 平滑约束。
     * @param {string} style.brushType - 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * @param {string} style.color - 填充颜色。默认值："#000000'"。
     * @param {string} style.strokeColor - 描边颜色。默认值："#000000'"。
     * @param {string} style.lineCape - 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * @param {number} style.lineWidth - 描边宽度。默认值：1。
     * @param {number} style.opacity - 绘制透明度。默认值：1。
     * @param {number} style.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
     * @param {number} style.shadowColor - 阴影颜色。默认值："#000000'"。
     * @param {number} style.shadowOffsetX - 阴影横向偏移。默认值：0。
     * @param {number} style.shadowOffsetY - 阴影纵向偏移。默认值：0。
     * @param {string} style.text - 图形中的附加文本。默认值：""。
     * @param {string} style.textColor - 文本颜色。默认值："#000000'"。
     * @param {string} style.textFont - 附加文本样式。示例:'bold 18px verdana'。
     * @param {string} style.textPosition - 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * @param {string} style.textAlign - 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * @param {string} style.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */
    //打开接口 style

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicPolygon.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function SmicPolygon(options) {
        _classCallCheck(this, SmicPolygon);

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.type
         * @description 图形类型.
         */
        var _this = _possibleConstructorReturn(this, (SmicPolygon.__proto__ || Object.getPrototypeOf(SmicPolygon)).call(this, options));

        _this.type = 'smicpolygon';

        /**
         * @member {Array} SuperMap.LevelRenderer.Shape.SmicPolygon.prototype._holePolygonPointList
         * @description 岛洞面多边形顶点数组（三维数组）
         *
         */
        _this.holePolygonPointLists = null;

        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) {
            _this.refOriginalPosition = [0, 0];
        }
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicPolygon";
        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(SmicPolygon, [{
        key: 'destroy',
        value: function destroy() {
            this.type = null;
            this.holePolygonPointLists = null;
            _get(SmicPolygon.prototype.__proto__ || Object.getPrototypeOf(SmicPolygon.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.brush
         * @description 笔触。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {boolean} isHighlight - 是否使用高亮属性。
         *
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }

            var style = this.style;
            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {});
            }

            ctx.save();
            this.setContext(ctx, style);

            // 设置 transform
            this.setTransform(ctx);

            // 先 fill 再stroke
            var hasPath = false;
            if (style.brushType == 'fill' || style.brushType == 'both' || typeof style.brushType == 'undefined') {
                // 默认为fill
                ctx.beginPath();
                if (style.lineType == 'dashed' || style.lineType == 'dotted' || style.lineType == 'dot' || style.lineType == 'dash' || style.lineType == 'dashdot' || style.lineType == 'longdash' || style.lineType == 'longdashdot') {
                    // 特殊处理，虚线围不成path，实线再build一次
                    this.buildPath(ctx, {
                        lineType: 'solid',
                        lineWidth: style.lineWidth,
                        pointList: style.pointList
                    });
                } else {
                    this.buildPath(ctx, style);
                    hasPath = true; // 这个path能用
                }
                ctx.closePath();
                this.setCtxGlobalAlpha(ctx, "fill", style);
                ctx.fill();
                this.setCtxGlobalAlpha(ctx, "reset", style);
            }

            if (style.lineWidth > 0 && (style.brushType == 'stroke' || style.brushType == 'both')) {
                if (!hasPath) {
                    ctx.beginPath();
                    this.buildPath(ctx, style);
                }
                this.setCtxGlobalAlpha(ctx, "stroke", style);
                ctx.stroke();
                this.setCtxGlobalAlpha(ctx, "reset", style);
            }

            this.drawText(ctx, style, this.style);

            //岛洞
            var hpStyle = _Util.Util.cloneObject(style);

            if (hpStyle.pointList) {
                if (this.holePolygonPointLists && this.holePolygonPointLists.length > 0) {
                    var holePLS = this.holePolygonPointLists;
                    var holePLSen = holePLS.length;
                    for (var i = 0; i < holePLSen; i++) {
                        var holePL = holePLS[i];
                        //岛洞面
                        hpStyle.pointList = holePL;

                        ctx.globalCompositeOperation = "destination-out";
                        // 先 fill 再stroke
                        hasPath = false;
                        if (hpStyle.brushType == 'fill' || hpStyle.brushType == 'both' || typeof hpStyle.brushType == 'undefined') {
                            // 默认为fill
                            ctx.beginPath();
                            if (hpStyle.lineType == 'dashed' || hpStyle.lineType == 'dotted' || hpStyle.lineType == 'dot' || hpStyle.lineType == 'dash' || hpStyle.lineType == 'dashdot' || hpStyle.lineType == 'longdash' || hpStyle.lineType == 'longdashdot') {
                                // 特殊处理，虚线围不成path，实线再build一次
                                this.buildPath(ctx, {
                                    lineType: 'solid',
                                    lineWidth: hpStyle.lineWidth,
                                    pointList: hpStyle.pointList
                                });
                            } else {
                                this.buildPath(ctx, hpStyle);
                                hasPath = true; // 这个path能用
                            }
                            ctx.closePath();
                            this.setCtxGlobalAlpha(ctx, "fill", hpStyle);
                            ctx.fill();
                            this.setCtxGlobalAlpha(ctx, "reset", hpStyle);
                        }

                        if (hpStyle.lineWidth > 0 && (hpStyle.brushType == 'stroke' || hpStyle.brushType == 'both')) {
                            if (!hasPath) {
                                ctx.beginPath();
                                this.buildPath(ctx, hpStyle);
                            }
                            //如果描边，先回复 globalCompositeOperation 默认值再描边。
                            ctx.globalCompositeOperation = "source-over";
                            this.setCtxGlobalAlpha(ctx, "stroke", hpStyle);
                            ctx.stroke();
                            this.setCtxGlobalAlpha(ctx, "reset", hpStyle);
                        } else {
                            ctx.globalCompositeOperation = "source-over";
                        }
                    }
                }
            }
            ctx.restore();
            return;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.buildPath
         * @description 创建多边形路径。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - style。
         *
         */

    }, {
        key: 'buildPath',
        value: function buildPath(ctx, style) {
            if (style.showShadow) {
                ctx.shadowBlur = style.shadowBlur;
                ctx.shadowColor = style.shadowColor;
                ctx.shadowOffsetX = style.shadowOffsetX;
                ctx.shadowOffsetY = style.shadowOffsetY;
            }
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            // 虽然能重用 brokenLine，但底层图形基于性能考虑，重复代码减少调用吧
            var pointList = style.pointList;

            if (pointList.length < 2) {
                // 少于2个点就不画了~
                return;
            }

            if (style.smooth && style.smooth !== 'spline') {
                var controlPoints = _SUtil.SUtil.SUtil_smoothBezier(pointList, style.smooth, true, style.smoothConstraint, __OP);

                ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                var cp1;
                var cp2;
                var p;
                var len = pointList.length;
                for (var i = 0; i < len; i++) {
                    cp1 = controlPoints[i * 2];
                    cp2 = controlPoints[i * 2 + 1];
                    p = [pointList[(i + 1) % len][0] + __OP[0], pointList[(i + 1) % len][1] + __OP[1]];
                    ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], p[0], p[1]);
                }
            } else {
                if (style.smooth === 'spline') {
                    pointList = _SUtil.SUtil.SUtil_smoothSpline(pointList, true, null, __OP);
                }

                if (!style.lineType || style.lineType == 'solid') {
                    // 默认为实线
                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var _i = 1; _i < pointList.length; _i++) {
                        ctx.lineTo(pointList[_i][0] + __OP[0], pointList[_i][1] + __OP[1]);
                    }
                    ctx.lineTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                } else if (style.lineType === 'dashed' || style.lineType === 'dotted' || style.lineType === 'dot' || style.lineType === 'dash' || style.lineType === 'longdash') {
                    // SMIC-方法修改 - start
                    var dashLengthForStyle = style._dashLength || (style.lineWidth || 1) * (style.lineType == 'dashed' ? 5 : 1);
                    style._dashLength = dashLengthForStyle;

                    var dashLength = style.lineWidth || 1;
                    var pattern1 = dashLength;
                    var pattern2 = dashLength;

                    //dashed
                    if (style.lineType === 'dashed') {
                        pattern1 *= 5;
                        pattern2 *= 5;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    //dotted
                    if (style.lineType === 'dotted') {
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 = 1;
                            pattern2 += dashLength;
                        }
                    }

                    //dot
                    if (style.lineType === 'dot') {
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 = 1;
                            pattern2 += dashLength;
                        }
                    }

                    //dash
                    if (style.lineType === 'dash') {
                        pattern1 *= 4;
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    //longdash
                    if (style.lineType === 'longdash') {
                        pattern1 *= 8;
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var _i2 = 1; _i2 < pointList.length; _i2++) {
                        _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[_i2 - 1][0] + __OP[0], pointList[_i2 - 1][1] + __OP[1], pointList[_i2][0] + __OP[0], pointList[_i2][1] + __OP[1], dashLength, [pattern1, pattern2]);
                    }
                    _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[pointList.length - 1][0] + __OP[0], pointList[pointList.length - 1][1] + __OP[1], pointList[0][0] + __OP[0], pointList[0][1] + __OP[1], dashLength, [pattern1, pattern2]);
                } else if (style.lineType === 'dashdot' || style.lineType === 'longdashdot') {
                    var _dashLengthForStyle = style._dashLength || (style.lineWidth || 1) * (style.lineType == 'dashed' ? 5 : 1);
                    style._dashLength = _dashLengthForStyle;

                    var _dashLength = style.lineWidth || 1;
                    var _pattern = _dashLength;
                    var _pattern2 = _dashLength;
                    var pattern3 = _dashLength;
                    var pattern4 = _dashLength;

                    //dashdot
                    if (style.lineType === 'dashdot') {
                        _pattern *= 4;
                        _pattern2 *= 4;
                        pattern4 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            _pattern -= _dashLength;
                            _pattern2 += _dashLength;
                            pattern3 = 1;
                            pattern4 += _dashLength;
                        }
                    }

                    //longdashdot
                    if (style.lineType === 'longdashdot') {
                        _pattern *= 8;
                        _pattern2 *= 4;
                        pattern4 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            _pattern -= _dashLength;
                            _pattern2 += _dashLength;
                            pattern3 = 1;
                            pattern4 += _dashLength;
                        }
                    }

                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var _i3 = 1; _i3 < pointList.length; _i3++) {
                        _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[_i3 - 1][0] + __OP[0], pointList[_i3 - 1][1] + __OP[1], pointList[_i3][0] + __OP[0], pointList[_i3][1] + __OP[1], _dashLength, [_pattern, _pattern2, pattern3, pattern4]);
                    }
                    _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[pointList.length - 1][0] + __OP[0], pointList[pointList.length - 1][1] + __OP[1], pointList[0][0] + __OP[0], pointList[0][1] + __OP[1], _dashLength, [_pattern, _pattern2, pattern3, pattern4]);
                }
            }
            return;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicPolygon.prototype.getRect
         * @description 计算返回多边形包围盒矩阵。该包围盒是直接从四个控制点计算，并非最小包围盒。
         * 
         * @param {Object} style - style
         * @return {Object} 边框对象。包含属性：x，y，width，height。
         * 
         */

    }, {
        key: 'getRect',
        value: function getRect(style, refOriginalPosition) {
            var __OP;
            if (!refOriginalPosition) {
                if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                    this.refOriginalPosition = [0, 0];
                }
                __OP = this.refOriginalPosition;
            } else {
                __OP = refOriginalPosition;
            }

            if (style.__rect) {
                return style.__rect;
            }

            var minX = Number.MAX_VALUE;
            var maxX = Number.MIN_VALUE;
            var minY = Number.MAX_VALUE;
            var maxY = Number.MIN_VALUE;

            var pointList = style.pointList;
            for (var i = 0, l = pointList.length; i < l; i++) {
                if (pointList[i][0] + __OP[0] < minX) {
                    minX = pointList[i][0] + __OP[0];
                }
                if (pointList[i][0] + __OP[0] > maxX) {
                    maxX = pointList[i][0] + __OP[0];
                }
                if (pointList[i][1] + __OP[1] < minY) {
                    minY = pointList[i][1] + __OP[1];
                }
                if (pointList[i][1] + __OP[1] > maxY) {
                    maxY = pointList[i][1] + __OP[1];
                }
            }

            var lineWidth;
            if (style.brushType == 'stroke' || style.brushType == 'fill') {
                lineWidth = style.lineWidth || 1;
            } else {
                lineWidth = 0;
            }

            style.__rect = {
                x: Math.round(minX - lineWidth / 2),
                y: Math.round(minY - lineWidth / 2),
                width: maxX - minX + lineWidth,
                height: maxY - minY + lineWidth
            };
            return style.__rect;
        }
    }]);

    return SmicPolygon;
}(_Shape2.Shape);

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
var Config = exports.Config = function Config() {
    _classCallCheck(this, Config);
};
/**
 * @enum EVENT
 * @description 事件
 * @type {Object}
 * @private 
 */


Config.EVENT = {
    //窗口大小变化
    RESIZE: 'resize',

    //鼠标按钮被（手指）按下，事件对象是：目标图形元素或空
    CLICK: 'click',

    //双击事件
    DBLCLICK: 'dblclick',

    //鼠标滚轮变化，事件对象是：目标图形元素或空
    MOUSEWHEEL: 'mousewheel',

    //鼠标（手指）被移动，事件对象是：目标图形元素或空
    MOUSEMOVE: 'mousemove',

    //鼠标移到某图形元素之上，事件对象是：目标图形元素
    MOUSEOVER: 'mouseover',

    //鼠标从某图形元素移开，事件对象是：目标图形元素
    MOUSEOUT: 'mouseout',

    //鼠标按钮（手指）被按下，事件对象是：目标图形元素或空
    MOUSEDOWN: 'mousedown',

    //鼠标按键（手指）被松开，事件对象是：目标图形元素或空
    MOUSEUP: 'mouseup',

    //全局离开，MOUSEOUT触发比较频繁，一次离开优化绑定
    GLOBALOUT: 'globalout',

    // 一次成功元素拖拽的行为事件过程是：
    // dragstart > dragenter > dragover [> dragleave] > drop > dragend

    //开始拖拽时触发，事件对象是：被拖拽图形元素
    DRAGSTART: 'dragstart',

    //拖拽完毕时触发（在drop之后触发），事件对象是：被拖拽图形元素
    DRAGEND: 'dragend',

    //拖拽图形元素进入目标图形元素时触发，事件对象是：目标图形元素
    DRAGENTER: 'dragenter',

    //拖拽图形元素在目标图形元素上移动时触发，事件对象是：目标图形元素
    DRAGOVER: 'dragover',

    //拖拽图形元素离开目标图形元素时触发，事件对象是：目标图形元素
    DRAGLEAVE: 'dragleave',

    //拖拽图形元素放在目标图形元素内时触发，事件对象是：目标图形元素
    DROP: 'drop',

    //touch end - start < delay is click
    touchClickDelay: 300
};

/**
 * @enum catchBrushException
 * @description 是否异常捕获
 * @type {boolean}
 * @private 
 */
Config.catchBrushException = false;

/**
 * @enum debugMode
 * @description debug 日志选项：catchBrushException 为 true 下有效。
 * 0 : 不生成debug数据，发布用
 * 1 : 异常抛出，调试用
 * 2 : 控制台输出，调试用
 * @type {boolean}
 * @private 
 */
Config.debugMode = 0;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
/**
 * @private
 * @class  SuperMap.LevelRenderer.Tool.Vector
 * @category Visualization Theme
 * @classdesc LevelRenderer 二维向量类
 *
 */
var Vector = exports.Vector = function () {

    /**
     * @function SuperMap.LevelRenderer.Tool.Vector.constructor
     * @description 构造函数
     */
    function Vector() {
        _classCallCheck(this, Vector);

        this.ArrayCtor = typeof Float32Array === 'undefined' ? Array : Float32Array;

        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Vector";
    }

    /**
     * @function SuperMap.LevelRenderer.Tool.Vector.prototype.create
     * @description 创建一个向量。
     * 
     * @param {number} x - x坐标
     * @param {number} y - Y坐标
     * @return {Vector2} 向量。
     */


    _createClass(Vector, [{
        key: "create",
        value: function create(x, y) {
            var ArrayCtor = this.ArrayCtor;

            var out = new ArrayCtor(2);
            out[0] = x || 0;
            out[1] = y || 0;

            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.copy
         * @description 复制一个向量。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v - 向量。
         * @return {Vector2} 克隆向量。
         */

    }, {
        key: "copy",
        value: function copy(out, v) {
            out[0] = v[0];
            out[1] = v[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.set
         * @description 设置向量的两个项。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {number} a - 项 a。
         * @param {number} b - 项 b。
         * @return {Vector2} 结果。
         */

    }, {
        key: "set",
        value: function set(out, a, b) {
            out[0] = a;
            out[1] = b;
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.add
         * @description 向量相加。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "add",
        value: function add(out, v1, v2) {
            out[0] = v1[0] + v2[0];
            out[1] = v1[1] + v2[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.scaleAndAdd
         * @description 向量缩放后相加。
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2（缩放向量）。
         * @param {number} a - 缩放参数。
         * @return {Vector2} 结果。
         */

    }, {
        key: "scaleAndAdd",
        value: function scaleAndAdd(out, v1, v2, a) {
            out[0] = v1[0] + v2[0] * a;
            out[1] = v1[1] + v2[1] * a;
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.sub
         * @description 向量相减。
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "sub",
        value: function sub(out, v1, v2) {
            out[0] = v1[0] - v2[0];
            out[1] = v1[1] - v2[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.len
         * @description 向量长度。
         * @param {Vector2} v - 向量。
         * @return {number} 向量长度。
         */

    }, {
        key: "len",
        value: function len(v) {
            return Math.sqrt(this.lenSquare(v));
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.lenSquare
         * @description 向量长度平方。
         * @param {Vector2} v - 向量。
         * @return {number} 向量长度平方。
         */

    }, {
        key: "lenSquare",
        value: function lenSquare(v) {
            return v[0] * v[0] + v[1] * v[1];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.mul
         * @description 向量乘法。
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "mul",
        value: function mul(out, v1, v2) {
            out[0] = v1[0] * v2[0];
            out[1] = v1[1] * v2[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.div
         * @description 向量除法。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "div",
        value: function div(out, v1, v2) {
            out[0] = v1[0] / v2[0];
            out[1] = v1[1] / v2[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.dot
         * @description 向量点乘。
         * 
         * @param  {Vector2} v1 - 向量 v1。
         * @param  {Vector2} v2 - 向量 v2。
         * @return {number} 向量点乘。
         */

    }, {
        key: "dot",
        value: function dot(v1, v2) {
            return v1[0] * v2[0] + v1[1] * v2[1];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.scale
         * @description 向量缩放。
         *
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v - 向量v。
         * @param {number} s -缩放参数。
         * @return {Vector2} 结果。
         */

    }, {
        key: "scale",
        value: function scale(out, v, s) {
            out[0] = v[0] * s;
            out[1] = v[1] * s;
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.normalize
         * @description 向量归一化。
         *
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v - 向量 v。
         * @return {Vector2} 结果。
         */

    }, {
        key: "normalize",
        value: function normalize(out, v) {
            var d = this.len(v);
            if (d === 0) {
                out[0] = 0;
                out[1] = 0;
            } else {
                out[0] = v[0] / d;
                out[1] = v[1] / d;
            }
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.distance
         * @description 计算向量间距离。
         * 
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {number} 向量间距离。
         */

    }, {
        key: "distance",
        value: function distance(v1, v2) {
            return Math.sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]));
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.distanceSquare
         * @description 向量距离平方。
         * 
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {number} 向量距离平方。
         */

    }, {
        key: "distanceSquare",
        value: function distanceSquare(v1, v2) {
            return (v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.negate
         * @description 求负向量。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v - 向量 v。
         * @return {Vector2} 负向量。
         */

    }, {
        key: "negate",
        value: function negate(out, v) {
            out[0] = -v[0];
            out[1] = -v[1];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.lerp
         * @description 两点之间线性插值。
         *
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @param {number} t
         * @return {Vector2} 结果。
         */

    }, {
        key: "lerp",
        value: function lerp(out, v1, v2, t) {
            out[0] = v1[0] + t * (v2[0] - v1[0]);
            out[1] = v1[1] + t * (v2[1] - v1[1]);
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.applyTransform
         * @description 矩阵左乘向量。
         * 
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "applyTransform",
        value: function applyTransform(out, v, m) {
            var x = v[0];
            var y = v[1];
            out[0] = m[0] * x + m[2] * y + m[4];
            out[1] = m[1] * x + m[3] * y + m[5];
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.min
         * @description 求两个向量最小值。
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "min",
        value: function min(out, v1, v2) {
            out[0] = Math.min(v1[0], v2[0]);
            out[1] = Math.min(v1[1], v2[1]);
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.max
         * @description 求两个向量最大值。
         *
         * @param {Vector2} out - 基础向量。
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {Vector2} 结果。
         */

    }, {
        key: "max",
        value: function max(out, v1, v2) {
            out[0] = Math.max(v1[0], v2[0]);
            out[1] = Math.max(v1[1], v2[1]);
            return out;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.length
         * @description 向量长度。
         * 
         * @param {Vector2} v - 向量。
         * @return {number} 向量长度。
         */

    }, {
        key: "length",
        value: function length(v) {
            return this.len(v);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.lengthSquare
         * @description 向量长度平方。
         * 
         * @param {Vector2} v - 向量。
         * @return {number} 向量长度平方。
         */

    }, {
        key: "lengthSquare",
        value: function lengthSquare(v) {
            return this.lenSquare(v);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.dist
         * @description 计算向量间距离。
         *
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {number} 向量间距离。
         */

    }, {
        key: "dist",
        value: function dist(v1, v2) {
            return this.distance(v1, v2);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Vector.prototype.distSquare
         * @description 向量距离平方。
         * 
         * @param {Vector2} v1 - 向量 v1。
         * @param {Vector2} v2 - 向量 v2。
         * @return {number} 向量距离平方
         */

    }, {
        key: "distSquare",
        value: function distSquare(v1, v2) {
            return this.distanceSquare(v1, v2);
        }
    }]);

    return Vector;
}();

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Curve = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _Vector = __webpack_require__(58);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class  SuperMap.LevelRenderer.Tool.Curve
 * @category Visualization Theme
 * @classdesc LevelRenderer 工具-曲线
 * @private 
 */
var Curve = exports.Curve = function () {

    /**
     * @function SuperMap.LevelRenderer.Tool.Curve.prototype.constructor
     * @description 构造函数。
     */
    function Curve() {
        _classCallCheck(this, Curve);

        /**
         * @member {SuperMap.LevelRenderer.Tool.Vector} SuperMap.LevelRenderer.Tool.Curve.prototype.vector
         * @description 矢量工具。
         */
        this.vector = new _Vector.Vector();

        /**
         * @member {number} SuperMap.LevelRenderer.Tool.Curve.prototype.EPSILON
         * @description e。
         */
        this.EPSILON = 1e-4;

        /**
         * @member {number} SuperMap.LevelRenderer.Tool.Curve.prototype.THREE_SQRT
         * @description 3 的平方根。
         */
        this.THREE_SQRT = Math.sqrt(3);

        /**
         * @member {number} SuperMap.LevelRenderer.Tool.Curve.prototype.ONE_THIRD
         * @description 1/3。
         */
        this.ONE_THIRD = 1 / 3;

        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Curve";
    }

    /*
     * Method: evalCubicCoeff
     *
     * Parameters:
     * a - {number} 值。
     * b - {number} 值。
     * c - {number} 值。
     * d - {number} 值。
     * t - {number} 值。
     *
     * Returns:
     * {number}
     */

    /*
     evalCubicCoeff: function(a, b, c, d, t){
     return ((a * t + b) * t + c) * t + d;
     },
     */

    /**
     * @function SuperMap.LevelRenderer.Tool.Curve.prototype.isAroundZero
     * @description 判断一个值是否趋于0，判断参考值：1e-4。
     * @param {number} val - 值。
     * @returns {boolean} 值是否趋于0。
     */


    _createClass(Curve, [{
        key: "isAroundZero",
        value: function isAroundZero(val) {
            return val > -this.EPSILON && val < this.EPSILON;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.isNotAroundZero
         * @description 判断一个值是否不趋于0，判断参考值：1e-4。
         * @param {number} val - 值。
         * @returns {boolean} 值是否不趋于0。
         */

    }, {
        key: "isNotAroundZero",
        value: function isNotAroundZero(val) {
            return val > this.EPSILON || val < -this.EPSILON;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicAt
         * @description 计算三次贝塞尔值
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} p3 - 点p3。
         * @param {number} t - t值。
         * @returns {number} 三次贝塞尔值。
         */

    }, {
        key: "cubicAt",
        value: function cubicAt(p0, p1, p2, p3, t) {
            var onet = 1 - t;
            return onet * onet * (onet * p0 + 3 * t * p1) + t * t * (t * p3 + 3 * onet * p2);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicDerivativeAt
         * @description 计算三次贝塞尔导数值
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} p3 - 点p3。
         * @param {number} t - t值。
         * @returns {number} 三次贝塞尔导数值。
         */

    }, {
        key: "cubicDerivativeAt",
        value: function cubicDerivativeAt(p0, p1, p2, p3, t) {
            var onet = 1 - t;
            return 3 * (((p1 - p0) * onet + 2 * (p2 - p1) * t) * onet + (p3 - p2) * t * t);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicRootAt
         * @description 计算三次贝塞尔方程根，使用盛金公式
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} p3 - 点p3。
         * @param {number} val - 值。
         * @param {Array.<number>} roots - 有效根数目。
         * @returns {number} 有效根。
         */

    }, {
        key: "cubicRootAt",
        value: function cubicRootAt(p0, p1, p2, p3, val, roots) {
            // Evaluate roots of cubic functions
            var a = p3 + 3 * (p1 - p2) - p0;
            var b = 3 * (p2 - p1 * 2 + p0);
            var c = 3 * (p1 - p0);
            var d = p0 - val;

            var A = b * b - 3 * a * c;
            var B = b * c - 9 * a * d;
            var C = c * c - 3 * b * d;

            var n = 0;

            if (this.isAroundZero(A) && this.isAroundZero(B)) {
                if (this.isAroundZero(b)) {
                    roots[0] = 0;
                } else {
                    var t1 = -c / b; //t1, t2, t3, b is not zero
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                }
            } else {
                var disc = B * B - 4 * A * C;

                if (this.isAroundZero(disc)) {
                    var K = B / A;
                    var _t2 = -b / a + K; // t1, a is not zero
                    var t2 = -K / 2; // t2, t3
                    if (_t2 >= 0 && _t2 <= 1) {
                        roots[n++] = _t2;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        roots[n++] = t2;
                    }
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var Y1 = A * b + 1.5 * a * (-B + discSqrt);
                    var Y2 = A * b + 1.5 * a * (-B - discSqrt);
                    if (Y1 < 0) {
                        Y1 = -Math.pow(-Y1, this.ONE_THIRD);
                    } else {
                        Y1 = Math.pow(Y1, this.ONE_THIRD);
                    }
                    if (Y2 < 0) {
                        Y2 = -Math.pow(-Y2, this.ONE_THIRD);
                    } else {
                        Y2 = Math.pow(Y2, this.ONE_THIRD);
                    }
                    var _t3 = (-b - (Y1 + Y2)) / (3 * a);
                    if (_t3 >= 0 && _t3 <= 1) {
                        roots[n++] = _t3;
                    }
                } else {
                    var T = (2 * A * b - 3 * a * B) / (2 * Math.sqrt(A * A * A));
                    var theta = Math.acos(T) / 3;
                    var ASqrt = Math.sqrt(A);
                    var tmp = Math.cos(theta);

                    var _t4 = (-b - 2 * ASqrt * tmp) / (3 * a);
                    var _t5 = (-b + ASqrt * (tmp + this.THREE_SQRT * Math.sin(theta))) / (3 * a);
                    var t3 = (-b + ASqrt * (tmp - this.THREE_SQRT * Math.sin(theta))) / (3 * a);
                    if (_t4 >= 0 && _t4 <= 1) {
                        roots[n++] = _t4;
                    }
                    if (_t5 >= 0 && _t5 <= 1) {
                        roots[n++] = _t5;
                    }
                    if (t3 >= 0 && t3 <= 1) {
                        roots[n++] = t3;
                    }
                }
            }
            return n;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicRootAt
         * @description 计算三次贝塞尔方程极限值的位置
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} p3 - 点p3。
         * @param {Array.<number>} extrema - 值。
         * @returns {number} 有效数目。
         */

    }, {
        key: "cubicExtrema",
        value: function cubicExtrema(p0, p1, p2, p3, extrema) {
            var b = 6 * p2 - 12 * p1 + 6 * p0;
            var a = 9 * p1 + 3 * p3 - 3 * p0 - 9 * p2;
            var c = 3 * p1 - 3 * p0;

            var n = 0;
            if (this.isAroundZero(a)) {
                if (this.isNotAroundZero(b)) {
                    var t1 = -c / b;
                    if (t1 >= 0 && t1 <= 1) {
                        extrema[n++] = t1;
                    }
                }
            } else {
                var disc = b * b - 4 * a * c;
                if (this.isAroundZero(disc)) {
                    extrema[0] = -b / (2 * a);
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var _t6 = (-b + discSqrt) / (2 * a);
                    var t2 = (-b - discSqrt) / (2 * a);
                    if (_t6 >= 0 && _t6 <= 1) {
                        extrema[n++] = _t6;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        extrema[n++] = t2;
                    }
                }
            }
            return n;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicSubdivide
         * @description 细分三次贝塞尔曲线
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} p3 - 点p3。
         * @param {number} t - t值。
         * @param {Array.<number>} out - 投射点。
         * @returns {number} 投射点。
         */

    }, {
        key: "cubicSubdivide",
        value: function cubicSubdivide(p0, p1, p2, p3, t, out) {
            var p01 = (p1 - p0) * t + p0;
            var p12 = (p2 - p1) * t + p1;
            var p23 = (p3 - p2) * t + p2;

            var p012 = (p12 - p01) * t + p01;
            var p123 = (p23 - p12) * t + p12;

            var p0123 = (p123 - p012) * t + p012;
            // Seg0
            out[0] = p0;
            out[1] = p01;
            out[2] = p012;
            out[3] = p0123;
            // Seg1
            out[4] = p0123;
            out[5] = p123;
            out[6] = p23;
            out[7] = p3;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.cubicProjectPoint
         * @description 投射点到三次贝塞尔曲线上，返回投射距离。投射点有可能会有一个或者多个，这里只返回其中距离最短的一个。
         * @param {number} x0 - 点p0横坐标。
         * @param {number} y0 - 点p0纵坐标。
         * @param {number} x1 - 点p1横坐标。
         * @param {number} y1 - 点p1纵坐标。
         * @param {number} x2 - 点p2横坐标。
         * @param {number} y2 - 点p2纵坐标。
         * @param {number} x3 - 点p3横坐标。
         * @param {number} y3 - 点p3纵坐标。
         * @param {number} x - 点p横坐标。
         * @param {number} y - 点p纵坐标。
         * @param {Array.<number>} out - 投射点。
         * @returns {number} 投射点。
         */

    }, {
        key: "cubicProjectPoint",
        value: function cubicProjectPoint(x0, y0, x1, y1, x2, y2, x3, y3, x, y, out) {
            // 临时变量
            var _v0 = this.vector.create();
            var _v1 = this.vector.create();
            var _v2 = this.vector.create();
            // var _v3 = vector.create();

            // http://pomax.github.io/bezierinfo/#projections
            var t;
            var interval = 0.005;
            var d = Infinity;

            _v0[0] = x;
            _v0[1] = y;

            // 先粗略估计一下可能的最小距离的 t 值
            // PENDING
            for (var _t = 0; _t < 1; _t += 0.05) {
                _v1[0] = this.cubicAt(x0, x1, x2, x3, _t);
                _v1[1] = this.cubicAt(y0, y1, y2, y3, _t);
                var d1 = this.vector.distSquare(_v0, _v1);
                if (d1 < d) {
                    t = _t;
                    d = d1;
                }
            }
            d = Infinity;

            // At most 32 iteration
            for (var i = 0; i < 32; i++) {
                if (interval < this.EPSILON) {
                    break;
                }
                var prev = t - interval;
                var next = t + interval;
                // t - interval
                _v1[0] = this.cubicAt(x0, x1, x2, x3, prev);
                _v1[1] = this.cubicAt(y0, y1, y2, y3, prev);

                var _d = this.vector.distSquare(_v1, _v0);

                if (prev >= 0 && _d < d) {
                    t = prev;
                    d = _d;
                } else {
                    // t + interval
                    _v2[0] = this.cubicAt(x0, x1, x2, x3, next);
                    _v2[1] = this.cubicAt(y0, y1, y2, y3, next);
                    var d2 = this.vector.distSquare(_v2, _v0);

                    if (next <= 1 && d2 < d) {
                        t = next;
                        d = d2;
                    } else {
                        interval *= 0.5;
                    }
                }
            }
            // t
            if (out) {
                out[0] = this.cubicAt(x0, x1, x2, x3, t);
                out[1] = this.cubicAt(y0, y1, y2, y3, t);
            }
            // console.log(interval, i);
            return Math.sqrt(d);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.quadraticAt
         * @description 计算二次方贝塞尔值。
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} t - t值。
         * @returns {number} 二次方贝塞尔值。
         */

    }, {
        key: "quadraticAt",
        value: function quadraticAt(p0, p1, p2, t) {
            var onet = 1 - t;
            return onet * (onet * p0 + 2 * t * p1) + t * t * p2;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.quadraticAt
         * @description 计算二次方贝塞尔导数值。
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} t - t值。
         * @returns {number} 二次方贝塞尔导数值。
         */

    }, {
        key: "quadraticDerivativeAt",
        value: function quadraticDerivativeAt(p0, p1, p2, t) {
            return 2 * ((1 - t) * (p1 - p0) + t * (p2 - p1));
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.quadraticRootAt
         * @description 计算二次方贝塞尔方程根
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @param {number} val - 值。
         * @param {Array.<number>} roots - 有效根数目。
         * @returns {number} 有效根数目。
         */

    }, {
        key: "quadraticRootAt",
        value: function quadraticRootAt(p0, p1, p2, val, roots) {
            var a = p0 - 2 * p1 + p2;
            var b = 2 * (p1 - p0);
            var c = p0 - val;

            var n = 0;
            if (this.isAroundZero(a)) {
                if (this.isNotAroundZero(b)) {
                    var t1 = -c / b;
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                }
            } else {
                var disc = b * b - 4 * a * c;
                if (this.isAroundZero(disc)) {
                    var _t7 = -b / (2 * a);
                    if (_t7 >= 0 && _t7 <= 1) {
                        roots[n++] = _t7;
                    }
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var _t8 = (-b + discSqrt) / (2 * a);
                    var t2 = (-b - discSqrt) / (2 * a);
                    if (_t8 >= 0 && _t8 <= 1) {
                        roots[n++] = _t8;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        roots[n++] = t2;
                    }
                }
            }
            return n;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.quadraticExtremum
         * @description 计算二次贝塞尔方程极限值
         * @param {number} p0 - 点p0。
         * @param {number} p1 - 点p1。
         * @param {number} p2 - 点p2。
         * @returns {number} 二次贝塞尔方程极限值。
         */

    }, {
        key: "quadraticExtremum",
        value: function quadraticExtremum(p0, p1, p2) {
            var divider = p0 + p2 - 2 * p1;
            if (divider === 0) {
                // p1 is center of p0 and p2
                return 0.5;
            } else {
                return (p0 - p1) / divider;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Curve.prototype.quadraticProjectPoint
         * @description 投射点到二次贝塞尔曲线上，返回投射距离。投射点有可能会有一个或者多个，这里只返回其中距离最短的一个。
         * @param {number} x0 - 点p0横坐标。
         * @param {number} y0 - 点p0纵坐标。
         * @param {number} x1 - 点p1横坐标。
         * @param {number} y1 - 点p1纵坐标。
         * @param {number} x2 - 点p2横坐标。
         * @param {number} y2 - 点p2纵坐标。
         * @param {number} x - 点p横坐标。
         * @param {number} y - 点p纵坐标。
         * @param {Array.<number>} out - 投射点。
         * @returns {number} 投射距离。
         */

    }, {
        key: "quadraticProjectPoint",
        value: function quadraticProjectPoint(x0, y0, x1, y1, x2, y2, x, y, out) {
            // 临时变量
            var _v0 = this.vector.create();
            var _v1 = this.vector.create();
            var _v2 = this.vector.create();

            // http://pomax.github.io/bezierinfo/#projections
            var t;
            var interval = 0.005;
            var d = Infinity;

            _v0[0] = x;
            _v0[1] = y;

            // 先粗略估计一下可能的最小距离的 t 值
            // PENDING
            for (var _t = 0; _t < 1; _t += 0.05) {
                _v1[0] = this.quadraticAt(x0, x1, x2, _t);
                _v1[1] = this.quadraticAt(y0, y1, y2, _t);
                var d1 = this.vector.distSquare(_v0, _v1);
                if (d1 < d) {
                    t = _t;
                    d = d1;
                }
            }
            d = Infinity;

            // At most 32 iteration
            for (var i = 0; i < 32; i++) {
                if (interval < this.EPSILON) {
                    break;
                }
                var prev = t - interval;
                var next = t + interval;
                // t - interval
                _v1[0] = this.quadraticAt(x0, x1, x2, prev);
                _v1[1] = this.quadraticAt(y0, y1, y2, prev);

                var _d2 = this.vector.distSquare(_v1, _v0);

                if (prev >= 0 && _d2 < d) {
                    t = prev;
                    d = _d2;
                } else {
                    // t + interval
                    _v2[0] = this.quadraticAt(x0, x1, x2, next);
                    _v2[1] = this.quadraticAt(y0, y1, y2, next);
                    var d2 = this.vector.distSquare(_v2, _v0);
                    if (next <= 1 && d2 < d) {
                        t = next;
                        d = d2;
                    } else {
                        interval *= 0.5;
                    }
                }
            }
            // t
            if (out) {
                out[0] = this.quadraticAt(x0, x1, x2, t);
                out[1] = this.quadraticAt(y0, y1, y2, t);
            }
            // console.log(interval, i);
            return Math.sqrt(d);
        }
    }]);

    return Curve;
}();

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Transformable = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SUtil = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Transformable
 * @category Visualization Theme
 * @classdesc 可变换超类，所有支持 Canvas Transform 变换操作的类均是此类的子类。此类不可实例化。
 */
var Transformable = exports.Transformable = function () {

    /**
     * @function SuperMap.LevelRenderer.Transformable.constructor
     * @description 构造函数。
     */
    function Transformable() {
        _classCallCheck(this, Transformable);

        /**
         * @member {Array.<number>} SuperMap.LevelRenderer.Transformable.prototype.position 
         * @description 平移， 默认值：[0, 0]。
         */
        this.position = [0, 0];

        /**
         * @member {Array.<number>} SuperMap.LevelRenderer.Transformable.prototype.rotation
         * @description 旋转，可以通过数组二三项指定旋转的原点， 默认值：[0, 0, 0]。
         */
        this.rotation = [0, 0, 0];

        /**
         * @member {Array.<number>} SuperMap.LevelRenderer.Transformable.prototype.scale
         * @description 缩放，可以通过数组三四项指定缩放的原点， 默认值：[1, 1, 0, 0]。
         */
        this.scale = [1, 1, 0, 0];

        /**
         * @member {boolean} SuperMap.LevelRenderer.Transformable.prototype.needLocalTransform
         * @description 是否变换。默认值：false。
         */
        this.needLocalTransform = false;

        /**
         * @member {boolean} SuperMap.LevelRenderer.Transformable.prototype.needTransform
         * @description 是否有坐标变换。默认值：false。
         */
        this.needTransform = false;

        this.CLASS_NAME = "SuperMap.LevelRenderer.Transformable";
        /**
         * @function SuperMap.LevelRenderer.Transformable.prototype.lookAt
         * @description 设置图形的朝向。
         */
        this.lookAt = function () {
            var v = _SUtil.SUtil.Util_vector.create();
            // {Array.<Number>|Float32Array} target
            return function (target) {
                if (!this.transform) {
                    this.transform = _SUtil.SUtil.Util_matrix.create();
                }
                var m = this.transform;
                _SUtil.SUtil.Util_vector.sub(v, target, this.position);
                if (isAroundZero(v[0]) && isAroundZero(v[1])) {
                    return;
                }
                _SUtil.SUtil.Util_vector.normalize(v, v);
                // Y Axis
                // TODO Scale origin ?
                m[2] = v[0] * this.scale[1];
                m[3] = v[1] * this.scale[1];
                // X Axis
                m[0] = v[1] * this.scale[0];
                m[1] = -v[0] * this.scale[0];
                // Position
                m[4] = this.position[0];
                m[5] = this.position[1];

                this.decomposeTransform();

                function isAroundZero(val) {
                    var EPSILON = 5e-5;
                    return val > -EPSILON && val < EPSILON;
                }
            };
        }();
    }

    /**
     * @function SuperMap.LevelRenderer.Transformable.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(Transformable, [{
        key: "destroy",
        value: function destroy() {
            this.position = null;
            this.rotation = null;
            this.scale = null;
            this.needLocalTransform = null;
            this.needTransform = null;
        }

        /**
         * @function SuperMap.LevelRenderer.Transformable.prototype.updateNeedTransform
         * @description 更新 needLocalTransform
         */

    }, {
        key: "updateNeedTransform",
        value: function updateNeedTransform() {
            this.needLocalTransform = isNotAroundZero(this.rotation[0]) || isNotAroundZero(this.position[0]) || isNotAroundZero(this.position[1]) || isNotAroundZero(this.scale[0] - 1) || isNotAroundZero(this.scale[1] - 1);

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Transformable.prototype.updateTransform
         * @description 判断是否需要有坐标变换，更新 needTransform 属性。如果有坐标变换, 则从 position, rotation, scale 以及父节点的 transform 计算出自身的 transform 矩阵
         */

    }, {
        key: "updateTransform",
        value: function updateTransform() {
            this.updateNeedTransform();

            if (this.parent) {
                this.needTransform = this.needLocalTransform || this.parent.needTransform;
            } else {
                this.needTransform = this.needLocalTransform;
            }

            if (!this.needTransform) {
                return;
            }

            var origin = [0, 0];

            var m = this.transform || _SUtil.SUtil.Util_matrix.create();
            _SUtil.SUtil.Util_matrix.identity(m);

            if (this.needLocalTransform) {
                if (isNotAroundZero(this.scale[0]) || isNotAroundZero(this.scale[1])) {
                    origin[0] = -this.scale[2] || 0;
                    origin[1] = -this.scale[3] || 0;
                    var haveOrigin = isNotAroundZero(origin[0]) || isNotAroundZero(origin[1]);
                    if (haveOrigin) {
                        _SUtil.SUtil.Util_matrix.translate(m, m, origin);
                    }
                    _SUtil.SUtil.Util_matrix.scale(m, m, this.scale);
                    if (haveOrigin) {
                        origin[0] = -origin[0];
                        origin[1] = -origin[1];
                        _SUtil.SUtil.Util_matrix.translate(m, m, origin);
                    }
                }

                if (this.rotation instanceof Array) {
                    if (this.rotation[0] !== 0) {
                        origin[0] = -this.rotation[1] || 0;
                        origin[1] = -this.rotation[2] || 0;
                        var _haveOrigin = isNotAroundZero(origin[0]) || isNotAroundZero(origin[1]);
                        if (_haveOrigin) {
                            _SUtil.SUtil.Util_matrix.translate(m, m, origin);
                        }
                        _SUtil.SUtil.Util_matrix.rotate(m, m, this.rotation[0]);
                        if (_haveOrigin) {
                            origin[0] = -origin[0];
                            origin[1] = -origin[1];
                            _SUtil.SUtil.Util_matrix.translate(m, m, origin);
                        }
                    }
                } else {
                    if (this.rotation !== 0) {
                        _SUtil.SUtil.Util_matrix.rotate(m, m, this.rotation);
                    }
                }

                if (isNotAroundZero(this.position[0]) || isNotAroundZero(this.position[1])) {
                    _SUtil.SUtil.Util_matrix.translate(m, m, this.position);
                }
            }

            // 保存这个变换矩阵
            this.transform = m;

            // 应用父节点变换
            if (this.parent && this.parent.needTransform) {
                if (this.needLocalTransform) {
                    _SUtil.SUtil.Util_matrix.mul(this.transform, this.parent.transform, this.transform);
                } else {
                    _SUtil.SUtil.Util_matrix.copy(this.transform, this.parent.transform);
                }
            }

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Transformable.prototype.setTransform
         * @description 将自己的 transform 应用到 context 上。
         * 
         * @param {Context2D} ctx - Context2D 上下文。
         */

    }, {
        key: "setTransform",
        value: function setTransform(ctx) {
            if (this.needTransform) {
                var m = this.transform;
                ctx.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Transformable.prototype.decomposeTransform
         * @description 分解`transform`矩阵到`position`, `rotation`, `scale` 。
         */

    }, {
        key: "decomposeTransform",
        value: function decomposeTransform() {
            if (!this.transform) {
                return;
            }
            var m = this.transform;
            var sx = m[0] * m[0] + m[1] * m[1];
            var position = this.position;
            var scale = this.scale;
            var rotation = this.rotation;
            if (isNotAroundZero(sx - 1)) {
                sx = Math.sqrt(sx);
            }
            var sy = m[2] * m[2] + m[3] * m[3];
            if (isNotAroundZero(sy - 1)) {
                sy = Math.sqrt(sy);
            }
            position[0] = m[4];
            position[1] = m[5];
            scale[0] = sx;
            scale[1] = sy;
            scale[2] = scale[3] = 0;
            rotation[0] = Math.atan2(-m[1] / sy, m[0] / sx);
            rotation[1] = rotation[2] = 0;

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }
    }]);

    return Transformable;
}();

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sector = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _ShapeParameters2 = __webpack_require__(24);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Feature.ShapeParameters.Sector
 * @category Visualization Theme
 * @classdesc 扇形参数对象。
 * @extends {SuperMap.Feature.ShapeParameters}
 */

var Sector = exports.Sector = function (_ShapeParameters) {
  _inherits(Sector, _ShapeParameters);

  /**
   * @function SuperMap.Feature.ShapeParameters.Sector.prototype.constructor
   * @description 创建一个扇形参数对象。
   * @param {number} x - 圆心 x 坐标，必设参数。
   * @param {number} y - 圆心 y 坐标，必设参数。
   * @param {number} r - 外圆半径，必设参数。
   * @param {number} startAngle - 起始角度，必设参数。取值范围[0, 360)。
   * @param {number} endAngle - 结束角度，必设参数。取值范围(0, 360]。
   * @param {number} [r0=0] - 内圆半径，指定后将出现内弧，同时扇边长度为'r - r0'。取值范围[0, r)。
   * @returns {SuperMap.Feature.ShapeParameters.Sector} 扇形参数对象。
   */
  function Sector(x, y, r, startAngle, endAngle, r0, clockWise) {
    _classCallCheck(this, Sector);

    /**
     * @member {number} SuperMap.Feature.ShapeParameters.Sector.prototype.x
     * @description  圆心 x 坐标。
     */
    var _this = _possibleConstructorReturn(this, (Sector.__proto__ || Object.getPrototypeOf(Sector)).call(this, x, y, r, startAngle, endAngle, r0, clockWise));

    _this.x = !isNaN(x) ? x : 0;

    /**
     * @member {number} SuperMap.Feature.ShapeParameters.Sector.prototype.Y
     * @description  圆心 Y 坐标。
     */
    _this.y = !isNaN(y) ? y : 0;

    /**
     * @member {number} SuperMap.Feature.ShapeParameters.Sector.prototype.r
     * @description  外圆半径。
     */
    _this.r = !isNaN(r) ? r : 0;

    /**
     * @member {number} SuperMap.Feature.ShapeParameters.Sector.prototype.startAngle
     * @description  起始角度。取值范围[0, 360)，默认值：null。
     */
    _this.startAngle = !isNaN(startAngle) ? startAngle : 0;

    /**
     * @member {number} SuperMap.Feature.ShapeParameters.Sector.prototype.endAngle
     * @description  结束角度。取值范围(0, 360]，默认值：null。
     */
    _this.endAngle = !isNaN(endAngle) ? endAngle : 0;

    /**
     * @member {number} [SuperMap.Feature.ShapeParameters.Sector.prototype.r0=0]
     * @description 内圆半径，指定后将出现内弧，同时扇边长度为 r 减 r0。取值范围[0, r)。
     */
    _this.r0 = !isNaN(r0) ? r0 : 0;

    /**
     * @member {number} [SuperMap.Feature.ShapeParameters.Sector.prototype.clockWise=false]
     * @description 是否是顺时针。默认值：false。
     */
    _this.clockWise = clockWise;

    _this.CLASS_NAME = "SuperMap.Feature.ShapeParameters.Sector";
    return _this;
  }

  /**
   * @function SuperMap.Feature.ShapeParameters.Sector.prototype.destroy
   * @description 销毁对象。
   */


  _createClass(Sector, [{
    key: 'destroy',
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.r = null;
      this.startAngle = null;
      this.endAngle = null;
      this.r0 = null;
      this.clockWise = null;

      _get(Sector.prototype.__proto__ || Object.getPrototypeOf(Sector.prototype), 'destroy', this).call(this);
    }
  }]);

  return Sector;
}(_ShapeParameters2.ShapeParameters);

/**
 * @typedef {Object} SuperMap.Feature.ShapeParameters.Sector.style
 * @property {boolean} fill - 是否填充，不需要填充则设置为false，默认值为 true。此属性与 stroke 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} fillColor - 十六进制填充颜色。默认值为 "#000000"。
 * @property {number} fillOpacity - 填充不透明度。取值范围[0, 1]，默认值 1。
 * @property {boolean} stroke - 是否描边，不需要描边则设置为 false，默认值为 false。此属性与 fill 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} strokeColor - 十六进制描边颜色。
 * @property {number} strokeWidth - 描边宽度，默认值 1。
 * @property {number} strokeOpacity - 描边的不透明度。取值范围[0, 1]，默认值 1。
 * @property {number} shadowBlur - 阴影模糊度，（大于 0 有效; 默认值 0）。
 * @property {string} shadowColor - 阴影颜色; 默认值 '#000000'。
 * @property {number} shadowOffsetX - 阴影 X 方向偏移值; 默认值 0。
 * @property {number} shadowOffsetY - 阴影 Y 方向偏移值; 默认值 0。
 */

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeParameters.Sector = Sector;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Polygon = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _ShapeParameters2 = __webpack_require__(24);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Feature.ShapeParameters.Polygon
 * @category Visualization Theme
 * @classdesc 面参数对象。
 * @extends {SuperMap.Feature.ShapeParameters}
 */

var Polygon = exports.Polygon = function (_ShapeParameters) {
  _inherits(Polygon, _ShapeParameters);

  /**
   * @function SuperMap.Feature.ShapeParameters.Polygon.prototype.constructor
   * @description 创建一个图形面参数对象。
   * @param {Array} pointList - 横坐标，必设参数。
   * @returns {SuperMap.Feature.ShapeParameters.Polygon} 标签参数对象。
   */
  function Polygon(pointList) {
    _classCallCheck(this, Polygon);

    /**
     * @member {Array} SuperMap.Feature.ShapeParameters.Polygon.prototype.pointList
     * @description 面要素节点数组，二维数组。
     * 数组形如：
     * (start code)
     *  [
     *  [10, 20],         //节点
     *  [30, 40],
     *  [25, 30]         //最后一个节点和第一个节点不必相同，绘制时自动封闭
     *   ]
     * (end)
     */
    var _this = _possibleConstructorReturn(this, (Polygon.__proto__ || Object.getPrototypeOf(Polygon)).call(this, pointList));

    _this.pointList = pointList;

    /**
     * @member {Array} SuperMap.Feature.ShapeParameters.Polygon.prototype.holePolygonPointLists
     * @description 岛洞面多边形顶点数组（三维数组）
     */
    _this.holePolygonPointLists = null;

    _this.CLASS_NAME = "SuperMap.Feature.ShapeParameters.Polygon";
    return _this;
  }

  /**
   * @function SuperMap.Feature.ShapeParameters.Polygon.prototype.destroy
   * @description 销毁对象。
   */


  _createClass(Polygon, [{
    key: 'destroy',
    value: function destroy() {
      this.pointList = null;
      this.holePolygonPointLists = null;
      _get(Polygon.prototype.__proto__ || Object.getPrototypeOf(Polygon.prototype), 'destroy', this).call(this);
    }
  }]);

  return Polygon;
}(_ShapeParameters2.ShapeParameters);

/**
 * @typedef {Object} SuperMap.Feature.ShapeParameters.Polygon.style
 * @property {boolean} fill - 是否填充，不需要填充则设置为false，默认值为 true。此属性与 stroke 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} fillColor - 十六进制填充颜色。默认值为 "#000000"。
 * @property {number} fillOpacity - 填充不透明度。取值范围[0, 1]，默认值 1。
 * @property {boolean} stroke - 是否描边，不需要描边则设置为 false，默认值为 false。此属性与 fill 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} strokeColor - 十六进制描边颜色。
 * @property {number} strokeWidth - 描边宽度，默认值 1。
 * @property {number} strokeOpacity - 描边的不透明度。取值范围[0, 1]，默认值 1。
 * @property {string} strokeLinecap - 线帽样式；strokeLinecap 有三种类型 ：“butt", "round", "square"; 默认为"butt"。
 * @property {string} strokeLineJoin - 线段连接样式；strokeLineJoin 有三种类型： “miter", "round", "bevel"; 默认为"miter"。
 * @property {string} strokeDashstyle - 虚线类型； strokeDashstyle 有八种类型 ：“dot",“dash",“dashdot",“longdash",“longdashdot",“solid", "dashed", "dotted"; 默认值 "solid"。solid 表示实线。
 * @property {number} shadowBlur - 阴影模糊度，（大于 0 有效; 默认值 0）。
 * @property {string} shadowColor - 阴影颜色; 默认值 '#000000'。
 * @property {number} shadowOffsetX - 阴影 X 方向偏移值; 默认值 0。
 * @property {number} shadowOffsetY - 阴影 Y 方向偏移值; 默认值 0。
*/

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeParameters.Polygon = Polygon;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Line = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _ShapeParameters2 = __webpack_require__(24);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Feature.ShapeParameters.Line
 * @category Visualization Theme
 * @classdesc 线参数对象。
 * @extends {SuperMap.Feature.ShapeParameters}
 */
var Line = exports.Line = function (_ShapeParameters) {
  _inherits(Line, _ShapeParameters);

  /**
   * @function SuperMap.Feature.ShapeParameters.Line.prototype.constructor
   * @description 创建一个图形线参数对象。
   * @param {Array} pointList - 线要素节点数组，二维数组，必设参数。
   * @returns {SuperMap.Feature.ShapeParameters.Line} 圆形参数对象。
   */
  function Line(pointList) {
    _classCallCheck(this, Line);

    /**
     * @member {Array} SuperMap.Feature.ShapeParameters.Line.prototype.pointList
     * @description 线要素节点数组，二维数组。
     * 数组形如：
     * (start code)
     *  [
     *  [10, 20],         //节点
     *  [30, 40],
     *  [25, 30]         //最后一个节点和第一个节点不必相同，绘制时自动封闭
     *   ]
     * (end)
     */
    var _this = _possibleConstructorReturn(this, (Line.__proto__ || Object.getPrototypeOf(Line)).call(this, pointList));

    _this.pointList = pointList;

    _this.CLASS_NAME = "SuperMap.Feature.ShapeParameters.Line";

    return _this;
  }

  /**
   * @function SuperMap.Feature.ShapeParameters.Line.prototype.destroy
   * @description 销毁对象。
   */


  _createClass(Line, [{
    key: 'destroy',
    value: function destroy() {
      this.pointList = null;
      _get(Line.prototype.__proto__ || Object.getPrototypeOf(Line.prototype), 'destroy', this).call(this);
    }
  }]);

  return Line;
}(_ShapeParameters2.ShapeParameters);

/**
* @typedef {Object} SuperMap.Feature.ShapeParameters.Line.style
* @property {string} strokeColor - 十六进制线颜色。
* @property {number}  strokeWidth - 线宽度，默认值 1。
* @property {string} strokeLinecap - 线帽样式；strokeLinecap 有三种类型 ：“butt", "round", "square"; 默认为"butt"。
* @property {string} strokeLineJoin - 线段连接样式；strokeLineJoin 有三种类型： “miter", "round", "bevel"; 默认为"miter"。
* @property {string} strokeDashstyle - 虚线类型； strokeDashstyle 有八种类型 ：“dot",“dash",“dashdot",“longdash",“longdashdot",“solid", "dashed", "dotted"; 默认值 "solid"。solid 表示实线。
* @property {number}  strokeOpacity - 线的不透明度。取值范围[0, 1]，默认值 1。
* @property {number}  shadowBlur - 阴影模糊度，（大于 0 有效; 默认值 0）。
* @property {string} shadowColor - 阴影颜色; 默认值 '#000000'。
* @property {number}  shadowOffsetX - 阴影 X 方向偏移值; 默认值 0。
* @property {number}  shadowOffsetY - 阴影 Y 方向偏移值; 默认值 0。
*/


_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeParameters.Line = Line;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Point = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _ShapeParameters2 = __webpack_require__(24);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Feature.ShapeParameters.Point
 * @category Visualization Theme
 * @classdesc 点参数对象。
 * @extends {SuperMap.Feature.ShapeParameters}
 */

var Point = exports.Point = function (_ShapeParameters) {
  _inherits(Point, _ShapeParameters);

  /**
   * @function SuperMap.Feature.ShapeParameters.Point.prototype.constructor
   * @description 创建一个图形点参数对象。
   * @param {number} x - 点 x 坐标，必设参数。
   * @param {number} y - 点 y 坐标，必设参数。
   * @returns {SuperMap.Feature.ShapeParameters.Point} 标签参数对象。
   */
  function Point(x, y) {
    _classCallCheck(this, Point);

    /**
     * @member {number}  SuperMap.Feature.ShapeParameters.Point.prototype.x
     * @description 点 x 坐标。
     */
    var _this = _possibleConstructorReturn(this, (Point.__proto__ || Object.getPrototypeOf(Point)).call(this, x, y));

    _this.x = !isNaN(x) ? x : 0;

    /**
     * @member {number}  SuperMap.Feature.ShapeParameters.Point.prototype.y
     * @description 点 y 坐标。
     */
    _this.y = !isNaN(y) ? y : 0;

    /**
     * @member {number}  SuperMap.Feature.ShapeParameters.Point.prototype.r
     * @description 点的半径。
     */
    _this.r = 6;

    _this.CLASS_NAME = "SuperMap.Feature.ShapeParameters.Point";
    return _this;
  }

  /**
   * @function SuperMap.Feature.ShapeParameters.Point.prototype.destroy
   * @description 销毁对象。
   */


  _createClass(Point, [{
    key: 'destroy',
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.r = null;

      _get(Point.prototype.__proto__ || Object.getPrototypeOf(Point.prototype), 'destroy', this).call(this);
    }
  }]);

  return Point;
}(_ShapeParameters2.ShapeParameters);

/**
 * @typedef {Object} SuperMap.Feature.ShapeParameters.Point.style
 * @property {number} pointRadius - 点的半径，默认值：6。
 * @property {boolean} fill - 是否填充，不需要填充则设置为false，默认值为 true。此属性与 stroke 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} fillColor - 十六进制填充颜色。默认值为 "#000000"。
 * @property {number} fillOpacity - 填充不透明度。取值范围[0, 1]，默认值 1。
 * @property {boolean} stroke - 是否描边，不需要描边则设置为 false，默认值为 false。此属性与 fill 不能同时为 false，如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染。
 * @property {string} strokeColor - 十六进制描边颜色。
 * @property {number} strokeWidth - 描边宽度，默认值 1。
 * @property {number} strokeOpacity - 描边的不透明度。取值范围[0, 1]，默认值 1。
 * @property {number} shadowBlur - 阴影模糊度，（大于 0 有效; 默认值 0）。
 * @property {string} shadowColor - 阴影颜色; 默认值 '#000000'。
 * @property {number} shadowOffsetX - 阴影 X 方向偏移值; 默认值 0。
 * @property {number} shadowOffsetY - 阴影 Y 方向偏移值; 默认值 0。
 */

_SuperMap.SuperMap.Feature = _SuperMap.SuperMap.Feature || {};
_SuperMap.SuperMap.Feature.ShapeParameters.Point = Point;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Color = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _Util = __webpack_require__(30);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class  SuperMap.LevelRenderer.Tool.Color
 * @category Visualization Theme
 * @classdesc LevelRenderer 工具-颜色辅助类
 * @private 
 */
var Color = exports.Color = function () {
    function Color() {
        _classCallCheck(this, Color);

        /**
         * @member {SuperMap.LevelRenderer.Tool.Util} SuperMap.LevelRenderer.Tool.Color.prototype.util
         * @description LevelRenderer 基础工具对象。
         */
        this.util = new _Util.Util();

        /**
         * @member {Object} SuperMap.LevelRenderer.Tool.Color.prototype._ctx
         * @description _ctx。
         */
        this._ctx = null;

        /**
         * @member {Array} SuperMap.LevelRenderer.Tool.Color.prototype.palette
         * @description 默认色板。色板是一个包含图表默认颜色系列的数组，当色板中所有颜色被使用过后，又将从新回到色板中的第一个颜色。
         */
        this.palette = ['#ff9277', ' #dddd00', ' #ffc877', ' #bbe3ff', ' #d5ffbb', '#bbbbff', ' #ddb000', ' #b0dd00', ' #e2bbff', ' #ffbbe3', '#ff7777', ' #ff9900', ' #83dd00', ' #77e3ff', ' #778fff', '#c877ff', ' #ff77ab', ' #ff6600', ' #aa8800', ' #77c7ff', '#ad77ff', ' #ff77ff', ' #dd0083', ' #777700', ' #00aa00', '#0088aa', ' #8400dd', ' #aa0088', ' #dd0000', ' #772e00'];

        /**
         * @member {Array} SuperMap.LevelRenderer.Tool.Color.prototype._palette
         * @description 复位色板，用于复位  palette
         */
        this._palette = this.palette;

        /**
         * @member {string} SuperMap.LevelRenderer.Tool.Color.prototype.highlightColor
         * @description 高亮色
         */
        this.highlightColor = 'rgba(0,0,255,1)';

        /**
         * @member {string} SuperMap.LevelRenderer.Tool.Color.prototype._highlightColor
         * @description 复位高亮色
         */
        this._highlightColor = this.highlightColor;

        /**
         * @member {string} SuperMap.LevelRenderer.Tool.Color.prototype.colorRegExp
         * @description 颜色格式，正则表达式。
         */
        this.colorRegExp = /^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i;

        /**
         * @member {string} SuperMap.LevelRenderer.Tool.Color.prototype._nameColors
         * @description 颜色名。
         */
        this._nameColors = {
            aliceblue: '#f0f8ff',
            antiquewhite: '#faebd7',
            aqua: '#0ff',
            aquamarine: '#7fffd4',
            azure: '#f0ffff',
            beige: '#f5f5dc',
            bisque: '#ffe4c4',
            black: '#000',
            blanchedalmond: '#ffebcd',
            blue: '#00f',
            blueviolet: '#8a2be2',
            brown: '#a52a2a',
            burlywood: '#deb887',
            cadetblue: '#5f9ea0',
            chartreuse: '#7fff00',
            chocolate: '#d2691e',
            coral: '#ff7f50',
            cornflowerblue: '#6495ed',
            cornsilk: '#fff8dc',
            crimson: '#dc143c',
            cyan: '#0ff',
            darkblue: '#00008b',
            darkcyan: '#008b8b',
            darkgoldenrod: '#b8860b',
            darkgray: '#a9a9a9',
            darkgrey: '#a9a9a9',
            darkgreen: '#006400',
            darkkhaki: '#bdb76b',
            darkmagenta: '#8b008b',
            darkolivegreen: '#556b2f',
            darkorange: '#ff8c00',
            darkorchid: '#9932cc',
            darkred: '#8b0000',
            darksalmon: '#e9967a',
            darkseagreen: '#8fbc8f',
            darkslateblue: '#483d8b',
            darkslategray: '#2f4f4f',
            darkslategrey: '#2f4f4f',
            darkturquoise: '#00ced1',
            darkviolet: '#9400d3',
            deeppink: '#ff1493',
            deepskyblue: '#00bfff',
            dimgray: '#696969',
            dimgrey: '#696969',
            dodgerblue: '#1e90ff',
            firebrick: '#b22222',
            floralwhite: '#fffaf0',
            forestgreen: '#228b22',
            fuchsia: '#f0f',
            gainsboro: '#dcdcdc',
            ghostwhite: '#f8f8ff',
            gold: '#ffd700',
            goldenrod: '#daa520',
            gray: '#808080',
            grey: '#808080',
            green: '#008000',
            greenyellow: '#adff2f',
            honeydew: '#f0fff0',
            hotpink: '#ff69b4',
            indianred: '#cd5c5c',
            indigo: '#4b0082',
            ivory: '#fffff0',
            khaki: '#f0e68c',
            lavender: '#e6e6fa',
            lavenderblush: '#fff0f5',
            lawngreen: '#7cfc00',
            lemonchiffon: '#fffacd',
            lightblue: '#add8e6',
            lightcoral: '#f08080',
            lightcyan: '#e0ffff',
            lightgoldenrodyellow: '#fafad2',
            lightgray: '#d3d3d3',
            lightgrey: '#d3d3d3',
            lightgreen: '#90ee90',
            lightpink: '#ffb6c1',
            lightsalmon: '#ffa07a',
            lightseagreen: '#20b2aa',
            lightskyblue: '#87cefa',
            lightslategray: '#789',
            lightslategrey: '#789',
            lightsteelblue: '#b0c4de',
            lightyellow: '#ffffe0',
            lime: '#0f0',
            limegreen: '#32cd32',
            linen: '#faf0e6',
            magenta: '#f0f',
            maroon: '#800000',
            mediumaquamarine: '#66cdaa',
            mediumblue: '#0000cd',
            mediumorchid: '#ba55d3',
            mediumpurple: '#9370d8',
            mediumseagreen: '#3cb371',
            mediumslateblue: '#7b68ee',
            mediumspringgreen: '#00fa9a',
            mediumturquoise: '#48d1cc',
            mediumvioletred: '#c71585',
            midnightblue: '#191970',
            mintcream: '#f5fffa',
            mistyrose: '#ffe4e1',
            moccasin: '#ffe4b5',
            navajowhite: '#ffdead',
            navy: '#000080',
            oldlace: '#fdf5e6',
            olive: '#808000',
            olivedrab: '#6b8e23',
            orange: '#ffa500',
            orangered: '#ff4500',
            orchid: '#da70d6',
            palegoldenrod: '#eee8aa',
            palegreen: '#98fb98',
            paleturquoise: '#afeeee',
            palevioletred: '#d87093',
            papayawhip: '#ffefd5',
            peachpuff: '#ffdab9',
            peru: '#cd853f',
            pink: '#ffc0cb',
            plum: '#dda0dd',
            powderblue: '#b0e0e6',
            purple: '#800080',
            red: '#f00',
            rosybrown: '#bc8f8f',
            royalblue: '#4169e1',
            saddlebrown: '#8b4513',
            salmon: '#fa8072',
            sandybrown: '#f4a460',
            seagreen: '#2e8b57',
            seashell: '#fff5ee',
            sienna: '#a0522d',
            silver: '#c0c0c0',
            skyblue: '#87ceeb',
            slateblue: '#6a5acd',
            slategray: '#708090',
            slategrey: '#708090',
            snow: '#fffafa',
            springgreen: '#00ff7f',
            steelblue: '#4682b4',
            tan: '#d2b48c',
            teal: '#008080',
            thistle: '#d8bfd8',
            tomato: '#ff6347',
            turquoise: '#40e0d0',
            violet: '#ee82ee',
            wheat: '#f5deb3',
            white: '#fff',
            whitesmoke: '#f5f5f5',
            yellow: '#ff0',
            yellowgreen: '#9acd32'
        };

        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Color";
    }

    /**
     * @function SuperMap.LevelRenderer.Tool.Color.prototype.customPalette
     * @description 自定义调色板。
     * @param {Array} userPalete - 颜色板。
     */


    _createClass(Color, [{
        key: 'customPalette',
        value: function customPalette(userPalete) {
            this.palette = userPalete;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.resetPalette
         * @description 复位默认色板。
         */

    }, {
        key: 'resetPalette',
        value: function resetPalette() {
            this.palette = this._palette;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getColor
         * @description 获取色板颜色。
         * @param {number} idx - 色板位置。
         * @param {Array} userPalete - 色板。
         * @returns {string} 颜色值。
         */

    }, {
        key: 'getColor',
        value: function getColor(idx, userPalete) {
            idx = idx | 0;
            userPalete = userPalete || this.palette;
            return userPalete[idx % userPalete.length];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.customHighlight
         * @description 自定义默认高亮颜色。
         * @param {string} userHighlightColor - 自定义高亮色。
         */

    }, {
        key: 'customHighlight',
        value: function customHighlight(userHighlightColor) {
            this.highlightColor = userHighlightColor;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.resetHighlight
         * @description 重置默认高亮颜色。将当前的高亮色作为默认高亮颜色
         */

    }, {
        key: 'resetHighlight',
        value: function resetHighlight() {
            this.highlightColor = this._highlightColor;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getHighlightColor
         * @description 获取默认高亮颜色
         * @returns {string} 颜色值。
         */

    }, {
        key: 'getHighlightColor',
        value: function getHighlightColor() {
            return this.highlightColor;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getRadialGradient
         * @description 径向渐变。
         * @param {number} x0 - 渐变起点横坐标。
         * @param {number} y0 - 渐变起点纵坐标。
         * @param {number} r0 - 半径
         * @param {number} x1 - 渐变终点横坐标。
         * @param {number} y1 - 渐变终点纵坐标。
         * @param {number} r1 - 半径
         * @param {Array} colorList - 颜色列表。
         * @returns {CanvasGradient} Cavans 渐变颜色。
         */

    }, {
        key: 'getRadialGradient',
        value: function getRadialGradient(x0, y0, r0, x1, y1, r1, colorList) {
            var util = this.util;

            if (!this._ctx) {
                this._ctx = util.getContext();
            }
            var gradient = this._ctx.createRadialGradient(x0, y0, r0, x1, y1, r1);
            for (var i = 0, l = colorList.length; i < l; i++) {

                gradient.addColorStop(colorList[i][0], colorList[i][1]);
            }
            gradient.__nonRecursion = true;
            return gradient;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getLinearGradient
         * @description 线性渐变。
         * @param {number} x0 - 渐变起点横坐标。
         * @param {number} y0 - 渐变起点纵坐标。
         * @param {number} x1 - 渐变终点横坐标。
         * @param {number} y1 - 渐变终点纵坐标。
         * @param {Array} colorList - 颜色列表。
         * @returns {CanvasGradient} Cavans 渐变颜色。
         */

    }, {
        key: 'getLinearGradient',
        value: function getLinearGradient(x0, y0, x1, y1, colorList) {
            var util = this.util;

            if (!this._ctx) {
                this._ctx = util.getContext();
            }
            var gradient = this._ctx.createLinearGradient(x0, y0, x1, y1);
            for (var i = 0, l = colorList.length; i < l; i++) {
                gradient.addColorStop(colorList[i][0], colorList[i][1]);
            }
            gradient.__nonRecursion = true;
            return gradient;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getStepColors
         * @description 获取两种颜色之间渐变颜色数组。
         * @param {Object} start - 起始颜色对象。
         * @param {Object} end - 结束颜色对象。
         * @param {number} step - 渐变级数。
         * @returns {Array} 颜色数组。
         */

    }, {
        key: 'getStepColors',
        value: function getStepColors(start, end, step) {
            start = this.toRGBA(start);
            end = this.toRGBA(end);
            start = this.getData(start);
            end = this.getData(end);

            var colors = [];
            var stepR = (end[0] - start[0]) / step;
            var stepG = (end[1] - start[1]) / step;
            var stepB = (end[2] - start[2]) / step;
            var stepA = (end[3] - start[3]) / step;
            // 生成颜色集合
            // fix by linfeng 颜色堆积
            for (var i = 0, r = start[0], g = start[1], b = start[2], a = start[3]; i < step; i++) {
                colors[i] = this.toColor([this.adjust(Math.floor(r), [0, 255]), this.adjust(Math.floor(g), [0, 255]), this.adjust(Math.floor(b), [0, 255]), a.toFixed(4) - 0], 'rgba');
                r += stepR;
                g += stepG;
                b += stepB;
                a += stepA;
            }
            r = end[0];
            g = end[1];
            b = end[2];
            a = end[3];
            colors[i] = this.toColor([r, g, b, a], 'rgba');
            return colors;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getGradientColors
         * @description 获取指定级数的渐变颜色数组。
         * @param {Array.<string>} colors - 颜色数组。
         * @param {number} [step=20] - 渐变级数。
         * @returns {Array.<string>} 颜色数组。
         */

    }, {
        key: 'getGradientColors',
        value: function getGradientColors(colors, step) {
            var ret = [];
            var len = colors.length;
            if (step === undefined) {
                step = 20;
            }
            if (len === 1) {
                ret = this.getStepColors(colors[0], colors[0], step);
            } else if (len > 1) {
                for (var i = 0, n = len - 1; i < n; i++) {
                    var steps = this.getStepColors(colors[i], colors[i + 1], step);
                    if (i < n - 1) {
                        steps.pop();
                    }
                    ret = ret.concat(steps);
                }
            }
            return ret;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toColor
         * @description 颜色值数组转为指定格式颜色。
         * @param {Array} data - 颜色值数组。
         * @param {string} format - 格式，默认'rgb'
         * @returns {string} 颜色。
         */

    }, {
        key: 'toColor',
        value: function toColor(data, format) {
            format = format || 'rgb';
            if (data && (data.length === 3 || data.length === 4)) {
                data = this.map(data, function (c) {
                    return c > 1 ? Math.ceil(c) : c;
                });

                if (format.indexOf('hex') > -1) {
                    return '#' + ((1 << 24) + (data[0] << 16) + (data[1] << 8) + +data[2]).toString(16).slice(1);
                } else if (format.indexOf('hs') > -1) {
                    var sx = this.map(data.slice(1, 3), function (c) {
                        return c + '%';
                    });
                    data[1] = sx[0];
                    data[2] = sx[1];
                }

                if (format.indexOf('a') > -1) {
                    if (data.length === 3) {
                        data.push(1);
                    }
                    data[3] = this.adjust(data[3], [0, 1]);
                    return format + '(' + data.slice(0, 4).join(',') + ')';
                }

                return format + '(' + data.slice(0, 3).join(',') + ')';
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toArray
         * @description 颜色字符串转换为rgba数组。
         * @param {string} color - 颜色。
         * @returns {Array.<number>} 颜色值数组。
         */

    }, {
        key: 'toArray',
        value: function toArray(color) {
            color = this.trim(color);
            if (color.indexOf('rgba') < 0) {
                color = this.toRGBA(color);
            }

            var data = [];
            var i = 0;
            color.replace(/[\d.]+/g, function (n) {
                if (i < 3) {
                    n = n | 0;
                } else {
                    // Alpha
                    n = +n;
                }
                data[i++] = n;
            });
            return data;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.convert
         * @description 颜色格式转化。
         * @param {Array} data - 颜色值数组。
         * @param {string} format - 格式，默认'rgb'
         * @returns {string} 颜色。
         */

    }, {
        key: 'convert',
        value: function convert(color, format) {
            if (!this.isCalculableColor(color)) {
                return color;
            }
            var data = this.getData(color);
            var alpha = data[3];
            if (typeof alpha === 'undefined') {
                alpha = 1;
            }

            if (color.indexOf('hsb') > -1) {
                data = this._HSV_2_RGB(data);
            } else if (color.indexOf('hsl') > -1) {
                data = this._HSL_2_RGB(data);
            }

            if (format.indexOf('hsb') > -1 || format.indexOf('hsv') > -1) {
                data = this._RGB_2_HSB(data);
            } else if (format.indexOf('hsl') > -1) {
                data = this._RGB_2_HSL(data);
            }

            data[3] = alpha;

            return this.toColor(data, format);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toRGBA
         * @description 转换为rgba格式的颜色。
         * @param {string} color - 颜色。
         * @returns {string} 颜色。
         */

    }, {
        key: 'toRGBA',
        value: function toRGBA(color) {
            return this.convert(color, 'rgba');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toRGB
         * @description 转换为rgb数字格式的颜色。
         * @param {string} color - 颜色。
         * @returns {string} 颜色。
         */

    }, {
        key: 'toRGB',
        value: function toRGB(color) {
            return this.convert(color, 'rgb');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHex
         * @description 转换为16进制颜色。
         * @param {string} color - 颜色。
         * @returns {string} 16进制颜色，#rrggbb格式
         */

    }, {
        key: 'toHex',
        value: function toHex(color) {
            return this.convert(color, 'hex');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSVA
         * @description 转换为HSV颜色。
         * @param {string} color - 颜色。
         * @returns {string} HSVA颜色，hsva(h,s,v,a)
         */

    }, {
        key: 'toHSVA',
        value: function toHSVA(color) {
            return this.convert(color, 'hsva');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSV
         * @description 转换为HSV颜色。
         * @param {string} color - 颜色。
         * @returns {string} HSV颜色，hsv(h,s,v)
         */

    }, {
        key: 'toHSV',
        value: function toHSV(color) {
            return this.convert(color, 'hsv');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSBA
         * @description 转换为HSBA颜色。
         * @param {string} color - 颜色。
         * @returns {string} HSBA颜色，hsba(h,s,b,a)
         */

    }, {
        key: 'toHSBA',
        value: function toHSBA(color) {
            return this.convert(color, 'hsba');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSB
         * @description 转换为HSB颜色。
         * @param {string} color - 颜色。
         * @returns {string} HSB颜色，hsb(h,s,b)
         */

    }, {
        key: 'toHSB',
        value: function toHSB(color) {
            return this.convert(color, 'hsb');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSLA
         * @description 转换为HSLA颜色。
         * @param {string} color - 颜色。
         * @returns {string} HSLA颜色，hsla(h,s,l,a)
         */

    }, {
        key: 'toHSLA',
        value: function toHSLA(color) {
            return this.convert(color, 'hsla');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toHSL
         * @description 转换为HSL颜色。
         * @param {string} color - 颜色。
         * @returns {string}  HSL颜色，hsl(h,s,l)
         */

    }, {
        key: 'toHSL',
        value: function toHSL(color) {
            return this.convert(color, 'hsl');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.toName
         * @description 转换颜色名。
         * @param {string} color - 颜色。
         * @returns {string} 颜色名
         */

    }, {
        key: 'toName',
        value: function toName(color) {
            for (var key in this._nameColors) {
                if (this.toHex(this._nameColors[key]) === this.toHex(color)) {
                    return key;
                }
            }
            return null;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.trim
         * @description 移除颜色中多余空格。
         * @param {string} color - 颜色。
         * @returns {string} 无空格颜色
         */

    }, {
        key: 'trim',
        value: function trim(color) {
            return String(color).replace(/\s+/g, '');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.normalize
         * @description 颜色规范化。
         * @param {string} color - 颜色。
         * @returns {string} 规范化后的颜色
         */

    }, {
        key: 'normalize',
        value: function normalize(color) {
            // 颜色名
            if (this._nameColors[color]) {
                color = this._nameColors[color];
            }
            // 去掉空格
            color = this.trim(color);
            // hsv与hsb等价
            color = color.replace(/hsv/i, 'hsb');
            // rgb转为rrggbb
            if (/^#[\da-f]{3}$/i.test(color)) {
                color = parseInt(color.slice(1), 16);
                var r = (color & 0xf00) << 8;
                var g = (color & 0xf0) << 4;
                var b = color & 0xf;

                color = '#' + ((1 << 24) + (r << 4) + r + (g << 4) + g + (b << 4) + b).toString(16).slice(1);
            }
            // 或者使用以下正则替换，不过 chrome 下性能相对差点
            // color = color.replace(/^#([\da-f])([\da-f])([\da-f])$/i, '#$1$1$2$2$3$3');
            return color;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.lift
         * @description 颜色加深或减淡，当level>0加深，当level<0减淡。
         * @param {string} color - 颜色。
         * @param {number} level - 升降程度，取值区间[-1,1]。
         * @returns {string} 加深或减淡后颜色值
         */

    }, {
        key: 'lift',
        value: function lift(color, level) {
            if (!this.isCalculableColor(color)) {
                return color;
            }
            var direct = level > 0 ? 1 : -1;
            if (typeof level === 'undefined') {
                level = 0;
            }
            level = Math.abs(level) > 1 ? 1 : Math.abs(level);
            color = this.toRGB(color);
            var data = this.getData(color);
            for (var i = 0; i < 3; i++) {
                if (direct === 1) {
                    data[i] = data[i] * (1 - level) | 0;
                } else {
                    data[i] = (255 - data[i]) * level + data[i] | 0;
                }
            }
            return 'rgb(' + data.join(',') + ')';
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.reverse
         * @description 颜色翻转。[255-r,255-g,255-b,1-a]
         * @param {string} color - 颜色。
         * @returns {string} 翻转颜色
         */

    }, {
        key: 'reverse',
        value: function reverse(color) {
            if (!this.isCalculableColor(color)) {
                return color;
            }
            var data = this.getData(this.toRGBA(color));
            data = this.map(data, function (c) {
                return 255 - c;
            });
            return this.toColor(data, 'rgb');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.mix
         * @description 简单两种颜色混合
         * @param {string} color1 - 第一种颜色。
         * @param {string} color2 - 第二种颜色。
         * @param {number} weight - 混合权重[0-1]。
         * @returns {string} 结果色。rgb(r,g,b)或rgba(r,g,b,a)
         */

    }, {
        key: 'mix',
        value: function mix(color1, color2, weight) {
            if (!this.isCalculableColor(color1) || !this.isCalculableColor(color2)) {
                return color1;
            }

            if (typeof weight === 'undefined') {
                weight = 0.5;
            }
            weight = 1 - this.adjust(weight, [0, 1]);

            var w = weight * 2 - 1;
            var data1 = this.getData(this.toRGBA(color1));
            var data2 = this.getData(this.toRGBA(color2));

            var d = data1[3] - data2[3];

            var weight1 = ((w * d === -1 ? w : (w + d) / (1 + w * d)) + 1) / 2;
            var weight2 = 1 - weight1;

            var data = [];

            for (var i = 0; i < 3; i++) {
                data[i] = data1[i] * weight1 + data2[i] * weight2;
            }

            var alpha = data1[3] * weight + data2[3] * (1 - weight);
            alpha = Math.max(0, Math.min(1, alpha));

            if (data1[3] === 1 && data2[3] === 1) {
                // 不考虑透明度
                return this.toColor(data, 'rgb');
            }
            data[3] = alpha;
            return this.toColor(data, 'rgba');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.random
         * @description 随机颜色
         * @returns {string}  颜色值，#rrggbb格式
         */

    }, {
        key: 'random',
        value: function random() {
            return '#' + Math.random().toString(16).slice(2, 8);
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.getData
         * @description 获取颜色值数组，返回值范围。
         * RGB 范围[0-255]
         * HSL/HSV/HSB 范围[0-1]
         * A透明度范围[0-1]
         * 支持格式：
         * #rgb
         * #rrggbb
         * rgb(r,g,b)
         * rgb(r%,g%,b%)
         * rgba(r,g,b,a)
         * hsb(h,s,b) // hsv与hsb等价
         * hsb(h%,s%,b%)
         * hsba(h,s,b,a)
         * hsl(h,s,l)
         * hsl(h%,s%,l%)
         * hsla(h,s,l,a)
         * @param {string} color - 颜色。
         * @returns {Array.<number>} 颜色值数组或null
         */

    }, {
        key: 'getData',
        value: function getData(color) {
            color = this.normalize(color);
            var r = color.match(this.colorRegExp);
            if (r === null) {
                throw new Error('The color format error'); // 颜色格式错误
            }
            var d;
            var a;
            var data = [];
            var rgb;

            if (r[2]) {
                // #rrggbb
                d = r[2].replace('#', '').split('');
                rgb = [d[0] + d[1], d[2] + d[3], d[4] + d[5]];
                data = this.map(rgb, function (c) {
                    return Color.prototype.adjust.call(this, parseInt(c, 16), [0, 255]);
                });
            } else if (r[4]) {
                // rgb rgba
                var rgba = r[4].split(',');
                a = rgba[3];
                rgb = rgba.slice(0, 3);
                data = this.map(rgb, function (c) {
                    c = Math.floor(c.indexOf('%') > 0 ? parseInt(c, 0) * 2.55 : c);
                    return Color.prototype.adjust.call(this, c, [0, 255]);
                });

                if (typeof a !== 'undefined') {
                    data.push(this.adjust(parseFloat(a), [0, 1]));
                }
            } else if (r[5] || r[6]) {
                // hsb hsba hsl hsla
                var hsxa = (r[5] || r[6]).split(',');
                var h = parseInt(hsxa[0], 0) / 360;
                var s = hsxa[1];
                var x = hsxa[2];
                a = hsxa[3];
                data = this.map([s, x], function (c) {
                    return Color.prototype.adjust.call(this, parseFloat(c) / 100, [0, 1]);
                });
                data.unshift(h);
                if (typeof a !== 'undefined') {
                    data.push(this.adjust(parseFloat(a), [0, 1]));
                }
            }
            return data;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.alpha
         * @description 设置颜色透明度
         * @param {string} color - 颜色。
         * @param {number} a - 透明度,区间[0,1]。
         * @returns {string} rgba颜色值
         */

    }, {
        key: 'alpha',
        value: function alpha(color, a) {
            if (!this.isCalculableColor(color)) {
                return color;
            }
            if (a === null) {
                a = 1;
            }
            var data = this.getData(this.toRGBA(color));
            data[3] = this.adjust(Number(a).toFixed(4), [0, 1]);

            return this.toColor(data, 'rgba');
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.map
         * @description 数组映射
         * @param {Array} array - 数组。
         * @param {function} fun - 函数。
         * @returns {string} 数组映射结果
         */

    }, {
        key: 'map',
        value: function map(array, fun) {
            if (typeof fun !== 'function') {
                throw new TypeError();
            }
            var len = array ? array.length : 0;
            for (var i = 0; i < len; i++) {
                array[i] = fun(array[i]);
            }
            return array;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.adjust
         * @description 调整值区间
         * @param {Array.<number>} value - 数组。
         * @param {Array.<number>} region - 区间。
         * @returns {number} 调整后的值
         */

    }, {
        key: 'adjust',
        value: function adjust(value, region) {
            // < to <= & > to >=
            // modify by linzhifeng 2014-05-25 because -0 == 0
            if (value <= region[0]) {
                value = region[0];
            } else if (value >= region[1]) {
                value = region[1];
            }
            return value;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype.isCalculableColor
         * @description 判断是否是可计算的颜色
         * @param {string} color - 颜色。
         * @returns {boolean} 是否是可计算的颜色
         */

    }, {
        key: 'isCalculableColor',
        value: function isCalculableColor(color) {
            return color instanceof Array || typeof color === 'string';
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype._HSV_2_RGB。参见{@link http://www.easyrgb.com/index.php?X=MATH}
         */

    }, {
        key: '_HSV_2_RGB',
        value: function _HSV_2_RGB(data) {
            var H = data[0];
            var S = data[1];
            var V = data[2];
            // HSV from 0 to 1
            var R;
            var G;
            var B;
            if (S === 0) {
                R = V * 255;
                G = V * 255;
                B = V * 255;
            } else {
                var h = H * 6;
                if (h === 6) {
                    h = 0;
                }
                var i = h | 0;
                var v1 = V * (1 - S);
                var v2 = V * (1 - S * (h - i));
                var v3 = V * (1 - S * (1 - (h - i)));
                var r = 0;
                var g = 0;
                var b = 0;

                if (i === 0) {
                    r = V;
                    g = v3;
                    b = v1;
                } else if (i === 1) {
                    r = v2;
                    g = V;
                    b = v1;
                } else if (i === 2) {
                    r = v1;
                    g = V;
                    b = v3;
                } else if (i === 3) {
                    r = v1;
                    g = v2;
                    b = V;
                } else if (i === 4) {
                    r = v3;
                    g = v1;
                    b = V;
                } else {
                    r = V;
                    g = v1;
                    b = v2;
                }

                // RGB results from 0 to 255
                R = r * 255;
                G = g * 255;
                B = b * 255;
            }
            return [R, G, B];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype._HSL_2_RGB。参见{@link http://www.easyrgb.com/index.php?X=MATH}
         */

    }, {
        key: '_HSL_2_RGB',
        value: function _HSL_2_RGB(data) {
            var H = data[0];
            var S = data[1];
            var L = data[2];
            // HSL from 0 to 1
            var R;
            var G;
            var B;
            if (S === 0) {
                R = L * 255;
                G = L * 255;
                B = L * 255;
            } else {
                var v2;
                if (L < 0.5) {
                    v2 = L * (1 + S);
                } else {
                    v2 = L + S - S * L;
                }

                var v1 = 2 * L - v2;

                R = 255 * this._HUE_2_RGB(v1, v2, H + 1 / 3);
                G = 255 * this._HUE_2_RGB(v1, v2, H);
                B = 255 * this._HUE_2_RGB(v1, v2, H - 1 / 3);
            }
            return [R, G, B];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype._HUE_2_RGB。参见{@link http://www.easyrgb.com/index.php?X=MATH}
         */

    }, {
        key: '_HUE_2_RGB',
        value: function _HUE_2_RGB(v1, v2, vH) {
            if (vH < 0) {
                vH += 1;
            }
            if (vH > 1) {
                vH -= 1;
            }
            if (6 * vH < 1) {
                return v1 + (v2 - v1) * 6 * vH;
            }
            if (2 * vH < 1) {
                return v2;
            }
            if (3 * vH < 2) {
                return v1 + (v2 - v1) * (2 / 3 - vH) * 6;
            }
            return v1;
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype._RGB_2_HSB。参见{@link http://www.easyrgb.com/index.php?X=MATH}
         */

    }, {
        key: '_RGB_2_HSB',
        value: function _RGB_2_HSB(data) {
            // RGB from 0 to 255
            var R = data[0] / 255;
            var G = data[1] / 255;
            var B = data[2] / 255;

            var vMin = Math.min(R, G, B); // Min. value of RGB
            var vMax = Math.max(R, G, B); // Max. value of RGB
            var delta = vMax - vMin; // Delta RGB value
            var V = vMax;
            var H;
            var S;

            // HSV results from 0 to 1
            if (delta === 0) {
                H = 0;
                S = 0;
            } else {
                S = delta / vMax;

                var deltaR = ((vMax - R) / 6 + delta / 2) / delta;
                var deltaG = ((vMax - G) / 6 + delta / 2) / delta;
                var deltaB = ((vMax - B) / 6 + delta / 2) / delta;

                if (R === vMax) {
                    H = deltaB - deltaG;
                } else if (G === vMax) {
                    H = 1 / 3 + deltaR - deltaB;
                } else if (B === vMax) {
                    H = 2 / 3 + deltaG - deltaR;
                }

                if (H < 0) {
                    H += 1;
                }
                if (H > 1) {
                    H -= 1;
                }
            }
            H = H * 360;
            S = S * 100;
            V = V * 100;
            return [H, S, V];
        }

        /**
         * @function SuperMap.LevelRenderer.Tool.Color.prototype._RGB_2_HSL。参见{@link http://www.easyrgb.com/index.php?X=MATH}
         */

    }, {
        key: '_RGB_2_HSL',
        value: function _RGB_2_HSL(data) {

            // RGB from 0 to 255
            var R = data[0] / 255;
            var G = data[1] / 255;
            var B = data[2] / 255;

            var vMin = Math.min(R, G, B); // Min. value of RGB
            var vMax = Math.max(R, G, B); // Max. value of RGB
            var delta = vMax - vMin; // Delta RGB value

            var L = (vMax + vMin) / 2;
            var H;
            var S;
            // HSL results from 0 to 1
            if (delta === 0) {
                H = 0;
                S = 0;
            } else {
                if (L < 0.5) {
                    S = delta / (vMax + vMin);
                } else {
                    S = delta / (2 - vMax - vMin);
                }

                var deltaR = ((vMax - R) / 6 + delta / 2) / delta;
                var deltaG = ((vMax - G) / 6 + delta / 2) / delta;
                var deltaB = ((vMax - B) / 6 + delta / 2) / delta;

                if (R === vMax) {
                    H = deltaB - deltaG;
                } else if (G === vMax) {
                    H = 1 / 3 + deltaR - deltaB;
                } else if (B === vMax) {
                    H = 2 / 3 + deltaG - deltaR;
                }

                if (H < 0) {
                    H += 1;
                }

                if (H > 1) {
                    H -= 1;
                }
            }

            H = H * 360;
            S = S * 100;
            L = L * 100;

            return [H, S, L];
        }
    }]);

    return Color;
}();

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelMatrixCell = undefined;

var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                           * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                           * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.LabelMatrixCell
 * @category iServer Map Theme
 * @classdesc 矩阵标签元素抽象类。
 * @description 该类可以包含 n*n 个矩阵标签元素，矩阵标签元素的类型可以是图片，符号，标签专题图等。
 *              符号类型的矩阵标签元素类、图片类型的矩阵标签元素类和专题图类型的矩阵标签元素类均继承自该类。
 */
var LabelMatrixCell = exports.LabelMatrixCell = function LabelMatrixCell() {
  _classCallCheck(this, LabelMatrixCell);

  this.CLASS_NAME = "LabelMatrixCell";
};

_SuperMap.SuperMap.LabelMatrixCell = LabelMatrixCell;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ThemeOffset = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeOffset
 * @category  iServer Map Theme
 * @classdesc 专题图中文本或符号相对于要素内点的偏移量设置类。
 *            通过该类可以设置专题图中标记文本或符号的偏移量以及偏移量是否随地图缩放而改变。
 * @param {Object} options - 参数。
 * @param {boolean} [options.offsetFixed=false] - 当前专题图是否固定标记文本或符号的偏移量。
 * @param {string} [options.offsetX='0.0'] - 专题图中文本或符号相对于要素内点的水平偏移量。
 * @param {string} [options.offsetY='0.0'] - 专题图中文本或符号相对于要素内点的垂直偏移量。
 */
var ThemeOffset = exports.ThemeOffset = function () {
    function ThemeOffset(options) {
        _classCallCheck(this, ThemeOffset);

        /**
         * @member {boolean} [SuperMap.ThemeOffset.prototype.offsetFixed=false]
         * @description 当前专题图是否固定标记文本或符号的偏移量。所谓固定偏移量，则文本或符号的偏移量不随地图的缩放而变化。
         */
        this.offsetFixed = false;

        /**
         * @member {string} [SuperMap.ThemeOffset.prototype.offsetX=0.0]
         * @description 专题图中文本或符号相对于要素内点的水平偏移量。偏移量的单位为地图单位。
         *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么水平偏移量为2。
         */
        this.offsetX = "0.0";

        /**
         * @member {string} [SuperMap.ThemeOffset.prototype.offsetY=0.0]
         * @description 专题图中文本或符号相对于要素内点的垂直偏移量。偏移量的单位为地图单位。
         *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么垂直偏移量为2。
         */
        this.offsetY = "0.0";

        if (options) {
            _Util.Util.extend(this, options);
        }
        this.CLASS_NAME = "SuperMap.ThemeOffset";
    }

    /**
     * @function SuperMap.ThemeOffset.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(ThemeOffset, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.offsetFixed = null;
            me.offsetX = null;
            me.offsetY = null;
        }

        /**
         * @function SuperMap.ThemeOffset.fromObj
         * @description 从传入对象获取专题图中文本或符号相对于要素内点的偏移量设置类。
         * @param {Object} obj - 传入对象。
         * @returns {SuperMap.ThemeOffset} ThemeOffset 对象。
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) {
                return;
            }
            var res = new ThemeOffset();
            _Util.Util.copy(res, obj);
            return res;
        }
    }]);

    return ThemeOffset;
}();

_SuperMap.SuperMap.ThemeOffset = ThemeOffset;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ThemeFlow = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _ServerStyle = __webpack_require__(13);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeFlow
 * @category  iServer Map Theme
 * @classdesc 标签或符号流动显示和牵引线风格设置类。
 *            通过该类可以设置专题图中符号是否流动显示、是否使用牵引线以及牵引线风格。
 * @param {Object} options - 参数。
 * @param {boolean} [options.flowEnabled=false] - 是否流动显示标签或符号。
 * @param {boolean} [options.leaderLineDisplayed=false] - 是否显示标签或符号和它标注的对象之间的牵引线。
 * @param {SuperMap.ServerStyle} [options.leaderLineStyle] - 标签或符号与其标注对象之间牵引线的风格。
 */
var ThemeFlow = exports.ThemeFlow = function () {
    function ThemeFlow(options) {
        _classCallCheck(this, ThemeFlow);

        /**
         * @member {boolean} [SuperMap.ThemeFlow.prototype.flowEnabled=false]
         * @description 是否流动显示标签或符号。<br>
         *              对于标签专题图而言，对于跨越比较大的区域和线条状的几何对象，在一个地图窗口中不能完全显示的情况下，如果其标签位置比较固定，
         *              在当前地图窗口中该对象的标签不可见，则需要通过平移地图来查看对象的标签信息。如果采用了流动显示的效果，在当前地图窗口中，对象即使是部分显示，
         *              其标签也会显示在当前地图窗口中。当平移地图时，对象的标签会随之移动，以保证在当前地图窗口中部分或全部显示的对象其标签都可见，从而可以方便地查看各要素的标签信息。
         */
        this.flowEnabled = false;

        /**
         * @member {boolean} [SuperMap.ThemeFlow.prototype.leaderLineDisplayed=false]
         * @description 是否显示标签或符号和它标注的对象之间的牵引线。false表示不显示标签或符号和它标注的对象之间的牵引线。<br>
         *              只有当 flowEnabled 为 true 时，牵引线才起作用。在当标签流动显示时，其位置不固定，由于牵引线始终指向要素的内点，
         *              因而通过牵引线显示功能可以找到流动的标签或符号实际对应的要素。或者渲染符号偏移它所指向的对象时，图与对象之间可以采用牵引线进行连接。
         */
        this.leaderLineDisplayed = false;

        /**
         * @member {SuperMap.ServerStyle} SuperMap.ThemeFlow.prototype.leaderLineStyle
         * @description 标签或符号与其标注对象之间牵引线的风格。
         */
        this.leaderLineStyle = new _ServerStyle.ServerStyle();

        if (options) {
            _Util.Util.extend(this, options);
        }

        this.CLASS_NAME = "SuperMap.ThemeFlow";
    }

    /**
     * @function SuperMap.ThemeFlow.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(ThemeFlow, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.flowEnabled = null;
            me.leaderLineDisplayed = null;
            if (me.leaderLineStyle) {
                me.leaderLineStyle.destroy();
                me.leaderLineStyle = null;
            }
        }

        /**
         * @function SuperMap.ThemeFlow.fromObj
         * @description 从传入对象获取标签或符号流动显示和牵引线风格设置类。
         * @param {Object} obj - 传入对象。
         * @returns {SuperMap.ThemeFlow} ThemeFlow 对象。
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) {
                return;
            }
            var res = new ThemeFlow();
            _Util.Util.copy(res, obj);
            res.leaderLineStyle = _ServerStyle.ServerStyle.fromJson(obj.leaderLineStyle);
            return res;
        }
    }]);

    return ThemeFlow;
}();

_SuperMap.SuperMap.ThemeFlow = ThemeFlow;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ThemeLabel = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _Theme2 = __webpack_require__(26);

var _ThemeLabelItem = __webpack_require__(201);

var _ThemeUniqueItem = __webpack_require__(95);

var _ThemeFlow = __webpack_require__(68);

var _ThemeOffset = __webpack_require__(67);

var _ThemeLabelText = __webpack_require__(200);

var _ThemeLabelAlongLine = __webpack_require__(198);

var _ThemeLabelBackground = __webpack_require__(197);

var _REST = __webpack_require__(2);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.ThemeLabel
 * @category  iServer Map Theme
 * @classdesc 标签专题图类。
 * @extends SuperMap.Theme
 * @param {Object} options - 参数。
 * @param {Array.<SuperMap.ThemeUniqueItem>} options.items - 分段标签专题图的子项数组。
 * @param {string} options.labelExpression - 标注字段表达式。
 * @param {Array.<SuperMap.LabelMatrixCell>} options.matrixCells - 矩阵标签元素数组。
 * @param {SuperMap.ThemeLabelAlongLine} [options.alongLine] - 标签沿线标注方向样式类。
 * @param {SuperMap.ThemeLabelBackground} [options.background] - 标签专题图中标签的背景风格类。
 * @param {SuperMap.ThemeFlow} [options.flow] - 标签专题图标签流动显示与牵引线设置类。
 * @param {SuperMap.LabelOverLengthMode} [options.labelOverLengthMode=SuperMap.LabelOverLengthMode.NONE] - 标签专题图中超长标签的处理模式枚举类。
 * @param {number} [options.maxLabelLength=256] - 标签在每一行显示的最大长度。
 * @param {number} [options.numericPrecision=0] - 通过该字段设置其显示的精度。
 * @param {SuperMap.ThemeOffset} [options.offset] - 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。
 * @param {boolean} [options.overlapAvoided=true] - 是否允许以文本避让方式显示文本。
 * @param {string} [options.rangeExpression] - 制作分段标签专题的分段字段或字段表达式。
 * @param {boolean} [options.smallGeometryLabeled=false] - 是否显示长度大于被标注对象本身长度的标签。
 * @param {SuperMap.ThemeLabelText} options.text - 标签中文本风格。
 * @param {number} [options.textSpace=0] - 沿线标注，相邻两个文字之间的间距，单位当前设置的字高。
 * @param {SuperMap.ThemeMemoryData} [options.memoryData] - 专题图内存数据。
 */
var ThemeLabel = exports.ThemeLabel = function (_Theme) {
    _inherits(ThemeLabel, _Theme);

    function ThemeLabel(options) {
        _classCallCheck(this, ThemeLabel);

        /**
         * @member {SuperMap.ThemeLabelAlongLine} [SuperMap.ThemeLabel.prototype.alongLine]
         * @description 标签沿线标注方向样式类。
         *              在该类中可以设置标签是否沿线标注以及沿线标注的多种方式。沿线标注属性只适用于线数据集专题图。
         */
        var _this = _possibleConstructorReturn(this, (ThemeLabel.__proto__ || Object.getPrototypeOf(ThemeLabel)).call(this, "LABEL", options));

        _this.alongLine = new _ThemeLabelAlongLine.ThemeLabelAlongLine();

        /**
         * @member {SuperMap.ThemeLabelBackground} [SuperMap.ThemeLabel.prototype.background] 
         * @description 标签专题图中标签的背景风格类。通过该字段可以设置标签的背景形状和风格。
         */
        _this.background = new _ThemeLabelBackground.ThemeLabelBackground();

        /**
         * @member {SuperMap.ThemeFlow} [SuperMap.ThemeLabel.prototype.flow]
         * @description 标签专题图标签流动显示与牵引线设置类。通过该字段可以设置标签是否流动显示和牵引线风格。
         */
        _this.flow = new _ThemeFlow.ThemeFlow();

        /**
         * @member {Array.<SuperMap.ThemeUniqueItem>} [SuperMap.ThemeLabel.prototype.items]
         * @description 分段标签专题图的子项数组。分段标签专题图使用 rangeExpression
         *              指定数字型的字段作为分段数据，items 中的每个子对象的 [start，end) 分段值必须来源于属性 rangeExpression 的字段值。每个子项拥有自己的风格。
         */
        _this.items = null;

        /**
         * @member {Array.<SuperMap.ThemeLabelUniqueItem>} SuperMap.ThemeLabel.prototype.uniqueItems
         * @description 单值标签专题图子项数组。单值标签专题图使用 uniqueExpression单值标签专题图子项集合。
         */
        _this.uniqueItems = null;

        /**
         * @member {string} SuperMap.ThemeLabel.prototype.labelExpression
         * @description 标注字段表达式。系统将 labelExpression 对应的字段或字段表达式的值以标签的形式显示在图层中。
         */
        _this.labelExpression = null;

        /**
         * @member {SuperMap.LabelOverLengthMode} [SuperMap.ThemeLabel.prototype.labelOverLengthMode=SuperMap.LabelOverLengthMode.NONE] - 标签专题图中超长标签的处理模式枚举类。
         * @description 对于标签的长度超过设置的标签最大长度 maxLabelLength 时称为超长标签。
         */
        _this.labelOverLengthMode = _REST.LabelOverLengthMode.NONE;

        /**
         * @member {Array.<SuperMap.LabelMatrixCell>} SuperMap.ThemeLabel.prototype.matrixCells
         * @description 矩阵标签元素数组，用于制作矩阵标签专题图。
         *              数组中可以放置符号类型的矩阵标签元素和图片类型的矩阵标签元素。
         */
        _this.matrixCells = null;

        /**
         * @member {number} [SuperMap.ThemeLabel.prototype.maxLabelLength=256]
         * @description 标签在每一行显示的最大长度，一个中文为两个字符。
         *              如果超过最大长度，可以采用两种方式来处理，一种是换行的模式进行显示，另一种是以省略号方式显示。单位为字符。
         */
        _this.maxLabelLength = 256;

        /**
         * @member {number} [SuperMap.ThemeLabel.prototype.numericPrecision=0]
         * @description 如果显示的标签内容为数字，通过该字段设置其显示的精度。例如标签对应的数字是8071.64529347，
         *              如果该属性为0时，显示8071；为1时，显示8071.6；为3时，则是8071.645。
         */
        _this.numericPrecision = 0;

        /**
         * @member {SuperMap.ThemeOffset} [SuperMap.ThemeLabel.prototype.offset]
         * @description 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。
         */
        _this.offset = new _ThemeOffset.ThemeOffset();

        /**
         * @member {boolean} [SuperMap.ThemeLabel.prototype.overlapAvoided=true]
         * @description 是否允许以文本避让方式显示文本。true 表示自动避免文本叠盖。只针对该标签专题图层中的文本数据。
         *              在标签重叠度很大的情况下，即使使用自动避让功能，可能也无法完全避免标签重叠现象。
         */
        _this.overlapAvoided = true;

        /**
         * @member {string} SuperMap.ThemeLabel.prototype.rangeExpression
         * @description 制作分段标签专题的分段字段或字段表达式。该表达式对应的字段（或者字段表达式）的值应该为数值型。
         *              该字段与 items 分段子项联合使用，每个子项的起始值 [start，end)来源于 rangeExpression 字段值。
         *              最后 labelExpression 指定的标签字段（标签专题图要显示的具体内容）会根据分段子项的风格进行分段显示。
         */
        _this.rangeExpression = null;

        /**
         * @member {string} SuperMap.ThemeLabel.prototype.uniqueExpression
         * @description 用于制作单值专题图的字段或字段表达式。
         *              该字段值的数据类型可以为数值型或字符型。如果设置字段表达式，只能是相同数据类型字段间的运算。必须与labelExpression一起使用。
         */
        _this.uniqueExpression = null;

        /**
         * @member {boolean} [SuperMap.ThemeLabel.prototype.smallGeometryLabeled=false]
         * @description 是否显示长度大于被标注对象本身长度的标签。在标签的长度大于线或者面对象本身的长度时，
         *              如果该值为 true，则标签文字会叠加在一起显示，为了清楚完整的显示该标签，
         *              可以采用换行模式来显示标签，但必须保证每行的长度小于对象本身的长度。
         */
        _this.smallGeometryLabeled = false;

        /**
         * @member {SuperMap.ThemeLabelText} SuperMap.ThemeLabel.prototype.text
         * @description 标签中文本风格。
         */
        _this.text = new _ThemeLabelText.ThemeLabelText();

        /**
         * @member {number} [SuperMap.ThemeLabel.prototype.textSpace=0]
         * @description 沿线标注，相邻两个文字之间的间距，单位当前设置的字高。
         */
        _this.textSpace = 0;

        if (options) {
            _Util.Util.extend(_this, options);
        }

        _this.CLASS_NAME = "SuperMap.ThemeLabel";
        return _this;
    }

    /**
     * @function SuperMap.ThemeLabel.prototype.destroy
     * @override
     */


    _createClass(ThemeLabel, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeLabel.prototype.__proto__ || Object.getPrototypeOf(ThemeLabel.prototype), 'destroy', this).call(this);
            var me = this;
            me.alongLine = null;
            if (me.background) {
                me.background.destroy();
                me.background = null;
            }
            me.flow = null;
            if (me.items) {
                for (var i = 0, items = me.items, len = items.length; i < len; i++) {
                    items[i].destroy();
                }
                me.items = null;
            }
            if (me.uniqueItems) {
                for (var j = 0, uniqueItems = me.uniqueItems, uniqueLen = uniqueItems.length; j < uniqueLen; j++) {
                    uniqueItems[j].destory();
                }
                me.uniqueItems = null;
            }
            me.labelExpression = null;
            me.labelOverLengthMode = null;
            me.matrixCells = null;
            me.maxLabelLength = null;
            me.numericPrecision = null;
            me.overlapAvoided = null;
            me.rangeExpression = null;
            me.uniqueExpression = null;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            me.overlapAvoided = null;
            me.smallGeometryLabeled = null;
            if (me.text) {
                me.text.destroy();
                me.text = null;
            }
            me.textSpace = null;
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toJSON
         * @description 将themeLabel对象转化为 JSON 字符串。
         * @returns {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _Util.Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @returns {Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            obj.memoryData = this.memoryData;
            if (this.alongLine) {
                obj.alongLine = this.alongLine.isAlongLine;
                obj.alongLineDirection = this.alongLine.alongLineDirection;
                obj.angleFixed = this.alongLine.angleFixed;
                obj.isLabelRepeated = this.alongLine.isLabelRepeated;
                obj.labelRepeatInterval = this.alongLine.labelRepeatInterval;
                obj.repeatedLabelAvoided = this.alongLine.repeatedLabelAvoided;
                obj.repeatIntervalFixed = this.alongLine.repeatIntervalFixed;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }

            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.text) {
                obj.maxTextHeight = this.text.maxTextHeight;
                obj.maxTextWidth = this.text.maxTextWidth;
                obj.minTextHeight = this.text.minTextHeight;
                obj.minTextWidth = this.text.minTextWidth;
                obj.uniformStyle = this.text.uniformStyle;
                obj.uniformMixedStyle = this.text.uniformMixedStyle;
            }
            if (this.background) {
                obj.labelBackShape = this.background.labelBackShape;
                obj.backStyle = this.background.backStyle;
            }
            obj.labelOverLengthMode = this.labelOverLengthMode;
            obj.maxLabelLength = this.maxLabelLength;
            obj.smallGeometryLabeled = this.smallGeometryLabeled;
            obj.rangeExpression = this.rangeExpression;
            obj.uniqueExpression = this.uniqueExpression;
            obj.numericPrecision = this.numericPrecision;
            obj.items = this.items;
            obj.uniqueItems = this.uniqueItems;
            obj.labelExpression = this.labelExpression;
            obj.overlapAvoided = this.overlapAvoided;
            obj.matrixCells = this.matrixCells;
            obj.textSpace = this.textSpace;
            return obj;
        }

        /**
         * @function SuperMap.ThemeLabel.fromObj
         * @description 从传入对象获取标签专题图类。
         * @param {Object} obj - 传入对象。
         * @returns {SuperMap.ThemeLabel} ThemeLabel 对象。
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) {
                return;
            }
            var lab = new ThemeLabel();
            var itemsL = obj.items,
                itemsU = obj.uniqueItems,
                cells = obj.matrixCells;
            obj.matrixCells = null;
            _Util.Util.copy(lab, obj);
            lab.alongLine = _ThemeLabelAlongLine.ThemeLabelAlongLine.fromObj(obj);
            lab.background = _ThemeLabelBackground.ThemeLabelBackground.fromObj(obj);
            lab.flow = new _ThemeFlow.ThemeFlow({
                flowEnabled: obj.flowEnabled,
                leaderLineDisplayed: obj.leaderLineDisplayed,
                leaderLineStyle: obj.leaderLineStyle
            });
            if (itemsL) {
                lab.items = [];
                for (var i = 0, len = itemsL.length; i < len; i++) {
                    lab.items.push(_ThemeLabelItem.ThemeLabelItem.fromObj(itemsL[i]));
                }
            }
            if (itemsU) {
                lab.uniqueItems = [];
                for (var j = 0, uniqueLen = itemsU.length; j < uniqueLen; j++) {
                    lab.uniqueItems.push(_ThemeUniqueItem.ThemeUniqueItem.fromObj(itemsU[j]));
                }
            }
            if (cells) {
                lab.matrixCells = [];
                for (var _i = 0, _len = cells.length; _i < _len; _i++) {
                    //TODO
                    //lab.matrixCells.push(SuperMap.LabelMatrixCell.fromObj(cells[i]));
                }
            }
            lab.offset = _ThemeOffset.ThemeOffset.fromObj(obj);
            lab.text = _ThemeLabelText.ThemeLabelText.fromObj(obj);
            return lab;
        }
    }]);

    return ThemeLabel;
}(_Theme2.Theme);

_SuperMap.SuperMap.ThemeLabel = ThemeLabel;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThiessenAnalystParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThiessenAnalystParameters
 * @category  iServer SpatialAnalyst ThiessenPolygonAnalyst
 * @classdesc 泰森多边形分析参数基类。
 * @param {Object} options - 参数。
 * @param {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [options.clipRegion] - 结果数据裁剪区域，可以为 null，表示不对结果进行裁剪。
 * @param {boolean} [options.createResultDataset=false] - 是否返回结果数据集。
 * @param {string} [options.resultDatasetName] - 指定结果数据集名称。
 * @param {string} [options.resultDatasourceName] - 指定结果数据集所在数据源，默认为当前数据源。
 * @param {boolean} [options.returnResultRegion=true] - 是否返回分析得到的多边形面数组。
 */
var ThiessenAnalystParameters = exports.ThiessenAnalystParameters = function () {
  function ThiessenAnalystParameters(options) {
    _classCallCheck(this, ThiessenAnalystParameters);

    if (!options) {
      return;
    }
    /**
     * @member {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [SuperMap.ThiessenAnalystParameters.prototype.clipRegion]
     * @description 结果数据裁剪区域，可以为 null，表示不对结果进行裁剪。
     */
    this.clipRegion = null;

    /**
     *  @member {boolean} [SuperMap.ThiessenAnalystParameters.prototype.createResultDataset=false]
     *  @description 是否返回结果数据集。如果为 true，则必须设置属性 resultDatasetName 和 resultDatasourceName。
     */
    this.createResultDataset = false;

    /**
     * @member {string} SuperMap.ThiessenAnalystParameters.prototype.resultDatasetName
     * @description 指定结果数据集名称。
     */
    this.resultDatasetName = null;

    /**
     * @member {string} SuperMap.ThiessenAnalystParameters.prototype.resultDatasourceName
     * @description 指定结果数据集所在数据源。
     */
    this.resultDatasourceName = null;

    /**
     * @member {boolean} SuperMap.ThiessenAnalystParameters.prototype.returnResultRegion
     * @description 是否返回分析得到的多边形面数组。
     */
    this.returnResultRegion = true;

    _Util.Util.extend(this, options);

    this.CLASS_NAME = "SuperMap.ThiessenAnalystParameters";
  }

  /**
   * @function SuperMap.ThiessenAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(ThiessenAnalystParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      if (me.clipRegion) {
        me.clipRegion.destroy();
        me.clipRegion = null;
      }
      me.createResultDataset = null;
      me.resultDatasetName = null;
      me.resultDatasourceName = null;
      me.returnResultRegion = null;
    }
  }]);

  return ThiessenAnalystParameters;
}();

_SuperMap.SuperMap.ThiessenAnalystParameters = ThiessenAnalystParameters;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurfaceAnalystParameters = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _DataReturnOption = __webpack_require__(48);

var _REST = __webpack_require__(2);

var _SurfaceAnalystParametersSetting = __webpack_require__(230);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.SurfaceAnalystParameters
 * @category  iServer SpatialAnalyst SurfaceAnalyst
 * @classdesc 表面分析提取操作参数类。
 * @description 通过该类可以为进行表面分析提供参数信息，包括表面分析的方法提取等值线、提取等值面和中间结果的分辨率，
 * {@link SuperMap.DatasetSurfaceAnalystParameters} 和 {@link SuperMap.GeometrySurfaceAnalystParameters} 继承自该类。
 * @param {Object} options - 参数。
 * @param {SuperMap.SurfaceAnalystParametersSetting} options.extractParameter - 获取或设置表面分析参数。
 * @param {number} options.resolution - 指定中间结果（栅格数据集）的分辨率。
 * @param {SuperMap.DataReturnOption} options.resultSetting - 结果返回设置类。
 * @param {SuperMap.SurfaceAnalystMethod} [options.surfaceAnalystMethod=SuperMap.SurfaceAnalystMethod.ISOLINE] - 获取或设置表面分析的提取方法，提取等值线和提取等值面。
 */
var SurfaceAnalystParameters = exports.SurfaceAnalystParameters = function () {
  function SurfaceAnalystParameters(options) {
    _classCallCheck(this, SurfaceAnalystParameters);

    /**
     * @member {number} SuperMap.SurfaceAnalystParameters.prototype.resolution
     * @description 获取或设置指定中间结果（栅格数据集）的分辨率。
     */
    this.resolution = 0;

    /**
     * @member {SuperMap.SurfaceAnalystParametersSetting} SuperMap.SurfaceAnalystParameters.prototype.extractParameter
     * @description 获取或设置表面分析参数。
     * 在进行点数据集进行提取等值面分析时，暂时不支持 SurfaceAnalystParametersSetting 类中的 expectedZValues 字段。
     */
    this.extractParameter = new _SurfaceAnalystParametersSetting.SurfaceAnalystParametersSetting();

    /**
     * @member {SuperMap.DataReturnOption} SuperMap.SurfaceAnalystParameters.prototype.resultSetting
     * @description 结果返回设置类。
     */
    this.resultSetting = new _DataReturnOption.DataReturnOption();

    /**
     * @member {SuperMap.SurfaceAnalystMethod} [SuperMap.SurfaceAnalystParameters.prototype.surfaceAnalystMethod=SuperMap.SurfaceAnalystMethod.ISOLINE]
     * @description 获取或设置表面分析的提取方法，提取等值线和提取等值面。
     */
    this.surfaceAnalystMethod = _REST.SurfaceAnalystMethod.ISOLINE;

    if (options) {
      _Util.Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.SurfaceAnalystParameters";
  }

  /**
   * @function SuperMap.SurfaceAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  _createClass(SurfaceAnalystParameters, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.resolution = null;
      if (me.extractParameter) {
        me.extractParameter.destroy();
        me.extractParameter = null;
      }
      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }
      me.surfaceAnalystMethod = null;
    }
  }]);

  return SurfaceAnalystParameters;
}();

_SuperMap.SuperMap.SurfaceAnalystParameters = SurfaceAnalystParameters;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.JoinItem = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.JoinItem
 * @category iServer
 * @classdesc 连接信息类。
 * 该类用于矢量数据集与外部表的连接。外部表可以为另一个矢量数据集（其中纯属性数据集中没有空间几何信息）所对应的 DBMS 表，也可以是用户自建的业务表。
 * 需要注意的是，矢量数据集与外部表必须属于同一数据源。表之间的联系的建立有两种方式，一种是连接（join），一种是关联（link）。
 * 连接，实际上是依据相同的字段将一个外部表追加到指定的表；而关联是基于一个相同的字段定义了两个表格之间的联系，但不是实际的追加。
 * 用于连接两个表的字段的名称不一定相同，但类型必须一致。当两个表格之间建立了连接，通过对主表进行操作，可以对外部表进行查询，制作专题图以及分析等。
 * 当两个表格之间是一对一或多对一的关系时，可以使用 join 连接。当为多对一的关系时，允许指定多个字段之间的关联。
 *（注意：SuperMap.JoinItem 目前支持左连接和内连接，不支持全连接和右连接，UDB 引擎不支持内连接。并且用于建立连接的两个表必须在同一个数据源下。)
 * @param {Object} options - 参数。 
 * @param {string} options.foreignTableName - 外部表的名称。 
 * @param {string} options.joinFilter - 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。 
 * @param {SuperMap.JoinType} options.joinType - 两个表之间连接类型。 
 * @example 下面以 SQL 查询说明 joinItem 的使用方法：
 *(start code)
 *   function queryBySQL() {
     *       // 设置与外部表的连接信息
     *       var joinItem = new SuperMap.JoinItem({
     *           foreignTableName: "foreignTable",
     *           joinFilter: "foreignTable.CONTINENT = Countries.CONTINENT",
     *           joinType: "LEFTJOIN"
     *       })
     *       var queryParam, queryBySQLParams, queryBySQLService;
     *       // 设置查询参数，在查询参数中添加joinItem关联条件信息
     *       queryParam = new SuperMap.FilterParameter({
     *            name: "Countries@World",
     *            joinItems: [joinItem]
     *         }),
     *       queryBySQLParams = new SuperMap.QueryBySQLParameters({
     *             queryParams: [queryParam]
     *         }),
     *       queryBySQLService = new SuperMap.QueryBySQLService(url, {
     *             eventListeners: { "processCompleted": processCompleted, "processFailed": processFailed}
     *         });
     *       queryBySQLService.processAsync(queryBySQLParams);
     *  }
 *  function processCompleted(queryEventArgs) {//todo}
 *  function processFailed(e) {//todo}
 * (end)
 */
var JoinItem = exports.JoinItem = function () {
    function JoinItem(options) {
        _classCallCheck(this, JoinItem);

        /**
         * @member {string} SuperMap.JoinItem.prototype.foreignTableName
         * @description 外部表的名称。
         * 如果外部表的名称是以 “表名@数据源名” 命名方式，则该属性只需赋值表名。
         * 例如：外部表 Name@changchun，Name 为表名，changchun 为数据源名称，则该属性的赋值应为：Name。
         */
        this.foreignTableName = null;

        /**
         * @member {string} SuperMap.JoinItem.prototype.joinFilter
         * @description 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。
         * 例如，将房屋面数据集（Building）的 district 字段与房屋拥有者的纯属性数据集（Owner）的 region 字段相连接，
         * 两个数据集对应的表名称分别为 Table_Building 和 Table_Owner，
         * 则连接表达式为 Table_Building.district = Table_Owner.region。
         * 当有多个字段相连接时，用 AND 将多个表达式相连。
         */
        this.joinFilter = null;

        /**
         * @member {SuperMap.JoinType} SuperMap.JoinItem.prototype.joinType
         * @description 两个表之间连接类型。
         * 连接类型决定了对两个表进行连接查询后返回的记录的情况。
         */
        this.joinType = null;

        if (options) {
            _Util.Util.extend(this, options);
        }
        this.CLASS_NAME = "SuperMap.JoinItem";
    }

    /**
     * @function SuperMap.JoinItem.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    _createClass(JoinItem, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.foreignTableName = null;
            me.joinFilter = null;
            me.joinType = null;
        }

        /**
         * @function SuperMap.JoinItem.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var dataObj = {};
            dataObj = _Util.Util.copyAttributes(dataObj, this);
            //joinFilter基本是个纯属性对象，这里不再做转换
            return dataObj;
        }
    }]);

    return JoinItem;
}();

_SuperMap.SuperMap.JoinItem = JoinItem;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.IPortalServiceBase = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

var _REST = __webpack_require__(2);

var _SecurityManager = __webpack_require__(37);

var _Credential = __webpack_require__(108);

var _FetchRequest = __webpack_require__(16);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.iPortalServiceBase
 * @classdesc iPortal 服务基类（有权限限制的类需要实现此类）。
 * @category iPortal/Online
 * @param {string} url - iPortal 服务地址。
 * @param {Object} options - 可选参数。
 * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
 */
var IPortalServiceBase = exports.IPortalServiceBase = function () {
    function IPortalServiceBase(url, options) {
        _classCallCheck(this, IPortalServiceBase);

        options = options || {};
        this.serviceUrl = url;
        this.serverType = _REST.ServerType.iPortal;
        this.CLASS_NAME = "SuperMap.iPortalServiceBase";
        this.withCredentials = options.withCredentials || false;
    }

    /**
     * @function SuperMap.iPortalServiceBase.prototype.request
     * @description 子类统一通过该方法发送请求。
     * @param {string} [method='GET'] - 请求类型。
     * @param {string} url - 服务地址。
     * @param {Object} param - 请求参数。
     * @param {Object} [requestOptions] - fetch 请求配置项。
     * @returns {Promise} 返回包含请求结果的 Promise 对象。
     */

    _createClass(IPortalServiceBase, [{
        key: 'request',
        value: function request(method, url, param) {
            var requestOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : { withCredentials: this.withCredentials };

            url = this.createCredentialUrl(url);
            return _FetchRequest.FetchRequest.commit(method, url, param, requestOptions).then(function (response) {
                return response.json();
            });
        }

        /**
         * @function SuperMap.iPortalServiceBase.prototype.createCredentialUrl
         * @description 追加授权信息。
         * @param {string} url - 创建证书 URL 地址。
         * @returns {string} 携带 token 或 key 的新地址。
         */

    }, {
        key: 'createCredentialUrl',
        value: function createCredentialUrl(url) {
            var newUrl = url,
                credential = this.getCredential();

            if (credential) {
                var endStr = newUrl.substring(newUrl.length - 1, newUrl.length);

                if (newUrl.indexOf("?") > -1 && endStr === "?") {
                    newUrl += credential.getUrlParameters();
                } else if (newUrl.indexOf("?") > -1 && endStr !== "?") {
                    newUrl += "&" + credential.getUrlParameters();
                } else {
                    newUrl += "?" + credential.getUrlParameters();
                }
            }
            return newUrl;
        }

        /**
         * @function SuperMap.iPortalServiceBase.prototype.getCredential
         * @description 获取 token。
         * @returns {string} 返回获取的 token。
         *
         */

    }, {
        key: 'getCredential',
        value: function getCredential() {
            var credential,
                value = _SecurityManager.SecurityManager.getToken(this.serviceUrl);
            credential = value ? new _Credential.Credential(value, "token") : null;
            if (!credential) {
                value = this.getKey();
                credential = value ? new _Credential.Credential(value, "key") : null;
            }
            return credential;
        }

        /**
         * @function SuperMap.iPortalServiceBase.prototype.getKey
         * @description 其子类需要重写该方法，修改其中获取 key 的字段，存储 key 可能是服务 ID 字段，可能是 URL。
         */

    }, {
        key: 'getKey',
        value: function getKey() {
            //return SuperMap.SecurityManager.getKey(this.id);
            //或
            //return SuperMap.SecurityManager.getKey(this.serviceUrl);
        }
    }]);

    return IPortalServiceBase;
}();

_SuperMap.SuperMap.iPortalServiceBase = IPortalServiceBase;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Route = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _Util = __webpack_require__(1);

var _LinearRing = __webpack_require__(38);

var _LineString = __webpack_require__(22);

var _PointWithMeasure = __webpack_require__(257);

var _Collection2 = __webpack_require__(31);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Route
 * @category  iServer SpatialAnalyst
 * @classdesc 路由对象类。路由对象为一系列有序的带有属性值 M 的 x，y 坐标对，其中 M 值为该结点的距离属性（到已知点的距离）。
 * @param {Array.<SuperMap.Geometry>} points - 形成路由对象的线数组。
 * @param {Object} options - 参数。
 * @param {number} options.id - 路由对象在数据库中的 id。
 * @param {number} options.length - 路由对象的长度。单位与数据集的单位相同。
 * @param {number} [options.maxM] - 最大线性度量值，即所有结点到起始点的量算距离中最大值。
 * @param {number} [options.minM] - 最小线性度量值，即所有结点到起始点的量算距离中最小值。
 * @param {string} [options.type] - 数据类型，如："LINEM"。
 * @extends {SuperMap.Geometry.Collection}
 */
var Route = exports.Route = function (_Collection) {
    _inherits(Route, _Collection);

    function Route(points, options) {
        _classCallCheck(this, Route);

        /**
         * @member {number} SuperMap.Route.prototype.id
         * @description 路由对象在数据库中的 ID。
         */
        var _this = _possibleConstructorReturn(this, (Route.__proto__ || Object.getPrototypeOf(Route)).call(this, points, options));

        _this.id = null;

        /**
         * @member {number} SuperMap.Route.prototype.center
         * @description 路由对象的中心点。
         */
        _this.center = null;

        /**
         * @member {string} SuperMap.Route.prototype.style
         * @description 路由对象的样式。
         */
        _this.style = null;

        /**
         * @member {number} SuperMap.Route.prototype.length
         * @description 路由对象的长度。单位与数据集的单位相同。
         */
        _this.length = null;

        /**
         *  @member {number} SuperMap.Route.prototype.maxM
         *  @description 最大线性度量值，即所有结点到起始点的量算距离中最大值。
         */
        _this.maxM = null;

        /**
         * @member {number} SuperMap.Route.prototype.minM
         * @description 最小线性度量值，即所有结点到起始点的量算距离中最小值。
         */
        _this.minM = null;

        /**
         * @member {Array.<number>} SuperMap.Route.prototype.parts
         * @description 服务端几何对象中各个子对象所包含的节点个数。
         */
        _this.parts = null;

        /**
         * @member {Array.<Object>} SuperMap.Route.prototype.points
         * @description 路由对象的所有路由点。
         * @example
         * (start code)
         * [
         *  {
         *      "measure": 0,
         *      "y": -4377.027184298267,
         *      "x": 4020.0045221720466
         *  },
         *  {
         *      "measure": 37.33288381391519,
         *      "y": -4381.569363260499,
         *      "x": 4057.0600591960642
         *  }
         * ]
         * (end)
         */
        _this.points = null;

        /**
         * @member {string} SuperMap.Route.prototype.type
         * @description 服务端几何对象类型。
         */
        _this.type = null;

        /**
         * @member {Array.<string>} [SuperMap.Route.prototype.componentTypes=SuperMap.Geometry.LineString]
         * @description components 存储的的几何对象所支持的几何类型数组。
         */
        _this.componentTypes = ["SuperMap.Geometry.LinearRing", "SuperMap.Geometry.LineString"];

        if (options) {
            _Util.Util.extend(_this, options);
        }

        _this.CLASS_NAME = "SuperMap.Route";
        _this.geometryType = "LINEM";
        return _this;
    }

    /**
     *
     * @function SuperMap.Route.prototype.toJson
     * @description 转换为 JSON 对象。
     * @returns {Object} JSON 对象。
     */


    _createClass(Route, [{
        key: 'toJson',
        value: function toJson() {
            var result = "{";
            if (this.id != null && this.id != undefined) {
                result += "\"id\":" + this.id + ",";
            }
            if (this.center != null && this.center != undefined) {
                result += "\"center\":" + this.center + ",";
            }
            if (this.style != null && this.style != undefined) {
                result += "\"style\":" + this.style + ",";
            }
            if (this.length != null && this.length != undefined) {
                result += "\"length\":" + this.length + ",";
            }
            if (this.maxM != null && this.maxM != undefined) {
                result += "\"maxM\":" + this.maxM + ",";
            }
            if (this.minM != null && this.minM != undefined) {
                result += "\"minM\":" + this.minM + ",";
            }
            if (this.type != null && this.type != undefined) {
                result += "\"type\":\"" + this.type + "\",";
            }
            if (this.parts != null && this.parts != undefined) {
                result += "\"parts\":[" + this.parts[0];

                for (var i = 1; i < this.parts.length; i++) {
                    result += "," + this.parts[i];
                }
                result += "],";
            }
            if (this.components != null && this.components.length > 0) {
                result += "\"points\":[";
                for (var j = 0, len = this.components.length; j < len; j++) {
                    for (var k = 0, len2 = this.components[j].components.length; k < len2; k++) {
                        result += this.components[j].components[k].toJson() + ",";
                    }
                }
                result = result.replace(/,$/g, '');
                result += "]";
            }
            result = result.replace(/,$/g, '');
            result += "}";
            return result;
        }

        /**
         * @function SuperMap.Route.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.id = null;
            me.center = null;
            me.style = null;
            me.length = null;
            me.maxM = null;
            me.minM = null;
            me.type = null;
            me.parts = null;
            me.components.length = 0;
            me.components = null;
            me.componentTypes = null;
        }

        /**
         * @function SuperMap.Route.fromJson
         * @description 将 JSON 对象转换为 SuperMap.Route 对象。
         * @param {Object} [jsonObject] - JSON 对象表示的路由对象。
         * @returns {SuperMap.Route} 转化后的 Route 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }

            var geoParts = jsonObject.parts || [],
                geoPoints = jsonObject.points || [],
                len = geoParts.length,
                lineList = [];
            if (len > 0) {
                for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                    for (var j = 0; j < geoParts[i]; j++) {
                        pointList.push(_PointWithMeasure.PointWithMeasure.fromJson(geoPoints[pointIndex + j]));
                    }
                    pointIndex += geoParts[i];
                    //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                    if (pointList[0].equals(pointList[geoParts[i] - 1])) {
                        lineList.push(new _LinearRing.LinearRing(pointList));
                    } else {
                        lineList.push(new _LineString.LineString(pointList));
                    }
                    pointList = [];
                }
            } else {
                return null;
            }

            return new Route(lineList, {
                id: jsonObject.id,
                center: jsonObject.center,
                style: jsonObject.style,
                length: jsonObject.length,
                maxM: jsonObject.maxM,
                minM: jsonObject.minM,
                type: jsonObject.type,
                parts: jsonObject.parts
            });
        }
    }]);

    return Route;
}(_Collection2.Collection);

_SuperMap.SuperMap.Route = Route;

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Vector = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _Feature2 = __webpack_require__(258);

var _Util = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Feature.Vector
 * @category BaseTypes Geometry
 * @classdesc 矢量要素类。该类具有 Geometry 属性存放几何信息，
 * attributes 属性存放非几何信息，另外还包含了 style 属性，用来定义矢量要素的样式，
 * 其中，默认的样式在 {@link SuperMap.Feature.Vector.style} 类中定义，如果没有特别的指定将使用默认的样式。
 * @extends {SuperMap.Feature}
 * @param {SuperMap.Geometry} geometry - 代表要素的几何形状。
 * @param {Object} [attributes] - 描述要素的任意的可序列化属性，将要映射到 attributes 属性中的对象。
 * @param {Object} [style] - 样式对象。
 * @example
 * var geometry = new SuperMap.Geometry.Point(-115,10);
 *  var style = {
     *      strokeColor:"#339933",
     *      strokeOpacity:1,
     *      strokeWidth:3,
     *      pointRadius:6
     *  }
 *  var pointFeature = new SuperMap.Feature.Vector(geometry,null,style);
 *  vectorLayer.addFeatures(pointFeature);
 */
var Vector = exports.Vector = function (_Feature) {
    _inherits(Vector, _Feature);

    function Vector(geometry, attributes, style) {
        _classCallCheck(this, Vector);

        /**
         * @member {string} SuperMap.Feature.Vector.prototype.fid
         * @description fid
         */
        var _this = _possibleConstructorReturn(this, (Vector.__proto__ || Object.getPrototypeOf(Vector)).call(this, null, null, attributes));

        _this.fid = null;

        /**
         * @member {SuperMap.Geometry} SuperMap.Feature.Vector.prototype.geometry
         * @description 该属性用于存放几何信息。
         */
        _this.geometry = geometry ? geometry : null;

        /**
         * @member {Object} SuperMap.Feature.Vector.prototype.attributes
         * @description 描述要素的任意的可序列化属性。
         */
        _this.attributes = {};

        if (attributes) {
            _this.attributes = _Util.Util.extend(_this.attributes, attributes);
        }

        /**
         * @member {SuperMap.Bounds} SuperMap.Feature.Vector.prototype.bounds
         * @description The box bounding that feature's geometry, that
         *     property can be set by an <SuperMap.Format> object when
         *     deserializing the feature, so in most cases it represents an
         *     information set by the server.
         */
        _this.bounds = null;

        /**
         * @member {string} SuperMap.Feature.Vector.prototype.state
         * @description state
         */
        _this.state = null;

        /**
         * @member {Object} SuperMap.Feature.Vector.prototype.style
         * @description 要素的样式属性，地图查询返回的 feature 的 style，8C 变为null。
         */
        _this.style = style ? style : null;

        /**
         * @member {string} SuperMap.Feature.Vector.prototype.url 
         * @description 如果设置了这个属性，在更新或者删除要素时需要考虑 {@link SuperMap.HTTP} 。
         */
        _this.url = null;

        _this.lonlat = null;

        _this.CLASS_NAME = "SuperMap.Feature.Vector";
        // TRASH THIS
        _SuperMap.SuperMap.State = {
            /** states */
            UNKNOWN: 'Unknown',
            INSERT: 'Insert',
            UPDATE: 'Update',
            DELETE: 'Delete'
        };

        Vector.style = {
            'default': {
                fillColor: "#ee9900",
                fillOpacity: 0.4,
                hoverFillColor: "white",
                hoverFillOpacity: 0.8,
                strokeColor: "#ee9900",
                strokeOpacity: 1,
                strokeWidth: 1,
                strokeLinecap: "round",
                strokeDashstyle: "solid",
                hoverStrokeColor: "red",
                hoverStrokeOpacity: 1,
                hoverStrokeWidth: 0.2,
                pointRadius: 6,
                hoverPointRadius: 1,
                hoverPointUnit: "%",
                pointerEvents: "visiblePainted",
                cursor: "inherit",
                fontColor: "#000000",
                labelAlign: "cm",
                labelOutlineColor: "white",
                labelOutlineWidth: 3
            },
            'select': {
                fillColor: "blue",
                fillOpacity: 0.4,
                hoverFillColor: "white",
                hoverFillOpacity: 0.8,
                strokeColor: "blue",
                strokeOpacity: 1,
                strokeWidth: 2,
                strokeLinecap: "round",
                strokeDashstyle: "solid",
                hoverStrokeColor: "red",
                hoverStrokeOpacity: 1,
                hoverStrokeWidth: 0.2,
                pointRadius: 6,
                hoverPointRadius: 1,
                hoverPointUnit: "%",
                pointerEvents: "visiblePainted",
                cursor: "pointer",
                fontColor: "#000000",
                labelAlign: "cm",
                labelOutlineColor: "white",
                labelOutlineWidth: 3

            },
            'temporary': {
                fillColor: "#66cccc",
                fillOpacity: 0.2,
                hoverFillColor: "white",
                hoverFillOpacity: 0.8,
                strokeColor: "#66cccc",
                strokeOpacity: 1,
                strokeLinecap: "round",
                strokeWidth: 2,
                strokeDashstyle: "solid",
                hoverStrokeColor: "red",
                hoverStrokeOpacity: 1,
                hoverStrokeWidth: 0.2,
                pointRadius: 6,
                hoverPointRadius: 1,
                hoverPointUnit: "%",
                pointerEvents: "visiblePainted",
                //cursor:"inherit",
                cursor: "default",
                fontColor: "#000000",
                labelAlign: "cm",
                labelOutlineColor: "white",
                labelOutlineWidth: 3

            },
            'delete': {
                display: "none"
            }
        };
        return _this;
    }

    /**
     * @function SuperMap.Feature.Vector.prototype.destroy
     * @description nullify references to prevent circular references and memory leaks
     */


    _createClass(Vector, [{
        key: 'destroy',
        value: function destroy() {
            if (this.layer) {
                this.layer.removeFeatures(this);
                this.layer = null;
            }

            this.geometry = null;
            _get(Vector.prototype.__proto__ || Object.getPrototypeOf(Vector.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.clone
         * @description Create a clone of this vector feature.  Does not set any non-standard
         *     properties.
         * @returns {SuperMap.Feature.Vector} An exact clone of this vector feature.
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new Vector(this.geometry ? this.geometry.clone() : null, this.attributes, this.style);
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.toState
         * @description 设置新状态。
         * @param {string} state - 状态。
         */

    }, {
        key: 'toState',
        value: function toState(state) {
            if (state === _SuperMap.SuperMap.State.UPDATE) {
                switch (this.state) {
                    case _SuperMap.SuperMap.State.UNKNOWN:
                    case _SuperMap.SuperMap.State.DELETE:
                        this.state = state;
                        break;
                    case _SuperMap.SuperMap.State.UPDATE:
                    case _SuperMap.SuperMap.State.INSERT:
                        break;
                }
            } else if (state === _SuperMap.SuperMap.State.INSERT) {
                switch (this.state) {
                    case _SuperMap.SuperMap.State.UNKNOWN:
                        break;
                    default:
                        this.state = state;
                        break;
                }
            } else if (state === _SuperMap.SuperMap.State.DELETE) {
                switch (this.state) {
                    case _SuperMap.SuperMap.State.INSERT:
                        // the feature should be destroyed
                        break;
                    case _SuperMap.SuperMap.State.DELETE:
                        break;
                    case _SuperMap.SuperMap.State.UNKNOWN:
                    case _SuperMap.SuperMap.State.UPDATE:
                        this.state = state;
                        break;
                }
            } else if (state === _SuperMap.SuperMap.State.UNKNOWN) {
                this.state = state;
            }
        }
    }]);

    return Vector;
}(_Feature2.Feature);
/**
 *
 * @typedef {Object} SuperMap.Feature.Vector.style
 * @description SuperMap.features 有大量的样式属性，如果没有特别的指定将使用默认的样式，
 * 大部分样式通过 SVG 标准定义属性。
 * - fill properties 资料介绍：{@link http://www.w3.org/TR/SVG/painting.html#FillProperties}
 * - stroke properties 资料介绍：{@link http://www.w3.org/TR/SVG/painting.html#StrokeProperties}
 * @property {boolean} [fill] - 不需要填充则设置为 false。
 * @property {string} [fillColor='#ee9900'] - 十六进制填充颜色。
 * @property {number} [fillOpacity=0.4] - 填充不透明度。
 * @property {boolean} [stroke] - 不需要描边则设为 false。
 * @property {string} [strokeColor='#ee9900'] - 十六进制描边颜色。
 * @property {number} [strokeOpacity=0.4] - 描边的不透明度(0-1)。
 * @property {number} [strokeWidth=1] - 像素描边宽度。
 * @property {string} [strokeLinecap='round'] - strokeLinecap 有三种类型 butt，round，square。
 * @property {string} [strokeDashstyle='solid'] - 有 dot，dash，dashdot，longdash，longdashdot，solid 几种样式。
 * @property {boolean} [graphic] - 不需要则设置为 false。
 * @property {number} [pointRadius=6] - 像素点半径。
 * @property {string} [pointerEvents='visiblePainted'] - pointerEvents。
 * @property {string} [cursor] - cursor。
 * @property {boolean} [allowRotate='false'] - 是否允许图标随着运行方向旋转。用于时空数据图层。
 * @property {string} [externalGraphic] - 连接到用来渲染点的外部的图形。
 * @property {number} [graphicWidth] - 外部图表的像素宽度。
 * @property {number} [graphicHeight] - 外部图表的高宽度。
 * @property {number} [graphicOpacity] - 外部图表的不透明度(0-1)。
 * @property {number} [graphicXOffset] - 外部图表沿着x方向的偏移量。
 * @property {number} [graphicYOffset] - 外部图表沿着y方向的偏移量 Pixel。
 * @property {number} [rotation] - 一个图表沿着其中心点（或者偏移中心指定点）在顺时针方向旋转。
 * @property {number} [graphicZIndex] - 渲染时使用的索引值。
 * @property {string} [graphicName='circle'] - 渲染点时图标使用的名字。支持"circle" , "square", "star", "x", "cross", "triangle"。
 * @property {string} [graphicTitle] - 外部图表的提示框。
 * @property {string} [backgroundGraphic] - 外部图表的背景。
 * @property {number} [backgroundGraphicZIndex] - 背景图渲染时使用的索引值。
 * @property {number} [backgroundXOffset] - 背景图在 x 轴的偏移量。
 * @property {number} [backgroundYOffset] - 背景图在 y 轴的偏移量。
 * @property {number} [backgroundHeight] - 背景图的高度。如果没有设置，将用 graphicHeight。
 * @property {number} [backgroundWidth] - 背景图的宽度。如果没有设置，将用 graphicWidth。
 * @property {boolean} [isUnicode=false] - 这个属性要配合 label 属性来用，当为 true时，label 就可以使用 unicode 编码，
 * 比如 "a" 的 unicode 十六进制编码为 61，则 label 属性可以为 "&#x61;",其中 "&#" 为前缀，标志这个为 unicode 编码，
 * "x" 是指 16 进制,这时页面显示的是 "a"；当此值为 false 的时候，label 的内容会被直接输出，
 * 比如，label 为 "&#x61;"，这时页面显示的也是 "&#x61;"。
 * @property {string} [label] - 可选的标签文本。
 * @property {string} [labelAlign='cm'] - 标签对齐，是由两个字符组成的字符串，如："lt", "cm", "rb"，
 * 其中第一个字符代表水平方向上的对齐，"l"=left, "c"=center, "r"=right；
 * 第二个字符代表垂直方向上的对齐，"t"=top, "m"=middle, "b"=bottom。
 * @property {number} [labelXOffset] - 标签在 x 轴方向的偏移量。
 * @property {number} [labelYOffset] - 标签在 y 轴方向的偏移量。
 * @property {boolean} [labelSelect=false] - 如果设为 true，标签可以选用 SelectFeature 或者 similar 控件。
 * @property {string} [fontColor='#000000'] - 标签字体颜色。
 * @property {number} [fontOpacity] - 标签透明度 (0-1)。
 * @property {string} [fontFamily] - 标签的字体类型。
 * @property {string} [fontSize] - 标签的字体大小。
 * @property {string} [fontStyle] - 标签的字体样式。
 * @property {string} [fontWeight] - 标签的字体粗细。
 * @property {string} [display] - 如果 display 属性设置为 “none”，符号将没有任何效果。
 * @example
 *  // label的用法如下：
 *  function addGeoTest(){
 *  var geometry = new SuperMap.Geometry.Point(105, 35);
 *  var pointFeature = new SuperMap.Feature.Vector(geometry);
 *  var styleTest = {
 *        label:"supermap",
 *        fontColor:"#0000ff",
 *        fontOpacity:"0.5",
 *        fontFamily:"隶书",
 *        fontSize:"8em",
 *        fontWeight:"bold",
 *        fontStyle:"italic",
 *        labelSelect:"true",
 *     }
 *           pointFeature.style = styleTest;
 *          vectorLayer.addFeatures([pointFeature]);
 * }
     */


_SuperMap.SuperMap.Feature.Vector = Vector;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Pixel = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _SuperMap = __webpack_require__(0);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Pixel
 * @category BaseTypes Geometry
 * @classdesc 此类用 x,y 坐标描绘屏幕坐标（像素点）。
 * @param {number} [x=0.0] - x 坐标。
 * @param {number} [y=0.0] - y 坐标。
 * @param {SuperMap.Pixel.Mode} [mode=SuperMap.Pixel.Mode.LeftTop] - 坐标模式。
 *
 * @example
 * //单独创建一个对象
 * var pixcel = new SuperMap.Pixel(100,50);
 *
 * //依据 size 创建
 *  var size = new SuperMap.Size(21,25);
 *  var offset = new SuperMap.Pixel(-(size.w/2), -size.h);
 */
var Pixel = exports.Pixel = function () {
    function Pixel(x, y, mode) {
        _classCallCheck(this, Pixel);

        /**
         * @member {number} [SuperMap.Pixel.prototype.x=0.0]
         * @description x 坐标。
         */
        this.x = x ? parseFloat(x) : 0.0;

        /**
         * @member {number} [SuperMap.Pixel.prototype.y=0.0]
         * @description y 坐标。
         */
        this.y = y ? parseFloat(y) : 0.0;

        /**
         * @member {SuperMap.Pixel.Mode} [SuperMap.Pixel.prototype.mode=SuperMap.Pixel.Mode.LeftTop]
         * @description 坐标模式，有左上、右上、右下、左下这几种模式，分别表示相对于左上角、右上角、右下角、左下角的坐标。 
         */
        this.mode = mode;
        this.CLASS_NAME = "SuperMap.Pixel";
        /**
         * @enum SuperMap.Pixel.Mode
         * @readonly
         * @description 模式。
         * @type {string}
         */

        _SuperMap.SuperMap.Pixel.Mode = {
            /** 左上模式。*/
            LeftTop: "lefttop",
            /** 右上模式。 */
            RightTop: "righttop",
            /** 右下模式。 */
            RightBottom: "rightbottom",
            /** 左下模式。 */
            LeftBottom: "leftbottom"
        };
    }

    /**
     * @function SuperMap.Pixel.prototype.toString
     * @description 返回此对象的字符串形式。
     * @example
     *
     * var pixcel = new SuperMap.Pixel(100,50);
     * var str = pixcel.toString();
     *
     * @returns {string} 例如: "x=200.4,y=242.2"
     */


    _createClass(Pixel, [{
        key: "toString",
        value: function toString() {
            return "x=" + this.x + ",y=" + this.y;
        }

        /**
         * @function SuperMap.Pixel.prototype.clone
         * @description 克隆当前的 pixel 对象。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = pixcel.clone();
         * @returns {SuperMap.Pixel} 返回一个新的与当前 pixel 对象有相同 x、y 坐标的 pixel 对象。
         */

    }, {
        key: "clone",
        value: function clone() {
            return new Pixel(this.x, this.y, this.mode);
        }

        /**
         * @function SuperMap.Pixel.prototype.equals
         * @description 比较两 pixel 是否相等。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(100,50);
         * var isEquals = pixcel.equals(pixcel2);
         *
         * @param {SuperMap.Pixel} px - 用于比较相等的 pixel 对象。
         * @returns {boolean} 如果传入的像素点和当前像素点相同返回 true，如果不同或传入参数为 NULL 则返回 false。
         */

    }, {
        key: "equals",
        value: function equals(px) {
            var equals = false;
            if (px != null) {
                equals = this.x == px.x && this.y == px.y || isNaN(this.x) && isNaN(this.y) && isNaN(px.x) && isNaN(px.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Pixel.prototype.distanceTo
         * @description 返回两个 pixel 的距离。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(110,30);
         * var distance = pixcel.distanceTo(pixcel2);
         *
         * @param {SuperMap.Pixel} px - 用于计算的一个 pixel。
         * @returns {float} 作为参数传入的像素与当前像素点的距离。
         */

    }, {
        key: "distanceTo",
        value: function distanceTo(px) {
            return Math.sqrt(Math.pow(this.x - px.x, 2) + Math.pow(this.y - px.y, 2));
        }

        /**
         * @function SuperMap.Pixel.prototype.add
         * @description 在原来像素坐标基础上，x 值加上传入的 x 参数，y 值加上传入的 y 参数。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * //pixcel2是新的对象
         * var pixcel2 = pixcel.add(20,30);
         *
         * @param {number} x - 传入的 x 值。
         * @param {number} y - 传入的 y 值。
         * @returns {SuperMap.Pixel} 返回一个新的 pixel 对象，该 pixel 是由当前的 pixel 与传入的 x，y 相加得到。
         */

    }, {
        key: "add",
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Pixel.add cannot receive null values');
            }
            return new Pixel(this.x + x, this.y + y);
        }

        /**
         * @function SuperMap.Pixel.prototype.offset
         * @description 通过传入的 {@link SuperMap.Pixel} 参数对原屏幕坐标进行偏移。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(130,20);
         * //pixcel3 是新的对象
         * var pixcel3 = pixcel.offset(pixcel2);
         *
         * @param {SuperMap.Pixel} px - 传入的 <SuperMap.Pixel> 对象。
         * @returns {SuperMap.Pixel} 返回一个新的 pixel，该 pixel 是由当前的 pixel 对象的 x，y 值与传入的 Pixel 对象的 x，y 值相加得到。
         */

    }, {
        key: "offset",
        value: function offset(px) {
            var newPx = this.clone();
            if (px) {
                newPx = this.add(px.x, px.y);
            }
            return newPx;
        }

        /**
         *
         * @function SuperMap.Pixel.prototype.destroy
         * @description 销毁此对象。销毁后此对象的所有属性为 null，而不是初始值。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * pixcel.destroy();
         */

    }, {
        key: "destroy",
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.mode = null;
        }
    }]);

    return Pixel;
}();

_SuperMap.SuperMap.Pixel = Pixel;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Graphic = __webpack_require__(293);

Object.defineProperty(exports, 'Graphic', {
  enumerable: true,
  get: function get() {
    return _Graphic.Graphic;
  }
});

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Theme3DLayer = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class mapboxgl.supermap.Theme3DLayer
 * @category  Visualization Theme
 * @classdesc 三维专题图基类,不能直接实例化。
 * @param  {string} [id] - 专题图图层 id。默认使用 CommonUtil.createUniqueID("theme3DLayer") 创建专题图层 ID。
 * @param  {Object} layerOptions -专题图图层配置项。
 * @param  {number} [layerOptions.opacity=1] - 图层透明度。
 * @param  {boolean} [layerOptions.parseNumber=fasle] - 是否预处理数据，将数据转换为 number。
 * @param  {boolean} [layerOptions.enableHighlight=false] - 是否开启高亮。
 * @param  {string} [layerOptions.highlight="#ADA91E"] - 高亮颜色。
 * @param  {string} [layerOptions.baseHeightField] - 数据中表示基础高度的字段。
 * @param  {number} [layerOptions.height] - 高度。如果数据指定的 heightField (为height)没有可以表示高度的字段，可以为所有数据统一设置一个高度。
 * @param  {string} [layerOptions.heightField] - 数据中表示高度的字段。
 * @param  {string} [layerOptions.themeField] - 专题展示的字段。
 * @param  {boolean} [playerOptions.showLegend=true] - 是否显示图例。
 * @param  {string} [layerOptions.legendTitle] - 图例标题。
 * @param  {string} [layerOptions.legendTheme='light'] - 图例主题，取值：'light','dark'。
 * @param  {string} [layerOptions.legendOrientation='horizontal'] - 图例方向，取值：'horizontal','vertical'。
 * @param  {string} [layerOptions.legendPosition] - 图例位置，取值：'top-right'|'top-left'|'bottom-left'|'bottom-right'。
 */
var Theme3DLayer = exports.Theme3DLayer = function () {
    function Theme3DLayer(id, layerOptions) {
        _classCallCheck(this, Theme3DLayer);

        /**
         * @member {string} mapboxgl.supermap.Theme3DLayer.prototype.id 
         * @description Mapbox GL 图层 id。
         */
        this.id = id;

        /**
         * @member {Object} mapboxgl.supermap.Theme3DLayer.prototype.map 
         * @description Mapbox GL 地图对象。
         */
        this.map = null;
        /**
         * @member {number} [mapboxgl.supermap.Theme3DLayer.prototype.opacity=1] 
         * @description 图层透明度。
         */
        this.opacity = 1;
        /**
         * @member {boolean} [mapboxgl.supermap.Theme3DLayer.prototype.parseNumber=false]
         * @description 是否进行数据预处理,有些字段是 string 类型，需要转换为 number。
         */
        this.parseNumber = false;
        /**
         * @member {boolean} [mapboxgl.supermap.Theme3DLayer.prototype.enableHighlight=false]
         * @description 是否开启高亮。
         */
        this.enableHighlight = false;

        /**
         * @member {Object} [mapboxgl.supermap.Theme3DLayer.prototype.highlight={color: "#ADA91E"}]
         * @description 高亮相关配置。
         */
        this.highlight = { color: "#ADA91E" };

        /**
         * @member {string} mapboxgl.supermap.Theme3DLayer.prototype.baseHeightField 
         * @description 数据中表示基础高度的字段。
         */
        this.baseHeightField = null;

        /**
         * @member {number} mapboxgl.supermap.Theme3DLayer.prototype.height 
         * @description 高度。如果数据指定的 heightField (默认 height) 没有可以表示高度的字段，可以为所有数据统一设置一个高度。
         */
        this.height = null;

        /**
         * @member {string} mapboxgl.supermap.Theme3DLayer.prototype.heightField 
         * @description 数据中表示高度的字段。
         */
        this.heightField = 'height';

        /**
         * @member {string} [mapboxgl.supermap.Theme3DLayer.prototype.themeField]
         * @description 专题展示的字段。
         */
        this.themeField = this.heightField;

        /**
         * @member {boolean} [mapboxgl.supermap.Theme3DLayer.prototype.showLegend=true]
         * @description 是否显示图例。
         */
        this.showLegend = true;

        /**
         * @member {string} [mapboxgl.supermap.Theme3DLayer.prototype.legendTitle]
         * @description 图例标题。
         */
        this.legendTitle = null;

        /**
         * @member {string} [mapboxgl.supermap.Theme3DLayer.prototype.legendTheme='light']
         * @description 图例主题，取值：'light','dark'。
         * @default 'light'
         */
        this.legendTheme = 'light';

        /**
         * @member {string} [mapboxgl.supermap.Theme3DLayer.prototype.legendOrientation='horizontal']
         * @description 图例方向，取值：'horizontal','vertical'。
         * @default 'horizontal'
         */
        this.legendOrientation = 'horizontal';
        /**
         * @member {string} mapboxgl.supermap.Theme3DLayer.prototype.legendPosition 
         * @description 图例位置，取值：'top-right'|'top-left'|'bottom-left'|'bottom-right'。
         * @default 'bottom-right'
         */
        this.legendPosition = 'bottom-right';
        this._extend(this, layerOptions);
    }

    /**
     * @function mapboxgl.supermap.Theme3DLayer.prototype.setLayerOptions
     * @description 设置图层相关参数。
     * @param {Object} layerOptions - 该专题图图层相关参数。
     * @param {number} [layerOptions.opacity=1] - 图层透明度。
     * @param {boolean} [layerOptions.parseNumber=false] - 是否预处理数据，将数据转换为 number。
     * @param {string} [layerOptions.baseHeightField] - 数据中表示基础高度的字段
     * @param {number} [layerOptions.height] - 高度。如果数据指定的heightField(默认height)没有可以表示高度的字段，可以为所有数据统一设置一个高度。
     * @param {string} [layerOptions.heightField] - 数据中表示高度的字段。
     * @param {string} [layerOptions.themeField] - 专题展示的字段。
     * @param {boolean} [layerOptions.showLegend=true] - 是否显示图例。
     * @param {string} layerOptions.legendTitle - 图例标题。
     * @param {string} [layerOptions.legendTheme='light'] - 图例主题，取值：'light','dark'。
     * @param {string} [layerOptions.legendOrientation='horizontal'] - 图例方向，取值：'horizontal','vertical'。
     * @param {string} [layerOptions.legendPosition] - 图例位置，取值：'top-right'|'top-left'|'bottom-left'|'bottom-right'。
     * @returns {this}
     */


    _createClass(Theme3DLayer, [{
        key: 'setLayerOptions',
        value: function setLayerOptions(layerOptions) {
            this._extend(this, layerOptions);
            return this;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.setHighlightStyleOptions
         * @description 设置图层高亮相关参数。
         * @param {Object} highlightOptions - 该专题图图层高亮相关参数。
         * @param {string} [highlightOptions.color] - 颜色。
         * @param {function} highlightOptions.callback - 回调,返回数据参数（data,event）。
         * @returns {this}
         */

    }, {
        key: 'setHighlightStyleOptions',
        value: function setHighlightStyleOptions(highlightOptions) {
            this._extend(this.highlight, highlightOptions);
            return this;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.setData
         * @description 设置数据，数据格式必须为 GeoJSON 格式。
         * @param {GeoJSONObject} data - GeoJSON 格式数据。
         * @param {boolean} [parseNumber=false] - 是否进行数据预处理,有些字段是 string 类型，需要转换为 number。
         */

    }, {
        key: 'setData',
        value: function setData(data, parseNumber) {
            var me = this;
            me.data = data;
            if (parseNumber != null) {
                me.parseNumber = parseNumber;
            }
            me.parseNumber && me.data && me.data.features && me.data.features.map(function (val) {
                if (me.baseHeightField && val.properties[me.baseHeightField]) {
                    val.properties[me.baseHeightField] = parseFloat(val.properties[me.baseHeightField]);
                }
                if (me.heightField && val.properties[me.heightField]) {
                    val.properties[me.heightField] = parseFloat(val.properties[me.heightField]);
                }
                return val;
            });
            return this;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.getData
         * @description 获取数据。
         * @returns {GeoJSONObject} 获取的数据。
         */

    }, {
        key: 'getData',
        value: function getData() {
            return this.data;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.addTo
         * @description 添加图层到地图上。
         * @param {mapboxgl.Map} map - Mapbox GL 地图对象。
         * @returns {this} this 对象。
         */

    }, {
        key: 'addTo',
        value: function addTo(map) {
            this.map = map;
            if (!this.map) {
                return this;
            }

            this.show();
            return this;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.show
         * @description 显示图层。
         * @param {Object} options - 图层配置项。
         * @returns {this} this 对象。
         */

    }, {
        key: 'show',
        value: function show(options) {
            this._extend(this, options);
            this._addLayer();
            if (this.enableHighlight) {
                this._addHighLightLayer();
            }
            if (this.showLegend) {
                if (!this.legend) {
                    this.legend = this._createLegendControl();
                }
                this.map.addControl(this.legend, this.legendPosition);
            }
            return this;
        }

        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.remove
         * @description 从地图上移除图层。
         * @returns {this} this 对象。
         */

    }, {
        key: 'remove',
        value: function remove() {
            if (!this.map) {
                return this;
            }
            //移除图层
            var layerId = this.id ? this.id : "theme3DLayer";
            if (this.map.getLayer(layerId)) {
                this.map.off('mousemove', layerId, this._onMouseMove.bind(this));
                this.map.on('mouseout', layerId, this._onMouseMove.bind(this));
                this.map.removeLayer(layerId);
            }
            //移除高亮图层
            var highlightLayerId = "highlightLayer";
            if (this.map.getLayer(highlightLayerId)) {
                this._selectFeatureId = null;
                this.map.removeLayer(highlightLayerId);
            }

            //移除图例
            if (this.legend) {
                this.map.removeControl(this.legend);
            }
            return this;
        }

        /**
         * @function  mapboxgl.supermap.Theme3DLayer.prototype.getLayerStyleOptions
         * @description 获取图层样式。
         * @returns {Object} Mapbox GL 样式对象。
         */

    }, {
        key: 'getLayerStyleOptions',
        value: function getLayerStyleOptions() {}
        //子类重写实现


        /**
         * @function mapboxgl.supermap.Theme3DLayer.prototype.getHighlightStyleOptions
         * @description 获取高亮样式,子类重写实现。
         * @returns {Object} Mapbox GL 样式对象。
         */

    }, {
        key: 'getHighlightStyleOptions',
        value: function getHighlightStyleOptions() {
            //子类重写实现
        }
    }, {
        key: '_createLegendControl',
        value: function _createLegendControl(html) {
            var me = this;

            function LegendControl() {}

            LegendControl.prototype.onAdd = function (map) {
                this._map = map;
                this._container = document.createElement('div');
                var className = 'mapboxgl-ctrl legend ';
                var theme = 'legend-light';
                if (me.legendTheme === 'dark') {
                    theme = 'legend-dark';
                }
                var orientation = ' legend-horizontal';
                if (me.legendOrientation === 'vertical') {
                    orientation = ' legend-vertical';
                }
                this._container.className = className + theme + orientation;

                if (html) {
                    this._container.innerHTML = html;
                } else {
                    var legendTitle = me.legendTitle || "";
                    var titleElement = " <div class='legend-title'>" + legendTitle + "</div>";
                    var content = me._createLegendElement.call(me) || "";
                    var contentElement = "<div class='legend-content'>" + content + "</div>";
                    this._container.innerHTML = titleElement + contentElement;
                }
                me._appendLegendCSSStyle();
                return this._container;
            };

            LegendControl.prototype.onRemove = function () {
                this._container.parentNode.removeChild(this._container);
                this._map = undefined;
            };

            return new LegendControl();
        }
    }, {
        key: '_createLegendElement',
        value: function _createLegendElement() {
            //子类实现
        }
    }, {
        key: '_addLayer',
        value: function _addLayer() {
            var paintOptions = this.getLayerStyleOptions();
            var id = this.id ? this.id : "theme3DLayer";
            var sourceId = this.sourceId = id + 'Source';
            if (!this.map.getSource(sourceId)) {
                this.map.addSource(sourceId, {
                    'type': 'geojson',
                    'data': this.data
                });
            } else {
                this.map.removeSource(sourceId);
                this.map.addSource(sourceId, {
                    'type': 'geojson',
                    'data': this.data
                });
            }
            this.map.addLayer({
                'id': id,
                'type': 'fill-extrusion',
                'source': sourceId,
                'paint': paintOptions
            });
            this.map.moveLayer(id);
        }

        //添加高亮图层

    }, {
        key: '_addHighLightLayer',
        value: function _addHighLightLayer() {
            if (!this.map) {
                return;
            }
            var map = this.map;
            map.addLayer({
                'id': 'highlightLayer',
                'type': 'fill-extrusion',
                'source': this.sourceId,
                'paint': this.getHighlightStyleOptions(),
                "filter": ["in", "$id", ""]
            });

            this._selectFeatureId = null;
            map.on('mousemove', this.id, this._onMouseMove.bind(this));
            map.on('mouseout', this.id, this._onMouseMove.bind(this));
        }
    }, {
        key: '_onMouseMove',
        value: function _onMouseMove(e) {
            var me = this,
                map = this.map;
            var features = map.queryRenderedFeatures(e.point, { layers: [me.id] });

            if (me.highlight && me.highlight.callback) {
                me.highlight.callback(features, e);
            }

            if (!features || features.length < 1) {
                me._clearHighlight.call(me);
                me._selectFeatureId = null;
                return;
            }
            var id = features[0].id;
            if (me._selectFeatureId === id) {
                return;
            }
            me._selectFeatureId = id;
            map.setFilter("highlightLayer", ['==', '$id', me._selectFeatureId]);
        }
    }, {
        key: '_clearHighlight',
        value: function _clearHighlight() {
            if (this.map) {
                this.map.setFilter("highlightLayer", ["in", "$id", ""]);
            }
        }
    }, {
        key: '_appendLegendCSSStyle',
        value: function _appendLegendCSSStyle() {
            var legendStyle = document.createElement('style');
            legendStyle.type = 'text/css';
            var baseStyle = '\n        .legend {\n            display: inline-block;\n            border-radius: 2px;\n            -moz-border-radius: 2px;\n            -webkit-border-radius: 2px;\n            font-size: 12px;\n            color: rgba(0, 0, 0, 0.8);\n            background-color: rgb(255, 255, 255);\n        }\n        .legend-light {\n            color: rgba(0, 0, 0, 0.8);\n            background-color: rgb(255, 255, 255);\n            box-shadow: 0px 0px 6px #bbbbbb;\n            -moz-box-shadow: 0px 6px 10px #bbbbbb;\n            -webkit-box-shadow: 0px 0px 6px #bbbbbb;\n        }\n        .legend-dark {\n            color: rgba(255, 255, 255, 0.8);\n            background-color: rgb(64, 64, 64);\n        }\n        .legend .legend-title {\n            min-height: 14px;\n            max-width: 500px;\n            padding:6px 10px;\n        }\n        .legend-light .legend-title {\n            color: rgba(0, 0, 0, 0.8);\n        }\n        .legend-dark .legend-title {\n            color: rgba(255, 255, 255, 0.8);\n        }\n        .legend-content{\n            padding:6px 10px;\n        }\n        ';
            legendStyle.innerHTML = baseStyle + this._legendCSSStyle();
            document.getElementsByTagName('head')[0].appendChild(legendStyle);
        }

        //各种图层对应的自己的图例的样式

    }, {
        key: '_legendCSSStyle',
        value: function _legendCSSStyle() {
            //子类可重写实现
            return '\n        .legend ul {\n            padding: 0;\n            margin: 0 16px;\n            height: 100%;\n            display: block;\n            list-style: none;\n        }\n\n        .legend li {\n            vertical-align: middle;\n        }\n\n        .legend li span:first-child {\n            vertical-align: middle;\n        }\n\n        .legend li span:last-child {\n            line-height: 28px;\n            max-width: 200px;\n            vertical-align: middle;\n            white-space: nowrap;\n            overflow: hidden;\n            text-overflow: ellipsis;\n            -ms-text-overflow: ellipsis;\n        }\n\n        .legend-vertical li {\n            height: 28px;\n        }\n\n        .legend-vertical li span:first-child {\n            display: inline-block;\n            width: 60px;\n            height: 100%;\n        }\n\n        .legend-vertical li span:last-child {\n            display: inline-block;\n            margin-left: 16px;\n            height: 100%;\n        }\n\n        .legend-horizontal li {\n            height: 56px;\n            float: left;\n        }\n\n        .legend-horizontal li span:first-child {\n            display: block;\n            width: 100%;\n            height: 50%;\n        }\n\n        .legend-horizontal li span:last-child {\n            display: block;\n            vertical-align: middle;\n            width: 60px;\n            height: 50%;\n            text-align: center;\n        }\n        ';
        }
    }, {
        key: '_extend',
        value: function _extend(dest) {
            for (var index = 0; index < Object.getOwnPropertyNames(arguments).length; index++) {
                var arg = Object.getOwnPropertyNames(arguments)[index];
                if (arg == "caller" || arg == "callee" || arg == "length" || arg == "arguments") {
                    continue;
                }
                var obj = arguments[arg];
                if (obj) {
                    for (var j = 0; j < Object.getOwnPropertyNames(obj).length; j++) {
                        var key = Object.getOwnPropertyNames(obj)[j];
                        if (arg == "caller" || arg == "callee" || arg == "length" || arg == "arguments") {
                            continue;
                        }
                        dest[key] = obj[key];
                    }
                }
            }
            return dest;
        }
    }]);

    return Theme3DLayer;
}();

_mapboxGl2.default.supermap.Theme3DLayer = Theme3DLayer;

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Theme = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var _mapboxGl = __webpack_require__(3);

var _mapboxGl2 = _interopRequireDefault(_mapboxGl);

__webpack_require__(4);

var _ThemeFeature = __webpack_require__(116);

var _iclientCommon = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class mapboxgl.supermap.ThemeLayer
 * @category Visualization Theme
 * @classdesc 专题图基类。
 * @param {string} name - 专题图图层名。
 * @param {Object} options -可选参数。
 * @param {mapboxgl.Map} options.map - 当前 mapboxgl map 对象，将在下个版本弃用，请用 map.addLayer()方法添加图层。
 * @param {string} [options.id] - 专题图层 ID。默认使用 CommonUtil.createUniqueID("themeLayer_") 创建专题图层 ID。
 * @param {boolean} [options.loadWhileAnimating=true] - 是否实时重绘。
 * @param {boolean} [options.visibility=true] - 图层是否可见。
 * @param {number} [options.opacity=1] - 图层透明度。
 * @fires mapboxgl.supermap.ThemeLayer#changelayer
 * @fires mapboxgl.supermap.ThemeLayer#featuresremoved
 */
var Theme = function () {
    function Theme(name, opt_options) {
        _classCallCheck(this, Theme);

        var options = opt_options ? opt_options : {};
        /**
         * @member {string} mapboxgl.supermap.ThemeLayer.prototype.name
         * @description 专题图图层名称。
         */
        this.name = name;

        /**
         * @member {string} [mapboxgl.supermap.ThemeLayer.prototype.id]
         * @description 专题图图层 id。
         */
        this.id = options.id ? options.id : _iclientCommon.CommonUtil.createUniqueID("themeLayer_");
        /**
         * @member {float} [mapboxgl.supermap.ThemeLayer.prototype.opacity=1]
         * @description 图层透明度。
         */
        this.opacity = options.opacity ? options.opacity : 1;

        /**
         * @member {boolean} [mapboxgl.supermap.ThemeLayer.prototype.visibility=true]
         * @description 图层是否可见。
         */
        this.visibility = true;

        /**
         * @member {boolean} [mapboxgl.supermap.ThemeLayer.prototype.loadWhileAnimating=true]
         * @description 是否实时重绘。(当绘制大数据量要素的情况下会出现卡顿，建议把该参数设为 false)。
         */
        this.loadWhileAnimating = options.loadWhileAnimating === undefined ? true : options.loadWhileAnimating;

        /**
         * @member {mapboxgl.Map} mapboxgl.supermap.ThemeLayer.prototype.map
         * @description map 对象。
         */
        this.map = options.map ? options.map : null;

        this.features = [];
        this.TFEvents = [];

        //todo 保留之前创建图层同时添加到图层的用法，在下个版本遗弃
        if (this.map) {
            this.map.addLayer(this);
        }
    }

    /**
     * @function mapboxgl.supermap.ThemeLayer.prototype.onAdd
     * @description 向底图添加该图层。
     */


    _createClass(Theme, [{
        key: 'onAdd',
        value: function onAdd(map) {
            this.map = map;
            this._createCanvasContainer();

            //处理用户预先（在图层添加到 map 前）监听的事件
            this.addTFEvents();
            this.map.on('resize', this.resizeEvent.bind(this));
            this.map.on('zoomstart', this.zoomStartEvent.bind(this));
            this.map.on('zoomend', this.zoomEndEvent.bind(this));
            this.map.on('rotatestart', this.rotateStartEvent.bind(this));
            this.map.on('rotate', this.rotateEvent.bind(this));
            this.map.on('rotateend', this.rotateEndEvent.bind(this));
            this.map.on('dragend', this.dragEndEvent.bind(this));
            this.map.on('movestart', this.moveStartEvent.bind(this));
            this.map.on('move', this.moveEvent.bind(this));
            this.map.on('moveend', this.moveEndEvent.bind(this));
            this.map.on('remove', this.removeFromMap.bind(this));

            this.refresh();
        }

        /**
         * @function mapboxgl.supermap.HeatMapLayer.prototype.refresh
         * @description 强制刷新当前热点显示，在图层热点数组发生变化后调用，更新显示。
         */

    }, {
        key: 'refresh',
        value: function refresh() {
            if (this.features.length === 0) {
                return;
            }
            if (this.map) {
                this.redrawThematicFeatures(this.map.getBounds());
            }
        }
    }, {
        key: '_createCanvasContainer',
        value: function _createCanvasContainer() {
            this.movingOffset = [0, 0];
            this.mapContainer = this.map.getCanvasContainer();
            this.div = document.createElement('div');
            this.div.id = this.id;
            this.div.style.position = 'absolute';
            var container = this.map.getCanvasContainer();
            var canvas = this.map.getCanvas();
            this.mapContainer.style.perspective = this.map.transform.cameraToCenterDistance + 'px';
            this.div.style.width = canvas.style.width;
            this.div.style.height = canvas.style.height;
            this.div.className = "themeLayer";
            this.div.width = parseInt(canvas.width);
            this.div.height = parseInt(canvas.height);
            container.appendChild(this.div);
            this.setOpacity(this.opacity);
            this.levelRenderer = new _iclientCommon.LevelRenderer();
            this.renderer = this.levelRenderer.init(this.div);
            this.renderer.clear();
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.destroyFeatures
         * @description 销毁某个要素。
         * @param {SuperMap.Feature.Vector} features - 将被销毁的要素。
         */

    }, {
        key: 'destroyFeatures',
        value: function destroyFeatures(features) {
            var all = features == undefined;
            if (all) {
                features = this.features;
            }
            if (features) {
                this.removeFeatures(features);
                for (var i = features.length - 1; i >= 0; i--) {
                    features[i].destroy();
                }
            }
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.setVisibility
         * @description 设置图层可见性，设置图层的隐藏，显示，重绘的相应的可见标记。
         * @param {boolean} [visibility] - 是否显示图层（当前地图的 resolution 在最大最小 resolution 之间）。
         */

    }, {
        key: 'setVisibility',
        value: function setVisibility(visibility) {
            if (visibility !== this.visibility) {
                this.visibility = visibility;
                this.display(visibility);
                this.redrawThematicFeatures(this.map.getBounds());
            }
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.display
         * @description 临时隐藏或者显示图层。通过对 CSS 控制产生即时效果，重新渲染失效。一般用 setVisibility 方法来动态控制图层的显示和隐藏。
         * @param {boolean} [display] - 是否显示图层。
         */

    }, {
        key: 'display',
        value: function display(_display) {
            this.div.style.display = _display ? "block" : "none";
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.setOpacity
         * @description 设置图层的不透明度,取值[0-1]之间。
         * @param {number} [opacity] - 不透明度。
         */

    }, {
        key: 'setOpacity',
        value: function setOpacity(opacity) {
            if (opacity !== this.opacity) {
                this.opacity = opacity;
                var element = this.div;
                _iclientCommon.CommonUtil.modifyDOMElement(element, null, null, null, null, null, null, opacity);

                if (this.map !== null) {
                    /**
                    * @event mapboxgl.supermap.ThemeLayer#changelayer
                    * @description 图层属性改变之后触发。
                    * @property {Object} layer - 图层。
                    * @property {string} property - 被改变的属性。
                    */
                    _mapboxGl2.default.Evented.prototype.fire('changelayer', { layer: this, property: "opacity" });
                }
            }
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.addFeatures
         * @param {mapboxgl.supermap.ThemeFeature|SuperMap.ServerFeature|GeoJSONObject} features - 待添加要素。
         * @description 抽象方法，可实例化子类必须实现此方法。向专题图图层中添加数据 ,
         */

    }, {
        key: 'addFeatures',
        value: function addFeatures(features) {} // eslint-disable-line no-unused-vars

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.removeFeatures
         * @param {Array.<SuperMap.Feature.Vector>} features - 要删除 feature 的数组。
         * @description 从专题图中删除 feature。这个函数删除所有传递进来的矢量要素。
         *              参数中的 features 数组中的每一项，必须是已经添加到当前图层中的 feature，
         *              如果无法确定 feature 数组，则可以调用 removeAllFeatures 来删除所有 feature。
         *              如果要删除的 feature 数组中的元素特别多，推荐使用 removeAllFeatures，
         *              删除所有 feature 后再重新添加。这样效率会更高。
         */

    }, {
        key: 'removeFeatures',
        value: function removeFeatures(features) {
            if (!features || features.length === 0) {
                return;
            }
            if (features === this.features) {
                return this.removeAllFeatures();
            }
            if (!_iclientCommon.CommonUtil.isArray(features)) {
                features = [features];
            }
            var featuresFailRemoved = [];
            for (var i = features.length - 1; i >= 0; i--) {
                var feature = features[i];
                //如果我们传入的feature在features数组中没有的话，则不进行删除，
                //并将其放入未删除的数组中。
                var findex = _iclientCommon.CommonUtil.indexOf(this.features, feature);
                if (findex === -1) {
                    featuresFailRemoved.push(feature);
                    continue;
                }
                this.features.splice(findex, 1);
            }
            var drawFeatures = [];
            for (var hex = 0, len = this.features.length; hex < len; hex++) {
                feature = this.features[hex];
                drawFeatures.push(feature);
            }
            this.features = [];
            this.addFeatures(drawFeatures);
            //绘制专题要素
            if (this.renderer) {
                this.redrawThematicFeatures(this.map.getBounds());
            }
            var succeed = featuresFailRemoved.length == 0 ? true : false;
            /**
             * @event mapboxgl.supermap.ThemeLayer#featuresremoved
             * @description 要素删除之后触发。
             * @property {Array.<SuperMap.Feature.Vector>} features - 未被成功删除的要素。
             * @property {boolean} succeed - 删除成功与否。
             */
            _mapboxGl2.default.Evented.prototype.fire("featuresremoved", { features: featuresFailRemoved, succeed: succeed });
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.removeAllFeatures
         * @description 清除当前图层所有的矢量要素。
         */

    }, {
        key: 'removeAllFeatures',
        value: function removeAllFeatures() {
            if (this.renderer) {
                this.renderer.clear();
            }
            this.features = [];
            _mapboxGl2.default.Evented.prototype.fire('featuresremoved', { features: [], succeed: true });
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.getFeatures
         * @description 查看当前图层中的有效数据。
         * @returns {SuperMap.Feature.Vector} 用户加入图层的有效数据。
         */

    }, {
        key: 'getFeatures',
        value: function getFeatures() {
            var len = this.features.length;
            var clonedFeatures = new Array(len);
            for (var i = 0; i < len; ++i) {
                clonedFeatures[i] = this.features[i];
            }
            return clonedFeatures;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.getFeatureBy
         * @description 在专题图的要素数组 features 里面遍历每一个 feature，当 feature[property] === value 时，
         *              返回此 feature（并且只返回第一个）。
         * @param {string} property - feature 的某个属性名称。
         * @param {string} value - property 所对应的值。
         * @returns {SuperMap.Feature.Vector} 第一个匹配属性和值的矢量要素。
         */

    }, {
        key: 'getFeatureBy',
        value: function getFeatureBy(property, value) {
            var feature = null;
            for (var id in this.features) {
                if (this.features[id][property] === value) {
                    feature = this.features[id];
                    break;
                }
            }
            return feature;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.getFeatureById
         * @description 通过给定一个 id，返回对应的矢量要素。
         * @param {string} featureId - 矢量要素的属性 id。
         * @returns {SuperMap.Feature.Vector} 对应 id 的 feature，如果不存在则返回 null。
         */

    }, {
        key: 'getFeatureById',
        value: function getFeatureById(featureId) {
            return this.getFeatureBy('id', featureId);
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.getFeaturesByAttribute
         * @description 通过给定一个属性的 key 值和 value 值，返回所有匹配的要素数组。
         * @param {string} attrName - 属性的 key。
         * @param {string} attrValue - 矢量要素的属性 id。
         * @returns {Array.<SuperMap.Feature.Vector>} 一个匹配的 feature 数组。
         */

    }, {
        key: 'getFeaturesByAttribute',
        value: function getFeaturesByAttribute(attrName, attrValue) {
            var feature,
                foundFeatures = [];
            for (var id in this.features) {
                feature = this.features[id];
                if (feature && feature.attributes) {
                    if (feature.attributes[attrName] === attrValue) {
                        foundFeatures.push(feature);
                    }
                }
            }
            return foundFeatures;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.redrawThematicFeatures
         * @description 抽象方法，可实例化子类必须实现此方法。重绘专题要素。
         * @param {mapboxgl.LngLatBounds} extent - 重绘的范围。
         */

    }, {
        key: 'redrawThematicFeatures',
        value: function redrawThematicFeatures(extent) {} // eslint-disable-line no-unused-vars


        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.on
         * @description 添加专题要素事件监听。添加专题要素事件监听。
         * @param {Event} event - 监听事件。
         * @param {function} callback - 回调函数。
         * @param {string} context - 信息。
         */

    }, {
        key: 'on',
        value: function on(event, callback, context) {
            // eslint-disable-line no-unused-vars
            if (this.renderer) {
                this.renderer.on(event, callback);
            } else {
                this.map.on(event, callback);
            }
            return this;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.off
         * @description 移除专题要素事件监听。
         * @param {Event} event - 监听事件。
         * @param {function} callback - 回调函数。
         * @param {string} context - 信息。
         */

    }, {
        key: 'off',
        value: function off(event, callback, context) {
            // eslint-disable-line no-unused-vars
            var me = this;
            if (me.renderer) {
                me.renderer.off(event, callback);
            } else {
                this.map.off(event, callback);
            }
            return this;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.addTFEvents
         * @description 将图层添加到地图上之前用户要求添加的事件监听添加到图层。
         * @private
         */

    }, {
        key: 'addTFEvents',
        value: function addTFEvents() {
            var tfEs = this.TFEvents;
            var len = tfEs.length;
            for (var i = 0; i < len; i++) {
                this.renderer.on(tfEs[i][0], tfEs[i][1]);
            }
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.getLocalXY
         * @description 地理坐标转为像素坐标。
         * @param {Object} [coordinate] - 坐标位置。
         */

    }, {
        key: 'getLocalXY',
        value: function getLocalXY(coordinate) {
            var pixelP,
                map = this.map;
            if (coordinate instanceof _iclientCommon.GeometryPoint || coordinate instanceof _iclientCommon.GeoText) {
                var tempPoint = map.project(new _mapboxGl2.default.LngLat(coordinate.x, coordinate.y));
                pixelP = [tempPoint.x, tempPoint.y];
            }
            if (coordinate instanceof _iclientCommon.LonLat) {
                var _tempPoint = map.project(new _mapboxGl2.default.LngLat(coordinate.lon, coordinate.lat));
                pixelP = [_tempPoint.x, _tempPoint.y];
            }
            return pixelP;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.toFeature
         * @description 转为 iClient 要素。
         * @param {mapboxgl.supermap.ThemeFeature|GeoJSONObject} features - 待转要素。
         * @returns {SuperMap.Feature.Vector} 转换后的 iClient 要素。
         */

    }, {
        key: 'toiClientFeature',
        value: function toiClientFeature(features) {
            if (!_iclientCommon.CommonUtil.isArray(features)) {
                features = [features];
            }

            var featuresTemp = [];
            for (var i = 0; i < features.length; i++) {
                //mapboxgl.supermap.ThemeFeature 类型
                if (features[i] instanceof _ThemeFeature.ThemeFeature) {
                    featuresTemp.push(features[i].toFeature());
                } else if (features[i] instanceof _iclientCommon.GeometryVector) {
                    // 若是 GeometryVector 直接返回
                    featuresTemp.push(features[i]);
                } else if (["FeatureCollection", "Feature", "Geometry"].indexOf(features[i].type) != -1) {
                    //GeoJSON 规范数据类型
                    var format = new _iclientCommon.GeoJSON();
                    featuresTemp = featuresTemp.concat(format.read(features[i]));
                } else if (features[i].geometry && features[i].geometry.parts) {
                    //iServer服务器返回数据格式
                    featuresTemp.push(_iclientCommon.ServerFeature.fromJson(features[i]).toFeature());
                } else {
                    throw new Error('features\'s type is not be supported.');
                }
            }
            return featuresTemp;
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.toFeature
         * @deprecated
         * @description 转为 iClient 要素，该方法将被弃用，由 {@link mapboxgl.supermap.ThemeLayer#toiClientFeature} 代替。
         * @param {mapboxgl.supermap.ThemeFeature|GeoJSONObject} features - 待转要素。
         * @returns {SuperMap.Feature.Vector} 转换后的 iClient 要素。
         */

    }, {
        key: 'toFeature',
        value: function toFeature(features) {
            return this.toiClientFeature(features);
        }
    }, {
        key: 'moveEndEvent',
        value: function moveEndEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.div.style.transform = '';
            this.redrawThematicFeatures(this.map.getBounds());
            this._show();
        }
    }, {
        key: 'moveStartEvent',
        value: function moveStartEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.startPitch = this.map.getPitch();
            this.startBearing = this.map.getBearing();
            var startMovePoint = this.map.project(new _mapboxGl2.default.LngLat(0, 0));
            this.startMoveX = startMovePoint.x;
            this.startMoveY = startMovePoint.y;
        }
    }, {
        key: 'moveEvent',
        value: function moveEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                this.redrawThematicFeatures(this.map.getBounds());
                return;
            }
            if (this.rotating || this.zooming) {
                return;
            }
            if (this.map.getPitch() !== 0) {
                this._hide();
            }
            this.mapContainer.style.perspective = this.map.transform.cameraToCenterDistance + 'px';
            var tPitch = this.map.getPitch() - this.startPitch;
            var tBearing = -this.map.getBearing() + this.startBearing;
            var endMovePoint = this.map.project(new _mapboxGl2.default.LngLat(0, 0));
            var tMoveX = endMovePoint.x - this.startMoveX;
            var tMoveY = endMovePoint.y - this.startMoveY;
            this.div.style.transform = 'rotateX(' + tPitch + 'deg)' + ' rotateZ(' + tBearing + 'deg)' + ' translate3d(' + tMoveX + 'px, ' + tMoveY + 'px, 0px)';
        }
    }, {
        key: 'zoomStartEvent',
        value: function zoomStartEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.zooming = true;
            this._hide();
        }
    }, {
        key: 'zoomEndEvent',
        value: function zoomEndEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.zooming = false;
            this._show();
        }
    }, {
        key: 'rotateStartEvent',
        value: function rotateStartEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.rotating = true;
        }
    }, {
        key: 'rotateEvent',
        value: function rotateEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            if (this.map.getPitch() !== 0) {
                this._hide();
            }
            this.mapContainer.style.perspective = this.map.transform.cameraToCenterDistance + 'px';
            var tPitch = this.map.getPitch() - this.startPitch;
            var tBearing = -this.map.getBearing() + this.startBearing;
            this.div.style.transform = 'rotateX(' + tPitch + 'deg)' + ' rotateZ(' + tBearing + 'deg)';
        }
    }, {
        key: 'rotateEndEvent',
        value: function rotateEndEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this.rotating = false;
            this._show();
        }
    }, {
        key: 'dragEndEvent',
        value: function dragEndEvent() {
            if (this.loadWhileAnimating || !this.visibility) {
                return;
            }
            this._hide();
        }
    }, {
        key: 'resizeEvent',
        value: function resizeEvent() {
            this.mapContainer.style.perspective = this.map.transform.cameraToCenterDistance + 'px';
            var canvas = this.map.getCanvas();
            this.div.style.width = canvas.style.width;
            this.div.style.height = canvas.style.height;
            this.div.width = parseInt(canvas.width);
            this.div.height = parseInt(canvas.height);
            this.renderer.resize();
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.removeFromMap
         * @description 移除图层。
         */

    }, {
        key: 'removeFromMap',
        value: function removeFromMap() {
            this.mapContainer.removeChild(this.div);
            this.removeAllFeatures();
        }

        /**
         * @function mapboxgl.supermap.ThemeLayer.prototype.moveTo
         * @description 将图层移动到某个图层之前。
         * @param {string} layerID - 待插入的图层 ID。
         * @param {boolean} [before=true] - 是否将本图层插入到图层 id 为 layerID 的图层之前(如果为 false 则将本图层插入到图层 id 为 layerID 的图层之后)。
         */

    }, {
        key: 'moveTo',
        value: function moveTo(layerID, before) {
            var layer = document.getElementById(this.div.id);
            before = before !== undefined ? before : true;
            if (before) {
                var beforeLayer = document.getElementById(layerID);
                if (layer && beforeLayer) {
                    beforeLayer.parentNode.insertBefore(layer, beforeLayer);
                }
                return;
            }
            var nextLayer = document.getElementById(layerID);
            if (layer) {
                if (nextLayer.nextSibling) {
                    nextLayer.parentNode.insertBefore(layer, nextLayer.nextSibling);
                    return;
                }
                nextLayer.parentNode.appendChild(layer);
            }
        }
    }, {
        key: '_hide',
        value: function _hide() {
            this.renderer.painter.root.style.display = 'none';
        }
    }, {
        key: '_show',
        value: function _show() {
            this.renderer.painter.root.style.display = 'block';
        }
    }]);

    return Theme;
}();

exports.Theme = Theme;


_mapboxGl2.default.supermap.ThemeLayer = Theme;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Lang = undefined;

var _SuperMap = __webpack_require__(0);

/**
 * @name Lang
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes
 * @description 国际化的命名空间，包含多种语言和方法库来设置和获取当前的语言。
 */
var Lang = {

    /**
     * @member {string} SuperMap.Lang.code
     * @description 当前所使用的语言类型。
     */
    code: null,

    /**
     * @member {string} [SuperMap.Lang.defaultCode='en-US']
     * @description 默认使用的语言类型。
     */
    defaultCode: "en-US",

    /**
     * @function SuperMap.Lang.getCode
     * @description 获取当前的语言代码。
     * @returns {string} 当前的语言代码。
     */
    getCode: function getCode() {
        if (!_SuperMap.SuperMap.Lang.code) {
            _SuperMap.SuperMap.Lang.setCode();
        }
        return _SuperMap.SuperMap.Lang.code;
    },

    /**
     * @function SuperMap.Lang.setCode
     * @description 设置语言代码。
     * @param {string} code - 此参数遵循IETF规范。
     */
    setCode: function setCode() {
        var lang = this.getLanguageFromCookie();
        if (lang) {
            _SuperMap.SuperMap.Lang.code = lang;
            return;
        }
        lang = _SuperMap.SuperMap.Lang.defaultCode;
        if (navigator.appName === 'Netscape') {
            lang = navigator.language;
        } else {
            lang = navigator.browserLanguage;
        }
        if (lang.indexOf('zh') === 0) {
            lang = 'zh-CN';
        }
        if (lang.indexOf('en') === 0) {
            lang = 'en-US';
        }

        _SuperMap.SuperMap.Lang.code = lang;
    },
    /**
     * @function SuperMap.Lang.getLanguageFromCookie
     * @description 从 cookie 中获取语言类型。
     */
    getLanguageFromCookie: function getLanguageFromCookie() {
        var name = 'language=';
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) !== -1) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    },


    /**
     * @function SuperMap.Lang.i18n
     * @description 从当前语言字符串的字典查找 key。
     * @param {string} key - 字典中 i18n 字符串值的关键字。
     * @returns {string} 国际化的字符串。
     */
    i18n: function i18n(key) {
        var dictionary = _SuperMap.SuperMap.Lang[_SuperMap.SuperMap.Lang.getCode()];
        var message = dictionary && dictionary[key];
        if (!message) {
            // Message not found, fall back to message key
            message = key;
        }
        return message;
    }

}; /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
    * This program are made available under the terms of the Apache License, Version 2.0
    * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

exports.Lang = Lang;

_SuperMap.SuperMap.Lang = Lang;
_SuperMap.SuperMap.i18n = _SuperMap.SuperMap.Lang.i18n;

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmicRectangle = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _Shape2 = __webpack_require__(12);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicRectangle
 * @category Visualization Theme
 * @classdesc 矩形。
 * @extends SuperMap.LevelRenderer.Shape
 * @example
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicRectangle({
 *         style: {
 *             x: 0,
 *             y: 0,
 *             width: 100,
 *             height: 100,
 *             radius: 20
 *         }
 *     });
 *   levelRenderer.addShape(shape);
 * 
 */
var SmicRectangle = exports.SmicRectangle = function (_Shape) {
    _inherits(SmicRectangle, _Shape);

    /**
     * @member {Object} SuperMap.LevelRenderer.Shape.SmicRectangle.prototype.style
     * @description 绘制样式。
     *
     * @param {number} style.x - 左上角 x 坐标，必设参数。
     * @param {number} style.y - 左上角 y 坐标，必设参数。
     * @param {number} style.width - 宽度，必设参数。
     * @param {number} style.height - 高度，必设参数。
     * @param {Array} style.radius - 矩形圆角，可以用数组分别指定四个角的圆角，设：左上、右上、右下、左下角的半径依次为 r1、r2、r3、r4 则 radius为 [r1、r2、r3、r4 ]。
     * @param {string} style.brushType - 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * @param {string} style.color - 填充颜色。默认值："#000000'"。
     * @param {string} style.strokeColor - 描边颜色。默认值："#000000'"。
     * @param {string} style.lineCape - 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * @param {number} style.lineWidth - 描边宽度。默认值：1。
     * @param {number} style.opacity - 绘制透明度。默认值：1。
     * @param {number} style.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
     * @param {number} style.shadowColor - 阴影颜色。默认值："#000000'"。
     * @param {number} style.shadowOffsetX - 阴影横向偏移。默认值：0。
     * @param {number} style.shadowOffsetY - 阴影纵向偏移。默认值：0。
     * @param {string} style.text - 图形中的附加文本。默认值：""。
     * @param {string} style.textColor - 文本颜色。默认值："#000000'"。
     * @param {string} style.textFont - 附加文本样式。示例:'bold 18px verdana'。
     * @param {string} style.textPosition - 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * @param {string} style.textAlign - 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * @param {string} style.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */
    //打开接口 style

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicRectangle.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function SmicRectangle(options) {
        _classCallCheck(this, SmicRectangle);

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicRectangle.prototype.type
         * @description 图形类型.
         */
        var _this = _possibleConstructorReturn(this, (SmicRectangle.__proto__ || Object.getPrototypeOf(SmicRectangle)).call(this, options));

        _this.type = 'smicrectangle';
        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) {
            _this.refOriginalPosition = [0, 0];
        }
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicRectangle";
        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicRectangle.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(SmicRectangle, [{
        key: 'destroy',
        value: function destroy() {
            this.type = null;
            _get(SmicRectangle.prototype.__proto__ || Object.getPrototypeOf(SmicRectangle.prototype), 'destroy', this).call(this);
        }

        /**
         * APIMethod: _buildRadiusPath
         * 创建矩形的圆角路径。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * style - {Object} style。
         *
         */

    }, {
        key: '_buildRadiusPath',
        value: function _buildRadiusPath(ctx, style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            // 左上、右上、右下、左下角的半径依次为r1、r2、r3、r4
            // r缩写为1         相当于 [1, 1, 1, 1]
            // r缩写为[1]       相当于 [1, 1, 1, 1]
            // r缩写为[1, 2]    相当于 [1, 2, 1, 2]
            // r缩写为[1, 2, 3] 相当于 [1, 2, 3, 2]
            var x = style.x + __OP[0];
            var y = style.y + __OP[1];
            var width = style.width;
            var height = style.height;
            var r = style.radius;
            var r1;
            var r2;
            var r3;
            var r4;

            if (typeof r === 'number') {
                r1 = r2 = r3 = r4 = r;
            } else if (r instanceof Array) {
                if (r.length === 1) {
                    r1 = r2 = r3 = r4 = r[0];
                } else if (r.length === 2) {
                    r1 = r3 = r[0];
                    r2 = r4 = r[1];
                } else if (r.length === 3) {
                    r1 = r[0];
                    r2 = r4 = r[1];
                    r3 = r[2];
                } else {
                    r1 = r[0];
                    r2 = r[1];
                    r3 = r[2];
                    r4 = r[3];
                }
            } else {
                r1 = r2 = r3 = r4 = 0;
            }

            var total;
            if (r1 + r2 > width) {
                total = r1 + r2;
                r1 *= width / total;
                r2 *= width / total;
            }
            if (r3 + r4 > width) {
                total = r3 + r4;
                r3 *= width / total;
                r4 *= width / total;
            }
            if (r2 + r3 > height) {
                total = r2 + r3;
                r2 *= height / total;
                r3 *= height / total;
            }
            if (r1 + r4 > height) {
                total = r1 + r4;
                r1 *= height / total;
                r4 *= height / total;
            }
            ctx.moveTo(x + r1, y);
            ctx.lineTo(x + width - r2, y);
            r2 !== 0 && ctx.quadraticCurveTo(x + width, y, x + width, y + r2);
            ctx.lineTo(x + width, y + height - r3);
            r3 !== 0 && ctx.quadraticCurveTo(x + width, y + height, x + width - r3, y + height);
            ctx.lineTo(x + r4, y + height);
            r4 !== 0 && ctx.quadraticCurveTo(x, y + height, x, y + height - r4);
            ctx.lineTo(x, y + r1);
            r1 !== 0 && ctx.quadraticCurveTo(x, y, x + r1, y);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicRectangle.prototype.buildPath
         * @description 创建矩形路径。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - style。
         *
         */

    }, {
        key: 'buildPath',
        value: function buildPath(ctx, style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            if (!style.radius) {
                ctx.moveTo(style.x + __OP[0], style.y + __OP[1]);
                ctx.lineTo(style.x + __OP[0] + style.width, style.y + __OP[1]);
                ctx.lineTo(style.x + __OP[0] + style.width, style.y + __OP[1] + style.height);
                ctx.lineTo(style.x + __OP[0], style.y + __OP[1] + style.height);
                ctx.lineTo(style.x + __OP[0], style.y + __OP[1]);
                // ctx.rect(style.x, style.y, style.width, style.height);
            } else {
                this._buildRadiusPath(ctx, style);
            }
            ctx.closePath();
            return;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicRectangle.prototype.getRect
         * @description 计算返回矩形包围盒矩阵。该包围盒是直接从四个控制点计算，并非最小包围盒。
         * 
         * @param {Object} style - style
         * @return {Object} 边框对象。包含属性：x，y，width，height。
         */

    }, {
        key: 'getRect',
        value: function getRect(style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            if (style.__rect) {
                return style.__rect;
            }

            var lineWidth;
            if (style.brushType == 'stroke' || style.brushType == 'fill') {
                lineWidth = style.lineWidth || 1;
            } else {
                lineWidth = 0;
            }
            style.__rect = {
                x: Math.round(style.x + __OP[0] - lineWidth / 2),
                y: Math.round(style.y + __OP[1] - lineWidth / 2),
                width: style.width + lineWidth,
                height: style.height + lineWidth
            };

            return style.__rect;
        }
    }]);

    return SmicRectangle;
}(_Shape2.Shape);

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmicImage = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _Shape2 = __webpack_require__(12);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicImage
 * @category Visualization Theme
 * @classdesc 图片绘制。
 * @extends SuperMap.LevelRenderer.Shape
 * @example
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicImage({
 *         style: {
 *             image: 'test.jpg',
 *             x: 100,
 *             y: 100
 *         }
 *   });
 *   levelRenderer.addShape(shape);
 *
 *
 */
var SmicImage = exports.SmicImage = function (_Shape) {
    _inherits(SmicImage, _Shape);

    /**
     * @member {Object} SuperMap.LevelRenderer.Shape.SmicImage.prototype.style
     * @description 绘制样式。
     *
     * @param {number} style.x - 左上角横坐标，必设参数。
     * @param {number} style.y - 左上角纵坐标，必设参数。
     * @param {(string/Cavans)} style.image - 图片地址或cavans对象，必设参数。
     * @param {number} style.width - 绘制到画布上的宽度，默认为图片高度。
     * @param {number} style.height - 绘制到画布上的高度，默认为图片高度。
     * @param {number} style.sx - 从图片中裁剪的左上角横坐标。
     * @param {number} style.sy - 从图片中裁剪的左上角纵坐标。
     * @param {number} style.sWidth - 从图片中裁剪的宽度，默认为图片高度。
     * @param {number} style.sHeight - 绘制到画布上的高度，默认为图片高度。
     * @param {number} style.opacity - 绘制透明度。默认值：1。
     * @param {number} style.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
     * @param {number} style.shadowColor - 阴影颜色。默认值："#000000'"。
     * @param {number} style.shadowOffsetX - 阴影横向偏移。默认值：0。
     * @param {number} style.shadowOffsetY - 阴影纵向偏移。默认值：0。
     * @param {string} style.text - 图形中的附加文本。默认值：""。
     * @param {string} style.textColor - 文本颜色。默认值："#000000'"。
     * @param {string} style.textFont - 附加文本样式。示例:'bold 18px verdana'。
     * @param {string} style.textPosition - 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * @param {string} style.textAlign - 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * @param {string} style.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */
    //打开接口 style

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicImage.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function SmicImage(options) {
        _classCallCheck(this, SmicImage);

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicImage.prototype.type
         * @description  图形类型。
         */
        var _this = _possibleConstructorReturn(this, (SmicImage.__proto__ || Object.getPrototypeOf(SmicImage)).call(this, options));

        _this.type = 'smicimage';

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicImage.prototype._imageCache
         * @description 图片缓存。
         */
        _this._imageCache = {};
        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) {
            _this.refOriginalPosition = [0, 0];
        }
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicImage";
        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicImage.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(SmicImage, [{
        key: 'destroy',
        value: function destroy() {
            this.type = null;
            this._imageCache = null;
            _get(SmicImage.prototype.__proto__ || Object.getPrototypeOf(SmicImage.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicImage.prototype.buildPath
         * @description 创建图片。
         * 
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - style。
         *
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight, refresh) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            var style = this.style || {};

            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {});
            }

            var image = style.image;
            var me = this;

            if (typeof image === 'string') {
                var src = image;
                if (this._imageCache[src]) {
                    image = this._imageCache[src];
                } else {
                    image = new Image();
                    image.onload = function () {
                        image.onload = null;
                        clearTimeout(SmicImage._refreshTimeout);
                        SmicImage._needsRefresh.push(me);
                        // 防止因为缓存短时间内触发多次onload事件
                        SmicImage._refreshTimeout = setTimeout(function () {
                            refresh && refresh(SmicImage._needsRefresh);
                            // 清空 needsRefresh
                            SmicImage._needsRefresh = [];
                        }, 10);
                    };

                    image.src = src;
                    this._imageCache[src] = image;
                }
            }
            if (image) {
                // 图片已经加载完成
                if (image.nodeName.toUpperCase() == 'IMG') {
                    if (window.ActiveXObject) {
                        if (image.readyState != 'complete') {
                            return;
                        }
                    } else {
                        if (!image.complete) {
                            return;
                        }
                    }
                }
                // Else is canvas
                var width = style.width || image.width;
                var height = style.height || image.height;
                var x = style.x + __OP[0];
                var y = style.y + __OP[1];

                // 图片加载失败
                if (!image.width || !image.height) {
                    return;
                }

                ctx.save();

                this.doClip(ctx);

                this.setContext(ctx, style);

                // 设置transform
                this.setTransform(ctx);

                if (style.sWidth && style.sHeight) {
                    var sx = style.sx + __OP[0] || 0;
                    var sy = style.sy + __OP[1] || 0;
                    ctx.drawImage(image, sx, sy, style.sWidth, style.sHeight, x, y, width, height);
                } else if (style.sx && style.sy) {
                    var _sx = style.sx + __OP[0];
                    var _sy = style.sy + __OP[1];
                    var sWidth = width - _sx;
                    var sHeight = height - _sy;
                    ctx.drawImage(image, _sx, _sy, sWidth, sHeight, x, y, width, height);
                } else {
                    ctx.drawImage(image, x, y, width, height);
                }
                // 如果没设置宽和高的话自动根据图片宽高设置
                if (!style.width) {
                    style.width = width;
                }
                if (!style.height) {
                    style.height = height;
                }
                if (!this.style.width) {
                    this.style.width = width;
                }
                if (!this.style.height) {
                    this.style.height = height;
                }

                this.drawText(ctx, style, this.style);

                ctx.restore();
            }
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicImage.prototype.getRect
         * @description 计算返回图片的包围盒矩形。
         *
         * @param {Object} style - style
         * @return {Object} 边框对象。包含属性：x，y，width，height。
         */

    }, {
        key: 'getRect',
        value: function getRect(style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            return {
                x: style.x + __OP[0],
                y: style.y + __OP[1],
                width: style.width,
                height: style.height
            };
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicImage.prototype.clearCache
         * @description 清除图片缓存。
         *
         * @param {Object} style - style
         * @return {Object} 边框对象。包含属性：x，y，width，height。
         * 
         */

    }, {
        key: 'clearCache',
        value: function clearCache() {
            this._imageCache = {};
        }
    }]);

    return SmicImage;
}(_Shape2.Shape);

SmicImage._needsRefresh = [];
SmicImage._refreshTimeout = null;

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmicBrokenLine = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _Shape2 = __webpack_require__(12);

var _SmicPolygon = __webpack_require__(56);

var _SUtil = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicBrokenLine
 * @category Visualization Theme
 * @classdesc 折线(ic)。
 * @extends SuperMap.LevelRenderer.Shape
 * @example
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicBrokenLine({
 *         style: {
 *             pointList: [[0, 0], [100, 100], [100, 0]],
 *             smooth: 'bezier',
 *             strokeColor: 'purple'
 *         }
 *   });
 *   levelRenderer.addShape(shape);
 * 
 *
 */
var SmicBrokenLine = exports.SmicBrokenLine = function (_Shape) {
    _inherits(SmicBrokenLine, _Shape);

    /**
     * @member {Object} SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.style
     * @description 绘制样式。
     *
     * @param {Array} pointList - 节点数组，二维数组。默认值：null，必设参数。其形式如下：
     * (code)
     * (start code)
     *  [
     *  [10, 20],         //单个节点
     *  [30, 40],
     *  [25, 30]
     *   ]
     * (end)
     * @param {string} smooth - 是否做平滑插值, 平滑算法可以选择 "bezier", "spline"。默认值："";
     * @param {number} smoothConstraint - 平滑约束。
     * @param {string} strokeColor - 描边颜色。默认值："#000000'"。
     * @param {string} lineCape - 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * @param {number} lineWidth - 描边宽度。默认值：1。
     * @param {number} opacity - 绘制透明度。默认值：1。
     * @param {number} shadowBlur - 阴影模糊度，大于0有效。默认值：0。
     * @param {number} shadowColor - 阴影颜色。默认值："#000000'"。
     * @param {number} shadowOffsetX - 阴影横向偏移。默认值：0。
     * @param {number} shadowOffsetY - 阴影纵向偏移。默认值：0。
     * @param {string} text - 图形中的附加文本。默认值：""。
     * @param {string} textColor - 文本颜色。默认值："#000000'"。
     * @param {string} textFont - 附加文本样式。示例:'bold 18px verdana'。
     * @param {string} textPosition - 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * @param {string} textAlign - 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * @param {string} textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */
    //打开接口 style

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicBrokenLine.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function SmicBrokenLine(options) {
        _classCallCheck(this, SmicBrokenLine);

        /**
         * @member {string}  SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.brushTypeOnly
         * @description 线条只能描边。
         */
        var _this = _possibleConstructorReturn(this, (SmicBrokenLine.__proto__ || Object.getPrototypeOf(SmicBrokenLine)).call(this, options));

        _this.brushTypeOnly = 'stroke';

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.textPosition
         * @description 文本位置。
         */
        _this.textPosition = 'end';

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.type
         * @description 图形类型.
         */
        _this.type = 'smicbroken-line';
        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) {
            _this.refOriginalPosition = [0, 0];
        }

        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicBrokenLine";
        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(SmicBrokenLine, [{
        key: 'destroy',
        value: function destroy() {
            this.brushTypeOnly = null;
            this.textPosition = null;
            this.type = null;

            _get(SmicBrokenLine.prototype.__proto__ || Object.getPrototypeOf(SmicBrokenLine.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.buildPath
         * @description 创建折线路径。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {Object} style - style。
         *
         */

    }, {
        key: 'buildPath',
        value: function buildPath(ctx, style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }

            var __OP = this.refOriginalPosition;

            var pointList = style.pointList;
            if (pointList.length < 2) {
                // 少于2个点就不画了~
                return;
            }

            var len = Math.min(style.pointList.length, Math.round(style.pointListLength || style.pointList.length));

            if (style.smooth && style.smooth !== 'spline') {
                var controlPoints = _SUtil.SUtil.SUtil_smoothBezier(pointList, style.smooth, false, style.smoothConstraint, __OP);

                ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                var cp1;
                var cp2;
                var p;
                for (var _i = 0; _i < len - 1; _i++) {
                    cp1 = controlPoints[_i * 2];
                    cp2 = controlPoints[_i * 2 + 1];
                    p = [pointList[_i + 1][0] + __OP[0], pointList[_i + 1][1] + __OP[1]];
                    ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], p[0], p[1]);
                }
            } else {
                if (style.smooth === 'spline') {
                    pointList = _SUtil.SUtil.SUtil_smoothSpline(pointList, null, null, __OP);
                    len = pointList.length;
                }
                if (!style.lineType || style.lineType === 'solid') {
                    // 默认为实线
                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var _i2 = 1; _i2 < len; _i2++) {
                        ctx.lineTo(pointList[_i2][0] + __OP[0], pointList[_i2][1] + __OP[1]);
                    }
                } else if (style.lineType === 'dashed' || style.lineType === 'dotted' || style.lineType === 'dot' || style.lineType === 'dash' || style.lineType === 'longdash') {
                    var dashLength = style.lineWidth || 1;
                    var pattern1 = dashLength;
                    var pattern2 = dashLength;

                    //dashed
                    if (style.lineType === 'dashed') {
                        pattern1 *= 5;
                        pattern2 *= 5;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    //dotted
                    if (style.lineType === 'dotted') {
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 = 1;
                            pattern2 += dashLength;
                        }
                    }

                    //dot
                    if (style.lineType === 'dot') {
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 = 1;
                            pattern2 += dashLength;
                        }
                    }

                    //dash
                    if (style.lineType === 'dash') {
                        pattern1 *= 4;
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    //longdash
                    if (style.lineType === 'longdash') {
                        pattern1 *= 8;
                        pattern2 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            pattern1 -= dashLength;
                            pattern2 += dashLength;
                        }
                    }

                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var i = 1; i < len; i++) {
                        _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[i - 1][0] + __OP[0], pointList[i - 1][1] + __OP[1], pointList[i][0] + __OP[0], pointList[i][1] + __OP[1], dashLength, [pattern1, pattern2]);
                    }
                } else if (style.lineType === 'dashdot' || style.lineType === 'longdashdot') {
                    var _dashLength = style.lineWidth || 1;
                    var _pattern = _dashLength;
                    var _pattern2 = _dashLength;
                    var pattern3 = _dashLength;
                    var pattern4 = _dashLength;

                    //dashdot
                    if (style.lineType === 'dashdot') {
                        _pattern *= 4;
                        _pattern2 *= 4;
                        pattern4 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            _pattern -= _dashLength;
                            _pattern2 += _dashLength;
                            pattern3 = 1;
                            pattern4 += _dashLength;
                        }
                    }

                    //longdashdot
                    if (style.lineType === 'longdashdot') {
                        _pattern *= 8;
                        _pattern2 *= 4;
                        pattern4 *= 4;
                        if (style.lineCap && style.lineCap !== "butt") {
                            _pattern -= _dashLength;
                            _pattern2 += _dashLength;
                            pattern3 = 1;
                            pattern4 += _dashLength;
                        }
                    }

                    _dashLength = (style.lineWidth || 1) * (style.lineType === 'dashed' ? 5 : 1);
                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var _i3 = 1; _i3 < len; _i3++) {
                        _SUtil.SUtil.SUtil_dashedLineTo(ctx, pointList[_i3 - 1][0] + __OP[0], pointList[_i3 - 1][1] + __OP[1], pointList[_i3][0] + __OP[0], pointList[_i3][1] + __OP[1], _dashLength, [_pattern, _pattern2, pattern3, pattern4]);
                    }
                }
            }
            return;
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicBrokenLine.prototype.getRect
         * @description 计算返回折线包围盒矩形。该包围盒是直接从四个控制点计算，并非最小包围盒。
         *
         * @param {Object} style - style
         * @return {Object} 边框对象。包含属性：x，y，width，height。
         */

    }, {
        key: 'getRect',
        value: function getRect(style) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;
            return _SmicPolygon.SmicPolygon.prototype.getRect.apply(this, [style, __OP]);
        }
    }]);

    return SmicBrokenLine;
}(_Shape2.Shape);

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmicText = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _Shape2 = __webpack_require__(12);

var _SUtil = __webpack_require__(11);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * This program are made available under the terms of the Apache License, Version 2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicText
 * @category Visualization Theme
 * @extends {SuperMap.LevelRenderer.Shape}
 * @example
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicText({
 *         style: {
 *             text: 'Label',
 *             x: 100,
 *             y: 100,
 *             textFont: '14px Arial'
 *         }
 *     });
 *   levelRenderer.addShape(shape);
 *
 */
var SmicText = exports.SmicText = function (_Shape) {
    _inherits(SmicText, _Shape);

    /**
     * @member {Object} SuperMap.LevelRenderer.Shape.SmicText.prototype.style
     * @description 绘制样式。
     *
     * @param {number} style.x - 横坐标，必设参数。
     * @param {number} style.y - 纵坐标，必设参数。
     * @param {string} style.text - 图形中的附加文本。默认值：""。
     * @param {number} style.maxWidth - 最大宽度限制。默认值：null。
     * @param {string} style.textFont - 附加文本样式。示例:'bold 18px verdana'。
     * @param {string} style.textAlign - 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * @param {string} style.textBaseline - 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     * @param {string} style.brushType -画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * @param {string} style.color - 填充颜色。默认值："#000000'"。
     * @param {string} style.strokeColor - 描边颜色。默认值："#000000'"。
     * @param {number} style.lineWidth - 描边宽度。默认值：1。
     * @param {number} style.opacity - 绘制透明度。默认值：1。
     * @param {number} style.shadowBlur - 阴影模糊度，大于0有效。默认值：0。
     * @param {number} style.shadowColor - 阴影颜色。默认值："#000000'"。
     * @param {number} style.shadowOffsetX - 阴影横向偏移。默认值：0。
     * @param {number} style.shadowOffsetY - 阴影纵向偏移。默认值：0。
     */
    //打开接口 style


    /**
     * @function SuperMap.LevelRenderer.Shape.SmicText.constructor
     * @description 构造函数。
     *
     * @param {Array} options - shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */
    function SmicText(options) {
        _classCallCheck(this, SmicText);

        /**
         * @member {string} SuperMap.LevelRenderer.Shape.SmicText.prototype.type
         * @description 图形类型.
         */
        var _this = _possibleConstructorReturn(this, (SmicText.__proto__ || Object.getPrototypeOf(SmicText)).call(this, options));

        _this.type = 'smictext';
        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) {
            _this.refOriginalPosition = [0, 0];
        }
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicText";
        return _this;
    }

    /**
     * @function SuperMap.LevelRenderer.Shape.SmicText.prototype.destroy
     * @description 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    _createClass(SmicText, [{
        key: 'destroy',
        value: function destroy() {
            this.type = null;

            _get(SmicText.prototype.__proto__ || Object.getPrototypeOf(SmicText.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.LevelRenderer.Shape.SmicText.prototype.brush
         * @description 笔触。
         *
         * @param {CanvasRenderingContext2D} ctx - Context2D 上下文。
         * @param {boolean} isHighlight - 是否使用高亮属性。
         *
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                this.refOriginalPosition = [0, 0];
            }
            var __OP = this.refOriginalPosition;

            var style = this.style;
            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {});
            }

            if (typeof style.text == 'undefined' || style.text === false) {
                return;
            }

            ctx.save();
            this.doClip(ctx);

            this.setContext(ctx, style);

            // 设置transform
            this.setTransform(ctx);

            if (style.textFont) {
                ctx.font = style.textFont;
            }
            ctx.textAlign = style.textAlign || 'start';
            ctx.textBaseline = style.textBaseline || 'middle';

            var text = (style.text + '').split('\n');
            var lineHeight = _SUtil.SUtil.Util_area.getTextHeight('ZH', style.textFont);
            var rect = this.getRectNoRotation(style);
            // var x = style.x;
            var x = style.x + __OP[0];
            var y;
            if (style.textBaseline == 'top') {
                y = rect.y;
            } else if (style.textBaseline == 'bottom') {
                y = rect.y + lineHeight;
            } else {
                y = rect.y + lineHeight / 2;
            }
            var ox = style.x + __OP[0];
            var oy = style.y + __OP[1];

            //文本绘制
            for (var i = 0, l = text.length; i < l; i++) {
                //是否渲染矩形背景及颜色
                if (style.labelRect) {
                    //+4,-2是为了让文字距边框左右边缘有点间隔
                    ctx.fillRect(rect.x - 2, rect.y, rect.width + 4, rect.height);
                    ctx.fillStyle = style.strokeColor;
                    ctx.strokeRect(rect.x - 2, rect.y, rect.width + 4, rect.height);
                    ctx.fillStyle = style.textColor;
                }

                switch (style.brushType) {
                    case 'stroke':
                        this.setCtxGlobalAlpha(ctx, "stroke", style);
                        if (style.textRotation && style.textRotation !== 0) {
                            ctx.save();
                            ctx.translate(ox, oy);
                            ctx.rotate(style.textRotation * Math.PI / 180);
                            if (style.textBaseline == 'top') {
                                if (style.maxWidth) {
                                    ctx.strokeText(text[i], 0, lineHeight * i, style.maxWidth);
                                } else {
                                    ctx.strokeText(text[i], 0, lineHeight * i);
                                }
                            } else if (style.textBaseline == 'bottom') {
                                if (style.maxWidth) {
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height, style.maxWidth);
                                } else {
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height);
                                }
                            } else {
                                if (style.maxWidth) {
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height / 2 - lineHeight / 2, style.maxWidth);
                                } else {
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height / 2 - lineHeight / 2);
                                }
                            }
                            ctx.restore();
                        } else {
                            if (style.maxWidth) {
                                ctx.strokeText(text[i], x, y, style.maxWidth);
                            } else {
                                ctx.strokeText(text[i], x, y);
                            }
                        }
                        this.setCtxGlobalAlpha(ctx, "reset", style);
                        break;
                    case 'both':
                        if (style.textRotation && style.textRotation !== 0) {
                            ctx.save();
                            ctx.translate(ox, oy);
                            ctx.rotate(style.textRotation * Math.PI / 180);
                            if (style.textBaseline == 'top') {
                                if (style.maxWidth) {
                                    this.setCtxGlobalAlpha(ctx, "fill", style);
                                    ctx.fillText(text[i], 0, lineHeight * i, style.maxWidth);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);

                                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                                    ctx.strokeText(text[i], 0, lineHeight * i, style.maxWidth);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);
                                } else {
                                    this.setCtxGlobalAlpha(ctx, "fill", style);
                                    ctx.fillText(text[i], 0, lineHeight * i);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);

                                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                                    ctx.strokeText(text[i], 0, lineHeight * i);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);
                                }
                            } else if (style.textBaseline == 'bottom') {
                                if (style.maxWidth) {
                                    this.setCtxGlobalAlpha(ctx, "fill", style);
                                    ctx.fillText(text[i], 0, lineHeight * (i + 1) - rect.height, style.maxWidth);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);

                                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height, style.maxWidth);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);
                                } else {
                                    this.setCtxGlobalAlpha(ctx, "fill", style);
                                    ctx.fillText(text[i], 0, lineHeight * (i + 1) - rect.height);
                                    this.setCtxGlobalAlpha(ctx, "reset", style);

                                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                                    ctx.strokeText(text[i], 0, lineHeight * (i + 1) - rect.height);
                                    this.setCtxGlobalAlpha(ct