/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plugins;

import android.location.Location;
import com.supermap.plugins.GpsLocation;
import com.supermap.plugins.WiFiLocation;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class SMLocation
extends CordovaPlugin {
    String errorString = "";
    public static final String ACTION = "Location";

    public boolean execute(String action, JSONArray data, CallbackContext callbackContext) {
        Object result = null;
        if (ACTION.equals(action)) {
            try {
                JSONObject fileInfo = new JSONObject();
                int TimeOut = Integer.parseInt(data.getString(0));
                fileInfo = this.locationInfo(TimeOut);
                callbackContext.success(fileInfo);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackContext.error("error on SMLocation");
                return false;
            }
        }
        return false;
    }

    private String errorFun(String str) {
        this.errorString = this.errorString == "" ? String.valueOf(this.errorString) + str : String.valueOf(this.errorString) + ";" + str;
        return this.errorString;
    }

    public JSONObject locationInfo(int time) throws Exception {
        String GPSerrorString;
        JSONObject fileInfo = new JSONObject();
        Location locationInfo = null;
        double lon = 0.0;
        double lat = 0.0;
        if (GpsLocation.isGpsActive()) {
            locationInfo = GpsLocation.gpsLocation(time);
            if (locationInfo != null) {
                lon = locationInfo.getLongitude();
                lat = locationInfo.getLatitude();
            } else {
                GPSerrorString = "GPS\u5b9a\u4f4d\u5931\u8d25";
                this.errorString = this.errorFun(GPSerrorString);
            }
        } else {
            GPSerrorString = "GPS\u672a\u6253\u5f00";
            this.errorString = this.errorFun(GPSerrorString);
        }
        if (locationInfo == null) {
            JSONObject locationWifiInfo = new JSONObject();
            if (WiFiLocation.isWiFiActive()) {
                locationWifiInfo = WiFiLocation.wifiLocation();
                Thread.sleep(1000L);
                if (WiFiLocation.locResult == null) {
                    String WifierrorString = "wifi\u5b9a\u4f4d\u5931\u8d25";
                    this.errorString = this.errorFun(WifierrorString);
                } else {
                    lat = WiFiLocation.locResult.getDouble("latitude");
                    lon = WiFiLocation.locResult.getDouble("longitude");
                }
            } else {
                String WifierrorString = "Wifi\u672a\u6253\u5f00";
                this.errorString = this.errorFun(WifierrorString);
            }
        }
        fileInfo.put("lon", lon);
        fileInfo.put("lat", lat);
        fileInfo.put("errorString", (Object)this.errorString);
        return fileInfo;
    }
}

