/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Vibrator;
import android.view.View;
import android.widget.EditText;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Notification
extends CordovaPlugin {
    public int confirmResult = -1;
    public ProgressDialog spinnerDialog = null;
    public ProgressDialog progressDialog = null;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("beep")) {
            this.beep(args.getLong(0));
        } else if (action.equals("vibrate")) {
            this.vibrate(args.getLong(0));
        } else {
            if (action.equals("alert")) {
                this.alert(args.getString(0), args.getString(1), args.getString(2), callbackContext);
                return true;
            }
            if (action.equals("confirm")) {
                this.confirm(args.getString(0), args.getString(1), args.getJSONArray(2), callbackContext);
                return true;
            }
            if (action.equals("prompt")) {
                this.prompt(args.getString(0), args.getString(1), args.getJSONArray(2), callbackContext);
                return true;
            }
            if (action.equals("activityStart")) {
                this.activityStart(args.getString(0), args.getString(1));
            } else if (action.equals("activityStop")) {
                this.activityStop();
            } else if (action.equals("progressStart")) {
                this.progressStart(args.getString(0), args.getString(1));
            } else if (action.equals("progressValue")) {
                this.progressValue(args.getInt(0));
            } else if (action.equals("progressStop")) {
                this.progressStop();
            } else {
                return false;
            }
        }
        callbackContext.success();
        return true;
    }

    public void beep(long count) {
        Uri ringtone = RingtoneManager.getDefaultUri((int)2);
        Ringtone notification = RingtoneManager.getRingtone((Context)this.cordova.getActivity().getBaseContext(), (Uri)ringtone);
        if (notification != null) {
            for (long i = 0L; i < count; ++i) {
                notification.play();
                long timeout = 5000L;
                while (notification.isPlaying() && timeout > 0L) {
                    timeout -= 100L;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public void vibrate(long time) {
        if (time == 0L) {
            time = 500L;
        }
        Vibrator vibrator = (Vibrator)this.cordova.getActivity().getSystemService("vibrator");
        vibrator.vibrate(time);
    }

    public synchronized void alert(final String message, final String title, final String buttonLabel, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)cordova.getActivity());
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                dlg.setPositiveButton((CharSequence)buttonLabel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                dlg.create();
                dlg.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void confirm(final String message, final String title, final JSONArray buttonLabels, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)cordova.getActivity());
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                if (buttonLabels.length() > 0) {
                    try {
                        dlg.setNegativeButton((CharSequence)buttonLabels.getString(0), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 1));
                            }
                        });
                    }
                    catch (JSONException e) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 1) {
                    try {
                        dlg.setNeutralButton((CharSequence)buttonLabels.getString(1), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 2));
                            }
                        });
                    }
                    catch (JSONException e) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 2) {
                    try {
                        dlg.setPositiveButton((CharSequence)buttonLabels.getString(2), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 3));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                dlg.create();
                dlg.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void prompt(final String message, final String title, final JSONArray buttonLabels, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        final EditText promptInput = new EditText((Context)cordova.getActivity());
        Runnable runnable = new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)cordova.getActivity());
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                dlg.setView((View)promptInput);
                final JSONObject result = new JSONObject();
                if (buttonLabels.length() > 0) {
                    try {
                        dlg.setNegativeButton((CharSequence)buttonLabels.getString(0), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 1);
                                    result.put("input1", (Object)promptInput.getText());
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException e) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 1) {
                    try {
                        dlg.setNeutralButton((CharSequence)buttonLabels.getString(1), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 2);
                                    result.put("input1", (Object)promptInput.getText());
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException e) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 2) {
                    try {
                        dlg.setPositiveButton((CharSequence)buttonLabels.getString(2), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 3);
                                    result.put("input1", (Object)promptInput.getText());
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        try {
                            result.put("buttonIndex", 0);
                            result.put("input1", (Object)promptInput.getText());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                    }
                });
                dlg.create();
                dlg.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStart(final String title, final String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                Notification.this.spinnerDialog = ProgressDialog.show((Context)cordova.getActivity(), (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        Notification.this.spinnerDialog = null;
                    }
                });
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStop() {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public synchronized void progressStart(final String title, final String message) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
        final Notification notification = this;
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                notification.progressDialog = new ProgressDialog((Context)cordova.getActivity());
                notification.progressDialog.setProgressStyle(1);
                notification.progressDialog.setTitle((CharSequence)title);
                notification.progressDialog.setMessage((CharSequence)message);
                notification.progressDialog.setCancelable(true);
                notification.progressDialog.setMax(100);
                notification.progressDialog.setProgress(0);
                notification.progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        notification.progressDialog = null;
                    }
                });
                notification.progressDialog.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void progressValue(int value) {
        if (this.progressDialog != null) {
            this.progressDialog.setProgress(value);
        }
    }

    public synchronized void progressStop() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }
}

