/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.LineNumber_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class LineNumberTableAttribute_info
extends Attribute_info {
    private List m_lines;

    public LineNumber_info get(int offset) {
        return (LineNumber_info)this.m_lines.get(offset);
    }

    public int size() {
        return this.m_lines.size();
    }

    public long length() {
        return 8 + (this.m_lines.size() << 2);
    }

    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("LineNumberTableAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int l = 0; l < this.size(); ++l) {
            s.append("            " + this.get(l));
            s.append("\n");
        }
        return s.toString();
    }

    public Object clone() {
        LineNumberTableAttribute_info _clone = (LineNumberTableAttribute_info)super.clone();
        int lines_count = this.m_lines.size();
        _clone.m_lines = new ArrayList(lines_count);
        for (int e = 0; e < lines_count; ++e) {
            _clone.m_lines.add(((LineNumber_info)this.m_lines.get(e)).clone());
        }
        return _clone;
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        int lines_count = this.m_lines.size();
        out.writeU2(lines_count);
        for (int l = 0; l < lines_count; ++l) {
            ((LineNumber_info)this.m_lines.get(l)).writeInClassFormat(out);
        }
    }

    LineNumberTableAttribute_info(int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        int lines_count = bytes.readU2();
        this.m_lines = new ArrayList(lines_count);
        for (int i = 0; i < lines_count; ++i) {
            this.m_lines.add(new LineNumber_info(bytes));
        }
    }
}

