/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.AliasFileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.FileRenderer;
import ch.randelshofer.quaqua.filechooser.FileTransferHandler;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.TreePath;

public class QuaquaJaguarFileChooserUI
extends BasicFileChooserUI {
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FileView fileView;
    private FilterComboBoxModel filterComboBoxModel;
    private AliasFileSystemTreeModel model = null;
    private static int PREF_WIDTH = 430;
    private static int PREF_HEIGHT = 330;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 430;
    private static int MIN_HEIGHT = 330;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    protected String chooseButtonText = null;
    private String newFolderDialogPrompt;
    private String newFolderDefaultName;
    private String newFolderErrorText;
    private String newFolderExistsErrorText;
    private String newFolderButtonText;
    private String newFolderTitleText;
    private AncestorListener ancestorListener;
    private FileTransferHandler fileTransferHandler;
    private Action newFolderAction = new NewFolderAction();
    private Action approveSelectionAction = new ApproveSelectionAction();
    private int isAdjusting = 0;
    private JPanel accessoryPanel;
    private JButton approveButton;
    private JBrowser browser;
    private JScrollPane browserScrollPane;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JComboBox directoryComboBox;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JLabel filesOfTypeLabel;
    private JComboBox filterComboBox;
    private JPanel formatPanel;
    private JPanel formatPanel2;
    private JPanel fromPanel;
    private JLabel lookInLabel;
    private JButton newFolderButton;
    private JPanel separatorPanel;
    private JPanel separatorPanel1;
    private JPanel separatorPanel2;
    private JPanel strutPanel1;
    private JPanel strutPanel2;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaJaguarFileChooserUI((JFileChooser)c);
    }

    public QuaquaJaguarFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        this.fromPanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.strutPanel1 = new JPanel();
        this.lookInLabel = new JLabel();
        this.directoryComboBox = new JComboBox();
        this.strutPanel2 = new JPanel();
        this.separatorPanel1 = new JPanel();
        this.separatorPanel2 = new JPanel();
        this.browserScrollPane = new JScrollPane();
        this.browser = new JBrowser();
        this.newFolderButton = new JButton();
        this.separatorPanel = new JPanel();
        this.formatPanel = new JPanel();
        this.formatPanel2 = new JPanel();
        this.filesOfTypeLabel = new JLabel();
        this.filterComboBox = new JComboBox();
        this.accessoryPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.approveButton = new JButton();
        fc.setLayout(new GridBagLayout());
        this.fromPanel.setLayout(new GridBagLayout());
        this.fileNameLabel.setText(UIManager.getString("FileChooser.fileNameLabelText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 14, 0);
        this.fromPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 14, 0);
        gridBagConstraints.weightx = 1.0;
        this.fromPanel.add((Component)this.fileNameTextField, gridBagConstraints);
        this.strutPanel1.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 5;
        this.fromPanel.add((Component)this.strutPanel1, gridBagConstraints);
        this.lookInLabel.setText(UIManager.getString("FileChooser.fromLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        gridBagConstraints.anchor = 13;
        this.fromPanel.add((Component)this.lookInLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.fromPanel.add((Component)this.directoryComboBox, gridBagConstraints);
        this.strutPanel2.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 5;
        this.fromPanel.add((Component)this.strutPanel2, gridBagConstraints);
        this.separatorPanel1.setLayout(new BorderLayout());
        this.separatorPanel1.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0E-4;
        this.fromPanel.add((Component)this.separatorPanel1, gridBagConstraints);
        this.separatorPanel2.setLayout(new BorderLayout());
        this.separatorPanel2.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 1;
        this.fromPanel.add((Component)this.separatorPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        fc.add((Component)this.fromPanel, gridBagConstraints);
        this.browserScrollPane.setHorizontalScrollBarPolicy(32);
        this.browserScrollPane.setVerticalScrollBarPolicy(21);
        this.browserScrollPane.setViewportView(this.browser);
        this.browserScrollPane.setPreferredSize(new Dimension(388, 298));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 23, 0, 23);
        fc.add((Component)this.browserScrollPane, gridBagConstraints);
        this.newFolderButton.setText(UIManager.getString("FileChooser.newFolderButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        fc.add((Component)this.newFolderButton, gridBagConstraints);
        this.separatorPanel.setLayout(new BorderLayout());
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        fc.add((Component)this.separatorPanel, gridBagConstraints);
        this.formatPanel.setLayout(new GridBagLayout());
        this.formatPanel2.setLayout(new BorderLayout(2, 0));
        this.filesOfTypeLabel.setText(UIManager.getString("FileChooser.filesOfTypeLabelText"));
        this.formatPanel2.add((Component)this.filesOfTypeLabel, "West");
        this.formatPanel2.add((Component)this.filterComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 40);
        this.formatPanel.add((Component)this.formatPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        fc.add((Component)this.formatPanel, gridBagConstraints);
        this.accessoryPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(14, 20, 0, 20);
        fc.add((Component)this.accessoryPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.cancelButton.setText(UIManager.getString("FileChooser.cancelButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 18, 16, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.approveButton.setText(UIManager.getString("FileChooser.openButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 16, 22);
        this.buttonPanel.add((Component)this.approveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        fc.add((Component)this.buttonPanel, gridBagConstraints);
        this.browser.setColumnCellRenderer(new FileRenderer(fc, UIManager.getIcon("Browser.expandingIcon"), UIManager.getIcon("Browser.expandedIcon"), UIManager.getIcon("Browser.selectedExpandingIcon"), UIManager.getIcon("Browser.selectedExpandedIcon"), UIManager.getIcon("Browser.focusedSelectedExpandingIcon"), UIManager.getIcon("Browser.focusedSelectedExpandedIcon")));
        if (fc.isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
        }
        this.browser.setModel(this.getTreeModel());
        this.browser.setPrototypeCellValue(this.getTreeModel().getPrototypeValue());
        this.browser.addTreeSelectionListener(this.createBrowserSelectionListener(fc));
        this.browser.addMouseListener(this.createDoubleClickListener(fc));
        this.separatorPanel.setOpaque(true);
        this.separatorPanel1.setOpaque(true);
        this.separatorPanel2.setOpaque(true);
        this.formatPanel.setVisible(fc.getChoosableFileFilters().length > 1);
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        } else {
            this.accessoryPanel.setVisible(false);
        }
        this.lookInLabel.setText(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.newFolderButton.setText(this.newFolderTitleText);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.fileNameLabel.setText(this.fileNameLabelText);
        this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        if (!fc.getControlButtonsAreShown()) {
            this.cancelButton.setVisible(false);
            this.approveButton.setVisible(false);
        }
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.fileNameTextField.addFocusListener(new SaveTextFocusListener());
        this.fileNameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.fileTransferHandler = new FileTransferHandler(fc);
        Component[] dropComponents = new Component[]{fc, this.accessoryPanel, this.approveButton, this.browser, this.browserScrollPane, this.buttonPanel, this.cancelButton, this.directoryComboBox, this.fileNameLabel, this.fileNameTextField, this.filesOfTypeLabel, this.filterComboBox, this.formatPanel, this.formatPanel2, this.fromPanel, this.lookInLabel, this.newFolderButton, this.separatorPanel, this.separatorPanel1, this.separatorPanel2, this.strutPanel1, this.strutPanel2};
        for (int i = 0; i < dropComponents.length; ++i) {
            new DropTarget(dropComponents[i], 1, this.fileTransferHandler);
        }
        boolean isSave = fc.getDialogType() == 1 || fc.getDialogType() == 2;
        this.lookInLabel.setText(isSave ? this.saveInLabelText : this.lookInLabelText);
        this.fileNameLabel.setVisible(isSave);
        this.fileNameTextField.setVisible(isSave);
        this.fileNameTextField.setEnabled(isSave);
        this.updateSeparatorPanelVisibility();
        this.separatorPanel1.setVisible(isSave);
        this.separatorPanel2.setVisible(isSave);
        this.separatorPanel1.setVisible(isSave);
        this.newFolderButton.setVisible(isSave);
        Dimension ps = this.getMinimumSize(fc);
        fc.setBounds(0, 0, ps.width, ps.height);
        fc.doLayout();
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected void installStrings(JFileChooser fc) {
        Locale l;
        super.installStrings(fc);
        try {
            l = fc.getLocale();
        }
        catch (IllegalComponentStateException e) {
            l = Locale.getDefault();
        }
        this.chooseButtonText = UIManager.getString("FileChooser.chooseButtonText");
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString("FileChooser.lookInLabelText");
        if (this.lookInLabelText == null) {
            this.lookInLabelText = UIManager.getString("FileChooser.fromLabelText");
        }
        this.saveInLabelText = UIManager.getString("FileChooser.saveInLabelText");
        if (this.saveInLabelText == null) {
            this.saveInLabelText = UIManager.getString("FileChooser.whereLabelText");
        }
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = UIManager.getString("FileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = UIManager.getString("FileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", l, "Error occured during folder creation");
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", l, "That name is already taken");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", l, "New");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", l, "New Folder");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", l, "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", l, "untitled folder");
        this.newFolderTitleText = UIManager.getString("FileChooser.newFolderTitleText");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = this.getString("FileChooser.newFolderAccessibleName", l, this.newFolderTitleText);
    }

    private String getString(String string, Locale l, String defaultValue) {
        String value = UIManager.getString(string);
        return value == null ? defaultValue : value;
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.ancestorListener = this.createAncestorListener(fc);
        if (this.ancestorListener != null) {
            fc.addAncestorListener(this.ancestorListener);
        }
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.ancestorListener != null) {
            fc.removeAncestorListener(this.ancestorListener);
        }
    }

    protected AncestorListener createAncestorListener(JFileChooser fc) {
        return new FileChooserAncestorListener();
    }

    public void createModel() {
        JFileChooser fc = this.getFileChooser();
        this.model = new AliasFileSystemTreeModel(fc);
        this.model.setResolveFileLabels(false);
        this.fileView = QuaquaFileSystemView.getQuaquaFileSystemView().createFileView(fc);
        fc.setFileView(this.fileView);
        fc.setFileSystemView(QuaquaFileSystemView.getQuaquaFileSystemView());
    }

    public AliasFileSystemTreeModel getTreeModel() {
        return this.model;
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    private File[] getSelectedFiles() {
        JFileChooser fc = this.getFileChooser();
        if (fc.isMultiSelectionEnabled()) {
            File[] selectedFiles = fc.getSelectedFiles();
            ArrayList<File> list = new ArrayList<File>(selectedFiles.length);
            for (int i = 0; i < selectedFiles.length; ++i) {
                if (selectedFiles[i] == null) continue;
                if (selectedFiles[i].isAbsolute()) {
                    list.add(selectedFiles[i]);
                    continue;
                }
                list.add(new File(fc.getCurrentDirectory(), selectedFiles[i].getName()));
            }
            return list.toArray(new File[list.size()]);
        }
        File f = fc.getSelectedFile();
        if (f == null) {
            return new File[0];
        }
        if (f.isAbsolute()) {
            return new File[]{f};
        }
        return new File[]{new File(fc.getCurrentDirectory(), f.getName())};
    }

    private void updateSelection() {
        JFileChooser fc = this.getFileChooser();
        File[] files = this.getSelectedFiles();
        if (files.length != 0) {
            TreePath[] paths = new TreePath[files.length];
            ArrayList<Serializable> list = new ArrayList<Serializable>(paths.length);
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory;
                File file = files[i];
                boolean bl = isDirectory = file.isDirectory() && fc.isTraversable(file);
                if (files.length != 1 && isDirectory && !fc.isDirectorySelectionEnabled()) continue;
                list.add(this.getTreeModel().toPath(file, this.browser.getSelectionPath()));
            }
            if (list.size() == 0 && files.length > 0) {
                list.add(fc.getFileSystemView().getParentDirectory(files[0]));
            }
            this.browser.setSelectionPaths(list.toArray(new TreePath[list.size()]));
            if (files.length == 1 && !files[0].isDirectory() || !fc.isTraversable(files[0])) {
                this.setFileName(files[0].getName());
            }
        }
        if (files.length == 0) {
            this.directoryComboBoxModel.addItem(fc.getCurrentDirectory());
        } else if (files[0].isDirectory()) {
            this.directoryComboBoxModel.addItem(files[0]);
        } else {
            this.directoryComboBoxModel.addItem(files[0].getParentFile());
        }
        if (files.length == 1) {
            this.ensureFileIsVisible(fc, files[0]);
        }
        this.updateApproveButtonState();
    }

    private boolean isFileNameFieldValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    private boolean isFileNameFieldVisible() {
        JFileChooser fc = this.getFileChooser();
        return fc.getDialogType() == 1 || fc.getDialogType() == 2;
    }

    private void updateApproveButtonState() {
        JFileChooser fc = this.getFileChooser();
        if (fc.getControlButtonsAreShown()) {
            JRootPane rp;
            File[] files = this.getSelectedFiles();
            boolean isFileSelected = false;
            boolean isDirectorySelected = false;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() && fc.isTraversable(files[i])) {
                    isDirectorySelected = true;
                    continue;
                }
                isFileSelected = true;
            }
            boolean isEnabled = false;
            switch (fc.getFileSelectionMode()) {
                case 0: {
                    isEnabled = isFileSelected || this.isFileNameFieldVisible() && this.isFileNameFieldValid();
                    break;
                }
                case 1: {
                    isEnabled = !isFileSelected || files.length == 1 && !files[0].exists();
                    break;
                }
                case 2: {
                    isEnabled = true;
                }
            }
            this.approveButton.setEnabled(isEnabled);
            if (isEnabled && (rp = this.approveButton.getRootPane()) != null) {
                rp.setDefaultButton(this.approveButton);
            }
        }
    }

    private void updateApproveButtonText() {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
    }

    protected TreeSelectionListener createBrowserSelectionListener(JFileChooser fc) {
        return new BrowserSelectionListener();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(Math.max(d.width, QuaquaJaguarFileChooserUI.PREF_SIZE.width), Math.max(d.height, QuaquaJaguarFileChooserUI.PREF_SIZE.height));
        }
        return new Dimension(QuaquaJaguarFileChooserUI.PREF_SIZE.width, QuaquaJaguarFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        File[] files = this.getSelectedFiles();
        if (files.length == 0) {
            File dir = (File)e.getNewValue();
            this.directoryComboBoxModel.addItem(dir);
            this.browser.setSelectionPath(this.model.toPath(dir, this.browser.getSelectionPath()));
            this.model.lazyInvalidatePath(this.browser.getSelectionPath());
            if (dir != null) {
                this.getNewFolderAction().setEnabled(dir.canWrite());
                this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(dir));
                if (fc.getDialogType() == 0) {
                    this.updateApproveButtonState();
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        this.model.invalidatePath(this.browser.getSelectionPath());
        if (this.getFileChooser().isShowing()) {
            this.model.validatePath(this.browser.getSelectionPath());
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        this.updateApproveButtonText();
        this.updateApproveButtonState();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doChoosableFilterChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        boolean isChooserVisible = ((FileFilter[])e.getNewValue()).length > 1;
        this.formatPanel.setVisible(isChooserVisible);
        this.updateSeparatorPanelVisibility();
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
            this.accessoryPanel.setVisible(accessory != null);
        }
        this.updateSeparatorPanelVisibility();
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        boolean isSave = this.isFileNameFieldVisible();
        this.lookInLabel.setText(isSave ? this.saveInLabelText : this.lookInLabelText);
        this.fileNameLabel.setVisible(isSave);
        this.fileNameTextField.setVisible(isSave);
        this.fileNameTextField.setEnabled(isSave);
        this.updateSeparatorPanelVisibility();
        this.separatorPanel1.setVisible(isSave);
        this.separatorPanel2.setVisible(isSave);
        this.separatorPanel1.setVisible(isSave);
        this.newFolderButton.setVisible(isSave);
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                QuaquaJaguarFileChooserUI.this.isAdjusting++;
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    QuaquaJaguarFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    QuaquaJaguarFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    QuaquaJaguarFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ChoosableFileFilterChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doChoosableFilterChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    QuaquaJaguarFileChooserUI.this.doControlButtonsChanged(e);
                } else if (!s.equals("componentOrientation") && s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    QuaquaJaguarFileChooserUI.this.browser.ensurePathIsVisible(QuaquaJaguarFileChooserUI.this.browser.getSelectionPath());
                    QuaquaJaguarFileChooserUI.this.fileNameTextField.selectAll();
                    QuaquaJaguarFileChooserUI.this.fileNameTextField.requestFocus();
                }
                QuaquaJaguarFileChooserUI.this.isAdjusting--;
            }
        };
    }

    private void updateSeparatorPanelVisibility() {
        JFileChooser fc = this.getFileChooser();
        boolean isSave = fc.getDialogType() == 1 || fc.getDialogType() == 2;
        this.separatorPanel.setVisible(isSave && (fc.getControlButtonsAreShown() || !fc.isAcceptAllFileFilterUsed() || fc.getAccessory() != null));
    }

    protected void removeControlButtons() {
        this.buttonPanel.setVisible(false);
        this.updateSeparatorPanelVisibility();
    }

    protected void addControlButtons() {
        this.buttonPanel.setVisible(true);
        this.updateSeparatorPanelVisibility();
    }

    private void ensurePathIsVisible(TreePath path) {
        this.browser.ensurePathIsVisible(path);
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (!(this.fileNameTextField == null || filename != null && this.fileNameTextField.getText().equals(filename))) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void maybeApproveSelection() {
        JFileChooser fc = this.getFileChooser();
        File selectedFile = null;
        File[] selectedFiles = null;
        String filename = null;
        if (this.isFileNameFieldVisible() && (filename = this.getFileName()).equals("")) {
            filename = null;
        }
        if (fc.isMultiSelectionEnabled()) {
            TreePath[] selectedPaths = this.browser.getSelectionPaths();
            if (filename != null) {
                selectedFiles = new File[]{new File(fc.getFileSystemView().getParentDirectory(((AliasFileSystemTreeModel.Node)selectedPaths[0].getLastPathComponent()).lazyGetResolvedFile()), filename)};
            } else {
                selectedFiles = new File[selectedPaths.length];
                for (int i = 0; i < selectedPaths.length; ++i) {
                    selectedFiles[i] = ((AliasFileSystemTreeModel.Node)selectedPaths[i].getLastPathComponent()).getResolvedFile();
                }
            }
        } else {
            selectedFile = ((AliasFileSystemTreeModel.Node)this.browser.getSelectionPath().getLastPathComponent()).getResolvedFile();
            if (filename != null) {
                selectedFile = new File(selectedFile.isDirectory() && fc.isTraversable(selectedFile) ? selectedFile : fc.getFileSystemView().getParentDirectory(selectedFile), filename);
            }
            if (fc.getFileSelectionMode() == 0 && selectedFile.isDirectory() && fc.isTraversable(selectedFile)) {
                return;
            }
        }
        if (selectedFiles != null || selectedFile != null) {
            if (selectedFiles != null) {
                fc.setSelectedFiles(selectedFiles);
            } else if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(new File[]{selectedFile});
            } else {
                fc.setSelectedFile(selectedFile);
            }
            fc.approveSelection();
        } else {
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(null);
            } else {
                fc.setSelectedFile(null);
            }
            fc.cancelSelection();
        }
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (f != null) {
            if (!f.isAbsolute()) {
                f = new File(fc.getCurrentDirectory(), f.getName());
            }
            this.ensurePathIsVisible(this.getTreeModel().toPath(f, this.browser.getSelectionPath()));
        }
    }

    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.isDirectorySelectionEnabled() && this.chooseButtonText != null) {
            return this.chooseButtonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        if (fc.isShowing()) {
            this.model.lazyInvalidatePath(this.browser.getSelectionPath());
            this.model.validatePath(this.browser.getSelectionPath());
        }
    }

    public void clearIconCache() {
        try {
            this.fileView.getClass().getMethod("clearIconCache", new Class[0]).invoke((Object)this.fileView, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc) {
        return new DoubleClickListener();
    }

    private class FileChooserAncestorListener
    implements AncestorListener {
        private FileChooserAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
            if (QuaquaJaguarFileChooserUI.this.model != null) {
                QuaquaJaguarFileChooserUI.this.model.setAutoValidate(QuaquaManager.getBoolean("FileChooser.autovalidate"));
                QuaquaJaguarFileChooserUI.this.model.validatePath(QuaquaJaguarFileChooserUI.this.browser.getSelectionPath());
            }
            QuaquaJaguarFileChooserUI.this.updateApproveButtonState();
        }

        public void ancestorRemoved(AncestorEvent event) {
            if (QuaquaJaguarFileChooserUI.this.model != null) {
                QuaquaJaguarFileChooserUI.this.model.setAutoValidate(false);
                QuaquaJaguarFileChooserUI.this.model.stopValidation();
                QuaquaJaguarFileChooserUI.this.model.invalidatePath(QuaquaJaguarFileChooserUI.this.browser.getSelectionPath());
                QuaquaJaguarFileChooserUI.this.clearIconCache();
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        public void removeUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        public void changedUpdate(DocumentEvent documentevent) {
        }

        private void textChanged() {
            if (QuaquaJaguarFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFileChooser fc = QuaquaJaguarFileChooserUI.this.getFileChooser();
                    File file = ((AliasFileSystemTreeModel.Node)QuaquaJaguarFileChooserUI.this.browser.getSelectionPath().getLastPathComponent()).getResolvedFile();
                    if (QuaquaJaguarFileChooserUI.this.fileNameTextField.getText().length() != 0) {
                        file = file.isDirectory() && fc.isTraversable(file) ? new File(file, QuaquaJaguarFileChooserUI.this.fileNameTextField.getText()) : new File(fc.getFileSystemView().getParentDirectory(file), QuaquaJaguarFileChooserUI.this.fileNameTextField.getText());
                    }
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{file});
                    } else {
                        fc.setSelectedFile(file);
                    }
                }
            });
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        public void focusGained(FocusEvent focusevent) {
            QuaquaJaguarFileChooserUI.this.updateApproveButtonState();
        }

        public void focusLost(FocusEvent focusevent) {
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        private String showNewFolderDialog() {
            JOptionPane optionPane = new JOptionPane(QuaquaJaguarFileChooserUI.this.newFolderDialogPrompt, -1, 2);
            optionPane.setWantsInput(true);
            optionPane.setInitialSelectionValue(QuaquaJaguarFileChooserUI.this.newFolderDefaultName);
            JDialog dialog = optionPane.createDialog(QuaquaJaguarFileChooserUI.this.getFileChooser(), QuaquaJaguarFileChooserUI.this.newFolderTitleText);
            dialog.show();
            dialog.dispose();
            return optionPane.getInputValue() == JOptionPane.UNINITIALIZED_VALUE ? null : (String)optionPane.getInputValue();
        }

        public void actionPerformed(ActionEvent actionevent) {
            JFileChooser fc = QuaquaJaguarFileChooserUI.this.getFileChooser();
            String newFolderName = this.showNewFolderDialog();
            if (newFolderName != null) {
                File newFolder;
                File currentFile = ((AliasFileSystemTreeModel.Node)QuaquaJaguarFileChooserUI.this.browser.getSelectionPath().getLastPathComponent()).getResolvedFile();
                if (!currentFile.isDirectory() || !fc.isTraversable(currentFile)) {
                    currentFile = fc.getFileSystemView().getParentDirectory(currentFile);
                }
                if ((newFolder = new File(currentFile, newFolderName)).exists()) {
                    JOptionPane.showMessageDialog(fc, QuaquaJaguarFileChooserUI.this.newFolderExistsErrorText, QuaquaJaguarFileChooserUI.this.newFolderTitleText, 0);
                    return;
                }
                try {
                    newFolder.mkdir();
                    fc.rescanCurrentDirectory();
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{newFolder});
                    } else {
                        fc.setSelectedFile(newFolder);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(fc, QuaquaJaguarFileChooserUI.this.newFolderErrorText, QuaquaJaguarFileChooserUI.this.newFolderTitleText, 0);
                }
            }
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent e) {
            QuaquaJaguarFileChooserUI.this.maybeApproveSelection();
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JFileChooser fc = QuaquaJaguarFileChooserUI.this.getFileChooser();
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && fc.getDialogType() != 1) {
                QuaquaJaguarFileChooserUI.this.maybeApproveSelection();
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaJaguarFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            JFileChooser fc = QuaquaJaguarFileChooserUI.this.getFileChooser();
            File file = (File)QuaquaJaguarFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (file != null) {
                if (fc.isMultiSelectionEnabled()) {
                    fc.setSelectedFiles(new File[]{file});
                } else {
                    fc.setSelectedFile(file);
                }
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = QuaquaJaguarFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                QuaquaJaguarFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = QuaquaJaguarFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    QuaquaJaguarFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return QuaquaJaguarFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return QuaquaJaguarFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object[] directories = new Object[5];
        Object selectedDirectory = null;
        JFileChooser chooser = QuaquaJaguarFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = QuaquaJaguarFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
            this.directories[0] = new File(QuaquaManager.getProperty("user.home"));
            this.directories[1] = "";
            this.directories[2] = new File(QuaquaManager.getProperty("user.home"), "Desktop");
            this.directories[3] = new File(QuaquaManager.getProperty("user.home"));
            this.directories[4] = new File("/");
        }

        private void addItem(File directory) {
            QuaquaJaguarFileChooserUI.this.isAdjusting++;
            this.directories[0] = directory;
            this.selectedDirectory = directory;
            this.fireContentsChanged(this, -1, -1);
            this.fireContentsChanged(this, 0, 0);
            QuaquaJaguarFileChooserUI.this.isAdjusting--;
        }

        public void setSelectedItem(Object selectedDirectory) {
            if (selectedDirectory instanceof File) {
                this.selectedDirectory = (File)selectedDirectory;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.length;
        }

        public Object getElementAt(int index) {
            return this.directories[index];
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        public int getIconWidth() {
            return this.icon == null ? this.depth * 10 : this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        final File root = new File("/");
        IndentIcon ii = new IndentIcon();

        DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
                this.setText((String)value);
                this.setPreferredSize(new Dimension(10, 14));
                return this;
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setPreferredSize(null);
            File directory = (File)value;
            this.setText(QuaquaJaguarFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = QuaquaJaguarFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = 0;
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class BrowserSelectionListener
    implements TreeSelectionListener {
        protected BrowserSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (QuaquaJaguarFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            JFileChooser fc = QuaquaJaguarFileChooserUI.this.getFileChooser();
            FileSystemView fsv = fc.getFileSystemView();
            TreePath path = QuaquaJaguarFileChooserUI.this.browser.getSelectionPath();
            if (path != null) {
                QuaquaJaguarFileChooserUI.this.model.lazyInvalidatePath(path);
                QuaquaJaguarFileChooserUI.this.model.validatePath(path);
            }
            TreePath[] paths = QuaquaJaguarFileChooserUI.this.browser.getSelectionPaths();
            boolean count = false;
            File[] files = new File[paths == null ? 0 : paths.length];
            ArrayList<File> list = new ArrayList<File>(files.length);
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory;
                File file = ((AliasFileSystemTreeModel.Node)paths[i].getLastPathComponent()).getResolvedFile();
                boolean bl = isDirectory = file.isDirectory() && fc.isTraversable(file);
                if (files.length != 1 && isDirectory && !fc.isDirectorySelectionEnabled()) continue;
                list.add(file);
            }
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(list.toArray(new File[list.size()]));
            } else {
                fc.setSelectedFile(list.size() > 0 ? (File)list.get(0) : null);
            }
        }
    }
}

