/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class QuaquaTextFieldBorder
extends VisualMargin
implements BackgroundBorder {
    private String imagesLocation;
    private Insets imageInsets;
    private Insets searchImageInsets;
    private Insets smallSearchImageInsets;
    private String searchImagesLocation;
    private String smallSearchImagesLocation;
    private Border[] plainBorders;
    private Border[] searchBorders;
    private Border[] smallSearchBorders;
    private Border textFieldBackground = new Border(){

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c.isOpaque()) {
                g.setColor(UIManager.getColor("Panel.background"));
                g.fillRect(0, 0, width, height);
            }
            g.setColor(c.getBackground());
            Insets insets = QuaquaTextFieldBorder.this.getVisualMargin(c, new Insets(0, 0, 0, 0));
            if (QuaquaTextFieldBorder.isSearchField(c)) {
                int arc = Math.min(width - insets.left - insets.right - 8, height - insets.top - insets.bottom - 7);
                g.fillRoundRect(insets.left + 4, insets.bottom + 3, width - insets.left - insets.right - 8, height - insets.top - insets.bottom - 7, arc, arc);
            } else {
                g.fillRect(insets.left + 3, insets.bottom + 3, width - insets.left - insets.right - 6, height - insets.top - insets.bottom - 7);
            }
        }
    };

    public QuaquaTextFieldBorder(String imagesLocation, Insets imageInsets, String searchImagesLocation, Insets searchImageInsets, String smallSearchImagesLocation, Insets smallSearchImageInsets) {
        super(3, 3, 2, 3);
        this.imageInsets = imageInsets;
        this.searchImageInsets = searchImageInsets;
        this.smallSearchImageInsets = smallSearchImageInsets;
        this.imagesLocation = imagesLocation;
        this.searchImagesLocation = searchImagesLocation;
        this.smallSearchImagesLocation = smallSearchImagesLocation;
    }

    private static boolean isSmall(Component c) {
        return QuaquaUtilities.isSmallSizeVariant((JComponent)c);
    }

    private static boolean isSearchField(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            return jc.getClientProperty("Quaqua.TextField.style") != null && jc.getClientProperty("Quaqua.TextField.style").equals("search");
        }
        return false;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets margin;
        insets = this.getVisualMargin(c, insets);
        Insets inner = QuaquaTextFieldBorder.isSmall(c) ? (QuaquaTextFieldBorder.isSearchField(c) ? new Insets(6, 10, 5, 10) : new Insets(6, 7, 5, 7)) : (QuaquaTextFieldBorder.isSearchField(c) ? new Insets(6, 9, 6, 9) : new Insets(6, 7, 6, 7));
        InsetsUtil.addTo(inner, insets);
        if (c instanceof JTextComponent && (margin = ((JTextComponent)c).getMargin()) != null) {
            InsetsUtil.addTo(margin, insets);
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets margin = this.getVisualMargin(c, new Insets(0, 0, 0, 0));
        Border border = this.getBorder(c);
        border.paintBorder(c, g, x + margin.left, y + margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom);
        if (c instanceof JTextComponent) {
            Debug.paint(g, (JTextComponent)c, ((JTextComponent)c).getUI());
        }
    }

    public Border getBackgroundBorder() {
        return this.textFieldBackground;
    }

    private Border getBorder(Component c) {
        Border[] borders;
        if (QuaquaTextFieldBorder.isSearchField(c)) {
            if (QuaquaTextFieldBorder.isSmall(c)) {
                if (this.smallSearchBorders == null) {
                    this.smallSearchBorders = (Border[])QuaquaBorderFactory.create(this.smallSearchImagesLocation, this.smallSearchImageInsets, 3, true);
                }
                borders = this.smallSearchBorders;
            } else {
                if (this.searchBorders == null) {
                    this.searchBorders = (Border[])QuaquaBorderFactory.create(this.searchImagesLocation, this.searchImageInsets, 3, true);
                }
                borders = this.searchBorders;
            }
        } else {
            if (this.plainBorders == null) {
                this.plainBorders = (Border[])QuaquaBorderFactory.create(this.imagesLocation, this.imageInsets, 3, true);
            }
            borders = this.plainBorders;
        }
        boolean isEditable = c instanceof JTextComponent ? ((JTextComponent)c).isEditable() : true;
        if (QuaquaUtilities.isFocused(c) && c.isEnabled()) {
            return borders[2];
        }
        if (c.isEnabled() && isEditable) {
            return borders[0];
        }
        return borders[1];
    }

    public static class UIResource
    extends QuaquaTextFieldBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(String imagesLocation, String searchImagesLocation, String smallSearchImagesLocation) {
            this(imagesLocation, new Insets(6, 6, 5, 6), searchImagesLocation, new Insets(13, 13, 13, 13), smallSearchImagesLocation, new Insets(11, 13, 11, 13));
        }

        public UIResource(String imagesLocation, Insets imageInsets, String searchImagesLocation, Insets searchImageInsets, String smallSearchImagesLocation, Insets smallSearchImageInsets) {
            super(imagesLocation, imageInsets, searchImagesLocation, searchImageInsets, smallSearchImagesLocation, smallSearchImageInsets);
        }
    }
}

