/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PAppletMethods
extends Task {
    private File baseDir;

    public void setDir(String dir) {
        this.baseDir = new File(dir);
    }

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("dir parameter must be set!");
        }
        File graphicsFile = new File(this.baseDir, "PGraphics.java");
        File appletFile = new File(this.baseDir, "PApplet.java");
        File imageFile = new File(this.baseDir, "PImage.java");
        if (!graphicsFile.exists() || !graphicsFile.canRead()) {
            throw new BuildException("PGraphics file not readable: " + graphicsFile.getAbsolutePath());
        }
        if (!(appletFile.exists() && appletFile.canRead() && appletFile.canWrite())) {
            throw new BuildException("PApplet file not read/writeable: " + appletFile.getAbsolutePath());
        }
        if (!imageFile.exists() || !imageFile.canRead()) {
            throw new BuildException("PImage file not readable: " + imageFile.getAbsolutePath());
        }
        StringBuffer out = new StringBuffer();
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader applet = PAppletMethods.createReader(appletFile);
            while ((line = applet.readLine()) != null) {
                out.append(line);
                out.append('\n');
                content.append(line);
                content.append('\n');
                if (line.indexOf("public functions for processing.core") < 0) continue;
            }
            while ((line = applet.readLine()) != null) {
                content.append(line);
                content.append('\n');
            }
            applet.close();
            this.process(out, graphicsFile);
            this.process(out, imageFile);
            out.append('}');
            out.append('\n');
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        String outString = out.toString();
        if (content.toString().equals(outString)) {
            System.out.println("No changes to PApplet API.");
        } else {
            System.out.println("Updating PApplet with API changes from PImage or PGraphics.");
            try {
                PrintStream temp = new PrintStream(appletFile, "UTF-8");
                temp.print(outString);
                temp.flush();
                temp.close();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void process(StringBuffer out, File input) throws IOException {
        BufferedReader in = PAppletMethods.createReader(input);
        int comments = 0;
        String line = null;
        StringBuffer commentBuffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            String decl = "";
            if (line.indexOf("/*") != -1) {
                ++comments;
            }
            if (line.indexOf("*/") != -1) {
                commentBuffer.append(line);
                commentBuffer.append('\n');
                --comments;
                continue;
            }
            if (comments > 0) {
                commentBuffer.append(line);
                commentBuffer.append('\n');
                continue;
            }
            boolean gotSomething = false;
            boolean gotStatic = false;
            Matcher result = Pattern.compile("^\\s*public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
            if (result.matches()) {
                gotSomething = true;
            } else {
                result = Pattern.compile("^\\s*abstract public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                if (result.matches()) {
                    gotSomething = true;
                } else {
                    result = Pattern.compile("^\\s*public final ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                    if (result.matches()) {
                        gotSomething = true;
                    } else {
                        result = Pattern.compile("^\\s*static public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                        if (result.matches()) {
                            gotSomething = true;
                            gotStatic = true;
                        }
                    }
                }
            }
            if (gotSomething && line.indexOf("// ignore") >= 0) {
                gotSomething = false;
            }
            String returns = "";
            if (gotSomething) {
                String[] parts;
                returns = result.group(1).equals("void") ? "" : "return ";
                line = line.replaceFirst(Pattern.quote("abstract"), " ");
                line = line.replaceAll(Pattern.quote(";"), " {\n");
                out.append('\n');
                out.append('\n');
                out.append(commentBuffer.toString());
                commentBuffer.setLength(0);
                out.append(line);
                out.append('\n');
                decl = decl + line;
                while (line.indexOf(41) == -1) {
                    line = in.readLine();
                    decl = decl + line;
                    line = line.replaceAll("\\;\\s*$", " {\n");
                    out.append(line);
                    out.append('\n');
                }
                result = Pattern.compile(".*?\\s(\\S+)\\(.*?").matcher(decl);
                result.matches();
                String declName = result.group(1);
                String gline = "";
                String rline = "";
                if (gotStatic) {
                    gline = "    " + returns + "PGraphics." + declName + "(";
                } else {
                    rline = "    if (recorder != null) recorder." + declName + "(";
                    gline = "    " + returns + "g." + declName + "(";
                }
                decl = decl.replaceAll("\\s+", " ");
                decl = decl.replaceFirst("^.*\\(", "");
                decl = decl.replaceFirst("\\).*$", "");
                boolean prev = false;
                for (String part : parts = decl.split("\\, ")) {
                    if (part.trim().equals("")) continue;
                    String[] blargh = part.split(" ");
                    String theArg = blargh[1].replaceAll("[\\[\\]]", "");
                    if (prev) {
                        gline = gline + ", ";
                        rline = rline + ", ";
                    }
                    gline = gline + theArg;
                    rline = rline + theArg;
                    prev = true;
                }
                gline = gline + ");";
                rline = rline + ");";
                if (!gotStatic && returns.equals("")) {
                    out.append(rline);
                    out.append('\n');
                }
                out.append(gline);
                out.append('\n');
                out.append("  }");
                out.append('\n');
                continue;
            }
            commentBuffer.setLength(0);
        }
        in.close();
    }

    static BufferedReader createReader(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
    }
}

