/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.qq.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.qq.handler.UmengQBaseHandler;
import com.umeng.qq.handler.UmengQQPreferences;
import com.umeng.qq.handler.UmengQQShareContent;
import com.umeng.qq.tencent.IUiListener;
import com.umeng.qq.tencent.Tencent;
import com.umeng.qq.tencent.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UmengQQHandler
extends UmengQBaseHandler {
    private IUiListener mShareListener;
    private UmengQQPreferences qqPreferences;
    private final String UNIONID_REQUEST_URL = "https://graph.qq.com/oauth2.0/me?access_token=";
    private final String UNIONID_PARAM = "&unionid=1";

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        if (context != null) {
            this.qqPreferences = new UmengQQPreferences(this.getContext(), SHARE_MEDIA.QQ.toString());
        }
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        Bundle bundle;
        String error;
        UmengQQShareContent shareContent = new UmengQQShareContent(content);
        if (this.mShareConfig != null) {
            shareContent.setCompressListener(this.mShareConfig.getCompressListener());
        }
        if (this.mTencent == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQQHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.tencentEmpty((boolean)Config.isUmengQQ)));
                }
            });
            return false;
        }
        this.mShareListener = this.getQQSharelistener(listener);
        if (!this.isInstall()) {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"http://log.umsns.com/link/qq/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQQHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(error = (bundle = shareContent.getBundle(this.getShareConfig().isHideQzoneOnQQFriendList(), this.getShareConfig().getAppName())).getString("error")))) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQQHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(error));
                }
            });
            return false;
        }
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mTencent.shareToQQ((Activity)this.mWeakAct.get(), bundle, this.mShareListener);
        }
        return true;
    }

    public boolean isAuthorize() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.isAuthValid();
        }
        return false;
    }

    private IUiListener getQQSharelistener(final UMShareListener listener) {
        return new IUiListener(){

            @Override
            public void onError(final UiError e) {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UmengQQHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.ShareFailed.getMessage() + (e == null ? "" : e.errorMessage)));
                    }
                });
            }

            @Override
            public void onCancel() {
                UmengQQHandler.this.getShareListener(listener).onCancel(SHARE_MEDIA.QQ);
            }

            @Override
            public void onComplete(Object response) {
                UmengQQHandler.this.getShareListener(listener).onResult(SHARE_MEDIA.QQ);
            }
        };
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10103) {
            Tencent.onActivityResultData(requestCode, resultCode, data, this.mShareListener);
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData(requestCode, resultCode, data, this.getQQAuthlistener(this.mAuthListener));
        }
    }

    private IUiListener getQQAuthlistener(final UMAuthListener listener) {
        return new IUiListener(){

            @Override
            public void onError(UiError e) {
                UmengQQHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + "==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            @Override
            public void onCancel() {
                UmengQQHandler.this.getAuthListener(listener).onCancel(SHARE_MEDIA.QQ, 0);
            }

            @Override
            public void onComplete(final Object response) {
                SocializeUtils.safeCloseDialog((Dialog)UmengQQHandler.this.mProgressDialog);
                final Bundle values = UmengQQHandler.this.parseOauthData(response);
                if (UmengQQHandler.this.qqPreferences == null && UmengQQHandler.this.getContext() != null) {
                    UmengQQHandler.this.qqPreferences = new UmengQQPreferences(UmengQQHandler.this.getContext(), SHARE_MEDIA.QQ.toString());
                }
                if (UmengQQHandler.this.qqPreferences != null) {
                    UmengQQHandler.this.qqPreferences.setAuthData(values).commit();
                }
                QueuedWork.runInBack((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("https://graph.qq.com/oauth2.0/me?access_token=").append(UmengQQHandler.this.getmAccessToken()).append("&unionid=1");
                        String result = UmengQQHandler.this.getUnionIdRequest(stringBuilder.toString());
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                String errormessage;
                                JSONObject jsonObject = new JSONObject(result.replace("callback", "").replace("(", "").replace(")", ""));
                                String unionid = jsonObject.optString("unionid");
                                String openid = jsonObject.optString("openid");
                                if (UmengQQHandler.this.qqPreferences != null) {
                                    UmengQQHandler.this.qqPreferences.setmOpenid(openid);
                                    UmengQQHandler.this.qqPreferences.setUnionid(unionid);
                                    UmengQQHandler.this.qqPreferences.commit();
                                }
                                if (!TextUtils.isEmpty((CharSequence)(errormessage = jsonObject.optString("error_description")))) {
                                    SLog.E((String)(UmengText.QQ.ERRORINFO + errormessage));
                                }
                            }
                            catch (JSONException e) {
                                SLog.error((Throwable)e);
                            }
                        }
                        UmengQQHandler.this.initOpenidAndToken((JSONObject)response);
                        final Map map = SocializeUtils.bundleTomap((Bundle)values);
                        map.put("unionid", UmengQQHandler.this.getUnionid());
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UmengQQHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 0, map);
                            }
                        });
                        if (UmengQQHandler.this.config != null) {
                            map.put("aid", UmengQQHandler.this.config.appId);
                            map.put("as", UmengQQHandler.this.config.appkey);
                        }
                    }
                }, (boolean)true);
            }
        };
    }

    private void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception e) {
            SLog.error((String)UmengText.QQ.OPENIDANDTOKEN, (Throwable)e);
        }
    }

    public void setAuthListener(UMAuthListener listener) {
        this.mAuthListener = listener;
    }

    public boolean isHasAuthListener() {
        return this.mAuthListener != null;
    }

    public void authorize(final UMAuthListener listener) {
        this.mAuthListener = listener;
        if (this.mTencent == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQQHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + UmengText.tencentEmpty((boolean)Config.isUmengQQ)));
                }
            });
        }
        this.loginDeal();
    }

    public boolean isInstall() {
        return this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    private void loginDeal() {
        if (this.isInstall()) {
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                this.mTencent.login((Activity)this.mWeakAct.get(), "all", this.getQQAuthlistener(this.mAuthListener));
            }
        } else {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"https://log.umsns.com/link/qq/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQQHandler.this.getAuthListener(UmengQQHandler.this.mAuthListener).onError(SHARE_MEDIA.QQ, 0, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
        }
    }

    private void fetchUserInfo(final UMAuthListener listener) {
        QueuedWork.runInBack((Runnable)new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = null;
                try {
                    jsonObject = UmengQQHandler.this.request();
                    final HashMap<String, String> infos = new HashMap<String, String>();
                    infos.put("screen_name", jsonObject.optString("nickname"));
                    infos.put("name", jsonObject.optString("nickname"));
                    infos.put("gender", UmengQQHandler.this.getGender(jsonObject.optString("gender")));
                    infos.put("profile_image_url", jsonObject.optString("figureurl_qq_2"));
                    infos.put("iconurl", jsonObject.optString("figureurl_qq_2"));
                    infos.put("is_yellow_year_vip", jsonObject.optString("is_yellow_year_vip"));
                    infos.put("yellow_vip_level", jsonObject.optString("yellow_vip_level"));
                    infos.put("msg", jsonObject.optString("msg"));
                    infos.put("city", jsonObject.optString("city"));
                    infos.put("vip", jsonObject.optString("vip"));
                    infos.put("level", jsonObject.optString("level"));
                    infos.put("ret", jsonObject.optString("ret"));
                    infos.put("province", jsonObject.optString("province"));
                    infos.put("is_yellow_vip", jsonObject.optString("is_yellow_vip"));
                    infos.put("openid", UmengQQHandler.this.getuid());
                    infos.put("uid", UmengQQHandler.this.getuid());
                    infos.put("access_token", UmengQQHandler.this.getmAccessToken());
                    infos.put("expires_in", UmengQQHandler.this.getMtl() + "");
                    infos.put("accessToken", UmengQQHandler.this.getmAccessToken());
                    infos.put("expiration", UmengQQHandler.this.getMtl() + "");
                    infos.put("unionid", UmengQQHandler.this.getUnionid());
                    final String ret = (String)infos.get("ret");
                    if (!TextUtils.isEmpty((CharSequence)ret) && ret.equals("0")) {
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UmengQQHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 2, infos);
                            }
                        });
                    } else {
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!TextUtils.isEmpty((CharSequence)ret) && ret.equals("100030")) {
                                    UmengQQHandler.this.qqPreferencesDelete();
                                    UmengQQHandler.this.authAndFetchUserInfo(listener);
                                } else {
                                    UmengQQHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + (String)infos.get("msg")));
                                }
                            }
                        });
                    }
                }
                catch (JSONException e) {
                    QueuedWork.runInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UmengQQHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + e.getMessage()));
                        }
                    });
                    SLog.error((Throwable)e);
                }
            }
        }, (boolean)false);
    }

    public void getPlatformInfo(UMAuthListener listener) {
        if (this.qqPreferences.isAuthValid() && !this.getShareConfig().isNeedAuthOnGetUserInfo()) {
            this.fetchUserInfo(listener);
        } else {
            this.authAndFetchUserInfo(listener);
        }
    }

    private void authAndFetchUserInfo(final UMAuthListener listener) {
        this.authorize(new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                UmengQQHandler.this.fetchUserInfo(listener);
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                UmengQQHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, t);
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
                UmengQQHandler.this.getAuthListener(listener).onCancel(SHARE_MEDIA.QQ, 2);
            }
        });
    }

    public boolean isSupportAuth() {
        return true;
    }

    public void deleteAuth(final UMAuthListener listener) {
        this.mTencent.logout();
        this.qqPreferencesDelete();
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UmengQQHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 1, null);
            }
        });
    }

    public int getRequestCode() {
        return 10103;
    }

    private String getmAccessToken() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.getmAccessToken();
        }
        return "";
    }

    private String getUnionid() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.getUnionid();
        }
        return "";
    }

    private long getMtl() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.getMtl();
        }
        return 0L;
    }

    private String getuid() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.getuid();
        }
        return "";
    }

    private void qqPreferencesDelete() {
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
    }

    private JSONObject request() throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://openmobile.qq.com/user/get_simple_userinfo?status_os=" + Build.VERSION.RELEASE).append("&").append("access_token=" + this.getmAccessToken()).append("&oauth_consumer_key=" + this.config.appId).append("&format=json&openid=" + this.getuid()).append("&status_version=" + Build.VERSION.SDK).append("&status_machine=" + this.getDeviceName()).append("&pf=openmobile_android&sdkp=a&sdkv=3.1.0.lite");
        String result = this.request(stringBuilder.toString());
        return new JSONObject(result.replace("/n", ""));
    }

    private String getDeviceName() {
        try {
            return URLEncoder.encode(Build.MODEL.replace(" ", "+"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SLog.error((Throwable)e);
            return "sm801";
        }
    }

    private String request(String urlStr) {
        String emptyStr = "";
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            if (conn == null) {
                return emptyStr;
            }
            conn.connect();
            InputStream inputStream = conn.getInputStream();
            if (inputStream == null) {
                return emptyStr;
            }
            return this.convertStreamToString(inputStream);
        }
        catch (Exception e) {
            SLog.error((Throwable)e);
            return emptyStr;
        }
    }

    private String getUnionIdRequest(String urlStr) {
        String emptyStr = "";
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            if (conn == null) {
                return emptyStr;
            }
            conn.connect();
            InputStream inputStream = conn.getInputStream();
            if (inputStream == null) {
                return emptyStr;
            }
            return this.convertStreamToString(inputStream);
        }
        catch (Exception e) {
            SLog.error((Throwable)e);
            return emptyStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "/n");
            }
        }
        catch (IOException e) {
            SLog.error((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                SLog.error((Throwable)e);
            }
        }
        return sb.toString();
    }

    public void release() {
        if (this.mTencent != null) {
            this.mTencent.release();
        }
        this.mTencent = null;
        this.mAuthListener = null;
    }
}

