/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.social.tool;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;

class UMWaterMark {
    private static final String TAG = UMWaterMark.class.getSimpleName();
    private float mScale = 0.3f;
    private int mRightMargin;
    private int mLeftMargin;
    private int mTopMargin;
    private int mBottomMargin;
    private Rect mAnchorMarkRect = new Rect();
    private int mVerticalRelativePosition = -1;
    private int mHorizontalRelativePosition = -1;
    static final int RELATIVE_POSITION_VERTICAL_BOTTOM = 1;
    static final int RELATIVE_POSITION_VERTICAL_TOP = 2;
    static final int RELATIVE_POSITION_HORIZONTAL_RIGHT = 3;
    static final int RELATIVE_POSITION_HORIZONTAL_LEFT = 4;
    private int mGravity = 51;
    private boolean mIsTransparent = false;
    private boolean mIsBringToFront = false;
    private float mAlpha = -1.0f;
    private int mDegree = -1;
    private Context mContext;
    private Rect mMeasureRect = new Rect();

    UMWaterMark() {
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.mLeftMargin = left;
        this.mTopMargin = top;
        this.mRightMargin = right;
        this.mBottomMargin = bottom;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setGravity(int gravity) {
        if (gravity <= 0) {
            return;
        }
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
        }
    }

    public void setScale(float scale) {
        if (scale < 0.0f || scale > 1.0f) {
            return;
        }
        this.mScale = scale;
    }

    public void setRotate(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this.mDegree = degree;
    }

    public void bringToFront() {
        this.mIsBringToFront = true;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            return;
        }
        this.mAlpha = alpha;
    }

    public void setTransparent() {
        this.mIsTransparent = true;
    }

    public Bitmap compound(Bitmap src) {
        try {
            Canvas canvas;
            Bitmap bitmap;
            if (src == null) {
                Log.e((String)TAG, (String)"scr bitmap is null");
                return null;
            }
            Bitmap markBitmap = this.getMarkBitmap();
            if (markBitmap == null) {
                Log.e((String)TAG, (String)"mark bitmap is null");
                return src;
            }
            int srcWidth = src.getWidth();
            int srcHeight = src.getHeight();
            if (srcWidth <= 0 || srcHeight <= 0) {
                Log.e((String)TAG, (String)("mark bitmap is error, markWidth:" + srcWidth + ", markHeight:" + srcHeight));
                return src;
            }
            int markWidth = this.getMarkWidth();
            int markHeight = this.getMarkHeight();
            if (markWidth <= 0 || markHeight <= 0) {
                Log.e((String)TAG, (String)("mark bitmap is error, markWidth:" + markWidth + ", markHeight:" + markHeight));
                return src;
            }
            if (this.mIsTransparent) {
                bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                canvas = new Canvas(bitmap);
                canvas.drawColor(0);
            } else {
                bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                canvas = new Canvas(bitmap);
            }
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            Matrix matrix = new Matrix();
            int srcMinLength = Math.min(src.getWidth(), src.getHeight());
            int markMaxLength = Math.max(markWidth, markHeight);
            float scaleFactor = this.mScale * (float)srcMinLength / (float)markMaxLength;
            matrix.postScale(scaleFactor, scaleFactor, this.getScaleAnchorX(markWidth), this.getScaleAnchorY(markHeight));
            if (this.mDegree != -1) {
                matrix.postRotate((float)this.mDegree, (float)(markWidth / 2), (float)(markHeight / 2));
            }
            float dx = this.isHorizontalRelativePosition() ? this.getRelativeDx(srcWidth) : this.getDx(srcWidth);
            float dy = this.isVerticalRelativePosition() ? this.getRelativeDy(srcHeight) : this.getDy(srcHeight);
            matrix.postTranslate(dx, dy);
            if (this.mAlpha != -1.0f) {
                Paint paint = new Paint();
                paint.setAlpha((int)(255.0f * this.mAlpha));
                canvas.drawBitmap(markBitmap, matrix, paint);
            } else {
                canvas.drawBitmap(markBitmap, matrix, null);
            }
            canvas.save(31);
            canvas.restore();
            this.safelyRecycleBitmap(src);
            this.safelyRecycleBitmap(markBitmap);
            this.releaseResource();
            return bitmap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private float getScaleAnchorY(int height) {
        float y;
        int gravity = this.mGravity & 0x70;
        switch (gravity) {
            case 80: {
                y = height;
                break;
            }
            case 16: {
                y = height / 2;
                break;
            }
            default: {
                y = 0.0f;
            }
        }
        return y;
    }

    private float getScaleAnchorX(int width) {
        float x;
        int gravity = this.mGravity & 7;
        switch (gravity) {
            case 1: {
                x = width / 2;
                break;
            }
            case 5: {
                x = width;
                break;
            }
            default: {
                x = 0.0f;
            }
        }
        return x;
    }

    private void safelyRecycleBitmap(Bitmap bitmap) {
        try {
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Bitmap getMarkBitmap() {
        return null;
    }

    private float getRelativeDy(int srcHeight) {
        float dy;
        float anchorMarkTop = this.mAnchorMarkRect.top;
        float anchorMarkBottom = this.mAnchorMarkRect.bottom;
        switch (this.mVerticalRelativePosition) {
            case 1: {
                int topMargin = this.dip2px(this.mTopMargin);
                dy = anchorMarkBottom + (float)topMargin;
                break;
            }
            case 2: {
                int bottomMargin = -this.dip2px(this.mBottomMargin);
                dy = anchorMarkTop - (float)this.getMarkHeight() + (float)bottomMargin;
                break;
            }
            default: {
                dy = this.getDy(srcHeight);
            }
        }
        return dy;
    }

    private float getRelativeDx(int srcWidth) {
        float dx;
        float anchorMarkLeft = this.mAnchorMarkRect.left;
        float anchorMarkRight = this.mAnchorMarkRect.right;
        switch (this.mHorizontalRelativePosition) {
            case 4: {
                int rightMargin = -this.dip2px(this.mRightMargin);
                dx = anchorMarkLeft - (float)this.getMarkWidth() + (float)rightMargin;
                break;
            }
            case 3: {
                int leftMargin = this.dip2px(this.mLeftMargin);
                dx = anchorMarkRight + (float)leftMargin;
                break;
            }
            default: {
                dx = this.getDx(srcWidth);
            }
        }
        return dx;
    }

    private float getDy(int srcHeight) {
        float dy;
        int bottomMargin = -this.dip2px(this.mBottomMargin);
        int topMargin = this.dip2px(this.mTopMargin);
        int gravity = this.mGravity & 0x70;
        switch (gravity) {
            case 80: {
                dy = srcHeight - this.getMarkHeight() + bottomMargin;
                break;
            }
            case 16: {
                int offset = topMargin != 0 ? topMargin : bottomMargin;
                dy = (float)(srcHeight - this.getMarkHeight()) * 1.0f / 2.0f + (float)offset;
                break;
            }
            default: {
                dy = topMargin;
            }
        }
        return dy;
    }

    private float getDx(int srcWidth) {
        float dy;
        int leftMargin = this.dip2px(this.mLeftMargin);
        int rightMargin = -this.dip2px(this.mRightMargin);
        int gravity = this.mGravity & 7;
        switch (gravity) {
            case 1: {
                int offset = leftMargin != 0 ? leftMargin : rightMargin;
                dy = (float)(srcWidth - this.getMarkWidth()) * 1.0f / 2.0f + (float)offset;
                break;
            }
            case 5: {
                dy = srcWidth - this.getMarkWidth() + rightMargin;
                break;
            }
            default: {
                dy = leftMargin;
            }
        }
        return dy;
    }

    private int getMarkWidth() {
        if (this.getMarkBitmap() == null) {
            return -1;
        }
        return this.getMarkBitmap().getWidth();
    }

    private int getMarkHeight() {
        if (this.getMarkBitmap() == null) {
            return -1;
        }
        return this.getMarkBitmap().getHeight();
    }

    void setAnchorMarkHorizontalRect(Rect rect) {
        int top = this.mAnchorMarkRect.top;
        int bottom = this.mAnchorMarkRect.bottom;
        this.mAnchorMarkRect.set(rect.left, top, rect.right, bottom);
    }

    void setAnchorMarkVerticalRect(Rect rect) {
        this.mAnchorMarkRect = rect;
        int left = this.mAnchorMarkRect.left;
        int right = this.mAnchorMarkRect.right;
        this.mAnchorMarkRect.set(left, rect.top, right, rect.bottom);
    }

    Rect onMeasure(int srcWidth, int srcHeight) {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (!this.isHorizontalRelativePosition()) {
            left = (int)this.getDx(srcWidth);
            right = left + this.getMarkWidth();
        }
        if (!this.isVerticalRelativePosition()) {
            top = (int)this.getDy(srcHeight);
            bottom = top + this.getMarkHeight();
        }
        this.mMeasureRect.set(left, top, right, bottom);
        return this.mMeasureRect;
    }

    void setHorizontalRelativePosition(int position) {
        this.mHorizontalRelativePosition = position;
    }

    void setVerticalRelativePosition(int position) {
        this.mVerticalRelativePosition = position;
    }

    void clearRelativePosition() {
        this.mHorizontalRelativePosition = -1;
        this.mVerticalRelativePosition = -1;
    }

    boolean isVerticalRelativePosition() {
        return this.mVerticalRelativePosition != -1;
    }

    boolean isHorizontalRelativePosition() {
        return this.mHorizontalRelativePosition != -1;
    }

    boolean isBringToFront() {
        return this.mIsBringToFront;
    }

    int dip2px(float dpValue) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    void releaseResource() {
    }
}

