/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.sina.weibo.sdk.api.BaseMediaObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ImageObject
extends BaseMediaObject {
    private static final int DATA_SIZE = 0x200000;
    public byte[] imageData;
    public String imagePath;
    public static final Parcelable.Creator<ImageObject> CREATOR = new Parcelable.Creator(){

        public ImageObject createFromParcel(Parcel parcel) {
            return new ImageObject(parcel);
        }

        public ImageObject[] newArray(int n) {
            return new ImageObject[n];
        }
    };

    public ImageObject() {
    }

    public ImageObject(Parcel parcel) {
        this.imageData = parcel.createByteArray();
        this.imagePath = parcel.readString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setImageObject(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.imageData);
        parcel.writeString(this.imagePath);
    }

    @Override
    public boolean checkArgs() {
        if (this.imageData == null && this.imagePath == null) {
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0x200000) {
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 512) {
            return false;
        }
        if (this.imagePath != null) {
            File file = new File(this.imagePath);
            try {
                if (!file.exists() || file.length() == 0L || file.length() > 0xA00000L) {
                    return false;
                }
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getObjType() {
        return 2;
    }

    @Override
    protected BaseMediaObject toExtraMediaObject(String string) {
        return this;
    }

    @Override
    protected String toExtraMediaString() {
        return "";
    }
}

