/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.sina;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.share.WbShareCallback;
import com.sina.weibo.sdk.share.WbShareTransActivity;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.media.AppInfo;
import com.umeng.socialize.media.IWeiboHandler;
import com.umeng.socialize.sina.auth.AuthInfo;
import com.umeng.socialize.sina.helper.MD5;
import com.umeng.socialize.sina.message.BaseRequest;
import com.umeng.socialize.sina.message.SendMessageToWeiboRequest;
import com.umeng.socialize.sina.message.SendMessageToWeiboResponse;
import com.umeng.socialize.sina.message.SendMultiMessageToWeiboRequest;
import com.umeng.socialize.sina.params.ShareRequestParam;
import com.umeng.socialize.sina.util.Utility;
import com.umeng.socialize.sina.webview.ShareDialog;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;

public class SinaAPI {
    private Context mContext;
    private String mAppKey;
    private String pkgName;

    public SinaAPI(Context context, String string, boolean bl) {
        this.mContext = context;
        this.mAppKey = string;
    }

    public boolean registerApp() {
        this.sendBroadcast(this.mContext, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_REGISTER", this.mAppKey, null, null);
        return true;
    }

    private void sendBroadcast(Context context, String string, String string2, String string3, Bundle bundle) {
        Intent intent = new Intent(string);
        String string4 = context.getPackageName();
        intent.putExtra("_weibo_sdkVersion", "0031205000");
        intent.putExtra("_weibo_appPackage", string4);
        intent.putExtra("_weibo_appKey", string2);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign(context, string4)));
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            intent.setPackage(string3);
        }
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.sendBroadcast(intent, "com.sina.weibo.permission.WEIBO_SDK_PERMISSION");
    }

    public void startClientShare(AppInfo appInfo, Context context, WeiboMultiMessage weiboMultiMessage) {
        Bundle bundle = new Bundle();
        bundle.putInt("_weibo_command_type", 1);
        bundle.putString("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
        bundle.putLong("callbackId", 0L);
        bundle.putAll(weiboMultiMessage.toBundle(bundle));
        Intent intent = new Intent();
        intent.setClass(context, WbShareTransActivity.class);
        intent.putExtra("startPackage", appInfo.a());
        intent.putExtra("startAction", "com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY");
        intent.putExtra("startFlag", 0);
        intent.putExtra("startActivity", context.getClass().getName());
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            SLog.error((String)UmengText.SINA.SINASTARTERROR, (Throwable)exception);
        }
    }

    public void setPkgName(String string) {
        this.pkgName = string;
    }

    public boolean launchWeiboActivity(Activity activity, String string, String string2, String string3, Bundle bundle) {
        if (!(activity == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3))) {
            Intent intent = new Intent();
            intent.setPackage(string2);
            intent.setAction(string);
            String string4 = activity.getPackageName();
            intent.putExtra("_weibo_sdkVersion", "0031205000");
            intent.putExtra("_weibo_appPackage", string4);
            intent.putExtra("_weibo_appKey", string3);
            intent.putExtra("_weibo_flag", 538116905);
            intent.putExtra("_weibo_sign", MD5.hexdigest(Utility.getSign((Context)activity, string4)));
            intent.putExtra("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
            if (bundle != null) {
                intent.putExtras(bundle);
            }
            try {
                activity.startActivityForResult(intent, 765);
                return true;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public boolean sendRequest(Activity activity, BaseRequest baseRequest, AuthInfo authInfo, String string, UMShareListener uMShareListener, boolean bl) {
        if (baseRequest == null) {
            return false;
        }
        if (bl) {
            SendMultiMessageToWeiboRequest sendMultiMessageToWeiboRequest = (SendMultiMessageToWeiboRequest)baseRequest;
            SendMessageToWeiboRequest sendMessageToWeiboRequest = new SendMessageToWeiboRequest();
            sendMessageToWeiboRequest.packageName = sendMultiMessageToWeiboRequest.packageName;
            sendMessageToWeiboRequest.transaction = sendMultiMessageToWeiboRequest.transaction;
            sendMessageToWeiboRequest.message = this.adapterMultiMessage2SingleMessage(sendMultiMessageToWeiboRequest.multiMessage);
            Bundle bundle = new Bundle();
            sendMessageToWeiboRequest.toBundle(bundle);
            return this.launchWeiboActivity(activity, "com.sina.weibo.sdk.action.ACTION_WEIBO_ACTIVITY", this.pkgName, this.mAppKey, bundle);
        }
        return this.startShareWeiboActivity(activity, string, baseRequest, uMShareListener);
    }

    public boolean startShareWeiboActivity(final Activity activity, String string, BaseRequest baseRequest, final UMShareListener uMShareListener) {
        try {
            String string2 = activity.getPackageName();
            ShareRequestParam shareRequestParam = new ShareRequestParam((Context)activity);
            shareRequestParam.setToken(string);
            shareRequestParam.setAppKey(this.mAppKey);
            shareRequestParam.setAppPackage(string2);
            shareRequestParam.setBaseRequest(baseRequest);
            shareRequestParam.setSpecifyTitle("\u5fae\u535a\u5206\u4eab");
            Bundle bundle = new Bundle();
            bundle = shareRequestParam.createRequestParamBundle();
            final ShareRequestParam shareRequestParam2 = new ShareRequestParam((Context)activity);
            shareRequestParam2.setupRequestParam(bundle);
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing()) {
                        ShareDialog shareDialog = new ShareDialog(activity, SHARE_MEDIA.SINA, uMShareListener, shareRequestParam2);
                        shareDialog.show();
                    }
                }
            });
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    private Bundle adapterMultiMessage2SingleMessage(WeiboMultiMessage weiboMultiMessage) {
        if (weiboMultiMessage == null) {
            return new Bundle();
        }
        Bundle bundle = new Bundle();
        weiboMultiMessage.toBundle(bundle);
        return bundle;
    }

    public boolean handleWeiboResponse(Intent intent, IWeiboHandler.Response response) {
        String string = intent.getStringExtra("_weibo_appPackage");
        String string2 = intent.getStringExtra("_weibo_transaction");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (!(response instanceof Activity)) {
            return false;
        }
        Activity activity = (Activity)response;
        String string3 = activity.getCallingPackage();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        SendMessageToWeiboResponse sendMessageToWeiboResponse = new SendMessageToWeiboResponse(intent.getExtras());
        response.a(sendMessageToWeiboResponse);
        return true;
    }

    public void doResultIntent(Intent intent, WbShareCallback wbShareCallback) {
        Bundle bundle;
        if (wbShareCallback != null && (bundle = intent.getExtras()) != null) {
            int n = bundle.getInt("_weibo_resp_errcode");
            switch (n) {
                case 0: {
                    wbShareCallback.onWbShareSuccess();
                    break;
                }
                case 1: {
                    wbShareCallback.onWbShareCancel();
                    break;
                }
                case 2: {
                    wbShareCallback.onWbShareFail();
                    break;
                }
            }
        }
    }
}

