# Summary

* [I. Spring Boot文档](I. Spring Boot Documentation/README.md)
    * [1. 关于本文档](I. Spring Boot Documentation/1. About the documentation.md)
    * [2. 获取帮助](I. Spring Boot Documentation/2. Getting help.md)
    * [3. 第一步](I. Spring Boot Documentation/3. First steps.md)
    * [4. 使用Spring Boot](I. Spring Boot Documentation/4. Working with Spring Boot.md)
    * [5. 了解Spring Boot特性](I. Spring Boot Documentation/5. Learning about Spring Boot features.md)
    * [6. 迁移到生存环境](I. Spring Boot Documentation/6. Moving to production.md)
    * [7. 高级主题](I. Spring Boot Documentation/7. Advanced topics.md)
* [II. 开始](II. Getting started/README.md)
    * [8. Spring Boot介绍](II. Getting started/8. Introducing Spring Boot.md)
    * [9. 系统要求](II. Getting started/9. System Requirements.md)
      * [9.1. Servlet容器](II. Getting started/9.1. Servlet containers.md)
    * [10. Spring Boot安装](II. Getting started/10. Installing Spring Boot.md)
      * [10.1. 为Java开发者准备的安装指南](II. Getting started/10.1. Installation instructions for the Java developer.md)
         * [10.1.1. Maven安装](II. Getting started/10.1.1. Maven installation.md)
         * [10.1.2. Gradle安装](II. Getting started/10.1.2. Gradle installation.md)
      * [10.2. Spring Boot CLI安装](II. Getting started/10.2. Installing the Spring Boot CLI.md)
         * [10.2.1. 手动安装](II. Getting started/10.2.1. Manual installation.md)
         * [10.2.2. 使用GVM安装](II. Getting started/10.2.2. Installation with GVM.md)
         * [10.2.3. 使用OSX Homebrew进行安装](II. Getting started/10.2.3. OSX Homebrew installation.md)
         * [10.2.4. 使用MacPorts进行安装](II. Getting started/10.2.4. MacPorts installation.md)
         * [10.2.5. 命令行实现](II. Getting started/10.2.5. Command-line completion.md)
         * [10.2.6. Spring CLI示例快速入门](II. Getting started/10.2.6. Quick start Spring CLI example.md)
      * [10.3. 从Spring Boot早期版本升级](II. Getting started/10.3. Upgrading from an earlier version of Spring Boot.md)
   * [11. 开发你的第一个Spring Boot应用](II. Getting started/11. Developing your first Spring Boot application.md)
      * [11.1. 创建POM](II. Getting started/11.1. Creating the POM.md)
      * [11.2. 添加classpath依赖](II. Getting started/11.2. Adding classpath dependencies.md)
      * [11.3. 编写代码](II. Getting started/11.3. Writing the code.md)
         * [11.3.1. @RestController和@RequestMapping注解](II. Getting started/11.3.1. The @RestController and @RequestMapping annotations.md)
         * [11.3.2. @EnableAutoConfiguration注解](II. Getting started/11.3.2. The @EnableAutoConfiguration annotation.md)
         * [11.3.3. main方法](II. Getting started/11.3.3. The “main” method.md)
      * [11.4. 运行示例](II. Getting started/11.4. Running the example.md)
      * [11.5. 创建一个可执行jar](II. Getting started/11.5. Creating an executable jar.md)
   * [12. 接下来阅读什么](II. Getting started/12. What to read next.md)
* [III. 使用Spring Boot](III. Using Spring Boot/README.md)
   * [13. 构建系统](III. Using Spring Boot/13. Build systems.md)
      * [13.1. Maven](III. Using Spring Boot/13.1. Maven.md)
         * [13.1.1. 继承starter parent](III. Using Spring Boot/13.1.1. Inheriting the starter parent.md)
         * [13.1.2. 使用没有父POM的Spring Boot](III. Using Spring Boot/13.1.2. Using Spring Boot without the parent POM.md)
         * [13.1.3. 改变Java版本](III. Using Spring Boot/13.1.3. Changing the Java version.md)
         * [13.1.4. 使用Spring Boot Maven插件](III. Using Spring Boot/13.1.4. Using the Spring Boot Maven plugin.md)
      * [13.2. Gradle](III. Using Spring Boot/13.2. Gradle.md)
      * [13.3. Ant](III. Using Spring Boot/13.3. Ant.md)
      * [13.4. Starter POMs](III. Using Spring Boot/13.4. Starter POMs.md)
   * [14. 组织你的代码](III. Using Spring Boot/14. Structuring your code.md)
      * [14.1. 使用"default"包](III. Using Spring Boot/14.1. Using the “default” package.md)
      * [14.2. 定位main应用类](III. Using Spring Boot/14.2. Locating the main application class.md)
   * [15. 配置类](III. Using Spring Boot/15. Configuration classes.md)
      * [15.1. 导入其他配置类](III. Using Spring Boot/15.1. Importing additional configuration classes.md)
      * [15.2. 导入XML配置](III. Using Spring Boot/15.2. Importing XML configuration.md)
   * [16. 自动配置](III. Using Spring Boot/16. Auto-configuration.md)
      * [16.1. 逐步替换自动配置](III. Using Spring Boot/16.1. Gradually replacing auto-configuration.md)
      * [16.2. 禁用特定的自动配置](III. Using Spring Boot/16.2. Disabling specific auto-configuration.md)
   * [17. Spring Beans和依赖注入](III. Using Spring Boot/17. Spring Beans and dependency injection.md)
   * [18. 使用@SpringBootApplication注解](III. Using Spring Boot/18. Using the @SpringBootApplication annotation.md)
   * [19. 运行应用程序](III. Using Spring Boot/19. Running your application.md)
      * [19.1. 从IDE中运行](III. Using Spring Boot/19.1. Running from an IDE.md)
      * [19.2. 作为一个打包后的应用运行](III. Using Spring Boot/19.2. Running as a packaged application.md)
      * [19.3. 使用Maven插件运行](III. Using Spring Boot/19.3. Using the Maven plugin.md)
      * [19.4. 使用Gradle插件运行](III. Using Spring Boot/19.4. Using the Gradle plugin.md)
      * [19.5. 热交换](III. Using Spring Boot/19.5. Hot swapping.md)
   * [20. 打包用于生产的应用程序](III. Using Spring Boot/20. Packaging your application for production.md)
   * [21. 接下来阅读什么](III. Using Spring Boot/21. What to read next.md)
* [IV. Spring Boot特性](IV. Spring Boot features/README.md)
   * [22. SpringApplication](IV. Spring Boot features/22. SpringApplication.md)
      * [22.1. 自定义Banner](IV. Spring Boot features/22.1. Customizing the Banner.md)
      * [22.2. 自定义SpringApplication](IV. Spring Boot features/22.2. Customizing SpringApplication.md)
      * [22.3. 流畅的构建API](IV. Spring Boot features/22.3. Fluent builder API.md)
      * [22.4. Application事件和监听器](IV. Spring Boot features/22.4. Application events and listeners.md)
      * [22.5. Web环境](IV. Spring Boot features/22.5. Web environment.md)
      * [22.6. 命令行启动器](IV. Spring Boot features/22.6. Using the CommandLineRunner.md)
      * [22.7. Application退出](IV. Spring Boot features/22.7. Application exit.md)
   * [23.外化配置](IV. Spring Boot features/23. Externalized Configuration.md)
      * [23.1. 配置随机值](IV. Spring Boot features/23.1. Configuring random values.md)
      * [23.2. 访问命令行属性](IV. Spring Boot features/23.2. Accessing command line properties.md)
      * [23.3. Application属性文件](IV. Spring Boot features/23.3. Application property files.md)
      * [23.4. 特定的Profile属性](IV. Spring Boot features/23.4. Profile-specific properties.md)
      * [23.5. 属性占位符](IV. Spring Boot features/23.5. Placeholders in properties.md)
      * [23.6. 使用YAML代替Properties](IV. Spring Boot features/23.6. Using YAML instead of Properties.md)
         * [23.6.1. 加载YAML](IV. Spring Boot features/23.6.1. Loading YAML.md)
         * [23.6.2. 在Spring环境中使用YAML暴露属性](IV. Spring Boot features/23.6.2. Exposing YAML as properties in the Spring Environment.md)
         * [23.6.3. Multi-profile YAML文档](IV. Spring Boot features/23.6.3. Multi-profile YAML documents.md)
         * [23.6.4. YAML缺点](IV. Spring Boot features/23.6.4. YAML shortcomings.md)
      * [23.7. 类型安全的配置属性](IV. Spring Boot features/23.7. Typesafe Configuration Properties.md)
         * [23.7.1. 第三方配置](IV. Spring Boot features/23.7.1. Third-party configuration.md)
         * [23.7.2. 松散的绑定（Relaxed binding）](IV. Spring Boot features/23.7.2. Relaxed binding.md)
         * [23.7.3. @ConfigurationProperties校验](IV. Spring Boot features/23.7.3. @ConfigurationProperties Validation.md)
   * [24. Profiles](IV. Spring Boot features/24. Profiles.md)
      * [24.1. 添加激活的配置(profiles)](IV. Spring Boot features/24.1. Adding active profiles.md)
      * [24.2.以编程方式设置profiles](IV. Spring Boot features/24.2. Programmatically setting profiles.md)
      * [24.3. Profile特定配置文件](IV. Spring Boot features/24.3. Profile specific configuration files.md)
   * [25. 日志](IV. Spring Boot features/25. Logging.md)
      * [25.1. 日志格式](IV. Spring Boot features/25.1. Log format.md)
      * [25.2. 控制台输出](IV. Spring Boot features/25.2. Console output.md)
      * [25.3. 文件输出](IV. Spring Boot features/25.3. File output.md)
      * [25.4. 日志级别](IV. Spring Boot features/25.4. Log Levels.md)
      * [25.5. 自定义日志配置](IV. Spring Boot features/25.5. Custom log configuration.md)
   * [26. 开发Web应用](IV. Spring Boot features/26. Developing web applications.md)
      * [26.1. Spring Web MVC框架](IV. Spring Boot features/26.1. The ‘Spring Web MVC framework’.md)
         * [26.1.1. Spring MVC自动配置](IV. Spring Boot features/26.1.1. Spring MVC auto-configuration.md)
         * [26.1.2. HttpMessageConverters](IV. Spring Boot features/26.1.2. HttpMessageConverters.md)
         * [26.1.3. MessageCodesResolver](IV. Spring Boot features/26.1.3. MessageCodesResolver.md)
         * [26.1.4. 静态内容](IV. Spring Boot features/26.1.4. Static Content.md)
         * [26.1.5. 模板引擎](IV. Spring Boot features/26.1.5. Template engines.md)
         * [26.1.6. 错误处理](IV. Spring Boot features/26.1.6. Error Handling.md)
         * [26.1.7. Spring HATEOAS](IV. Spring Boot features/26.1.7. Spring HATEOAS.md)
      * [26.2. JAX-RS和Jersey](IV. Spring Boot features/26.2. JAX-RS and Jersey.md)
      * [26.3. 内嵌servlet容器支持](IV. Spring Boot features/26.3. Embedded servlet container support.md)
         * [26.3.1. Servlets和Filters](IV. Spring Boot features/26.3.1. Servlets and Filters.md)
         * [26.3.2. EmbeddedWebApplicationContext](IV. Spring Boot features/26.3.2. The EmbeddedWebApplicationContext.md)
         * [26.3.3. 自定义内嵌servlet容器](IV. Spring Boot features/26.3.3. Customizing embedded servlet containers.md)
         * [26.3.4. JSP的限制](IV. Spring Boot features/26.3.4. JSP limitations.md)
   * [27. 安全](IV. Spring Boot features/27. Security.md)
   * [28. 使用SQL数据库](IV. Spring Boot features/28. Working with SQL databases.md)
      * [28.1. 配置DataSource](IV. Spring Boot features/28.1. Configure a DataSource.md)
         * [28.1.1. 对内嵌数据库的支持](IV. Spring Boot features/28.1.1. Embedded Database Support.md)
         * [28.1.2. 连接到一个生产环境数据库](IV. Spring Boot features/28.1.2. Connection to a production database.md)
         * [28.1.3. 连接到一个JNDI数据库](IV. Spring Boot features/28.1.3. Connection to a JNDI DataSource.md)
      * [28.2. 使用JdbcTemplate](IV. Spring Boot features/28.2. Using JdbcTemplate.md)
      * [28.3. JPA和Spring Data](IV. Spring Boot features/28.3. JPA and ‘Spring Data’.md)
         * [28.3.1. 实体类](IV. Spring Boot features/28.3.1. Entity Classes.md)
         * [28.3.2. Spring Data JPA仓库](IV. Spring Boot features/28.3.2. Spring Data JPA Repositories.md)
         * [28.3.3. 创建和删除JPA数据库](IV. Spring Boot features/28.3.3. Creating and dropping JPA databases.md)
   * [29. 使用NoSQL技术](IV. Spring Boot features/29. Working with NoSQL technologies.md)
      * [29.1. Redis](IV. Spring Boot features/29.1. Redis.md)
         * [29.1.1. 连接Redis](IV. Spring Boot features/29.1.1. Connecting to Redis.md)
      * [29.2. MongoDB](IV. Spring Boot features/29.2. MongoDB.md)
         * [29.2.1. 连接MongoDB数据库](IV. Spring Boot features/29.2.1. Connecting to a MongoDB database.md)
         * [29.2.2. MongoDBTemplate](IV. Spring Boot features/29.2.2. MongoTemplate.md)
         * [29.2.3. Spring Data MongoDB仓库](IV. Spring Boot features/29.2.3. Spring Data MongoDB repositories.md)
      * [29.3. Gemfire](IV. Spring Boot features/29.3. Gemfire.md)
      * [29.4. Solr](IV. Spring Boot features/29.4. Solr.md)
         * [29.4.1. 连接Solr](IV. Spring Boot features/29.4.1. Connecting to Solr.md)
         * [29.4.2. Spring Data Solr仓库](IV. Spring Boot features/29.4.2. Spring Data Solr repositories.md)
      * [29.5. Elasticsearch](IV. Spring Boot features/29.5. Elasticsearch.md)
         * [29.5.1. 连接Elasticsearch](IV. Spring Boot features/29.5.1. Connecting to Elasticsearch.md)
         * [29.5.2. Spring Data Elasticseach仓库](IV. Spring Boot features/29.5.2. Spring Data Elasticsearch repositories.md)
   * [30. 消息](IV. Spring Boot features/30. Messaging.md)
      * [30.1. JMS](IV. Spring Boot features/30.1. JMS.md)
         * [30.1.1. HornetQ支持](IV. Spring Boot features/30.1.1. HornetQ support.md)
         * [30.1.2. ActiveQ支持](IV. Spring Boot features/30.1.2. ActiveMQ support.md)
         * [30.1.3. 使用JNDI ConnectionFactory](IV. Spring Boot features/30.1.3. Using a JNDI ConnectionFactory.md)
         * [30.1.4. 发送消息](IV. Spring Boot features/30.1.4. Sending a message.md)
         * [30.1.5. 接收消息](IV. Spring Boot features/30.1.5. Receiving a message.md)
   * [31. 发送邮件](IV. Spring Boot features/31. Sending email.md)
   * [32. 使用JTA处理分布式事务](IV. Spring Boot features/32. Distributed Transactions with JTA.md)
      * [32.1. 使用一个Atomikos事务管理器](IV. Spring Boot features/32.1. Using an Atomikos transaction manager.md)
      * [32.2. 使用一个Bitronix事务管理器](IV. Spring Boot features/32.2. Using a Bitronix transaction manager.md)
      * [32.3. 使用一个J2EE管理的事务管理器](IV. Spring Boot features/32.3. Using a Java EE managed transaction manager.md)
      * [32.4. 混合XA和non-XA的JMS连接](IV. Spring Boot features/32.4. Mixing XA and non-XA JMS connections.md)
      * [32.5. 支持可替代的内嵌事务管理器](IV. Spring Boot features/32.5. Supporting an alternative embedded )
   * [33. Spring集成](IV. Spring Boot features/33. Spring Integration.md)
   * [34. 基于JMX的监控和管理](IV. Spring Boot features/34. Monitoring and management over JMX.md)
   * [35. 测试](IV. Spring Boot features/35. Testing.md)
      * [35.1. 测试作用域依赖](IV. Spring Boot features/35.1. Test scope dependencies.md)
      * [35.2. 测试Spring应用](IV. Spring Boot features/35.2. Testing Spring applications.md)
      * [35.3. 测试Spring Boot应用](IV. Spring Boot features/35.3. Testing Spring Boot applications.md)
         * [35.3.1. 使用Spock测试Spring Boot应用](IV. Spring Boot features/35.3.1. Using Spock to test Spring Boot applications.md)
      * [35.4. 测试工具](IV. Spring Boot features/35.4. Test utilities.md)
         * [35.4.1. ConfigFileApplicationContextInitializer](IV. Spring Boot features/35.4.1. ConfigFileApplicationContextInitializer.md)
         * [35.4.2. EnvironmentTestUtils](IV. Spring Boot features/35.4.2. EnvironmentTestUtils.md)
         * [35.4.3. OutputCapture](IV. Spring Boot features/35.4.3. OutputCapture.md)
         * [35.4.4. TestRestTemplate](IV. Spring Boot features/35.4.4. TestRestTemplate.md)
   * [36. 开发自动配置和使用条件](IV. Spring Boot features/36. Developing auto-configuration and using conditions.md)
      * [36.1. 理解auto-configured beans](IV. Spring Boot features/36.1. Understanding auto-configured beans.md)
      * [36.2. 定位auto-configuration候选者](IV. Spring Boot features/36.2. Locating auto-configuration candidates.md)
      * [36.3. Condition注解](IV. Spring Boot features/36.3. Condition annotations.md)
         * [36.3.1. Class条件](IV. Spring Boot features/36.3.1. Class conditions.md)
         * [36.3.2. Bean条件](IV. Spring Boot features/36.3.2. Bean conditions.md)
         * [36.3.3. Property条件](IV. Spring Boot features/36.3.3. Property conditions.md)
         * [36.3.4. Resource条件](IV. Spring Boot features/36.3.4. Resource conditions.md)
         * [36.3.5. Web Application条件](IV. Spring Boot features/36.3.5. Web Application Conditions.md)
         * [36.3.6. SpEL表达式条件](IV. Spring Boot features/36.3.6. SpEL expression conditions.md)
   * [37. WebSockets](IV. Spring Boot features/37. WebSockets.md)
   * [38. 接下来阅读什么](IV. Spring Boot features/38. What to read next.md)
* [V. Spring Boot执行器: Production-ready特性](V. Spring Boot Actuator/README.md)
   * [39. 开启production-ready特性](V. Spring Boot Actuator/39. Enabling production-ready features.md)
   * [40. 端点](V. Spring Boot Actuator/40. Endpoints.md)
      * [40.1. 自定义端点](V. Spring Boot Actuator/40.1. Customizing endpoints.md)
      * [40.2. 健康信息](V. Spring Boot Actuator/40.2. Health information.md)
      * [40.3. 安全与HealthIndicators](V. Spring Boot Actuator/40.3. Security with HealthIndicators.md)
         * [40.3.1. 自动配置的HealthIndicators](V. Spring Boot Actuator/40.3.1. Auto-configured-HealthIndicators.md)
         * [40.3.2. 编写自定义HealthIndicators](V. Spring Boot Actuator/40.3.2. Writing custom HealthIndicators.md)
      * [40.4. 自定义应用info信息](V. Spring Boot Actuator/40.4. Custom application info information.md)
         * [40.4.1. 在构建时期自动扩展info属性](V. Spring Boot Actuator/40.4.1. Automatically expand info properties at build time.md)
         * [40.4.2. Git提交信息](V. Spring Boot Actuator/40.4.2. Git commit information.md)
   * [41. 基于HTTP的监控和管理](V. Spring Boot Actuator/41. Monitoring and management over HTTP.md)
      * [41.1. 保护敏感端点](V. Spring Boot Actuator/41.1. Securing sensitive endpoints.md)
      * [41.2. 自定义管理服务器的上下文路径](V. Spring Boot Actuator/41.2. Customizing the management server context path.md)
      * [41.3. 自定义管理服务器的端口](V. Spring Boot Actuator/41.3. Customizing the management server port.md)
      * [41.4. 自定义管理服务器的地址](V. Spring Boot Actuator/41.4. Customizing the management server address.md)
      * [41.5. 禁用HTTP端点](V. Spring Boot Actuator/41.5. Disabling HTTP endpoints.md)
      * [41.6. HTTP Health端点访问限制](V. Spring Boot Actuator/41.6. HTTP Health endpoint access restrictions.md)
   * [42. 基于JMX的监控和管理](V. Spring Boot Actuator/42. Monitoring and management over JMX.md)
      * [42.1. 自定义MBean名称](V. Spring Boot Actuator/42.1. Customizing MBean names.md)
      * [42.2. 禁用JMX端点](V. Spring Boot Actuator/42.2. Disabling JMX endpoints.md)
      * [42.3. 使用Jolokia通过HTTP实现JMX远程管理](V. Spring Boot Actuator/42.3. Using Jolokia for JMX over HTTP.md)
         * [42.3.1. 自定义Jolokia](V. Spring Boot Actuator/42.3.1. Customizing Jolokia.md)
         * [42.3.2. 禁用Jolokia](V. Spring Boot Actuator/42.3.2. Disabling Jolokia.md)
      * [43. 使用远程shell来进行监控和管理](V. Spring Boot Actuator/43. Monitoring and management using a remote shell.md)
         * [43.1. 连接远程shell](V. Spring Boot Actuator/43.1. Connecting to the remote shell.md)
            * [43.1.1. 远程shell证书](V. Spring Boot Actuator/43.1.1. Remote shell credentials.md)
         * [43.2. 扩展远程shell](V. Spring Boot Actuator/43.2. Extending the remote shell.md)
            * [43.2.1. 远程shell命令](V. Spring Boot Actuator/43.2.1. Remote shell commands.md)
            * [43.2.2. 远程shell插件](V. Spring Boot Actuator/43.2.2. Remote shell plugins.md)
      * [44. 度量指标（Metrics）](V. Spring Boot Actuator/44. Metrics.md)
         * [44.1. 系统指标](V. Spring Boot Actuator/44.1. System metrics.md)
         * [44.2. 数据源指标](V. Spring Boot Actuator/44.2. DataSource metrics.md)
         * [44.3. Tomcat session指标](V. Spring Boot Actuator/44.3. Tomcat session metrics.md)
         * [44.4. 记录自己的指标](V. Spring Boot Actuator/44.4. Recording your own metrics.md)
         * [44.5. 添加你自己的公共指标](V. Spring Boot Actuator/44.5. Adding your own public metrics.md)
         * [44.6. 指标仓库](V. Spring Boot Actuator/44.6. Metric repositories.md)
         * [44.7. Dropwizard指标](V. Spring Boot Actuator/44.7. Dropwizard Metrics.md)
         * [44.8. 消息渠道集成](V. Spring Boot Actuator/44.8. Message channel integration.md)
      * [45. 审计](V. Spring Boot Actuator/45. Auditing.md)
      * [46. 追踪（Tracing）](V. Spring Boot Actuator/46. Tracing.md)
         * [46.1. 自定义追踪](V. Spring Boot Actuator/46.1. Custom tracing.md)
      * [47. 进程监控](V. Spring Boot Actuator/47. Process monitoring.md)
         * [47.1. 扩展属性](V. Spring Boot Actuator/47.1. Extend configuration.md)
         * [47.2. 以编程方式](V. Spring Boot Actuator/47.2. Programmatically.md)
      * [48. 接下来阅读什么](V. Spring Boot Actuator/48. What to read next.md`)
* [VI. 部署到云端](VI. Deploying to the cloud/README.md)
   * [49. Cloud Foundry](VI. Deploying to the cloud/49. Cloud Foundry.md)
      * [49.1. 绑定服务](VI. Deploying to the cloud/49.1. Binding to services.md)
   * [50. Heroku](VI. Deploying to the cloud/50. Heroku.md)
   * [51. Openshift](VI. Deploying to the cloud/51. Openshift.md)
   * [52. Google App Engine](VI. Deploying to the cloud/52. Google App Engine.md)
   * [53. 接下来阅读什么](VI. Deploying to the cloud/53. What to read next.md)
* [VII. Spring Boot CLI](VII. Spring Boot CLI/README.md)
   * [54. 安装CLI](VII. Spring Boot CLI/54. Installing the CLI.md)
   * [55. 使用CLI](VII. Spring Boot CLI/55. Using the CLI.md)
      * [55.1. 使用CLI运行应用](VII. Spring Boot CLI/55.1. Running applications using the CLI.md)
         * [55.1.1. 推断"grab"依赖](VII. Spring Boot CLI/55.1.1. Deduced “grab” dependencies.md)
         * [55.1.2. 推断"grab"坐标](VII. Spring Boot CLI/55.1.2. Deduced “grab” coordinates.md)
         * [55.1.3. 默认import语句](VII. Spring Boot CLI/55.1.3. Default import statements.md)
         * [55.1.4. 自动创建main方法](VII. Spring Boot CLI/55.1.4. Automatic main method.md)
         * [55.1.5. 自定义"grab"元数据](VII. Spring Boot CLI/55.1.5. Custom “grab” metadata.md)
      * [55.2. 测试你的代码](VII. Spring Boot CLI/55.2. Testing your code.md)
      * [55.3. 多源文件应用](VII. Spring Boot CLI/55.3. Applications with multiple source files.md)
      * [55.4. 应用打包](VII. Spring Boot CLI/55.4. Packaging your application.md)
      * [55.5. 初始化新工程](VII. Spring Boot CLI/55.5. Initialize a new project.md)
      * [55.6. 使用内嵌shell](VII. Spring Boot CLI/55.6. Using the embedded shell.md)
      * [55.7. 为CLI添加扩展](VII. Spring Boot CLI/55.7. Adding extensions to the CLI.md)
   * [56. 使用Groovy beans DSL开发应用](VII. Spring Boot CLI/56. Developing application with the Groovy beans DSL.md)
   * [57. 接下来阅读什么](VII. Spring Boot CLI/57. What to read next.md)
* [VIII. 构建工具插件](VIII. Build tool plugins/README.md)
   * [58. Spring Boot Maven插件](VIII. Build tool plugins/58. Spring Boot Maven plugin.md)
      * [58.1. 包含该插件](VIII. Build tool plugins/58.1. Including the plugin.md)
      * [58.2. 打包可执行jar和war文件](VIII. Build tool plugins/58.2. Packaging executable jar and war files.md)
   * [59. Spring Boot Gradle插件](VIII. Build tool plugins/59. Spring Boot Gradle plugin.md)
      * [59.1. 包含该插件](VIII. Build tool plugins/59.1. Including the plugin.md)
      * [59.2. 声明不带版本的依赖](VIII. Build tool plugins/59.2. Declaring dependencies without versions.md)
         * [59.2.1. 自定义版本管理](VIII. Build tool plugins/59.2.1. Custom version management.md)
      * [59.3. 默认排除规则](VIII. Build tool plugins/59.3. Default exclude rules.md)
      * [59.4. 打包可执行jar和war文件](VIII. Build tool plugins/59.4. Packaging executable jar and war files.md)
      * [59.5. 就地（in-place）运行项目](VIII. Build tool plugins/59.5. Running a project in-place.md)
      * [59.6. Spring Boot插件配置](VIII. Build tool plugins/59.6. Spring Boot plugin configuration.md)
      * [59.7. Repackage配置](VIII. Build tool plugins/59.7. Repackage configuration.md)
      * [59.8. 使用Gradle自定义配置进行Repackage](VIII. Build tool plugins/59.8. Repackage with custom Gradle configuration.md)
         * [59.8.1. 配置选项](VIII. Build tool plugins/59.8.1. Configuration options.md)
      * [59.9. 理解Gradle插件是如何工作的](VIII. Build tool plugins/59.9. Understanding how the Gradle plugin works.md)
   * [60. 对其他构建系统的支持](VIII. Build tool plugins/60. Supporting other build systems.md)
      * [60.1. 重新打包存档](VIII. Build tool plugins/60.1. Repackaging archives.md)
      * [60.2. 内嵌的库](VIII. Build tool plugins/60.2. Nested libraries.md)
      * [60.3. 查找main类](VIII. Build tool plugins/60.3. Finding a main class.md)
      * [60.4. repackage实现示例](VIII. Build tool plugins/60.4. Example repackage implementation.md)
   * [61. 接下来阅读什么](VIII. Build tool plugins/61. What to read next.md)
* [IX. How-to指南](IX. ‘How-to’ guides/README.md)
   * [62. Spring Boot应用](IX. ‘How-to’ guides/62. Spring Boot application.md)
      * [62.1. 解决自动配置问题](IX. ‘How-to’ guides/62.1. Troubleshoot auto-configuration.md)
      * [62.2. 启动前自定义Environment或ApplicationContext](IX. ‘How-to’ guides/62.2. Customize the Environment or ApplicationContext before it starts.md)
      * [62.3. 构建ApplicationContext层次结构（添加父或根上下文](IX. ‘How-to’ guides/62.3. Build an ApplicationContext hierarchy (adding a parent or root context).md)
      * [62.4. 创建一个非web（non-web）应用](IX. ‘How-to’ guides/62.4. Create a non-web application.md)
   * [63. 属性&配置](IX. ‘How-to’ guides/63. Properties & configuration.md)
      * [63.1. 外部化SpringApplication配置](IX. ‘How-to’ guides/63.1. Externalize the configuration of SpringApplication.md)
      * [63.2. 改变应用程序外部配置文件的位置](IX. ‘How-to’ guides/63.2. Change the location of external properties of an application.md)
      * [63.3. 使用'short'命令行参数](IX. ‘How-to’ guides/63.3. Use ‘short’ command line arguments.md)
      * [63.4. 使用YAML配置外部属性](IX. ‘How-to’ guides/63.4. Use YAML for external properties.md)
      * [63.5. 设置生效的Spring profiles](IX. ‘How-to’ guides/63.5. Set the active Spring profiles.md)
      * [63.6. 根据环境改变配置](IX. ‘How-to’ guides/63.6. Change configuration depending on the environment.md)
      * [63.7. 发现外部属性的内置选项](IX. ‘How-to’ guides/63.7. Discover built-in options for external properties.md)
   * [64. 内嵌的servlet容器](IX. ‘How-to’ guides/64. Embedded servlet containers.md)
      * [64.1. 为应用添加Servlet，Filter或ServletContextListener](IX. ‘How-to’ guides/64.1. Add a Servlet, Filter or ServletContextListener to an application.md)
      * [64.2. 改变HTTP端口](IX. ‘How-to’ guides/64.2. Change the HTTP port.md)
      * [64.3. 使用随机未分配的HTTP端口](IX. ‘How-to’ guides/64.3. Use a random unassigned HTTP port.md)
      * [64.4. 发现运行时的HTTP端口](IX. ‘How-to’ guides/64.4. Discover the HTTP port at runtime.md)
      * [64.5. 配置SSL](IX. ‘How-to’ guides/64.5. Configure SSL.md)
      * [64.6. 配置Tomcat](IX. ‘How-to’ guides/64.6. Configure Tomcat.md)
      * [64.7. 启用Tomcat的多连接器（Multiple Connectors）](IX. ‘How-to’ guides/64.7. Enable Multiple Connectors with Tomcat.md)
      * [64.8. 在前端代理服务器后使用Tomcat](IX. ‘How-to’ guides/64.8. Use Tomcat behind a front-end proxy server.md)
      * [64.9. 使用Jetty替代Tomcat](IX. ‘How-to’ guides/64.9. Use Jetty instead of Tomcat.md)
      * [64.10. 配置Jetty](IX. ‘How-to’ guides/64.10. Configure Jetty.md)
      * [64.11. 使用Undertow替代Tomcat](IX. ‘How-to’ guides/64.11. Use Undertow instead of Tomcat.md)
      * [64.12. 配置Undertow](IX. ‘How-to’ guides/64.12. Configure Undertow.md)
      * [64.13. 启用Undertow的多监听器](IX. ‘How-to’ guides/64.13. Enable Multiple Listeners with Undertow.md)
      * [64.14. 使用Tomcat7](IX. ‘How-to’ guides/64.14. Use Tomcat 7.md)
         * [64.14.1. 通过Maven使用Tomcat7](IX. ‘How-to’ guides/64.14.1. Use Tomcat 7 with Maven.md)
         * [64.14.2. 通过Gradle使用Tomcat7](IX. ‘How-to’ guides/64.14.2. Use Tomcat 7 with Gradle.md)
      * [64.15. 使用Jetty8](IX. ‘How-to’ guides/64.15. Use Jetty 8.md)
         * [64.15.1. 通过Maven使用Jetty8](IX. ‘How-to’ guides/64.15.1. Use Jetty 8 with Maven.md)
         * [64.15.2. 通过Gradle使用Jetty8](IX. ‘How-to’ guides/64.15.2. Use Jetty 8 with Gradle.md)
      * [64.16. 使用@ServerEndpoint创建WebSocket端点](IX. ‘How-to’ guides/64.16. Create WebSocket endpoints using @ServerEndpoint.md)
      * [64.17. 启用HTTP响应压缩](IX. ‘How-to’ guides/64.17. Enable HTTP response compression.md)
         * [64.17.1. 启用Tomcat的HTTP响应压缩](IX. ‘How-to’ guides/64.17.1. Enable Tomcat’s HTTP response compression.md)
         * [64.17.2. 使用GzipFilter开启HTTP响应压缩](IX. ‘How-to’ guides/64.17.2. Enable HTTP response compression using GzipFilter.md)
   * [65. Spring MVC](IX. ‘How-to’ guides/65. Spring MVC.md)
      * [65.1. 编写一个JSON REST服务](IX. ‘How-to’ guides/65.1. Write a JSON REST service.md)
      * [65.2. 编写一个XML REST服务](IX. ‘How-to’ guides/65.2. Write an XML REST service.md)
      * [65.3. 自定义Jackson ObjectMapper](IX. ‘How-to’ guides/65.3. Customize the Jackson ObjectMapper.md)
      * [65.4. 自定义@ResponseBody渲染](IX. ‘How-to’ guides/65.4. Customize the @ResponseBody rendering.md)
      * [65.5. 处理Multipart文件上传](IX. ‘How-to’ guides/65.5. Handling Multipart File Uploads.md)
      * [65.6. 关闭Spring MVC DispatcherServlet](IX. ‘How-to’ guides/65.6. Switch off the Spring MVC DispatcherServlet.md)
      * [65.7. 关闭默认的MVC配置](IX. ‘How-to’ guides/65.7. Switch off the Default MVC configuration.md)
      * [65.8. 自定义ViewResolvers](IX. ‘How-to’ guides/65.8. Customize ViewResolvers.md)
   * [66. 日志](IX. ‘How-to’ guides/66. Logging.md)
      * [66.1. 配置Logback](IX. ‘How-to’ guides/66.1. Configure Logback for logging.md)
      * [66.2. 配置Log4j](IX. ‘How-to’ guides/66.2. Configure Log4j for logging.md)
         * [66.2.1. 使用YAML或JSON配置Log4j2](IX. ‘How-to’ guides/66.2.1. Use YAML or JSON to configure Log4j 2.md)
   * [67. 数据访问](IX. ‘How-to’ guides/67. Data Access.md)
      * [67.1. 配置一个数据源](IX. ‘How-to’ guides/67.1. Configure a DataSource.md)
      * [67.2. 配置两个数据源](IX. ‘How-to’ guides/67.2. Configure Two DataSources.md)
      * [67.3. 使用Spring Data仓库](IX. ‘How-to’ guides/67.3. Use Spring Data repositories.md)
      * [67.4. 从Spring配置分离@Entity定义](IX. ‘How-to’ guides/67.4. Separate @Entity definitions from Spring configuration.md)
      * [67.5. 配置JPA属性](IX. ‘How-to’ guides/67.5. Configure JPA properties.md)
      * [67.6. 使用自定义的EntityManagerFactory](IX. ‘How-to’ guides/67.6. Use a custom EntityManagerFactory.md)
      * [67.7. 使用两个EntityManagers](IX. ‘How-to’ guides/67.7. Use Two EntityManagers.md)
      * [67.8. 使用普通的persistence.xml](IX. ‘How-to’ guides/67.8. Use a traditional persistence.xml.md)
      * [67.9. 使用Spring Data JPA和Mongo仓库](IX. ‘How-to’ guides/67.9. Use Spring Data JPA and Mongo repositories.md)
      * [67.10. 将Spring Data仓库暴露为REST端点](IX. ‘How-to’ guides/67.10. Expose Spring Data repositories as REST endpoint.md)
   * [68. 数据库初始化](IX. ‘How-to’ guides/68. Database initialization.md)
      * [68.1. 使用JPA初始化数据库](IX. ‘How-to’ guides/68.1. Initialize a database using JPA.md)
      * [68.2. 使用Hibernate初始化数据库](IX. ‘How-to’ guides/68.2. Initialize a database using Hibernate.md)
      * [68.3. 使用Spring JDBC初始化数据库](IX. ‘How-to’ guides/68.3. Initialize a database using Spring JDBC.md)
      * [68.4. 初始化Spring Batch数据库](IX. ‘How-to’ guides/68.4. Initialize a Spring Batch database.md)
      * [68.5. 使用一个高级别的数据迁移工具](IX. ‘How-to’ guides/68.5. Use a higher level database migration tool.md)
         * [68.5.1. 启动时执行Flyway数据库迁移](IX. ‘How-to’ guides/68.5.1. Execute Flyway database migrations on startup.md)
         * [68.5.2. 启动时执行Liquibase数据库迁移](IX. ‘How-to’ guides/68.5.2. Execute Liquibase database migrations on startup.md)
   * [69. 批处理应用](IX. ‘How-to’ guides/69. Batch applications.md)
      * [69.1. 在启动时执行Spring Batch作业](IX. ‘How-to’ guides/69.1. Execute Spring Batch jobs on startup.md)
   * [70. 执行器（Actuator）](IX. ‘How-to’ guides/70. Actuator.md)
      * [70.1. 改变HTTP端口或执行器端点的地址](IX. ‘How-to’ guides/70.1. Change the HTTP port or address of the actuator endpoints.md)
      * [70.2. 自定义'白标'（whitelabel，可以了解下相关理念）错误页面](IX. ‘How-to’ guides/70.2. Customize the ‘whitelabel’ error page.md)
   * [71. 安全](IX. ‘How-to’ guides/71. Security.md)
      * [71.1. 关闭Spring Boot安全配置](IX. ‘How-to’ guides/71.1. Switch off the Spring Boot security configuration.md)
      * [71.2. 改变AuthenticationManager并添加用户账号](IX. ‘How-to’ guides/71.2. Change the AuthenticationManager and add user accounts.md)
      * [71.3. 当前端使用代理服务器时，启用HTTPS](IX. ‘How-to’ guides/71.3. Enable HTTPS when running behind a proxy server.md)
   * [72. 热交换](IX. ‘How-to’ guides/72. Hot swapping.md)
      * [72.1. 重新加载静态内容](IX. ‘How-to’ guides/72.1. Reload static content.md)
      * [72.2. 在不重启容器的情况下重新加载Thymeleaf模板](IX. ‘How-to’ guides/72.2. Reload Thymeleaf templates without restarting the container.md)
      * [72.3. 在不重启容器的情况下重新加载FreeMarker模板](IX. ‘How-to’ guides/72.3. Reload FreeMarker templates without restarting the container.md)
      * [72.4. 在不重启容器的情况下重新加载Groovy模板](IX. ‘How-to’ guides/72.4. Reload Groovy templates without restarting the container.md)
      * [72.5. 在不重启容器的情况下重新加载Velocity模板](IX. ‘How-to’ guides/72.5. Reload Velocity templates without restarting the container.md)
      * [72.6. 在不重启容器的情况下重新加载Java类](IX. ‘How-to’ guides/72.6. Reload Java classes without restarting the container.md)
         * [72.6.1. 使用Maven配置Spring Loaded](IX. ‘How-to’ guides/72.6.1. Configuring Spring Loaded for use with Maven.md)
         * [72.6.2. 使用Gradle和IntelliJ配置Spring Loaded](IX. ‘How-to’ guides/72.6.2. Configuring Spring Loaded for use with Gradle and IntelliJ.md)
   * [73. 构建](IX. ‘How-to’ guides/73. Build.md)
      * [73.1. 使用Maven自定义依赖版本](IX. ‘How-to’ guides/73.1. Customize dependency versions with Maven.md)
      * [73.2. 使用Maven创建可执行JAR](IX. ‘How-to’ guides/73.2. Create an executable JAR with Maven.md)
      * [73.3. 创建其他的可执行JAR](IX. ‘How-to’ guides/73.3. Create an additional executable JAR.md)
      * [73.4. 在可执行jar运行时提取特定的版本](IX. ‘How-to’ guides/73.4. Extract specific libraries when an executable jar runs.md)
      * [73.5. 使用排除创建不可执行的JAR](IX. ‘How-to’ guides/73.5. Create a non-executable JAR with exclusions.m)
      * [73.6. 远程调试一个使用Maven启动的Spring Boot项目](IX. ‘How-to’ guides/73.6. Remote debug a Spring Boot application started with Maven.md)
      * [73.7. 远程调试一个使用Gradle启动的Spring Boot项目](IX. ‘How-to’ guides/73.7. Remote debug a Spring Boot application started with Gradle.md)
      * [73.8. 使用Ant构建可执行存档（archive）](IX. ‘How-to’ guides/73.8. Build an executable archive with Ant.md)
      * [73.9. 如何使用Java6](IX. ‘How-to’ guides/73.9. How to use Java 6.md)
         * [73.9.1. 内嵌Servlet容器兼容性](IX. ‘How-to’ guides/73.9.1. Embedded servlet container compatibility.md)
         * [73.9.2. JTA API兼容性](IX. ‘How-to’ guides/73.9.2. JTA API compatibility.md)
   * [74. 传统部署](IX. ‘How-to’ guides/74. Traditional deployment.md)
      * [74.1. 创建一个可部署的war文件](IX. ‘How-to’ guides/74.1. Create a deployable war file.md)
      * [74.2. 为老的servlet容器创建一个可部署的war文件](IX. ‘How-to’ guides/74.2. Create a deployable war file for older servlet containers.md)
      * [74.3. 将现有的应用转换为Spring Boot](IX. ‘How-to’ guides/74.3. Convert an existing application to Spring Boot.md)
      * [74.4. 部署WAR到Weblogic](IX. ‘How-to’ guides/74.4. Deploying a WAR to Weblogic.md)
      * [74.5. 部署WAR到老的(Servlet2.5)容器](IX. ‘How-to’ guides/74.5. Deploying a WAR in an Old (Servlet 2.5) Container.md)
* [X.附录](X. Appendices/README.md)
   * [附录A. 常见应用属性](X. Appendices/A. Common application properties.md) 
   * [附录B. 配置元数据](X. Appendices/B. Configuration meta-data.md)
      * [附录B.1. 元数据格式](X. Appendices/B.1. Meta-data format.md)
         * [附录B.1.1. Group属性](X. Appendices/B.1.1. Group Attributes.md)
         * [附录B.1.2. Property属性](X. Appendices/B.1.2. Property Attributes.md)
         * [附录B.1.3. 可重复的元数据节点](X. Appendices/B.1.3. Repeated meta-data items.md)
      * [附录B.2. 使用注解处理器产生自己的元数据](X. Appendices/B.2. Generating your own meta-data using the annotation processor.md)
         * [附录 B.2.1. 内嵌属性](X. Appendices/B.2.1. Nested properties.md)
         * [附录 B.2.2. 添加其他的元数据](X. Appendices/B.2.2. Adding additional meta-data.md)
   * [附录C. 自动配置类](X. Appendices/C. Auto-configuration classes.md)
      * [附录 C.1. 来自spring-boot-autoconfigure模块](X. Appendices/C.1. From the “spring-boot-autoconfigure” module.md)
      * [附录C.2. 来自spring-boot-actuator模块](X. Appendices/C.2. From the “spring-boot-actuator” module.md)
   * [附录D. 可执行jar格式](X. Appendices/D. The executable jar format.md)
      * [附录D.1. 内嵌JARs](X. Appendices/D.1. Nested JARs.md)
         * [附录D.1.1. 可执行jar文件结构](X. Appendices/D.1.1. The executable jar file structure.md)
         * [附录D.1.2. 可执行war文件结构](X. Appendices/D.1.2. The executable war file structure.md)
      * [附录D.2. Spring Boot的"JarFile"类](X. Appendices/D.2. Spring Boot’s “JarFile” class.md)
         * [附录D.2.1. 对标准Java "JarFile"的兼容性](X. Appendices/D.2.1. Compatibility with the standard Java “JarFile”.md)
      * [附录D.3. 启动可执行jars](X. Appendices/D.3. Launching executable jars.md)
         * [附录D.3.1 Launcher manifest](X. Appendices/D.3.1. Launcher manifest.md)
         * [附录D.3.2. 暴露的存档](X. Appendices/D.3.2. Exploded archives.md)
      * [附录D.4. PropertiesLauncher特性](X. Appendices/D.4. PropertiesLauncher Features.md)
      * [附录D.5. 可执行jar的限制](X. Appendices/D.5. Executable jar restrictions.md)
         * [附录D.5.1. Zip实体压缩](X. Appendices/D.5.1. Zip entry compression.md)
         * [附录D.5.2. 系统ClassLoader](X. Appendices/D.5.2. System ClassLoader.md)
      * [附录D.6. 可替代的单一jar解决方案](X. Appendices/D.6. Alternative single jar solutions.md)
   * [附录E. 依赖版本](X. Appendices/E. Dependency versions.md)
