/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ExceptionHandlerTable
implements IExceptionHandlerTable {
    private List m_exceptions;

    public Exception_info get(int offset) {
        return (Exception_info)this.m_exceptions.get(offset);
    }

    public int size() {
        return this.m_exceptions.size();
    }

    public long length() {
        return 2 + (this.m_exceptions.size() << 3);
    }

    public Object clone() {
        try {
            ExceptionHandlerTable _clone = (ExceptionHandlerTable)super.clone();
            int exceptions_count = this.m_exceptions.size();
            _clone.m_exceptions = new ArrayList(exceptions_count);
            for (int e = 0; e < exceptions_count; ++e) {
                _clone.m_exceptions.add(((Exception_info)this.m_exceptions.get(e)).clone());
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int exception_table_length = this.m_exceptions.size();
        out.writeU2(exception_table_length);
        for (int i = 0; i < exception_table_length; ++i) {
            this.get(i).writeInClassFormat(out);
        }
    }

    public int add(Exception_info exception) {
        int newoffset = this.m_exceptions.size();
        this.m_exceptions.add(exception);
        return newoffset;
    }

    public Exception_info set(int offset, Exception_info exception) {
        return this.m_exceptions.set(offset, exception);
    }

    ExceptionHandlerTable(int capacity) {
        this.m_exceptions = capacity < 0 ? new ArrayList() : new ArrayList(capacity);
    }
}

