/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.dplus.cache;

import android.util.Log;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AtomicFile {
    private final File a;
    private final File b;

    public AtomicFile(File file) {
        this.a = file;
        this.b = new File(file.getPath() + ".bak");
    }

    public File getBaseFile() {
        return this.a;
    }

    public void delete() {
        this.a.delete();
        this.b.delete();
    }

    public FileOutputStream startWrite(boolean bl) throws IOException {
        if (this.a.exists()) {
            if (!this.b.exists()) {
                if (!this.a.renameTo(this.b)) {
                    Log.w((String)"AtomicFile", (String)("Couldn't rename file " + this.a + " to backup file " + this.b));
                } else {
                    AtomicFile.a(this.b, this.a);
                }
            } else {
                this.a.delete();
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.a, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = this.a.getParentFile();
            if (!file.mkdirs()) {
                SLog.error(UmengText.CACHE.CACHEFILE, fileNotFoundException);
            }
            try {
                fileOutputStream = new FileOutputStream(this.a, bl);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                SLog.error(UmengText.CACHE.CACHEFILE, fileNotFoundException);
            }
        }
        return fileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file, File file2) throws IOException {
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
                Log.d((String)"AtomicFile", (String)(n + ""));
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Log.d((String)"AtomicFile", (String)("comsum time:" + (System.currentTimeMillis() - l)));
    }

    public void finishWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream != null) {
            AtomicFile.a(fileOutputStream);
            try {
                fileOutputStream.close();
                this.b.delete();
            }
            catch (IOException iOException) {
                SLog.error(UmengText.CACHE.CACHEFILE, iOException);
            }
        }
    }

    public void failWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream != null) {
            AtomicFile.a(fileOutputStream);
            try {
                fileOutputStream.close();
                this.a.delete();
                this.b.renameTo(this.a);
            }
            catch (IOException iOException) {
                SLog.error(UmengText.CACHE.CACHEFILE, iOException);
            }
        }
    }

    public FileInputStream openRead() throws FileNotFoundException {
        if (this.b.exists()) {
            this.a.delete();
            this.b.renameTo(this.a);
        }
        return new FileInputStream(this.a);
    }

    public byte[] readFully() throws IOException {
        FileInputStream fileInputStream = this.openRead();
        try {
            int n = 0;
            int n2 = fileInputStream.available();
            byte[] byArray = new byte[n2];
            while (true) {
                byte[] byArray2;
                int n3;
                if ((n3 = fileInputStream.read(byArray, n, byArray.length - n)) <= 0) {
                    byArray2 = byArray;
                    return byArray2;
                }
                n2 = fileInputStream.available();
                if (n2 <= byArray.length - (n += n3)) continue;
                byArray2 = new byte[n + n2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    static boolean a(FileOutputStream fileOutputStream) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.getFD().sync();
            }
            return true;
        }
        catch (IOException iOException) {
            SLog.error(UmengText.CACHE.CACHEFILE, iOException);
            return false;
        }
    }
}

