/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.qq.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.qq.handler.UmengQBaseHandler;
import com.umeng.qq.handler.UmengQQPreferences;
import com.umeng.qq.handler.UmengQZoneShareContent;
import com.umeng.qq.tencent.IUiListener;
import com.umeng.qq.tencent.Tencent;
import com.umeng.qq.tencent.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.utils.UmengText;

public class UmengQZoneHandler
extends UmengQBaseHandler {
    private UmengQQPreferences qqPreferences;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.qqPreferences = new UmengQQPreferences(context, SHARE_MEDIA.QQ.toString());
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        Bundle bundle;
        String error;
        UmengQZoneShareContent shareContent = new UmengQZoneShareContent(content);
        if (this.mShareConfig != null) {
            shareContent.setCompressListener(this.mShareConfig.getCompressListener());
        }
        if (listener != null) {
            this.mShareListener = listener;
        }
        if (this.mTencent == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQZoneHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.tencentEmpty((boolean)Config.isUmengQQ)));
                }
            });
            return false;
        }
        if (!this.isInstall()) {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"https://log.umsns.com/link/qq/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQZoneHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(error = (bundle = shareContent.getBundle(this.getShareConfig().getAppName())).getString("error")))) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UmengQZoneHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.ShareFailed.getMessage() + error));
                }
            });
            return false;
        }
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mTencent.shareToQzone((Activity)this.mWeakAct.get(), bundle, this.getmShareListener(this.mShareListener));
        }
        return false;
    }

    public boolean isInstall() {
        return this.mWeakAct.get() == null || ((Activity)this.mWeakAct.get()).isFinishing() || this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public boolean isSupportAuth() {
        return false;
    }

    public int getRequestCode() {
        return 10104;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10104) {
            Tencent.onActivityResultData(requestCode, resultCode, data, this.getmShareListener(this.mShareListener));
        }
    }

    public IUiListener getmShareListener(final UMShareListener mShareListener) {
        return new IUiListener(){

            @Override
            public void onComplete(Object o) {
                UmengQZoneHandler.this.getShareListener(mShareListener).onResult(SHARE_MEDIA.QZONE);
            }

            @Override
            public void onError(UiError uiError) {
                UmengQZoneHandler.this.getShareListener(mShareListener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.ShareFailed.getMessage() + uiError.errorMessage));
            }

            @Override
            public void onCancel() {
                UmengQZoneHandler.this.getShareListener(mShareListener).onCancel(SHARE_MEDIA.QZONE);
            }
        };
    }
}

