/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.content.Context;
import android.os.Build;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.DeviceConfig;

public class URLBuilder {
    private String mReqType = "0";
    private String mHost = null;
    private String mPath = null;
    private String mAppkey = null;
    private String mEntityKey = null;
    private String mOpId = null;
    private String mUID = null;
    private String mSessionId = null;
    private String mPlatfrom = null;
    private String imei = null;
    private String mac = null;
    private String network = null;
    private String model = null;
    private String sdkversion = null;
    private String os = null;
    private String ts = null;
    private String protoversion = null;

    public URLBuilder(Context context) {
        this.imei = DeviceConfig.getDeviceId(context);
        this.mac = DeviceConfig.getMac(context);
        String[] stringArray = DeviceConfig.getNetworkAccessMode(context);
        this.network = stringArray[0];
        this.model = Build.MODEL;
        this.sdkversion = "6.9.8";
        this.os = "Android";
        this.ts = String.valueOf(System.currentTimeMillis());
        this.protoversion = "3.0";
    }

    public URLBuilder setHost(String string) {
        this.mHost = string;
        return this;
    }

    public URLBuilder setPath(String string) {
        this.mPath = string;
        return this;
    }

    public URLBuilder setAppkey(String string) {
        this.mAppkey = string;
        return this;
    }

    public URLBuilder setEntityKey(String string) {
        this.mEntityKey = string;
        return this;
    }

    public URLBuilder withMedia(SHARE_MEDIA sHARE_MEDIA) {
        this.mPlatfrom = sHARE_MEDIA.toString();
        return this;
    }

    public URLBuilder withOpId(String string) {
        this.mOpId = string;
        return this;
    }

    public URLBuilder withSessionId(String string) {
        this.mSessionId = string;
        return this;
    }

    public URLBuilder withUID(String string) {
        this.mUID = string;
        return this;
    }

    public String to() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mHost);
        stringBuilder.append(this.mPath);
        stringBuilder.append(this.mAppkey);
        stringBuilder.append("/");
        stringBuilder.append(this.mEntityKey);
        stringBuilder.append("/?");
        stringBuilder.append(this.buildParams());
        return stringBuilder.toString();
    }

    public String toEncript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mHost);
        stringBuilder.append(this.mPath);
        stringBuilder.append(this.mAppkey);
        stringBuilder.append("/");
        stringBuilder.append(this.mEntityKey);
        stringBuilder.append("/?");
        String string = this.buildParams();
        Object var3_3 = null;
        try {
            stringBuilder.append(string);
        }
        catch (Exception exception) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String buildParams() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("via=").append(this.mPlatfrom.toLowerCase());
        stringBuilder.append("&opid=").append(this.mOpId);
        stringBuilder.append("&ak=").append(this.mAppkey);
        stringBuilder.append("&pcv=").append(this.protoversion);
        stringBuilder.append("&tp=").append(this.mReqType);
        if (this.imei != null) {
            stringBuilder.append("&imei=").append(this.imei);
        }
        if (this.mac != null) {
            stringBuilder.append("&mac=").append(this.mac);
        }
        if (this.network != null) {
            stringBuilder.append("&en=").append(this.network);
        }
        if (this.model != null) {
            stringBuilder.append("&de=").append(this.model);
        }
        if (this.sdkversion != null) {
            stringBuilder.append("&sdkv=").append(this.sdkversion);
        }
        if (this.os != null) {
            stringBuilder.append("&os=").append(this.os);
        }
        if (this.ts != null) {
            stringBuilder.append("&dt=").append(this.ts);
        }
        if (this.mUID != null) {
            stringBuilder.append("&uid=").append(this.mUID);
        }
        if (this.mEntityKey != null) {
            stringBuilder.append("&ek=").append(this.mEntityKey);
        }
        if (this.mSessionId != null) {
            stringBuilder.append("&sid=").append(this.mSessionId);
        }
        return stringBuilder.toString();
    }
}

