/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public abstract class URequest {
    protected MIME mMimeType;
    public Map<String, String> mHeaders;
    public Map<String, String> mParams = new HashMap<String, String>();
    public Class<? extends SocializeReseponse> mResponseClz;
    public Context mContext;
    public RequestMethod mMethod;
    public PostStyle postStyle = PostStyle.MULTIPART;
    protected static String POST = "POST";
    protected static String GET = "GET";
    protected static String MULTIPART = "multipart/form-data";
    protected static String APPLICATION = "application/x-www-form-urlencoded";
    protected String mBaseUrl;

    public abstract JSONObject toJson();

    public abstract String toGetUrl();

    protected String getHttpMethod() {
        return this.mMethod.toString();
    }

    public URequest(String string) {
        this.mBaseUrl = string;
    }

    public void setBaseUrl(String string) {
        this.mBaseUrl = string;
    }

    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    public Map<String, Object> getBodyPair() {
        return null;
    }

    public Map<String, FilePair> getFilePair() {
        return null;
    }

    public void onPrepareRequest() {
    }

    public String getEcryptString(String string) {
        return string;
    }

    public String getDecryptString(String string) {
        return string;
    }

    public String generateGetURL(String string, Map<String, Object> map) {
        return this.buildGetUrl(string, map);
    }

    public String buildGetUrl(String string, Map<String, Object> map) {
        CharSequence charSequence;
        if (TextUtils.isEmpty((CharSequence)string) || map == null || map.size() == 0) {
            return string;
        }
        if (!string.endsWith("?")) {
            string = string + "?";
        }
        String string2 = URequest.buildGetParams(map);
        SLog.debug(UmengText.NET.assertURL(string, string2));
        try {
            charSequence = this.getEcryptString(string2);
            string2 = charSequence;
        }
        catch (Exception exception) {
            SLog.error(UmengText.NET.PARSEERROR, exception);
        }
        charSequence = new StringBuilder(string);
        ((StringBuilder)charSequence).append(string2);
        return ((StringBuilder)charSequence).toString();
    }

    public static String buildGetParams(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = map.keySet();
        for (String string : set) {
            if (map.get(string) == null) continue;
            stringBuilder = stringBuilder.append(string + "=" + URLEncoder.encode(map.get(string).toString()) + "&");
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 1).toString();
        return string;
    }

    public abstract Map<String, Object> buildParams();

    public void addStringParams(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mParams.put(string, string2);
        }
    }

    protected static enum MIME {
        DEFAULT("application/x-www-form-urlencoded;charset=utf-8"),
        JSON("application/json;charset=utf-8");

        private String mimeType;

        private MIME(String string2) {
            this.mimeType = string2;
        }

        public String toString() {
            return this.mimeType;
        }
    }

    public static class FilePair {
        String mFileName;
        byte[] mBinaryData;

        public FilePair(String string, byte[] byArray) {
            this.mFileName = string;
            this.mBinaryData = byArray;
        }
    }

    public static enum PostStyle {
        MULTIPART{

            public String toString() {
                return URequest.MULTIPART;
            }
        }
        ,
        APPLICATION{

            public String toString() {
                return URequest.APPLICATION;
            }
        };

    }

    public static enum RequestMethod {
        GET{

            public String toString() {
                return URequest.GET;
            }
        }
        ,
        POST{

            public String toString() {
                return URequest.POST;
            }
        };

    }
}

