/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.qq.handler;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMWeb;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.UmengText;
import java.io.File;
import java.util.ArrayList;

public class UmengQZoneShareContent
extends SimpleShareContent {
    public ArrayList imagelist = new ArrayList();

    public UmengQZoneShareContent(ShareContent shareContent) {
        super(shareContent);
    }

    public Bundle getBundle(String appName) {
        Bundle bundle = null;
        if (this.getmStyle() == 2 || this.getmStyle() == 3) {
            bundle = this.buildImageBundle();
            bundle.putString("umeng_type", "shuoshuo");
        } else if (this.getmStyle() == 4) {
            bundle = this.buildMusicBundle();
            bundle.putString("umeng_type", "qzone");
        } else if (this.getmStyle() == 16) {
            bundle = this.buildWebBundle();
            bundle.putString("umeng_type", "qzone");
        } else if (this.getmStyle() == 8) {
            bundle = this.buildVideoBundle();
            bundle.putString("umeng_type", "qzone");
        } else {
            bundle = this.buildTextBundle();
            bundle.putString("umeng_type", "shuoshuo");
        }
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            bundle.putString("appName", appName);
        }
        return bundle;
    }

    private Bundle buildTextBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("summary", this.getText());
        return bundle;
    }

    private Bundle buildVideoBundle() {
        String localpath = null;
        String error = null;
        UMVideo umVideo = this.getVideo();
        if (umVideo.getThumbImage() != null) {
            if (umVideo.getThumbImage().asFileImage() != null) {
                if (this.getUMImageScale(umVideo.getThumbImage()) <= 0) {
                    error = UmengText.IMAGE.SHARECONTENT_IMAGE_ERROR;
                }
                localpath = umVideo.getThumbImage().asFileImage().toString();
            } else {
                error = UmengText.QQ.QQ_PERMISSION;
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)umVideo), 200));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)umVideo), 600));
        bundle.putString("imageLocalUrl", localpath);
        if (!TextUtils.isEmpty((CharSequence)localpath)) {
            this.imagelist.clear();
            this.imagelist.add(localpath);
        }
        bundle.putStringArrayList("imageUrl", this.imagelist);
        bundle.putString("targetUrl", umVideo.toUrl());
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildWebBundle() {
        String localpath = null;
        String error = null;
        UMWeb umWeb = this.getUmWeb();
        Bundle bundle = new Bundle();
        if (umWeb.getThumbImage() != null) {
            UMImage t = umWeb.getThumbImage();
            if (t.isUrlMedia()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(t.toUrl());
                bundle.putStringArrayList("imageUrl", list);
            } else {
                if (umWeb.getThumbImage().asFileImage() != null) {
                    if (this.getUMImageScale(umWeb.getThumbImage()) <= 0) {
                        error = UmengText.IMAGE.SHARECONTENT_THUMB_ERROR;
                    }
                    localpath = umWeb.getThumbImage().asFileImage().toString();
                } else {
                    error = UmengText.QQ.QQ_PERMISSION;
                }
                bundle.putString("imageLocalUrl", localpath);
                if (!TextUtils.isEmpty(localpath)) {
                    this.imagelist.clear();
                    this.imagelist.add(localpath);
                }
                bundle.putStringArrayList("imageUrl", this.imagelist);
            }
        }
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)umWeb), 200));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)umWeb), 600));
        bundle.putString("targetUrl", umWeb.toUrl());
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildMusicBundle() {
        String localpath = null;
        String error = null;
        UMusic mMusic = this.getMusic();
        if (mMusic.getThumbImage() != null) {
            if (mMusic.getThumbImage().asFileImage() != null) {
                if (this.getUMImageScale(mMusic.getThumbImage()) <= 0) {
                    error = UmengText.IMAGE.SHARECONTENT_IMAGE_ERROR;
                }
                localpath = mMusic.getThumbImage().asFileImage().toString();
            } else {
                error = UmengText.QQ.QQ_PERMISSION;
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString("title", this.subString(this.objectSetTitle((BaseMediaObject)mMusic), 200));
        bundle.putString("summary", this.subString(this.objectSetDescription((BaseMediaObject)mMusic), 600));
        bundle.putString("imageLocalUrl", localpath);
        if (!TextUtils.isEmpty((CharSequence)localpath)) {
            this.imagelist.clear();
            this.imagelist.add(localpath);
        }
        bundle.putStringArrayList("imageUrl", this.imagelist);
        bundle.putString("targetUrl", mMusic.getmTargetUrl());
        bundle.putString("audio_url", mMusic.toUrl());
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }

    private Bundle buildImageBundle() {
        String localpath = null;
        String error = null;
        Bundle bundle = new Bundle();
        if (this.getmImages() != null && this.getmImages().length > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            for (UMImage temp : this.getmImages()) {
                File f = temp.asFileImage();
                if (f == null) continue;
                paths.add(f.toString());
            }
            bundle.putStringArrayList("imageUrl", paths);
        } else {
            if (this.getImage().asFileImage() != null) {
                if (this.getUMImageScale(this.getImage()) <= 0) {
                    error = UmengText.IMAGE.SHARECONTENT_IMAGE_ERROR;
                }
                localpath = this.getImage().asFileImage().toString();
            } else {
                error = UmengText.QQ.QQ_PERMISSION;
            }
            bundle.putString("summary", this.getText());
            bundle.putString("imageLocalUrl", localpath);
            if (!TextUtils.isEmpty((CharSequence)localpath)) {
                this.imagelist.clear();
                this.imagelist.add(localpath);
            }
            bundle.putStringArrayList("imageUrl", this.imagelist);
        }
        if (!TextUtils.isEmpty((CharSequence)error)) {
            bundle.putString("error", error);
        }
        return bundle;
    }
}

