/*!
 * 
 *     iclient9-mapboxgl.(http://iclient.supermapol.com)
 *     Copyright© 2000-2017 SuperMap Software Co. Ltd
 *     license: Apache-2.0
 *     version: v9.0.0
 * 
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 256);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var SuperMap = window.SuperMap = window.SuperMap || {};
module.exports = SuperMap;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryType = exports.StatisticAnalystMode = exports.AnalystSizeUnit = exports.AnalystAreaUnit = exports.ClipAnalystMode = exports.ChartType = exports.ClientType = exports.Exponent = exports.VariogramMode = exports.InterpolationAlgorithmType = exports.SearchMode = exports.PixelFormat = exports.StatisticMode = exports.UGCLayerType = exports.LayerType = exports.ColorSpaceType = exports.GridType = exports.TransferPreference = exports.TransferTactic = exports.EditType = exports.DataReturnMode = exports.SurfaceAnalystMethod = exports.SmoothMethod = exports.OverlayOperationType = exports.BufferEndType = exports.TurnType = exports.SupplyCenterType = exports.SideType = exports.DirectionType = exports.LabelOverLengthMode = exports.LabelBackShape = exports.AlongLineDirection = exports.FillGradientMode = exports.TextAlignment = exports.ColorGradientType = exports.ThemeType = exports.RangeMode = exports.GraduatedMode = exports.GraphAxesTextDisplayMode = exports.ThemeGraphType = exports.ThemeGraphTextFormat = exports.EngineType = exports.Unit = exports.MeasureMode = exports.SpatialRelationType = exports.SpatialQueryMode = exports.JoinType = exports.QueryOption = exports.GeometryType = exports.ServerType = exports.DataFormat = undefined;

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @name DataFormat
 * @memberOf SuperMap
 * @description 服务请求返回结果数据类型
 *
 * @property {string} GEOJSON  GEOJSON
 * @property {string} ISERVER  ISERVER
 */
var DataFormat = exports.DataFormat = _SuperMap2.default.DataFormat = {
  GEOJSON: "GEOJSON",
  ISERVER: "ISERVER"
};

/**
 * @name ServerType
 * @memberOf SuperMap
 * @description 服务器类型
 *
 * @property {string} ISERVER  ISERVER
 * @property {string} IPORTAL  IPORTAL
 * @property {string} ONLINE  ONLINE
 */
var ServerType = exports.ServerType = _SuperMap2.default.ServerType = {
  ISERVER: "ISERVER",
  IPORTAL: "IPORTAL",
  ONLINE: "ONLINE"
};

/**
 * @name GeometryType
 * @memberOf SuperMap
 * @description 几何对象枚举,定义了一系列几何对象类型。
 *
 * @property {string} LINE  LINE
 * @property {string} LINEM  LINEM
 * @property {string} POINT  POINT
 * @property {string} REGION  REGION
 * @property {string} ELLIPSE  ELLIPSE
 * @property {string} CIRCLE  CIRCLE
 * @property {string} TEXT  TEXT
 * @property {string} UNKNOWN  UNKNOWN
 */
var GeometryType = exports.GeometryType = _SuperMap2.default.GeometryType = {
  LINE: "LINE",
  LINEM: "LINEM",
  POINT: "POINT",
  REGION: "REGION",
  ELLIPSE: "ELLIPSE",
  CIRCLE: "CIRCLE",
  TEXT: "TEXT",
  UNKNOWN: "UNKNOWN"
};

/**
 * @name QueryOption
 * @memberOf SuperMap
 * @description 查询结果类型枚举,描述查询结果返回类型，包括只返回属性、只返回几何实体以及返回属性和几何实体。
 *
 * @property {string} ATTRIBUTE  ATTRIBUTE
 * @property {string} ATTRIBUTEANDGEOMETRY  ATTRIBUTEANDGEOMETRY
 * @property {string} GEOMETRY  GEOMETRY
 */
var QueryOption = exports.QueryOption = _SuperMap2.default.QueryOption = {
  ATTRIBUTE: "ATTRIBUTE",
  ATTRIBUTEANDGEOMETRY: "ATTRIBUTEANDGEOMETRY",
  GEOMETRY: "GEOMETRY"
};

/**
 * @name JoinType
 * @memberOf SuperMap
 * @description 关联查询时的关联类型常量。
 * 该类定义了两个表之间的连接类型常量，决定了对两个表之间进行连接查询时，查询结果中得到的记录的情况。
 *
 * @property {string} INNERJOIN  INNERJOIN
 * @property {string} LEFTJOIN  LEFTJOIN
 */
var JoinType = exports.JoinType = _SuperMap2.default.JoinType = {
  INNERJOIN: "INNERJOIN",
  LEFTJOIN: "LEFTJOIN"
};

/**
 * @name SpatialQueryMode
 * @memberOf SuperMap
 * @description  空间查询模式枚举。该类定义了空间查询操作模式常量。
 *
 * @property {string} CONTAIN  CONTAIN
 * @property {string} CROSS  CROSS
 * @property {string} DISJOINT  DISJOINT
 * @property {string} IDENTITY  IDENTITY
 * @property {string} INTERSECT  INTERSECT
 * @property {string} NONE  NONE
 * @property {string} OVERLAP  OVERLAP
 * @property {string} TOUCH  TOUCH
 * @property {string} WITHIN  WITHIN
 */
var SpatialQueryMode = exports.SpatialQueryMode = _SuperMap2.default.SpatialQueryMode = {
  CONTAIN: "CONTAIN",
  CROSS: "CROSS",
  DISJOINT: "DISJOINT",
  IDENTITY: "IDENTITY",
  INTERSECT: "INTERSECT",
  NONE: "NONE",
  OVERLAP: "OVERLAP",
  TOUCH: "TOUCH",
  WITHIN: "WITHIN"
};

/**
 * @name SpatialRelationType
 * @memberOf SuperMap
 * @description  数据集对象间的空间关系枚举。
 * 该类定义了数据集对象间的空间关系类型常量。
 *
 * @property {string} CONTAIN 包含关系 CONTAIN  CONTAIN
 * @property {string} INTERSECT 相交关系 INTERSECT  INTERSECT
 * @property {string} INTERSECT 被包含关系 WITHIN  WITHIN
 */
var SpatialRelationType = exports.SpatialRelationType = _SuperMap2.default.SpatialRelationType = {
  CONTAIN: "CONTAIN",
  INTERSECT: "INTERSECT",
  WITHIN: "WITHIN"
};

/**
 * @name MeasureMode
 * @memberOf SuperMap
 * @property {string} DISTANCE DISTANCE
 * @property {string} AREA AREA
 * @description  量算模式枚举。
 * 该类定义了两种测量模式：距离测量和面积测量。
 */
var MeasureMode = exports.MeasureMode = _SuperMap2.default.MeasureMode = {
  DISTANCE: "DISTANCE",
  AREA: "AREA"
};

/**
 * @name Unit
 * @memberOf SuperMap
 * @description  距离单位枚举。
 * 该类定义了一系列距离单位类型。
 *
 * @property {string} METER  METER
 * @property {string} KILOMETER  KILOMETER
 * @property {string} MILE  MILE
 * @property {string} YARD  YARD
 * @property {string} DEGREE  DEGREE
 * @property {string} MILLIMETER  MILLIMETER
 * @property {string} CENTIMETER  CENTIMETER
 * @property {string} INCH  INCH
 * @property {string} DECIMETER  DECIMETER
 * @property {string} FOOT  FOOT
 * @property {string} SECOND  SECOND
 * @property {string} MINUTE  MINUTE
 * @property {string} RADIAN  RADIAN
 */
var Unit = exports.Unit = _SuperMap2.default.Unit = {
  METER: "METER",
  KILOMETER: "KILOMETER",
  MILE: "MILE",
  YARD: "YARD",
  DEGREE: "DEGREE",
  MILLIMETER: "MILLIMETER",
  CENTIMETER: "CENTIMETER",
  INCH: "INCH",
  DECIMETER: "DECIMETER",
  FOOT: "FOOT",
  SECOND: "SECOND",
  MINUTE: "MINUTE",
  RADIAN: "RADIAN"
};

/**
 * @name EngineType
 * @memberOf SuperMap
 * @description  数据源引擎类型枚举。
 *
 * @property {string} IMAGEPLUGINS  IMAGEPLUGINS
 * @property {string} OGC  OGC
 * @property {string} ORACLEPLUS  ORACLEPLUS
 * @property {string} SDBPLUS  SDBPLUS
 * @property {string} SQLPLUS  SQLPLUS
 * @property {string} UDB  UDB
 */
var EngineType = exports.EngineType = _SuperMap2.default.EngineType = {
  IMAGEPLUGINS: "IMAGEPLUGINS",
  OGC: "OGC",
  ORACLEPLUS: "ORACLEPLUS",
  SDBPLUS: "SDBPLUS",
  SQLPLUS: "SQLPLUS",
  UDB: "UDB"
};

/**
 * @name ThemeGraphTextFormat
 * @memberOf SuperMap
 * @description  统计专题图文本显示格式枚举。
 *
 * @property {string} CAPTION  CAPTION
 * @property {string} CAPTION_PERCENT  CAPTION_PERCENT
 * @property {string} CAPTION_VALUE  CAPTION_VALUE
 * @property {string} PERCENT  PERCENT
 * @property {string} VALUE  VALUE
 */
var ThemeGraphTextFormat = exports.ThemeGraphTextFormat = _SuperMap2.default.ThemeGraphTextFormat = {
  CAPTION: "CAPTION",
  CAPTION_PERCENT: "CAPTION_PERCENT",
  CAPTION_VALUE: "CAPTION_VALUE",
  PERCENT: "PERCENT",
  VALUE: "VALUE"
};

/**
 * @name ThemeGraphType
 * @memberOf SuperMap
 * @description  统计专题图类型枚举。
 *
 * @property {string} AREA  AREA
 * @property {string} BAR  BAR
 * @property {string} BAR3D  BAR3D
 * @property {string} LINE  LINE
 * @property {string} PIE  PIE
 * @property {string} PIE3D  PIE3D
 * @property {string} POINT  POINT
 * @property {string} RING  RING
 * @property {string} ROSE  ROSE
 * @property {string} ROSE3D  ROSE3D
 * @property {string} STACK_BAR  STACK_BAR
 * @property {string} STACK_BAR3D  STACK_BAR3D
 * @property {string} STEP  STEP
 */
var ThemeGraphType = exports.ThemeGraphType = _SuperMap2.default.ThemeGraphType = {
  AREA: "AREA",
  BAR: "BAR",
  BAR3D: "BAR3D",
  LINE: "LINE",
  PIE: "PIE",
  PIE3D: "PIE3D",
  POINT: "POINT",
  RING: "RING",
  ROSE: "ROSE",
  ROSE3D: "ROSE3D",
  STACK_BAR: "STACK_BAR",
  STACK_BAR3D: "STACK_BAR3D",
  STEP: "STEP"
};

/**
 * @name GraphAxesTextDisplayMode
 * @memberOf SuperMap
 * @description  统计专题图坐标轴文本显示模式。
 *
 * @property {string} ALL  ALL, 显示全部文本
 * @property {string} NONE  NONE, 没有显示
 * @property {string} YAXES  YAXES. 显示Y轴的文本
 */
var GraphAxesTextDisplayMode = exports.GraphAxesTextDisplayMode = _SuperMap2.default.GraphAxesTextDisplayMode = {
  ALL: "ALL",
  NONE: "NONE",
  YAXES: "YAXES"
};

/**
 * @name GraduatedMode
 * @memberOf SuperMap
 * @description  专题图分级模式枚举。
 *
 * @property {string} CONSTANT  CONSTANT
 * @property {string} LOGARITHM  LOGARITHM
 * @property {string} SQUAREROOT  SQUAREROOT
 */
var GraduatedMode = exports.GraduatedMode = _SuperMap2.default.GraduatedMode = {
  CONSTANT: "CONSTANT",
  LOGARITHM: "LOGARITHM",
  SQUAREROOT: "SQUAREROOT"
};

/**
 * @name RangeMode
 * @memberOf SuperMap
 * @description  范围分段专题图分段方式枚举。
 *
 * @property {string} CUSTOMINTERVAL  CUSTOMINTERVAL
 * @property {string} EQUALINTERVAL  EQUALINTERVAL
 * @property {string} LOGARITHM  LOGARITHM
 * @property {string} QUANTILE  QUANTILE
 * @property {string} SQUAREROOT  SQUAREROOT
 * @property {string} STDDEVIATION  STDDEVIATION
 */
var RangeMode = exports.RangeMode = _SuperMap2.default.RangeMode = {
  CUSTOMINTERVAL: "CUSTOMINTERVAL",
  EQUALINTERVAL: "EQUALINTERVAL",
  LOGARITHM: "LOGARITHM",
  QUANTILE: "QUANTILE",
  SQUAREROOT: "SQUAREROOT",
  STDDEVIATION: "STDDEVIATION"
};

/**
 * @name ThemeType
 * @memberOf SuperMap
 * @description  专题图类型枚举。
 *
 * @property {string} DOTDENSITY  DOTDENSITY
 * @property {string} GRADUATEDSYMBOL  GRADUATEDSYMBOL
 * @property {string} GRAPH  GRAPH
 * @property {string} LABEL  LABEL
 * @property {string} RANGE  RANGE
 * @property {string} UNIQUE  UNIQUE
 */
var ThemeType = exports.ThemeType = _SuperMap2.default.ThemeType = {
  DOTDENSITY: "DOTDENSITY",
  GRADUATEDSYMBOL: "GRADUATEDSYMBOL",
  GRAPH: "GRAPH",
  LABEL: "LABEL",
  RANGE: "RANGE",
  UNIQUE: "UNIQUE"
};

/**
 * @name ColorGradientType
 * @memberOf SuperMap
 * @description  渐变颜色枚举。
 *
 * @property {string} BLACK_WHITE  BLACKWHITE
 * @property {string} BLUE_BLACK  BLUEBLACK
 * @property {string} BLUE_RED   BLUERED
 * @property {string} BLUE_WHITE  BLUEWHITE
 * @property {string} CYAN_BLACK  CYANBLACK
 * @property {string} CYAN_BLUE  CYANBLUE
 * @property {string} CYAN_GREEN  CYANGREEN
 * @property {string} CYAN_WHITE  CYANWHITE
 * @property {string} GREEN_BLACK  GREENBLACK
 * @property {string} GREEN_BLUE  GREENBLUE
 * @property {string} GREEN_ORANGE_VIOLET  GREENORANGEVIOLET
 * @property {string} GREEN_RED  GREENRED
 * @property {string} GREEN_WHITE  GREENWHITE
 * @property {string} PINK_BLACK  PINKBLACK
 * @property {string} PINK_BLUE  PINKBLUE
 * @property {string} PINK_RED  PINKRED
 * @property {string} PINK_WHITE  PINKWHITE
 * @property {string} RAIN_BOW  RAINBOW
 * @property {string} RED_BLACK  REDBLACK
 * @property {string} RED_WHITE  REDWHITE
 * @property {string} SPECTRUM  SPECTRUM
 * @property {string} TERRAIN  TERRAIN
 * @property {string} YELLOW_BLACK  YELLOWBLACK
 * @property {string} YELLOW_BLUE  YELLOWBLUE
 * @property {string} YELLOW_GREEN  YELLOWGREEN
 * @property {string} YELLOW_RED  YELLOWRED
 * @property {string} YELLOW_WHITE  YELLOWWHITE
 */
var ColorGradientType = exports.ColorGradientType = _SuperMap2.default.ColorGradientType = {
  BLACK_WHITE: "BLACKWHITE",
  BLUE_BLACK: "BLUEBLACK",
  BLUE_RED: "BLUERED",
  BLUE_WHITE: "BLUEWHITE",
  CYAN_BLACK: "CYANBLACK",
  CYAN_BLUE: "CYANBLUE",
  CYAN_GREEN: "CYANGREEN",
  CYAN_WHITE: "CYANWHITE",
  GREEN_BLACK: "GREENBLACK",
  GREEN_BLUE: "GREENBLUE",
  GREEN_ORANGE_VIOLET: "GREENORANGEVIOLET",
  GREEN_RED: "GREENRED",
  GREEN_WHITE: "GREENWHITE",
  PINK_BLACK: "PINKBLACK",
  PINK_BLUE: "PINKBLUE",
  PINK_RED: "PINKRED",
  PINK_WHITE: "PINKWHITE",
  RAIN_BOW: "RAINBOW",
  RED_BLACK: "REDBLACK",
  RED_WHITE: "REDWHITE",
  SPECTRUM: "SPECTRUM",
  TERRAIN: "TERRAIN",
  YELLOW_BLACK: "YELLOWBLACK",
  YELLOW_BLUE: "YELLOWBLUE",
  YELLOW_GREEN: "YELLOWGREEN",
  YELLOW_RED: "YELLOWRED",
  YELLOW_WHITE: "YELLOWWHITE"
};

/**
 * @name TextAlignment
 * @memberOf SuperMap
 * @description  文本对齐枚举。
 *
 * @property {string} TOPLEFT  TOPLEFT
 * @property {string} TOPCENTER  TOPCENTER
 * @property {string} TOPRIGHT  TOPRIGHT
 * @property {string} BASELINELEFT  BASELINELEFT
 * @property {string} BASELINECENTER  BASELINECENTER
 * @property {string} BASELINERIGHT  BASELINERIGHT
 * @property {string} BOTTOMLEFT  BOTTOMLEFT
 * @property {string} BOTTOMCENTER  BOTTOMCENTER
 * @property {string} BOTTOMRIGHT  BOTTOMRIGHT
 * @property {string} MIDDLELEFT  MIDDLELEFT
 * @property {string} MIDDLECENTER  MIDDLECENTER
 * @property {string} MIDDLERIGHT  MIDDLERIGHT
 */
var TextAlignment = exports.TextAlignment = _SuperMap2.default.TextAlignment = {
  TOPLEFT: "TOPLEFT",
  TOPCENTER: "TOPCENTER",
  TOPRIGHT: "TOPRIGHT",
  BASELINELEFT: "BASELINELEFT",
  BASELINECENTER: "BASELINECENTER",
  BASELINERIGHT: "BASELINERIGHT",
  BOTTOMLEFT: "BOTTOMLEFT",
  BOTTOMCENTER: "BOTTOMCENTER",
  BOTTOMRIGHT: "BOTTOMRIGHT",
  MIDDLELEFT: "MIDDLELEFT",
  MIDDLECENTER: "MIDDLECENTER",
  MIDDLERIGHT: "MIDDLERIGHT"
};

/**
 * @name FillGradientMode
 * @memberOf SuperMap
 * @description  渐变填充风格的渐变类型枚举。
 *
 * @property {string} NONE  NONE
 * @property {string} LINEAR  LINEAR
 * @property {string} RADIAL  RADIAL
 * @property {string} CONICAL  CONICAL
 * @property {string} SQUARE  SQUARE
 */
var FillGradientMode = exports.FillGradientMode = _SuperMap2.default.FillGradientMode = {
  NONE: "NONE",
  LINEAR: "LINEAR",
  RADIAL: "RADIAL",
  CONICAL: "CONICAL",
  SQUARE: "SQUARE"
};

/**
 * @name AlongLineDirection
 * @memberOf SuperMap
 * @name AlongLineDirection
 * @memberOf SuperMap
 * @description  标签沿线标注方向枚举。
 *
 * @property {string} NORMAL  ALONG_LINE_NORMAL
 * @property {string} LB_TO_RT  LEFT_BOTTOM_TO_RIGHT_TOP
 * @property {string} LT_TO_RB  LEFT_TOP_TO_RIGHT_BOTTOM
 * @property {string} RB_TO_LT  RIGHT_BOTTOM_TO_LEFT_TOP
 * @property {string} RT_TO_LB  RIGHT_TOP_TO_LEFT_BOTTOM
 */
var AlongLineDirection = exports.AlongLineDirection = _SuperMap2.default.AlongLineDirection = {
  NORMAL: "ALONG_LINE_NORMAL",
  LB_TO_RT: "LEFT_BOTTOM_TO_RIGHT_TOP",
  LT_TO_RB: "LEFT_TOP_TO_RIGHT_BOTTOM",
  RB_TO_LT: "RIGHT_BOTTOM_TO_LEFT_TOP",
  RT_TO_LB: "RIGHT_TOP_TO_LEFT_BOTTOM"
};

/**
 * @name LabelBackShape
 * @memberOf SuperMap
 * @description  标签专题图中标签背景的形状枚举。
 *
 * @property {string} DIAMOND  DIAMOND
 * @property {string} ELLIPSE  ELLIPSE
 * @property {string} MARKER  MARKER
 * @property {string} NONE  NONE
 * @property {string} RECT  RECT
 * @property {string} ROUNDRECT  ROUNDRECT
 * @property {string} TRIANGLE  TRIANGLE
 */
var LabelBackShape = exports.LabelBackShape = _SuperMap2.default.LabelBackShape = {
  DIAMOND: "DIAMOND",
  ELLIPSE: "ELLIPSE",
  MARKER: "MARKER",
  NONE: "NONE",
  RECT: "RECT",
  ROUNDRECT: "ROUNDRECT",
  TRIANGLE: "TRIANGLE"
};

/**
 * @name LabelOverLengthMode
 * @memberOf SuperMap
 * @description  标签专题图中超长标签的处理模式枚举。
 *
 * @property {string} NEWLINE  NEWLINE
 * @property {string} NONE  NONE
 * @property {string} OMIT  OMIT
 */
var LabelOverLengthMode = exports.LabelOverLengthMode = _SuperMap2.default.LabelOverLengthMode = {
  NEWLINE: "NEWLINE",
  NONE: "NONE",
  OMIT: "OMIT"
};

/**
 * @name DirectionType
 * @memberOf SuperMap
 * @description  网络分析中方向枚举。
 * 在行驶引导子项中使用。
 *
 * @property {string} EAST  EAST
 * @property {string} NONE  NONE
 * @property {string} NORTH  NORTH
 * @property {string} SOURTH  SOURTH
 * @property {string} WEST  WEST
 */
var DirectionType = exports.DirectionType = _SuperMap2.default.DirectionType = {
  EAST: "EAST",
  NONE: "NONE",
  NORTH: "NORTH",
  SOURTH: "SOURTH",
  WEST: "WEST"
};

/**
 * @name SideType
 * @memberOf SuperMap
 * @description  行驶位置枚举。
 * 表示在行驶在路的左边、右边或者路上的枚举,该类用在行驶导引子项类中。
 *
 * @property {string} LEFT  LEFT
 * @property {string} MIDDLE  MIDDLE
 * @property {string} NONE  NONE
 * @property {string} RIGHT  RIGHT
 */
var SideType = exports.SideType = _SuperMap2.default.SideType = {
  LEFT: "LEFT",
  MIDDLE: "MIDDLE",
  NONE: "NONE",
  RIGHT: "RIGHT"
};

/**
 * @name SupplyCenterType
 * @memberOf SuperMap
 * @description  资源供给中心类型枚举。
 * 该枚举定义了网络分析中资源中心点的类型，主要用于资源分配和选址分区。
 * 资源供给中心点的类型包括非中心，固定中心和可选中心。固定中心用于资源分配分析； 固定中心和可选中心用于选址分析；非中心在两种网络分析时都不予考虑。
 *
 * @property {string} FIXEDCENTER  FIXEDCENTER
 * @property {string} NULL  NULL
 * @property {string} OPTIONALCENTER  OPTIONALCENTER
 */
var SupplyCenterType = exports.SupplyCenterType = _SuperMap2.default.SupplyCenterType = {
  FIXEDCENTER: "FIXEDCENTER",
  NULL: "NULL",
  OPTIONALCENTER: "OPTIONALCENTER"
};

/**
 * @name TurnType
 * @memberOf SuperMap
 * @description  转弯方向枚举。
 * 用在行驶引导子项类中，表示转弯的方向。
 *
 * @property {string} AHEAD  AHEAD
 * @property {string} BACK  BACK
 * @property {string} END  END
 * @property {string} LEFT  LEFT
 * @property {string} NONE  NONE
 * @property {string} RIGHT  RIGHT
 */
var TurnType = exports.TurnType = _SuperMap2.default.TurnType = {
  AHEAD: "AHEAD",
  BACK: "BACK",
  END: "END",
  LEFT: "LEFT",
  NONE: "NONE",
  RIGHT: "RIGHT"
};

/**
 * @name BufferEndType
 * @memberOf SuperMap
 * @description  缓冲区分析BufferEnd类型。
 *
 * @property {string} FLAT  FLAT
 * @property {string} ROUND  ROUND
 */
var BufferEndType = exports.BufferEndType = _SuperMap2.default.BufferEndType = {
  FLAT: "FLAT",
  ROUND: "ROUND"
};

/**
 * @name OverlayOperationType
 * @memberOf SuperMap
 * @description  叠加分析类型枚举。
 *
 * @property {string} CLIP  CLIP
 * @property {string} ERASE  ERASE
 * @property {string} IDENTITY  IDENTITY
 * @property {string} INTERSECT  INTERSECT
 * @property {string} UNION  UNION
 * @property {string} UPDATE  UPDATE
 * @property {string} XOR  XOR
 */
var OverlayOperationType = exports.OverlayOperationType = _SuperMap2.default.OverlayOperationType = {
  CLIP: "CLIP",
  ERASE: "ERASE",
  IDENTITY: "IDENTITY",
  INTERSECT: "INTERSECT",
  UNION: "UNION",
  UPDATE: "UPDATE",
  XOR: "XOR"
};

/**
 * @name SmoothMethod
 * @memberOf SuperMap
 * @description  光滑方法枚举。
 * 用于从Grid 或DEM数据生成等值线或等值面时对等值线或者等值面的边界线进行平滑处理的方法。
 *
 * @property {string} BSPLINE  BSPLINE
 * @property {string} POLISH  POLISH
 */
var SmoothMethod = exports.SmoothMethod = _SuperMap2.default.SmoothMethod = {
  BSPLINE: "BSPLINE",
  POLISH: "POLISH"
};

/**
 * @name SurfaceAnalystMethod
 * @memberOf SuperMap
 * @description  表面分析方法枚举。
 * 通过对数据进行表面分析，能够挖掘原始数据所包含的信息，使某些细节明显化，易于分析。
 *
 * @property {string} ISOLINE  ISOLINE
 * @property {string} ISOREGION  ISOREGION
 */
var SurfaceAnalystMethod = exports.SurfaceAnalystMethod = _SuperMap2.default.SurfaceAnalystMethod = {
  ISOLINE: "ISOLINE",
  ISOREGION: "ISOREGION"
};
/**
 * @name DataReturnMode
 * @memberOf SuperMap
 * @description  数据返回模式枚举。
 * 该枚举用于指定空间分析返回结果模式,包含返回数据集标识和记录集、只返回数据集标识(数据集名称@数据源名称)及只返回记录集三种模式。
 *
 * @property {string} DATASET_AND_RECORDSET  DATASET_AND_RECORDSET
 * @property {string} DATASET_ONLY  DATASET_ONLY
 * @property {string} RECORDSET_ONLY  RECORDSET_ONLY
 */
var DataReturnMode = exports.DataReturnMode = _SuperMap2.default.DataReturnMode = {
  DATASET_AND_RECORDSET: "DATASET_AND_RECORDSET",
  DATASET_ONLY: "DATASET_ONLY",
  RECORDSET_ONLY: "RECORDSET_ONLY"
};

/**
 * @name EditType
 * @memberOf SuperMap
 * @description  要素集更新模式枚举。
 * 该枚举用于指定数据服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 *
 * @property {string} ADD  add
 * @property {string} UPDATE  update
 * @property {string} DELETE  delete
 */
var EditType = exports.EditType = _SuperMap2.default.EditType = {
  ADD: "add",
  UPDATE: "update",
  DELETE: "delete"
};

/**
 * @name TransferTactic
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定公交服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 *
 * @property {string} LESS_TIME  LESS_TIME
 * @property {string} LESS_TRANSFER  LESS_TRANSFER
 * @property {string} LESS_WALK  LESS_WALK
 * @property {string} MIN_DISTANCE  MIN_DISTANCE
 */
var TransferTactic = exports.TransferTactic = _SuperMap2.default.TransferTactic = {
  LESS_TIME: "LESS_TIME",
  LESS_TRANSFER: "LESS_TRANSFER",
  LESS_WALK: "LESS_WALK",
  MIN_DISTANCE: "MIN_DISTANCE"
};

/**
 * @name TransferPreference
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定交通换乘服务中设置地铁优先、公交优先、不乘地铁、无偏好等偏好设置。
 *
 * @property {string} BUS  BUS
 * @property {string} SUBWAY  SUBWAY
 * @property {string} NO_SUBWAY  NO_SUBWAY
 * @property {string} NONE  NONE
 */
var TransferPreference = exports.TransferPreference = _SuperMap2.default.TransferPreference = {
  BUS: "BUS",
  SUBWAY: "SUBWAY",
  NO_SUBWAY: "NO_SUBWAY",
  NONE: "NONE"
};

/**
 * @name GridType
 * @memberOf SuperMap
 * @description  地图背景格网类型枚举。
 *
 * @property {string} CROSS  CROSS
 * @property {string} GRID  GRID
 * @property {string} POINT  POINT
 */
var GridType = exports.GridType = _SuperMap2.default.GridType = {
  CROSS: "CROSS",
  GRID: "GRID",
  POINT: "POINT"
};

/**
 * @name ColorSpaceType
 * @memberOf SuperMap
 * @description  色彩空间枚举。
 * 由于成色原理的不同，决定了显示器、投影仪这类靠色光直接合成颜色的颜色设备和打印机、
 * 印刷机这类靠使用颜料的印刷设备在生成颜色方式上的区别。
 * 针对上述不同成色方式，SuperMap 提供两种色彩空间，
 * 分别为 RGB 和 CMYK。RGB 主要用于显示系统中，CMYK 主要用于印刷系统中。
 *
 * @property {string} CMYK  CMYK
 * @property {string} RGB  RGB
 */
var ColorSpaceType = exports.ColorSpaceType = _SuperMap2.default.ColorSpaceType = {
  CMYK: "CMYK",
  RGB: "RGB"
};

/**
 * @name LayerType
 * @memberOf SuperMap
 * @description  图层类型。
 *
 * @property {string} UGC  UGC
 * @property {string} WMS  WMS
 * @property {string} WFS  WFS
 * @property {string} CUSTOM  CUSTOM
 */
var LayerType = exports.LayerType = _SuperMap2.default.LayerType = {
  UGC: "UGC",
  WMS: "WMS",
  WFS: "WFS",
  CUSTOM: "CUSTOM"

};

/**
 * @name UGCLayerType
 * @memberOf SuperMap
 * @description  UGC图层类型。
 *
 * @property {string} THEME  THEME
 * @property {string} VECTOR  VECTOR
 * @property {string} GRID  GRID
 * @property {string} IMAGE  IMAGE
 */
var UGCLayerType = exports.UGCLayerType = _SuperMap2.default.UGCLayerType = {
  THEME: "THEME",
  VECTOR: "VECTOR",
  GRID: "GRID",
  IMAGE: "IMAGE"

};

/**
 * @name StatisticMode
 * @memberOf SuperMap
 * @description  字段统计方法类型。
 *
 * @property {string} AVERAGE  AVERAGE, 统计所选字段的平均值
 * @property {string} MAX  MAX, 统计所选字段的最大值
 * @property {string} MIN  MIN, 统计所选字段的最小值
 * @property {string} STDDEVIATION  STDDEVIATION, 统计所选字段的标准差
 * @property {string} SUM  SUM, 统计所选字段的总和
 * @property {string} VARIANCE  VARIANCE, 统计所选字段的方差
 */
var StatisticMode = exports.StatisticMode = _SuperMap2.default.StatisticMode = {
  AVERAGE: "AVERAGE",
  MAX: "MAX",
  MIN: "MIN",
  STDDEVIATION: "STDDEVIATION",
  SUM: "SUM",
  VARIANCE: "VARIANCE"
};

/**
 * @name PixelFormat
 * @memberOf SuperMap
 * @description  栅格与影像数据存储的像素格式枚举。
 *
 * @property {string} BIT16  BIT16, 每个像元用16个比特(即2个字节)表示
 * @property {string} BIT32  BIT32, 每个像元用32个比特(即4个字节)表示
 * @property {string} BIT64  BIT64, 每个像元用64个比特(即8个字节)表示，只提供给栅格数据集使用
 * @property {string} SINGLE  SINGLE, 每个像元用4个字节来表示，只提供给栅格数据集使用
 * @property {string} DOUBLE  DOUBLE, 每个像元用8个字节来表示，只提供给栅格数据集使用
 * @property {string} UBIT1  UBIT1, 每个像元用1个比特表示
 * @property {string} UBIT4  UBIT4, 每个像元用4个比特来表示
 * @property {string} UBIT8  UBIT8, 每个像元用8个比特(即1个字节)来表示
 * @property {string} UBIT24  UBIT24, 每个像元用24个比特(即3个字节)来表示
 * @property {string} UBIT32  UBIT32, 每个像元用32个比特(即4个字节)来表示
 */
var PixelFormat = exports.PixelFormat = _SuperMap2.default.PixelFormat = {
  BIT16: "BIT16",
  BIT32: "BIT32",
  BIT64: "BIT64",
  SINGLE: "SINGLE",
  DOUBLE: "DOUBLE",
  UBIT1: "UBIT1",
  UBIT4: "UBIT4",
  UBIT8: "UBIT8",
  UBIT24: "UBIT24",
  UBIT32: "UBIT32"
};

/**
 * @name SearchMode
 * @memberOf SuperMap
 * @description  内插时使用的样本点的查找方式枚举
 *
 * @property {string} KDTREE_FIXED_COUNT  KDTREE_FIXED_COUNT, 使用 KDTREE 的固定点数方式查找参与内插分析的点
 * @property {string} KDTREE_FIXED_RADIUS  KDTREE_FIXED_RADIUS, 使用 KDTREE 的定长方式查找参与内插分析的点
 * @property {string} NONE  NONE, 不进行查找，使用所有的输入点进行内插分析
 * @property {string} QUADTREE  QUADTREE, 使用 QUADTREE 方式查找参与内插分析的点，仅对样条（RBF）插值和普通克吕金（Kriging）有用
 */
var SearchMode = exports.SearchMode = _SuperMap2.default.SearchMode = {
  KDTREE_FIXED_COUNT: "KDTREE_FIXED_COUNT",
  KDTREE_FIXED_RADIUS: "KDTREE_FIXED_RADIUS",
  NONE: "NONE",
  QUADTREE: "QUADTREE"
};

/**
 * @name InterpolationAlgorithmType
 * @memberOf SuperMap
 * @description  插值分析的算法的类型
 *
 * @property {string} KRIGING  KRIGING, 普通克吕金插值法
 * @property {string} SimpleKriging  SimpleKriging, 简单克吕金插值法
 * @property {string} UniversalKriging  UniversalKriging, 泛克吕金插值法
 */
var InterpolationAlgorithmType = exports.InterpolationAlgorithmType = _SuperMap2.default.InterpolationAlgorithmType = {
  KRIGING: "KRIGING",
  SimpleKriging: "SimpleKriging",
  UniversalKriging: "UniversalKriging"
};

/**
 * @name VariogramMode
 * @memberOf SuperMap
 * @description  克吕金（Kriging）插值时的半变函数类型枚举
 *
 * @property {string} EXPONENTIAL  EXPONENTIAL, 指数函数（Exponential Variogram Mode）
 * @property {string} GAUSSIAN  GAUSSIAN,  高斯函数（Gaussian Variogram Mode）
 * @property {string} SPHERICAL  SPHERICAL, 球型函数（Spherical Variogram Mode）
 */
var VariogramMode = exports.VariogramMode = _SuperMap2.default.VariogramMode = {
  EXPONENTIAL: "EXPONENTIAL",
  GAUSSIAN: "GAUSSIAN",
  SPHERICAL: "SPHERICAL"
};

/**
 * @name Exponent
 * @memberOf SuperMap
 * @description  定义了泛克吕金（UniversalKriging）插值时样点数据中趋势面方程的阶数
 *
 * @property {string} EXP1  EXP1, 阶数为1
 * @property {string} EXP2  EXP2, 阶数为2
 */
var Exponent = exports.Exponent = _SuperMap2.default.Exponent = {
  EXP1: "EXP1",
  EXP2: "EXP2"
};

/**
 * @name ClientType
 * @memberOf SuperMap
 * @description token申请的客户端标识类型
 *
 * @property {string} IP  IP
 * @property {string} REFERER  Referer
 * @property {string} REQUESTIP  RequestIP
 * @property {string} NONE  NONE
 * @property {string} SERVER  SERVER
 * @property {string} WEB  WEB
 */
var ClientType = exports.ClientType = _SuperMap2.default.ClientType = {
  IP: "IP",
  REFERER: "Referer",
  REQUESTIP: "RequestIP",
  NONE: "NONE",
  SERVER: "SERVER",
  WEB: "WEB"
};

/**
 * @name ChartType
 * @memberOf SuperMap
 * @description 客户端专题图图表类型
 *
 * @property {string} BAR  Bar
 * @property {string} BAR3D  Bar3D
 * @property {string} CIRCLE  Circle
 * @property {string} PIE  Pie
 * @property {string} POINT  Point
 * @property {string} LINE  Line
 * @property {string} RING  Ring
 */
var ChartType = exports.ChartType = _SuperMap2.default.ChartType = {
  BAR: "Bar",
  BAR3D: "Bar3D",
  CIRCLE: "Circle",
  PIE: "Pie",
  POINT: "Point",
  LINE: "Line",
  RING: "Ring"
};

/**
 * @name ClipAnalystMode
 * @memberOf SuperMap
 * @description  裁剪分析模式
 *
 * @property {string} CLIP  clip
 * @property {string} INTERSECT  intersect
 */
var ClipAnalystMode = exports.ClipAnalystMode = _SuperMap2.default.ClipAnalystMode = {
  CLIP: "clip",
  INTERSECT: "intersect"
};
/**
 * @name AnalystAreaUnit
 * @memberOf SuperMap
 * @description 分布式分析面积单位
 *
 * @property {string} SQUAREMETER  SquareMeter
 * @property {string} SQUAREKILOMETER   SquareKiloMeter
 * @property {string} HECTARE  Hectare
 * @property {string} ARE   Are
 * @property {string} ACRE   Acre
 * @property {string} SQUAREFOOT   SquareFoot
 * @property {string} SQUAREYARD   SquareYard
 * @property {string} SQUAREMILE   SquareMile
 */
var AnalystAreaUnit = exports.AnalystAreaUnit = _SuperMap2.default.AnalystAreaUnit = {
  "SQUAREMETER": "SquareMeter",
  "SQUAREKILOMETER": "SquareKiloMeter",
  "HECTARE": "Hectare",
  "ARE": "Are",
  "ACRE": "Acre",
  "SQUAREFOOT": "SquareFoot",
  "SQUAREYARD": "SquareYard",
  "SQUAREMILE": "SquareMile"
};
/**
 * @name AnalystSizeUnit
 * @memberOf SuperMap
 * @description 分布式分析单位
 *
 * @property {string} METER   Meter
 * @property {string} KILOMETER   Kilometer
 * @property {string} YARD   Yard
 * @property {string} FOOT   Foot
 * @property {string} MILE   Mile
 */
var AnalystSizeUnit = exports.AnalystSizeUnit = _SuperMap2.default.AnalystSizeUnit = {
  "METER": "Meter",
  "KILOMETER": "Kilometer",
  "YARD": "Yard",
  "FOOT": "Foot",
  "MILE": "Mile"
};
/**
 * @name StatisticAnalystMode
 * @memberOf SuperMap
 * @description 分布式分析统计模式
 *
 * @property {string} MAX   max
 * @property {string} MIN   min
 * @property {string} AVERAGE   average
 * @property {string} SUM   sum
 * @property {string} VARIANCE   variance
 * @property {string} STDDEVIATION   stdDeviation
 */
var StatisticAnalystMode = exports.StatisticAnalystMode = _SuperMap2.default.StatisticAnalystMode = {
  "MAX": "max",
  "MIN": "min",
  "AVERAGE": "average",
  "SUM": "sum",
  "VARIANCE": "variance",
  "STDDEVIATION": "stdDeviation"
};
/**
 * @name SummaryType
 * @memberOf SuperMap
 * @description 分布式分析聚合类型
 *
 * @property {string} SUMMARYMESH   SUMMARYMESH
 * @property {string} SUMMARYREGION SUMMARYREGION
 */
var SummaryType = exports.SummaryType = _SuperMap2.default.SummaryType = {
  "SUMMARYMESH": "SUMMARYMESH",
  "SUMMARYREGION": "SUMMARYREGION"

};

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _FetchRequest = __webpack_require__(28);

__webpack_require__(133);

__webpack_require__(131);

__webpack_require__(249);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.CommonServiceBase
 * @classdesc 对接iServer各种服务的Service的基类。
 * @param url - {string} 服务地址。
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var CommonServiceBase = function () {
    function CommonServiceBase(url, options) {
        _classCallCheck(this, CommonServiceBase);

        this.EVENT_TYPES = ["processCompleted", "processFailed"];
        this.events = null;
        this.eventListeners = null;
        this.url = null;
        this.urls = null;
        this.serverType = null;
        this.index = null;
        this.length = null;
        this.options = null;
        this.totalTimes = null;
        this.POLLING_TIMES = 3;
        this._processSuccess = null;
        this._processFailed = null;
        this.isInTheSameDomain = null;
        this.CLASS_NAME = "SuperMap.CommonServiceBase";

        var me = this;

        if (_SuperMap2.default.Util.isArray(url)) {
            me.urls = url;
            me.length = url.length;
            me.totalTimes = me.length;
            if (me.length === 1) {
                me.url = url[0];
            } else {
                me.index = parseInt(Math.random() * me.length);
                me.url = url[me.index];
            }
        } else {
            me.totalTimes = 1;
            me.url = url;
        }

        if (_SuperMap2.default.Util.isArray(url) && !me.isServiceSupportPolling()) {
            me.url = url[0];
            me.totalTimes = 1;
        }

        me.serverType = me.serverType || _SuperMap2.default.ServerType.ISERVER;

        options = options || {};

        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }

        me.isInTheSameDomain = _SuperMap2.default.Util.isInTheSameDomain(me.url);

        me.events = new _SuperMap2.default.Events(me, null, me.EVENT_TYPES, true);
        if (me.eventListeners instanceof Object) {
            me.events.on(me.eventListeners);
        }
    }

    /**
     * @function SuperMap.CommonServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    _createClass(CommonServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (_SuperMap2.default.Util.isArray(me.urls)) {
                me.urls = null;
                me.index = null;
                me.length = null;
                me.totalTimes = null;
            }
            me.url = null;
            me.options = null;
            me._processSuccess = null;
            me._processFailed = null;
            me.isInTheSameDomain = null;

            me.EVENT_TYPES = null;
            if (me.events) {
                me.events.destroy();
                me.events = null;
            }
            if (me.eventListeners) {
                me.eventListeners = null;
            }
        }

        /**
         * @function  SuperMap.CommonServiceBase.prototype.request
         * @description: 该方法用于向服务发送请求。
         * @param options - {Object} 参数。
         *        method - {string} 请求方式，包括"GET"，"POST"，"PUT"，"DELETE"。<br>
         *        url - {string}  发送请求的地址。<br>
         *        params - {Object} 作为查询字符串添加到url中的一组键值对，此参数只适用于GET方式发送的请求。<br>
         *        data - {String } 发送到服务器的数据。<br>
         *        success - {function} 请求成功后的回调函数。<br>
         *        failure - {function} 请求失败后的回调函数。<br>
         *        scope - {Object} 如果回调函数是对象的一个公共方法，设定该对象的范围。<br>
         *        isInTheSameDomain - {boolean} 请求是否在当前域中。<br>
         */

    }, {
        key: 'request',
        value: function request(options) {
            var me = this;
            options.url = options.url || me.url;
            options.isInTheSameDomain = me.isInTheSameDomain;
            //为url添加安全认证信息片段
            var credential = this.getCredential(options.url);
            if (credential) {
                //当url中含有?，并且?在url末尾的时候直接添加token *网络分析等服务请求url会出现末尾是?的情况*
                //当url中含有?，并且?不在url末尾的时候添加&token
                //当url中不含有?，在url末尾添加?token
                var endStr = options.url.substring(options.url.length - 1, options.url.length);
                if (options.url.indexOf("?") > -1 && endStr === "?") {
                    options.url += credential.getUrlParameters();
                } else if (options.url.indexOf("?") > -1 && endStr !== "?") {
                    options.url += "&" + credential.getUrlParameters();
                } else {
                    options.url += "?" + credential.getUrlParameters();
                }
            }
            me.calculatePollingTimes();
            me._processSuccess = options.success;
            me._processFailed = options.failure;
            options.scope = me;
            options.success = me.getUrlCompleted;
            options.failure = me.getUrlFailed;
            me.options = options;
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getCredential
         * @description  获取凭据信息
         * @param url - {string} 服务地址。
         * @return {SuperMap.Credential} 凭据信息对象。
         */

    }, {
        key: 'getCredential',
        value: function getCredential(url) {
            var keyUrl = url,
                credential = void 0,
                value = void 0;
            switch (this.serverType) {
                case _SuperMap2.default.ServerType.ISERVER:
                    value = _SuperMap2.default.SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2.default.Credential(value, "token") : null;
                    break;
                case _SuperMap2.default.ServerType.IPORTAL:
                    value = _SuperMap2.default.SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2.default.Credential(value, "token") : null;
                    if (!credential) {
                        value = _SuperMap2.default.SecurityManager.getKey(keyUrl);
                        credential = value ? new _SuperMap2.default.Credential(value, "key") : null;
                    }
                    break;
                case _SuperMap2.default.ServerType.ONLINE:
                    value = _SuperMap2.default.SecurityManager.getKey(keyUrl);
                    credential = value ? new _SuperMap2.default.Credential(value, "key") : null;
                    break;
                default:
                    value = _SuperMap2.default.SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2.default.Credential(value, "token") : null;
                    break;
            }
            return credential;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlCompleted
         * @description 请求成功后执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlCompleted',
        value: function getUrlCompleted(result) {
            var me = this;
            me._processSuccess(result);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlFailed
         * @description 请求失败后执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlFailed',
        value: function getUrlFailed(result) {
            var me = this;
            if (me.totalTimes > 0) {
                me.totalTimes--;
                me.ajaxPolling();
            } else {
                me._processFailed(result);
            }
        }

        /**
         *
         * @function SuperMap.CommonServiceBase.prototype.ajaxPolling
         * @description 请求失败后，如果剩余请求失败次数不为0，重新获取url发送请求
         */

    }, {
        key: 'ajaxPolling',
        value: function ajaxPolling() {
            var me = this,
                url = me.options.url,
                re = /^http:\/\/([a-z]{9}|(\d+\.){3}\d+):\d{0,4}/;
            me.index = parseInt(Math.random() * me.length);
            me.url = me.urls[me.index];
            url = url.replace(re, re.exec(me.url)[0]);
            me.options.url = url;
            me.options.isInTheSameDomain = _SuperMap2.default.Util.isInTheSameDomain(url);
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.calculatePollingTimes
         * @description 计算剩余请求失败执行次数。
         */

    }, {
        key: 'calculatePollingTimes',
        value: function calculatePollingTimes() {
            var me = this;
            if (me.times) {
                if (me.totalTimes > me.POLLING_TIMES) {
                    if (me.times > me.POLLING_TIMES) {
                        me.totalTimes = me.POLLING_TIMES;
                    } else {
                        me.totalTimes = me.times;
                    }
                } else {
                    if (me.times < me.totalTimes) {
                        me.totalTimes = me.times;
                    }
                }
            } else {
                if (me.totalTimes > me.POLLING_TIMES) {
                    me.totalTimes = me.POLLING_TIMES;
                }
            }
            me.totalTimes--;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.isServiceSupportPolling
         * @description 判断服务是否支持轮询。
         */

    }, {
        key: 'isServiceSupportPolling',
        value: function isServiceSupportPolling() {
            var me = this;
            return !(me.CLASS_NAME === "SuperMap.REST.ThemeService" || me.CLASS_NAME === "SuperMap.REST.EditFeaturesService");
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessCompleted
         * @description 状态完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            result = _SuperMap2.default.Util.transformResult(result);
            this.events.triggerEvent("processCompleted", { result: result });
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessFailed
         * @description 状态失败，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            result = _SuperMap2.default.Util.transformResult(result);
            var error = result.error || result;
            this.events.triggerEvent("processFailed", { error: error });
        }
    }, {
        key: '_commit',
        value: function _commit(options) {
            if (options.method === "POST" || options.method === "PUT") {
                if (options.params) {
                    options.url = _SuperMap2.default.Util.urlAppend(options.url, _SuperMap2.default.Util.getParameterString(options.params || {}));
                }
                options.params = options.data;
            }
            _FetchRequest.FetchRequest.commit(options.method, options.url, options.params, {
                headers: options.headers,
                withCredentials: options.withCredentials,
                timeout: options.async ? 0 : null,
                proxy: options.proxy
            }).then(function (response) {
                return response.text();
            }).then(function (text) {
                var result = new _SuperMap2.default.Format.JSON().read(text);
                if (!result) {
                    result = { error: text };
                }
                if (result.error) {
                    var failure = options.scope ? _SuperMap2.default.Function.bind(options.failure, options.scope) : options.failure;
                    failure(result.error);
                } else {
                    result.succeed = result.succeed == undefined ? true : result.succeed;
                    var success = options.scope ? _SuperMap2.default.Function.bind(options.success, options.scope) : options.success;
                    success(result);
                }
            });
        }
    }]);

    return CommonServiceBase;
}();

exports.default = CommonServiceBase;


_SuperMap2.default.CommonServiceBase = CommonServiceBase;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SpatialAnalystBase
 * @classdesc 空间分析服务基类。
 * @param url -{string} 地址d。
 * @param options -{Object} 参数。
 * @extends SuperMap.CommonServiceBase
 */
var SpatialAnalystBase = function (_CommonServiceBase) {
    _inherits(SpatialAnalystBase, _CommonServiceBase);

    function SpatialAnalystBase(url, options) {
        _classCallCheck(this, SpatialAnalystBase);

        var _this = _possibleConstructorReturn(this, (SpatialAnalystBase.__proto__ || Object.getPrototypeOf(SpatialAnalystBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.SpatialAnalystBase";

        if (options && options.format) {
            _this.format = options.format.toUpperCase();
        }
        return _this;
    }

    /**
     * @function SuperMap.SpatialAnalystBase.prototype.destroy
     * @override
     */

    /**
     * @member SuperMap.SpatialAnalystBase.prototype.format -{string}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式，参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    _createClass(SpatialAnalystBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(SpatialAnalystBase.prototype.__proto__ || Object.getPrototypeOf(SpatialAnalystBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                analystResult = me.toGeoJSONResult(result);
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         *
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            if (result.recordsets) {
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        recordsets[i].features = JSON.parse(geoJSONFormat.write(recordsets[i].features));
                    }
                }
            } else if (result.recordset && result.recordset.features) {
                result.recordset.features = JSON.parse(geoJSONFormat.write(result.recordset.features));
            }
            if (result.resultGeometry) {
                result.resultGeometry = JSON.parse(geoJSONFormat.write(result.resultGeometry));
            }

            return result;
        }
    }]);

    return SpatialAnalystBase;
}(_CommonServiceBase3.default);

exports.default = SpatialAnalystBase;

_SuperMap2.default.SpatialAnalystBase = SpatialAnalystBase;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _JSON = __webpack_require__(140);

var _JSON2 = _interopRequireDefault(_JSON);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _MultiPoint = __webpack_require__(30);

var _MultiPoint2 = _interopRequireDefault(_MultiPoint);

var _LineString = __webpack_require__(18);

var _LineString2 = _interopRequireDefault(_LineString);

var _MultiLineString = __webpack_require__(42);

var _MultiLineString2 = _interopRequireDefault(_MultiLineString);

var _LinearRing = __webpack_require__(25);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _Polygon = __webpack_require__(31);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _MultiPolygon = __webpack_require__(43);

var _MultiPolygon2 = _interopRequireDefault(_MultiPolygon);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Format.GeoJSON
 * @classdesc  GeoJSON 的读和写。使用 <SuperMap.Format.GeoJSON> 构造器创建一个GeoJSON解析器。
 * @extends SuperMap.Format.JSON。
 */
var GeoJSON = function (_JSONFormat) {
    _inherits(GeoJSON, _JSONFormat);

    function GeoJSON() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, GeoJSON);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = GeoJSON.__proto__ || Object.getPrototypeOf(GeoJSON)).call.apply(_ref, [this].concat(args))), _this), _this.ignoreExtraDims = false, _this.parseCoords = {
            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.point
             * @description 将一组坐标成一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的一组坐标。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "point": function point(array) {
                if (this.ignoreExtraDims == false && array.length != 2) {
                    throw "Only 2D points are supported: " + array;
                }
                return new _Point2.default(array[0], array[1]);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipoint
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multipoint": function multipoint(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _MultiPoint2.default(points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.linestring
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "linestring": function linestring(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _LineString2.default(points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multilinestring
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multilinestring": function multilinestring(array) {
                var lines = [];
                var l = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    lines.push(l);
                }
                return new _MultiLineString2.default(lines);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.polygon
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "polygon": function polygon(array) {
                var rings = [];
                var r, l;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    r = new _LinearRing2.default(l.components);
                    rings.push(r);
                }
                return new _Polygon2.default(rings);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipolygon
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multipolygon": function multipolygon(array) {
                var polys = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["polygon"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    polys.push(p);
                }
                return new _MultiPolygon2.default(polys);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.box
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "box": function box(array) {
                if (array.length != 2) {
                    throw "GeoJSON box coordinates must have 2 elements";
                }
                return new _Polygon2.default([new _LinearRing2.default([new _Point2.default(array[0][0], array[0][1]), new _Point2.default(array[1][0], array[0][1]), new _Point2.default(array[1][0], array[1][1]), new _Point2.default(array[0][0], array[1][1]), new _Point2.default(array[0][0], array[0][1])])]);
            }

        }, _this.extract = {
            /**
             * @function SuperMap.Format.GeoJSON.extract.feature
             * @description 返回一个表示单个要素对象的GeoJSON的一部分。
             * @param feature - iServer要素对象
             * @return {Object} 一个表示点的对象。
             */
            'feature': function feature(_feature) {
                var geom = this.extract.geometry.apply(this, [_feature.geometry]);
                var json = {
                    "type": "Feature",
                    "properties": this.createAttributes(_feature),
                    "geometry": geom
                };

                if (_feature.geometry && _feature.geometry.type === 'TEXT') {
                    json.properties.texts = _feature.geometry.texts;
                    json.properties.textStyle = _feature.geometry.textStyle;
                }
                if (_feature.fid !== null) {
                    json.id = _feature.fid;
                }
                if (_feature.ID !== null) {
                    json.id = _feature.ID;
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.geometry
             * @description 返回一个表示单个几何对象的GeoJSON的一部分。
             * @param geometry -iServer 几何对象
             * @return {Object} 一个表示几何体的对象。
             */
            'geometry': function geometry(_geometry) {
                if (_geometry == null) {
                    return null;
                }
                var geo = this.toGeometry(_geometry);
                var geometryType = geo.type;
                var data = this.extract[geometryType.toLowerCase()].apply(this, [geo]);
                geometryType = geometryType === 'TEXT' ? 'Point' : geometryType;
                var json;
                if (geometryType === "Collection") {
                    json = {
                        "type": "GeometryCollection",
                        "geometries": data
                    };
                } else {
                    json = {
                        "type": geometryType,
                        "coordinates": data
                    };
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个点对象中返回一个坐标组。
             * @param point - {SuperMap.Geometry.Point} 一个点对象。
             * @return {Array} 一个表示一个点的坐标组。
             */
            'point': function point(_point) {
                var p = [_point.x, _point.y];
                for (var name in _point) {
                    if (name !== "x" && name !== "y" && !isNaN(_point[name])) {
                        p.push(_point[name]);
                    }
                }
                return p;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个文本对象中返回一个坐标组。
             * @param geo 一个文本对象。
             * @return {Array} 一个表示一个点的坐标组。
             */
            'text': function text(geo) {
                return [geo.points[0].x, geo.points[0].y];
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipoint
             * @description 从一个多点对象中返一个坐标组数组。
             * @param multipoint - {SuperMap.Geometry.MultiPoint} 多点对象。
             * @return {Array} 一个表示多点的坐标组数组。
             */
            'multipoint': function multipoint(_multipoint) {
                var array = [];
                for (var i = 0, len = _multipoint.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_multipoint.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.linestring
             * @description 从一个线对象中返回一个坐标组数组。
             * @param linestring - {SuperMap.Geometry.Linestring} 线对象。
             * @return {Array} 一个表示线对象的坐标组数组。
             */
            'linestring': function linestring(_linestring) {
                var array = [];
                for (var i = 0, len = _linestring.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_linestring.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multilinestring
             * @description 从一个多线对象中返回一个线数组。
             * @param multilinestring - {SuperMap.Geometry.MultiLinestring} 多线对象
             *
             * @return {Array} 一个表示多线的线数组。
             */
            'multilinestring': function multilinestring(_multilinestring) {
                var array = [];
                for (var i = 0, len = _multilinestring.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [{ components: _multilinestring.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.polygon
             * @description 从一个面对象中返回一组线环。
             * @polygon - {SuperMap.Geometry.Polygon} 面对象。
             * @return {Array} 一组表示面的线环。
             */
            'polygon': function polygon(_polygon) {
                var array = [];
                for (var i = 0, len = _polygon.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [{ components: _polygon.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipolygon
             * @description 从一个多面对象中返回一组面。
             * @param multipolygon - {SuperMap.Geometry.MultiPolygon} 多面对象。
             * @return {Array} 一组表示多面的面。
             */
            'multipolygon': function multipolygon(_multipolygon) {
                var array = [];
                for (var i = 0, len = _multipolygon.components.length; i < len; ++i) {
                    array.push(this.extract.polygon.apply(this, [{ components: _multipolygon.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.collection
             * @description 从一个几何要素集合中一组几何要素数组。
             * @param collection - {SuperMap.Geometry.Collection} 几何要素集合。
             * @return {Array} 一组表示几何要素集合的几何要素数组。
             */
            'collection': function collection(_collection) {
                var len = _collection.components.length;
                var array = new Array(len);
                for (var i = 0; i < len; ++i) {
                    array[i] = this.extract.geometry.apply(this, [{
                        type: "Collection",
                        components: _collection.components[i]
                    }]);
                }
                return array;
            }
        }, _this.CLASS_NAME = "SuperMap.Format.GeoJSON", _temp), _possibleConstructorReturn(_this, _ret);
    }

    /**
     * @member SuperMap.Format.GeoJSON.prototype.ignoreExtraDims - {boolean}
     * @description 忽略维度超过2的几何要素。
     */


    _createClass(GeoJSON, [{
        key: 'read',


        /**
         * @function SuperMap.Format.GeoJSON.prototype.read
         * @description 反序列化一个 GeoJSON 字符串。
         * @param json - {string}  GeoJSON 字符串
         * @param type - {string} 可选的字符串，它决定了输出的格式。
         *     支持的值有："Geometry","Feature",和"FeatureCollection",
         *     如果此值为null，则会使用默认值"FeaureCollection"。
         * @param filter - {function} 对象中每个层次每个键值对都会调用此函数得出一个结果。
         *     每个值都会被filter函数的结果所替换掉。这个函数可被用来将某些对象转化成
         *     某个类相应的对象，或者将日期字符串转化成Date对象。
         *
         * @return {Object}
         *    返回值依赖于type参数的值。如果type等于"FeatureCollection"（默认值），
         *     返回值将会是 <SuperMap.Feature.Vector> 数组。如果type为"Geometry",
         *     输入的json对象必须表示一个唯一的几何体，然后返回值就会是 <SuperMap.Feature.Geometry>
         *     如果type为"Feature"，输入的json对象也必须表示的一个要素，这样返回值才会是<SuperMap.Feature.Vector> 。
         */
        value: function read(json, type, filter) {
            type = type ? type : "FeatureCollection";
            var results = null;
            var obj = null;
            if (typeof json == "string") {
                obj = _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'read', this).call(this, json, filter);
            } else {
                obj = json;
            }
            if (!obj) {
                //SuperMap.Console.error("Bad JSON: " + json);
            } else if (typeof obj.type != "string") {
                //SuperMap.Console.error("Bad GeoJSON - no type: " + json);
            } else if (this.isValidType(obj, type)) {
                switch (type) {
                    case "Geometry":
                        try {
                            results = this.parseGeometry(obj);
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "Feature":
                        try {
                            results = this.parseFeature(obj);
                            results.type = "Feature";
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "FeatureCollection":
                        // for type FeatureCollection, we allow input to be any type
                        results = [];
                        switch (obj.type) {
                            case "Feature":
                                try {
                                    results.push(this.parseFeature(obj));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                                break;
                            case "FeatureCollection":
                                for (var i = 0, len = obj.features.length; i < len; ++i) {
                                    try {
                                        results.push(this.parseFeature(obj.features[i]));
                                    } catch (err) {
                                        results = null;
                                        // SuperMap.Console.error(err);
                                    }
                                }
                                break;
                            default:
                                try {
                                    var geom = this.parseGeometry(obj);
                                    results.push(new _SuperMap2.default.Feature.Vector(geom));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                        }
                        break;
                    default:
                        break;
                }
            }
            return results;
        }

        /**
         *  @function SuperMap.Format.GeoJSON.prototype.isValidType
         *  @description 检查一个GeoJSON对象是否和给定的类型相符的合法的对象。
         *  @return {boolean} GeoJSON是否是给定类型的合法对象。
         */

    }, {
        key: 'isValidType',
        value: function isValidType(obj, type) {
            var valid = false;
            switch (type) {
                case "Geometry":
                    if (_SuperMap2.default.Util.indexOf(["Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon", "Box", "GeometryCollection"], obj.type) == -1) {
                        // unsupported geometry type
                        //SuperMap.Console.error("Unsupported geometry type: " +
                        // obj.type);
                    } else {
                        valid = true;
                    }
                    break;
                case "FeatureCollection":
                    // allow for any type to be converted to a feature collection
                    valid = true;
                    break;
                default:
                    // for Feature types must match
                    if (obj.type == type) {
                        valid = true;
                    } else {
                        //SuperMap.Console.error("Cannot convert types from " +
                        //obj.type + " to " + type);
                    }
            }
            return valid;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseFeature
         * @description 将一个GeoJSON中的feature转化成<SuperMap.Feature.Vector>对象。
         * @param obj - {Object} 从GeoJSON对象中创建一个对象。
         * @return {SuperMap.Feature.Vector} 一个要素。
         */

    }, {
        key: 'parseFeature',
        value: function parseFeature(obj) {
            var feature, geometry, attributes, bbox;
            attributes = obj.properties ? obj.properties : {};
            bbox = obj.geometry && obj.geometry.bbox || obj.bbox;
            try {
                geometry = this.parseGeometry(obj.geometry);
            } catch (err) {
                // deal with bad geometries
                throw err;
            }
            feature = new _SuperMap2.default.Feature.Vector(geometry, attributes);
            if (bbox) {
                feature.bounds = _SuperMap2.default.Bounds.fromArray(bbox);
            }
            if (obj.id) {
                feature.fid = obj.id;
            }
            return feature;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseGeometry
         * @description 将一个GeoJSON中的几何要素转化成<SuperMap.Geometry>对象。
         * @param obj - {Object} 从GeoJSON对象中创建一个对象。
         * @return {SuperMap.Geometry} 一个几何要素。
         */

    }, {
        key: 'parseGeometry',
        value: function parseGeometry(obj) {
            if (obj == null) {
                return null;
            }
            var geometry,
                collection = false;
            if (obj.type == "GeometryCollection") {
                if (!_SuperMap2.default.Util.isArray(obj.geometries)) {
                    throw "GeometryCollection must have geometries array: " + obj;
                }
                var numGeom = obj.geometries.length;
                var components = new Array(numGeom);
                for (var i = 0; i < numGeom; ++i) {
                    components[i] = this.parseGeometry.apply(this, [obj.geometries[i]]);
                }
                geometry = new _SuperMap2.default.Geometry.Collection(components);
                collection = true;
            } else {
                if (!_SuperMap2.default.Util.isArray(obj.coordinates)) {
                    throw "Geometry must have coordinates array: " + obj;
                }
                if (!this.parseCoords[obj.type.toLowerCase()]) {
                    throw "Unsupported geometry type: " + obj.type;
                }
                try {
                    geometry = this.parseCoords[obj.type.toLowerCase()].apply(this, [obj.coordinates]);
                } catch (err) {
                    // deal with bad coordinates
                    throw err;
                }
            }
            return geometry;
        }

        /**
         * @member SuperMap.Format.GeoJSON.prototype.parseCoords - {Object}
         * @description 一个属性名对应着GeoJSON对象的几何类型的对象。每个属性其实都是一个实际上做解析用的方法。
         */

    }, {
        key: 'write',


        /**
         * @function SuperMap.Format.GeoJSON.write
         * @description 序列化一个要素对象，几何对象，要素对象数组为一个GeoJSON字符串。
         * @param obj - {Object} 一个 <SuperMap.Feature.Vector> 对象，一个 <SuperMap.Geometry> 对象或者一个要素对象数组。
         * @param pretty - {boolean} 是否使用换行和缩进来控制输出。默认值为false。
         * @return {string} 一个GeoJSON字符串，它表示了输入的几何对象，要素对象，或者要素对象数组。
         */
        value: function write(obj, pretty) {
            var geojson = {
                "type": null
            };
            if (_SuperMap2.default.Util.isArray(obj)) {
                geojson.type = "FeatureCollection";
                var numFeatures = obj.length;
                geojson.features = new Array(numFeatures);
                for (var i = 0; i < numFeatures; ++i) {
                    var element = obj[i];
                    if (isGeometry(element)) {
                        var feature = {};
                        feature.geometry = element;
                        geojson.features[i] = this.extract.feature.apply(this, [feature]);
                    } else {
                        geojson.features[i] = this.extract.feature.apply(this, [element]);
                    }
                }
            } else if (isGeometry(obj)) {
                var feature = {};
                feature.geometry = obj;
                geojson = this.extract.feature.apply(this, [feature]);
            }

            function isGeometry(input) {
                return input.hasOwnProperty("parts") && input.hasOwnProperty("points");
            }

            return _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'write', this).call(this, geojson, pretty);
        }

        /**
         * @function SuperMap.Format.GeoJSON.createCRSObject
         * @description 从一个要素对象中创建一个坐标参考系对象。
         * @param object - {SuperMap.Feature.Vector} 要素对象
         * @return {Object} 一个可作为GeoJSON对象的crs属性使用的对象。
         */

    }, {
        key: 'createCRSObject',
        value: function createCRSObject(object) {
            var proj = object.layer.projection.toString();
            var crs = {};
            if (proj.match(/epsg:/i)) {
                var code = parseInt(proj.substring(proj.indexOf(":") + 1));
                if (code == 4326) {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
                        }
                    };
                } else {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "EPSG:" + code
                        }
                    };
                }
            }
            return crs;
        }

        /**
         * Property: extract
         * 一个属性名对应着GeoJSON类型的对象。其值为相应的实际的解析方法。
         */

    }, {
        key: 'createAttributes',
        value: function createAttributes(feature) {
            if (!feature) {
                return null;
            }
            var attr = {};
            processFieldsAttributes(feature, attr);
            var exceptKeys = ["fieldNames", "fieldValues", "geometry"];
            for (var key in feature) {
                if (exceptKeys.indexOf(key) > -1) {
                    continue;
                }
                attr[key] = feature[key];
            }

            function processFieldsAttributes(feature, attributes) {
                if (!(feature.hasOwnProperty("fieldNames") && feature.hasOwnProperty("fieldValues"))) {
                    return;
                }
                var names = feature.fieldNames,
                    values = feature.fieldValues;
                for (var i in names) {
                    attributes[names[i]] = values[i];
                }
            }

            return attr;
        }
    }, {
        key: 'toGeometry',
        value: function toGeometry(geometry) {
            var me = this,
                geoType = geometry.type;
            if (geoType === 'polygon') {
                geoType = _REST.GeometryType.REGION;
            }
            switch (geoType.toUpperCase()) {
                case _REST.GeometryType.POINT:
                    return me.toGeoPoint(geometry);
                case _REST.GeometryType.LINE:
                    return me.toGeoLine(geometry);
                case _REST.GeometryType.LINEM:
                    return me.toGeoLinem(geometry);
                case _REST.GeometryType.REGION:
                    return me.toGeoRegion(geometry);
                case _REST.GeometryType.POINTEPS:
                    return me.toGeoPoint(geometry);
                // case GeometryType.LINEEPS:
                //     return me.toGeoLineEPS();
                // case GeometryType.REGIONEPS:
                //     return me.toGeoRegionEPS();
                default:
                    return geometry;
            }
        }

        /**
         * @function SuperMap.Format.GeoJSON.toGeoPoint
         * @description 将服务端的点几何对象转换为几何对象
         */

    }, {
        key: 'toGeoPoint',
        value: function toGeoPoint(geometry) {
            var geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            if (len === 1) {
                return { type: "Point", x: parseFloat(geoPoints[0].x), y: parseFloat(geoPoints[0].y) };
            } else {
                for (var i = 0, pointList = []; i < len; i++) {
                    pointList.push({ x: parseFloat(geoPoints[i].x), y: parseFloat(geoPoints[i].y) });
                }
                return { type: "MultiPoint", components: pointList };
            }
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoPoint
         * @description 将服务端的线几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoLine',
        value: function toGeoLine(geometry) {
            var me = this,
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            if (len === 1) {
                for (var i = 0, pointList = []; i < geoParts[0]; i++) {
                    pointList.push({ x: parseFloat(geoPoints[i].x), y: parseFloat(geoPoints[i].y) });
                }
                //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                if (me.isPointsEquals(pointList[0], pointList[geoParts[0] - 1])) {
                    pointList.pop();
                    pointList.push(pointList[0]);
                }
                return { type: "LineString", components: pointList };
            } else {
                for (var k = 0, lineList = []; k < len; k++) {
                    for (var j = 0, pointArr = []; j < geoParts[k]; j++) {
                        pointArr.push({ x: parseFloat(geoPoints[j].x), y: parseFloat(geoPoints[j].y) });
                    }
                    lineList.push(pointArr);
                    geoPoints.splice(0, geoParts[k]);
                }
                return { type: "MultiLineString", components: lineList };
            }
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoLinem
         * @description 将服务端的路由线几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoLinem',
        value: function toGeoLinem(geometry) {
            var me = this,
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length,
                lineList = [],
                type;
            if (len < 1) {
                return null;
            }
            for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                for (var j = 0; j < geoParts[i]; j++) {
                    pointList.push({
                        x: parseFloat(geoPoints[pointIndex + j].x),
                        y: parseFloat(geoPoints[pointIndex + j].y),
                        measure: parseFloat(geoPoints[pointIndex + j].measure)
                    });
                }
                pointIndex += geoParts[i];
                //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                if (me.isPointsEquals(pointList[0], pointList[geoParts[0] - 1])) {
                    pointList.pop();
                    pointList.push(pointList[0]);
                }
                lineList.push(pointList);
                pointList = [];
            }
            return { type: "MultiLineString", components: lineList };
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoRegion
         * @description 将服务端的面几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoRegion',
        value: function toGeoRegion(geometry) {
            var CCWArray = [],
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            var polygonArray = new Array();
            for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                for (var j = 0; j < geoParts[i]; j++) {
                    pointList.push({
                        x: parseFloat(geoPoints[pointIndex + j].x),
                        y: parseFloat(geoPoints[pointIndex + j].y)
                    });
                }

                pointIndex += geoParts[i];
                var linearRing = pointList.concat();
                linearRing.pop();
                linearRing.push(linearRing[0]);

                if (this.isClockWise(linearRing) > 0) {
                    CCWArray.push(linearRing);
                } else {
                    polygonArray.push([linearRing]);
                }

                if (i === len - 1) {
                    var polyLength = polygonArray.length;
                    if (!!polyLength) {
                        polygonArray[polyLength - 1] = polygonArray[polyLength - 1].concat(CCWArray);
                    } else {
                        for (var k = 0, length = CCWArray.length; k < length; k++) {
                            polygonArray.push([CCWArray[k]].concat());
                        }
                    }
                }
                pointList = [];
            }
            return { type: "MultiPolygon", components: polygonArray };
        }
    }, {
        key: 'isClockWise',
        value: function isClockWise(points) {
            var length = points.length;
            if (length < 3) {
                return 0.0;
            }
            var s = points[0].y * (points[length - 1].x - points[1].x);
            points.push(points[0]);
            for (var i = 1; i < length; i++) {
                s += points[i].y * (points[i - 1].x - points[i + 1].x);
            }
            return s * 0.5;
        }
    }, {
        key: 'isPointsEquals',
        value: function isPointsEquals(point1, point2) {
            return point1.x === point2.x && point1.y === point2.y;
        }
    }]);

    return GeoJSON;
}(_JSON2.default);

exports.default = GeoJSON;

_SuperMap2.default.Format.GeoJSON = GeoJSON;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Bounds = __webpack_require__(39);

var _Bounds2 = _interopRequireDefault(_Bounds);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _MultiPoint = __webpack_require__(30);

var _MultiPoint2 = _interopRequireDefault(_MultiPoint);

var _LinearRing = __webpack_require__(25);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _LineString = __webpack_require__(18);

var _LineString2 = _interopRequireDefault(_LineString);

var _MultiLineString = __webpack_require__(42);

var _MultiLineString2 = _interopRequireDefault(_MultiLineString);

var _Polygon = __webpack_require__(31);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _MultiPolygon = __webpack_require__(43);

var _MultiPolygon2 = _interopRequireDefault(_MultiPolygon);

var _ServerStyle = __webpack_require__(6);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

var _Route = __webpack_require__(34);

var _Route2 = _interopRequireDefault(_Route);

var _Util = __webpack_require__(7);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class SuperMap.ServerGeometry
 * @description 服务端几何对象类。
 * 该类描述几何对象（矢量）的特征数据（坐标点对、几何对象的类型等）。
 * 基于服务端的空间分析、空间关系运算、查询等 GIS 服务功能使用服务端几何对象。
 */
var ServerGeometry = function () {

  /*
     * Constructor: SuperMap.ServerGeometry
     * 服务端几何对象类构造函数。
     *
     * Parameters:
     * options - {Object} 参数。
     *
     * Allowed options properties:
     * id - {String} 服务端几何对象唯一标识符。
     * style - {<SuperMap.ServerStyle>}  服务端几何对象的风格。
     * parts - {Array(Number)} 服务端几何对象中各个子对象所包含的节点个数。
     * points - {Array(<Point>)} 组成几何对象的节点的坐标对数组。
     * type - {<SuperMap.GeometryType>} 几何对象的类型。
     */

  /*
     * APIProperty: type
     * {<SuperMap.GeometryType>} 几何对象的类型(GeometryType)。
     */

  /*
     * APIProperty: parts
     * {Array(Number)} 服务端几何对象中各个子对象所包含的节点个数。
     * 1.几何对象从结构上可以分为简单几何对象和复杂几何对象。
     * 简单几何对象与复杂几何对象的区别：简单的几何对象一般为单一对象，
     * 而复杂的几何对象由多个简单对象组成或经过一定的空间运算之后产生，
     * 如：矩形为简单的区域对象，而中空的矩形为复杂的区域对象。
     * 2.通常情况，一个简单几何对象的子对象就是它本身，
     * 因此对于简单对象来说的该字段为长度为1的整型数组，
     * 该字段的值就是这个简单对象节点的个数。
     * 如果一个几何对象是由几个简单对象组合而成的，
     * 例如，一个岛状几何对象由3个简单的多边形组成而成，
     * 那么这个岛状的几何对象的 Parts 字段值就是一个长度为3的整型数组，
     * 数组中每个成员的值分别代表这三个多边形所包含的节点个数。
     */


  /*
     * APIProperty: id
     * {String} 服务端几何对象唯一标识符。
     */
  function ServerGeometry(options) {
    _classCallCheck(this, ServerGeometry);

    this.id = 0;
    this.style = null;
    this.parts = null;
    this.points = null;
    this.type = null;
    this.prjCoordSys = null;
    this.CLASS_NAME = "SuperMap.ServerGeometry";

    if (options) {
      _Util.Util.extend(this, options);
    }
  }

  /*
     * APIMethod: destroy
     * 释放资源，将引用资源的属性置空。
     */

  /*
     * APIProperty: prjCoordSys
     * {Object}投影坐标参数,现仅在缓冲区分析中有效。
     */

  /*
     * APIProperty: points
     * {Array(<Point>)} 组成几何对象的节点的坐标对数组。
     * 1.所有几何对象（点、线、面）都是由一些简单的点坐标组成的，
     * 该字段存放了组成几何对象的点坐标的数组。
     * 对于简单的面对象，他的起点和终点的坐标点相同。
     * 2.对于复杂的几何对象，根据 Parts 属性来确定每一个组成复杂几何对象的简单对象所对应的节点的个数，
     * 从而确定 Points 字段中坐标对的分配归属问题。
     */


  /*
     * APIProperty: style
     * {<SuperMap.ServerStyle>} 服务端几何对象的风格(ServerStyle)。
     */


  _createClass(ServerGeometry, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.id = null;
      me.style = null;
      me.parts = null;
      me.partTopo = null;
      me.points = null;
      me.type = null;
      me.prjCoordSys = null;
    }

    /*
     * APIMethod: toGeometry
     * 将服务端几何对象 ServerGeometry 转换为客户端几何对象 Geometry。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeometry',
    value: function toGeometry() {
      var me = this,
          geoType = me.type;
      switch (geoType) {
        case _REST.GeometryType.POINT:
          return me.toGeoPoint();
        case _REST.GeometryType.LINE:
          return me.toGeoLine();
        case _REST.GeometryType.LINEM:
          return me.toGeoLinem();
        case _REST.GeometryType.REGION:
          return me.toGeoRegion();
        case _REST.GeometryType.POINTEPS:
          return me.toGeoPoint();
        case _REST.GeometryType.LINEEPS:
          return me.toGeoLineEPS();
        case _REST.GeometryType.REGIONEPS:
          return me.toGeoRegionEPS();
      }
    }

    /*
     * Method: toGeoPoint
     * 将服务端的点几何对象转换为客户端几何对象。
     * 包括 Point 、MultiPoint。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoPoint',
    value: function toGeoPoint() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          return new _Point2.default(geoPoints[0].x, geoPoints[0].y);
        } else {
          for (var i = 0, pointList = []; i < len; i++) {
            pointList.push(new _Point2.default(geoPoints[i].x, geoPoints[i].y));
          }
          return new _MultiPoint2.default(pointList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLine
     * 将服务端的线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLine',
    value: function toGeoLine() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          for (var i = 0, pointList = []; i < geoParts[0]; i++) {
            pointList.push(new _Point2.default(geoPoints[i].x, geoPoints[i].y));
          }
          //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            return new _LinearRing2.default(pointList);
          } else {
            return new _LineString2.default(pointList);
          }
        } else {
          for (var i = 0, lineList = []; i < len; i++) {
            for (var j = 0, pointList = []; j < geoParts[i]; j++) {
              pointList.push(new _Point2.default(geoPoints[j].x, geoPoints[j].y));
            }
            lineList.push(new _LineString2.default(pointList));
            geoPoints.splice(0, geoParts[i]);
          }
          return new _MultiLineString2.default(lineList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLineEPS
     * 将服务端的线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLineEPS',
    value: function toGeoLineEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          i,
          j,
          pointList,
          lineList,
          lineEPS,
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          for (i = 0, pointList = []; i < geoParts[0]; i++) {
            pointList.push(new _Point2.default(geoPoints[i].x, geoPoints[i].y, geoPoints[i].type));
          }
          //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            lineEPS = _LineString2.default.createLineEPS(pointList);
            return new _SuperMap2.default.Geometry.LineRing(lineEPS);
          } else {
            lineEPS = _LineString2.default.createLineEPS(pointList);
            return new _LineString2.default(lineEPS);
          }
        } else {
          for (i = 0, lineList = []; i < len; i++) {
            for (j = 0, pointList = []; j < geoParts[i]; j++) {
              pointList.push(new _Point2.default(geoPoints[j].x, geoPoints[j].y));
            }
            lineEPS = _LineString2.default.createLineEPS(pointList);
            lineList.push(new _LineString2.default(lineEPS));
            geoPoints.splice(0, geoParts[i]);
          }
          return new _MultiLineString2.default(lineList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLine
     * 将服务端的路由线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLinem',
    value: function toGeoLinem() {
      var me = this;
      return new _Route2.default.fromJson(me);
    }

    /*
     * Method: toGeoRegion
     * 将服务端的面几何对象转换为客户端几何对象。
     * 类型为Polygon。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoRegion',
    value: function toGeoRegion() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len <= 0) {
        return null;
      }
      var polygonArray = [];
      var pointList = [];
      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new _Point2.default(geoPoints[i].x, geoPoints[i].y));
        }
        polygonArray.push(new _Polygon2.default([new _LinearRing2.default(pointList)]));
        pointList = [];
        return new _MultiPolygon2.default(polygonArray);
      }
      //处理复杂面
      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      //polyon岛洞标识数组，初始都是岛。
      var CCWIdent = [];
      for (var i = 0, pointIndex = 0; i < len; i++) {
        for (var j = 0; j < geoParts[i]; j++) {
          pointList.push(new _Point2.default(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }
        pointIndex += geoParts[i];
        var polygon = new _Polygon2.default([new _LinearRing2.default(pointList)]);
        pointList = [];
        polygonArrayTemp.push(polygon);
        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      }
      //根据面积排序
      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo);
      //iServer 9D新增字段
      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];
        for (var i = 1; i < polygonArrayTemp.length; i++) {
          for (var j = i - 1; j >= 0; j--) {
            targetArray[i] = -1;
            if (polygonArrayTemp[j].getBounds().containsBounds(polygonArrayTemp[i].getBounds())) {
              CCWIdent[i] = CCWIdent[j] * -1;
              if (CCWIdent[i] < 0) {
                targetArray[i] = j;
              }
              break;
            }
          }
        }
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (CCWIdent[i] > 0) {
            polygonArray.push(polygonArrayTemp[i]);
          } else {
            polygonArray[targetArray[i]].components = polygonArray[targetArray[i]].components.concat(polygonArrayTemp[i].components);
            //占位
            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        //ServerGeometry.bubbleSort(areaArray, polygonArrayTemp,geoTopo);
        var polygonArray = new Array();
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (geoTopo[i] && geoTopo[i] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[i].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }
            polygonArray.push(polygonArrayTemp[i]);
          }
          if (i == len - 1) {
            var polyLength = polygonArray.length;
            if (!!polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new _Polygon2.default(CCWArray));
              }
            }
          }
        }
      }
      return new _MultiPolygon2.default(polygonArray);
    }

    /*
     * Method: toGeoRegionEPS
     * 将服务端的面几何对象转换为客户端几何对象。
     * 类型为Polygon。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoRegionEPS',
    value: function toGeoRegionEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len <= 0) {
        return null;
      }
      var polygonArray = [];
      var pointList = [];
      var lineEPS;
      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new _Point2.default(geoPoints[i].x, geoPoints[i].y));
        }

        lineEPS = _LineString2.default.createLineEPS(pointList);
        polygonArray.push(new _Polygon2.default([new _LinearRing2.default(lineEPS)]));
        pointList = [];
        return new _MultiPolygon2.default(polygonArray);
      }
      //处理复杂面
      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      //polyon岛洞标识数组，初始都是岛。
      var CCWIdent = [];
      for (var i = 0, pointIndex = 0; i < len; i++) {
        for (var j = 0; j < geoParts[i]; j++) {
          pointList.push(new _Point2.default(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }
        pointIndex += geoParts[i];

        lineEPS = _LineString2.default.createLineEPS(pointList);
        var polygon = new _Polygon2.default([new _LinearRing2.default(lineEPS)]);
        pointList = [];
        polygonArrayTemp.push(polygon);
        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      }
      //根据面积排序
      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo);
      //iServer 9D新增字段
      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];
        for (var i = 1; i < polygonArrayTemp.length; i++) {
          for (var j = i - 1; j >= 0; j--) {
            targetArray[i] = -1;
            if (polygonArrayTemp[j].getBounds().containsBounds(polygonArrayTemp[i].getBounds())) {
              CCWIdent[i] = CCWIdent[j] * -1;
              if (CCWIdent[i] < 0) {
                targetArray[i] = j;
              }
              break;
            }
          }
        }
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (CCWIdent[i] > 0) {
            polygonArray.push(polygonArrayTemp[i]);
          } else {
            polygonArray[targetArray[i]].components = polygonArray[targetArray[i]].components.concat(polygonArrayTemp[i].components);
            //占位
            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        var polygonArray = new Array();
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (geoTopo[i] && geoTopo[i] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[i].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }
            polygonArray.push(polygonArrayTemp[i]);
          }
          if (i == len - 1) {
            var polyLength = polygonArray.length;
            if (!!polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new _Polygon2.default(CCWArray));
              }
            }
          }
        }
      }
      return new _MultiPolygon2.default(polygonArray);
    }

    /*
     * Function: ServerGeometry.fromJson
     * 将 JSON 对象表示服务端几何对象转换为 ServerGeometry。
     *
     * Parameters:
     * jsonObject - {Object} 要转换的 JSON 对象。
     *
     * Returns:
     * {<SuperMap.ServerGeometry>} 转化后的 ServerGeometry 对象。
     */

  }], [{
    key: 'fromJson',
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }
      return new ServerGeometry({
        id: jsonObject.id,
        style: _ServerStyle2.default.fromJson(jsonObject.style),
        parts: jsonObject.parts,
        partTopo: jsonObject.partTopo,
        points: jsonObject.points,
        center: jsonObject.center,
        length: jsonObject.length,
        maxM: jsonObject.maxM,
        minM: jsonObject.minM,
        type: jsonObject.type
      });
    }
  }, {
    key: 'fromGeometry',


    /*
     * Function: ServerGeometry.fromGeometry
     * 将客户端Geometry转换成服务端ServerGeometry。
     *
     * Parameters:
     * geometry - {<SuperMap.Geometry>} 要转换的客户端Geometry对象。

     *
     * Returns:
     * {<SuperMap.ServerGeometry>} 转化后的 ServerGeometry 对象。
     */
    value: function fromGeometry(geometry) {
      if (!geometry) {
        return;
      }
      var id = 0,
          parts = [],
          points = [],
          type = null,
          icomponents = geometry.components,
          className = geometry.CLASS_NAME,
          prjCoordSys = { "epsgCode": geometry.SRID };

      if (!isNaN(geometry.id)) {
        id = geometry.id;
      }
      //坑爹的改法，没法，为了支持态势标绘，有时间就得全改
      if (className != "SuperMap.Geometry.LinearRing" && className != "SuperMap.Geometry.LineString" && (geometry instanceof _MultiPoint2.default || geometry instanceof _MultiLineString2.default)) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var partPointsCount = icomponents[i].getVertices().length;
          parts.push(partPointsCount);
          for (var j = 0; j < partPointsCount; j++) {
            points.push(new _Point2.default(icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
          }
        }
        //这里className不是多点就全部是算线
        type = className == "SuperMap.Geometry.MultiPoint" ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
      } else if (geometry instanceof _MultiPolygon2.default) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var polygon = icomponents[i],
              linearRingOfPolygon = polygon.components,
              linearRingOfPolygonLen = linearRingOfPolygon.length;
          for (var j = 0; j < linearRingOfPolygonLen; j++) {
            var partPointsCount = linearRingOfPolygon[j].getVertices().length + 1;
            parts.push(partPointsCount);
            for (var k = 0; k < partPointsCount - 1; k++) {
              points.push(new _Point2.default(linearRingOfPolygon[j].getVertices()[k].x, linearRingOfPolygon[j].getVertices()[k].y));
            }
            points.push(new _Point2.default(linearRingOfPolygon[j].getVertices()[0].x, linearRingOfPolygon[j].getVertices()[0].y));
          }
        }
        type = _REST.GeometryType.REGION;
      } else if (geometry instanceof _Polygon2.default) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var partPointsCount = icomponents[i].getVertices().length + 1;
          parts.push(partPointsCount);
          for (var j = 0; j < partPointsCount - 1; j++) {
            points.push(new _Point2.default(icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
          }
          points.push(new _Point2.default(icomponents[i].getVertices()[0].x, icomponents[i].getVertices()[0].y));
        }
        type = _REST.GeometryType.REGION;
      } else {
        var geometryVerticesCount = geometry.getVertices().length;
        for (var j = 0; j < geometryVerticesCount; j++) {
          points.push(new _Point2.default(geometry.getVertices()[j].x, geometry.getVertices()[j].y));
        }
        if (geometry instanceof _LinearRing2.default) {
          points.push(new _Point2.default(geometry.getVertices()[0].x, geometry.getVertices()[0].y));
          geometryVerticesCount++;
        }
        parts.push(geometryVerticesCount);
        type = geometry instanceof _Point2.default ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
      }

      return new ServerGeometry({
        id: id,
        style: null,
        parts: parts,
        points: points,
        type: type,
        prjCoordSys: prjCoordSys
      });
    }
  }, {
    key: 'IsClockWise',


    /*
     * Function: SuperMap.Geometry.IsClockWise
     * 判断linearRing中的点的顺序，顺时针？逆时针
     * 返回值大于0, 逆时针; 小于0, 顺时针
     *
     * Parameters:
     * geometry - {<SuperMap.Geometry>} 要转换的客户端Geometry对象。

     *
     * Returns:
     * {<Number>}。
     */
    value: function IsClockWise(points) {
      var length = points.length;
      if (length < 3) {
        return 0.0;
      }
      var s = points[0].y * (points[length - 1].x - points[1].x);
      points.push(points[0]);
      for (var i = 1; i < length; i++) {
        s += points[i].y * (points[i - 1].x - points[i + 1].x);
      }
      return s * 0.5;
    }
  }, {
    key: 'bubbleSort',
    value: function bubbleSort(areaArray, pointList, geoTopo) {
      for (var i = 0; i < areaArray.length; i++) {
        for (var j = 0; j < areaArray.length; j++) {
          if (areaArray[i] > areaArray[j]) {
            var d = areaArray[j];
            areaArray[j] = areaArray[i];
            areaArray[i] = d;
            var b = pointList[j];
            pointList[j] = pointList[i];
            pointList[i] = b;
            if (geoTopo && geoTopo.length > 0) {
              var c = geoTopo[j];
              geoTopo[j] = geoTopo[i];
              geoTopo[i] = c;
            }
          }
        }
      }
    }
  }]);

  return ServerGeometry;
}();

exports.default = ServerGeometry;

_SuperMap2.default.ServerGeometry = ServerGeometry;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServerColor = __webpack_require__(11);

var _ServerColor2 = _interopRequireDefault(_ServerColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerStyle
 * @classdesc 服务端矢量要素风格类。
 * @description 该类用于定义点状符号、线状符号、填充符号风格及其相关属性。
 * @param options - {Object} 可选参数。如：<br>
 *        fillBackColor - {{@link SuperMap.ServerColor}} 填充背景颜色。<br>
 *        fillBackOpaque - {boolean} 背景是否不透明。<br>
 *        fillForeColor - {{@link SuperMap.ServerColor}} 填充颜色。<br>
 *        fillGradientMode - {{@link SuperMap.FillGradientMode}} 渐变填充风格的渐变类型。<br>
 *        fillGradientAngle - {number}渐变填充的旋转角度。<br>
 *        fillGradientOffsetRatioX - {number}渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。<br>
 *        fillGradientOffsetRatioY - {number}填充中心点相对于填充区域范围中心点的垂直偏移百分比。<br>
 *        fillOpaqueRate - {number}填充不透明度。<br>
 *        fillSymbolID - {integer} 填充符号的编码。<br>
 *        lineColor - {{@link SuperMap.ServerColor}} 矢量要素的边线颜色。<br>
 *        lineSymbolID - {integer} 线状符号的编码。<br>
 *        lineWidth - {number}边线的宽度。<br>
 *        markerAngle - {number}点状符号的旋转角度。<br>
 *        markerSize - {number}点状符号的大小。<br>
 *        markerSymbolID - {integer} 点状符号的编码。
 */
var ServerStyle = function () {

    /**
     * @member SuperMap.ServerStyle.prototype.markerSize -{number}
     * @description 点状符号的大小。单位为毫米，精度为0.1，默认值为1.0。当该属性设置为0时，采用符号默认大小1.0显示。
     *              当该属性设置为非法值时，交由服务器默认处理。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineWidth -{number}
     * @description 边线的宽度。单位为毫米，精度到0.1，默认值为1.0。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineColor -{SuperMap.ServerColor}
     * @description 矢量要素的边线颜色。默认为黑色。如果等级符号是点符号，点符号的颜色由lineColor控制
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillOpaqueRate -{number}
     * @description 填充不透明度。合法值为0--100的数值。其中为0表示完全透明；
     *              100表示完全不透明。赋值小于0时按照0处理，大于100时按照100处理。默认值为 100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientOffsetRatioX -{number}
     * @description 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。它们的关系如下：设填充区域范围中心点的坐标为（x0, y0），
     *              填充中心点的坐标为（x, y），填充区域范围的宽度为 a，水平偏移百分比为 dx，则 x=x0 + a*dx/100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientMode -{SuperMap.FillGradientMode}
     * @description 渐变填充风格的渐变类型。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillBackOpaque -{boolean}
     * @description 背景是否不透明。false 表示透明。默认值为 false。
     */
    function ServerStyle(options) {
        _classCallCheck(this, ServerStyle);

        this.fillBackColor = null;
        this.fillBackOpaque = false;
        this.fillForeColor = null;
        this.fillGradientMode = null;
        this.fillGradientAngle = 0;
        this.fillGradientOffsetRatioX = 0;
        this.fillGradientOffsetRatioY = 0;
        this.fillOpaqueRate = 100;
        this.fillSymbolID = 0;
        this.lineColor = null;
        this.lineSymbolID = 0;
        this.lineWidth = 1;
        this.markerAngle = 0;
        this.markerSize = 1;
        this.markerSymbolID = -1;
        this.CLASS_NAME = "SuperMap.ServerStyle";

        var me = this;
        me.fillBackColor = new _ServerColor2.default(255, 255, 255);
        me.fillForeColor = new _ServerColor2.default(255, 0, 0);
        me.lineColor = new _ServerColor2.default(0, 0, 0);
        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ServerStyle.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.markerSymbolID -{integer}
     * @description 点状符号的编码。此编码用于唯一标识各点状符号。默认为 -1。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.markerAngle -{number}
     * @description 点状符号的旋转角度。以度为单位，精确到0.1度，逆时针方向为正方向，默认值为0。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineSymbolID -{integer}
     * @description 线状符号的编码。此编码用于唯一标识各普通填充风格的填充符号，默认值为0。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillSymbolID -{integer}
     * @description 填充符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于填充符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientOffsetRatioY -{number}
     * @description 填充中心点相对于填充区域范围中心点的垂直偏移百分比。它们的关系如下：<br>
     *           设填充区域范围中心点的坐标为（x0, y0），填充中心点的坐标为（x, y），填充区域范围的高度为 b，垂直偏移百分比为 dy，则 y=y0 + b*dx/100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientAngle -{number}
     * @description 渐变填充的旋转角度。单位为度，精确到0.1度，逆时针方向为正方向。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillForeColor -{SuperMap.ServerColor}
     * @description 填充颜色。当填充模式为渐变填充时，该颜色为填充起始颜色。默认为红色。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillBackColor -{SuperMap.ServerColor}
     * @description 填充背景颜色。当填充模式为渐变填充时，该颜色为填充终止色。默认为白色。
     */


    _createClass(ServerStyle, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.fillBackColor) {
                me.fillBackColor.destroy();
                me.fillBackColor = null;
            }
            me.fillBackOpaque = null;

            if (me.fillForeColor) {
                me.fillForeColor.destroy();
                me.fillForeColor = null;
            }
            me.fillGradientMode = null;
            me.fillGradientAngle = null;
            me.fillGradientOffsetRatioX = null;
            me.fillGradientOffsetRatioY = null;
            me.fillOpaqueRate = null;
            me.fillSymbolID = null;
            if (me.lineColor) {
                me.lineColor.destroy();
                me.lineColor = null;
            }
            me.lineSymbolID = null;
            me.lineWidth = null;
            me.markerAngle = null;
            me.markerSize = null;
            me.markerSymbolID = null;
        }

        /**
         * @function SuperMap.ServerStyle.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object } 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var styleObj = {};
            styleObj = _SuperMap2.default.Util.copyAttributes(styleObj, this);
            //暂时先忽略serverColor往Json的转换
            return styleObj;
        }

        /**
         * @function SuperMap.ServerStyle.fromJson
         * @description 将JSON对象转换为 SuperMap.ServerStyle 对象。
         * @param jsonObject - {Object} 要转换的 JSON 对象。
         * @return{SuperMap.ServerStyle} 转化后的 SuperMap.ServerStyle 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            return new _SuperMap2.default.ServerStyle({
                fillBackColor: _ServerColor2.default.fromJson(jsonObject.fillBackColor),
                fillBackOpaque: jsonObject.fillBackOpaque,
                fillForeColor: _ServerColor2.default.fromJson(jsonObject.fillForeColor),
                fillGradientMode: jsonObject.fillGradientMode,
                fillGradientAngle: jsonObject.fillGradientAngle,
                fillGradientOffsetRatioX: jsonObject.fillGradientOffsetRatioX,
                fillGradientOffsetRatioY: jsonObject.fillGradientOffsetRatioY,
                fillOpaqueRate: jsonObject.fillOpaqueRate,
                fillSymbolID: jsonObject.fillSymbolID,
                lineColor: _ServerColor2.default.fromJson(jsonObject.lineColor),
                lineSymbolID: jsonObject.lineSymbolID,
                lineWidth: jsonObject.lineWidth,
                markerAngle: jsonObject.markerAngle,
                markerSize: jsonObject.markerSize,
                markerSymbolID: jsonObject.markerSymbolID
            });
        }
    }]);

    return ServerStyle;
}();

exports.default = ServerStyle;


_SuperMap2.default.ServerStyle = ServerStyle;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Util = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

__webpack_require__(29);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Util = exports.Util = _SuperMap2.default.Util = _SuperMap2.default.Util || {};
/**
 * @name Util
 * @memberOf SuperMap
 * @namespace
 * @description common工具类。
 */

/**
 * @description 复制源对象的所有属性到目标对象上，源对象上的没有定义的属性在目标对象上也不会被设置。
 * @example
 * 要复制SuperMap.Size对象的所有属性到自定义对象上，使用方法如下:
 *     var size = new SuperMap.Size(100, 100);
 *     var obj = {}；
 *     SuperMap.Util.extend(obj, size);
 * @param destination - {Object} 目标对象。
 * @param source - {Object} 源对象，其属性将被设置到目标对象上。
 * @return {Object} 目标对象。
 */

_SuperMap2.default.Util.extend = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }

        /**
         * IE doesn't include the toString property when iterating over an object's
         * properties with the for(property in object) syntax.  Explicitly check if
         * the source has its own toString property.
         */

        /*
         * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
         * prototype object" when calling hawOwnProperty if the source object
         * is an instance of window.Event.
         */

        var sourceIsEvt = typeof window.Event === "function" && source instanceof window.Event;

        if (!sourceIsEvt && source.hasOwnProperty && source.hasOwnProperty("toString")) {
            destination.toString = source.toString;
        }
    }
    return destination;
};
/**
 * @description 对象拷贝。
 * @param des - {Object} 目标对象。
 * @param soc - {Object} 源对象
 */
_SuperMap2.default.Util.copy = function (des, soc) {
    des = des || {};
    var v;
    if (soc) {
        for (var p in des) {
            v = soc[p];
            if (typeof v !== 'undefined') {
                des[p] = v;
            }
        }
    }
};
/**
 * @description 销毁对象，将其属性置空
 * @param obj - {Object} 目标对象。
 */
_SuperMap2.default.Util.reset = function (obj) {
    obj = obj || {};
    for (var p in obj) {
        if (obj.hasOwnProperty(p)) {
            if (_typeof(obj[p]) === "object" && obj[p] instanceof Array) {
                for (var i in obj[p]) {
                    if (obj[p][i].destroy) {
                        obj[p][i].destroy();
                    }
                }
                obj[p].length = 0;
            } else if (_typeof(obj[p]) === "object" && obj[p] instanceof Object) {
                if (obj[p].destroy) {
                    obj[p].destroy();
                }
            }
            obj[p] = null;
        }
    }
};

/**
 * @description 获取HTML元素数组。
 * @param argument - {String | HTMLElement | Window}
 * @return {Array<HTMLElement>} HTML元素数组。
 */
_SuperMap2.default.Util.getElement = function () {
    var elements = [];

    for (var i = 0, len = arguments.length; i < len; i++) {
        var element = arguments[i];
        if (typeof element === 'string') {
            element = document.getElementById(element);
        }
        if (arguments.length === 1) {
            return element;
        }
        elements.push(element);
    }
    return elements;
};

/**
 * @description instance of的跨浏览器实现。
 * @param o - {Object} 对象。
 * @return {boolean}
 */
_SuperMap2.default.Util.isElement = function (o) {
    return !!(o && o.nodeType === 1);
};

/**
 * @description 判断一个对象是否是数组。
 * @param a - {Object} 对象。
 * @return {boolean} 是否是数组。
 */
_SuperMap2.default.Util.isArray = function (a) {
    return Object.prototype.toString.call(a) === '[object Array]';
};

/**
 * @description 从数组中删除某一项。
 * @param array - {Array} 数组。
 * @param item - {Object} 数组中要删除的一项。
 * @return {Array} 执行删除操作后的数组。
 */
_SuperMap2.default.Util.removeItem = function (array, item) {
    for (var i = array.length - 1; i >= 0; i--) {
        if (array[i] === item) {
            array.splice(i, 1);
            //break;more than once??
        }
    }
    return array;
};

/**
 * @description 获取某对象再数组中的索引值。
 * @param array - {Array} 数组。
 * @param obj - {Object} 对象。
 * @return {number} 某对象再数组中的索引值。
 */
_SuperMap2.default.Util.indexOf = function (array, obj) {
    if (array == null) {
        return -1;
    } else {
        // use the build-in function if available.
        if (typeof array.indexOf === "function") {
            return array.indexOf(obj);
        } else {
            for (var i = 0, len = array.length; i < len; i++) {
                if (array[i] === obj) {
                    return i;
                }
            }
            return -1;
        }
    }
};

/**
 * @description 修改某DOM元素的许多属性。
 * @param element - {HTMLElement} 待修改的DOM元素。
 * @param id - {string} DOM元素的id。
 * @param px - {SuperMap.Pixel} 包含DOM元素的style属性的left和top属性。
 * @param sz - {SuperMap.Size} 包含DOM元素的width和height属性。
 * @param position - {string} DOM元素的position属性。
 * @param border - {string} DOM元素的style属性的border属性。
 * @param overflow - {string} DOM元素的style属性的overflow属性。
 * @param opacity - {number} 不透明度值。取值范围为 (0.0 - 1.0)。
 */
_SuperMap2.default.Util.modifyDOMElement = function (element, id, px, sz, position, border, overflow, opacity) {

    if (id) {
        element.id = id;
    }
    if (px) {
        element.style.left = px.x + "px";
        element.style.top = px.y + "px";
    }
    if (sz) {
        element.style.width = sz.w + "px";
        element.style.height = sz.h + "px";
    }
    if (position) {
        element.style.position = position;
    }
    if (border) {
        element.style.border = border;
    }
    if (overflow) {
        element.style.overflow = overflow;
    }
    if (parseFloat(opacity) >= 0.0 && parseFloat(opacity) < 1.0) {
        element.style.filter = 'alpha(opacity=' + opacity * 100 + ')';
        element.style.opacity = opacity;
    } else if (parseFloat(opacity) === 1.0) {
        element.style.filter = '';
        element.style.opacity = '';
    }
};

/**
 * @param params - {Object} 参数对象。
 * @return {string} HTTP的GEI请求中的参数字符串。
 * @description 将参数对象转换为HTTP的GEI请求中的参数字符串。例如："key1=value1&key2=value2&key3=value3"。
 */
_SuperMap2.default.Util.getParameterString = function (params) {
    var paramsArray = [];

    for (var key in params) {
        var value = params[key];
        if (value != null && typeof value !== 'function') {
            var encodedValue;
            if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                /* value is an array; encode items and separate with "," */
                var encodedItemArray = [];
                var item;
                for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                    item = value[itemIndex];
                    encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                }
                encodedValue = encodedItemArray.join(",");
            } else {
                /* value is a string; simply encode */
                encodedValue = encodeURIComponent(value);
            }
            paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
        }
    }

    return paramsArray.join("&");
};

/**
 * @description 给url追加参数。
 * @param url - {string} 待追加参数的url字符串。
 * @param paramStr - {string} 待追加的参数。
 * @return {string} The new url
 */
_SuperMap2.default.Util.urlAppend = function (url, paramStr) {
    var newUrl = url;
    if (paramStr) {
        var parts = (url + " ").split(/[?&]/);
        newUrl += parts.pop() === " " ? paramStr : parts.length ? "&" + paramStr : "?" + paramStr;
    }
    return newUrl;
};

/**
 * @description 为了避免浮点精度错误而保留的有效位数。
 * @type {number}
 * @default 14
 */
_SuperMap2.default.Util.DEFAULT_PRECISION = 14;

/**
 * @description 将字符串以接近的精度转换为数字。
 * @param number - {string} 字符串。
 * @param precision - {number} 精度。
 * @return {number} 数字。
 */
_SuperMap2.default.Util.toFloat = function (number, precision) {
    if (precision == null) {
        precision = _SuperMap2.default.Util.DEFAULT_PRECISION;
    }
    if (typeof number !== "number") {
        number = parseFloat(number);
    }
    return precision === 0 ? number : parseFloat(number.toPrecision(precision));
};

/**
 * @description 角度转弧度。
 * @param x - {number} 角度。
 * @return {number} 弧度。
 */
_SuperMap2.default.Util.rad = function (x) {
    return x * Math.PI / 180;
};

/**
 * @description 从URL字符串中解析出参数对象。
 * @param url - {string} url。
 * @return {Object} 解析出的参数对象。
 */
_SuperMap2.default.Util.getParameters = function (url) {
    // if no url specified, take it from the location bar
    url = url === null || url === undefined ? window.location.href : url;

    //parse out parameters portion of url string
    var paramsString = "";
    if (_SuperMap2.default.String.contains(url, '?')) {
        var start = url.indexOf('?') + 1;
        var end = _SuperMap2.default.String.contains(url, "#") ? url.indexOf('#') : url.length;
        paramsString = url.substring(start, end);
    }

    var parameters = {};
    var pairs = paramsString.split(/[&;]/);
    for (var i = 0, len = pairs.length; i < len; ++i) {
        var keyValue = pairs[i].split('=');
        if (keyValue[0]) {

            var key = keyValue[0];
            try {
                key = decodeURIComponent(key);
            } catch (err) {
                key = unescape(key);
            }

            // being liberal by replacing "+" with " "
            var value = (keyValue[1] || '').replace(/\+/g, " ");

            try {
                value = decodeURIComponent(value);
            } catch (err) {
                value = unescape(value);
            }

            // follow OGC convention of comma delimited values
            value = value.split(",");

            //if there's only one value, do not return as array                    
            if (value.length == 1) {
                value = value[0];
            }

            parameters[key] = value;
        }
    }
    return parameters;
};

/**
 * @description 不断递增计数变量，用于生成唯一ID。
 * @type {number}
 * @default 0
 */
_SuperMap2.default.Util.lastSeqID = 0;

/**
 * @description 创建唯一ID值。
 * @param prefix {string} 前缀。
 * @return {string} 唯一的ID值。
 */
_SuperMap2.default.Util.createUniqueID = function (prefix) {
    if (prefix == null) {
        prefix = "id_";
    }
    _SuperMap2.default.Util.lastSeqID += 1;
    return prefix + _SuperMap2.default.Util.lastSeqID;
};

/**
 * @memberOf SuperMap
 * @description 每单位的英尺数。
 * @type {Object}
 * @constant
 */
_SuperMap2.default.INCHES_PER_UNIT = {
    'inches': 1.0,
    'ft': 12.0,
    'mi': 63360.0,
    'm': 39.3701,
    'km': 39370.1,
    'dd': 4374754,
    'yd': 36
};
_SuperMap2.default.INCHES_PER_UNIT["in"] = _SuperMap2.default.INCHES_PER_UNIT.inches;
_SuperMap2.default.INCHES_PER_UNIT["degrees"] = _SuperMap2.default.INCHES_PER_UNIT.dd;
_SuperMap2.default.INCHES_PER_UNIT["nmi"] = 1852 * _SuperMap2.default.INCHES_PER_UNIT.m;

// Units from CS-Map
_SuperMap2.default.METERS_PER_INCH = 0.02540005080010160020;
_SuperMap2.default.Util.extend(_SuperMap2.default.INCHES_PER_UNIT, {
    "Inch": _SuperMap2.default.INCHES_PER_UNIT.inches,
    "Meter": 1.0 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9001
    "Foot": 0.30480060960121920243 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9003
    "IFoot": 0.30480000000000000000 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9002
    "ClarkeFoot": 0.3047972651151 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9005
    "SearsFoot": 0.30479947153867624624 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9041
    "GoldCoastFoot": 0.30479971018150881758 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9094
    "IInch": 0.02540000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "MicroInch": 0.00002540000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Mil": 0.00000002540000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Centimeter": 0.01000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Kilometer": 1000.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9036
    "Yard": 0.91440182880365760731 / _SuperMap2.default.METERS_PER_INCH,
    "SearsYard": 0.914398414616029 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9040
    "IndianYard": 0.91439853074444079983 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9084
    "IndianYd37": 0.91439523 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9085
    "IndianYd62": 0.9143988 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9086
    "IndianYd75": 0.9143985 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9087
    "IndianFoot": 0.30479951 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9080
    "IndianFt37": 0.30479841 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9081
    "IndianFt62": 0.3047996 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9082
    "IndianFt75": 0.3047995 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9083
    "Mile": 1609.34721869443738887477 / _SuperMap2.default.METERS_PER_INCH,
    "IYard": 0.91440000000000000000 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9096
    "IMile": 1609.34400000000000000000 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9093
    "NautM": 1852.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9030
    "Lat-66": 110943.316488932731 / _SuperMap2.default.METERS_PER_INCH,
    "Lat-83": 110946.25736872234125 / _SuperMap2.default.METERS_PER_INCH,
    "Decimeter": 0.10000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Millimeter": 0.00100000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Dekameter": 10.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Decameter": 10.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "Hectometer": 100.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "GermanMeter": 1.0000135965 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9031
    "CaGrid": 0.999738 / _SuperMap2.default.METERS_PER_INCH,
    "ClarkeChain": 20.1166194976 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9038
    "GunterChain": 20.11684023368047 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9033
    "BenoitChain": 20.116782494375872 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9062
    "SearsChain": 20.11676512155 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9042
    "ClarkeLink": 0.201166194976 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9039
    "GunterLink": 0.2011684023368047 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9034
    "BenoitLink": 0.20116782494375872 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9063
    "SearsLink": 0.2011676512155 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9043
    "Rod": 5.02921005842012 / _SuperMap2.default.METERS_PER_INCH,
    "IntnlChain": 20.1168 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9097
    "IntnlLink": 0.201168 / _SuperMap2.default.METERS_PER_INCH, //EPSG:9098
    "Perch": 5.02921005842012 / _SuperMap2.default.METERS_PER_INCH,
    "Pole": 5.02921005842012 / _SuperMap2.default.METERS_PER_INCH,
    "Furlong": 201.1684023368046 / _SuperMap2.default.METERS_PER_INCH,
    "Rood": 3.778266898 / _SuperMap2.default.METERS_PER_INCH,
    "CapeFoot": 0.3047972615 / _SuperMap2.default.METERS_PER_INCH,
    "Brealey": 375.00000000000000000000 / _SuperMap2.default.METERS_PER_INCH,
    "ModAmFt": 0.304812252984505969011938 / _SuperMap2.default.METERS_PER_INCH,
    "Fathom": 1.8288 / _SuperMap2.default.METERS_PER_INCH,
    "NautM-UK": 1853.184 / _SuperMap2.default.METERS_PER_INCH,
    "50kilometers": 50000.0 / _SuperMap2.default.METERS_PER_INCH,
    "150kilometers": 150000.0 / _SuperMap2.default.METERS_PER_INCH
});

//unit abbreviations supported by PROJ.4
_SuperMap2.default.Util.extend(_SuperMap2.default.INCHES_PER_UNIT, {
    "mm": _SuperMap2.default.INCHES_PER_UNIT["Meter"] / 1000.0,
    "cm": _SuperMap2.default.INCHES_PER_UNIT["Meter"] / 100.0,
    "dm": _SuperMap2.default.INCHES_PER_UNIT["Meter"] * 100.0,
    "km": _SuperMap2.default.INCHES_PER_UNIT["Meter"] * 1000.0,
    "kmi": _SuperMap2.default.INCHES_PER_UNIT["nmi"], //International Nautical Mile
    "fath": _SuperMap2.default.INCHES_PER_UNIT["Fathom"], //International Fathom
    "ch": _SuperMap2.default.INCHES_PER_UNIT["IntnlChain"], //International Chain
    "link": _SuperMap2.default.INCHES_PER_UNIT["IntnlLink"], //International Link
    "us-in": _SuperMap2.default.INCHES_PER_UNIT["inches"], //U.S. Surveyor's Inch
    "us-ft": _SuperMap2.default.INCHES_PER_UNIT["Foot"], //U.S. Surveyor's Foot
    "us-yd": _SuperMap2.default.INCHES_PER_UNIT["Yard"], //U.S. Surveyor's Yard
    "us-ch": _SuperMap2.default.INCHES_PER_UNIT["GunterChain"], //U.S. Surveyor's Chain
    "us-mi": _SuperMap2.default.INCHES_PER_UNIT["Mile"], //U.S. Surveyor's Statute Mile
    "ind-yd": _SuperMap2.default.INCHES_PER_UNIT["IndianYd37"], //Indian Yard
    "ind-ft": _SuperMap2.default.INCHES_PER_UNIT["IndianFt37"], //Indian Foot
    "ind-ch": 20.11669506 / _SuperMap2.default.METERS_PER_INCH //Indian Chain
});

/**
 * @memberOf SuperMap
 * @description 分辨率与比例尺之间转换的常量，默认值96。
 * @type {Object}
 * @default 96
 */
_SuperMap2.default.DOTS_PER_INCH = 96;

/**
 * @param scale - {number}
 * @return {number}
 */
_SuperMap2.default.Util.normalizeScale = function (scale) {
    var normScale = scale > 1.0 ? 1.0 / scale : scale;
    return normScale;
};

/**
 * @param scale - {number} 比例尺。
 * @param units - {string} 比例尺单位。
 * @return {number} 分辨率。
 */
_SuperMap2.default.Util.getResolutionFromScale = function (scale, units) {
    var resolution;
    if (scale) {
        if (units == null) {
            units = "degrees";
        }
        var normScale = _SuperMap2.default.Util.normalizeScale(scale);
        resolution = 1 / (normScale * _SuperMap2.default.INCHES_PER_UNIT[units] * _SuperMap2.default.DOTS_PER_INCH);
    }
    return resolution;
};

/**
 * @description 分辨率转比例尺。
 * @param resolution - {number} 分辨率。
 * @param units - {string} 分辨率单位。
 * @return {number} 比例尺。
 */
_SuperMap2.default.Util.getScaleFromResolution = function (resolution, units) {

    if (units == null) {
        units = "degrees";
    }

    var scale = resolution * _SuperMap2.default.INCHES_PER_UNIT[units] * _SuperMap2.default.DOTS_PER_INCH;
    return scale;
};

/**
 * @memberOf SuperMap
 * @description 如果userAgent捕获到浏览器使用的是Gecko引擎则返回true。
 * @constant
 */
_SuperMap2.default.IS_GECKO = function () {
    var ua = navigator.userAgent.toLowerCase();
    return ua.indexOf("webkit") === -1 && ua.indexOf("gecko") !== -1;
}();

/**
 * @memberOf SuperMap
 * @description 浏览器名称，依赖于userAgent属性，BROWSER_NAME可以是空，或者以下浏览器：
 *     * "opera" -- Opera
 *     * "msie"  -- Internet Explorer
 *     * "safari" -- Safari
 *     * "firefox" -- Firefox
 *     * "mozilla" -- Mozilla
 * @constant
 */
_SuperMap2.default.Browser = function () {
    var name = '',
        version = '',
        device = 'pc',
        uaMatch;
    //以下进行测试
    var ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf("msie") > -1 || ua.indexOf("trident") > -1 && ua.indexOf("rv") > -1) {
        name = 'msie';
        uaMatch = ua.match(/msie ([\d.]+)/) || ua.match(/rv:([\d.]+)/);
    } else if (ua.indexOf("chrome") > -1) {
        name = 'chrome';
        uaMatch = ua.match(/chrome\/([\d.]+)/);
    } else if (ua.indexOf("firefox") > -1) {
        name = 'firefox';
        uaMatch = ua.match(/firefox\/([\d.]+)/);
    } else if (ua.indexOf("opera") > -1) {
        name = 'opera';
        uaMatch = ua.match(/version\/([\d.]+)/);
    } else if (ua.indexOf("safari") > -1) {
        name = 'safari';
        uaMatch = ua.match(/version\/([\d.]+)/);
    }
    version = uaMatch ? uaMatch[1] : '';

    if (ua.indexOf("ipad") > -1 || ua.indexOf("ipod") > -1 || ua.indexOf("iphone") > -1) {
        device = 'apple';
    } else if (ua.indexOf("android") > -1) {
        uaMatch = ua.match(/version\/([\d.]+)/);
        version = uaMatch ? uaMatch[1] : '';
        device = 'android';
    }
    return { name: name, version: version, device: device };
}();

/**
 * @description 获取浏览器相关信息。支持的浏览器包括：Opera，Internet Explorer，Safari，Firefox。
 * @return {Object} 获取浏览器名称、版本、设备名称。对应的属性分别为 name, version, device。
 */
_SuperMap2.default.Util.getBrowser = function () {
    return _SuperMap2.default.Browser;
};

/**
 * @description 浏览器是否支持Canvas。
 * @return {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */
_SuperMap2.default.Util.isSupportCanvas = function () {
    var checkRes = true,
        broz = _SuperMap2.default.Util.getBrowser();
    if (document.createElement("canvas").getContext) {
        if (broz.name === 'firefox' && parseFloat(broz.version) < 5) {
            checkRes = false;
        }
        if (broz.name === 'safari' && parseFloat(broz.version) < 4) {
            checkRes = false;
        }
        if (broz.name === 'opera' && parseFloat(broz.version) < 10) {
            checkRes = false;
        }
        if (broz.name === 'msie' && parseFloat(broz.version) < 9) {
            checkRes = false;
        }
    } else {
        checkRes = false;
    }
    return checkRes;
}();

/**
 * @description 判断；浏览器是否支持Canvas。
 * @return {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */
_SuperMap2.default.Util.supportCanvas = function () {
    return _SuperMap2.default.Util.isSupportCanvas;
};

//将服务端的地图单位转成SuperMap的地图单位
_SuperMap2.default.INCHES_PER_UNIT["degree"] = _SuperMap2.default.INCHES_PER_UNIT.dd;
_SuperMap2.default.INCHES_PER_UNIT["meter"] = _SuperMap2.default.INCHES_PER_UNIT.m;
_SuperMap2.default.INCHES_PER_UNIT["foot"] = _SuperMap2.default.INCHES_PER_UNIT.ft;
_SuperMap2.default.INCHES_PER_UNIT["inch"] = _SuperMap2.default.INCHES_PER_UNIT.inches;
_SuperMap2.default.INCHES_PER_UNIT["mile"] = _SuperMap2.default.INCHES_PER_UNIT.mi;
_SuperMap2.default.INCHES_PER_UNIT["kilometer"] = _SuperMap2.default.INCHES_PER_UNIT.km;
_SuperMap2.default.INCHES_PER_UNIT["yard"] = _SuperMap2.default.INCHES_PER_UNIT.yd;

/**
 * @description 判断一个 URL 请求是否在当前域中。
 * @param url - {string}  URL 请求字符串。
 * @return {boolean} URL请求是否在当前域中。
 */
_SuperMap2.default.Util.isInTheSameDomain = function (url) {
    if (!url) {
        return true;
    }
    var index = url.indexOf("//");
    var documentUrl = document.location.toString();
    var documentIndex = documentUrl.indexOf("//");
    if (index === -1) {
        return true;
    } else {
        var protocol;
        var substring = protocol = url.substring(0, index);
        var documentSubString = documentUrl.substring(documentIndex + 2);
        documentIndex = documentSubString.indexOf("/");
        var documentPortIndex = documentSubString.indexOf(":");
        var documentDomainWithPort = documentSubString.substring(0, documentIndex);
        var documentPort;

        var documentprotocol = document.location.protocol;
        if (documentPortIndex !== -1) {
            documentPort = +documentSubString.substring(documentPortIndex, documentIndex);
        } else {
            documentDomainWithPort += ':' + (documentprotocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        if (documentprotocol.toLowerCase() !== substring.toLowerCase()) {
            return false;
        }
        substring = url.substring(index + 2);
        var portIndex = substring.indexOf(":");
        index = substring.indexOf("/");
        var domainWithPort = substring.substring(0, index);
        var domain;
        if (portIndex !== -1) {
            domain = substring.substring(0, portIndex);
        } else {
            domain = substring.substring(0, index);
            domainWithPort += ':' + (protocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        var documentDomain = document.domain;
        if (domain === documentDomain && domainWithPort === documentDomainWithPort) {
            return true;
        }
    }
    return false;
};

/**
 * @description 计算iServer服务的REST图层的显示分辨率，需要从iServer的REST图层表述中获取viewBounds、viewer、scale、coordUnit、datumAxis 五个参数，来进行计算。
 * @param viewBounds - {SuperMap.Bounds} 地图的参照可视范围，即地图初始化时默认的地图显示范围。
 * @param viewer - {SuperMap.Size} 地图初始化时默认的地图图片的尺寸。
 * @param scale - {number} 地图初始化时默认的显示比例尺。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则系统默认为WGS84参考系的椭球体长半轴6378137。
 * @return {number} 返回图层显示分辨率。
 */
_SuperMap2.default.Util.calculateDpi = function (viewBounds, viewer, scale, coordUnit, datumAxis) {
    //10000 是 0.1毫米与米的转换。DPI的计算公式：Viewer / DPI *  0.0254 * 10000 = ViewBounds * scale ，公式中的10000是为了提高计算结果的精度，以下出现的ratio皆为如此。
    if (!viewBounds || !viewer || !scale) {
        return;
    }
    var ratio = 10000,
        rvbWidth = viewBounds.getWidth(),
        rvbHeight = viewBounds.getHeight(),
        rvWidth = viewer.w,
        rvHeight = viewer.h;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "degrees";
    if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
        var num1 = rvbWidth / rvWidth,
            num2 = rvbHeight / rvHeight,
            resolution = num1 > num2 ? num1 : num2,
            dpi = 0.0254 * ratio / resolution / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
        return dpi;
    } else {
        var resolution = rvbWidth / rvWidth,
            dpi = 0.0254 * ratio / resolution / scale / ratio;
        return dpi;
    }
};

/**
 * @description 将对象转换成 JSON 字符串。
 * @param obj - {Object} 要转换成 JSON 的 Object 对象。
 * @return {string} 返回转换后的 JSON 对象。
 */
_SuperMap2.default.Util.toJSON = function (obj) {
    var objInn = obj;
    if (objInn == null) {
        return null;
    }
    switch (objInn.constructor) {
        case String:
            //s = "'" + str.replace(/(["\\])/g, "\\$1") + "'";   string含有单引号出错
            objInn = '"' + objInn.replace(/(["\\])/g, '\\$1') + '"';
            objInn = objInn.replace(/\n/g, "\\n");
            objInn = objInn.replace(/\r/g, "\\r");
            objInn = objInn.replace("<", "&lt;");
            objInn = objInn.replace(">", "&gt;");
            objInn = objInn.replace(/%/g, "%25");
            objInn = objInn.replace(/&/g, "%26");
            return objInn;
        case Array:
            var arr = [];
            for (var i = 0, len = objInn.length; i < len; i++) {
                arr.push(_SuperMap2.default.Util.toJSON(objInn[i]));
            }
            return "[" + arr.join(",") + "]";
        case Number:
            return isFinite(objInn) ? String(objInn) : null;
        case Boolean:
            return String(objInn);
        case Date:
            var dateStr = "{" + "'__type':\"System.DateTime\"," + "'Year':" + objInn.getFullYear() + "," + "'Month':" + (objInn.getMonth() + 1) + "," + "'Day':" + objInn.getDate() + "," + "'Hour':" + objInn.getHours() + "," + "'Minute':" + objInn.getMinutes() + "," + "'Second':" + objInn.getSeconds() + "," + "'Millisecond':" + objInn.getMilliseconds() + "," + "'TimezoneOffset':" + objInn.getTimezoneOffset() + "}";
            return dateStr;
        default:
            if (objInn["toJSON"] != null && typeof objInn["toJSON"] === "function") {
                return objInn.toJSON();
            }
            if ((typeof objInn === 'undefined' ? 'undefined' : _typeof(objInn)) === "object") {
                if (objInn.length) {
                    var arr = [];
                    for (var i = 0, len = objInn.length; i < len; i++) {
                        arr.push(_SuperMap2.default.Util.toJSON(objInn[i]));
                    }return "[" + arr.join(",") + "]";
                }
                var arr = [];
                for (var attr in objInn) {
                    //为解决SuperMap.Geometry类型头json时堆栈溢出的问题，attr == "parent"时不进行json转换
                    if (typeof objInn[attr] !== "function" && attr !== "CLASS_NAME" && attr !== "parent") {
                        arr.push("'" + attr + "':" + _SuperMap2.default.Util.toJSON(objInn[attr]));
                    }
                }

                if (arr.length > 0) {
                    return "{" + arr.join(",") + "}";
                } else {
                    return "{}";
                }
            }
            return objInn.toString();
    }
};

/**
 * @description 根据比例尺和dpi计算屏幕分辨率。
 * @param scale - {number} 比例尺。
 * @param dpi - {number} 图像分辨率，表示每英寸内的像素个数。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则DPI默认按照WGS84参考系的椭球体长半轴6378137来计算。
 * @return {number} 返回当前比例尺下的屏幕分辨率。
 */
_SuperMap2.default.Util.getResolutionFromScaleDpi = function (scale, dpi, coordUnit, datumAxis) {
    var resolution = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (scale > 0 && dpi > 0) {
        scale = _SuperMap2.default.Util.normalizeScale(scale);
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            //scale = SuperMap.Util.normalizeScale(scale);
            resolution = 0.0254 * ratio / dpi / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
            return resolution;
        } else {
            resolution = 0.0254 * ratio / dpi / scale / ratio;
            return resolution;
        }
    }
    return -1;
};

/**
 * @description 根据resolution、dpi、coordUnit和datumAxis计算比例尺。
 * @param resolution - {number} 用于计算比例尺的地图分辨率。
 * @param dpi - {number} 图像分辨率，表示每英寸内的像素个数。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则DPI默认按照WGS84参考系的椭球体长半轴6378137来计算。
 * @return {number} 返回当前屏幕分辨率下的比例尺。
 */
_SuperMap2.default.Util.getScaleFromResolutionDpi = function (resolution, dpi, coordUnit, datumAxis) {
    var scale = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (resolution > 0 && dpi > 0) {
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            scale = 0.0254 * ratio / dpi / resolution / (Math.PI * 2 * datumAxis / 360) / ratio;
            return scale;
        } else {
            scale = 0.0254 * ratio / dpi / resolution / ratio;
            return scale;
        }
    }
    return -1;
};

/**
 * @description 转换查询结果。
 * @param result - {Object} 查询结果。
 * @return {Object} 转换后的查询结果。
 */
_SuperMap2.default.Util.transformResult = function (result) {
    if (result.responseText && typeof result.responseText === "string") {
        //支持JSON对象的浏览器Firefox 3.1 + ，IE 8 RC1 +
        if (typeof JSON != 'undefined' && JSON.parse) {
            result = JSON.parse(result.responseText);
        } else {
            result = eval("(" + result.responseText + ")");
        }
    }
    return result;
};

/**
 * @description 属性拷贝，不拷贝方法类名(CLASS_NAME)等。
 * @param destination - {Object} 拷贝目标。
 * @param source - {Object} 源对象。
 *
 */
_SuperMap2.default.Util.copyAttributes = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 将源对象上的属性拷贝到目标对象上。（不拷贝 CLASS_NAME 和方法）
 * @param destination - {Object} 目标对象。
 * @param source - {Object} 源对象。
 * @param clip - {Array<string>} 源对象中禁止拷贝到目标对象的属性，目的是防止目标对象上不可修改的属性被篡改。
 *
 */
_SuperMap2.default.Util.copyAttributesWithClip = function (destination, source, clip) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            //去掉禁止拷贝的属性
            var isInClip = false;
            if (clip && clip.length) {
                for (var i = 0, len = clip.length; i < len; i++) {
                    if (property === clip[i]) {
                        isInClip = true;
                        break;
                    }
                }
            }
            if (isInClip === true) {
                continue;
            }

            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 克隆一份Object对象
 * @param obj - {Object}  需要克隆的对象。
 * @return {Object} 返回对象的拷贝对象，注意是新的对象，不是指向。
 */
_SuperMap2.default.Util.cloneObject = function (obj) {
    // Handle the 3 simple types, and null or undefined
    if (null === obj || "object" !== (typeof obj === 'undefined' ? 'undefined' : _typeof(obj))) return obj;

    // Handle Date
    if (obj instanceof Date) {
        var copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
    }

    // Handle Array
    if (obj instanceof Array) {
        var copy = obj.slice(0);
        return copy;
    }

    // Handle Object
    if (obj instanceof Object) {
        var copy = {};
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) {
                copy[attr] = _SuperMap2.default.Util.cloneObject(obj[attr]);
            }
        }
        return copy;
    }

    throw new Error("Unable to copy obj! Its type isn't supported.");
};

/**
 * @description 判断两条线段是不是有交点。
 * @param a1 - {SuperMap.Geometry.Point}  第一条线段的起始节点。
 * @param a2 - {SuperMap.Geometry.Point}  第一条线段的结束节点。
 * @param b1 - {SuperMap.Geometry.Point}  第二条线段的起始节点。
 * @param b2 - {SuperMap.Geometry.Point}  第二条线段的结束节点。
 * @return {Object} 如果相交返回交点，如果不相交返回两条线段的位置关系。
 */
_SuperMap2.default.Util.lineIntersection = function (a1, a2, b1, b2) {
    var intersectValue = null;
    var k1;
    var k2;
    var b = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
    var a = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
    var ab = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
    //ab==0代表两条线断的斜率一样
    if (ab != 0) {
        k1 = b / ab;
        k2 = a / ab;

        if (k1 >= 0 && k2 <= 1 && k1 <= 1 && k2 >= 0) {
            intersectValue = new _SuperMap2.default.Geometry.Point(a1.x + k1 * (a2.x - a1.x), a1.y + k1 * (a2.y - a1.y));
        } else {
            intersectValue = "No Intersection";
        }
    } else {

        if (b == 0 && a == 0) {
            var maxy = Math.max(a1.y, a2.y);
            var miny = Math.min(a1.y, a2.y);
            var maxx = Math.max(a1.x, a2.x);
            var minx = Math.min(a1.x, a2.x);
            if ((b1.y >= miny && b1.y <= maxy || b2.y >= miny && b2.y <= maxy) && b1.x >= minx && b1.x <= maxx || b2.x >= minx && b2.x <= maxx) {
                intersectValue = "Coincident"; //重合
            } else {
                intersectValue = "Parallel"; //平行
            }
        } else {
            intersectValue = "Parallel"; //平行
        }
    }
    return intersectValue;
};

/**
 * @description 获取文本外接矩形宽度与高度。
 * @param style - {SuperMap.Style} 文本样式。
 * @param text - {string} 文本内容。
 * @param element - {Object} DOM元素。
 * @return {Object} 返回裁剪后的宽度，高度信息。
 */
_SuperMap2.default.Util.getTextBounds = function (style, text, element) {
    document.body.appendChild(element);
    element.style.width = 'auto';
    element.style.height = 'auto';
    if (style.fontSize) element.style.fontSize = style.fontSize;
    if (style.fontFamily) element.style.fontFamily = style.fontFamily;
    if (style.fontWeight) element.style.fontWeight = style.fontWeight;
    element.style.position = 'relative';
    element.style.visibility = 'hidden';
    //fix 在某些情况下，element内的文本变成竖起排列，导致宽度计算不正确的bug
    element.style.display = 'inline-block';
    element.innerHTML = text;
    var textWidth = element.clientWidth;
    var textHeight = element.clientHeight;
    document.body.removeChild(element);
    return {
        textWidth: textWidth,
        textHeight: textHeight
    };
};

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.NetworkAnalystServiceBase
 * @classdesc 网络分析服务基类。
 * @description 网络分析服务基类。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 网络分析服务地址
 * @param options - {Object} 网络分析可选参数。如：<br>
 *        format - {{@link SuperMap.DataFormat}} 查询结果返回格式
 *
 */
var NetworkAnalystServiceBase = function (_CommonServiceBase) {
    _inherits(NetworkAnalystServiceBase, _CommonServiceBase);

    function NetworkAnalystServiceBase(url, options) {
        _classCallCheck(this, NetworkAnalystServiceBase);

        var _this = _possibleConstructorReturn(this, (NetworkAnalystServiceBase.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.NetworkAnalystServiceBase";

        if (options && options.format) {
            _this.format = options.format.toUpperCase();
        }
        return _this;
    }

    /**
     * @function SuperMap.NetworkAnalystServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    /**
     * @member SuperMap.NetworkAnalystServiceBase.prototype.format -{SuperMap.DataFormat}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *              参数格式为"ISERVER","GEOJSON"
     * @default "GEOJSON"
     */


    _createClass(NetworkAnalystServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(NetworkAnalystServiceBase.prototype.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                analystResult = me.toGeoJSONResult(result);
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。只处理结果中的路由，由子类实现
         * @param result - {Object} 服务器返回的结果对象。
         * @return{Object} geojson对象
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            return null;
        }
    }]);

    return NetworkAnalystServiceBase;
}(_CommonServiceBase3.default);

exports.default = NetworkAnalystServiceBase;

_SuperMap2.default.NetworkAnalystServiceBase = NetworkAnalystServiceBase;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _JoinItem = __webpack_require__(32);

var _JoinItem2 = _interopRequireDefault(_JoinItem);

var _LinkItem = __webpack_require__(199);

var _LinkItem2 = _interopRequireDefault(_LinkItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FilterParameter
 * @classdesc 查询过滤条件参数类。该类用于设置查询数据集的查询过滤参数。
 * @param options - {Object} 可选参数。如:<br>
 *        attributeFilter - {string} 属性过滤条件。</br>
 *        name - {string} 查询数据集名称或者图层名称。</br>
 *        joinItems - {Array<{@link SuperMap.JoinItem}>} 与外部表的连接信息 SuperMap.JoinItem 数组。</br>
 *        linkItems - {Array<{@link SuperMap.LinkItem}>} 与外部表的关联信息 SuperMap.LinkItem 数组。</br>
 *        ids - {Array<string>} 查询 id 数组，即属性表中的 SmID 值。</br>
 *        orderBy - {string} 查询排序的字段, orderBy 的字段须为数值型的。</br>
 *        groupBy - {string} 查询分组条件的字段。</br>
 *        fields - {Array<string>} 查询字段数组。</br>
 */
var FilterParameter = function () {

  /**
     * @member SuperMap.FilterParameter.prototype.groupBy - {string}
     * @description 查询分组条件的字段。
     * 相当于 SQL 语句中的 GROUP BY 子句，其格式为：GROUP BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段分组时，该字段的用法为 groupBy = "字段名"；
     * 对多个字段分组时，字段之间以英文逗号进行分割，用法为 groupBy = "字段名1, 字段名2"。
     * 例如，现有一个全球城市数据集，该数据集有两个字段分别为“Continent”和“Country”，
     * 分别表示某个城市所属的洲和国家。
     * 如果要按照国家对全球的城市进行分组， 可以设置 groupBy = "Country"；
     * 如果以洲和国家对城市进行分组，设置 groupBy = "Continent, Country"。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.ids -{Array<string>}
     * @description 查询 id 数组，即属性表中的 SmID 值。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.joinItems - {Array<SuperMap.JoinItem>}
     * @description 与外部表的连接信息 SuperMap.JoinItem 数组。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.attributeFilter - {string}
     * @description 属性过滤条件。
     * 相当于 SQL 语句中的 WHERE 子句，其格式为：WHERE <条件表达式>，
     * attributeFilter 就是其中的“条件表达式”。
     * 该字段的用法为 attributeFilter = "过滤条件"。
     * 例如，要查询字段 fieldValue 小于100的记录，设置 attributeFilter = "fieldValue < 100"；
     * 要查询字段 name 的值为“酒店”的记录，设置 attributeFilter = "name like '%酒店%'"，等等。
     */
  function FilterParameter(options) {
    _classCallCheck(this, FilterParameter);

    this.attributeFilter = null;
    this.name = null;
    this.joinItems = null;
    this.linkItems = null;
    this.ids = null;
    this.orderBy = null;
    this.groupBy = null;
    this.fields = null;
    this.CLASS_NAME = "SuperMap.FilterParameter";

    if (options) {
      _SuperMap2.default.Util.extend(this, options);
    }
  }

  /**
     * @function SuperMap.FilterParameter.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.fields - {Array<string>}
     * @description 查询字段数组，如果不设置则使用系统返回的所有字段。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.orderBy - {string}
     * @description 查询排序的字段,orderBy的字段须为数值型的。
     * 相当于 SQL 语句中的 ORDER BY 子句，其格式为：ORDER BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段排序时，该字段的用法为 orderBy = "字段名"；
     * 对多个字段排序时，字段之间以英文逗号进行分割，用法为 orderBy = "字段名1, 字段名2"。
     * 例如，现有一个国家数据集，它有两个字段分别为“SmArea”和“pop_1994”，
     * 分别表示国家的面积和1994年的各国人口数量。
     * 如果要按照各国人口数量对记录进行排序，则 orderBy = "pop_1994"；
     * 如果要以面积和人口进行排序，则 orderBy = "SmArea, pop_1994"。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.linkItems - {Array<SuperMap.LinkItem>}
     * @description 与外部表的关联信息 LinkItem 数组。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.name - {string}
     * @description 查询数据集名称或者图层名称，根据实际的查询对象而定，必设属性。
     * 一般情况下该字段为数据集名称，但在进行与地图相关功能的操作时，
     * 需要设置为图层名称（图层名称格式：数据集名称@数据源别名）。
     * 因为一个地图的图层可能是来自于不同数据源的数据集，
     * 而不同的数据源中可能存在同名的数据集，
     * 使用数据集名称不能唯一的确定数据集，
     * 所以在进行与地图相关功能的操作时，该值需要设置为图层名称。
     */


  _createClass(FilterParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.attributeFilter = null;
      me.name = null;
      if (me.joinItems) {
        for (var i = 0, joinItems = me.joinItems, len = joinItems.length; i < len; i++) {
          joinItems[i].destroy();
        }
        me.joinItems = null;
      }
      if (me.linkItems) {
        for (var i = 0, linkItems = me.linkItems, len = linkItems.length; i < len; i++) {
          linkItems[i].destroy();
        }
        me.linkItems = null;
      }
      me.ids = null;
      me.orderBy = null;
      me.groupBy = null;
      me.fields = null;
    }
  }]);

  return FilterParameter;
}();

exports.default = FilterParameter;

_SuperMap2.default.FilterParameter = FilterParameter;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Geometry2 = __webpack_require__(40);

var _Geometry3 = _interopRequireDefault(_Geometry2);

var _Bounds = __webpack_require__(39);

var _Bounds2 = _interopRequireDefault(_Bounds);

var _Util = __webpack_require__(7);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Point
 * @classdesc 点几何对象类。
 * @extends {SuperMap.Geometry}
 * @param  x - {float} x-坐标
 * @param y - {float} y-坐标
 * @param type - {string} 用来存储点的类型
 * @param tag -  {float} 用来存储额外的属性，比如差值分析中的Z值。
 * @example
 * var point = new SuperMap.Geometry.Point(-111.04, 45.68);
 */
var Point = function (_Geometry) {
    _inherits(Point, _Geometry);

    /**
     * @member SuperMap.Geometry.Point.prototype.tag - {string}
     * @description  用来存储额外的属性，比如差值分析中的Z值。
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.x - {float}
     * @description 横坐标。
     */
    function Point(x, y, type, tag) {
        _classCallCheck(this, Point);

        var _this = _possibleConstructorReturn(this, (Point.__proto__ || Object.getPrototypeOf(Point)).call(this, x, y, type, tag));

        _this.x = null;
        _this.y = null;
        _this.tag = null;
        _this.type = null;
        _this.CLASS_NAME = "SuperMap.Geometry.Point";


        _this.x = parseFloat(x);
        _this.y = parseFloat(y);
        if (tag || tag == 0) {
            _this.tag = parseFloat(tag);
        }
        _this.type = type || "NONE";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Point.prototype.clone
     * @description 克隆点对象。
     * @returns {SuperMap.Geometry.Point} 克隆后的点对象。
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.tag - {string}
     * @description  用来存储点的类型
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.y - {float}
     * @description 纵坐标。
     */


    _createClass(Point, [{
        key: 'clone',
        value: function clone(obj) {
            if (obj == null) {
                obj = new Point(this.x, this.y);
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(obj, this);

            return obj;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.calculateBounds
         * @description 计算点对象的范围。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = new _Bounds2.default(this.x, this.y, this.x, this.y);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.distanceTo
         * @description 计算两个点对象间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标点对象。
         * @param options - {Object} 计算距离时需要设置的可选属性。有效的选项取决于特定的几何类型。<br>
         *         details - {boolean} 返回距离计算的细节。默认为false。<br>
         *         edge - {boolean} 计算一个几何对象到目标几何对象边缘的最近距离。默认为true。 如果设为true，
         *                          一个几何对象完全包含在目标几何对象中时，调用distanceTo返回非零结果，如果
         *                          false，两个几何对象相交情况下调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何对象到目标几何对象的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var distance, x0, y0, x1, y1, result;
            if (geometry instanceof Point) {
                x0 = this.x;
                y0 = this.y;
                x1 = geometry.x;
                y1 = geometry.y;
                distance = Math.sqrt(Math.pow(x0 - x1, 2) + Math.pow(y0 - y1, 2));
                result = !details ? distance : { x0: x0, y0: y0, x1: x1, y1: y1, distance: distance };
            } else {
                result = geometry.distanceTo(this, options);
                if (details) {
                    // switch coord order since this geom is target
                    result = {
                        x0: result.x1, y0: result.y1,
                        x1: result.x0, y1: result.y0,
                        distance: result.distance
                    };
                }
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.equals
         * @description 判断两个点对象是否相等。如果两个点对象具有相同的坐标，则认为是相等的。
         * @example
         * var point= new SuperMap.Geometry.Point(0,0);
         * var point1={x:0,y:0};
         * var result= point.equals(point1);
         * @param geom - {SuperMap.Geometry.Point} 需要判断的点对象。
         * @returns {boolean} 两个点对象是否相等（true为相等，false为不等）。
         */

    }, {
        key: 'equals',
        value: function equals(geom) {
            var equals = false;
            if (geom != null) {
                equals = this.x === geom.x && this.y === geom.y || isNaN(this.x) && isNaN(this.y) && isNaN(geom.x) && isNaN(geom.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.toShortString
         * @returns {string} 字符串代表点对象。(ex. <i>"5, 42"</i>)
         */

    }, {
        key: 'toShortString',
        value: function toShortString() {
            return this.x + ", " + this.y;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.move
         * @description 沿着x、y轴的正方向上按照给定的位移移动点对象，move 不仅改变了几何对象的位置并且清理了边界缓存。
         * @param x - {float} x轴正方向上的偏移量。
         * @param  y - {float} y轴正方向上偏移量。
         * @example
         * var point = new SuperMap.Geometry.Point(10,20);
         * var dx = 10*Math.random();
         * var dy = 10*Math.random();
         * point.move(dx,dy);
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            this.x = this.x + x;
            this.y = this.y + y;
            this.clearBounds();
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.rotate
         * @description 围绕中心点旋转点对象。
         * @param angle - {float} 旋转角的度数（沿着x轴正方向的逆时针方向）。
         * @param origin - {SuperMap.Geometry.Point} 旋转的中心点 。
         * @example
         * var point = new SuperMap.Geometry.Point(10,20);
         * var rotateOrigin = new SuperMap.Geometry.Point(5,10);
         * point.rotate(360,rotateOrigin);
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            angle *= Math.PI / 180;
            var radius = this.distanceTo(origin);
            var theta = angle + Math.atan2(this.y - origin.y, this.x - origin.x);
            this.x = origin.x + radius * Math.cos(theta);
            this.y = origin.y + radius * Math.sin(theta);
            this.clearBounds();
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.getCentroid
         * @description 获取点对象的质心。
         * @returns {SuperMap.Geometry.Point} 点对象的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            return new Point(this.x, this.y);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.resize
         * @description 调整几何对象相对于原点的大小。
         * @param scale - {float} resize之后到原点的距离与resize之前到原点的距离比。
         * @param origin - {SuperMap.Geometry.Point} 调整的起始点。
         * @param ratio - {float} 点对象自身x与y的比值：ratio=x/y，默认的比例为1，不推荐设置。
         * @returns {SuperMap.Geometry} - 当前几何对象。
         * @example
         * var point = new SuperMap.Geometry.Point(10,10);
         * var origin = new SuperMap.Geometry.Point(0,0);
         * point.resize(2,origin,4);
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            ratio = ratio == undefined ? 1 : ratio;
            //所有的线和面最终都是控制点
            this.x = origin.x + scale * ratio * (this.x - origin.x);

            this.y = origin.y + scale * (this.y - origin.y);
            this.clearBounds();
            return this;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.intersects
         * @description 判断两个几何对象是否相交。
         * @param geometry - {SuperMap.Geometry} 任意类型的几何对象。
         * @returns {boolean} 传入的几何对象与当前几何对象相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.equals(geometry);
            } else {
                intersect = geometry.intersects(this);
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.destroy
         * @description 释放点对象的资源
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.tag = null;
            _get(Point.prototype.__proto__ || Object.getPrototypeOf(Point.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.getVertices
         * @description 返回点对象的所有顶点的列表。
         * @param nodes - {boolean} 对于点对象此参数不起作用，直接返回点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            return [this];
        }
    }]);

    return Point;
}(_Geometry3.default);

exports.default = Point;

_SuperMap2.default.Geometry.Point = Point;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerColor
 * @classdesc 颜色类。该类使用三原色（ RGB ）来表达颜色。
 * @param options - {Object} 可选参数。如：<br>
 *        red - {number}获取或设置红色值,默认值为255。<br>
 *        green - {number}获取或设置绿色值,默认值为0。<br>
 *        blue - {number}获取或设置蓝色值,默认值为0。
 */
var ServerColor = function () {

    /**
     * @member SuperMap.ServerColor.prototype.green -{number}
     * @description 获取或设置绿色值,默认值为0。
     * @default 0
     */
    function ServerColor(red, green, blue) {
        _classCallCheck(this, ServerColor);

        this.red = 255;
        this.green = 0;
        this.blue = 0;
        this.CLASS_NAME = "SuperMap.ServerColor";

        if (!red && red != 0) {
            this.red = 255;
        } else {
            this.red = red;
        }

        if (!green && green != 0) {
            this.green = 0;
        } else {
            this.green = green;
        }

        if (!blue && blue != 0) {
            this.blue = 0;
        } else {
            this.blue = blue;
        }
    }

    /**
     * @function SuperMap.ServerColor.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerColor.prototype.blue -{number}
     * @description 获取或设置蓝色值,默认值为0。
     * @default 0
     */


    /**
     * @member SuperMap.ServerColor.prototype.red -{number}
     * @description 获取或设置红色值,默认值为255。
     * @default 255
     */


    _createClass(ServerColor, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.red = null;
            me.green = null;
            me.blue = null;
        }

        /**
         * @function SuperMap.ServerColor.formJson
         * @description 将JSON对象转化为ServerColor对象。
         * @param jsonObject - {Object} 要转换的JSON对象
         * @return{SuperMap.ServerColor} 转化后的ServerColor对象。
         */

    }], [{
        key: "fromJson",
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            var color = new ServerColor();
            var red = 255;
            if (jsonObject.red !== null) {
                red = Number(jsonObject.red);
            }
            color.red = red;

            var green = 0;
            if (jsonObject.green !== null) {
                green = Number(jsonObject.green);
            }
            color.green = green;

            var blue = 0;
            if (jsonObject.blue !== null) {
                blue = Number(jsonObject.blue);
            }
            color.blue = blue;
            return color;
        }
    }]);

    return ServerColor;
}();

exports.default = ServerColor;


_SuperMap2.default.ServerColor = ServerColor;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ThemeMemoryData = __webpack_require__(235);

var _ThemeMemoryData2 = _interopRequireDefault(_ThemeMemoryData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Theme
 * @classdesc 专题图基类。
 * @param  type - {string} 专题图类型。
 * @param options - {Object} 可选参数。如：<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var Theme = function () {

    /**
     * @member SuperMap.Theme.prototype.memoryData -{SuperMap.ThemeMemoryData}
     * @description 专题图内存数据。<br>
     *              用内存数据制作专题图的方式与表达式制作专题图的方式互斥，前者优先级较高。
     *              第一个参数代表专题值，即数据集中用来做专题图的字段或表达式的值；第二个参数代表外部值。在制作专题图时，会用外部值代替专题值来制作相应的专题图。
     */
    function Theme(type, options) {
        _classCallCheck(this, Theme);

        this.memoryData = null;
        this.type = null;
        this.CLASS_NAME = "SuperMap.Theme";

        if (!type) {
            return this;
        }
        this.type = type;
        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.Theme.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.Theme.prototype.type -{string}
     * @description 专题图类型。
     */


    _createClass(Theme, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.memoryData) {
                me.memoryData.destroy();
                me.memoryData = null;
            }
            me.type = null;
        }

        /**
         * @function SuperMap.Theme.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            //return 子类实现
            return;
        }
    }]);

    return Theme;
}();

exports.default = Theme;


_SuperMap2.default.Theme = Theme;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _Geometry2 = __webpack_require__(40);

var _Geometry3 = _interopRequireDefault(_Geometry2);

var _Util = __webpack_require__(7);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Collection
 * @classdesc 几何对象集合类，存储在本地的 components 属性中（可作为参数传递给构造函数）。
 *            随着新的几何图形添加到集合中，将不能被克隆，当移动几何图形时，需要指定参照物。
 *            getArea和getLength函数只能通过遍历存储几何对象的 components 数组，总计所有几何图形的面积和长度。
 *
 * @extends SuperMap.Geometry
 * @param components - {Array<SuperMap.Geometry>} 几何对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(10,20);
 * var point2 = new SuperMap.Geometry.Point(30,40);
 * var col = new SuperMap.Geometry.Collection([point1,point2]);
 */
var Collection = function (_Geometry) {
    _inherits(Collection, _Geometry);

    /**
     * @description 存储几何对象的数组。
     * @member SuperMap.Geometry.Collection.prototype.components - {Array<SuperMap.Geometry>}
     */
    function Collection(components) {
        _classCallCheck(this, Collection);

        var _this = _possibleConstructorReturn(this, (Collection.__proto__ || Object.getPrototypeOf(Collection)).call(this));

        _this.components = null;
        _this.componentTypes = null;
        _this.CLASS_NAME = "SuperMap.Geometry.Collection";

        _this.components = [];
        if (components != null) {
            _this.addComponents(components);
        }
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Collection.prototype.destroy
     * @description 销毁几何图形。
     */


    /**
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @member SuperMap.Geometry.Collection.prototype.componentTypes - {Array<string>}
     */


    _createClass(Collection, [{
        key: 'destroy',
        value: function destroy() {
            this.components.length = 0;
            this.components = null;
            _get(Collection.prototype.__proto__ || Object.getPrototypeOf(Collection.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.clone
         * @description 克隆当前几何对象。
         * @returns {SuperMap.Geometry.Collection} 克隆的几何对象集合。
         */

    }, {
        key: 'clone',
        value: function clone() {
            var geometry = eval("new " + this.CLASS_NAME + "()");
            for (var i = 0, len = this.components.length; i < len; i++) {
                geometry.addComponent(this.components[i].clone());
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(geometry, this);

            return geometry;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getComponentsString
         * @description 获取components字符串。
         * @returns {string} components字符串。
         */

    }, {
        key: 'getComponentsString',
        value: function getComponentsString() {
            var strings = [];
            for (var i = 0, len = this.components.length; i < len; i++) {
                strings.push(this.components[i].toShortString());
            }
            return strings.join(",");
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.calculateBounds
         * @description 通过遍历数组重新计算边界，在遍历每一子项中时调用 extend 方法。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = null;
            var bounds = new _SuperMap2.default.Bounds();
            var components = this.components;
            if (components) {
                for (var i = 0, len = components.length; i < len; i++) {
                    bounds.extend(components[i].getBounds());
                }
            }
            // to preserve old behavior, we only set bounds if non-null
            // in the future, we could add bounds.isEmpty()
            if (bounds.left != null && bounds.bottom != null && bounds.right != null && bounds.top != null) {
                this.setBounds(bounds);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponents
         * @description 给几何图形对象添加元素。
         * @param components - {Array<SuperMap.Geometry>} 几何对象组件。
         * @example
         * var collection = new SuperMap.Geometry.Collection();
         * collection.addComponents(new SuerpMap.Geometry.Point(10,10));
         */

    }, {
        key: 'addComponents',
        value: function addComponents(components) {
            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = 0, len = components.length; i < len; i++) {
                this.addComponent(components[i]);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponent
         * @description 添加一个几何对象到集合中。如果设置了componentTypes类型，则添加的几何对象必须是componentTypes中的类型。
         * @param component - {SuperMap.Geometry} 待添加的几何对象。
         * @param index - {int} 几何对象插入的位置。
         * @returns {boolean} 是否添加成功。
         */

    }, {
        key: 'addComponent',
        value: function addComponent(component, index) {
            var added = false;
            if (component) {
                if (this.componentTypes == null || _Util.Util.indexOf(this.componentTypes, component.CLASS_NAME) > -1) {

                    if (index != null && index < this.components.length) {
                        var components1 = this.components.slice(0, index);
                        var components2 = this.components.slice(index, this.components.length);
                        components1.push(component);
                        this.components = components1.concat(components2);
                    } else {
                        this.components.push(component);
                    }
                    component.parent = this;
                    this.clearBounds();
                    added = true;
                }
            }
            return added;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponents
         * @description 清除几何对象。
         * @param components - {Array<SuperMap.Geometry>} 需要清除的几何对象。
         * @returns {boolean} 元素是否被删除。
         */

    }, {
        key: 'removeComponents',
        value: function removeComponents(components) {
            var removed = false;

            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = components.length - 1; i >= 0; --i) {
                removed = this.removeComponent(components[i]) || removed;
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponent
         * @description 从集合中移除一个几何对象
         * @param component - {SuperMap.Geometry} 要移除的几何对象
         * @returns {boolean} 几何对象是否移除成功
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(component) {
            _Util.Util.removeItem(this.components, component);

            // clearBounds() so that it gets recalculated on the next call
            // to this.getBounds();
            this.clearBounds();
            return true;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getLength
         * @description 计算几何对象长度。
         * @returns {number} 几何对象长度（所有几何对象长度总和）。
         */

    }, {
        key: 'getLength',
        value: function getLength() {
            var length = 0.0;
            for (var i = 0, len = this.components.length; i < len; i++) {
                length += this.components[i].getLength();
            }
            return length;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getArea
         * @description 计算几何对象的面积。注意，这个方法在 <SuperMap.Geometry.Polygon> 类中需要重写。
         * @returns {number} 几何图形的面积，是几何对象中所有组成部分的面积之和。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            for (var i = 0, len = this.components.length; i < len; i++) {
                area += this.components[i].getArea();
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getCentroid
         * @description 计算几何图形集合的质心。
         * @param weighted - {boolean} 执行getCentroid方法进行递归计算，返回此几何图形集合中的面积加权平均值。
         * @returns {SuperMap.Geometry.Point} 质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid(weighted) {
            if (!weighted) {
                return this.components.length && this.components[0].getCentroid();
            }
            var len = this.components.length;
            if (!len) {
                return false;
            }

            var areas = [];
            var centroids = [];
            var areaSum = 0;
            var minArea = Number.MAX_VALUE;
            var component;
            for (var i = 0; i < len; ++i) {
                component = this.components[i];
                var area = component.getArea();
                var centroid = component.getCentroid(true);
                if (isNaN(area) || isNaN(centroid.x) || isNaN(centroid.y)) {
                    continue;
                }
                areas.push(area);
                areaSum += area;
                minArea = area < minArea && area > 0 ? area : minArea;
                centroids.push(centroid);
            }
            len = areas.length;
            if (areaSum === 0) {
                // all the components in this collection have 0 area
                // probably a collection of points -- weight all the points the same
                for (var i = 0; i < len; ++i) {
                    areas[i] = 1;
                }
                areaSum = areas.length;
            } else {
                // normalize all the areas where the smallest area will get
                // a value of 1
                for (var i = 0; i < len; ++i) {
                    areas[i] /= minArea;
                }
                areaSum /= minArea;
            }

            var xSum = 0,
                ySum = 0,
                centroid,
                area;
            for (var i = 0; i < len; ++i) {
                centroid = centroids[i];
                area = areas[i];
                xSum += centroid.x * area;
                ySum += centroid.y * area;
            }

            return new _Point2.default(xSum / areaSum, ySum / areaSum);
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.move
         * @description  沿着x、y轴的正方向上按照给定的位移移动几何图形，move 不仅改变了几何图形的位置并且清理了边界缓存。
         * @param x -{number} x轴正方向上移动的距离。
         * @param y - {number} y轴正方向上移动的距离。
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            for (var i = 0, len = this.components.length; i < len; i++) {
                this.components[i].move(x, y);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.rotate
         * @description 围绕中心点旋转几何图形。
         * @param angle -{number} 旋转角的度数（沿着x轴正方向逆时针测量）。
         * @param origin - {SuperMap.Geometry.Point} 旋转中心点。
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            for (var i = 0, len = this.components.length; i < len; ++i) {
                this.components[i].rotate(angle, origin);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.resize
         * @description  调整几何对象大小。
         * @param scale - {number} 几何图形缩放的比例系数，是几何图形维数的两倍。（如，对于线来说将以线2倍的长度拉长，对于多边形来说，将以面积的4倍变化）。
         * @param origin - {SuperMap.Geometry.Point} 调整大小选定的起始原点。
         * @param ratio - {number} 可选的x,y的比例，默认的比例为1。
         * @returns {SuperMap.Geometry} 几何图形。
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            for (var i = 0; i < this.components.length; ++i) {
                this.components[i].resize(scale, origin, ratio);
            }
            return this;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标几何图形。
         * @param options - {Object} 距离计算需要设置的可选属性。有效的选项取决于特定的几何类型。<br>
         *        details - {boolean} 返回距离计算的细节。默认为false。<br>
         *        edge - {boolean} 计算一个几何图形到目标几何图形边缘的最近距离。默认为true。
         *                         如果设为true，一个几何图形完全包含在目标几何图形中时，调用distanceTo返回非零结果，
         *                         如果false，两个几何图形相交情况下调用distanceTo结果返回0，而且如果false，将不返距离值。
         * @returns {(number | Object)} 返回一个几何图形到目标几何图形的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var result, best, distance;
            var min = Number.POSITIVE_INFINITY;
            for (var i = 0, len = this.components.length; i < len; ++i) {
                result = this.components[i].distanceTo(geometry, options);
                distance = details ? result.distance : result;
                if (distance < min) {
                    min = distance;
                    best = result;
                    if (min == 0) {
                        break;
                    }
                }
            }
            return best;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.equals
         * @description 判断两个几何图形是否相等。如果所有的 components 具有相同的坐标，则认为是相等的。
         * @param geometry - {SuperMap.Geometry} 需要判断的几何图形。
         * @returns {boolean} 输入的几何图形与当前几何图形是否相等。
         */

    }, {
        key: 'equals',
        value: function equals(geometry) {
            var equivalent = true;
            if (!geometry || !geometry.CLASS_NAME || this.CLASS_NAME !== geometry.CLASS_NAME) {
                equivalent = false;
            } else if (!_Util.Util.isArray(geometry.components) || geometry.components.length !== this.components.length) {
                equivalent = false;
            } else {
                for (var i = 0, len = this.components.length; i < len; ++i) {
                    if (!this.components[i].equals(geometry.components[i])) {
                        equivalent = false;
                        break;
                    }
                }
            }
            return equivalent;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.intersects
         * @description 判断输入的几何对象是否与当前几何对象相交。
         * @param geometry - {SuperMap.Geometry} 任意的几何类型。
         * @returns {boolean} 输入几何对象与当前几何对象相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            for (var i = 0, len = this.components.length; i < len; ++i) {
                intersect = geometry.intersects(this.components[i]);
                if (intersect) {
                    break;
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getVertices
         * @description 返回几何对象的所有结点的列表。
         * @param nodes - {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices = [];
            for (var i = 0, len = this.components.length; i < len; ++i) {
                Array.prototype.push.apply(vertices, this.components[i].getVertices(nodes));
            }
            return vertices;
        }
    }]);

    return Collection;
}(_Geometry3.default);

exports.default = Collection;

_SuperMap2.default.Geometry.Collection = Collection;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _FilterParameter = __webpack_require__(9);

var _FilterParameter2 = _interopRequireDefault(_FilterParameter);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.QueryParameters
 * @classdesc 查询参数基类。距离查询、SQL 查询、几何地物查询等各自的参数均继承此类。
 * @param options - {Object} 可选参数。如：<br>
 *         customParams - {string} 自定义参数，供扩展使用。<br>
 *         prjCoordSys - {Object} 自定义参数，供isueprmap提供的动态投影查询扩展使用。如 {"epsgCode":3857}。<br>
 *         expectCount - {number}期望返回结果记录个数。<br>
 *         networkType - {{@link SuperMap.GeometryType}} 网络数据集对应的查询类型。<br>
 *         queryOption - {{@link SuperMap.QueryOption}} 查询结果类型枚举类。<br>
 *         queryParams - {Array<{@link SuperMap.FilterParameter}>}查询过滤条件参数数组。<br>
 *         startRecord - {number}查询起始记录号。<br>
 *         holdTime - {number}资源在服务端保存的时间。<br>
 *         returnCustomResult -{boolean} 仅供三维使用。
 */
var QueryParameters = function () {

    /**
     * @member SuperMap.QueryParameters.prototype.holdTime -{number}
     * @description 资源在服务端保存的时间。默认为10（分钟）。
     * @default 10
     */


    /**
     * @member SuperMap.QueryParameters.prototype.queryParams -{Array<SuperMap.FilterParameter>}
     * @description 查询过滤条件参数数组。
     *               该类用于设置查询数据集的查询过滤参数。
     */


    /**
     * @member SuperMap.QueryParameters.prototype.networkType -{SuperMap.GeometryType}
     * @description 网络数据集对应的查询类型，
     *               分为点和线两种类型，默认为线几何对象类型，即{@link GeometryType.LINE | SuperMap.GeometryType.LINE}。
     * @default  {@link SuperMap.GeometryType.LINE}
     */


    /**
     * @member SuperMap.QueryParameters.prototype.prjCoordSys -{Object}
     * @description 自定义参数，供isueprmap提供的动态投影查询扩展使用。如 {"epsgCode":3857}
     */
    function QueryParameters(options) {
        _classCallCheck(this, QueryParameters);

        this.customParams = null;
        this.prjCoordSys = null;
        this.expectCount = 100000;
        this.networkType = _REST.GeometryType.LINE;
        this.queryOption = _REST.QueryOption.ATTRIBUTEANDGEOMETRY;
        this.queryParams = null;
        this.startRecord = 0;
        this.holdTime = 10;
        this.returnCustomResult = false;
        this.CLASS_NAME = "SuperMap.QueryParameters";

        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     * @function SuperMap.QueryParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.QueryParameters.prototype.returnCustomResult -{boolean}
     * @description 仅供三维使用。
     * @default false
     */


    /**
     * @member SuperMap.QueryParameters.prototype.startRecord -{number}
     * @description 查询起始记录号，默认值为0。
     * @default 0
     */


    /**
     * @member SuperMap.QueryParameters.prototype.queryOption -{SuperMap.QueryOption}
     * @description 查询结果类型枚举类。
     *               该类描述查询结果返回类型，包括只返回属性、
     *               只返回几何实体以及返回属性和几何实体。
     * @default {@link SuperMap.QueryOption.ATTRIBUTEANDGEOMETRY}
     */


    /**
     * @member SuperMap.QueryParameters.prototype.expectCount -{number}
     * @description 期望返回结果记录个数，默认返回100000条查询记录，
     *               如果实际不足100000条则返回实际记录条数。
     * @default 100000
     */


    /**
     * @member SuperMap.QueryParameters.prototype.customParams -{string}
     * @description 自定义参数，供扩展使用。
     */


    _createClass(QueryParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.customParams = null;
            me.expectCount = null;
            me.networkType = null;
            me.queryOption = null;
            if (me.queryParams) {
                for (var i = 0, qps = me.queryParams, len = qps.length; i < len; i++) {
                    qps[i].destroy();
                }
                me.queryParams = null;
            }
            me.startRecord = null;
            me.holdTime = null;
            me.returnCustomResult = null;
            me.prjCoordSys = null;
        }
    }]);

    return QueryParameters;
}();

exports.default = QueryParameters;


_SuperMap2.default.QueryParameters = QueryParameters;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _ServerColor = __webpack_require__(11);

var _ServerColor2 = _interopRequireDefault(_ServerColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerTextStyle
 * @classdesc 服务端文本风格类
 * @description 该类用于定义文本风格的相关属性。
 * @param options - {Object} 可选参数。如：<br>
 *        align - {{@link SuperMap.TextAlignment}} 文本的对齐方式。<br>
 *        backColor - {{@link SuperMap.ServerColor}} 文本的背景色。<br>
 *        foreColor - {{@link SuperMap.ServerColor}} 文本的前景色。<br>
 *        backOpaque - {boolean} 文本背景是否不透明。<br>
 *        sizeFixed - {boolean} 文本大小是否固定。<br>
 *        fontHeight - {number}文本字体的高度。<br>
 *        fontWidth - {number}文本字体的宽度。<br>
 *        fontWeight - {integer} 文本字体的磅数。<br>
 *        fontName - {string} 文本字体的名称。<br>
 *        bold - {boolean} 文本是否为粗体字。<br>
 *        italic - {boolean}文本是否采用斜体。<br>
 *        italicAngle - {number}字体倾斜角度。<br>
 *        shadow - {boolean} 文本是否有阴影。<br>
 *        strikeout - {boolean} 文本字体是否加删除线。<br>
 *        outline - {boolean} 是否以轮廓的方式来显示文本的背景。<br>
 *        opaqueRate - {number}注记文字的不透明度。<br>
 *        underline - {boolean} 文本字体是否加下划线。<br>
 *        rotation -  {number} 文本旋转的角度。
 */
var ServerTextStyle = function () {

    /**
     * @member SuperMap.ServerTextStyle.prototype.underline -{boolean}
     * @description 文本字体是否加下划线。true 表示加下划线。默认为 false。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.outline -{boolean}
     * @description 是否以轮廓的方式来显示文本的背景。true 表示以轮廓的方式来显示文本的背景。默认值为 false，表示不以轮廓的方式来显示文本的背景。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.shadow -{boolean}
     * @description 文本是否有阴影。true 表示给文本增加阴影。默认值为 false，即文本没有阴影。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.italic -{boolean}
     * @description 文本是否采用斜体。true 表示采用斜体。默认为 false。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontName -{string}
     * @description 文本字体的名称。默认值为 Times New Roman。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontWidth -{number}
     * @description 文本字体的宽度。字体的宽度以英文字符为标准，由于一个中文字符相当于两个英文字符，默认为0地图坐标单位。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.sizeFixed -{boolean}
     * @description 文本大小是否固定。默认为 true，表示图片为固定像素大小，具体大小请参考 fontHeight。当设为 false 时，图片会随着地图缩放而缩放。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.foreColor -{SuperMap.ServerColor}
     * @description 文本的前景色。默认为黑色。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.align -{SuperMap.TextAlignment}
     * @description 文本的对齐方式。默认为 SuperMap.TextAlignment.BASELINECENTER（基准线居中对齐）。
     */
    function ServerTextStyle(options) {
        _classCallCheck(this, ServerTextStyle);

        this.align = _REST.TextAlignment.BASELINECENTER;
        this.backColor = null;
        this.foreColor = null;
        this.backOpaque = false;
        this.sizeFixed = true;
        this.fontHeight = 6;
        this.fontWidth = 0;
        this.fontWeight = 400;
        this.fontName = "Times New Roman";
        this.bold = false;
        this.italic = false;
        this.italicAngle = 0;
        this.shadow = false;
        this.strikeout = false;
        this.outline = false;
        this.opaqueRate = 0;
        this.underline = false;
        this.rotation = 0.0;
        this.CLASS_NAME = "SuperMap.ServerTextStyle";

        var me = this;
        me.backColor = new _ServerColor2.default(255, 255, 255);
        me.foreColor = new _ServerColor2.default(0, 0, 0);
        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ServerTextStyle.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.rotation -{number}
     * @description 文本旋转的角度。逆时针方向为正方向，单位为度，精确到0.1度。默认值为0.0。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.opaqueRate -{number}
     * @description 注记文字的不透明度。不透明度的范围为0-100。默认为0，表示透明。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.strikeout -{boolean}
     * @description 文本字体是否加删除线。true 表示加删除线。默认值为 false，即文本字体不加删除线。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.italicAngle -{number}
     * @description 字体倾斜角度。正负度之间，以度为单位，精确到0.1度，默认为0度。当倾斜角度为0度，为系统默认的字体倾斜样式。
     *              正负度是指以纵轴为起始零度线，其纵轴左侧为正，右侧为负。允许的最大角度为60，最小-60。大于60按照60处理，小于-60按照-60处理。目前只对标签专题图有效。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.bold -{boolean}
     * @description 文本是否为粗体字。true 表示为粗体。默认值为 false，即文本不是粗体字。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontWeight -{integer}
     * @description 文本字体的磅数。表示粗体的具体数值。取值范围为从0－900之间的整百数，默认值为400。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontHeight -{number}
     * @description 文本字体的高度，默认为6，单位与 sizeFixed 有关，当 sizeFixed 为 False 时，即非固定文本大小时使用地图坐标单位，
     *              如地理坐标系下的地图中单位为度；当 sizeFixed 为 True 时，单位为毫米（mm）。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.backOpaque -{boolean}
     * @description 文本背景是否不透明。true 表示文本背景不透明。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.backColor -{SuperMap.ServerColor}
     * @description 文本的背景色。默认为白色。
     */


    _createClass(ServerTextStyle, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.align = null;
            if (me.backColor) {
                me.backColor.destroy();
                me.backColor = null;
            }
            if (me.foreColor) {
                me.foreColor.destroy();
                me.foreColor = null;
            }
            me.backOpaque = null;
            me.sizeFixed = null;
            me.fontHeight = null;
            me.fontWidth = null;
            me.fontWeight = null;
            me.fontName = null;
            me.bold = null;
            me.italic = null;
            me.italicAngle = null;
            me.shadow = null;
            me.strikeout = null;
            me.outline = null;
            me.opaqueRate = null;
            me.underline = null;
            me.rotation = null;
        }

        /**
         * @function SuperMap.ServerTextStyle.fromObj
         * @description 从传入对象获服务端文本风格类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ServerTextStyle}
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ServerTextStyle(obj);
            _SuperMap2.default.Util.copy(res, obj);
            res.backColor = _ServerColor2.default.fromJson(obj.backColor);
            res.foreColor = _ServerColor2.default.fromJson(obj.foreColor);
            return res;
        }
    }]);

    return ServerTextStyle;
}();

exports.default = ServerTextStyle;


_SuperMap2.default.ServerTextStyle = ServerTextStyle;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _TransportationAnalystResultSetting = __webpack_require__(242);

var _TransportationAnalystResultSetting2 = _interopRequireDefault(_TransportationAnalystResultSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.TransportationAnalystParameter
 * @classdesc 交通网络分析通用参数类。
 * @description该类主要用来提供交通网络分析所需的通用参数。
 * 通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息，还可以对分析结果包含的内容进行一些设置。
 * @param options - {Object} 可选参数。如:</br>
 *        barrierEdgeIDs - {Array<number>} 网络分析中障碍弧段的 ID 数组。</br>
 *        barrierNodeIDs - {Array<number>} 网络分析中障碍点的 ID 数组。</br>
 *        barrierPoints - {Array<Point>} 网络分析中 Point2D 类型的障碍点数组。</br>
 *                         点类型可以是：SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point。</br>
 *        weightFieldName - {string} 阻力字段的名称。</br>
 *        turnWeightField - {string} 转向权重字段的名称。</br>
 *        resultSetting - {{@link SuperMap.TransportationAnalystResultSetting}} 分析结果返回内容。
 */
var TransportationAnalystParameter = function () {

  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.turnWeightField -{string}
     * @description 转向权重字段的名称。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierPoints -{Array<Point>}
     * @description 网络分析中 Point2D 类型的障碍点数组。障碍点表示任何方向都不能通过此点。</br>
     * 点类型可以是：SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point。</br>
     * 当各网络分析参数类中的 isAnalyzeById 属性设置为 false 时，该属性才生效。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierEdgeIDs -{Array<number>}
     * @description 网络分析中障碍弧段的 ID 数组。弧段设置为障碍边之后，表示双向都不通。
     */
  function TransportationAnalystParameter(options) {
    _classCallCheck(this, TransportationAnalystParameter);

    this.barrierEdgeIDs = null;
    this.barrierNodeIDs = null;
    this.barrierPoints = null;
    this.weightFieldName = null;
    this.turnWeightField = null;
    this.resultSetting = null;
    this.CLASS_NAME = "SuperMap.TransportationAnalystParameter";

    var me = this;
    me.resultSetting = new _TransportationAnalystResultSetting2.default();
    if (!options) {
      return;
    }
    _SuperMap2.default.Util.extend(this, options);
  }

  /**
     * @function SuperMap.TransportationAnalystParameter.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


  /**
     *  @member SuperMap.TransportationAnalystParameter.prototype.resultSetting -{SuperMap.TransportationAnalystResultSetting}
     *  @description 分析结果返回内容。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.weightFieldName -{string}
     * @description 阻力字段的名称，标识了进行网络分析时所使用的阻力字段，例如表示时间、长度等的字段都可以用作阻力字段。
     * 该字段默值为服务器发布的所有耗费字段的第一个字段。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierNodeIDs -{Array<number>}
     * @description 网络分析中障碍点的 ID 数组。结点设置为障碍点之后，表示任何方向都不能通过此结点。
     */


  _createClass(TransportationAnalystParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.barrierEdgeIDs = null;
      me.barrierNodeIDs = null;
      me.weightFieldName = null;
      me.turnWeightField = null;
      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }
      if (me.barrierPoints && me.barrierPoints.length) {
        for (var i in me.barrierPoints) {
          me.barrierPoints.destroy();
        }
      }
      me.barrierPoints = null;
    }
  }]);

  return TransportationAnalystParameter;
}();

exports.default = TransportationAnalystParameter;

_SuperMap2.default.TransportationAnalystParameter = TransportationAnalystParameter;

/***/ }),
/* 17 */
/***/ (function(module, exports) {

module.exports = mapboxgl;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _Collection = __webpack_require__(13);

var _Collection2 = _interopRequireDefault(_Collection);

var _Curve2 = __webpack_require__(138);

var _Curve3 = _interopRequireDefault(_Curve2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.LineString
 * @classdesc 几何对象线串类。
 * @param points - {Array<SuperMap.Geometry.Point>} 用来生成线串的点数组。
 * @extends {SuperMap.Geometry.Curve}
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *     new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *     new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *     new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *     new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var roadLine = new SuperMap.Geometry.LineString(points)；
 */
var LineString = function (_Curve) {
    _inherits(LineString, _Curve);

    function LineString(points) {
        _classCallCheck(this, LineString);

        var _this = _possibleConstructorReturn(this, (LineString.__proto__ || Object.getPrototypeOf(LineString)).call(this, points));

        _this.CLASS_NAME = "SuperMap.Geometry.LineString";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LineString.prototype.removeComponent
     * @description 只有在线串上有三个或更多的点的时候，才会允许移除点（否则结果将会是单一的点）。
     * @param point - {SuperMap.Geometry.Point} 将被删除的点。
     * @returns {boolean} 删除的点。
     */


    _createClass(LineString, [{
        key: 'removeComponent',
        value: function removeComponent(point) {
            var removed = this.components && this.components.length > 2;
            if (removed) {
                _Collection2.default.prototype.removeComponent.apply(this, arguments);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.intersects
         * @description 判断两个几何图形是否相交。
         * @param geometry - {SuperMap.Geometry} 任意的几何类型。
         * @returns {boolean} 输入几何图形与当前几何图形是否相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            var type = geometry.CLASS_NAME;
            if (type === "SuperMap.Geometry.LineString" || type === "SuperMap.Geometry.LinearRing" || type === "SuperMap.Geometry.Point") {
                var segs1 = this.getSortedSegments();
                var segs2;
                if (type === "SuperMap.Geometry.Point") {
                    segs2 = [{
                        x1: geometry.x, y1: geometry.y,
                        x2: geometry.x, y2: geometry.y
                    }];
                } else {
                    segs2 = geometry.getSortedSegments();
                }
                var seg1, seg1x1, seg1x2, seg1y1, seg1y2, seg2, seg2y1, seg2y2;
                // sweep right
                outer: for (var i = 0, len = segs1.length; i < len; ++i) {
                    seg1 = segs1[i];
                    seg1x1 = seg1.x1;
                    seg1x2 = seg1.x2;
                    seg1y1 = seg1.y1;
                    seg1y2 = seg1.y2;
                    inner: for (var j = 0, jlen = segs2.length; j < jlen; ++j) {
                        seg2 = segs2[j];
                        if (seg2.x1 > seg1x2) {
                            // seg1 still left of seg2
                            break;
                        }
                        if (seg2.x2 < seg1x1) {
                            // seg2 still left of seg1
                            continue;
                        }
                        seg2y1 = seg2.y1;
                        seg2y2 = seg2.y2;
                        if (Math.min(seg2y1, seg2y2) > Math.max(seg1y1, seg1y2)) {
                            // seg2 above seg1
                            continue;
                        }
                        if (Math.max(seg2y1, seg2y2) < Math.min(seg1y1, seg1y2)) {
                            // seg2 below seg1
                            continue;
                        }
                        if (_SuperMap2.default.Geometry.segmentsIntersect(seg1, seg2)) {
                            intersect = true;
                            break outer;
                        }
                    }
                }
            } else {
                intersect = geometry.intersects(this);
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getSortedSegments
         * @returns {Array} 分割对象的数组。分割对象有x1,y1,x2,y2属性。起始点为x1,y1，终点为x2,y2。起始点与终点以增序排序。
         */

    }, {
        key: 'getSortedSegments',
        value: function getSortedSegments() {
            var numSeg = this.components.length - 1;
            var segments = new Array(numSeg),
                point1,
                point2;
            for (var i = 0; i < numSeg; ++i) {
                point1 = this.components[i];
                point2 = this.components[i + 1];
                if (point1.x < point2.x) {
                    segments[i] = {
                        x1: point1.x,
                        y1: point1.y,
                        x2: point2.x,
                        y2: point2.y
                    };
                } else {
                    segments[i] = {
                        x1: point2.x,
                        y1: point2.y,
                        x2: point1.x,
                        y2: point1.y
                    };
                }
            }

            // more efficient to define this somewhere static
            function byX1(seg1, seg2) {
                return seg1.x1 - seg2.x1;
            }

            return segments.sort(byX1);
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.splitWithSegment
         * @description 以给定的分割对象来分割几何对象。
         * @param seg - {Object} 分割对象。
         * @param options - {Object} 可选参数。<br>
         *         edge - {boolean} 当与边界相交的时候是否分割。默认为true。
         *         tolerance - {number} 容差。
         * @returns {Object} 一个带有lines和points属性的对象。
         */

    }, {
        key: 'splitWithSegment',
        value: function splitWithSegment(seg, options) {
            var edge = !(options && options.edge === false);
            var tolerance = options && options.tolerance;
            var lines = [];
            var verts = this.getVertices();
            var points = [];
            var intersections = [];
            var split = false;
            var vert1, vert2, point;
            var node, vertex, target;
            var interOptions = { point: true, tolerance: tolerance };
            var result = null;
            for (var i = 0, stop = verts.length - 2; i <= stop; ++i) {
                vert1 = verts[i];
                points.push(vert1.clone());
                vert2 = verts[i + 1];
                target = { x1: vert1.x, y1: vert1.y, x2: vert2.x, y2: vert2.y };
                point = _SuperMap2.default.Geometry.segmentsIntersect(seg, target, interOptions);
                if (point instanceof _Point2.default) {
                    if (point.x === seg.x1 && point.y === seg.y1 || point.x === seg.x2 && point.y === seg.y2 || point.equals(vert1) || point.equals(vert2)) {
                        vertex = true;
                    } else {
                        vertex = false;
                    }
                    if (vertex || edge) {
                        // push intersections different than the previous
                        if (!point.equals(intersections[intersections.length - 1])) {
                            intersections.push(point.clone());
                        }
                        if (i === 0) {
                            if (point.equals(vert1)) {
                                continue;
                            }
                        }
                        if (point.equals(vert2)) {
                            continue;
                        }
                        split = true;
                        if (!point.equals(vert1)) {
                            points.push(point);
                        }
                        lines.push(new LineString(points));
                        points = [point.clone()];
                    }
                }
            }
            if (split) {
                points.push(vert2.clone());
                lines.push(new LineString(points));
            }
            if (intersections.length > 0) {
                // sort intersections along segment
                var xDir = seg.x1 < seg.x2 ? 1 : -1;
                var yDir = seg.y1 < seg.y2 ? 1 : -1;
                result = {
                    lines: lines,
                    points: intersections.sort(function (p1, p2) {
                        return xDir * p1.x - xDir * p2.x || yDir * p1.y - yDir * p2.y;
                    })
                };
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.split
         * @description 用一个几何对象去分割另外一个几何对象。
         * @param target - {SuperMap.Geometry} 目标几何对象.
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} 分割源几何对象，除了目标对象。默认是false。
         *         edge - {boolean} 当与边界相交的时候才允许分割，默认是true。
         *         tolerance - {number} 容差。
         * @returns {Array} 几何对象列表。
         */

    }, {
        key: 'split',
        value: function split(target, options) {
            var results = null;
            var mutual = options && options.mutual;
            var sourceSplit, targetSplit, sourceParts, targetParts;
            if (target instanceof LineString) {
                var verts = this.getVertices();
                var vert1, vert2, seg, splits, lines, point;
                var points = [];
                sourceParts = [];
                for (var i = 0, stop = verts.length - 2; i <= stop; ++i) {
                    vert1 = verts[i];
                    vert2 = verts[i + 1];
                    seg = {
                        x1: vert1.x, y1: vert1.y,
                        x2: vert2.x, y2: vert2.y
                    };
                    targetParts = targetParts || [target];
                    if (mutual) {
                        points.push(vert1.clone());
                    }
                    for (var j = 0; j < targetParts.length; ++j) {
                        splits = targetParts[j].splitWithSegment(seg, options);
                        if (splits) {
                            // splice in new features
                            lines = splits.lines;
                            if (lines.length > 0) {
                                lines.unshift(j, 1);
                                Array.prototype.splice.apply(targetParts, lines);
                                j += lines.length - 2;
                            }
                            if (mutual) {
                                for (var k = 0, len = splits.points.length; k < len; ++k) {
                                    point = splits.points[k];
                                    if (!point.equals(vert1)) {
                                        points.push(point);
                                        sourceParts.push(new LineString(points));
                                        if (point.equals(vert2)) {
                                            points = [];
                                        } else {
                                            points = [point.clone()];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (mutual && sourceParts.length > 0 && points.length > 0) {
                    points.push(vert2.clone());
                    sourceParts.push(new LineString(points));
                }
            } else {
                results = target.splitWith(this, options);
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetSplit || sourceSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.splitWith
         * @description 用几何对象分割另一个几何对象。
         * @param geometry - {SuperMap.Geometry} A geometry used to split this geometry (the source).
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} 分割源几何对象，除了目标对象。默认是false。
         *         edge - {boolean} 当与边界相交的时候才允许分割，默认是true。
         *         tolerance - {number} 容差。
         * @returns {Array} 几何对象数组。
         */

    }, {
        key: 'splitWith',
        value: function splitWith(geometry, options) {
            return geometry.split(this, options);
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表。
         * @param nodes - {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点
         * 如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices;
            if (nodes === true) {
                vertices = [this.components[0], this.components[this.components.length - 1]];
            } else if (nodes === false) {
                vertices = this.components.slice(1, this.components.length - 1);
            } else {
                vertices = this.components.slice();
            }
            return vertices;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。
         * @param geometry {SuperMap.Geometry} 目标几何图形。
         * @param options {Object}距离计算需要设置的可选属性。有效的选项取决于特定的几何类型。
         *         details - {boolean} 返回距离计算的细节，默认为false。
         *         edge - {boolean} 计算一个几何图形到目标几何图形边缘的最近距离，默认为true。 如果设为true，
         *                          一个几何图形完全包含在目标几何图形中时，调用distanceTo返回非零结果，如果false，两个几何图形相交情况下
         *                          调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何图形到目标几何图形的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var result,
                best = {};
            var min = Number.POSITIVE_INFINITY;
            if (geometry instanceof _Point2.default) {
                var segs = this.getSortedSegments();
                var x = geometry.x;
                var y = geometry.y;
                var seg;
                for (var i = 0, len = segs.length; i < len; ++i) {
                    seg = segs[i];
                    result = Supermap.Geometry.distanceToSegment(geometry, seg);
                    if (result.distance < min) {
                        min = result.distance;
                        best = result;
                        if (min === 0) {
                            break;
                        }
                    } else {
                        // if distance increases and we cross y0 to the right of x0, no need to keep looking.
                        if (seg.x2 > x && (y > seg.y1 && y < seg.y2 || y < seg.y1 && y > seg.y2)) {
                            break;
                        }
                    }
                }
                if (details) {
                    best = {
                        distance: best.distance,
                        x0: best.x, y0: best.y,
                        x1: x, y1: y
                    };
                } else {
                    best = best.distance;
                }
            } else if (geometry instanceof LineString) {
                var segs0 = this.getSortedSegments();
                var segs1 = geometry.getSortedSegments();
                var seg0, seg1, intersection, x0, y0;
                var len1 = segs1.length;
                var interOptions = { point: true };
                outer: for (var i = 0, len = segs0.length; i < len; ++i) {
                    seg0 = segs0[i];
                    x0 = seg0.x1;
                    y0 = seg0.y1;
                    for (var j = 0; j < len1; ++j) {
                        seg1 = segs1[j];
                        intersection = Supermap.Geometry.segmentsIntersect(seg0, seg1, interOptions);
                        if (intersection) {
                            min = 0;
                            best = {
                                distance: 0,
                                x0: intersection.x, y0: intersection.y,
                                x1: intersection.x, y1: intersection.y
                            };
                            break outer;
                        } else {
                            result = Supermap.Geometry.distanceToSegment({ x: x0, y: y0 }, seg1);
                            if (result.distance < min) {
                                min = result.distance;
                                best = {
                                    distance: min,
                                    x0: x0, y0: y0,
                                    x1: result.x, y1: result.y
                                };
                            }
                        }
                    }
                }
                if (!details) {
                    best = best.distance;
                }
                if (min !== 0) {
                    // check the final vertex in this line's sorted segments
                    if (seg0) {
                        result = geometry.distanceTo(new _Point2.default(seg0.x2, seg0.y2), options);
                        var dist = details ? result.distance : result;
                        if (dist < min) {
                            if (details) {
                                best = {
                                    distance: min,
                                    x0: result.x1, y0: result.y1,
                                    x1: result.x0, y1: result.y0
                                };
                            } else {
                                best = dist;
                            }
                        }
                    }
                }
            } else {
                best = geometry.distanceTo(this, options);
                // swap since target comes from this line
                if (details) {
                    best = {
                        distance: best.distance,
                        x0: best.x1, y0: best.y1,
                        x1: best.x0, y1: best.y0
                    };
                }
            }
            return best;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.simplify
         * @description 这个函数返回一个简化的线串，基于道格拉斯 - 普克简化算法进行简化。
         * @param tolerance {number} 地图单位上的简化的阈值。
         * @returns {SuperMap.Geometry.LineString} 被简化的线串。
         */

    }, {
        key: 'simplify',
        value: function simplify(tolerance) {
            if (this && this !== null) {
                var points = this.getVertices();
                if (points.length < 3) {
                    return this;
                }

                var compareNumbers;
                a, b;
                {
                    return a - b;
                }
                ;

                var firstPoint = 0;
                var lastPoint = points.length - 1;
                var pointIndexsToKeep = [];

                /**
                 * Private function calculating the perpendicular distance
                 * TODO: check whether SuperMap.Geometry.LineString::distanceTo() is faster or slower
                 */
                var perpendicularDistance;
                point1, point2, point;
                {
                    //Area = |(1/2)(x1y2 + x2y3 + x3y1 - x2y1 - x3y2 - x1y3)|   *Area of triangle
                    //Base = v((x1-x2)²+(x1-x2)²)                               *Base of Triangle*
                    //Area = .5*Base*H                                          *Solve for height
                    //Height = Area/.5/Base

                    var area = Math.abs(0.5 * (point1.x * point2.y + point2.x * point.y + point.x * point1.y - point2.x * point1.y - point.x * point2.y - point1.x * point.y));
                    var bottom = Math.sqrt(Math.pow(point1.x - point2.x, 2) + Math.pow(point1.y - point2.y, 2));
                    var height = area / bottom * 2;

                    return height;
                }
                ;

                /**
                 * Private function doing the Douglas-Peucker reduction
                 */
                var douglasPeuckerReduction;
                points, firstPoint, lastPoint, tolerance;
                {
                    var maxDistance = 0;
                    var indexFarthest = 0;

                    for (var index = firstPoint, distance; index < lastPoint; index++) {
                        distance = perpendicularDistance(points[firstPoint], points[lastPoint], points[index]);
                        if (distance > maxDistance) {
                            maxDistance = distance;
                            indexFarthest = index;
                        }
                    }

                    if (maxDistance > tolerance && indexFarthest !== firstPoint) {
                        //Add the largest point that exceeds the tolerance
                        pointIndexsToKeep.push(indexFarthest);
                        douglasPeuckerReduction(points, firstPoint, indexFarthest, tolerance);
                        douglasPeuckerReduction(points, indexFarthest, lastPoint, tolerance);
                    }
                }
                ;

                //Add the first and last index to the keepers
                pointIndexsToKeep.push(firstPoint);
                pointIndexsToKeep.push(lastPoint);

                //The first and the last point cannot be the same
                while (points[firstPoint].equals(points[lastPoint])) {
                    lastPoint--;
                    //Addition: the first point not equal to first point in the LineString is kept as well
                    pointIndexsToKeep.push(lastPoint);
                }

                douglasPeuckerReduction(points, firstPoint, lastPoint, tolerance);
                var returnPoints = [];
                pointIndexsToKeep.sort(compareNumbers);
                for (var index = 0; index < pointIndexsToKeep.length; index++) {
                    returnPoints.push(points[pointIndexsToKeep[index]]);
                }
                return new LineString(returnPoints);
            } else {
                return this;
            }
        }

        /**
         * @function SuperMap.Geometry.LineString.createCurve
         * @description 创建扇形对象。（备注：需要依赖Smooth.js）
         * @param points - {Array<SuperMap.Geometry.Point>} 曲线经过的点串。
         * @param method - {String} 曲线类型，目前支持的有："lanczos","cubic","linear",默认为"lanczos"。
         * @param filterSize - {number} 曲线平滑曲度，在2~10之间的数值，默认为10，不支持method为"linear"的类型。
         * @param lineLength - {number} 曲线拟合的线数目，默认是80。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(11983722.7315,3942864.5449));
         * points.push(new SuperMap.Geometry.Point(11986722.7315, 3946864.5449));
         * points.push(new SuperMap.Geometry.Point(11989722.7315, 3949864.5449));
         * var curve = SuperMap.Geometry.LineString.createCurve(points);
         */

    }], [{
        key: 'createCurve',
        value: function createCurve(points, method, filterSize, lineLength) {
            var methodCurve = "lanczos";
            if (method != undefined) methodCurve = method;

            var filterSizeCurve = 10;
            if (filterSize != undefined) filterSizeCurve = filterSize;

            var smoothConfig = {
                method: methodCurve,
                clip: 'mirror',
                lanczosFilterSize: filterSizeCurve,
                cubicTension: 0
            };

            var pp = [];
            for (var i = 0; i < points.length; i++) {
                pp.push([points[i].x, points[i].y]);
            }

            var distance;
            a, b;
            {
                return Math.sqrt(Math.pow(a[0] - b[0], 2) + Math.pow(a[1] - b[1], 2));
            }

            var averageLineLengthCurve = 80;
            if (lineLength != undefined) averageLineLengthCurve = lineLength;

            var pointList = [];
            var averageLineLength, du, end, pieceCount, pieceLength, s, start, t, u, _ref, _ref2, _ref3;
            averageLineLength = distance(pp[0], pp[pp.length - 1]) / averageLineLengthCurve;
            pieceCount = 2;
            s = Smooth(pp, smoothConfig);
            for (t = 0, _ref = 1 / pieceCount; t < 1; t += _ref) {
                _ref2 = [s(i + t), s(i + t + 1 / pieceCount)], start = _ref2[0], end = _ref2[1];
                pieceLength = distance(start, end);
                du = averageLineLength / pieceLength;
                for (u = 0, _ref3 = 1 / pieceCount; 0 <= _ref3 ? u < _ref3 : u > _ref3; u += du) {
                    var p = s(i + t + u);
                    pointList.push(new _Point2.default(p[0], p[1]));
                }
            }

            var p = s(i + 1);
            pointList.push(new _Point2.default(p[0], p[1]));

            return new LineString(pointList);
        }
    }, {
        key: 'createBspline',


        /**
         * @function SuperMap.Geometry.LineString.createBspline
         * @description 创建B样条曲线。此曲线会穿过所有的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 曲线经过的点串。
         * @param filterSize - {number} 曲线平滑曲度，默认为10。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(116, 39.4));
         * points.push(new SuperMap.Geometry.Point(118, 39.8));
         * points.push(new SuperMap.Geometry.Point(119, 39));
         *
         * var curve = SuperMap.Geometry.LineString.createBspline(points,5);
         */
        value: function createBspline(points, filterSize) {
            //一个点无效，至少需要两个点
            if (points.length < 2) {
                return null;
            }
            //曲线内部的所有点数组
            var pointListDraw = [];
            //设置曲线平滑曲度
            var k = 10;
            if (filterSize != undefined) {
                k = filterSize;
            }
            var i, j, a0, a1, a2, dt, t1, t2;
            var t_x, t_y;
            dt = 1.0 / k;
            //计算起始点，
            var value = Math.sqrt((Math.pow(points[1].x - points[0].x, 2) + Math.pow(points[1].y - points[0].y, 2)) / 2); //取的点数组中前两个点粗略计算出的一个值
            //此为第一个控制点，此点以后可能会开放出来
            var pointFirst = new _Point2.default(points[0].x - value, points[0].y - value);
            //初始化一个点数组，存放所有的控制点
            var pointListControl = [];
            //第一个控制点也就是起始点pointFirst
            pointListControl[0] = pointFirst;
            //循环用户传进的点数组
            for (i = 0; i < points.length - 1; i++) {
                //定义一个零时数组，只需要三个元素，后期用于调用贝茨曲线划线（由首尾两个挤出点和中间的控制点组成的）
                var pointList = [];
                //
                pointList[0] = points[i];
                //由前一个控制点和当前的点生成的后一个控制点
                var point = new _Point2.default(points[i].x * 2 - pointListControl[i].x, points[i].y * 2 - pointListControl[i].y);
                pointList[1] = point;
                pointListControl[i + 1] = point;
                pointList[2] = points[i + 1];
                //将此控制点存起来
                pointListDraw.push(pointList[0]);
                //生成当前曲线中的所有点
                for (j = 0; j <= k; j++) {
                    t1 = j * dt;
                    t2 = t1 * t1;

                    a0 = (t2 - 2 * t1 + 1) / 2.0;
                    a1 = (2 * t1 - 2 * t2 + 1) / 2.0;
                    a2 = t2 / 2.0;

                    t_x = a0 * pointList[0].x + a1 * pointList[1].x + a2 * pointList[2].x;
                    t_y = a0 * pointList[0].y + a1 * pointList[1].y + a2 * pointList[2].y;
                    pointListDraw.push(new _Point2.default(t_x, t_y));
                }
            }
            //将最后一个用户的点存进去才能达到曲线通过所有的点
            pointListDraw.push(points[points.length - 1]);
            return new LineString(pointListDraw);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier1
         * @description 创建1次贝塞尔曲线。
         * @param points -{Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         *                     决定贝塞尔曲线的平滑程度。取值越小曲线越平滑。取值为大于1的整数。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier1(points, 20);
         */

    }, {
        key: 'createBezier1',
        value: function createBezier1(points, precision, part) {
            if (part) {
                return LineString.createBezier3(points, part);
            }
            //获取待拆分的点
            var bezierPts = [];
            for (var m = 0; m < points.length; m++) {
                bezierPts[m] = points[m];
            }
            //获取输入点的数量
            var i;
            var k;
            var j = 0;
            var bExit;
            var count = bezierPts.length;
            var ptBuffer = [];
            var ok = true;
            while (ok) {
                bExit = true;
                //贝塞尔分解是按4个点为一组进行的，所以小于4个点就再不进行分解
                for (i = 0; i < count - 3; i += 3) {
                    //对输入点数组进行分解
                    //判断bezierPts[i]到bezierPts[i+4]是否达到精度
                    if (GetBezierGap(bezierPts, i) > precision) {
                        bExit = false;
                        //对未达到精度的bezierPts[i]到bezierPts[i+4]进行计算，得到新的ptBuffer点数组
                        InciseBezier(bezierPts, i, ptBuffer);
                        //去除已使用过的2个控制点
                        bezierPts.splice(i + 1, 2);
                        //将本次计算得到的5个新的点插入到bezierPts[i]位置之后，得到新的bezierPts点数组
                        for (k = 0; k < 5; k++) {
                            bezierPts.splice(i + 1 + k, 0, ptBuffer[k + 1]);
                        }
                        //bezierPts[i]到bezierPts[i+4]没有达到精度，所以不能跳过，i需回归初始
                        i -= 3;
                        count = bezierPts.length;
                    }
                    if (bExit) break;
                }
                //对分解得出的新bezierPts点数组进行优化，除去相同的点
                while (j < count - 1) {
                    if (bezierPts[j] === bezierPts[j + 1]) {
                        bezierPts.splice(j + 1, 1);
                        count--;
                    }
                    j++;
                }
                ok = false;
            }

            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZ2
         * @description 计算2次贝塞尔曲线的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串（必须为三个点）。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} 2次贝塞尔曲线的所有点。
         */

    }, {
        key: 'calculatePointsFBZ2',
        value: function calculatePointsFBZ2(points, part) {
            if (!part) part = 20;

            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;
            if (part > 0) {
                scale = 1 / part;
            }

            for (var i = 0; i < points.length - 2;) {
                //起始点
                var pointS = points[i];
                //控制点
                var pointC = points[i + 1];
                //结束点
                var pointE = points[i + 2];

                bezierPts.push(pointS);
                for (var t = 0; t < 1;) {
                    //二次贝塞尔曲线公式
                    var x = (1 - t) * (1 - t) * pointS.x + 2 * t * (1 - t) * pointC.x + t * t * pointE.x;
                    var y = (1 - t) * (1 - t) * pointS.y + 2 * t * (1 - t) * pointC.y + t * t * pointE.y;
                    var point = new _Point2.default(x, y);
                    bezierPts.push(point);
                    t += scale;
                }

                i += 2;
                if (i >= points.length) {
                    bezierPts.push(pointS);
                }
            }

            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }

            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZ3
         * @description 计算3次贝塞尔曲线的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串(四个)。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} 3次贝塞尔曲线的所有点
         */

    }, {
        key: 'calculatePointsFBZ3',
        value: function calculatePointsFBZ3(points, part) {
            if (!part) part = 20;
            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;

            if (part > 0) {
                scale = 1 / part;
            }

            for (var i = 0; i < points.length - 3;) {
                //起始点
                var pointS = points[i];
                //第一个控制点
                var pointC1 = points[i + 1];
                //第二个控制点
                var pointC2 = points[i + 2];
                //结束点
                var pointE = points[i + 3];

                bezierPts.push(pointS);
                for (var t = 0; t < 1;) {
                    //三次贝塞尔曲线公式
                    var x = (1 - t) * (1 - t) * (1 - t) * pointS.x + 3 * t * (1 - t) * (1 - t) * pointC1.x + 3 * t * t * (1 - t) * pointC2.x + t * t * t * pointE.x;
                    var y = (1 - t) * (1 - t) * (1 - t) * pointS.y + 3 * t * (1 - t) * (1 - t) * pointC1.y + 3 * t * t * (1 - t) * pointC2.y + t * t * t * pointE.y;
                    var point = new _Point2.default(x, y);
                    bezierPts.push(point);
                    t += scale;
                }

                i += 3;
                if (i >= points.length) {
                    bezierPts.push(pointS);
                }
            }

            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }
            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZN
         * @description 计算N次贝塞尔曲线的插值点。计算N次贝塞尔曲线需要N+1个点,也就是传入 points ，得到的是points.length-1次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} N次贝塞尔曲线的所有点。
         */

    }, {
        key: 'calculatePointsFBZN',
        value: function calculatePointsFBZN(points, part) {
            if (!part) part = points.length * 8;

            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;
            if (part > 0) {
                scale = 1 / part;
            }
            for (var t = 0; t <= 1;) {
                var x = 0;
                var y = 0;
                var n = points.length;
                for (var i = 0; i < points.length; i++) {
                    var b = LineString.BEZ(n - 1, i, t);
                    x += points[i].x * b;
                    y += points[i].y * b;
                }
                var point = new _Point2.default(x, y);
                bezierPts.push(point);
                t += scale;
            }
            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }
            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier2
         * @description 创建2次贝塞尔曲线。
         * @param points -{Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串（必须为三个点）。
         * @param part -{number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier2(points, 20);
         */

    }, {
        key: 'createBezier2',
        value: function createBezier2(points, part) {

            var bezierPts = LineString.calculatePointsFBZ2(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier3
         * @description 创建3次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。(必须为四个点)。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier3(points, 20);
         */

    }, {
        key: 'createBezier3',
        value: function createBezier3(points, part) {

            var bezierPts = LineString.calculatePointsFBZ3(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier
         * @description 创建3次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         *                     决定贝塞尔曲线的平滑程度。取值越小曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier(points,1);
         */

    }, {
        key: 'createBezier',
        value: function createBezier(points, precision) {
            //获取待拆分的点
            var bezierPts = [];
            for (var m = 0; m < points.length; m++) {
                bezierPts[m] = points[m];
            }
            //获取输入点的数量
            var i,
                k,
                j = 0,
                bExit,
                count = bezierPts.length;
            var ptBuffer = [];
            while (true) {
                bExit = true;
                //贝塞尔分解是按4个点为一组进行的，所以小于4个点就再不进行分解
                for (i = 0; i < count - 3; i += 3) {
                    //对输入点数组进行分解
                    //判断bezierPts[i]到bezierPts[i+4]是否达到精度
                    if (GetBezierGap(bezierPts, i) > precision) {
                        bExit = false;
                        //对未达到精度的bezierPts[i]到bezierPts[i+4]进行计算，得到新的ptBuffer点数组
                        InciseBezier(bezierPts, i, ptBuffer);
                        //去除已使用过的2个控制点
                        bezierPts.splice(i + 1, 2);
                        //将本次计算得到的5个新的点插入到bezierPts[i]位置之后，得到新的bezierPts点数组
                        for (k = 0; k < 5; k++) {
                            bezierPts.splice(i + 1 + k, 0, ptBuffer[k + 1]);
                        }
                        //bezierPts[i]到bezierPts[i+4]没有达到精度，所以不能跳过，i需回归初始
                        i -= 3;
                        count = bezierPts.length;
                    }
                    if (bExit) break;
                }
                //对分解得出的新bezierPts点数组进行优化，除去相同的点
                while (j < count - 1) {
                    if (bezierPts[j] === bezierPts[j + 1]) {
                        bezierPts.splice(j + 1, 1);
                        count--;
                    }
                    j++;
                }
                //返回分解完成的新的bezierPts点数组
                return new LineString(bezierPts);
            }
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezierN
         * @description 创建N次贝塞尔曲线。创建N次贝塞尔曲线需要N+1个点,也就是传入 points ，得到的是points.length-1次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数，默认为20。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * //创建3次贝塞尔曲线
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezierN(points, 20);
         * //创建4次贝塞尔曲线
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         * points.push(new SuperMap.Geometry.Point(50,20));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezierN(points, 30);
         * ......
         */

    }, {
        key: 'createBezierN',
        value: function createBezierN(points, part) {
            var bezierPts = LineString.calculatePointsFBZN(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.BEZ
         * @description 基函数。
         * @param n -{number}
         * @param k -{number}
         * @param t -{number} 0-1之间的一个数。
         * @returns {number} 基函数的值。
         *
         */

    }, {
        key: 'BEZ',
        value: function BEZ(n, k, t) {
            return LineString.combSort(n, k) * Math.pow(t, k) * Math.pow(1 - t, n - k);
        }

        /**
         * @function SuperMap.Geometry.LineString.combSort
         * @description 组合排序,计算从1*2*...*n/(1*2*...*k*1*2*...*(n-k))的值。
         * @param n -{number} 贝塞尔曲线的次数n。
         * @param k -{number} 小于N的一个数k。
         * @returns {number} 组合排序的值。
         *
         */

    }, {
        key: 'combSort',
        value: function combSort(n, k) {
            var son = LineString.factorial(n);
            var mother = LineString.factorial(k) * LineString.factorial(n - k);
            return son / mother;
        }

        /**
         * @function SuperMap.Geometry.LineString.factorial
         * @description 阶乘,计算从1*2*3*4*...*n的值。
         * @param n - {number}
         * @returns {number} 阶乘的值。
         *
         */

    }, {
        key: 'factorial',
        value: function factorial(n) {
            var result = 1;
            for (var i = 1; i <= n; i++) {
                result *= i;
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculateCardinalPoints
         * @description 创建Cardinal控制点。
         * 利用输入的点数组计算出相应的Cardinal控制点，再使用贝塞尔曲线3创建经过所有Cardinal控制点的圆滑曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的Cardinal控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var cardinal = SuperMap.Geometry.LineString.createCloseCardinal(points);
         */

    }, {
        key: 'calculateCardinalPoints',
        value: function calculateCardinalPoints(points) {
            if (points == null || points.length < 3) {
                return points;
            }
            //定义传入的点数组，将在点数组中央（每两个点）插入两个控制点
            var cPoints = points;
            //包含输入点和控制点的数组
            var cardinalPoints = [];

            //这些都是相关资料测出的经验数值
            //定义张力系数，取值在0<t<0.5
            var t = 0.4;
            //为端点张力系数因子，取值在0<b<1
            var b = 0.5;
            //误差控制，是一个大于等于0的数，用于三点非常趋近与一条直线时，减少计算量
            var e = 0.005;

            //传入的点数量，至少有三个，n至少为2
            var n = cPoints.length - 1;
            //从开始遍历到倒数第二个，其中倒数第二个用于计算起点（终点）的插值控制点

            for (var k = 0; k <= n + 1 - 3; k++) {
                //三个基础输入点
                var p0 = cPoints[k];
                var p1 = cPoints[k + 1];
                var p2 = cPoints[k + 2];
                //定义p1的左控制点和右控制点
                var p1l = new _Point2.default();
                var p1r = new _Point2.default();
                //通过p0、p1、p2计算p1点的做控制点p1l和又控制点p1r
                //计算向量p0_p1和p1_p2
                var p0_p1 = new _Point2.default(p1.x - p0.x, p1.y - p0.y);
                var p1_p2 = new _Point2.default(p2.x - p1.x, p2.y - p1.y);
                //并计算模
                var d01 = Math.sqrt(p0_p1.x * p0_p1.x + p0_p1.y * p0_p1.y);
                var d12 = Math.sqrt(p1_p2.x * p1_p2.x + p1_p2.y * p1_p2.y);
                //向量单位化
                var p0_p1_1 = new _Point2.default(p0_p1.x / d01, p0_p1.y / d01);
                var p1_p2_1 = new _Point2.default(p1_p2.x / d12, p1_p2.y / d12);
                //计算向量p0_p1和p1_p2的夹角平分线向量
                var p0_p1_p2 = new _Point2.default(p0_p1_1.x + p1_p2_1.x, p0_p1_1.y + p1_p2_1.y);
                //计算向量 p0_p1_p2 的模
                var d012 = Math.sqrt(p0_p1_p2.x * p0_p1_p2.x + p0_p1_p2.y * p0_p1_p2.y);
                //单位化向量p0_p1_p2
                var p0_p1_p2_1 = new _Point2.default(p0_p1_p2.x / d012, p0_p1_p2.y / d012);
                //判断p0、p1、p2是否共线，这里判定向量p0_p1和p1_p2的夹角的余弦和1的差值小于e就认为三点共线
                var cosE_p0p1p2 = (p0_p1_1.x * p1_p2_1.x + p0_p1_1.y * p1_p2_1.y) / 1;
                //共线
                if (Math.abs(1 - cosE_p0p1p2) < e) {
                    //计算p1l的坐标
                    p1l.x = p1.x - p1_p2_1.x * d01 * t;
                    p1l.y = p1.y - p1_p2_1.y * d01 * t;
                    //计算p1r的坐标
                    p1r.x = p1.x + p0_p1_1.x * d12 * t;
                    p1r.y = p1.y + p0_p1_1.y * d12 * t;
                }
                //非共线
                else {
                        //计算p1l的坐标
                        p1l.x = p1.x - p0_p1_p2_1.x * d01 * t;
                        p1l.y = p1.y - p0_p1_p2_1.y * d01 * t;
                        //计算p1r的坐标
                        p1r.x = p1.x + p0_p1_p2_1.x * d12 * t;
                        p1r.y = p1.y + p0_p1_p2_1.y * d12 * t;
                    }
                //记录下这三个控制点
                cardinalPoints[k * 3 + 2 + 0] = p1l;
                cardinalPoints[k * 3 + 2 + 1] = p1;
                cardinalPoints[k * 3 + 2 + 2] = p1r;

                //当为起始点时需要计算第一个点的右控制点
                if (k == 0) {
                    //定义p0的右控制点
                    var p0r = new _Point2.default();

                    //计算向量p0_p1l
                    var po_p1l = new _Point2.default(p1l.x - p0.x, p1l.y - p0.y);
                    //计算模
                    var d01l = Math.sqrt(po_p1l.x * po_p1l.x + po_p1l.y * po_p1l.y);
                    //单位化
                    var po_p1l_1 = new _Point2.default(po_p1l.x / d01l, po_p1l.y / d01l);
                    //计算p0r
                    p0r.x = p0.x + po_p1l_1.x * d01 * t * b;
                    p0r.y = p0.y + po_p1l_1.y * d01 * t * b;

                    cardinalPoints[k * 3 + 0] = p0;
                    cardinalPoints[k * 3 + 1] = p0r;
                }
                //当为倒数第三个点时需要计算最后点的左控制点
                if (k == n + 1 - 3) {
                    //定义 p2的做控制点p2l
                    var p2l = new _Point2.default();

                    //计算向量p2_p1r
                    var p2_p1r = new _Point2.default(p1r.x - p2.x, p1r.y - p2.y);
                    //并取模
                    var d21r = Math.sqrt(p2_p1r.x * p2_p1r.x + p2_p1r.y * p2_p1r.y);
                    //单位化
                    var p2_p1r_1 = new _Point2.default(p2_p1r.x / d21r, p2_p1r.y / d21r);
                    //计算p2l
                    p2l.x = p2.x + p2_p1r_1.x * d12 * t * b;
                    p2l.y = p2.y + p2_p1r_1.y * d12 * t * b;

                    cardinalPoints[k * 3 + 2 + 3] = p2l;
                    cardinalPoints[k * 3 + 2 + 4] = p2;
                }
            }
            return cardinalPoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.createCloseCardinal
         * @description 创建闭合Cardinal的控制点。利用输入的点数组计算出相应的Cardinal控制点，再使用贝塞尔曲线3创建经过所有Cardinal控制点的圆滑闭合曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的Cardinal控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var cardinal = SuperMap.Geometry.LineString.createCloseCardinal(points);
         */

    }, {
        key: 'createCloseCardinal',
        value: function createCloseCardinal(points) {
            if (points == null || points.length < 3) {
                return points;
            }
            //获取起点，作为终点，以闭合曲线。
            var lastP = points[0];
            points.push(lastP);

            //定义传入的点数组，将在点数组中央（每两个点）插入两个控制点
            var cPoints = points;
            //包含输入点和控制点的数组
            var cardinalPoints = [];

            //至少三个点以上
            //这些都是相关资料测出的经验数值
            //定义张力系数，取值在0<t<0.5
            var t = 0.4;
            //为端点张力系数因子，取值在0<b<1
            var b = 0.5;
            //误差控制，是一个大于等于0的数，用于三点非常趋近与一条直线时，减少计算量
            var e = 0.005;

            //传入的点数量，至少有三个，n至少为2
            var n = cPoints.length - 1;
            //从开始遍历到倒数第二个，其中倒数第二个用于计算起点（终点）的插值控制点
            for (var k = 0; k <= n - 1; k++) {
                //计算起点（终点）的左右控制点
                if (k == n - 1) {
                    //三个基础输入点
                    var p0 = cPoints[n - 1];
                    var p1 = cPoints[0];
                    var p2 = cPoints[1];
                } else {
                    var p0 = cPoints[k];
                    var p1 = cPoints[k + 1];
                    var p2 = cPoints[k + 2];
                }

                //定义p1的左控制点和右控制点
                var p1l = new _Point2.default();
                var p1r = new _Point2.default();
                //通过p0、p1、p2计算p1点的做控制点p1l和又控制点p1r
                //计算向量p0_p1和p1_p2
                var p0_p1 = new _Point2.default(p1.x - p0.x, p1.y - p0.y);
                var p1_p2 = new _Point2.default(p2.x - p1.x, p2.y - p1.y);
                //并计算模
                var d01 = Math.sqrt(p0_p1.x * p0_p1.x + p0_p1.y * p0_p1.y);
                var d12 = Math.sqrt(p1_p2.x * p1_p2.x + p1_p2.y * p1_p2.y);
                //向量单位化
                var p0_p1_1 = new _Point2.default(p0_p1.x / d01, p0_p1.y / d01);
                var p1_p2_1 = new _Point2.default(p1_p2.x / d12, p1_p2.y / d12);
                //计算向量p0_p1和p1_p2的夹角平分线向量
                var p0_p1_p2 = new _Point2.default(p0_p1_1.x + p1_p2_1.x, p0_p1_1.y + p1_p2_1.y);
                //计算向量 p0_p1_p2 的模
                var d012 = Math.sqrt(p0_p1_p2.x * p0_p1_p2.x + p0_p1_p2.y * p0_p1_p2.y);
                //单位化向量p0_p1_p2
                var p0_p1_p2_1 = new _Point2.default(p0_p1_p2.x / d012, p0_p1_p2.y / d012);
                //判断p0、p1、p2是否共线，这里判定向量p0_p1和p1_p2的夹角的余弦和1的差值小于e就认为三点共线
                var cosE_p0p1p2 = (p0_p1_1.x * p1_p2_1.x + p0_p1_1.y * p1_p2_1.y) / 1;
                //共线
                if (Math.abs(1 - cosE_p0p1p2) < e) {
                    //计算p1l的坐标
                    p1l.x = p1.x - p1_p2_1.x * d01 * t;
                    p1l.y = p1.y - p1_p2_1.y * d01 * t;
                    //计算p1r的坐标
                    p1r.x = p1.x + p0_p1_1.x * d12 * t;
                    p1r.y = p1.y + p0_p1_1.y * d12 * t;
                }
                //非共线
                else {
                        //计算p1l的坐标
                        p1l.x = p1.x - p0_p1_p2_1.x * d01 * t;
                        p1l.y = p1.y - p0_p1_p2_1.y * d01 * t;
                        //计算p1r的坐标
                        p1r.x = p1.x + p0_p1_p2_1.x * d12 * t;
                        p1r.y = p1.y + p0_p1_p2_1.y * d12 * t;
                    }

                //记录起点（终点）的左右插值控制点及倒数第二个控制点
                if (k == n - 1) {
                    cardinalPoints[0] = p1;
                    cardinalPoints[1] = p1r;
                    cardinalPoints[(n - 2) * 3 + 2 + 3] = p1l;
                    cardinalPoints[(n - 2) * 3 + 2 + 4] = cPoints[n];
                } else {
                    //记录下这三个控制点
                    cardinalPoints[k * 3 + 2 + 0] = p1l;
                    cardinalPoints[k * 3 + 2 + 1] = p1;
                    cardinalPoints[k * 3 + 2 + 2] = p1r;
                }
            }
            return cardinalPoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculateCircle
         * @description 三点画圆弧。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的圆弧控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50));
         * points.push(new SuperMap.Geometry.Point(2,60));
         *
         * var circle = SuperMap.Geometry.LineString.calculateCircle(points);
         */

    }, {
        key: 'calculateCircle',
        value: function calculateCircle(points) {
            if (points.length < 3) {
                return points;
            }
            var len = points.length,
                centerPoint = {},
                p1 = points[0],
                p2 = points[1],
                p3 = points[2];
            var R = 0,
                dStep = 0,
                direc = true,
                dRotation = 0,
                dRotationBegin = 0,
                dRotationAngle = 0,
                nSegmentCount = 72,
                centerPoint = {},
                circlePoints = [];

            var KTan13 = (p3.y - p1.y) / (p3.x - p1.x);
            var B13 = p3.y - KTan13 * p3.x;
            if (p3.x != p1.x && p3.y != p1.y && p2.y == KTan13 * p2.x + B13 || p3.x == p1.x && p2.x == p1.x || p3.y == p1.y && p2.y == p1.y || p3.x == p1.x && p3.y == p1.y || p3.x == p2.x && p3.y == p2.y || p1.x == p2.x && p1.y == p2.y) {
                circlePoints.push(p1);
                circlePoints.push(p2);
                circlePoints.push(p3);
            } else {
                var D = (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p3.y - p1.y)) - (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p2.y - p1.y));
                var E = 2 * (p2.x - p1.x) * (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) - 2 * (p3.x - p1.x) * (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y));
                var F = 4 * ((p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y));
                centerPoint.x = D / F;
                centerPoint.y = E / F;
                R = Math.sqrt((p1.x - centerPoint.x) * (p1.x - centerPoint.x) + (p1.y - centerPoint.y) * (p1.y - centerPoint.y));

                var dis = (p1.x - p3.x) * (p1.x - p3.x) + (p1.y - p3.y) * (p1.y - p3.y);
                var cons = (2 * R * R - dis) / (2 * R * R);
                cons = cons >= 1 ? 1 : cons;
                cons = cons <= -1 ? -1 : cons;
                dRotationAngle = Math.acos(cons) * 180 / Math.PI;

                if (p3.x == p1.x) {
                    dRotationAngle = centerPoint.x > p1.x && p2.x > p1.x || centerPoint.x < p1.x && p2.x < p1.x ? 360 - dRotationAngle : dRotationAngle;
                } else {
                    dRotationAngle = centerPoint.y > KTan13 * centerPoint.x + B13 && p2.y > KTan13 * p2.x + B13 || centerPoint.y < KTan13 * centerPoint.x + B13 && p2.y < KTan13 * p2.x + B13 ? 360 - dRotationAngle : dRotationAngle;
                }
                dStep = dRotationAngle / 72;

                if (p3.y != p1.y) {
                    if (p3.x == p1.x) {
                        if (p3.y > p1.y) {
                            if (p2.x < p1.x) {
                                direc = false;
                            }
                        } else {
                            if (p2.x > p1.x) {
                                direc = false;
                            }
                        }
                    } else if (p3.x < p1.x) {
                        if (p2.y < KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    } else {
                        if (p2.y > KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    }
                } else {
                    if (p3.x > p1.x) {
                        if (p2.y > p1.y) {
                            direc = false;
                        }
                    } else {
                        if (p2.y < p1.y) {
                            direc = false;
                        }
                    }
                }

                var K10 = (p1.y - centerPoint.y) / (p1.x - centerPoint.x);
                var atan10 = K10 >= 0 ? Math.atan(K10) * 180 / Math.PI : Math.abs(Math.atan(K10) * 180 / Math.PI) + 90;

                var CY = Math.abs(centerPoint.y);
                if (p1.y == CY && CY == p3.y) {
                    if (p1.x < p3.x) {
                        atan10 = atan10 + 180;
                    }
                }

                var newPY = p1.y - centerPoint.y;
                circlePoints.push(p1);
                for (var i = 1; i < nSegmentCount; i++) {
                    dRotation = dStep * i;
                    dRotationBegin = atan10;

                    if (direc) {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin + dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) + dRotation;
                            }
                        } else {
                            if (K10 > 0) {
                                dRotationBegin = dRotationBegin - 180 + dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin + dRotation;
                            }
                        }
                    } else {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) - dRotation;
                            }
                        } else {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - 180 - dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin - dRotation;
                            }
                        }
                    }

                    dRotationBegin = dRotationBegin * Math.PI / 180;
                    var x = centerPoint.x + R * Math.cos(dRotationBegin);
                    var y = centerPoint.y + R * Math.sin(dRotationBegin);
                    circlePoints.push(new _Point2.default(x, y));
                }
                circlePoints.push(p3);
            }
            return circlePoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.createLineEPS
         * @description 根据点的类型画出不同类型的曲线。点的类型有三种, LTypeArc, LTypeCurve, NONE。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的lineEPS控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-50,30));
         * points.push(new SuperMap.Geometry.Point(-30,50,"LTypeArc"));
         * points.push(new SuperMap.Geometry.Point(2,60));
         * points.push(new SuperMap.Geometry.Point(8,20));
         *
         * var lineEPS = SuperMap.Geometry.LineString.createLineEPS(points);
         */

    }, {
        key: 'createLineEPS',
        value: function createLineEPS(points) {
            var list = [],
                part = 0,
                len = points.length;
            if (points == null || len < 2) {
                return points;
            }
            for (var i = 0; i < len;) {
                var type = points[i].type;
                if (type == 'LTypeArc') {
                    var listObj = LineString.createLineArc(list, i, len, points);
                    list = listObj[0];
                    i = listObj[1];
                } else {
                    list.push(points[i]);
                    i++;
                }
            }
            return list;
        }
    }, {
        key: 'createLineArc',
        value: function createLineArc(list, i, len, points) {
            if (i == 0) {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            } else if (i == len - 1) {
                var bezierP = [points[i - 1], points[i]],
                    bezierPts = LineString.calculateCircle(bezierP);
                Array.prototype.push.apply(list, bezierPts);
                i++;
            } else {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                list.pop();
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            }
            return [list, i];
        }
    }, {
        key: 'createLineCurve',
        value: function createLineCurve(list, i, len, points) {
            if (i == 0) {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeCurve');
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            } else if (i == len - 1) {
                var bezierP = [points[i - 1], points[i]],
                    bezierPts = LineString.calculatePointsFBZN(bezierP);
                Array.prototype.push.apply(list, bezierPts);
                i++;
            } else {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeCurve');
                list.pop();
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            }
            return [list, i];
        }
    }, {
        key: 'addPointEPS',
        value: function addPointEPS(points, i, len, type) {
            var bezierP = [],
                j = i + 1;
            if (i == 0) {
                Array.prototype.push.apply(bezierP, [points[i], points[i + 1]]);
            } else if (i == len - 1) {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i]]);
            } else {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i], points[i + 1]]);
            }
            if (type == 'LTypeCurve') {
                var bezierPts = LineString.calculatePointsFBZN(bezierP);
            } else if (type == 'LTypeArc') {
                var bezierPts = LineString.calculateCircle(bezierP);
            }
            return [bezierPts, j];
        }
    }]);

    return LineString;
}(_Curve3.default);

exports.default = LineString;


_SuperMap2.default.Geometry.LineString = LineString;

/**
 * @private
 * @function InciseBezier
 * 拆分贝赛尔曲线单元
 *
 * pSrcPt -{Array<SuperMap.Geometry.Point>} 传入的待拆分点数组。
 * j - {number} 本次拆分的首点位置，从pSrcPt[j]（包括此点）点向后取4个点进行本次拆分。
 * pDstPt -{Array<SuperMap.Geometry.Point>} 将4个点拆分成7个点，pDstPt是包含此7个点的结果点数组。
 */
function InciseBezier(pSrcPt, j, pDstPt) {
    var buffer = [];
    buffer[0] = [];
    buffer[1] = [];
    buffer[2] = [];
    var i;
    for (i = 0; i < 3; i++) {
        buffer[0][i] = new _Point2.default();
        buffer[0][i].x = (pSrcPt[j + i].x + pSrcPt[j + i + 1].x) / 2;
        buffer[0][i].y = (pSrcPt[j + i].y + pSrcPt[j + i + 1].y) / 2;
    }
    for (i = 0; i < 2; i++) {
        buffer[1][i] = new _Point2.default();
        buffer[1][i].x = (buffer[0][i].x + buffer[0][i + 1].x) / 2;
        buffer[1][i].y = (buffer[0][i].y + buffer[0][i + 1].y) / 2;
    }

    buffer[2][0] = new _Point2.default();
    buffer[2][0].x = (buffer[1][0].x + buffer[1][1].x) / 2;
    buffer[2][0].y = (buffer[1][0].y + buffer[1][1].y) / 2;
    //将输入的四个点拆分成7个点
    pDstPt[0] = pSrcPt[j];
    pDstPt[1] = buffer[0][0];
    pDstPt[2] = buffer[1][0];
    pDstPt[3] = buffer[2][0];
    pDstPt[4] = buffer[1][1];
    pDstPt[5] = buffer[0][2];
    pDstPt[6] = pSrcPt[j + 3];
    return true;
}

/**
 * @private
 * @function SuperMap.Geometry.LineString.GetBezierGap
 * @description 计算贝赛尔曲线两个顶点的纵向和横向的最大距离，结果用来判断是否达到拆分精度。
 * @param pSrcPt {Array<SuperMap.Geometry.Point>} 传入的待拆分点数组。
 * @param j {number} 本次拆分的首点位置，从pSrcPt[j]（包括此点）点向后取4个点进行距离计算。
 */
function GetBezierGap(pSrcPt, j) {
    var gap = 0;
    for (var i = 1; i < 4; i++) {
        if (Math.abs(pSrcPt[j + i].x - pSrcPt[j + i - 1].x) > gap) gap = Math.abs(pSrcPt[j + i].x - pSrcPt[j + i - 1].x);
        if (Math.abs(pSrcPt[j + i].y - pSrcPt[j + i - 1].y) > gap) gap = Math.abs(pSrcPt[j + i].y - pSrcPt[j + i - 1].y);
    }
    return gap;
}

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.DataReturnOption
 * @classdesc 数据返回设置类。
 * @param options - {Object} 可选参数。如：<br>
 *         expectCount - {number} 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。<br>
 *         dataset - {string} 设置结果数据集标识，当dataReturnMode为 SuperMap.DataReturnMode.DATASET_ONLY或SuperMap.DataReturnMode.DATASET_AND_RECORDSET时有效，
 *                            作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。<br>
 *         dataReturnMode - {@link SuperMap.DataReturnMode} 数据返回模式，默认为SuperMap.DataReturnMode.RECORDSET_ONLY。<br>
 *         deleteExistResultDataset - {boolean} 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。默认为true。<br>
 */
var DataReturnOption = function () {

    /**
     * @member SuperMap.DataReturnOption.prototype.dataReturnMode -{SuperMap.DataReturnMode}
     * @description 数据返回模式，默认为SuperMap.DataReturnMode.RECORDSET_ONLY。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.expectCount -{number}
     * @description 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。
     */
    function DataReturnOption(options) {
        _classCallCheck(this, DataReturnOption);

        this.expectCount = 1000;
        this.dataset = null;
        this.dataReturnMode = _REST.DataReturnMode.RECORDSET_ONLY;
        this.deleteExistResultDataset = true;
        this.CLASS_NAME = "SuperMap.DataReturnOption";

        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.DataReturnOption.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.deleteExistResultDataset -{boolean}
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.dataset -{string}
     * @description 设置结果数据集标识，当dataReturnMode为 SuperMap.DataReturnMode.DATASET_ONLY
     * 或SuperMap.DataReturnMode.DATASET_AND_RECORDSET时有效，
     * 作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。
     */


    _createClass(DataReturnOption, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.expectCount = null;
            me.dataset = null;
            me.dataReturnMode = null;
            me.deleteExistResultDataset = null;
        }
    }]);

    return DataReturnOption;
}();

exports.default = DataReturnOption;


_SuperMap2.default.DataReturnOption = DataReturnOption;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FacilityAnalyst3DParameters
 * @classdesc 最近设施分析参数基类。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *               设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在10分钟内能到达的最近医院，
 *               超过10分钟能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起
 *               作用的障碍边、障碍点、转向表、耗费等属性在最近设施分析时同样可设置。
 * @param options - {Object} 可选参数。如：<br>
 *         edgeID - {number} 指定的弧段ID。<br>
 *         nodeID - {integer} 指定的结点ID。<br>
 *         weightName -{string} 指定的权值字段信息对象的名称。<br>
 *         isUncertainDirectionValid - {boolean} 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 *                                               指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */
var FacilityAnalyst3DParameters = function () {

    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.weightName - string}
     * @description 指定的权值字段信息对象的名称。
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.edgeID - {number}
     * @description 指定的弧段ID。
     */
    function FacilityAnalyst3DParameters(options) {
        _classCallCheck(this, FacilityAnalyst3DParameters);

        this.edgeID = null;
        this.nodeID = null;
        this.weightName = null;
        this.isUncertainDirectionValid = false;
        this.CLASS_NAME = "SuperMap.FacilityAnalyst3DParameters";

        var me = this;
        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(me, options);
    }

    /**
     * @function SuperMap.FacilityAnalyst3DParameters.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.isUncertainDirectionValid - {boolean}
     * @description 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
     *                指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.nodeID - {number}
     * @description 指定的结点ID。
     */


    _createClass(FacilityAnalyst3DParameters, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.edgeID = null;
            me.nodeID = null;
            me.weightName = null;
            me.isUncertainDirectionValid = null;
        }
    }]);

    return FacilityAnalyst3DParameters;
}();

exports.default = FacilityAnalyst3DParameters;

_SuperMap2.default.FacilityAnalyst3DParameters = FacilityAnalyst3DParameters;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.GetFeaturesParametersBase
 * @classdesc 要素查询参数基类
 * @param options - {Object} 参数。如：<br>
 *        datasetNames - {Array<string>} 数据集集合中的数据集名称列表。</br>
 *        returnContent - {boolean} 是否直接返回查询结果。</br>
 *        fromIndex - {integer} 查询结果的最小索引号。</br>
 *        toIndex - {integer} 查询结果的最大索引号。</br>
 */
var GetFeaturesParametersBase = function () {

    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.returnCountOnly - {boolean}
     * @description 只返回查询结果的总数，默认为false。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.fromIndex - {integer}
     * @description 查询结果的最小索引号。默认值是0，如果该值大于查询结果的最大索引号，则查询结果为空。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.datasetName - {Array<string>}
     * @description 数据集集合中的数据集名称列表。
     */
    function GetFeaturesParametersBase(options) {
        _classCallCheck(this, GetFeaturesParametersBase);

        this.datasetNames = null;
        this.returnContent = true;
        this.fromIndex = 0;
        this.toIndex = 19;
        this.returnCountOnly = false;
        this.maxFeatures = null;
        this.CLASS_NAME = "SuperMap.GetFeaturesParametersBase";

        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     *
     * @function SuperMap.GetFeaturesParametersBase.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.maxFeatures - {integer}
     * @description 进行SQL查询时，用于设置服务端返回查询结果条目数量，默认为1000。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.toIndex - {integer}
     * @description 查询结果的最大索引号。默认值是19，如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.returnContent - {boolean}
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     *              如果为 true，则直接返回新创建资源，即查询结果的表述。
     *              如果为 false，则返回的是查询结果资源的 URI。默认为 true。
     */


    _createClass(GetFeaturesParametersBase, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.datasetNames = null;
            me.returnContent = null;
            me.fromIndex = null;
            me.toIndex = null;
            me.maxFeatures = null;
        }
    }]);

    return GetFeaturesParametersBase;
}();

exports.default = GetFeaturesParametersBase;


_SuperMap2.default.GetFeaturesParametersBase = GetFeaturesParametersBase;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesServiceBase
 * @classdesc 数据服务中数据集查询服务基类。获取结果数据类型为Object。包含 result属性，result的数据格式根据format参数决定为GeoJSON或者iServerJSON。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务，URL
 * 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myService = new SuperMap.GetFeaturesServiceBase(url, {
 *     eventListeners: {
 *         "processCompleted": getFeatureCompleted,
 *         "processFailed": getFeatureError
 *     }
 * });
 */
var GetFeaturesServiceBase = function (_CommonServiceBase) {
    _inherits(GetFeaturesServiceBase, _CommonServiceBase);

    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.maxFeatures - {integer}
     * @description 进行SQL查询时，用于设置服务端返回查询结果条目数量，默认为1000。
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.fromIndex - {integer}
     * @description 查询结果的最小索引号。
     * 默认值是0，如果该值大于查询结果的最大索引号，则查询结果为空。
     */
    function GetFeaturesServiceBase(url, options) {
        _classCallCheck(this, GetFeaturesServiceBase);

        var _this = _possibleConstructorReturn(this, (GetFeaturesServiceBase.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase)).call(this, url, options));

        _this.returnContent = true;
        _this.fromIndex = 0;
        _this.toIndex = 19;
        _this.maxFeatures = null;
        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.GetFeaturesServiceBase";

        options = options || {};
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var me = _this,
            end;
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);
        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (me.format==="geojson" ) {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end == "/" ? "featureResults.json?" : "/featureResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesServiceBase.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.format - {string}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。
     *  参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.toIndex - {integer}
     * @description 查询结果的最大索引号。
     * 如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
     */

    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.returnContent - {boolean}
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     * 如果为 true，则直接返回新创建资源，即查询结果的表述。
     * 如果为 false，则返回的是查询结果资源的 URI。默认为 false。
     */


    _createClass(GetFeaturesServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesServiceBase.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.fromIndex = null;
            me.toIndex = null;
            me.maxFeatures = null;
            me.format = null;
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.processAsync
         * @description  将客户端的查询参数传递到服务端。
         * @param params - {Object} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters = null,
                firstPara = true;

            me.returnContent = params.returnContent;
            me.fromIndex = params.fromIndex;
            me.toIndex = params.toIndex;
            me.maxFeatures = params.maxFeatures;
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
                firstPara = false;
            }
            var isValidNumber = me.fromIndex != null && me.toIndex != null && !isNaN(me.fromIndex) && !isNaN(me.toIndex);
            if (isValidNumber && me.fromIndex >= 0 && me.toIndex >= 0 && !firstPara) {
                me.url += "&fromIndex=" + me.fromIndex + "&toIndex=" + me.toIndex;
            }

            if (params.returnCountOnly) me.url += "&returnCountOnly=" + params.returnContent;
            jsonParameters = me.getJsonParameters(params);
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.getFeatureComplete
         * @description 查询完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            if (me.format === _REST.DataFormat.GEOJSON && result.features) {
                var geoJSONFormat = new _GeoJSON2.default();
                result.features = JSON.parse(geoJSONFormat.write(result.features));
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }
    }]);

    return GetFeaturesServiceBase;
}(_CommonServiceBase3.default);

exports.default = GetFeaturesServiceBase;


_SuperMap2.default.GetFeaturesServiceBase = GetFeaturesServiceBase;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ClipParameter = __webpack_require__(148);

var _ClipParameter2 = _interopRequireDefault(_ClipParameter);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.InterpolationAnalystParameters
 * @classdesc 插值分析参数类。
 * @param options - {Object} 可选参数。如：</br>
 *        bounds - {Object} 插值分析的范围，用于确定结果栅格数据集的范围。Bounds类型可以是SuperMap.Bounds|L.Bounds|ol.extent。</br>
 *        searchRadius - {number} 查找半径，即参与运算点的查找范围，与点数据集单位相同。</br>
 *        zValueFieldName - {string} 存储用于进行插值分析的字段名称，插值分析不支持文本类型的字段。</br>
 *        zValueScale - {number} 用于进行插值分析值的缩放比率，默认为1。</br>
 *        resolution - {number} 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。</br>
 *        filterQueryParameter - {{@link SuperMap.FilterParameter}} 属性过滤条件。</br>
 *        outputDatasetName - {string} 插值分析结果数据集的名称。</br>
 *        outputDatasourceName - {string} 插值分析结果数据源的名称。</br>
 *        pixelFormat - {{@link SuperMap.PixelFormat}} 指定结果栅格数据集存储的像素格式。</br>
 *        dataset - {string} 用于做插值分析的数据源中数据集的名称。</br>
 *        inputPoints - {Array <Object>} 用于做插值分析的离散点集合。点类型可以是：SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point。</br>
 *        InterpolationAnalystType - {string} 插值分析类型（dataset或geometry），默认为dataset 。</br>
 */
var InterpolationAnalystParameters = function () {

    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.InterpolationAnalystType - {string}
     * @description  插值分析类型。差值分析包括数据集插值分析和几何插值分析两类，
     * "dataset"表示对数据集进行插值分析，"geometry"表示对离散点数组进行插值分析，默认值为"dataset"。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.dataset - {string}
     * @description 用来做插值分析的数据源中数据集的名称，该名称用形如"数据集名称@数据源别名"形式来表示。
     * 当插值分析类型(InterpolationAnalystType)为 dataset 时，必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.outputDatasourceName - {string}
     * @description 插值分析结果数据源的名称。必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.filterQueryParameter - {SuperMap.FilterParameter}
     * @description 过滤条件，对分析数据集中的点进行过滤，不设置时默认为null，即对数据集中的所有点进行分析。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.zValueScale - {number}
     * @description 用于进行插值分析值的缩放比率，默认值为1。
     * 参加插值分析的值将乘以该参数值后再进行插值，也就是对进行插值分析的值进行统一的扩大或缩小。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.searchRadius - {number}
     * @description 查找半径，即参与运算点的查找范围，与点数据集单位相同，默认值为0。
     * 计算某个位置的Z 值时，会以该位置为圆心，以查找范围的值为半径，落在这个范围内的采样点都将参与运算。
     * 该值需要根据待插值点数据的分布状况和点数据集范围进行设置。
     */
    function InterpolationAnalystParameters(options) {
        _classCallCheck(this, InterpolationAnalystParameters);

        this.bounds = null;
        this.searchRadius = 0;
        this.zValueFieldName = null;
        this.zValueScale = 1;
        this.resolution = null;
        this.filterQueryParameter = null;
        this.outputDatasetName = null;
        this.outputDatasourceName = null;
        this.pixelFormat = _REST.PixelFormat.BIT16;
        this.dataset = null;
        this.inputPoints = null;
        this.InterpolationAnalystType = "dataset";
        this.clipParam = null;
        this.CLASS_NAME = "SuperMap.InterpolationAnalystParameters";

        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     * @function SuperMap.InterpolationAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.clipParam - {Object}
     * @description 对插值分析结果进行裁剪的参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.inputPoints - {Array<Object>}
     * @description 用于做插值分析的离散点（离散点包括Z值）集合。
     * 点类型可以是：SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point。
     * 当插值分析类型（InterpolationAnalystType）为 geometry 时，此参数为必设参数。
     * 通过离散点直接进行插值分析不需要指定输入数据集inputDatasourceName，inputDatasetName以及zValueFieldName。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.pixelFormat - {SuperMap.PixelFormat}
     * @description 指定结果栅格数据集存储的像素格式。
     * 默认值为 SuperMap.PixelFormat.BIT16。
     * 支持存储的像素格式有 BIT16、BIT32、DOUBLE、SINGLE、UBIT1、UBIT4、UBIT8、UBIT24、UBIT32。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.outputDatasetName - {string}
     * @description 插值分析结果数据集的名称。必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.resolution - {number}
     * @description 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。
     * 该值不能超过待分析数据集的范围边长。
     * 且该值设置时，应该考虑点数据集范围大小来取值，一般为结果栅格行列值（即结果栅格数据集范围除以分辨率），在500以内可以较好地体现密度走势。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.zValueFieldName - {string}
     * @description 数据集插值分析中，用于指定进行插值分析的目标字段名，插值分析不支持文本类型的字段。
     * 含义为每个插值点在插值过程中的权重，可以将所有点此字段值设置为1，即所有点在整体插值中权重相同。
     * 当插值分析类型(InterpolationAnalystType)为 dataset 时，必设参数。
     */

    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.bounds - {Object}
     * @description 插值分析的范围，用于确定结果栅格数据集的范围。
     * Bounds类型可以是SuperMap.Bounds|L.Bounds|ol.extent。
     * 如果缺省，则默认为原数据集的范围。鉴于此插值方法为内插方法，原数据集的范围内的插值结果才相对有参考价值，
     * 因此建议此参数不大于原数据集范围。
     */


    _createClass(InterpolationAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.bounds = null;
            me.searchRadius = null;
            me.zValueFieldName = null;
            me.zValueScale = null;

            me.resolution = null;
            me.filterQueryParameter = null;
            me.outputDatasetName = null;
            me.pixelFormat = null;
        }

        /**
         * @function SuperMap.InterpolationAnalystParameters.toObject
         * @param interpolationAnalystParameters - {SuperMap.InterpolationAnalystParameters} 插值分析参数类。
         * @param tempObj - {SuperMap.InterpolationAnalystParameters} 插值分析参数对象。
         * @description 将插值分析参数对象转换成JSON对象。
         * @return JSON对象。
         */

    }], [{
        key: 'toObject',
        value: function toObject(interpolationAnalystParameters, tempObj) {
            for (var name in interpolationAnalystParameters) {
                if (name === "inputPoints" && interpolationAnalystParameters.InterpolationAnalystType === "geometry") {
                    var objs = [];
                    for (var i = 0; i < interpolationAnalystParameters.inputPoints.length; i++) {
                        var item = interpolationAnalystParameters.inputPoints[i];
                        var obj = {
                            x: item.x,
                            y: item.y,
                            z: item.tag
                        };
                        objs.push(obj);
                    }
                    tempObj[name] = objs;
                } else {
                    tempObj[name] = interpolationAnalystParameters[name];
                }
            }
        }
    }]);

    return InterpolationAnalystParameters;
}();

exports.default = InterpolationAnalystParameters;


_SuperMap2.default.InterpolationAnalystParameters = InterpolationAnalystParameters;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FetchRequest = __webpack_require__(28);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ProcessingServiceBase
 * @description 分布式分析服务基类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 分布式分析服务地址。
 * @param options - {Object} 参数。如：<br>
 *        events - {{@link SuperMap.Events}} 处理所有事件的对象。<br>
 *        eventListeners - {Object} 听器对象。<br>
 *        serverType - {{@link ServerType}} 服务器类型，iServer|iPortal|Online。<br>
 *        index - {number}服务访问地址在数组中的位置。<br>
 *        length - {number}服务访问地址数组长度。
 */
var ProcessingServiceBase = function (_CommonServiceBase) {
    _inherits(ProcessingServiceBase, _CommonServiceBase);

    function ProcessingServiceBase(url, options) {
        _classCallCheck(this, ProcessingServiceBase);

        options = options || {};
        /*
         * Constant: EVENT_TYPES
         * {Array<string>}
         * 此类支持的事件类型
         * - *processCompleted* 创建成功后触发的事件。
         * - *processFailed* 创建失败后触发的事件 。
         * - *processRunning* 创建过程的整个阶段都会触发的事件，用于获取创建过程的状态 。
         */
        options.EVENT_TYPES = ["processCompleted", "processFailed", "processRunning"];

        var _this = _possibleConstructorReturn(this, (ProcessingServiceBase.__proto__ || Object.getPrototypeOf(ProcessingServiceBase)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ProcessingServiceBase";
        return _this;
    }

    /**
     * @function SuperMap.ProcessingServiceBase.prototype.destroy
     * @override
     */


    _createClass(ProcessingServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.getJobs
         * @description 获取分布式分析任务。
         * @param url - {string} 资源地址。
         */

    }, {
        key: 'getJobs',
        value: function getJobs(url) {
            var me = this;
            _FetchRequest.FetchRequest.get(url).then(function (response) {
                return response.json();
            }).then(function (result) {
                me.events.triggerEvent("processCompleted", { result: result });
            }).catch(function (e) {
                me.eventListeners.processFailed({ error: e });
            });
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.addJob
         * @description 添加分布式分析任务。
         * @param url - {string} 资源根地址。
         * @param params - {Object} 创建一个空间分析的请求参数。
         * @param paramType - {string} - 请求参数类型。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addJob',
        value: function addJob(url, params, paramType, seconds) {
            var me = this,
                parameterObject = null;
            if (params && params instanceof paramType) {
                parameterObject = new Object();
                paramType.toObject(params, parameterObject);
            }
            var options = {
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            };
            _FetchRequest.FetchRequest.post(me._processUrl(url), JSON.stringify(parameterObject), options).then(function (response) {
                return response.json();
            }).then(function (result) {
                if (result.succeed) {
                    me.serviceProcessCompleted(result, seconds);
                } else {
                    me.serviceProcessFailed(result);
                }
            }).catch(function (e) {
                me.serviceProcessFailed({ error: e });
            });
        }
    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result, seconds) {
            result = _SuperMap2.default.Util.transformResult(result);
            seconds = seconds || 1000;
            var me = this;
            if (result) {
                var id = setInterval(function () {
                    _FetchRequest.FetchRequest.get(result.newResourceLocation).then(function (response) {
                        return response.json();
                    }).then(function (job) {
                        me.events.triggerEvent("processRunning", { id: job.id, state: job.state });
                        if (job.state.runState === 'LOST' || job.state.runState === 'KILLED' || job.state.runState === 'FAILED') {
                            clearInterval(id);
                            me.events.triggerEvent("processFailed", { error: job.state.errorMsg, state: job.state.runState });
                        }
                        if (job.state.runState === 'FINISHED' && job.setting.serviceInfo) {
                            clearInterval(id);
                            me.events.triggerEvent("processCompleted", { result: job });
                        }
                    }).catch(function (e) {
                        clearInterval(id);
                        me.events.triggerEvent("processFailed", { error: e });
                    });
                }, seconds);
            }
        }
    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'serviceProcessFailed', this).call(this, result);
        }

        //为不是以.json结尾的url加上.json，并且如果有token的话，在.json后加上token参数。

    }, {
        key: '_processUrl',
        value: function _processUrl(url) {
            if (url.indexOf('.json') === -1) {
                url += '.json';
            }
            if (_SuperMap2.default.SecurityManager.getToken(url)) {
                url += '?token=' + _SuperMap2.default.SecurityManager.getToken(url);
            }
            return url;
        }
    }]);

    return ProcessingServiceBase;
}(_CommonServiceBase3.default);

exports.default = ProcessingServiceBase;


_SuperMap2.default.ProcessingServiceBase = ProcessingServiceBase;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection = __webpack_require__(13);

var _Collection2 = _interopRequireDefault(_Collection);

var _LineString2 = __webpack_require__(18);

var _LineString3 = _interopRequireDefault(_LineString2);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _BaseTypes = __webpack_require__(29);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class  SuperMap.Geometry.LinearRing
 * @classdesc 几何对象线环类，是一个特殊的封闭的线串，在每次addPoint/removePoint之后会通过添加一个点（此点是复制的第一个点得到的）
 *             作为最后的一个点来自动关闭线环。
 * @extends {SuperMap.Geometry.LineString}
 * @param points {Array<SuperMap.Geometry.Point>} 组成线性环的点。
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *      new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *      new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *      new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *      new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var linearRing = new SuperMap.Geometry.LinearRing(points);
 */
var LinearRing = function (_LineString) {
    _inherits(LinearRing, _LineString);

    function LinearRing(points) {
        _classCallCheck(this, LinearRing);

        var _this = _possibleConstructorReturn(this, (LinearRing.__proto__ || Object.getPrototypeOf(LinearRing)).call(this, points));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.LinearRing";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LinearRing.prototype.addComponent
     * @description 添加一个点到几何图形数组中，如果这个点将要被添加到组件数组的末端，并且与数组中已经存在的最后一个点相同，
     *                重复的点是不能被添加的。这将影响未关闭环的关闭。这个方法可以通过将非空索引（组件数组的下标）作为第二个参数重写。
     * @param point {SuperMap.Geometry.Point} 点对象。
     * @param index {integer} 插入组件数组的下标。
     * @returns {boolean} 点对象是否添加成功。
     */


    /**
     * @member SuperMap.Geometry.LinearRing.prototype.componentTypes - {Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Point}"]
     */


    _createClass(LinearRing, [{
        key: 'addComponent',
        value: function addComponent(point, index) {
            var added = false;

            //remove last point
            var lastPoint = this.components.pop();

            // given an index, add the point
            // without an index only add non-duplicate points
            if (index != null || !point.equals(lastPoint)) {
                added = _Collection2.default.prototype.addComponent.apply(this, arguments);
            }

            //append copy of first point
            var firstPoint = this.components[0];
            _Collection2.default.prototype.addComponent.apply(this, [firstPoint]);

            return added;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.removeComponent
         * @description 从几何组件中删除一个点。
         * @param point {SuperMap.Geometry.Point} 点对象。
         * @returns {boolean} 点对象是否删除。
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(point) {
            var removed = this.components && this.components.length > 3;
            if (removed) {
                //remove last point
                this.components.pop();

                //remove our point
                _Collection2.default.prototype.removeComponent.apply(this, arguments);
                //append copy of first point
                var firstPoint = this.components[0];
                _Collection2.default.prototype.addComponent.apply(this, [firstPoint]);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.move
         * @description 沿着给定的x、y轴正方向按照给定的位移移动一个几何图形，move 不仅改变了几何图形的位置并且清理了边界缓存。
         * @param x {float} x轴正方向上的偏移量。
         * @param y {float} y轴正方向上的偏移量。
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            for (var i = 0, len = this.components.length; i < len - 1; i++) {
                this.components[i].move(x, y);
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.rotate
         * @description 围绕中心点旋转几何图形。
         * @param angle {float} 旋转角的度数（沿着x轴正方向的逆时针方向）。
         * @param origin {SuperMap.Geometry.Point} 旋转中心点。
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            for (var i = 0, len = this.components.length; i < len - 1; ++i) {
                this.components[i].rotate(angle, origin);
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.resize
         * @description 调整几何对象的大小。
         * @param scale - {float} 几何图形缩放的比例系数，是几何图形维数的两倍。（如：对于线来说将以线2倍的长度拉长，对于多边形来说，将以面积的4倍变化）。
         * @param origin {SuperMap.Geometry.Point} 调整大小选定的起始原点。
         * @param ratio {float} 可选的x,y的比例，默认的比例为1。
         * @returns {SuperMap.Geometry} 当前的几何对象。
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            for (var i = 0, len = this.components.length; i < len - 1; ++i) {
                this.components[i].resize(scale, origin, ratio);
            }
            return this;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getCentroid
         * @description 获取几何对象的质心。
         * @returns {SuperMap.Geometry.Point} 几何图形的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            if (this.components) {
                var len = this.components.length;
                if (len > 0 && len <= 2) {
                    return this.components.clone();
                } else if (len > 2) {
                    var sumX = 0.0;
                    var sumY = 0.0;
                    var x0 = this.components[0].x;
                    var y0 = this.components[0].y;
                    var area = -1 * this.getArea();
                    if (area != 0) {
                        for (var i = 0; i < len - 1; i++) {
                            var b = this.components[i];
                            var c = this.components[i + 1];
                            sumX += (b.x + c.x - 2 * x0) * ((b.x - x0) * (c.y - y0) - (c.x - x0) * (b.y - y0));
                            sumY += (b.y + c.y - 2 * y0) * ((b.x - x0) * (c.y - y0) - (c.x - x0) * (b.y - y0));
                        }
                        var x = x0 + sumX / (6 * area);
                        var y = y0 + sumY / (6 * area);
                    } else {
                        for (var i = 0; i < len - 1; i++) {
                            sumX += this.components[i].x;
                            sumY += this.components[i].y;
                        }
                        var x = sumX / (len - 1);
                        var y = sumY / (len - 1);
                    }
                    return new _Point2.default(x, y);
                } else {
                    return null;
                }
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getArea
         * @description 获得当前几何对象区域大小，如果是沿顺时针方向的环则是正值，否则为负值。
         * @returns {float} 环的面积。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 2) {
                var sum = 0.0;
                for (var i = 0, len = this.components.length; i < len - 1; i++) {
                    var b = this.components[i];
                    var c = this.components[i + 1];
                    sum += (b.x + c.x) * (c.y - b.y);
                }
                area = -sum / 2.0;
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.containsPoint
         * @description 判断点是否在线环上，是返回1，不是返回0。
         * @param point {SuperMap.Geometry.Point}
         * @returns {boolean | number} 点是否在线环上。
         */

    }, {
        key: 'containsPoint',
        value: function containsPoint(point) {
            var approx = _BaseTypes.NumberExt.limitSigDigs;
            var digs = 14;
            var px = approx(point.x, digs);
            var py = approx(point.y, digs);

            function getX(y, x1, y1, x2, y2) {
                return (y - y2) * ((x2 - x1) / (y2 - y1)) + x2;
            }

            var numSeg = this.components.length - 1;
            var start, end, x1, y1, x2, y2, cx, cy;
            var crosses = 0;
            for (var i = 0; i < numSeg; ++i) {
                start = this.components[i];
                x1 = approx(start.x, digs);
                y1 = approx(start.y, digs);
                end = this.components[i + 1];
                x2 = approx(end.x, digs);
                y2 = approx(end.y, digs);

                /**
                 * The following conditions enforce five edge-crossing rules:
                 *    1. points coincident with edges are considered contained;
                 *    2. an upward edge includes its starting endpoint, and
                 *    excludes its final endpoint;
                 *    3. a downward edge excludes its starting endpoint, and
                 *    includes its final endpoint;
                 *    4. horizontal edges are excluded; and
                 *    5. the edge-ray intersection point must be strictly right
                 *    of the point P.
                 */
                if (y1 === y2) {
                    // horizontal edge
                    if (py === y1) {
                        // point on horizontal line
                        if (x1 <= x2 && px >= x1 && px <= x2 || // right or vert
                        x1 >= x2 && px <= x1 && px >= x2) {
                            // left or vert
                            // point on edge
                            crosses = -1;
                            break;
                        }
                    }
                    // ignore other horizontal edges
                    continue;
                }
                cx = approx(getX(py, x1, y1, x2, y2), digs);
                if (cx === px) {
                    // point on line
                    if (y1 < y2 && py >= y1 && py <= y2 || // upward
                    y1 > y2 && py <= y1 && py >= y2) {
                        // downward
                        // point on edge
                        crosses = -1;
                        break;
                    }
                }
                if (cx <= px) {
                    // no crossing to the right
                    continue;
                }
                if (x1 !== x2 && (cx < Math.min(x1, x2) || cx > Math.max(x1, x2))) {
                    // no crossing
                    continue;
                }
                if (y1 < y2 && py >= y1 && py < y2 || // upward
                y1 > y2 && py < y1 && py >= y2) {
                    // downward
                    ++crosses;
                }
            }
            var contained = crosses === -1 ?
            // on edge
            1 :
            // even (out) or odd (in)
            !!(crosses & 1);

            return contained;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.intersects
         * @description 判断输入的几何图形是否与当前几何图形相交。
         * @param geometry {SuperMap.Geometry} 任意的几何对象。
         * @returns {boolean} 输入几何图形与当前的目标几何图形相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.containsPoint(geometry);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LineString") {
                intersect = geometry.intersects(this);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LinearRing") {
                intersect = _LineString3.default.prototype.intersects.apply(this, [geometry]);
            } else {
                // check for component intersections
                for (var i = 0, len = geometry.components.length; i < len; ++i) {
                    intersect = geometry.components[i].intersects(this);
                    if (intersect) {
                        break;
                    }
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getVertices
         * @description 返回几何图形的所有点的列表。
         * @param nodes {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点。如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象所有点的列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            return nodes === true ? [] : this.components.slice(0, this.components.length - 1);
        }
    }]);

    return LinearRing;
}(_LineString3.default);

exports.default = LinearRing;

_SuperMap2.default.Geometry.LinearRing = LinearRing;

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _QueryParameters = __webpack_require__(14);

var _QueryParameters2 = _interopRequireDefault(_QueryParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryService
 * @classdesc 查询服务基类。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myService = new SuperMap.QueryService(url, {
 *     eventListeners: {
 *	       "processCompleted": queryCompleted,
 *		   "processFailed": queryError
 *		   }
 * };
 */
var QueryService = function (_CommonServiceBase) {
    _inherits(QueryService, _CommonServiceBase);

    /*
     * @function SuperMap.QueryService.prototype.constructor
     * @description 查询服务基类构造函数。
     * @param url - {string} 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
     * @param options - {Object} 可选参数。如：<br>
     *        eventListeners - {Object} 需要被注册的监听器对象。
     */


    /*
     * Property: returnContent
     * {Boolean} 是否立即返回新创建资源的表述还是返回新资源的URI。
     */
    function QueryService(url, options) {
        _classCallCheck(this, QueryService);

        var _this = _possibleConstructorReturn(this, (QueryService.__proto__ || Object.getPrototypeOf(QueryService)).call(this, url, options));

        _this.returnContent = false;
        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.QueryService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var me = _this,
            end;
        if (!me.url) {
            return _possibleConstructorReturn(_this);
        }
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);

        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (this.format==="geojson") {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end === "/" ? "queryResults.json?" : "/queryResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.QueryService.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /*
     *  Property: format
     *  {string} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *  参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    _createClass(QueryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryService.prototype.__proto__ || Object.getPrototypeOf(QueryService.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.format = null;
        }

        /**
         * @function SuperMap.QueryService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {QueryParameters} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                returnCustomResult = null,
                jsonParameters = null;
            me.returnContent = params.returnContent;
            jsonParameters = me.getJsonParameters(params);
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
            } else {
                //仅供三维使用 获取高亮图片的bounds
                returnCustomResult = params.returnCustomResult;
                if (returnCustomResult) {
                    me.url += "returnCustomResult=" + returnCustomResult;
                }
            }
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /*
         * Method: queryComplete
         * 查询完成，执行此方法。
         *
         * Parameters:
         * result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result && result.recordsets && me.format === _SuperMap2.default.DataFormat.GEOJSON) {
                var geoJSONFormat = new _GeoJSON2.default();
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        recordsets[i].features = JSON.parse(geoJSONFormat.write(recordsets[i].features));
                    }
                }
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }

        /**
         * @function SuperMap.QueryService.prototype.getQueryParameters
         * @description 将 JSON 对象表示的查询参数转化为 QueryParameters 对象。
         * @param params - {Object} JSON 字符串表示的查询参数。
         * @return {QueryParameters} 返回转化后的 QueryParameters 对象。
         */

    }, {
        key: 'getQueryParameters',
        value: function getQueryParameters(params) {
            return new _QueryParameters2.default({
                customParams: params.customParams,
                expectCount: params.expectCount,
                networkType: params.networkType,
                queryOption: params.queryOption,
                queryParams: params.queryParams,
                startRecord: params.startRecord,
                prjCoordSys: params.prjCoordSys,
                holdTime: params.holdTime
            });
        }
    }]);

    return QueryService;
}(_CommonServiceBase3.default);

exports.default = QueryService;


_SuperMap2.default.QueryService = QueryService;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _UGCMapLayer2 = __webpack_require__(243);

var _UGCMapLayer3 = _interopRequireDefault(_UGCMapLayer2);

var _JoinItem = __webpack_require__(32);

var _JoinItem2 = _interopRequireDefault(_JoinItem);

var _DatasetInfo = __webpack_require__(152);

var _DatasetInfo2 = _interopRequireDefault(_DatasetInfo);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.UGCSubLayer
 * @classdesc 地图服务图层属性信息类，影像图层(Image)、专题图层(ServerTheme)、栅格图层(Grid)、矢量图层(Vector)等图层均继承该类。
 * @extends SuperMap.UGCMapLayer
 * @param options - {Object} 可选参数。如：<br>
 *        datasetInfo - {{@link SuperMap.DatasetInfo}} 数据集信息。<br>
 *        displayFilter - {string} 图层显示过滤条件。<br>
 *        joinItems - {{@link SuperMap.JoinItem}} 连接信息类。<br>
 *        representationField - {string} 存储制图表达信息的字段。<br>
 *        ugcLayerType - {{@link SuperMap.LayerType}} 图层类型
 */
var UGCSubLayer = function (_UGCMapLayer) {
    _inherits(UGCSubLayer, _UGCMapLayer);

    /*
     * Constructor: SuperMap.UGCSubLayer
     * 地图服务图层属性信息类构造函数。
     。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.representationField -{string}
     * @description 存储制图表达信息的字段。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.displayFilter -{string}
     * @description 图层显示过滤条件。
     */
    function UGCSubLayer(options) {
        _classCallCheck(this, UGCSubLayer);

        options = options || {};

        var _this = _possibleConstructorReturn(this, (UGCSubLayer.__proto__ || Object.getPrototypeOf(UGCSubLayer)).call(this, options));

        _this.datasetInfo = null;
        _this.displayFilter = null;
        _this.joinItems = null;
        _this.representationField = null;
        _this.ugcLayerType = null;
        _this.CLASS_NAME = "SuperMap.UGCSubLayer";
        return _this;
    }

    /**
     * @function SuperMap.UGCSubLayer.prototype.fromJson
     * @description 将服务端JSON对象转换成当前客户端对象
     * @param jsonObject - {Object} 要转换的 JSON 对象。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.ugcLayerType -{SuperMap.LayerType}
     * @description 图层类型。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.joinItems -{SuperMap.JoinItem}
     * @description 连接信息类。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.datasetInfo -{SuperMap.DatasetInfo}
     * @description 数据集信息。
     */


    _createClass(UGCSubLayer, [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'fromJson', this).call(this, jsonObject);
            if (this.datasetInfo) {
                this.datasetInfo = new _DatasetInfo2.default(this.datasetInfo);
            }
            if (this.joinItems && this.joinItems.length) {
                var newJoinItems = [];
                for (var i = 0; i < this.joinItems.length; i++) {
                    newJoinItems[i] = new _JoinItem2.default(this.joinItems[i]);
                }
                this.joinItems = newJoinItems;
            }
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'toServerJSONObject', this).call(this);
            if (jsonObject.joinItems) {
                var joinItems = [];
                for (var i = 0; i < jsonObject.joinItems.length; i++) {
                    if (jsonObject.joinItems[i].toServerJSONObject) {
                        joinItems[i] = jsonObject.joinItems[i].toServerJSONObject();
                    }
                }
                jsonObject.joinItems = joinItems;
            }
            if (jsonObject.datasetInfo) {
                if (jsonObject.datasetInfo.toServerJSONObject) {
                    jsonObject.datasetInfo = jsonObject.datasetInfo.toServerJSONObject();
                }
            }
            return jsonObject;
        }
    }]);

    return UGCSubLayer;
}(_UGCMapLayer3.default);

exports.default = UGCSubLayer;


_SuperMap2.default.UGCSubLayer = UGCSubLayer;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FetchRequest = exports.Support = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

__webpack_require__(252);

var _whatwgFetchImportable = __webpack_require__(130);

var _whatwgFetchImportable2 = _interopRequireDefault(_whatwgFetchImportable);

var _fetchJsonp2 = __webpack_require__(124);

var _fetchJsonp3 = _interopRequireDefault(_fetchJsonp2);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Support = exports.Support = _SuperMap2.default.Support = _SuperMap2.default.Support || {
    cors: window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest()
};
var FetchRequest = exports.FetchRequest = _SuperMap2.default.FetchRequest = {
    commit: function commit(method, url, params, options) {
        method = method ? method.toUpperCase() : method;
        switch (method) {
            case 'GET':
                return this.get(url, params, options);
            case 'POST':
                return this.post(url, params, options);
            case 'PUT':
                return this.put(url, params, options);
            case 'DELETE':
                return this.delete(url, params, options);
            default:
                return this.get(url, params, options);
        }
    },

    get: function get(url, params, options) {
        options = options || {};
        var type = 'GET';
        url = this._processUrl(url, options);
        url = _SuperMap2.default.Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.urlIsLong(url)) {
            if (_SuperMap2.default.Util.isInTheSameDomain(url) || Support.cors || options.proxy) {
                return this._fetch(url, params, options, type);
            }
            if (!_SuperMap2.default.Util.isInTheSameDomain(url)) {
                url = url.replace('.json', '.jsonp');
                return this._fetchJsonp(url, options);
            }
        }
        return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    },

    delete: function _delete(url, params, options) {
        options = options || {};
        var type = 'DELETE';
        url = this._processUrl(url, options);
        url = _SuperMap2.default.Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.urlIsLong(url) && Support.cors) {
            return this._fetch(url, params, options, type);
        }
        return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    },

    post: function post(url, params, options) {
        options = options || {};
        return this._fetch(this._processUrl(url, options), params, options, 'POST');
    },

    put: function put(url, params, options) {
        options = options || {};
        return this._fetch(this._processUrl(url, options), params, options, 'PUT');
    },
    urlIsLong: function urlIsLong(url) {
        //当前url的字节长度。
        var totalLength = 0,
            charCode = null;
        for (var i = 0, len = url.length; i < len; i++) {
            //转化为Unicode编码
            charCode = url.charCodeAt(i);
            if (charCode < 0x007f) {
                totalLength++;
            } else if (0x0080 <= charCode && charCode <= 0x07ff) {
                totalLength += 2;
            } else if (0x0800 <= charCode && charCode <= 0xffff) {
                totalLength += 3;
            }
        }
        return totalLength < 2000 ? false : true;
    },
    _postSimulatie: function _postSimulatie(type, url, params, options) {
        var separator = url.indexOf("?") > -1 ? "&" : "?";
        url += separator + '_method= ' + type;
        return this.post(url, params, options);
    },

    _processUrl: function _processUrl(url, options) {
        if (this._isMVTRequest(url)) {
            return url;
        }

        if (url.indexOf('.json') === -1 && !options.withoutFormatSuffix) {
            if (url.indexOf("?") < 0) {
                url += '.json';
            } else {
                var urlArrays = url.split("?");
                if (urlArrays.length === 2) {
                    url = urlArrays[0] + ".json?" + urlArrays[1];
                }
            }
        }
        if (options && options.proxy) {
            if (typeof options.proxy === "function") {
                url = options.proxy(url);
            } else {
                url = decodeURIComponent(url);
                url = options.proxy + encodeURIComponent(url);
            }
        }
        return url;
    },

    _fetch: function _fetch(url, params, options, type) {
        options = options || {};
        options.headers = options.headers || {};
        if (!options.headers['Content-Type']) {
            options.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8';
        }
        if (options.timeout) {
            return this._timeout(options.timeout, (0, _whatwgFetchImportable2.default)(url, {
                method: type,
                headers: options.headers,
                body: type === 'PUT' || type === 'POST' ? params : undefined,
                credentials: options.withCredentials ? 'include' : 'omit',
                mode: 'cors'
            }).then(function (response) {
                return response;
            }));
        }
        return (0, _whatwgFetchImportable2.default)(url, {
            method: type,
            body: type === 'PUT' || type === 'POST' ? params : undefined,
            headers: options.headers,
            credentials: options.withCredentials ? 'include' : 'omit',
            mode: 'cors'
        }).then(function (response) {
            return response;
        });
    },

    _fetchJsonp: function _fetchJsonp(url, options) {
        options = options || {};
        return (0, _fetchJsonp3.default)(url, { method: 'GET', timeout: options.timeout }).then(function (response) {
            return response;
        });
    },

    _timeout: function _timeout(seconds, promise) {
        return new Promise(function (resolve, reject) {
            setTimeout(function () {
                reject(new Error("timeout"));
            }, seconds);
            promise.then(resolve, reject);
        });
    },

    _getParameterString: function _getParameterString(params) {
        var paramsArray = [];
        for (var key in params) {
            var value = params[key];
            if (value != null && typeof value !== 'function') {
                var encodedValue;
                if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                    var encodedItemArray = [];
                    var item;
                    for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                        item = value[itemIndex];
                        encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                    }
                    encodedValue = '[' + encodedItemArray.join(",") + ']';
                } else {
                    encodedValue = encodeURIComponent(value);
                }
                paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
            }
        }
        return paramsArray.join("&");
    },

    _isMVTRequest: function _isMVTRequest(url) {
        return url.indexOf('.mvt') > -1 || url.indexOf('.pbf') > -1;
    }
};

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ArrayExt = exports.FunctionExt = exports.NumberExt = exports.StringExt = undefined;

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 *@namespace SuperMap
 */

/**
 * @description In addition to the mandatory C and P parameters, an arbitrary number of
 * objects can be passed, which will extend C.
 * @memberOf SuperMap
 * @param C - {Object} the class that inherits
 * @param P - {Object} the superclass to inherit from
 */
_SuperMap2.default.inherit = function (C, P) {
    var F = function F() {};
    F.prototype = P.prototype;
    C.prototype = new F();
    var i, l, o;
    for (i = 2, l = arguments.length; i < l; i++) {
        o = arguments[i];
        if (typeof o === "function") {
            o = o.prototype;
        }
        _SuperMap2.default.Util.extend(C.prototype, o);
    }
};

/**
 * @description 实现多重继承
 * @memberOf SuperMap
 * @param ...mixins {Class|Object}继承的类
 */
_SuperMap2.default.mixin = function () {
    for (var _len = arguments.length, mixins = Array(_len), _key = 0; _key < _len; _key++) {
        mixins[_key] = arguments[_key];
    }

    var Mix = function Mix(options) {
        _classCallCheck(this, Mix);

        for (var index = 0; index < mixins.length; index++) {
            copyProperties(this, new mixins[index](options));
        }
    };

    for (var index = 0; index < mixins.length; index++) {
        var mixin = mixins[index];
        copyProperties(Mix, mixin);
        copyProperties(Mix.prototype, mixin.prototype);
        copyProperties(Mix.prototype, new mixin());
    }
    return Mix;

    function copyProperties(target, source) {
        var ownKeys = Object.getOwnPropertyNames(source);
        if (Object.getOwnPropertySymbols) {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source));
        }
        for (var index = 0; index < ownKeys.length; index++) {
            var key = ownKeys[index];
            if (key !== "constructor" && key !== "prototype" && key !== "name" && key !== "length") {
                var desc = Object.getOwnPropertyDescriptor(source, key);
                Object.defineProperty(target, key, desc);
            }
        }
    }
};

/**
 * @name String
 * @memberOf SuperMap
 * @namespace
 * @description 字符串操作的一系列常用扩展函数.
 */
var StringExt = exports.StringExt = _SuperMap2.default.String = {

    /**
     * @description 判断目标字符串是否以指定的子字符串开头.
     * @param str - {string} 目标字符串.
     * @param sub - {string} 查找的子字符串.
     * @returns {Boolean} 目标字符串以指定的子字符串开头,则返回true;否则返回false.
     */
    startsWith: function startsWith(str, sub) {
        return str.indexOf(sub) == 0;
    },

    /**
     * @description 判断目标字符串是否包含指定的子字符串.
     * @param str - {string} 目标字符串.
     * @param sub - {string} 查找的子字符串.
     * @returns {Boolean} 目标字符串中包含指定的子字符串,则返回true;否则返回false.
     */
    contains: function contains(str, sub) {
        return str.indexOf(sub) != -1;
    },

    /**
     * @description 删除一个字符串的开头和结尾处的所有空白字符.
     * @param str - {string} (可能)存在空白字符填塞的字符串.
     * @returns {string} 删除开头和结尾处空白字符后的字符串.
     */
    trim: function trim(str) {
        return str.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
    },

    /**
     * @description 骆驼式("-")连字符的字符串处理.
     * 例如: "chicken-head" becomes "chickenHead",
     *       "-chicken-head" becomes "ChickenHead".
     * @param str - {string} 要处理的字符串,原始内容不应被修改.
     * @returns {string}
     */
    camelize: function camelize(str) {
        var oStringList = str.split('-');
        var camelizedString = oStringList[0];
        for (var i = 1, len = oStringList.length; i < len; i++) {
            var s = oStringList[i];
            camelizedString += s.charAt(0).toUpperCase() + s.substring(1);
        }
        return camelizedString;
    },

    /**
     * @description 提供带 ${token} 标记的字符串, 返回context对象属性中指定标记的属性值.
     * @example
     * 示例:
     * (code)
     * 1、template = "${value,getValue}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:36
     * (end)
     * 示例:
     * (code)
     * 2、template = "$${{value,getValue}}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:"${36}"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = {a: {b:"format"}};
     *         args = null;
     *       返回值:"format"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = null;
     *         args = null;
     *       返回值:"${a.b}"
     * (end)
     * @param template - {string} 带标记的字符串将要被替换.参数 template 格式为"${token}",此处的 token 标记会替换为 context["token"] 属性的值
     * @param context - {Object} 带有属性的可选对象的属性用于匹配格式化字符串中的标记.如果该参数为空,将使用 window 对象.
     * @param args - {Array} 可选参数传递给在context对象上找到的函数.
     * @returns {string} 从 context 对象属性中替换字符串标记位的字符串.
     */
    format: function format(template, context, args) {
        if (!context) {
            context = window;
        }

        // Example matching:
        // str   = ${foo.bar}
        // match = foo.bar
        var replacer = function replacer(str, match) {
            var replacement;

            // Loop through all subs. Example: ${a.b.c}
            // 0 -> replacement = context[a];
            // 1 -> replacement = context[a][b];
            // 2 -> replacement = context[a][b][c];
            var subs = match.split(/\.+/);
            for (var i = 0; i < subs.length; i++) {
                if (i == 0) {
                    replacement = context;
                }

                replacement = replacement[subs[i]];
            }

            if (typeof replacement === "function") {
                replacement = args ? replacement.apply(null, args) : replacement();
            }

            // If replacement is undefined, return the string 'undefined'.
            // This is a workaround for a bugs in browsers not properly
            // dealing with non-participating groups in regular expressions:
            // http://blog.stevenlevithan.com/archives/npcg-javascript
            if (typeof replacement == 'undefined') {
                return 'undefined';
            } else {
                return replacement;
            }
        };

        return template.replace(_SuperMap2.default.String.tokenRegEx, replacer);
    },

    /**
     * @description Used to find tokens in a string.
     * @default  /\$\{([\w.]+?)\}/g
     * @example
     * Examples: ${a}, ${a.b.c}, ${a-b}, ${5}
     */
    tokenRegEx: /\$\{([\w.]+?)\}/g,

    /**
     * @description Used to test strings as numbers.
     * @default  /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/
     */
    numberRegEx: /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,

    /**
     * @description 判断一个字符串是否只包含一个数值.
     * @example
     * (code)
     * SuperMap.String.isNumeric("6.02e23") // true
     * SuperMap.String.isNumeric("12 dozen") // false
     * SuperMap.String.isNumeric("4") // true
     * SuperMap.String.isNumeric(" 4 ") // false
     * (end)
     * @returns {Boolean} 字符串包含唯一的数值,返回true;否则返回false.
     */
    isNumeric: function isNumeric(value) {
        return _SuperMap2.default.String.numberRegEx.test(value);
    },

    /**
     * @description 把一个看似数值型的字符串转化为一个数值.
     *
     * @returns {number|string} 如果能转换为数值则返回数值,否则返回字符串本身.
     */
    numericIf: function numericIf(value) {
        return _SuperMap2.default.String.isNumeric(value) ? parseFloat(value) : value;
    }

};

/**
 * @name Number
 * @memberOf SuperMap
 * @namespace
 * @description 数值操作的一系列常用扩展函数.
 */
var NumberExt = exports.NumberExt = _SuperMap2.default.Number = {

    /**
     *  @description 格式化数字时默认的小数点分隔符.
     *  @constant
     *  @default "."
     */
    decimalSeparator: ".",

    /**
     *  @description 格式化数字时默认的千位分隔符.
     *  @constant
     *  @default ","
     */
    thousandsSeparator: ",",

    /**
     * @description 限制浮点数的有效数字位数.
     * @param num - {number}
     * @param sig - {integer}
     * @returns {number} 将数字四舍五入到指定数量的有效位数.
     */
    limitSigDigs: function limitSigDigs(num, sig) {
        var fig = 0;
        if (sig > 0) {
            fig = parseFloat(num.toPrecision(sig));
        }
        return fig;
    },

    /**
     * @description 数字格式化输出.
     * @param num  - {number}
     * @param dec  - {integer} 数字的小数部分四舍五入到指定的位数.默认为 0. 设置为null值时小数部分不变.
     * @param tsep - {string} 千位分隔符. 默认为",".
     * @param dsep - {string} 小数点分隔符. 默认为".".
     * @returns {string} 数字格式化后的字符串.
     */
    format: function format(num, dec, tsep, dsep) {
        dec = typeof dec != "undefined" ? dec : 0;
        tsep = typeof tsep != "undefined" ? tsep : _SuperMap2.default.Number.thousandsSeparator;
        dsep = typeof dsep != "undefined" ? dsep : _SuperMap2.default.Number.decimalSeparator;

        if (dec != null) {
            num = parseFloat(num.toFixed(dec));
        }

        var parts = num.toString().split(".");
        if (parts.length === 1 && dec == null) {
            // integer where we do not want to touch the decimals
            dec = 0;
        }

        var integer = parts[0];
        if (tsep) {
            var thousands = /(-?[0-9]+)([0-9]{3})/;
            while (thousands.test(integer)) {
                integer = integer.replace(thousands, "$1" + tsep + "$2");
            }
        }

        var str;
        if (dec == 0) {
            str = integer;
        } else {
            var rem = parts.length > 1 ? parts[1] : "0";
            if (dec != null) {
                rem = rem + new Array(dec - rem.length + 1).join("0");
            }
            str = integer + dsep + rem;
        }
        return str;
    }
};

if (!Number.prototype.limitSigDigs) {
    /**
     * APIMethod: Number.limitSigDigs
     * 限制浮点数的有效数字位数.
     * @param sig - {integer}
     * @returns {integer} 将数字四舍五入到指定数量的有效位数.
     *           如果传入值为 null、0、或者是负数, 返回值 0
     */
    Number.prototype.limitSigDigs = function (sig) {
        return NumberExt.limitSigDigs(this, sig);
    };
}

/**
 * @name Function
 * @memberOf SuperMap
 * @namespace
 * @description 函数操作的一系列常用扩展函数.
 */
var FunctionExt = exports.FunctionExt = _SuperMap2.default.Function = {
    /**
     * @description 绑定函数到对象.方便创建this的作用域.
     * @param func - {function} 输入函数.
     * @param object - {Object} 对象绑定到输入函数(作为输入函数的this对象).
     * @returns {function} object参数作为func函数的this对象.
     */
    bind: function bind(func, object) {
        // create a reference to all arguments past the second one
        var args = Array.prototype.slice.apply(arguments, [2]);
        return function () {
            // Push on any additional arguments from the actual function call.
            // These will come after those sent to the bind call.
            var newArgs = args.concat(Array.prototype.slice.apply(arguments, [0]));
            return func.apply(object, newArgs);
        };
    },

    /**
     * @description 绑定函数到对象,在调用该函数时配置并使用事件对象作为第一个参数.
     * @param func - {function} 用于监听事件的函数.
     * @param object - {Object} this 对象的引用.
     * @returns {function}
     */
    bindAsEventListener: function bindAsEventListener(func, object) {
        return function (event) {
            return func.call(object, event || window.event);
        };
    },

    /**
     * @description 该函数仅仅返回false.该函数主要是避免在IE8以下浏览中DOM事件句柄的匿名函数问题.
     * @example
     * document.onclick = SuperMap.Function.False;
     * @returns {Boolean}
     */
    False: function False() {
        return false;
    },

    /**
     * @description 该函数仅仅返回true.该函数主要是避免在IE8以下浏览中DOM事件句柄的匿名函数问题.
     * @example
     * document.onclick = SuperMap.Function.True;
     * @returns {Boolean}
     */
    True: function True() {
        return true;
    },

    /**
     * @description 可重用函数,仅仅返回"undefined".
     * @returns {undefined}
     */
    Void: function Void() {}

};

/**
 * @name Array
 * @memberOf SuperMap
 * @namespace
 * @description 数组操作的一系列常用扩展函数.
 */
var ArrayExt = exports.ArrayExt = _SuperMap2.default.Array = {

    /**
     * @description 过滤数组.提供了ECMA-262标准中Array.prototype.filter函数的扩展.
     * @see {@link http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/filter}
     * @param array - {Array} 要过滤的数组..
     * @param callback - {function} 数组中的每一个元素调用该函数.<br>
     *     如果函数的返回值为true,该元素将包含在返回的数组中.该函数有三个参数: 数组中的元素,元素的索引,数组自身.<br>
     *     如果设置了可选参数caller,在调用callback时,使用可选参数caller设置为callback的参数.<br>
     * @param caller - {Object} 在调用callback时,使用可选参数caller设置为callback的参数.
     * @returns {Array} callback函数返回true时的元素将作为返回数组中的元素.
     */
    filter: function filter(array, callback, caller) {
        var selected = [];
        if (Array.prototype.filter) {
            selected = array.filter(callback, caller);
        } else {
            var len = array.length;
            if (typeof callback != "function") {
                throw new TypeError();
            }
            for (var i = 0; i < len; i++) {
                if (i in array) {
                    var val = array[i];
                    if (callback.call(caller, val, i, array)) {
                        selected.push(val);
                    }
                }
            }
        }
        return selected;
    }

};

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(13);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiPoint
 * @classdesc 几何对象多点类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.Point>} 点对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(5,6);
 * var poine2 = new SuperMap.Geometry.Point(7,8);
 * var multiPoint = new SuperMap.Geometry.MultiPoint([point1,point2]);
 */
var MultiPoint = function (_Collection) {
    _inherits(MultiPoint, _Collection);

    function MultiPoint(components) {
        _classCallCheck(this, MultiPoint);

        var _this = _possibleConstructorReturn(this, (MultiPoint.__proto__ || Object.getPrototypeOf(MultiPoint)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiPoint";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.MultiPoint.prototype.addPoint
     * @description 添加点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.addComponent}方法。
     * @param point - {SuperMap.Geometry.Point} 添加的点。
     * @param index - {integer} 可选的下标。
     */


    /**
     * @member SuperMap.Geometry.MultiPoint.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Point}"]
     */


    _createClass(MultiPoint, [{
        key: 'addPoint',
        value: function addPoint(point, index) {
            this.addComponent(point, index);
        }

        /**
         * @function SuperMap.Geometry.MultiPoint.prototype.removePoint
         * @description 移除点,封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.removeComponent} 方法。
         * @param point - {SuperMap.Geometry.Point} 移除的点对象。
         */

    }, {
        key: 'removePoint',
        value: function removePoint(point) {
            this.removeComponent(point);
        }
    }]);

    return MultiPoint;
}(_Collection3.default);

exports.default = MultiPoint;

_SuperMap2.default.Geometry.MultiPoint = MultiPoint;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(13);

var _Collection3 = _interopRequireDefault(_Collection2);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _LineString = __webpack_require__(18);

var _LineString2 = _interopRequireDefault(_LineString);

var _LinearRing = __webpack_require__(25);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Polygon
 * @classdesc  多边形几何对象类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.LinearRing>} 用来生成多边形的线环数组。
 * @example
 * var points =[new SuperMap.Geometry.Point(0,4010338),
 *      new SuperMap.Geometry.Point(1063524,4010338),
 *      new SuperMap.Geometry.Point(1063524,3150322),
 *      new SuperMap.Geometry.Point(0,3150322)
 *  ],
 *  var linearRings = new SuperMap.Geometry.LinearRing(points),
 *  var  region = new SuperMap.Geometry.Polygon([linearRings]);
 */
var Polygon = function (_Collection) {
    _inherits(Polygon, _Collection);

    function Polygon(components) {
        _classCallCheck(this, Polygon);

        var _this = _possibleConstructorReturn(this, (Polygon.__proto__ || Object.getPrototypeOf(Polygon)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.LinearRing"];
        _this.CLASS_NAME = "SuperMap.Geometry.Polygon";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Polygon.prototype.getArea
     * @description 获得区域面积，从区域的外部口径减去计此区域内部口径算所得的面积。
     * @returns {float} 几何对象的面积。
     */


    /**
     * @member SuperMap.Geometry.Polygon.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.LinearRing}"]
     */


    _createClass(Polygon, [{
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 0) {
                area += Math.abs(this.components[0].getArea());
                for (var i = 1, len = this.components.length; i < len; i++) {
                    area -= Math.abs(this.components[i].getArea());
                }
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.getGeodesicArea
         * @description 计算投影到球面上的多边形近似面积。
         * @param projection - {SuperMap.Projection} 空间参考系统的几何坐标。如果没有设置，默认 WGS84。
         * @returns {float} 多边形近似测地面积。
         */

    }, {
        key: 'getGeodesicArea',
        value: function getGeodesicArea(projection) {
            var area = 0.0;
            if (this.components && this.components.length > 0) {
                area += Math.abs(this.components[0].getGeodesicArea(projection));
                for (var i = 1, len = this.components.length; i < len; i++) {
                    area -= Math.abs(this.components[i].getGeodesicArea(projection));
                }
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.containsPoint
         * @description 判断点是否在多边形里。
         * @param point - {SuperMap.Geometry.Point} 点对象。
         * @returns {boolean | number} 是否在多边形里。
         */

    }, {
        key: 'containsPoint',
        value: function containsPoint(point) {
            var numRings = this.components.length;
            var contained = false;
            if (numRings > 0) {
                // check exterior ring - 1 means on edge, boolean otherwise
                contained = this.components[0].containsPoint(point);
                if (contained !== 1) {
                    if (contained && numRings > 1) {
                        // check interior rings
                        var hole;
                        for (var i = 1; i < numRings; ++i) {
                            hole = this.components[i].containsPoint(point);
                            if (hole) {
                                if (hole === 1) {
                                    // on edge
                                    contained = 1;
                                } else {
                                    // in hole
                                    contained = false;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            return contained;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.intersects
         * @description 判断两个几何对象是否相交。
         * @param geometry - {SuperMap.Geometry} 任何类型的几何对象。
         * @returns {boolean} 两个几何对象是否相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            var i, len;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.containsPoint(geometry);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LineString" || geometry.CLASS_NAME === "SuperMap.Geometry.LinearRing") {
                // check if rings/linestrings intersect
                for (i = 0, len = this.components.length; i < len; ++i) {
                    intersect = geometry.intersects(this.components[i]);
                    if (intersect) {
                        break;
                    }
                }
                if (!intersect) {
                    // check if this poly contains points of the ring/linestring
                    for (i = 0, len = geometry.components.length; i < len; ++i) {
                        intersect = this.containsPoint(geometry.components[i]);
                        if (intersect) {
                            break;
                        }
                    }
                }
            } else {
                for (i = 0, len = geometry.components.length; i < len; ++i) {
                    intersect = this.intersects(geometry.components[i]);
                    if (intersect) {
                        break;
                    }
                }
            }
            // check case where this poly is wholly contained by another
            if (!intersect && geometry.CLASS_NAME === "SuperMap.Geometry.Polygon") {
                // exterior ring points will be contained in the other geometry
                var ring = this.components[0];
                for (i = 0, len = ring.components.length; i < len; ++i) {
                    intersect = geometry.containsPoint(ring.components[i]);
                    if (intersect) {
                        break;
                    }
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.distanceTo
         * @description 计算两个几何对象间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标几何对象。
         * @param options - {Object}可选参数。<br>
         *         details - {boolean} 返回距离计算的细节。默认为false。<br>
         *         edge - {boolean} 计算一个几何对象到目标几何对象边缘的最近距离。默认为true。 如果设为true，
         *                          一个几何图形完全包含在目标几何对象中时，调用distanceTo返回非零结果，如果false，
         *                          两个几何对象相交情况下调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何对象到目标几何对象的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var result;
            // this is the case where we might not be looking for distance to edge
            if (!edge && this.intersects(geometry)) {
                result = 0;
            } else {
                result = _get(Polygon.prototype.__proto__ || Object.getPrototypeOf(Polygon.prototype), 'distanceTo', this).call(this, geometry, options);
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygon
         * @description 创建 RegularPolygon 对象。
         * @param origin - {SuperMap.Geometry.Point} 多边形的中心 。
         * @param radius - {float} 半径。
         * @param sides - {integer} 边数，20个近似一个圆。
         * @param rotation - {float} 旋转角度，单位为degrees。
         * @example
         * var sides = 50;
         * var origin = new SuperMap.Geometry.Point(5,0);
         * var polygon = SuperMap.Geometry.Polygon.createRegularPolygon(origin,6,sides,270);
         */

    }], [{
        key: 'createRegularPolygon',
        value: function createRegularPolygon(origin, radius, sides, rotation) {
            var angle = Math.PI * (1 / sides - 1 / 2);
            if (rotation) {
                angle += rotation / 180 * Math.PI;
            }
            var rotatedAngle, x, y;
            var points = [];
            for (var i = 0; i < sides; ++i) {
                rotatedAngle = angle + i * 2 * Math.PI / sides;
                x = origin.x + radius * Math.cos(rotatedAngle);
                y = origin.y + radius * Math.sin(rotatedAngle);
                points.push(new _Point2.default(x, y));
            }
            var ring = new _LinearRing2.default(points);
            return new Polygon([ring]);
        }
    }, {
        key: 'createRegularPolygonCurve',


        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygonCurve
         * @description 创建扇形对象。
         * @param origin - {SuperMap.Geometry.Point} 多边形的中心 。
         * @param radius - {float} 半径。
         * @param sides - {integer} 边数，50个近似一个扇形。
         * @param r - {integer}
         * @param angel - {float} 旋转角度，单位为degrees。沿着x轴正方向的逆时针方向。
         * @param resolution - {float} 当前地图的分辨率.,固定大小下输入，其他情况不需要此参数
         * 备注：Geometry内部单位均为地理单位，默认用户输入的参数也为地理单位，如果传入resolution，则半径则为
         * 为像素单位，内部会根据像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @returns {SuperMap.Geometry.Polygon} 几何面对象。
         * @example
         * var sides = 50;
         * var origin = new SuperMap.Geometry.Point(5,0);
         * var polygon = SuperMap.Geometry.Polygon.createRegularPolygonCurve(origin,6,sides,270);
         */
        value: function createRegularPolygonCurve(origin, radius, sides, r, angel, resolution) {
            if (resolution == undefined) resolution = 1;

            var rR = r * Math.PI / (180 * sides);

            var rotatedAngle, x, y;
            var points = [];
            for (var i = 0; i < sides; ++i) {
                rotatedAngle = rR * i;
                x = origin.x + radius * resolution * Math.cos(rotatedAngle);
                y = origin.y + radius * resolution * Math.sin(rotatedAngle);
                points.push(new _Point2.default(x, y));
            }
            rotatedAngle = r * Math.PI / 180;
            x = origin.x + radius * resolution * Math.cos(rotatedAngle);
            y = origin.y + radius * resolution * Math.sin(rotatedAngle);
            points.push(new _Point2.default(x, y));

            points.push(origin);

            var ring = new _LinearRing2.default(points);
            ring.rotate(parseFloat(angel), origin);
            var geo = new Polygon([ring]);
            geo.origin = origin;
            geo.radius = radius;
            geo.r = r;
            geo.angel = angel;
            geo.sides = sides;
            geo.polygonType = "Curve";
            return geo;
        }
    }, {
        key: 'createRegularPolygonTriangle',


        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygonTriangle
         * @description 创建4G三角形,电信行业4G专业符号形容类似为：-▷。
         * @param origin - {SuperMap.Geometry.Point} 三角形的原点 。
         * @param height - {float} 外接矩形的高度。
         * @param width - {float} 外接矩形的宽度。
         * @param lineLength - {float} 线长度。
         * @param angel - {float} 旋转角度，单位为degrees,沿着x轴正方向的逆时针方向.。
         * @param resolution - {float} 当前地图的分辨率.,固定大小下输入，其他情况不需要此参数。备注：Geometry内部单位均为地理单位，
         *                              默认用户输入的参数也为地理单位，如果传入resolution，则height、width、lineLength则为像素单
         *                              位，内部会根据像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @returns {SuperMap.Geometry.Collection} 几何对象集合，面对象&线对象。
         */
        value: function createRegularPolygonTriangle(origin, height, width, lineLength, angel, resolution) {
            if (resolution == undefined) resolution = 1;

            var lineList = [];
            lineList.push(origin);
            lineList.push(new _Point2.default(origin.x + lineLength * resolution, origin.y));
            var geoline = new _LineString2.default(lineList);
            geoline.rotate(parseFloat(angel), origin);

            var triangleList = [];
            triangleList.push(new _Point2.default(origin.x + height * resolution, origin.y));
            triangleList.push(new _Point2.default(origin.x + lineLength * resolution, origin.y + width * resolution / 2));
            triangleList.push(new _Point2.default(origin.x + lineLength * resolution, origin.y - width * resolution / 2));
            var geoTriangle = new _LinearRing2.default(triangleList);
            geoTriangle.rotate(parseFloat(angel), origin);
            var geo = new _Collection3.default([geoline, geoTriangle]);
            geo.origin = origin;
            geo.height = height;
            geo.width = width;
            geo.lineLength = lineLength;
            geo.angel = angel;
            geo.polygonType = "Triangle";
            return geo;
        }
    }, {
        key: 'createBsplinesurface',


        /**
         * @function SuperMap.Geometry.Polygon.createBsplinesurface
         * @description 创建3G B样条曲面，电信3G专业符号，由B样条曲线模拟生成。
         * @param origin - {SuperMap.Geometry.Point} 曲面的原点 。
         * @param height - {float} 外接矩形的高度。
         * @param width - {float} 外接矩形的宽度。
         * @param angel - {float} 旋转角度，单位为degrees，沿着x轴正方向的逆时针方向。
         * @param resolution - {float} 当前地图的分辨率，固定大小下输入，其他情况不需要此参数。备注：Geometry内部单位均为地理单位，
         *                              默认用户输入的参数也为地理单位，如果传入resolution，则height、width为像素单位，内部会根据
         *                              像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @param k - {number} 递推次数，可以控制曲线的光滑度。
         * @returns {SuperMap.Geometry.Polygon} 几何面对象。
         */
        value: function createBsplinesurface(origin, height, width, angel, resolution, k) {
            if (resolution == undefined) resolution = 1;

            if (k == undefined) k = 10;

            var pointList = [];
            pointList.push(origin);
            pointList.push(origin);

            pointList.push(new _Point2.default(origin.x + height * resolution * 2 / 3, origin.y + width * resolution / 2));
            pointList.push(new _Point2.default(origin.x + height * resolution, origin.y + width * resolution / 2));
            pointList.push(new _Point2.default(origin.x + height * resolution, origin.y - width * resolution / 2));
            pointList.push(new _Point2.default(origin.x + height * resolution * 2 / 3, origin.y - width * resolution / 2));

            pointList.push(origin);
            pointList.push(origin);

            var pointList2 = [];
            var i, j, a0, a1, a2, dt, t1, t2;
            var t_x, t_y;
            var n = pointList.length;
            dt = 1.0 / k;

            pointList2.push(new _Point2.default((pointList[0].x + pointList[1].x) / 2, (pointList[0].y + pointList[1].y) / 2));

            for (i = 1; i < n - 1; i++) {
                for (j = 0; j <= k; j++) {
                    t1 = j * dt;
                    t2 = t1 * t1;

                    a0 = (t2 - 2 * t1 + 1) / 2.0;
                    a1 = (2 * t1 - 2 * t2 + 1) / 2.0;
                    a2 = t2 / 2.0;

                    t_x = a0 * pointList[i - 1].x + a1 * pointList[i].x + a2 * pointList[i + 1].x;
                    t_y = a0 * pointList[i - 1].y + a1 * pointList[i].y + a2 * pointList[i + 1].y;
                    pointList2.push(new _Point2.default(t_x, t_y));
                }
            }

            var ring = new _LinearRing2.default(pointList2);
            ring.rotate(parseFloat(angel), origin);
            var geo = new _Collection3.default([ring]);
            geo.origin = origin;
            geo.height = height;
            geo.width = width;
            geo.angel = angel;
            geo.polygonType = "Bspline";
            return geo;
        }
    }]);

    return Polygon;
}(_Collection3.default);

exports.default = Polygon;


_SuperMap2.default.Geometry.Polygon = Polygon;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.JoinItem
 * @classdesc 连接信息类。
 * 该类用于矢量数据集与外部表的连接。外部表可以为另一个矢量数据集（其中纯属性数据集中没有空间几何信息）所对应的 DBMS 表，也可以是用户自建的业务表。需要注意的是，矢量数据集与外部表必须属于同一数据源。表之间的联系的建立有两种方式，一种是连接（join），一种是关联（link）。连接，实际上是依据相同的字段将一个外部表追加到指定的表；而关联是基于一个相同的字段定义了两个表格之间的联系，但不是实际的追加。用于连接两个表的字段的名称不一定相同，但类型必须一致。当两个表格之间建立了连接，通过对主表进行操作，可以对外部表进行查询，制作专题图以及分析等。当两个表格之间是一对一或多对一的关系时，可以使用 join 连接。当为多对一的关系时，允许指定多个字段之间的关联。(注意：SuperMap.JoinItem 目前支持左连接和内连接，不支持全连接和右连接，UDB 引擎不支持内连接。并且用于建立连接的两个表必须在同一个数据源下。)
 * @param options - {Object} 可選参数。如:</br>
 *        foreignTableName - {string} 外部表的名称。</br>
 *        joinFilter - {string} 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。</br>
 *        joinType - {SuperMap.JoinType} 两个表之间连接类型。</br>
 * @example 下面以SQL查询说明joinItem的使用方法：
 *(start code)
 *   function queryBySQL() {
     *       // 设置与外部表的连接信息
     *       var joinItem = new SuperMap.JoinItem({
     *           foreignTableName: "foreignTable",
     *           joinFilter: "foreignTable.CONTINENT = Countries.CONTINENT",
     *           joinType: "LEFTJOIN"
     *       })
     *       var queryParam, queryBySQLParams, queryBySQLService;
     *       // 设置查询参数，在查询参数中添加joinItem关联条件信息
     *       queryParam = new SuperMap.FilterParameter({
     *            name: "Countries@World",
     *            joinItems: [joinItem]
     *         }),
     *       queryBySQLParams = new SuperMap.QueryBySQLParameters({
     *             queryParams: [queryParam]
     *         }),
     *       queryBySQLService = new SuperMap.QueryBySQLService(url, {
     *             eventListeners: { "processCompleted": processCompleted, "processFailed": processFailed}
     *         });
     *       queryBySQLService.processAsync(queryBySQLParams);
     *  }
 *  function processCompleted(queryEventArgs) {//todo}
 *  function processFailed(e) {//todo}
 * (end)
 */
var JoinItem = function () {

    /**
     * @member SuperMap.JoinItem.prototype.joinFilter -{string}
     * @description 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。
     * 例如，将房屋面数据集（Building）的 district 字段与房屋拥有者的纯属性数据集（Owner）的 region 字段相连接，
     * 两个数据集对应的表名称分别为 Table_Building 和 Table_Owner，
     * 则连接表达式为 Table_Building.district = Table_Owner.region。
     * 当有多个字段相连接时，用 AND 将多个表达式相连。
     */
    function JoinItem(options) {
        _classCallCheck(this, JoinItem);

        this.foreignTableName = null;
        this.joinFilter = null;
        this.joinType = null;
        this.CLASS_NAME = "SuperMap.JoinItem";

        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.JoinItem.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.JoinItem.prototype.joinType -{JoinType}
     * @description 两个表之间连接类型。
     * 连接类型决定了对两个表进行连接查询后返回的记录的情况。
     */

    /**
     * @member SuperMap.JoinItem.prototype.foreignTableName -{string}
     * @description 外部表的名称。
     * 如果外部表的名称是以“表名@数据源名”命名方式，则该属性只需赋值表名。
     * 例如：外部表 Name@changchun，Name 为表名，changchun 为数据源名称，则该属性的赋值应为：Name。
     */


    _createClass(JoinItem, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.foreignTableName = null;
            me.joinFilter = null;
            me.joinType = null;
        }

        /**
         * @function SuperMap.JoinItem.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         */

    }, {
        key: "toServerJSONObject",
        value: function toServerJSONObject() {
            var dataObj = {};
            dataObj = _SuperMap2.default.Util.copyAttributes(dataObj, this);
            //joinFilter基本是个纯属性对象，这里不再做转换
            return dataObj;
        }
    }]);

    return JoinItem;
}();

exports.default = JoinItem;

_SuperMap2.default.JoinItem = JoinItem;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.LabelMatrixCell
 * @classdesc 矩阵标签元素抽象类。
 * @description 该类可以包含 n*n 个矩阵标签元素，矩阵标签元素的类型可以是图片，符号，标签专题图等。
 *              符号类型的矩阵标签元素类、图片类型的矩阵标签元素类和专题图类型的矩阵标签元素类均继承自该类。
 */
var LabelMatrixCell = function LabelMatrixCell() {
  _classCallCheck(this, LabelMatrixCell);

  this.CLASS_NAME = "LabelMatrixCell";
};

exports.default = LabelMatrixCell;


_SuperMap2.default.LabelMatrixCell = LabelMatrixCell;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _PointWithMeasure = __webpack_require__(203);

var _PointWithMeasure2 = _interopRequireDefault(_PointWithMeasure);

var _Collection2 = __webpack_require__(13);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Route
 * @classdesc
 * 路由对象类。路由对象为一系列有序的带有属性值 M 的 x，y 坐标对，其中 M 值为该结点的距离属性（到已知点的距离）。
 * @param points - {{Array<SuperMap.Geometry>}} 形成路由对象的线数组。
 * @param  options - {Object} 可选参数。如:</br>
 *         id - {number}路由对象在数据库中的id。</br>
 *         length - {number}路由对象的长度。</br>
 *         maxM - {number}最大线性度量值，即所有结点到起始点的量算距离中最大值。</br>
 *         minM - {number}最小线性度量值，即所有结点到起始点的量算距离中最小值。</br>
 *         type - {string} 数据类型，如："LINEM"</br>
 * @extends SuperMap.Geometry.Collection
 */
var Route = function (_Collection) {
    _inherits(Route, _Collection);

    /**
     * @member SuperMap.Route.prototype.type -{string}
     * @description 服务端几何对象类型。
     */


    /**
     * @member SuperMap.Route.prototype.parts -{Array<number>}
     * @description 服务端几何对象中各个子对象所包含的节点个数。
     */


    /**
     *  @member SuperMap.Route.prototype.maxM -{number}
     *  @description 最大线性度量值，即所有结点到起始点的量算距离中最大值。
     */


    /**
     * @member SuperMap.Route.prototype.style -{string}
     * @description 路由对象的样式
     */


    /**
     * @member SuperMap.Route.prototype.id -{number}
     * @description 路由对象在数据库中的id。
     */
    function Route(points, options) {
        _classCallCheck(this, Route);

        var _this = _possibleConstructorReturn(this, (Route.__proto__ || Object.getPrototypeOf(Route)).call(this, points, options));

        _this.id = null;
        _this.center = null;
        _this.style = null;
        _this.length = null;
        _this.maxM = null;
        _this.minM = null;
        _this.parts = null;
        _this.points = null;
        _this.type = null;
        _this.componentTypes = ["SuperMap.Geometry.LinearRing", "SuperMap.Geometry.LineString"];
        _this.CLASS_NAME = "SuperMap.Route";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     *
     * @function SuperMap.Route.prototype.toJson
     * @description 转换为json对象。
     * @return{Object} json对象
     */


    /**
     * @member SuperMap.Route.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @default ["{@link SuperMap.Geometry.LinearRing}", "{@link SuperMap.Geometry.LineString}"];
     */


    /**
     * @member SuperMap.Route.prototype.points -{Array<Object>}
     * @description 路由对象的所有路由点。
     * @example
     * (start code)
     * [
     *  {
     *      "measure": 0,
     *      "y": -4377.027184298267,
     *      "x": 4020.0045221720466
     *  },
     *  {
     *      "measure": 37.33288381391519,
     *      "y": -4381.569363260499,
     *      "x": 4057.0600591960642
     *  }
     * ]
     * (end)
     */


    /**
     * @member SuperMap.Route.prototype.minM -{number}
     * @description 最小线性度量值，即所有结点到起始点的量算距离中最小值。
     */


    /**
     * @member SuperMap.Route.prototype.length -{number}
     * @description 路由对象的长度。单位与数据集的单位相同。
     */


    /**
     * @member SuperMap.Route.prototype.center -{number}
     * @description 路由对象的中心点
     */


    _createClass(Route, [{
        key: 'toJson',
        value: function toJson() {
            var result = "{";
            if (this.id != null && this.id != undefined) {
                result += "\"id\":" + this.id + ",";
            }
            if (this.center != null && this.center != undefined) {
                result += "\"center\":" + this.center + ",";
            }
            if (this.style != null && this.style != undefined) {
                result += "\"style\":" + this.style + ",";
            }
            if (this.length != null && this.length != undefined) {
                result += "\"length\":" + this.length + ",";
            }
            if (this.maxM != null && this.maxM != undefined) {
                result += "\"maxM\":" + this.maxM + ",";
            }
            if (this.minM != null && this.minM != undefined) {
                result += "\"minM\":" + this.minM + ",";
            }
            if (this.type != null && this.type != undefined) {
                result += "\"type\":\"" + this.type + "\",";
            }
            if (this.parts != null && this.parts != undefined) {
                result += "\"parts\":[" + this.parts[0];

                for (var i = 1; i < this.parts.length; i++) {
                    result += "," + this.parts[i];
                }
                result += "],";
            }
            if (this.components != null && this.components.length > 0) {
                result += "\"points\":[";
                for (var j = 0, len = this.components.length; j < len; j++) {
                    for (var k = 0, len2 = this.components[j].components.length; k < len2; k++) {
                        result += this.components[j].components[k].toJson() + ",";
                    }
                }
                result = result.replace(/,$/g, '');
                result += "]";
            }
            result = result.replace(/,$/g, '');
            result += "}";
            return result;
        }

        /**
         * @function SuperMap.Route.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.id = null;
            me.center = null;
            me.style = null;
            me.length = null;
            me.maxM = null;
            me.minM = null;
            me.type = null;
            me.parts = null;
            me.components.length = 0;
            me.components = null;
            me.componentTypes = null;
        }

        /**
         * @function SuperMap.Route.fromJson
         * @description  将 JSON 对象转换为 SuperMap.Route 对象。
         * @param jsonObject - {Object} JSON 对象表示的路由对象。
         * @return{SuperMap.Route} 转化后的 Route 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }

            var geoParts = jsonObject.parts || [],
                geoPoints = jsonObject.points || [],
                len = geoParts.length,
                lineList = [];
            if (len > 0) {
                for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                    for (var j = 0; j < geoParts[i]; j++) {
                        pointList.push(_PointWithMeasure2.default.fromJson(geoPoints[pointIndex + j]));
                    }
                    pointIndex += geoParts[i];
                    //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                    if (pointList[0].equals(pointList[geoParts[i] - 1])) {
                        lineList.push(new _SuperMap2.default.Geometry.LinearRing(pointList));
                    } else {
                        lineList.push(new _SuperMap2.default.Geometry.LineString(pointList));
                    }
                    pointList = [];
                }
            } else {
                return null;
            }

            return new Route(lineList, {
                id: jsonObject.id,
                center: jsonObject.center,
                style: jsonObject.style,
                length: jsonObject.length,
                maxM: jsonObject.maxM,
                minM: jsonObject.minM,
                type: jsonObject.type,
                parts: jsonObject.parts
            });
        }
    }]);

    return Route;
}(_Collection3.default);

exports.default = Route;


_SuperMap2.default.Route = Route;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServerStyle = __webpack_require__(6);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeFlow
 * @classdesc 标签或符号流动显示和牵引线风格设置类。
 *              通过该类可以设置专题图中符号是否流动显示、是否使用牵引线以及牵引线风格。
 * @param options - {Object} 可选参数。如：<br>
 *        flowEnabled - {boolean} 是否流动显示标签或符号。<br>
 *        leaderLineDisplayed - {boolean} 是否显示标签或符号和它标注的对象之间的牵引线。<br>
 *        leaderLineStyle - {{@link SuperMap.ServerStyle}} 标签或符号与其标注对象之间牵引线的风格。
 */
var ThemeFlow = function () {

    /**
     * @member SuperMap.ThemeFlow.prototype.leaderLineDisplayed -{boolean}
     * @description 是否显示标签或符号和它标注的对象之间的牵引线。默认值为 false，即不显示标签或符号和它标注的对象之间的牵引线。<br>
     *              只有当 flowEnabled 为 true 时，牵引线才起作用。在当标签流动显示时，其位置不固定，由于牵引线始终指向要素的内点，<br>
     *              因而通过牵引线显示功能可以找到流动的标签或符号实际对应的要素。或者渲染符号偏移它所指向的对象时，图与对象之间可以采用牵引线进行连接。
     */
    function ThemeFlow(options) {
        _classCallCheck(this, ThemeFlow);

        this.flowEnabled = false;
        this.leaderLineDisplayed = false;
        this.leaderLineStyle = null;
        this.CLASS_NAME = "SuperMap.ThemeFlow";

        var me = this;
        me.leaderLineStyle = new _ServerStyle2.default();
        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ThemeFlow.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeFlow.prototype.leaderLineStyle -{SuperMap.ServerStyle}
     * @description 标签或符号与其标注对象之间牵引线的风格。
     */


    /**
     * @member SuperMap.ThemeFlow.prototype.flowEnabled -{boolean}
     * @description 是否流动显示标签或符号。<br>
     *              对于标签专题图而言，对于跨越比较大的区域和线条状的几何对象，在一个地图窗口中不能完全显示的情况下，如果其标签位置比较固定，<br>
     *              在当前地图窗口中该对象的标签不可见，则需要通过平移地图来查看对象的标签信息。如果采用了流动显示的效果，在当前地图窗口中，对象即使是部分显示，<br>
     *              其标签也会显示在当前地图窗口中。当平移地图时，对象的标签会随之移动，以保证在当前地图窗口中部分或全部显示的对象其标签都可见，从而可以方便地查看各要素的标签信息。
     */


    _createClass(ThemeFlow, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.flowEnabled = null;
            me.leaderLineDisplayed = null;
            if (me.leaderLineStyle) {
                me.leaderLineStyle.destroy();
                me.leaderLineStyle = null;
            }
        }

        /**
         * @function SuperMap.ThemeFlow.fromObj
         * @description 从传入对象获取标签或符号流动显示和牵引线风格设置类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeFlow} ThemeFlow对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) {
                return;
            }
            var res = new ThemeFlow();
            _SuperMap2.default.Util.copy(res, obj);
            res.leaderLineStyle = _ServerStyle2.default.fromJson(obj.leaderLineStyle);
            return res;
        }
    }]);

    return ThemeFlow;
}();

exports.default = ThemeFlow;


_SuperMap2.default.ThemeFlow = ThemeFlow;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeLabelItem = __webpack_require__(232);

var _ThemeLabelItem2 = _interopRequireDefault(_ThemeLabelItem);

var _ThemeLabelUniqueItem = __webpack_require__(234);

var _ThemeLabelUniqueItem2 = _interopRequireDefault(_ThemeLabelUniqueItem);

var _ThemeFlow = __webpack_require__(35);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(37);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeLabelText = __webpack_require__(233);

var _ThemeLabelText2 = _interopRequireDefault(_ThemeLabelText);

var _ThemeLabelAlongLine = __webpack_require__(230);

var _ThemeLabelAlongLine2 = _interopRequireDefault(_ThemeLabelAlongLine);

var _ThemeLabelBackground = __webpack_require__(231);

var _ThemeLabelBackground2 = _interopRequireDefault(_ThemeLabelBackground);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeLabel
 * @classdesc 标签专题图类。
 * @extends SuperMap.Theme
 * @param  options - {Object} 可选参数。如：<br>
 *         alongLine - {{@link SuperMap.ThemeLabelAlongLine}} 标签沿线标注方向样式类。<br>
 *         background - {{@link SuperMap.ThemeLabelBackground}} 标签专题图中标签的背景风格类。<br>
 *         flow - {{@link SuperMap.ThemeFlow}} 标签专题图标签流动显示与牵引线设置类。<br>
 *         items - {Array<{@link SuperMap.ThemeUniqueItem}>} 分段标签专题图的子项数组。<br>
 *         labelExpression - {string} 标注字段表达式。<br>
 *         labelOverLengthMode - {{@link SuperMap.LabelOverLengthMode}} 标签专题图中超长标签的处理模式枚举类。<br>
 *         matrixCells - {Array<{@link SuperMap.LabelMatrixCell}>} 矩阵标签元素数组。<br>
 *         maxLabelLength - {number}标签在每一行显示的最大长度。<br>
 *         numericPrecision - {number}通过该字段设置其显示的精度。<br>
 *         offset - {{@link SuperMap.ThemeOffset}} 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。<br>
 *         overlapAvoided - {boolean} 是否允许以文本避让方式显示文本。<br>
 *         rangeExpression - {string} 制作分段标签专题的分段字段或字段表达式。<br>
 *         smallGeometryLabeled - {boolean} 是否显示长度大于被标注对象本身长度的标签。<br>
 *         text - {{@link SuperMap.ThemeLabelText}} 标签中文本风格。<br>
 *         textSpace - {number} 沿线标注，相邻两个文字之间的间距，单位当前设置的字高。<br>
 *         memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeLabel = function (_Theme) {
    _inherits(ThemeLabel, _Theme);

    /**
     * @member SuperMap.ThemeLabel.prototype.text -{SuperMap.ThemeLabelText}
     * @description 标签中文本风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.uniqueExpression -{string}
     * @description 用于制作单值专题图的字段或字段表达式。
     *              该字段值的数据类型可以为数值型或字符型。如果设置字段表达式，只能是相同数据类型字段间的运算。必设字段,必须与labelExpression一起使用
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.overlapAvoided -{boolean}
     * @description 是否允许以文本避让方式显示文本。默认值为 true， 即自动避免文本叠盖。只针对该标签专题图层中的文本数据。
     *               在标签重叠度很大的情况下，即使使用自动避让功能，可能也无法完全避免标签重叠现象。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.numericPrecision -{number}
     * @description 如果显示的标签内容为数字，通过该字段设置其显示的精度。例如标签对应的数字是8071.64529347，
     *              如果该属性为0时，显示8071；为1时，显示8071.6；为3时，则是8071.645。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.matrixCells -{Array<SuperMap.LabelMatrixCell>}
     * @description 矩阵标签元素数组，用于制作矩阵标签专题图。
     *              数组中可以放置符号类型的矩阵标签元素和图片类型的矩阵标签元素。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.labelExpression -{string}
     * @description 标注字段表达式。系统将 labelExpression 对应的字段或字段表达式的值以标签的形式显示在图层中。必设字段。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.items - {Array<SuperMap.ThemeUniqueItem>}
     * @description 分段标签专题图的子项数组。分段标签专题图使用 rangeExpression <br>
     *              指定数字型的字段作为分段数据，items 中的每个子对象的 [start，end) 分段值必须来源于属性 rangeExpression 的字段值。每个子项拥有自己的风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.background -{SuperMap.ThemeLabelBackground}
     * @description 标签专题图中标签的背景风格类。通过该字段可以设置标签的背景形状和风格。
     */
    function ThemeLabel(options) {
        _classCallCheck(this, ThemeLabel);

        var _this = _possibleConstructorReturn(this, (ThemeLabel.__proto__ || Object.getPrototypeOf(ThemeLabel)).call(this, "LABEL", options));

        _this.alongLine = null;
        _this.background = null;
        _this.flow = null;
        _this.items = null;
        _this.uniqueItems = null;
        _this.labelExpression = null;
        _this.labelOverLengthMode = _REST.LabelOverLengthMode.NONE;
        _this.matrixCells = null;
        _this.maxLabelLength = 256;
        _this.numericPrecision = 0;
        _this.offset = null;
        _this.overlapAvoided = true;
        _this.rangeExpression = null;
        _this.uniqueExpression = null;
        _this.smallGeometryLabeled = false;
        _this.text = null;
        _this.textSpace = 0;
        _this.CLASS_NAME = "SuperMap.ThemeLabel";

        var me = _this;
        me.alongLine = new _ThemeLabelAlongLine2.default();
        me.background = new _ThemeLabelBackground2.default();
        me.flow = new _ThemeFlow2.default();
        me.offset = new _ThemeOffset2.default();
        me.text = new _ThemeLabelText2.default();
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeLabel.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.textSpace -{number}
     * @description 沿线标注，相邻两个文字之间的间距，单位当前设置的字高
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.smallGeometryLabeled -{boolean}
     * @description 是否显示长度大于被标注对象本身长度的标签，默认为 false。在标签的长度大于线或者面对象本身的长度时，
     *              如果该值为 true，则标签文字会叠加在一起显示，为了清楚完整的显示该标签，
     *              可以采用换行模式来显示标签，但必须保证每行的长度小于对象本身的长度。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.rangeExpression -{string}
     * @description 制作分段标签专题的分段字段或字段表达式。该表达式对应的字段（或者字段表达式）的值应该为数值型。
     *              该字段与 items 分段子项联合使用，每个子项的起始值 [start，end)来源于 rangeExpression 字段值。
     *              最后 labelExpression 指定的标签字段（标签专题图要显示的具体内容）会根据分段子项的风格进行分段显示。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.maxLabelLength -{number}
     * @description 标签在每一行显示的最大长度，一个中文为两个字符。
     *              如果超过最大长度，可以采用两种方式来处理，一种是换行的模式进行显示，另一种是以省略号方式显示。默认最大长度为256个字符。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.labelOverLengthMode -{SuperMap.LabelOverLengthMode} 标签专题图中超长标签的处理模式枚举类。
     * 对于标签的长度超过设置的标签最大长度 maxLabelLength 时称为超长标签。默认为 SuperMap.LabelOverLengthMode.NONE。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.uniqueItems -{Array<SuperMap.ThemeLabelUniqueItem>}
     * @description 单值标签专题图子项数组。单值标签专题图使用 uniqueExpression单值标签专题图子项集合
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.flow -{SuperMap.ThemeFlow}
     * @description 标签专题图标签流动显示与牵引线设置类。通过该字段可以设置标签是否流动显示和牵引线风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.alongLine -{SuperMap.ThemeLabelAlongLine}
     * @description 标签沿线标注方向样式类。<br>
     *              在该类中可以设置标签是否沿线标注以及沿线标注的多种方式。沿线标注属性只适用于线数据集专题图。
     */


    _createClass(ThemeLabel, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeLabel.prototype.__proto__ || Object.getPrototypeOf(ThemeLabel.prototype), 'destroy', this).call(this);
            var me = this;
            me.alongLine = null;
            if (me.background) {
                me.background.destroy();
                me.background = null;
            }
            me.flow = null;
            if (me.items) {
                for (var i = 0, items = me.items, len = items.length; i < len; i++) {
                    items[i].destroy();
                }
                me.items = null;
            }
            if (me.uniqueItems) {
                for (var j = 0, uniqueItems = me.uniqueItems, uniqueLen = uniqueItems.length; j < uniqueLen; j++) {
                    uniqueItems[j].destory();
                }
                me.uniqueItems = null;
            }
            me.labelExpression = null;
            me.labelOverLengthMode = null;
            me.matrixCells = null;
            me.maxLabelLength = null;
            me.numericPrecision = null;
            me.overlapAvoided = null;
            me.rangeExpression = null;
            me.uniqueExpression = null;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            me.overlapAvoided = null;
            me.smallGeometryLabeled = null;
            if (me.text) {
                me.text.destroy();
                me.text = null;
            }
            me.textSpace = null;
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toJSON
         * @description 将themeLabel对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2.default.Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            obj.memoryData = this.memoryData;
            if (this.alongLine) {
                obj.alongLine = this.alongLine.isAlongLine;
                obj.alongLineDirection = this.alongLine.alongLineDirection;
                obj.angleFixed = this.alongLine.angleFixed;
                obj.isLabelRepeated = this.alongLine.isLabelRepeated;
                obj.labelRepeatInterval = this.alongLine.labelRepeatInterval;
                obj.repeatedLabelAvoided = this.alongLine.repeatedLabelAvoided;
                obj.repeatIntervalFixed = this.alongLine.repeatIntervalFixed;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }

            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.text) {
                obj.maxTextHeight = this.text.maxTextHeight;
                obj.maxTextWidth = this.text.maxTextWidth;
                obj.minTextHeight = this.text.minTextHeight;
                obj.minTextWidth = this.text.minTextWidth;
                obj.uniformStyle = this.text.uniformStyle;
                obj.uniformMixedStyle = this.text.uniformMixedStyle;
            }
            if (this.background) {
                obj.labelBackShape = this.background.labelBackShape;
                obj.backStyle = this.background.backStyle;
            }
            obj.labelOverLengthMode = this.labelOverLengthMode;
            obj.maxLabelLength = this.maxLabelLength;
            obj.smallGeometryLabeled = this.smallGeometryLabeled;
            obj.rangeExpression = this.rangeExpression;
            obj.uniqueExpression = this.uniqueExpression;
            obj.numericPrecision = this.numericPrecision;
            obj.items = this.items;
            obj.uniqueItems = this.uniqueItems;
            obj.labelExpression = this.labelExpression;
            obj.overlapAvoided = this.overlapAvoided;
            obj.matrixCells = this.matrixCells;
            obj.textSpace = this.textSpace;
            return obj;
        }

        /**
         * @function SuperMap.ThemeLabel.fromObj
         * @description 从传入对象获取标签专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeLabel} ThemeLabel对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var lab = new ThemeLabel();
            var itemsL = obj.items,
                itemsU = obj.uniqueItems,
                cells = obj.matrixCells;
            obj.matrixCells = null;
            _SuperMap2.default.Util.copy(lab, obj);
            lab.alongLine = _ThemeLabelAlongLine2.default.fromObj(obj);
            lab.background = _ThemeLabelBackground2.default.fromObj(obj);
            lab.flow = new _ThemeFlow2.default({ flowEnabled: obj.flowEnabled, leaderLineDisplayed: obj.leaderLineDisplayed, leaderLineStyle: obj.leaderLineStyle });
            if (itemsL) {
                lab.items = [];
                for (var i = 0, len = itemsL.length; i < len; i++) {
                    lab.items.push(_ThemeLabelItem2.default.fromObj(itemsL[i]));
                }
            }
            if (itemsU) {
                lab.uniqueItems = [];
                for (var j = 0, uniqueLen = itemsU.length; j < uniqueLen; j++) {
                    lab.uniqueItems.push(ThemeUniqueItem.fromObj(itemsU[j]));
                }
            }
            if (cells) {
                lab.matrixCells = [];
                for (var i = 0, len = cells.length; i < len; i++) {
                    //TODO
                    //lab.matrixCells.push(SuperMap.LabelMatrixCell.fromObj(cells[i]));
                }
            }
            lab.offset = _ThemeOffset2.default.fromObj(obj);
            lab.text = _ThemeLabelText2.default.fromObj(obj);
            return lab;
        }
    }]);

    return ThemeLabel;
}(_Theme3.default);

exports.default = ThemeLabel;


_SuperMap2.default.ThemeLabel = ThemeLabel;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeOffset
 * @classdesc 专题图中文本或符号相对于要素内点的偏移量设置类。
 *              通过该类可以设置专题图中标记文本或符号的偏移量以及偏移量是否随地图缩放而改变。
 * @param options - {Object} 可选参数。如：<br>
 *        offsetFixed - {boolean} 当前专题图是否固定标记文本或符号的偏移量。<br>
 *        offsetX - {string} 专题图中文本或符号相对于要素内点的水平偏移量。<br>
 *        offsetY - {string} 专题图中文本或符号相对于要素内点的垂直偏移量。
 */
var ThemeOffset = function () {

    /**
     * @member SuperMap.ThemeOffset.prototype.offsetX -{string}
     * @description 专题图中文本或符号相对于要素内点的水平偏移量。偏移量的单位为地图单位。
     *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么水平偏移量为2。
     */
    function ThemeOffset(options) {
        _classCallCheck(this, ThemeOffset);

        this.offsetFixed = false;
        this.offsetX = "0.0";
        this.offsetY = "0.0";
        this.CLASS_NAME = "SuperMap.ThemeOffset";

        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ThemeOffset.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeOffset.prototype.offsetY -{string}
     * @description 专题图中文本或符号相对于要素内点的垂直偏移量。偏移量的单位为地图单位。
     *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么垂直偏移量为2。
     */


    /**
     * @member SuperMap.ThemeOffset.prototype.offsetFixed -{boolean}
     * @description 当前专题图是否固定标记文本或符号的偏移量。所谓固定偏移量，则文本或符号的偏移量不随地图的缩放而变化。默认为 false，表示偏移量随地图的缩放而变化。
     */


    _createClass(ThemeOffset, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.offsetFixed = null;
            me.offsetX = null;
            me.offsetY = null;
        }

        /**
         * @function SuperMap.ThemeOffset.fromObj
         * @description 从传入对象获取专题图中文本或符号相对于要素内点的偏移量设置类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeOffset} ThemeOffset对象
         */

    }], [{
        key: "fromObj",
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeOffset();
            _SuperMap2.default.Util.copy(res, obj);
            return res;
        }
    }]);

    return ThemeOffset;
}();

exports.default = ThemeOffset;


_SuperMap2.default.ThemeOffset = ThemeOffset;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThiessenAnalystParameters
 * @classdesc 泰森多边形分析参数基类。
 * @param options - {Object} 可选参数。如:</br>
 *        clipRegion - {Object} 结果数据裁剪区域，可以为null，表示不对结果进行裁剪。</br>
 *                      面类型可以是：SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon。</br>
 *        createResultDataset - {boolean} 是否返回结果数据集，默认不返回。</br>
 *        resultDatasetName - {boolean} 指定结果数据集名称。</br>
 *        resultDatasourceName - {boolean} 指定结果数据集所在数据源，默认为当前数据源。</br>
 *        returnResultRegion - {boolean} 是否返回分析得到的多边形面数组，默认返回。</br>
 */
var ThiessenAnalystParameters = function () {

    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.resultDatasourceName -{string}
     * @description 指定结果数据集所在数据源。
     */


    /**
     *  @member SuperMap.ThiessenAnalystParameters.prototype.createResultDataset -{boolean}
     *  @description 是否返回结果数据集，默认值 false。如果为true，则必须设置属性resultDatasetName和resultDatasourceName。
     */
    function ThiessenAnalystParameters(options) {
        _classCallCheck(this, ThiessenAnalystParameters);

        this.clipRegion = null;
        this.createResultDataset = false;
        this.resultDatasetName = null;
        this.resultDatasourceName = null;
        this.returnResultRegion = true;
        this.CLASS_NAME = "SuperMap.ThiessenAnalystParameters";

        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     * @function SuperMap.ThiessenAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.returnResultRegion -{boolean}
     * @description 是否返回分析得到的多边形面数组，默认 true，返回。
     */


    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.resultDatasetName -{string}
     * @description 指定结果数据集名称。
     */

    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.clipRegion  -{Object}
     * @description 结果数据裁剪区域，可以为null，表示不对结果进行裁剪。</br>
     * 面类型可以是：SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon。
     */


    _createClass(ThiessenAnalystParameters, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            if (me.clipRegion) {
                me.clipRegion.destroy();
                me.clipRegion = null;
            }
            me.createResultDataset = null;
            me.resultDatasetName = null;
            me.resultDatasourceName = null;
            me.returnResultRegion = null;
        }
    }]);

    return ThiessenAnalystParameters;
}();

exports.default = ThiessenAnalystParameters;

_SuperMap2.default.ThiessenAnalystParameters = ThiessenAnalystParameters;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Size = __webpack_require__(136);

var _Size2 = _interopRequireDefault(_Size);

var _Pixel = __webpack_require__(41);

var _Pixel2 = _interopRequireDefault(_Pixel);

var _LonLat = __webpack_require__(135);

var _LonLat2 = _interopRequireDefault(_LonLat);

var _Point = __webpack_require__(10);

var _Point2 = _interopRequireDefault(_Point);

var _LinearRing = __webpack_require__(25);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _Polygon = __webpack_require__(31);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _Util = __webpack_require__(7);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Bounds
 * @classdesc 表示边界类实例。使用bounds之前需要设置left,bottom, right, top四个属性，这些属性的初始值为null。
 * @param  left - {number} 左边界，注意考虑宽度，理论上小于right值。
 * @param  bottom - {number} 下边界。考虑高度，理论上小于top值。
 * @param  right - {number} 右边界。
 * @param  top - {number} 上边界。
 * @param  array - {Array<number>} [left, bottom, right, top]  如果同时传多个参数，则使用左下右上组成的数组。
 * @example
 * var bounds = new SuperMap.Bounds();
 * bounds.extend(new SuperMap.LonLat(4,5));
 * bounds.extend(new SuperMap.LonLat(5,6));
 * bounds.toBBOX(); // returns 4,5,5,6
 */
var Bounds = function () {

    /**
     * @member SuperMap.Bounds.prototype.top - {number}
     * @description 最大的垂直坐标系。
     */


    /**
     * @member SuperMap.Bounds.prototype.bottom - {number}
     * @description 最小的垂直坐标系。
     */
    function Bounds(left, bottom, right, top) {
        _classCallCheck(this, Bounds);

        this.left = null;
        this.bottom = null;
        this.right = null;
        this.top = null;
        this.centerLonLat = null;
        this.CLASS_NAME = "SuperMap.Bounds";

        if (_Util.Util.isArray(left)) {
            top = left[3];
            right = left[2];
            bottom = left[1];
            left = left[0];
        }
        this.left = left != null ? _Util.Util.toFloat(left) : this.left;
        this.bottom = bottom != null ? _Util.Util.toFloat(bottom) : this.bottom;
        this.right = right != null ? _Util.Util.toFloat(right) : this.right;
        this.top = top != null ? _Util.Util.toFloat(top) : this.top;
    }

    /**
     * @function SuperMap.Bounds.prototype.clone
     * @description 复制当前 bounds 对象。
     * @example
     * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
     * var bounds2 = bounds1.clone();
     * @returns {SuperMap.Bounds} 返回一个克隆的bounds。
     */


    /**
     * @member SuperMap.Bounds.prototype.centerLonLat - {SuperMap.LonLat}
     * @description bounds的地图空间的中心点。用 getCenterLonLat() 获得。
     */


    /**
     * @member SuperMap.Bounds.prototype.right - {number}
     * @description 最大的水平坐标系。
     */


    /**
     * @member SuperMap.Bounds.prototype.left - {number}
     * @description 最小的水平坐标系。
     */


    _createClass(Bounds, [{
        key: 'clone',
        value: function clone() {
            return new Bounds(this.left, this.bottom, this.right, this.top);
        }

        /**
         * @function SuperMap.Bounds.prototype.equals
         * @description 判断两个 bounds 对象是否相等。
         * @example
         * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
         * var bounds2 = new SuperMap.Bounds(-180,-90,180,90);
         * var isEquals = bounds1.equals(bounds2);
         * @param bounds - {SuperMap.Bounds} 需要进行计较的 bounds。
         * @returns {boolean} 如果 bounds 对象的边和传入的 bounds 一致则返回true,不一致或传入的 bounds 参数为NULL则返回false。
         */

    }, {
        key: 'equals',
        value: function equals(bounds) {
            var equals = false;
            if (bounds != null) {
                equals = this.left === bounds.left && this.right === bounds.right && this.top === bounds.top && this.bottom === bounds.bottom;
            }
            return equals;
        }

        /**
         * @function SuperMap.Bounds.prototype.toString
         * @description 返回此对象的字符串形式
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,180,90);
         * var str = bounds.toString();
         * @returns {string} 边界对象的字符串表示形式（left,bottom,right,top），例如: "-180,-90,180,90"
         */

    }, {
        key: 'toString',
        value: function toString() {
            return [this.left, this.bottom, this.right, this.top].join(",");
        }

        /**
         * @function SuperMap.Bounds.prototype.toArray
         * @description 边界对象的数组表示形式 。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //array1 = [-180,-90,100,80];
         * var array1 = bounds.toArray();
         * //array1 = [-90,-180,80,100];
         * var array2 = bounds.toArray(true);
         * @param reverseAxisOrder - {boolean} 是否反转轴顺序，
         * 如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {Array} left, bottom, right, top数组。
         */

    }, {
        key: 'toArray',
        value: function toArray(reverseAxisOrder) {
            if (reverseAxisOrder === true) {
                return [this.bottom, this.left, this.top, this.right];
            } else {
                return [this.left, this.bottom, this.right, this.top];
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toBBOX
         * @description 取小数点后decimal位数字进行四舍五入再转换为BBOX字符串。
         * @example
         * var bounds = new SuperMap.Bounds(-1.1234567,-1.7654321,1.4444444,1.5555555);
         * //str1 = "-1.123457,-1.765432,1.444444,1.555556";
         * var str1 = bounds.toBBOX();
         * //str2 = "-1.1,-1.8,1.4,1.6";
         * var str2 = bounds.toBBOX(1);
         * //str2 = "-1.8,-1.1,1.6,1.4";
         * var str2 = bounds.toBBOX(1,true);
         * @param decimal - {integer} 边界方位坐标的有效数字个数，默认为6。
         * @param  reverseAxisOrder - {boolean} 是否是反转轴顺序。
         * 如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {string} 边界对象的字符串表示形式，如："5,42,10,45"。
         */

    }, {
        key: 'toBBOX',
        value: function toBBOX(decimal, reverseAxisOrder) {
            if (decimal == null) {
                decimal = 6;
            }
            var mult = Math.pow(10, decimal);
            var xmin = Math.round(this.left * mult) / mult;
            var ymin = Math.round(this.bottom * mult) / mult;
            var xmax = Math.round(this.right * mult) / mult;
            var ymax = Math.round(this.top * mult) / mult;
            if (reverseAxisOrder === true) {
                return ymin + "," + xmin + "," + ymax + "," + xmax;
            } else {
                return xmin + "," + ymin + "," + xmax + "," + ymax;
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toGeometry
         * @description 基于当前边界范围创建一个新的多边形对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //SuperMap.Geometry.Polygon对象
         * var geo = bounds.toGeometry();
         * @returns {SuperMap.Geometry.Polygon} 基于当前bounds坐标创建的新的多边形。
         */

    }, {
        key: 'toGeometry',
        value: function toGeometry() {
            return new _Polygon2.default([new _LinearRing2.default([new _Point2.default(this.left, this.bottom), new _Point2.default(this.right, this.bottom), new _Point2.default(this.right, this.top), new _Point2.default(this.left, this.top)])]);
        }

        /**
         * @function SuperMap.Bounds.prototype.getWidth
         * @description 获取bounds的宽度。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //width = 280;
         * var width = bounds.getWidth();
         * @returns {float} 获取当前bounds的宽度（right减去left）。
         */

    }, {
        key: 'getWidth',
        value: function getWidth() {
            return this.right - this.left;
        }

        /**
         * @function SuperMap.Bounds.prototype.getHeight
         * @description 获取bounds的高度。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //height = 170;
         * var height = bounds.getHeight();
         * @returns {float} 返回边界高度（top减去bottom）。
         */

    }, {
        key: 'getHeight',
        value: function getHeight() {
            return this.top - this.bottom;
        }

        /**
         * @function SuperMap.Bounds.prototype.getSize
         * @description 获取边框大小。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var size = bounds.getSize();
         * @returns {SuperMap.Size} 返回边框大小。
         */

    }, {
        key: 'getSize',
        value: function getSize() {
            return new _Size2.default(this.getWidth(), this.getHeight());
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterPixel
         * @description 获取像素格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var pixel = bounds.getCenterPixel();
         * @returns {SuperMap.Pixel} 返回像素格式的当前范围的中心点。
         */

    }, {
        key: 'getCenterPixel',
        value: function getCenterPixel() {
            return new _Pixel2.default((this.left + this.right) / 2, (this.bottom + this.top) / 2);
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterLonLat
         * @description 获取地理格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var lonlat = bounds.getCenterLonLat();
         * @returns {SuperMap.LonLat} 返回当前地理范围的中心点。
         */

    }, {
        key: 'getCenterLonLat',
        value: function getCenterLonLat() {
            if (!this.centerLonLat) {
                this.centerLonLat = new _LonLat2.default((this.left + this.right) / 2, (this.bottom + this.top) / 2);
            }
            return this.centerLonLat;
        }

        /**
         * @function SuperMap.Bounds.prototype.scale
         * @description 按照比例扩大/缩小出一个新的bounds。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * var bounds2 = bounds.scale(2);
         * @param ratio - {float} 需要扩大的比例，默认为1。
         * @param origin - {SuperMap.Pixel|SuperMap.LonLat} 扩大时的基准点，默认为当前bounds的中心点。
         * @returns {SuperMap.Bounds} 返回通过ratio、origin计算得到的新的边界范围。
         */

    }, {
        key: 'scale',
        value: function scale(ratio, origin) {
            ratio = ratio ? ratio : 1;
            if (origin == null) {
                origin = this.getCenterLonLat();
            }

            var origx, origy;

            // get origin coordinates
            if (origin.CLASS_NAME === "SuperMap.LonLat") {
                origx = origin.lon;
                origy = origin.lat;
            } else {
                origx = origin.x;
                origy = origin.y;
            }

            var left = (this.left - origx) * ratio + origx;
            var bottom = (this.bottom - origy) * ratio + origy;
            var right = (this.right - origx) * ratio + origx;
            var top = (this.top - origy) * ratio + origy;

            return new Bounds(left, bottom, right, top);
        }

        /**
         * @function SuperMap.Bounds.prototype.add
         * @description 在当前的dounds上按照传入的坐标点进行平移，返回新的范围。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //bounds2 是新的 bounds
         * var bounds2 = bounds.add(20,10);
         * @param x - {float} 传入坐标点的x坐标。
         * @param y - {float} 传入坐标点的y坐标。
         * @returns {SuperMap.Bounds} 返回一个新的bounds，此bounds的坐标是由传入的x，y参数与当前bounds坐标计算所得。
         */

    }, {
        key: 'add',
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Bounds.add cannot receive null values');
            }
            return new Bounds(this.left + x, this.bottom + y, this.right + x, this.top + y);
        }

        /**
         * @function SuperMap.Bounds.prototype.extend
         * @description 在当前bounds上扩展bounds，支持point，lanlat和bounds。扩展后的bounds的范围是两者的结合。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //bounds改变
         * bounds.extend(new SuperMap.LonLat(50,60));
         * @param object - {SuperMap.Geometry.Point|SuperMap.LonLat | SuperMap.Bounds} 可以是point，lanlat和bounds。
         */

    }, {
        key: 'extend',
        value: function extend(object) {
            var bounds = null;
            if (object) {
                // clear cached center location
                switch (object.CLASS_NAME) {
                    case "SuperMap.LonLat":
                        bounds = new Bounds(object.lon, object.lat, object.lon, object.lat);
                        break;
                    case "SuperMap.Geometry.Point":
                        bounds = new Bounds(object.x, object.y, object.x, object.y);
                        break;

                    case "SuperMap.Bounds":
                        bounds = object;
                        break;
                }

                if (bounds) {
                    this.centerLonLat = null;
                    if (this.left == null || bounds.left < this.left) {
                        this.left = bounds.left;
                    }
                    if (this.bottom == null || bounds.bottom < this.bottom) {
                        this.bottom = bounds.bottom;
                    }
                    if (this.right == null || bounds.right > this.right) {
                        this.right = bounds.right;
                    }
                    if (this.top == null || bounds.top > this.top) {
                        this.top = bounds.top;
                    }
                }
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.containsLonLat
         * @description 判断传入的坐标是否在范围内。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains1 = true
         * //这里的第二个参数可以直接为 boolean 类型，也就是inclusive
         * var isContains1 = bounds.containsLonLat(new SuperMap.LonLat(40,40),true);
         *
         * //(40,40)在范围内，同样(40+360,40)也在范围内
         * var bounds2 = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains2 = true;
         * var isContains2 = bounds2.containsLonLat(
         *      new SuperMap.LonLat(400,40),
         *      {
         *           inclusive:true,
         *           //全球的范围
         *           worldBounds: new SuperMap.Bounds(-180,-90,180,90)
         *      }
         *      );
         * @param ll - {SuperMap.LonLat|Object}  <SuperMap.LonLat> 对象或者是一个
         *     包含 'lon' 与 'lat' 属性的对象。
         * @param options - {Object} 可选参数<br>
         *         inclusive - {boolean} 是否包含边界，默认为 true 。<br>
         *         worldBounds - {@link SuperMap.Bounds} 如果提供 worldBounds 参数, 如果 ll 参数提供的坐标超出了世界边界（worldBounds）,
         *         但是通过日界线的转化可以被包含, 它将被认为是包含在该范围内的。
         * @returns {boolean} 传入坐标是否包含在范围内.
         */

    }, {
        key: 'containsLonLat',
        value: function containsLonLat(ll, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            var contains = this.contains(ll.lon, ll.lat, options.inclusive),
                worldBounds = options.worldBounds;
            //日界线以外的也有可能算包含，
            if (worldBounds && !contains) {
                var worldWidth = worldBounds.getWidth();
                var worldCenterX = (worldBounds.left + worldBounds.right) / 2;
                //这一步很关键
                var worldsAway = Math.round((ll.lon - worldCenterX) / worldWidth);
                contains = this.containsLonLat({
                    lon: ll.lon - worldsAway * worldWidth,
                    lat: ll.lat
                }, { inclusive: options.inclusive });
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsPixel
         * @description 判断传入的像素是否在范围内。直接匹配大小，不涉及像素和地理转换。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains = true
         * var isContains = bounds.containsPixel(new SuperMap.Pixel(40,40),true);
         * @param px - {SuperMap.Pixel} 提供的像素参数。
         * @param inclusive - {boolean} 是否包含边界，默认为true。
         * @returns {boolean} 传入的pixel在当前边界范围之内。
         */

    }, {
        key: 'containsPixel',
        value: function containsPixel(px, inclusive) {
            return this.contains(px.x, px.y, inclusive);
        }

        /**
         * @function SuperMap.Bounds.prototype.contains
         * @description 判断传入的x，y坐标值是否在范围内。
         * @example
         * var bounds = new SuperMap.Bounds(-50,-50,40,40);
         * //isContains = true
         * var isContains = bounds.contains(40,40,true);
         * @param x - {float} 传入的x坐标值。
         * @param y - {float} 传入的y坐标值。
         * @param inclusive - {boolean} 是否包含边界，默认为true。
         * @returns {boolean} 传入的x,y坐标在当前范围内。
         */

    }, {
        key: 'contains',
        value: function contains(x, y, inclusive) {
            //set default
            if (inclusive == null) {
                inclusive = true;
            }

            if (x == null || y == null) {
                return false;
            }

            x = _Util.Util.toFloat(x);
            y = _Util.Util.toFloat(y);

            var contains = false;
            if (inclusive) {
                contains = x >= this.left && x <= this.right && y >= this.bottom && y <= this.top;
            } else {
                contains = x > this.left && x < this.right && y > this.bottom && y < this.top;
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.intersectsBounds
         * @description 判断目标边界范围是否与当前边界范围相交。如果两个边界范围中的任意
         *                边缘相交或者一个边界包含了另外一个就认为这两个边界相交。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var isIntersects = bounds.intersectsBounds(
         *      new SuperMap.Bounds(-170,-90,120,80)
         *  );
         * @param bounds - {SuperMap.Bounds} 目标边界。
         * @param options - {Object} 可选参数。<br>
         *         inclusive - {boolean} 边缘重合也看成相交，默认为true。如果是false，
         *                               两个边界范围没有重叠部分仅仅是在边缘相接（重合），
         *                               这种情况被认为没有相交。<br>
         *         worldBounds - {@link SuperMap.Bounds} 提供了 worldBounds 参数, 如果他们相交时
         *                               是在全球范围内, 两个边界将被视为相交。这仅适用于交叉
         *                               或完全不在世界范围的边界。
         * @returns {boolean} 传入的bounds对象与当前bounds相交。
         */

    }, {
        key: 'intersectsBounds',
        value: function intersectsBounds(bounds, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            if (options.worldBounds) {
                var self = this.wrapDateLine(options.worldBounds);
                bounds = bounds.wrapDateLine(options.worldBounds);
            } else {
                self = this;
            }
            if (options.inclusive == null) {
                options.inclusive = true;
            }
            var intersects = false;
            var mightTouch = self.left === bounds.right || self.right === bounds.left || self.top === bounds.bottom || self.bottom === bounds.top;

            // if the two bounds only touch at an edge, and inclusive is false,
            // then the bounds don't *really* intersect.
            if (options.inclusive || !mightTouch) {
                // otherwise, if one of the boundaries even partially contains another,
                // inclusive of the edges, then they do intersect.
                var inBottom = bounds.bottom >= self.bottom && bounds.bottom <= self.top || self.bottom >= bounds.bottom && self.bottom <= bounds.top;
                var inTop = bounds.top >= self.bottom && bounds.top <= self.top || self.top > bounds.bottom && self.top < bounds.top;
                var inLeft = bounds.left >= self.left && bounds.left <= self.right || self.left >= bounds.left && self.left <= bounds.right;
                var inRight = bounds.right >= self.left && bounds.right <= self.right || self.right >= bounds.left && self.right <= bounds.right;
                intersects = (inBottom || inTop) && (inLeft || inRight);
            }
            // document me
            if (options.worldBounds && !intersects) {
                var world = options.worldBounds;
                var width = world.getWidth();
                var selfCrosses = !world.containsBounds(self);
                var boundsCrosses = !world.containsBounds(bounds);
                if (selfCrosses && !boundsCrosses) {
                    bounds = bounds.add(-width, 0);
                    intersects = self.intersectsBounds(bounds, { inclusive: options.inclusive });
                } else if (boundsCrosses && !selfCrosses) {
                    self = self.add(-width, 0);
                    intersects = bounds.intersectsBounds(self, { inclusive: options.inclusive });
                }
            }
            return intersects;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsBounds
         * @description 判断目标边界是否被当前边界包含在内。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var isContains = bounds.containsBounds(
         *      new SuperMap.Bounds(-170,-90,100,80),true,true
         *  );
         * @param bounds - {SuperMap.Bounds} 目标边界。
         * @param partial - {boolean} 目标边界的任意部分都包含在当前边界中则被认为是包含关系。默认为false，
         *                             如果设为false，整个目标边界全部被包含在当前边界范围内。
         * @param inclusive - {boolean} 边缘共享被视为包含。默认为true。
         * @returns {boolean} 传入的边界被当前边界包含。
         */

    }, {
        key: 'containsBounds',
        value: function containsBounds(bounds, partial, inclusive) {
            if (partial == null) {
                partial = false;
            }
            if (inclusive == null) {
                inclusive = true;
            }
            var bottomLeft = this.contains(bounds.left, bounds.bottom, inclusive);
            var bottomRight = this.contains(bounds.right, bounds.bottom, inclusive);
            var topLeft = this.contains(bounds.left, bounds.top, inclusive);
            var topRight = this.contains(bounds.right, bounds.top, inclusive);

            return partial ? bottomLeft || bottomRight || topLeft || topRight : bottomLeft && bottomRight && topLeft && topRight;
        }

        /**
         * @function SuperMap.Bounds.prototype.determineQuadrant
         * @description 判断传入坐标在bounds范围内的象限。以bounds中心点为坐标原点。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * //str = "tr";
         * var str = bounds.determineQuadrant(
         *      new SuperMap.LonLat(20,20)
         *  );
         * @param lonlat - {SuperMap.LonLat} 传入的坐标对象。
         * @returns {string} 传入坐标所在的象限("br" "tr" "tl" "bl" 分别对应"右下"，"右上"，"左上" "左下")。
         */

    }, {
        key: 'determineQuadrant',
        value: function determineQuadrant(lonlat) {

            var quadrant = "";
            var center = this.getCenterLonLat();

            quadrant += lonlat.lat < center.lat ? "b" : "t";
            quadrant += lonlat.lon < center.lon ? "l" : "r";

            return quadrant;
        }

        /**
         * @function SuperMap.Bounds.prototype.wrapDateLine
         * @description 将当前bounds移动到最大边界范围内部（所谓的内部是相交或者内部）。
         * @example
         * var bounds = new SuperMap.Bounds(380,-40,400,-20);
         * var maxExtent = new SuperMap.Bounds(-180,-90,100,80);
         * //新的bounds
         * var newBounds = bounds.wrapDateLine(maxExtent);
         * @param maxExtent - {SuperMap.Bounds} 最大的边界范围（一般是全球范围）。
         * @param options - {Object} 可选选项参数。<br>
         *         leftTolerance - {float} left允许的误差。默认为0。<br>
         *         rightTolerance - {float} right允许的误差。默认为0。
         * @returns {SuperMap.Bounds} 克隆当前边界。如果当前边界完全在最大范围之外此函数则返回一个不同值的边界，
         *                             若落在最大边界的左边，则给当前的bounds值加上最大范围的宽度，即向右移动，
         *                             若落在右边，则向左移动，即给当前的bounds值加上负的最大范围的宽度。
         */

    }, {
        key: 'wrapDateLine',
        value: function wrapDateLine(maxExtent, options) {
            options = options || {};

            var leftTolerance = options.leftTolerance || 0;
            var rightTolerance = options.rightTolerance || 0;

            var newBounds = this.clone();

            if (maxExtent) {
                var width = maxExtent.getWidth();
                //如果 newBounds 在 maxExtent 的左边，那么一直向右移动，直到相交或者包含为止，每次移动width
                //shift right?
                while (newBounds.left < maxExtent.left && newBounds.right - rightTolerance <= maxExtent.left) {
                    newBounds = newBounds.add(width, 0);
                }
                //如果 newBounds 在 maxExtent 的右边，那么一直向左移动，直到相交或者包含为止，每次移动width
                //shift left?
                while (newBounds.left + leftTolerance >= maxExtent.right && newBounds.right > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
                //如果和右边相交，左边又在内部，那么再次向左边移动一次
                // crosses right only? force left
                var newLeft = newBounds.left + leftTolerance;
                if (newLeft < maxExtent.right && newLeft > maxExtent.left && newBounds.right - rightTolerance > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
            }

            return newBounds;
        }

        /**
         * @function SuperMap.Bounds.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * var obj = bounds.toServerJSONObject();
         * @returns {Object} 返回json 格式的Object对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = {
                rightTop: { x: this.right, y: this.top },
                leftBottom: { x: this.left, y: this.bottom },
                left: this.left,
                right: this.right,
                top: this.top,
                bottom: this.bottom
            };
            return jsonObject;
        }

        /**
         *
         * @function SuperMap.Bounds.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为null，而不是初始值。
         * @example
         * var bounds = new SuperMap.Bounds(-180,-90,100,80);
         * bounds.destroy();
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.left = null;
            this.right = null;
            this.top = null;
            this.bottom = null;
            this.centerLonLat = null;
        }

        /**
         * @function SuperMap.Bounds.fromString
         * @description 通过字符串参数创建新的bounds的构造函数。
         * @example
         * var bounds = SuperMap.Bounds.fromString("-180,-90,100,80");
         * @param str - {string} 边界字符串，用逗号隔开 (e.g. <i>"5,42,10,45"</i>)
         * @param reverseAxisOrder - {boolean} 是否反转轴顺序.
         * 如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {SuperMap.Bounds} 返回给定的字符串创建的新的边界对象
         */

    }], [{
        key: 'fromString',
        value: function fromString(str, reverseAxisOrder) {
            var bounds = str.split(",");
            return Bounds.fromArray(bounds, reverseAxisOrder);
        }
    }, {
        key: 'fromArray',


        /**
         * @function SuperMap.Bounds.fromArray
         * @description 通过边界框数组创建Bounds。
         * @example
         * var bounds = SuperMap.Bounds.fromArray([-180,-90,100,80]);
         * @param bbox - {Array(float)} 边界值数组。 (e.g. <i>[5,42,10,45]</i>)
         * @param reverseAxisOrder - {boolean} 是否是反转轴顺序。如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {SuperMap.Bounds} 返回根据传入的数组创建的新的边界对象。
         */
        value: function fromArray(bbox, reverseAxisOrder) {
            return reverseAxisOrder === true ? new Bounds(bbox[1], bbox[0], bbox[3], bbox[2]) : new Bounds(bbox[0], bbox[1], bbox[2], bbox[3]);
        }
    }, {
        key: 'fromSize',


        /**
         * @function SuperMap.Bounds.fromSize
         * @description 通过传入的边界大小来创建新的边界。
         * @example
         * var bounds = SuperMap.Bounds.fromSize(new SuperMap.Size(20,10));
         * @param size - {SuperMap.Size} 传入的边界大小。
         * @returns {SuperMap.Bounds} 返回根据传入的边界大小的创建新的边界。
         */
        value: function fromSize(size) {
            return new Bounds(0, size.h, size.w, 0);
        }
    }, {
        key: 'oppositeQuadrant',


        /**
         * @function SuperMap.Bounds.oppositeQuadrant
         * @description 反转象限。"t"和"b" 交换，"r"和"l"交换, 如："tl"变为"br"。
         * @param quadrant - {string} 代表象限的字符串，如："tl"。
         * @returns {string} 反转后的象限。
         */
        value: function oppositeQuadrant(quadrant) {
            var opp = "";

            opp += quadrant.charAt(0) === 't' ? 'b' : 't';
            opp += quadrant.charAt(1) === 'l' ? 'r' : 'l';

            return opp;
        }
    }]);

    return Bounds;
}();

exports.default = Bounds;

_SuperMap2.default.Bounds = Bounds;

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _WKT = __webpack_require__(141);

var _WKT2 = _interopRequireDefault(_WKT);

var _Vector = __webpack_require__(137);

var _Vector2 = _interopRequireDefault(_Vector);

var _Util = __webpack_require__(7);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Geometry
 * @classdesc 几何对象类，描述地理对象的几何图形。
 */
var Geometry = function () {

    /**
     * @member SuperMap.Geometry.prototype.bounds - {SuperMap.Bounds}
     * @description 几何对象的范围。
     */


    /**
     * @member SuperMap.Geometry.prototype.id - {string}
     * @description  此几何对象的唯一标示符。
     */
    function Geometry() {
        _classCallCheck(this, Geometry);

        this.id = null;
        this.parent = null;
        this.bounds = null;
        this.SRID = null;
        this.CLASS_NAME = "SuperMap.Geometry";

        this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");
    }

    /**
     * @function SuperMap.Geometry.prototype.destroy
     * @description 解构Geometry类，释放资源。
     */


    /**
     * @member SuperMap.Geometry.prototype.SRID - {interger}
     * @description 投影坐标参数。通过该参数，服务器判断Geometry对象的坐标参考系是否与数据集相同，如果不同，则在数据入库前进行投影变换。
     * @example
     *   var geometry= new SuperMap.Geometry();
     *   geometry. SRID=4326;
     */


    /**
     * @member SuperMap.Geometry.prototype.parent - {SuperMap.Geometry}
     * @description 当几何对象添加到组件上的时候被设置。
     */


    _createClass(Geometry, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.bounds = null;
            this.SRID = null;
        }

        /**
         * @function SuperMap.Geometry.prototype.clone
         * @description 创建克隆的几何图形。克隆的几何图形不设置非标准的属性。
         * @returns {SuperMap.Geometry} 克隆的几何图形。
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new Geometry();
        }

        /**
         * @function SuperMap.Geometry.prototype.setBounds
         * @description 设置此几何对象的bounds。
         * @param bounds - {SuperMap.Bounds}
         */

    }, {
        key: 'setBounds',
        value: function setBounds(bounds) {
            if (bounds) {
                this.bounds = bounds.clone();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.clearBounds
         * @description 清除几何对象的bounds。
         * 如果该对象有父类，也会清除父类几何对象的bounds。
         */

    }, {
        key: 'clearBounds',
        value: function clearBounds() {
            this.bounds = null;
            if (this.parent) {
                this.parent.clearBounds();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.extendBounds
         * @description 扩展新的Bounds。
         * @param newBounds - {SuperMap.Bounds}
         */

    }, {
        key: 'extendBounds',
        value: function extendBounds(newBounds) {
            var bounds = this.getBounds();
            if (!bounds) {
                this.setBounds(newBounds);
            } else {
                this.bounds.extend(newBounds);
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.getBounds
         * @description 获得几何图形的边界。如果没有设置边界，可通过计算获得。
         * @returns {SuperMap.Bounds}返回的几何对象的边界。
         */

    }, {
        key: 'getBounds',
        value: function getBounds() {
            if (this.bounds == null) {
                this.calculateBounds();
            }
            return this.bounds;
        }

        /**
         * @function SuperMap.Geometry.prototype.calculateBounds
         * @description 重新计算几何图形的边界。（需要在子类中实现此方法）
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {}
        //
        // This should be overridden by subclasses.
        //


        /**
         * @function SuperMap.Geometry.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。（需要在子类中实现此方法）
         * @param geometry - {SuperMap.Geometry} 目标几何图形.
         * @param options - {Object} 距离计算需要设计的可选属性。有效的选项取决于特定的几何类型。
         * @returns {number | Object} 两个几个图形间的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {}

        /**
         * @function SuperMap.Geometry.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表。（需要在子类中实现此方法）
         * @param nodes - {boolean} 如果是true，线则只返回线的末端点，如果false，仅仅返回顶点，如果没有设置，则返回顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {}

        /**
         * @function SuperMap.Geometry.prototype.atPoint
         * @description 确定坐标是否在几何对象的范围内。
         * @param lonlat -{SuperMap.LonLat}
         * @param toleranceLon - {float} 可选参数，经度的偏移。
         * @param toleranceLat - {float}  可选参数，纬度的偏移。
         * @returns {boolean} 判断传入的坐标是否在指定的范围内 。
         *
         */

    }, {
        key: 'atPoint',
        value: function atPoint(lonlat, toleranceLon, toleranceLat) {
            var atPoint = false;
            var bounds = this.getBounds();
            if (bounds != null && lonlat != null) {

                var dX = toleranceLon != null ? toleranceLon : 0;
                var dY = toleranceLat != null ? toleranceLat : 0;

                var toleranceBounds = new _SuperMap2.default.Bounds(this.bounds.left - dX, this.bounds.bottom - dY, this.bounds.right + dX, this.bounds.top + dY);

                atPoint = toleranceBounds.containsLonLat(lonlat);
            }
            return atPoint;
        }

        /**
         * @function SuperMap.Geometry.prototype.getLength
         * @description 计算几何对象的长度 ，此方法需要在子类中定义 。
         * @returns {float} 集合长度。
         */

    }, {
        key: 'getLength',
        value: function getLength() {
            //to be overridden by geometries that actually have a length
            //
            return 0.0;
        }

        /**
         * @function SuperMap.Geometry.prototype.getArea
         * @description 计算几何对象的面积 ，此方法需要在子类中定义  。
         * @returns {float} 集合表示的面积。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            //to be overridden by geometries that actually have an area
            //
            return 0.0;
        }

        /**
         * @function SuperMap.Geometry.prototype.getCentroid
         * @description 计算几何图形的质心。（需要在子类中实现此方法）
         * @returns {SuperMap.Geometry.Point} 采集的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            return null;
        }

        /**
         * @function SuperMap.Geometry.prototype.toString
         * @description 返回geometry对象的字符串表述，需要引入{@link SuperMap.Format.WKT}。此方法只能在子类实现，在父类使用会报错。
         * @returns {string} geometry对象的字符串表述(Well-Known Text)。
         */

    }, {
        key: 'toString',
        value: function toString() {
            var string;
            if (_WKT2.default) {
                var wkt = new _WKT2.default();
                string = wkt.write(new _Vector2.default(this));
            } else {
                string = Object.prototype.toString.call(this);
            }
            return string;
        }

        /**
         * @function SuperMap.Geometry.fromWKT
         * @description 从一个给定的字符串生成一个geometry对象，需要引入SuperMap.Format.WKT，该方法方可生效。
         * @example
         * var geometry= new SuperMap.Geometry.fromWKT("POINT(0 0)");
         * geometry.x=0;
         * @param wkt - {string} 描述geometry信息的字符串(A string representing the geometry in Well-Known Text.)
         * @returns {SuperMap.Geometry} 适当类型的geometry对象(A geometry of the appropriate class).
         */

    }], [{
        key: 'fromWKT',
        value: function fromWKT(wkt) {
            var geom;
            if (_WKT2.default) {
                var format = Geometry.fromWKT.format;
                if (!format) {
                    format = new _WKT2.default();
                    Geometry.fromWKT.format = format;
                }
                var result = format.read(wkt);
                if (result instanceof _Vector2.default) {
                    geom = result.geometry;
                } else if (_Util.Util.isArray(result)) {
                    var len = result.length;
                    var components = new Array(len);
                    for (var i = 0; i < len; ++i) {
                        components[i] = result[i].geometry;
                    }
                    geom = new Geometry.Collection(components);
                }
            }
            return geom;
        }

        /**
         * @function SuperMap.Geometry.prototype.SuperMap.Geometry.segmentsIntersect
         * @description 线段相交。该方法是判断两条线段是否相交。计算并返回相交的point。如果seg1.x2 >= seg2.x1 || seg2.x2 >= seg1.x1 ，该方法明显不会被调用。
         * @param seg1 - {Object} 该对象包含的属性是 x1, y1, x2,和y2。起始点是 由x1 and y1构成，终点是有x2 and y2组成，必须满足的是x1 < x2。
         * @param seg2 - {Object} 该对象包含的属性是 x1, y1, x2,和y2。起始点是 由x1 and y1构成，终点是有x2 and y2组成，必须满足的是x1 < x2。
         * @param options - {Object} Optional properties for calculating the intersection.该对象是判断是否计算相交的点。<br>
         *         point - {boolean} 返回相交点。如果设置为false，说明实际的相交点不需要计算出来。如果设置为true,并且这两条线段相交，返回相交的点 。
         *                           如果设置为true，但是两条线段不相交，返回false。如果设置为true，但是两条线段平行，则返回true。<br>
         *         tolerance - {number} 如果设置该值不为空，两条线段在容线的范围内，则会被当作相交。此外，如果point这个属性为true，计算相交的容线距离终点,端点将返回而不是计算相交。
         * @returns {boolean | SuperMap.Geometry.Point} 返回线之间是否相交，如果设置点属性为true的话，会返回相交的点坐标。如果点为true，线重合，将会返回true（相交的等于最短的线）。
         */

    }, {
        key: 'segmentsIntersect',
        value: function segmentsIntersect(seg1, seg2, options) {
            var point = options && options.point;
            var tolerance = options && options.tolerance;
            var intersection = false;
            var x11_21 = seg1.x1 - seg2.x1;
            var y11_21 = seg1.y1 - seg2.y1;
            var x12_11 = seg1.x2 - seg1.x1;
            var y12_11 = seg1.y2 - seg1.y1;
            var y22_21 = seg2.y2 - seg2.y1;
            var x22_21 = seg2.x2 - seg2.x1;
            var d = y22_21 * x12_11 - x22_21 * y12_11;
            var n1 = x22_21 * y11_21 - y22_21 * x11_21;
            var n2 = x12_11 * y11_21 - y12_11 * x11_21;
            if (d == 0) {
                // parallel
                if (n1 == 0 && n2 == 0) {
                    // coincident
                    intersection = true;
                }
            } else {
                var along1 = n1 / d;
                var along2 = n2 / d;
                if (along1 >= 0 && along1 <= 1 && along2 >= 0 && along2 <= 1) {
                    // intersect
                    if (!point) {
                        intersection = true;
                    } else {
                        // calculate the intersection point
                        var x = seg1.x1 + along1 * x12_11;
                        var y = seg1.y1 + along1 * y12_11;
                        intersection = new Geometry.Point(x, y);
                    }
                }
            }
            if (tolerance) {
                var dist;
                if (intersection) {
                    if (point) {
                        var segs = [seg1, seg2];
                        var seg, x, y;
                        // check segment endpoints for proximity to intersection
                        // set intersection to first endpoint within the tolerance
                        outer: for (var i = 0; i < 2; ++i) {
                            seg = segs[i];
                            for (var j = 1; j < 3; ++j) {
                                x = seg["x" + j];
                                y = seg["y" + j];
                                dist = Math.sqrt(Math.pow(x - intersection.x, 2) + Math.pow(y - intersection.y, 2));
                                if (dist < tolerance) {
                                    intersection.x = x;
                                    intersection.y = y;
                                    break outer;
                                }
                            }
                        }
                    }
                } else {
                    // no calculated intersection, but segments could be within
                    // the tolerance of one another
                    var segs = [seg1, seg2];
                    var source, target, x, y, p, result;
                    // check segment endpoints for proximity to intersection
                    // set intersection to first endpoint within the tolerance
                    outer: for (var i = 0; i < 2; ++i) {
                        source = segs[i];
                        target = segs[(i + 1) % 2];
                        for (var j = 1; j < 3; ++j) {
                            p = { x: source["x" + j], y: source["y" + j] };
                            result = Geometry.distanceToSegment(p, target);
                            if (result.distance < tolerance) {
                                if (point) {
                                    intersection = new Geometry.Point(p.x, p.y);
                                } else {
                                    intersection = true;
                                }
                                break outer;
                            }
                        }
                    }
                }
            }
            return intersection;
        }

        /**
         * @function SuperMap.Geometry.distanceToSegment
         * @description 计算点到直线的距离。
         * @param point - {Object} 一个点包含x和y坐标。
         * @param segment - {Object} 一个对象包含 x1, y1, x2, and y2坐标。
         * @example
         *        var point={
         *         x:0,
         *          y:13
         *          } ,
         *            seg1={
         *             x1:6,
         *             y1:5,
         *            x2:6,
         *            y2:12
         *       } ;
         *       var geo=SuperMap.Geometry.distanceToSegment(point,seg1);
         * @returns {Object} 返回的是点到直线的最短距离，以及点与直线最短距离相交的点坐标（x,y）。
         */

    }, {
        key: 'distanceToSegment',
        value: function distanceToSegment(point, segment) {
            var x0 = point.x;
            var y0 = point.y;
            var x1 = segment.x1;
            var y1 = segment.y1;
            var x2 = segment.x2;
            var y2 = segment.y2;
            var dx = x2 - x1;
            var dy = y2 - y1;
            var along = (dx * (x0 - x1) + dy * (y0 - y1)) / (Math.pow(dx, 2) + Math.pow(dy, 2));
            var x, y;
            if (along <= 0.0) {
                x = x1;
                y = y1;
            } else if (along >= 1.0) {
                x = x2;
                y = y2;
            } else {
                x = x1 + along * dx;
                y = y1 + along * dy;
            }
            return {
                distance: Math.sqrt(Math.pow(x - x0, 2) + Math.pow(y - y0, 2)),
                x: x, y: y
            };
        }
    }]);

    return Geometry;
}();

exports.default = Geometry;

_SuperMap2.default.Geometry = Geometry;

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Pixel
 * @classdesc 此类用x,y坐标描绘屏幕坐标（像素点）。
 * @param x - {number} x坐标，默认为0.0
 * @param y - {number} y坐标，默认为0.0
 * @param mode - {string} 坐标模式，默认为{@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
 *
 * @example
 * //单独创建一个对象
 * var pixcel = new SuperMap.Pixel(100,50);
 *
 * //依据size创建
 *  var size = new SuperMap.Size(21,25);
 *  var offset = new SuperMap.Pixel(-(size.w/2), -size.h);
 */
var Pixel = function () {

    /**
     * @member SuperMap.Pixel.prototype.y -{number}
     * @description y坐标，默认为0.0
     */
    function Pixel(x, y, mode) {
        _classCallCheck(this, Pixel);

        this.x = 0.0;
        this.y = 0.0;
        this.mode = null;
        this.CLASS_NAME = "SuperMap.Pixel";

        this.x = x ? parseFloat(x) : this.x;
        this.y = y ? parseFloat(y) : this.y;
        this.mode = mode;
    }

    /**
     * @function SuperMap.Pixel.prototype.toString
     * @description 返回此对象的字符串形式
     * @example
     *
     * var pixcel = new SuperMap.Pixel(100,50);
     * var str = pixcel.toString();
     *
     * @returns {string} 例如: "x=200.4,y=242.2"
     */


    /**
     * @member SuperMap.Pixel.prototype.mode -{SuperMap.Pixel.Mode}
     * @description 坐标模式，有左上、右上、右下、左下这几种模式，分别表示相对于左上角、右上角、右下角、左下角的坐标。<br>
     * 值有<br>
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.RightTop}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.RightBottom}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftBottom}
     *
     * 这四种 默认值为：{@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     *
     * @default {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     */


    /**
     * @member SuperMap.Pixel.prototype.x -{number}
     * @description x坐标，默认为0.0
     */


    _createClass(Pixel, [{
        key: "toString",
        value: function toString() {
            return "x=" + this.x + ",y=" + this.y;
        }

        /**
         * @function SuperMap.Pixel.prototype.clone
         * @description 克隆当前的 pixel 对象。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = pixcel.clone();
         * @returns {SuperMap.Pixel} 返回一个新的与当前 pixel 对象有相同x、y坐标的 pixel 对象。
         */

    }, {
        key: "clone",
        value: function clone() {
            return new Pixel(this.x, this.y, this.mode);
        }

        /**
         * @function SuperMap.Pixel.prototype.equals
         * @description 比较两 pixel 是否相等
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(100,50);
         * var isEquals = pixcel.equals(pixcel2);
         *
         * @param px - {SuperMap.Pixel} 用于比较相等的 pixel 对象。
         * @returns {Boolean} 如果传入的像素点和当前像素点相同返回true,如果不同或传入参数为NULL则返回false
         */

    }, {
        key: "equals",
        value: function equals(px) {
            var equals = false;
            if (px != null) {
                equals = this.x == px.x && this.y == px.y || isNaN(this.x) && isNaN(this.y) && isNaN(px.x) && isNaN(px.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Pixel.prototype.distanceTo
         * @description 返回两个 pixel 的距离。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(110,30);
         * var distance = pixcel.distanceTo(pixcel2);
         *
         * @param px - {SuperMap.Pixel} 用于计算的一个 pixel
         * @returns {float} 作为参数传入的像素与当前像素点的距离。
         */

    }, {
        key: "distanceTo",
        value: function distanceTo(px) {
            return Math.sqrt(Math.pow(this.x - px.x, 2) + Math.pow(this.y - px.y, 2));
        }

        /**
         * @function SuperMap.Pixel.prototype.add
         * @description 在原来像素坐标基础上，x值加上传入的x参数，y值加上传入的y参数。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * //pixcel2是新的对象
         * var pixcel2 = pixcel.add(20,30);
         *
         * @param x - {number} 传入的x值。
         * @param y - {number} 传入的y值。
         * @returns {SuperMap.Pixel} 返回一个新的pixel对象，该pixel是由当前的pixel与传
         *      入的x,y相加得到。
         */

    }, {
        key: "add",
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Pixel.add cannot receive null values');
            }
            return new Pixel(this.x + x, this.y + y);
        }

        /**
         * @function SuperMap.Pixel.prototype.offset
         * @description 通过传入的 {@link SuperMap.Pixel} 参数对原屏幕坐标进行偏移。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * var pixcel2 = new SuperMap.Pixel(130,20);
         * //pixcel3 是新的对象
         * var pixcel3 = pixcel.offset(pixcel2);
         *
         * @param px - {SuperMap.Pixel}  传入的 <SuperMap.Pixel> 对象。
         * @returns {SuperMap.Pixel} 返回一个新的pixel，该pixel是由当前的pixel对象的x，y
         *      值与传入的Pixel对象的x，y值相加得到。
         */

    }, {
        key: "offset",
        value: function offset(px) {
            var newPx = this.clone();
            if (px) {
                newPx = this.add(px.x, px.y);
            }
            return newPx;
        }

        /**
         *
         * @function SuperMap.Pixel.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为null，而不是初始值。
         * @example
         * var pixcel = new SuperMap.Pixel(100,50);
         * pixcel.destroy();
         */

    }, {
        key: "destroy",
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.mode = null;
        }

        /**
         * @member SuperMap.Pixel.Mode
         * @enum {string}
         * @readonly
         * @description 模式
         *
         * * SuperMap.Pixel.Mode.LeftTop 左上模式
         * * SuperMap.Pixel.Mode.RightTop 右上模式
         * * SuperMap.Pixel.Mode.RightBottom 右下模式
         * * SuperMap.Pixel.Mode.LeftBottom 左下模式
         */

    }]);

    return Pixel;
}();

Pixel.Mode = {
    LeftTop: "lefttop",
    RightTop: "righttop",
    RightBottom: "rightbottom",
    LeftBottom: "leftbottom"
};
exports.default = Pixel;

_SuperMap2.default.Pixel = Pixel;

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(13);

var _Collection3 = _interopRequireDefault(_Collection2);

var _LineString = __webpack_require__(18);

var _LineString2 = _interopRequireDefault(_LineString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiLineString
 * @classdesc 几何对象多线类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.LineString>} LineString数组。
 * @example
 * var multi = new SuperMap.Geometry.MultiLineString([
 *      new SuperMap.Geometry.LineString([
 *          new SuperMap.Geometry.Point(1, 0),
 *          new SuperMap.Geometry.Point(0, 1)
 *      ])
 *  ]);
 */
var MultiLineString = function (_Collection) {
    _inherits(MultiLineString, _Collection);

    function MultiLineString(components) {
        _classCallCheck(this, MultiLineString);

        var _this = _possibleConstructorReturn(this, (MultiLineString.__proto__ || Object.getPrototypeOf(MultiLineString)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.LineString"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiLineString";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.MultiLineString.prototype.split
     * @description 用几何对象去分割另一个几何对象。
     * @param geometry - {SuperMap.Geometry} 目标几何对象。
     * @param options - {Object} 可选参数。<br>
     *         mutual - {boolean} Split the source geometry in addition to the target
     *                   geometry.  Default is false.<br>
     *         edge - {boolean} 是否只当与边界相交的时候才进行分割。默认是true。如果为false则在容差范围内相交被分割。
     *         tolerance - {number} 容差。
     * @returns {Array} 被分割的几何对象数组。
     */


    /**
     * @member SuperMap.Geometry.MultiLineString.prototype.componentTypes - {Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.LineString}"]
     */


    _createClass(MultiLineString, [{
        key: 'split',
        value: function split(geometry, options) {
            var results = null;
            var mutual = options && options.mutual;
            var splits, sourceLine, sourceLines, sourceSplit, targetSplit;
            var sourceParts = [];
            var targetParts = [geometry];
            for (var i = 0, len = this.components.length; i < len; ++i) {
                sourceLine = this.components[i];
                sourceSplit = false;
                for (var j = 0; j < targetParts.length; ++j) {
                    splits = sourceLine.split(targetParts[j], options);
                    if (splits) {
                        if (mutual) {
                            sourceLines = splits[0];
                            for (var k = 0, klen = sourceLines.length; k < klen; ++k) {
                                if (k === 0 && sourceParts.length) {
                                    sourceParts[sourceParts.length - 1].addComponent(sourceLines[k]);
                                } else {
                                    sourceParts.push(new MultiLineString([sourceLines[k]]));
                                }
                            }
                            sourceSplit = true;
                            splits = splits[1];
                        }
                        if (splits.length) {
                            // splice in new target parts
                            splits.unshift(j, 1);
                            Array.prototype.splice.apply(targetParts, splits);
                            break;
                        }
                    }
                }
                if (!sourceSplit) {
                    // source line was not hit
                    if (sourceParts.length) {
                        // add line to existing multi
                        sourceParts[sourceParts.length - 1].addComponent(sourceLine.clone());
                    } else {
                        // create a fresh multi
                        sourceParts = [new MultiLineString(sourceLine.clone())];
                    }
                }
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceSplit || targetSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }

        /**
         * @function SuperMap.Geometry.MultiLineString.prototype.splitWith
         * @description 用几何对象去分割另一个几何对象。
         * @param geometry - {SuperMap.Geometry} 目标几何对象。
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} Split the source geometry in addition to the target
         *                   geometry.  Default is false.<br>
         *         edge - {boolean} 是否只当与边界相交的时候才进行分割。默认是true。如果为false则在容差范围内相交被分割。
         *         tolerance - {number} 容差。
         * @returns {Array} 被分割的几何对象数组。
         */

    }, {
        key: 'splitWith',
        value: function splitWith(geometry, options) {
            var results = null;
            var mutual = options && options.mutual;
            var splits, targetLine, sourceLines, sourceSplit, targetSplit, sourceParts, targetParts;
            if (geometry instanceof _LineString2.default) {
                targetParts = [];
                sourceParts = [geometry];
                for (var i = 0, len = this.components.length; i < len; ++i) {
                    targetSplit = false;
                    targetLine = this.components[i];
                    for (var j = 0; j < sourceParts.length; ++j) {
                        splits = sourceParts[j].split(targetLine, options);
                        if (splits) {
                            if (mutual) {
                                sourceLines = splits[0];
                                if (sourceLines.length) {
                                    // splice in new source parts
                                    sourceLines.unshift(j, 1);
                                    Array.prototype.splice.apply(sourceParts, sourceLines);
                                    j += sourceLines.length - 2;
                                }
                                splits = splits[1];
                                if (splits.length === 0) {
                                    splits = [targetLine.clone()];
                                }
                            }
                            for (var k = 0, klen = splits.length; k < klen; ++k) {
                                if (k === 0 && targetParts.length) {
                                    targetParts[targetParts.length - 1].addComponent(splits[k]);
                                } else {
                                    targetParts.push(new MultiLineString([splits[k]]));
                                }
                            }
                            targetSplit = true;
                        }
                    }
                    if (!targetSplit) {
                        // target component was not hit
                        if (targetParts.length) {
                            // add it to any existing multi-line
                            targetParts[targetParts.length - 1].addComponent(targetLine.clone());
                        } else {
                            // or start with a fresh multi-line
                            targetParts = [new MultiLineString([targetLine.clone()])];
                        }
                    }
                }
            } else {
                results = geometry.split(this);
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceSplit || targetSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }
    }]);

    return MultiLineString;
}(_Collection3.default);

exports.default = MultiLineString;

_SuperMap2.default.Geometry.MultiLineString = MultiLineString;

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(13);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiPolygon
 * @classdesc 几何对象多多边形类。
 * @extends {SuperMap.Geometry.Collection}
 * @param  components - {Array<SuperMap.Geometry.Polygon>} 形成 MultiPolygon 的多边形数组。
 * @example
 * var points1 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0)];
 * var points2 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0),new SuperMap.Geometry.Point(3,3),new SuperMap.Geometry.Point(10,10)];
 *
 * var linearRing1 = new SuperMap.Geometry.LinearRing(points1);
 * var linearRing2 = new SuperMap.Geometry.LinearRing(points2);
 *
 * var polygon1 = new SuperMap.Geometry.Polygon([linearRing1]);
 * var polygon2 = new SuperMap.Geometry.Polygon([linearRing2]);
 *
 * var multiPolygon1 = new SuperMap.Geometry.MultiPolygon([polygon1,polygon2]);
 */
var MultiPolygon = function (_Collection) {
    _inherits(MultiPolygon, _Collection);

    function MultiPolygon(components) {
        _classCallCheck(this, MultiPolygon);

        var _this = _possibleConstructorReturn(this, (MultiPolygon.__proto__ || Object.getPrototypeOf(MultiPolygon)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.Polygon"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiPolygon";
        return _this;
    }

    /**
     * @member SuperMap.Geometry.MultiPolygon.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Polygon}"]
     */


    return MultiPolygon;
}(_Collection3.default);

exports.default = MultiPolygon;

_SuperMap2.default.Geometry.MultiPolygon = MultiPolygon;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Format
 * @classdesc 读写各种格式的格式类基类。其子类应该包含并实现read和write方法。
 * @param options - {Object} 可选参数。<br>
 *        keepData - {boolean} 如果设置为true， data属性会指向被解析的对象（例如json或xml数据对象）。
 */
var Format = function () {

    /**
     * @member SuperMap.Format.prototype.data - {Object}
     * @description 当 <keepData> 属性设置为true，这是传递给<read>操作的要被解析的字符串。
     */
    function Format(options) {
        _classCallCheck(this, Format);

        this.options = null;
        this.data = null;
        this.keepData = false;
        this.CLASS_NAME = "SuperMap.Format";

        _SuperMap2.default.Util.extend(this, options);
        this.options = options;
    }

    /**
     * @function SuperMap.Format.prototype.destroy
     * @description 销毁该格式类，释放相关资源。
     */


    /**
     * APIProperty: keepData
     * @member SuperMap.Format.prototype.keepData - {Object}
     * @description 保持最近读到的数据的引用（通过 <data> 属性）。默认值是false。
     */


    /**
     * @member SuperMap.Format.prototype.options - {Object}
     * @description 可选参数。
     */


    _createClass(Format, [{
        key: "destroy",
        value: function destroy() {}
        //用来销毁该格式类，释放相关资源


        /**
         * @function SuperMap.Format.prototype.read
         * @description 来从字符串中读取数据。
         * @param data - {string} 读取的数据。
         */

    }, {
        key: "read",
        value: function read(data) {}
        //用来从字符串中读取数据


        /**
         * @function SuperMap.Format.prototype.write
         * @description 将对象写成字符串。
         * @param object - {Object} 可序列化的对象。
         * @return {string} 对象被写成字符串。
         */

    }, {
        key: "write",
        value: function write(object) {
            //用来写字符串
        }
    }]);

    return Format;
}();

exports.default = Format;

_SuperMap2.default.Format = Format;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _BufferSetting = __webpack_require__(144);

var _BufferSetting2 = _interopRequireDefault(_BufferSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.BufferAnalystParameters
 * @classdesc 缓冲区分析参数基类。
 * @param options - {Object} 参数。如:</br>
 *        bufferSetting - {@link SuperMap.BufferSetting} 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
 */
var BufferAnalystParameters = function () {
    function BufferAnalystParameters(options) {
        _classCallCheck(this, BufferAnalystParameters);

        this.bufferSetting = null;
        this.CLASS_NAME = "SuperMap.BufferAnalystParameters";

        var me = this;
        me.bufferSetting = new _BufferSetting2.default();
        if (!options) {
            return;
        }
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     * @function SuperMap.BufferAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */

    /**
     * @member SuperMap.BufferAnalystParameters.prototype.bufferSetting - {SuperMap.BufferSetting}
     * @description 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
     */


    _createClass(BufferAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.bufferSetting) {
                me.bufferSetting.destroy();
                me.bufferSetting = null;
            }
        }
    }]);

    return BufferAnalystParameters;
}();

exports.default = BufferAnalystParameters;

_SuperMap2.default.BufferAnalystParameters = BufferAnalystParameters;

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.OverlayAnalystParameters
 * @classdesc 叠加分析参数基类，数据集叠加分析参数和几何对象叠加分析参数均继承此基类
 * @param options - {Object} 叠加分析参数。
 */
var OverlayAnalystParameters = function () {
    function OverlayAnalystParameters(options) {
        _classCallCheck(this, OverlayAnalystParameters);

        this.operation = _REST.OverlayOperationType.UNION;
        this.CLASS_NAME = "SuperMap.OverlayAnalystParameters";

        var me = this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
    }

    /**
     * @function SuperMap.OverlayAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.OverlayAnalystParameters.prototype.operation -{SuperMap.OverlayOperationType}
     * @description 指定叠加分析操作类型。
     */


    _createClass(OverlayAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.operation = null;
        }
    }]);

    return OverlayAnalystParameters;
}();

exports.default = OverlayAnalystParameters;

_SuperMap2.default.OverlayAnalystParameters = OverlayAnalystParameters;

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _DataReturnOption = __webpack_require__(19);

var _DataReturnOption2 = _interopRequireDefault(_DataReturnOption);

var _REST = __webpack_require__(1);

var _SurfaceAnalystParametersSetting = __webpack_require__(219);

var _SurfaceAnalystParametersSetting2 = _interopRequireDefault(_SurfaceAnalystParametersSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.SurfaceAnalystParameters
 * @classdesc 表面分析提取操作参数类。
 * @description 通过该类可以为进行表面分析提供参数信息，包括表面分析的方法提取等值线、提取等值面和中间结果的分辨率，
 * {@link SuperMap.DatasetSurfaceAnalystParameters} 和 {@link SuperMap.GeometrySurfaceAnalystParameters} 继承自该类。
 * @param options - {Object} 可选参数。如:</br>
 *        extractParameter - {{@link SuperMap.SurfaceAnalystParametersSetting}} 获取或设置表面分析参数。</br>
 *        resolution - {number}指定中间结果（栅格数据集）的分辨率。</br>
 *        resultSetting - {{@link SuperMap.DataReturnOption}} 结果返回设置类。</br>
 *        surfaceAnalystMethod - {{@link SuperMap.SurfaceAnalystMethod}} 获取或设置表面分析的提取方法，提取等值线和提取等值面。</br>
 */
var SurfaceAnalystParameters = function () {

    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.resultSetting -{SuperMap.DataReturnOption}
     * @description 结果返回设置类。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.resolution -{number}
     * @description 获取或设置指定中间结果（栅格数据集）的分辨率。
     */
    function SurfaceAnalystParameters(options) {
        _classCallCheck(this, SurfaceAnalystParameters);

        this.resolution = 0;
        this.extractParameter = null;
        this.resultSetting = null;
        this.surfaceAnalystMethod = _REST.SurfaceAnalystMethod.ISOLINE;
        this.CLASS_NAME = "SuperMap.SurfaceAnalystParameters";

        var me = this;
        me.extractParameter = new _SurfaceAnalystParametersSetting2.default();
        me.resultSetting = new _DataReturnOption2.default();
        if (options) {
            _SuperMap2.default.Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.SurfaceAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.surfaceAnalystMethod -{SuperMap.SurfaceAnalystMethod}
     * @description 获取或设置表面分析的提取方法，提取等值线和提取等值面，默认为等值线分析。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.extractParameter -{SuperMap.SurfaceAnalystParametersSetting}
     * @description 获取或设置表面分析参数。
     * 在进行点数据集进行提取等值面分析时，暂时不支持 SurfaceAnalystParametersSetting 类中的 expectedZValues 字段。
     */


    _createClass(SurfaceAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.resolution = null;
            if (me.extractParameter) {
                me.extractParameter.destroy();
                me.extractParameter = null;
            }
            if (me.resultSetting) {
                me.resultSetting.destroy();
                me.resultSetting = null;
            }
            me.surfaceAnalystMethod = null;
        }
    }]);

    return SurfaceAnalystParameters;
}();

exports.default = SurfaceAnalystParameters;

_SuperMap2.default.SurfaceAnalystParameters = SurfaceAnalystParameters;

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ServerStyle = __webpack_require__(6);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeDotDensity
 * @classdesc 点密度专题图。<br>
 * @description
 *              点密度专题图用一定大小、形状相同的点表示现象分布范围、数量特征和分布密度。点的多少和所代表的意义由地图的内容确定。<br>
 *              点密度专题图利用图层的某一数值属性信息（专题值）映射为不同等级，每一级别使用不同数量或表现为密度的点符号来表示。<br>
 *              该专题值在各个分区内的分布情况，体现不同区域的相对数量差异。多用于具有数量特征的地图上，<br>
 *              比如表示不同地区的粮食产量、GDP、人口等的分级，主要针对区域或面状的要素，因而，点密度专题图适用于面数据集。<br>
 *              注意：点密度专题图中点的分布是随机的，并不代表实际的分布位置。即使在相关设置完全相同的情况下，<br>
 *              每次制作出的专题图，点的数量相同，但点的位置都有差异。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        dotExpression - {string} 创建点密度专题图的字段或字段表达式。<br>
 *        style - {{@link SuperMap.ServerStyle}} 点密度专题图中点的风格。<br>
 *        value - {string} 专题图中每一个点所代表的数值。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeDotDensity = function (_Theme) {
    _inherits(ThemeDotDensity, _Theme);

    /**
     * @member SuperMap.ThemeDotDensity.prototype.style -{SuperMap.ServerStyle}
     * @description 点密度专题图中点的风格。
     */
    function ThemeDotDensity(options) {
        _classCallCheck(this, ThemeDotDensity);

        var _this = _possibleConstructorReturn(this, (ThemeDotDensity.__proto__ || Object.getPrototypeOf(ThemeDotDensity)).call(this, "DOTDENSITY", options));

        _this.dotExpression = null;
        _this.style = null;
        _this.value = null;
        _this.CLASS_NAME = "SuperMap.ThemeDotDensity";

        var me = _this;
        me.style = new _ServerStyle2.default();
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeDotDensity.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeDotDensity.prototype.value -{number}
     * @description 专题图中每一个点所代表的数值。<br>
     *              点值的确定与地图比例尺以及点的大小有关。地图比例尺越大，相应的图面范围也越大，<br>
     *              点相应就可以越多，此时点值就可以设置相对小一些。点形状越大，<br>
     *              点值相应就应该设置的小一些。点值过大或过小都是不合适的。
     */


    /**
     * @member SuperMap.ThemeDotDensity.prototype.dotExpression -{string}
     * @description 创建点密度专题图的字段或字段表达式。点的数目或密集程度的来源。
     */


    _createClass(ThemeDotDensity, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.dotExpression = null;
            me.value = null;

            if (me.style) {
                me.style.destroy();
                me.style = null;
            }
        }

        /**
         * @function SuperMap.ThemeDotDensity.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj = _SuperMap2.default.Util.copyAttributes(obj, this);
            if (obj.style) {
                if (obj.style.toServerJSONObject) {
                    obj.style = obj.style.toServerJSONObject();
                }
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeDotDensity.fromObj
         * @description 从传入对象获取点密度专题图中点的风格。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeDotDensity} ThemeDotDensity对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeDotDensity();
            _SuperMap2.default.Util.copy(res, obj);
            res.style = _ServerStyle2.default.fromJson(obj.style);
            return res;
        }
    }]);

    return ThemeDotDensity;
}(_Theme3.default);

exports.default = ThemeDotDensity;


_SuperMap2.default.ThemeDotDensity = ThemeDotDensity;

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeFlow = __webpack_require__(35);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(37);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeGraduatedSymbolStyle = __webpack_require__(221);

var _ThemeGraduatedSymbolStyle2 = _interopRequireDefault(_ThemeGraduatedSymbolStyle);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeGraduatedSymbol
 * @classdesc 等级符号专题图。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        baseValue - {number}等级符号专题图的基准值，单位同专题变量的单位。<br>
 *        expression - {string} 等级符号专题图的字段或字段表达式。<br>
 *        flow - {{@link SuperMap.ThemeFlow}} 等级符号专题图符号流动显示与牵引线设置类。<br>
 *        graduatedMode - {{@link SuperMap.GraduatedMode}} 等级符号专题图分级模式。<br>
 *        offset - {{@link SuperMap.ThemeOffset}} 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。<br>
 *        style - {{@link SuperMap.ThemeGraduatedSymbolStyle}} 用于设置等级符号图正负和零值显示风格。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeGraduatedSymbol = function (_Theme) {
    _inherits(ThemeGraduatedSymbol, _Theme);

    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置等级符号图相对于要素内点的偏移量。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.flow -{SuperMap.ThemeFlow}
     * @description 等级符号专题图符号流动显示与牵引线设置类。<br>
     *              通过该字段可以设置等级符号是否流动显示和牵引线风格。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.baseValue -{number}
     * @description 等级符号专题图的基准值，单位同专题变量的单位。<br>
     *              依据此值系统会自动根据分级方式计算其余值对应的符号大小，每个符号的显示大小等于<br>
     *              ThemeValueSection.positiveStyle（或 zeroStyle，negativeStyle）.markerSize * value / basevalue，<br>
     *              其中 value 是 expression 所指定字段对应的值经过分级计算之后的值。默认值为0，建议通过多次尝试设置该值才能达到较好的显示效果。
     */
    function ThemeGraduatedSymbol(options) {
        _classCallCheck(this, ThemeGraduatedSymbol);

        var _this = _possibleConstructorReturn(this, (ThemeGraduatedSymbol.__proto__ || Object.getPrototypeOf(ThemeGraduatedSymbol)).call(this, "GRADUATEDSYMBOL", options));

        _this.baseValue = 0;
        _this.expression = null;
        _this.flow = null;
        _this.graduatedMode = _REST.GraduatedMode.CONSTANT;
        _this.offset = null;
        _this.style = null;
        _this.CLASS_NAME = "SuperMap.ThemeGraduatedSymbol";

        var me = _this;
        me.flow = new _ThemeFlow2.default();
        me.offset = new _ThemeOffset2.default();
        me.style = new _ThemeGraduatedSymbolStyle2.default();
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeGraduatedSymbol.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.style -{SuperMap.ThemeGraduatedSymbolStyle}
     * @description 用于设置等级符号图正负和零值显示风格。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.graduatedMode -{SuperMap.GraduatedMode}
     * @description 等级符号专题图分级模式。<br>
     *              分级主要是为了减少制作等级符号专题图中数据大小之间的差异。如果数据之间差距较大，则可以采用对数或者平方根的分级方式来进行，<br>
     *              这样就减少了数据之间的绝对大小的差异，使得等级符号图的视觉效果比较好，同时不同类别之间的比较也是有意义的。<br>
     *              有三种分级模式：常数、对数和平方根，对于有值为负数的字段，在用对数或平方根方式分级时，默认对负数取正。<br>
     *              不同的分级模式用于确定符号大小的数值是不相同的：常数按照字段的原始数据进行；对数则是对每条记录对应的专题变量取自然对数；<br>
     *              平方根则是对其取平方根，然后用最终得到的结果来确定其等级符号的大小。<br>
     *              默认值为 SuperMap.GraduatedMode.CONSTANT。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.expression -{string}
     * @description 用于创建等级符号专题图的字段或字段表达式，字段或字段表达式应为数值型。必设字段。
     */


    _createClass(ThemeGraduatedSymbol, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeGraduatedSymbol.prototype.__proto__ || Object.getPrototypeOf(ThemeGraduatedSymbol.prototype), 'destroy', this).call(this);
            var me = this;
            me.expression = null;
            if (me.flow) {
                me.flow.destroy();
                me.flow = null;
            }
            me.graduatedMode = _REST.GraduatedMode.CONSTANT;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            if (me.style) {
                me.style.destroy();
                me.style = null;
            }
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.prototype.toJSON
         * @description 将themeLabel对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2.default.Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            obj.memoryData = this.memoryData;
            obj.baseValue = this.baseValue;
            obj.expression = this.expression;
            obj.graduatedMode = this.graduatedMode;
            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }
            if (this.style) {
                obj.negativeStyle = this.style.negativeStyle;
                obj.negativeDisplayed = this.style.negativeDisplayed;
                obj.positiveStyle = this.style.positiveStyle;
                obj.zeroDisplayed = this.style.zeroDisplayed;
                obj.zeroStyle = this.style.zeroStyle;
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.fromObj
         * @description 从传入对象获取等级符号专题图。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeGraduatedSymbol} 等级符号专题图对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new _SuperMap2.default.ThemeGraduatedSymbol();
            _SuperMap2.default.Util.copy(res, obj);
            res.flow = _ThemeFlow2.default.fromObj(obj);
            res.offset = _ThemeOffset2.default.fromObj(obj);
            res.style = _ThemeGraduatedSymbolStyle2.default.fromObj(obj);
            return res;
        }
    }]);

    return ThemeGraduatedSymbol;
}(_Theme3.default);

exports.default = ThemeGraduatedSymbol;


_SuperMap2.default.ThemeGraduatedSymbol = ThemeGraduatedSymbol;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeFlow = __webpack_require__(35);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(37);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeGraphAxes = __webpack_require__(222);

var _ThemeGraphAxes2 = _interopRequireDefault(_ThemeGraphAxes);

var _ThemeGraphSize = __webpack_require__(224);

var _ThemeGraphSize2 = _interopRequireDefault(_ThemeGraphSize);

var _ThemeGraphText = __webpack_require__(225);

var _ThemeGraphText2 = _interopRequireDefault(_ThemeGraphText);

var _ThemeGraphItem = __webpack_require__(223);

var _ThemeGraphItem2 = _interopRequireDefault(_ThemeGraphItem);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeGraph
 * @classdesc 统计专题图类。
 * @extends SuperMap.Theme
 * @param options - {Object} 参数。<br>
 *        barWidth - {number}柱状专题图中每一个柱的宽度。<br>
 *        flow - {SuperMap.ThemeFlow} 统计专题图流动显示与牵引线设置。<br>
 *        graduatedMode - {{@link SuperMap.GraduatedMode}} 统计图中地理要素的值与图表尺寸间的映射关系。<br>
 *        graphAxes - {{@link SuperMap.ThemeGraphAxes}} 统计图中坐标轴样式相关信息。<br>
 *        graphSize - {{@link SuperMap.ThemeGraphSize}} 统计符号的最大最小尺寸。<br>
 *        graphSizeFixed - {boolean} 缩放地图时统计图符号是否固定大小。<br>
 *        graphText - {{@link SuperMap.ThemeGraphText}} 统计图上的文字是否可以见以及文字标注风格。<br>
 *        graphAxesTextDisplayMode -{{@link SuperMap.GraphAxesTextDisplayMode}} 统计专题图坐标轴文本显示模式 。默认值 SuperMap.GraphAxesTextDisplayMode.NONE。
 *        graphType - {{@link SuperMap.ThemeGraphType}} 统计专题图类型。<br>
 *        items - {Array<{@link SuperMap.ThemeGraphItem}>} 统计专题图子项集合。<br>
 *        memoryKeys - {Array<integer>} 以内存数组方式制作专题图时的键数组。<br>
 *        negativeDisplayed - {boolean} 专题图中是否显示属性为负值的数据。<br>
 *        offset - {{@link SuperMap.ThemeOffset}} 统计图相对于要素内点的偏移量。<br>
 *        overlapAvoided - {boolean} 统计图是否采用避让方式显示。<br>
 *        roseAngle - {number}统计图中玫瑰图或三维玫瑰图用于等分的角度。<br>
 *        startAngle - {number}饼状统计图扇形的起始角度。
 */
var ThemeGraph = function (_Theme) {
    _inherits(ThemeGraph, _Theme);

    /**
     * @member SuperMap.ThemeGraph.prototype.roseAngle -{number}
     * @description 统计图中玫瑰图或三维玫瑰图用于等分的角度，默认为0度，精确到0.1度。在角度为0或者大于360度的情况下均使用360度来等分制作统计图的字段数。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置统计图相对于要素内点的偏移量。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.memoryKeys -{Array<integer>}
     * @description 以内存数组方式制作专题图时的键数组。<br>
     *              键数组内的数值代表 SmID 值，它与 SuperMap.ThemeGraphItem 类中的值数组（SuperMap.ThemeGraphItem.memoryDoubleValues）要关联起来应用。<br>
     *              键数组中数值的个数必须要与值数组的数值个数一致。值数组中的值将代替原来的专题值来制作统计专题图。<br>
     *              目前所有的专题图都支持以内存数组的方式制作专题图，但统计专题图与其他专题图指定内存数组的方式不同，<br>
     *              统计专题图使用 memoryKeys 指定内存数组，而其他专题图则使用 memoryData 来指定内存数组。
     * @example
     *  memoryKeys的使用方法如：
     *   function addThemeGraph() {
     *      removeTheme();
     *        //创建统计专题图对象，SuperMap.ThemeGraph 必设 items。
     *       //专题图参数 ThemeParameters 必设 theme（即以设置好的分段专题图对象）、dataSourceName 和 datasetName
     *      var style1 = new SuperMap.ServerStyle({
     *                   fillForeColor: new SuperMap.ServerColor(92,73,234),
     *                   lineWidth: 0.1
     *               }),
     *               style2 = new SuperMap.ServerStyle({
     *                   fillForeColor: new SuperMap.ServerColor(211,111,240),
     *                   lineWidth: 0.1
     *               }),
     *               item1 = new SuperMap.ThemeGraphItem({
     *                   memoryDoubleValues:[1.18,0.95,0.37,1.31,0.8,1.5],
     *                  caption: "1992-1995人口增长率",
     *                  graphExpression: "Pop_Rate95",
     *                   uniformStyle: style1
     *               }),
     *               item2 = new SuperMap.ThemeGraphItem({
     *               //以内存数组方式制作专题图时的值数组
     *                   memoryDoubleValues:[2.71,0,0.74,3.1,2.2,3.5],
     *                   caption: "1995-1999人口增长率",  //专题图子项的名称
     *                   graphExpression: "Pop_Rate99",  //统计专题图的专题变量
     *                   uniformStyle: style2      //统计专题图子项的显示风格
     *               }),
     *               themeGraph  = new SuperMap.ThemeGraph({
     *               //以内存数组方式制作专题图时的键数组，键数组内的数值代表 SmID 值
     *                    memoryKeys:[1,2,4,8,10,12],
     *                   items: new Array(item1,item2),
     *                   barWidth: 0.03,
     *                    //统计图中地理要素的值与图表尺寸间的映射关系为平方根
     *                   graduatedMode: SuperMap.GraduatedMode.SQUAREROOT,
     *                   //graphAxes用于设置统计图中坐标轴样式相关信息
     *                   graphAxes: new SuperMap.ThemeGraphAxes({
     *                       axesDisplayed: true
     *                   }),
     *                   graphSize: new SuperMap.ThemeGraphSize({
     *                       maxGraphSize: 1,
     *                       minGraphSize: 0.35
     *                   }),
     *                   //统计图上的文字是否可以见以及文字标注风格
     *                   graphText: new SuperMap.ThemeGraphText({
     *                       graphTextDisplayed: true,
     *                       graphTextFormat: SuperMap.ThemeGraphTextFormat.VALUE,
     *                       graphTextStyle: new SuperMap.ServerTextStyle({
     *                           sizeFixed: true,
     *                           fontHeight: 9,
     *                           fontWidth: 5
     *                       })
     *                   }),
     *                   //统计专题图类型为三维柱状图
     *                   graphType: SuperMap.ThemeGraphType.BAR3D
     *               }),
     * //专题图参数对象
     *               themeParameters = new SuperMap.ThemeParameters({
     *                   themes: [themeGraph],
     *                   dataSourceNames: ["Jingjin"],
     *                   datasetNames: ["BaseMap_R"]
     *               }),
     *    //与服务端交互
     *               themeService=new SuperMap.ThemeService(url, {
     *                   eventListeners: {
     *                       "processCompleted": ThemeCompleted,
     *                        "processFailed": themeFailed
     *                  }
     *              });
     *       themeService.processAsync(themeParameters);
     *   }
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphAxesTextDisplayMode -{SuperMap.GraphAxesTextDisplayMode}
     * @description 统计专题图坐标轴文本显示模式 。默认值 SuperMap.GraphAxesTextDisplayMode.NONE。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphText -{SuperMap.ThemeGraphText}
     * @description 统计图上的文字是否可以见以及文字标注风格。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphSize -{SuperMap.ThemeGraphSize}
     * @description 用于设置统计符号的最大最小尺寸。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graduatedMode -{SuperMap.GraduatedMode}
     * @description 统计图中地理要素的值与图表尺寸间的映射关系（常数、对数、平方根），即分级方式。
     *              默认值为 SuperMap.GraduatedMode.CONSTANT。
     *              分级主要是为了减少制作统计专题图中数据大小之间的差异，使得统计图的视觉效果比较好，同时不同类别之间的比较也还是有意义的。
     *              提供三种分级模式：常数、对数和平方根，对于有值为负数的字段，不可以采用对数和平方根的分级方式。不同的等级方式用于确定符号大小的数值是不相同的。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.barWidth -{number}
     * @description 柱状专题图中每一个柱的宽度。使用地图坐标单位，默认值为0。<br>
     *              只有选择的统计图类型为柱状图（柱状图、三维柱状图、堆叠柱状图、三维堆叠柱状图）时，此项才可设置。
     */
    function ThemeGraph(options) {
        _classCallCheck(this, ThemeGraph);

        var _this = _possibleConstructorReturn(this, (ThemeGraph.__proto__ || Object.getPrototypeOf(ThemeGraph)).call(this, "GRAPH", options));

        _this.barWidth = 0;
        _this.flow = null;
        _this.graduatedMode = _REST.GraduatedMode.CONSTANT;
        _this.graphAxes = null;
        _this.graphSize = null;
        _this.graphSizeFixed = false;
        _this.graphText = null;
        _this.graphType = _REST.ThemeGraphType.AREA;
        _this.graphAxesTextDisplayMode = _REST.GraphAxesTextDisplayMode.NONE;
        _this.items = null;
        _this.memoryKeys = null;
        _this.negativeDisplayed = false;
        _this.offset = null;
        _this.overlapAvoided = true;
        _this.roseAngle = 0;
        _this.startAngle = 0;
        _this.CLASS_NAME = "SuperMap.ThemeGraph";

        var me = _this;
        me.flow = new _ThemeFlow2.default();
        me.graphAxes = new _ThemeGraphAxes2.default();
        me.graphSize = new _ThemeGraphSize2.default();
        me.graphText = new _ThemeGraphText2.default();
        me.offset = new _ThemeOffset2.default();
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeGraph.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.startAngle -{number}
     * @description 饼状统计图扇形的起始角度。默认为0度，精确到0.1度，以水平方向为正向。只有选择的统计图类型为饼状图（饼图、三维饼图、玫瑰图、三维玫瑰图）时，此项才可设置。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.overlapAvoided -{boolean}
     * @description 统计图是否采用避让方式显示。<br>
     *              1.对数据集制作统计专题图:当统计图采用避让方式显示时，如果 overlapAvoided 为 true，则在统计图重叠度很大的情况下，
     *              会出现无法完全避免统计图重叠的现象；如果 overlapAvoided 为 false，会过滤掉一些统计图，从而保证所有的统计图均不重叠。<br>
     *              2.对数据集同时制作统计专题图和标签专题图：当统计图不显示子项文本时，标签专题图的标签即使和统计图重叠，两者也都可正常显示；
     *              当统计图显示子项文本时，如果统计图中的子项文本和标签专题图中的标签不重叠，则两者均正常显示；如果重叠，则会过滤掉统计图的子项文本，只显示标签。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.negativeDisplayed -{boolean}
     * @description 专题图中是否显示属性为负值的数据。true 表示显示；默认为 false 即不显示。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.items -{Array<SuperMap.ThemeGraphItem>}
     * @description 统计专题图子项集合。必设字段。
     *              统计专题图可以基于多个变量，反映多种属性，即可以将多个专题变量的值绘制在一个统计图上。每一个专题变量对应的统计图即为一个专题图子项。
     *              对于每个专题图子项可以为其设置标题、风格，甚至可以将该子项再制作成范围分段专题图。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphType -{SuperMap.ThemeGraphType}
     * @description 统计专题图类型。SuperMap 提供了多种类型的统计图，<br>
     *              分别为面积图、阶梯图、折线图、点状图、柱状图、三维柱状图、饼图、三维饼图、玫瑰图、三维玫瑰图、堆叠柱状图、三维堆叠柱状图、环状图。默认为面积图。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphSizeFixed -{boolean}
     * @description 缩放地图时统计图符号是否固定大小。默认值为 false，即统计图符号将随地图缩放。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphAxes -{SuperMap.ThemeGraphAxes}
     * @description 用于设置统计图中坐标轴样式相关信息，如坐标轴颜色、是否显示、坐标文本样式等。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.flow -{SuperMap.ThemeFlow}
     * @description 统计专题图流动显示与牵引线设置。
     *              通过该字段可以设置统计符号是否流动显示和牵引线风格。
     */


    _createClass(ThemeGraph, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeGraph.prototype.__proto__ || Object.getPrototypeOf(ThemeGraph.prototype), 'destroy', this).call(this);
            var me = this;
            me.barWidth = null;
            if (me.flow) {
                me.flow.destroy();
                me.flow = null;
            }
            me.graduatedMode = null;
            if (me.graphAxes) {
                me.graphAxes.destroy();
                me.graphAxes = null;
            }
            if (me.graphSize) {
                me.graphSize.destroy();
                me.graphSize = null;
            }
            me.graphSizeFixed = null;
            if (me.graphText) {
                me.graphText.destroy();
                me.graphText = null;
            }
            me.graphType = null;
            if (me.items) {
                for (var i = 0, items = me.items, len = items.length; i < len; i++) {
                    items[i].destroy();
                }
                me.items = null;
            }
            me.memoryKeys = null;
            me.negativeDisplayed = null;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            me.overlapAvoided = null;
            me.roseAngle = null;
            me.startAngle = null;
            me.graphAxesTextDisplayMode = null;
        }

        /**
         * @function SuperMap.ThemeGraph.prototype.toJSON
         * @description 将SuperMap.ThemeGraph对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2.default.Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeGraph.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            if (this.graphText) {
                obj.graphTextDisplayed = this.graphText.graphTextDisplayed;
                obj.graphTextFormat = this.graphText.graphTextFormat;
                obj.graphTextStyle = this.graphText.graphTextStyle;
            }
            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.graphAxes) {
                obj.axesColor = this.graphAxes.axesColor;
                obj.axesDisplayed = this.graphAxes.axesDisplayed;
                obj.axesGridDisplayed = this.graphAxes.axesGridDisplayed;
                obj.axesTextDisplayed = this.graphAxes.axesTextDisplayed;
                obj.axesTextStyle = this.graphAxes.axesTextStyle;
            }
            if (this.graphSize) {
                obj.maxGraphSize = this.graphSize.maxGraphSize;
                obj.minGraphSize = this.graphSize.minGraphSize;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }
            obj.barWidth = this.barWidth;
            obj.graduatedMode = this.graduatedMode;
            obj.graphSizeFixed = this.graphSizeFixed;
            obj.graphType = this.graphType;
            obj.graphAxesTextDisplayMode = this.graphAxesTextDisplayMode;
            obj.items = this.items;
            obj.memoryKeys = this.memoryKeys;
            obj.negativeDisplayed = this.negativeDisplayed;
            obj.overlapAvoided = this.overlapAvoided;
            obj.roseAngle = this.roseAngle;
            obj.startAngle = this.startAngle;
            return obj;
        }

        /**
         * @function SuperMap.ThemeGraph.fromObj
         * @description 从传入对象获取统计专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeGraph} ThemeGraph对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ThemeGraph();
            var itemsG = obj.items;
            var len = itemsG ? itemsG.length : 0;
            _SuperMap2.default.Util.copy(res, obj);
            res.items = [];
            res.flow = _ThemeFlow2.default.fromObj(obj);
            res.graphAxes = _ThemeGraphAxes2.default.fromObj(obj);
            res.graphSize = _ThemeGraphSize2.default.fromObj(obj);
            res.graphText = _ThemeGraphText2.default.fromObj(obj);
            res.offset = _ThemeOffset2.default.fromObj(obj);
            for (var i = 0; i < len; i++) {
                res.items.push(_ThemeGraphItem2.default.fromObj(itemsG[i]));
            }
            return res;
        }
    }]);

    return ThemeGraph;
}(_Theme3.default);

exports.default = ThemeGraph;


_SuperMap2.default.ThemeGraph = ThemeGraph;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeRangeItem = __webpack_require__(237);

var _ThemeRangeItem2 = _interopRequireDefault(_ThemeRangeItem);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeRange
 * @classdesc 范围分段专题图。
 * @description 范围分段专题图是按照指定的分段方法（如：等距离分段法）对字段的属性值进行分段，使用不同的颜色或符号（线型、填充）表示不同范围段落的属性值在整体上的分布情况，体现区域的差异。
 *              在分段专题图中，专题值按照某种分段方式被分成多个范围段，要素根据各自的专题值被分配到其中一个范围段中，在同一个范围段中的要素使用相同的颜色，填充，符号等风格进行显示。
 *              分段专题图所基于的专题变量必须为数值型，分段专题图一般用来反映连续分布现象的数量或程度特征，如降水量的分布，土壤侵蚀强度的分布等。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        items - {Array<{@link SuperMap.ThemeRangeItem}>} 分段专题图子项数组。<br>
 *        rangeExpression - {string} 分段字段表达式。<br>
 *        rangeMode - {{@link SuperMap.RangeMode}} 分段专题图的分段模式。<br>
 *        rangeParameter - {number}分段参数。<br>
 *        colorGradientType - {{@link SuperMap.ColorGradientType}} 渐变颜色枚举类。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeRange = function (_Theme) {
    _inherits(ThemeRange, _Theme);

    /**
     * @member SuperMap.ThemeRange.prototype.rangeParameter -{number}
     * @description 分段参数。<br>
     *              当分段模式为等距离分段法，平方根分段，对数分段法，计数分段法其中一种模式时，该参数用于设置分段个数，必设；当分段模式为标准差分段法时，
     *              该参数不起作用；当分段模式为自定义距离时，该参数用于设置自定义距离。默认值为 -1。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.rangeExpression -{string}
     * @description 分段字段表达式。<br>
     *              由于范围分段专题图基于各种分段方法根据一定的距离进行分段，因而范围分段专题图所基于的字段值的数据类型必须为数值型。对于字段表达式，只能为数值型的字段间的运算。必设字段。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.precision -{string}
     * @description 精准度
     */
    function ThemeRange(options) {
        _classCallCheck(this, ThemeRange);

        var _this = _possibleConstructorReturn(this, (ThemeRange.__proto__ || Object.getPrototypeOf(ThemeRange)).call(this, "RANGE", options));

        _this.precision = '1.0E-12';
        _this.items = null;
        _this.rangeExpression = null;
        _this.rangeMode = _REST.RangeMode.EQUALINTERVAL;
        _this.rangeParameter = 0;
        _this.colorGradientType = _REST.ColorGradientType.YELLOW_RED;
        _this.CLASS_NAME = "SuperMap.ThemeRange";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeRange.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeRange.prototype.colorGradientType -{SuperMap.ColorGradientType}
     * @description 渐变颜色枚举类 <br>
     *              渐变色是由起始色根据一定算法逐渐过渡到终止色的一种混合型颜色。
     *              该类作为单值专题图参数类、分段专题图参数类的属性，负责设置单值专题图、分段专题图的配色方案，在默认情况下专题图所有子项会根据这个配色
     *              方案完成填*充。但如果为某几个子项的风格进行单独设置后（设置了 {@link SuperMap.ThemeUniqueItem} 或 {@link SuperMap.ThemeRangeItem} 类中Style属性），
     *              该配色方案对于这几个子项将不起作用。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.rangeMode -{SuperMap.RangeMode}
     * @description 分段专题图的分段模式。<br>
     *              默认值为 {@link RangeMode|SuperMap.RangeMode.EQUALINTERVAL}（等距离分段）。
     *              在分段专题图中，作为专题变量的字段或表达式的值按照某种分段方式被分成多个范围段。
     *              目前 SuperMap 提供的分段方式包括：等距离分段法、平方根分段法、标准差分段法、对数分段法、等计数分段法和自定义距离法，
     *              显然这些分段方法根据一定的距离进行分段，因而范围分段专题图所基于的专题变量必须为数值型。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.items -{Array<SuperMap.ThemeRangeItem>}
     * @description 分段专题图子项数组。<br>
     *              在分段专题图中，字段值按照某种分段模式被分成多个范围段，每个范围段即为一个子项，同一范围段的要素属于同一个分段专题图子项。<br>
     *              每个子项都有其分段起始值、终止值、名称和风格等。每个分段所表示的范围为[start, end)。<br>
     *              如果设置了范围分段模式和分段数，则会自动计算每段的范围[start, end)，故无需设置[start, end)；当然可以设置，那么结果就会按照您设置的值对分段结果进行调整。
     */


    _createClass(ThemeRange, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeRange.prototype.__proto__ || Object.getPrototypeOf(ThemeRange.prototype), 'destroy', this).call(this);
            var me = this;
            if (me.items) {
                if (me.items.length > 0) {
                    for (var item in me.items) {
                        me.items[item].destroy();
                        me.items[item] = null;
                    }
                }
                me.items = null;
            }
            me.rangeExpression = null;
            me.rangeMode = null;
            me.rangeParameter = null;
            me.colorGradientType = null;
        }

        /**
         * @function SuperMap.ThemeRange.fromObj
         * @description 从传入对象获取范围分段专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeRange} ThemeRange对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeRange();
            _SuperMap2.default.Util.copy(res, obj);
            var itemsR = obj.items;
            var len = itemsR ? itemsR.length : 0;
            res.items = [];
            for (var i = 0; i < len; i++) {
                res.items.push(_ThemeRangeItem2.default.fromObj(itemsR[i]));
            }
            return res;
        }
    }]);

    return ThemeRange;
}(_Theme3.default);

exports.default = ThemeRange;


_SuperMap2.default.ThemeRange = ThemeRange;

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(12);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ServerStyle = __webpack_require__(6);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

var _ThemeUniqueItem = __webpack_require__(238);

var _ThemeUniqueItem2 = _interopRequireDefault(_ThemeUniqueItem);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeUnique
 * @classdesc 单值专题图。
 * @description 单值专题图是利用不同的颜色或符号（线型、填充）表示图层中某一属性信息的不同属性值，属性值相同的要素具有相同的渲染风格。单值专题图多用于具有分类属性的地图上，
 *              比如土壤类型分布图、土地利用图、行政区划图等。单值专题图着重表示现象质的差别，一般不表示数量的特征。尤其是有交叉或重叠现象时，此类不推荐使用，例如：民族分布区等。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        items - {Array<{@link SuperMap.ThemeUniqueItem}>} 单值专题图子项类数组。<br>
 *        uniqueExpression - {string} 用于制作单值专题图的字段或字段表达式。<br>
 *        defaultStyle - {{@link SuperMap.ServerStyle}} 未参与单值专题图制作的对象的显示风格。<br>
 *        colorGradientType - {{@link SuperMap.ColorGradientType}} 渐变颜色枚举类。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeUnique = function (_Theme) {
    _inherits(ThemeUnique, _Theme);

    /**
     * @member SuperMap.ThemeUnique.prototype.uniqueExpression -{string}
     * @description 用于制作单值专题图的字段或字段表达式。<br>
     *              该字段值的数据类型可以为数值型或字符型。如果设置字段表达式，只能是相同数据类型字段间的运算。必设字段。
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.defaultStyle -{SuperMap.ServerStyle}
     * @description 未参与单值专题图制作的对象的显示风格。<br>
     *              通过单值专题图子项数组 （items）可以指定某些要素参与单值专题图制作，对于那些没有被包含的要素，即不参加单值专题表达的要素，使用该风格显示。
     */
    function ThemeUnique(options) {
        _classCallCheck(this, ThemeUnique);

        var _this = _possibleConstructorReturn(this, (ThemeUnique.__proto__ || Object.getPrototypeOf(ThemeUnique)).call(this, "UNIQUE", options));

        _this.defaultStyle = null;
        _this.items = null;
        _this.uniqueExpression = null;
        _this.colorGradientType = _REST.ColorGradientType.YELLOW_RED;
        _this.CLASS_NAME = "SuperMap.ThemeUnique";

        var me = _this;
        me.defaultStyle = new _ServerStyle2.default();
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeUnique.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.colorGradientType -{SuperMap.ColorGradientType}
     * @description 渐变颜色枚举类。<br>
     *              渐变色是由起始色根据一定算法逐渐过渡到终止色的一种混合型颜色。
     *              该类作为单值专题图参数类、分段专题图参数类的属性，负责设置单值专题图、分段专题图的配色方案，在默认情况下专题图所有子项会根据这个配色方案完成填充。
     *              但如果为某几个子项的风格进行单独设置后（设置了 ThemeUniqueItem 或 ThemeRangeItem 类中Style属性），
     *              该配色方案对于这几个子项将不起作用。
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.items -{Array<SuperMap.ThemeUniqueItem>}
     * @description 单值专题图子项类数组。<br>
     *              单值专题图是将专题值相同的要素归为一类，为每一类设定一种渲染风格，其中每一类就是一个专题图子项。比如，利用单值专题图制作行政区划图，
     *              Name 字段代表省/直辖市名，该字段用来做专题变量，如果该字段的字段值总共有5种不同值，则该行政区划图有5个专题图子项。
     */


    _createClass(ThemeUnique, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeUnique.prototype.__proto__ || Object.getPrototypeOf(ThemeUnique.prototype), 'destroy', this).call(this);
            var me = this;
            me.uniqueExpression = null;
            me.colorGradientType = null;
            if (me.items) {
                if (me.items.length > 0) {
                    for (var item in me.items) {
                        me.items[item].destroy();
                        me.items[item] = null;
                    }
                }
                me.items = null;
            }

            if (me.defaultStyle) {
                me.defaultStyle.destroy();
                me.defaultStyle = null;
            }
        }

        /**
         * @function SuperMap.ThemeUnique.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj = _SuperMap2.default.Util.copyAttributes(obj, this);
            if (obj.defaultStyle) {
                if (obj.defaultStyle.toServerJSONObject) {
                    obj.defaultStyle = obj.defaultStyle.toServerJSONObject();
                }
            }
            if (obj.items) {
                var items = [],
                    len = obj.items.length;
                for (var i = 0; i < len; i++) {
                    items.push(obj.items[i].toServerJSONObject());
                }
                obj.items = items;
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeUnique.fromObj
         * @description 从传入对象获取单值专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeUnique} ThemeUnique对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ThemeUnique();
            var uItems = obj.items;
            var len = uItems ? uItems.length : 0;
            _SuperMap2.default.Util.extend(res, obj);
            res.items = [];
            res.defaultStyle = new _ServerStyle2.default.fromJson(obj.defaultStyle);
            for (var i = 0; i < len; i++) {
                res.items.push(new _ThemeUniqueItem2.default.fromObj(uItems[i]));
            }
            return res;
        }
    }]);

    return ThemeUnique;
}(_Theme3.default);

exports.default = ThemeUnique;


_SuperMap2.default.ThemeUnique = ThemeUnique;

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.UGCLayer
 * @classdesc UGC 图层类。
 * @param options - {Object} 可选参数。如：<br>
 *        bounds - {{@link SuperMap.Bounds}} 图层范围。<br>
 *        caption - {string} 图层的标题。<br>
 *        description - {string} 图层的描述信息。<br>
 *        name - {string} 图层的名称。<br>
 *        queryable - {boolean} 图层中的对象是否可以查询。<br>
 *        subUGCLayers - {boolean} 是否允许图层的符号大小随图缩放。<br>
 *        type - {{@link SuperMap.UGCLayerType}} 图层类型。<br>
 *        visible - {boolean} 地图对象在同一范围内时，是否重叠显示，默认为False。
 */
var UGCLayer = function () {

    /**
     * @member SuperMap.UGCLayer.prototype.type -{SuperMap.UGCLayerType}
     * @description 图层类型。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.queryable -{boolean}
     * @description 图层中的对象是否可以查询。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.description -{string}
     * @description 图层的描述信息。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.bounds -{SuperMap.Bounds}
     * @description 图层范围。
     */
    function UGCLayer(options) {
        _classCallCheck(this, UGCLayer);

        this.bounds = null;
        this.caption = null;
        this.description = null;
        this.name = null;
        this.queryable = null;
        this.subLayers = null;
        this.type = null;
        this.visible = null;
        this.CLASS_NAME = "SuperMap.UGCLayer";

        options = options ? options : {};
        _SuperMap2.default.Util.extend(this, options);
    }

    /**
     * @function SuperMap.UGCLayer.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.visible -{boolean}
     * @description 图层是否可视。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.subLayers -{Array}
     * @description 子图层集。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.name -{string}
     * @description 图层的名称。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.caption -{string}
     * @description 图层的标题。
     */


    _createClass(UGCLayer, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            _SuperMap2.default.Util.reset(me);
        }

        /**
         * @function SuperMap.UGCLayer.prototype.fromJson
         * @description 将服务端JSON对象转换成当前客户端对象
         * @param jsonObject - {Object} 要转换的 JSON 对象。
         */

    }, {
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            jsonObject = jsonObject ? jsonObject : {};
            _SuperMap2.default.Util.extend(this, jsonObject);
            var b = this.bounds;
            if (b) {
                this.bounds = new _SuperMap2.default.Bounds(b.leftBottom.x, b.leftBottom.y, b.rightTop.x, b.rightTop.y);
            }
        }

        /**
         * @function SuperMap.UGCLayer.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = {};
            jsonObject = _SuperMap2.default.Util.copyAttributes(jsonObject, this);
            if (jsonObject.bounds) {
                if (jsonObject.bounds.toServerJSONObject) {
                    jsonObject.bounds = jsonObject.bounds.toServerJSONObject();
                }
            }
            return jsonObject;
        }
    }]);

    return UGCLayer;
}();

exports.default = UGCLayer;


_SuperMap2.default.UGCLayer = UGCLayer;

/***/ }),
/* 54 */
/***/ (function(module, exports) {

module.exports = function(){try{return mapv}catch(e){return {}}}();

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _TimeControlBase2 = __webpack_require__(139);

var _TimeControlBase3 = _interopRequireDefault(_TimeControlBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.TimeFlowControl
 * @classdesc 时间管理类。
 * @description 此类只负责时间上的控制，具体执行的操作需要用户在初始化时的回调函数内部进行实现。<br>
 *              如设置起始时间为1000，结束时间是2000，步长设置为1，
 *              那么表示按照每次1年（可以通过setSpeed进行修改）的变化从公元1000年开始到公元2000年为止，默认每1秒会1次(通过setFrequency修改)
 * @extends SuperMap.TimeControlBase
 * @param callback - {function} 每次刷新回调函数，必设属性。具体的效果需要用户在此回调函数里面实现。
 * @param options - {Object} 该类开放的可选属性。如：<br>
 *        speed - {number}步长(单位ms)。不能小于0，默认为1（表示每次刷新的数据之间的间隔为1ms）。<br>
 *        frequency -  {number} 刷新频率(单位ms)，默认为1000ms。<br>
 *        startTime - {number}起始时间，必须为数字，且小于等于endTime。如果不设置，初始化时为0，建议设置。<br>
 *        endTime - {number}结束时间，必须为数字，且大于等于startTime。如果不设置，初始化时以当前时间进行设置，建议设置。<br>
 *        repeat - {boolean} 是否重复循环。默认为true。<br>
 *        reverse - {boolean} 是否反向。默认为false。
 */
var TimeFlowControl = function (_TimeControlBase) {
    _inherits(TimeFlowControl, _TimeControlBase);

    function TimeFlowControl(callback, options) {
        _classCallCheck(this, TimeFlowControl);

        var _this = _possibleConstructorReturn(this, (TimeFlowControl.__proto__ || Object.getPrototypeOf(TimeFlowControl)).call(this, options));

        _this.callback = null;
        _this.CLASS_NAME = "SuperMap.TimeFlowControl";

        var me = _this;

        //先让IE下支持bind方法
        if (!Function.prototype.bind) {
            Function.prototype.bind = function (oThis) {
                if (typeof this !== "function") {
                    throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");
                }
                var aArgs = Array.prototype.slice.call(arguments, 1),
                    fToBind = this,
                    fNOP = function fNOP() {
                    //empty Function
                },
                    fBound = function fBound() {
                    return fToBind.apply(this instanceof fNOP && oThis ? this : oThis, aArgs.concat(Array.prototype.slice.call(arguments)));
                };
                fNOP.prototype = this.prototype;
                fBound.prototype = new fNOP();
                return fBound;
            };
        }
        //保证 this.tick 的上下文还是 TimeControl 这个对象
        me.update = me.update.bind(me);

        me.oldTime = me.currentTime;
        //记录回调函数
        me.callback = callback;
        return _this;
    }

    /**
     * @function SuperMap.TimeFlowControl.prototype.updateOptions
     * @override
     */


    /**
     * @member SuperMap.TimeFlowControl.prototype.callback -{function}
     * @description 每次刷新执行的回调函数
     */


    _createClass(TimeFlowControl, [{
        key: 'updateOptions',
        value: function updateOptions(options) {
            options = options || {};
            _get(TimeFlowControl.prototype.__proto__ || Object.getPrototypeOf(TimeFlowControl.prototype), 'updateOptions', this).call(this, options);
        }

        /**
         * @function SuperMap.TimeFlowControl.prototype.start
         * @override
         */

    }, {
        key: 'start',
        value: function start() {
            var me = this;
            if (me.running) {
                return;
            }
            me.running = true;
            if (me.reverse) {
                if (me.currentTime === me.startTime) {
                    me.oldTime = me.endTime;
                    me.currentTime = me.oldTime;
                }
            } else {
                if (me.oldTime === me.endTime) {
                    me.currentTime = me.startTime;
                    me.oldTime = me.currentTime;
                }
            }
            me.tick();
        }

        /**
         * @function SuperMap.TimeFlowControl.prototype.stop
         * @override
         */

    }, {
        key: 'stop',
        value: function stop() {
            _get(TimeFlowControl.prototype.__proto__ || Object.getPrototypeOf(TimeFlowControl.prototype), 'stop', this).call(this);
            var me = this;
            me.oldTime = me.currentTime;

            if (me.running) {
                me.running = false;
            }
            //清除定时tick
            me.intervalId && window.clearTimeout(me.intervalId);
        }

        /**
         * @function SuperMap.TimeFlowControl.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            _get(TimeFlowControl.prototype.__proto__ || Object.getPrototypeOf(TimeFlowControl.prototype), 'destroy', this).call(this);
            var me = this;
            me.oldTime = null;
            me.callback = null;
        }

        /**
         * @function SuperMap.TimeFlowControl.prototype.tick
         * @description 定时刷新
         */

    }, {
        key: 'tick',
        value: function tick() {
            var me = this;
            me.intervalId && window.clearInterval(me.intervalId);
            me.intervalId = null;
            me.intervalId = window.setInterval(me.update, me.frequency);
        }

        /**
         * @function SuperMap.TimeFlowControl.prototype.update
         * @override
         */

    }, {
        key: 'update',
        value: function update() {
            var me = this;

            //判定是否还需要继续
            if (!me.running) {
                return;
            }
            //调用回调函数
            me.callback && me.callback(me.currentTime); //destroy之后callback就为空，所以需要判定一下

            if (!me.reverse) {
                //如果相等，则代表上一帧已经运行到了最后，下一帧运行初始化的状态
                if (me.currentTime === me.endTime) {
                    //不循环时
                    if (!me.repeat) {
                        me.running = false;
                        me.stop();
                        return null;
                    }
                    me.stop();
                    me.currentTime = me.startTime;
                    me.oldTime = me.currentTime;
                    me.start();
                }
                //否则时间递增
                else {
                        me.oldTime = me.currentTime;
                        me.currentTime += me.speed;
                    }

                if (me.currentTime >= me.endTime) {
                    me.currentTime = me.endTime;
                }
            } else {
                //如果相等，则代表上一帧已经运行到了最前，下一帧运行结束的状态
                if (me.currentTime === me.startTime) {
                    //不循环时
                    if (!me.repeat) {
                        me.running = false;
                        return null;
                    }

                    me.oldTime = me.endTime;
                    me.currentTime = me.oldTime;
                }
                //否则时间递减
                else {
                        me.currentTime = me.oldTime;
                        me.oldTime -= me.speed;
                    }

                if (me.oldTime <= me.startTime) {
                    me.oldTime = me.startTime;
                }
            }
        }
    }]);

    return TimeFlowControl;
}(_TimeControlBase3.default);

exports.default = TimeFlowControl;


_SuperMap2.default.TimeFlowControl = TimeFlowControl;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FetchRequest = __webpack_require__(28);

var _GeoCodingParameter = __webpack_require__(174);

var _GeoCodingParameter2 = _interopRequireDefault(_GeoCodingParameter);

var _GeoDecodingParameter = __webpack_require__(175);

var _GeoDecodingParameter2 = _interopRequireDefault(_GeoDecodingParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.AddressMatchService
 * @classdesc 地址匹配服务，包括正向匹配和反向匹配。
 * @param options - {Object} 参数。
 * @param url {string} 地址匹配服务地址。
 */
var AddressMatchService = function (_CommonServiceBase) {
    _inherits(AddressMatchService, _CommonServiceBase);

    function AddressMatchService(url, options) {
        _classCallCheck(this, AddressMatchService);

        var _this = _possibleConstructorReturn(this, (AddressMatchService.__proto__ || Object.getPrototypeOf(AddressMatchService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.AddressMatchService";
        return _this;
    }

    /**
     * @function SuperMap.AddressMatchService.prototype.destroy
     * @override
     */


    _createClass(AddressMatchService, [{
        key: 'destroy',
        value: function destroy() {
            _get(AddressMatchService.prototype.__proto__ || Object.getPrototypeOf(AddressMatchService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.AddressMatchService.prototype.code
         * @param url {string} 正向地址匹配服务地址
         * @param params {SuperMap.GeoCodingParameter} 正向地址匹配服务参数
         */

    }, {
        key: 'code',
        value: function code(url, params) {
            this.processAsync(url, params);
        }

        /**
         * @function SuperMap.AddressMatchService.prototype.decode
         * @param url {string} 反向地址匹配服务地址
         * @param params {SuperMap.GeoDecodingParameter} 反向地址匹配服务参数
         */

    }, {
        key: 'decode',
        value: function decode(url, params) {
            this.processAsync(url, params);
        }

        /**
         * @function SuperMap.AddressMatchService.prototype.processAsync
         * @description 负责将客户端的动态分段服务参数传递到服务端。
         * @param url - {string} 服务地址
         * @param params - {Object} 参数
         */

    }, {
        key: 'processAsync',
        value: function processAsync(url, params) {
            var me = this;
            _FetchRequest.FetchRequest.get(url, params).then(function (response) {
                return response.json();
            }).then(function (result) {
                if (result) {
                    me.serviceProcessCompleted(result);
                } else {
                    me.serviceProcessFailed(result);
                }
            }).catch(function (e) {
                me.eventListeners.processFailed({ error: e });
            });
        }

        /**
         * @function SuperMap.AddressMatchService.prototype.serviceProcessCompleted
         * @param result - {Object} 服务器返回的结果对象。
         * @description 服务流程是否完成
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            _get(AddressMatchService.prototype.__proto__ || Object.getPrototypeOf(AddressMatchService.prototype), 'serviceProcessCompleted', this).call(this, result);
        }

        /**
         * @function SuperMap.AddressMatchService.prototype.serviceProcessCompleted
         * @param result - {Object} 服务器返回的结果对象。
         * @description 服务流程是否失败
         */

    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            _get(AddressMatchService.prototype.__proto__ || Object.getPrototypeOf(AddressMatchService.prototype), 'serviceProcessFailed', this).call(this, result);
        }
    }]);

    return AddressMatchService;
}(_CommonServiceBase3.default);

exports.default = AddressMatchService;

_SuperMap2.default.AddressMatchService = AddressMatchService;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _AreaSolarRadiationParameters = __webpack_require__(142);

var _AreaSolarRadiationParameters2 = _interopRequireDefault(_AreaSolarRadiationParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.AreaSolarRadiationService
 * @classdesc 地区太阳辐射服务类。
 * @param url - {string} 服务的访问地址。如</br> http://localhost:8090/iserver/services/spatialanalyst-sample/restjsr/spatialanalyst 。</br>
 * @param options - {Object} 参数。如:</br>
 * eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var myAreaSolarRadiationService = new SuperMap.AreaSolarRadiationService(url);
 * myAreaSolarRadiationService.on({
     *     "processCompleted": processCompleted,
     *     "processFailed": processFailed
     *     }
 * );
 * (end)
 *
 */
var AreaSolarRadiationService = function (_SpatialAnalystBase) {
    _inherits(AreaSolarRadiationService, _SpatialAnalystBase);

    function AreaSolarRadiationService(url, options) {
        _classCallCheck(this, AreaSolarRadiationService);

        var _this = _possibleConstructorReturn(this, (AreaSolarRadiationService.__proto__ || Object.getPrototypeOf(AreaSolarRadiationService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.AreaSolarRadiationService";
        return _this;
    }

    /**
     * @function SuperMap.AreaSolarRadiationService.prototype.destroy
     * @override
     */


    _createClass(AreaSolarRadiationService, [{
        key: 'destroy',
        value: function destroy() {
            _get(AreaSolarRadiationService.prototype.__proto__ || Object.getPrototypeOf(AreaSolarRadiationService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.AreaSolarRadiationService.prototype.processAsync
         * @description  负责将客户端的查询参数传递到服务端。
         * @param parameter - {SuperMap.AreaSolarRadiationParameters} 地区太阳辐射参数
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            var parameterObject = {};

            if (parameter instanceof _SuperMap2.default.AreaSolarRadiationParameter) {
                me.url += 'datasets/' + parameter.dataset + '/solarradiation';
            }

            _SuperMap2.default.AreaSolarRadiationParameters.toObject(parameter, parameterObject);
            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return AreaSolarRadiationService;
}(_SpatialAnalystBase3.default);

exports.default = AreaSolarRadiationService;

_SuperMap2.default.AreaSolarRadiationService = AreaSolarRadiationService;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _DatasetBufferAnalystParameters = __webpack_require__(151);

var _DatasetBufferAnalystParameters2 = _interopRequireDefault(_DatasetBufferAnalystParameters);

var _GeometryBufferAnalystParameters = __webpack_require__(177);

var _GeometryBufferAnalystParameters2 = _interopRequireDefault(_GeometryBufferAnalystParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.BufferAnalystService
 * @classdesc 缓冲区分析服务类
 * 该类负责将客户设置的缓冲区分析参数传递给服务端，并接收服务端返回的缓冲区分析结果数据。
 * 缓冲区分析结果通过该类支持的事件的监听函数参数获取
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var myBufferAnalystService = new SuperMap.BufferAnalystService(url, {
     *     eventListeners: {
     *           "processCompleted": bufferCompleted,
     *           "processFailed": bufferFailed
     *           }
     *    });
 * (end)
 *
 *
 */
var BufferAnalystService = function (_SpatialAnalystBase) {
    _inherits(BufferAnalystService, _SpatialAnalystBase);

    function BufferAnalystService(url, options) {
        _classCallCheck(this, BufferAnalystService);

        var _this = _possibleConstructorReturn(this, (BufferAnalystService.__proto__ || Object.getPrototypeOf(BufferAnalystService)).call(this, url, options));

        _this.mode = null;
        _this.CLASS_NAME = "SuperMap.BufferAnalystService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.BufferAnalystService.prototype.destroy
     * @override
     */

    /**
     * @member SuperMap.BufferAnalystService.prototype.mode -{string}
     * @description 缓冲区分析类型
     */


    _createClass(BufferAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(BufferAnalystService.prototype.__proto__ || Object.getPrototypeOf(BufferAnalystService.prototype), 'destroy', this).call(this);
            this.mode = null;
        }

        /**
         * @method SuperMap.BufferAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param parameter - {BufferAnalystParameters} 缓冲区分析参数
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var parameterObject = {};
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            if (parameter instanceof _DatasetBufferAnalystParameters2.default) {
                me.mode = "datasets";
                me.url += 'datasets/' + parameter.dataset + '/buffer';
                _DatasetBufferAnalystParameters2.default.toObject(parameter, parameterObject);
            } else if (parameter instanceof _GeometryBufferAnalystParameters2.default) {
                me.mode = "geometry";
                me.url += 'geometry/buffer';
                _GeometryBufferAnalystParameters2.default.toObject(parameter, parameterObject);
            }

            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @method SuperMap.BufferAnalystService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */
        // toGeoJSONResult(result) {
        //     if (!result) {
        //         return result;
        //     }
        //
        //     var analystResult = super.toGeoJSONResult(result);
        //     if (analystResult.resultGeometry) {
        //         var geoJSONFormat = new GeoJSON();
        //         result = JSON.parse(geoJSONFormat.write(analystResult.resultGeometry));
        //     }
        //     return result;
        // }

    }]);

    return BufferAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = BufferAnalystService;

_SuperMap2.default.BufferAnalystService = BufferAnalystService;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _BurstPipelineAnalystParameters = __webpack_require__(145);

var _BurstPipelineAnalystParameters2 = _interopRequireDefault(_BurstPipelineAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.BurstPipelineAnalystService
 * @classdesc 爆管分析服务类;即将给定弧段或节点作为爆管点来进行分析，返回关键结点 ID 数组，普通结点 ID 数组及其上下游弧段 ID 数组。
 * @extends SuperMap.NetworkAnalystServiceBase
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                       例如: "http://localhost:8090/iserver/services/test/rest/networkanalyst/WaterNet@FacilityNet";
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var BurstPipelineAnalystService = function (_NetworkAnalystServic) {
    _inherits(BurstPipelineAnalystService, _NetworkAnalystServic);

    function BurstPipelineAnalystService(url, options) {
        _classCallCheck(this, BurstPipelineAnalystService);

        var _this = _possibleConstructorReturn(this, (BurstPipelineAnalystService.__proto__ || Object.getPrototypeOf(BurstPipelineAnalystService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.BurstPipelineAnalystService";
        return _this;
    }

    /**
     * @function SuperMap.BurstPipelineAnalystService.prototype.destroy
     * @override
     */


    _createClass(BurstPipelineAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(BurstPipelineAnalystService.prototype.__proto__ || Object.getPrototypeOf(BurstPipelineAnalystService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.BurstPipelineAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @params params - {SuperMap.BurstPipelineAnalystParameters} 爆管分析参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject;
            var end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "burstAnalyse" : "/burstAnalyse") + ".json?";

            jsonObject = {
                sourceNodeIDs: params.sourceNodeIDs,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };

            //必传参数不正确，就终止
            if (params.edgeID !== null && params.nodeID !== null) return;
            if (params.edgeID === null && params.nodeID === null) return;
            if (params.edgeID !== null) jsonObject.edgeID = params.edgeID;else jsonObject.nodeID = params.nodeID;

            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return BurstPipelineAnalystService;
}(_NetworkAnalystServiceBase2.default);

exports.default = BurstPipelineAnalystService;


_SuperMap2.default.BurstPipelineAnalystService = BurstPipelineAnalystService;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ChartFeatureInfoSpecsService
 * @classdesc 海图物标信息服务类，通过该服务类可以查询到服务端支持的所有海图物标信息。<br>
 *              用户可以通过两种方式获取查询结果：<br>
 *              一种是通过监听 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE 事件；<br>
 *              另一种是使用 AsyncResponder 类实现异步处理。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 地图（特指海图）服务地址。<br>
 *        如："http://localhost:8090/iserver/services/map-ChartW/rest/maps/海图"。<br>
 *        发送请求格式类似于："http://localhost:8090/iserver/services/map-ChartW/rest/maps/海图/chartFeatureInfoSpecs.json"
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var ChartFeatureInfoSpecsService = function (_CommonServiceBase) {
    _inherits(ChartFeatureInfoSpecsService, _CommonServiceBase);

    function ChartFeatureInfoSpecsService(url, options) {
        _classCallCheck(this, ChartFeatureInfoSpecsService);

        var _this = _possibleConstructorReturn(this, (ChartFeatureInfoSpecsService.__proto__ || Object.getPrototypeOf(ChartFeatureInfoSpecsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ChartFeatureInfoSpecsService";
        return _this;
    }

    /**
     * @function SuperMap.ChartFeatureInfoSpecsService.prototype.destroy
     * @override
     */


    _createClass(ChartFeatureInfoSpecsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(ChartFeatureInfoSpecsService.prototype.__proto__ || Object.getPrototypeOf(ChartFeatureInfoSpecsService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.ChartFeatureInfoSpecsService.prototype.processAsync
         * @description 根据地图（特指海图）服务地址与服务端完成异步通讯，获取物标信息。<br>
         *               当查询物标信息成功时，将触发 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE <br>
         *               事件。用可以通过户两种方式获取图层信息: <br>
         *                 1. 通过 AsyncResponder 类获取（推荐使用）；<br>
         *                 2. 通过监听 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE 事件获取。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            var me = this,
                method = "GET",
                end = me.url.substr(me.url.length - 1, 1);
            if (!me.isTempLayers) {
                me.url += end === "/" ? '' : '/';
                me.url += "chartFeatureInfoSpecs.json?";
            } else {
                me.url += ".json?";
            }
            me.request({
                method: method,
                params: null,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return ChartFeatureInfoSpecsService;
}(_CommonServiceBase3.default);

exports.default = ChartFeatureInfoSpecsService;


_SuperMap2.default.ChartFeatureInfoSpecsService = ChartFeatureInfoSpecsService;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _QueryParameters = __webpack_require__(14);

var _QueryParameters2 = _interopRequireDefault(_QueryParameters);

var _ChartQueryParameters = __webpack_require__(147);

var _ChartQueryParameters2 = _interopRequireDefault(_ChartQueryParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ChartQueryService
 * @classdesc 海图查询服务类。该类负责将海图查询所需参数（ChartQueryParameters）传递至服务端，并获取服务端的返回结果。<br>
 *      用户可以通过两种方式获取查询结果:<br>
 *      1.通过 AsyncResponder 类获取（推荐使用）；<br>
 *      2.通过监听 QueryEvent.PROCESS_COMPLETE 事件获取。<br>
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 地图查询服务访问地址。如："http://192.168.168.35:8090/iserver/services/map-ChartW/rest/maps/海图"。
 * @param options - {Object} 服务交互时所需的可选参数。<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * 下面示例显示了如何进行海图属性查询：
 * var nameArray = ["GB4X0000_52000"];
 * var chartQueryFilterParameter = new ChartQueryFilterParameter({
 *       isQueryPoint:true,
 *        isQueryLine:true,
 *        isQueryRegion:true,
 *        attributeFilter:"SmID<10",
 *        chartFeatureInfoSpecCode:1
 *    });
 *
 * var chartQueryParameters = new SuperMap.ChartQueryParameters({
 *        queryMode:"ChartAttributeQuery",
 *        chartLayerNames:nameArray,
 *        returnContent:true,
 *        chartQueryFilterParameters:[chartQueryFilterParameter]
 *    });
 *
 * var chartQueryService = new SuperMap.ChartQueryService(url);
 *
 * chartQueryService.events.on({
 *        "processCompleted":processCompleted,
 *        "processFailed":processFailed
 *    });
 * chartQueryService.processAsync(chartQueryParameters);
 */
var ChartQueryService = function (_CommonServiceBase) {
    _inherits(ChartQueryService, _CommonServiceBase);

    /**
     * @member SuperMap.ChartQueryService.prototype.returnContent -{boolean}
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     */
    function ChartQueryService(url, options) {
        _classCallCheck(this, ChartQueryService);

        var _this = _possibleConstructorReturn(this, (ChartQueryService.__proto__ || Object.getPrototypeOf(ChartQueryService)).call(this, url, options));

        _this.returnContent = null;
        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.ChartQueryService";

        options = options || {};
        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var me = _this,
            end;
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        if (!me.url) {
            return _possibleConstructorReturn(_this);
        }
        end = me.url.substr(me.url.length - 1, 1);

        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (me.format==="geojson") {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end === "/" ? "queryResults.json?" : "/queryResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.ChartQueryService.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ChartQueryService.prototype.format -{SuperMap.DataFormat}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *              参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    _createClass(ChartQueryService, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            _SuperMap2.default.CommonServiceBase.prototype.destroy.apply(this, arguments);
            me.returnContent = null;
            me.format = null;
        }

        /**
         * @function SuperMap.ChartQueryService.prototype.processAsync
         * @description 使用服务地址 URL 实例化 ChartQueryService 对象。
         * @param params - {SuperMap.ChartQueryParameters} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            //todo重点需要添加代码的地方
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters;
            me.returnContent = params.returnContent;
            jsonParameters = params.getVariablesJson();
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
            }
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.ChartQueryService.prototype.serviceProcessCompleted
         * @description 查询完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result && result.recordsets && me.format === _REST.DataFormat.GEOJSON) {
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        var geoJSONFormat = new _GeoJSON2.default();
                        recordsets[i].features = JSON.parse(geoJSONFormat.write(recordsets[i].features));
                    }
                }
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }

        /**
         * @function SuperMap.ChartQueryService.prototype.getQueryParameters
         * @description 将 JSON 对象表示的查询参数转化为 QueryParameters 对象。
         * @param params - {Object} JSON 字符串表示的查询参数。
         * @return {chartQueryFilterParameters} 返回查询结果
         */

    }, {
        key: 'getQueryParameters',
        value: function getQueryParameters(params) {
            return new _QueryParameters2.default({
                queryMode: params.queryMode,
                bounds: params.bounds,
                chartLayerNames: params.chartLayerNames,
                chartQueryFilterParameters: params.chartQueryFilterParameters,
                returnContent: params.returnContent
            });
        }
    }]);

    return ChartQueryService;
}(_CommonServiceBase3.default);

exports.default = ChartQueryService;

_SuperMap2.default.ChartQueryService = ChartQueryService;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ComputeWeightMatrixParameters = __webpack_require__(150);

var _ComputeWeightMatrixParameters2 = _interopRequireDefault(_ComputeWeightMatrixParameters);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ComputeWeightMatrixService
 * @classdesc 耗费矩阵分析服务类。<br>
 *               耗费矩阵是根据交通网络分析参数中的耗费字段来计算一个二维数组，
 *               用来存储指定的任意两点间的资源消耗。
 *               耗费矩阵分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var mycomputeWeightMatrixService = new SuperMap.ComputeWeightMatrixService(url,{
 *     eventListeners: {
 *	       "processCompleted": computeWeightMatrixCompleted,
 *		   "processFailed": computeWeightMatrixnError
 *		   }
 * });
 * @param url - {string} 耗费矩阵分析服务地址。请求服务的URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var ComputeWeightMatrixService = function (_NetworkAnalystServic) {
    _inherits(ComputeWeightMatrixService, _NetworkAnalystServic);

    function ComputeWeightMatrixService(url, options) {
        _classCallCheck(this, ComputeWeightMatrixService);

        var _this = _possibleConstructorReturn(this, (ComputeWeightMatrixService.__proto__ || Object.getPrototypeOf(ComputeWeightMatrixService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ComputeWeightMatrixService";
        return _this;
    }

    /**
     * @function SuperMap.ComputeWeightMatrixService.prototype.destroy
     * @override
     */


    _createClass(ComputeWeightMatrixService, [{
        key: 'destroy',
        value: function destroy() {
            _get(ComputeWeightMatrixService.prototype.__proto__ || Object.getPrototypeOf(ComputeWeightMatrixService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.ComputeWeightMatrixService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {ComputeWeightMatrixParameters} 耗费矩阵分析参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "weightmatrix" : "/weightmatrix") + ".json?";
            jsonObject = {
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                nodes: me.getJson(params.isAnalyzeById, params.nodes)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.ComputeWeightMatrixService.prototype.getJson
         * @description 将对象转化为JSON字符串。
         * @param isAnalyzeById - {boolean} 是否通过id分析
         * @param params - {Array} 分析参数数组
         * @return- {string} 转化后的JSON字符串。
         */

    }, {
        key: 'getJson',
        value: function getJson(isAnalyzeById, params) {
            var jsonString = "[",
                len = params ? params.length : 0;

            if (isAnalyzeById === false) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
                }
            } else if (isAnalyzeById == true) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += params[i];
                }
            }
            jsonString += ']';
            return jsonString;
        }
    }]);

    return ComputeWeightMatrixService;
}(_NetworkAnalystServiceBase2.default);

exports.default = ComputeWeightMatrixService;

_SuperMap2.default.ComputeWeightMatrixService = ComputeWeightMatrixService;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.DataFlowService
 * @classdesc 实时数据服务类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 实时数据服务地址
 * @param options - {Object} 加载实时数据可选参数。如：<br>
 *        style - {function} 设置数据加载样式。<br>
 *        onEachFeature - {function} 设置每个数据加载popup等。<br>
 *        geometry - {Array<Object>} 设置增添的几何要素对象数组。
 *        excludeField - -{Object} 排除字段
 */
var DataFlowService = function (_CommonServiceBase) {
    _inherits(DataFlowService, _CommonServiceBase);

    /**
     * @member SuperMap.DataFlowService.prototype.prjCoordSys -{Object}
     * @description 动态投影参数
     */
    function DataFlowService(url, options) {
        _classCallCheck(this, DataFlowService);

        options = options || {};
        options.EVENT_TYPES = ["broadcastSocketConnected", "broadcastSocketError", "broadcastFailed", "broadcastSuccessed", "subscribeSocketConnected", "subscribeSocketError", "messageSuccessed", "setFilterParamSuccessed"];

        var _this = _possibleConstructorReturn(this, (DataFlowService.__proto__ || Object.getPrototypeOf(DataFlowService)).call(this, url, options));

        _this.geometry = null;
        _this.prjCoordSys = null;
        _this.excludeField = null;
        _this.CLASS_NAME = "SuperMap.DataFlowService";


        var me = _this;
        var end = me.url.substr(me.url.length - 1, 1);
        if (end === '/') {} else {
            me.url += "/";
        }
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.DataFlowService.prototype.initBroadcast
     * @description 初始化广播
     * @return{SuperMap.DataFlowService}
     */


    /**
     * @member SuperMap.DataFlowService.prototype.excludeField -{Object}
     * @description 排除字段
     */


    /*
     * @constant EVENT_TYPES
     * {Array<string>}
     * 此类支持的事件类型
     */
    //EVENT_TYPES = ["broadcastSocketConnected", "broadcastSocketError", "broadcastFailed", "broadcastSuccessed", "subscribeSocketConnected", "subscribeSocketError", "messageSuccessed", "setFilterParamSuccessed"];

    /**
     * @member SuperMap.DataFlowService.prototype.geometry -{Aarry<Object>}
     * @description 设置增添的几何要素对象数组。
     */


    _createClass(DataFlowService, [{
        key: 'initBroadcast',
        value: function initBroadcast() {
            var me = this;
            this.broadcastWebSocket = this._connect(me.url + 'broadcast');
            this.broadcastWebSocket.onopen = function (e) {
                me.broadcastWebSocket.isOpen = true;
                e.eventType = 'broadcastSocketConnected';
                me.events.triggerEvent('broadcastSocketConnected', e);
            };
            this.broadcastWebSocket.onclose = function (e) {
                me.broadcastWebSocket.isOpen = false;
                e.eventType = 'broadcastSocketConnected';
                me.events.triggerEvent('broadcastSocketConnected', e);
            };
            this.broadcastWebSocket.onerror = function (e) {
                e.eventType = 'broadcastSocketError';
                me.events.triggerEvent('broadcastSocketError', e);
            };
            return this;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.broadcast
         * @description 加载广播数据
         * @param geoJSONFeature {JSON} json格式的要素数据
         */

    }, {
        key: 'broadcast',
        value: function broadcast(geoJSONFeature) {
            if (!this.broadcastWebSocket.isOpen) {
                this.events.triggerEvent('broadcastFailed');
                return;
            }
            this.broadcastWebSocket.send(JSON.stringify(geoJSONFeature));
            this.events.triggerEvent('broadcastSuccessed');
        }

        /**
         * @function SuperMap.DataFlowService.prototype.initSubscribe
         * @description 初始化订阅数据
         * @return {SuperMap.DataFlowService}
         */

    }, {
        key: 'initSubscribe',
        value: function initSubscribe() {
            var me = this;
            this.subscribeWebSocket = this._connect(this.url + 'subscribe');
            this.subscribeWebSocket.onopen = function (e) {
                me.subscribeWebSocket.send(me._getFilterParams());
                e.eventType = 'subscribeSocketConnected';
                me.events.triggerEvent('subscribeSocketConnected', e);
            };
            this.subscribeWebSocket.onerror = function (e) {
                e.eventType = 'subscribeSocketError';
                me.events.triggerEvent('subscribeSocketError', e);
            };
            this.subscribeWebSocket.onmessage = function (e) {
                me._onMessage(e);
            };
            return this;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.setExcludeField
         * @description 设置排除字段
         * @param excludeField - {Object} 排除字段
         * @return {SuperMap.DataFlowService}
         */

    }, {
        key: 'setExcludeField',
        value: function setExcludeField(excludeField) {
            this.excludeField = excludeField;
            this.subscribeWebSocket.send(this._getFilterParams());
            return this;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.setGeometry
         * @description 设置添加的几何要素数据
         * @param geometry - {Array<Object>} 设置增添的几何要素对象数组。
         * @return {SuperMap.DataFlowService}
         */

    }, {
        key: 'setGeometry',
        value: function setGeometry(geometry) {
            this.geometry = geometry;
            this.subscribeWebSocket.send(this._getFilterParams());
            return this;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.unSubscribe
         * @description 结束订阅数据
         */

    }, {
        key: 'unSubscribe',
        value: function unSubscribe() {
            if (!this.subscribeWebSocket) {
                return;
            }
            this.subscribeWebSocket.close();
            this.subscribeWebSocket = null;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.unBroadcast
         * @description 结束加载广播
         */

    }, {
        key: 'unBroadcast',
        value: function unBroadcast() {
            if (this.broadcastWebSocket) {
                return;
            }
            this.broadcastWebSocket.close();
            this.broadcastWebSocket = null;
        }

        /**
         * @function SuperMap.DataFlowService.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            _SuperMap2.default.CommonServiceBase.prototype.destroy.apply(this, arguments);
            var me = this;
            me.geometry = null;
            me.prjCoordSys = null;
            me.excludeField = null;
            this.unBroadcast();
            this.unSubscribe();
        }
    }, {
        key: '_getFilterParams',
        value: function _getFilterParams() {
            var filter = {
                filterParam: {
                    prjCoordSys: this.prjCoordSys,
                    excludeField: this.excludeField,
                    geometry: this.geometry
                }
            };
            return _SuperMap2.default.Util.toJSON(filter);
        }
    }, {
        key: '_onMessage',
        value: function _onMessage(e) {
            if (e.data && e.data.indexOf("filterParam") > 0) {
                var filterParam = JSON.parse(e.data);
                e.filterParam = filterParam;
                e.eventType = 'setFilterParamSuccessed';
                this.events.triggerEvent('setFilterParamSuccessed', e);
                return;
            }
            var feature = JSON.parse(e.data);
            e.featureResult = feature;
            e.eventType = 'messageSuccessed';
            this.events.triggerEvent('messageSuccessed', e);
        }
    }, {
        key: '_connect',
        value: function _connect(url) {
            url = this._appendCredentials(url);
            if ("WebSocket" in window) {
                return new WebSocket(url);
            } else if ("MozWebSocket" in window) {
                return new MozWebSocket(url);
            } else {
                console.log("no WebSocket");
                return null;
            }
        }
    }, {
        key: '_appendCredentials',
        value: function _appendCredentials(url) {
            var token = _SuperMap2.default.SecurityManager.getToken(url);
            if (token) {
                url += "?token=" + token;
            }
            return url;
        }
    }]);

    return DataFlowService;
}(_CommonServiceBase3.default);

exports.default = DataFlowService;


_SuperMap2.default.DataFlowService = DataFlowService;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _DensityKernelAnalystParameters = __webpack_require__(157);

var _DensityKernelAnalystParameters2 = _interopRequireDefault(_DensityKernelAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.DensityAnalystService
 * @classdesc
 *  密度分析服务类，密度分析可计算每个输出栅格像元周围圆形邻域内输入的点或线对象的密度。
 *  密度分析，在某种意义上来说，相当于在表面上将输入的点线对象的测量值散开来，将每个点或线对象的测量量分布在整个研究区域，并计算输出栅格中每个像元的密度值。目前提供1种密度分析：核密度分析（Kernel）。
 * @param  url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.SpatialAnalystBase
 * @example  例如：
 * (start code)
 * var myDensityAnalystService = new SuperMap.DensityAnalystService(url);
 * myDensityAnalystService.on({
 *     "processCompleted": processCompleted,
 *     "processFailed": processFailed
 *     }
 * );
 * (end)
 *
 */
var DensityAnalystService = function (_SpatialAnalystBase) {
    _inherits(DensityAnalystService, _SpatialAnalystBase);

    function DensityAnalystService(url, options) {
        _classCallCheck(this, DensityAnalystService);

        var _this = _possibleConstructorReturn(this, (DensityAnalystService.__proto__ || Object.getPrototypeOf(DensityAnalystService)).call(this, url, options));

        _this.mode = null;
        _this.CLASS_NAME = "SuperMap.DensityAnalystService";

        var me = _this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.DensityAnalystService.prototype.destroy
     * @description 释放资源,将引用资源的属性置空。
     */


    /**
     * @member SuperMap.DensityAnalystService.prototype.mode -{string}
     * @description 密度分析类型。
     */


    _createClass(DensityAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(DensityAnalystService.prototype.__proto__ || Object.getPrototypeOf(DensityAnalystService.prototype), 'destroy', this).call(this);
            this.mode = null;
        }

        /**
         * @function SuperMap.DensityAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param parameter - {DensityKernelAnalystParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            var parameterObject = new Object();

            if (parameter instanceof _SuperMap2.default.DensityKernelAnalystParameters) {
                me.url += 'datasets/' + parameter.dataset + '/densityanalyst/kernel';
                me.mode = "kernel";
            }

            _DensityKernelAnalystParameters2.default.toObject(parameter, parameterObject);
            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return DensityAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = DensityAnalystService;

_SuperMap2.default.DensityAnalystService = DensityAnalystService;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _EditFeaturesParameters = __webpack_require__(158);

var _EditFeaturesParameters2 = _interopRequireDefault(_EditFeaturesParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.EditFeaturesService
 * @classdesc 数据服务中数据集添加、更新、删除服务类。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 服务端的数据服务资源地址。请求数据服务中数据集编辑服务，URL 应为：</br>
 * http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/datasources/name/{数据源名}/datasets/name/{数据集名} 。</br>
 * 例如：http://localhost:8090/iserver/services/data-jingjin/rest/data/datasources/name/Jingjin/datasets/name/Landuse_R
 * @param options - {Object} 参数。如:</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myService = new SuperMap.EditFeaturesService(url, {eventListeners: {
 *     "processCompleted": editFeatureCompleted,
 *     "processFailed": editFeatureError
 *       }
 * };
 *
 */
var EditFeaturesService = function (_CommonServiceBase) {
    _inherits(EditFeaturesService, _CommonServiceBase);

    /**
     * @member SuperMap.EditFeaturesService.prototype.returnContent -{boolean}
     * @description要素添加时，isUseBatch 不传或传为 false 的情况下有效。true 表示直接返回新创建的要素的 ID 数组;false 表示返回创建的 featureResult 资源的 URI。默认不传时为 false。
     */
    function EditFeaturesService(url, options) {
        _classCallCheck(this, EditFeaturesService);

        var _this = _possibleConstructorReturn(this, (EditFeaturesService.__proto__ || Object.getPrototypeOf(EditFeaturesService)).call(this, url, options));

        _this.returnContent = false;
        _this.isUseBatch = false;
        _this.CLASS_NAME = "SuperMap.EditFeaturesService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var me = _this,
            end;
        end = me.url.substr(me.url.length - 1, 1);
        me.url += end == "/" ? "features.json?" : "/features.json?";
        return _this;
    }

    /**
     * @function SuperMap.EditFeaturesService.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.EditFeaturesService.prototype.isUseBatch -{boolean}
     * @description 是否使用批量添加要素功能，要素添加时有效。
     *           批量添加能够提高要素编辑效率。
     *           true 表示批量添加；false 表示不使用批量添加。默认不传时为 false。
     */


    _createClass(EditFeaturesService, [{
        key: 'destroy',
        value: function destroy() {
            _get(EditFeaturesService.prototype.__proto__ || Object.getPrototypeOf(EditFeaturesService.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.isUseBatch = null;
            me.fromIndex = null;
            me.toIndex = null;
        }

        /**
         * @function SuperMap.EditFeaturesService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {SuperMap.EditFeaturesParameters} 编辑要素参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                method = "POST",
                ids = "",
                editType = params.editType,
                jsonParameters = null;

            me.returnContent = params.returnContent;
            me.isUseBatch = params.isUseBatch;
            jsonParameters = _EditFeaturesParameters2.default.toJsonParameters(params);
            if (editType === _REST.EditType.DELETE) {
                ids = _SuperMap2.default.Util.toJSON(params.IDs);
                me.url += "ids=" + ids;
                method = "DELETE";
                jsonParameters = ids;
            } else if (editType === _REST.EditType.UPDATE) {
                method = "PUT";
            } else {
                if (me.isUseBatch) {
                    me.url += "isUseBatch=" + me.isUseBatch;
                    me.returnContent = false;
                }
                if (me.returnContent) {
                    me.url += "returnContent=" + me.returnContent;
                    method = "POST";
                }
            }

            me.request({
                method: method,
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return EditFeaturesService;
}(_CommonServiceBase3.default);

exports.default = EditFeaturesService;

_SuperMap2.default.EditFeaturesService = EditFeaturesService;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FacilityAnalystSinks3DParameters = __webpack_require__(159);

var _FacilityAnalystSinks3DParameters2 = _interopRequireDefault(_FacilityAnalystSinks3DParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystSinks3DService
 * @classdesc  最近设施分析服务类(汇查找资源)<br>
 *                最近设施分析是指在网络上给定一个事件点和一组设施点，
 *                查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *                该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *                最近设施分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myFacilityAnalystSinks3DService = new SuperMap.FacilityAnalystSinks3DService(url, {
 *     eventListeners: {
 *	       "processCompleted": facilityAnalystSinks3DCompleted,
 *		   "processFailed": facilityAnalystSinks3DError
 *		   }
 * });
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *               http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *              例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。<br>
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystSinks3DService = function (_CommonServiceBase) {
    _inherits(FacilityAnalystSinks3DService, _CommonServiceBase);

    function FacilityAnalystSinks3DService(url, options) {
        _classCallCheck(this, FacilityAnalystSinks3DService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystSinks3DService.__proto__ || Object.getPrototypeOf(FacilityAnalystSinks3DService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystSinks3DService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystSinks3DService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystSinks3DService, [{
        key: 'destroy',
        value: function destroy() {
            _SuperMap2.default.CommonServiceBase.prototype.destroy.apply(this, arguments);
        }

        /**
         * @function SuperMap.FacilityAnalystSinks3DService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystSinks3DParameters} 最近设施分析参数类(汇查找资源)
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "sinks" : "/sinks") + ".json?";
            jsonObject = {
                edgeID: params.edgeID,
                nodeID: params.nodeID,
                weightName: params.weightName,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystSinks3DService;
}(_CommonServiceBase3.default);

exports.default = FacilityAnalystSinks3DService;


_SuperMap2.default.FacilityAnalystSinks3DService = FacilityAnalystSinks3DService;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FacilityAnalystSources3DParameters = __webpack_require__(160);

var _FacilityAnalystSources3DParameters2 = _interopRequireDefault(_FacilityAnalystSources3DParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystSources3DService
 * @classdesc 最近设施分析服务类(源查找资源) <br>
 *               最近设施分析是指在网络上给定一个事件点和一组设施点，
 *               查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *               该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *               最近设施分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.CommonServiceBase
 * @param  url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystSources3DService = function (_CommonServiceBase) {
    _inherits(FacilityAnalystSources3DService, _CommonServiceBase);

    function FacilityAnalystSources3DService(url, options) {
        _classCallCheck(this, FacilityAnalystSources3DService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystSources3DService.__proto__ || Object.getPrototypeOf(FacilityAnalystSources3DService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystSources3DService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystSources3DService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystSources3DService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FacilityAnalystSources3DService.prototype.__proto__ || Object.getPrototypeOf(FacilityAnalystSources3DService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FacilityAnalystSources3DService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystSources3DParameters} 最近设施分析参数类(源查找资源)
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "sources" : "/sources") + ".json?";
            jsonObject = {
                edgeID: params.edgeID,
                nodeID: params.nodeID,
                weightName: params.weightName,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystSources3DService;
}(_CommonServiceBase3.default);

exports.default = FacilityAnalystSources3DService;


_SuperMap2.default.FacilityAnalystSources3DService = FacilityAnalystSources3DService;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FacilityAnalystStreamParameters = __webpack_require__(161);

var _FacilityAnalystStreamParameters2 = _interopRequireDefault(_FacilityAnalystStreamParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystStreamService
 * @description 上游/下游 关键设施查找资源服务类;即查找给定弧段或节点的上游/下游中的关键设施结点，返回关键结点 ID 数组及其下游弧段 ID 数组。
 * @extends SuperMap.NetworkAnalystServiceBase
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如: "http://localhost:8090/iserver/services/test/rest/networkanalyst/WaterNet@FacilityNet";
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystStreamService = function (_NetworkAnalystServic) {
    _inherits(FacilityAnalystStreamService, _NetworkAnalystServic);

    function FacilityAnalystStreamService(url, options) {
        _classCallCheck(this, FacilityAnalystStreamService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystStreamService.__proto__ || Object.getPrototypeOf(FacilityAnalystStreamService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystStreamService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystStreamService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystStreamService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FacilityAnalystStreamService.prototype.__proto__ || Object.getPrototypeOf(FacilityAnalystStreamService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FacilityAnalystStreamService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystStreamParameters} 上游/下游关键设施查找资源参数类。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject;
            var end = me.url.substr(me.url.length - 1, 1);

            //URL 通过参数类型来判断是 上游 还是下游 查询
            if (params.queryType === 0) {
                me.url = me.url + (end === "/" ? "upstreamcirticalfaclilities" : "/upstreamcirticalfaclilities") + ".json?";
            } else if (params.queryType === 1) {
                me.url = me.url + (end === "/" ? "downstreamcirticalfaclilities" : "/downstreamcirticalfaclilities") + ".json?";
            } else return;

            jsonObject = {
                sourceNodeIDs: params.sourceNodeIDs,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };

            if (params.edgeID !== null && params.nodeID !== null) return;
            if (params.edgeID === null && params.nodeID === null) return;
            if (params.edgeID !== null) jsonObject.edgeID = params.edgeID;else jsonObject.nodeID = params.nodeID;

            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystStreamService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FacilityAnalystStreamService;


_SuperMap2.default.FacilityAnalystStreamService = FacilityAnalystStreamService;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FacilityAnalystTracedown3DParameters = __webpack_require__(162);

var _FacilityAnalystTracedown3DParameters2 = _interopRequireDefault(_FacilityAnalystTracedown3DParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystTracedown3DService
 * @classdesc 下游追踪资源服务类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystTracedown3DService = function (_CommonServiceBase) {
    _inherits(FacilityAnalystTracedown3DService, _CommonServiceBase);

    function FacilityAnalystTracedown3DService(url, options) {
        _classCallCheck(this, FacilityAnalystTracedown3DService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystTracedown3DService.__proto__ || Object.getPrototypeOf(FacilityAnalystTracedown3DService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystTracedown3DService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystTracedown3DService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystTracedown3DService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FacilityAnalystTracedown3DService.prototype.__proto__ || Object.getPrototypeOf(FacilityAnalystTracedown3DService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FacilityAnalystTracedown3DService.prototype.processAsync
         * @description负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystTracedown3DParameters} 下游追踪资源参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "tracedownresult" : "/tracedownresult") + ".json?";
            jsonObject = {
                edgeID: params.edgeID,
                nodeID: params.nodeID,
                weightName: params.weightName,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystTracedown3DService;
}(_CommonServiceBase3.default);

exports.default = FacilityAnalystTracedown3DService;


_SuperMap2.default.FacilityAnalystTracedown3DService = FacilityAnalystTracedown3DService;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FacilityAnalystTraceup3DParameters = __webpack_require__(163);

var _FacilityAnalystTraceup3DParameters2 = _interopRequireDefault(_FacilityAnalystTraceup3DParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystTraceup3DService
 * @classdesc 上游追踪资源服务类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystTraceup3DService = function (_CommonServiceBase) {
    _inherits(FacilityAnalystTraceup3DService, _CommonServiceBase);

    /*
     * @function SuperMap.FacilityAnalystTraceup3DService.constructor
     * @description 上游追踪资源服务类构造函数。
     * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
     *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
     *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
     * @param options - {Object} 互服务时所需可选参数。如：<br>
     *         eventListeners - {Object} 需要被注册的监听器对象。
     */
    function FacilityAnalystTraceup3DService(url, options) {
        _classCallCheck(this, FacilityAnalystTraceup3DService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystTraceup3DService.__proto__ || Object.getPrototypeOf(FacilityAnalystTraceup3DService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystTraceup3DService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystTraceup3DService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystTraceup3DService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FacilityAnalystTraceup3DService.prototype.__proto__ || Object.getPrototypeOf(FacilityAnalystTraceup3DService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FacilityAnalystTraceup3DService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystTraceup3DParameters} 上游追踪资源参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "traceupresult" : "/traceupresult") + ".json?";
            jsonObject = {
                edgeID: params.edgeID,
                nodeID: params.nodeID,
                weightName: params.weightName,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystTraceup3DService;
}(_CommonServiceBase3.default);

exports.default = FacilityAnalystTraceup3DService;


_SuperMap2.default.FacilityAnalystTraceup3DService = FacilityAnalystTraceup3DService;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FacilityAnalystUpstream3DParameters = __webpack_require__(164);

var _FacilityAnalystUpstream3DParameters2 = _interopRequireDefault(_FacilityAnalystUpstream3DParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FacilityAnalystUpstream3DService
 * @classdesc 上游关键设施查找资源服务类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FacilityAnalystUpstream3DService = function (_CommonServiceBase) {
    _inherits(FacilityAnalystUpstream3DService, _CommonServiceBase);

    function FacilityAnalystUpstream3DService(url, options) {
        _classCallCheck(this, FacilityAnalystUpstream3DService);

        var _this = _possibleConstructorReturn(this, (FacilityAnalystUpstream3DService.__proto__ || Object.getPrototypeOf(FacilityAnalystUpstream3DService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FacilityAnalystUpstream3DService";
        return _this;
    }

    /**
     * @function SuperMap.FacilityAnalystUpstream3DService.prototype.destroy
     * @override
     */


    _createClass(FacilityAnalystUpstream3DService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FacilityAnalystUpstream3DService.prototype.__proto__ || Object.getPrototypeOf(FacilityAnalystUpstream3DService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FacilityAnalystUpstream3DService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FacilityAnalystUpstream3DParameters} 上游关键设施查找资源参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "upstreamcirticalfaclilities" : "/upstreamcirticalfaclilities") + ".json?";
            jsonObject = {
                sourceNodeIDs: params.sourceNodeIDs,
                edgeID: params.edgeID,
                nodeID: params.nodeID,
                isUncertainDirectionValid: params.isUncertainDirectionValid
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FacilityAnalystUpstream3DService;
}(_CommonServiceBase3.default);

exports.default = FacilityAnalystUpstream3DService;


_SuperMap2.default.FacilityAnalystUpstream3DService = FacilityAnalystUpstream3DService;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(1);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FieldStatisticsParameters = __webpack_require__(166);

var _FieldStatisticsParameters2 = _interopRequireDefault(_FieldStatisticsParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FieldStatisticService
 * @classdesc 字段查询统计服务类。用来完成对指定数据集指定字段的查询统计分析，即求平均值，最大值等。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为:http://localhost:8090/iserver/services/data-world/rest/data 即可。
 * @param options - {Object} 可选参数。</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 *        datasource - {string} 数据集所在的数据源名称。</br>
 *        dataset - {string} 数据集名称。</br>
 *        field - {string} 查询统计的目标字段名称。</br>
 *        statisticMode - {StatisticMode} 字段查询统计的方法类型。</br>
 * @example
 * var myService = new SuperMap.FieldStatisticService(url, {eventListeners: {
 *     "processCompleted": fieldStatisticCompleted,
 *     "processFailed": fieldStatisticError
 *     }，
 *     datasource: "World",
 *     dataset: "Countries",
 *     field: "SmID",
 *     statisticMode: StatisticMode.AVERAGE
 * };
 */

var FieldStatisticService = function (_CommonServiceBase) {
    _inherits(FieldStatisticService, _CommonServiceBase);

    /**
     * @member SuperMap.FieldStatisticService.prototype.field -{string}
     * @description 查询统计的目标字段名称。
     */


    /**
     * @member SuperMap.FieldStatisticService.prototype.datasource -{string}
     * @description 数据集所在的数据源名称。
     */
    function FieldStatisticService(url, options) {
        _classCallCheck(this, FieldStatisticService);

        var _this = _possibleConstructorReturn(this, (FieldStatisticService.__proto__ || Object.getPrototypeOf(FieldStatisticService)).call(this, url, options));

        _this.datasource = null;
        _this.dataset = null;
        _this.field = null;
        _this.statisticMode = null;
        _this.CLASS_NAME = "SuperMap.FieldStatisticService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.FieldStatisticService.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.FieldStatisticService.prototype.statisticMode -{string}
     * @description 字段查询统计的方法类型。
     */


    /**
     * @member SuperMap.FieldStatisticService.prototype.dataset -{string}
     * @description 数据集名称。
     */


    _createClass(FieldStatisticService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FieldStatisticService.prototype.__proto__ || Object.getPrototypeOf(FieldStatisticService.prototype), 'destroy', this).call(this);
            var me = this;
            me.datasource = null;
            me.dataset = null;
            me.field = null;
            me.statisticMode = null;
        }

        /**
         * @function SuperMap.FieldStatisticService.prototype.processAsync
         * @description 执行服务，进行指定字段的查询统计。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            var me = this,
                end = me.url.substr(me.url.length - 1, 1),
                fieldStatisticURL = "datasources/" + me.datasource + "/datasets/" + me.dataset + "/fields/" + me.field + "/" + me.statisticMode;
            me.url += end == "/" ? fieldStatisticURL + ".json?" : "/" + fieldStatisticURL + ".json?";

            me.request({
                method: "GET",
                data: null,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return FieldStatisticService;
}(_CommonServiceBase3.default);

exports.default = FieldStatisticService;


_SuperMap2.default.FieldStatisticService = FieldStatisticService;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindClosestFacilitiesParameters = __webpack_require__(167);

var _FindClosestFacilitiesParameters2 = _interopRequireDefault(_FindClosestFacilitiesParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindClosestFacilitiesService
 * @classdesc 最近设施分析服务类。<br>
 *               最近设施分析是指在网络上给定一个事件点和一组设施点，
 *               查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *               该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *              最近设施分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var myfindClosestFacilitiesService = new SuperMap.FindClosestFacilitiesService(url, {
 *     eventListeners: {
 *	       "processCompleted": findClosestFacilitiesCompleted,
 *		   "processFailed": findClosestFacilitiesError
 *		   }
 * });
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FindClosestFacilitiesService = function (_NetworkAnalystServic) {
    _inherits(FindClosestFacilitiesService, _NetworkAnalystServic);

    /*
     * @function SuperMap.FindClosestFacilitiesService.prototype.constructor
     * @description 最近设施分析服务类构造函数。
     * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
     *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
     *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
     * @param options - {Object} 互服务时所需可选参数。如：<br>
     *         eventListeners - {Object} 需要被注册的监听器对象。
     */
    function FindClosestFacilitiesService(url, options) {
        _classCallCheck(this, FindClosestFacilitiesService);

        var _this = _possibleConstructorReturn(this, (FindClosestFacilitiesService.__proto__ || Object.getPrototypeOf(FindClosestFacilitiesService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindClosestFacilitiesService";
        return _this;
    }

    /**
     * @function SuperMap.FindClosestFacilitiesService.prototype.destroy
     * @override
     */


    _createClass(FindClosestFacilitiesService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindClosestFacilitiesService.prototype.__proto__ || Object.getPrototypeOf(FindClosestFacilitiesService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindClosestFacilitiesService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindClosestFacilitiesParameters} 最近设施分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "closestfacility" : "/closestfacility") + ".json?";
            jsonObject = {
                expectFacilityCount: params.expectFacilityCount,
                fromEvent: params.fromEvent,
                maxWeight: params.maxWeight,
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                event: _SuperMap2.default.Util.toJSON(params.event),
                facilities: me.getJson(params.isAnalyzeById, params.facilities)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindClosestFacilitiesService.prototype.getJson
         * @description 将对象转化为JSON字符串。
         * @param isAnalyzeById - {boolean} 是否通过ID来分析
         * @param params - {Array} 分析参数数组
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJson',
        value: function getJson(isAnalyzeById, params) {
            var jsonString = "[",
                len = params ? params.length : 0;

            if (isAnalyzeById === false) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
                }
            } else if (isAnalyzeById == true) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += params[i];
                }
            }
            jsonString += ']';
            return jsonString;
        }

        /**
         * @function SuperMap.FindClosestFacilitiesService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result || !result.facilityPathList) {
                return result;
            }

            var geoJSONFormat = new _GeoJSON2.default();
            result.facilityPathList.map(function (path) {
                if (path.route) {
                    path.route = JSON.parse(geoJSONFormat.write(path.route));
                }
                if (path.pathGuideItems) {
                    path.pathGuideItems = JSON.parse(geoJSONFormat.write(path.pathGuideItems));
                }
                if (path.edgeFeatures) {
                    path.edgeFeatures = JSON.parse(geoJSONFormat.write(path.edgeFeatures));
                }
                if (path.nodeFeatures) {
                    path.nodeFeatures = JSON.parse(geoJSONFormat.write(path.nodeFeatures));
                }
            });
            return result;
        }
    }]);

    return FindClosestFacilitiesService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindClosestFacilitiesService;


_SuperMap2.default.FindClosestFacilitiesService = FindClosestFacilitiesService;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindLocationParameters = __webpack_require__(168);

var _FindLocationParameters2 = _interopRequireDefault(_FindLocationParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindLocationService
 * @classdesc 选址分区分析服务类。
 *               选址分区分析是为了确定一个或多个待建设施的最佳或最优位置，使得设施可以用一种最经济有效的方式为需求方提供服务或者商品。
 *               选址分区不仅仅是一个选址过程，还要将需求点的需求分配到相应的新建设施的服务区中，因此称之为选址与分区。
 *               选址分区分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * (start code)
 * var findLocationService = new SuperMap.FindLocationService(url, {
 *     eventListeners: {
 *         "processCompleted": findLocationCompleted,
 *		   "processFailed": findLocationError
 *		   }
 * });
 * (end)
 * @param url - {string} 服务的访问地址。<br>
 *                        如 http://localhost:8090/iserver/services/transportationanalyst-sample/rest/networkanalyst/RoadNet@Changchun 。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FindLocationService = function (_NetworkAnalystServic) {
    _inherits(FindLocationService, _NetworkAnalystServic);

    function FindLocationService(url, options) {
        _classCallCheck(this, FindLocationService);

        var _this = _possibleConstructorReturn(this, (FindLocationService.__proto__ || Object.getPrototypeOf(FindLocationService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindLocationService";
        return _this;
    }

    /**
     * @function SuperMap.FindLocationService.prototype.destroy
     * @override
     */


    _createClass(FindLocationService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindLocationService.prototype.__proto__ || Object.getPrototypeOf(FindLocationService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindLocationService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindLocationParameters} 选址分区分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "location" : "/location") + ".json?";
            jsonObject = {
                isFromCenter: params.isFromCenter,
                expectedSupplyCenterCount: params.expectedSupplyCenterCount,
                weightName: params.weightName,
                turnWeightField: params.turnWeightField,
                returnEdgeFeature: true,
                returnEdgeGeometry: true,
                returnNodeFeature: true,
                mapParameter: _SuperMap2.default.Util.toJSON(params.mapParameter),
                supplyCenters: me.getCentersJson(params.supplyCenters)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindLocationService.prototype.getCentersJson
         * @description 将数组对象转化为JSON字符串。
         * @param params - {Array} 需要转换的参数
         * @return {string} 转化后的JSON字符串。
         */

    }, {
        key: 'getCentersJson',
        value: function getCentersJson(params) {
            var json = "[",
                len = params ? params.length : 0;
            for (var i = 0; i < len; i++) {
                if (i > 0) json += ",";
                json += _SuperMap2.default.Util.toJSON(params[i]);
            }
            json += "]";
            return json;
        }

        /**
         * @function SuperMap.FindLocationService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            if (result.demandResults) {
                result.demandResults = JSON.parse(geoJSONFormat.write(result.demandResults));
            }
            if (result.supplyResults) {
                result.supplyResults = JSON.parse(geoJSONFormat.write(result.supplyResults));
            }

            return result;
        }
    }]);

    return FindLocationService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindLocationService;


_SuperMap2.default.FindLocationService = FindLocationService;

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindMTSPPathsParameters = __webpack_require__(169);

var _FindMTSPPathsParameters2 = _interopRequireDefault(_FindMTSPPathsParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindMTSPPathsService
 * @classdesc 多旅行商分析服务类<br>
 *               多旅行商分析也称为物流配送，是指在网络数据集中，给定 M 个配送中心点和 N 个配送目的地（M，N 为大于零的整数）。<br>
 *               查找经济有效的配送路径，并给出相应的行走路线。<br>
 *               物流配送功能就是解决如何合理分配配送次序和送货路线，使配送总花费达到最小或每个配送中心的花费达到最小。<br>
 *               该类负责将客户端指定的多旅行商分析参数传递给服务端，并接收服务端返回的结果数据。<br>
 *               多旅行商分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var myFindMTSPPathsService = new SuperMap.FindMTSPPathsService(url, {
 *     eventListeners: {
 *         "processCompleted": findMTSPPathsCompleted,
 *		   "processFailed": findMTSPPathsError
 *		   }
 * });
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                       http://{服务器地址}:{服务端口号}/iserver/services/网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FindMTSPPathsService = function (_NetworkAnalystServic) {
    _inherits(FindMTSPPathsService, _NetworkAnalystServic);

    function FindMTSPPathsService(url, options) {
        _classCallCheck(this, FindMTSPPathsService);

        var _this = _possibleConstructorReturn(this, (FindMTSPPathsService.__proto__ || Object.getPrototypeOf(FindMTSPPathsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindMTSPPathsService";
        return _this;
    }

    /**
     * @function SuperMap.FindMTSPPathsService.prototype.destroy
     * @override
     */


    _createClass(FindMTSPPathsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindMTSPPathsService.prototype.__proto__ || Object.getPrototypeOf(FindMTSPPathsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindMTSPPathsService..prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindMTSPPathsParameters} 多旅行商分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1),
                centers = me.getJson(params.isAnalyzeById, params.centers),
                nodes = me.getJson(params.isAnalyzeById, params.nodes);
            me.url = me.url + "/mtsppath" + ".json?";
            jsonObject = {
                centers: centers,
                nodes: nodes,
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                hasLeastTotalCost: params.hasLeastTotalCost
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindMTSPPathsService.prototype.getJson
         * @description 将对象转化为JSON字符串。
         * @param isAnalyzeById - {boolean} 是否通过id分析
         * @param params - {Array} 需要转换的数字
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJson',
        value: function getJson(isAnalyzeById, params) {
            var jsonString = "[",
                len = params ? params.length : 0;

            if (isAnalyzeById === false) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
                }
            } else if (isAnalyzeById == true) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += params[i];
                }
            }
            jsonString += ']';
            return jsonString;
        }

        /**
         * @function SuperMap.FindMTSPPathsService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result || !result.pathList) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            result.pathList.map(function (path) {
                if (path.route) {
                    path.route = JSON.parse(geoJSONFormat.write(path.route));
                }
                if (path.pathGuideItems) {
                    path.pathGuideItems = JSON.parse(geoJSONFormat.write(path.pathGuideItems));
                }
                if (path.edgeFeatures) {
                    path.edgeFeatures = JSON.parse(geoJSONFormat.write(path.edgeFeatures));
                }
                if (path.nodeFeatures) {
                    path.nodeFeatures = JSON.parse(geoJSONFormat.write(path.nodeFeatures));
                }
            });
            return result;
        }
    }]);

    return FindMTSPPathsService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindMTSPPathsService;


_SuperMap2.default.FindMTSPPathsService = FindMTSPPathsService;

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindPathParameters = __webpack_require__(170);

var _FindPathParameters2 = _interopRequireDefault(_FindPathParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindPathService
 * @classdesc 最佳路径分析服务类。<br>
 *               最佳路径是在网络数据集中指定一些节点，按照节点的选择顺序，<br>
 *               顺序访问这些节点从而求解起止点之间阻抗最小的路经。<br>
 *               该类负责将客户端指定的最佳路径分析参数传递给服务端，并接收服务端返回的结果数据。<br>
 *               最佳路径分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var myFindPathService = new SuperMap.FindPathService(url, {
 *     eventListeners: {
 *	       "processCompleted": findPathCompleted,
 *		   "processFailed": findPathError
 *		   }
 * });
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *               http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *               例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var FindPathService = function (_NetworkAnalystServic) {
    _inherits(FindPathService, _NetworkAnalystServic);

    function FindPathService(url, options) {
        _classCallCheck(this, FindPathService);

        var _this = _possibleConstructorReturn(this, (FindPathService.__proto__ || Object.getPrototypeOf(FindPathService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindPathService";
        return _this;
    }

    /**
     * @function SuperMap.FindPathService.prototype.destroy
     * @override
     */


    _createClass(FindPathService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindPathService.prototype.__proto__ || Object.getPrototypeOf(FindPathService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindPathService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindPathParameters} 最佳路径分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "path" : "/path") + ".json?";
            jsonObject = {
                hasLeastEdgeCount: params.hasLeastEdgeCount,
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                nodes: me.getJson(params.isAnalyzeById, params.nodes)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindPathService.prototype.getJson
         * @description 将对象转化为JSON字符串。
         * @param isAnalyzeById - {boolean} 是否通过id分析
         * @param params - {Array} 需要转换的数字
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJson',
        value: function getJson(isAnalyzeById, params) {
            var jsonString = "[",
                len = params ? params.length : 0;

            if (isAnalyzeById === false) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
                }
            } else if (isAnalyzeById == true) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += params[i];
                }
            }
            jsonString += ']';
            return jsonString;
        }

        /**
         * @function SuperMap.FindMTSPPathsService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result || !result.pathList || result.pathList.length < 1) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            result.pathList.forEach(function (path) {
                if (path.route) {
                    path.route = JSON.parse(geoJSONFormat.write(path.route));
                }
                if (path.pathGuideItems) {
                    path.pathGuideItems = JSON.parse(geoJSONFormat.write(path.pathGuideItems));
                }
                if (path.edgeFeatures) {
                    path.edgeFeatures = JSON.parse(geoJSONFormat.write(path.edgeFeatures));
                }
                if (path.nodeFeatures) {
                    path.nodeFeatures = JSON.parse(geoJSONFormat.write(path.nodeFeatures));
                }
            });
            return result;
        }
    }]);

    return FindPathService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindPathService;


_SuperMap2.default.FindPathService = FindPathService;

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindServiceAreasParameters = __webpack_require__(171);

var _FindServiceAreasParameters2 = _interopRequireDefault(_FindServiceAreasParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindServiceAreasService
 * @classdesc 服务区分析服务类。<br>
 *               服务区分析是以指定服务站点为中心，<br>
 *               在一定服务范围内查找网络上服务站点能够提供服务的区域范围。<br>
 *               该类负责将客户端指定的服务区分析参数传递给服务端，并接收服务端返回的结果数据。<br>
 *               服务区分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var myFindServiceAreasService = new SuperMap.FindServiceAreasService(url, {
 *          eventListeners: {
 *              "processCompleted": findServiceAreasCompleted,
 *              "processFailed": findServiceAreasError
 *          }
 * });
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                        例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象
 */
var FindServiceAreasService = function (_NetworkAnalystServic) {
    _inherits(FindServiceAreasService, _NetworkAnalystServic);

    function FindServiceAreasService(url, options) {
        _classCallCheck(this, FindServiceAreasService);

        var _this = _possibleConstructorReturn(this, (FindServiceAreasService.__proto__ || Object.getPrototypeOf(FindServiceAreasService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindServiceAreasService";
        return _this;
    }

    /**
     * @function SuperMap.FindServiceAreasService.prototype.destroy
     * @override
     */


    _createClass(FindServiceAreasService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindServiceAreasService.prototype.__proto__ || Object.getPrototypeOf(FindServiceAreasService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindServiceAreasService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindServiceAreasParameters} 服务区分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "servicearea" : "/servicearea") + ".json?";
            jsonObject = {
                isFromCenter: params.isFromCenter,
                isCenterMutuallyExclusive: params.isCenterMutuallyExclusive,
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                centers: me.getJson(params.isAnalyzeById, params.centers),
                weights: me.getJson(true, params.weights)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindServiceAreasService.prototype.getJson
         * @description 将对象转化为JSON字符串。
         * @param isAnalyzeById - {boolean} 是否通过id分析
         * @param params - {Array} 需要转换的数字
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJson',
        value: function getJson(isAnalyzeById, params) {
            var jsonString = "[",
                len = params ? params.length : 0;

            if (isAnalyzeById === false) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
                }
            } else if (isAnalyzeById == true) {
                for (var i = 0; i < len; i++) {
                    if (i > 0) jsonString += ",";
                    jsonString += params[i];
                }
            }
            jsonString += ']';
            return jsonString;
        }

        /**
         * @function SuperMap.FindServiceAreasService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result || !result.serviceAreaList) {
                return result;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            result.serviceAreaList.map(function (serviceArea) {
                if (serviceArea.serviceRegion) {
                    serviceArea.serviceRegion = JSON.parse(geoJSONFormat.write(serviceArea.serviceRegion));
                }
                if (serviceArea.edgeFeatures) {
                    serviceArea.edgeFeatures = JSON.parse(geoJSONFormat.write(serviceArea.edgeFeatures));
                }
                if (serviceArea.nodeFeatures) {
                    serviceArea.nodeFeatures = JSON.parse(geoJSONFormat.write(serviceArea.nodeFeatures));
                }
                if (serviceArea.routes) {
                    serviceArea.routes = JSON.parse(geoJSONFormat.write(serviceArea.routes));
                }
            });

            return result;
        }
    }]);

    return FindServiceAreasService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindServiceAreasService;


_SuperMap2.default.FindServiceAreasService = FindServiceAreasService;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _FindTSPPathsParameters = __webpack_require__(172);

var _FindTSPPathsParameters2 = _interopRequireDefault(_FindTSPPathsParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.FindTSPPathsService
 * @classdesc 旅行商分析服务类<br>
 *               旅行商分析是路径分析的一种，它从起点开始（默认为用户指定的第一点）查找能够遍历所有途经点且花费最小的路径。
 *               旅行商分析也可以指定到达的终点，这时查找从起点能够遍历所有途经点最后到达终点，且花费最小的路径。
 *               该类负责将客户端指定的旅行商分析参数传递给服务端，并接收服务端返回的结果数据。
 *               旅行商分析结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * (start code)
 * var myFindTSPPathsService = new SuperMap.FindTSPPathsService(url, {
 *     eventListeners: {
 *	      "processCompleted": findTSPPathsCompleted,
 *		  "processFailed": findTSPPathsError
 *		  }
 *  });
 * (end)
 * @param url - {string} 网络分析服务地址。请求网络分析服务，URL应为：
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var FindTSPPathsService = function (_NetworkAnalystServic) {
    _inherits(FindTSPPathsService, _NetworkAnalystServic);

    function FindTSPPathsService(url, options) {
        _classCallCheck(this, FindTSPPathsService);

        var _this = _possibleConstructorReturn(this, (FindTSPPathsService.__proto__ || Object.getPrototypeOf(FindTSPPathsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.FindTSPPathsService";
        return _this;
    }

    /**
     * @function SuperMap.FindTSPPathsService.prototype.destroy
     * @override
     */


    _createClass(FindTSPPathsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(FindTSPPathsService.prototype.__proto__ || Object.getPrototypeOf(FindTSPPathsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.FindTSPPathsService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {SuperMap.FindTSPPathsParameters} 旅行商分析服务参数类
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonObject,
                end = me.url.substr(me.url.length - 1, 1);
            me.url = me.url + (end === "/" ? "tsppath" : "/tsppath") + ".json?";
            jsonObject = {
                parameter: _SuperMap2.default.Util.toJSON(params.parameter),
                endNodeAssigned: params.endNodeAssigned,
                nodes: me.getNodesJson(params)
            };
            me.request({
                method: "GET",
                params: jsonObject,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.FindTSPPathsService.prototype.getNodesJson
         * @description 将节点对象转化为JSON字符串。
         * @param params - {SuperMap.FindTSPPathsParameters}
         * @return {string} 转化后的JSON字符串。
         */

    }, {
        key: 'getNodesJson',
        value: function getNodesJson(params) {
            var jsonParameters = "",
                nodesString,
                i,
                len,
                nodes;
            if (params.isAnalyzeById === false) {
                for (nodesString = "[", i = 0, nodes = params.nodes, len = nodes.length; i < len; i++) {
                    if (i > 0) nodesString += ",";
                    nodesString += '{"x":' + nodes[i].x + ',"y":' + nodes[i].y + '}';
                }
                nodesString += ']';
                jsonParameters += nodesString;
            } else if (params.isAnalyzeById == true) {
                for (var nodeIDsString = "[", i = 0, nodes = params.nodes, len = nodes.length; i < len; i++) {
                    if (i > 0) nodeIDsString += ",";
                    nodeIDsString += nodes[i];
                }
                nodeIDsString += ']';
                jsonParameters += nodeIDsString;
            }
            return jsonParameters;
        }

        /**
         * @function SuperMap.FindTSPPathsService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result || !result.tspPathList) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2.default();
            result.tspPathList.forEach(function (path) {
                if (path.route) {
                    path.route = JSON.parse(geoJSONFormat.write(path.route));
                }
                if (path.pathGuideItems) {
                    path.pathGuideItems = JSON.parse(geoJSONFormat.write(path.pathGuideItems));
                }
                if (path.edgeFeatures) {
                    path.edgeFeatures = JSON.parse(geoJSONFormat.write(path.edgeFeatures));
                }
                if (path.nodeFeatures) {
                    path.nodeFeatures = JSON.parse(geoJSONFormat.write(path.nodeFeatures));
                }
            });
            return result;
        }
    }]);

    return FindTSPPathsService;
}(_NetworkAnalystServiceBase2.default);

exports.default = FindTSPPathsService;


_SuperMap2.default.FindTSPPathsService = FindTSPPathsService;

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _GenerateSpatialDataParameters = __webpack_require__(173);

var _GenerateSpatialDataParameters2 = _interopRequireDefault(_GenerateSpatialDataParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GenerateSpatialDataService
 * @classdesc
 * 动态分段分析服务类。
 * 该类负责将客户设置的动态分段分析服务参数传递给服务端，并接收服务端返回的动态分段分析结果数据。
 * 获取的结果数据包括 originResult 、result 两种，其中，originResult 为服务端返回的用 JSON 对象表示的动态分段分析结果数据，result 为服务端返回的动态分段分析结果数据。
 *  @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 *  @param options - {Object} 可选参数。如:</br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.SpatialAnalystBase
 * @example 实例化该类如下例所示：
 * (start code)
 *  function GenerateSpatialData(){
     *
     *  //配置数据返回选项(option)
     *  var option = new SuperMap.DataReturnOption({
     *      expectCount: 1000,
     *      dataset: "generateSpatialData",
     *      deleteExistResultDataset: true,
     *      dataReturnMode: SuperMap.DataReturnMode.DATASET_ONLY
     *  }),
     *  //配置动态分段参数(Parameters)
     *  parameters = new SuperMap.GenerateSpatialDataParameters({
     *      routeTable: "RouteDT_road@Changchun",
     *      routeIDField: "RouteID",
     *      eventTable: "LinearEventTabDT@Changchun",
     *      eventRouteIDField: "RouteID",
     *      measureField: "",
     *      measureStartField: "LineMeasureFrom",
     *      measureEndField: "LineMeasureTo",
     *      measureOffsetField: "",
     *      errorInfoField: "",
     *      retainedFields:[],
     *      dataReturnOption: option
     *  }),
     *  //配置动态分段iService
     *  iService = new SuperMap.GenerateSpatialDataService(Changchun_spatialanalyst, {
     *      eventListeners: {
     *          processCompleted: generateCompleted,
     *          processFailed: generateFailded
     *      }
     *  });
     *  //执行
     *  iService.processAsync(parameters);
     *  function Completed(generateSpatialDataEventArgs){//todo};
     *  function Error(generateSpatialDataEventArgs){//todo};
     * (end)
     */
var GenerateSpatialDataService = function (_SpatialAnalystBase) {
    _inherits(GenerateSpatialDataService, _SpatialAnalystBase);

    function GenerateSpatialDataService(url, options) {
        _classCallCheck(this, GenerateSpatialDataService);

        var _this = _possibleConstructorReturn(this, (GenerateSpatialDataService.__proto__ || Object.getPrototypeOf(GenerateSpatialDataService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GenerateSpatialDataService";
        return _this;
    }

    /**
     * @function SuperMap.GenerateSpatialDataService.prototype.destroy
     * @override
     */


    _createClass(GenerateSpatialDataService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GenerateSpatialDataService.prototype.__proto__ || Object.getPrototypeOf(GenerateSpatialDataService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GenerateSpatialDataService.prototype.processAsync
         * @description 负责将客户端的动态分段服务参数传递到服务端。
         * @param params - {SuperMap.GenerateSpatialDataParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters;

            jsonParameters = me.getJsonParameters(params);

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.GenerateSpatialDataService.prototype.getJsonParameters
         * @description 将参数转化为 JSON 字符串。
         * @param params -  {SuperMap.GenerateSpatialDataParameters}
         * @return {string}转化后的JSON字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var jsonParameters = "",
                jsonStr = "datasets/" + params.routeTable + "/linearreferencing/generatespatialdata",
                me = this,
                end;

            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? jsonStr + ".json" : "/" + jsonStr + ".json";

            me.url += "?returnContent=true";
            jsonParameters = _SuperMap2.default.Util.toJSON(params);
            return jsonParameters;
        }
    }]);

    return GenerateSpatialDataService;
}(_SpatialAnalystBase3.default);

exports.default = GenerateSpatialDataService;


_SuperMap2.default.GenerateSpatialDataService = GenerateSpatialDataService;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _GeoRelationAnalystParameters = __webpack_require__(176);

var _GeoRelationAnalystParameters2 = _interopRequireDefault(_GeoRelationAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GeoRelationAnalystService
 * @classdesc
 * 空间关系分析服务类。
 * 该类负责将客户设置的空间关系分析服务参数传递给服务端，并接收服务端返回的空间关系分析结果数据。
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param options - {Object} 可选参数。</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.SpatialAnalystBase
 * @example 实例化该类如下例所示：
 * (start code)
 *  function datasetGeoRelationAnalystProcess() {
     *      var referenceFilter = new SuperMap.FilterParameter({
     *                              name:"Frame_R@Changchun",
     *                              attributeFilter:"SmID>0"});
     *      var sourceFilter = new SuperMap.FilterParameter({
     *                          attributeFilter:"SmID>0"});
     *      //初始化服务类
     *      var datasetGeoRelationService = new SuperMap.GeoRelationAnalystService(
     *          "http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst/"),
     *      //构建参数类
     *      datasetGeoRelationParameters = new SuperMap.GeoRelationAnalystParameters({
     *          dataset: "Park@Changchun",
     *          startRecord: 0,
     *          expectCount: 20,
     *          sourceFilter: sourceFilter,
     *          referenceFilter: referenceFilter,
     *          spatialRelationType: SuperMap.SpatialRelationType.INTERSECT,
     *          isBorderInside: true,
     *          returnFeature: true,
     *          returnGeoRelatedOnly: true
     *      });
     *      datasetGeoRelationService.events.on({
     *          "processCompleted": datasetGeoRelationAnalystCompleted,
     *          "processFailed": datasetGeoRelationAnalystFailed});
     *      //执行
     *      datasetGeoRelationService.processAsync(datasetGeoRelationParameters);
     *  }
 *  function Completed(datasetGeoRelationAnalystCompleted){//todo};
 *  function Error(datasetGeoRelationAnalystFailed){//todo};
 * (end)
 *
 */
var GeoRelationAnalystService = function (_SpatialAnalystBase) {
    _inherits(GeoRelationAnalystService, _SpatialAnalystBase);

    function GeoRelationAnalystService(url, options) {
        _classCallCheck(this, GeoRelationAnalystService);

        var _this = _possibleConstructorReturn(this, (GeoRelationAnalystService.__proto__ || Object.getPrototypeOf(GeoRelationAnalystService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GeoRelationAnalystService";
        return _this;
    }

    /**
     * @function SuperMap.GeoRelationAnalystService.prototype.destroy
     * @override
     */


    _createClass(GeoRelationAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GeoRelationAnalystService.prototype.__proto__ || Object.getPrototypeOf(GeoRelationAnalystService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GeoRelationAnalystService.prototype.processAsync
         * @description 负责将客户端的空间关系分析参数传递到服务端
         * @param parameter - {GeoRelationAnalystParameters} 空间关系分析所需的参数信息。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var me = this;
            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {
                me.url += 'datasets/' + parameter.dataset + '/georelation';
            } else {
                me.url += '/datasets/' + parameter.dataset + '/georelation';
            }

            var jsonParameters = _SuperMap2.default.Util.toJSON(parameter);

            me.url += '.json?returnContent=true';

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return GeoRelationAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = GeoRelationAnalystService;


_SuperMap2.default.GeoRelationAnalystService = GeoRelationAnalystService;

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GetFeaturesServiceBase = __webpack_require__(22);

var _GetFeaturesServiceBase2 = _interopRequireDefault(_GetFeaturesServiceBase);

var _GetFeaturesByBoundsParameters = __webpack_require__(181);

var _GetFeaturesByBoundsParameters2 = _interopRequireDefault(_GetFeaturesByBoundsParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesByBoundsService
 * @classdesc 数据集范围查询服务类,查询与指定范围对象符合一定空间关系的矢量要素。
 * @description 数据集范围查询服务类构造函数。
 * @extends SuperMap.GetFeaturesServiceBase
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务，URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/；
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myGetFeaturesByBoundsService = new SuperMa.GetFeaturesByBoundsService(url, {
 *     eventListeners: {
 *           "processCompleted": getFeatureCompleted,
 *           "processFailed": getFeatureError
 *           }
 * });
 * function getFeatureCompleted(object){//todo};
 * function getFeatureError(object){//todo}
 */

var GetFeaturesByBoundsService = function (_GetFeaturesServiceBa) {
    _inherits(GetFeaturesByBoundsService, _GetFeaturesServiceBa);

    function GetFeaturesByBoundsService(url, options) {
        _classCallCheck(this, GetFeaturesByBoundsService);

        var _this = _possibleConstructorReturn(this, (GetFeaturesByBoundsService.__proto__ || Object.getPrototypeOf(GetFeaturesByBoundsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GetFeaturesByBoundsService";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesByBoundsService.prototype.destroy
     * @override
     */


    _createClass(GetFeaturesByBoundsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesByBoundsService.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesByBoundsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GetFeaturesByBoundsService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。在本类中重写此方法，可以实现不同种类的查询（ID, SQL, Buffer, Geometry,Bounds等）。
         * @param params {SuperMap.GetFeaturesByBoundsParameters}
         * @return {string} 转化后的 JSON 字符串。
         *
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            return _GetFeaturesByBoundsParameters2.default.toJsonParameters(params);
        }
    }]);

    return GetFeaturesByBoundsService;
}(_GetFeaturesServiceBase2.default);

exports.default = GetFeaturesByBoundsService;


_SuperMap2.default.GetFeaturesByBoundsService = GetFeaturesByBoundsService;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GetFeaturesServiceBase = __webpack_require__(22);

var _GetFeaturesServiceBase2 = _interopRequireDefault(_GetFeaturesServiceBase);

var _GetFeaturesByBufferParameters = __webpack_require__(182);

var _GetFeaturesByBufferParameters2 = _interopRequireDefault(_GetFeaturesByBufferParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesByBufferService
 * @classdesc 数据服务中数据集缓冲区查询服务类。
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务，
 * URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/；
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @extends SuperMap.GetFeaturesServiceBase
 * @example
 * var myGetFeaturesByBufferService = new SuperMap.GetFeaturesByBufferService(url, {
 *     eventListeners: {
 *           "processCompleted": GetFeaturesCompleted,
 *           "processFailed": GetFeaturesError
 *           }
 * });
 * function GetFeaturesCompleted(object){//todo};
 * function GetFeaturesError(object){//todo};
 */

var GetFeaturesByBufferService = function (_GetFeaturesServiceBa) {
    _inherits(GetFeaturesByBufferService, _GetFeaturesServiceBa);

    function GetFeaturesByBufferService(url, options) {
        _classCallCheck(this, GetFeaturesByBufferService);

        var _this = _possibleConstructorReturn(this, (GetFeaturesByBufferService.__proto__ || Object.getPrototypeOf(GetFeaturesByBufferService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GetFeaturesByBufferService";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesByBufferService.prototype.destroy
     * @override
     */


    _createClass(GetFeaturesByBufferService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesByBufferService.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesByBufferService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GetFeaturesByBufferService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。在本类中重写此方法，可以实现不同种类的查询（IDs, SQL, Buffer, Geometry等）。
         * @param params {SuperMap.GetFeaturesByBufferParameters}
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            return _SuperMap2.default.GetFeaturesByBufferParameters.toJsonParameters(params);
        }
    }]);

    return GetFeaturesByBufferService;
}(_GetFeaturesServiceBase2.default);

exports.default = GetFeaturesByBufferService;


_SuperMap2.default.GetFeaturesByBufferService = GetFeaturesByBufferService;

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GetFeaturesServiceBase = __webpack_require__(22);

var _GetFeaturesServiceBase2 = _interopRequireDefault(_GetFeaturesServiceBase);

var _GetFeaturesByGeometryParameters = __webpack_require__(183);

var _GetFeaturesByGeometryParameters2 = _interopRequireDefault(_GetFeaturesByGeometryParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesByGeometryService
 * @classdesc 数据集几何查询服务类,查询与指定几何对象符合一定空间关系的矢量要素。
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务。
 * URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data；
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data"
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @extends SuperMap.GetFeaturesServiceBase
 * @example
 * var myService = new SuperMap.GetFeaturesByGeometryService(url, {
     *     eventListeners: {
     *           "processCompleted": getFeatureCompleted,
     *           "processFailed": getFeatureError
     *           }
     * });
 * function getFeatureCompleted(object){//todo};
 * function getFeatureError(object){//todo}
 */
var GetFeaturesByGeometryService = function (_GetFeaturesServiceBa) {
    _inherits(GetFeaturesByGeometryService, _GetFeaturesServiceBa);

    function GetFeaturesByGeometryService(url, options) {
        _classCallCheck(this, GetFeaturesByGeometryService);

        var _this = _possibleConstructorReturn(this, (GetFeaturesByGeometryService.__proto__ || Object.getPrototypeOf(GetFeaturesByGeometryService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GetFeaturesByGeometryService";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesByGeometryService.prototype.destroy
     * @override
     */


    _createClass(GetFeaturesByGeometryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesByGeometryService.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesByGeometryService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GetFeaturesByGeometryService.prototype.getJsonParameters
         * @param params - {SuperMap.GetFeaturesByGeometryParameters}
         * @description 将查询参数转化为 JSON 字符串。
         * 在本类中重写此方法，可以实现不同种类的查询（ID, SQL, Buffer, Geometry等）。
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            return _GetFeaturesByGeometryParameters2.default.toJsonParameters(params);
        }
    }]);

    return GetFeaturesByGeometryService;
}(_GetFeaturesServiceBase2.default);

exports.default = GetFeaturesByGeometryService;


_SuperMap2.default.GetFeaturesByGeometryService = GetFeaturesByGeometryService;

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GetFeaturesServiceBase = __webpack_require__(22);

var _GetFeaturesServiceBase2 = _interopRequireDefault(_GetFeaturesServiceBase);

var _GetFeaturesByIDsParameters = __webpack_require__(184);

var _GetFeaturesByIDsParameters2 = _interopRequireDefault(_GetFeaturesByIDsParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesByIDsService
 * @classdesc 数据集ID查询服务类。在数据集集合中查找指定 ID 号对应的空间地物要素。
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务。
 *              URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/；</br>
 *              例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param options - {Object} 可選参数。如:</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @extends SuperMap.GetFeaturesServiceBase
 * @example
 * var myGetFeaturesByIDsService = new SuperMap.GetFeaturesByIDsService(url, {
 *     eventListeners: {
 *         "processCompleted": getFeatureCompleted,
 *         "processFailed": getFeatureError
 *            }
 *     });
 * function getFeatureCompleted(object){//todo};
 * function getFeatureError(object){//todo}
 */
var GetFeaturesByIDsService = function (_GetFeaturesServiceBa) {
    _inherits(GetFeaturesByIDsService, _GetFeaturesServiceBa);

    function GetFeaturesByIDsService(url, options) {
        _classCallCheck(this, GetFeaturesByIDsService);

        var _this = _possibleConstructorReturn(this, (GetFeaturesByIDsService.__proto__ || Object.getPrototypeOf(GetFeaturesByIDsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GetFeaturesByIDsService";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesByIDsService.prototype.destroy
     * @override
     */


    _createClass(GetFeaturesByIDsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesByIDsService.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesByIDsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.GetFeaturesByIDsService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         * 在本类中重写此方法，可以实现不同种类的查询（ID, SQL, Buffer, Geometry等）。
         * @param  params - {SuperMap.GetFeaturesByIDsParameters}
         * @return {string} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            return _GetFeaturesByIDsParameters2.default.toJsonParameters(params);
        }
    }]);

    return GetFeaturesByIDsService;
}(_GetFeaturesServiceBase2.default);

exports.default = GetFeaturesByIDsService;


_SuperMap2.default.GetFeaturesByIDsService = GetFeaturesByIDsService;

/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _GetFeaturesServiceBase = __webpack_require__(22);

var _GetFeaturesServiceBase2 = _interopRequireDefault(_GetFeaturesServiceBase);

var _GetFeaturesBySQLParameters = __webpack_require__(185);

var _GetFeaturesBySQLParameters2 = _interopRequireDefault(_GetFeaturesBySQLParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesBySQLService
 * @constructs SuperMap.GetFeaturesBySQLService
 * @classdesc
 * 数据服务中数据集 SQL 查询服务类。
 * 在一个或多个指定的图层上查询符合 SQL 条件的空间地物信息。
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务，
 * URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/；</br>
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param  options - {Object} 可选参数。如</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @extends SuperMap.GetFeaturesServiceBase
 * @example
 * var myGetFeaturesBySQLService = new SuperMap.GetFeaturesBySQLService(url, {
     *     eventListeners: {
     *         "processCompleted": GetFeaturesCompleted,
     *         "processFailed": GetFeaturesError
     *         }
     * });
 * function getFeaturesCompleted(object){//todo};
 * function getFeaturesError(object){//todo};
 *
 */
var GetFeaturesBySQLService = function (_GetFeaturesServiceBa) {
    _inherits(GetFeaturesBySQLService, _GetFeaturesServiceBa);

    function GetFeaturesBySQLService(url, options) {
        _classCallCheck(this, GetFeaturesBySQLService);

        var _this = _possibleConstructorReturn(this, (GetFeaturesBySQLService.__proto__ || Object.getPrototypeOf(GetFeaturesBySQLService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.GetFeaturesBySQLService";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesBySQLService.prototype.destroy
     * @override
     */


    _createClass(GetFeaturesBySQLService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesBySQLService.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesBySQLService.prototype), 'destroy', this).call(this);
        }

        /*
         * @function SuperMap.GetFeaturesBySQLService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         * 在本类中重写此方法，可以实现不同种类的查询（ID, SQL, Buffer, Geometry等）。
         * @param params - {SuperMap.GetFeaturesBySQLParameters}
         * @return {string} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            return _GetFeaturesBySQLParameters2.default.toJsonParameters(params);
        }
    }]);

    return GetFeaturesBySQLService;
}(_GetFeaturesServiceBase2.default);

exports.default = GetFeaturesBySQLService;


_SuperMap2.default.GetFeaturesBySQLService = GetFeaturesBySQLService;

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFieldsService
 * @classdesc 字段查询服务，支持查询指定数据集的中所有属性字段（field）的集合。
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/data-world/rest/data 即可。
 * @param options - {Object} 可選参数。如:</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 *        datasource - {string}</br>
 *        dataset - {string}</br>
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myService = new SuperMap.GetFieldsService(url, {eventListeners: {
 *     "processCompleted": getFieldsCompleted,
 *     "processFailed": getFieldsError
 *     },
 *     datasource: "World",
 *     dataset: "Countries"
 * };
 *
 */
var GetFieldsService = function (_CommonServiceBase) {
    _inherits(GetFieldsService, _CommonServiceBase);

    /**
     * @member SuperMap.GetFieldsService.prototype.datasource -{string}
     * @description 要查询的数据集所在的数据源名称。
     */
    function GetFieldsService(url, options) {
        _classCallCheck(this, GetFieldsService);

        var _this = _possibleConstructorReturn(this, (GetFieldsService.__proto__ || Object.getPrototypeOf(GetFieldsService)).call(this, url, options));

        _this.datasource = null;
        _this.dataset = null;
        _this.CLASS_NAME = "SuperMap.GetFieldsService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.GetFieldsService.prototype.destroy
     * @override
     */


    /**
     *  @member SuperMap.GetFieldsService.prototype.dataset -{string}
     *  @description 要查询的数据集名称。
     */


    _createClass(GetFieldsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFieldsService.prototype.__proto__ || Object.getPrototypeOf(GetFieldsService.prototype), 'destroy', this).call(this);
            var me = this;
            me.datasource = null;
            me.dataset = null;
        }

        /**
         * @function SuperMap.GetFieldsService.prototype.processAsync
         * @description 执行服务，查询指定数据集的字段信息。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            var me = this,
                end = me.url.substr(me.url.length - 1, 1),
                datasetURL = "datasources/" + me.datasource + "/datasets/" + me.dataset;
            me.url += end == "/" ? datasetURL + "/fields.json?" : "/" + datasetURL + "/fields.json?";

            me.request({
                method: "GET",
                data: null,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return GetFieldsService;
}(_CommonServiceBase3.default);

exports.default = GetFieldsService;


_SuperMap2.default.GetFieldsService = GetFieldsService;

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _GetGridCellInfosParameters = __webpack_require__(186);

var _GetGridCellInfosParameters2 = _interopRequireDefault(_GetGridCellInfosParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetGridCellInfosService
 * @classdesc 数据栅格查询服务，支持查询指定地理位置的栅格信息。
 * @param url - {string} 查询服务地址。例如: http://localhost:8090/iserver/services/data-jingjin/rest/data
 * @param options - {Object} 可選参数。如:</br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myService = new SuperMap.GetGridCellInfosService(url, {eventListeners: {
 *     "processCompleted": queryCompleted,
 *     "processFailed": queryError
 *     }
 * });
 *
 */
var GetGridCellInfosService = function (_CommonServiceBase) {
    _inherits(GetGridCellInfosService, _CommonServiceBase);

    /**
     * @member SuperMap.GetGridCellInfosService.prototype.X -{number}
     * @description 要查询的地理位置X轴
     */


    /**
     * @member SuperMap.GetGridCellInfosService.prototype.dataSourceName -{string}
     * @description 数据源名称。
     */
    function GetGridCellInfosService(url, options) {
        _classCallCheck(this, GetGridCellInfosService);

        var _this = _possibleConstructorReturn(this, (GetGridCellInfosService.__proto__ || Object.getPrototypeOf(GetGridCellInfosService)).call(this, url, options));

        _this.datasetName = null;
        _this.dataSourceName = null;
        _this.datasetType = null;
        _this.X = null;
        _this.Y = null;
        _this.CLASS_NAME = "SuperMap.GetGridCellInfosService";

        if (!!options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.GetGridCellInfosService.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.GetGridCellInfosService.prototype.Y-{number}
     * @description 要查询的地理位置Y轴
     */


    /**
     * @member SuperMap.GetGridCellInfosService.prototype.datasetType -{string}
     * @description 数据集类型。
     */


    /**
     * @member SuperMap.GetGridCellInfosService.prototype.datasetName -{string}
     * @description 数据集名称。
     */


    _createClass(GetGridCellInfosService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetGridCellInfosService.prototype.__proto__ || Object.getPrototypeOf(GetGridCellInfosService.prototype), 'destroy', this).call(this);
            var me = this;
            me.X = null;
            me.Y = null;
            me.datasetName = null;
            me.dataSourceName = null;
            me.datasetType = null;
        }

        /**
         * @function SuperMap.GetGridCellInfosService.prototype.processAsync
         * @description 执行服务，查询数据集信息。
         * params - {SuperMap.GetGridCellInfosParameters} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (params) {
                _SuperMap2.default.Util.extend(this, params);
            }
            var me = this;
            var end = me.url.substr(me.url.length - 1, 1);
            me.url += end == "/" ? "datasources/" + me.dataSourceName + "/datasets/" + me.datasetName + ".json" : "/datasources/" + me.dataSourceName + "/datasets/" + me.datasetName + ".json";

            me.queryRequest(me.getDatasetInfoCompleted, me.getDatasetInfoFailed);
        }

        /**
         * @function SuperMap.GetGridCellInfosService.prototype.queryRequest
         * @description 执行服务，查询。
         * @param successFun -{function} 成功后执行的函数
         * @param failedFunc -{function} 失败后执行的函数
         */

    }, {
        key: 'queryRequest',
        value: function queryRequest(successFun, failedFunc) {
            var me = this;
            me.request({
                method: "GET",
                data: null,
                scope: me,
                success: successFun,
                failure: failedFunc
            });
        }

        /**
         * @function SuperMap.GetGridCellInfosService.prototype.getDatasetInfoCompleted
         * @description  数据集查询完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getDatasetInfoCompleted',
        value: function getDatasetInfoCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            me.datasetType = result.datasetInfo.type;
            me.queryGridInfos();
        }

        /**
         * @function SuperMap.GetGridCellInfosService.prototype.queryGridInfos
         * @description 执行服务，查询数据集栅格信息信息。
         */

    }, {
        key: 'queryGridInfos',
        value: function queryGridInfos() {
            var me = this,
                re = /\.json/,
                index = re.exec(me.url).index,
                urlBack = me.url.substring(index),
                urlFront = me.url.substring(0, me.url.length - urlBack.length);
            if (me.datasetType == "GRID") {
                me.url = urlFront + "/gridValue" + urlBack;
            } else {
                me.url = urlFront + "/imageValue" + urlBack;
            }

            if (me.X != null && me.Y != null) {
                me.url += '?x=' + me.X + '&y=' + me.Y;
            }
            me.queryRequest(me.serviceProcessCompleted, me.serviceProcessFailed);
        }

        /**
         * @function SuperMap.GetGridCellInfosService.prototype.getDatasetInfoFailed
         * @description 数据集查询失败，执行此方法。
         * @param result -  {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getDatasetInfoFailed',
        value: function getDatasetInfoFailed(result) {
            var me = this;
            me.serviceProcessFailed(result);
        }
    }]);

    return GetGridCellInfosService;
}(_CommonServiceBase3.default);

exports.default = GetGridCellInfosService;


_SuperMap2.default.GetGridCellInfosService = GetGridCellInfosService;

/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _ServerTheme = __webpack_require__(210);

var _ServerTheme2 = _interopRequireDefault(_ServerTheme);

var _Grid = __webpack_require__(187);

var _Grid2 = _interopRequireDefault(_Grid);

var _Image = __webpack_require__(188);

var _Image2 = _interopRequireDefault(_Image);

var _Vector = __webpack_require__(246);

var _Vector2 = _interopRequireDefault(_Vector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetLayersInfoService
 * @classdesc 获取图层信息服务类构造函数。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 与客户端交互的地图服务地址。请求地图服务,URL 应为：<br>
 *         http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；<br>
 *         如 http://localhost:8090/iserver/services/map-world/rest/maps/World 。<br>
 *         如果查询临时图层的信息，请指定完成的url，包含临时图层ID信息，如：<br>
 *         http://localhost:8090/iserver/services/map-world/rest/maps/World/tempLayersSet/resourceID
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *         serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *         format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 *         isTempLayers - {boolean} 当前url对应的图层是否是临时图层。
 */
var GetLayersInfoService = function (_CommonServiceBase) {
    _inherits(GetLayersInfoService, _CommonServiceBase);

    function GetLayersInfoService(url, options) {
        _classCallCheck(this, GetLayersInfoService);

        var _this = _possibleConstructorReturn(this, (GetLayersInfoService.__proto__ || Object.getPrototypeOf(GetLayersInfoService)).call(this, url, options));

        _this.isTempLayers = false;
        _this.CLASS_NAME = "SuperMap.GetLayersInfoService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.GetLayersInfoService.prototype.destroy
     * @override
     */

    /**
     * @member SuperMap.GetLayersInfoService.prototype.isTempLayers -{Boolean}
     * @description 当前url对应的图层是否是临时图层。
     */


    _createClass(GetLayersInfoService, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetLayersInfoService.prototype.__proto__ || Object.getPrototypeOf(GetLayersInfoService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.GetLayersInfoService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            var me = this,
                method = "GET",
                end = me.url.substr(me.url.length - 1, 1);
            if (!me.isTempLayers) {
                me.url += end === "/" ? '' : '/';
                me.url += "layers.json?";
            } else {
                me.url += ".json?";
            }
            me.request({
                method: method,
                params: null,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.GetLayersInfoService.prototype.serviceProcessCompleted
         * @description 编辑完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                existRes,
                layers,
                len;
            result = _SuperMap2.default.Util.transformResult(result);

            existRes = !!result && result.length > 0;
            layers = existRes ? result[0].subLayers.layers : null;
            len = layers ? layers.length : 0;
            me.handleLayers(len, layers);
            me.events.triggerEvent("processCompleted", { result: result[0] });
        }

        /**
         * TODO 专题图时候可能会用到
         * @function SuperMap.GetLayersInfoService.prototype.handleLayers
         * @description 处理iserver 新增图层组数据 (subLayers.layers 中可能还会含有 subLayers.layers)
         * @param len - {number} subLayers.layers的长度
         * @param layers - {Array} subLayers.layers
         */

    }, {
        key: 'handleLayers',
        value: function handleLayers(len, layers) {
            var me = this,
                tempLayer;
            if (len) {
                for (var i = 0; i < len; i++) {
                    if (layers[i].subLayers && layers[i].subLayers.layers && layers[i].subLayers.layers.length > 0) {
                        me.handleLayers(layers[i].subLayers.layers.length, layers[i].subLayers.layers);
                    } else {
                        var type = layers[i].ugcLayerType;
                        switch (type) {
                            case 'THEME':
                                tempLayer = new _ServerTheme2.default();
                                tempLayer.fromJson(layers[i]);
                                layers[i] = tempLayer;
                                break;
                            case 'GRID':
                                tempLayer = new _Grid2.default();
                                tempLayer.fromJson(layers[i]);
                                layers[i] = tempLayer;
                                break;
                            case 'IMAGE':
                                tempLayer = new _Image2.default();
                                tempLayer.fromJson(layers[i]);
                                layers[i] = tempLayer;
                                break;
                            case 'VECTOR':
                                tempLayer = new _Vector2.default();
                                tempLayer.fromJson(layers[i]);
                                layers[i] = tempLayer;
                                break;
                            default:
                                break;
                        }
                    }
                }
            }
        }
    }]);

    return GetLayersInfoService;
}(_CommonServiceBase3.default);

exports.default = GetLayersInfoService;


_SuperMap2.default.GetLayersInfoService = GetLayersInfoService;

/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _InterpolationRBFAnalystParameters = __webpack_require__(192);

var _InterpolationRBFAnalystParameters2 = _interopRequireDefault(_InterpolationRBFAnalystParameters);

var _InterpolationDensityAnalystParameters = __webpack_require__(189);

var _InterpolationDensityAnalystParameters2 = _interopRequireDefault(_InterpolationDensityAnalystParameters);

var _InterpolationIDWAnalystParameters = __webpack_require__(190);

var _InterpolationIDWAnalystParameters2 = _interopRequireDefault(_InterpolationIDWAnalystParameters);

var _InterpolationKrigingAnalystParameters = __webpack_require__(191);

var _InterpolationKrigingAnalystParameters2 = _interopRequireDefault(_InterpolationKrigingAnalystParameters);

var _InterpolationAnalystParameters = __webpack_require__(23);

var _InterpolationAnalystParameters2 = _interopRequireDefault(_InterpolationAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.InterpolationAnalystService
 * @classdesc
 * 插值分析服务类
 * 插值分析可以将有限的采样点数据，通过插值算法对采样点周围的数值情况进行预测，可以掌握研究区域内数据的总体分布状况，从而使采样的离散点不仅仅反映其所在位置的数值情况，还可以反映区域的数值分布。目前SuperMap iServer的插值功能提供从点数据集插值得到栅格数据集的功能，支持以下常用的内插方法，包括：反距离加权插值、克吕金（Kriging）插值法、样条（径向基函数，Radial Basis Function）插值、点密度插值。
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param options - {Object} 可选参数。如</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 *
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var myTInterpolationAnalystService = new SuperMap.InterpolationAnalystService(url);
 * myTInterpolationAnalystService.events.on({
     *     "processCompleted": processCompleted,
     *     "processFailed": processFailed
     *     }
 * );
 * (end)
 *
 */
var InterpolationAnalystService = function (_SpatialAnalystBase) {
    _inherits(InterpolationAnalystService, _SpatialAnalystBase);

    function InterpolationAnalystService(url, options) {
        _classCallCheck(this, InterpolationAnalystService);

        var _this = _possibleConstructorReturn(this, (InterpolationAnalystService.__proto__ || Object.getPrototypeOf(InterpolationAnalystService)).call(this, url, options));

        _this.mode = null;
        _this.CLASS_NAME = "SuperMap.InterpolationAnalystService";

        var me = _this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.InterpolationAnalystService.prototype.destroy
     * @description 释放资源,将引用资源的属性置空。
     */

    /**
     * @member SuperMap.InterpolationAnalystService.prototype.mode -{string}
     * @description 插值分析类型。
     */

    _createClass(InterpolationAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(InterpolationAnalystService.prototype.__proto__ || Object.getPrototypeOf(InterpolationAnalystService.prototype), 'destroy', this).call(this);
            this.mode = null;
        }

        /**
         * @function SuperMap.InterpolationAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param  parameter - {SuperMap.InterpolationAnalystParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var parameterObject = {};
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            if (parameter instanceof _InterpolationDensityAnalystParameters2.default) {
                me.mode = "Density";
                if (parameter.InterpolationAnalystType === "geometry") {
                    me.url += 'geometry/interpolation/density';
                } else {
                    me.url += 'datasets/' + parameter.dataset + '/interpolation/density';
                }
            } else if (parameter instanceof _InterpolationIDWAnalystParameters2.default) {
                me.mode = "IDW";
                if (parameter.InterpolationAnalystType === "geometry") {
                    me.url += 'geometry/interpolation/idw';
                } else {
                    me.url += 'datasets/' + parameter.dataset + '/interpolation/idw';
                }
            } else if (parameter instanceof _InterpolationRBFAnalystParameters2.default) {
                me.mode = "RBF";
                if (parameter.InterpolationAnalystType === "geometry") {
                    me.url += 'geometry/interpolation/rbf';
                } else {
                    me.url += 'datasets/' + parameter.dataset + '/interpolation/rbf';
                }
            } else if (parameter instanceof _InterpolationKrigingAnalystParameters2.default) {
                me.mode = "Kriging";
                if (parameter.InterpolationAnalystType === "geometry") {
                    me.url += 'geometry/interpolation/kriging';
                } else {
                    me.url += 'datasets/' + parameter.dataset + '/interpolation/kriging';
                }
            }
            _InterpolationAnalystParameters2.default.toObject(parameter, parameterObject);
            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return InterpolationAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = InterpolationAnalystService;


_SuperMap2.default.InterpolationAnalystService = InterpolationAnalystService;

/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ProcessingServiceBase = __webpack_require__(24);

var _ProcessingServiceBase2 = _interopRequireDefault(_ProcessingServiceBase);

var _KernelDensityJobParameter = __webpack_require__(193);

var _KernelDensityJobParameter2 = _interopRequireDefault(_KernelDensityJobParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.KernelDensityJobsService
 * @classdesc 核密度分析服务类
 * @extends SuperMap.ProcessingServiceBase
 * @param url -{string} 核密度分析服务地址。
 * @param options - {Object} 交互服务时所需可选参数。
 */
var KernelDensityJobsService = function (_ProcessingServiceBas) {
    _inherits(KernelDensityJobsService, _ProcessingServiceBas);

    function KernelDensityJobsService(url, options) {
        _classCallCheck(this, KernelDensityJobsService);

        var _this = _possibleConstructorReturn(this, (KernelDensityJobsService.__proto__ || Object.getPrototypeOf(KernelDensityJobsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.KernelDensityJobsService";

        _this.url += "/spatialanalyst/density";
        return _this;
    }

    /**
     * @function SuperMap.KernelDensityJobsService.prototype.destroy
     * @override
     */


    _createClass(KernelDensityJobsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(KernelDensityJobsService.prototype.__proto__ || Object.getPrototypeOf(KernelDensityJobsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.KernelDensityJobsService.prototype.getKernelDensityJobs
         * @description 获取核密度分析任务
         */

    }, {
        key: 'getKernelDensityJobs',
        value: function getKernelDensityJobs() {
            _get(KernelDensityJobsService.prototype.__proto__ || Object.getPrototypeOf(KernelDensityJobsService.prototype), 'getJobs', this).call(this, this.url);
        }

        /**
         * @function SuperMap.KernelDensityJobsService.prototype.getKernelDensityJobs
         * @description 获取指定id的核密度分析服务
         * @param id -{string} 指定要获取数据的id
         */

    }, {
        key: 'getKernelDensityJob',
        value: function getKernelDensityJob(id) {
            _get(KernelDensityJobsService.prototype.__proto__ || Object.getPrototypeOf(KernelDensityJobsService.prototype), 'getJobs', this).call(this, this.url + '/' + id);
        }

        /**
         * @function SuperMap.KernelDensityJobsService.prototype.addKernelDensityJob
         * @description 新建核密度分析服务
         * @param params - {SuperMap.KernelDensityJobParameter} 创建一个空间分析的请求参数。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addKernelDensityJob',
        value: function addKernelDensityJob(params, seconds) {
            _get(KernelDensityJobsService.prototype.__proto__ || Object.getPrototypeOf(KernelDensityJobsService.prototype), 'addJob', this).call(this, this.url, params, _KernelDensityJobParameter2.default, seconds);
        }
    }]);

    return KernelDensityJobsService;
}(_ProcessingServiceBase2.default);

exports.default = KernelDensityJobsService;


_SuperMap2.default.KernelDensityJobsService = KernelDensityJobsService;

/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.MapService
 * @classdesc 地图信息服务类。
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myMapService = new SuperMap.MapService(url, {
 * eventListeners:{
 *     "processCompleted": MapServiceCompleted,
 *       "processFailed": MapServiceFailed
 *       }
 * });
 *
 * @param url - {string} 服务的访问地址。如：http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 。
 * @param options - {Object} 可选参数 。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var MapService = function (_CommonServiceBase) {
    _inherits(MapService, _CommonServiceBase);

    function MapService(url, options) {
        _classCallCheck(this, MapService);

        var _this = _possibleConstructorReturn(this, (MapService.__proto__ || Object.getPrototypeOf(MapService)).call(this, url, options));

        _this.projection = null;
        _this.CLASS_NAME = "SuperMap.MapService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var me = _this;

        me.url += ".json";

        if (me.projection) {
            var arr = me.projection.split(":");
            if (arr instanceof Array) {
                if (arr.length === 2) {
                    me.url += "?prjCoordSys={\"epsgCode\":" + arr[1] + "}";
                }
                if (arr.length === 1) {
                    me.url += "?prjCoordSys={\"epsgCode\":" + arr[0] + "}";
                }
            }
        }
        return _this;
    }

    /**
     * @function  destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    /**
     * @member  SuperMap.MapService.prototype.projection -{string}
     * @description 根据投影参数获取地图状态信息。如"EPSG:4326"
     */


    _createClass(MapService, [{
        key: 'destroy',
        value: function destroy() {
            _get(MapService.prototype.__proto__ || Object.getPrototypeOf(MapService.prototype), 'destroy', this).call(this);
            var me = this;
            if (me.events) {
                me.events.un(me.eventListeners);
                me.events.listeners = null;
                me.events.destroy();
                me.events = null;
                me.eventListeners = null;
            }
        }

        /**
         * @function  SuperMap.MapService.prototype.processAsync
         * @description 负责将客户端的设置的参数传递到服务端，与服务端完成异步通讯。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            var me = this;
            me.request({
                method: "GET",
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /*
         * Method: getMapStatusCompleted
         * 获取地图状态完成，执行此方法。
         *
         * Parameters:
         * result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            var codeStatus = result.code >= 200 && result.code < 300 || result.code == 0 || result.code === 304;
            var isCodeValid = result.code && codeStatus;
            if (!result.code || isCodeValid) {
                me.events && me.events.triggerEvent("processCompleted", { result: result });
            }
            //在没有token是返回的是200，但是其实是没有权限，所以这里也应该是触发失败事件
            else {
                    me.events.triggerEvent("processFailed", { error: result });
                }
        }
    }]);

    return MapService;
}(_CommonServiceBase3.default);

exports.default = MapService;


_SuperMap2.default.MapService = MapService;

/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _MathExpressionAnalysisParameters = __webpack_require__(200);

var _MathExpressionAnalysisParameters2 = _interopRequireDefault(_MathExpressionAnalysisParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.MathExpressionAnalysisService
 * @classdesc 栅格代数运算服务类。
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var myMathExpressionAnalysisService = new SuperMap.MathExpressionAnalysisService(url);
 * myMathExpressionAnalysisService.on({
     *     "processCompleted": processCompleted,
     *     "processFailed": processFailed
     *     }
 * );
 * (end)
 *
 */
var MathExpressionAnalysisService = function (_SpatialAnalystBase) {
    _inherits(MathExpressionAnalysisService, _SpatialAnalystBase);

    function MathExpressionAnalysisService(url, options) {
        _classCallCheck(this, MathExpressionAnalysisService);

        var _this = _possibleConstructorReturn(this, (MathExpressionAnalysisService.__proto__ || Object.getPrototypeOf(MathExpressionAnalysisService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.MathExpressionAnalysisService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(MathExpressionAnalysisService, [{
        key: 'destroy',
        value: function destroy() {
            _get(MathExpressionAnalysisService.prototype.__proto__ || Object.getPrototypeOf(MathExpressionAnalysisService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.MathExpressionAnalysisService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param  parameter - {SuperMap.MathExpressionAnalysisParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            var parameterObject = {};

            if (parameter instanceof _MathExpressionAnalysisParameters2.default) {
                me.url += 'datasets/' + parameter.dataset + '/mathanalyst';
            }

            _MathExpressionAnalysisParameters2.default.toObject(parameter, parameterObject);
            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return MathExpressionAnalysisService;
}(_SpatialAnalystBase3.default);

exports.default = MathExpressionAnalysisService;


_SuperMap2.default.MathExpressionAnalysisService = MathExpressionAnalysisService;

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _MeasureParameters = __webpack_require__(201);

var _MeasureParameters2 = _interopRequireDefault(_MeasureParameters);

var _ServerGeometry = __webpack_require__(5);

var _ServerGeometry2 = _interopRequireDefault(_ServerGeometry);

var _REST = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.MeasureService
 * @classdesc 量算服务类。
 *              该类负责将量算参数传递到服务端，并获取服务端返回的量算结果。
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myMeasuerService = new SuperMap.MeasureService(url, {
 *      measureMode: SuperMap.MeasureMode.DISTANCE,
 *      eventListeners:{
 *          "processCompleted": measureCompleted
 *      }
 * });
 * @param url - {string} 服务访问的地址。如：http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 。
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。<br>
 *        measureMode - {MeasureMode} 量算模式，包括距离量算模式和面积量算模式。
 */
var MeasureService = function (_CommonServiceBase) {
    _inherits(MeasureService, _CommonServiceBase);

    function MeasureService(url, options) {
        _classCallCheck(this, MeasureService);

        var _this = _possibleConstructorReturn(this, (MeasureService.__proto__ || Object.getPrototypeOf(MeasureService)).call(this, url, options));

        _this.measureMode = _REST.MeasureMode.DISTANCE;
        _this.CLASS_NAME = "SuperMap.MeasureService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @override
     */


    /**
     * @member SuperMap.MeasureService.prototype.measureMode -{SuperMap.MeasureMode}
     * @description 量算模式，包括距离量算模式和面积量算模式。默认值为：MeasureMode.DISTANCE 。
     */


    _createClass(MeasureService, [{
        key: 'destroy',
        value: function destroy() {
            _get(MeasureService.prototype.__proto__ || Object.getPrototypeOf(MeasureService.prototype), 'destroy', this).call(this);
            var me = this;
            me.measureMode = null;
        }

        /**
         * @function SuperMap.MeasureService.prototype.processAsync
         * @description 负责将客户端的量算参数传递到服务端。
         * @param params - {SuperMap.MeasureParameters} 量算参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                geometry = params.geometry,
                pointsCount = 0,
                point2ds = null,
                urlParameters = null,
                end = null;
            if (!geometry) {
                return;
            }
            end = me.url.substr(me.url.length - 1, 1);
            if (me.measureMode === _REST.MeasureMode.AREA) {
                me.url += end === "/" ? "area.json?" : "/area.json?";
            } else {
                me.url += end === "/" ? "distance.json?" : "/distance.json?";
            }
            var serverGeometry = _ServerGeometry2.default.fromGeometry(geometry);
            if (!serverGeometry) {
                return;
            }
            pointsCount = serverGeometry.parts[0];
            point2ds = serverGeometry.points.splice(0, pointsCount);

            var prjCoordSysTemp, prjCodeTemp, paramsTemp;
            if (params.prjCoordSys) {
                if (_typeof(params.prjCoordSys) === "object") {
                    prjCodeTemp = params.prjCoordSys.projCode;
                    prjCoordSysTemp = '{"epsgCode"' + prjCodeTemp.substring(prjCodeTemp.indexOf(":"), prjCodeTemp.length) + "}";
                } else if (typeof params.prjCoordSys === "string") {
                    prjCoordSysTemp = '{"epsgCode"' + params.prjCoordSys.substring(params.prjCoordSys.indexOf(":"), params.prjCoordSys.length) + "}";
                }
                paramsTemp = {
                    "point2Ds": _SuperMap2.default.Util.toJSON(point2ds),
                    "unit": params.unit,
                    "prjCoordSys": prjCoordSysTemp
                };
            } else {
                paramsTemp = { "point2Ds": _SuperMap2.default.Util.toJSON(point2ds), "unit": params.unit };
            }

            me.request({
                method: "GET",
                params: paramsTemp,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return MeasureService;
}(_CommonServiceBase3.default);

exports.default = MeasureService;


_SuperMap2.default.MeasureService = MeasureService;

/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _DatasetOverlayAnalystParameters = __webpack_require__(153);

var _DatasetOverlayAnalystParameters2 = _interopRequireDefault(_DatasetOverlayAnalystParameters);

var _GeometryOverlayAnalystParameters = __webpack_require__(178);

var _GeometryOverlayAnalystParameters2 = _interopRequireDefault(_GeometryOverlayAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.OverlayAnalystService
 * @classdesc
 * 叠加分析服务类
 * 该类负责将客户设置的叠加分析参数传递给服务端，并接收服务端返回的叠加分析结果数据。
 * 叠加分析结果通过该类支持的事件的监听函数参数获取
 * @param url - {string} 服务的访问地址。如http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @extends SuperMap.CommonServiceBase
 * @example 例如：
 * (start code)
 * var myOverlayAnalystService = new SuperMap.OverlayAnalystService(url, {
     *     eventListeners: {
     *	       "processCompleted": OverlayCompleted,
     *		   "processFailed": OverlayFailed
     *		   }
     * });
 * (end)
 */

var OverlayAnalystService = function (_SpatialAnalystBase) {
    _inherits(OverlayAnalystService, _SpatialAnalystBase);

    function OverlayAnalystService(url, options) {
        _classCallCheck(this, OverlayAnalystService);

        var _this = _possibleConstructorReturn(this, (OverlayAnalystService.__proto__ || Object.getPrototypeOf(OverlayAnalystService)).call(this, url, options));

        _this.mode = null;
        _this.CLASS_NAME = "SuperMap.OverlayAnalystService";

        var me = _this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        return _this;
    }

    /**
     * @override
     */


    /**
     * @member SuperMap.OverlayAnalystService.prototype.mode -{string}
     * @description 叠加分析类型
     */


    _createClass(OverlayAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(OverlayAnalystService.prototype.__proto__ || Object.getPrototypeOf(OverlayAnalystService.prototype), 'destroy', this).call(this);
            this.mode = null;
        }

        /**
         * @function SuperMap.OverlayAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param parameter - {SuperMap.OverlayAnalystParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var parameterObject = {};
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            if (parameter instanceof _DatasetOverlayAnalystParameters2.default) {
                me.mode = "datasets";
                me.url += 'datasets/' + parameter.sourceDataset + '/overlay';
                _DatasetOverlayAnalystParameters2.default.toObject(parameter, parameterObject);
            } else if (parameter instanceof _GeometryOverlayAnalystParameters2.default) {
                me.mode = "geometry";
                me.url += 'geometry/overlay';
                _GeometryOverlayAnalystParameters2.default.toObject(parameter, parameterObject);
            }

            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return OverlayAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = OverlayAnalystService;


_SuperMap2.default.OverlayAnalystService = OverlayAnalystService;

/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _QueryService2 = __webpack_require__(26);

var _QueryService3 = _interopRequireDefault(_QueryService2);

var _QueryByBoundsParameters = __webpack_require__(204);

var _QueryByBoundsParameters2 = _interopRequireDefault(_QueryByBoundsParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryByBoundsService
 * @classdesc Bounds 查询服务类。
 * @augments SuperMap.QueryService
 * @example
 * (start end)
 * var myQueryByBoundsService = new SuperMap.QueryByBoundsService(url, {
 *     eventListeners: {
 *         "processCompleted": queryCompleted,
 *		   "processFailed": queryError
 *		   }
 * });
 * function queryCompleted(object){//todo};
 * function queryError(object){//todo};
 * (end)
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var QueryByBoundsService = function (_QueryService) {
    _inherits(QueryByBoundsService, _QueryService);

    function QueryByBoundsService(url, options) {
        _classCallCheck(this, QueryByBoundsService);

        var _this = _possibleConstructorReturn(this, (QueryByBoundsService.__proto__ || Object.getPrototypeOf(QueryByBoundsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.QueryByBoundsService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(QueryByBoundsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryByBoundsService.prototype.__proto__ || Object.getPrototypeOf(QueryByBoundsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.QueryByBoundsService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         *              在本类中重写此方法，可以实现不同种类的查询（sql, geometry, distance, bounds 等）。
         * @param params - {SuperMap.QueryByBoundsParameters} Bounds 查询参数。
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var me = this,
                jsonParameters = "",
                qp = null,
                bounds = params.bounds;
            qp = me.getQueryParameters(params);
            jsonParameters += "'queryMode':'BoundsQuery','queryParameters':";
            jsonParameters += _SuperMap2.default.Util.toJSON(qp);
            jsonParameters += ",'bounds': {'rightTop':{'y':" + bounds.top + ",'x':" + bounds.right + "},'leftBottom':{'y':" + bounds.bottom + ",'x':" + bounds.left + "}}";
            jsonParameters = "{" + jsonParameters + "}";
            return jsonParameters;
        }
    }]);

    return QueryByBoundsService;
}(_QueryService3.default);

exports.default = QueryByBoundsService;


_SuperMap2.default.QueryByBoundsService = QueryByBoundsService;

/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _QueryService2 = __webpack_require__(26);

var _QueryService3 = _interopRequireDefault(_QueryService2);

var _QueryByDistanceParameters = __webpack_require__(205);

var _QueryByDistanceParameters2 = _interopRequireDefault(_QueryByDistanceParameters);

var _ServerGeometry = __webpack_require__(5);

var _ServerGeometry2 = _interopRequireDefault(_ServerGeometry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryByDistanceService
 * @description Distance查询服务类。
 * @extends SuperMap.QueryService
 * @example
 * var myQueryByDistService = new SuperMap.QueryByDistanceService(url, {
 *     eventListeners: {
 *         "processCompleted": queryCompleted,
 *		   "processFailed": queryError
 *		   }
 * });
 * function queryCompleted(object){//todo};
 * function queryError(object){//todo};
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为：http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var QueryByDistanceService = function (_QueryService) {
    _inherits(QueryByDistanceService, _QueryService);

    function QueryByDistanceService(url, options) {
        _classCallCheck(this, QueryByDistanceService);

        var _this = _possibleConstructorReturn(this, (QueryByDistanceService.__proto__ || Object.getPrototypeOf(QueryByDistanceService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.QueryByDistanceService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(QueryByDistanceService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryByDistanceService.prototype.__proto__ || Object.getPrototypeOf(QueryByDistanceService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.QueryByDistanceService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         *              在本类中重写此方法，可以实现不同种类的查询（sql, geometry, distance, bounds等）。
         * @param params - {SuperMap.QueryByDistanceParameters}
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var me = this,
                jsonParameters = "",
                qp = me.getQueryParameters(params);
            var sg = _ServerGeometry2.default.fromGeometry(params.geometry);

            jsonParameters += params.isNearest ? "'queryMode':'FindNearest','queryParameters':" : "'queryMode':'DistanceQuery','queryParameters':";
            jsonParameters += _SuperMap2.default.Util.toJSON(qp);
            jsonParameters += ",'geometry':" + _SuperMap2.default.Util.toJSON(sg) + ",'distance':" + params.distance;
            jsonParameters = "{" + jsonParameters + "}";
            return jsonParameters;
        }
    }]);

    return QueryByDistanceService;
}(_QueryService3.default);

exports.default = QueryByDistanceService;


_SuperMap2.default.QueryByDistanceService = QueryByDistanceService;

/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _QueryService2 = __webpack_require__(26);

var _QueryService3 = _interopRequireDefault(_QueryService2);

var _QueryByGeometryParameters = __webpack_require__(206);

var _QueryByGeometryParameters2 = _interopRequireDefault(_QueryByGeometryParameters);

var _ServerGeometry = __webpack_require__(5);

var _ServerGeometry2 = _interopRequireDefault(_ServerGeometry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryByGeometryService
 * @classdesc Geometry查询服务类。
 * @extends SuperMap.QueryService
 * @example
 * var myQueryByGeometryService = new SuperMap.QueryByGeometryService(url, {
 *     eventListeners: {
 *	      "processCompleted": queryCompleted,
 *		  "processFailed": queryError
 *		  }
 * });
 * function queryCompleted(object){//todo};
 * function queryError(object){//todo};
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var QueryByGeometryService = function (_QueryService) {
    _inherits(QueryByGeometryService, _QueryService);

    /*
     * @function SuperMap.QueryByGeometryService.prototype.constructor
     * @description Geometry 查询服务类构造函数。
     * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
     * @param options - {Object} 互服务时所需可选参数。如：<br>
     *         eventListeners - {Object} 需要被注册的监听器对象。
     */
    function QueryByGeometryService(url, options) {
        _classCallCheck(this, QueryByGeometryService);

        var _this = _possibleConstructorReturn(this, (QueryByGeometryService.__proto__ || Object.getPrototypeOf(QueryByGeometryService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.QueryByGeometryService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(QueryByGeometryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryByGeometryService.prototype.__proto__ || Object.getPrototypeOf(QueryByGeometryService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.QueryByGeometryService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         *              在本类中重写此方法，可以实现不同种类的查询（sql, geometry, distance, bounds等）。
         * @param params - {SuperMap.QueryByGeometryParameters}
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var me = this,
                jsonParameters = "",
                qp = null,
                geometry = params.geometry,
                sg = _ServerGeometry2.default.fromGeometry(geometry);
            qp = me.getQueryParameters(params);
            jsonParameters += "'queryMode':'SpatialQuery','queryParameters':";
            jsonParameters += _SuperMap2.default.Util.toJSON(qp) + ",'geometry':" + _SuperMap2.default.Util.toJSON(sg) + ",'spatialQueryMode':" + _SuperMap2.default.Util.toJSON(params.spatialQueryMode);
            jsonParameters = "{" + jsonParameters + "}";
            return jsonParameters;
        }
    }]);

    return QueryByGeometryService;
}(_QueryService3.default);

exports.default = QueryByGeometryService;


_SuperMap2.default.QueryByGeometryService = QueryByGeometryService;

/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _QueryService2 = __webpack_require__(26);

var _QueryService3 = _interopRequireDefault(_QueryService2);

var _QueryBySQLParameters = __webpack_require__(207);

var _QueryBySQLParameters2 = _interopRequireDefault(_QueryBySQLParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryBySQLService
 * @classdesc SQL 查询服务类。在一个或多个指定的图层上查询符合 SQL 条件的空间地物信息。
 * @extends SuperMap.QueryService
 * @example
 * var queryParam = new SuperMap.FilterParameter({
 *     name: "Countries@World.1",
 *     attributeFilter: "Pop_1994>1000000000 and SmArea>900"
 * });
 * var queryBySQLParams = new SuperMap.QueryBySQLParameters({
 *     queryParams: [queryParam]
 * });
 * var myQueryBySQLService = new SuperMap.QueryBySQLService(url, {eventListeners: {
 *     "processCompleted": queryCompleted,
 *     "processFailed": queryError
 *	   }
 * });
 * queryBySQLService.processAsync(queryBySQLParams);
 * function queryCompleted(object){//todo};
 * function queryError(object){//todo};
 * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var QueryBySQLService = function (_QueryService) {
    _inherits(QueryBySQLService, _QueryService);

    /*
     * @function SuperMap.QueryBySQLService.prototype.constructor
     * @descriptionSQL 查询服务类构造函数。
     * @param url - {string} 服务的访问地址。如访问World Map服务，只需将url设为: http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 即可。
     * @param options - {Object} 互服务时所需可选参数。如：<br>
     *         eventListeners - {Object} 需要被注册的监听器对象。
     */
    function QueryBySQLService(url, options) {
        _classCallCheck(this, QueryBySQLService);

        var _this = _possibleConstructorReturn(this, (QueryBySQLService.__proto__ || Object.getPrototypeOf(QueryBySQLService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.QueryBySQLService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(QueryBySQLService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryBySQLService.prototype.__proto__ || Object.getPrototypeOf(QueryBySQLService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.QueryBySQLService.prototype.getJsonParameters
         * @description 将查询参数转化为 JSON 字符串。
         *              在本类中重写此方法，可以实现不同种类的查询（sql, geometry, distance, bounds等）。
         * @param params - {SuperMap.QueryBySQLParameters}
         * @return {Object} 转化后的 JSON 字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var me = this,
                jsonParameters = "",
                qp = null;
            qp = me.getQueryParameters(params);
            jsonParameters += "'queryMode':'SqlQuery','queryParameters':";
            jsonParameters += _SuperMap2.default.Util.toJSON(qp);
            jsonParameters = "{" + jsonParameters + "}";
            return jsonParameters;
        }
    }]);

    return QueryBySQLService;
}(_QueryService3.default);

exports.default = QueryBySQLService;


_SuperMap2.default.QueryBySQLService = QueryBySQLService;

/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _RouteCalculateMeasureParameters = __webpack_require__(208);

var _RouteCalculateMeasureParameters2 = _interopRequireDefault(_RouteCalculateMeasureParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.RouteCalculateMeasureService
 * @classdesc
 * 该类负责将客户设置的计算指定点的M值参数传递给服务端，并接收服务端返回的
 *      指定点的M值。通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.SpatialAnalystBase
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。</br>
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst
 * @example 实例化该类如下例所示：
 * (start code)
 * var parameters = new SuperMap.RouteCalculateMeasureParameters({
     *     "sourceRoute":{
     *         "type":"LINEM",
     *        "parts":[4],
     *         "points":[
     *             {
     *                 "measure":0,
     *                 "y":-6674.466867067764,
     *                 "x":3817.3527876130133
     *             },
     *             {
     *                 "measure":199.57954019411724,
     *                 "y":-6670.830929417594,
     *                 "x":3617.806369901496
     *             },
     *             {
     *                 "measure":609.3656478634477,
     *                "y":-6877.837541432356,
     *                 "x":3264.1498746678444
     *             },
     *             {
     *                 "measure":936.0174126282958,
     *                 "y":-7038.687780615184,
     *                 "x":2979.846206068903
     *             }
     *         ]
     *     },
     *     "tolerance":1,
     *     "point":{
     *         "x":3330.7754269417,
     *         "y":-6838.8394457216
     *     },
     *     "isIgnoreGap":false
     * });
 *
 * var routeCalculateMeasureService = new SuperMap.RouteCalculateMeasureService(spatialAnalystURL, {
     *     eventListeners:{
     *         processCompleted:calculateCompleted,
     *         processFailed:calculateFailded
     *     }
     * );
     * routeCalculateMeasureService.processAsync(parameters);
     *
     *  //执行
     * function calculateCompleted(){todo}
     * function calculateFailded(){todo}
     * (end)
     *
     */
var RouteCalculateMeasureService = function (_SpatialAnalystBase) {
    _inherits(RouteCalculateMeasureService, _SpatialAnalystBase);

    function RouteCalculateMeasureService(url, options) {
        _classCallCheck(this, RouteCalculateMeasureService);

        var _this = _possibleConstructorReturn(this, (RouteCalculateMeasureService.__proto__ || Object.getPrototypeOf(RouteCalculateMeasureService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.RouteCalculateMeasureService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(RouteCalculateMeasureService, [{
        key: 'destroy',
        value: function destroy() {
            _get(RouteCalculateMeasureService.prototype.__proto__ || Object.getPrototypeOf(RouteCalculateMeasureService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.RouteCalculateMeasureService.prototype.processAsync
         * @description 负责将客户端的基于路由对象计算指定点M值操作的参数传递到服务端。
         * @param params - {SuperMap.RouteCalculateMeasureParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters;

            jsonParameters = me.getJsonParameters(params);

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.RouteCalculateMeasureService.prototype.getJsonParameters
         * @description 将参数转化为 JSON 字符串。
         * @param params - {SuperMap.RouteCalculateMeasureParameters}
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var jsonParameters,
                jsonStr = "geometry/calculatemeasure",
                me = this,
                end;
            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? jsonStr + ".json" : "/" + jsonStr + ".json";
            me.url += "?returnContent=true";
            jsonParameters = _SuperMap2.default.Util.toJSON(params);
            return jsonParameters;
        }
    }]);

    return RouteCalculateMeasureService;
}(_SpatialAnalystBase3.default);

exports.default = RouteCalculateMeasureService;


_SuperMap2.default.RouteCalculateMeasureService = RouteCalculateMeasureService;

/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _RouteLocatorParameters = __webpack_require__(209);

var _RouteLocatorParameters2 = _interopRequireDefault(_RouteLocatorParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.RouteLocatorService
 * @classdesc 路由对象定位空间对象的服务类。
 * @extends SuperMap.SpatialAnalystBase
 * @param options - {Object} 可选参数。如</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @param url -{string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @example 实例化该类如下例所示：
 * (start code)
 * var routeLocatorParameters_point = new SuperMap.RouteLocatorParameters({
     *   "sourceRoute":{
     *       "type":"LINEM",
     *       "parts":[4],
     *       "points":[
     *           {
     *               "measure":0,
     *               "y":-6674.466867067764,
     *               "x":3817.3527876130133
     *           },
     *           {
     *               "measure":199.57954019411724,
     *               "y":-6670.830929417594,
     *               "x":3617.806369901496
     *          },
     *           {
     *               "measure":609.3656478634477,
     *               "y":-6877.837541432356,
     *               "x":3264.1498746678444
     *           },
     *           {
     *               "measure":936.0174126282958,
     *               "y":-7038.687780615184,
     *               "x":2979.846206068903
     *           }
     *       ]
     *   },
     *   "type":"POINT",
     *   "measure":10,
     *   "offset":3,
     *   "isIgnoreGap":true
     * });
 * var routeLocatorService = new SuperMap.RouteLocatorService(spatialAnalystURL, {
     *     eventListeners:{
     *         processCompleted:routeLocatorCompleted,
     *         processFailed:routeLocatorFailded
     *     }
     * );
     * routeLocatorService.processAsync(routeLocatorParameters_point);
     *
     *  //执行
     * function routeLocatorCompleted(){todo}
     * function routeLocatorFailded(){todo}
     * (end)
     *
     */
var RouteLocatorService = function (_SpatialAnalystBase) {
    _inherits(RouteLocatorService, _SpatialAnalystBase);

    function RouteLocatorService(url, options) {
        _classCallCheck(this, RouteLocatorService);

        var _this = _possibleConstructorReturn(this, (RouteLocatorService.__proto__ || Object.getPrototypeOf(RouteLocatorService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.RouteLocatorService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(RouteLocatorService, [{
        key: 'destroy',
        value: function destroy() {
            _get(RouteLocatorService.prototype.__proto__ || Object.getPrototypeOf(RouteLocatorService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.RouteLocatorService.prototype.processAsync
         * @description 负责将客户端的基于路由对象计算指定点M值操作的参数传递到服务端。
         * @param params - {SuperMap.RouteLocatorParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters;

            jsonParameters = me.getJsonParameters(params);

            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.RouteLocatorService.prototype.processAsync
         * @description 将参数转化为 JSON 字符串。
         * @param params - {SuperMap.RouteLocatorParameters}
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var jsonParameters,
                jsonStr = "geometry/routelocator",
                me = this,
                end;
            end = me.url.substr(me.url.length - 1, 1);

            if (params.dataset) {
                jsonStr = "datasets/" + params.dataset + "/linearreferencing/routelocator";
                params.sourceRoute = null;
            }
            me.url += end === "/" ? jsonStr + ".json" : "/" + jsonStr + ".json";
            me.url += "?returnContent=true";
            jsonParameters = _SuperMap2.default.Util.toJSON(params);
            return jsonParameters;
        }
    }]);

    return RouteLocatorService;
}(_SpatialAnalystBase3.default);

exports.default = RouteLocatorService;


_SuperMap2.default.RouteLocatorService = RouteLocatorService;

/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _SetLayerInfoParameters = __webpack_require__(211);

var _SetLayerInfoParameters2 = _interopRequireDefault(_SetLayerInfoParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SetLayerInfoService
 * @classdesc 设置图层信息服务类。可以实现临时图层中子图层的修改
 *              该类负责将图层设置参数传递到服务端，并获取服务端返回的结果信息。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 与客户端交互的地图服务地址。请求地图服务,URL 应为：<br>
 *               http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}/tempLayersSet/{tempLayerID}/Rivers@World@@World"；
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var SetLayerInfoService = function (_CommonServiceBase) {
    _inherits(SetLayerInfoService, _CommonServiceBase);

    function SetLayerInfoService(url, options) {
        _classCallCheck(this, SetLayerInfoService);

        var _this = _possibleConstructorReturn(this, (SetLayerInfoService.__proto__ || Object.getPrototypeOf(SetLayerInfoService)).call(this, url, options));

        _this.resourceID = null;
        _this.CLASS_NAME = "SuperMap.SetLayerInfoService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        _this.resourceID = options.resourceID;
        return _this;
    }

    /**
     * @override
     */


    /**
     * @member SuperMap.SetLayerInfoService.prototype.resourceID - {string}
     * @description 图层资源ID，临时图层的资源ID标记。
     */


    _createClass(SetLayerInfoService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SetLayerInfoService.prototype.__proto__ || Object.getPrototypeOf(SetLayerInfoService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.SetLayerInfoService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {Object} 修改后的图层资源信息。<br>
         *        该参数可以使用获取图层信息服务 <SuperMap.GetLayerInfoService>.result.subLayers.layers[i]返回图层信息，然后对其属性进行修改来获取。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            var me = this;

            if (!params) {
                return;
            }
            me.url += ".json";
            var jsonParamsStr = _SuperMap2.default.Util.toJSON(params);
            me.request({
                method: "PUT",
                data: jsonParamsStr,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return SetLayerInfoService;
}(_CommonServiceBase3.default);

exports.default = SetLayerInfoService;


_SuperMap2.default.SetLayerInfoService = SetLayerInfoService;

/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _SetLayerStatusParameters = __webpack_require__(212);

var _SetLayerStatusParameters2 = _interopRequireDefault(_SetLayerStatusParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SetLayerStatusService
 * @classdesc  子图层显示控制服务类。该类负责将子图层显示控制参数传递到服务端，并获取服务端返回的图层显示状态。<br>
 *                用户获取服务端返回的各子图层显示状态有两种方式：<br>
 *                一种是通过监听 SetLayerEvent.PROCESS_COMPLETE 事件；<br>
 *                一种是使用 AsyncResponder 类实现异步处理。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 地图服务访问地址。请求地图服务,URL 应为：<br>
 *               http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *         serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *         format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var SetLayerStatusService = function (_CommonServiceBase) {
    _inherits(SetLayerStatusService, _CommonServiceBase);

    function SetLayerStatusService(url, options) {
        _classCallCheck(this, SetLayerStatusService);

        var _this = _possibleConstructorReturn(this, (SetLayerStatusService.__proto__ || Object.getPrototypeOf(SetLayerStatusService)).call(this, url, options));

        _this.lastparams = null;
        _this.mapUrl = null;
        _this.CLASS_NAME = "SuperMap.SetLayerStatusService";

        var me = _this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        me.mapUrl = url;
        return _this;
    }

    /**
     * @override
     */


    _createClass(SetLayerStatusService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SetLayerStatusService.prototype.__proto__ || Object.getPrototypeOf(SetLayerStatusService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.SetLayerStatusService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {Object} 修改后的图层资源信息。该参数可以使用获取图层信息服务 <SuperMap.SetLayerStatusParameters>
         *         返回图层信息，然后对其属性进行修改来获取。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            var subLayers = [],
                me = this,
                method = "POST";
            if (!params) {
                return;
            }

            me.url = me.mapUrl;
            var end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? '' : '/';

            if (params.resourceID == null) {
                me.url += "tempLayersSet";
                me.url += ".json?";

                me.lastparams = params;

                me.request({
                    method: method,
                    scope: me,
                    success: me.createTempLayerComplete,
                    failure: me.serviceProcessFailed
                });
            } else {
                me.url += "tempLayersSet/" + params.resourceID;
                me.url += ".json?";

                me.url += "elementRemain=true&reference=" + params.resourceID + "&holdTime=" + params.holdTime.toString();

                var jsonParameters = '[{';

                jsonParameters += '"type":"UGC",';
                if (params.layerStatusList != null && params.layerStatusList.length > 0) {
                    jsonParameters += '"subLayers":' + params.toJSON();
                }
                jsonParameters += ',"visible":' + true + ',';
                jsonParameters += '"name":"' + this.getMapName(this.mapUrl) + '"';

                jsonParameters += '}]';

                me.request({
                    method: "PUT",
                    data: jsonParameters,
                    scope: me,
                    success: me.serviceProcessCompleted,
                    failure: me.serviceProcessFailed
                });
            }
        }

        /*
         * Method: createTempLayerComplete
         * 设置完成，执行此方法。
         *
         * Parameters:
         * result - {Object} 服务器返回的结果对象，记录设置操作是否成功。
         */

    }, {
        key: 'createTempLayerComplete',
        value: function createTempLayerComplete(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result.succeed) {
                me.lastparams.resourceID = result.newResourceID;
            }

            me.processAsync(me.lastparams);
        }
    }, {
        key: 'getMapName',
        value: function getMapName(url) {
            var mapUrl = url;
            if (mapUrl.charAt(mapUrl.length - 1) === "/") {
                mapUrl = mapUrl.substr(0, mapUrl.length - 1);
            }
            var index = mapUrl.lastIndexOf("/");
            var mapName = mapUrl.substring(index + 1, mapUrl.length);
            return mapName;
        }

        /*
         * Method: setLayerCompleted
         * 设置完成，执行此方法。
         *
         * Parameters:
         * result - {Object} 服务器返回的结果对象，记录设置操作是否成功。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2.default.Util.transformResult(result);
            if (result != null && me.lastparams != null) {
                result.newResourceID = me.lastparams.resourceID;
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }
    }]);

    return SetLayerStatusService;
}(_CommonServiceBase3.default);

exports.default = SetLayerStatusService;


_SuperMap2.default.SetLayerStatusService = SetLayerStatusService;

/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _SetLayersInfoParameters = __webpack_require__(213);

var _SetLayersInfoParameters2 = _interopRequireDefault(_SetLayersInfoParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SetLayersInfoService
 * @classdesc  设置图层信息服务类。可以实现创建新的临时图层和对现有临时图层的修改，<br>
 *                当 isTempLayers 为 false的时候执行创建临时图层。当 isTempLayers 为 ture 并且临时图层资源 resourceID 被设置有效时执行对临时图层的编辑。<br>
 *                该类负责将图层设置参数传递到服务端，并获取服务端返回的结果信息。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 与客户端交互的地图服务地址。请求地图服务,URL 应为：<br>
 *              http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *         resourceID - {string} 图层资源ID，临时图层的资源ID标记。<br>
 *         isTempLayers - {boolean} 当前url对应的图层是否是临时图层。<br>
 *         eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *         serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *         format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。<br>
 */
var SetLayersInfoService = function (_CommonServiceBase) {
    _inherits(SetLayersInfoService, _CommonServiceBase);

    /**
     * @member SuperMap.SetLayersInfoService.prototype.resourceID - {string}
     * @description 图层资源ID，临时图层的资源ID标记。
     */
    function SetLayersInfoService(url, options) {
        _classCallCheck(this, SetLayersInfoService);

        var _this = _possibleConstructorReturn(this, (SetLayersInfoService.__proto__ || Object.getPrototypeOf(SetLayersInfoService)).call(this, url, options));

        _this.resourceID = null;
        _this.isTempLayers = false;
        _this.CLASS_NAME = "SuperMap.SetLayersInfoService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        _this.resourceID = options.resourceID;
        _this.isTempLayers = options.isTempLayers;
        return _this;
    }

    /**
     * @override
     */


    /**
     * @function SuperMap.SetLayersInfoService.prototype.isTempLayers -{boolean}
     * @description 当前url对应的图层是否是临时图层。
     */


    _createClass(SetLayersInfoService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SetLayersInfoService.prototype.__proto__ || Object.getPrototypeOf(SetLayersInfoService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.SetLayersInfoService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param  params - {Object} 修改后的图层资源信息。该参数可以使用获取图层信息服务<SuperMap.GetLayerInfoService>.result.subLayers.layers
         *            返回图层信息，然后对其属性进行修改来获取。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            var jsonParams,
                subLayers = [],
                me = this,
                method = "",
                end;
            if (!params) {
                return;
            }
            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? '' : '/';
            //创建临时图层和设置修改临时图层信息对应不同的资源URL
            if (me.isTempLayers) {
                me.url += "tempLayersSet/" + me.resourceID;
                method = "PUT";
            } else {
                me.url += "tempLayersSet";
                method = "POST";
            }
            me.url += ".json?";
            var layers = params.subLayers.layers,
                len = layers.length;
            for (var i in layers) {
                if (layers[i].ugcLayerType === "GRID") {
                    var colorDictionary = {};
                    var colorDics = layers[i].colorDictionarys;
                    for (var j in colorDics) {
                        var key = colorDics[j].elevation;
                        colorDictionary[key] = colorDics[j].color;
                    }
                }
                layers[i].colorDictionary = colorDictionary;
                delete layers[i].colorDictionarys;
            }

            for (var i = 0; i < len; i++) {
                if (layers[i].toJsonObject) {
                    //将图层信息转换成服务端能识别的简单json对象
                    subLayers.push(layers[i].toJsonObject());
                } else {
                    subLayers.push(layers[i]);
                }
            }
            jsonParams = _SuperMap2.default.Util.extend(jsonParams, params);
            jsonParams.subLayers = { "layers": subLayers };
            jsonParams.object = null;
            var jsonParamsStr = _SuperMap2.default.Util.toJSON([jsonParams]);
            me.request({
                method: method,
                data: jsonParamsStr,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return SetLayersInfoService;
}(_CommonServiceBase3.default);

exports.default = SetLayersInfoService;


_SuperMap2.default.SetLayersInfoService = SetLayersInfoService;

/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ProcessingServiceBase = __webpack_require__(24);

var _ProcessingServiceBase2 = _interopRequireDefault(_ProcessingServiceBase);

var _SingleObjectQueryJobsParameter = __webpack_require__(214);

var _SingleObjectQueryJobsParameter2 = _interopRequireDefault(_SingleObjectQueryJobsParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SingleObjectQueryJobsService
 * @classdesc 单对象查询分析服务类
 * @extends SuperMap.ProcessingServiceBase
 * @param url -{string} 单对象空间查询分析服务地址。
 * @param options - {Object} 交互服务时所需可选参数。
 */
var SingleObjectQueryJobsService = function (_ProcessingServiceBas) {
    _inherits(SingleObjectQueryJobsService, _ProcessingServiceBas);

    function SingleObjectQueryJobsService(url, options) {
        _classCallCheck(this, SingleObjectQueryJobsService);

        var _this = _possibleConstructorReturn(this, (SingleObjectQueryJobsService.__proto__ || Object.getPrototypeOf(SingleObjectQueryJobsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.SingleObjectQueryJobsService";

        _this.url += "/spatialanalyst/query";
        return _this;
    }

    /**
     *@override
     */


    _createClass(SingleObjectQueryJobsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SingleObjectQueryJobsService.prototype.__proto__ || Object.getPrototypeOf(SingleObjectQueryJobsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.SingleObjectQueryJobsService.protitype.getQueryJobs
         * @description 获取单对象空间查询分析所有任务
         */

    }, {
        key: 'getQueryJobs',
        value: function getQueryJobs() {
            _get(SingleObjectQueryJobsService.prototype.__proto__ || Object.getPrototypeOf(SingleObjectQueryJobsService.prototype), 'getJobs', this).call(this, this.url);
        }

        /**
         * @function SuperMap.KernelDensityJobsService.protitype.getQueryJob
         * @description 获取指定id的单对象空间查询分析服务
         * @param id -{string} 指定要获取数据的id
         */

    }, {
        key: 'getQueryJob',
        value: function getQueryJob(id) {
            _get(SingleObjectQueryJobsService.prototype.__proto__ || Object.getPrototypeOf(SingleObjectQueryJobsService.prototype), 'getJobs', this).call(this, this.url + '/' + id);
        }

        /**
         * @function SuperMap.SingleObjectQueryJobsService.protitype.addQueryJob
         * @description 新建单对象空间查询分析服务
         * @param params - {SuperMap.SingleObjectQueryJobsParameter} 创建一个空间分析的请求参数。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addQueryJob',
        value: function addQueryJob(params, seconds) {
            _get(SingleObjectQueryJobsService.prototype.__proto__ || Object.getPrototypeOf(SingleObjectQueryJobsService.prototype), 'addJob', this).call(this, this.url, params, _SingleObjectQueryJobsParameter2.default, seconds);
        }
    }]);

    return SingleObjectQueryJobsService;
}(_ProcessingServiceBase2.default);

exports.default = SingleObjectQueryJobsService;


_SuperMap2.default.SingleObjectQueryJobsService = SingleObjectQueryJobsService;

/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _StopQueryParameters = __webpack_require__(215);

var _StopQueryParameters2 = _interopRequireDefault(_StopQueryParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.StopQueryService
 * @classdesc
 * 站点查询服务类。
 * 返回结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 与客户端交互的站点查询服务地址。
 * 例如:</br>"http://localhost:8090/iserver/services/traffictransferanalyst-sample/restjsr/traffictransferanalyst/Traffic-Changchun"。
 * @param options - {Object} 可選参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 *
 * @example 例如：
 * (start code)
 * var myService = new SuperMap.StopQueryService(url, {eventListeners: {
     *     "processCompleted": StopQueryCompleted,
     *     "processFailed": StopQueryError
     *     }
     * };
 * (end)
 *
 *
 */

var StopQueryService = function (_CommonServiceBase) {
    _inherits(StopQueryService, _CommonServiceBase);

    function StopQueryService(url, options) {
        _classCallCheck(this, StopQueryService);

        var _this = _possibleConstructorReturn(this, (StopQueryService.__proto__ || Object.getPrototypeOf(StopQueryService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.StopQueryService";

        options = options || {};
        _SuperMap2.default.Util.extend(_this, options);
        return _this;
    }

    /**
     *@override
     */


    _createClass(StopQueryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(StopQueryService.prototype.__proto__ || Object.getPrototypeOf(StopQueryService.prototype), 'destroy', this).call(this);
            _SuperMap2.default.Util.reset(this);
        }

        /**
         * @function SuperMap.StopQueryService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {SuperMap.StopQueryParameters} 交通换乘参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                end;

            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? '' : '/';
            me.url += "stops/keyword/" + params.keyWord;
            me.url += ".json?";

            me.request({
                method: "GET",
                params: { returnPosition: params.returnPosition },
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return StopQueryService;
}(_CommonServiceBase3.default);

exports.default = StopQueryService;


_SuperMap2.default.StopQueryService = StopQueryService;

/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ProcessingServiceBase = __webpack_require__(24);

var _ProcessingServiceBase2 = _interopRequireDefault(_ProcessingServiceBase);

var _SummaryMeshJobParameter = __webpack_require__(216);

var _SummaryMeshJobParameter2 = _interopRequireDefault(_SummaryMeshJobParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SummaryMeshJobsService
 * @classdesc 点聚合分析任务类。
 * @param url -{string} 点聚合分析任务地址。
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        events - {SuperMap.Events} 处理所有事件的对象。<br>
 *        eventListeners - {Object} 听器对象。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        index - {number}服务访问地址在数组中的位置。<br>
 *        length - {number}服务访问地址数组长度。
 */
var SummaryMeshJobsService = function (_ProcessingServiceBas) {
    _inherits(SummaryMeshJobsService, _ProcessingServiceBas);

    function SummaryMeshJobsService(url, options) {
        _classCallCheck(this, SummaryMeshJobsService);

        var _this = _possibleConstructorReturn(this, (SummaryMeshJobsService.__proto__ || Object.getPrototypeOf(SummaryMeshJobsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.SummaryMeshJobsService";

        _this.url += "/spatialanalyst/aggregatepoints";
        return _this;
    }

    /**
     * @override
     */


    _createClass(SummaryMeshJobsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SummaryMeshJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryMeshJobsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.SummaryMeshJobsService.prototype.getSummaryMeshJobs
         * @description 获取点聚合分析任务
         */

    }, {
        key: 'getSummaryMeshJobs',
        value: function getSummaryMeshJobs() {
            _get(SummaryMeshJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryMeshJobsService.prototype), 'getJobs', this).call(this, this.url);
        }

        /**
         * @function SuperMap.SummaryMeshJobsService.prototype.getSummaryMeshJob
         * @description 获取指定ip的点聚合分析任务
         * @param id -{string} 指定要获取数据的id
         */

    }, {
        key: 'getSummaryMeshJob',
        value: function getSummaryMeshJob(id) {
            _get(SummaryMeshJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryMeshJobsService.prototype), 'getJobs', this).call(this, this.url + '/' + id);
        }

        /**
         * @function SuperMap.SummaryMeshJobsService.prototype.addSummaryMeshJob
         * @description 新建点聚合分析服务
         * @param params - {SuperMap.SummaryMeshJobParameter} 创建一个空间分析的请求参数。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addSummaryMeshJob',
        value: function addSummaryMeshJob(params, seconds) {
            _get(SummaryMeshJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryMeshJobsService.prototype), 'addJob', this).call(this, this.url, params, _SummaryMeshJobParameter2.default, seconds);
        }
    }]);

    return SummaryMeshJobsService;
}(_ProcessingServiceBase2.default);

exports.default = SummaryMeshJobsService;


_SuperMap2.default.SummaryMeshJobsService = SummaryMeshJobsService;

/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ProcessingServiceBase = __webpack_require__(24);

var _ProcessingServiceBase2 = _interopRequireDefault(_ProcessingServiceBase);

var _SummaryRegionJobParameter = __webpack_require__(217);

var _SummaryRegionJobParameter2 = _interopRequireDefault(_SummaryRegionJobParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SummaryRegionJobsService
 * @classdesc 区域汇总分析服务类
 * @extends SuperMap.ProcessingServiceBase
 * @param url -{string} 区域汇总分析服务地址。
 * @param options - {Object} 区域汇总分析服务可选参数。
 */
var SummaryRegionJobsService = function (_ProcessingServiceBas) {
    _inherits(SummaryRegionJobsService, _ProcessingServiceBas);

    function SummaryRegionJobsService(url, options) {
        _classCallCheck(this, SummaryRegionJobsService);

        var _this = _possibleConstructorReturn(this, (SummaryRegionJobsService.__proto__ || Object.getPrototypeOf(SummaryRegionJobsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.SummaryRegionJobsService";

        _this.url += "/spatialanalyst/summaryregion";
        return _this;
    }

    /**
     *@override
     */


    _createClass(SummaryRegionJobsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SummaryRegionJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryRegionJobsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.SummaryRegionJobsService.prototype.getSummaryRegionJobs
         * @description 获取区域汇总分析任务集合。
         */

    }, {
        key: 'getSummaryRegionJobs',
        value: function getSummaryRegionJobs() {
            _get(SummaryRegionJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryRegionJobsService.prototype), 'getJobs', this).call(this, this.url);
        }

        /**
         * @function SuperMap.SummaryRegionJobsService.prototype.getSummaryRegionJob
         * @description 获取指定id的区域汇总分析任务。
         * @param id -{string} 要获取区域汇总分析任务的id
         */

    }, {
        key: 'getSummaryRegionJob',
        value: function getSummaryRegionJob(id) {
            _get(SummaryRegionJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryRegionJobsService.prototype), 'getJobs', this).call(this, this.url + '/' + id);
        }

        /**
         * @function SuperMap.SummaryRegionJobsService.prototype.addSummaryRegionJob
         * @description 新建区域汇总任务。
         * @param params - {SuperMap.SummaryRegionJobParameter} 创建一个区域汇总任务的请求参数。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addSummaryRegionJob',
        value: function addSummaryRegionJob(params, seconds) {
            _get(SummaryRegionJobsService.prototype.__proto__ || Object.getPrototypeOf(SummaryRegionJobsService.prototype), 'addJob', this).call(this, this.url, params, _SummaryRegionJobParameter2.default, seconds);
        }
    }]);

    return SummaryRegionJobsService;
}(_ProcessingServiceBase2.default);

exports.default = SummaryRegionJobsService;


_SuperMap2.default.SummaryRegionJobsService = SummaryRegionJobsService;

/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _DatasetSurfaceAnalystParameters = __webpack_require__(154);

var _DatasetSurfaceAnalystParameters2 = _interopRequireDefault(_DatasetSurfaceAnalystParameters);

var _GeometrySurfaceAnalystParameters = __webpack_require__(179);

var _GeometrySurfaceAnalystParameters2 = _interopRequireDefault(_GeometrySurfaceAnalystParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SurfaceAnalystService
 * @classdesc
 * 表面分析服务类。
 * 该类负责将客户设置的表面分析服务参数传递给服务端，并接收服务端返回的表面分析服务分析结果数据。
 * 表面分析结果通过该类支持的事件的监听函数参数获取
 * @param options - {Object} 可选参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。s
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var mySurfaceAnalystService = new SuperMap.SurfaceAnalystService(url, {
     *      eventListeners: {
     *	       "processCompleted": surfaceAnalysCompleted,
     *		   "processFailed": surfaceAnalysFailed
     *		   }
     * });
 * (end)
 *
 */
var SurfaceAnalystService = function (_SpatialAnalystBase) {
    _inherits(SurfaceAnalystService, _SpatialAnalystBase);

    function SurfaceAnalystService(url, options) {
        _classCallCheck(this, SurfaceAnalystService);

        var _this = _possibleConstructorReturn(this, (SurfaceAnalystService.__proto__ || Object.getPrototypeOf(SurfaceAnalystService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.SurfaceAnalystService";
        return _this;
    }

    /**
     * @function SuperMap.SurfaceAnalystService.prototype.destroy
     * @description 释放资源,将引用的资源属性置空。
     */


    _createClass(SurfaceAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(SurfaceAnalystService.prototype.__proto__ || Object.getPrototypeOf(SurfaceAnalystService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.SurfaceAnalystService.prototype.processAsync
         * @description 负责将客户端的表面分析服务参数传递到服务端。
         * @param params - {SuperMap.SurfaceAnalystParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters;
            jsonParameters = me.getJsonParameters(params);
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.SurfaceAnalystService.prototype.getJsonParameters
         * @description 将参数转化为 JSON 字符串。
         * @param params - {SuperMap.SurfaceAnalystParameters}
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(params) {
            var jsonParameters = "";
            var parameterObject = {};
            var me = this,
                end;
            if (params instanceof _DatasetSurfaceAnalystParameters2.default) {
                var end = me.url.substr(me.url.length - 1, 1);
                me.url += end === "/" ? "datasets/" + params.dataset + "/" + params.surfaceAnalystMethod.toLowerCase() + ".json?returnContent=true" : "/datasets/" + params.dataset + "/" + params.surfaceAnalystMethod.toLowerCase() + ".json?returnContent=true";
                _DatasetSurfaceAnalystParameters2.default.toObject(params, parameterObject);
                jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            } else if (params instanceof _GeometrySurfaceAnalystParameters2.default) {
                end = me.url.substr(me.url.length - 1, 1);
                me.url += end === "/" ? "geometry/" + params.surfaceAnalystMethod.toLowerCase() + ".json?returnContent=true" : "/geometry/" + params.surfaceAnalystMethod.toLowerCase() + ".json?returnContent=true";
                jsonParameters = _SuperMap2.default.Util.toJSON(params);
            } else {
                return;
            }

            return jsonParameters;
        }
    }]);

    return SurfaceAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = SurfaceAnalystService;


_SuperMap2.default.SurfaceAnalystService = SurfaceAnalystService;

/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _TerrainCurvatureCalculationParameters = __webpack_require__(220);

var _TerrainCurvatureCalculationParameters2 = _interopRequireDefault(_TerrainCurvatureCalculationParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.TerrainCurvatureCalculationService
 * @classdesc 地形曲率计算服务类。
 * @extends SuperMap.SpatialAnalystBase
 * @param options - {Object} 可选参数。如</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @param url - {string} 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @example 例如：
 * (start code)
 * var myTerrainCurvatureCalculationService = new SuperMap.TerrainCurvatureCalculationService(url);
 * myTerrainCurvatureCalculationService.on({
     *     "processCompleted": processCompleted,
     *     "processFailed": processFailed
     *     }
 * );
 * (end)
 *
 */
var TerrainCurvatureCalculationService = function (_SpatialAnalystBase) {
    _inherits(TerrainCurvatureCalculationService, _SpatialAnalystBase);

    function TerrainCurvatureCalculationService(url, options) {
        _classCallCheck(this, TerrainCurvatureCalculationService);

        var _this = _possibleConstructorReturn(this, (TerrainCurvatureCalculationService.__proto__ || Object.getPrototypeOf(TerrainCurvatureCalculationService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.TerrainCurvatureCalculationService";
        return _this;
    }

    /**
     *@override
     */


    _createClass(TerrainCurvatureCalculationService, [{
        key: 'destroy',
        value: function destroy() {
            _get(TerrainCurvatureCalculationService.prototype.__proto__ || Object.getPrototypeOf(TerrainCurvatureCalculationService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.TerrainCurvatureCalculationService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param parameter - {SuperMap.TerrainCurvatureCalculationParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            var parameterObject = {};

            if (parameter instanceof _TerrainCurvatureCalculationParameters2.default) {
                me.url += 'datasets/' + parameter.dataset + '/terraincalculation/curvature';
            }

            _TerrainCurvatureCalculationParameters2.default.toObject(parameter, parameterObject);
            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return TerrainCurvatureCalculationService;
}(_SpatialAnalystBase3.default);

exports.default = TerrainCurvatureCalculationService;


_SuperMap2.default.TerrainCurvatureCalculationService = TerrainCurvatureCalculationService;

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _ThemeParameters = __webpack_require__(236);

var _ThemeParameters2 = _interopRequireDefault(_ThemeParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeService
 * @classdesc 专题图服务类。
 * @extends SuperMap.CommonServiceBase
 * @example
 * var myThemeService = new SuperMap.ThemeService(url, {
 *     eventListeners: {
 *           "processCompleted": themeCompleted,
 *           "processFailed": themeFailed
 *           }
 * });
 * @param url - {string} 服务的访问地址。如：http://localhost:8090/iserver/services/map-world/rest/maps/World+Map 。
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var ThemeService = function (_CommonServiceBase) {
    _inherits(ThemeService, _CommonServiceBase);

    function ThemeService(url, options) {
        _classCallCheck(this, ThemeService);

        var _this = _possibleConstructorReturn(this, (ThemeService.__proto__ || Object.getPrototypeOf(ThemeService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ThemeService";

        if (options) {
            _SuperMap2.default.Util.extend(_this, options);
        }
        var end,
            me = _this;
        end = me.url.substr(me.url.length - 1, 1);
        me.url += end === "/" ? "tempLayersSet.json?" : "/tempLayersSet.json?";
        return _this;
    }

    /**
     * @override
     */


    _createClass(ThemeService, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeService.prototype.__proto__ || Object.getPrototypeOf(ThemeService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.ThemeService.prototype.processAsync
         * @description 负责将客户端的专题图参数传递到服务端。
         * @param params - {SuperMap.ThemeParameters} 专题图参数类。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters = null;
            jsonParameters = me.getJsonParameters(params);
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.ThemeService.prototype.getJsonParameters
         * @description 将专题图参数参数转化为 JSON 字符串。
         * @param params - {SuperMap.ThemeParameters} 专题图参数类。
         * @return {Object} 转化后的JSON字符串。
         */

    }, {
        key: 'getJsonParameters',
        value: function getJsonParameters(parameter) {
            var jsonParameters = "",
                themeType = "",
                themeObj = null,
                filters = null,
                orderBys = null,
                fieldValuesDisplayFilter;
            jsonParameters += "[{'type': 'UGC','subLayers': {'layers': [";
            for (var themeID in parameter.themes) {
                themeObj = parameter.themes[themeID];
                var jsonTheme = _SuperMap2.default.Util.toJSON(themeObj);
                jsonTheme = jsonTheme.slice(0, -1);

                jsonParameters += "{'theme': " + jsonTheme + "},'type': 'UGC','ugcLayerType': 'THEME',";
                filters = parameter.displayFilters;
                if (filters && filters.length > 0) {
                    if (filters.length === 1) {
                        jsonParameters += "'displayFilter':\"" + filters[0] + "\",";
                    } else {
                        jsonParameters += "'displayFilter':\"" + filters[themeID] + "\",";
                    }
                }
                orderBys = parameter.displayOrderBy;
                if (orderBys && orderBys.length > 0) {
                    if (orderBys.length === 1) {
                        jsonParameters += "'displayOrderBy':'" + orderBys[0] + "',";
                    } else {
                        jsonParameters += "'displayOrderBy':'" + orderBys[themeID] + "',";
                    }
                }

                fieldValuesDisplayFilter = parameter.fieldValuesDisplayFilter;
                if (fieldValuesDisplayFilter) {
                    jsonParameters += "'fieldValuesDisplayFilter':" + _SuperMap2.default.Util.toJSON(fieldValuesDisplayFilter) + ",";
                }

                if (parameter.joinItems && parameter.joinItems.length > 0 && parameter.joinItems[themeID]) {
                    jsonParameters += "'joinItems':[" + _SuperMap2.default.Util.toJSON(parameter.joinItems[themeID]) + "],";
                }
                if (parameter.datasetNames && parameter.dataSourceNames) {
                    var datasetID = parameter.datasetNames[themeID] ? themeID : parameter.datasetNames.length - 1;
                    var dataSourceID = parameter.dataSourceNames[themeID] ? themeID : parameter.dataSourceNames.length - 1;
                    jsonParameters += "'datasetInfo': {'name': '" + parameter.datasetNames[datasetID] + "','dataSourceName': '" + parameter.dataSourceNames[dataSourceID] + "'}},";
                } else {
                    jsonParameters += "},";
                }
            }
            //去除多余的逗号
            if (parameter.themes && parameter.themes.length > 0) {
                jsonParameters = jsonParameters.substring(0, jsonParameters.length - 1);
            }
            jsonParameters += "]},";
            var urlArray = this.url.split("/");
            var jsonMapName = urlArray[urlArray.length - 2];

            jsonParameters += "'name': '" + jsonMapName + "'}]";
            return jsonParameters;
        }
    }]);

    return ThemeService;
}(_CommonServiceBase3.default);

exports.default = ThemeService;


_SuperMap2.default.ThemeService = ThemeService;

/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _SpatialAnalystBase2 = __webpack_require__(3);

var _SpatialAnalystBase3 = _interopRequireDefault(_SpatialAnalystBase2);

var _DatasetThiessenAnalystParameters = __webpack_require__(155);

var _DatasetThiessenAnalystParameters2 = _interopRequireDefault(_DatasetThiessenAnalystParameters);

var _GeometryThiessenAnalystParameters = __webpack_require__(180);

var _GeometryThiessenAnalystParameters2 = _interopRequireDefault(_GeometryThiessenAnalystParameters);

var _GeoJSON = __webpack_require__(4);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThiessenAnalystService
 * @classdesc
 * 泰森多边形分析服务类
 * 该类负责将客户设置的泰森多边形分析参数传递给服务端，并接收服务端返回的分析结果数据。
 * 泰森多边形分析结果通过该类支持的事件的监听函数参数获取
 * 泰森多边形分析的参数支持两种，当参数为 {SuperMap.DatasetThiessenAnalystParameters} 类型
 * 时，执行数据集泰森多边形分析，当参数为 {SuperMap.GeometryThiessenAnalystParameters} 类型时，
 * 执行几何对象泰森多边形分析。
 * @param options - {Object} 参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 * @param url - {string} 服务的访问地址。
 * 如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 *
 * @extends SuperMap.SpatialAnalystBase
 * @example 例如：
 * (start code)
 * var myThiessenAnalystService = new SuperMap.ThiessenAnalystService(url, {
     *     eventListeners: {
     *           "processCompleted": bufferCompleted,
     *           "processFailed": bufferFailed
     *           }
     *    });
 * (end)
 *
 */
var ThiessenAnalystService = function (_SpatialAnalystBase) {
    _inherits(ThiessenAnalystService, _SpatialAnalystBase);

    function ThiessenAnalystService(url, options) {
        _classCallCheck(this, ThiessenAnalystService);

        var _this = _possibleConstructorReturn(this, (ThiessenAnalystService.__proto__ || Object.getPrototypeOf(ThiessenAnalystService)).call(this, url, options));

        _this.mode = null;
        _this.CLASS_NAME = "SuperMap.ThiessenAnalystService";

        var me = _this;
        if (options) {
            _SuperMap2.default.Util.extend(me, options);
        }
        return _this;
    }

    /**
     * @override
     */

    /**
     * @member SuperMap.ThiessenAnalystService.prototype.mode -{string}
     * @description 缓冲区分析类型
     */


    _createClass(ThiessenAnalystService, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThiessenAnalystService.prototype.__proto__ || Object.getPrototypeOf(ThiessenAnalystService.prototype), 'destroy', this).call(this);
            this.mode = null;
        }

        /**
         * @function SuperMap.ThiessenAnalystService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param parameter - {SuperMap.DatasetThiessenAnalystParameters}|{GeometryThiessenAnalystParameters}
         */

    }, {
        key: 'processAsync',
        value: function processAsync(parameter) {
            var parameterObject = {};
            var me = this;

            var end = me.url.substr(me.url.length - 1, 1);
            if (end === '/') {} else {
                me.url += "/";
            }

            if (parameter instanceof _DatasetThiessenAnalystParameters2.default) {
                me.mode = "datasets";
                me.url += 'datasets/' + parameter.dataset + '/thiessenpolygon';
                _DatasetThiessenAnalystParameters2.default.toObject(parameter, parameterObject);
            } else if (parameter instanceof _GeometryThiessenAnalystParameters2.default) {
                me.mode = "geometry";
                me.url += 'geometry/thiessenpolygon';
                _GeometryThiessenAnalystParameters2.default.toObject(parameter, parameterObject);
            }

            var jsonParameters = _SuperMap2.default.Util.toJSON(parameterObject);
            me.url += '.json?returnContent=true';
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.ThiessenAnalystService.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result) {
                return result;
            }

            result = _get(ThiessenAnalystService.prototype.__proto__ || Object.getPrototypeOf(ThiessenAnalystService.prototype), 'toGeoJSONResult', this).call(this, result);
            if (result.regions) {
                var geoJSONFormat = new _GeoJSON2.default();
                result.regions = JSON.parse(geoJSONFormat.write(result.regions));
            }
            return result;
        }
    }]);

    return ThiessenAnalystService;
}(_SpatialAnalystBase3.default);

exports.default = ThiessenAnalystService;


_SuperMap2.default.ThiessenAnalystService = ThiessenAnalystService;

/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.TilesetsService
 * @classdesc 切片列表信息查询服务类;即查询切片地图服务的切片列表，返回切片集名称、地图切片元数据信息、切片版本集信息
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 地图服务地址。URL应为：<br>
 *                        http://{服务器地址}:{服务端口号}/iserver/services/{服务名}/rest/maps/map；<br>
 *                       例如: "http://localhost:8090/iserver/services/test/rest/maps/tianlocal";
 * @param options - {Object} 交互服务时所需可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var TilesetsService = function (_CommonServiceBase) {
    _inherits(TilesetsService, _CommonServiceBase);

    function TilesetsService(url, options) {
        _classCallCheck(this, TilesetsService);

        var _this = _possibleConstructorReturn(this, (TilesetsService.__proto__ || Object.getPrototypeOf(TilesetsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.TilesetsService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(TilesetsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(TilesetsService.prototype.__proto__ || Object.getPrototypeOf(TilesetsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.TilesetsService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         */

    }, {
        key: 'processAsync',
        value: function processAsync() {
            if (!this.url) {
                return;
            }
            var me = this;
            var end = me.url.substr(me.url.length - 1, 1);

            me.url = me.url + (end === "/" ? "tilesets" : "/tilesets") + ".json?";

            me.request({
                method: "GET",
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return TilesetsService;
}(_CommonServiceBase3.default);

exports.default = TilesetsService;


_SuperMap2.default.TilesetsService = TilesetsService;

/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _TransferPathParameters = __webpack_require__(240);

var _TransferPathParameters2 = _interopRequireDefault(_TransferPathParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.TransferPathService
 * @classdesc 交通换乘线路查询服务类，根据交通换乘分析结果(TransferSolutionResult)，获取某一条乘车路线的详细信息。
 *            返回结果通过该类支持的事件的监听函数参数获取
 * @extends SuperMap.CommonServiceBase
 * @example 例如：
 * var myService = new SuperMap.TransferPathService(url, {eventListeners: {
 *     "processCompleted": TrafficTransferCompleted,
 *     "processFailed": TrafficTransferError
 *     }
 * };
 * @param url - {string} 与客户端交互的交通换乘线路查询服务地址。
 * 例如:</br>"http://localhost:8090/iserver/services/traffictransferanalyst-sample/restjsr/traffictransferanalyst/Traffic-Changchun"。
 * @param options - {Object} 可選参数。如:</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。
 */
var TransferPathService = function (_CommonServiceBase) {
    _inherits(TransferPathService, _CommonServiceBase);

    function TransferPathService(url, options) {
        _classCallCheck(this, TransferPathService);

        var _this = _possibleConstructorReturn(this, (TransferPathService.__proto__ || Object.getPrototypeOf(TransferPathService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.TransferPathService";
        return _this;
    }
    /**
     * @override
     */


    _createClass(TransferPathService, [{
        key: 'destroy',
        value: function destroy() {
            _get(TransferPathService.prototype.__proto__ || Object.getPrototypeOf(TransferPathService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.TransferPathService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {SuperMap.TransferPathParameters} 交通换乘参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                method = "GET",
                jsonParameters,
                end;

            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? '' : '/';
            me.url += "path.json?";

            jsonParameters = {
                points: _SuperMap2.default.Util.toJSON(params.points),
                transferLines: _SuperMap2.default.Util.toJSON(params['transferLines'])
            };

            me.request({
                method: method,
                params: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return TransferPathService;
}(_CommonServiceBase3.default);

exports.default = TransferPathService;


_SuperMap2.default.TransferPathService = TransferPathService;

/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(2);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _TransferSolutionParameters = __webpack_require__(241);

var _TransferSolutionParameters2 = _interopRequireDefault(_TransferSolutionParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.TransferSolutionService
 * @classdesc
 * 交通换乘方案查询服务类。
 * 返回结果通过该类支持的事件的监听函数参数获取。
 * @param url - {string} 与客户端交互的交通换乘方案查询服务地址。
 * 例如:</br>"http://localhost:8090/iserver/services/traffictransferanalyst-sample/restjsr/traffictransferanalyst/Traffic-Changchun"。
 * @param options - {Object} 参数。如</br>
 *        eventListeners - {Object} 需要被注册的监听器对象。</br>
 * @extends SuperMap.CommonServiceBase
 * @example 例如：
 * (start code)
 * var myService = new SuperMap.TransferSolutionService(url, {eventListeners: {
     *     "processCompleted": trafficTransferCompleted,
     *     "processFailed": trafficTransferError
     *     }
     * };
 * (end)
 *
 */
var TransferSolutionService = function (_CommonServiceBase) {
    _inherits(TransferSolutionService, _CommonServiceBase);

    function TransferSolutionService(url, options) {
        _classCallCheck(this, TransferSolutionService);

        var _this = _possibleConstructorReturn(this, (TransferSolutionService.__proto__ || Object.getPrototypeOf(TransferSolutionService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.TransferSolutionService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(TransferSolutionService, [{
        key: 'destroy',
        value: function destroy() {
            _get(TransferSolutionService.prototype.__proto__ || Object.getPrototypeOf(TransferSolutionService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.TransferSolutionService.prototype.processAsync
         * @description 负责将客户端的更新参数传递到服务端。
         * @param params - {SuperMap.TransferSolutionParameters} 交通换乘参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                method = "GET",
                jsonParameters,
                end;

            end = me.url.substr(me.url.length - 1, 1);
            me.url += end === "/" ? '' : '/';
            me.url += "solutions.json?";

            jsonParameters = {
                points: _SuperMap2.default.Util.toJSON(params.points),
                walkingRatio: params['walkingRatio'],
                transferTactic: params['transferTactic'],
                solutionCount: params['solutionCount'],
                transferPreference: params["transferPreference"]
            };
            if (params.evadeLines) jsonParameters["evadeLines"] = _SuperMap2.default.Util.toJSON(params.evadeLines);
            if (params.evadeStops) jsonParameters["evadeStops"] = _SuperMap2.default.Util.toJSON(params.evadeStops);
            if (params.priorLines) jsonParameters["priorLines"] = _SuperMap2.default.Util.toJSON(params.priorLines);
            if (params.priorStops) jsonParameters["priorStops"] = _SuperMap2.default.Util.toJSON(params.priorStops);
            if (params.travelTime) jsonParameters["travelTime"] = params.travelTime;

            me.request({
                method: method,
                params: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }
    }]);

    return TransferSolutionService;
}(_CommonServiceBase3.default);

exports.default = TransferSolutionService;


_SuperMap2.default.TransferSolutionService = TransferSolutionService;

/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _UpdateEdgeWeightParameters = __webpack_require__(244);

var _UpdateEdgeWeightParameters2 = _interopRequireDefault(_UpdateEdgeWeightParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.UpdateEdgeWeightService
 * @classdesc 更新边的边的耗费权重服务
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 *(start code)
 * var updateEdgeWeightService = new SuperMap.UpdateEdgeWeightService(url, {
 *     eventListeners: {
 *         "processCompleted": UpdateEdgeWeightCompleted,      //参数为SuperMap.UpdateEdgeWeightEventArgs
 *		   "processFailed": UpdateEdgeWeightError             //参数为SuperMap.ServiceFailedEventArgs
 *		   }
 * });
 * (end)
 * @param url - {string} 服务的访问地址。 如:<br>
 *                       http://localhost:8090/iserver/services/transportationanalyst-sample/rest/networkanalyst/RoadNet@Changchun 。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var UpdateEdgeWeightService = function (_NetworkAnalystServic) {
    _inherits(UpdateEdgeWeightService, _NetworkAnalystServic);

    function UpdateEdgeWeightService(url, options) {
        _classCallCheck(this, UpdateEdgeWeightService);

        var _this = _possibleConstructorReturn(this, (UpdateEdgeWeightService.__proto__ || Object.getPrototypeOf(UpdateEdgeWeightService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.UpdateEdgeWeightService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(UpdateEdgeWeightService, [{
        key: 'destroy',
        value: function destroy() {
            _get(UpdateEdgeWeightService.prototype.__proto__ || Object.getPrototypeOf(UpdateEdgeWeightService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.UpdateEdgeWeightService.prototype.processAsync
         * @description 开始异步执行边的边的耗费权重的更新
         * @param params - {SuperMap.UpdateEdgeWeightParameters} 边的耗费权重更新服务参数类
         * @example
         * (code)
         *  var updateEdgeWeightParam=new SuperMapUpdateEdgeWeightParameters({
         *          edgeId:"20",
         *          fromNodeId:"26",
         *          toNodeId:"109",
         *          weightField:"time",
         *          edgeWeight:"25"
         *      });
         *  updateEdgeWeightService.processAsync(updateEdgeWeightParam);
         * (end)
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }

            var me = this,
                end = me.url.substr(me.url.length - 1, 1);
            var paramStr = me.parse(params);
            if (end === "/") {
                me.url.splice(me.url.length - 1, 1);
            }
            me.url = me.url + paramStr + ".json?";
            var data = params.edgeWeight ? params.edgeWeight : null;
            me.request({
                method: "PUT",
                scope: me,
                data: data,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /*
         * Method: parse
         * 将更新服务参数解析为用‘/’做分隔的字符串
         */

    }, {
        key: 'parse',
        value: function parse(params) {
            if (!params) {
                return;
            }
            var paramStr = "";
            for (var attr in params) {
                if (params[attr] === "" || params[attr] === "edgeWeight") continue;
                switch (attr) {
                    case "edgeId":
                        paramStr += "/edgeweight/" + params[attr];
                        break;
                    case "fromNodeId":
                        paramStr += "/fromnode/" + params[attr];
                        break;
                    case "toNodeId":
                        paramStr += "/tonode/" + params[attr];
                        break;
                    case "weightField":
                        paramStr += "/weightfield/" + params[attr];
                        break;
                    default:
                        break;
                }
            }
            return paramStr;
        }
    }]);

    return UpdateEdgeWeightService;
}(_NetworkAnalystServiceBase2.default);

exports.default = UpdateEdgeWeightService;


_SuperMap2.default.UpdateEdgeWeightService = UpdateEdgeWeightService;

/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _NetworkAnalystServiceBase = __webpack_require__(8);

var _NetworkAnalystServiceBase2 = _interopRequireDefault(_NetworkAnalystServiceBase);

var _UpdateTurnNodeWeightParameters = __webpack_require__(245);

var _UpdateTurnNodeWeightParameters2 = _interopRequireDefault(_UpdateTurnNodeWeightParameters);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.UpdateTurnNodeWeightService
 * @classdesc 转向耗费权重更新服务类
 * @extends SuperMap.NetworkAnalystServiceBase
 * @example
 * var UpdateTurnNodeWeightService = new SuperMap.UpdateTurnNodeWeightService(url, {
 *     eventListeners: {
 *         "processCompleted": UpdateTurnNodeWeightCompleted,    //参数为SuperMap.UpdateTurnNodeWeightEventArgs
 *		   "processFailed": UpdateTurnNodeWeightError          //参数为SuperMap.ServiceFailedEventArgs
 *		   }
 * });
 * @param url - {string} 服务的访问地址。如:<br>
 *                       http://localhost:8090/iserver/services/transportationanalyst-sample/rest/networkanalyst/RoadNet@Changchun 。
 * @param options - {Object} 互服务时所需可选参数。如：<br>
 *         eventListeners - {Object} 需要被注册的监听器对象。
 */
var UpdateTurnNodeWeightService = function (_NetworkAnalystServic) {
    _inherits(UpdateTurnNodeWeightService, _NetworkAnalystServic);

    function UpdateTurnNodeWeightService(url, options) {
        _classCallCheck(this, UpdateTurnNodeWeightService);

        var _this = _possibleConstructorReturn(this, (UpdateTurnNodeWeightService.__proto__ || Object.getPrototypeOf(UpdateTurnNodeWeightService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.UpdateTurnNodeWeightService";
        return _this;
    }

    /**
     * @override
     */


    _createClass(UpdateTurnNodeWeightService, [{
        key: 'destroy',
        value: function destroy() {
            _get(UpdateTurnNodeWeightService.prototype.__proto__ || Object.getPrototypeOf(UpdateTurnNodeWeightService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.UpdateTurnNodeWeightService.prototype.processAsync
         * @description 开始异步执行转向耗费权重的更新
         * @param params - {SuperMap.UpdateTurnNodeWeightParameters} 转向耗费权重更新服务参数类
         * @example
         * (code)
         *  var updateTurnNodeWeightParam=new SuperMap.UpdateTurnNodeWeightParameters({
         *           nodeId:"106",
         *           fromEdgeId:"6508",
         *           toEdgeId:"6504",
         *           weightField:"TurnCost",
         *           turnNodeWeight:"50"
         *       });
         *  updateTurnNodeWeightService.processAsync(updateTurnNodeWeightParam);
         * (end)
         **/

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }

            var me = this,
                end = me.url.substr(me.url.length - 1, 1);
            var paramStr = me.parse(params);
            if (end === "/") {
                me.url.splice(me.url.length - 1, 1);
            }
            me.url = me.url + paramStr + ".json?";
            var data = params.turnNodeWeight ? params.turnNodeWeight : null;
            me.request({
                method: "PUT",
                scope: me,
                data: data,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /*
         * Method: parse
         * 将更新服务参数解析为用‘/’做分隔的字符串
         * */

    }, {
        key: 'parse',
        value: function parse(params) {
            if (!params) {
                return;
            }
            var paramStr = "";
            for (var attr in params) {
                if (params[attr] === "" || params[attr] === "turnNodeWeight") continue;
                switch (attr) {
                    case "nodeId":
                        paramStr += "/turnnodeweight/" + params[attr];
                        break;
                    case "fromEdgeId":
                        paramStr += "/fromedge/" + params[attr];
                        break;
                    case "toEdgeId":
                        paramStr += "/toedge/" + params[attr];
                        break;
                    case "weightField":
                        paramStr += "/weightfield/" + params[attr];
                        break;
                    default:
                        break;
                }
            }
            return paramStr;
        }
    }]);

    return UpdateTurnNodeWeightService;
}(_NetworkAnalystServiceBase2.default);

exports.default = UpdateTurnNodeWeightService;


_SuperMap2.default.UpdateTurnNodeWeightService = UpdateTurnNodeWeightService;

/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ProcessingServiceBase = __webpack_require__(24);

var _ProcessingServiceBase2 = _interopRequireDefault(_ProcessingServiceBase);

var _VectorClipJobsParameter = __webpack_require__(247);

var _VectorClipJobsParameter2 = _interopRequireDefault(_VectorClipJobsParameter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.VectorClipJobsService
 * @classdesc 矢量裁剪分析服务类
 * @extends SuperMap.ProcessingServiceBase
 * @param url -{string} 矢量裁剪分析服务地址。
 * @param options - {Object} 交互服务时所需可选参数。
 */
var VectorClipJobsService = function (_ProcessingServiceBas) {
    _inherits(VectorClipJobsService, _ProcessingServiceBas);

    function VectorClipJobsService(url, options) {
        _classCallCheck(this, VectorClipJobsService);

        var _this = _possibleConstructorReturn(this, (VectorClipJobsService.__proto__ || Object.getPrototypeOf(VectorClipJobsService)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.VectorClipJobsService";

        _this.url += "/spatialanalyst/vectorclip";
        return _this;
    }

    /**
     *@override
     */


    _createClass(VectorClipJobsService, [{
        key: 'destroy',
        value: function destroy() {
            _get(VectorClipJobsService.prototype.__proto__ || Object.getPrototypeOf(VectorClipJobsService.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.VectorClipJobsService.protitype.getVectorClipJobs
         * @description 获取矢量裁剪分析所有任务
         */

    }, {
        key: 'getVectorClipJobs',
        value: function getVectorClipJobs() {
            _get(VectorClipJobsService.prototype.__proto__ || Object.getPrototypeOf(VectorClipJobsService.prototype), 'getJobs', this).call(this, this.url);
        }

        /**
         * @function SuperMap.KernelDensityJobsService.protitype.getVectorClipJob
         * @description 获取指定id的矢量裁剪分析服务
         * @param id -{string} 指定要获取数据的id
         */

    }, {
        key: 'getVectorClipJob',
        value: function getVectorClipJob(id) {
            _get(VectorClipJobsService.prototype.__proto__ || Object.getPrototypeOf(VectorClipJobsService.prototype), 'getJobs', this).call(this, this.url + '/' + id);
        }

        /**
         * @function SuperMap.VectorClipJobsService.protitype.addVectorClipJob
         * @description 新建矢量裁剪分析服务
         * @param params - {SuperMap.VectorClipJobsParameter} 创建一个空间分析的请求参数。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addVectorClipJob',
        value: function addVectorClipJob(params, seconds) {
            _get(VectorClipJobsService.prototype.__proto__ || Object.getPrototypeOf(VectorClipJobsService.prototype), 'addJob', this).call(this, this.url, params, _VectorClipJobsParameter2.default, seconds);
        }
    }]);

    return VectorClipJobsService;
}(_ProcessingServiceBase2.default);

exports.default = VectorClipJobsService;


_SuperMap2.default.VectorClipJobsService = VectorClipJobsService;

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _elasticsearch = __webpack_require__(255);

var _elasticsearch2 = _interopRequireDefault(_elasticsearch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ElasticSearch
 * @classdesc ElasticSearch服务类。
 * @param url - {string} ElasticSearch服务地址。
 * @param options - {Object} 可选参数。如:</br>
 *         change - {function} 服务器返回数据后执行的函数。</br>
 *         openGeoFence - {boolean} 是否开启地理围栏验证，默认为不开启。</br>
 *         outOfGeoFence - {function} 数据超出地理围栏后执行的函数。</br>
 *         geoFence - {Object} 地理围栏。</br>
 */

var ElasticSearch = function () {

    /**
     * @member SuperMap.ElasticSearch.prototype.events -{SuperMap.Events}
     * @description 事件
     */


    /**
     * @member SuperMap.ElasticSearch.prototype.geoFence -{Object}
     * @description 地理围栏
     * @example {
     *    radius: 1000,//单位是m
     *    center: [104.40, 30.43],
     *    unit: 'meter|degree'
     *  }
     */

    /**
     *  @member SuperMap.ElasticSearch.prototype.openGeoFence -{boolean}
     *  @description 是否开启地理围栏验证，默认为不开启。
     */

    /**
     *  @member SuperMap.ElasticSearch.prototype.client -{Object}
     *  @description client ES客户端
     */
    function ElasticSearch(url, options) {
        _classCallCheck(this, ElasticSearch);

        this.url = null;
        this.client = null;
        this.change = null;
        this.openGeoFence = false;
        this.outOfGeoFence = null;
        this.geoFence = null;
        this.EVENT_TYPES = ['change', 'error', 'outOfGeoFence'];
        this.events = null;
        this.eventListeners = null;

        options = options || {};
        var me = this;
        me.url = url;
        me.client = new _elasticsearch2.default.Client({
            host: me.url
        });
        me.change = options.change;
        me.geoFence = options.geoFence;
        me.openGeoFence = options.openGeoFence;
        me.outOfGeoFence = options.outOfGeoFence;
        me.events = new _SuperMap2.default.Events(me, null, me.EVENT_TYPES);
        me.eventListeners = options.eventListeners;
        if (me.eventListeners instanceof Object) {
            me.events.on(me.eventListeners);
        }
    }

    /**
     * @function  SuperMap.ElasticSearch.prototype.setGeoFence
     * @description 设置地理围栏，openGeoFence参数为true的时候，设置的地理围栏才生效。
     * @param geoFence - {SuperMap.Geometry} 地理围栏。
     */

    /**
     * @member SuperMap.ElasticSearch.prototype.eventListeners -{Object}
     * @description 听器对象，在构造函数中设置此参数（可选），对 MapService 支持的两个事件 processCompleted 、processFailed 进行监听，
     * 相当于调用 SuperMap.Events.on(eventListeners)。
     */


    /*
     * Constant: EVENT_TYPES
     * {Array<String>}
     * 此类支持的事件类型。
     *
     */

    /**
     *  @member SuperMap.ElasticSearch.prototype.outOfGeoFence -{function}
     *  @description 数据超出地理围栏后执行的函数
     */

    /**
     *  @member SuperMap.ElasticSearch.prototype.change -{function}
     *  @description 服务器返回数据后执行的函数
     */

    /**
     *  @member SuperMap.ElasticSearch.prototype.url -{string}
     *  @description ElasticSearch服务地址
     */


    _createClass(ElasticSearch, [{
        key: 'setGeoFence',
        value: function setGeoFence(geoFence) {
            this.geoFence = geoFence;
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.bulk
         * @description 批量操作API，允许执行多个索引/删除操作。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-bulk</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'bulk',
        value: function bulk(params, callback) {
            return this.client.bulk(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.clearScroll
         * @description 通过指定scroll参数进行查询来清除已经创建的scroll请求。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-clearscroll</br>
         *更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-request-scroll.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'clearScroll',
        value: function clearScroll(params, callback) {
            return this.client.clearScroll(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.count
         * @description 获取集群、索引、类型或查询的文档个数。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-count</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-count.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'count',
        value: function count(params, callback) {
            return this.client.count(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.count
         * @description 在特定索引中添加一个类型化的JSON文档，使其可搜索。如果具有相同index，type且id已经存在的文档将发生错误。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-create</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-index_.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'create',
        value: function create(params, callback) {
            return this.client.create(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.delete
         * @description 根据其ID从特定索引中删除键入的JSON文档。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-delete</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-delete.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'delete',
        value: function _delete(params, callback) {
            return this.client.delete(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.delete
         * @description 根据其ID从特定索引中删除键入的JSON文档。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-deletebyquery</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-delete-by-query.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'deleteByQuery',
        value: function deleteByQuery(params, callback) {
            return this.client.deleteByQuery(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.delete
         * @description 根据其ID删除脚本。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-deletescript</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-scripting.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'deleteScript',
        value: function deleteScript(params, callback) {
            return this.client.deleteScript(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.deleteTemplate
         * @description 根据其ID删除模板。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-deletetemplate</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-template.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'deleteTemplate',
        value: function deleteTemplate(params, callback) {
            return this.client.deleteTemplate(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.exists
         * @description 检查给定文档是否存在。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-exists</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-get.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'exists',
        value: function exists(params, callback) {
            return this.client.exists(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.existsSource
         * @description 检查资源是否存在。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-existssource</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-get.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'existsSource',
        value: function existsSource(params, callback) {
            return this.client.existsSource(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.explain
         * @description 提供与特定查询相关的特定文档分数的详细信息。它还会告诉您文档是否与指定的查询匹配。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-explain</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-explain.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'explain',
        value: function explain(params, callback) {
            return this.client.explain(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.fieldCaps
         * @description 允许检索多个索引之间的字段的功能。(实验性API，可能会在未来版本中删除)</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-fieldcaps</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-field-caps.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'fieldCaps',
        value: function fieldCaps(params, callback) {
            return this.client.fieldCaps(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.get
         * @description 从索引获取一个基于其id的类型的JSON文档。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-get</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-get.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'get',
        value: function get(params, callback) {
            return this.client.get(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.getScript
         * @description 获取脚本。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-getscript</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-scripting.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'getScript',
        value: function getScript(params, callback) {
            return this.client.getScript(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.getSource
         * @description 通过索引，类型和ID获取文档的源。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-getsource</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-get.html</br>
         * @param params - {Object} 参数。
         * @param callback - {function} 回调函数。
         */

    }, {
        key: 'getSource',
        value: function getSource(params, callback) {
            return this.client.getSource(params, callback);
        }

        /**
         * @function  SuperMap.ElasticSearch.prototype.getTemplate
         * @description 获取模板。</br>
         * 参数设置参考 https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/api-reference.html#api-gettemplate</br>
         * 更多信息参考 https://www.elastic.co/guide/en/elasticsearch/reference/current/search-template.html</br>
