/*!
 * 
 *     iclient9-leaflet.(http://iclient.supermapol.com)
 *     Copyright© 2000-2017 SuperMap Software Co. Ltd
 *     license: Apache-2.0
 *     version: v9.0.0
 * 
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 471);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var SuperMap = window.SuperMap = window.SuperMap || {};
module.exports = SuperMap;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = L;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryType = exports.StatisticAnalystMode = exports.AnalystSizeUnit = exports.AnalystAreaUnit = exports.ClipAnalystMode = exports.ChartType = exports.ClientType = exports.Exponent = exports.VariogramMode = exports.InterpolationAlgorithmType = exports.SearchMode = exports.PixelFormat = exports.StatisticMode = exports.UGCLayerType = exports.LayerType = exports.ColorSpaceType = exports.GridType = exports.TransferPreference = exports.TransferTactic = exports.EditType = exports.DataReturnMode = exports.SurfaceAnalystMethod = exports.SmoothMethod = exports.OverlayOperationType = exports.BufferEndType = exports.TurnType = exports.SupplyCenterType = exports.SideType = exports.DirectionType = exports.LabelOverLengthMode = exports.LabelBackShape = exports.AlongLineDirection = exports.FillGradientMode = exports.TextAlignment = exports.ColorGradientType = exports.ThemeType = exports.RangeMode = exports.GraduatedMode = exports.GraphAxesTextDisplayMode = exports.ThemeGraphType = exports.ThemeGraphTextFormat = exports.EngineType = exports.Unit = exports.MeasureMode = exports.SpatialRelationType = exports.SpatialQueryMode = exports.JoinType = exports.QueryOption = exports.GeometryType = exports.ServerType = exports.DataFormat = undefined;

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @name DataFormat
 * @memberOf SuperMap
 * @description 服务请求返回结果数据类型
 *
 * @property {string} GEOJSON  GEOJSON
 * @property {string} ISERVER  ISERVER
 */
var DataFormat = exports.DataFormat = _SuperMap2["default"].DataFormat = {
  GEOJSON: "GEOJSON",
  ISERVER: "ISERVER"
};

/**
 * @name ServerType
 * @memberOf SuperMap
 * @description 服务器类型
 *
 * @property {string} ISERVER  ISERVER
 * @property {string} IPORTAL  IPORTAL
 * @property {string} ONLINE  ONLINE
 */
var ServerType = exports.ServerType = _SuperMap2["default"].ServerType = {
  ISERVER: "ISERVER",
  IPORTAL: "IPORTAL",
  ONLINE: "ONLINE"
};

/**
 * @name GeometryType
 * @memberOf SuperMap
 * @description 几何对象枚举,定义了一系列几何对象类型。
 *
 * @property {string} LINE  LINE
 * @property {string} LINEM  LINEM
 * @property {string} POINT  POINT
 * @property {string} REGION  REGION
 * @property {string} ELLIPSE  ELLIPSE
 * @property {string} CIRCLE  CIRCLE
 * @property {string} TEXT  TEXT
 * @property {string} UNKNOWN  UNKNOWN
 */
var GeometryType = exports.GeometryType = _SuperMap2["default"].GeometryType = {
  LINE: "LINE",
  LINEM: "LINEM",
  POINT: "POINT",
  REGION: "REGION",
  ELLIPSE: "ELLIPSE",
  CIRCLE: "CIRCLE",
  TEXT: "TEXT",
  UNKNOWN: "UNKNOWN"
};

/**
 * @name QueryOption
 * @memberOf SuperMap
 * @description 查询结果类型枚举,描述查询结果返回类型，包括只返回属性、只返回几何实体以及返回属性和几何实体。
 *
 * @property {string} ATTRIBUTE  ATTRIBUTE
 * @property {string} ATTRIBUTEANDGEOMETRY  ATTRIBUTEANDGEOMETRY
 * @property {string} GEOMETRY  GEOMETRY
 */
var QueryOption = exports.QueryOption = _SuperMap2["default"].QueryOption = {
  ATTRIBUTE: "ATTRIBUTE",
  ATTRIBUTEANDGEOMETRY: "ATTRIBUTEANDGEOMETRY",
  GEOMETRY: "GEOMETRY"
};

/**
 * @name JoinType
 * @memberOf SuperMap
 * @description 关联查询时的关联类型常量。
 * 该类定义了两个表之间的连接类型常量，决定了对两个表之间进行连接查询时，查询结果中得到的记录的情况。
 *
 * @property {string} INNERJOIN  INNERJOIN
 * @property {string} LEFTJOIN  LEFTJOIN
 */
var JoinType = exports.JoinType = _SuperMap2["default"].JoinType = {
  INNERJOIN: "INNERJOIN",
  LEFTJOIN: "LEFTJOIN"
};

/**
 * @name SpatialQueryMode
 * @memberOf SuperMap
 * @description  空间查询模式枚举。该类定义了空间查询操作模式常量。
 *
 * @property {string} CONTAIN  CONTAIN
 * @property {string} CROSS  CROSS
 * @property {string} DISJOINT  DISJOINT
 * @property {string} IDENTITY  IDENTITY
 * @property {string} INTERSECT  INTERSECT
 * @property {string} NONE  NONE
 * @property {string} OVERLAP  OVERLAP
 * @property {string} TOUCH  TOUCH
 * @property {string} WITHIN  WITHIN
 */
var SpatialQueryMode = exports.SpatialQueryMode = _SuperMap2["default"].SpatialQueryMode = {
  CONTAIN: "CONTAIN",
  CROSS: "CROSS",
  DISJOINT: "DISJOINT",
  IDENTITY: "IDENTITY",
  INTERSECT: "INTERSECT",
  NONE: "NONE",
  OVERLAP: "OVERLAP",
  TOUCH: "TOUCH",
  WITHIN: "WITHIN"
};

/**
 * @name SpatialRelationType
 * @memberOf SuperMap
 * @description  数据集对象间的空间关系枚举。
 * 该类定义了数据集对象间的空间关系类型常量。
 *
 * @property {string} CONTAIN 包含关系 CONTAIN  CONTAIN
 * @property {string} INTERSECT 相交关系 INTERSECT  INTERSECT
 * @property {string} INTERSECT 被包含关系 WITHIN  WITHIN
 */
var SpatialRelationType = exports.SpatialRelationType = _SuperMap2["default"].SpatialRelationType = {
  CONTAIN: "CONTAIN",
  INTERSECT: "INTERSECT",
  WITHIN: "WITHIN"
};

/**
 * @name MeasureMode
 * @memberOf SuperMap
 * @property {string} DISTANCE DISTANCE
 * @property {string} AREA AREA
 * @description  量算模式枚举。
 * 该类定义了两种测量模式：距离测量和面积测量。
 */
var MeasureMode = exports.MeasureMode = _SuperMap2["default"].MeasureMode = {
  DISTANCE: "DISTANCE",
  AREA: "AREA"
};

/**
 * @name Unit
 * @memberOf SuperMap
 * @description  距离单位枚举。
 * 该类定义了一系列距离单位类型。
 *
 * @property {string} METER  METER
 * @property {string} KILOMETER  KILOMETER
 * @property {string} MILE  MILE
 * @property {string} YARD  YARD
 * @property {string} DEGREE  DEGREE
 * @property {string} MILLIMETER  MILLIMETER
 * @property {string} CENTIMETER  CENTIMETER
 * @property {string} INCH  INCH
 * @property {string} DECIMETER  DECIMETER
 * @property {string} FOOT  FOOT
 * @property {string} SECOND  SECOND
 * @property {string} MINUTE  MINUTE
 * @property {string} RADIAN  RADIAN
 */
var Unit = exports.Unit = _SuperMap2["default"].Unit = {
  METER: "METER",
  KILOMETER: "KILOMETER",
  MILE: "MILE",
  YARD: "YARD",
  DEGREE: "DEGREE",
  MILLIMETER: "MILLIMETER",
  CENTIMETER: "CENTIMETER",
  INCH: "INCH",
  DECIMETER: "DECIMETER",
  FOOT: "FOOT",
  SECOND: "SECOND",
  MINUTE: "MINUTE",
  RADIAN: "RADIAN"
};

/**
 * @name EngineType
 * @memberOf SuperMap
 * @description  数据源引擎类型枚举。
 *
 * @property {string} IMAGEPLUGINS  IMAGEPLUGINS
 * @property {string} OGC  OGC
 * @property {string} ORACLEPLUS  ORACLEPLUS
 * @property {string} SDBPLUS  SDBPLUS
 * @property {string} SQLPLUS  SQLPLUS
 * @property {string} UDB  UDB
 */
var EngineType = exports.EngineType = _SuperMap2["default"].EngineType = {
  IMAGEPLUGINS: "IMAGEPLUGINS",
  OGC: "OGC",
  ORACLEPLUS: "ORACLEPLUS",
  SDBPLUS: "SDBPLUS",
  SQLPLUS: "SQLPLUS",
  UDB: "UDB"
};

/**
 * @name ThemeGraphTextFormat
 * @memberOf SuperMap
 * @description  统计专题图文本显示格式枚举。
 *
 * @property {string} CAPTION  CAPTION
 * @property {string} CAPTION_PERCENT  CAPTION_PERCENT
 * @property {string} CAPTION_VALUE  CAPTION_VALUE
 * @property {string} PERCENT  PERCENT
 * @property {string} VALUE  VALUE
 */
var ThemeGraphTextFormat = exports.ThemeGraphTextFormat = _SuperMap2["default"].ThemeGraphTextFormat = {
  CAPTION: "CAPTION",
  CAPTION_PERCENT: "CAPTION_PERCENT",
  CAPTION_VALUE: "CAPTION_VALUE",
  PERCENT: "PERCENT",
  VALUE: "VALUE"
};

/**
 * @name ThemeGraphType
 * @memberOf SuperMap
 * @description  统计专题图类型枚举。
 *
 * @property {string} AREA  AREA
 * @property {string} BAR  BAR
 * @property {string} BAR3D  BAR3D
 * @property {string} LINE  LINE
 * @property {string} PIE  PIE
 * @property {string} PIE3D  PIE3D
 * @property {string} POINT  POINT
 * @property {string} RING  RING
 * @property {string} ROSE  ROSE
 * @property {string} ROSE3D  ROSE3D
 * @property {string} STACK_BAR  STACK_BAR
 * @property {string} STACK_BAR3D  STACK_BAR3D
 * @property {string} STEP  STEP
 */
var ThemeGraphType = exports.ThemeGraphType = _SuperMap2["default"].ThemeGraphType = {
  AREA: "AREA",
  BAR: "BAR",
  BAR3D: "BAR3D",
  LINE: "LINE",
  PIE: "PIE",
  PIE3D: "PIE3D",
  POINT: "POINT",
  RING: "RING",
  ROSE: "ROSE",
  ROSE3D: "ROSE3D",
  STACK_BAR: "STACK_BAR",
  STACK_BAR3D: "STACK_BAR3D",
  STEP: "STEP"
};

/**
 * @name GraphAxesTextDisplayMode
 * @memberOf SuperMap
 * @description  统计专题图坐标轴文本显示模式。
 *
 * @property {string} ALL  ALL, 显示全部文本
 * @property {string} NONE  NONE, 没有显示
 * @property {string} YAXES  YAXES. 显示Y轴的文本
 */
var GraphAxesTextDisplayMode = exports.GraphAxesTextDisplayMode = _SuperMap2["default"].GraphAxesTextDisplayMode = {
  ALL: "ALL",
  NONE: "NONE",
  YAXES: "YAXES"
};

/**
 * @name GraduatedMode
 * @memberOf SuperMap
 * @description  专题图分级模式枚举。
 *
 * @property {string} CONSTANT  CONSTANT
 * @property {string} LOGARITHM  LOGARITHM
 * @property {string} SQUAREROOT  SQUAREROOT
 */
var GraduatedMode = exports.GraduatedMode = _SuperMap2["default"].GraduatedMode = {
  CONSTANT: "CONSTANT",
  LOGARITHM: "LOGARITHM",
  SQUAREROOT: "SQUAREROOT"
};

/**
 * @name RangeMode
 * @memberOf SuperMap
 * @description  范围分段专题图分段方式枚举。
 *
 * @property {string} CUSTOMINTERVAL  CUSTOMINTERVAL
 * @property {string} EQUALINTERVAL  EQUALINTERVAL
 * @property {string} LOGARITHM  LOGARITHM
 * @property {string} QUANTILE  QUANTILE
 * @property {string} SQUAREROOT  SQUAREROOT
 * @property {string} STDDEVIATION  STDDEVIATION
 */
var RangeMode = exports.RangeMode = _SuperMap2["default"].RangeMode = {
  CUSTOMINTERVAL: "CUSTOMINTERVAL",
  EQUALINTERVAL: "EQUALINTERVAL",
  LOGARITHM: "LOGARITHM",
  QUANTILE: "QUANTILE",
  SQUAREROOT: "SQUAREROOT",
  STDDEVIATION: "STDDEVIATION"
};

/**
 * @name ThemeType
 * @memberOf SuperMap
 * @description  专题图类型枚举。
 *
 * @property {string} DOTDENSITY  DOTDENSITY
 * @property {string} GRADUATEDSYMBOL  GRADUATEDSYMBOL
 * @property {string} GRAPH  GRAPH
 * @property {string} LABEL  LABEL
 * @property {string} RANGE  RANGE
 * @property {string} UNIQUE  UNIQUE
 */
var ThemeType = exports.ThemeType = _SuperMap2["default"].ThemeType = {
  DOTDENSITY: "DOTDENSITY",
  GRADUATEDSYMBOL: "GRADUATEDSYMBOL",
  GRAPH: "GRAPH",
  LABEL: "LABEL",
  RANGE: "RANGE",
  UNIQUE: "UNIQUE"
};

/**
 * @name ColorGradientType
 * @memberOf SuperMap
 * @description  渐变颜色枚举。
 *
 * @property {string} BLACK_WHITE  BLACKWHITE
 * @property {string} BLUE_BLACK  BLUEBLACK
 * @property {string} BLUE_RED   BLUERED
 * @property {string} BLUE_WHITE  BLUEWHITE
 * @property {string} CYAN_BLACK  CYANBLACK
 * @property {string} CYAN_BLUE  CYANBLUE
 * @property {string} CYAN_GREEN  CYANGREEN
 * @property {string} CYAN_WHITE  CYANWHITE
 * @property {string} GREEN_BLACK  GREENBLACK
 * @property {string} GREEN_BLUE  GREENBLUE
 * @property {string} GREEN_ORANGE_VIOLET  GREENORANGEVIOLET
 * @property {string} GREEN_RED  GREENRED
 * @property {string} GREEN_WHITE  GREENWHITE
 * @property {string} PINK_BLACK  PINKBLACK
 * @property {string} PINK_BLUE  PINKBLUE
 * @property {string} PINK_RED  PINKRED
 * @property {string} PINK_WHITE  PINKWHITE
 * @property {string} RAIN_BOW  RAINBOW
 * @property {string} RED_BLACK  REDBLACK
 * @property {string} RED_WHITE  REDWHITE
 * @property {string} SPECTRUM  SPECTRUM
 * @property {string} TERRAIN  TERRAIN
 * @property {string} YELLOW_BLACK  YELLOWBLACK
 * @property {string} YELLOW_BLUE  YELLOWBLUE
 * @property {string} YELLOW_GREEN  YELLOWGREEN
 * @property {string} YELLOW_RED  YELLOWRED
 * @property {string} YELLOW_WHITE  YELLOWWHITE
 */
var ColorGradientType = exports.ColorGradientType = _SuperMap2["default"].ColorGradientType = {
  BLACK_WHITE: "BLACKWHITE",
  BLUE_BLACK: "BLUEBLACK",
  BLUE_RED: "BLUERED",
  BLUE_WHITE: "BLUEWHITE",
  CYAN_BLACK: "CYANBLACK",
  CYAN_BLUE: "CYANBLUE",
  CYAN_GREEN: "CYANGREEN",
  CYAN_WHITE: "CYANWHITE",
  GREEN_BLACK: "GREENBLACK",
  GREEN_BLUE: "GREENBLUE",
  GREEN_ORANGE_VIOLET: "GREENORANGEVIOLET",
  GREEN_RED: "GREENRED",
  GREEN_WHITE: "GREENWHITE",
  PINK_BLACK: "PINKBLACK",
  PINK_BLUE: "PINKBLUE",
  PINK_RED: "PINKRED",
  PINK_WHITE: "PINKWHITE",
  RAIN_BOW: "RAINBOW",
  RED_BLACK: "REDBLACK",
  RED_WHITE: "REDWHITE",
  SPECTRUM: "SPECTRUM",
  TERRAIN: "TERRAIN",
  YELLOW_BLACK: "YELLOWBLACK",
  YELLOW_BLUE: "YELLOWBLUE",
  YELLOW_GREEN: "YELLOWGREEN",
  YELLOW_RED: "YELLOWRED",
  YELLOW_WHITE: "YELLOWWHITE"
};

/**
 * @name TextAlignment
 * @memberOf SuperMap
 * @description  文本对齐枚举。
 *
 * @property {string} TOPLEFT  TOPLEFT
 * @property {string} TOPCENTER  TOPCENTER
 * @property {string} TOPRIGHT  TOPRIGHT
 * @property {string} BASELINELEFT  BASELINELEFT
 * @property {string} BASELINECENTER  BASELINECENTER
 * @property {string} BASELINERIGHT  BASELINERIGHT
 * @property {string} BOTTOMLEFT  BOTTOMLEFT
 * @property {string} BOTTOMCENTER  BOTTOMCENTER
 * @property {string} BOTTOMRIGHT  BOTTOMRIGHT
 * @property {string} MIDDLELEFT  MIDDLELEFT
 * @property {string} MIDDLECENTER  MIDDLECENTER
 * @property {string} MIDDLERIGHT  MIDDLERIGHT
 */
var TextAlignment = exports.TextAlignment = _SuperMap2["default"].TextAlignment = {
  TOPLEFT: "TOPLEFT",
  TOPCENTER: "TOPCENTER",
  TOPRIGHT: "TOPRIGHT",
  BASELINELEFT: "BASELINELEFT",
  BASELINECENTER: "BASELINECENTER",
  BASELINERIGHT: "BASELINERIGHT",
  BOTTOMLEFT: "BOTTOMLEFT",
  BOTTOMCENTER: "BOTTOMCENTER",
  BOTTOMRIGHT: "BOTTOMRIGHT",
  MIDDLELEFT: "MIDDLELEFT",
  MIDDLECENTER: "MIDDLECENTER",
  MIDDLERIGHT: "MIDDLERIGHT"
};

/**
 * @name FillGradientMode
 * @memberOf SuperMap
 * @description  渐变填充风格的渐变类型枚举。
 *
 * @property {string} NONE  NONE
 * @property {string} LINEAR  LINEAR
 * @property {string} RADIAL  RADIAL
 * @property {string} CONICAL  CONICAL
 * @property {string} SQUARE  SQUARE
 */
var FillGradientMode = exports.FillGradientMode = _SuperMap2["default"].FillGradientMode = {
  NONE: "NONE",
  LINEAR: "LINEAR",
  RADIAL: "RADIAL",
  CONICAL: "CONICAL",
  SQUARE: "SQUARE"
};

/**
 * @name AlongLineDirection
 * @memberOf SuperMap
 * @name AlongLineDirection
 * @memberOf SuperMap
 * @description  标签沿线标注方向枚举。
 *
 * @property {string} NORMAL  ALONG_LINE_NORMAL
 * @property {string} LB_TO_RT  LEFT_BOTTOM_TO_RIGHT_TOP
 * @property {string} LT_TO_RB  LEFT_TOP_TO_RIGHT_BOTTOM
 * @property {string} RB_TO_LT  RIGHT_BOTTOM_TO_LEFT_TOP
 * @property {string} RT_TO_LB  RIGHT_TOP_TO_LEFT_BOTTOM
 */
var AlongLineDirection = exports.AlongLineDirection = _SuperMap2["default"].AlongLineDirection = {
  NORMAL: "ALONG_LINE_NORMAL",
  LB_TO_RT: "LEFT_BOTTOM_TO_RIGHT_TOP",
  LT_TO_RB: "LEFT_TOP_TO_RIGHT_BOTTOM",
  RB_TO_LT: "RIGHT_BOTTOM_TO_LEFT_TOP",
  RT_TO_LB: "RIGHT_TOP_TO_LEFT_BOTTOM"
};

/**
 * @name LabelBackShape
 * @memberOf SuperMap
 * @description  标签专题图中标签背景的形状枚举。
 *
 * @property {string} DIAMOND  DIAMOND
 * @property {string} ELLIPSE  ELLIPSE
 * @property {string} MARKER  MARKER
 * @property {string} NONE  NONE
 * @property {string} RECT  RECT
 * @property {string} ROUNDRECT  ROUNDRECT
 * @property {string} TRIANGLE  TRIANGLE
 */
var LabelBackShape = exports.LabelBackShape = _SuperMap2["default"].LabelBackShape = {
  DIAMOND: "DIAMOND",
  ELLIPSE: "ELLIPSE",
  MARKER: "MARKER",
  NONE: "NONE",
  RECT: "RECT",
  ROUNDRECT: "ROUNDRECT",
  TRIANGLE: "TRIANGLE"
};

/**
 * @name LabelOverLengthMode
 * @memberOf SuperMap
 * @description  标签专题图中超长标签的处理模式枚举。
 *
 * @property {string} NEWLINE  NEWLINE
 * @property {string} NONE  NONE
 * @property {string} OMIT  OMIT
 */
var LabelOverLengthMode = exports.LabelOverLengthMode = _SuperMap2["default"].LabelOverLengthMode = {
  NEWLINE: "NEWLINE",
  NONE: "NONE",
  OMIT: "OMIT"
};

/**
 * @name DirectionType
 * @memberOf SuperMap
 * @description  网络分析中方向枚举。
 * 在行驶引导子项中使用。
 *
 * @property {string} EAST  EAST
 * @property {string} NONE  NONE
 * @property {string} NORTH  NORTH
 * @property {string} SOURTH  SOURTH
 * @property {string} WEST  WEST
 */
var DirectionType = exports.DirectionType = _SuperMap2["default"].DirectionType = {
  EAST: "EAST",
  NONE: "NONE",
  NORTH: "NORTH",
  SOURTH: "SOURTH",
  WEST: "WEST"
};

/**
 * @name SideType
 * @memberOf SuperMap
 * @description  行驶位置枚举。
 * 表示在行驶在路的左边、右边或者路上的枚举,该类用在行驶导引子项类中。
 *
 * @property {string} LEFT  LEFT
 * @property {string} MIDDLE  MIDDLE
 * @property {string} NONE  NONE
 * @property {string} RIGHT  RIGHT
 */
var SideType = exports.SideType = _SuperMap2["default"].SideType = {
  LEFT: "LEFT",
  MIDDLE: "MIDDLE",
  NONE: "NONE",
  RIGHT: "RIGHT"
};

/**
 * @name SupplyCenterType
 * @memberOf SuperMap
 * @description  资源供给中心类型枚举。
 * 该枚举定义了网络分析中资源中心点的类型，主要用于资源分配和选址分区。
 * 资源供给中心点的类型包括非中心，固定中心和可选中心。固定中心用于资源分配分析； 固定中心和可选中心用于选址分析；非中心在两种网络分析时都不予考虑。
 *
 * @property {string} FIXEDCENTER  FIXEDCENTER
 * @property {string} NULL  NULL
 * @property {string} OPTIONALCENTER  OPTIONALCENTER
 */
var SupplyCenterType = exports.SupplyCenterType = _SuperMap2["default"].SupplyCenterType = {
  FIXEDCENTER: "FIXEDCENTER",
  NULL: "NULL",
  OPTIONALCENTER: "OPTIONALCENTER"
};

/**
 * @name TurnType
 * @memberOf SuperMap
 * @description  转弯方向枚举。
 * 用在行驶引导子项类中，表示转弯的方向。
 *
 * @property {string} AHEAD  AHEAD
 * @property {string} BACK  BACK
 * @property {string} END  END
 * @property {string} LEFT  LEFT
 * @property {string} NONE  NONE
 * @property {string} RIGHT  RIGHT
 */
var TurnType = exports.TurnType = _SuperMap2["default"].TurnType = {
  AHEAD: "AHEAD",
  BACK: "BACK",
  END: "END",
  LEFT: "LEFT",
  NONE: "NONE",
  RIGHT: "RIGHT"
};

/**
 * @name BufferEndType
 * @memberOf SuperMap
 * @description  缓冲区分析BufferEnd类型。
 *
 * @property {string} FLAT  FLAT
 * @property {string} ROUND  ROUND
 */
var BufferEndType = exports.BufferEndType = _SuperMap2["default"].BufferEndType = {
  FLAT: "FLAT",
  ROUND: "ROUND"
};

/**
 * @name OverlayOperationType
 * @memberOf SuperMap
 * @description  叠加分析类型枚举。
 *
 * @property {string} CLIP  CLIP
 * @property {string} ERASE  ERASE
 * @property {string} IDENTITY  IDENTITY
 * @property {string} INTERSECT  INTERSECT
 * @property {string} UNION  UNION
 * @property {string} UPDATE  UPDATE
 * @property {string} XOR  XOR
 */
var OverlayOperationType = exports.OverlayOperationType = _SuperMap2["default"].OverlayOperationType = {
  CLIP: "CLIP",
  ERASE: "ERASE",
  IDENTITY: "IDENTITY",
  INTERSECT: "INTERSECT",
  UNION: "UNION",
  UPDATE: "UPDATE",
  XOR: "XOR"
};

/**
 * @name SmoothMethod
 * @memberOf SuperMap
 * @description  光滑方法枚举。
 * 用于从Grid 或DEM数据生成等值线或等值面时对等值线或者等值面的边界线进行平滑处理的方法。
 *
 * @property {string} BSPLINE  BSPLINE
 * @property {string} POLISH  POLISH
 */
var SmoothMethod = exports.SmoothMethod = _SuperMap2["default"].SmoothMethod = {
  BSPLINE: "BSPLINE",
  POLISH: "POLISH"
};

/**
 * @name SurfaceAnalystMethod
 * @memberOf SuperMap
 * @description  表面分析方法枚举。
 * 通过对数据进行表面分析，能够挖掘原始数据所包含的信息，使某些细节明显化，易于分析。
 *
 * @property {string} ISOLINE  ISOLINE
 * @property {string} ISOREGION  ISOREGION
 */
var SurfaceAnalystMethod = exports.SurfaceAnalystMethod = _SuperMap2["default"].SurfaceAnalystMethod = {
  ISOLINE: "ISOLINE",
  ISOREGION: "ISOREGION"
};
/**
 * @name DataReturnMode
 * @memberOf SuperMap
 * @description  数据返回模式枚举。
 * 该枚举用于指定空间分析返回结果模式,包含返回数据集标识和记录集、只返回数据集标识(数据集名称@数据源名称)及只返回记录集三种模式。
 *
 * @property {string} DATASET_AND_RECORDSET  DATASET_AND_RECORDSET
 * @property {string} DATASET_ONLY  DATASET_ONLY
 * @property {string} RECORDSET_ONLY  RECORDSET_ONLY
 */
var DataReturnMode = exports.DataReturnMode = _SuperMap2["default"].DataReturnMode = {
  DATASET_AND_RECORDSET: "DATASET_AND_RECORDSET",
  DATASET_ONLY: "DATASET_ONLY",
  RECORDSET_ONLY: "RECORDSET_ONLY"
};

/**
 * @name EditType
 * @memberOf SuperMap
 * @description  要素集更新模式枚举。
 * 该枚举用于指定数据服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 *
 * @property {string} ADD  add
 * @property {string} UPDATE  update
 * @property {string} DELETE  delete
 */
var EditType = exports.EditType = _SuperMap2["default"].EditType = {
  ADD: "add",
  UPDATE: "update",
  DELETE: "delete"
};

/**
 * @name TransferTactic
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定公交服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 *
 * @property {string} LESS_TIME  LESS_TIME
 * @property {string} LESS_TRANSFER  LESS_TRANSFER
 * @property {string} LESS_WALK  LESS_WALK
 * @property {string} MIN_DISTANCE  MIN_DISTANCE
 */
var TransferTactic = exports.TransferTactic = _SuperMap2["default"].TransferTactic = {
  LESS_TIME: "LESS_TIME",
  LESS_TRANSFER: "LESS_TRANSFER",
  LESS_WALK: "LESS_WALK",
  MIN_DISTANCE: "MIN_DISTANCE"
};

/**
 * @name TransferPreference
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定交通换乘服务中设置地铁优先、公交优先、不乘地铁、无偏好等偏好设置。
 *
 * @property {string} BUS  BUS
 * @property {string} SUBWAY  SUBWAY
 * @property {string} NO_SUBWAY  NO_SUBWAY
 * @property {string} NONE  NONE
 */
var TransferPreference = exports.TransferPreference = _SuperMap2["default"].TransferPreference = {
  BUS: "BUS",
  SUBWAY: "SUBWAY",
  NO_SUBWAY: "NO_SUBWAY",
  NONE: "NONE"
};

/**
 * @name GridType
 * @memberOf SuperMap
 * @description  地图背景格网类型枚举。
 *
 * @property {string} CROSS  CROSS
 * @property {string} GRID  GRID
 * @property {string} POINT  POINT
 */
var GridType = exports.GridType = _SuperMap2["default"].GridType = {
  CROSS: "CROSS",
  GRID: "GRID",
  POINT: "POINT"
};

/**
 * @name ColorSpaceType
 * @memberOf SuperMap
 * @description  色彩空间枚举。
 * 由于成色原理的不同，决定了显示器、投影仪这类靠色光直接合成颜色的颜色设备和打印机、
 * 印刷机这类靠使用颜料的印刷设备在生成颜色方式上的区别。
 * 针对上述不同成色方式，SuperMap 提供两种色彩空间，
 * 分别为 RGB 和 CMYK。RGB 主要用于显示系统中，CMYK 主要用于印刷系统中。
 *
 * @property {string} CMYK  CMYK
 * @property {string} RGB  RGB
 */
var ColorSpaceType = exports.ColorSpaceType = _SuperMap2["default"].ColorSpaceType = {
  CMYK: "CMYK",
  RGB: "RGB"
};

/**
 * @name LayerType
 * @memberOf SuperMap
 * @description  图层类型。
 *
 * @property {string} UGC  UGC
 * @property {string} WMS  WMS
 * @property {string} WFS  WFS
 * @property {string} CUSTOM  CUSTOM
 */
var LayerType = exports.LayerType = _SuperMap2["default"].LayerType = {
  UGC: "UGC",
  WMS: "WMS",
  WFS: "WFS",
  CUSTOM: "CUSTOM"

};

/**
 * @name UGCLayerType
 * @memberOf SuperMap
 * @description  UGC图层类型。
 *
 * @property {string} THEME  THEME
 * @property {string} VECTOR  VECTOR
 * @property {string} GRID  GRID
 * @property {string} IMAGE  IMAGE
 */
var UGCLayerType = exports.UGCLayerType = _SuperMap2["default"].UGCLayerType = {
  THEME: "THEME",
  VECTOR: "VECTOR",
  GRID: "GRID",
  IMAGE: "IMAGE"

};

/**
 * @name StatisticMode
 * @memberOf SuperMap
 * @description  字段统计方法类型。
 *
 * @property {string} AVERAGE  AVERAGE, 统计所选字段的平均值
 * @property {string} MAX  MAX, 统计所选字段的最大值
 * @property {string} MIN  MIN, 统计所选字段的最小值
 * @property {string} STDDEVIATION  STDDEVIATION, 统计所选字段的标准差
 * @property {string} SUM  SUM, 统计所选字段的总和
 * @property {string} VARIANCE  VARIANCE, 统计所选字段的方差
 */
var StatisticMode = exports.StatisticMode = _SuperMap2["default"].StatisticMode = {
  AVERAGE: "AVERAGE",
  MAX: "MAX",
  MIN: "MIN",
  STDDEVIATION: "STDDEVIATION",
  SUM: "SUM",
  VARIANCE: "VARIANCE"
};

/**
 * @name PixelFormat
 * @memberOf SuperMap
 * @description  栅格与影像数据存储的像素格式枚举。
 *
 * @property {string} BIT16  BIT16, 每个像元用16个比特(即2个字节)表示
 * @property {string} BIT32  BIT32, 每个像元用32个比特(即4个字节)表示
 * @property {string} BIT64  BIT64, 每个像元用64个比特(即8个字节)表示，只提供给栅格数据集使用
 * @property {string} SINGLE  SINGLE, 每个像元用4个字节来表示，只提供给栅格数据集使用
 * @property {string} DOUBLE  DOUBLE, 每个像元用8个字节来表示，只提供给栅格数据集使用
 * @property {string} UBIT1  UBIT1, 每个像元用1个比特表示
 * @property {string} UBIT4  UBIT4, 每个像元用4个比特来表示
 * @property {string} UBIT8  UBIT8, 每个像元用8个比特(即1个字节)来表示
 * @property {string} UBIT24  UBIT24, 每个像元用24个比特(即3个字节)来表示
 * @property {string} UBIT32  UBIT32, 每个像元用32个比特(即4个字节)来表示
 */
var PixelFormat = exports.PixelFormat = _SuperMap2["default"].PixelFormat = {
  BIT16: "BIT16",
  BIT32: "BIT32",
  BIT64: "BIT64",
  SINGLE: "SINGLE",
  DOUBLE: "DOUBLE",
  UBIT1: "UBIT1",
  UBIT4: "UBIT4",
  UBIT8: "UBIT8",
  UBIT24: "UBIT24",
  UBIT32: "UBIT32"
};

/**
 * @name SearchMode
 * @memberOf SuperMap
 * @description  内插时使用的样本点的查找方式枚举
 *
 * @property {string} KDTREE_FIXED_COUNT  KDTREE_FIXED_COUNT, 使用 KDTREE 的固定点数方式查找参与内插分析的点
 * @property {string} KDTREE_FIXED_RADIUS  KDTREE_FIXED_RADIUS, 使用 KDTREE 的定长方式查找参与内插分析的点
 * @property {string} NONE  NONE, 不进行查找，使用所有的输入点进行内插分析
 * @property {string} QUADTREE  QUADTREE, 使用 QUADTREE 方式查找参与内插分析的点，仅对样条（RBF）插值和普通克吕金（Kriging）有用
 */
var SearchMode = exports.SearchMode = _SuperMap2["default"].SearchMode = {
  KDTREE_FIXED_COUNT: "KDTREE_FIXED_COUNT",
  KDTREE_FIXED_RADIUS: "KDTREE_FIXED_RADIUS",
  NONE: "NONE",
  QUADTREE: "QUADTREE"
};

/**
 * @name InterpolationAlgorithmType
 * @memberOf SuperMap
 * @description  插值分析的算法的类型
 *
 * @property {string} KRIGING  KRIGING, 普通克吕金插值法
 * @property {string} SimpleKriging  SimpleKriging, 简单克吕金插值法
 * @property {string} UniversalKriging  UniversalKriging, 泛克吕金插值法
 */
var InterpolationAlgorithmType = exports.InterpolationAlgorithmType = _SuperMap2["default"].InterpolationAlgorithmType = {
  KRIGING: "KRIGING",
  SimpleKriging: "SimpleKriging",
  UniversalKriging: "UniversalKriging"
};

/**
 * @name VariogramMode
 * @memberOf SuperMap
 * @description  克吕金（Kriging）插值时的半变函数类型枚举
 *
 * @property {string} EXPONENTIAL  EXPONENTIAL, 指数函数（Exponential Variogram Mode）
 * @property {string} GAUSSIAN  GAUSSIAN,  高斯函数（Gaussian Variogram Mode）
 * @property {string} SPHERICAL  SPHERICAL, 球型函数（Spherical Variogram Mode）
 */
var VariogramMode = exports.VariogramMode = _SuperMap2["default"].VariogramMode = {
  EXPONENTIAL: "EXPONENTIAL",
  GAUSSIAN: "GAUSSIAN",
  SPHERICAL: "SPHERICAL"
};

/**
 * @name Exponent
 * @memberOf SuperMap
 * @description  定义了泛克吕金（UniversalKriging）插值时样点数据中趋势面方程的阶数
 *
 * @property {string} EXP1  EXP1, 阶数为1
 * @property {string} EXP2  EXP2, 阶数为2
 */
var Exponent = exports.Exponent = _SuperMap2["default"].Exponent = {
  EXP1: "EXP1",
  EXP2: "EXP2"
};

/**
 * @name ClientType
 * @memberOf SuperMap
 * @description token申请的客户端标识类型
 *
 * @property {string} IP  IP
 * @property {string} REFERER  Referer
 * @property {string} REQUESTIP  RequestIP
 * @property {string} NONE  NONE
 * @property {string} SERVER  SERVER
 * @property {string} WEB  WEB
 */
var ClientType = exports.ClientType = _SuperMap2["default"].ClientType = {
  IP: "IP",
  REFERER: "Referer",
  REQUESTIP: "RequestIP",
  NONE: "NONE",
  SERVER: "SERVER",
  WEB: "WEB"
};

/**
 * @name ChartType
 * @memberOf SuperMap
 * @description 客户端专题图图表类型
 *
 * @property {string} BAR  Bar
 * @property {string} BAR3D  Bar3D
 * @property {string} CIRCLE  Circle
 * @property {string} PIE  Pie
 * @property {string} POINT  Point
 * @property {string} LINE  Line
 * @property {string} RING  Ring
 */
var ChartType = exports.ChartType = _SuperMap2["default"].ChartType = {
  BAR: "Bar",
  BAR3D: "Bar3D",
  CIRCLE: "Circle",
  PIE: "Pie",
  POINT: "Point",
  LINE: "Line",
  RING: "Ring"
};

/**
 * @name ClipAnalystMode
 * @memberOf SuperMap
 * @description  裁剪分析模式
 *
 * @property {string} CLIP  clip
 * @property {string} INTERSECT  intersect
 */
var ClipAnalystMode = exports.ClipAnalystMode = _SuperMap2["default"].ClipAnalystMode = {
  CLIP: "clip",
  INTERSECT: "intersect"
};
/**
 * @name AnalystAreaUnit
 * @memberOf SuperMap
 * @description 分布式分析面积单位
 *
 * @property {string} SQUAREMETER  SquareMeter
 * @property {string} SQUAREKILOMETER   SquareKiloMeter
 * @property {string} HECTARE  Hectare
 * @property {string} ARE   Are
 * @property {string} ACRE   Acre
 * @property {string} SQUAREFOOT   SquareFoot
 * @property {string} SQUAREYARD   SquareYard
 * @property {string} SQUAREMILE   SquareMile
 */
var AnalystAreaUnit = exports.AnalystAreaUnit = _SuperMap2["default"].AnalystAreaUnit = {
  "SQUAREMETER": "SquareMeter",
  "SQUAREKILOMETER": "SquareKiloMeter",
  "HECTARE": "Hectare",
  "ARE": "Are",
  "ACRE": "Acre",
  "SQUAREFOOT": "SquareFoot",
  "SQUAREYARD": "SquareYard",
  "SQUAREMILE": "SquareMile"
};
/**
 * @name AnalystSizeUnit
 * @memberOf SuperMap
 * @description 分布式分析单位
 *
 * @property {string} METER   Meter
 * @property {string} KILOMETER   Kilometer
 * @property {string} YARD   Yard
 * @property {string} FOOT   Foot
 * @property {string} MILE   Mile
 */
var AnalystSizeUnit = exports.AnalystSizeUnit = _SuperMap2["default"].AnalystSizeUnit = {
  "METER": "Meter",
  "KILOMETER": "Kilometer",
  "YARD": "Yard",
  "FOOT": "Foot",
  "MILE": "Mile"
};
/**
 * @name StatisticAnalystMode
 * @memberOf SuperMap
 * @description 分布式分析统计模式
 *
 * @property {string} MAX   max
 * @property {string} MIN   min
 * @property {string} AVERAGE   average
 * @property {string} SUM   sum
 * @property {string} VARIANCE   variance
 * @property {string} STDDEVIATION   stdDeviation
 */
var StatisticAnalystMode = exports.StatisticAnalystMode = _SuperMap2["default"].StatisticAnalystMode = {
  "MAX": "max",
  "MIN": "min",
  "AVERAGE": "average",
  "SUM": "sum",
  "VARIANCE": "variance",
  "STDDEVIATION": "stdDeviation"
};
/**
 * @name SummaryType
 * @memberOf SuperMap
 * @description 分布式分析聚合类型
 *
 * @property {string} SUMMARYMESH   SUMMARYMESH
 * @property {string} SUMMARYREGION SUMMARYREGION
 */
var SummaryType = exports.SummaryType = _SuperMap2["default"].SummaryType = {
  "SUMMARYMESH": "SUMMARYMESH",
  "SUMMARYREGION": "SUMMARYREGION"

};

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _FetchRequest = __webpack_require__(15);

__webpack_require__(171);

__webpack_require__(169);

__webpack_require__(22);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.CommonServiceBase
 * @classdesc 对接iServer各种服务的Service的基类。
 * @param url - {string} 服务地址。
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 */
var CommonServiceBase = function () {
    function CommonServiceBase(url, options) {
        _classCallCheck(this, CommonServiceBase);

        this.EVENT_TYPES = ["processCompleted", "processFailed"];
        this.events = null;
        this.eventListeners = null;
        this.url = null;
        this.urls = null;
        this.serverType = null;
        this.index = null;
        this.length = null;
        this.options = null;
        this.totalTimes = null;
        this.POLLING_TIMES = 3;
        this._processSuccess = null;
        this._processFailed = null;
        this.isInTheSameDomain = null;
        this.CLASS_NAME = "SuperMap.CommonServiceBase";

        var me = this;

        if (_SuperMap2["default"].Util.isArray(url)) {
            me.urls = url;
            me.length = url.length;
            me.totalTimes = me.length;
            if (me.length === 1) {
                me.url = url[0];
            } else {
                me.index = parseInt(Math.random() * me.length);
                me.url = url[me.index];
            }
        } else {
            me.totalTimes = 1;
            me.url = url;
        }

        if (_SuperMap2["default"].Util.isArray(url) && !me.isServiceSupportPolling()) {
            me.url = url[0];
            me.totalTimes = 1;
        }

        me.serverType = me.serverType || _SuperMap2["default"].ServerType.ISERVER;

        options = options || {};

        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }

        me.isInTheSameDomain = _SuperMap2["default"].Util.isInTheSameDomain(me.url);

        me.events = new _SuperMap2["default"].Events(me, null, me.EVENT_TYPES, true);
        if (me.eventListeners instanceof Object) {
            me.events.on(me.eventListeners);
        }
    }

    /**
     * @function SuperMap.CommonServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    _createClass(CommonServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (_SuperMap2["default"].Util.isArray(me.urls)) {
                me.urls = null;
                me.index = null;
                me.length = null;
                me.totalTimes = null;
            }
            me.url = null;
            me.options = null;
            me._processSuccess = null;
            me._processFailed = null;
            me.isInTheSameDomain = null;

            me.EVENT_TYPES = null;
            if (me.events) {
                me.events.destroy();
                me.events = null;
            }
            if (me.eventListeners) {
                me.eventListeners = null;
            }
        }

        /**
         * @function  SuperMap.CommonServiceBase.prototype.request
         * @description: 该方法用于向服务发送请求。
         * @param options - {Object} 参数。
         *        method - {string} 请求方式，包括"GET"，"POST"，"PUT"，"DELETE"。<br>
         *        url - {string}  发送请求的地址。<br>
         *        params - {Object} 作为查询字符串添加到url中的一组键值对，此参数只适用于GET方式发送的请求。<br>
         *        data - {String } 发送到服务器的数据。<br>
         *        success - {function} 请求成功后的回调函数。<br>
         *        failure - {function} 请求失败后的回调函数。<br>
         *        scope - {Object} 如果回调函数是对象的一个公共方法，设定该对象的范围。<br>
         *        isInTheSameDomain - {boolean} 请求是否在当前域中。<br>
         */

    }, {
        key: 'request',
        value: function request(options) {
            var me = this;
            options.url = options.url || me.url;
            options.isInTheSameDomain = me.isInTheSameDomain;
            //为url添加安全认证信息片段
            var credential = this.getCredential(options.url);
            if (credential) {
                //当url中含有?，并且?在url末尾的时候直接添加token *网络分析等服务请求url会出现末尾是?的情况*
                //当url中含有?，并且?不在url末尾的时候添加&token
                //当url中不含有?，在url末尾添加?token
                var endStr = options.url.substring(options.url.length - 1, options.url.length);
                if (options.url.indexOf("?") > -1 && endStr === "?") {
                    options.url += credential.getUrlParameters();
                } else if (options.url.indexOf("?") > -1 && endStr !== "?") {
                    options.url += "&" + credential.getUrlParameters();
                } else {
                    options.url += "?" + credential.getUrlParameters();
                }
            }
            me.calculatePollingTimes();
            me._processSuccess = options.success;
            me._processFailed = options.failure;
            options.scope = me;
            options.success = me.getUrlCompleted;
            options.failure = me.getUrlFailed;
            me.options = options;
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getCredential
         * @description  获取凭据信息
         * @param url - {string} 服务地址。
         * @return {SuperMap.Credential} 凭据信息对象。
         */

    }, {
        key: 'getCredential',
        value: function getCredential(url) {
            var keyUrl = url,
                credential = void 0,
                value = void 0;
            switch (this.serverType) {
                case _SuperMap2["default"].ServerType.ISERVER:
                    value = _SuperMap2["default"].SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2["default"].Credential(value, "token") : null;
                    break;
                case _SuperMap2["default"].ServerType.IPORTAL:
                    value = _SuperMap2["default"].SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2["default"].Credential(value, "token") : null;
                    if (!credential) {
                        value = _SuperMap2["default"].SecurityManager.getKey(keyUrl);
                        credential = value ? new _SuperMap2["default"].Credential(value, "key") : null;
                    }
                    break;
                case _SuperMap2["default"].ServerType.ONLINE:
                    value = _SuperMap2["default"].SecurityManager.getKey(keyUrl);
                    credential = value ? new _SuperMap2["default"].Credential(value, "key") : null;
                    break;
                default:
                    value = _SuperMap2["default"].SecurityManager.getToken(keyUrl);
                    credential = value ? new _SuperMap2["default"].Credential(value, "token") : null;
                    break;
            }
            return credential;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlCompleted
         * @description 请求成功后执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlCompleted',
        value: function getUrlCompleted(result) {
            var me = this;
            me._processSuccess(result);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.getUrlFailed
         * @description 请求失败后执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'getUrlFailed',
        value: function getUrlFailed(result) {
            var me = this;
            if (me.totalTimes > 0) {
                me.totalTimes--;
                me.ajaxPolling();
            } else {
                me._processFailed(result);
            }
        }

        /**
         *
         * @function SuperMap.CommonServiceBase.prototype.ajaxPolling
         * @description 请求失败后，如果剩余请求失败次数不为0，重新获取url发送请求
         */

    }, {
        key: 'ajaxPolling',
        value: function ajaxPolling() {
            var me = this,
                url = me.options.url,
                re = /^http:\/\/([a-z]{9}|(\d+\.){3}\d+):\d{0,4}/;
            me.index = parseInt(Math.random() * me.length);
            me.url = me.urls[me.index];
            url = url.replace(re, re.exec(me.url)[0]);
            me.options.url = url;
            me.options.isInTheSameDomain = _SuperMap2["default"].Util.isInTheSameDomain(url);
            me._commit(me.options);
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.calculatePollingTimes
         * @description 计算剩余请求失败执行次数。
         */

    }, {
        key: 'calculatePollingTimes',
        value: function calculatePollingTimes() {
            var me = this;
            if (me.times) {
                if (me.totalTimes > me.POLLING_TIMES) {
                    if (me.times > me.POLLING_TIMES) {
                        me.totalTimes = me.POLLING_TIMES;
                    } else {
                        me.totalTimes = me.times;
                    }
                } else {
                    if (me.times < me.totalTimes) {
                        me.totalTimes = me.times;
                    }
                }
            } else {
                if (me.totalTimes > me.POLLING_TIMES) {
                    me.totalTimes = me.POLLING_TIMES;
                }
            }
            me.totalTimes--;
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.isServiceSupportPolling
         * @description 判断服务是否支持轮询。
         */

    }, {
        key: 'isServiceSupportPolling',
        value: function isServiceSupportPolling() {
            var me = this;
            return !(me.CLASS_NAME === "SuperMap.REST.ThemeService" || me.CLASS_NAME === "SuperMap.REST.EditFeaturesService");
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessCompleted
         * @description 状态完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            result = _SuperMap2["default"].Util.transformResult(result);
            this.events.triggerEvent("processCompleted", { result: result });
        }

        /**
         * @function SuperMap.CommonServiceBase.prototype.serviceProcessFailed
         * @description 状态失败，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            result = _SuperMap2["default"].Util.transformResult(result);
            var error = result.error || result;
            this.events.triggerEvent("processFailed", { error: error });
        }
    }, {
        key: '_commit',
        value: function _commit(options) {
            if (options.method === "POST" || options.method === "PUT") {
                if (options.params) {
                    options.url = _SuperMap2["default"].Util.urlAppend(options.url, _SuperMap2["default"].Util.getParameterString(options.params || {}));
                }
                options.params = options.data;
            }
            _FetchRequest.FetchRequest.commit(options.method, options.url, options.params, {
                headers: options.headers,
                withCredentials: options.withCredentials,
                timeout: options.async ? 0 : null,
                proxy: options.proxy
            }).then(function (response) {
                return response.text();
            }).then(function (text) {
                var result = new _SuperMap2["default"].Format.JSON().read(text);
                if (!result) {
                    result = { error: text };
                }
                if (result.error) {
                    var failure = options.scope ? _SuperMap2["default"].Function.bind(options.failure, options.scope) : options.failure;
                    failure(result.error);
                } else {
                    result.succeed = result.succeed == undefined ? true : result.succeed;
                    var success = options.scope ? _SuperMap2["default"].Function.bind(options.success, options.scope) : options.success;
                    success(result);
                }
            });
        }
    }]);

    return CommonServiceBase;
}();

exports["default"] = CommonServiceBase;


_SuperMap2["default"].CommonServiceBase = CommonServiceBase;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

__webpack_require__(105);

__webpack_require__(407);

__webpack_require__(406);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

_leaflet2["default"].supermap = _leaflet2["default"].supermap || {}; /**
                                                                *SuperMap Leaflet基类
                                                                * 定义命名空间
                                                                * 提供公共模块
                                                                */

_leaflet2["default"].supermap.control = _leaflet2["default"].supermap.control || {};

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Util = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

__webpack_require__(56);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Util = exports.Util = _SuperMap2["default"].Util = _SuperMap2["default"].Util || {};
/**
 * @name Util
 * @memberOf SuperMap
 * @namespace
 * @description common工具类。
 */

/**
 * @description 复制源对象的所有属性到目标对象上，源对象上的没有定义的属性在目标对象上也不会被设置。
 * @example
 * 要复制SuperMap.Size对象的所有属性到自定义对象上，使用方法如下:
 *     var size = new SuperMap.Size(100, 100);
 *     var obj = {}；
 *     SuperMap.Util.extend(obj, size);
 * @param destination - {Object} 目标对象。
 * @param source - {Object} 源对象，其属性将被设置到目标对象上。
 * @return {Object} 目标对象。
 */

_SuperMap2["default"].Util.extend = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }

        /**
         * IE doesn't include the toString property when iterating over an object's
         * properties with the for(property in object) syntax.  Explicitly check if
         * the source has its own toString property.
         */

        /*
         * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
         * prototype object" when calling hawOwnProperty if the source object
         * is an instance of window.Event.
         */

        var sourceIsEvt = typeof window.Event === "function" && source instanceof window.Event;

        if (!sourceIsEvt && source.hasOwnProperty && source.hasOwnProperty("toString")) {
            destination.toString = source.toString;
        }
    }
    return destination;
};
/**
 * @description 对象拷贝。
 * @param des - {Object} 目标对象。
 * @param soc - {Object} 源对象
 */
_SuperMap2["default"].Util.copy = function (des, soc) {
    des = des || {};
    var v;
    if (soc) {
        for (var p in des) {
            v = soc[p];
            if (typeof v !== 'undefined') {
                des[p] = v;
            }
        }
    }
};
/**
 * @description 销毁对象，将其属性置空
 * @param obj - {Object} 目标对象。
 */
_SuperMap2["default"].Util.reset = function (obj) {
    obj = obj || {};
    for (var p in obj) {
        if (obj.hasOwnProperty(p)) {
            if (_typeof(obj[p]) === "object" && obj[p] instanceof Array) {
                for (var i in obj[p]) {
                    if (obj[p][i].destroy) {
                        obj[p][i].destroy();
                    }
                }
                obj[p].length = 0;
            } else if (_typeof(obj[p]) === "object" && obj[p] instanceof Object) {
                if (obj[p].destroy) {
                    obj[p].destroy();
                }
            }
            obj[p] = null;
        }
    }
};

/**
 * @description 获取HTML元素数组。
 * @param argument - {String | HTMLElement | Window}
 * @return {Array<HTMLElement>} HTML元素数组。
 */
_SuperMap2["default"].Util.getElement = function () {
    var elements = [];

    for (var i = 0, len = arguments.length; i < len; i++) {
        var element = arguments[i];
        if (typeof element === 'string') {
            element = document.getElementById(element);
        }
        if (arguments.length === 1) {
            return element;
        }
        elements.push(element);
    }
    return elements;
};

/**
 * @description instance of的跨浏览器实现。
 * @param o - {Object} 对象。
 * @return {boolean}
 */
_SuperMap2["default"].Util.isElement = function (o) {
    return !!(o && o.nodeType === 1);
};

/**
 * @description 判断一个对象是否是数组。
 * @param a - {Object} 对象。
 * @return {boolean} 是否是数组。
 */
_SuperMap2["default"].Util.isArray = function (a) {
    return Object.prototype.toString.call(a) === '[object Array]';
};

/**
 * @description 从数组中删除某一项。
 * @param array - {Array} 数组。
 * @param item - {Object} 数组中要删除的一项。
 * @return {Array} 执行删除操作后的数组。
 */
_SuperMap2["default"].Util.removeItem = function (array, item) {
    for (var i = array.length - 1; i >= 0; i--) {
        if (array[i] === item) {
            array.splice(i, 1);
            //break;more than once??
        }
    }
    return array;
};

/**
 * @description 获取某对象再数组中的索引值。
 * @param array - {Array} 数组。
 * @param obj - {Object} 对象。
 * @return {number} 某对象再数组中的索引值。
 */
_SuperMap2["default"].Util.indexOf = function (array, obj) {
    if (array == null) {
        return -1;
    } else {
        // use the build-in function if available.
        if (typeof array.indexOf === "function") {
            return array.indexOf(obj);
        } else {
            for (var i = 0, len = array.length; i < len; i++) {
                if (array[i] === obj) {
                    return i;
                }
            }
            return -1;
        }
    }
};

/**
 * @description 修改某DOM元素的许多属性。
 * @param element - {HTMLElement} 待修改的DOM元素。
 * @param id - {string} DOM元素的id。
 * @param px - {SuperMap.Pixel} 包含DOM元素的style属性的left和top属性。
 * @param sz - {SuperMap.Size} 包含DOM元素的width和height属性。
 * @param position - {string} DOM元素的position属性。
 * @param border - {string} DOM元素的style属性的border属性。
 * @param overflow - {string} DOM元素的style属性的overflow属性。
 * @param opacity - {number} 不透明度值。取值范围为 (0.0 - 1.0)。
 */
_SuperMap2["default"].Util.modifyDOMElement = function (element, id, px, sz, position, border, overflow, opacity) {

    if (id) {
        element.id = id;
    }
    if (px) {
        element.style.left = px.x + "px";
        element.style.top = px.y + "px";
    }
    if (sz) {
        element.style.width = sz.w + "px";
        element.style.height = sz.h + "px";
    }
    if (position) {
        element.style.position = position;
    }
    if (border) {
        element.style.border = border;
    }
    if (overflow) {
        element.style.overflow = overflow;
    }
    if (parseFloat(opacity) >= 0.0 && parseFloat(opacity) < 1.0) {
        element.style.filter = 'alpha(opacity=' + opacity * 100 + ')';
        element.style.opacity = opacity;
    } else if (parseFloat(opacity) === 1.0) {
        element.style.filter = '';
        element.style.opacity = '';
    }
};

/**
 * @param params - {Object} 参数对象。
 * @return {string} HTTP的GEI请求中的参数字符串。
 * @description 将参数对象转换为HTTP的GEI请求中的参数字符串。例如："key1=value1&key2=value2&key3=value3"。
 */
_SuperMap2["default"].Util.getParameterString = function (params) {
    var paramsArray = [];

    for (var key in params) {
        var value = params[key];
        if (value != null && typeof value !== 'function') {
            var encodedValue;
            if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                /* value is an array; encode items and separate with "," */
                var encodedItemArray = [];
                var item;
                for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                    item = value[itemIndex];
                    encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                }
                encodedValue = encodedItemArray.join(",");
            } else {
                /* value is a string; simply encode */
                encodedValue = encodeURIComponent(value);
            }
            paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
        }
    }

    return paramsArray.join("&");
};

/**
 * @description 给url追加参数。
 * @param url - {string} 待追加参数的url字符串。
 * @param paramStr - {string} 待追加的参数。
 * @return {string} The new url
 */
_SuperMap2["default"].Util.urlAppend = function (url, paramStr) {
    var newUrl = url;
    if (paramStr) {
        var parts = (url + " ").split(/[?&]/);
        newUrl += parts.pop() === " " ? paramStr : parts.length ? "&" + paramStr : "?" + paramStr;
    }
    return newUrl;
};

/**
 * @description 为了避免浮点精度错误而保留的有效位数。
 * @type {number}
 * @default 14
 */
_SuperMap2["default"].Util.DEFAULT_PRECISION = 14;

/**
 * @description 将字符串以接近的精度转换为数字。
 * @param number - {string} 字符串。
 * @param precision - {number} 精度。
 * @return {number} 数字。
 */
_SuperMap2["default"].Util.toFloat = function (number, precision) {
    if (precision == null) {
        precision = _SuperMap2["default"].Util.DEFAULT_PRECISION;
    }
    if (typeof number !== "number") {
        number = parseFloat(number);
    }
    return precision === 0 ? number : parseFloat(number.toPrecision(precision));
};

/**
 * @description 角度转弧度。
 * @param x - {number} 角度。
 * @return {number} 弧度。
 */
_SuperMap2["default"].Util.rad = function (x) {
    return x * Math.PI / 180;
};

/**
 * @description 从URL字符串中解析出参数对象。
 * @param url - {string} url。
 * @return {Object} 解析出的参数对象。
 */
_SuperMap2["default"].Util.getParameters = function (url) {
    // if no url specified, take it from the location bar
    url = url === null || url === undefined ? window.location.href : url;

    //parse out parameters portion of url string
    var paramsString = "";
    if (_SuperMap2["default"].String.contains(url, '?')) {
        var start = url.indexOf('?') + 1;
        var end = _SuperMap2["default"].String.contains(url, "#") ? url.indexOf('#') : url.length;
        paramsString = url.substring(start, end);
    }

    var parameters = {};
    var pairs = paramsString.split(/[&;]/);
    for (var i = 0, len = pairs.length; i < len; ++i) {
        var keyValue = pairs[i].split('=');
        if (keyValue[0]) {

            var key = keyValue[0];
            try {
                key = decodeURIComponent(key);
            } catch (err) {
                key = unescape(key);
            }

            // being liberal by replacing "+" with " "
            var value = (keyValue[1] || '').replace(/\+/g, " ");

            try {
                value = decodeURIComponent(value);
            } catch (err) {
                value = unescape(value);
            }

            // follow OGC convention of comma delimited values
            value = value.split(",");

            //if there's only one value, do not return as array                    
            if (value.length == 1) {
                value = value[0];
            }

            parameters[key] = value;
        }
    }
    return parameters;
};

/**
 * @description 不断递增计数变量，用于生成唯一ID。
 * @type {number}
 * @default 0
 */
_SuperMap2["default"].Util.lastSeqID = 0;

/**
 * @description 创建唯一ID值。
 * @param prefix {string} 前缀。
 * @return {string} 唯一的ID值。
 */
_SuperMap2["default"].Util.createUniqueID = function (prefix) {
    if (prefix == null) {
        prefix = "id_";
    }
    _SuperMap2["default"].Util.lastSeqID += 1;
    return prefix + _SuperMap2["default"].Util.lastSeqID;
};

/**
 * @memberOf SuperMap
 * @description 每单位的英尺数。
 * @type {Object}
 * @constant
 */
_SuperMap2["default"].INCHES_PER_UNIT = {
    'inches': 1.0,
    'ft': 12.0,
    'mi': 63360.0,
    'm': 39.3701,
    'km': 39370.1,
    'dd': 4374754,
    'yd': 36
};
_SuperMap2["default"].INCHES_PER_UNIT["in"] = _SuperMap2["default"].INCHES_PER_UNIT.inches;
_SuperMap2["default"].INCHES_PER_UNIT["degrees"] = _SuperMap2["default"].INCHES_PER_UNIT.dd;
_SuperMap2["default"].INCHES_PER_UNIT["nmi"] = 1852 * _SuperMap2["default"].INCHES_PER_UNIT.m;

// Units from CS-Map
_SuperMap2["default"].METERS_PER_INCH = 0.02540005080010160020;
_SuperMap2["default"].Util.extend(_SuperMap2["default"].INCHES_PER_UNIT, {
    "Inch": _SuperMap2["default"].INCHES_PER_UNIT.inches,
    "Meter": 1.0 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9001
    "Foot": 0.30480060960121920243 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9003
    "IFoot": 0.30480000000000000000 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9002
    "ClarkeFoot": 0.3047972651151 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9005
    "SearsFoot": 0.30479947153867624624 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9041
    "GoldCoastFoot": 0.30479971018150881758 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9094
    "IInch": 0.02540000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "MicroInch": 0.00002540000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Mil": 0.00000002540000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Centimeter": 0.01000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Kilometer": 1000.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9036
    "Yard": 0.91440182880365760731 / _SuperMap2["default"].METERS_PER_INCH,
    "SearsYard": 0.914398414616029 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9040
    "IndianYard": 0.91439853074444079983 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9084
    "IndianYd37": 0.91439523 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9085
    "IndianYd62": 0.9143988 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9086
    "IndianYd75": 0.9143985 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9087
    "IndianFoot": 0.30479951 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9080
    "IndianFt37": 0.30479841 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9081
    "IndianFt62": 0.3047996 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9082
    "IndianFt75": 0.3047995 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9083
    "Mile": 1609.34721869443738887477 / _SuperMap2["default"].METERS_PER_INCH,
    "IYard": 0.91440000000000000000 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9096
    "IMile": 1609.34400000000000000000 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9093
    "NautM": 1852.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9030
    "Lat-66": 110943.316488932731 / _SuperMap2["default"].METERS_PER_INCH,
    "Lat-83": 110946.25736872234125 / _SuperMap2["default"].METERS_PER_INCH,
    "Decimeter": 0.10000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Millimeter": 0.00100000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Dekameter": 10.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Decameter": 10.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "Hectometer": 100.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "GermanMeter": 1.0000135965 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9031
    "CaGrid": 0.999738 / _SuperMap2["default"].METERS_PER_INCH,
    "ClarkeChain": 20.1166194976 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9038
    "GunterChain": 20.11684023368047 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9033
    "BenoitChain": 20.116782494375872 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9062
    "SearsChain": 20.11676512155 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9042
    "ClarkeLink": 0.201166194976 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9039
    "GunterLink": 0.2011684023368047 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9034
    "BenoitLink": 0.20116782494375872 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9063
    "SearsLink": 0.2011676512155 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9043
    "Rod": 5.02921005842012 / _SuperMap2["default"].METERS_PER_INCH,
    "IntnlChain": 20.1168 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9097
    "IntnlLink": 0.201168 / _SuperMap2["default"].METERS_PER_INCH, //EPSG:9098
    "Perch": 5.02921005842012 / _SuperMap2["default"].METERS_PER_INCH,
    "Pole": 5.02921005842012 / _SuperMap2["default"].METERS_PER_INCH,
    "Furlong": 201.1684023368046 / _SuperMap2["default"].METERS_PER_INCH,
    "Rood": 3.778266898 / _SuperMap2["default"].METERS_PER_INCH,
    "CapeFoot": 0.3047972615 / _SuperMap2["default"].METERS_PER_INCH,
    "Brealey": 375.00000000000000000000 / _SuperMap2["default"].METERS_PER_INCH,
    "ModAmFt": 0.304812252984505969011938 / _SuperMap2["default"].METERS_PER_INCH,
    "Fathom": 1.8288 / _SuperMap2["default"].METERS_PER_INCH,
    "NautM-UK": 1853.184 / _SuperMap2["default"].METERS_PER_INCH,
    "50kilometers": 50000.0 / _SuperMap2["default"].METERS_PER_INCH,
    "150kilometers": 150000.0 / _SuperMap2["default"].METERS_PER_INCH
});

//unit abbreviations supported by PROJ.4
_SuperMap2["default"].Util.extend(_SuperMap2["default"].INCHES_PER_UNIT, {
    "mm": _SuperMap2["default"].INCHES_PER_UNIT["Meter"] / 1000.0,
    "cm": _SuperMap2["default"].INCHES_PER_UNIT["Meter"] / 100.0,
    "dm": _SuperMap2["default"].INCHES_PER_UNIT["Meter"] * 100.0,
    "km": _SuperMap2["default"].INCHES_PER_UNIT["Meter"] * 1000.0,
    "kmi": _SuperMap2["default"].INCHES_PER_UNIT["nmi"], //International Nautical Mile
    "fath": _SuperMap2["default"].INCHES_PER_UNIT["Fathom"], //International Fathom
    "ch": _SuperMap2["default"].INCHES_PER_UNIT["IntnlChain"], //International Chain
    "link": _SuperMap2["default"].INCHES_PER_UNIT["IntnlLink"], //International Link
    "us-in": _SuperMap2["default"].INCHES_PER_UNIT["inches"], //U.S. Surveyor's Inch
    "us-ft": _SuperMap2["default"].INCHES_PER_UNIT["Foot"], //U.S. Surveyor's Foot
    "us-yd": _SuperMap2["default"].INCHES_PER_UNIT["Yard"], //U.S. Surveyor's Yard
    "us-ch": _SuperMap2["default"].INCHES_PER_UNIT["GunterChain"], //U.S. Surveyor's Chain
    "us-mi": _SuperMap2["default"].INCHES_PER_UNIT["Mile"], //U.S. Surveyor's Statute Mile
    "ind-yd": _SuperMap2["default"].INCHES_PER_UNIT["IndianYd37"], //Indian Yard
    "ind-ft": _SuperMap2["default"].INCHES_PER_UNIT["IndianFt37"], //Indian Foot
    "ind-ch": 20.11669506 / _SuperMap2["default"].METERS_PER_INCH //Indian Chain
});

/**
 * @memberOf SuperMap
 * @description 分辨率与比例尺之间转换的常量，默认值96。
 * @type {Object}
 * @default 96
 */
_SuperMap2["default"].DOTS_PER_INCH = 96;

/**
 * @param scale - {number}
 * @return {number}
 */
_SuperMap2["default"].Util.normalizeScale = function (scale) {
    var normScale = scale > 1.0 ? 1.0 / scale : scale;
    return normScale;
};

/**
 * @param scale - {number} 比例尺。
 * @param units - {string} 比例尺单位。
 * @return {number} 分辨率。
 */
_SuperMap2["default"].Util.getResolutionFromScale = function (scale, units) {
    var resolution;
    if (scale) {
        if (units == null) {
            units = "degrees";
        }
        var normScale = _SuperMap2["default"].Util.normalizeScale(scale);
        resolution = 1 / (normScale * _SuperMap2["default"].INCHES_PER_UNIT[units] * _SuperMap2["default"].DOTS_PER_INCH);
    }
    return resolution;
};

/**
 * @description 分辨率转比例尺。
 * @param resolution - {number} 分辨率。
 * @param units - {string} 分辨率单位。
 * @return {number} 比例尺。
 */
_SuperMap2["default"].Util.getScaleFromResolution = function (resolution, units) {

    if (units == null) {
        units = "degrees";
    }

    var scale = resolution * _SuperMap2["default"].INCHES_PER_UNIT[units] * _SuperMap2["default"].DOTS_PER_INCH;
    return scale;
};

/**
 * @memberOf SuperMap
 * @description 如果userAgent捕获到浏览器使用的是Gecko引擎则返回true。
 * @constant
 */
_SuperMap2["default"].IS_GECKO = function () {
    var ua = navigator.userAgent.toLowerCase();
    return ua.indexOf("webkit") === -1 && ua.indexOf("gecko") !== -1;
}();

/**
 * @memberOf SuperMap
 * @description 浏览器名称，依赖于userAgent属性，BROWSER_NAME可以是空，或者以下浏览器：
 *     * "opera" -- Opera
 *     * "msie"  -- Internet Explorer
 *     * "safari" -- Safari
 *     * "firefox" -- Firefox
 *     * "mozilla" -- Mozilla
 * @constant
 */
_SuperMap2["default"].Browser = function () {
    var name = '',
        version = '',
        device = 'pc',
        uaMatch;
    //以下进行测试
    var ua = navigator.userAgent.toLowerCase();
    if (ua.indexOf("msie") > -1 || ua.indexOf("trident") > -1 && ua.indexOf("rv") > -1) {
        name = 'msie';
        uaMatch = ua.match(/msie ([\d.]+)/) || ua.match(/rv:([\d.]+)/);
    } else if (ua.indexOf("chrome") > -1) {
        name = 'chrome';
        uaMatch = ua.match(/chrome\/([\d.]+)/);
    } else if (ua.indexOf("firefox") > -1) {
        name = 'firefox';
        uaMatch = ua.match(/firefox\/([\d.]+)/);
    } else if (ua.indexOf("opera") > -1) {
        name = 'opera';
        uaMatch = ua.match(/version\/([\d.]+)/);
    } else if (ua.indexOf("safari") > -1) {
        name = 'safari';
        uaMatch = ua.match(/version\/([\d.]+)/);
    }
    version = uaMatch ? uaMatch[1] : '';

    if (ua.indexOf("ipad") > -1 || ua.indexOf("ipod") > -1 || ua.indexOf("iphone") > -1) {
        device = 'apple';
    } else if (ua.indexOf("android") > -1) {
        uaMatch = ua.match(/version\/([\d.]+)/);
        version = uaMatch ? uaMatch[1] : '';
        device = 'android';
    }
    return { name: name, version: version, device: device };
}();

/**
 * @description 获取浏览器相关信息。支持的浏览器包括：Opera，Internet Explorer，Safari，Firefox。
 * @return {Object} 获取浏览器名称、版本、设备名称。对应的属性分别为 name, version, device。
 */
_SuperMap2["default"].Util.getBrowser = function () {
    return _SuperMap2["default"].Browser;
};

/**
 * @description 浏览器是否支持Canvas。
 * @return {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */
_SuperMap2["default"].Util.isSupportCanvas = function () {
    var checkRes = true,
        broz = _SuperMap2["default"].Util.getBrowser();
    if (document.createElement("canvas").getContext) {
        if (broz.name === 'firefox' && parseFloat(broz.version) < 5) {
            checkRes = false;
        }
        if (broz.name === 'safari' && parseFloat(broz.version) < 4) {
            checkRes = false;
        }
        if (broz.name === 'opera' && parseFloat(broz.version) < 10) {
            checkRes = false;
        }
        if (broz.name === 'msie' && parseFloat(broz.version) < 9) {
            checkRes = false;
        }
    } else {
        checkRes = false;
    }
    return checkRes;
}();

/**
 * @description 判断；浏览器是否支持Canvas。
 * @return {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */
_SuperMap2["default"].Util.supportCanvas = function () {
    return _SuperMap2["default"].Util.isSupportCanvas;
};

//将服务端的地图单位转成SuperMap的地图单位
_SuperMap2["default"].INCHES_PER_UNIT["degree"] = _SuperMap2["default"].INCHES_PER_UNIT.dd;
_SuperMap2["default"].INCHES_PER_UNIT["meter"] = _SuperMap2["default"].INCHES_PER_UNIT.m;
_SuperMap2["default"].INCHES_PER_UNIT["foot"] = _SuperMap2["default"].INCHES_PER_UNIT.ft;
_SuperMap2["default"].INCHES_PER_UNIT["inch"] = _SuperMap2["default"].INCHES_PER_UNIT.inches;
_SuperMap2["default"].INCHES_PER_UNIT["mile"] = _SuperMap2["default"].INCHES_PER_UNIT.mi;
_SuperMap2["default"].INCHES_PER_UNIT["kilometer"] = _SuperMap2["default"].INCHES_PER_UNIT.km;
_SuperMap2["default"].INCHES_PER_UNIT["yard"] = _SuperMap2["default"].INCHES_PER_UNIT.yd;

/**
 * @description 判断一个 URL 请求是否在当前域中。
 * @param url - {string}  URL 请求字符串。
 * @return {boolean} URL请求是否在当前域中。
 */
_SuperMap2["default"].Util.isInTheSameDomain = function (url) {
    if (!url) {
        return true;
    }
    var index = url.indexOf("//");
    var documentUrl = document.location.toString();
    var documentIndex = documentUrl.indexOf("//");
    if (index === -1) {
        return true;
    } else {
        var protocol;
        var substring = protocol = url.substring(0, index);
        var documentSubString = documentUrl.substring(documentIndex + 2);
        documentIndex = documentSubString.indexOf("/");
        var documentPortIndex = documentSubString.indexOf(":");
        var documentDomainWithPort = documentSubString.substring(0, documentIndex);
        var documentPort;

        var documentprotocol = document.location.protocol;
        if (documentPortIndex !== -1) {
            documentPort = +documentSubString.substring(documentPortIndex, documentIndex);
        } else {
            documentDomainWithPort += ':' + (documentprotocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        if (documentprotocol.toLowerCase() !== substring.toLowerCase()) {
            return false;
        }
        substring = url.substring(index + 2);
        var portIndex = substring.indexOf(":");
        index = substring.indexOf("/");
        var domainWithPort = substring.substring(0, index);
        var domain;
        if (portIndex !== -1) {
            domain = substring.substring(0, portIndex);
        } else {
            domain = substring.substring(0, index);
            domainWithPort += ':' + (protocol.toLowerCase() === 'http:' ? 80 : 443);
        }
        var documentDomain = document.domain;
        if (domain === documentDomain && domainWithPort === documentDomainWithPort) {
            return true;
        }
    }
    return false;
};

/**
 * @description 计算iServer服务的REST图层的显示分辨率，需要从iServer的REST图层表述中获取viewBounds、viewer、scale、coordUnit、datumAxis 五个参数，来进行计算。
 * @param viewBounds - {SuperMap.Bounds} 地图的参照可视范围，即地图初始化时默认的地图显示范围。
 * @param viewer - {SuperMap.Size} 地图初始化时默认的地图图片的尺寸。
 * @param scale - {number} 地图初始化时默认的显示比例尺。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则系统默认为WGS84参考系的椭球体长半轴6378137。
 * @return {number} 返回图层显示分辨率。
 */
_SuperMap2["default"].Util.calculateDpi = function (viewBounds, viewer, scale, coordUnit, datumAxis) {
    //10000 是 0.1毫米与米的转换。DPI的计算公式：Viewer / DPI *  0.0254 * 10000 = ViewBounds * scale ，公式中的10000是为了提高计算结果的精度，以下出现的ratio皆为如此。
    if (!viewBounds || !viewer || !scale) {
        return;
    }
    var ratio = 10000,
        rvbWidth = viewBounds.getWidth(),
        rvbHeight = viewBounds.getHeight(),
        rvWidth = viewer.w,
        rvHeight = viewer.h;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "degrees";
    if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
        var num1 = rvbWidth / rvWidth,
            num2 = rvbHeight / rvHeight,
            resolution = num1 > num2 ? num1 : num2,
            dpi = 0.0254 * ratio / resolution / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
        return dpi;
    } else {
        var resolution = rvbWidth / rvWidth,
            dpi = 0.0254 * ratio / resolution / scale / ratio;
        return dpi;
    }
};

/**
 * @description 将对象转换成 JSON 字符串。
 * @param obj - {Object} 要转换成 JSON 的 Object 对象。
 * @return {string} 返回转换后的 JSON 对象。
 */
_SuperMap2["default"].Util.toJSON = function (obj) {
    var objInn = obj;
    if (objInn == null) {
        return null;
    }
    switch (objInn.constructor) {
        case String:
            //s = "'" + str.replace(/(["\\])/g, "\\$1") + "'";   string含有单引号出错
            objInn = '"' + objInn.replace(/(["\\])/g, '\\$1') + '"';
            objInn = objInn.replace(/\n/g, "\\n");
            objInn = objInn.replace(/\r/g, "\\r");
            objInn = objInn.replace("<", "&lt;");
            objInn = objInn.replace(">", "&gt;");
            objInn = objInn.replace(/%/g, "%25");
            objInn = objInn.replace(/&/g, "%26");
            return objInn;
        case Array:
            var arr = [];
            for (var i = 0, len = objInn.length; i < len; i++) {
                arr.push(_SuperMap2["default"].Util.toJSON(objInn[i]));
            }
            return "[" + arr.join(",") + "]";
        case Number:
            return isFinite(objInn) ? String(objInn) : null;
        case Boolean:
            return String(objInn);
        case Date:
            var dateStr = "{" + "'__type':\"System.DateTime\"," + "'Year':" + objInn.getFullYear() + "," + "'Month':" + (objInn.getMonth() + 1) + "," + "'Day':" + objInn.getDate() + "," + "'Hour':" + objInn.getHours() + "," + "'Minute':" + objInn.getMinutes() + "," + "'Second':" + objInn.getSeconds() + "," + "'Millisecond':" + objInn.getMilliseconds() + "," + "'TimezoneOffset':" + objInn.getTimezoneOffset() + "}";
            return dateStr;
        default:
            if (objInn["toJSON"] != null && typeof objInn["toJSON"] === "function") {
                return objInn.toJSON();
            }
            if ((typeof objInn === 'undefined' ? 'undefined' : _typeof(objInn)) === "object") {
                if (objInn.length) {
                    var arr = [];
                    for (var i = 0, len = objInn.length; i < len; i++) {
                        arr.push(_SuperMap2["default"].Util.toJSON(objInn[i]));
                    }return "[" + arr.join(",") + "]";
                }
                var arr = [];
                for (var attr in objInn) {
                    //为解决SuperMap.Geometry类型头json时堆栈溢出的问题，attr == "parent"时不进行json转换
                    if (typeof objInn[attr] !== "function" && attr !== "CLASS_NAME" && attr !== "parent") {
                        arr.push("'" + attr + "':" + _SuperMap2["default"].Util.toJSON(objInn[attr]));
                    }
                }

                if (arr.length > 0) {
                    return "{" + arr.join(",") + "}";
                } else {
                    return "{}";
                }
            }
            return objInn.toString();
    }
};

/**
 * @description 根据比例尺和dpi计算屏幕分辨率。
 * @param scale - {number} 比例尺。
 * @param dpi - {number} 图像分辨率，表示每英寸内的像素个数。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则DPI默认按照WGS84参考系的椭球体长半轴6378137来计算。
 * @return {number} 返回当前比例尺下的屏幕分辨率。
 */
_SuperMap2["default"].Util.getResolutionFromScaleDpi = function (scale, dpi, coordUnit, datumAxis) {
    var resolution = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (scale > 0 && dpi > 0) {
        scale = _SuperMap2["default"].Util.normalizeScale(scale);
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            //scale = SuperMap.Util.normalizeScale(scale);
            resolution = 0.0254 * ratio / dpi / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
            return resolution;
        } else {
            resolution = 0.0254 * ratio / dpi / scale / ratio;
            return resolution;
        }
    }
    return -1;
};

/**
 * @description 根据resolution、dpi、coordUnit和datumAxis计算比例尺。
 * @param resolution - {number} 用于计算比例尺的地图分辨率。
 * @param dpi - {number} 图像分辨率，表示每英寸内的像素个数。
 * @param coordUnit - {string} 投影坐标系统的地图单位。
 * @param datumAxis - {number} 地理坐标系统椭球体长半轴。用户自定义地图的Options时，若未指定该参数的值，则DPI默认按照WGS84参考系的椭球体长半轴6378137来计算。
 * @return {number} 返回当前屏幕分辨率下的比例尺。
 */
_SuperMap2["default"].Util.getScaleFromResolutionDpi = function (resolution, dpi, coordUnit, datumAxis) {
    var scale = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (resolution > 0 && dpi > 0) {
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            scale = 0.0254 * ratio / dpi / resolution / (Math.PI * 2 * datumAxis / 360) / ratio;
            return scale;
        } else {
            scale = 0.0254 * ratio / dpi / resolution / ratio;
            return scale;
        }
    }
    return -1;
};

/**
 * @description 转换查询结果。
 * @param result - {Object} 查询结果。
 * @return {Object} 转换后的查询结果。
 */
_SuperMap2["default"].Util.transformResult = function (result) {
    if (result.responseText && typeof result.responseText === "string") {
        //支持JSON对象的浏览器Firefox 3.1 + ，IE 8 RC1 +
        if (typeof JSON != 'undefined' && JSON.parse) {
            result = JSON.parse(result.responseText);
        } else {
            result = eval("(" + result.responseText + ")");
        }
    }
    return result;
};

/**
 * @description 属性拷贝，不拷贝方法类名(CLASS_NAME)等。
 * @param destination - {Object} 拷贝目标。
 * @param source - {Object} 源对象。
 *
 */
_SuperMap2["default"].Util.copyAttributes = function (destination, source) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 将源对象上的属性拷贝到目标对象上。（不拷贝 CLASS_NAME 和方法）
 * @param destination - {Object} 目标对象。
 * @param source - {Object} 源对象。
 * @param clip - {Array<string>} 源对象中禁止拷贝到目标对象的属性，目的是防止目标对象上不可修改的属性被篡改。
 *
 */
_SuperMap2["default"].Util.copyAttributesWithClip = function (destination, source, clip) {
    destination = destination || {};
    if (source) {
        for (var property in source) {
            //去掉禁止拷贝的属性
            var isInClip = false;
            if (clip && clip.length) {
                for (var i = 0, len = clip.length; i < len; i++) {
                    if (property === clip[i]) {
                        isInClip = true;
                        break;
                    }
                }
            }
            if (isInClip === true) {
                continue;
            }

            var value = source[property];
            if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
                destination[property] = value;
            }
        }
    }
    return destination;
};

/**
 * @description 克隆一份Object对象
 * @param obj - {Object}  需要克隆的对象。
 * @return {Object} 返回对象的拷贝对象，注意是新的对象，不是指向。
 */
_SuperMap2["default"].Util.cloneObject = function (obj) {
    // Handle the 3 simple types, and null or undefined
    if (null === obj || "object" !== (typeof obj === 'undefined' ? 'undefined' : _typeof(obj))) return obj;

    // Handle Date
    if (obj instanceof Date) {
        var copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
    }

    // Handle Array
    if (obj instanceof Array) {
        var copy = obj.slice(0);
        return copy;
    }

    // Handle Object
    if (obj instanceof Object) {
        var copy = {};
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) {
                copy[attr] = _SuperMap2["default"].Util.cloneObject(obj[attr]);
            }
        }
        return copy;
    }

    throw new Error("Unable to copy obj! Its type isn't supported.");
};

/**
 * @description 判断两条线段是不是有交点。
 * @param a1 - {SuperMap.Geometry.Point}  第一条线段的起始节点。
 * @param a2 - {SuperMap.Geometry.Point}  第一条线段的结束节点。
 * @param b1 - {SuperMap.Geometry.Point}  第二条线段的起始节点。
 * @param b2 - {SuperMap.Geometry.Point}  第二条线段的结束节点。
 * @return {Object} 如果相交返回交点，如果不相交返回两条线段的位置关系。
 */
_SuperMap2["default"].Util.lineIntersection = function (a1, a2, b1, b2) {
    var intersectValue = null;
    var k1;
    var k2;
    var b = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
    var a = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
    var ab = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y);
    //ab==0代表两条线断的斜率一样
    if (ab != 0) {
        k1 = b / ab;
        k2 = a / ab;

        if (k1 >= 0 && k2 <= 1 && k1 <= 1 && k2 >= 0) {
            intersectValue = new _SuperMap2["default"].Geometry.Point(a1.x + k1 * (a2.x - a1.x), a1.y + k1 * (a2.y - a1.y));
        } else {
            intersectValue = "No Intersection";
        }
    } else {

        if (b == 0 && a == 0) {
            var maxy = Math.max(a1.y, a2.y);
            var miny = Math.min(a1.y, a2.y);
            var maxx = Math.max(a1.x, a2.x);
            var minx = Math.min(a1.x, a2.x);
            if ((b1.y >= miny && b1.y <= maxy || b2.y >= miny && b2.y <= maxy) && b1.x >= minx && b1.x <= maxx || b2.x >= minx && b2.x <= maxx) {
                intersectValue = "Coincident"; //重合
            } else {
                intersectValue = "Parallel"; //平行
            }
        } else {
            intersectValue = "Parallel"; //平行
        }
    }
    return intersectValue;
};

/**
 * @description 获取文本外接矩形宽度与高度。
 * @param style - {SuperMap.Style} 文本样式。
 * @param text - {string} 文本内容。
 * @param element - {Object} DOM元素。
 * @return {Object} 返回裁剪后的宽度，高度信息。
 */
_SuperMap2["default"].Util.getTextBounds = function (style, text, element) {
    document.body.appendChild(element);
    element.style.width = 'auto';
    element.style.height = 'auto';
    if (style.fontSize) element.style.fontSize = style.fontSize;
    if (style.fontFamily) element.style.fontFamily = style.fontFamily;
    if (style.fontWeight) element.style.fontWeight = style.fontWeight;
    element.style.position = 'relative';
    element.style.visibility = 'hidden';
    //fix 在某些情况下，element内的文本变成竖起排列，导致宽度计算不正确的bug
    element.style.display = 'inline-block';
    element.innerHTML = text;
    var textWidth = element.clientWidth;
    var textHeight = element.clientHeight;
    document.body.removeChild(element);
    return {
        textWidth: textWidth,
        textHeight: textHeight
    };
};

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var TWO_PI = Math.PI * 2;
// SPI is slightly greater than Math.PI, so values that exceed the -180..180
// degree range by a tiny amount don't get wrapped. This prevents points that
// have drifted from their original location along the 180th meridian (due to
// floating point error) from changing their sign.
var SPI = 3.14159265359;
var sign = __webpack_require__(46);

module.exports = function(x) {
  return (Math.abs(x) <= SPI) ? x : (x - (sign(x) * TWO_PI));
};

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ServiceBase = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

__webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.ServiceBase
 * @private
 * @description L.supermap服务基类
 * @param url - {string} 与客户端交互的服务地址。
 * @param options - {Object} 可选参数。如：<br>
 *        serverType - {{@link SuperMap.ServerType}} 服务来源 iServer|iPortal|online
 */
var ServiceBase = exports.ServiceBase = _leaflet2["default"].Evented.extend({

    options: {
        url: null,
        //服务来源 iServer|iPortal|online
        serverType: null
    },

    initialize: function initialize(url, options) {
        if (url) {
            url = url.indexOf("/") !== url.length - 1 ? url : url.substr(0, url.length - 1);
        }
        this.url = url;
        _leaflet2["default"].setOptions(this, options);
        this.fire("initialized", this);
    },

    /**
     * @function L.supermap.ServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */
    destroy: function destroy() {
        this.fire("destroy", this);
    }

});

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Bounds = __webpack_require__(57);

var _Bounds2 = _interopRequireDefault(_Bounds);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _MultiPoint = __webpack_require__(60);

var _MultiPoint2 = _interopRequireDefault(_MultiPoint);

var _LinearRing = __webpack_require__(48);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _LineString = __webpack_require__(25);

var _LineString2 = _interopRequireDefault(_LineString);

var _MultiLineString = __webpack_require__(88);

var _MultiLineString2 = _interopRequireDefault(_MultiLineString);

var _Polygon = __webpack_require__(61);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _MultiPolygon = __webpack_require__(89);

var _MultiPolygon2 = _interopRequireDefault(_MultiPolygon);

var _ServerStyle = __webpack_require__(11);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

var _Route = __webpack_require__(65);

var _Route2 = _interopRequireDefault(_Route);

var _Util = __webpack_require__(5);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class SuperMap.ServerGeometry
 * @description 服务端几何对象类。
 * 该类描述几何对象（矢量）的特征数据（坐标点对、几何对象的类型等）。
 * 基于服务端的空间分析、空间关系运算、查询等 GIS 服务功能使用服务端几何对象。
 */
var ServerGeometry = function () {

  /*
     * Constructor: SuperMap.ServerGeometry
     * 服务端几何对象类构造函数。
     *
     * Parameters:
     * options - {Object} 参数。
     *
     * Allowed options properties:
     * id - {String} 服务端几何对象唯一标识符。
     * style - {<SuperMap.ServerStyle>}  服务端几何对象的风格。
     * parts - {Array(Number)} 服务端几何对象中各个子对象所包含的节点个数。
     * points - {Array(<Point>)} 组成几何对象的节点的坐标对数组。
     * type - {<SuperMap.GeometryType>} 几何对象的类型。
     */

  /*
     * APIProperty: type
     * {<SuperMap.GeometryType>} 几何对象的类型(GeometryType)。
     */

  /*
     * APIProperty: parts
     * {Array(Number)} 服务端几何对象中各个子对象所包含的节点个数。
     * 1.几何对象从结构上可以分为简单几何对象和复杂几何对象。
     * 简单几何对象与复杂几何对象的区别：简单的几何对象一般为单一对象，
     * 而复杂的几何对象由多个简单对象组成或经过一定的空间运算之后产生，
     * 如：矩形为简单的区域对象，而中空的矩形为复杂的区域对象。
     * 2.通常情况，一个简单几何对象的子对象就是它本身，
     * 因此对于简单对象来说的该字段为长度为1的整型数组，
     * 该字段的值就是这个简单对象节点的个数。
     * 如果一个几何对象是由几个简单对象组合而成的，
     * 例如，一个岛状几何对象由3个简单的多边形组成而成，
     * 那么这个岛状的几何对象的 Parts 字段值就是一个长度为3的整型数组，
     * 数组中每个成员的值分别代表这三个多边形所包含的节点个数。
     */


  /*
     * APIProperty: id
     * {String} 服务端几何对象唯一标识符。
     */
  function ServerGeometry(options) {
    _classCallCheck(this, ServerGeometry);

    this.id = 0;
    this.style = null;
    this.parts = null;
    this.points = null;
    this.type = null;
    this.prjCoordSys = null;
    this.CLASS_NAME = "SuperMap.ServerGeometry";

    if (options) {
      _Util.Util.extend(this, options);
    }
  }

  /*
     * APIMethod: destroy
     * 释放资源，将引用资源的属性置空。
     */

  /*
     * APIProperty: prjCoordSys
     * {Object}投影坐标参数,现仅在缓冲区分析中有效。
     */

  /*
     * APIProperty: points
     * {Array(<Point>)} 组成几何对象的节点的坐标对数组。
     * 1.所有几何对象（点、线、面）都是由一些简单的点坐标组成的，
     * 该字段存放了组成几何对象的点坐标的数组。
     * 对于简单的面对象，他的起点和终点的坐标点相同。
     * 2.对于复杂的几何对象，根据 Parts 属性来确定每一个组成复杂几何对象的简单对象所对应的节点的个数，
     * 从而确定 Points 字段中坐标对的分配归属问题。
     */


  /*
     * APIProperty: style
     * {<SuperMap.ServerStyle>} 服务端几何对象的风格(ServerStyle)。
     */


  _createClass(ServerGeometry, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.id = null;
      me.style = null;
      me.parts = null;
      me.partTopo = null;
      me.points = null;
      me.type = null;
      me.prjCoordSys = null;
    }

    /*
     * APIMethod: toGeometry
     * 将服务端几何对象 ServerGeometry 转换为客户端几何对象 Geometry。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeometry',
    value: function toGeometry() {
      var me = this,
          geoType = me.type;
      switch (geoType) {
        case _REST.GeometryType.POINT:
          return me.toGeoPoint();
        case _REST.GeometryType.LINE:
          return me.toGeoLine();
        case _REST.GeometryType.LINEM:
          return me.toGeoLinem();
        case _REST.GeometryType.REGION:
          return me.toGeoRegion();
        case _REST.GeometryType.POINTEPS:
          return me.toGeoPoint();
        case _REST.GeometryType.LINEEPS:
          return me.toGeoLineEPS();
        case _REST.GeometryType.REGIONEPS:
          return me.toGeoRegionEPS();
      }
    }

    /*
     * Method: toGeoPoint
     * 将服务端的点几何对象转换为客户端几何对象。
     * 包括 Point 、MultiPoint。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoPoint',
    value: function toGeoPoint() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          return new _Point2["default"](geoPoints[0].x, geoPoints[0].y);
        } else {
          for (var i = 0, pointList = []; i < len; i++) {
            pointList.push(new _Point2["default"](geoPoints[i].x, geoPoints[i].y));
          }
          return new _MultiPoint2["default"](pointList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLine
     * 将服务端的线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLine',
    value: function toGeoLine() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          for (var i = 0, pointList = []; i < geoParts[0]; i++) {
            pointList.push(new _Point2["default"](geoPoints[i].x, geoPoints[i].y));
          }
          //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            return new _LinearRing2["default"](pointList);
          } else {
            return new _LineString2["default"](pointList);
          }
        } else {
          for (var i = 0, lineList = []; i < len; i++) {
            for (var j = 0, pointList = []; j < geoParts[i]; j++) {
              pointList.push(new _Point2["default"](geoPoints[j].x, geoPoints[j].y));
            }
            lineList.push(new _LineString2["default"](pointList));
            geoPoints.splice(0, geoParts[i]);
          }
          return new _MultiLineString2["default"](lineList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLineEPS
     * 将服务端的线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLineEPS',
    value: function toGeoLineEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          i,
          j,
          pointList,
          lineList,
          lineEPS,
          len = geoParts.length;
      if (len > 0) {
        if (len === 1) {
          for (i = 0, pointList = []; i < geoParts[0]; i++) {
            pointList.push(new _Point2["default"](geoPoints[i].x, geoPoints[i].y, geoPoints[i].type));
          }
          //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            lineEPS = _LineString2["default"].createLineEPS(pointList);
            return new _SuperMap2["default"].Geometry.LineRing(lineEPS);
          } else {
            lineEPS = _LineString2["default"].createLineEPS(pointList);
            return new _LineString2["default"](lineEPS);
          }
        } else {
          for (i = 0, lineList = []; i < len; i++) {
            for (j = 0, pointList = []; j < geoParts[i]; j++) {
              pointList.push(new _Point2["default"](geoPoints[j].x, geoPoints[j].y));
            }
            lineEPS = _LineString2["default"].createLineEPS(pointList);
            lineList.push(new _LineString2["default"](lineEPS));
            geoPoints.splice(0, geoParts[i]);
          }
          return new _MultiLineString2["default"](lineList);
        }
      } else {
        return null;
      }
    }

    /*
     * Method: toGeoLine
     * 将服务端的路由线几何对象转换为客户端几何对象。
     * 包括LinearRing、LineString、MultiLineString。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoLinem',
    value: function toGeoLinem() {
      var me = this;
      return new _Route2["default"].fromJson(me);
    }

    /*
     * Method: toGeoRegion
     * 将服务端的面几何对象转换为客户端几何对象。
     * 类型为Polygon。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoRegion',
    value: function toGeoRegion() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;
      if (len <= 0) {
        return null;
      }
      var polygonArray = [];
      var pointList = [];
      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new _Point2["default"](geoPoints[i].x, geoPoints[i].y));
        }
        polygonArray.push(new _Polygon2["default"]([new _LinearRing2["default"](pointList)]));
        pointList = [];
        return new _MultiPolygon2["default"](polygonArray);
      }
      //处理复杂面
      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      //polyon岛洞标识数组，初始都是岛。
      var CCWIdent = [];
      for (var i = 0, pointIndex = 0; i < len; i++) {
        for (var j = 0; j < geoParts[i]; j++) {
          pointList.push(new _Point2["default"](geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }
        pointIndex += geoParts[i];
        var polygon = new _Polygon2["default"]([new _LinearRing2["default"](pointList)]);
        pointList = [];
        polygonArrayTemp.push(polygon);
        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      }
      //根据面积排序
      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo);
      //iServer 9D新增字段
      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];
        for (var i = 1; i < polygonArrayTemp.length; i++) {
          for (var j = i - 1; j >= 0; j--) {
            targetArray[i] = -1;
            if (polygonArrayTemp[j].getBounds().containsBounds(polygonArrayTemp[i].getBounds())) {
              CCWIdent[i] = CCWIdent[j] * -1;
              if (CCWIdent[i] < 0) {
                targetArray[i] = j;
              }
              break;
            }
          }
        }
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (CCWIdent[i] > 0) {
            polygonArray.push(polygonArrayTemp[i]);
          } else {
            polygonArray[targetArray[i]].components = polygonArray[targetArray[i]].components.concat(polygonArrayTemp[i].components);
            //占位
            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        //ServerGeometry.bubbleSort(areaArray, polygonArrayTemp,geoTopo);
        var polygonArray = new Array();
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (geoTopo[i] && geoTopo[i] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[i].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }
            polygonArray.push(polygonArrayTemp[i]);
          }
          if (i == len - 1) {
            var polyLength = polygonArray.length;
            if (!!polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new _Polygon2["default"](CCWArray));
              }
            }
          }
        }
      }
      return new _MultiPolygon2["default"](polygonArray);
    }

    /*
     * Method: toGeoRegionEPS
     * 将服务端的面几何对象转换为客户端几何对象。
     * 类型为Polygon。
     *
     * Returns
     * {<SuperMap.Geometry>} 转换后的客户端几何对象。
     */

  }, {
    key: 'toGeoRegionEPS',
    value: function toGeoRegionEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len <= 0) {
        return null;
      }
      var polygonArray = [];
      var pointList = [];
      var lineEPS;
      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new _Point2["default"](geoPoints[i].x, geoPoints[i].y));
        }

        lineEPS = _LineString2["default"].createLineEPS(pointList);
        polygonArray.push(new _Polygon2["default"]([new _LinearRing2["default"](lineEPS)]));
        pointList = [];
        return new _MultiPolygon2["default"](polygonArray);
      }
      //处理复杂面
      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      //polyon岛洞标识数组，初始都是岛。
      var CCWIdent = [];
      for (var i = 0, pointIndex = 0; i < len; i++) {
        for (var j = 0; j < geoParts[i]; j++) {
          pointList.push(new _Point2["default"](geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }
        pointIndex += geoParts[i];

        lineEPS = _LineString2["default"].createLineEPS(pointList);
        var polygon = new _Polygon2["default"]([new _LinearRing2["default"](lineEPS)]);
        pointList = [];
        polygonArrayTemp.push(polygon);
        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      }
      //根据面积排序
      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo);
      //iServer 9D新增字段
      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];
        for (var i = 1; i < polygonArrayTemp.length; i++) {
          for (var j = i - 1; j >= 0; j--) {
            targetArray[i] = -1;
            if (polygonArrayTemp[j].getBounds().containsBounds(polygonArrayTemp[i].getBounds())) {
              CCWIdent[i] = CCWIdent[j] * -1;
              if (CCWIdent[i] < 0) {
                targetArray[i] = j;
              }
              break;
            }
          }
        }
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (CCWIdent[i] > 0) {
            polygonArray.push(polygonArrayTemp[i]);
          } else {
            polygonArray[targetArray[i]].components = polygonArray[targetArray[i]].components.concat(polygonArrayTemp[i].components);
            //占位
            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        var polygonArray = new Array();
        for (var i = 0; i < polygonArrayTemp.length; i++) {
          if (geoTopo[i] && geoTopo[i] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[i].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }
            polygonArray.push(polygonArrayTemp[i]);
          }
          if (i == len - 1) {
            var polyLength = polygonArray.length;
            if (!!polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new _Polygon2["default"](CCWArray));
              }
            }
          }
        }
      }
      return new _MultiPolygon2["default"](polygonArray);
    }

    /*
     * Function: ServerGeometry.fromJson
     * 将 JSON 对象表示服务端几何对象转换为 ServerGeometry。
     *
     * Parameters:
     * jsonObject - {Object} 要转换的 JSON 对象。
     *
     * Returns:
     * {<SuperMap.ServerGeometry>} 转化后的 ServerGeometry 对象。
     */

  }], [{
    key: 'fromJson',
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }
      return new ServerGeometry({
        id: jsonObject.id,
        style: _ServerStyle2["default"].fromJson(jsonObject.style),
        parts: jsonObject.parts,
        partTopo: jsonObject.partTopo,
        points: jsonObject.points,
        center: jsonObject.center,
        length: jsonObject.length,
        maxM: jsonObject.maxM,
        minM: jsonObject.minM,
        type: jsonObject.type
      });
    }
  }, {
    key: 'fromGeometry',


    /*
     * Function: ServerGeometry.fromGeometry
     * 将客户端Geometry转换成服务端ServerGeometry。
     *
     * Parameters:
     * geometry - {<SuperMap.Geometry>} 要转换的客户端Geometry对象。

     *
     * Returns:
     * {<SuperMap.ServerGeometry>} 转化后的 ServerGeometry 对象。
     */
    value: function fromGeometry(geometry) {
      if (!geometry) {
        return;
      }
      var id = 0,
          parts = [],
          points = [],
          type = null,
          icomponents = geometry.components,
          className = geometry.CLASS_NAME,
          prjCoordSys = { "epsgCode": geometry.SRID };

      if (!isNaN(geometry.id)) {
        id = geometry.id;
      }
      //坑爹的改法，没法，为了支持态势标绘，有时间就得全改
      if (className != "SuperMap.Geometry.LinearRing" && className != "SuperMap.Geometry.LineString" && (geometry instanceof _MultiPoint2["default"] || geometry instanceof _MultiLineString2["default"])) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var partPointsCount = icomponents[i].getVertices().length;
          parts.push(partPointsCount);
          for (var j = 0; j < partPointsCount; j++) {
            points.push(new _Point2["default"](icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
          }
        }
        //这里className不是多点就全部是算线
        type = className == "SuperMap.Geometry.MultiPoint" ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
      } else if (geometry instanceof _MultiPolygon2["default"]) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var polygon = icomponents[i],
              linearRingOfPolygon = polygon.components,
              linearRingOfPolygonLen = linearRingOfPolygon.length;
          for (var j = 0; j < linearRingOfPolygonLen; j++) {
            var partPointsCount = linearRingOfPolygon[j].getVertices().length + 1;
            parts.push(partPointsCount);
            for (var k = 0; k < partPointsCount - 1; k++) {
              points.push(new _Point2["default"](linearRingOfPolygon[j].getVertices()[k].x, linearRingOfPolygon[j].getVertices()[k].y));
            }
            points.push(new _Point2["default"](linearRingOfPolygon[j].getVertices()[0].x, linearRingOfPolygon[j].getVertices()[0].y));
          }
        }
        type = _REST.GeometryType.REGION;
      } else if (geometry instanceof _Polygon2["default"]) {
        var ilen = icomponents.length;
        for (var i = 0; i < ilen; i++) {
          var partPointsCount = icomponents[i].getVertices().length + 1;
          parts.push(partPointsCount);
          for (var j = 0; j < partPointsCount - 1; j++) {
            points.push(new _Point2["default"](icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
          }
          points.push(new _Point2["default"](icomponents[i].getVertices()[0].x, icomponents[i].getVertices()[0].y));
        }
        type = _REST.GeometryType.REGION;
      } else {
        var geometryVerticesCount = geometry.getVertices().length;
        for (var j = 0; j < geometryVerticesCount; j++) {
          points.push(new _Point2["default"](geometry.getVertices()[j].x, geometry.getVertices()[j].y));
        }
        if (geometry instanceof _LinearRing2["default"]) {
          points.push(new _Point2["default"](geometry.getVertices()[0].x, geometry.getVertices()[0].y));
          geometryVerticesCount++;
        }
        parts.push(geometryVerticesCount);
        type = geometry instanceof _Point2["default"] ? _REST.GeometryType.POINT : _REST.GeometryType.LINE;
      }

      return new ServerGeometry({
        id: id,
        style: null,
        parts: parts,
        points: points,
        type: type,
        prjCoordSys: prjCoordSys
      });
    }
  }, {
    key: 'IsClockWise',


    /*
     * Function: SuperMap.Geometry.IsClockWise
     * 判断linearRing中的点的顺序，顺时针？逆时针
     * 返回值大于0, 逆时针; 小于0, 顺时针
     *
     * Parameters:
     * geometry - {<SuperMap.Geometry>} 要转换的客户端Geometry对象。

     *
     * Returns:
     * {<Number>}。
     */
    value: function IsClockWise(points) {
      var length = points.length;
      if (length < 3) {
        return 0.0;
      }
      var s = points[0].y * (points[length - 1].x - points[1].x);
      points.push(points[0]);
      for (var i = 1; i < length; i++) {
        s += points[i].y * (points[i - 1].x - points[i + 1].x);
      }
      return s * 0.5;
    }
  }, {
    key: 'bubbleSort',
    value: function bubbleSort(areaArray, pointList, geoTopo) {
      for (var i = 0; i < areaArray.length; i++) {
        for (var j = 0; j < areaArray.length; j++) {
          if (areaArray[i] > areaArray[j]) {
            var d = areaArray[j];
            areaArray[j] = areaArray[i];
            areaArray[i] = d;
            var b = pointList[j];
            pointList[j] = pointList[i];
            pointList[i] = b;
            if (geoTopo && geoTopo.length > 0) {
              var c = geoTopo[j];
              geoTopo[j] = geoTopo[i];
              geoTopo[i] = c;
            }
          }
        }
      }
    }
  }]);

  return ServerGeometry;
}();

exports["default"] = ServerGeometry;

_SuperMap2["default"].ServerGeometry = ServerGeometry;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _JSON = __webpack_require__(176);

var _JSON2 = _interopRequireDefault(_JSON);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _MultiPoint = __webpack_require__(60);

var _MultiPoint2 = _interopRequireDefault(_MultiPoint);

var _LineString = __webpack_require__(25);

var _LineString2 = _interopRequireDefault(_LineString);

var _MultiLineString = __webpack_require__(88);

var _MultiLineString2 = _interopRequireDefault(_MultiLineString);

var _LinearRing = __webpack_require__(48);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _Polygon = __webpack_require__(61);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _MultiPolygon = __webpack_require__(89);

var _MultiPolygon2 = _interopRequireDefault(_MultiPolygon);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Format.GeoJSON
 * @classdesc  GeoJSON 的读和写。使用 <SuperMap.Format.GeoJSON> 构造器创建一个GeoJSON解析器。
 * @extends SuperMap.Format.JSON。
 */
var GeoJSON = function (_JSONFormat) {
    _inherits(GeoJSON, _JSONFormat);

    function GeoJSON() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, GeoJSON);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = GeoJSON.__proto__ || Object.getPrototypeOf(GeoJSON)).call.apply(_ref, [this].concat(args))), _this), _this.ignoreExtraDims = false, _this.parseCoords = {
            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.point
             * @description 将一组坐标成一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的一组坐标。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "point": function point(array) {
                if (this.ignoreExtraDims == false && array.length != 2) {
                    throw "Only 2D points are supported: " + array;
                }
                return new _Point2["default"](array[0], array[1]);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipoint
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multipoint": function multipoint(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _MultiPoint2["default"](points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.linestring
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "linestring": function linestring(array) {
                var points = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["point"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    points.push(p);
                }
                return new _LineString2["default"](points);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multilinestring
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multilinestring": function multilinestring(array) {
                var lines = [];
                var l = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    lines.push(l);
                }
                return new _MultiLineString2["default"](lines);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.polygon
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "polygon": function polygon(array) {
                var rings = [];
                var r, l;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        l = this.parseCoords["linestring"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    r = new _LinearRing2["default"](l.components);
                    rings.push(r);
                }
                return new _Polygon2["default"](rings);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.multipolygon
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "multipolygon": function multipolygon(array) {
                var polys = [];
                var p = null;
                for (var i = 0, len = array.length; i < len; ++i) {
                    try {
                        p = this.parseCoords["polygon"].apply(this, [array[i]]);
                    } catch (err) {
                        throw err;
                    }
                    polys.push(p);
                }
                return new _MultiPolygon2["default"](polys);
            },

            /**
             * @function SuperMap.Format.GeoJSON.parseCoords.box
             * @description 将坐标组数组转化成为一个<SuperMap.Geometry>对象。
             * @param array - {Object} GeoJSON片段中的坐标组数组。
             * @return {SuperMap.Geometry} 一个几何对象。
             */
            "box": function box(array) {
                if (array.length != 2) {
                    throw "GeoJSON box coordinates must have 2 elements";
                }
                return new _Polygon2["default"]([new _LinearRing2["default"]([new _Point2["default"](array[0][0], array[0][1]), new _Point2["default"](array[1][0], array[0][1]), new _Point2["default"](array[1][0], array[1][1]), new _Point2["default"](array[0][0], array[1][1]), new _Point2["default"](array[0][0], array[0][1])])]);
            }

        }, _this.extract = {
            /**
             * @function SuperMap.Format.GeoJSON.extract.feature
             * @description 返回一个表示单个要素对象的GeoJSON的一部分。
             * @param feature - iServer要素对象
             * @return {Object} 一个表示点的对象。
             */
            'feature': function feature(_feature) {
                var geom = this.extract.geometry.apply(this, [_feature.geometry]);
                var json = {
                    "type": "Feature",
                    "properties": this.createAttributes(_feature),
                    "geometry": geom
                };

                if (_feature.geometry && _feature.geometry.type === 'TEXT') {
                    json.properties.texts = _feature.geometry.texts;
                    json.properties.textStyle = _feature.geometry.textStyle;
                }
                if (_feature.fid !== null) {
                    json.id = _feature.fid;
                }
                if (_feature.ID !== null) {
                    json.id = _feature.ID;
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.geometry
             * @description 返回一个表示单个几何对象的GeoJSON的一部分。
             * @param geometry -iServer 几何对象
             * @return {Object} 一个表示几何体的对象。
             */
            'geometry': function geometry(_geometry) {
                if (_geometry == null) {
                    return null;
                }
                var geo = this.toGeometry(_geometry);
                var geometryType = geo.type;
                var data = this.extract[geometryType.toLowerCase()].apply(this, [geo]);
                geometryType = geometryType === 'TEXT' ? 'Point' : geometryType;
                var json;
                if (geometryType === "Collection") {
                    json = {
                        "type": "GeometryCollection",
                        "geometries": data
                    };
                } else {
                    json = {
                        "type": geometryType,
                        "coordinates": data
                    };
                }
                return json;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个点对象中返回一个坐标组。
             * @param point - {SuperMap.Geometry.Point} 一个点对象。
             * @return {Array} 一个表示一个点的坐标组。
             */
            'point': function point(_point) {
                var p = [_point.x, _point.y];
                for (var name in _point) {
                    if (name !== "x" && name !== "y" && !isNaN(_point[name])) {
                        p.push(_point[name]);
                    }
                }
                return p;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.point
             * @description 从一个文本对象中返回一个坐标组。
             * @param geo 一个文本对象。
             * @return {Array} 一个表示一个点的坐标组。
             */
            'text': function text(geo) {
                return [geo.points[0].x, geo.points[0].y];
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipoint
             * @description 从一个多点对象中返一个坐标组数组。
             * @param multipoint - {SuperMap.Geometry.MultiPoint} 多点对象。
             * @return {Array} 一个表示多点的坐标组数组。
             */
            'multipoint': function multipoint(_multipoint) {
                var array = [];
                for (var i = 0, len = _multipoint.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_multipoint.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.linestring
             * @description 从一个线对象中返回一个坐标组数组。
             * @param linestring - {SuperMap.Geometry.Linestring} 线对象。
             * @return {Array} 一个表示线对象的坐标组数组。
             */
            'linestring': function linestring(_linestring) {
                var array = [];
                for (var i = 0, len = _linestring.components.length; i < len; ++i) {
                    array.push(this.extract.point.apply(this, [_linestring.components[i]]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multilinestring
             * @description 从一个多线对象中返回一个线数组。
             * @param multilinestring - {SuperMap.Geometry.MultiLinestring} 多线对象
             *
             * @return {Array} 一个表示多线的线数组。
             */
            'multilinestring': function multilinestring(_multilinestring) {
                var array = [];
                for (var i = 0, len = _multilinestring.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [{ components: _multilinestring.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.polygon
             * @description 从一个面对象中返回一组线环。
             * @polygon - {SuperMap.Geometry.Polygon} 面对象。
             * @return {Array} 一组表示面的线环。
             */
            'polygon': function polygon(_polygon) {
                var array = [];
                for (var i = 0, len = _polygon.components.length; i < len; ++i) {
                    array.push(this.extract.linestring.apply(this, [{ components: _polygon.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.multipolygon
             * @description 从一个多面对象中返回一组面。
             * @param multipolygon - {SuperMap.Geometry.MultiPolygon} 多面对象。
             * @return {Array} 一组表示多面的面。
             */
            'multipolygon': function multipolygon(_multipolygon) {
                var array = [];
                for (var i = 0, len = _multipolygon.components.length; i < len; ++i) {
                    array.push(this.extract.polygon.apply(this, [{ components: _multipolygon.components[i] }]));
                }
                return array;
            },

            /**
             * @function SuperMap.Format.GeoJSON.extract.collection
             * @description 从一个几何要素集合中一组几何要素数组。
             * @param collection - {SuperMap.Geometry.Collection} 几何要素集合。
             * @return {Array} 一组表示几何要素集合的几何要素数组。
             */
            'collection': function collection(_collection) {
                var len = _collection.components.length;
                var array = new Array(len);
                for (var i = 0; i < len; ++i) {
                    array[i] = this.extract.geometry.apply(this, [{
                        type: "Collection",
                        components: _collection.components[i]
                    }]);
                }
                return array;
            }
        }, _this.CLASS_NAME = "SuperMap.Format.GeoJSON", _temp), _possibleConstructorReturn(_this, _ret);
    }

    /**
     * @member SuperMap.Format.GeoJSON.prototype.ignoreExtraDims - {boolean}
     * @description 忽略维度超过2的几何要素。
     */


    _createClass(GeoJSON, [{
        key: 'read',


        /**
         * @function SuperMap.Format.GeoJSON.prototype.read
         * @description 反序列化一个 GeoJSON 字符串。
         * @param json - {string}  GeoJSON 字符串
         * @param type - {string} 可选的字符串，它决定了输出的格式。
         *     支持的值有："Geometry","Feature",和"FeatureCollection",
         *     如果此值为null，则会使用默认值"FeaureCollection"。
         * @param filter - {function} 对象中每个层次每个键值对都会调用此函数得出一个结果。
         *     每个值都会被filter函数的结果所替换掉。这个函数可被用来将某些对象转化成
         *     某个类相应的对象，或者将日期字符串转化成Date对象。
         *
         * @return {Object}
         *    返回值依赖于type参数的值。如果type等于"FeatureCollection"（默认值），
         *     返回值将会是 <SuperMap.Feature.Vector> 数组。如果type为"Geometry",
         *     输入的json对象必须表示一个唯一的几何体，然后返回值就会是 <SuperMap.Feature.Geometry>
         *     如果type为"Feature"，输入的json对象也必须表示的一个要素，这样返回值才会是<SuperMap.Feature.Vector> 。
         */
        value: function read(json, type, filter) {
            type = type ? type : "FeatureCollection";
            var results = null;
            var obj = null;
            if (typeof json == "string") {
                obj = _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'read', this).call(this, json, filter);
            } else {
                obj = json;
            }
            if (!obj) {
                //SuperMap.Console.error("Bad JSON: " + json);
            } else if (typeof obj.type != "string") {
                //SuperMap.Console.error("Bad GeoJSON - no type: " + json);
            } else if (this.isValidType(obj, type)) {
                switch (type) {
                    case "Geometry":
                        try {
                            results = this.parseGeometry(obj);
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "Feature":
                        try {
                            results = this.parseFeature(obj);
                            results.type = "Feature";
                        } catch (err) {
                            //SuperMap.Console.error(err);
                        }
                        break;
                    case "FeatureCollection":
                        // for type FeatureCollection, we allow input to be any type
                        results = [];
                        switch (obj.type) {
                            case "Feature":
                                try {
                                    results.push(this.parseFeature(obj));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                                break;
                            case "FeatureCollection":
                                for (var i = 0, len = obj.features.length; i < len; ++i) {
                                    try {
                                        results.push(this.parseFeature(obj.features[i]));
                                    } catch (err) {
                                        results = null;
                                        // SuperMap.Console.error(err);
                                    }
                                }
                                break;
                            default:
                                try {
                                    var geom = this.parseGeometry(obj);
                                    results.push(new _SuperMap2["default"].Feature.Vector(geom));
                                } catch (err) {
                                    results = null;
                                    //SuperMap.Console.error(err);
                                }
                        }
                        break;
                    default:
                        break;
                }
            }
            return results;
        }

        /**
         *  @function SuperMap.Format.GeoJSON.prototype.isValidType
         *  @description 检查一个GeoJSON对象是否和给定的类型相符的合法的对象。
         *  @return {boolean} GeoJSON是否是给定类型的合法对象。
         */

    }, {
        key: 'isValidType',
        value: function isValidType(obj, type) {
            var valid = false;
            switch (type) {
                case "Geometry":
                    if (_SuperMap2["default"].Util.indexOf(["Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon", "Box", "GeometryCollection"], obj.type) == -1) {
                        // unsupported geometry type
                        //SuperMap.Console.error("Unsupported geometry type: " +
                        // obj.type);
                    } else {
                        valid = true;
                    }
                    break;
                case "FeatureCollection":
                    // allow for any type to be converted to a feature collection
                    valid = true;
                    break;
                default:
                    // for Feature types must match
                    if (obj.type == type) {
                        valid = true;
                    } else {
                        //SuperMap.Console.error("Cannot convert types from " +
                        //obj.type + " to " + type);
                    }
            }
            return valid;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseFeature
         * @description 将一个GeoJSON中的feature转化成<SuperMap.Feature.Vector>对象。
         * @param obj - {Object} 从GeoJSON对象中创建一个对象。
         * @return {SuperMap.Feature.Vector} 一个要素。
         */

    }, {
        key: 'parseFeature',
        value: function parseFeature(obj) {
            var feature, geometry, attributes, bbox;
            attributes = obj.properties ? obj.properties : {};
            bbox = obj.geometry && obj.geometry.bbox || obj.bbox;
            try {
                geometry = this.parseGeometry(obj.geometry);
            } catch (err) {
                // deal with bad geometries
                throw err;
            }
            feature = new _SuperMap2["default"].Feature.Vector(geometry, attributes);
            if (bbox) {
                feature.bounds = _SuperMap2["default"].Bounds.fromArray(bbox);
            }
            if (obj.id) {
                feature.fid = obj.id;
            }
            return feature;
        }

        /**
         * @function SuperMap.Format.GeoJSON.prototype.parseGeometry
         * @description 将一个GeoJSON中的几何要素转化成<SuperMap.Geometry>对象。
         * @param obj - {Object} 从GeoJSON对象中创建一个对象。
         * @return {SuperMap.Geometry} 一个几何要素。
         */

    }, {
        key: 'parseGeometry',
        value: function parseGeometry(obj) {
            if (obj == null) {
                return null;
            }
            var geometry,
                collection = false;
            if (obj.type == "GeometryCollection") {
                if (!_SuperMap2["default"].Util.isArray(obj.geometries)) {
                    throw "GeometryCollection must have geometries array: " + obj;
                }
                var numGeom = obj.geometries.length;
                var components = new Array(numGeom);
                for (var i = 0; i < numGeom; ++i) {
                    components[i] = this.parseGeometry.apply(this, [obj.geometries[i]]);
                }
                geometry = new _SuperMap2["default"].Geometry.Collection(components);
                collection = true;
            } else {
                if (!_SuperMap2["default"].Util.isArray(obj.coordinates)) {
                    throw "Geometry must have coordinates array: " + obj;
                }
                if (!this.parseCoords[obj.type.toLowerCase()]) {
                    throw "Unsupported geometry type: " + obj.type;
                }
                try {
                    geometry = this.parseCoords[obj.type.toLowerCase()].apply(this, [obj.coordinates]);
                } catch (err) {
                    // deal with bad coordinates
                    throw err;
                }
            }
            return geometry;
        }

        /**
         * @member SuperMap.Format.GeoJSON.prototype.parseCoords - {Object}
         * @description 一个属性名对应着GeoJSON对象的几何类型的对象。每个属性其实都是一个实际上做解析用的方法。
         */

    }, {
        key: 'write',


        /**
         * @function SuperMap.Format.GeoJSON.write
         * @description 序列化一个要素对象，几何对象，要素对象数组为一个GeoJSON字符串。
         * @param obj - {Object} 一个 <SuperMap.Feature.Vector> 对象，一个 <SuperMap.Geometry> 对象或者一个要素对象数组。
         * @param pretty - {boolean} 是否使用换行和缩进来控制输出。默认值为false。
         * @return {string} 一个GeoJSON字符串，它表示了输入的几何对象，要素对象，或者要素对象数组。
         */
        value: function write(obj, pretty) {
            var geojson = {
                "type": null
            };
            if (_SuperMap2["default"].Util.isArray(obj)) {
                geojson.type = "FeatureCollection";
                var numFeatures = obj.length;
                geojson.features = new Array(numFeatures);
                for (var i = 0; i < numFeatures; ++i) {
                    var element = obj[i];
                    if (isGeometry(element)) {
                        var feature = {};
                        feature.geometry = element;
                        geojson.features[i] = this.extract.feature.apply(this, [feature]);
                    } else {
                        geojson.features[i] = this.extract.feature.apply(this, [element]);
                    }
                }
            } else if (isGeometry(obj)) {
                var feature = {};
                feature.geometry = obj;
                geojson = this.extract.feature.apply(this, [feature]);
            }

            function isGeometry(input) {
                return input.hasOwnProperty("parts") && input.hasOwnProperty("points");
            }

            return _get(GeoJSON.prototype.__proto__ || Object.getPrototypeOf(GeoJSON.prototype), 'write', this).call(this, geojson, pretty);
        }

        /**
         * @function SuperMap.Format.GeoJSON.createCRSObject
         * @description 从一个要素对象中创建一个坐标参考系对象。
         * @param object - {SuperMap.Feature.Vector} 要素对象
         * @return {Object} 一个可作为GeoJSON对象的crs属性使用的对象。
         */

    }, {
        key: 'createCRSObject',
        value: function createCRSObject(object) {
            var proj = object.layer.projection.toString();
            var crs = {};
            if (proj.match(/epsg:/i)) {
                var code = parseInt(proj.substring(proj.indexOf(":") + 1));
                if (code == 4326) {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
                        }
                    };
                } else {
                    crs = {
                        "type": "name",
                        "properties": {
                            "name": "EPSG:" + code
                        }
                    };
                }
            }
            return crs;
        }

        /**
         * Property: extract
         * 一个属性名对应着GeoJSON类型的对象。其值为相应的实际的解析方法。
         */

    }, {
        key: 'createAttributes',
        value: function createAttributes(feature) {
            if (!feature) {
                return null;
            }
            var attr = {};
            processFieldsAttributes(feature, attr);
            var exceptKeys = ["fieldNames", "fieldValues", "geometry"];
            for (var key in feature) {
                if (exceptKeys.indexOf(key) > -1) {
                    continue;
                }
                attr[key] = feature[key];
            }

            function processFieldsAttributes(feature, attributes) {
                if (!(feature.hasOwnProperty("fieldNames") && feature.hasOwnProperty("fieldValues"))) {
                    return;
                }
                var names = feature.fieldNames,
                    values = feature.fieldValues;
                for (var i in names) {
                    attributes[names[i]] = values[i];
                }
            }

            return attr;
        }
    }, {
        key: 'toGeometry',
        value: function toGeometry(geometry) {
            var me = this,
                geoType = geometry.type;
            if (geoType === 'polygon') {
                geoType = _REST.GeometryType.REGION;
            }
            switch (geoType.toUpperCase()) {
                case _REST.GeometryType.POINT:
                    return me.toGeoPoint(geometry);
                case _REST.GeometryType.LINE:
                    return me.toGeoLine(geometry);
                case _REST.GeometryType.LINEM:
                    return me.toGeoLinem(geometry);
                case _REST.GeometryType.REGION:
                    return me.toGeoRegion(geometry);
                case _REST.GeometryType.POINTEPS:
                    return me.toGeoPoint(geometry);
                // case GeometryType.LINEEPS:
                //     return me.toGeoLineEPS();
                // case GeometryType.REGIONEPS:
                //     return me.toGeoRegionEPS();
                default:
                    return geometry;
            }
        }

        /**
         * @function SuperMap.Format.GeoJSON.toGeoPoint
         * @description 将服务端的点几何对象转换为几何对象
         */

    }, {
        key: 'toGeoPoint',
        value: function toGeoPoint(geometry) {
            var geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            if (len === 1) {
                return { type: "Point", x: parseFloat(geoPoints[0].x), y: parseFloat(geoPoints[0].y) };
            } else {
                for (var i = 0, pointList = []; i < len; i++) {
                    pointList.push({ x: parseFloat(geoPoints[i].x), y: parseFloat(geoPoints[i].y) });
                }
                return { type: "MultiPoint", components: pointList };
            }
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoPoint
         * @description 将服务端的线几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoLine',
        value: function toGeoLine(geometry) {
            var me = this,
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            if (len === 1) {
                for (var i = 0, pointList = []; i < geoParts[0]; i++) {
                    pointList.push({ x: parseFloat(geoPoints[i].x), y: parseFloat(geoPoints[i].y) });
                }
                //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                if (me.isPointsEquals(pointList[0], pointList[geoParts[0] - 1])) {
                    pointList.pop();
                    pointList.push(pointList[0]);
                }
                return { type: "LineString", components: pointList };
            } else {
                for (var k = 0, lineList = []; k < len; k++) {
                    for (var j = 0, pointArr = []; j < geoParts[k]; j++) {
                        pointArr.push({ x: parseFloat(geoPoints[j].x), y: parseFloat(geoPoints[j].y) });
                    }
                    lineList.push(pointArr);
                    geoPoints.splice(0, geoParts[k]);
                }
                return { type: "MultiLineString", components: lineList };
            }
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoLinem
         * @description 将服务端的路由线几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoLinem',
        value: function toGeoLinem(geometry) {
            var me = this,
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length,
                lineList = [],
                type;
            if (len < 1) {
                return null;
            }
            for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                for (var j = 0; j < geoParts[i]; j++) {
                    pointList.push({
                        x: parseFloat(geoPoints[pointIndex + j].x),
                        y: parseFloat(geoPoints[pointIndex + j].y),
                        measure: parseFloat(geoPoints[pointIndex + j].measure)
                    });
                }
                pointIndex += geoParts[i];
                //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                if (me.isPointsEquals(pointList[0], pointList[geoParts[0] - 1])) {
                    pointList.pop();
                    pointList.push(pointList[0]);
                }
                lineList.push(pointList);
                pointList = [];
            }
            return { type: "MultiLineString", components: lineList };
        }

        /**
         *
         * @function SuperMap.Format.GeoJSON.toGeoRegion
         * @description 将服务端的面几何对象转换为几何对象。
         */

    }, {
        key: 'toGeoRegion',
        value: function toGeoRegion(geometry) {
            var CCWArray = [],
                geoPoints = geometry.points || [],
                geoParts = geometry.parts || [geoPoints.length],
                len = geoParts.length;
            if (len < 1) {
                return null;
            }
            var polygonArray = new Array();
            for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                for (var j = 0; j < geoParts[i]; j++) {
                    pointList.push({
                        x: parseFloat(geoPoints[pointIndex + j].x),
                        y: parseFloat(geoPoints[pointIndex + j].y)
                    });
                }

                pointIndex += geoParts[i];
                var linearRing = pointList.concat();
                linearRing.pop();
                linearRing.push(linearRing[0]);

                if (this.isClockWise(linearRing) > 0) {
                    CCWArray.push(linearRing);
                } else {
                    polygonArray.push([linearRing]);
                }

                if (i === len - 1) {
                    var polyLength = polygonArray.length;
                    if (!!polyLength) {
                        polygonArray[polyLength - 1] = polygonArray[polyLength - 1].concat(CCWArray);
                    } else {
                        for (var k = 0, length = CCWArray.length; k < length; k++) {
                            polygonArray.push([CCWArray[k]].concat());
                        }
                    }
                }
                pointList = [];
            }
            return { type: "MultiPolygon", components: polygonArray };
        }
    }, {
        key: 'isClockWise',
        value: function isClockWise(points) {
            var length = points.length;
            if (length < 3) {
                return 0.0;
            }
            var s = points[0].y * (points[length - 1].x - points[1].x);
            points.push(points[0]);
            for (var i = 1; i < length; i++) {
                s += points[i].y * (points[i - 1].x - points[i + 1].x);
            }
            return s * 0.5;
        }
    }, {
        key: 'isPointsEquals',
        value: function isPointsEquals(point1, point2) {
            return point1.x === point2.x && point1.y === point2.y;
        }
    }]);

    return GeoJSON;
}(_JSON2["default"]);

exports["default"] = GeoJSON;

_SuperMap2["default"].Format.GeoJSON = GeoJSON;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(3);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _GeoJSON = __webpack_require__(9);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.SpatialAnalystBase
 * @classdesc 空间分析服务基类。
 * @param url -{string} 地址d。
 * @param options -{Object} 参数。
 * @extends SuperMap.CommonServiceBase
 */
var SpatialAnalystBase = function (_CommonServiceBase) {
    _inherits(SpatialAnalystBase, _CommonServiceBase);

    function SpatialAnalystBase(url, options) {
        _classCallCheck(this, SpatialAnalystBase);

        var _this = _possibleConstructorReturn(this, (SpatialAnalystBase.__proto__ || Object.getPrototypeOf(SpatialAnalystBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.SpatialAnalystBase";

        if (options && options.format) {
            _this.format = options.format.toUpperCase();
        }
        return _this;
    }

    /**
     * @function SuperMap.SpatialAnalystBase.prototype.destroy
     * @override
     */

    /**
     * @member SuperMap.SpatialAnalystBase.prototype.format -{string}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式，参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    _createClass(SpatialAnalystBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(SpatialAnalystBase.prototype.__proto__ || Object.getPrototypeOf(SpatialAnalystBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _SuperMap2["default"].Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                analystResult = me.toGeoJSONResult(result);
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.SpatialAnalystBase.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。
         * @param result - {Object} 服务器返回的结果对象。
         *
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            if (!result) {
                return null;
            }
            var geoJSONFormat = new _GeoJSON2["default"]();
            if (result.recordsets) {
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        recordsets[i].features = JSON.parse(geoJSONFormat.write(recordsets[i].features));
                    }
                }
            } else if (result.recordset && result.recordset.features) {
                result.recordset.features = JSON.parse(geoJSONFormat.write(result.recordset.features));
            }
            if (result.resultGeometry) {
                result.resultGeometry = JSON.parse(geoJSONFormat.write(result.resultGeometry));
            }

            return result;
        }
    }]);

    return SpatialAnalystBase;
}(_CommonServiceBase3["default"]);

exports["default"] = SpatialAnalystBase;

_SuperMap2["default"].SpatialAnalystBase = SpatialAnalystBase;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServerColor = __webpack_require__(17);

var _ServerColor2 = _interopRequireDefault(_ServerColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerStyle
 * @classdesc 服务端矢量要素风格类。
 * @description 该类用于定义点状符号、线状符号、填充符号风格及其相关属性。
 * @param options - {Object} 可选参数。如：<br>
 *        fillBackColor - {{@link SuperMap.ServerColor}} 填充背景颜色。<br>
 *        fillBackOpaque - {boolean} 背景是否不透明。<br>
 *        fillForeColor - {{@link SuperMap.ServerColor}} 填充颜色。<br>
 *        fillGradientMode - {{@link SuperMap.FillGradientMode}} 渐变填充风格的渐变类型。<br>
 *        fillGradientAngle - {number}渐变填充的旋转角度。<br>
 *        fillGradientOffsetRatioX - {number}渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。<br>
 *        fillGradientOffsetRatioY - {number}填充中心点相对于填充区域范围中心点的垂直偏移百分比。<br>
 *        fillOpaqueRate - {number}填充不透明度。<br>
 *        fillSymbolID - {integer} 填充符号的编码。<br>
 *        lineColor - {{@link SuperMap.ServerColor}} 矢量要素的边线颜色。<br>
 *        lineSymbolID - {integer} 线状符号的编码。<br>
 *        lineWidth - {number}边线的宽度。<br>
 *        markerAngle - {number}点状符号的旋转角度。<br>
 *        markerSize - {number}点状符号的大小。<br>
 *        markerSymbolID - {integer} 点状符号的编码。
 */
var ServerStyle = function () {

    /**
     * @member SuperMap.ServerStyle.prototype.markerSize -{number}
     * @description 点状符号的大小。单位为毫米，精度为0.1，默认值为1.0。当该属性设置为0时，采用符号默认大小1.0显示。
     *              当该属性设置为非法值时，交由服务器默认处理。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineWidth -{number}
     * @description 边线的宽度。单位为毫米，精度到0.1，默认值为1.0。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineColor -{SuperMap.ServerColor}
     * @description 矢量要素的边线颜色。默认为黑色。如果等级符号是点符号，点符号的颜色由lineColor控制
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillOpaqueRate -{number}
     * @description 填充不透明度。合法值为0--100的数值。其中为0表示完全透明；
     *              100表示完全不透明。赋值小于0时按照0处理，大于100时按照100处理。默认值为 100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientOffsetRatioX -{number}
     * @description 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。它们的关系如下：设填充区域范围中心点的坐标为（x0, y0），
     *              填充中心点的坐标为（x, y），填充区域范围的宽度为 a，水平偏移百分比为 dx，则 x=x0 + a*dx/100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientMode -{SuperMap.FillGradientMode}
     * @description 渐变填充风格的渐变类型。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillBackOpaque -{boolean}
     * @description 背景是否不透明。false 表示透明。默认值为 false。
     */
    function ServerStyle(options) {
        _classCallCheck(this, ServerStyle);

        this.fillBackColor = null;
        this.fillBackOpaque = false;
        this.fillForeColor = null;
        this.fillGradientMode = null;
        this.fillGradientAngle = 0;
        this.fillGradientOffsetRatioX = 0;
        this.fillGradientOffsetRatioY = 0;
        this.fillOpaqueRate = 100;
        this.fillSymbolID = 0;
        this.lineColor = null;
        this.lineSymbolID = 0;
        this.lineWidth = 1;
        this.markerAngle = 0;
        this.markerSize = 1;
        this.markerSymbolID = -1;
        this.CLASS_NAME = "SuperMap.ServerStyle";

        var me = this;
        me.fillBackColor = new _ServerColor2["default"](255, 255, 255);
        me.fillForeColor = new _ServerColor2["default"](255, 0, 0);
        me.lineColor = new _ServerColor2["default"](0, 0, 0);
        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ServerStyle.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.markerSymbolID -{integer}
     * @description 点状符号的编码。此编码用于唯一标识各点状符号。默认为 -1。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.markerAngle -{number}
     * @description 点状符号的旋转角度。以度为单位，精确到0.1度，逆时针方向为正方向，默认值为0。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.lineSymbolID -{integer}
     * @description 线状符号的编码。此编码用于唯一标识各普通填充风格的填充符号，默认值为0。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillSymbolID -{integer}
     * @description 填充符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于填充符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientOffsetRatioY -{number}
     * @description 填充中心点相对于填充区域范围中心点的垂直偏移百分比。它们的关系如下：<br>
     *           设填充区域范围中心点的坐标为（x0, y0），填充中心点的坐标为（x, y），填充区域范围的高度为 b，垂直偏移百分比为 dy，则 y=y0 + b*dx/100。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillGradientAngle -{number}
     * @description 渐变填充的旋转角度。单位为度，精确到0.1度，逆时针方向为正方向。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillForeColor -{SuperMap.ServerColor}
     * @description 填充颜色。当填充模式为渐变填充时，该颜色为填充起始颜色。默认为红色。
     */


    /**
     * @member SuperMap.ServerStyle.prototype.fillBackColor -{SuperMap.ServerColor}
     * @description 填充背景颜色。当填充模式为渐变填充时，该颜色为填充终止色。默认为白色。
     */


    _createClass(ServerStyle, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.fillBackColor) {
                me.fillBackColor.destroy();
                me.fillBackColor = null;
            }
            me.fillBackOpaque = null;

            if (me.fillForeColor) {
                me.fillForeColor.destroy();
                me.fillForeColor = null;
            }
            me.fillGradientMode = null;
            me.fillGradientAngle = null;
            me.fillGradientOffsetRatioX = null;
            me.fillGradientOffsetRatioY = null;
            me.fillOpaqueRate = null;
            me.fillSymbolID = null;
            if (me.lineColor) {
                me.lineColor.destroy();
                me.lineColor = null;
            }
            me.lineSymbolID = null;
            me.lineWidth = null;
            me.markerAngle = null;
            me.markerSize = null;
            me.markerSymbolID = null;
        }

        /**
         * @function SuperMap.ServerStyle.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object } 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var styleObj = {};
            styleObj = _SuperMap2["default"].Util.copyAttributes(styleObj, this);
            //暂时先忽略serverColor往Json的转换
            return styleObj;
        }

        /**
         * @function SuperMap.ServerStyle.fromJson
         * @description 将JSON对象转换为 SuperMap.ServerStyle 对象。
         * @param jsonObject - {Object} 要转换的 JSON 对象。
         * @return{SuperMap.ServerStyle} 转化后的 SuperMap.ServerStyle 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            return new _SuperMap2["default"].ServerStyle({
                fillBackColor: _ServerColor2["default"].fromJson(jsonObject.fillBackColor),
                fillBackOpaque: jsonObject.fillBackOpaque,
                fillForeColor: _ServerColor2["default"].fromJson(jsonObject.fillForeColor),
                fillGradientMode: jsonObject.fillGradientMode,
                fillGradientAngle: jsonObject.fillGradientAngle,
                fillGradientOffsetRatioX: jsonObject.fillGradientOffsetRatioX,
                fillGradientOffsetRatioY: jsonObject.fillGradientOffsetRatioY,
                fillOpaqueRate: jsonObject.fillOpaqueRate,
                fillSymbolID: jsonObject.fillSymbolID,
                lineColor: _ServerColor2["default"].fromJson(jsonObject.lineColor),
                lineSymbolID: jsonObject.lineSymbolID,
                lineWidth: jsonObject.lineWidth,
                markerAngle: jsonObject.markerAngle,
                markerSize: jsonObject.markerSize,
                markerSymbolID: jsonObject.markerSymbolID
            });
        }
    }]);

    return ServerStyle;
}();

exports["default"] = ServerStyle;


_SuperMap2["default"].ServerStyle = ServerStyle;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Eventful = __webpack_require__(51);

var _Eventful2 = _interopRequireDefault(_Eventful);

var _Transformable = __webpack_require__(72);

var _Transformable2 = _interopRequireDefault(_Transformable);

__webpack_require__(5);

__webpack_require__(30);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape
 * 图形（shape）基类。
 *
 * Inherits from:
 *  - <SuperMap.LevelRenderer.Eventful>
 *  - <SuperMap.LevelRenderer.Transformable>
 */
var Shape = function (_SuperMap$mixin) {
    _inherits(Shape, _SuperMap$mixin);

    /**
     * Constructor: SuperMap.LevelRenderer.Shape
     * 构造函数。
     *
     * Parameters:
     * options - {Array} shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */


    /**
     * APIProperty: refDataHoverGroup
     * {String} 高亮图形组的组名。此属性在 refDataID 有效且 isHoverByRefDataID 为 true 时生效。
     * 一旦设置此属性，且属性值有效，只有关联同一个数据的图形且此属性相同的图形才会高亮。
     *
     */


    /**
     * APIProperty: refDataID
     * {String} 图形所关联数据的 ID。
     *
     */


    /**
     * APIProperty: z
     * {Number} z值，跟zlevel一样影响shape绘制的前后顺序，z值大的shape会覆盖在z值小的上面，
     * 但是并不会创建新的canvas，所以优先级低于zlevel，而且频繁改动的开销比zlevel小很多。
     * 默认值：0。
     */


    /**
     * APIProperty: clickable
     * {Boolean} 是否可点击。默认值：false。
     */


    /**
     * APIProperty: zlevel
     * {Number} z 层 level，决定绘画在哪层 canvas 中。默认值：0。
     */


    /**
     * APIProperty: invisible
     * {Boolean} 图形是否可见，为 true 时不绘制图形，但是仍能触发鼠标事件。默认值：false。
     */


    /**
     * Property: __dirty
     * {Boolean}
     */


    /**
     * APIProperty: style.__rect
     * {Object} 包围图形的最小矩形盒子。该对象包含以下属性：
     *
     * Symbolizer properties:
     * x - {Number} 左上角顶点x轴坐标。
     * y - {Number} 左上角顶点y轴坐标。
     * width - {Number} 包围盒矩形宽度。
     * height - {Number} 包围盒矩形高度。
     */

    /**
     * Property: highlightStyle
     * {Object} 高亮样式。
     *
     * Symbolizer properties:
     * brushType - {String} 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * color - {String} 填充颜色。默认值："#000000'"。
     * strokeColor - {String} 描边颜色。默认值："#000000'"。
     * lineCape - {String} 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * lineWidth - {Number} 描边宽度。默认值：1。
     * opacity - {Number} 绘制透明度。默认值：1。
     * shadowBlur - {Number} 阴影模糊度，大于0有效。默认值：0。
     * shadowColor - {Number} 阴影颜色。默认值："#000000'"。
     * shadowOffsetX - {Number} 阴影横向偏移。默认值：0。
     * shadowOffsetY - {Number} 阴影纵向偏移。默认值：0。
     * text - {String} 图形中的附加文本。默认值：""。
     * textColor - {String} 文本颜色。默认值："#000000'"。
     * textFont - {String} 附加文本样式。示例:'bold 18px verdana'。
     * textPosition - {String} 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * textAlign - {String} 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * textBaseline - {String} 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */


    /**
     * APIProperty: id
     * {String} 唯一标识。
     */
    function Shape(options) {
        _classCallCheck(this, Shape);

        var _this = _possibleConstructorReturn(this, (Shape.__proto__ || Object.getPrototypeOf(Shape)).call(this, options));

        _this.id = null;
        _this.style = null;
        _this.highlightStyle = null;
        _this.parent = null;
        _this.__dirty = null;
        _this.__clipShapes = null;
        _this.invisible = false;
        _this.ignore = false;
        _this.zlevel = 0;
        _this.draggable = false;
        _this.clickable = false;
        _this.hoverable = true;
        _this.z = 0;
        _this.refOriginalPosition = null;
        _this.refDataID = null;
        _this.isHoverByRefDataID = false;
        _this.refDataHoverGroup = null;
        _this.dataInfo = null;

        _this.getTansform = function () {
            var invTransform = [];

            return function (x, y) {
                var originPos = [x, y];
                // 对鼠标的坐标也做相同的变换
                if (this.needTransform && this.transform) {
                    _SuperMap2["default"].LevelRenderer.Util_matrix.invert(invTransform, this.transform);

                    _SuperMap2["default"].LevelRenderer.Util_matrix.mulVector(originPos, invTransform, [x, y, 1]);

                    if (x == originPos[0] && y == originPos[1]) {
                        // 避免外部修改导致的 needTransform 不准确
                        this.updateNeedTransform();
                    }
                }
                return originPos;
            };
        }();

        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape";


        options = options || {};

        _this.id = options.id || _SuperMap2["default"].Util.createUniqueID("smShape_");

        for (var key in options) {
            _this[key] = options[key];
        }

        _this.style = _this.style || {};

        _this.highlightStyle = _this.highlightStyle || null;

        _this.parent = null;

        _this.__dirty = true;

        _this.__clipShapes = [];

        _this.refOriginalPosition = [0, 0];
        return _this;
    }

    /**
     * APIMethod: destroy
     * 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    /**
     * APIProperty: dataInfo
     * {Object} 图形的数据信息。
     *
     */


    /**
     * APIProperty: isHoverByRefDataID
     * {Boolean} 是否根据 refDataID 进行高亮。用于同时高亮所有 refDataID 相同的图形。
     *
     */


    //地理扩展
    /**
     * APIProperty: refOriginalPosition
     * {Array} 图形参考原点位置，图形的参考中心位置。
     * refOriginalPosition 是长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     *
     * refOriginalPosition 表示图形的参考中心，通常情况下，图形是使用 canvas 的原点位置作为位置参考，
     * 但 refOriginalPosition 可以改变图形的参考位置，例如： refOriginalPosition = [80, 80],
     * 图形圆的 style.x = 20, style.y = 20，那么圆在 canvas 中的实际位置是 [100, 100]。
     *
     * 图形（Shape） 的所有位置相关属性都是以 refOriginalPosition 为参考中心，
     * 也就是说图形的所有位置信息在 canvas 中都是以 refOriginalPosition 为参考的相对位置，只有
     * refOriginalPosition 的值为 [0, 0] 时，形的位置信息才是 canvas 绝对位置。
     *
     * 图形的位置信息通常有：style.pointList，style.x，style.y。
     *
     * refOriginalPosition。默认值是： [0, 0]。
     */


    /**
     * APIProperty: hoverable
     * {Boolean} 是否可以 hover。默认值：true。
     */


    /**
     * APIProperty: draggable
     * {Boolean} 是否可拖拽。默认值：false。
     */


    /**
     * APIProperty: ignore
     * {Boolean} 图形是否忽略，为 true 时忽略图形的绘制以及事件触发。默认值：false。
     */


    /**
     * Property: __clipShapes
     * {Array}
     */


    /**
     * APIProperty: parent
     * {Object} 父节点，只读属性。<SuperMap.LevelRenderer.Group>
     */


    /**
     * APIProperty: style
     * {Object} 基础绘制样式。
     *
     * Symbolizer properties:
     * brushType - {String} 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * color - {String} 填充颜色。默认值："#000000'"。
     * strokeColor - {String} 描边颜色。默认值："#000000'"。
     * lineCape - {String} 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * lineWidth - {Number} 描边宽度。默认值：1。
     * opacity - {Number} 绘制透明度。默认值：1。
     * shadowBlur - {Number} 阴影模糊度，大于0有效。默认值：0。
     * shadowColor - {Number} 阴影颜色。默认值："#000000'"。
     * shadowOffsetX - {Number} 阴影横向偏移。默认值：0。
     * shadowOffsetY - {Number} 阴影纵向偏移。默认值：0。
     * text - {String} 图形中的附加文本。默认值：""。
     * textColor - {String} 文本颜色。默认值："#000000'"。
     * textFont - {String} 附加文本样式。示例:'bold 18px verdana'。
     * textPosition - {String} 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * textAlign - {String} 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * textBaseline - {String} 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     *
     */


    _createClass(Shape, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.style = null;
            this.highlightStyle = null;
            this.parent = null;
            this.__dirty = null;
            this.__clipShapes = null;
            this.invisible = null;
            this.ignore = null;
            this.zlevel = null;
            this.draggable = null;
            this.clickable = null;
            this.hoverable = null;
            this.z = null;

            this.refOriginalPosition = null;
            this.refDataID = null;
            this.refDataHoverGroup = null;
            this.isHoverByRefDataID = null;
            this.dataInfo = null;
            _get(Shape.prototype.__proto__ || Object.getPrototypeOf(Shape.prototype), 'destroy', this).call(this);
        }

        /**
         * APIMethod: brush
         * 绘制图形。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * isHighlight - {Boolean} 是否使用高亮属性。
         * updateCallback - {Function} 需要异步加载资源的 shape 可以通过这个 callback(e)
         * 让painter更新视图，base.brush 没用，需要的话重载 brush。
         *
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight) {

            var style = this.beforeBrush(ctx, isHighlight);

            ctx.beginPath();
            this.buildPath(ctx, style);

            switch (style.brushType) {
                /* jshint ignore:start */
                case 'both':
                    this.setCtxGlobalAlpha(ctx, "fill", style);
                    ctx.fill();
                    if (style.lineWidth > 0) {
                        this.setCtxGlobalAlpha(ctx, "stroke", style);
                        ctx.stroke();
                    }
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
                case 'stroke':
                    this.setCtxGlobalAlpha(ctx, "stroke", style);
                    style.lineWidth > 0 && ctx.stroke();
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
                /* jshint ignore:end */
                default:
                    this.setCtxGlobalAlpha(ctx, "fill", style);
                    ctx.fill();
                    this.setCtxGlobalAlpha(ctx, "reset", style);
                    break;
            }

            this.drawText(ctx, style, this.style);

            this.afterBrush(ctx);
        }

        /**
         * APIMethod: beforeBrush
         * 具体绘制操作前的一些公共操作。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * isHighlight - {Boolean} 是否使用高亮属性。
         *
         * Returns:
         * {Object} 处理后的样式。
         */

    }, {
        key: 'beforeBrush',
        value: function beforeBrush(ctx, isHighlight) {
            var style = this.style;

            if (this.brushTypeOnly) {
                style.brushType = this.brushTypeOnly;
            }

            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {}, this.brushTypeOnly);
            }

            if (this.brushTypeOnly == 'stroke') {
                style.strokeColor = style.strokeColor || style.color;
            }

            ctx.save();

            this.doClip(ctx);

            this.setContext(ctx, style);

            // 设置transform
            this.setTransform(ctx);

            return style;
        }

        /**
         * APIMethod: afterBrush
         * 绘制后的处理。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         *
         */

    }, {
        key: 'afterBrush',
        value: function afterBrush(ctx) {
            ctx.restore();
        }

        /**
         * APIMethod: setContext
         * 设置 fillStyle strokeStyle shadow 等通用绘制样式。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * style - {Object} 样式。
         *
         */

    }, {
        key: 'setContext',
        value: function setContext(ctx, style) {
            var STYLE_CTX_MAP = [['color', 'fillStyle'], ['strokeColor', 'strokeStyle'], ['opacity', 'globalAlpha'], ['lineCap', 'lineCap'], ['lineJoin', 'lineJoin'], ['miterLimit', 'miterLimit'], ['lineWidth', 'lineWidth'], ['shadowBlur', 'shadowBlur'], ['shadowColor', 'shadowColor'], ['shadowOffsetX', 'shadowOffsetX'], ['shadowOffsetY', 'shadowOffsetY']];

            for (var i = 0, len = STYLE_CTX_MAP.length; i < len; i++) {
                var styleProp = STYLE_CTX_MAP[i][0];
                var styleValue = style[styleProp];
                var ctxProp = STYLE_CTX_MAP[i][1];

                if (typeof styleValue != 'undefined') {
                    ctx[ctxProp] = styleValue;
                }
            }
        }

        /**
         * Method: doClip
         *
         */

    }, {
        key: 'doClip',
        value: function doClip(ctx) {
            var clipShapeInvTransform = _SuperMap2["default"].LevelRenderer.Util_matrix.create();

            if (this.__clipShapes) {
                for (var i = 0; i < this.__clipShapes.length; i++) {
                    var clipShape = this.__clipShapes[i];
                    if (clipShape.needTransform) {
                        var m = clipShape.transform;
                        _SuperMap2["default"].LevelRenderer.Util_matrix.invert(clipShapeInvTransform, m);
                        ctx.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
                    }
                    ctx.beginPath();
                    clipShape.buildPath(ctx, clipShape.style);
                    ctx.clip();
                    // Transform back
                    if (clipShape.needTransform) {
                        var m = clipShapeInvTransform;
                        ctx.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
                    }
                }
            }
        }

        /**
         * APIMethod: getHighlightStyle
         * 根据默认样式扩展高亮样式
         *
         * Parameters:
         * style - {Object} 样式。
         * highlightStyle - {Object} 高亮样式。
         * brushTypeOnly - {String} brushTypeOnly。
         *
         */

    }, {
        key: 'getHighlightStyle',
        value: function getHighlightStyle(style, highlightStyle, brushTypeOnly) {
            var newStyle = {};
            for (var k in style) {
                newStyle[k] = style[k];
            }

            var highlightColor = _SuperMap2["default"].LevelRenderer.Util_color.getHighlightColor();
            // 根据highlightStyle扩展
            if (style.brushType != 'stroke') {
                // 带填充则用高亮色加粗边线
                newStyle.strokeColor = highlightColor;
                // SMIC-方法修改 - start
                newStyle.lineWidth = style.lineWidth || 1;
                // 原始代码
                //      newStyle.lineWidth = (style.lineWidth || 1)
                //          + this.getHighlightZoom();
                // 修改代码1
                // if(!style.lineType || style.lineType === "solid"){
                //     newStyle.lineWidth = (style.lineWidth || 1)
                //         + this.getHighlightZoom();
                // }
                // else{
                //     newStyle.lineWidth = (style.lineWidth || 1);
                // }
                // SMIC-方法修改 - end
                newStyle.brushType = 'both';
            } else {
                if (brushTypeOnly != 'stroke') {
                    // 描边型的则用原色加工高亮
                    newStyle.strokeColor = highlightColor;
                    // SMIC-方法修改 - start
                    newStyle.lineWidth = style.lineWidth || 1;
                    // 原始代码
                    //      newStyle.lineWidth = (style.lineWidth || 1)
                    //          + this.getHighlightZoom();
                    // 修改代码1
                    // if(!style.lineType || style.lineType === "solid"){
                    //     newStyle.lineWidth = (style.lineWidth || 1)
                    //         + this.getHighlightZoom();
                    // }
                    // else{
                    //     newStyle.lineWidth = (style.lineWidth || 1);
                    // }
                    // SMIC-方法修改 - end
                } else {
                    // 线型的则用原色加工高亮
                    newStyle.strokeColor = highlightStyle.strokeColor || _SuperMap2["default"].LevelRenderer.Util_color.mix(style.strokeColor, _SuperMap2["default"].LevelRenderer.Util_color.toRGB(highlightColor));
                }
            }

            // 可自定义覆盖默认值
            for (var k in highlightStyle) {
                if (typeof highlightStyle[k] != 'undefined') {
                    newStyle[k] = highlightStyle[k];
                }
            }

            return newStyle;
        }

        /**
         * Method: getHighlightZoom
         * 高亮放大效果参数，当前统一设置为6，如有需要差异设置，通过 this.type 判断实例类型
         *
         */

    }, {
        key: 'getHighlightZoom',
        value: function getHighlightZoom() {
            return this.type != 'text' ? 6 : 2;
        }

        /**
         * APIMethod: drift
         * 移动位置
         *
         * Parameters:
         * dx - {Object} 横坐标变化。
         * dy - {Object} 纵坐标变化。
         *
         */

    }, {
        key: 'drift',
        value: function drift(dx, dy) {
            this.position[0] += dx;
            this.position[1] += dy;
        }

        /**
         * APIMethod: getTansform
         * 变换鼠标位置到 shape 的局部坐标空间
         *
         */

    }, {
        key: 'buildPath',


        /**
         * APIMethod: buildPath
         * 构建绘制的Path。子类必须重新实现此方法。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * style - {Object} 样式。
         */
        value: function buildPath(ctx, style) {
            _SuperMap2["default"].LevelRenderer.Util_log('buildPath not implemented in ' + this.type);
        }

        /**
         * APIMethod: getRect
         * 计算返回包围盒矩形。子类必须重新实现此方法。
         *
         * Parameters:
         * style - {Object} 样式。
         */

    }, {
        key: 'getRect',
        value: function getRect(style) {
            _SuperMap2["default"].LevelRenderer.Util_log('getRect not implemented in ' + this.type);
        }

        /**
         * APIMethod: isCover
         * 判断鼠标位置是否在图形内。
         *
         * Parameters:
         * x - {Number} x。
         * y - {Number} y。
         */

    }, {
        key: 'isCover',
        value: function isCover(x, y) {
            var originPos = this.getTansform(x, y);
            x = originPos[0];
            y = originPos[1];

            // 快速预判并保留判断矩形
            var rect = this.style.__rect;
            if (!rect) {
                rect = this.style.__rect = this.getRect(this.style);
            }

            if (x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height) {
                // 矩形内
                return _SuperMap2["default"].LevelRenderer.Util_area.isInside(this, this.style, x, y);
            }

            return false;
        }

        /**
         * APIMethod: drawText
         * 绘制附加文本。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * style - {String} 样式。
         * normalStyle - {String} normalStyle 默认样式，用于定位文字显示。
         */

    }, {
        key: 'drawText',
        value: function drawText(ctx, style, normalStyle) {
            if (typeof style.text == 'undefined' || style.text === false) {
                return;
            }
            // 字体颜色策略
            var textColor = style.textColor || style.color || style.strokeColor;
            ctx.fillStyle = textColor;

            // 文本与图形间空白间隙
            var dd = 10;
            var al; // 文本水平对齐
            var bl; // 文本垂直对齐
            var tx; // 文本横坐标
            var ty; // 文本纵坐标

            var textPosition = style.textPosition // 用户定义
            || this.textPosition // shape默认
            || 'top'; // 全局默认

            // Smic 方法修改 -start
            var __OP = [];
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) {
                __OP = [0, 0];
            } else {
                __OP = this.refOriginalPosition;
            }
            //原代码：
            // Smic 方法修改 -end

            switch (textPosition) {
                case 'inside':
                case 'top':
                case 'bottom':
                case 'left':
                case 'right':
                    if (this.getRect) {
                        var rect = (normalStyle || style).__rect || this.getRect(normalStyle || style);

                        switch (textPosition) {
                            case 'inside':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y + rect.height / 2;
                                al = 'center';
                                bl = 'middle';
                                if (style.brushType != 'stroke' && textColor == style.color) {
                                    ctx.fillStyle = '#fff';
                                }
                                break;
                            case 'left':
                                tx = rect.x - dd;
                                ty = rect.y + rect.height / 2;
                                al = 'end';
                                bl = 'middle';
                                break;
                            case 'right':
                                tx = rect.x + rect.width + dd;
                                ty = rect.y + rect.height / 2;
                                al = 'start';
                                bl = 'middle';
                                break;
                            case 'top':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y - dd;
                                al = 'center';
                                bl = 'bottom';
                                break;
                            case 'bottom':
                                tx = rect.x + rect.width / 2;
                                ty = rect.y + rect.height + dd;
                                al = 'center';
                                bl = 'top';
                                break;
                        }
                    }
                    break;
                case 'start':
                case 'end':
                    var xStart = 0;
                    var xEnd = 0;
                    var yStart = 0;
                    var yEnd = 0;
                    if (typeof style.pointList != 'undefined') {
                        var pointList = style.pointList;
                        if (pointList.length < 2) {
                            // 少于2个点就不画了~
                            return;
                        }
                        var length = pointList.length;
                        switch (textPosition) {
                            // Smic 方法修改 -start
                            case 'start':
                                xStart = pointList[0][0] + __OP[0];
                                xEnd = pointList[1][0] + __OP[0];
                                yStart = pointList[0][1] + __OP[1];
                                yEnd = pointList[1][1] + __OP[1];
                                break;
                            case 'end':
                                xStart = pointList[length - 2][0] + __OP[0];
                                xEnd = pointList[length - 1][0] + __OP[0];
                                yStart = pointList[length - 2][1] + __OP[1];
                                yEnd = pointList[length - 1][1] + __OP[1];
                                break;
                            //原代码：
                            /*
                             case 'start':
                             xStart = pointList[0][0];
                             xEnd = pointList[1][0];
                             yStart = pointList[0][1];
                             yEnd = pointList[1][1];
                             break;
                             case 'end':
                             xStart = pointList[length - 2][0];
                             xEnd = pointList[length - 1][0];
                             yStart = pointList[length - 2][1];
                             yEnd = pointList[length - 1][1];
                             break;
                             */
                            // Smic 方法修改 -end
                        }
                    } else {
                        // Smic 方法修改 -start
                        xStart = style.xStart + __OP[0] || 0;
                        xEnd = style.xEnd + __OP[0] || 0;
                        yStart = style.yStart + __OP[1] || 0;
                        yEnd = style.yEnd + __OP[1] || 0;
                        //原代码：
                        /*
                         xStart = style.xStart || 0;
                         xEnd = style.xEnd || 0;
                         yStart = style.yStart || 0;
                         yEnd = style.yEnd || 0;
                         */
                        // Smic 方法修改 -end
                    }

                    switch (textPosition) {
                        case 'start':
                            al = xStart < xEnd ? 'end' : 'start';
                            bl = yStart < yEnd ? 'bottom' : 'top';
                            tx = xStart;
                            ty = yStart;
                            break;
                        case 'end':
                            al = xStart < xEnd ? 'start' : 'end';
                            bl = yStart < yEnd ? 'top' : 'bottom';
                            tx = xEnd;
                            ty = yEnd;
                            break;
                    }
                    dd -= 4;
                    if (xStart && xEnd && xStart != xEnd) {
                        tx -= al == 'end' ? dd : -dd;
                    } else {
                        al = 'center';
                    }

                    if (yStart != yEnd) {
                        ty -= bl == 'bottom' ? dd : -dd;
                    } else {
                        bl = 'middle';
                    }
                    break;
                case 'specific':
                    tx = style.textX || 0;
                    ty = style.textY || 0;
                    al = 'start';
                    bl = 'middle';
                    break;
            }

            // Smic 方法修改 -start
            if (style.labelXOffset && !isNaN(style.labelXOffset)) {
                tx += style.labelXOffset;
            }
            if (style.labelYOffset && !isNaN(style.labelYOffset)) {
                ty += style.labelYOffset;
            }
            //原代码：
            // Smic 方法修改 -end

            if (tx != null && ty != null) {
                _SuperMap2["default"].LevelRenderer.Shape._fillText(ctx, style.text, tx, ty, style.textFont, style.textAlign || al, style.textBaseline || bl);
            }
        }

        /**
         * Method: modSelf
         * 图形发生改变
         */

    }, {
        key: 'modSelf',
        value: function modSelf() {
            this.__dirty = true;
            if (this.style) {
                this.style.__rect = null;
            }
            if (this.highlightStyle) {
                this.highlightStyle.__rect = null;
            }
        }

        /**
         * APIMethod: isSilent
         * 图形是否会触发事件，通过 bind 绑定的事件
         */

    }, {
        key: 'isSilent',
        value: function isSilent() {
            return !(this.hoverable || this.draggable || this.clickable || this.onmousemove || this.onmouseover || this.onmouseout || this.onmousedown || this.onmouseup || this.onclick || this.ondragenter || this.ondragover || this.ondragleave || this.ondrop);
        }

        /**
         * Method: setCtxGlobalAlpha
         * 设置 Cavans 上下文全局透明度
         *
         * Parameters:
         * _ctx - {Object} Cavans 上下文
         * type - {String} one of 'stroke' 'fill' or 'reset'
         * style - {Object} Symbolizer hash
         */

    }, {
        key: 'setCtxGlobalAlpha',
        value: function setCtxGlobalAlpha(_ctx, type, style) {
            if (type === "fill") {
                _ctx.globalAlpha = typeof style["fillOpacity"] === "undefined" ? typeof style["opacity"] === "undefined" ? 1 : style['opacity'] : style['fillOpacity'];
            } else if (type === "stroke") {
                _ctx.globalAlpha = typeof style["strokeOpacity"] === "undefined" ? typeof style["opacity"] === "undefined" ? 1 : style['opacity'] : style['strokeOpacity'];
            } else {
                _ctx.globalAlpha = typeof style["opacity"] === "undefined" ? 1 : style['opacity'];
            }
        }

        /**
         * Method: SuperMap.LevelRenderer.Shape._fillText
         * 填充文本
         */

    }], [{
        key: '_fillText',
        value: function _fillText(ctx, text, x, y, textFont, textAlign, textBaseline) {
            if (textFont) {
                ctx.font = textFont;
            }
            ctx.textAlign = textAlign;
            ctx.textBaseline = textBaseline;
            var rect = _SuperMap2["default"].LevelRenderer.Shape._getTextRect(text, x, y, textFont, textAlign, textBaseline);

            text = (text + '').split('\n');

            var lineHeight = _SuperMap2["default"].LevelRenderer.Util_area.getTextHeight('ZH', textFont);

            switch (textBaseline) {
                case 'top':
                    y = rect.y;
                    break;
                case 'bottom':
                    y = rect.y + lineHeight;
                    break;
                default:
                    y = rect.y + lineHeight / 2;
            }

            for (var i = 0, l = text.length; i < l; i++) {
                ctx.fillText(text[i], x, y);
                y += lineHeight;
            }
        }
    }, {
        key: '_getTextRect',


        /**
         * Method: SuperMap.LevelRenderer.Shape._getTextRect
         * 返回矩形区域，用于局部刷新和文字定位
         *
         * Parameters:
         * text - {String} text。
         * x - {Number} x。
         * y - {Number} y。
         * textFont - {String} textFont。
         * textAlign - {String} textAlign。
         * textBaseline - {String} textBaseline。
         *
         * Returns:
         * {Object} 矩形区域。
         */
        value: function _getTextRect(text, x, y, textFont, textAlign, textBaseline) {
            var width = _SuperMap2["default"].LevelRenderer.Util_area.getTextWidth(text, textFont);
            var lineHeight = _SuperMap2["default"].LevelRenderer.Util_area.getTextHeight('ZH', textFont);

            text = (text + '').split('\n');

            switch (textAlign) {
                case 'end':
                case 'right':
                    x -= width;
                    break;
                case 'center':
                    x -= width / 2;
                    break;
            }

            switch (textBaseline) {
                case 'top':
                    break;
                case 'bottom':
                    y -= lineHeight * text.length;
                    break;
                default:
                    y -= lineHeight * text.length / 2;
            }

            return {
                x: x,
                y: y,
                width: width,
                height: lineHeight * text.length
            };
        }
    }]);

    return Shape;
}(_SuperMap2["default"].mixin(_Eventful2["default"], _Transformable2["default"]));

exports["default"] = Shape;

_SuperMap2["default"].LevelRenderer.Shape = Shape;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Geometry2 = __webpack_require__(58);

var _Geometry3 = _interopRequireDefault(_Geometry2);

var _Bounds = __webpack_require__(57);

var _Bounds2 = _interopRequireDefault(_Bounds);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Point
 * @classdesc 点几何对象类。
 * @extends {SuperMap.Geometry}
 * @param  x - {float} x-坐标
 * @param y - {float} y-坐标
 * @param type - {string} 用来存储点的类型
 * @param tag -  {float} 用来存储额外的属性，比如差值分析中的Z值。
 * @example
 * var point = new SuperMap.Geometry.Point(-111.04, 45.68);
 */
var Point = function (_Geometry) {
    _inherits(Point, _Geometry);

    /**
     * @member SuperMap.Geometry.Point.prototype.tag - {string}
     * @description  用来存储额外的属性，比如差值分析中的Z值。
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.x - {float}
     * @description 横坐标。
     */
    function Point(x, y, type, tag) {
        _classCallCheck(this, Point);

        var _this = _possibleConstructorReturn(this, (Point.__proto__ || Object.getPrototypeOf(Point)).call(this, x, y, type, tag));

        _this.x = null;
        _this.y = null;
        _this.tag = null;
        _this.type = null;
        _this.CLASS_NAME = "SuperMap.Geometry.Point";


        _this.x = parseFloat(x);
        _this.y = parseFloat(y);
        if (tag || tag == 0) {
            _this.tag = parseFloat(tag);
        }
        _this.type = type || "NONE";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Point.prototype.clone
     * @description 克隆点对象。
     * @returns {SuperMap.Geometry.Point} 克隆后的点对象。
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.tag - {string}
     * @description  用来存储点的类型
     */


    /**
     * @member SuperMap.Geometry.Point.prototype.y - {float}
     * @description 纵坐标。
     */


    _createClass(Point, [{
        key: 'clone',
        value: function clone(obj) {
            if (obj == null) {
                obj = new Point(this.x, this.y);
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(obj, this);

            return obj;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.calculateBounds
         * @description 计算点对象的范围。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = new _Bounds2["default"](this.x, this.y, this.x, this.y);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.distanceTo
         * @description 计算两个点对象间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标点对象。
         * @param options - {Object} 计算距离时需要设置的可选属性。有效的选项取决于特定的几何类型。<br>
         *         details - {boolean} 返回距离计算的细节。默认为false。<br>
         *         edge - {boolean} 计算一个几何对象到目标几何对象边缘的最近距离。默认为true。 如果设为true，
         *                          一个几何对象完全包含在目标几何对象中时，调用distanceTo返回非零结果，如果
         *                          false，两个几何对象相交情况下调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何对象到目标几何对象的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var distance, x0, y0, x1, y1, result;
            if (geometry instanceof Point) {
                x0 = this.x;
                y0 = this.y;
                x1 = geometry.x;
                y1 = geometry.y;
                distance = Math.sqrt(Math.pow(x0 - x1, 2) + Math.pow(y0 - y1, 2));
                result = !details ? distance : { x0: x0, y0: y0, x1: x1, y1: y1, distance: distance };
            } else {
                result = geometry.distanceTo(this, options);
                if (details) {
                    // switch coord order since this geom is target
                    result = {
                        x0: result.x1, y0: result.y1,
                        x1: result.x0, y1: result.y0,
                        distance: result.distance
                    };
                }
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.equals
         * @description 判断两个点对象是否相等。如果两个点对象具有相同的坐标，则认为是相等的。
         * @example
         * var point= new SuperMap.Geometry.Point(00);
         * var point1={x:0y:0};
         * var result= point.equals(point1);
         * @param geom - {SuperMap.Geometry.Point} 需要判断的点对象。
         * @returns {boolean} 两个点对象是否相等（true为相等，false为不等）。
         */

    }, {
        key: 'equals',
        value: function equals(geom) {
            var equals = false;
            if (geom != null) {
                equals = this.x === geom.x && this.y === geom.y || isNaN(this.x) && isNaN(this.y) && isNaN(geom.x) && isNaN(geom.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.toShortString
         * @returns {string} 字符串代表点对象。(ex. <i>"5 42"</i>)
         */

    }, {
        key: 'toShortString',
        value: function toShortString() {
            return this.x + ", " + this.y;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.move
         * @description 沿着x、y轴的正方向上按照给定的位移移动点对象，move 不仅改变了几何对象的位置并且清理了边界缓存。
         * @param x - {float} x轴正方向上的偏移量。
         * @param  y - {float} y轴正方向上偏移量。
         * @example
         * var point = new SuperMap.Geometry.Point(1020);
         * var dx = 10*Math.random();
         * var dy = 10*Math.random();
         * point.move(dxdy);
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            this.x = this.x + x;
            this.y = this.y + y;
            this.clearBounds();
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.rotate
         * @description 围绕中心点旋转点对象。
         * @param angle - {float} 旋转角的度数（沿着x轴正方向的逆时针方向）。
         * @param origin - {SuperMap.Geometry.Point} 旋转的中心点 。
         * @example
         * var point = new SuperMap.Geometry.Point(1020);
         * var rotateOrigin = new SuperMap.Geometry.Point(510);
         * point.rotate(360rotateOrigin);
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            angle *= Math.PI / 180;
            var radius = this.distanceTo(origin);
            var theta = angle + Math.atan2(this.y - origin.y, this.x - origin.x);
            this.x = origin.x + radius * Math.cos(theta);
            this.y = origin.y + radius * Math.sin(theta);
            this.clearBounds();
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.getCentroid
         * @description 获取点对象的质心。
         * @returns {SuperMap.Geometry.Point} 点对象的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            return new Point(this.x, this.y);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.resize
         * @description 调整几何对象相对于原点的大小。
         * @param scale - {float} resize之后到原点的距离与resize之前到原点的距离比。
         * @param origin - {SuperMap.Geometry.Point} 调整的起始点。
         * @param ratio - {float} 点对象自身x与y的比值：ratio=x/y，默认的比例为1，不推荐设置。
         * @returns {SuperMap.Geometry} - 当前几何对象。
         * @example
         * var point = new SuperMap.Geometry.Point(1010);
         * var origin = new SuperMap.Geometry.Point(00);
         * point.resize(2origin4);
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            ratio = ratio == undefined ? 1 : ratio;
            //所有的线和面最终都是控制点
            this.x = origin.x + scale * ratio * (this.x - origin.x);

            this.y = origin.y + scale * (this.y - origin.y);
            this.clearBounds();
            return this;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.intersects
         * @description 判断两个几何对象是否相交。
         * @param geometry - {SuperMap.Geometry} 任意类型的几何对象。
         * @returns {boolean} 传入的几何对象与当前几何对象相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.equals(geometry);
            } else {
                intersect = geometry.intersects(this);
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.destroy
         * @description 释放点对象的资源
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.tag = null;
            _get(Point.prototype.__proto__ || Object.getPrototypeOf(Point.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Point.prototype.getVertices
         * @description 返回点对象的所有顶点的列表。
         * @param nodes - {boolean} 对于点对象此参数不起作用，直接返回点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            return [this];
        }
    }]);

    return Point;
}(_Geometry3["default"]);

exports["default"] = Point;

_SuperMap2["default"].Geometry.Point = Point;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(3);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.NetworkAnalystServiceBase
 * @classdesc 网络分析服务基类。
 * @description 网络分析服务基类。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 网络分析服务地址
 * @param options - {Object} 网络分析可选参数。如：<br>
 *        format - {{@link SuperMap.DataFormat}} 查询结果返回格式
 *
 */
var NetworkAnalystServiceBase = function (_CommonServiceBase) {
    _inherits(NetworkAnalystServiceBase, _CommonServiceBase);

    function NetworkAnalystServiceBase(url, options) {
        _classCallCheck(this, NetworkAnalystServiceBase);

        var _this = _possibleConstructorReturn(this, (NetworkAnalystServiceBase.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase)).call(this, url, options));

        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.NetworkAnalystServiceBase";

        if (options && options.format) {
            _this.format = options.format.toUpperCase();
        }
        return _this;
    }

    /**
     * @function SuperMap.NetworkAnalystServiceBase.prototype.destroy
     * @description 释放资源，将引用的资源属性置空。
     */


    /**
     * @member SuperMap.NetworkAnalystServiceBase.prototype.format -{SuperMap.DataFormat}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *              参数格式为"ISERVER","GEOJSON"
     * @default "GEOJSON"
     */


    _createClass(NetworkAnalystServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(NetworkAnalystServiceBase.prototype.__proto__ || Object.getPrototypeOf(NetworkAnalystServiceBase.prototype), 'destroy', this).call(this);
            this.format = null;
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.serviceProcessCompleted
         * @description 分析完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this,
                analystResult;
            result = _SuperMap2["default"].Util.transformResult(result);
            if (result && me.format === _REST.DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
                analystResult = me.toGeoJSONResult(result);
            }
            if (!analystResult) {
                analystResult = result;
            }
            me.events.triggerEvent("processCompleted", { result: analystResult });
        }

        /**
         * @function SuperMap.NetworkAnalystServiceBase.prototype.toGeoJSONResult
         * @description 将含有geometry的数据转换为geojson格式。只处理结果中的路由，由子类实现
         * @param result - {Object} 服务器返回的结果对象。
         * @return{Object} geojson对象
         */

    }, {
        key: 'toGeoJSONResult',
        value: function toGeoJSONResult(result) {
            return null;
        }
    }]);

    return NetworkAnalystServiceBase;
}(_CommonServiceBase3["default"]);

exports["default"] = NetworkAnalystServiceBase;

_SuperMap2["default"].NetworkAnalystServiceBase = NetworkAnalystServiceBase;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FetchRequest = exports.Support = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

__webpack_require__(405);

var _whatwgFetchImportable = __webpack_require__(168);

var _whatwgFetchImportable2 = _interopRequireDefault(_whatwgFetchImportable);

var _fetchJsonp2 = __webpack_require__(157);

var _fetchJsonp3 = _interopRequireDefault(_fetchJsonp2);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Support = exports.Support = _SuperMap2["default"].Support = _SuperMap2["default"].Support || {
    cors: window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest()
};
var FetchRequest = exports.FetchRequest = _SuperMap2["default"].FetchRequest = {
    commit: function commit(method, url, params, options) {
        method = method ? method.toUpperCase() : method;
        switch (method) {
            case 'GET':
                return this.get(url, params, options);
            case 'POST':
                return this.post(url, params, options);
            case 'PUT':
                return this.put(url, params, options);
            case 'DELETE':
                return this["delete"](url, params, options);
            default:
                return this.get(url, params, options);
        }
    },

    get: function get(url, params, options) {
        options = options || {};
        var type = 'GET';
        url = this._processUrl(url, options);
        url = _SuperMap2["default"].Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.urlIsLong(url)) {
            if (_SuperMap2["default"].Util.isInTheSameDomain(url) || Support.cors || options.proxy) {
                return this._fetch(url, params, options, type);
            }
            if (!_SuperMap2["default"].Util.isInTheSameDomain(url)) {
                url = url.replace('.json', '.jsonp');
                return this._fetchJsonp(url, options);
            }
        }
        return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    },

    "delete": function _delete(url, params, options) {
        options = options || {};
        var type = 'DELETE';
        url = this._processUrl(url, options);
        url = _SuperMap2["default"].Util.urlAppend(url, this._getParameterString(params || {}));
        if (!this.urlIsLong(url) && Support.cors) {
            return this._fetch(url, params, options, type);
        }
        return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    },

    post: function post(url, params, options) {
        options = options || {};
        return this._fetch(this._processUrl(url, options), params, options, 'POST');
    },

    put: function put(url, params, options) {
        options = options || {};
        return this._fetch(this._processUrl(url, options), params, options, 'PUT');
    },
    urlIsLong: function urlIsLong(url) {
        //当前url的字节长度。
        var totalLength = 0,
            charCode = null;
        for (var i = 0, len = url.length; i < len; i++) {
            //转化为Unicode编码
            charCode = url.charCodeAt(i);
            if (charCode < 0x007f) {
                totalLength++;
            } else if (0x0080 <= charCode && charCode <= 0x07ff) {
                totalLength += 2;
            } else if (0x0800 <= charCode && charCode <= 0xffff) {
                totalLength += 3;
            }
        }
        return totalLength < 2000 ? false : true;
    },
    _postSimulatie: function _postSimulatie(type, url, params, options) {
        var separator = url.indexOf("?") > -1 ? "&" : "?";
        url += separator + '_method= ' + type;
        return this.post(url, params, options);
    },

    _processUrl: function _processUrl(url, options) {
        if (this._isMVTRequest(url)) {
            return url;
        }

        if (url.indexOf('.json') === -1 && !options.withoutFormatSuffix) {
            if (url.indexOf("?") < 0) {
                url += '.json';
            } else {
                var urlArrays = url.split("?");
                if (urlArrays.length === 2) {
                    url = urlArrays[0] + ".json?" + urlArrays[1];
                }
            }
        }
        if (options && options.proxy) {
            if (typeof options.proxy === "function") {
                url = options.proxy(url);
            } else {
                url = decodeURIComponent(url);
                url = options.proxy + encodeURIComponent(url);
            }
        }
        return url;
    },

    _fetch: function _fetch(url, params, options, type) {
        options = options || {};
        options.headers = options.headers || {};
        if (!options.headers['Content-Type']) {
            options.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8';
        }
        if (options.timeout) {
            return this._timeout(options.timeout, (0, _whatwgFetchImportable2["default"])(url, {
                method: type,
                headers: options.headers,
                body: type === 'PUT' || type === 'POST' ? params : undefined,
                credentials: options.withCredentials ? 'include' : 'omit',
                mode: 'cors'
            }).then(function (response) {
                return response;
            }));
        }
        return (0, _whatwgFetchImportable2["default"])(url, {
            method: type,
            body: type === 'PUT' || type === 'POST' ? params : undefined,
            headers: options.headers,
            credentials: options.withCredentials ? 'include' : 'omit',
            mode: 'cors'
        }).then(function (response) {
            return response;
        });
    },

    _fetchJsonp: function _fetchJsonp(url, options) {
        options = options || {};
        return (0, _fetchJsonp3["default"])(url, { method: 'GET', timeout: options.timeout }).then(function (response) {
            return response;
        });
    },

    _timeout: function _timeout(seconds, promise) {
        return new Promise(function (resolve, reject) {
            setTimeout(function () {
                reject(new Error("timeout"));
            }, seconds);
            promise.then(resolve, reject);
        });
    },

    _getParameterString: function _getParameterString(params) {
        var paramsArray = [];
        for (var key in params) {
            var value = params[key];
            if (value != null && typeof value !== 'function') {
                var encodedValue;
                if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' && value.constructor === Array) {
                    var encodedItemArray = [];
                    var item;
                    for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
                        item = value[itemIndex];
                        encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
                    }
                    encodedValue = '[' + encodedItemArray.join(",") + ']';
                } else {
                    encodedValue = encodeURIComponent(value);
                }
                paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
            }
        }
        return paramsArray.join("&");
    },

    _isMVTRequest: function _isMVTRequest(url) {
        return url.indexOf('.mvt') > -1 || url.indexOf('.pbf') > -1;
    }
};

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _JoinItem = __webpack_require__(63);

var _JoinItem2 = _interopRequireDefault(_JoinItem);

var _LinkItem = __webpack_require__(276);

var _LinkItem2 = _interopRequireDefault(_LinkItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FilterParameter
 * @classdesc 查询过滤条件参数类。该类用于设置查询数据集的查询过滤参数。
 * @param options - {Object} 可选参数。如:<br>
 *        attributeFilter - {string} 属性过滤条件。</br>
 *        name - {string} 查询数据集名称或者图层名称。</br>
 *        joinItems - {Array<{@link SuperMap.JoinItem}>} 与外部表的连接信息 SuperMap.JoinItem 数组。</br>
 *        linkItems - {Array<{@link SuperMap.LinkItem}>} 与外部表的关联信息 SuperMap.LinkItem 数组。</br>
 *        ids - {Array<string>} 查询 id 数组，即属性表中的 SmID 值。</br>
 *        orderBy - {string} 查询排序的字段, orderBy 的字段须为数值型的。</br>
 *        groupBy - {string} 查询分组条件的字段。</br>
 *        fields - {Array<string>} 查询字段数组。</br>
 */
var FilterParameter = function () {

  /**
     * @member SuperMap.FilterParameter.prototype.groupBy - {string}
     * @description 查询分组条件的字段。
     * 相当于 SQL 语句中的 GROUP BY 子句，其格式为：GROUP BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段分组时，该字段的用法为 groupBy = "字段名"；
     * 对多个字段分组时，字段之间以英文逗号进行分割，用法为 groupBy = "字段名1, 字段名2"。
     * 例如，现有一个全球城市数据集，该数据集有两个字段分别为“Continent”和“Country”，
     * 分别表示某个城市所属的洲和国家。
     * 如果要按照国家对全球的城市进行分组， 可以设置 groupBy = "Country"；
     * 如果以洲和国家对城市进行分组，设置 groupBy = "Continent, Country"。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.ids -{Array<string>}
     * @description 查询 id 数组，即属性表中的 SmID 值。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.joinItems - {Array<SuperMap.JoinItem>}
     * @description 与外部表的连接信息 SuperMap.JoinItem 数组。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.attributeFilter - {string}
     * @description 属性过滤条件。
     * 相当于 SQL 语句中的 WHERE 子句，其格式为：WHERE <条件表达式>，
     * attributeFilter 就是其中的“条件表达式”。
     * 该字段的用法为 attributeFilter = "过滤条件"。
     * 例如，要查询字段 fieldValue 小于100的记录，设置 attributeFilter = "fieldValue < 100"；
     * 要查询字段 name 的值为“酒店”的记录，设置 attributeFilter = "name like '%酒店%'"，等等。
     */
  function FilterParameter(options) {
    _classCallCheck(this, FilterParameter);

    this.attributeFilter = null;
    this.name = null;
    this.joinItems = null;
    this.linkItems = null;
    this.ids = null;
    this.orderBy = null;
    this.groupBy = null;
    this.fields = null;
    this.CLASS_NAME = "SuperMap.FilterParameter";

    if (options) {
      _SuperMap2["default"].Util.extend(this, options);
    }
  }

  /**
     * @function SuperMap.FilterParameter.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.fields - {Array<string>}
     * @description 查询字段数组，如果不设置则使用系统返回的所有字段。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.orderBy - {string}
     * @description 查询排序的字段,orderBy的字段须为数值型的。
     * 相当于 SQL 语句中的 ORDER BY 子句，其格式为：ORDER BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段排序时，该字段的用法为 orderBy = "字段名"；
     * 对多个字段排序时，字段之间以英文逗号进行分割，用法为 orderBy = "字段名1, 字段名2"。
     * 例如，现有一个国家数据集，它有两个字段分别为“SmArea”和“pop_1994”，
     * 分别表示国家的面积和1994年的各国人口数量。
     * 如果要按照各国人口数量对记录进行排序，则 orderBy = "pop_1994"；
     * 如果要以面积和人口进行排序，则 orderBy = "SmArea, pop_1994"。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.linkItems - {Array<SuperMap.LinkItem>}
     * @description 与外部表的关联信息 LinkItem 数组。
     */


  /**
     * @member SuperMap.FilterParameter.prototype.name - {string}
     * @description 查询数据集名称或者图层名称，根据实际的查询对象而定，必设属性。
     * 一般情况下该字段为数据集名称，但在进行与地图相关功能的操作时，
     * 需要设置为图层名称（图层名称格式：数据集名称@数据源别名）。
     * 因为一个地图的图层可能是来自于不同数据源的数据集，
     * 而不同的数据源中可能存在同名的数据集，
     * 使用数据集名称不能唯一的确定数据集，
     * 所以在进行与地图相关功能的操作时，该值需要设置为图层名称。
     */


  _createClass(FilterParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.attributeFilter = null;
      me.name = null;
      if (me.joinItems) {
        for (var i = 0, joinItems = me.joinItems, len = joinItems.length; i < len; i++) {
          joinItems[i].destroy();
        }
        me.joinItems = null;
      }
      if (me.linkItems) {
        for (var i = 0, linkItems = me.linkItems, len = linkItems.length; i < len; i++) {
          linkItems[i].destroy();
        }
        me.linkItems = null;
      }
      me.ids = null;
      me.orderBy = null;
      me.groupBy = null;
      me.fields = null;
    }
  }]);

  return FilterParameter;
}();

exports["default"] = FilterParameter;

_SuperMap2["default"].FilterParameter = FilterParameter;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerColor
 * @classdesc 颜色类。该类使用三原色（ RGB ）来表达颜色。
 * @param options - {Object} 可选参数。如：<br>
 *        red - {number}获取或设置红色值,默认值为255。<br>
 *        green - {number}获取或设置绿色值,默认值为0。<br>
 *        blue - {number}获取或设置蓝色值,默认值为0。
 */
var ServerColor = function () {

    /**
     * @member SuperMap.ServerColor.prototype.green -{number}
     * @description 获取或设置绿色值,默认值为0。
     * @default 0
     */
    function ServerColor(red, green, blue) {
        _classCallCheck(this, ServerColor);

        this.red = 255;
        this.green = 0;
        this.blue = 0;
        this.CLASS_NAME = "SuperMap.ServerColor";

        if (!red && red != 0) {
            this.red = 255;
        } else {
            this.red = red;
        }

        if (!green && green != 0) {
            this.green = 0;
        } else {
            this.green = green;
        }

        if (!blue && blue != 0) {
            this.blue = 0;
        } else {
            this.blue = blue;
        }
    }

    /**
     * @function SuperMap.ServerColor.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerColor.prototype.blue -{number}
     * @description 获取或设置蓝色值,默认值为0。
     * @default 0
     */


    /**
     * @member SuperMap.ServerColor.prototype.red -{number}
     * @description 获取或设置红色值,默认值为255。
     * @default 255
     */


    _createClass(ServerColor, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.red = null;
            me.green = null;
            me.blue = null;
        }

        /**
         * @function SuperMap.ServerColor.formJson
         * @description 将JSON对象转化为ServerColor对象。
         * @param jsonObject - {Object} 要转换的JSON对象
         * @return{SuperMap.ServerColor} 转化后的ServerColor对象。
         */

    }], [{
        key: "fromJson",
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }
            var color = new ServerColor();
            var red = 255;
            if (jsonObject.red !== null) {
                red = Number(jsonObject.red);
            }
            color.red = red;

            var green = 0;
            if (jsonObject.green !== null) {
                green = Number(jsonObject.green);
            }
            color.green = green;

            var blue = 0;
            if (jsonObject.blue !== null) {
                blue = Number(jsonObject.blue);
            }
            color.blue = blue;
            return color;
        }
    }]);

    return ServerColor;
}();

exports["default"] = ServerColor;


_SuperMap2["default"].ServerColor = ServerColor;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ThemeMemoryData = __webpack_require__(331);

var _ThemeMemoryData2 = _interopRequireDefault(_ThemeMemoryData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Theme
 * @classdesc 专题图基类。
 * @param  type - {string} 专题图类型。
 * @param options - {Object} 可选参数。如：<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var Theme = function () {

    /**
     * @member SuperMap.Theme.prototype.memoryData -{SuperMap.ThemeMemoryData}
     * @description 专题图内存数据。<br>
     *              用内存数据制作专题图的方式与表达式制作专题图的方式互斥，前者优先级较高。
     *              第一个参数代表专题值，即数据集中用来做专题图的字段或表达式的值；第二个参数代表外部值。在制作专题图时，会用外部值代替专题值来制作相应的专题图。
     */
    function Theme(type, options) {
        _classCallCheck(this, Theme);

        this.memoryData = null;
        this.type = null;
        this.CLASS_NAME = "SuperMap.Theme";

        if (!type) {
            return this;
        }
        this.type = type;
        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.Theme.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.Theme.prototype.type -{string}
     * @description 专题图类型。
     */


    _createClass(Theme, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.memoryData) {
                me.memoryData.destroy();
                me.memoryData = null;
            }
            me.type = null;
        }

        /**
         * @function SuperMap.Theme.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            //return 子类实现
            return;
        }
    }]);

    return Theme;
}();

exports["default"] = Theme;


_SuperMap2["default"].Theme = Theme;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

__webpack_require__(47);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.Feature.ShapeParameters
 * 图形参数基类，此类不可实例化
 */
var ShapeParameters = function () {

    /**
     * Constructor: SuperMap.Feature.ShapeParameters
     * 图形参数对象。
     *
     * Returns:
     * {Object} 图形参数对象。
     */


    /**
     * Property: style。
     * {Object} 图形样式对象，可设样式属性在子类中确定。
     */


    /**
     * APIProperty: clickable
     * {Boolean} 是否可点击。
     */


    /**
     * APIProperty: refDataHoverGroup
     * {String} 高亮图形组的组名。此属性在 refDataID 有效且 isHoverByRefDataID 为 true 时生效。
     * 一旦设置此属性，且属性值有效，只有关联同一个数据的图形且此属性相同的图形才会高亮。
     */


    /**
     * APIProperty: refDataID
     * {String} 图形所关联数据的 ID （ <SuperMap.Feature.Vector> 的 id ）。
     */
    function ShapeParameters() {
        _classCallCheck(this, ShapeParameters);

        this.refOriginalPosition = null;
        this.refDataID = null;
        this.isHoverByRefDataID = false;
        this.refDataHoverGroup = null;
        this.dataInfo = null;
        this.clickable = true;
        this.hoverable = true;
        this.style = null;
        this.highlightStyle = null;
        this.CLASS_NAME = "SuperMap.Feature.ShapeParameters";

        this.refOriginalPosition = [0, 0];
        this.highlightStyle = {};
    }

    /**
     * APIMethod: destroy
     * 销毁对象。
     */


    /**
     * Property: highlightStyle
     * {Object} 高亮样式对象，可设样式属性与 style 的可设样式属性相同。
     */


    /**
     * APIProperty: hoverable
     * {Boolean} 是否可 hover。
     */


    /**
     * APIProperty: dataInfo
     * {Object} 图形携带的附加数据。
     */


    /**
     * APIProperty: isHoverByRefDataID
     * {Boolean} 是否根据 refDataID 进行高亮。用于同时高亮所有 refDataID 相同的图形。
     */


    /**
     * APIProperty: refOriginalPosition
     * {Array} 图形参考原点位置，图形的参考中心位置。
     * refOriginalPosition 是长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     *
     * refOriginalPosition 表示图形的参考中心，通常情况下，图形是使用 canvas 的原点位置作为位置参考，
     * 但 refOriginalPosition 可以改变图形的参考位置，例如： refOriginalPosition = [80, 80],
     * 图形圆的 style.x = 20, style.y = 20，那么圆在 canvas 中的实际位置是 [100, 100]。
     *
     * 图形（Shape） 的所有位置相关属性都是以 refOriginalPosition 为参考中心，
     * 也就是说图形的所有位置信息在 canvas 中都是以 refOriginalPosition 为参考的相对位置，只有
     * refOriginalPosition 的值为 [0, 0] 时，图形的位置信息才是 canvas 绝对位置。
     *
     * 图形的位置信息通常有：style.pointList，style.x，style.y。
     *
     * refOriginalPosition。默认值是： [0, 0]。
     */


    _createClass(ShapeParameters, [{
        key: 'destroy',
        value: function destroy() {
            this.refOriginalPosition = null;
            this.refDataID = null;
            this.isHoverByRefDataID = null;
            this.refDataHoverGroup = null;
            this.dataInfo = null;
            this.clickable = null;
            this.hoverable = null;
            this.style = null;
            this.highlightStyle = null;
        }
    }]);

    return ShapeParameters;
}();

exports["default"] = ShapeParameters;

_SuperMap2["default"].Feature.ShapeParameters = ShapeParameters;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _Geometry2 = __webpack_require__(58);

var _Geometry3 = _interopRequireDefault(_Geometry2);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Collection
 * @classdesc 几何对象集合类，存储在本地的 components 属性中（可作为参数传递给构造函数）。
 *            随着新的几何图形添加到集合中，将不能被克隆，当移动几何图形时，需要指定参照物。
 *            getArea和getLength函数只能通过遍历存储几何对象的 components 数组，总计所有几何图形的面积和长度。
 *
 * @extends SuperMap.Geometry
 * @param components - {Array<SuperMap.Geometry>} 几何对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(10,20);
 * var point2 = new SuperMap.Geometry.Point(30,40);
 * var col = new SuperMap.Geometry.Collection([point1,point2]);
 */
var Collection = function (_Geometry) {
    _inherits(Collection, _Geometry);

    /**
     * @description 存储几何对象的数组。
     * @member SuperMap.Geometry.Collection.prototype.components - {Array<SuperMap.Geometry>}
     */
    function Collection(components) {
        _classCallCheck(this, Collection);

        var _this = _possibleConstructorReturn(this, (Collection.__proto__ || Object.getPrototypeOf(Collection)).call(this));

        _this.components = null;
        _this.componentTypes = null;
        _this.CLASS_NAME = "SuperMap.Geometry.Collection";

        _this.components = [];
        if (components != null) {
            _this.addComponents(components);
        }
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Collection.prototype.destroy
     * @description 销毁几何图形。
     */


    /**
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @member SuperMap.Geometry.Collection.prototype.componentTypes - {Array<string>}
     */


    _createClass(Collection, [{
        key: 'destroy',
        value: function destroy() {
            this.components.length = 0;
            this.components = null;
            _get(Collection.prototype.__proto__ || Object.getPrototypeOf(Collection.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.clone
         * @description 克隆当前几何对象。
         * @returns {SuperMap.Geometry.Collection} 克隆的几何对象集合。
         */

    }, {
        key: 'clone',
        value: function clone() {
            var geometry = eval("new " + this.CLASS_NAME + "()");
            for (var i = 0, len = this.components.length; i < len; i++) {
                geometry.addComponent(this.components[i].clone());
            }

            // catch any randomly tagged-on properties
            _Util.Util.applyDefaults(geometry, this);

            return geometry;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getComponentsString
         * @description 获取components字符串。
         * @returns {string} components字符串。
         */

    }, {
        key: 'getComponentsString',
        value: function getComponentsString() {
            var strings = [];
            for (var i = 0, len = this.components.length; i < len; i++) {
                strings.push(this.components[i].toShortString());
            }
            return strings.join(",");
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.calculateBounds
         * @description 通过遍历数组重新计算边界，在遍历每一子项中时调用 extend 方法。
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {
            this.bounds = null;
            var bounds = new _SuperMap2["default"].Bounds();
            var components = this.components;
            if (components) {
                for (var i = 0, len = components.length; i < len; i++) {
                    bounds.extend(components[i].getBounds());
                }
            }
            // to preserve old behavior, we only set bounds if non-null
            // in the future, we could add bounds.isEmpty()
            if (bounds.left != null && bounds.bottom != null && bounds.right != null && bounds.top != null) {
                this.setBounds(bounds);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponents
         * @description 给几何图形对象添加元素。
         * @param components - {Array<SuperMap.Geometry>} 几何对象组件。
         * @example
         * var collection = new SuperMap.Geometry.Collection();
         * collection.addComponents(new SuerpMap.Geometry.Point(1010));
         */

    }, {
        key: 'addComponents',
        value: function addComponents(components) {
            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = 0, len = components.length; i < len; i++) {
                this.addComponent(components[i]);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.addComponent
         * @description 添加一个几何对象到集合中。如果设置了componentTypes类型，则添加的几何对象必须是componentTypes中的类型。
         * @param component - {SuperMap.Geometry} 待添加的几何对象。
         * @param index - {int} 几何对象插入的位置。
         * @returns {boolean} 是否添加成功。
         */

    }, {
        key: 'addComponent',
        value: function addComponent(component, index) {
            var added = false;
            if (component) {
                if (this.componentTypes == null || _Util.Util.indexOf(this.componentTypes, component.CLASS_NAME) > -1) {

                    if (index != null && index < this.components.length) {
                        var components1 = this.components.slice(0, index);
                        var components2 = this.components.slice(index, this.components.length);
                        components1.push(component);
                        this.components = components1.concat(components2);
                    } else {
                        this.components.push(component);
                    }
                    component.parent = this;
                    this.clearBounds();
                    added = true;
                }
            }
            return added;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponents
         * @description 清除几何对象。
         * @param components - {Array<SuperMap.Geometry>} 需要清除的几何对象。
         * @returns {boolean} 元素是否被删除。
         */

    }, {
        key: 'removeComponents',
        value: function removeComponents(components) {
            var removed = false;

            if (!_Util.Util.isArray(components)) {
                components = [components];
            }
            for (var i = components.length - 1; i >= 0; --i) {
                removed = this.removeComponent(components[i]) || removed;
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.removeComponent
         * @description 从集合中移除一个几何对象
         * @param component - {SuperMap.Geometry} 要移除的几何对象
         * @returns {boolean} 几何对象是否移除成功
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(component) {
            _Util.Util.removeItem(this.components, component);

            // clearBounds() so that it gets recalculated on the next call
            // to this.getBounds();
            this.clearBounds();
            return true;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getLength
         * @description 计算几何对象长度。
         * @returns {number} 几何对象长度（所有几何对象长度总和）。
         */

    }, {
        key: 'getLength',
        value: function getLength() {
            var length = 0.0;
            for (var i = 0, len = this.components.length; i < len; i++) {
                length += this.components[i].getLength();
            }
            return length;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getArea
         * @description 计算几何对象的面积。注意，这个方法在 <SuperMap.Geometry.Polygon> 类中需要重写。
         * @returns {number} 几何图形的面积，是几何对象中所有组成部分的面积之和。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            for (var i = 0, len = this.components.length; i < len; i++) {
                area += this.components[i].getArea();
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getCentroid
         * @description 计算几何图形集合的质心。
         * @param weighted - {boolean} 执行getCentroid方法进行递归计算，返回此几何图形集合中的面积加权平均值。
         * @returns {SuperMap.Geometry.Point} 质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid(weighted) {
            if (!weighted) {
                return this.components.length && this.components[0].getCentroid();
            }
            var len = this.components.length;
            if (!len) {
                return false;
            }

            var areas = [];
            var centroids = [];
            var areaSum = 0;
            var minArea = Number.MAX_VALUE;
            var component;
            for (var i = 0; i < len; ++i) {
                component = this.components[i];
                var area = component.getArea();
                var centroid = component.getCentroid(true);
                if (isNaN(area) || isNaN(centroid.x) || isNaN(centroid.y)) {
                    continue;
                }
                areas.push(area);
                areaSum += area;
                minArea = area < minArea && area > 0 ? area : minArea;
                centroids.push(centroid);
            }
            len = areas.length;
            if (areaSum === 0) {
                // all the components in this collection have 0 area
                // probably a collection of points -- weight all the points the same
                for (var i = 0; i < len; ++i) {
                    areas[i] = 1;
                }
                areaSum = areas.length;
            } else {
                // normalize all the areas where the smallest area will get
                // a value of 1
                for (var i = 0; i < len; ++i) {
                    areas[i] /= minArea;
                }
                areaSum /= minArea;
            }

            var xSum = 0,
                ySum = 0,
                centroid,
                area;
            for (var i = 0; i < len; ++i) {
                centroid = centroids[i];
                area = areas[i];
                xSum += centroid.x * area;
                ySum += centroid.y * area;
            }

            return new _Point2["default"](xSum / areaSum, ySum / areaSum);
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.move
         * @description  沿着x、y轴的正方向上按照给定的位移移动几何图形，move 不仅改变了几何图形的位置并且清理了边界缓存。
         * @param x -{number} x轴正方向上移动的距离。
         * @param y - {number} y轴正方向上移动的距离。
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            for (var i = 0, len = this.components.length; i < len; i++) {
                this.components[i].move(x, y);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.rotate
         * @description 围绕中心点旋转几何图形。
         * @param angle -{number} 旋转角的度数（沿着x轴正方向逆时针测量）。
         * @param origin - {SuperMap.Geometry.Point} 旋转中心点。
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            for (var i = 0, len = this.components.length; i < len; ++i) {
                this.components[i].rotate(angle, origin);
            }
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.resize
         * @description  调整几何对象大小。
         * @param scale - {number} 几何图形缩放的比例系数，是几何图形维数的两倍。（如，对于线来说将以线2倍的长度拉长，对于多边形来说，将以面积的4倍变化）。
         * @param origin - {SuperMap.Geometry.Point} 调整大小选定的起始原点。
         * @param ratio - {number} 可选的xy的比例，默认的比例为1。
         * @returns {SuperMap.Geometry} 几何图形。
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            for (var i = 0; i < this.components.length; ++i) {
                this.components[i].resize(scale, origin, ratio);
            }
            return this;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标几何图形。
         * @param options - {Object} 距离计算需要设置的可选属性。有效的选项取决于特定的几何类型。<br>
         *        details - {boolean} 返回距离计算的细节。默认为false。<br>
         *        edge - {boolean} 计算一个几何图形到目标几何图形边缘的最近距离。默认为true。
         *                         如果设为true，一个几何图形完全包含在目标几何图形中时，调用distanceTo返回非零结果，
         *                         如果false，两个几何图形相交情况下调用distanceTo结果返回0，而且如果false，将不返距离值。
         * @returns {(number | Object)} 返回一个几何图形到目标几何图形的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var result, best, distance;
            var min = Number.POSITIVE_INFINITY;
            for (var i = 0, len = this.components.length; i < len; ++i) {
                result = this.components[i].distanceTo(geometry, options);
                distance = details ? result.distance : result;
                if (distance < min) {
                    min = distance;
                    best = result;
                    if (min == 0) {
                        break;
                    }
                }
            }
            return best;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.equals
         * @description 判断两个几何图形是否相等。如果所有的 components 具有相同的坐标，则认为是相等的。
         * @param geometry - {SuperMap.Geometry} 需要判断的几何图形。
         * @returns {boolean} 输入的几何图形与当前几何图形是否相等。
         */

    }, {
        key: 'equals',
        value: function equals(geometry) {
            var equivalent = true;
            if (!geometry || !geometry.CLASS_NAME || this.CLASS_NAME !== geometry.CLASS_NAME) {
                equivalent = false;
            } else if (!_Util.Util.isArray(geometry.components) || geometry.components.length !== this.components.length) {
                equivalent = false;
            } else {
                for (var i = 0, len = this.components.length; i < len; ++i) {
                    if (!this.components[i].equals(geometry.components[i])) {
                        equivalent = false;
                        break;
                    }
                }
            }
            return equivalent;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.intersects
         * @description 判断输入的几何对象是否与当前几何对象相交。
         * @param geometry - {SuperMap.Geometry} 任意的几何类型。
         * @returns {boolean} 输入几何对象与当前几何对象相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            for (var i = 0, len = this.components.length; i < len; ++i) {
                intersect = geometry.intersects(this.components[i]);
                if (intersect) {
                    break;
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Collection.prototype.getVertices
         * @description 返回几何对象的所有结点的列表。
         * @param nodes - {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices = [];
            for (var i = 0, len = this.components.length; i < len; ++i) {
                Array.prototype.push.apply(vertices, this.components[i].getVertices(nodes));
            }
            return vertices;
        }
    }]);

    return Collection;
}(_Geometry3["default"]);

exports["default"] = Collection;

_SuperMap2["default"].Geometry.Collection = Collection;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(102);

var _Theme3 = _interopRequireDefault(_Theme2);

__webpack_require__(372);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Feature.Theme.Graph
 * @classdesc 统计专题要素基类。
 * @description 此类定义了统计专题要素基础模型，具体的图表模型通过继承此类，在子类中实现 assembleShapes 方法。
 *              统计专题要素模型采用了可视化图形大小自适应策略，用较少的参数控制着图表诸多图形，图表配置对象 <SuperMap.Feature.Theme.Graph::setting> 的基础属性只有 7 个，
 *              它们控制着图表结构、值域范围、数据小数位等基础图表形态。构成图表的图形必须在图表结构里自适应大小。
 *              此类不可实例化，此类的可实例化子类必须实现 assembleShapes() 方法。
 * @extends SuperMap.Feature.Theme
 * @param data - {SuperMap.Feature.Vector}  用户数据，必设参数。
 * @param layer - {SuperMap.Layer.Theme} 此专题要素所在图层，必设参数。
 * @param fields - {Array<string>} data 中的参与此图表生成的字段名称，必设参数。
 * @param setting - {Object} 图表配置对象，必设参数。
 * @param lonlat - {SuperMap.LonLat} 专题要素地理位置。默认为 data 指代的地理要素 Bounds 中心。
 * @return {SuperMap.Feature.Theme.Graph} 返回一个统计专题要素。
 */
var Graph = function (_Theme) {
    _inherits(Graph, _Theme);

    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.fields - {Array<string>}
     * @description 数据{SuperMap.Feature.Vector}属性字段。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBHeight - {number}{ReadOnly}
     * @description 数据视图框高度。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBOrigonPoint - {Array<number>} {ReadOnly}
     * @description 数据视图框原点，数据视图框左上角点，长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBCenterPoint - {Array<number>} {ReadOnly}
     * @description 数据视图框中心点，长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.dataViewBox - {Array<number>} {ReadOnly}
     * @description 数据视图框，长度为 4 的一维数组，[left, bottom, right, top]。
     *              dataViewBox 是统计专题要素最核心的内容，它负责解释数据在一个像素区域里的数据可视化含义，
     *              这种含义用可视化图形表达出来，这些表示数据的图形和一些辅助图形组合在一起构成统计专题图表。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.YOffset - {number}{ReadOnly}
     * @description 专题要素（图表）在 Y 方向上的偏移值，单位像素。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.height - {number}{ReadOnly}
     * @description 专题要素（图表）高度 ，必设属性。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.chartBounds - {SuperMap.Bounds} {ReadOnly}
     * @description 图表 Bounds 随着 lonlat、XOffset、YOffset 更新，注意 chartBounds 是图表像素范围，不是地理范围。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.origonPoint - {Array<number>} {ReadOnly}
     * @description 专题要素（图表）原点，图表左上角点像素坐标，是长度为 2 的一维数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.RelativeCoordinate -{bool}
     * @description 图形是否已经计算了相对坐标。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.shapeFactory -{SuperMap.Feature.ShapeFactory}
     * @description 内置的图形工厂对象，调用其 createShape 方法创建图形。
     */
    function Graph(data, layer, fields, setting, lonlat, options) {
        _classCallCheck(this, Graph);

        var _this = _possibleConstructorReturn(this, (Graph.__proto__ || Object.getPrototypeOf(Graph)).call(this, data, layer, fields, setting, lonlat, options));

        _this.shapeFactory = null;
        _this.shapeParameters = null;
        _this.RelativeCoordinate = false;
        _this.setting = null;
        _this.origonPoint = null;
        _this.chartBox = null;
        _this.chartBounds = null;
        _this.width = null;
        _this.height = null;
        _this.XOffset = 0;
        _this.YOffset = 0;
        _this.DVBParameter = null;
        _this.dataViewBox = null;
        _this.DVBCodomain = null;
        _this.DVBCenterPoint = null;
        _this.DVBUnitValue = null;
        _this.DVBOrigonPoint = null;
        _this.DVBWidth = null;
        _this.DVBHeight = null;
        _this.origonPointOffset = null;
        _this.fields = null;
        _this.dataValues = null;
        _this.CLASS_NAME = "SuperMap.Feature.Theme.Graph";

        var me = _this;
        // 图表位置
        if (lonlat) {
            me.lonlat = lonlat;
        } else {
            // 默认使用 bounds 中心
            var geometry = data.geometry;
            var dataBounds = geometry.getBounds();
            me.lonlat = dataBounds.getCenterLonLat();
        }

        // 配置项检测与赋值
        if (setting && setting.width && setting.height && setting.codomain) {
            me.setting = setting;
        }

        me.fields = fields ? fields : [];

        me.shapeFactory = new _SuperMap2["default"].Feature.ShapeFactory();
        return _this;
    }

    /**
     * @function SuperMap.Feature.Theme.Graph.prototype.destroy
     * @description 销毁专题要素。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.dataValues {Array<number>}
     * @description 图表展示的数据值，通过 fields 从数据feature属性中获得。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.origonPointOffset - {Array<number>} {ReadOnly}
     * @description 数据视图框原点相对于图表框的原点偏移量，长度为 2 的一维数组，第一个元素表示 x 偏移量，第二个元素表示 y 偏移量。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBWidth - {number}{ReadOnly}
     * @description 数据视图框宽度。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBUnitValue - {string} {ReadOnly}
     * @description 单位值。在 assembleShapes() 中初始化其具体意义，例如：饼图的 DVBUnitValue 可以定义为"360/数据总和"，
     *              折线图的 DVBUnitValue 可以定义为 "DVBCodomain/DVBHeight"。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBCodomain - {Array<number>} {ReadOnly}
     * @description 数据视图框的内允许展示的数据值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限。
     *              dataViewBox 中允许的数据范围，对数据溢出值域范围情况的处理需要在 assembleShapes 中进行。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.DVBParameter - {Array<number>} {ReadOnly}
     * @description 数据视图框参数，长度为 4 的一维数组（数组元素值 >= 0），[leftOffset, bottomOffset, rightOffset, topOffset]，chartBox 内偏距值。
     *               此属性用于指定数据视图框 dataViewBox 的范围。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.XOffset - {number}{ReadOnly}
     * @description 专题要素（图表）在 X 方向上的偏移值，单位像素。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.width - {number}{ReadOnly}
     * @description 专题要素（图表）宽度 ，必设属性。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.chartBox - {Array<number>} {ReadOnly}
     * @description 专题要素（图表）区域，即图表框，长度为 4 的一维数组，数组的 4 个元素依次表示图表框左端 x 坐标值、
     *              下端 y坐标值、 右端 x坐标值、 上端 y 坐标值；[left, bottom, right, top]。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.setting -{Object}
     * @description 图表配置对象，该对象控制着图表的可视化显示。<br>
     *              下面是此配置对象的 7 个基础可设属性：<br>
     *              Symbolizer properties:<br>
     *              width - {number}专题要素（图表）宽度，必设参数。<br>
     *              height - {number}专题要素（图表）高度，必设参数。<br>
     *              codomain - {Array<number>} 值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限，必设参数。<br>
     *              XOffset - {number}  专题要素（图表）在 X 方向上的偏移值，单位像素。<br>
     *              YOffset - {number}  专题要素（图表）在 Y 方向上的偏移值，单位像素。<br>
     *              dataViewBoxParameter - {Array<number>} 数据视图框 dataViewBox 参数，它是指图表框 chartBox
     *                                                    （由图表位置、图表宽度、图表高度构成的图表范围框）在左、下，右，上四个方向上的内偏距值。<br>
     *              decimalNumber - {number}数据值数组 dataValues 元素值小数位数，数据的小数位处理参数，取值范围：[0, 16]。
     *                                       如果不设置此参数，在取数据值时不对数据做小数位处理。<br>
     *              除了以上 7 个基础属性，此对象的可设属性在不同子类中有较大差异，不同子类中对同一属性的解释也可能不同。
     *              请在此类的子类中查看 setting 对象的可设属性和属性含义。
     */


    /**
     * @member SuperMap.Feature.Theme.Graph.prototype.shapeParameters -{Object}
     * @description 当前图形参数对象，<SuperMap.Feature.ShapeParameters> 的子类对象。
     */


    _createClass(Graph, [{
        key: 'destroy',
        value: function destroy() {
            this.shapeFactory = null;
            this.shapeParameters = null;
            this.width = null;
            this.height = null;
            this.origonPoint = null;
            this.chartBox = null;
            this.dataViewBox = null;
            this.chartBounds = null;
            this.DVBParameter = null;
            this.DVBOrigonPoint = null;
            this.DVBCenterPoint = null;
            this.DVBWidth = null;
            this.DVBHeight = null;
            this.DVBCodomain = null;
            this.DVBUnitValue = null;
            this.origonPointOffset = null;
            this.XOffset = null;
            this.YOffset = null;
            this.fields = null;
            this.dataValues = null;
            this.setting = null;
            _get(Graph.prototype.__proto__ || Object.getPrototypeOf(Graph.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.initBaseParameter
         * @description 初始化专题要素（图表）基础参数。在调用此方法前，此类的图表模型相关属性都是不可用的 ，此方法在 assembleShapes 函数中调用。<br>
         *              调用此函数关系到 setting 对象的以下属性。<br>
         *              width - {number} 专题要素（图表）宽度，必设参数。<br>
         *              height - {number} 专题要素（图表）高度，必设参数。<br>
         *              codomain - {Array<number>} 值域，长度为 2 的一维数组，第一个元素表示值域下限，第二个元素表示值域上限，必设参数。<br>
         *              XOffset - {number} 专题要素（图表）在 X 方向上的偏移值，单位像素。<br>
         *              YOffset - {number} 专题要素（图表）在 Y 方向上的偏移值，单位像素。<br>
         *              dataViewBoxParameter - {Array<number>} 数据视图框 dataViewBox 参数，它是指图表框 chartBox。<br>
         *                                     （由图表位置、图表宽度、图表高度构成的图表范围框）在左、下，右，上四个方向上的内偏距值。<br>
         *              decimalNumber - {number} 数据值数组 dataValues 元素值小数位数，数据的小数位处理参数，取值范围：[0 16]。如果不设置此参数，在取数据值时不对数据做小数位处理。
         * @return {Boolean} 初始化参数是否成功。
         */

    }, {
        key: 'initBaseParameter',
        value: function initBaseParameter() {
            // 参数初始化是否成功
            var isSuccess = true;

            // setting 属性是否已成功赋值
            if (!this.setting) {
                return false;
            }
            var sets = this.setting;
            // 检测 setting 的必设参数
            if (!(sets.width && sets.height && sets.codomain)) {
                return false;
            }

            // 数据
            var decimalNumber = typeof sets.decimalNumber !== "undefined" && !isNaN(sets.decimalNumber) ? sets.decimalNumber : -1;
            var dataEffective = _SuperMap2["default"].Feature.Theme.getDataValues(this.data, this.fields, decimalNumber);
            this.dataValues = dataEffective ? dataEffective : [];

            // 基础参数  width, height, codomain
            this.width = parseFloat(sets.width);
            this.height = parseFloat(sets.height);
            this.DVBCodomain = sets.codomain;

            // 图表偏移
            // if(sets.XOffset) {this.XOffset = sets.XOffset};
            // if(sets.YOffset) {this.YOffset = sets.YOffset};
            this.XOffset = sets.XOffset ? sets.XOffset : 0;
            this.YOffset = sets.YOffset ? sets.YOffset : 0;

            // 其他默认值
            this.origonPoint = [];
            this.chartBox = [];
            this.dataViewBox = [];

            this.DVBParameter = sets.dataViewBoxParameter ? sets.dataViewBoxParameter : [0, 0, 0, 0];

            this.DVBOrigonPoint = [];
            this.DVBCenterPoint = [];
            this.origonPointOffset = [];

            // 图表位置
            this.resetLocation();

            // 专题要素宽度 w
            var w = this.width;
            // 专题要素高度 h
            var h = this.height;
            // 专题要素像素位置 loc
            var loc = this.location;

            // 专题要素像素位置 loc
            this.origonPoint = [loc[0] - w / 2, loc[1] - h / 2];
            // 专题要素原点（左上角）
            var op = this.origonPoint;

            // 图表框（[left, bottom, right, top]）
            this.chartBox = [op[0], op[1] + h, op[0] + w, op[1]];
            // 图表框
            var cb = this.chartBox;

            // 数据视图框参数，它是图表框各方向对应的内偏距
            var dbbP = this.DVBParameter;
            // 数据视图框 （[left, bottom, right, top]）
            this.dataViewBox = [cb[0] + dbbP[0], cb[1] - dbbP[1], cb[2] - dbbP[2], cb[3] + dbbP[3]];
            // 数据视图框
            var dvb = this.dataViewBox;
            //检查数据视图框是否合法
            if (dvb[0] >= dvb[2] || dvb[1] <= dvb[3]) {
                return false;
            }

            // 数据视图框原点
            this.DVBOrigonPoint = [dvb[0], dvb[3]];
            // 数据视图框宽度
            this.DVBWidth = Math.abs(dvb[2] - dvb[0]);
            // 数据视图框高度
            this.DVBHeight = Math.abs(dvb[1] - dvb[3]);
            // 数据视图框中心点
            this.DVBCenterPoint = [this.DVBOrigonPoint[0] + this.DVBWidth / 2, this.DVBOrigonPoint[1] + this.DVBHeight / 2];

            // 数据视图框原点与图表框的原点偏移量
            this.origonPointOffset = [this.DVBOrigonPoint[0] - op[0], this.DVBOrigonPoint[1] - op[1]];

            return isSuccess;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.resetLocation
         * @description 根据地理位置 lonlat 重置专题要素（图表）位置。
         * @param lonlat - {SuperMap.LonLat} 专题要素新的像素中心位置。
         * @return {Array<number>} - 新专题要素像素参考位置。长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */

    }, {
        key: 'resetLocation',
        value: function resetLocation(lonlat) {
            if (lonlat) this.lonlat = lonlat;

            // 获取地理位置对应的像素坐标 newLocalLX
            var newLocalLX = this.getLocalXY(this.lonlat);
            // 处理偏移量 XOffset, YOffset
            newLocalLX[0] += this.XOffset;
            newLocalLX[1] += this.YOffset;
            // 将图形位置赋予  location 属性（注意 location 属性表示的是专题要素中心位置）
            this.location = newLocalLX;

            // 更新图表像素 Bounds
            var w = this.width;
            var h = this.height;
            var loc = this.location;
            this.chartBounds = new _SuperMap2["default"].Bounds(loc[0] - w / 2, loc[1] + h / 2, loc[0] + w / 2, loc[1] - h / 2);

            //重新计算当前渐变色
            this.resetLinearGradient();

            return loc;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.resetLinearGradient
         * @description resetLocation中调用 图表的相对坐标存在的时候，重新计算渐变的颜色。(目前用于二维柱状图渐变色 所以子类实现此方法)
         */

    }, {
        key: 'resetLinearGradient',
        value: function resetLinearGradient() {}
        //子类实现此方法


        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.shapesConvertToRelativeCoordinate
         * @description 将（构成图表）图形的节点转为相对坐标表示，此函数必须且只能在 assembleShapes() 结束时调用。
         */

    }, {
        key: 'shapesConvertToRelativeCoordinate',
        value: function shapesConvertToRelativeCoordinate() {
            var shapes = this.shapes;
            var shapeROP = this.location;
            for (var i = 0, len = shapes.length; i < len; i++) {
                shapes[i].refOriginalPosition = shapeROP;

                var style = shapes[i].style;

                for (var sty in style) {
                    switch (sty) {
                        case "pointList":
                            var pl = style[sty];
                            for (var j = 0, len2 = pl.length; j < len2; j++) {
                                pl[j][0] -= shapeROP[0];
                                pl[j][1] -= shapeROP[1];
                            }
                            break;
                        case "x":
                            style[sty] -= shapeROP[0];
                            break;
                        case "y":
                            style[sty] -= shapeROP[1];
                            break;
                        default:
                            break;
                    }
                }
            }
            this.RelativeCoordinate = true;
        }

        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.assembleShapes
         * @description 图形装配函数。抽象方法，可视化子类必须实现此方法。<br>
         *              重写此方法的步骤：<br>
         *              1. 图表的某些特殊配置项（setting）处理，例如多数图表模型需要重新指定 dataViewBoxParameter 的默认值。<br>
         *              2. 调用 initBaseParameter() 方法初始化模型属性值，此步骤必须执行，只有当 initBaseParameter 返回 true 时才可以允许进行后续步骤。<br>
         *              3. 计算图形参数，制作图形，图形组合。在组装图表过程中，应该特别注意数据视图框单位值的定义、数据值溢出值域范围的处理和图形大小自适应。<br>
         *              4. 调用 shapesConvertToRelativeCoordinate() 方法，将图形的坐标值转为相对坐标，此步骤必须执行。
         * @example
         *  //子类实现 assembleShapes() 接口的步骤示例：
         *  assembleShapes: function(){
         *    // 第一步：图表的某些特殊配置项（setting）处理，例如多数图表模型需要重新指定 dataViewBoxParameter 的默认值。此步骤是非必须过程。
         *
         *    // 图表配置对象
         *    var sets = this.setting;
         *    // 默认数据视图框，这里展示在使用坐标轴和不使用坐标轴情况下对数据视图框参数赋予不同的默认值
         *    if(!sets.dataViewBoxParameter){
         *          if(typeof(sets.useAxis) === "undefined" || sets.useAxis){
         *              sets.dataViewBoxParameter = [45 15 15 15];
         *          }
         *          else{
         *                  sets.dataViewBoxParameter = [5 5 5 5];
         *          }
         *    }
         *
         *    // 第二步：初始化图表模型基本参数，只有在图表模型基本参数初始化成功时才可模型相关属性，如 this.dataViewBox、 this.DVBCodomain等。此步骤是必须过程。
         *    if(!this.initBaseParameter()) return;
         *
         *    // 第三步：用图形组装图表，在组装图表过程中，应该特别注意数据视图框单位值的定义、数据值溢出值域范围的处理和图形大小自适应。
         *    // 定义图表数据视图框中单位值的含义，下面行代码表示将数据视图框单位值定义为数据视图框高度上每像素代表的数据值
         *    this.DVBUnitValue =  (this.codomain[1] - this.codomain[0])/this.DVBHeight;
         *    var uv = this.DVBUnitValue;
         *
         *    // 图形参数计算代码......
         *
         *    // 关于图形装配，实际上就是利用图形工程对象 this.shapeFactory 的 createShape() 方法通过图形参数对象创建可视化的图形对象，并把这些图形对象按序添加到模型的图形库（his.shapes）中。下面的代码演示创建一个面图形参数对象，并允许通过图形配置对象设置图形的 style 和 highlightStyle，
         *    var barParams = new SuperMap.Feature.ShapeParameters.Polygon(poiLists);
         *    barParams.style = sets.barStyle? sets.barStyle:{fillColor: "lightblue"};
         *    barParams.highlightStyle = sets.barHoverStyle? sets.barHoverStyle:{fillColor: "blue"};
         *    // 图形携带数据ID信息
         *    barParams.refDataID = this.data.id;
         *    // 创建图形并添加到图表图形数组中
         *    this.shapes.push(this.shapeFactory.createShape(barParams));
         *
         *    // 第四步：调用 shapesConvertToRelativeCoordinate() 方法，将图形库（his.shapes）中的图形转为由相对坐标表示的图形，客户端统计专题图模块从结构上要求可视化图形使用相对坐标，assembleShapes() 函数必须在图形装配完成后调用 shapesConvertToRelativeCoordinate() 函数。此步骤是必须过程。
         *    this.shapesConvertToRelativeCoordinate();
         * }
         */

    }, {
        key: 'assembleShapes',
        value: function assembleShapes() {}
        //子类必须实现此方法


        /**
         * @function SuperMap.Feature.Theme.Graph.prototype.getLocalXY
         * @description 地理坐标转为像素坐标。
         * @param lonlat - {SuperMap.Lonlat} 带转换的地理坐标。
         * @return 屏幕像素坐标。
         */

    }, {
        key: 'getLocalXY',
        value: function getLocalXY(lonlat) {
            return this.layer.getLocalXY(lonlat);
        }
    }]);

    return Graph;
}(_Theme3["default"]);

/**
 * @function SuperMap.Feature.Theme.getDataValues
 * @description 根据字段名数组获取指定数据（feature）的属性值数组。属性值类型必须为 Number。
 * @param data - {SuperMap.Feature.Vector} 数据。
 * @param fields - {Array<string>} 字段名数组。
 * @param decimalNumber - {number} 小数位处理参数，对获取到的属性数据值进行小数位处理。
 * @return {Array<string>} 字段名数组对应的属性数据值数组。
 */


exports["default"] = Graph;
_SuperMap2["default"].Feature.Theme.getDataValues = function (data, fields, decimalNumber) {
    if (!data.attributes) return false;

    var fieldsValue = [];

    var attrs = data.attributes;
    for (var i = 0; i < fields.length; i++) {
        for (var field in attrs) {
            if (field !== fields[i]) {
                continue;
            }
            // 数字转换判断
            try {
                if (!isNaN(decimalNumber) && decimalNumber >= 0) {
                    fieldsValue.push(parseFloat(attrs[field].toString()).toFixed(decimalNumber));
                } else {
                    fieldsValue.push(parseFloat(attrs[field].toString()));
                }
            } catch (e) {
                throw new Error("not a number");
            }
        }
    }

    if (fieldsValue.length === fields.length) {
        return fieldsValue;
    } else {
        return false;
    }
};
_SuperMap2["default"].Feature.Theme.Graph = Graph;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServerInfo = __webpack_require__(402);

var _ServerInfo2 = _interopRequireDefault(_ServerInfo);

var _TokenServiceParameter = __webpack_require__(403);

var _TokenServiceParameter2 = _interopRequireDefault(_TokenServiceParameter);

var _KeyServiceParameter = __webpack_require__(401);

var _KeyServiceParameter2 = _interopRequireDefault(_KeyServiceParameter);

var _FetchRequest = __webpack_require__(15);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @name SecurityManager
 * @memberOf SuperMap
 * @namespace
 * @description 安全管理中心，提供iServer,iPortal,Online统一权限认证管理
 *  > 使用说明：
 *  > 创建任何一个服务之前调用{@link SuperMap.SecurityManager.registerToken}或
 *  > {@link SuperMap.SecurityManager.registerKey}注册凭据。
 *  > 发送请求时根据url或者服务id获取相应的key或者token并自动添加到服务地址中
 */
_SuperMap2["default"].SecurityManager = {

    INNER_WINDOW_WIDTH: 600,
    INNER_WINDOW_HEIGHT: 600,
    /**
     * @description 从服务器获取一个token,在此之前要注册服务器信息
     * @param url {string}-服务器域名+端口，如：http://localhost:8092
     * @param tokenParam -{SuperMap.TokenServiceParameter} token申请参数
     * @return {Promise}
     */
    generateToken: function generateToken(url, tokenParam) {
        var serverInfo = this.servers[url];
        if (!serverInfo) {
            return;
        }
        return _FetchRequest.FetchRequest.post(serverInfo.tokenServiceUrl, JSON.stringify(tokenParam.toJSON())).then(function (response) {
            return response.text();
        });
    },

    /**
     * @description 注册安全服务器相关信息
     * @param serverInfos -{SuperMap.ServerInfo} 服务器信息
     */
    registerServers: function registerServers(serverInfos) {
        this.servers = this.servers || {};
        if (!_SuperMap2["default"].Util.isArray(serverInfos)) {
            serverInfos = [serverInfos];
        }
        for (var i = 0; i < serverInfos.length; i++) {
            var serverInfo = serverInfos[i];
            this.servers[serverInfo.server] = serverInfo;
        }
    },

    /**
     * @description 服务请求都会自动带上这个token
     * @param url {string} -服务器域名+端口：如http://localhost:8090
     * @param token -{string} token
     */
    registerToken: function registerToken(url, token) {
        this.tokens = this.tokens || {};
        if (!url || !token) {
            return;
        }
        var domain = this._getTokenStorageKey(url);
        this.tokens[domain] = token;
    },

    /**
     * @description 注册key,ids为数组(存在一个key对应多个服务)
     * @param ids -{Array} 可以是服务id数组或者url地址数组或者webAPI类型数组
     * @param key -{string} key
     */
    registerKey: function registerKey(ids, key) {
        this.keys = this.keys || {};
        if (!ids || ids.length < 1 || !key) {
            return;
        }

        ids = _SuperMap2["default"].Util.isArray(ids) ? ids : [ids];
        for (var i = 0; i < ids.length; i++) {
            var id = this._getUrlRestString(ids[0]) || ids[0];
            this.keys[id] = key;
        }
    },

    /**
     * @description 获取服务器信息
     * @param url {string}-服务器域名+端口，如：http://localhost:8092
     * @returns {SuperMap.ServerInfo} 服务器信息
     */
    getServerInfo: function getServerInfo(url) {
        this.servers = this.servers || {};
        return this.servers[url];
    },

    /**
     * @description 根据Url获取token
     * @param url -{string} 服务器域名+端口，如：http://localhost:8092
     * @returns {string} token
     */
    getToken: function getToken(url) {
        if (!url) {
            return;
        }
        this.tokens = this.tokens || {};
        var domain = this._getTokenStorageKey(url);
        return this.tokens[domain];
    },

    /**
     * @description 根据Url获取key
     * @param id -{string} id
     * @returns {string} key
     */
    getKey: function getKey(id) {
        this.keys = this.keys || {};
        var key = this._getUrlRestString(id) || id;
        return this.keys[key];
    },

    /**
     * @description Online登录验证
     * @param callbackLocation -{string} 跳转位置
     * @param newTab -{boolean}是否新窗口打开
     */
    loginOnline: function loginOnline(callbackLocation, newTab) {
        var loginUrl = _SuperMap2["default"].SecurityManager.SSO + "/login?service=" + callbackLocation;
        this._open(loginUrl, newTab);
    },

    /**
     * @description iPortal登录验证
     * @param url -{string} iportal首页地址
     * @param username -{string} 用户名
     * @param password -{string} 密码
     * @returns {Promise}
     */
    loginiPortal: function loginiPortal(url, username, password) {
        var end = url.substr(url.length - 1, 1);
        url += end === "/" ? "web/login.json" : "/web/login.json";
        var loginInfo = {
            username: username && username.toString(),
            password: password && password.toString()
        };
        loginInfo = JSON.stringify(loginInfo);
        var requestOptions = {
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            withCredentials: true
        };
        return _FetchRequest.FetchRequest.post(url, loginInfo, requestOptions).then(function (response) {
            return response.json();
        });
    },

    /**
     * @description iPortal登录验证
     * @param url -{string} iportal首页地址
     * @returns {Promise}
     */
    logoutiPortal: function logoutiPortal(url) {
        var end = url.substr(url.length - 1, 1);
        url += end === "/" ? "services/security/logout" : "/services/security/logout";

        var requestOptions = {
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            withCredentials: true,
            withoutFormatSuffix: true
        };
        return _FetchRequest.FetchRequest.get(url, "", requestOptions).then(function () {
            return true;
        })["catch"](function () {
            return false;
        });
    },

    /**
     * @description iManager登录验证
     * @param url -{string} iManager地址。<br>
     *                      地址参数为iManager首页地址，如： http://localhost:8390/imanager<br>
     * @param loginInfoParams -{Object} iManager 登录参数<br>
     *        userName -{string} 用户名<br>
     *        password-{string} 密码
     * @param options -{Object} <br>
     *        isNewTab -{boolean} 不同域时是否在新窗口打开登录页面
     * @return {Promise}
     */
    loginManager: function loginManager(url, loginInfoParams, options) {
        if (!_SuperMap2["default"].Util.isInTheSameDomain(url)) {
            var isNewTab = options ? options.isNewTab : true;
            this._open(url, isNewTab);
            return;
        }
        var end = url.substr(url.length - 1, 1);
        var requestUrl = end === "/" ? url + "icloud/security/tokens.json" : url + "/icloud/security/tokens.json";
        var params = loginInfoParams || {};
        var loginInfo = {
            username: params.userName && params.userName.toString(),
            password: params.password && params.password.toString()
        };
        loginInfo = JSON.stringify(loginInfo);
        var requestOptions = {
            headers: {
                'Accept': '*/*',
                'Content-Type': 'application/json'
            }
        };
        var me = this;
        return _FetchRequest.FetchRequest.post(requestUrl, loginInfo, requestOptions).then(function (response) {
            response.text().then(function (result) {
                me.imanagerToken = result;
                return result;
            });
        });
    },

    /**
     * @description 清空全部验证信息
     */
    destroyAllCredentials: function destroyAllCredentials() {
        this.keys = null;
        this.tokens = null;
        this.servers = null;
    },
    /**
     * @description 清空令牌信息
     */
    destroyToken: function destroyToken(url) {
        if (!url) {
            return;
        }
        var domain = this._getTokenStorageKey(url);
        this.tokens = this.tokens || {};
        if (this.tokens[domain]) {
            delete this.tokens[domain];
        }
    },
    /**
     * @description 清空服务授权码
     */
    destroyKey: function destroyKey(id) {
        if (!id) {
            return;
        }
        this.keys = this.keys || {};
        var key = this._getUrlRestString(id) || id;
        if (this.keys[key]) {
            delete this.keys[key];
        }
    },

    _open: function _open(url, newTab) {
        newTab = newTab != null ? newTab : true;
        var offsetX = window.screen.availWidth / 2 - this.INNER_WINDOW_WIDTH / 2;
        var offsetY = window.screen.availHeight / 2 - this.INNER_WINDOW_HEIGHT / 2;
        var options = "height=" + this.INNER_WINDOW_HEIGHT + ", width=" + this.INNER_WINDOW_WIDTH + ",top=" + offsetY + ", left=" + offsetX + ",toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no";
        if (newTab) {
            window.open(url, 'login');
        } else {
            window.open(url, 'login', options);
        }
    },

    _getTokenStorageKey: function _getTokenStorageKey(url) {
        var patten = /(.*?):\/\/([^\/]+)/i;
        var result = url.match(patten);
        if (!result) {
            return url;
        }
        return result[0];
    },

    _getUrlRestString: function _getUrlRestString(url) {
        if (!url) {
            return url;
        }
        var patten = /http:\/\/(.*\/rest)/i;
        var result = url.match(patten);
        if (!result) {
            return url;
        }
        return result[0];
    }

};
_SuperMap2["default"].SecurityManager.SSO = "https://sso.supermap.com";
_SuperMap2["default"].SecurityManager.ONLINE = "http://www.supermapol.com";

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

__webpack_require__(4);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class L.supermap.CommontypesConversion
 * @classdesc Leaflet对象和SuperMap对象转换工具
 */
var CommontypesConversion = function () {
    function CommontypesConversion() {
        _classCallCheck(this, CommontypesConversion);
    }

    _createClass(CommontypesConversion, null, [{
        key: 'toSuperMapBounds',

        /**
         * @function L.supermap.CommontypesConversion.toSuperMapBounds
         * @description 将Leaflet对象得bounds转成SuperMap 的bounds对象
         * @param bounds - {L.Bounds|L.LatLngBounds} 图层显示范围
         * @return {SuperMap.Bounds} SuperMap的bounds对象
         */
        value: function toSuperMapBounds(bounds) {
            if (bounds instanceof _leaflet2["default"].LatLngBounds) {
                return new _SuperMap2["default"].Bounds(bounds.getSouthWest().lng, bounds.getSouthWest().lat, bounds.getNorthEast().lng, bounds.getNorthEast().lat);
            }
            if (bounds instanceof _leaflet2["default"].Bounds) {
                return new _SuperMap2["default"].Bounds(bounds.min.x, bounds.min.y, bounds.max.x, bounds.max.y);
            }
            return new _SuperMap2["default"].Bounds();
        }
    }]);

    return CommontypesConversion;
}();

exports["default"] = CommontypesConversion;

_leaflet2["default"].supermap.CommontypesConversion = CommontypesConversion;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NormalizeScale = exports.GetResolutionFromScaleDpi = exports.getMeterPerMapUnit = exports.scaleToResolution = exports.resolutionToScale = exports.toSuperMapGeometry = exports.toGeoJSON = exports.supermap_callbacks = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

var _GeoJSON = __webpack_require__(9);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var supermap_callbacks = exports.supermap_callbacks = {};
_leaflet2["default"].Util.supermap_callbacks = supermap_callbacks;
var toGeoJSON = exports.toGeoJSON = function toGeoJSON(feature) {
    if (!feature) {
        return feature;
    }
    return JSON.parse(new _GeoJSON2["default"]().write(feature));
};
var toSuperMapGeometry = exports.toSuperMapGeometry = function toSuperMapGeometry(geometry) {
    if (!geometry) {
        return geometry;
    }
    var result,
        format = new _GeoJSON2["default"]();
    if (["FeatureCollection", "Feature", "Geometry"].indexOf(geometry.type) != -1) {
        result = format.read(geometry, geometry.type);
    } else if (typeof geometry.toGeoJSON === "function") {
        var geojson = geometry.toGeoJSON();
        result = geojson ? format.read(geojson, geojson.type) : geometry;
    }

    var serverResult = result;
    if (_leaflet2["default"].Util.isArray(result)) {
        if (result.length === 1) {
            serverResult = result[0];
        } else if (result.length > 1) {
            serverResult = [];
            result.map(function (item) {
                serverResult.push(item.geometry);
            });
        }
    }

    return serverResult && serverResult.geometry ? serverResult.geometry : serverResult;
};
var resolutionToScale = exports.resolutionToScale = function resolutionToScale(resolution, dpi, mapUnit) {
    var inchPerMeter = 1 / 0.0254;
    // 地球半径。
    var meterPerMapUnit = getMeterPerMapUnit(mapUnit);
    var scale = resolution * dpi * inchPerMeter * meterPerMapUnit;
    scale = 1 / scale;
    return scale;
};
var scaleToResolution = exports.scaleToResolution = function scaleToResolution(scale, dpi, mapUnit) {
    var inchPerMeter = 1 / 0.0254;
    var meterPerMapUnitValue = getMeterPerMapUnit(mapUnit);
    var resolution = scale * dpi * inchPerMeter * meterPerMapUnitValue;
    resolution = 1 / resolution;
    return resolution;
};
var getMeterPerMapUnit = exports.getMeterPerMapUnit = function getMeterPerMapUnit(mapUnit) {
    var earchRadiusInMeters = 6378137;
    var meterPerMapUnit;
    if (mapUnit === _SuperMap2["default"].Unit.METER) {
        meterPerMapUnit = 1;
    } else if (mapUnit === _SuperMap2["default"].Unit.DEGREE) {
        // 每度表示多少米。
        meterPerMapUnit = Math.PI * 2 * earchRadiusInMeters / 360;
    } else if (mapUnit === _SuperMap2["default"].Unit.KILOMETER) {
        meterPerMapUnit = 1.0E-3;
    } else if (mapUnit === _SuperMap2["default"].Unit.INCH) {
        meterPerMapUnit = 1 / 2.5399999918E-2;
    } else if (mapUnit === _SuperMap2["default"].Unit.FOOT) {
        meterPerMapUnit = 0.3048;
    } else {
        return meterPerMapUnit;
    }
    return meterPerMapUnit;
};
var GetResolutionFromScaleDpi = exports.GetResolutionFromScaleDpi = function GetResolutionFromScaleDpi(scale, dpi, coordUnit, datumAxis) {
    var resolution = null,
        ratio = 10000;
    //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。
    datumAxis = datumAxis || 6378137;
    coordUnit = coordUnit || "";
    if (scale > 0 && dpi > 0) {
        scale = _leaflet2["default"].Util.NormalizeScale(scale);
        if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
            //scale = SuperMap.Util.normalizeScale(scale);
            resolution = 0.0254 * ratio / dpi / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
            return resolution;
        } else {
            resolution = 0.0254 * ratio / dpi / scale / ratio;
            return resolution;
        }
    }
    return -1;
};
var NormalizeScale = exports.NormalizeScale = function NormalizeScale(scale) {
    return scale > 1.0 ? 1.0 / scale : scale;
};
_leaflet2["default"].Util.toGeoJSON = toGeoJSON;
_leaflet2["default"].Util.toSuperMapGeometry = toSuperMapGeometry;
_leaflet2["default"].Util.resolutionToScale = resolutionToScale;
_leaflet2["default"].Util.scaleToResolution = scaleToResolution;
_leaflet2["default"].Util.getMeterPerMapUnit = getMeterPerMapUnit;
_leaflet2["default"].Util.GetResolutionFromScaleDpi = GetResolutionFromScaleDpi;
_leaflet2["default"].Util.NormalizeScale = NormalizeScale;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _Collection = __webpack_require__(20);

var _Collection2 = _interopRequireDefault(_Collection);

var _Curve2 = __webpack_require__(173);

var _Curve3 = _interopRequireDefault(_Curve2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.LineString
 * @classdesc 几何对象线串类。
 * @param points - {Array<SuperMap.Geometry.Point>} 用来生成线串的点数组。
 * @extends {SuperMap.Geometry.Curve}
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *     new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *     new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *     new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *     new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var roadLine = new SuperMap.Geometry.LineString(points)；
 */
var LineString = function (_Curve) {
    _inherits(LineString, _Curve);

    function LineString(points) {
        _classCallCheck(this, LineString);

        var _this = _possibleConstructorReturn(this, (LineString.__proto__ || Object.getPrototypeOf(LineString)).call(this, points));

        _this.CLASS_NAME = "SuperMap.Geometry.LineString";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LineString.prototype.removeComponent
     * @description 只有在线串上有三个或更多的点的时候，才会允许移除点（否则结果将会是单一的点）。
     * @param point - {SuperMap.Geometry.Point} 将被删除的点。
     * @returns {boolean} 删除的点。
     */


    _createClass(LineString, [{
        key: 'removeComponent',
        value: function removeComponent(point) {
            var removed = this.components && this.components.length > 2;
            if (removed) {
                _Collection2["default"].prototype.removeComponent.apply(this, arguments);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.intersects
         * @description 判断两个几何图形是否相交。
         * @param geometry - {SuperMap.Geometry} 任意的几何类型。
         * @returns {boolean} 输入几何图形与当前几何图形是否相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            var type = geometry.CLASS_NAME;
            if (type === "SuperMap.Geometry.LineString" || type === "SuperMap.Geometry.LinearRing" || type === "SuperMap.Geometry.Point") {
                var segs1 = this.getSortedSegments();
                var segs2;
                if (type === "SuperMap.Geometry.Point") {
                    segs2 = [{
                        x1: geometry.x, y1: geometry.y,
                        x2: geometry.x, y2: geometry.y
                    }];
                } else {
                    segs2 = geometry.getSortedSegments();
                }
                var seg1, seg1x1, seg1x2, seg1y1, seg1y2, seg2, seg2y1, seg2y2;
                // sweep right
                outer: for (var i = 0, len = segs1.length; i < len; ++i) {
                    seg1 = segs1[i];
                    seg1x1 = seg1.x1;
                    seg1x2 = seg1.x2;
                    seg1y1 = seg1.y1;
                    seg1y2 = seg1.y2;
                    inner: for (var j = 0, jlen = segs2.length; j < jlen; ++j) {
                        seg2 = segs2[j];
                        if (seg2.x1 > seg1x2) {
                            // seg1 still left of seg2
                            break;
                        }
                        if (seg2.x2 < seg1x1) {
                            // seg2 still left of seg1
                            continue;
                        }
                        seg2y1 = seg2.y1;
                        seg2y2 = seg2.y2;
                        if (Math.min(seg2y1, seg2y2) > Math.max(seg1y1, seg1y2)) {
                            // seg2 above seg1
                            continue;
                        }
                        if (Math.max(seg2y1, seg2y2) < Math.min(seg1y1, seg1y2)) {
                            // seg2 below seg1
                            continue;
                        }
                        if (_SuperMap2["default"].Geometry.segmentsIntersect(seg1, seg2)) {
                            intersect = true;
                            break outer;
                        }
                    }
                }
            } else {
                intersect = geometry.intersects(this);
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getSortedSegments
         * @returns {Array} 分割对象的数组。分割对象有x1y1x2y2属性。起始点为x1y1，终点为x2y2。起始点与终点以增序排序。
         */

    }, {
        key: 'getSortedSegments',
        value: function getSortedSegments() {
            var numSeg = this.components.length - 1;
            var segments = new Array(numSeg),
                point1,
                point2;
            for (var i = 0; i < numSeg; ++i) {
                point1 = this.components[i];
                point2 = this.components[i + 1];
                if (point1.x < point2.x) {
                    segments[i] = {
                        x1: point1.x,
                        y1: point1.y,
                        x2: point2.x,
                        y2: point2.y
                    };
                } else {
                    segments[i] = {
                        x1: point2.x,
                        y1: point2.y,
                        x2: point1.x,
                        y2: point1.y
                    };
                }
            }

            // more efficient to define this somewhere static
            function byX1(seg1, seg2) {
                return seg1.x1 - seg2.x1;
            }

            return segments.sort(byX1);
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.splitWithSegment
         * @description 以给定的分割对象来分割几何对象。
         * @param seg - {Object} 分割对象。
         * @param options - {Object} 可选参数。<br>
         *         edge - {boolean} 当与边界相交的时候是否分割。默认为true。
         *         tolerance - {number} 容差。
         * @returns {Object} 一个带有lines和points属性的对象。
         */

    }, {
        key: 'splitWithSegment',
        value: function splitWithSegment(seg, options) {
            var edge = !(options && options.edge === false);
            var tolerance = options && options.tolerance;
            var lines = [];
            var verts = this.getVertices();
            var points = [];
            var intersections = [];
            var split = false;
            var vert1, vert2, point;
            var node, vertex, target;
            var interOptions = { point: true, tolerance: tolerance };
            var result = null;
            for (var i = 0, stop = verts.length - 2; i <= stop; ++i) {
                vert1 = verts[i];
                points.push(vert1.clone());
                vert2 = verts[i + 1];
                target = { x1: vert1.x, y1: vert1.y, x2: vert2.x, y2: vert2.y };
                point = _SuperMap2["default"].Geometry.segmentsIntersect(seg, target, interOptions);
                if (point instanceof _Point2["default"]) {
                    if (point.x === seg.x1 && point.y === seg.y1 || point.x === seg.x2 && point.y === seg.y2 || point.equals(vert1) || point.equals(vert2)) {
                        vertex = true;
                    } else {
                        vertex = false;
                    }
                    if (vertex || edge) {
                        // push intersections different than the previous
                        if (!point.equals(intersections[intersections.length - 1])) {
                            intersections.push(point.clone());
                        }
                        if (i === 0) {
                            if (point.equals(vert1)) {
                                continue;
                            }
                        }
                        if (point.equals(vert2)) {
                            continue;
                        }
                        split = true;
                        if (!point.equals(vert1)) {
                            points.push(point);
                        }
                        lines.push(new LineString(points));
                        points = [point.clone()];
                    }
                }
            }
            if (split) {
                points.push(vert2.clone());
                lines.push(new LineString(points));
            }
            if (intersections.length > 0) {
                // sort intersections along segment
                var xDir = seg.x1 < seg.x2 ? 1 : -1;
                var yDir = seg.y1 < seg.y2 ? 1 : -1;
                result = {
                    lines: lines,
                    points: intersections.sort(function (p1, p2) {
                        return xDir * p1.x - xDir * p2.x || yDir * p1.y - yDir * p2.y;
                    })
                };
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.split
         * @description 用一个几何对象去分割另外一个几何对象。
         * @param target - {SuperMap.Geometry} 目标几何对象.
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} 分割源几何对象，除了目标对象。默认是false。
         *         edge - {boolean} 当与边界相交的时候才允许分割，默认是true。
         *         tolerance - {number} 容差。
         * @returns {Array} 几何对象列表。
         */

    }, {
        key: 'split',
        value: function split(target, options) {
            var results = null;
            var mutual = options && options.mutual;
            var sourceSplit, targetSplit, sourceParts, targetParts;
            if (target instanceof LineString) {
                var verts = this.getVertices();
                var vert1, vert2, seg, splits, lines, point;
                var points = [];
                sourceParts = [];
                for (var i = 0, stop = verts.length - 2; i <= stop; ++i) {
                    vert1 = verts[i];
                    vert2 = verts[i + 1];
                    seg = {
                        x1: vert1.x, y1: vert1.y,
                        x2: vert2.x, y2: vert2.y
                    };
                    targetParts = targetParts || [target];
                    if (mutual) {
                        points.push(vert1.clone());
                    }
                    for (var j = 0; j < targetParts.length; ++j) {
                        splits = targetParts[j].splitWithSegment(seg, options);
                        if (splits) {
                            // splice in new features
                            lines = splits.lines;
                            if (lines.length > 0) {
                                lines.unshift(j, 1);
                                Array.prototype.splice.apply(targetParts, lines);
                                j += lines.length - 2;
                            }
                            if (mutual) {
                                for (var k = 0, len = splits.points.length; k < len; ++k) {
                                    point = splits.points[k];
                                    if (!point.equals(vert1)) {
                                        points.push(point);
                                        sourceParts.push(new LineString(points));
                                        if (point.equals(vert2)) {
                                            points = [];
                                        } else {
                                            points = [point.clone()];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (mutual && sourceParts.length > 0 && points.length > 0) {
                    points.push(vert2.clone());
                    sourceParts.push(new LineString(points));
                }
            } else {
                results = target.splitWith(this, options);
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetSplit || sourceSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.splitWith
         * @description 用几何对象分割另一个几何对象。
         * @param geometry - {SuperMap.Geometry} A geometry used to split this geometry (the source).
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} 分割源几何对象，除了目标对象。默认是false。
         *         edge - {boolean} 当与边界相交的时候才允许分割，默认是true。
         *         tolerance - {number} 容差。
         * @returns {Array} 几何对象数组。
         */

    }, {
        key: 'splitWith',
        value: function splitWith(geometry, options) {
            return geometry.split(this, options);
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表。
         * @param nodes - {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点
         * 如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            var vertices;
            if (nodes === true) {
                vertices = [this.components[0], this.components[this.components.length - 1]];
            } else if (nodes === false) {
                vertices = this.components.slice(1, this.components.length - 1);
            } else {
                vertices = this.components.slice();
            }
            return vertices;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。
         * @param geometry {SuperMap.Geometry} 目标几何图形。
         * @param options {Object}距离计算需要设置的可选属性。有效的选项取决于特定的几何类型。
         *         details - {boolean} 返回距离计算的细节，默认为false。
         *         edge - {boolean} 计算一个几何图形到目标几何图形边缘的最近距离，默认为true。 如果设为true，
         *                          一个几何图形完全包含在目标几何图形中时，调用distanceTo返回非零结果，如果false，两个几何图形相交情况下
         *                          调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何图形到目标几何图形的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var details = edge && options && options.details;
            var result,
                best = {};
            var min = Number.POSITIVE_INFINITY;
            if (geometry instanceof _Point2["default"]) {
                var segs = this.getSortedSegments();
                var x = geometry.x;
                var y = geometry.y;
                var seg;
                for (var i = 0, len = segs.length; i < len; ++i) {
                    seg = segs[i];
                    result = Supermap.Geometry.distanceToSegment(geometry, seg);
                    if (result.distance < min) {
                        min = result.distance;
                        best = result;
                        if (min === 0) {
                            break;
                        }
                    } else {
                        // if distance increases and we cross y0 to the right of x0, no need to keep looking.
                        if (seg.x2 > x && (y > seg.y1 && y < seg.y2 || y < seg.y1 && y > seg.y2)) {
                            break;
                        }
                    }
                }
                if (details) {
                    best = {
                        distance: best.distance,
                        x0: best.x, y0: best.y,
                        x1: x, y1: y
                    };
                } else {
                    best = best.distance;
                }
            } else if (geometry instanceof LineString) {
                var segs0 = this.getSortedSegments();
                var segs1 = geometry.getSortedSegments();
                var seg0, seg1, intersection, x0, y0;
                var len1 = segs1.length;
                var interOptions = { point: true };
                outer: for (var i = 0, len = segs0.length; i < len; ++i) {
                    seg0 = segs0[i];
                    x0 = seg0.x1;
                    y0 = seg0.y1;
                    for (var j = 0; j < len1; ++j) {
                        seg1 = segs1[j];
                        intersection = Supermap.Geometry.segmentsIntersect(seg0, seg1, interOptions);
                        if (intersection) {
                            min = 0;
                            best = {
                                distance: 0,
                                x0: intersection.x, y0: intersection.y,
                                x1: intersection.x, y1: intersection.y
                            };
                            break outer;
                        } else {
                            result = Supermap.Geometry.distanceToSegment({ x: x0, y: y0 }, seg1);
                            if (result.distance < min) {
                                min = result.distance;
                                best = {
                                    distance: min,
                                    x0: x0, y0: y0,
                                    x1: result.x, y1: result.y
                                };
                            }
                        }
                    }
                }
                if (!details) {
                    best = best.distance;
                }
                if (min !== 0) {
                    // check the final vertex in this line's sorted segments
                    if (seg0) {
                        result = geometry.distanceTo(new _Point2["default"](seg0.x2, seg0.y2), options);
                        var dist = details ? result.distance : result;
                        if (dist < min) {
                            if (details) {
                                best = {
                                    distance: min,
                                    x0: result.x1, y0: result.y1,
                                    x1: result.x0, y1: result.y0
                                };
                            } else {
                                best = dist;
                            }
                        }
                    }
                }
            } else {
                best = geometry.distanceTo(this, options);
                // swap since target comes from this line
                if (details) {
                    best = {
                        distance: best.distance,
                        x0: best.x1, y0: best.y1,
                        x1: best.x0, y1: best.y0
                    };
                }
            }
            return best;
        }

        /**
         * @function SuperMap.Geometry.LineString.prototype.simplify
         * @description 这个函数返回一个简化的线串，基于道格拉斯 - 普克简化算法进行简化。
         * @param tolerance {number} 地图单位上的简化的阈值。
         * @returns {SuperMap.Geometry.LineString} 被简化的线串。
         */

    }, {
        key: 'simplify',
        value: function simplify(tolerance) {
            if (this && this !== null) {
                var points = this.getVertices();
                if (points.length < 3) {
                    return this;
                }

                var compareNumbers;
                a, b;
                {
                    return a - b;
                }
                ;

                var firstPoint = 0;
                var lastPoint = points.length - 1;
                var pointIndexsToKeep = [];

                /**
                 * Private function calculating the perpendicular distance
                 * TODO: check whether SuperMap.Geometry.LineString::distanceTo() is faster or slower
                 */
                var perpendicularDistance;
                point1, point2, point;
                {
                    //Area = |(1/2)(x1y2 + x2y3 + x3y1 - x2y1 - x3y2 - x1y3)|   *Area of triangle
                    //Base = v((x1-x2)²+(x1-x2)²)                               *Base of Triangle*
                    //Area = .5*Base*H                                          *Solve for height
                    //Height = Area/.5/Base

                    var area = Math.abs(0.5 * (point1.x * point2.y + point2.x * point.y + point.x * point1.y - point2.x * point1.y - point.x * point2.y - point1.x * point.y));
                    var bottom = Math.sqrt(Math.pow(point1.x - point2.x, 2) + Math.pow(point1.y - point2.y, 2));
                    var height = area / bottom * 2;

                    return height;
                }
                ;

                /**
                 * Private function doing the Douglas-Peucker reduction
                 */
                var douglasPeuckerReduction;
                points, firstPoint, lastPoint, tolerance;
                {
                    var maxDistance = 0;
                    var indexFarthest = 0;

                    for (var index = firstPoint, distance; index < lastPoint; index++) {
                        distance = perpendicularDistance(points[firstPoint], points[lastPoint], points[index]);
                        if (distance > maxDistance) {
                            maxDistance = distance;
                            indexFarthest = index;
                        }
                    }

                    if (maxDistance > tolerance && indexFarthest !== firstPoint) {
                        //Add the largest point that exceeds the tolerance
                        pointIndexsToKeep.push(indexFarthest);
                        douglasPeuckerReduction(points, firstPoint, indexFarthest, tolerance);
                        douglasPeuckerReduction(points, indexFarthest, lastPoint, tolerance);
                    }
                }
                ;

                //Add the first and last index to the keepers
                pointIndexsToKeep.push(firstPoint);
                pointIndexsToKeep.push(lastPoint);

                //The first and the last point cannot be the same
                while (points[firstPoint].equals(points[lastPoint])) {
                    lastPoint--;
                    //Addition: the first point not equal to first point in the LineString is kept as well
                    pointIndexsToKeep.push(lastPoint);
                }

                douglasPeuckerReduction(points, firstPoint, lastPoint, tolerance);
                var returnPoints = [];
                pointIndexsToKeep.sort(compareNumbers);
                for (var index = 0; index < pointIndexsToKeep.length; index++) {
                    returnPoints.push(points[pointIndexsToKeep[index]]);
                }
                return new LineString(returnPoints);
            } else {
                return this;
            }
        }

        /**
         * @function SuperMap.Geometry.LineString.createCurve
         * @description 创建扇形对象。（备注：需要依赖Smooth.js）
         * @param points - {Array<SuperMap.Geometry.Point>} 曲线经过的点串。
         * @param method - {String} 曲线类型，目前支持的有："lanczos""cubic""linear"默认为"lanczos"。
         * @param filterSize - {number} 曲线平滑曲度，在2~10之间的数值，默认为10，不支持method为"linear"的类型。
         * @param lineLength - {number} 曲线拟合的线数目，默认是80。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(11983722.73153942864.5449));
         * points.push(new SuperMap.Geometry.Point(11986722.7315 3946864.5449));
         * points.push(new SuperMap.Geometry.Point(11989722.7315 3949864.5449));
         * var curve = SuperMap.Geometry.LineString.createCurve(points);
         */

    }], [{
        key: 'createCurve',
        value: function createCurve(points, method, filterSize, lineLength) {
            var methodCurve = "lanczos";
            if (method != undefined) methodCurve = method;

            var filterSizeCurve = 10;
            if (filterSize != undefined) filterSizeCurve = filterSize;

            var smoothConfig = {
                method: methodCurve,
                clip: 'mirror',
                lanczosFilterSize: filterSizeCurve,
                cubicTension: 0
            };

            var pp = [];
            for (var i = 0; i < points.length; i++) {
                pp.push([points[i].x, points[i].y]);
            }

            var distance;
            a, b;
            {
                return Math.sqrt(Math.pow(a[0] - b[0], 2) + Math.pow(a[1] - b[1], 2));
            }

            var averageLineLengthCurve = 80;
            if (lineLength != undefined) averageLineLengthCurve = lineLength;

            var pointList = [];
            var averageLineLength, du, end, pieceCount, pieceLength, s, start, t, u, _ref, _ref2, _ref3;
            averageLineLength = distance(pp[0], pp[pp.length - 1]) / averageLineLengthCurve;
            pieceCount = 2;
            s = Smooth(pp, smoothConfig);
            for (t = 0, _ref = 1 / pieceCount; t < 1; t += _ref) {
                _ref2 = [s(i + t), s(i + t + 1 / pieceCount)], start = _ref2[0], end = _ref2[1];
                pieceLength = distance(start, end);
                du = averageLineLength / pieceLength;
                for (u = 0, _ref3 = 1 / pieceCount; 0 <= _ref3 ? u < _ref3 : u > _ref3; u += du) {
                    var p = s(i + t + u);
                    pointList.push(new _Point2["default"](p[0], p[1]));
                }
            }

            var p = s(i + 1);
            pointList.push(new _Point2["default"](p[0], p[1]));

            return new LineString(pointList);
        }
    }, {
        key: 'createBspline',


        /**
         * @function SuperMap.Geometry.LineString.createBspline
         * @description 创建B样条曲线。此曲线会穿过所有的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 曲线经过的点串。
         * @param filterSize - {number} 曲线平滑曲度，默认为10。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(116, 39.4));
         * points.push(new SuperMap.Geometry.Point(118, 39.8));
         * points.push(new SuperMap.Geometry.Point(119, 39));
         *
         * var curve = SuperMap.Geometry.LineString.createBspline(points,5);
         */
        value: function createBspline(points, filterSize) {
            //一个点无效，至少需要两个点
            if (points.length < 2) {
                return null;
            }
            //曲线内部的所有点数组
            var pointListDraw = [];
            //设置曲线平滑曲度
            var k = 10;
            if (filterSize != undefined) {
                k = filterSize;
            }
            var i, j, a0, a1, a2, dt, t1, t2;
            var t_x, t_y;
            dt = 1.0 / k;
            //计算起始点，
            var value = Math.sqrt((Math.pow(points[1].x - points[0].x, 2) + Math.pow(points[1].y - points[0].y, 2)) / 2); //取的点数组中前两个点粗略计算出的一个值
            //此为第一个控制点，此点以后可能会开放出来
            var pointFirst = new _Point2["default"](points[0].x - value, points[0].y - value);
            //初始化一个点数组，存放所有的控制点
            var pointListControl = [];
            //第一个控制点也就是起始点pointFirst
            pointListControl[0] = pointFirst;
            //循环用户传进的点数组
            for (i = 0; i < points.length - 1; i++) {
                //定义一个零时数组，只需要三个元素，后期用于调用贝茨曲线划线（由首尾两个挤出点和中间的控制点组成的）
                var pointList = [];
                //
                pointList[0] = points[i];
                //由前一个控制点和当前的点生成的后一个控制点
                var point = new _Point2["default"](points[i].x * 2 - pointListControl[i].x, points[i].y * 2 - pointListControl[i].y);
                pointList[1] = point;
                pointListControl[i + 1] = point;
                pointList[2] = points[i + 1];
                //将此控制点存起来
                pointListDraw.push(pointList[0]);
                //生成当前曲线中的所有点
                for (j = 0; j <= k; j++) {
                    t1 = j * dt;
                    t2 = t1 * t1;

                    a0 = (t2 - 2 * t1 + 1) / 2.0;
                    a1 = (2 * t1 - 2 * t2 + 1) / 2.0;
                    a2 = t2 / 2.0;

                    t_x = a0 * pointList[0].x + a1 * pointList[1].x + a2 * pointList[2].x;
                    t_y = a0 * pointList[0].y + a1 * pointList[1].y + a2 * pointList[2].y;
                    pointListDraw.push(new _Point2["default"](t_x, t_y));
                }
            }
            //将最后一个用户的点存进去才能达到曲线通过所有的点
            pointListDraw.push(points[points.length - 1]);
            return new LineString(pointListDraw);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier1
         * @description 创建1次贝塞尔曲线。
         * @param points -{Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         *                     决定贝塞尔曲线的平滑程度。取值越小曲线越平滑。取值为大于1的整数。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier1(points 20);
         */

    }, {
        key: 'createBezier1',
        value: function createBezier1(points, precision, part) {
            if (part) {
                return LineString.createBezier3(points, part);
            }
            //获取待拆分的点
            var bezierPts = [];
            for (var m = 0; m < points.length; m++) {
                bezierPts[m] = points[m];
            }
            //获取输入点的数量
            var i;
            var k;
            var j = 0;
            var bExit;
            var count = bezierPts.length;
            var ptBuffer = [];
            var ok = true;
            while (ok) {
                bExit = true;
                //贝塞尔分解是按4个点为一组进行的，所以小于4个点就再不进行分解
                for (i = 0; i < count - 3; i += 3) {
                    //对输入点数组进行分解
                    //判断bezierPts[i]到bezierPts[i+4]是否达到精度
                    if (GetBezierGap(bezierPts, i) > precision) {
                        bExit = false;
                        //对未达到精度的bezierPts[i]到bezierPts[i+4]进行计算，得到新的ptBuffer点数组
                        InciseBezier(bezierPts, i, ptBuffer);
                        //去除已使用过的2个控制点
                        bezierPts.splice(i + 1, 2);
                        //将本次计算得到的5个新的点插入到bezierPts[i]位置之后，得到新的bezierPts点数组
                        for (k = 0; k < 5; k++) {
                            bezierPts.splice(i + 1 + k, 0, ptBuffer[k + 1]);
                        }
                        //bezierPts[i]到bezierPts[i+4]没有达到精度，所以不能跳过，i需回归初始
                        i -= 3;
                        count = bezierPts.length;
                    }
                    if (bExit) break;
                }
                //对分解得出的新bezierPts点数组进行优化，除去相同的点
                while (j < count - 1) {
                    if (bezierPts[j] === bezierPts[j + 1]) {
                        bezierPts.splice(j + 1, 1);
                        count--;
                    }
                    j++;
                }
                ok = false;
            }

            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZ2
         * @description 计算2次贝塞尔曲线的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串（必须为三个点）。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} 2次贝塞尔曲线的所有点。
         */

    }, {
        key: 'calculatePointsFBZ2',
        value: function calculatePointsFBZ2(points, part) {
            if (!part) part = 20;

            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;
            if (part > 0) {
                scale = 1 / part;
            }

            for (var i = 0; i < points.length - 2;) {
                //起始点
                var pointS = points[i];
                //控制点
                var pointC = points[i + 1];
                //结束点
                var pointE = points[i + 2];

                bezierPts.push(pointS);
                for (var t = 0; t < 1;) {
                    //二次贝塞尔曲线公式
                    var x = (1 - t) * (1 - t) * pointS.x + 2 * t * (1 - t) * pointC.x + t * t * pointE.x;
                    var y = (1 - t) * (1 - t) * pointS.y + 2 * t * (1 - t) * pointC.y + t * t * pointE.y;
                    var point = new _Point2["default"](x, y);
                    bezierPts.push(point);
                    t += scale;
                }

                i += 2;
                if (i >= points.length) {
                    bezierPts.push(pointS);
                }
            }

            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }

            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZ3
         * @description 计算3次贝塞尔曲线的点。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串(四个)。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} 3次贝塞尔曲线的所有点
         */

    }, {
        key: 'calculatePointsFBZ3',
        value: function calculatePointsFBZ3(points, part) {
            if (!part) part = 20;
            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;

            if (part > 0) {
                scale = 1 / part;
            }

            for (var i = 0; i < points.length - 3;) {
                //起始点
                var pointS = points[i];
                //第一个控制点
                var pointC1 = points[i + 1];
                //第二个控制点
                var pointC2 = points[i + 2];
                //结束点
                var pointE = points[i + 3];

                bezierPts.push(pointS);
                for (var t = 0; t < 1;) {
                    //三次贝塞尔曲线公式
                    var x = (1 - t) * (1 - t) * (1 - t) * pointS.x + 3 * t * (1 - t) * (1 - t) * pointC1.x + 3 * t * t * (1 - t) * pointC2.x + t * t * t * pointE.x;
                    var y = (1 - t) * (1 - t) * (1 - t) * pointS.y + 3 * t * (1 - t) * (1 - t) * pointC1.y + 3 * t * t * (1 - t) * pointC2.y + t * t * t * pointE.y;
                    var point = new _Point2["default"](x, y);
                    bezierPts.push(point);
                    t += scale;
                }

                i += 3;
                if (i >= points.length) {
                    bezierPts.push(pointS);
                }
            }

            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }
            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculatePointsFBZN
         * @description 计算N次贝塞尔曲线的插值点。计算N次贝塞尔曲线需要N+1个点也就是传入 points ，得到的是points.length-1次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {Array<SuperMap.Geometry.Point>} N次贝塞尔曲线的所有点。
         */

    }, {
        key: 'calculatePointsFBZN',
        value: function calculatePointsFBZN(points, part) {
            if (!part) part = points.length * 8;

            //获取待拆分的点
            var bezierPts = [];
            var scale = 0.05;
            if (part > 0) {
                scale = 1 / part;
            }
            for (var t = 0; t <= 1;) {
                var x = 0;
                var y = 0;
                var n = points.length;
                for (var i = 0; i < points.length; i++) {
                    var b = LineString.BEZ(n - 1, i, t);
                    x += points[i].x * b;
                    y += points[i].y * b;
                }
                var point = new _Point2["default"](x, y);
                bezierPts.push(point);
                t += scale;
            }
            //需要判定一下最后一个点是否存在
            var poRE = bezierPts[bezierPts.length - 1];
            var popE = points[points.length - 1];
            if (!poRE.equals(popE)) {
                bezierPts.push(popE.clone());
            }
            return bezierPts;
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier2
         * @description 创建2次贝塞尔曲线。
         * @param points -{Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串（必须为三个点）。
         * @param part -{number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier2(points 20);
         */

    }, {
        key: 'createBezier2',
        value: function createBezier2(points, part) {

            var bezierPts = LineString.calculatePointsFBZ2(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier3
         * @description 创建3次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。(必须为四个点)。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier3(points 20);
         */

    }, {
        key: 'createBezier3',
        value: function createBezier3(points, part) {

            var bezierPts = LineString.calculatePointsFBZ3(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezier
         * @description 创建3次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param precision - {number} 拆分精度，表示贝塞尔曲线上任意两点间横向或纵向的最大距离。
         *                     决定贝塞尔曲线的平滑程度。取值越小曲线越平滑。取值为大于1的整数。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezier(points1);
         */

    }, {
        key: 'createBezier',
        value: function createBezier(points, precision) {
            //获取待拆分的点
            var bezierPts = [];
            for (var m = 0; m < points.length; m++) {
                bezierPts[m] = points[m];
            }
            //获取输入点的数量
            var i,
                k,
                j = 0,
                bExit,
                count = bezierPts.length;
            var ptBuffer = [];
            while (true) {
                bExit = true;
                //贝塞尔分解是按4个点为一组进行的，所以小于4个点就再不进行分解
                for (i = 0; i < count - 3; i += 3) {
                    //对输入点数组进行分解
                    //判断bezierPts[i]到bezierPts[i+4]是否达到精度
                    if (GetBezierGap(bezierPts, i) > precision) {
                        bExit = false;
                        //对未达到精度的bezierPts[i]到bezierPts[i+4]进行计算，得到新的ptBuffer点数组
                        InciseBezier(bezierPts, i, ptBuffer);
                        //去除已使用过的2个控制点
                        bezierPts.splice(i + 1, 2);
                        //将本次计算得到的5个新的点插入到bezierPts[i]位置之后，得到新的bezierPts点数组
                        for (k = 0; k < 5; k++) {
                            bezierPts.splice(i + 1 + k, 0, ptBuffer[k + 1]);
                        }
                        //bezierPts[i]到bezierPts[i+4]没有达到精度，所以不能跳过，i需回归初始
                        i -= 3;
                        count = bezierPts.length;
                    }
                    if (bExit) break;
                }
                //对分解得出的新bezierPts点数组进行优化，除去相同的点
                while (j < count - 1) {
                    if (bezierPts[j] === bezierPts[j + 1]) {
                        bezierPts.splice(j + 1, 1);
                        count--;
                    }
                    j++;
                }
                //返回分解完成的新的bezierPts点数组
                return new LineString(bezierPts);
            }
        }

        /**
         * @function SuperMap.Geometry.LineString.createBezierN
         * @description 创建N次贝塞尔曲线。创建N次贝塞尔曲线需要N+1个点也就是传入 points ，得到的是points.length-1次贝塞尔曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @param part - {number} 平滑度。取值越大，曲线越平滑。取值为大于1的整数，默认为20。
         * @returns {SuperMap.Geometry.LineString} 几何线对象。
         * @example
         * //创建3次贝塞尔曲线
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezierN(points 20);
         * //创建4次贝塞尔曲线
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         * points.push(new SuperMap.Geometry.Point(5020));
         *
         * var bezier = SuperMap.Geometry.LineString.createBezierN(points 30);
         * ......
         */

    }, {
        key: 'createBezierN',
        value: function createBezierN(points, part) {
            var bezierPts = LineString.calculatePointsFBZN(points, part);
            return new LineString(bezierPts);
        }

        /**
         * @function SuperMap.Geometry.LineString.BEZ
         * @description 基函数。
         * @param n -{number}
         * @param k -{number}
         * @param t -{number} 0-1之间的一个数。
         * @returns {number} 基函数的值。
         *
         */

    }, {
        key: 'BEZ',
        value: function BEZ(n, k, t) {
            return LineString.combSort(n, k) * Math.pow(t, k) * Math.pow(1 - t, n - k);
        }

        /**
         * @function SuperMap.Geometry.LineString.combSort
         * @description 组合排序计算从1*2*...*n/(1*2*...*k*1*2*...*(n-k))的值。
         * @param n -{number} 贝塞尔曲线的次数n。
         * @param k -{number} 小于N的一个数k。
         * @returns {number} 组合排序的值。
         *
         */

    }, {
        key: 'combSort',
        value: function combSort(n, k) {
            var son = LineString.factorial(n);
            var mother = LineString.factorial(k) * LineString.factorial(n - k);
            return son / mother;
        }

        /**
         * @function SuperMap.Geometry.LineString.factorial
         * @description 阶乘计算从1*2*3*4*...*n的值。
         * @param n - {number}
         * @returns {number} 阶乘的值。
         *
         */

    }, {
        key: 'factorial',
        value: function factorial(n) {
            var result = 1;
            for (var i = 1; i <= n; i++) {
                result *= i;
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculateCardinalPoints
         * @description 创建Cardinal控制点。
         * 利用输入的点数组计算出相应的Cardinal控制点，再使用贝塞尔曲线3创建经过所有Cardinal控制点的圆滑曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的Cardinal控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var cardinal = SuperMap.Geometry.LineString.createCloseCardinal(points);
         */

    }, {
        key: 'calculateCardinalPoints',
        value: function calculateCardinalPoints(points) {
            if (points == null || points.length < 3) {
                return points;
            }
            //定义传入的点数组，将在点数组中央（每两个点）插入两个控制点
            var cPoints = points;
            //包含输入点和控制点的数组
            var cardinalPoints = [];

            //这些都是相关资料测出的经验数值
            //定义张力系数，取值在0<t<0.5
            var t = 0.4;
            //为端点张力系数因子，取值在0<b<1
            var b = 0.5;
            //误差控制，是一个大于等于0的数，用于三点非常趋近与一条直线时，减少计算量
            var e = 0.005;

            //传入的点数量，至少有三个，n至少为2
            var n = cPoints.length - 1;
            //从开始遍历到倒数第二个，其中倒数第二个用于计算起点（终点）的插值控制点

            for (var k = 0; k <= n + 1 - 3; k++) {
                //三个基础输入点
                var p0 = cPoints[k];
                var p1 = cPoints[k + 1];
                var p2 = cPoints[k + 2];
                //定义p1的左控制点和右控制点
                var p1l = new _Point2["default"]();
                var p1r = new _Point2["default"]();
                //通过p0、p1、p2计算p1点的做控制点p1l和又控制点p1r
                //计算向量p0_p1和p1_p2
                var p0_p1 = new _Point2["default"](p1.x - p0.x, p1.y - p0.y);
                var p1_p2 = new _Point2["default"](p2.x - p1.x, p2.y - p1.y);
                //并计算模
                var d01 = Math.sqrt(p0_p1.x * p0_p1.x + p0_p1.y * p0_p1.y);
                var d12 = Math.sqrt(p1_p2.x * p1_p2.x + p1_p2.y * p1_p2.y);
                //向量单位化
                var p0_p1_1 = new _Point2["default"](p0_p1.x / d01, p0_p1.y / d01);
                var p1_p2_1 = new _Point2["default"](p1_p2.x / d12, p1_p2.y / d12);
                //计算向量p0_p1和p1_p2的夹角平分线向量
                var p0_p1_p2 = new _Point2["default"](p0_p1_1.x + p1_p2_1.x, p0_p1_1.y + p1_p2_1.y);
                //计算向量 p0_p1_p2 的模
                var d012 = Math.sqrt(p0_p1_p2.x * p0_p1_p2.x + p0_p1_p2.y * p0_p1_p2.y);
                //单位化向量p0_p1_p2
                var p0_p1_p2_1 = new _Point2["default"](p0_p1_p2.x / d012, p0_p1_p2.y / d012);
                //判断p0、p1、p2是否共线，这里判定向量p0_p1和p1_p2的夹角的余弦和1的差值小于e就认为三点共线
                var cosE_p0p1p2 = (p0_p1_1.x * p1_p2_1.x + p0_p1_1.y * p1_p2_1.y) / 1;
                //共线
                if (Math.abs(1 - cosE_p0p1p2) < e) {
                    //计算p1l的坐标
                    p1l.x = p1.x - p1_p2_1.x * d01 * t;
                    p1l.y = p1.y - p1_p2_1.y * d01 * t;
                    //计算p1r的坐标
                    p1r.x = p1.x + p0_p1_1.x * d12 * t;
                    p1r.y = p1.y + p0_p1_1.y * d12 * t;
                }
                //非共线
                else {
                        //计算p1l的坐标
                        p1l.x = p1.x - p0_p1_p2_1.x * d01 * t;
                        p1l.y = p1.y - p0_p1_p2_1.y * d01 * t;
                        //计算p1r的坐标
                        p1r.x = p1.x + p0_p1_p2_1.x * d12 * t;
                        p1r.y = p1.y + p0_p1_p2_1.y * d12 * t;
                    }
                //记录下这三个控制点
                cardinalPoints[k * 3 + 2 + 0] = p1l;
                cardinalPoints[k * 3 + 2 + 1] = p1;
                cardinalPoints[k * 3 + 2 + 2] = p1r;

                //当为起始点时需要计算第一个点的右控制点
                if (k == 0) {
                    //定义p0的右控制点
                    var p0r = new _Point2["default"]();

                    //计算向量p0_p1l
                    var po_p1l = new _Point2["default"](p1l.x - p0.x, p1l.y - p0.y);
                    //计算模
                    var d01l = Math.sqrt(po_p1l.x * po_p1l.x + po_p1l.y * po_p1l.y);
                    //单位化
                    var po_p1l_1 = new _Point2["default"](po_p1l.x / d01l, po_p1l.y / d01l);
                    //计算p0r
                    p0r.x = p0.x + po_p1l_1.x * d01 * t * b;
                    p0r.y = p0.y + po_p1l_1.y * d01 * t * b;

                    cardinalPoints[k * 3 + 0] = p0;
                    cardinalPoints[k * 3 + 1] = p0r;
                }
                //当为倒数第三个点时需要计算最后点的左控制点
                if (k == n + 1 - 3) {
                    //定义 p2的做控制点p2l
                    var p2l = new _Point2["default"]();

                    //计算向量p2_p1r
                    var p2_p1r = new _Point2["default"](p1r.x - p2.x, p1r.y - p2.y);
                    //并取模
                    var d21r = Math.sqrt(p2_p1r.x * p2_p1r.x + p2_p1r.y * p2_p1r.y);
                    //单位化
                    var p2_p1r_1 = new _Point2["default"](p2_p1r.x / d21r, p2_p1r.y / d21r);
                    //计算p2l
                    p2l.x = p2.x + p2_p1r_1.x * d12 * t * b;
                    p2l.y = p2.y + p2_p1r_1.y * d12 * t * b;

                    cardinalPoints[k * 3 + 2 + 3] = p2l;
                    cardinalPoints[k * 3 + 2 + 4] = p2;
                }
            }
            return cardinalPoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.createCloseCardinal
         * @description 创建闭合Cardinal的控制点。利用输入的点数组计算出相应的Cardinal控制点，再使用贝塞尔曲线3创建经过所有Cardinal控制点的圆滑闭合曲线。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的Cardinal控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var cardinal = SuperMap.Geometry.LineString.createCloseCardinal(points);
         */

    }, {
        key: 'createCloseCardinal',
        value: function createCloseCardinal(points) {
            if (points == null || points.length < 3) {
                return points;
            }
            //获取起点，作为终点，以闭合曲线。
            var lastP = points[0];
            points.push(lastP);

            //定义传入的点数组，将在点数组中央（每两个点）插入两个控制点
            var cPoints = points;
            //包含输入点和控制点的数组
            var cardinalPoints = [];

            //至少三个点以上
            //这些都是相关资料测出的经验数值
            //定义张力系数，取值在0<t<0.5
            var t = 0.4;
            //为端点张力系数因子，取值在0<b<1
            var b = 0.5;
            //误差控制，是一个大于等于0的数，用于三点非常趋近与一条直线时，减少计算量
            var e = 0.005;

            //传入的点数量，至少有三个，n至少为2
            var n = cPoints.length - 1;
            //从开始遍历到倒数第二个，其中倒数第二个用于计算起点（终点）的插值控制点
            for (var k = 0; k <= n - 1; k++) {
                //计算起点（终点）的左右控制点
                if (k == n - 1) {
                    //三个基础输入点
                    var p0 = cPoints[n - 1];
                    var p1 = cPoints[0];
                    var p2 = cPoints[1];
                } else {
                    var p0 = cPoints[k];
                    var p1 = cPoints[k + 1];
                    var p2 = cPoints[k + 2];
                }

                //定义p1的左控制点和右控制点
                var p1l = new _Point2["default"]();
                var p1r = new _Point2["default"]();
                //通过p0、p1、p2计算p1点的做控制点p1l和又控制点p1r
                //计算向量p0_p1和p1_p2
                var p0_p1 = new _Point2["default"](p1.x - p0.x, p1.y - p0.y);
                var p1_p2 = new _Point2["default"](p2.x - p1.x, p2.y - p1.y);
                //并计算模
                var d01 = Math.sqrt(p0_p1.x * p0_p1.x + p0_p1.y * p0_p1.y);
                var d12 = Math.sqrt(p1_p2.x * p1_p2.x + p1_p2.y * p1_p2.y);
                //向量单位化
                var p0_p1_1 = new _Point2["default"](p0_p1.x / d01, p0_p1.y / d01);
                var p1_p2_1 = new _Point2["default"](p1_p2.x / d12, p1_p2.y / d12);
                //计算向量p0_p1和p1_p2的夹角平分线向量
                var p0_p1_p2 = new _Point2["default"](p0_p1_1.x + p1_p2_1.x, p0_p1_1.y + p1_p2_1.y);
                //计算向量 p0_p1_p2 的模
                var d012 = Math.sqrt(p0_p1_p2.x * p0_p1_p2.x + p0_p1_p2.y * p0_p1_p2.y);
                //单位化向量p0_p1_p2
                var p0_p1_p2_1 = new _Point2["default"](p0_p1_p2.x / d012, p0_p1_p2.y / d012);
                //判断p0、p1、p2是否共线，这里判定向量p0_p1和p1_p2的夹角的余弦和1的差值小于e就认为三点共线
                var cosE_p0p1p2 = (p0_p1_1.x * p1_p2_1.x + p0_p1_1.y * p1_p2_1.y) / 1;
                //共线
                if (Math.abs(1 - cosE_p0p1p2) < e) {
                    //计算p1l的坐标
                    p1l.x = p1.x - p1_p2_1.x * d01 * t;
                    p1l.y = p1.y - p1_p2_1.y * d01 * t;
                    //计算p1r的坐标
                    p1r.x = p1.x + p0_p1_1.x * d12 * t;
                    p1r.y = p1.y + p0_p1_1.y * d12 * t;
                }
                //非共线
                else {
                        //计算p1l的坐标
                        p1l.x = p1.x - p0_p1_p2_1.x * d01 * t;
                        p1l.y = p1.y - p0_p1_p2_1.y * d01 * t;
                        //计算p1r的坐标
                        p1r.x = p1.x + p0_p1_p2_1.x * d12 * t;
                        p1r.y = p1.y + p0_p1_p2_1.y * d12 * t;
                    }

                //记录起点（终点）的左右插值控制点及倒数第二个控制点
                if (k == n - 1) {
                    cardinalPoints[0] = p1;
                    cardinalPoints[1] = p1r;
                    cardinalPoints[(n - 2) * 3 + 2 + 3] = p1l;
                    cardinalPoints[(n - 2) * 3 + 2 + 4] = cPoints[n];
                } else {
                    //记录下这三个控制点
                    cardinalPoints[k * 3 + 2 + 0] = p1l;
                    cardinalPoints[k * 3 + 2 + 1] = p1;
                    cardinalPoints[k * 3 + 2 + 2] = p1r;
                }
            }
            return cardinalPoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.calculateCircle
         * @description 三点画圆弧。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的圆弧控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050));
         * points.push(new SuperMap.Geometry.Point(260));
         *
         * var circle = SuperMap.Geometry.LineString.calculateCircle(points);
         */

    }, {
        key: 'calculateCircle',
        value: function calculateCircle(points) {
            if (points.length < 3) {
                return points;
            }
            var len = points.length,
                centerPoint = {},
                p1 = points[0],
                p2 = points[1],
                p3 = points[2];
            var R = 0,
                dStep = 0,
                direc = true,
                dRotation = 0,
                dRotationBegin = 0,
                dRotationAngle = 0,
                nSegmentCount = 72,
                centerPoint = {},
                circlePoints = [];

            var KTan13 = (p3.y - p1.y) / (p3.x - p1.x);
            var B13 = p3.y - KTan13 * p3.x;
            if (p3.x != p1.x && p3.y != p1.y && p2.y == KTan13 * p2.x + B13 || p3.x == p1.x && p2.x == p1.x || p3.y == p1.y && p2.y == p1.y || p3.x == p1.x && p3.y == p1.y || p3.x == p2.x && p3.y == p2.y || p1.x == p2.x && p1.y == p2.y) {
                circlePoints.push(p1);
                circlePoints.push(p2);
                circlePoints.push(p3);
            } else {
                var D = (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p3.y - p1.y)) - (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p2.y - p1.y));
                var E = 2 * (p2.x - p1.x) * (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) - 2 * (p3.x - p1.x) * (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y));
                var F = 4 * ((p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y));
                centerPoint.x = D / F;
                centerPoint.y = E / F;
                R = Math.sqrt((p1.x - centerPoint.x) * (p1.x - centerPoint.x) + (p1.y - centerPoint.y) * (p1.y - centerPoint.y));

                var dis = (p1.x - p3.x) * (p1.x - p3.x) + (p1.y - p3.y) * (p1.y - p3.y);
                var cons = (2 * R * R - dis) / (2 * R * R);
                cons = cons >= 1 ? 1 : cons;
                cons = cons <= -1 ? -1 : cons;
                dRotationAngle = Math.acos(cons) * 180 / Math.PI;

                if (p3.x == p1.x) {
                    dRotationAngle = centerPoint.x > p1.x && p2.x > p1.x || centerPoint.x < p1.x && p2.x < p1.x ? 360 - dRotationAngle : dRotationAngle;
                } else {
                    dRotationAngle = centerPoint.y > KTan13 * centerPoint.x + B13 && p2.y > KTan13 * p2.x + B13 || centerPoint.y < KTan13 * centerPoint.x + B13 && p2.y < KTan13 * p2.x + B13 ? 360 - dRotationAngle : dRotationAngle;
                }
                dStep = dRotationAngle / 72;

                if (p3.y != p1.y) {
                    if (p3.x == p1.x) {
                        if (p3.y > p1.y) {
                            if (p2.x < p1.x) {
                                direc = false;
                            }
                        } else {
                            if (p2.x > p1.x) {
                                direc = false;
                            }
                        }
                    } else if (p3.x < p1.x) {
                        if (p2.y < KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    } else {
                        if (p2.y > KTan13 * p2.x + B13) {
                            direc = false;
                        }
                    }
                } else {
                    if (p3.x > p1.x) {
                        if (p2.y > p1.y) {
                            direc = false;
                        }
                    } else {
                        if (p2.y < p1.y) {
                            direc = false;
                        }
                    }
                }

                var K10 = (p1.y - centerPoint.y) / (p1.x - centerPoint.x);
                var atan10 = K10 >= 0 ? Math.atan(K10) * 180 / Math.PI : Math.abs(Math.atan(K10) * 180 / Math.PI) + 90;

                var CY = Math.abs(centerPoint.y);
                if (p1.y == CY && CY == p3.y) {
                    if (p1.x < p3.x) {
                        atan10 = atan10 + 180;
                    }
                }

                var newPY = p1.y - centerPoint.y;
                circlePoints.push(p1);
                for (var i = 1; i < nSegmentCount; i++) {
                    dRotation = dStep * i;
                    dRotationBegin = atan10;

                    if (direc) {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin + dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) + dRotation;
                            }
                        } else {
                            if (K10 > 0) {
                                dRotationBegin = dRotationBegin - 180 + dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin + dRotation;
                            }
                        }
                    } else {
                        if (newPY >= 0) {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - dRotation;
                            } else {
                                dRotationBegin = 180 - (dRotationBegin - 90) - dRotation;
                            }
                        } else {
                            if (K10 >= 0) {
                                dRotationBegin = dRotationBegin - 180 - dRotation;
                            } else {
                                dRotationBegin = 90 - dRotationBegin - dRotation;
                            }
                        }
                    }

                    dRotationBegin = dRotationBegin * Math.PI / 180;
                    var x = centerPoint.x + R * Math.cos(dRotationBegin);
                    var y = centerPoint.y + R * Math.sin(dRotationBegin);
                    circlePoints.push(new _Point2["default"](x, y));
                }
                circlePoints.push(p3);
            }
            return circlePoints;
        }

        /**
         * @function SuperMap.Geometry.LineString.createLineEPS
         * @description 根据点的类型画出不同类型的曲线。点的类型有三种 LTypeArc LTypeCurve NONE。
         * @param points - {Array<SuperMap.Geometry.Point>} 传入的待计算的初始点串。
         * @returns {Array<SuperMap.Geometry.Point>} 计算出相应的lineEPS控制点。
         * @example
         * var points = [];
         * points.push(new SuperMap.Geometry.Point(-5030));
         * points.push(new SuperMap.Geometry.Point(-3050"LTypeArc"));
         * points.push(new SuperMap.Geometry.Point(260));
         * points.push(new SuperMap.Geometry.Point(820));
         *
         * var lineEPS = SuperMap.Geometry.LineString.createLineEPS(points);
         */

    }, {
        key: 'createLineEPS',
        value: function createLineEPS(points) {
            var list = [],
                part = 0,
                len = points.length;
            if (points == null || len < 2) {
                return points;
            }
            for (var i = 0; i < len;) {
                var type = points[i].type;
                if (type == 'LTypeArc') {
                    var listObj = LineString.createLineArc(list, i, len, points);
                    list = listObj[0];
                    i = listObj[1];
                } else {
                    list.push(points[i]);
                    i++;
                }
            }
            return list;
        }
    }, {
        key: 'createLineArc',
        value: function createLineArc(list, i, len, points) {
            if (i == 0) {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            } else if (i == len - 1) {
                var bezierP = [points[i - 1], points[i]],
                    bezierPts = LineString.calculateCircle(bezierP);
                Array.prototype.push.apply(list, bezierPts);
                i++;
            } else {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
                list.pop();
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            }
            return [list, i];
        }
    }, {
        key: 'createLineCurve',
        value: function createLineCurve(list, i, len, points) {
            if (i == 0) {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeCurve');
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            } else if (i == len - 1) {
                var bezierP = [points[i - 1], points[i]],
                    bezierPts = LineString.calculatePointsFBZN(bezierP);
                Array.prototype.push.apply(list, bezierPts);
                i++;
            } else {
                var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeCurve');
                list.pop();
                Array.prototype.push.apply(list, bezierPtsObj[0]);
                i = bezierPtsObj[1] + 1;
            }
            return [list, i];
        }
    }, {
        key: 'addPointEPS',
        value: function addPointEPS(points, i, len, type) {
            var bezierP = [],
                j = i + 1;
            if (i == 0) {
                Array.prototype.push.apply(bezierP, [points[i], points[i + 1]]);
            } else if (i == len - 1) {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i]]);
            } else {
                Array.prototype.push.apply(bezierP, [points[i - 1], points[i], points[i + 1]]);
            }
            if (type == 'LTypeCurve') {
                var bezierPts = LineString.calculatePointsFBZN(bezierP);
            } else if (type == 'LTypeArc') {
                var bezierPts = LineString.calculateCircle(bezierP);
            }
            return [bezierPts, j];
        }
    }]);

    return LineString;
}(_Curve3["default"]);

exports["default"] = LineString;


_SuperMap2["default"].Geometry.LineString = LineString;

/**
 * @private
 * @function InciseBezier
 * 拆分贝赛尔曲线单元
 *
 * pSrcPt -{Array<SuperMap.Geometry.Point>} 传入的待拆分点数组。
 * j - {number} 本次拆分的首点位置，从pSrcPt[j]（包括此点）点向后取4个点进行本次拆分。
 * pDstPt -{Array<SuperMap.Geometry.Point>} 将4个点拆分成7个点，pDstPt是包含此7个点的结果点数组。
 */
function InciseBezier(pSrcPt, j, pDstPt) {
    var buffer = [];
    buffer[0] = [];
    buffer[1] = [];
    buffer[2] = [];
    var i;
    for (i = 0; i < 3; i++) {
        buffer[0][i] = new _Point2["default"]();
        buffer[0][i].x = (pSrcPt[j + i].x + pSrcPt[j + i + 1].x) / 2;
        buffer[0][i].y = (pSrcPt[j + i].y + pSrcPt[j + i + 1].y) / 2;
    }
    for (i = 0; i < 2; i++) {
        buffer[1][i] = new _Point2["default"]();
        buffer[1][i].x = (buffer[0][i].x + buffer[0][i + 1].x) / 2;
        buffer[1][i].y = (buffer[0][i].y + buffer[0][i + 1].y) / 2;
    }

    buffer[2][0] = new _Point2["default"]();
    buffer[2][0].x = (buffer[1][0].x + buffer[1][1].x) / 2;
    buffer[2][0].y = (buffer[1][0].y + buffer[1][1].y) / 2;
    //将输入的四个点拆分成7个点
    pDstPt[0] = pSrcPt[j];
    pDstPt[1] = buffer[0][0];
    pDstPt[2] = buffer[1][0];
    pDstPt[3] = buffer[2][0];
    pDstPt[4] = buffer[1][1];
    pDstPt[5] = buffer[0][2];
    pDstPt[6] = pSrcPt[j + 3];
    return true;
}

/**
 * @private
 * @function SuperMap.Geometry.LineString.GetBezierGap
 * @description 计算贝赛尔曲线两个顶点的纵向和横向的最大距离，结果用来判断是否达到拆分精度。
 * @param pSrcPt {Array<SuperMap.Geometry.Point>} 传入的待拆分点数组。
 * @param j {number} 本次拆分的首点位置，从pSrcPt[j]（包括此点）点向后取4个点进行距离计算。
 */
function GetBezierGap(pSrcPt, j) {
    var gap = 0;
    for (var i = 1; i < 4; i++) {
        if (Math.abs(pSrcPt[j + i].x - pSrcPt[j + i - 1].x) > gap) gap = Math.abs(pSrcPt[j + i].x - pSrcPt[j + i - 1].x);
        if (Math.abs(pSrcPt[j + i].y - pSrcPt[j + i - 1].y) > gap) gap = Math.abs(pSrcPt[j + i].y - pSrcPt[j + i - 1].y);
    }
    return gap;
}

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _FilterParameter = __webpack_require__(16);

var _FilterParameter2 = _interopRequireDefault(_FilterParameter);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.QueryParameters
 * @classdesc 查询参数基类。距离查询、SQL 查询、几何地物查询等各自的参数均继承此类。
 * @param options - {Object} 可选参数。如：<br>
 *         customParams - {string} 自定义参数，供扩展使用。<br>
 *         prjCoordSys - {Object} 自定义参数，供isueprmap提供的动态投影查询扩展使用。如 {"epsgCode":3857}。<br>
 *         expectCount - {number}期望返回结果记录个数。<br>
 *         networkType - {{@link SuperMap.GeometryType}} 网络数据集对应的查询类型。<br>
 *         queryOption - {{@link SuperMap.QueryOption}} 查询结果类型枚举类。<br>
 *         queryParams - {Array<{@link SuperMap.FilterParameter}>}查询过滤条件参数数组。<br>
 *         startRecord - {number}查询起始记录号。<br>
 *         holdTime - {number}资源在服务端保存的时间。<br>
 *         returnCustomResult -{boolean} 仅供三维使用。
 */
var QueryParameters = function () {

    /**
     * @member SuperMap.QueryParameters.prototype.holdTime -{number}
     * @description 资源在服务端保存的时间。默认为10（分钟）。
     * @default 10
     */


    /**
     * @member SuperMap.QueryParameters.prototype.queryParams -{Array<SuperMap.FilterParameter>}
     * @description 查询过滤条件参数数组。
     *               该类用于设置查询数据集的查询过滤参数。
     */


    /**
     * @member SuperMap.QueryParameters.prototype.networkType -{SuperMap.GeometryType}
     * @description 网络数据集对应的查询类型，
     *               分为点和线两种类型，默认为线几何对象类型，即{@link GeometryType.LINE | SuperMap.GeometryType.LINE}。
     * @default  {@link SuperMap.GeometryType.LINE}
     */


    /**
     * @member SuperMap.QueryParameters.prototype.prjCoordSys -{Object}
     * @description 自定义参数，供isueprmap提供的动态投影查询扩展使用。如 {"epsgCode":3857}
     */
    function QueryParameters(options) {
        _classCallCheck(this, QueryParameters);

        this.customParams = null;
        this.prjCoordSys = null;
        this.expectCount = 100000;
        this.networkType = _REST.GeometryType.LINE;
        this.queryOption = _REST.QueryOption.ATTRIBUTEANDGEOMETRY;
        this.queryParams = null;
        this.startRecord = 0;
        this.holdTime = 10;
        this.returnCustomResult = false;
        this.CLASS_NAME = "SuperMap.QueryParameters";

        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     * @function SuperMap.QueryParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.QueryParameters.prototype.returnCustomResult -{boolean}
     * @description 仅供三维使用。
     * @default false
     */


    /**
     * @member SuperMap.QueryParameters.prototype.startRecord -{number}
     * @description 查询起始记录号，默认值为0。
     * @default 0
     */


    /**
     * @member SuperMap.QueryParameters.prototype.queryOption -{SuperMap.QueryOption}
     * @description 查询结果类型枚举类。
     *               该类描述查询结果返回类型，包括只返回属性、
     *               只返回几何实体以及返回属性和几何实体。
     * @default {@link SuperMap.QueryOption.ATTRIBUTEANDGEOMETRY}
     */


    /**
     * @member SuperMap.QueryParameters.prototype.expectCount -{number}
     * @description 期望返回结果记录个数，默认返回100000条查询记录，
     *               如果实际不足100000条则返回实际记录条数。
     * @default 100000
     */


    /**
     * @member SuperMap.QueryParameters.prototype.customParams -{string}
     * @description 自定义参数，供扩展使用。
     */


    _createClass(QueryParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.customParams = null;
            me.expectCount = null;
            me.networkType = null;
            me.queryOption = null;
            if (me.queryParams) {
                for (var i = 0, qps = me.queryParams, len = qps.length; i < len; i++) {
                    qps[i].destroy();
                }
                me.queryParams = null;
            }
            me.startRecord = null;
            me.holdTime = null;
            me.returnCustomResult = null;
            me.prjCoordSys = null;
        }
    }]);

    return QueryParameters;
}();

exports["default"] = QueryParameters;


_SuperMap2["default"].QueryParameters = QueryParameters;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

var _ServerColor = __webpack_require__(17);

var _ServerColor2 = _interopRequireDefault(_ServerColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ServerTextStyle
 * @classdesc 服务端文本风格类
 * @description 该类用于定义文本风格的相关属性。
 * @param options - {Object} 可选参数。如：<br>
 *        align - {{@link SuperMap.TextAlignment}} 文本的对齐方式。<br>
 *        backColor - {{@link SuperMap.ServerColor}} 文本的背景色。<br>
 *        foreColor - {{@link SuperMap.ServerColor}} 文本的前景色。<br>
 *        backOpaque - {boolean} 文本背景是否不透明。<br>
 *        sizeFixed - {boolean} 文本大小是否固定。<br>
 *        fontHeight - {number}文本字体的高度。<br>
 *        fontWidth - {number}文本字体的宽度。<br>
 *        fontWeight - {integer} 文本字体的磅数。<br>
 *        fontName - {string} 文本字体的名称。<br>
 *        bold - {boolean} 文本是否为粗体字。<br>
 *        italic - {boolean}文本是否采用斜体。<br>
 *        italicAngle - {number}字体倾斜角度。<br>
 *        shadow - {boolean} 文本是否有阴影。<br>
 *        strikeout - {boolean} 文本字体是否加删除线。<br>
 *        outline - {boolean} 是否以轮廓的方式来显示文本的背景。<br>
 *        opaqueRate - {number}注记文字的不透明度。<br>
 *        underline - {boolean} 文本字体是否加下划线。<br>
 *        rotation -  {number} 文本旋转的角度。
 */
var ServerTextStyle = function () {

    /**
     * @member SuperMap.ServerTextStyle.prototype.underline -{boolean}
     * @description 文本字体是否加下划线。true 表示加下划线。默认为 false。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.outline -{boolean}
     * @description 是否以轮廓的方式来显示文本的背景。true 表示以轮廓的方式来显示文本的背景。默认值为 false，表示不以轮廓的方式来显示文本的背景。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.shadow -{boolean}
     * @description 文本是否有阴影。true 表示给文本增加阴影。默认值为 false，即文本没有阴影。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.italic -{boolean}
     * @description 文本是否采用斜体。true 表示采用斜体。默认为 false。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontName -{string}
     * @description 文本字体的名称。默认值为 Times New Roman。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontWidth -{number}
     * @description 文本字体的宽度。字体的宽度以英文字符为标准，由于一个中文字符相当于两个英文字符，默认为0地图坐标单位。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.sizeFixed -{boolean}
     * @description 文本大小是否固定。默认为 true，表示图片为固定像素大小，具体大小请参考 fontHeight。当设为 false 时，图片会随着地图缩放而缩放。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.foreColor -{SuperMap.ServerColor}
     * @description 文本的前景色。默认为黑色。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.align -{SuperMap.TextAlignment}
     * @description 文本的对齐方式。默认为 SuperMap.TextAlignment.BASELINECENTER（基准线居中对齐）。
     */
    function ServerTextStyle(options) {
        _classCallCheck(this, ServerTextStyle);

        this.align = _REST.TextAlignment.BASELINECENTER;
        this.backColor = null;
        this.foreColor = null;
        this.backOpaque = false;
        this.sizeFixed = true;
        this.fontHeight = 6;
        this.fontWidth = 0;
        this.fontWeight = 400;
        this.fontName = "Times New Roman";
        this.bold = false;
        this.italic = false;
        this.italicAngle = 0;
        this.shadow = false;
        this.strikeout = false;
        this.outline = false;
        this.opaqueRate = 0;
        this.underline = false;
        this.rotation = 0.0;
        this.CLASS_NAME = "SuperMap.ServerTextStyle";

        var me = this;
        me.backColor = new _ServerColor2["default"](255, 255, 255);
        me.foreColor = new _ServerColor2["default"](0, 0, 0);
        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ServerTextStyle.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.rotation -{number}
     * @description 文本旋转的角度。逆时针方向为正方向，单位为度，精确到0.1度。默认值为0.0。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.opaqueRate -{number}
     * @description 注记文字的不透明度。不透明度的范围为0-100。默认为0，表示透明。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.strikeout -{boolean}
     * @description 文本字体是否加删除线。true 表示加删除线。默认值为 false，即文本字体不加删除线。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.italicAngle -{number}
     * @description 字体倾斜角度。正负度之间，以度为单位，精确到0.1度，默认为0度。当倾斜角度为0度，为系统默认的字体倾斜样式。
     *              正负度是指以纵轴为起始零度线，其纵轴左侧为正，右侧为负。允许的最大角度为60，最小-60。大于60按照60处理，小于-60按照-60处理。目前只对标签专题图有效。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.bold -{boolean}
     * @description 文本是否为粗体字。true 表示为粗体。默认值为 false，即文本不是粗体字。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontWeight -{integer}
     * @description 文本字体的磅数。表示粗体的具体数值。取值范围为从0－900之间的整百数，默认值为400。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.fontHeight -{number}
     * @description 文本字体的高度，默认为6，单位与 sizeFixed 有关，当 sizeFixed 为 False 时，即非固定文本大小时使用地图坐标单位，
     *              如地理坐标系下的地图中单位为度；当 sizeFixed 为 True 时，单位为毫米（mm）。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.backOpaque -{boolean}
     * @description 文本背景是否不透明。true 表示文本背景不透明。
     */


    /**
     * @member SuperMap.ServerTextStyle.prototype.backColor -{SuperMap.ServerColor}
     * @description 文本的背景色。默认为白色。
     */


    _createClass(ServerTextStyle, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.align = null;
            if (me.backColor) {
                me.backColor.destroy();
                me.backColor = null;
            }
            if (me.foreColor) {
                me.foreColor.destroy();
                me.foreColor = null;
            }
            me.backOpaque = null;
            me.sizeFixed = null;
            me.fontHeight = null;
            me.fontWidth = null;
            me.fontWeight = null;
            me.fontName = null;
            me.bold = null;
            me.italic = null;
            me.italicAngle = null;
            me.shadow = null;
            me.strikeout = null;
            me.outline = null;
            me.opaqueRate = null;
            me.underline = null;
            me.rotation = null;
        }

        /**
         * @function SuperMap.ServerTextStyle.fromObj
         * @description 从传入对象获服务端文本风格类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ServerTextStyle}
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ServerTextStyle(obj);
            _SuperMap2["default"].Util.copy(res, obj);
            res.backColor = _ServerColor2["default"].fromJson(obj.backColor);
            res.foreColor = _ServerColor2["default"].fromJson(obj.foreColor);
            return res;
        }
    }]);

    return ServerTextStyle;
}();

exports["default"] = ServerTextStyle;


_SuperMap2["default"].ServerTextStyle = ServerTextStyle;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _TransportationAnalystResultSetting = __webpack_require__(343);

var _TransportationAnalystResultSetting2 = _interopRequireDefault(_TransportationAnalystResultSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.TransportationAnalystParameter
 * @classdesc 交通网络分析通用参数类。
 * @description该类主要用来提供交通网络分析所需的通用参数。
 * 通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息，还可以对分析结果包含的内容进行一些设置。
 * @param options - {Object} 可选参数。如:</br>
 *        barrierEdgeIDs - {Array<number>} 网络分析中障碍弧段的 ID 数组。</br>
 *        barrierNodeIDs - {Array<number>} 网络分析中障碍点的 ID 数组。</br>
 *        barrierPoints - {Array<Point>} 网络分析中 Point2D 类型的障碍点数组。</br>
 *                         点类型可以是：SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point。</br>
 *        weightFieldName - {string} 阻力字段的名称。</br>
 *        turnWeightField - {string} 转向权重字段的名称。</br>
 *        resultSetting - {{@link SuperMap.TransportationAnalystResultSetting}} 分析结果返回内容。
 */
var TransportationAnalystParameter = function () {

  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.turnWeightField -{string}
     * @description 转向权重字段的名称。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierPoints -{Array<Point>}
     * @description 网络分析中 Point2D 类型的障碍点数组。障碍点表示任何方向都不能通过此点。</br>
     * 点类型可以是：SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point。</br>
     * 当各网络分析参数类中的 isAnalyzeById 属性设置为 false 时，该属性才生效。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierEdgeIDs -{Array<number>}
     * @description 网络分析中障碍弧段的 ID 数组。弧段设置为障碍边之后，表示双向都不通。
     */
  function TransportationAnalystParameter(options) {
    _classCallCheck(this, TransportationAnalystParameter);

    this.barrierEdgeIDs = null;
    this.barrierNodeIDs = null;
    this.barrierPoints = null;
    this.weightFieldName = null;
    this.turnWeightField = null;
    this.resultSetting = null;
    this.CLASS_NAME = "SuperMap.TransportationAnalystParameter";

    var me = this;
    me.resultSetting = new _TransportationAnalystResultSetting2["default"]();
    if (!options) {
      return;
    }
    _SuperMap2["default"].Util.extend(this, options);
  }

  /**
     * @function SuperMap.TransportationAnalystParameter.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


  /**
     *  @member SuperMap.TransportationAnalystParameter.prototype.resultSetting -{SuperMap.TransportationAnalystResultSetting}
     *  @description 分析结果返回内容。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.weightFieldName -{string}
     * @description 阻力字段的名称，标识了进行网络分析时所使用的阻力字段，例如表示时间、长度等的字段都可以用作阻力字段。
     * 该字段默值为服务器发布的所有耗费字段的第一个字段。
     */


  /**
     * @member SuperMap.TransportationAnalystParameter.prototype.barrierNodeIDs -{Array<number>}
     * @description 网络分析中障碍点的 ID 数组。结点设置为障碍点之后，表示任何方向都不能通过此结点。
     */


  _createClass(TransportationAnalystParameter, [{
    key: 'destroy',
    value: function destroy() {
      var me = this;
      me.barrierEdgeIDs = null;
      me.barrierNodeIDs = null;
      me.weightFieldName = null;
      me.turnWeightField = null;
      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }
      if (me.barrierPoints && me.barrierPoints.length) {
        for (var i in me.barrierPoints) {
          me.barrierPoints.destroy();
        }
      }
      me.barrierPoints = null;
    }
  }]);

  return TransportationAnalystParameter;
}();

exports["default"] = TransportationAnalystParameter;

_SuperMap2["default"].TransportationAnalystParameter = TransportationAnalystParameter;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * ZRender, a high performance canvas library.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright (c) 2013, Baidu Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * All rights reserved.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * LICENSE
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * https://github.com/ecomfe/zrender/blob/master/LICENSE.txt
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer
 * LevelRenderer 渲染器。
 *
 */
var LevelRenderer = function () {

    /**
     * Constructor: SuperMap.LevelRenderer
     * 构造函数。
     *
     * (code)
     * //在渲染器上加上图形
     * var levelRenderer = new SuperMap.LevelRenderer();
     * var zr = levelRenderer.init(document.getElementById('lRendertest'));
     * zr.clear();
     * zr.addShape(new SuperMap.LevelRenderer.Shape.Circle({
     *     style:{
     *         x : 100,
     *         y : 100,
     *         r : 50,
     *         brushType: 'fill'
     *     }
     * }));
     * zr.render();
     * (end)
     */
    function LevelRenderer() {
        _classCallCheck(this, LevelRenderer);

        this.version = '2.0.4';
        this.CLASS_NAME = "SuperMap.LevelRenderer";
    }

    /**
     * APIMethod: destroy
     * 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    /**
     * Property: version
     * {String} 版本。zRender（Baidu） 的版本号，
     * 记录当前 LevelRenderer 是在 zRender 的那个版本上构建而来。
     * 在每次完整评判和实施由 zRender（Baidu）升级带来的 LevelRenderer 升级后修改。
     *
     */


    _createClass(LevelRenderer, [{
        key: 'destroy',
        value: function destroy() {
            this.dispose();
            this.version = null;
        }

        /**
         * APIMethod: init
         * 创建 LevelRenderer 实例。
         *
         * 不让外部直接 new LevelRenderer 实例，为啥？。
         * 不为啥，提供全局可控同时减少全局污染和降低命名冲突的风险！
         *
         * Parameters:
         * dom - {HTMLElement} 绘图容器。
         *
         * Returns:
         * {<SuperMap.LevelRenderer>} LevelRenderer 实例。
         */

    }, {
        key: 'init',
        value: function init(dom) {
            var zr = new _SuperMap2["default"].LevelRenderer.Render(_Util.Util.createUniqueID("LRenderer_"), dom);
            _SuperMap2["default"].LevelRenderer._instances[zr.id] = zr;
            return zr;
        }

        /**
         * APIMethod: dispose
         * LevelRenderer 实例销毁。
         *
         * 在 SuperMap.LevelRenderer._instances 里的索引也会删除了。
         * 管生就得管死，可以通过 zrender.dispose(zr) 销毁指定 SuperMap.LevelRenderer.Render 实例。
         * 当然也可以直接 zr.dispose() 自己销毁
         *
         * Parameters:
         * zr - {<SuperMap.LevelRenderer.Render>} ZRender对象，不传则销毁全部。
         *
         * Returns:
         * {<SuperMap.LevelRenderer>} this。
         */

    }, {
        key: 'dispose',
        value: function dispose(zr) {
            if (zr) {
                zr.dispose();
            } else {
                for (var key in _SuperMap2["default"].LevelRenderer._instances) {
                    _SuperMap2["default"].LevelRenderer._instances[key].dispose();
                }
                _SuperMap2["default"].LevelRenderer._instances = {};
            }

            return this;
        }

        /**
         * APIMethod: getInstance
         * 获取 SuperMap.LevelRenderer.Render 实例。
         *
         * Parameters:
         * id - {String} ZRender对象索引。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Render>} SuperMap.LevelRenderer.Render 实例。
         */

    }, {
        key: 'getInstance',
        value: function getInstance(id) {
            return _SuperMap2["default"].LevelRenderer._instances[id];
        }

        /**
         * APIMethod: delInstance
         * 删除 zrender 实例，SuperMap.LevelRenderer.Render 实例 dispose 时会调用，
         * 删除后 getInstance 则返回 undefined
         * ps: 仅是删除，删除的实例不代表已经 dispose 了~~
         *     这是一个摆脱全局 zrender.dispose() 自动销毁的后门，
         *     take care of yourself~
         *
         *
         * Parameters:
         * id - {String} SuperMap.LevelRenderer.Render 对象索引。
         *
         * Returns:
         * {<SuperMap.LevelRenderer>} this。
         */

    }, {
        key: 'delInstance',
        value: function delInstance(id) {
            delete _SuperMap2["default"].LevelRenderer._instances[id];
            return this;
        }
    }]);

    return LevelRenderer;
}();

exports["default"] = LevelRenderer;

_SuperMap2["default"].LevelRenderer = LevelRenderer;
/**
 * Property: _instances
 * {Object} LevelRenderer 实例 map 索引。
 */
_SuperMap2["default"].LevelRenderer._instances = {};

// 工具
_SuperMap2["default"].LevelRenderer.Tool = {};

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _LevelRenderer = __webpack_require__(29);

var _LevelRenderer2 = _interopRequireDefault(_LevelRenderer);

var _Area = __webpack_require__(373);

var _Area2 = _interopRequireDefault(_Area);

var _Color = __webpack_require__(375);

var _Color2 = _interopRequireDefault(_Color);

var _ComputeBoundingBox = __webpack_require__(376);

var _ComputeBoundingBox2 = _interopRequireDefault(_ComputeBoundingBox);

var _Curve = __webpack_require__(71);

var _Curve2 = _interopRequireDefault(_Curve);

var _Env = __webpack_require__(379);

var _Env2 = _interopRequireDefault(_Env);

var _Event = __webpack_require__(380);

var _Event2 = _interopRequireDefault(_Event);

var _Http = __webpack_require__(383);

var _Http2 = _interopRequireDefault(_Http);

var _Log = __webpack_require__(384);

var _Log2 = _interopRequireDefault(_Log);

var _Math = __webpack_require__(385);

var _Math2 = _interopRequireDefault(_Math);

var _Matrix = __webpack_require__(386);

var _Matrix2 = _interopRequireDefault(_Matrix);

var _Util = __webpack_require__(31);

var _Util2 = _interopRequireDefault(_Util);

var _Vector = __webpack_require__(73);

var _Vector2 = _interopRequireDefault(_Vector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// 把所有工具对象放到全局静态变量上，以便直接调用工具方法，
// 避免使用工具时频繁的创建工具对象带来的性能消耗。
_SuperMap2["default"].LevelRenderer.Util_area = new _Area2["default"]();
_SuperMap2["default"].LevelRenderer.Util_color = new _Color2["default"]();
_SuperMap2["default"].LevelRenderer.Util_computeBoundingBox = new _ComputeBoundingBox2["default"]();
_SuperMap2["default"].LevelRenderer.Util_curve = new _Curve2["default"]();
_SuperMap2["default"].LevelRenderer.Util_env = new _Env2["default"]();
_SuperMap2["default"].LevelRenderer.Util_event = new _Event2["default"]();
_SuperMap2["default"].LevelRenderer.Util_http = new _Http2["default"]();
_SuperMap2["default"].LevelRenderer.Util_log = new _Log2["default"]();
_SuperMap2["default"].LevelRenderer.Util_math = new _Math2["default"]();
_SuperMap2["default"].LevelRenderer.Util_matrix = new _Matrix2["default"]();
_SuperMap2["default"].LevelRenderer.Util = new _Util2["default"]();
_SuperMap2["default"].LevelRenderer.Util_vector = new _Vector2["default"]();

// 下面是一些图形工具
/**
 * APIFunction: SuperMap.LevelRenderer.SUtil_smoothBezier
 * 贝塞尔平滑曲线。
 *
 * Parameters:
 * points - {Array} 线段顶点数组。
 * smooth - {Number} 平滑等级, 0-1。
 * isLoop - {Boolean} isLoop。
 * constraint - {Array} 将计算出来的控制点约束在一个包围盒内，比如 [[0, 0], [100, 100]], 这个包围盒会与整个折线的包围盒做一个并集用来约束控制点。
 * originalPosition - {Array} 参考原点。默认值：[0, 0]。
 *
 * Returns:
 * {Array} 生成的平滑节点数组。
 */
_SuperMap2["default"].LevelRenderer.SUtil_smoothBezier = function (points, smooth, isLoop, constraint, originalPosition) {
    if (!originalPosition || originalPosition !== 2) originalPosition = [0, 0];
    var __OP = originalPosition;

    var cps = [];

    var v = [];
    var v1 = [];
    var v2 = [];

    var hasConstraint = !!constraint;
    var min, max;
    if (hasConstraint) {
        min = [Infinity, Infinity];
        max = [-Infinity, -Infinity];
        for (var i = 0, len = points.length; i < len; i++) {
            _SuperMap2["default"].LevelRenderer.Util_vector.min(min, min, [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
            _SuperMap2["default"].LevelRenderer.Util_vector.max(max, max, [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
        }
        // 与指定的包围盒做并集
        _SuperMap2["default"].LevelRenderer.Util_vector.min(min, min, constraint[0]);
        _SuperMap2["default"].LevelRenderer.Util_vector.max(max, max, constraint[1]);
    }

    for (var i = 0, len = points.length; i < len; i++) {
        var point = [points[i][0] + __OP[0], points[i][1] + __OP[1]];
        var prevPoint;
        var nextPoint;

        if (isLoop) {
            prevPoint = [points[i ? i - 1 : len - 1][0] + __OP[0], points[i ? i - 1 : len - 1][1] + __OP[1]];
            nextPoint = [points[(i + 1) % len][0] + __OP[0], points[(i + 1) % len][1] + __OP[1]];
        } else {
            if (i === 0 || i === len - 1) {
                cps.push([points[i][0] + __OP[0], points[i][1] + __OP[1]]);
                continue;
            } else {
                prevPoint = [points[i - 1][0] + __OP[0], points[i - 1][1] + __OP[1]];
                nextPoint = [points[i + 1][0] + __OP[0], points[i + 1][1] + __OP[1]];
            }
        }

        _SuperMap2["default"].LevelRenderer.Util_vector.sub(v, nextPoint, prevPoint);

        // use degree to scale the handle length
        _SuperMap2["default"].LevelRenderer.Util_vector.scale(v, v, smooth);

        var d0 = _SuperMap2["default"].LevelRenderer.Util_vector.distance(point, prevPoint);
        var d1 = _SuperMap2["default"].LevelRenderer.Util_vector.distance(point, nextPoint);
        var sum = d0 + d1;
        if (sum !== 0) {
            d0 /= sum;
            d1 /= sum;
        }

        _SuperMap2["default"].LevelRenderer.Util_vector.scale(v1, v, -d0);
        _SuperMap2["default"].LevelRenderer.Util_vector.scale(v2, v, d1);
        var cp0 = _SuperMap2["default"].LevelRenderer.Util_vector.add([], point, v1);
        var cp1 = _SuperMap2["default"].LevelRenderer.Util_vector.add([], point, v2);
        if (hasConstraint) {
            _SuperMap2["default"].LevelRenderer.Util_vector.max(cp0, cp0, min);
            _SuperMap2["default"].LevelRenderer.Util_vector.min(cp0, cp0, max);
            _SuperMap2["default"].LevelRenderer.Util_vector.max(cp1, cp1, min);
            _SuperMap2["default"].LevelRenderer.Util_vector.min(cp1, cp1, max);
        }
        cps.push(cp0);
        cps.push(cp1);
    }

    if (isLoop) {
        cps.push(cps.shift());
    }

    return cps;
};

/**
 * APIFunction: SuperMap.LevelRenderer.SUtil_smoothSpline
 * 插值折线。
 *
 * Parameters:
 * points - {Array} 线段顶点数组。
 * isLoop - {Boolean} isLoop。
 * constraint - {Array} 将计算出来的控制点约束在一个包围盒内，比如 [[0, 0], [100, 100]], 这个包围盒会与整个折线的包围盒做一个并集用来约束控制点。
 * originalPosition - {Array} 参考原点。默认值：[0, 0]。
 *
 * Returns:
 * {Array} 生成的平滑节点数组。
 */
_SuperMap2["default"].LevelRenderer.SUtil_smoothSpline = function (points, isLoop, constraint, originalPosition) {
    if (!originalPosition || originalPosition !== 2) originalPosition = [0, 0];
    var __OP = originalPosition;

    var len = points.length;
    var ret = [];

    var distance = 0;
    for (var i = 1; i < len; i++) {
        distance += _SuperMap2["default"].LevelRenderer.Util_vector.distance([points[i - 1][0] + __OP[0], points[i - 1][1] + __OP[1]], [points[i][0] + __OP[0], points[i][1] + __OP[1]]);
    }

    var segs = distance / 5;
    segs = segs < len ? len : segs;
    for (var i = 0; i < segs; i++) {
        var pos = i / (segs - 1) * (isLoop ? len : len - 1);
        var idx = _Math2["default"].floor(pos);

        var w = pos - idx;

        var p0;
        var p1 = [points[idx % len][0] + __OP[0], points[idx % len][1] + __OP[1]];
        var p2;
        var p3;
        if (!isLoop) {
            p0 = [points[idx === 0 ? idx : idx - 1][0] + __OP[0], points[idx === 0 ? idx : idx - 1][1] + __OP[1]];
            p2 = [points[idx > len - 2 ? len - 1 : idx + 1][0] + __OP[0], points[idx > len - 2 ? len - 1 : idx + 1][1] + __OP[1]];
            p3 = [points[idx > len - 3 ? len - 1 : idx + 2][0] + __OP[0], points[idx > len - 3 ? len - 1 : idx + 2][1] + __OP[1]];
        } else {

            p0 = [points[(idx - 1 + len) % len][0] + __OP[0], points[(idx - 1 + len) % len][1] + __OP[1]];
            p2 = [points[(idx + 1) % len][0] + __OP[0], points[(idx + 1) % len][1] + __OP[1]];
            p3 = [points[(idx + 2) % len][0] + __OP[0], points[(idx + 2) % len][1] + __OP[1]];
        }

        var w2 = w * w;
        var w3 = w * w2;

        ret.push([interpolate(p0[0], p1[0], p2[0], p3[0], w, w2, w3), interpolate(p0[1], p1[1], p2[1], p3[1], w, w2, w3)]);
    }
    return ret;

    // inner Function
    function interpolate(p0, p1, p2, p3, t, t2, t3) {
        var v0 = (p2 - p0) * 0.5;
        var v1 = (p3 - p1) * 0.5;
        return (2 * (p1 - p2) + v0 + v1) * t3 + (-3 * (p1 - p2) - 2 * v0 - v1) * t2 + v0 * t + p1;
    }
};

/**
 * APIFunction: SuperMap.LevelRenderer.SUtil_dashedLineTo
 * 虚线 lineTo。
 */
_SuperMap2["default"].LevelRenderer.SUtil_dashedLineTo = function (ctx, x1, y1, x2, y2, dashLength, customDashPattern) {
    // http://msdn.microsoft.com/en-us/library/ie/dn265063(v=vs.85).aspx
    var dashPattern = [5, 5];
    dashLength = typeof dashLength != 'number' ? 5 : dashLength;

    if (ctx.setLineDash) {
        dashPattern[0] = dashLength;
        dashPattern[1] = dashLength;

        if (customDashPattern && customDashPattern instanceof Array) {
            ctx.setLineDash(customDashPattern);
        } else {
            ctx.setLineDash(dashPattern);
        }
        // ctx.setLineDash(dashPattern);

        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        return;
    }

    var dx = x2 - x1;
    var dy = y2 - y1;
    var numDashes = _Math2["default"].floor(_Math2["default"].sqrt(dx * dx + dy * dy) / dashLength);
    dx = dx / numDashes;
    dy = dy / numDashes;
    var flag = true;
    for (var i = 0; i < numDashes; ++i) {
        if (flag) {
            ctx.moveTo(x1, y1);
        } else {
            ctx.lineTo(x1, y1);
        }
        flag = !flag;
        x1 += dx;
        y1 += dy;
    }
    ctx.lineTo(x2, y2);
};

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Tool.Util
 * LevelRenderer 基础工具类
 *
 */
var Util = function () {

    /**
     * Constructor: SuperMap.LevelRenderer.Tool.Util
     * 构造函数。
     *
     */


    /**
     * Property: _offsetX
     * {Object}
     */


    /**
     * Property: _width
     * {Object}
     */


    /**
     * Property: _canvas
     * {Object}
     */


    /**
     * Property: BUILTIN_OBJECT
     * {Object} 用于处理merge时无法遍历Date等对象的问题
     */
    function Util() {
        _classCallCheck(this, Util);

        this.BUILTIN_OBJECT = null;
        this._ctx = null;
        this._canvas = null;
        this._pixelCtx = null;
        this._width = null;
        this._height = null;
        this._offsetX = 0;
        this._offsetY = 0;
        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Util";

        this.BUILTIN_OBJECT = {
            '[object Function]': 1,
            '[object RegExp]': 1,
            '[object Date]': 1,
            '[object Error]': 1,
            '[object CanvasGradient]': 1
        };
    }

    /**
     * APIMethod: clone
     * 对一个object进行深度拷贝。
     *
     * Parameters:
     * source - {Object} 需要进行拷贝的对象。
     *
     * Returns:
     * {Object} 拷贝后的新对象。
     */


    /**
     * Property: _offsetY
     * {Object}
     */


    /**
     * Property: _height
     * {Object}
     */


    /**
     * Property: _pixelCtx
     * {Object}
     */


    /**
     * Property: _ctx
     * {Object}
     */


    _createClass(Util, [{
        key: 'clone',
        value: function clone(source) {
            var BUILTIN_OBJECT = this.BUILTIN_OBJECT;
            if ((typeof source === 'undefined' ? 'undefined' : _typeof(source)) == 'object' && source !== null) {
                var result = source;
                if (source instanceof Array) {
                    result = [];
                    for (var i = 0, len = source.length; i < len; i++) {
                        result[i] = this.clone(source[i]);
                    }
                } else if (!BUILTIN_OBJECT[Object.prototype.toString.call(source)]) {
                    result = {};
                    for (var key in source) {
                        if (source.hasOwnProperty(key)) {
                            result[key] = this.clone(source[key]);
                        }
                    }
                }

                return result;
            }

            return source;
        }

        /**
         * Method: mergeItem
         * 合并源对象的单个属性到目标对象。
         *
         * Parameters:
         * target - {Object} 目标对象。
         * source - {Object} 源对象。
         * key - {String} 键。
         * overwrite - {Boolean} 是否覆盖。
         *
         * Returns:
         * {Object} 目标对象。
         */

    }, {
        key: 'mergeItem',
        value: function mergeItem(target, source, key, overwrite) {
            var BUILTIN_OBJECT = this.BUILTIN_OBJECT;
            if (source.hasOwnProperty(key)) {
                if (_typeof(target[key]) == 'object' && !BUILTIN_OBJECT[Object.prototype.toString.call(target[key])]) {
                    // 如果需要递归覆盖，就递归调用merge
                    this.merge(target[key], source[key], overwrite);
                } else if (overwrite || !(key in target)) {
                    // 否则只处理overwrite为true，或者在目标对象中没有此属性的情况
                    target[key] = source[key];
                }
            }
        }

        /**
         * APIMethod: merge
         * 合并源对象的属性到目标对象。
         *
         * Parameters:
         * target - {Object} 目标对象。
         * source - {Object} 源对象。
         * overwrite - {Boolean} 是否覆盖。
         *
         * Returns:
         * {Object} 目标对象。
         */

    }, {
        key: 'merge',
        value: function merge(target, source, overwrite) {
            for (var i in source) {
                this.mergeItem(target, source, i, overwrite);
            }

            return target;
        }

        /**
         * Method: getContext
         * 获取 Cavans 上下文
         *
         * Returns:
         * {Object} Cavans 上下文。
         */

    }, {
        key: 'getContext',
        value: function getContext() {
            if (!this._ctx) {
                this._ctx = document.createElement('canvas').getContext('2d');
            }
            return this._ctx;
        }

        /**
         * APIMethod: getPixelContext
         * 获取像素拾取专用的上下文
         *
         * Returns:
         * {Object}像素拾取专用的上下文。
         */

    }, {
        key: 'getPixelContext',
        value: function getPixelContext() {
            if (!this._pixelCtx) {
                this._canvas = document.createElement('canvas');
                this._width = this._canvas.width;
                this._height = this._canvas.height;
                this._pixelCtx = this._canvas.getContext('2d');
            }
            return this._pixelCtx;
        }

        /**
         * APIMethod: adjustCanvasSize
         * 如果坐标处在_canvas外部，改变_canvas的大小
         *
         * 注意 修改canvas的大小 需要重新设置translate
         *
         * Parameters:
         * x - {Number} 横坐标。
         * y - {Number} 纵坐标。
         *
         */

    }, {
        key: 'adjustCanvasSize',
        value: function adjustCanvasSize(x, y) {
            var _canvas = this._canvas;
            var _pixelCtx = this._pixelCtx;
            var _width = this._width;
            var _height = this._height;
            var _offsetX = this._offsetX;
            var _offsetY = this._offsetY;

            // 每次加的长度
            var _v = 100;
            var _flag;

            if (x + _offsetX > _width) {
                _width = x + _offsetX + _v;
                _canvas.width = _width;
                _flag = true;
            }

            if (y + _offsetY > _height) {
                _height = y + _offsetY + _v;
                _canvas.height = _height;
                _flag = true;
            }

            if (x < -_offsetX) {
                _offsetX = Math.ceil(-x / _v) * _v;
                _width += _offsetX;
                _canvas.width = _width;
                _flag = true;
            }

            if (y < -_offsetY) {
                _offsetY = Math.ceil(-y / _v) * _v;
                _height += _offsetY;
                _canvas.height = _height;
                _flag = true;
            }

            if (_flag) {
                _pixelCtx.translate(_offsetX, _offsetY);
            }
        }

        /**
         * APIMethod: getPixelOffset
         * 获取像素canvas的偏移量
         *
         * Returns:
         * {Object}偏移量。
         */

    }, {
        key: 'getPixelOffset',
        value: function getPixelOffset() {
            return {
                x: this._offsetX,
                y: this._offsetY
            };
        }

        /**
         * APIMethod: indexOf
         * 查询数组中元素的index
         *
         * Returns:
         * {Object}偏移量。
         */

    }, {
        key: 'indexOf',
        value: function indexOf(array, value) {
            if (array.indexOf) {
                return array.indexOf(value);
            }
            for (var i = 0, len = array.length; i < len; i++) {
                if (array[i] === value) {
                    return i;
                }
            }
            return -1;
        }

        /**
         * APIMethod: inherits
         * 构造类继承关系
         *
         * Parameters:
         * clazz - {Function} 源类。
         * baseClazz - {Function} 基类。
         *
         * Returns:
         * {Object}偏移量。
         */

    }, {
        key: 'inherits',
        value: function inherits(clazz, baseClazz) {
            var clazzPrototype = clazz.prototype;

            function F() {}

            F.prototype = baseClazz.prototype;
            clazz.prototype = new F();

            for (var prop in clazzPrototype) {
                clazz.prototype[prop] = clazzPrototype[prop];
            }
            clazz.constructor = clazz;
        }
    }]);

    return Util;
}();

exports["default"] = Util;

_SuperMap2["default"].LevelRenderer.Tool.Util = Util;

/***/ }),
/* 32 */
/***/ (function(module, exports) {

module.exports = function(x) {
  if (Math.abs(x) > 1) {
    x = (x > 1) ? 1 : -1;
  }
  return Math.asin(x);
};

/***/ }),
/* 33 */
/***/ (function(module, exports) {

module.exports = function(eccent, sinphi, cosphi) {
  var con = eccent * sinphi;
  return cosphi / (Math.sqrt(1 - con * con));
};

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.DataReturnOption
 * @classdesc 数据返回设置类。
 * @param options - {Object} 可选参数。如：<br>
 *         expectCount - {number} 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。<br>
 *         dataset - {string} 设置结果数据集标识，当dataReturnMode为 SuperMap.DataReturnMode.DATASET_ONLY或SuperMap.DataReturnMode.DATASET_AND_RECORDSET时有效，
 *                            作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。<br>
 *         dataReturnMode - {@link SuperMap.DataReturnMode} 数据返回模式，默认为SuperMap.DataReturnMode.RECORDSET_ONLY。<br>
 *         deleteExistResultDataset - {boolean} 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。默认为true。<br>
 */
var DataReturnOption = function () {

    /**
     * @member SuperMap.DataReturnOption.prototype.dataReturnMode -{SuperMap.DataReturnMode}
     * @description 数据返回模式，默认为SuperMap.DataReturnMode.RECORDSET_ONLY。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.expectCount -{number}
     * @description 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。
     */
    function DataReturnOption(options) {
        _classCallCheck(this, DataReturnOption);

        this.expectCount = 1000;
        this.dataset = null;
        this.dataReturnMode = _REST.DataReturnMode.RECORDSET_ONLY;
        this.deleteExistResultDataset = true;
        this.CLASS_NAME = "SuperMap.DataReturnOption";

        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.DataReturnOption.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.deleteExistResultDataset -{boolean}
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */


    /**
     * @member SuperMap.DataReturnOption.prototype.dataset -{string}
     * @description 设置结果数据集标识，当dataReturnMode为 SuperMap.DataReturnMode.DATASET_ONLY
     * 或SuperMap.DataReturnMode.DATASET_AND_RECORDSET时有效，
     * 作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。
     */


    _createClass(DataReturnOption, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.expectCount = null;
            me.dataset = null;
            me.dataReturnMode = null;
            me.deleteExistResultDataset = null;
        }
    }]);

    return DataReturnOption;
}();

exports["default"] = DataReturnOption;


_SuperMap2["default"].DataReturnOption = DataReturnOption;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.FacilityAnalyst3DParameters
 * @classdesc 最近设施分析参数基类。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *               设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在10分钟内能到达的最近医院，
 *               超过10分钟能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起
 *               作用的障碍边、障碍点、转向表、耗费等属性在最近设施分析时同样可设置。
 * @param options - {Object} 可选参数。如：<br>
 *         edgeID - {number} 指定的弧段ID。<br>
 *         nodeID - {integer} 指定的结点ID。<br>
 *         weightName -{string} 指定的权值字段信息对象的名称。<br>
 *         isUncertainDirectionValid - {boolean} 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 *                                               指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */
var FacilityAnalyst3DParameters = function () {

    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.weightName - string}
     * @description 指定的权值字段信息对象的名称。
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.edgeID - {number}
     * @description 指定的弧段ID。
     */
    function FacilityAnalyst3DParameters(options) {
        _classCallCheck(this, FacilityAnalyst3DParameters);

        this.edgeID = null;
        this.nodeID = null;
        this.weightName = null;
        this.isUncertainDirectionValid = false;
        this.CLASS_NAME = "SuperMap.FacilityAnalyst3DParameters";

        var me = this;
        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(me, options);
    }

    /**
     * @function SuperMap.FacilityAnalyst3DParameters.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.isUncertainDirectionValid - {boolean}
     * @description 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
     *                指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找
     */


    /**
     * @member SuperMap.FacilityAnalyst3DParameters.prototype.nodeID - {number}
     * @description 指定的结点ID。
     */


    _createClass(FacilityAnalyst3DParameters, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.edgeID = null;
            me.nodeID = null;
            me.weightName = null;
            me.isUncertainDirectionValid = null;
        }
    }]);

    return FacilityAnalyst3DParameters;
}();

exports["default"] = FacilityAnalyst3DParameters;

_SuperMap2["default"].FacilityAnalyst3DParameters = FacilityAnalyst3DParameters;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.GetFeaturesParametersBase
 * @classdesc 要素查询参数基类
 * @param options - {Object} 参数。如：<br>
 *        datasetNames - {Array<string>} 数据集集合中的数据集名称列表。</br>
 *        returnContent - {boolean} 是否直接返回查询结果。</br>
 *        fromIndex - {integer} 查询结果的最小索引号。</br>
 *        toIndex - {integer} 查询结果的最大索引号。</br>
 */
var GetFeaturesParametersBase = function () {

    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.returnCountOnly - {boolean}
     * @description 只返回查询结果的总数，默认为false。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.fromIndex - {integer}
     * @description 查询结果的最小索引号。默认值是0，如果该值大于查询结果的最大索引号，则查询结果为空。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.datasetName - {Array<string>}
     * @description 数据集集合中的数据集名称列表。
     */
    function GetFeaturesParametersBase(options) {
        _classCallCheck(this, GetFeaturesParametersBase);

        this.datasetNames = null;
        this.returnContent = true;
        this.fromIndex = 0;
        this.toIndex = 19;
        this.returnCountOnly = false;
        this.maxFeatures = null;
        this.CLASS_NAME = "SuperMap.GetFeaturesParametersBase";

        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     *
     * @function SuperMap.GetFeaturesParametersBase.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.maxFeatures - {integer}
     * @description 进行SQL查询时，用于设置服务端返回查询结果条目数量，默认为1000。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.toIndex - {integer}
     * @description 查询结果的最大索引号。默认值是19，如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
     */


    /**
     * @member SuperMap.GetFeaturesParametersBase.prototype.returnContent - {boolean}
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     *              如果为 true，则直接返回新创建资源，即查询结果的表述。
     *              如果为 false，则返回的是查询结果资源的 URI。默认为 true。
     */


    _createClass(GetFeaturesParametersBase, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.datasetNames = null;
            me.returnContent = null;
            me.fromIndex = null;
            me.toIndex = null;
            me.maxFeatures = null;
        }
    }]);

    return GetFeaturesParametersBase;
}();

exports["default"] = GetFeaturesParametersBase;


_SuperMap2["default"].GetFeaturesParametersBase = GetFeaturesParametersBase;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

var _CommonServiceBase2 = __webpack_require__(3);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _GeoJSON = __webpack_require__(9);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.GetFeaturesServiceBase
 * @classdesc 数据服务中数据集查询服务基类。获取结果数据类型为Object。包含 result属性，result的数据格式根据format参数决定为GeoJSON或者iServerJSON。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 数据查询结果资源地址。请求数据服务中数据集查询服务，URL
 * 应为：http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/
 * 例如："http://localhost:8090/iserver/services/data-jingjin/rest/data/"
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myService = new SuperMap.GetFeaturesServiceBase(url, {
 *     eventListeners: {
 *         "processCompleted": getFeatureCompleted,
 *         "processFailed": getFeatureError
 *     }
 * });
 */
var GetFeaturesServiceBase = function (_CommonServiceBase) {
    _inherits(GetFeaturesServiceBase, _CommonServiceBase);

    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.maxFeatures - {integer}
     * @description 进行SQL查询时，用于设置服务端返回查询结果条目数量，默认为1000。
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.fromIndex - {integer}
     * @description 查询结果的最小索引号。
     * 默认值是0，如果该值大于查询结果的最大索引号，则查询结果为空。
     */
    function GetFeaturesServiceBase(url, options) {
        _classCallCheck(this, GetFeaturesServiceBase);

        var _this = _possibleConstructorReturn(this, (GetFeaturesServiceBase.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase)).call(this, url, options));

        _this.returnContent = true;
        _this.fromIndex = 0;
        _this.toIndex = 19;
        _this.maxFeatures = null;
        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.GetFeaturesServiceBase";

        options = options || {};
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        var me = _this,
            end;
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);
        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (me.format==="geojson" ) {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end == "/" ? "featureResults.json?" : "/featureResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.GetFeaturesServiceBase.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.format - {string}
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。
     *  参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.toIndex - {integer}
     * @description 查询结果的最大索引号。
     * 如果该值大于查询结果的最大索引号，则以查询结果的最大索引号为终止索引号。
     */

    /**
     * @member SuperMap.GetFeaturesServiceBase.prototype.returnContent - {boolean}
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     * 如果为 true，则直接返回新创建资源，即查询结果的表述。
     * 如果为 false，则返回的是查询结果资源的 URI。默认为 false。
     */


    _createClass(GetFeaturesServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(GetFeaturesServiceBase.prototype.__proto__ || Object.getPrototypeOf(GetFeaturesServiceBase.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.fromIndex = null;
            me.toIndex = null;
            me.maxFeatures = null;
            me.format = null;
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.processAsync
         * @description  将客户端的查询参数传递到服务端。
         * @param params - {Object} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                jsonParameters = null,
                firstPara = true;

            me.returnContent = params.returnContent;
            me.fromIndex = params.fromIndex;
            me.toIndex = params.toIndex;
            me.maxFeatures = params.maxFeatures;
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
                firstPara = false;
            }
            var isValidNumber = me.fromIndex != null && me.toIndex != null && !isNaN(me.fromIndex) && !isNaN(me.toIndex);
            if (isValidNumber && me.fromIndex >= 0 && me.toIndex >= 0 && !firstPara) {
                me.url += "&fromIndex=" + me.fromIndex + "&toIndex=" + me.toIndex;
            }

            if (params.returnCountOnly) me.url += "&returnCountOnly=" + params.returnContent;
            jsonParameters = me.getJsonParameters(params);
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /**
         * @function SuperMap.GetFeaturesServiceBase.prototype.getFeatureComplete
         * @description 查询完成，执行此方法。
         * @param result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2["default"].Util.transformResult(result);
            if (me.format === _REST.DataFormat.GEOJSON && result.features) {
                var geoJSONFormat = new _GeoJSON2["default"]();
                result.features = JSON.parse(geoJSONFormat.write(result.features));
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }
    }]);

    return GetFeaturesServiceBase;
}(_CommonServiceBase3["default"]);

exports["default"] = GetFeaturesServiceBase;


_SuperMap2["default"].GetFeaturesServiceBase = GetFeaturesServiceBase;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ClipParameter = __webpack_require__(196);

var _ClipParameter2 = _interopRequireDefault(_ClipParameter);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.InterpolationAnalystParameters
 * @classdesc 插值分析参数类。
 * @param options - {Object} 可选参数。如：</br>
 *        bounds - {Object} 插值分析的范围，用于确定结果栅格数据集的范围。Bounds类型可以是SuperMap.Bounds|L.Bounds|ol.extent。</br>
 *        searchRadius - {number} 查找半径，即参与运算点的查找范围，与点数据集单位相同。</br>
 *        zValueFieldName - {string} 存储用于进行插值分析的字段名称，插值分析不支持文本类型的字段。</br>
 *        zValueScale - {number} 用于进行插值分析值的缩放比率，默认为1。</br>
 *        resolution - {number} 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。</br>
 *        filterQueryParameter - {{@link SuperMap.FilterParameter}} 属性过滤条件。</br>
 *        outputDatasetName - {string} 插值分析结果数据集的名称。</br>
 *        outputDatasourceName - {string} 插值分析结果数据源的名称。</br>
 *        pixelFormat - {{@link SuperMap.PixelFormat}} 指定结果栅格数据集存储的像素格式。</br>
 *        dataset - {string} 用于做插值分析的数据源中数据集的名称。</br>
 *        inputPoints - {Array <Object>} 用于做插值分析的离散点集合。点类型可以是：SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point。</br>
 *        InterpolationAnalystType - {string} 插值分析类型（dataset或geometry），默认为dataset 。</br>
 */
var InterpolationAnalystParameters = function () {

    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.InterpolationAnalystType - {string}
     * @description  插值分析类型。差值分析包括数据集插值分析和几何插值分析两类，
     * "dataset"表示对数据集进行插值分析，"geometry"表示对离散点数组进行插值分析，默认值为"dataset"。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.dataset - {string}
     * @description 用来做插值分析的数据源中数据集的名称，该名称用形如"数据集名称@数据源别名"形式来表示。
     * 当插值分析类型(InterpolationAnalystType)为 dataset 时，必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.outputDatasourceName - {string}
     * @description 插值分析结果数据源的名称。必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.filterQueryParameter - {SuperMap.FilterParameter}
     * @description 过滤条件，对分析数据集中的点进行过滤，不设置时默认为null，即对数据集中的所有点进行分析。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.zValueScale - {number}
     * @description 用于进行插值分析值的缩放比率，默认值为1。
     * 参加插值分析的值将乘以该参数值后再进行插值，也就是对进行插值分析的值进行统一的扩大或缩小。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.searchRadius - {number}
     * @description 查找半径，即参与运算点的查找范围，与点数据集单位相同，默认值为0。
     * 计算某个位置的Z 值时，会以该位置为圆心，以查找范围的值为半径，落在这个范围内的采样点都将参与运算。
     * 该值需要根据待插值点数据的分布状况和点数据集范围进行设置。
     */
    function InterpolationAnalystParameters(options) {
        _classCallCheck(this, InterpolationAnalystParameters);

        this.bounds = null;
        this.searchRadius = 0;
        this.zValueFieldName = null;
        this.zValueScale = 1;
        this.resolution = null;
        this.filterQueryParameter = null;
        this.outputDatasetName = null;
        this.outputDatasourceName = null;
        this.pixelFormat = _REST.PixelFormat.BIT16;
        this.dataset = null;
        this.inputPoints = null;
        this.InterpolationAnalystType = "dataset";
        this.clipParam = null;
        this.CLASS_NAME = "SuperMap.InterpolationAnalystParameters";

        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     * @function SuperMap.InterpolationAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.clipParam - {Object}
     * @description 对插值分析结果进行裁剪的参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.inputPoints - {Array<Object>}
     * @description 用于做插值分析的离散点（离散点包括Z值）集合。
     * 点类型可以是：SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point。
     * 当插值分析类型（InterpolationAnalystType）为 geometry 时，此参数为必设参数。
     * 通过离散点直接进行插值分析不需要指定输入数据集inputDatasourceName，inputDatasetName以及zValueFieldName。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.pixelFormat - {SuperMap.PixelFormat}
     * @description 指定结果栅格数据集存储的像素格式。
     * 默认值为 SuperMap.PixelFormat.BIT16。
     * 支持存储的像素格式有 BIT16、BIT32、DOUBLE、SINGLE、UBIT1、UBIT4、UBIT8、UBIT24、UBIT32。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.outputDatasetName - {string}
     * @description 插值分析结果数据集的名称。必设参数。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.resolution - {number}
     * @description 插值结果栅格数据集的分辨率，即一个像元所代表的实地距离，与点数据集单位相同。
     * 该值不能超过待分析数据集的范围边长。
     * 且该值设置时，应该考虑点数据集范围大小来取值，一般为结果栅格行列值（即结果栅格数据集范围除以分辨率），在500以内可以较好地体现密度走势。
     */


    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.zValueFieldName - {string}
     * @description 数据集插值分析中，用于指定进行插值分析的目标字段名，插值分析不支持文本类型的字段。
     * 含义为每个插值点在插值过程中的权重，可以将所有点此字段值设置为1，即所有点在整体插值中权重相同。
     * 当插值分析类型(InterpolationAnalystType)为 dataset 时，必设参数。
     */

    /**
     * @member SuperMap.InterpolationAnalystParameters.prototype.bounds - {Object}
     * @description 插值分析的范围，用于确定结果栅格数据集的范围。
     * Bounds类型可以是SuperMap.Bounds|L.Bounds|ol.extent。
     * 如果缺省，则默认为原数据集的范围。鉴于此插值方法为内插方法，原数据集的范围内的插值结果才相对有参考价值，
     * 因此建议此参数不大于原数据集范围。
     */


    _createClass(InterpolationAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.bounds = null;
            me.searchRadius = null;
            me.zValueFieldName = null;
            me.zValueScale = null;

            me.resolution = null;
            me.filterQueryParameter = null;
            me.outputDatasetName = null;
            me.pixelFormat = null;
        }

        /**
         * @function SuperMap.InterpolationAnalystParameters.toObject
         * @param interpolationAnalystParameters - {SuperMap.InterpolationAnalystParameters} 插值分析参数类。
         * @param tempObj - {SuperMap.InterpolationAnalystParameters} 插值分析参数对象。
         * @description 将插值分析参数对象转换成JSON对象。
         * @return JSON对象。
         */

    }], [{
        key: 'toObject',
        value: function toObject(interpolationAnalystParameters, tempObj) {
            for (var name in interpolationAnalystParameters) {
                if (name === "inputPoints" && interpolationAnalystParameters.InterpolationAnalystType === "geometry") {
                    var objs = [];
                    for (var i = 0; i < interpolationAnalystParameters.inputPoints.length; i++) {
                        var item = interpolationAnalystParameters.inputPoints[i];
                        var obj = {
                            x: item.x,
                            y: item.y,
                            z: item.tag
                        };
                        objs.push(obj);
                    }
                    tempObj[name] = objs;
                } else {
                    tempObj[name] = interpolationAnalystParameters[name];
                }
            }
        }
    }]);

    return InterpolationAnalystParameters;
}();

exports["default"] = InterpolationAnalystParameters;


_SuperMap2["default"].InterpolationAnalystParameters = InterpolationAnalystParameters;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(3);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _FetchRequest = __webpack_require__(15);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ProcessingServiceBase
 * @description 分布式分析服务基类
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 分布式分析服务地址。
 * @param options - {Object} 参数。如：<br>
 *        events - {{@link SuperMap.Events}} 处理所有事件的对象。<br>
 *        eventListeners - {Object} 听器对象。<br>
 *        serverType - {{@link ServerType}} 服务器类型，iServer|iPortal|Online。<br>
 *        index - {number}服务访问地址在数组中的位置。<br>
 *        length - {number}服务访问地址数组长度。
 */
var ProcessingServiceBase = function (_CommonServiceBase) {
    _inherits(ProcessingServiceBase, _CommonServiceBase);

    function ProcessingServiceBase(url, options) {
        _classCallCheck(this, ProcessingServiceBase);

        options = options || {};
        /*
         * Constant: EVENT_TYPES
         * {Array<string>}
         * 此类支持的事件类型
         * - *processCompleted* 创建成功后触发的事件。
         * - *processFailed* 创建失败后触发的事件 。
         * - *processRunning* 创建过程的整个阶段都会触发的事件，用于获取创建过程的状态 。
         */
        options.EVENT_TYPES = ["processCompleted", "processFailed", "processRunning"];

        var _this = _possibleConstructorReturn(this, (ProcessingServiceBase.__proto__ || Object.getPrototypeOf(ProcessingServiceBase)).call(this, url, options));

        _this.CLASS_NAME = "SuperMap.ProcessingServiceBase";
        return _this;
    }

    /**
     * @function SuperMap.ProcessingServiceBase.prototype.destroy
     * @override
     */


    _createClass(ProcessingServiceBase, [{
        key: 'destroy',
        value: function destroy() {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.getJobs
         * @description 获取分布式分析任务。
         * @param url - {string} 资源地址。
         */

    }, {
        key: 'getJobs',
        value: function getJobs(url) {
            var me = this;
            _FetchRequest.FetchRequest.get(url).then(function (response) {
                return response.json();
            }).then(function (result) {
                me.events.triggerEvent("processCompleted", { result: result });
            })["catch"](function (e) {
                me.eventListeners.processFailed({ error: e });
            });
        }

        /**
         * @function SuperMap.ProcessingServiceBase.prototype.addJob
         * @description 添加分布式分析任务。
         * @param url - {string} 资源根地址。
         * @param params - {Object} 创建一个空间分析的请求参数。
         * @param paramType - {string} - 请求参数类型。
         * @param seconds - {number}开始创建后，获取创建成功结果的时间间隔。
         */

    }, {
        key: 'addJob',
        value: function addJob(url, params, paramType, seconds) {
            var me = this,
                parameterObject = null;
            if (params && params instanceof paramType) {
                parameterObject = new Object();
                paramType.toObject(params, parameterObject);
            }
            var options = {
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            };
            _FetchRequest.FetchRequest.post(me._processUrl(url), JSON.stringify(parameterObject), options).then(function (response) {
                return response.json();
            }).then(function (result) {
                if (result.succeed) {
                    me.serviceProcessCompleted(result, seconds);
                } else {
                    me.serviceProcessFailed(result);
                }
            })["catch"](function (e) {
                me.serviceProcessFailed({ error: e });
            });
        }
    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result, seconds) {
            result = _SuperMap2["default"].Util.transformResult(result);
            seconds = seconds || 1000;
            var me = this;
            if (result) {
                var id = setInterval(function () {
                    _FetchRequest.FetchRequest.get(result.newResourceLocation).then(function (response) {
                        return response.json();
                    }).then(function (job) {
                        me.events.triggerEvent("processRunning", { id: job.id, state: job.state });
                        if (job.state.runState === 'LOST' || job.state.runState === 'KILLED' || job.state.runState === 'FAILED') {
                            clearInterval(id);
                            me.events.triggerEvent("processFailed", { error: job.state.errorMsg, state: job.state.runState });
                        }
                        if (job.state.runState === 'FINISHED' && job.setting.serviceInfo) {
                            clearInterval(id);
                            me.events.triggerEvent("processCompleted", { result: job });
                        }
                    })["catch"](function (e) {
                        clearInterval(id);
                        me.events.triggerEvent("processFailed", { error: e });
                    });
                }, seconds);
            }
        }
    }, {
        key: 'serviceProcessFailed',
        value: function serviceProcessFailed(result) {
            _get(ProcessingServiceBase.prototype.__proto__ || Object.getPrototypeOf(ProcessingServiceBase.prototype), 'serviceProcessFailed', this).call(this, result);
        }

        //为不是以.json结尾的url加上.json，并且如果有token的话，在.json后加上token参数。

    }, {
        key: '_processUrl',
        value: function _processUrl(url) {
            if (url.indexOf('.json') === -1) {
                url += '.json';
            }
            if (_SuperMap2["default"].SecurityManager.getToken(url)) {
                url += '?token=' + _SuperMap2["default"].SecurityManager.getToken(url);
            }
            return url;
        }
    }]);

    return ProcessingServiceBase;
}(_CommonServiceBase3["default"]);

exports["default"] = ProcessingServiceBase;


_SuperMap2["default"].ProcessingServiceBase = ProcessingServiceBase;

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var HALF_PI = Math.PI/2;
var sign = __webpack_require__(46);

module.exports = function(x) {
  return (Math.abs(x) < HALF_PI) ? x : (x - (sign(x) * Math.PI));
};

/***/ }),
/* 41 */
/***/ (function(module, exports) {

module.exports = function(x) {
  return (1 - 0.25 * x * (1 + x / 16 * (3 + 1.25 * x)));
};

/***/ }),
/* 42 */
/***/ (function(module, exports) {

module.exports = function(x) {
  return (0.375 * x * (1 + 0.25 * x * (1 + 0.46875 * x)));
};

/***/ }),
/* 43 */
/***/ (function(module, exports) {

module.exports = function(x) {
  return (0.05859375 * x * x * (1 + 0.75 * x));
};

/***/ }),
/* 44 */
/***/ (function(module, exports) {

module.exports = function(x) {
  return (x * x * x * (35 / 3072));
};

/***/ }),
/* 45 */
/***/ (function(module, exports) {

module.exports = function(e0, e1, e2, e3, phi) {
  return (e0 * phi - e1 * Math.sin(2 * phi) + e2 * Math.sin(4 * phi) - e3 * Math.sin(6 * phi));
};

/***/ }),
/* 46 */
/***/ (function(module, exports) {

module.exports = function(x) {
  return x<0 ? -1 : 1;
};

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Feature
 * @classdesc 要素类组合了地理和属性，Feature 类同时具有 marker 和 lonlat 属性。
 * @param layer - {SuperMap.Layer} 图层。
 * @param lonlat - {SuperMap.LonLat} 经纬度。
 * @param data - {Object} 数据对象。
 */
var Feature = function () {

    /**
     * @member SuperMap.Feature.prototype.lonlat - {SuperMap.LonLat}
     * @description 经纬度。
     *
     */


    /**
     * @deprecated
     * @member SuperMap.Feature.prototype.layer - {SuperMap.Layer}
     * @description 图层。
     */
    function Feature(layer, lonlat, data) {
        _classCallCheck(this, Feature);

        this.layer = null;
        this.id = null;
        this.lonlat = null;
        this.data = null;
        this.CLASS_NAME = "SuperMap.Feature";

        this.layer = layer;
        this.lonlat = lonlat;
        this.data = data != null ? data : {};
        this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");
    }

    /**
     * @function SuperMap.Feature.prototype.destroy
     * @description 释放相关资源。
     */


    /**
     * @member SuperMap.Feature.prototype.data - {Object}
     * @description 数据对象。
     */


    /**
     * @member SuperMap.Feature.prototype.id - {string}
     * @description 要素id。
     */


    _createClass(Feature, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.lonlat = null;
            this.data = null;
        }
    }]);

    return Feature;
}();

exports["default"] = Feature;

_SuperMap2["default"].Feature = Feature;

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection = __webpack_require__(20);

var _Collection2 = _interopRequireDefault(_Collection);

var _LineString2 = __webpack_require__(25);

var _LineString3 = _interopRequireDefault(_LineString2);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _BaseTypes = __webpack_require__(56);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class  SuperMap.Geometry.LinearRing
 * @classdesc 几何对象线环类，是一个特殊的封闭的线串，在每次addPoint/removePoint之后会通过添加一个点（此点是复制的第一个点得到的）
 *             作为最后的一个点来自动关闭线环。
 * @extends {SuperMap.Geometry.LineString}
 * @param points {Array<SuperMap.Geometry.Point>} 组成线性环的点。
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *      new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *      new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *      new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *      new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var linearRing = new SuperMap.Geometry.LinearRing(points);
 */
var LinearRing = function (_LineString) {
    _inherits(LinearRing, _LineString);

    function LinearRing(points) {
        _classCallCheck(this, LinearRing);

        var _this = _possibleConstructorReturn(this, (LinearRing.__proto__ || Object.getPrototypeOf(LinearRing)).call(this, points));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.LinearRing";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.LinearRing.prototype.addComponent
     * @description 添加一个点到几何图形数组中，如果这个点将要被添加到组件数组的末端，并且与数组中已经存在的最后一个点相同，
     *                重复的点是不能被添加的。这将影响未关闭环的关闭。这个方法可以通过将非空索引（组件数组的下标）作为第二个参数重写。
     * @param point {SuperMap.Geometry.Point} 点对象。
     * @param index {integer} 插入组件数组的下标。
     * @returns {boolean} 点对象是否添加成功。
     */


    /**
     * @member SuperMap.Geometry.LinearRing.prototype.componentTypes - {Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Point}"]
     */


    _createClass(LinearRing, [{
        key: 'addComponent',
        value: function addComponent(point, index) {
            var added = false;

            //remove last point
            var lastPoint = this.components.pop();

            // given an index, add the point
            // without an index only add non-duplicate points
            if (index != null || !point.equals(lastPoint)) {
                added = _Collection2["default"].prototype.addComponent.apply(this, arguments);
            }

            //append copy of first point
            var firstPoint = this.components[0];
            _Collection2["default"].prototype.addComponent.apply(this, [firstPoint]);

            return added;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.removeComponent
         * @description 从几何组件中删除一个点。
         * @param point {SuperMap.Geometry.Point} 点对象。
         * @returns {boolean} 点对象是否删除。
         */

    }, {
        key: 'removeComponent',
        value: function removeComponent(point) {
            var removed = this.components && this.components.length > 3;
            if (removed) {
                //remove last point
                this.components.pop();

                //remove our point
                _Collection2["default"].prototype.removeComponent.apply(this, arguments);
                //append copy of first point
                var firstPoint = this.components[0];
                _Collection2["default"].prototype.addComponent.apply(this, [firstPoint]);
            }
            return removed;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.move
         * @description 沿着给定的x、y轴正方向按照给定的位移移动一个几何图形，move 不仅改变了几何图形的位置并且清理了边界缓存。
         * @param x {float} x轴正方向上的偏移量。
         * @param y {float} y轴正方向上的偏移量。
         */

    }, {
        key: 'move',
        value: function move(x, y) {
            for (var i = 0, len = this.components.length; i < len - 1; i++) {
                this.components[i].move(x, y);
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.rotate
         * @description 围绕中心点旋转几何图形。
         * @param angle {float} 旋转角的度数（沿着x轴正方向的逆时针方向）。
         * @param origin {SuperMap.Geometry.Point} 旋转中心点。
         */

    }, {
        key: 'rotate',
        value: function rotate(angle, origin) {
            for (var i = 0, len = this.components.length; i < len - 1; ++i) {
                this.components[i].rotate(angle, origin);
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.resize
         * @description 调整几何对象的大小。
         * @param scale - {float} 几何图形缩放的比例系数，是几何图形维数的两倍。（如：对于线来说将以线2倍的长度拉长，对于多边形来说，将以面积的4倍变化）。
         * @param origin {SuperMap.Geometry.Point} 调整大小选定的起始原点。
         * @param ratio {float} 可选的xy的比例，默认的比例为1。
         * @returns {SuperMap.Geometry} 当前的几何对象。
         */

    }, {
        key: 'resize',
        value: function resize(scale, origin, ratio) {
            for (var i = 0, len = this.components.length; i < len - 1; ++i) {
                this.components[i].resize(scale, origin, ratio);
            }
            return this;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getCentroid
         * @description 获取几何对象的质心。
         * @returns {SuperMap.Geometry.Point} 几何图形的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            if (this.components) {
                var len = this.components.length;
                if (len > 0 && len <= 2) {
                    return this.components.clone();
                } else if (len > 2) {
                    var sumX = 0.0;
                    var sumY = 0.0;
                    var x0 = this.components[0].x;
                    var y0 = this.components[0].y;
                    var area = -1 * this.getArea();
                    if (area != 0) {
                        for (var i = 0; i < len - 1; i++) {
                            var b = this.components[i];
                            var c = this.components[i + 1];
                            sumX += (b.x + c.x - 2 * x0) * ((b.x - x0) * (c.y - y0) - (c.x - x0) * (b.y - y0));
                            sumY += (b.y + c.y - 2 * y0) * ((b.x - x0) * (c.y - y0) - (c.x - x0) * (b.y - y0));
                        }
                        var x = x0 + sumX / (6 * area);
                        var y = y0 + sumY / (6 * area);
                    } else {
                        for (var i = 0; i < len - 1; i++) {
                            sumX += this.components[i].x;
                            sumY += this.components[i].y;
                        }
                        var x = sumX / (len - 1);
                        var y = sumY / (len - 1);
                    }
                    return new _Point2["default"](x, y);
                } else {
                    return null;
                }
            }
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getArea
         * @description 获得当前几何对象区域大小，如果是沿顺时针方向的环则是正值，否则为负值。
         * @returns {float} 环的面积。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 2) {
                var sum = 0.0;
                for (var i = 0, len = this.components.length; i < len - 1; i++) {
                    var b = this.components[i];
                    var c = this.components[i + 1];
                    sum += (b.x + c.x) * (c.y - b.y);
                }
                area = -sum / 2.0;
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.containsPoint
         * @description 判断点是否在线环上，是返回1，不是返回0。
         * @param point {SuperMap.Geometry.Point}
         * @returns {boolean | number} 点是否在线环上。
         */

    }, {
        key: 'containsPoint',
        value: function containsPoint(point) {
            var approx = _BaseTypes.NumberExt.limitSigDigs;
            var digs = 14;
            var px = approx(point.x, digs);
            var py = approx(point.y, digs);

            function getX(y, x1, y1, x2, y2) {
                return (y - y2) * ((x2 - x1) / (y2 - y1)) + x2;
            }

            var numSeg = this.components.length - 1;
            var start, end, x1, y1, x2, y2, cx, cy;
            var crosses = 0;
            for (var i = 0; i < numSeg; ++i) {
                start = this.components[i];
                x1 = approx(start.x, digs);
                y1 = approx(start.y, digs);
                end = this.components[i + 1];
                x2 = approx(end.x, digs);
                y2 = approx(end.y, digs);

                /**
                 * The following conditions enforce five edge-crossing rules:
                 *    1. points coincident with edges are considered contained;
                 *    2. an upward edge includes its starting endpoint, and
                 *    excludes its final endpoint;
                 *    3. a downward edge excludes its starting endpoint, and
                 *    includes its final endpoint;
                 *    4. horizontal edges are excluded; and
                 *    5. the edge-ray intersection point must be strictly right
                 *    of the point P.
                 */
                if (y1 === y2) {
                    // horizontal edge
                    if (py === y1) {
                        // point on horizontal line
                        if (x1 <= x2 && px >= x1 && px <= x2 || // right or vert
                        x1 >= x2 && px <= x1 && px >= x2) {
                            // left or vert
                            // point on edge
                            crosses = -1;
                            break;
                        }
                    }
                    // ignore other horizontal edges
                    continue;
                }
                cx = approx(getX(py, x1, y1, x2, y2), digs);
                if (cx === px) {
                    // point on line
                    if (y1 < y2 && py >= y1 && py <= y2 || // upward
                    y1 > y2 && py <= y1 && py >= y2) {
                        // downward
                        // point on edge
                        crosses = -1;
                        break;
                    }
                }
                if (cx <= px) {
                    // no crossing to the right
                    continue;
                }
                if (x1 !== x2 && (cx < Math.min(x1, x2) || cx > Math.max(x1, x2))) {
                    // no crossing
                    continue;
                }
                if (y1 < y2 && py >= y1 && py < y2 || // upward
                y1 > y2 && py < y1 && py >= y2) {
                    // downward
                    ++crosses;
                }
            }
            var contained = crosses === -1 ?
            // on edge
            1 :
            // even (out) or odd (in)
            !!(crosses & 1);

            return contained;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.intersects
         * @description 判断输入的几何图形是否与当前几何图形相交。
         * @param geometry {SuperMap.Geometry} 任意的几何对象。
         * @returns {boolean} 输入几何图形与当前的目标几何图形相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.containsPoint(geometry);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LineString") {
                intersect = geometry.intersects(this);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LinearRing") {
                intersect = _LineString3["default"].prototype.intersects.apply(this, [geometry]);
            } else {
                // check for component intersections
                for (var i = 0, len = geometry.components.length; i < len; ++i) {
                    intersect = geometry.components[i].intersects(this);
                    if (intersect) {
                        break;
                    }
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.LinearRing.prototype.getVertices
         * @description 返回几何图形的所有点的列表。
         * @param nodes {boolean} 对于线来说，仅仅返回作为端点的顶点，如果设为false，则返回非端点的顶点。如果没有设置此参数，则返回所有顶点。
         * @returns {Array} 几何对象所有点的列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {
            return nodes === true ? [] : this.components.slice(0, this.components.length - 1);
        }
    }]);

    return LinearRing;
}(_LineString3["default"]);

exports["default"] = LinearRing;

_SuperMap2["default"].Geometry.LinearRing = LinearRing;

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _CommonServiceBase2 = __webpack_require__(3);

var _CommonServiceBase3 = _interopRequireDefault(_CommonServiceBase2);

var _QueryParameters = __webpack_require__(26);

var _QueryParameters2 = _interopRequireDefault(_QueryParameters);

var _GeoJSON = __webpack_require__(9);

var _GeoJSON2 = _interopRequireDefault(_GeoJSON);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.QueryService
 * @classdesc 查询服务基类。
 * @extends SuperMap.CommonServiceBase
 * @param url - {string} 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
 * @param options - {Object} 可选参数。如：<br>
 *        eventListeners - {Object} 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。<br>
 *        serverType - {SuperMap.ServerType} 服务器类型，iServer|iPortal|Online。<br>
 *        format -{SuperMap.DataFormat} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @example
 * var myService = new SuperMap.QueryService(url, {
 *     eventListeners: {
 *	       "processCompleted": queryCompleted,
 *		   "processFailed": queryError
 *		   }
 * };
 */
var QueryService = function (_CommonServiceBase) {
    _inherits(QueryService, _CommonServiceBase);

    /*
     * @function SuperMap.QueryService.prototype.constructor
     * @description 查询服务基类构造函数。
     * @param url - {string} 服务地址。请求地图查询服务的 URL 应为：http://{服务器地址}:{服务端口号}/iserver/services/{地图服务名}/rest/maps/{地图名}；
     * @param options - {Object} 可选参数。如：<br>
     *        eventListeners - {Object} 需要被注册的监听器对象。
     */


    /*
     * Property: returnContent
     * {Boolean} 是否立即返回新创建资源的表述还是返回新资源的URI。
     */
    function QueryService(url, options) {
        _classCallCheck(this, QueryService);

        var _this = _possibleConstructorReturn(this, (QueryService.__proto__ || Object.getPrototypeOf(QueryService)).call(this, url, options));

        _this.returnContent = false;
        _this.format = _REST.DataFormat.GEOJSON;
        _this.CLASS_NAME = "SuperMap.QueryService";

        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        var me = _this,
            end;
        if (!me.url) {
            return _possibleConstructorReturn(_this);
        }
        if (options && options.format) {
            me.format = options.format.toUpperCase();
        }

        end = me.url.substr(me.url.length - 1, 1);

        // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
        // if (this.format==="geojson") {
        //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
        // } else {
        //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
        // }
        me.url += end === "/" ? "queryResults.json?" : "/queryResults.json?";
        return _this;
    }

    /**
     * @function SuperMap.QueryService.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /*
     *  Property: format
     *  {string} 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *  参数格式为"ISERVER","GEOJSON",GEOJSON
     */


    _createClass(QueryService, [{
        key: 'destroy',
        value: function destroy() {
            _get(QueryService.prototype.__proto__ || Object.getPrototypeOf(QueryService.prototype), 'destroy', this).call(this);
            var me = this;
            me.returnContent = null;
            me.format = null;
        }

        /**
         * @function SuperMap.QueryService.prototype.processAsync
         * @description 负责将客户端的查询参数传递到服务端。
         * @param params - {QueryParameters} 查询参数。
         */

    }, {
        key: 'processAsync',
        value: function processAsync(params) {
            if (!params) {
                return;
            }
            var me = this,
                returnCustomResult = null,
                jsonParameters = null;
            me.returnContent = params.returnContent;
            jsonParameters = me.getJsonParameters(params);
            if (me.returnContent) {
                me.url += "returnContent=" + me.returnContent;
            } else {
                //仅供三维使用 获取高亮图片的bounds
                returnCustomResult = params.returnCustomResult;
                if (returnCustomResult) {
                    me.url += "returnCustomResult=" + returnCustomResult;
                }
            }
            me.request({
                method: "POST",
                data: jsonParameters,
                scope: me,
                success: me.serviceProcessCompleted,
                failure: me.serviceProcessFailed
            });
        }

        /*
         * Method: queryComplete
         * 查询完成，执行此方法。
         *
         * Parameters:
         * result - {Object} 服务器返回的结果对象。
         */

    }, {
        key: 'serviceProcessCompleted',
        value: function serviceProcessCompleted(result) {
            var me = this;
            result = _SuperMap2["default"].Util.transformResult(result);
            if (result && result.recordsets && me.format === _SuperMap2["default"].DataFormat.GEOJSON) {
                var geoJSONFormat = new _GeoJSON2["default"]();
                for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
                    if (recordsets[i].features) {
                        recordsets[i].features = JSON.parse(geoJSONFormat.write(recordsets[i].features));
                    }
                }
            }
            me.events.triggerEvent("processCompleted", { result: result });
        }

        /**
         * @function SuperMap.QueryService.prototype.getQueryParameters
         * @description 将 JSON 对象表示的查询参数转化为 QueryParameters 对象。
         * @param params - {Object} JSON 字符串表示的查询参数。
         * @return {QueryParameters} 返回转化后的 QueryParameters 对象。
         */

    }, {
        key: 'getQueryParameters',
        value: function getQueryParameters(params) {
            return new _QueryParameters2["default"]({
                customParams: params.customParams,
                expectCount: params.expectCount,
                networkType: params.networkType,
                queryOption: params.queryOption,
                queryParams: params.queryParams,
                startRecord: params.startRecord,
                prjCoordSys: params.prjCoordSys,
                holdTime: params.holdTime
            });
        }
    }]);

    return QueryService;
}(_CommonServiceBase3["default"]);

exports["default"] = QueryService;


_SuperMap2["default"].QueryService = QueryService;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _UGCMapLayer2 = __webpack_require__(344);

var _UGCMapLayer3 = _interopRequireDefault(_UGCMapLayer2);

var _JoinItem = __webpack_require__(63);

var _JoinItem2 = _interopRequireDefault(_JoinItem);

var _DatasetInfo = __webpack_require__(202);

var _DatasetInfo2 = _interopRequireDefault(_DatasetInfo);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.UGCSubLayer
 * @classdesc 地图服务图层属性信息类，影像图层(Image)、专题图层(ServerTheme)、栅格图层(Grid)、矢量图层(Vector)等图层均继承该类。
 * @extends SuperMap.UGCMapLayer
 * @param options - {Object} 可选参数。如：<br>
 *        datasetInfo - {{@link SuperMap.DatasetInfo}} 数据集信息。<br>
 *        displayFilter - {string} 图层显示过滤条件。<br>
 *        joinItems - {{@link SuperMap.JoinItem}} 连接信息类。<br>
 *        representationField - {string} 存储制图表达信息的字段。<br>
 *        ugcLayerType - {{@link SuperMap.LayerType}} 图层类型
 */
var UGCSubLayer = function (_UGCMapLayer) {
    _inherits(UGCSubLayer, _UGCMapLayer);

    /*
     * Constructor: SuperMap.UGCSubLayer
     * 地图服务图层属性信息类构造函数。
     。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.representationField -{string}
     * @description 存储制图表达信息的字段。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.displayFilter -{string}
     * @description 图层显示过滤条件。
     */
    function UGCSubLayer(options) {
        _classCallCheck(this, UGCSubLayer);

        options = options || {};

        var _this = _possibleConstructorReturn(this, (UGCSubLayer.__proto__ || Object.getPrototypeOf(UGCSubLayer)).call(this, options));

        _this.datasetInfo = null;
        _this.displayFilter = null;
        _this.joinItems = null;
        _this.representationField = null;
        _this.ugcLayerType = null;
        _this.CLASS_NAME = "SuperMap.UGCSubLayer";
        return _this;
    }

    /**
     * @function SuperMap.UGCSubLayer.prototype.fromJson
     * @description 将服务端JSON对象转换成当前客户端对象
     * @param jsonObject - {Object} 要转换的 JSON 对象。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.ugcLayerType -{SuperMap.LayerType}
     * @description 图层类型。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.joinItems -{SuperMap.JoinItem}
     * @description 连接信息类。
     */


    /**
     * @member SuperMap.UGCSubLayer.prototype.datasetInfo -{SuperMap.DatasetInfo}
     * @description 数据集信息。
     */


    _createClass(UGCSubLayer, [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'fromJson', this).call(this, jsonObject);
            if (this.datasetInfo) {
                this.datasetInfo = new _DatasetInfo2["default"](this.datasetInfo);
            }
            if (this.joinItems && this.joinItems.length) {
                var newJoinItems = [];
                for (var i = 0; i < this.joinItems.length; i++) {
                    newJoinItems[i] = new _JoinItem2["default"](this.joinItems[i]);
                }
                this.joinItems = newJoinItems;
            }
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'destroy', this).call(this);
            _SuperMap2["default"].Util.reset(this);
        }

        /**
         * @function SuperMap.UGCSubLayer.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = _get(UGCSubLayer.prototype.__proto__ || Object.getPrototypeOf(UGCSubLayer.prototype), 'toServerJSONObject', this).call(this);
            if (jsonObject.joinItems) {
                var joinItems = [];
                for (var i = 0; i < jsonObject.joinItems.length; i++) {
                    if (jsonObject.joinItems[i].toServerJSONObject) {
                        joinItems[i] = jsonObject.joinItems[i].toServerJSONObject();
                    }
                }
                jsonObject.joinItems = joinItems;
            }
            if (jsonObject.datasetInfo) {
                if (jsonObject.datasetInfo.toServerJSONObject) {
                    jsonObject.datasetInfo = jsonObject.datasetInfo.toServerJSONObject();
                }
            }
            return jsonObject;
        }
    }]);

    return UGCSubLayer;
}(_UGCMapLayer3["default"]);

exports["default"] = UGCSubLayer;


_SuperMap2["default"].UGCSubLayer = UGCSubLayer;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

__webpack_require__(29);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Eventful
 * 事件分发器超类，所有支持事件处理的类均是此类的子类。
 *
 * 此类不可实例化。
 *
 */
var Eventful = function () {

    /*
     * Constructor: SuperMap.LevelRenderer.Eventful
     * 构造函数。
     *
     * 对象可以通过 onxxxx 绑定事件。
     *
     * 支持的事件：
     * Symbolizer properties:
     * onclick - {Function} 默认值：null。
     * onmouseover - {Function} 默认值：null。
     * onmouseout - {Function} 默认值：null。
     * onmousemove - {Function} 默认值：null。
     * onmousewheel - {Function} 默认值：null。
     * onmousedown - {Function} 默认值：null。
     * onmouseup - {Function} 默认值：null。
     * ondragstart - {Function} 默认值：null。
     * ondragend - {Function} 默认值：null。
     * ondragenter - {Function} 默认值：null。
     * ondragleave - {Function} 默认值：null。
     * ondragover - {Function} 默认值：null。
     * ondrop - {Function} 默认值：null。
     */
    function Eventful() {
        _classCallCheck(this, Eventful);

        this._handlers = {};
        this.CLASS_NAME = "SuperMap.LevelRenderer.Eventful";

        this._handlers = {};
    }

    /**
     * APIMethod: destroy
     * 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    /**
     * Property: _handlers
     * {Object} 事件处理对象（事件分发器）。
     */


    _createClass(Eventful, [{
        key: 'destroy',
        value: function destroy() {
            this._handlers = null;
        }

        /**
         * APIMethod: one
         * 单次触发绑定，dispatch后销毁。
         *
         * Parameters:
         * event - {String} 事件名。
         * handler - {Boolean} 响应函数。
         * context - {Object} context。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Eventful>} this。
         */

    }, {
        key: 'one',
        value: function one(event, handler, context) {
            var _h = this._handlers;

            if (!handler || !event) {
                return this;
            }

            if (!_h[event]) {
                _h[event] = [];
            }

            _h[event].push({
                h: handler,
                one: true,
                ctx: context || this
            });

            return this;
        }

        /**
         * APIMethod: bind
         * 绑定事件。
         *
         * Parameters:
         * event - {String} 事件名。
         * handler - {Boolean} 事件处理函数。
         * context - {Object} context。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Eventful>} this。
         */

    }, {
        key: 'bind',
        value: function bind(event, handler, context) {
            var _h = this._handlers;

            if (!handler || !event) {
                return this;
            }

            if (!_h[event]) {
                _h[event] = [];
            }

            _h[event].push({
                h: handler,
                one: false,
                ctx: context || this
            });

            return this;
        }

        /**
         * APIMethod: unbind
         * 解绑事件。
         *
         * Parameters:
         * event - {String} 事件名。
         * handler - {Boolean} 事件处理函数。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Eventful>} this。
         */

    }, {
        key: 'unbind',
        value: function unbind(event, handler) {
            var _h = this._handlers;

            if (!event) {
                this._handlers = {};
                return this;
            }

            if (handler) {
                if (_h[event]) {
                    var newList = [];
                    for (var i = 0, l = _h[event].length; i < l; i++) {
                        if (_h[event][i]['h'] != handler) {
                            newList.push(_h[event][i]);
                        }
                    }
                    _h[event] = newList;
                }

                if (_h[event] && _h[event].length === 0) {
                    delete _h[event];
                }
            } else {
                delete _h[event];
            }

            return this;
        }

        /**
         * APIMethod: dispatch
         * 事件分发。
         *
         * Parameters:
         * type - {String} 事件类型。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Eventful>} this。
         */

    }, {
        key: 'dispatch',
        value: function dispatch(type) {
            if (this._handlers[type]) {
                var args = arguments;
                var argLen = args.length;

                if (argLen > 3) {
                    args = Array.prototype.slice.call(args, 1);
                }

                var _h = this._handlers[type];
                var len = _h.length;
                for (var i = 0; i < len;) {
                    // Optimize advise from backbone
                    switch (argLen) {
                        case 1:
                            _h[i]['h'].call(_h[i]['ctx']);
                            break;
                        case 2:
                            _h[i]['h'].call(_h[i]['ctx'], args[1]);
                            break;
                        case 3:
                            _h[i]['h'].call(_h[i]['ctx'], args[1], args[2]);
                            break;
                        default:
                            // have more than 2 given arguments
                            _h[i]['h'].apply(_h[i]['ctx'], args);
                            break;
                    }

                    if (_h[i]['one']) {
                        _h.splice(i, 1);
                        len--;
                    } else {
                        i++;
                    }
                }
            }

            return this;
        }

        /**
         * APIMethod: dispatchWithContext
         * 带有context的事件分发 最后一个参数是事件回调的 context。
         *
         * Parameters:
         * type - {String} 事件类型。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Eventful>} this。
         */

    }, {
        key: 'dispatchWithContext',
        value: function dispatchWithContext(type) {
            if (this._handlers[type]) {
                var args = arguments;
                var argLen = args.length;

                if (argLen > 4) {
                    args = Array.prototype.slice.call(args, 1, args.length - 1);
                }
                var ctx = args[args.length - 1];

                var _h = this._handlers[type];
                var len = _h.length;
                for (var i = 0; i < len;) {
                    // Optimize advise from backbone
                    switch (argLen) {
                        case 1:
                            _h[i]['h'].call(ctx);
                            break;
                        case 2:
                            _h[i]['h'].call(ctx, args[1]);
                            break;
                        case 3:
                            _h[i]['h'].call(ctx, args[1], args[2]);
                            break;
                        default:
                            // have more than 2 given arguments
                            _h[i]['h'].apply(ctx, args);
                            break;
                    }

                    if (_h[i]['one']) {
                        _h.splice(i, 1);
                        len--;
                    } else {
                        i++;
                    }
                }
            }

            return this;
        }
    }]);

    return Eventful;
}();

exports["default"] = Eventful;

_SuperMap2["default"].LevelRenderer.Eventful = Eventful;

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Symbolizer = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.Symbolizer
 * @description 符号类
 * @private
 * @extends L.Class{@linkdoc-leaflet/#class}
 * @param feature — {L.feature} 要素
 */
var Symbolizer = exports.Symbolizer = _leaflet2["default"].Class.extend({

    initialize: function initialize(feature) {
        this.properties = feature.properties;
        this.type = feature.type;
        this.layerName = feature.layerName;
    },

    /**
     * @function L.supermap.Symbolizer.prototype.render
     * @description 绘制线符号
     * @param renderer - {Object} 渲染器
     * @param style - {string} 符号样式
     */
    render: function render(renderer, style) {
        this._renderer = renderer;
        this.options = style;
        renderer._initPath(this);
        renderer._updateStyle(this);
        var elem = this.getElement();
        if (elem && this.layerName) {
            _leaflet2["default"].DomUtil.addClass(elem, this.layerName);
        }
    },

    /**
     * @function L.supermap.Symbolizer.prototype.updateStyle
     * @description 更新替换符号样式
     * @param renderer - {Object} 渲染器
     * @param style - {string} 符号样式
     */
    updateStyle: function updateStyle(renderer, style) {
        this.options = style;
        renderer._updateStyle(this);
    },

    /**
     * @function L.supermap.Symbolizer.prototype.getElement
     * @description 获取文本信息
     */
    getElement: function getElement() {
        return this._path || this._renderer._container;
    },

    _getPixelBounds: function _getPixelBounds() {
        var parts = this._parts;
        var bounds = _leaflet2["default"].bounds([]);
        for (var i = 0; i < parts.length; i++) {
            var part = parts[i];
            for (var j = 0; j < part.length; j++) {
                bounds.extend(part[j]);
            }
        }

        var w = this._clickTolerance(),
            p = new _leaflet2["default"].Point(w, w);

        bounds.min._subtract(p);
        bounds.max._add(p);

        return bounds;
    },
    _clickTolerance: _leaflet2["default"].Path.prototype._clickTolerance
});

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * @constant L.supermap.VectorFeatureType
 * @description 矢量图层要素类型,和SuperMap.CartoStyleMap中的类型相对应
 * @private
 */
var VectorFeatureType = exports.VectorFeatureType = {
    LABEL: "LABEL", //label实际处理成TEXT
    TEXT: "TEXT",
    POINT: "POINT",
    LINE: "LINE",
    REGION: "REGION"
};

/***/ }),
/* 54 */
/***/ (function(module, exports) {

var HALF_PI = Math.PI/2;
module.exports = function(eccent, ts) {
  var eccnth = 0.5 * eccent;
  var con, dphi;
  var phi = HALF_PI - 2 * Math.atan(ts);
  for (var i = 0; i <= 15; i++) {
    con = eccent * Math.sin(phi);
    dphi = HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
    phi += dphi;
    if (Math.abs(dphi) <= 0.0000000001) {
      return phi;
    }
  }
  //console.log("phi2z has NoConvergence");
  return -9999;
};

/***/ }),
/* 55 */
/***/ (function(module, exports) {

var HALF_PI = Math.PI/2;

module.exports = function(eccent, phi, sinphi) {
  var con = eccent * sinphi;
  var com = 0.5 * eccent;
  con = Math.pow(((1 - con) / (1 + con)), com);
  return (Math.tan(0.5 * (HALF_PI - phi)) / con);
};

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ArrayExt = exports.FunctionExt = exports.NumberExt = exports.StringExt = undefined;

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 *@namespace SuperMap
 */

/**
 * @description In addition to the mandatory C and P parameters, an arbitrary number of
 * objects can be passed, which will extend C.
 * @memberOf SuperMap
 * @param C - {Object} the class that inherits
 * @param P - {Object} the superclass to inherit from
 */
_SuperMap2["default"].inherit = function (C, P) {
    var F = function F() {};
    F.prototype = P.prototype;
    C.prototype = new F();
    var i, l, o;
    for (i = 2, l = arguments.length; i < l; i++) {
        o = arguments[i];
        if (typeof o === "function") {
            o = o.prototype;
        }
        _SuperMap2["default"].Util.extend(C.prototype, o);
    }
};

/**
 * @description 实现多重继承
 * @memberOf SuperMap
 * @param ...mixins {Class|Object}继承的类
 */
_SuperMap2["default"].mixin = function () {
    for (var _len = arguments.length, mixins = Array(_len), _key = 0; _key < _len; _key++) {
        mixins[_key] = arguments[_key];
    }

    var Mix = function Mix(options) {
        _classCallCheck(this, Mix);

        for (var index = 0; index < mixins.length; index++) {
            copyProperties(this, new mixins[index](options));
        }
    };

    for (var index = 0; index < mixins.length; index++) {
        var mixin = mixins[index];
        copyProperties(Mix, mixin);
        copyProperties(Mix.prototype, mixin.prototype);
        copyProperties(Mix.prototype, new mixin());
    }
    return Mix;

    function copyProperties(target, source) {
        var ownKeys = Object.getOwnPropertyNames(source);
        if (Object.getOwnPropertySymbols) {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source));
        }
        for (var index = 0; index < ownKeys.length; index++) {
            var key = ownKeys[index];
            if (key !== "constructor" && key !== "prototype" && key !== "name" && key !== "length") {
                var desc = Object.getOwnPropertyDescriptor(source, key);
                Object.defineProperty(target, key, desc);
            }
        }
    }
};

/**
 * @name String
 * @memberOf SuperMap
 * @namespace
 * @description 字符串操作的一系列常用扩展函数.
 */
var StringExt = exports.StringExt = _SuperMap2["default"].String = {

    /**
     * @description 判断目标字符串是否以指定的子字符串开头.
     * @param str - {string} 目标字符串.
     * @param sub - {string} 查找的子字符串.
     * @returns {Boolean} 目标字符串以指定的子字符串开头,则返回true;否则返回false.
     */
    startsWith: function startsWith(str, sub) {
        return str.indexOf(sub) == 0;
    },

    /**
     * @description 判断目标字符串是否包含指定的子字符串.
     * @param str - {string} 目标字符串.
     * @param sub - {string} 查找的子字符串.
     * @returns {Boolean} 目标字符串中包含指定的子字符串,则返回true;否则返回false.
     */
    contains: function contains(str, sub) {
        return str.indexOf(sub) != -1;
    },

    /**
     * @description 删除一个字符串的开头和结尾处的所有空白字符.
     * @param str - {string} (可能)存在空白字符填塞的字符串.
     * @returns {string} 删除开头和结尾处空白字符后的字符串.
     */
    trim: function trim(str) {
        return str.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
    },

    /**
     * @description 骆驼式("-")连字符的字符串处理.
     * 例如: "chicken-head" becomes "chickenHead",
     *       "-chicken-head" becomes "ChickenHead".
     * @param str - {string} 要处理的字符串,原始内容不应被修改.
     * @returns {string}
     */
    camelize: function camelize(str) {
        var oStringList = str.split('-');
        var camelizedString = oStringList[0];
        for (var i = 1, len = oStringList.length; i < len; i++) {
            var s = oStringList[i];
            camelizedString += s.charAt(0).toUpperCase() + s.substring(1);
        }
        return camelizedString;
    },

    /**
     * @description 提供带 ${token} 标记的字符串, 返回context对象属性中指定标记的属性值.
     * @example
     * 示例:
     * (code)
     * 1、template = "${value,getValue}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:36
     * (end)
     * 示例:
     * (code)
     * 2、template = "$${{value,getValue}}";
     *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
     *         args = [2,23,12,36,21];
     *       返回值:"${36}"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = {a: {b:"format"}};
     *         args = null;
     *       返回值:"format"
     * (end)
     * 示例:
     * (code)
     * 3、template = "${a,b}";
     *         context = null;
     *         args = null;
     *       返回值:"${a.b}"
     * (end)
     * @param template - {string} 带标记的字符串将要被替换.参数 template 格式为"${token}",此处的 token 标记会替换为 context["token"] 属性的值
     * @param context - {Object} 带有属性的可选对象的属性用于匹配格式化字符串中的标记.如果该参数为空,将使用 window 对象.
     * @param args - {Array} 可选参数传递给在context对象上找到的函数.
     * @returns {string} 从 context 对象属性中替换字符串标记位的字符串.
     */
    format: function format(template, context, args) {
        if (!context) {
            context = window;
        }

        // Example matching:
        // str   = ${foo.bar}
        // match = foo.bar
        var replacer = function replacer(str, match) {
            var replacement;

            // Loop through all subs. Example: ${a.b.c}
            // 0 -> replacement = context[a];
            // 1 -> replacement = context[a][b];
            // 2 -> replacement = context[a][b][c];
            var subs = match.split(/\.+/);
            for (var i = 0; i < subs.length; i++) {
                if (i == 0) {
                    replacement = context;
                }

                replacement = replacement[subs[i]];
            }

            if (typeof replacement === "function") {
                replacement = args ? replacement.apply(null, args) : replacement();
            }

            // If replacement is undefined, return the string 'undefined'.
            // This is a workaround for a bugs in browsers not properly
            // dealing with non-participating groups in regular expressions:
            // http://blog.stevenlevithan.com/archives/npcg-javascript
            if (typeof replacement == 'undefined') {
                return 'undefined';
            } else {
                return replacement;
            }
        };

        return template.replace(_SuperMap2["default"].String.tokenRegEx, replacer);
    },

    /**
     * @description Used to find tokens in a string.
     * @default  /\$\{([\w.]+?)\}/g
     * @example
     * Examples: ${a}, ${a.b.c}, ${a-b}, ${5}
     */
    tokenRegEx: /\$\{([\w.]+?)\}/g,

    /**
     * @description Used to test strings as numbers.
     * @default  /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/
     */
    numberRegEx: /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,

    /**
     * @description 判断一个字符串是否只包含一个数值.
     * @example
     * (code)
     * SuperMap.String.isNumeric("6.02e23") // true
     * SuperMap.String.isNumeric("12 dozen") // false
     * SuperMap.String.isNumeric("4") // true
     * SuperMap.String.isNumeric(" 4 ") // false
     * (end)
     * @returns {Boolean} 字符串包含唯一的数值,返回true;否则返回false.
     */
    isNumeric: function isNumeric(value) {
        return _SuperMap2["default"].String.numberRegEx.test(value);
    },

    /**
     * @description 把一个看似数值型的字符串转化为一个数值.
     *
     * @returns {number|string} 如果能转换为数值则返回数值,否则返回字符串本身.
     */
    numericIf: function numericIf(value) {
        return _SuperMap2["default"].String.isNumeric(value) ? parseFloat(value) : value;
    }

};

/**
 * @name Number
 * @memberOf SuperMap
 * @namespace
 * @description 数值操作的一系列常用扩展函数.
 */
var NumberExt = exports.NumberExt = _SuperMap2["default"].Number = {

    /**
     *  @description 格式化数字时默认的小数点分隔符.
     *  @constant
     *  @default "."
     */
    decimalSeparator: ".",

    /**
     *  @description 格式化数字时默认的千位分隔符.
     *  @constant
     *  @default ","
     */
    thousandsSeparator: ",",

    /**
     * @description 限制浮点数的有效数字位数.
     * @param num - {number}
     * @param sig - {integer}
     * @returns {number} 将数字四舍五入到指定数量的有效位数.
     */
    limitSigDigs: function limitSigDigs(num, sig) {
        var fig = 0;
        if (sig > 0) {
            fig = parseFloat(num.toPrecision(sig));
        }
        return fig;
    },

    /**
     * @description 数字格式化输出.
     * @param num  - {number}
     * @param dec  - {integer} 数字的小数部分四舍五入到指定的位数.默认为 0. 设置为null值时小数部分不变.
     * @param tsep - {string} 千位分隔符. 默认为",".
     * @param dsep - {string} 小数点分隔符. 默认为".".
     * @returns {string} 数字格式化后的字符串.
     */
    format: function format(num, dec, tsep, dsep) {
        dec = typeof dec != "undefined" ? dec : 0;
        tsep = typeof tsep != "undefined" ? tsep : _SuperMap2["default"].Number.thousandsSeparator;
        dsep = typeof dsep != "undefined" ? dsep : _SuperMap2["default"].Number.decimalSeparator;

        if (dec != null) {
            num = parseFloat(num.toFixed(dec));
        }

        var parts = num.toString().split(".");
        if (parts.length === 1 && dec == null) {
            // integer where we do not want to touch the decimals
            dec = 0;
        }

        var integer = parts[0];
        if (tsep) {
            var thousands = /(-?[0-9]+)([0-9]{3})/;
            while (thousands.test(integer)) {
                integer = integer.replace(thousands, "$1" + tsep + "$2");
            }
        }

        var str;
        if (dec == 0) {
            str = integer;
        } else {
            var rem = parts.length > 1 ? parts[1] : "0";
            if (dec != null) {
                rem = rem + new Array(dec - rem.length + 1).join("0");
            }
            str = integer + dsep + rem;
        }
        return str;
    }
};

if (!Number.prototype.limitSigDigs) {
    /**
     * APIMethod: Number.limitSigDigs
     * 限制浮点数的有效数字位数.
     * @param sig - {integer}
     * @returns {integer} 将数字四舍五入到指定数量的有效位数.
     *           如果传入值为 null、0、或者是负数, 返回值 0
     */
    Number.prototype.limitSigDigs = function (sig) {
        return NumberExt.limitSigDigs(this, sig);
    };
}

/**
 * @name Function
 * @memberOf SuperMap
 * @namespace
 * @description 函数操作的一系列常用扩展函数.
 */
var FunctionExt = exports.FunctionExt = _SuperMap2["default"].Function = {
    /**
     * @description 绑定函数到对象.方便创建this的作用域.
     * @param func - {function} 输入函数.
     * @param object - {Object} 对象绑定到输入函数(作为输入函数的this对象).
     * @returns {function} object参数作为func函数的this对象.
     */
    bind: function bind(func, object) {
        // create a reference to all arguments past the second one
        var args = Array.prototype.slice.apply(arguments, [2]);
        return function () {
            // Push on any additional arguments from the actual function call.
            // These will come after those sent to the bind call.
            var newArgs = args.concat(Array.prototype.slice.apply(arguments, [0]));
            return func.apply(object, newArgs);
        };
    },

    /**
     * @description 绑定函数到对象,在调用该函数时配置并使用事件对象作为第一个参数.
     * @param func - {function} 用于监听事件的函数.
     * @param object - {Object} this 对象的引用.
     * @returns {function}
     */
    bindAsEventListener: function bindAsEventListener(func, object) {
        return function (event) {
            return func.call(object, event || window.event);
        };
    },

    /**
     * @description 该函数仅仅返回false.该函数主要是避免在IE8以下浏览中DOM事件句柄的匿名函数问题.
     * @example
     * document.onclick = SuperMap.Function.False;
     * @returns {Boolean}
     */
    False: function False() {
        return false;
    },

    /**
     * @description 该函数仅仅返回true.该函数主要是避免在IE8以下浏览中DOM事件句柄的匿名函数问题.
     * @example
     * document.onclick = SuperMap.Function.True;
     * @returns {Boolean}
     */
    True: function True() {
        return true;
    },

    /**
     * @description 可重用函数,仅仅返回"undefined".
     * @returns {undefined}
     */
    Void: function Void() {}

};

/**
 * @name Array
 * @memberOf SuperMap
 * @namespace
 * @description 数组操作的一系列常用扩展函数.
 */
var ArrayExt = exports.ArrayExt = _SuperMap2["default"].Array = {

    /**
     * @description 过滤数组.提供了ECMA-262标准中Array.prototype.filter函数的扩展.
     * @see {@link http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/filter}
     * @param array - {Array} 要过滤的数组..
     * @param callback - {function} 数组中的每一个元素调用该函数.<br>
     *     如果函数的返回值为true,该元素将包含在返回的数组中.该函数有三个参数: 数组中的元素,元素的索引,数组自身.<br>
     *     如果设置了可选参数caller,在调用callback时,使用可选参数caller设置为callback的参数.<br>
     * @param caller - {Object} 在调用callback时,使用可选参数caller设置为callback的参数.
     * @returns {Array} callback函数返回true时的元素将作为返回数组中的元素.
     */
    filter: function filter(array, callback, caller) {
        var selected = [];
        if (Array.prototype.filter) {
            selected = array.filter(callback, caller);
        } else {
            var len = array.length;
            if (typeof callback != "function") {
                throw new TypeError();
            }
            for (var i = 0; i < len; i++) {
                if (i in array) {
                    var val = array[i];
                    if (callback.call(caller, val, i, array)) {
                        selected.push(val);
                    }
                }
            }
        }
        return selected;
    }

};

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Size = __webpack_require__(172);

var _Size2 = _interopRequireDefault(_Size);

var _Pixel = __webpack_require__(59);

var _Pixel2 = _interopRequireDefault(_Pixel);

var _LonLat = __webpack_require__(86);

var _LonLat2 = _interopRequireDefault(_LonLat);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _LinearRing = __webpack_require__(48);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

var _Polygon = __webpack_require__(61);

var _Polygon2 = _interopRequireDefault(_Polygon);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Bounds
 * @classdesc 表示边界类实例。使用bounds之前需要设置left,bottom, right, top四个属性，这些属性的初始值为null。
 * @param  left - {number} 左边界，注意考虑宽度，理论上小于right值。
 * @param  bottom - {number} 下边界。考虑高度，理论上小于top值。
 * @param  right - {number} 右边界。
 * @param  top - {number} 上边界。
 * @param  array - {Array<number>} [left, bottom, right, top]  如果同时传多个参数，则使用左下右上组成的数组。
 * @example
 * var bounds = new SuperMap.Bounds();
 * bounds.extend(new SuperMap.LonLat(4,5));
 * bounds.extend(new SuperMap.LonLat(5,6));
 * bounds.toBBOX(); // returns 4,5,5,6
 */
var Bounds = function () {

    /**
     * @member SuperMap.Bounds.prototype.top - {number}
     * @description 最大的垂直坐标系。
     */


    /**
     * @member SuperMap.Bounds.prototype.bottom - {number}
     * @description 最小的垂直坐标系。
     */
    function Bounds(left, bottom, right, top) {
        _classCallCheck(this, Bounds);

        this.left = null;
        this.bottom = null;
        this.right = null;
        this.top = null;
        this.centerLonLat = null;
        this.CLASS_NAME = "SuperMap.Bounds";

        if (_Util.Util.isArray(left)) {
            top = left[3];
            right = left[2];
            bottom = left[1];
            left = left[0];
        }
        this.left = left != null ? _Util.Util.toFloat(left) : this.left;
        this.bottom = bottom != null ? _Util.Util.toFloat(bottom) : this.bottom;
        this.right = right != null ? _Util.Util.toFloat(right) : this.right;
        this.top = top != null ? _Util.Util.toFloat(top) : this.top;
    }

    /**
     * @function SuperMap.Bounds.prototype.clone
     * @description 复制当前 bounds 对象。
     * @example
     * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
     * var bounds2 = bounds1.clone();
     * @returns {SuperMap.Bounds} 返回一个克隆的bounds。
     */


    /**
     * @member SuperMap.Bounds.prototype.centerLonLat - {SuperMap.LonLat}
     * @description bounds的地图空间的中心点。用 getCenterLonLat() 获得。
     */


    /**
     * @member SuperMap.Bounds.prototype.right - {number}
     * @description 最大的水平坐标系。
     */


    /**
     * @member SuperMap.Bounds.prototype.left - {number}
     * @description 最小的水平坐标系。
     */


    _createClass(Bounds, [{
        key: 'clone',
        value: function clone() {
            return new Bounds(this.left, this.bottom, this.right, this.top);
        }

        /**
         * @function SuperMap.Bounds.prototype.equals
         * @description 判断两个 bounds 对象是否相等。
         * @example
         * var bounds1 = new SuperMap.Bounds(-180-9018090);
         * var bounds2 = new SuperMap.Bounds(-180-9018090);
         * var isEquals = bounds1.equals(bounds2);
         * @param bounds - {SuperMap.Bounds} 需要进行计较的 bounds。
         * @returns {boolean} 如果 bounds 对象的边和传入的 bounds 一致则返回true不一致或传入的 bounds 参数为NULL则返回false。
         */

    }, {
        key: 'equals',
        value: function equals(bounds) {
            var equals = false;
            if (bounds != null) {
                equals = this.left === bounds.left && this.right === bounds.right && this.top === bounds.top && this.bottom === bounds.bottom;
            }
            return equals;
        }

        /**
         * @function SuperMap.Bounds.prototype.toString
         * @description 返回此对象的字符串形式
         * @example
         * var bounds = new SuperMap.Bounds(-180-9018090);
         * var str = bounds.toString();
         * @returns {string} 边界对象的字符串表示形式（leftbottomrighttop），例如: "-180-9018090"
         */

    }, {
        key: 'toString',
        value: function toString() {
            return [this.left, this.bottom, this.right, this.top].join(",");
        }

        /**
         * @function SuperMap.Bounds.prototype.toArray
         * @description 边界对象的数组表示形式 。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * //array1 = [-180,-90,100,80];
         * var array1 = bounds.toArray();
         * //array1 = [-90,-180,80,100];
         * var array2 = bounds.toArray(true);
         * @param reverseAxisOrder - {boolean} 是否反转轴顺序，
         * 如果设为true，则倒转顺序（bottomlefttopright）否则按正常轴顺序（leftbottomrighttop）。
         * @returns {Array} left bottom right top数组。
         */

    }, {
        key: 'toArray',
        value: function toArray(reverseAxisOrder) {
            if (reverseAxisOrder === true) {
                return [this.bottom, this.left, this.top, this.right];
            } else {
                return [this.left, this.bottom, this.right, this.top];
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toBBOX
         * @description 取小数点后decimal位数字进行四舍五入再转换为BBOX字符串。
         * @example
         * var bounds = new SuperMap.Bounds(-1.1234567-1.76543211.44444441.5555555);
         * //str1 = "-1.123457,-1.765432,1.444444,1.555556";
         * var str1 = bounds.toBBOX();
         * //str2 = "-1.1,-1.8,1.4,1.6";
         * var str2 = bounds.toBBOX(1);
         * //str2 = "-1.8,-1.1,1.6,1.4";
         * var str2 = bounds.toBBOX(1true);
         * @param decimal - {integer} 边界方位坐标的有效数字个数，默认为6。
         * @param  reverseAxisOrder - {boolean} 是否是反转轴顺序。
         * 如果设为true，则倒转顺序（bottomlefttopright）否则按正常轴顺序（leftbottomrighttop）。
         * @returns {string} 边界对象的字符串表示形式，如："5421045"。
         */

    }, {
        key: 'toBBOX',
        value: function toBBOX(decimal, reverseAxisOrder) {
            if (decimal == null) {
                decimal = 6;
            }
            var mult = Math.pow(10, decimal);
            var xmin = Math.round(this.left * mult) / mult;
            var ymin = Math.round(this.bottom * mult) / mult;
            var xmax = Math.round(this.right * mult) / mult;
            var ymax = Math.round(this.top * mult) / mult;
            if (reverseAxisOrder === true) {
                return ymin + "," + xmin + "," + ymax + "," + xmax;
            } else {
                return xmin + "," + ymin + "," + xmax + "," + ymax;
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.toGeometry
         * @description 基于当前边界范围创建一个新的多边形对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * //SuperMap.Geometry.Polygon对象
         * var geo = bounds.toGeometry();
         * @returns {SuperMap.Geometry.Polygon} 基于当前bounds坐标创建的新的多边形。
         */

    }, {
        key: 'toGeometry',
        value: function toGeometry() {
            return new _Polygon2["default"]([new _LinearRing2["default"]([new _Point2["default"](this.left, this.bottom), new _Point2["default"](this.right, this.bottom), new _Point2["default"](this.right, this.top), new _Point2["default"](this.left, this.top)])]);
        }

        /**
         * @function SuperMap.Bounds.prototype.getWidth
         * @description 获取bounds的宽度。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * //width = 280;
         * var width = bounds.getWidth();
         * @returns {float} 获取当前bounds的宽度（right减去left）。
         */

    }, {
        key: 'getWidth',
        value: function getWidth() {
            return this.right - this.left;
        }

        /**
         * @function SuperMap.Bounds.prototype.getHeight
         * @description 获取bounds的高度。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * //height = 170;
         * var height = bounds.getHeight();
         * @returns {float} 返回边界高度（top减去bottom）。
         */

    }, {
        key: 'getHeight',
        value: function getHeight() {
            return this.top - this.bottom;
        }

        /**
         * @function SuperMap.Bounds.prototype.getSize
         * @description 获取边框大小。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var size = bounds.getSize();
         * @returns {SuperMap.Size} 返回边框大小。
         */

    }, {
        key: 'getSize',
        value: function getSize() {
            return new _Size2["default"](this.getWidth(), this.getHeight());
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterPixel
         * @description 获取像素格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var pixel = bounds.getCenterPixel();
         * @returns {SuperMap.Pixel} 返回像素格式的当前范围的中心点。
         */

    }, {
        key: 'getCenterPixel',
        value: function getCenterPixel() {
            return new _Pixel2["default"]((this.left + this.right) / 2, (this.bottom + this.top) / 2);
        }

        /**
         * @function SuperMap.Bounds.prototype.getCenterLonLat
         * @description 获取地理格式的范围中心点。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var lonlat = bounds.getCenterLonLat();
         * @returns {SuperMap.LonLat} 返回当前地理范围的中心点。
         */

    }, {
        key: 'getCenterLonLat',
        value: function getCenterLonLat() {
            if (!this.centerLonLat) {
                this.centerLonLat = new _LonLat2["default"]((this.left + this.right) / 2, (this.bottom + this.top) / 2);
            }
            return this.centerLonLat;
        }

        /**
         * @function SuperMap.Bounds.prototype.scale
         * @description 按照比例扩大/缩小出一个新的bounds。
         * @example
         * var bounds = new SuperMap.Bounds(-50-504040);
         * var bounds2 = bounds.scale(2);
         * @param ratio - {float} 需要扩大的比例，默认为1。
         * @param origin - {SuperMap.Pixel|SuperMap.LonLat} 扩大时的基准点，默认为当前bounds的中心点。
         * @returns {SuperMap.Bounds} 返回通过ratio、origin计算得到的新的边界范围。
         */

    }, {
        key: 'scale',
        value: function scale(ratio, origin) {
            ratio = ratio ? ratio : 1;
            if (origin == null) {
                origin = this.getCenterLonLat();
            }

            var origx, origy;

            // get origin coordinates
            if (origin.CLASS_NAME === "SuperMap.LonLat") {
                origx = origin.lon;
                origy = origin.lat;
            } else {
                origx = origin.x;
                origy = origin.y;
            }

            var left = (this.left - origx) * ratio + origx;
            var bottom = (this.bottom - origy) * ratio + origy;
            var right = (this.right - origx) * ratio + origx;
            var top = (this.top - origy) * ratio + origy;

            return new Bounds(left, bottom, right, top);
        }

        /**
         * @function SuperMap.Bounds.prototype.add
         * @description 在当前的dounds上按照传入的坐标点进行平移，返回新的范围。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50-504040);
         * //bounds2 是新的 bounds
         * var bounds2 = bounds.add(2010);
         * @param x - {float} 传入坐标点的x坐标。
         * @param y - {float} 传入坐标点的y坐标。
         * @returns {SuperMap.Bounds} 返回一个新的bounds，此bounds的坐标是由传入的x，y参数与当前bounds坐标计算所得。
         */

    }, {
        key: 'add',
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Bounds.add cannot receive null values');
            }
            return new Bounds(this.left + x, this.bottom + y, this.right + x, this.top + y);
        }

        /**
         * @function SuperMap.Bounds.prototype.extend
         * @description 在当前bounds上扩展bounds，支持point，lanlat和bounds。扩展后的bounds的范围是两者的结合。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50-504040);
         * //bounds改变
         * bounds.extend(new SuperMap.LonLat(5060));
         * @param object - {SuperMap.Geometry.Point|SuperMap.LonLat | SuperMap.Bounds} 可以是point，lanlat和bounds。
         */

    }, {
        key: 'extend',
        value: function extend(object) {
            var bounds = null;
            if (object) {
                // clear cached center location
                switch (object.CLASS_NAME) {
                    case "SuperMap.LonLat":
                        bounds = new Bounds(object.lon, object.lat, object.lon, object.lat);
                        break;
                    case "SuperMap.Geometry.Point":
                        bounds = new Bounds(object.x, object.y, object.x, object.y);
                        break;

                    case "SuperMap.Bounds":
                        bounds = object;
                        break;
                }

                if (bounds) {
                    this.centerLonLat = null;
                    if (this.left == null || bounds.left < this.left) {
                        this.left = bounds.left;
                    }
                    if (this.bottom == null || bounds.bottom < this.bottom) {
                        this.bottom = bounds.bottom;
                    }
                    if (this.right == null || bounds.right > this.right) {
                        this.right = bounds.right;
                    }
                    if (this.top == null || bounds.top > this.top) {
                        this.top = bounds.top;
                    }
                }
            }
        }

        /**
         * @function SuperMap.Bounds.prototype.containsLonLat
         * @description 判断传入的坐标是否在范围内。
         * @example
         * var bounds1 = new SuperMap.Bounds(-50-504040);
         * //isContains1 = true
         * //这里的第二个参数可以直接为 boolean 类型，也就是inclusive
         * var isContains1 = bounds.containsLonLat(new SuperMap.LonLat(4040)true);
         *
         * //(40,40)在范围内，同样(40+360,40)也在范围内
         * var bounds2 = new SuperMap.Bounds(-50-504040);
         * //isContains2 = true;
         * var isContains2 = bounds2.containsLonLat(
         *      new SuperMap.LonLat(40040)
         *      {
         *           inclusive:true
         *           //全球的范围
         *           worldBounds: new SuperMap.Bounds(-180-9018090)
         *      }
         *      );
         * @param ll - {SuperMap.LonLat|Object}  <SuperMap.LonLat> 对象或者是一个
         *     包含 'lon' 与 'lat' 属性的对象。
         * @param options - {Object} 可选参数<br>
         *         inclusive - {boolean} 是否包含边界，默认为 true 。<br>
         *         worldBounds - {@link SuperMap.Bounds} 如果提供 worldBounds 参数 如果 ll 参数提供的坐标超出了世界边界（worldBounds）
         *         但是通过日界线的转化可以被包含 它将被认为是包含在该范围内的。
         * @returns {boolean} 传入坐标是否包含在范围内.
         */

    }, {
        key: 'containsLonLat',
        value: function containsLonLat(ll, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            var contains = this.contains(ll.lon, ll.lat, options.inclusive),
                worldBounds = options.worldBounds;
            //日界线以外的也有可能算包含，
            if (worldBounds && !contains) {
                var worldWidth = worldBounds.getWidth();
                var worldCenterX = (worldBounds.left + worldBounds.right) / 2;
                //这一步很关键
                var worldsAway = Math.round((ll.lon - worldCenterX) / worldWidth);
                contains = this.containsLonLat({
                    lon: ll.lon - worldsAway * worldWidth,
                    lat: ll.lat
                }, { inclusive: options.inclusive });
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsPixel
         * @description 判断传入的像素是否在范围内。直接匹配大小，不涉及像素和地理转换。
         * @example
         * var bounds = new SuperMap.Bounds(-50-504040);
         * //isContains = true
         * var isContains = bounds.containsPixel(new SuperMap.Pixel(4040)true);
         * @param px - {SuperMap.Pixel} 提供的像素参数。
         * @param inclusive - {boolean} 是否包含边界，默认为true。
         * @returns {boolean} 传入的pixel在当前边界范围之内。
         */

    }, {
        key: 'containsPixel',
        value: function containsPixel(px, inclusive) {
            return this.contains(px.x, px.y, inclusive);
        }

        /**
         * @function SuperMap.Bounds.prototype.contains
         * @description 判断传入的x，y坐标值是否在范围内。
         * @example
         * var bounds = new SuperMap.Bounds(-50-504040);
         * //isContains = true
         * var isContains = bounds.contains(4040true);
         * @param x - {float} 传入的x坐标值。
         * @param y - {float} 传入的y坐标值。
         * @param inclusive - {boolean} 是否包含边界，默认为true。
         * @returns {boolean} 传入的xy坐标在当前范围内。
         */

    }, {
        key: 'contains',
        value: function contains(x, y, inclusive) {
            //set default
            if (inclusive == null) {
                inclusive = true;
            }

            if (x == null || y == null) {
                return false;
            }

            x = _Util.Util.toFloat(x);
            y = _Util.Util.toFloat(y);

            var contains = false;
            if (inclusive) {
                contains = x >= this.left && x <= this.right && y >= this.bottom && y <= this.top;
            } else {
                contains = x > this.left && x < this.right && y > this.bottom && y < this.top;
            }
            return contains;
        }

        /**
         * @function SuperMap.Bounds.prototype.intersectsBounds
         * @description 判断目标边界范围是否与当前边界范围相交。如果两个边界范围中的任意
         *                边缘相交或者一个边界包含了另外一个就认为这两个边界相交。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var isIntersects = bounds.intersectsBounds(
         *      new SuperMap.Bounds(-170-9012080)
         *  );
         * @param bounds - {SuperMap.Bounds} 目标边界。
         * @param options - {Object} 可选参数。<br>
         *         inclusive - {boolean} 边缘重合也看成相交，默认为true。如果是false，
         *                               两个边界范围没有重叠部分仅仅是在边缘相接（重合），
         *                               这种情况被认为没有相交。<br>
         *         worldBounds - {@link SuperMap.Bounds} 提供了 worldBounds 参数 如果他们相交时
         *                               是在全球范围内 两个边界将被视为相交。这仅适用于交叉
         *                               或完全不在世界范围的边界。
         * @returns {boolean} 传入的bounds对象与当前bounds相交。
         */

    }, {
        key: 'intersectsBounds',
        value: function intersectsBounds(bounds, options) {
            if (typeof options === "boolean") {
                options = { inclusive: options };
            }
            options = options || {};
            if (options.worldBounds) {
                var self = this.wrapDateLine(options.worldBounds);
                bounds = bounds.wrapDateLine(options.worldBounds);
            } else {
                self = this;
            }
            if (options.inclusive == null) {
                options.inclusive = true;
            }
            var intersects = false;
            var mightTouch = self.left === bounds.right || self.right === bounds.left || self.top === bounds.bottom || self.bottom === bounds.top;

            // if the two bounds only touch at an edge, and inclusive is false,
            // then the bounds don't *really* intersect.
            if (options.inclusive || !mightTouch) {
                // otherwise, if one of the boundaries even partially contains another,
                // inclusive of the edges, then they do intersect.
                var inBottom = bounds.bottom >= self.bottom && bounds.bottom <= self.top || self.bottom >= bounds.bottom && self.bottom <= bounds.top;
                var inTop = bounds.top >= self.bottom && bounds.top <= self.top || self.top > bounds.bottom && self.top < bounds.top;
                var inLeft = bounds.left >= self.left && bounds.left <= self.right || self.left >= bounds.left && self.left <= bounds.right;
                var inRight = bounds.right >= self.left && bounds.right <= self.right || self.right >= bounds.left && self.right <= bounds.right;
                intersects = (inBottom || inTop) && (inLeft || inRight);
            }
            // document me
            if (options.worldBounds && !intersects) {
                var world = options.worldBounds;
                var width = world.getWidth();
                var selfCrosses = !world.containsBounds(self);
                var boundsCrosses = !world.containsBounds(bounds);
                if (selfCrosses && !boundsCrosses) {
                    bounds = bounds.add(-width, 0);
                    intersects = self.intersectsBounds(bounds, { inclusive: options.inclusive });
                } else if (boundsCrosses && !selfCrosses) {
                    self = self.add(-width, 0);
                    intersects = bounds.intersectsBounds(self, { inclusive: options.inclusive });
                }
            }
            return intersects;
        }

        /**
         * @function SuperMap.Bounds.prototype.containsBounds
         * @description 判断目标边界是否被当前边界包含在内。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var isContains = bounds.containsBounds(
         *      new SuperMap.Bounds(-170-9010080)truetrue
         *  );
         * @param bounds - {SuperMap.Bounds} 目标边界。
         * @param partial - {boolean} 目标边界的任意部分都包含在当前边界中则被认为是包含关系。默认为false，
         *                             如果设为false，整个目标边界全部被包含在当前边界范围内。
         * @param inclusive - {boolean} 边缘共享被视为包含。默认为true。
         * @returns {boolean} 传入的边界被当前边界包含。
         */

    }, {
        key: 'containsBounds',
        value: function containsBounds(bounds, partial, inclusive) {
            if (partial == null) {
                partial = false;
            }
            if (inclusive == null) {
                inclusive = true;
            }
            var bottomLeft = this.contains(bounds.left, bounds.bottom, inclusive);
            var bottomRight = this.contains(bounds.right, bounds.bottom, inclusive);
            var topLeft = this.contains(bounds.left, bounds.top, inclusive);
            var topRight = this.contains(bounds.right, bounds.top, inclusive);

            return partial ? bottomLeft || bottomRight || topLeft || topRight : bottomLeft && bottomRight && topLeft && topRight;
        }

        /**
         * @function SuperMap.Bounds.prototype.determineQuadrant
         * @description 判断传入坐标在bounds范围内的象限。以bounds中心点为坐标原点。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * //str = "tr";
         * var str = bounds.determineQuadrant(
         *      new SuperMap.LonLat(2020)
         *  );
         * @param lonlat - {SuperMap.LonLat} 传入的坐标对象。
         * @returns {string} 传入坐标所在的象限("br" "tr" "tl" "bl" 分别对应"右下"，"右上"，"左上" "左下")。
         */

    }, {
        key: 'determineQuadrant',
        value: function determineQuadrant(lonlat) {

            var quadrant = "";
            var center = this.getCenterLonLat();

            quadrant += lonlat.lat < center.lat ? "b" : "t";
            quadrant += lonlat.lon < center.lon ? "l" : "r";

            return quadrant;
        }

        /**
         * @function SuperMap.Bounds.prototype.wrapDateLine
         * @description 将当前bounds移动到最大边界范围内部（所谓的内部是相交或者内部）。
         * @example
         * var bounds = new SuperMap.Bounds(380-40400-20);
         * var maxExtent = new SuperMap.Bounds(-180-9010080);
         * //新的bounds
         * var newBounds = bounds.wrapDateLine(maxExtent);
         * @param maxExtent - {SuperMap.Bounds} 最大的边界范围（一般是全球范围）。
         * @param options - {Object} 可选选项参数。<br>
         *         leftTolerance - {float} left允许的误差。默认为0。<br>
         *         rightTolerance - {float} right允许的误差。默认为0。
         * @returns {SuperMap.Bounds} 克隆当前边界。如果当前边界完全在最大范围之外此函数则返回一个不同值的边界，
         *                             若落在最大边界的左边，则给当前的bounds值加上最大范围的宽度，即向右移动，
         *                             若落在右边，则向左移动，即给当前的bounds值加上负的最大范围的宽度。
         */

    }, {
        key: 'wrapDateLine',
        value: function wrapDateLine(maxExtent, options) {
            options = options || {};

            var leftTolerance = options.leftTolerance || 0;
            var rightTolerance = options.rightTolerance || 0;

            var newBounds = this.clone();

            if (maxExtent) {
                var width = maxExtent.getWidth();
                //如果 newBounds 在 maxExtent 的左边，那么一直向右移动，直到相交或者包含为止，每次移动width
                //shift right?
                while (newBounds.left < maxExtent.left && newBounds.right - rightTolerance <= maxExtent.left) {
                    newBounds = newBounds.add(width, 0);
                }
                //如果 newBounds 在 maxExtent 的右边，那么一直向左移动，直到相交或者包含为止，每次移动width
                //shift left?
                while (newBounds.left + leftTolerance >= maxExtent.right && newBounds.right > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
                //如果和右边相交，左边又在内部，那么再次向左边移动一次
                // crosses right only? force left
                var newLeft = newBounds.left + leftTolerance;
                if (newLeft < maxExtent.right && newLeft > maxExtent.left && newBounds.right - rightTolerance > maxExtent.right) {
                    newBounds = newBounds.add(-width, 0);
                }
            }

            return newBounds;
        }

        /**
         * @function SuperMap.Bounds.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * var obj = bounds.toServerJSONObject();
         * @returns {Object} 返回json 格式的Object对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = {
                rightTop: { x: this.right, y: this.top },
                leftBottom: { x: this.left, y: this.bottom },
                left: this.left,
                right: this.right,
                top: this.top,
                bottom: this.bottom
            };
            return jsonObject;
        }

        /**
         *
         * @function SuperMap.Bounds.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为null，而不是初始值。
         * @example
         * var bounds = new SuperMap.Bounds(-180-9010080);
         * bounds.destroy();
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.left = null;
            this.right = null;
            this.top = null;
            this.bottom = null;
            this.centerLonLat = null;
        }

        /**
         * @function SuperMap.Bounds.fromString
         * @description 通过字符串参数创建新的bounds的构造函数。
         * @example
         * var bounds = SuperMap.Bounds.fromString("-180-9010080");
         * @param str - {string} 边界字符串，用逗号隔开 (e.g. <i>"5421045"</i>)
         * @param reverseAxisOrder - {boolean} 是否反转轴顺序.
         * 如果设为true，则倒转顺序（bottomlefttopright）否则按正常轴顺序（leftbottomrighttop）。
         * @returns {SuperMap.Bounds} 返回给定的字符串创建的新的边界对象
         */

    }], [{
        key: 'fromString',
        value: function fromString(str, reverseAxisOrder) {
            var bounds = str.split(",");
            return Bounds.fromArray(bounds, reverseAxisOrder);
        }
    }, {
        key: 'fromArray',


        /**
         * @function SuperMap.Bounds.fromArray
         * @description 通过边界框数组创建Bounds。
         * @example
         * var bounds = SuperMap.Bounds.fromArray([-180,-90,100,80]);
         * @param bbox - {Array(float)} 边界值数组。 (e.g. <i>[5,42,10,45]</i>)
         * @param reverseAxisOrder - {boolean} 是否是反转轴顺序。如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
         * @returns {SuperMap.Bounds} 返回根据传入的数组创建的新的边界对象。
         */
        value: function fromArray(bbox, reverseAxisOrder) {
            return reverseAxisOrder === true ? new Bounds(bbox[1], bbox[0], bbox[3], bbox[2]) : new Bounds(bbox[0], bbox[1], bbox[2], bbox[3]);
        }
    }, {
        key: 'fromSize',


        /**
         * @function SuperMap.Bounds.fromSize
         * @description 通过传入的边界大小来创建新的边界。
         * @example
         * var bounds = SuperMap.Bounds.fromSize(new SuperMap.Size(20,10));
         * @param size - {SuperMap.Size} 传入的边界大小。
         * @returns {SuperMap.Bounds} 返回根据传入的边界大小的创建新的边界。
         */
        value: function fromSize(size) {
            return new Bounds(0, size.h, size.w, 0);
        }
    }, {
        key: 'oppositeQuadrant',


        /**
         * @function SuperMap.Bounds.oppositeQuadrant
         * @description 反转象限。"t"和"b" 交换，"r"和"l"交换, 如："tl"变为"br"。
         * @param quadrant - {string} 代表象限的字符串，如："tl"。
         * @returns {string} 反转后的象限。
         */
        value: function oppositeQuadrant(quadrant) {
            var opp = "";

            opp += quadrant.charAt(0) === 't' ? 'b' : 't';
            opp += quadrant.charAt(1) === 'l' ? 'r' : 'l';

            return opp;
        }
    }]);

    return Bounds;
}();

exports["default"] = Bounds;

_SuperMap2["default"].Bounds = Bounds;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _WKT = __webpack_require__(177);

var _WKT2 = _interopRequireDefault(_WKT);

var _Vector = __webpack_require__(87);

var _Vector2 = _interopRequireDefault(_Vector);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Geometry
 * @classdesc 几何对象类，描述地理对象的几何图形。
 */
var Geometry = function () {

    /**
     * @member SuperMap.Geometry.prototype.bounds - {SuperMap.Bounds}
     * @description 几何对象的范围。
     */


    /**
     * @member SuperMap.Geometry.prototype.id - {string}
     * @description  此几何对象的唯一标示符。
     */
    function Geometry() {
        _classCallCheck(this, Geometry);

        this.id = null;
        this.parent = null;
        this.bounds = null;
        this.SRID = null;
        this.CLASS_NAME = "SuperMap.Geometry";

        this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");
    }

    /**
     * @function SuperMap.Geometry.prototype.destroy
     * @description 解构Geometry类，释放资源。
     */


    /**
     * @member SuperMap.Geometry.prototype.SRID - {interger}
     * @description 投影坐标参数。通过该参数，服务器判断Geometry对象的坐标参考系是否与数据集相同，如果不同，则在数据入库前进行投影变换。
     * @example
     *   var geometry= new SuperMap.Geometry();
     *   geometry. SRID=4326;
     */


    /**
     * @member SuperMap.Geometry.prototype.parent - {SuperMap.Geometry}
     * @description 当几何对象添加到组件上的时候被设置。
     */


    _createClass(Geometry, [{
        key: 'destroy',
        value: function destroy() {
            this.id = null;
            this.bounds = null;
            this.SRID = null;
        }

        /**
         * @function SuperMap.Geometry.prototype.clone
         * @description 创建克隆的几何图形。克隆的几何图形不设置非标准的属性。
         * @returns {SuperMap.Geometry} 克隆的几何图形。
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new Geometry();
        }

        /**
         * @function SuperMap.Geometry.prototype.setBounds
         * @description 设置此几何对象的bounds。
         * @param bounds - {SuperMap.Bounds}
         */

    }, {
        key: 'setBounds',
        value: function setBounds(bounds) {
            if (bounds) {
                this.bounds = bounds.clone();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.clearBounds
         * @description 清除几何对象的bounds。
         * 如果该对象有父类，也会清除父类几何对象的bounds。
         */

    }, {
        key: 'clearBounds',
        value: function clearBounds() {
            this.bounds = null;
            if (this.parent) {
                this.parent.clearBounds();
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.extendBounds
         * @description 扩展新的Bounds。
         * @param newBounds - {SuperMap.Bounds}
         */

    }, {
        key: 'extendBounds',
        value: function extendBounds(newBounds) {
            var bounds = this.getBounds();
            if (!bounds) {
                this.setBounds(newBounds);
            } else {
                this.bounds.extend(newBounds);
            }
        }

        /**
         * @function SuperMap.Geometry.prototype.getBounds
         * @description 获得几何图形的边界。如果没有设置边界，可通过计算获得。
         * @returns {SuperMap.Bounds}返回的几何对象的边界。
         */

    }, {
        key: 'getBounds',
        value: function getBounds() {
            if (this.bounds == null) {
                this.calculateBounds();
            }
            return this.bounds;
        }

        /**
         * @function SuperMap.Geometry.prototype.calculateBounds
         * @description 重新计算几何图形的边界。（需要在子类中实现此方法）
         */

    }, {
        key: 'calculateBounds',
        value: function calculateBounds() {}
        //
        // This should be overridden by subclasses.
        //


        /**
         * @function SuperMap.Geometry.prototype.distanceTo
         * @description 计算两个几个图形间的最小距离（x-y平面坐标系下）。（需要在子类中实现此方法）
         * @param geometry - {SuperMap.Geometry} 目标几何图形.
         * @param options - {Object} 距离计算需要设计的可选属性。有效的选项取决于特定的几何类型。
         * @returns {number | Object} 两个几个图形间的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {}

        /**
         * @function SuperMap.Geometry.prototype.getVertices
         * @description 返回几何图形的所有顶点的列表。（需要在子类中实现此方法）
         * @param nodes - {boolean} 如果是true，线则只返回线的末端点，如果false，仅仅返回顶点，如果没有设置，则返回顶点。
         * @returns {Array} 几何图形的顶点列表。
         */

    }, {
        key: 'getVertices',
        value: function getVertices(nodes) {}

        /**
         * @function SuperMap.Geometry.prototype.atPoint
         * @description 确定坐标是否在几何对象的范围内。
         * @param lonlat -{SuperMap.LonLat}
         * @param toleranceLon - {float} 可选参数，经度的偏移。
         * @param toleranceLat - {float}  可选参数，纬度的偏移。
         * @returns {boolean} 判断传入的坐标是否在指定的范围内 。
         *
         */

    }, {
        key: 'atPoint',
        value: function atPoint(lonlat, toleranceLon, toleranceLat) {
            var atPoint = false;
            var bounds = this.getBounds();
            if (bounds != null && lonlat != null) {

                var dX = toleranceLon != null ? toleranceLon : 0;
                var dY = toleranceLat != null ? toleranceLat : 0;

                var toleranceBounds = new _SuperMap2["default"].Bounds(this.bounds.left - dX, this.bounds.bottom - dY, this.bounds.right + dX, this.bounds.top + dY);

                atPoint = toleranceBounds.containsLonLat(lonlat);
            }
            return atPoint;
        }

        /**
         * @function SuperMap.Geometry.prototype.getLength
         * @description 计算几何对象的长度 ，此方法需要在子类中定义 。
         * @returns {float} 集合长度。
         */

    }, {
        key: 'getLength',
        value: function getLength() {
            //to be overridden by geometries that actually have a length
            //
            return 0.0;
        }

        /**
         * @function SuperMap.Geometry.prototype.getArea
         * @description 计算几何对象的面积 ，此方法需要在子类中定义  。
         * @returns {float} 集合表示的面积。
         */

    }, {
        key: 'getArea',
        value: function getArea() {
            //to be overridden by geometries that actually have an area
            //
            return 0.0;
        }

        /**
         * @function SuperMap.Geometry.prototype.getCentroid
         * @description 计算几何图形的质心。（需要在子类中实现此方法）
         * @returns {SuperMap.Geometry.Point} 采集的质心。
         */

    }, {
        key: 'getCentroid',
        value: function getCentroid() {
            return null;
        }

        /**
         * @function SuperMap.Geometry.prototype.toString
         * @description 返回geometry对象的字符串表述，需要引入{@link SuperMap.Format.WKT}。此方法只能在子类实现，在父类使用会报错。
         * @returns {string} geometry对象的字符串表述(Well-Known Text)。
         */

    }, {
        key: 'toString',
        value: function toString() {
            var string;
            if (_WKT2["default"]) {
                var wkt = new _WKT2["default"]();
                string = wkt.write(new _Vector2["default"](this));
            } else {
                string = Object.prototype.toString.call(this);
            }
            return string;
        }

        /**
         * @function SuperMap.Geometry.fromWKT
         * @description 从一个给定的字符串生成一个geometry对象，需要引入SuperMap.Format.WKT，该方法方可生效。
         * @example
         * var geometry= new SuperMap.Geometry.fromWKT("POINT(0 0)");
         * geometry.x=0;
         * @param wkt - {string} 描述geometry信息的字符串(A string representing the geometry in Well-Known Text.)
         * @returns {SuperMap.Geometry} 适当类型的geometry对象(A geometry of the appropriate class).
         */

    }], [{
        key: 'fromWKT',
        value: function fromWKT(wkt) {
            var geom;
            if (_WKT2["default"]) {
                var format = Geometry.fromWKT.format;
                if (!format) {
                    format = new _WKT2["default"]();
                    Geometry.fromWKT.format = format;
                }
                var result = format.read(wkt);
                if (result instanceof _Vector2["default"]) {
                    geom = result.geometry;
                } else if (_Util.Util.isArray(result)) {
                    var len = result.length;
                    var components = new Array(len);
                    for (var i = 0; i < len; ++i) {
                        components[i] = result[i].geometry;
                    }
                    geom = new Geometry.Collection(components);
                }
            }
            return geom;
        }

        /**
         * @function SuperMap.Geometry.prototype.SuperMap.Geometry.segmentsIntersect
         * @description 线段相交。该方法是判断两条线段是否相交。计算并返回相交的point。如果seg1.x2 >= seg2.x1 || seg2.x2 >= seg1.x1 ，该方法明显不会被调用。
         * @param seg1 - {Object} 该对象包含的属性是 x1 y1 x2和y2。起始点是 由x1 and y1构成，终点是有x2 and y2组成，必须满足的是x1 < x2。
         * @param seg2 - {Object} 该对象包含的属性是 x1 y1 x2和y2。起始点是 由x1 and y1构成，终点是有x2 and y2组成，必须满足的是x1 < x2。
         * @param options - {Object} Optional properties for calculating the intersection.该对象是判断是否计算相交的点。<br>
         *         point - {boolean} 返回相交点。如果设置为false，说明实际的相交点不需要计算出来。如果设置为true并且这两条线段相交，返回相交的点 。
         *                           如果设置为true，但是两条线段不相交，返回false。如果设置为true，但是两条线段平行，则返回true。<br>
         *         tolerance - {number} 如果设置该值不为空，两条线段在容线的范围内，则会被当作相交。此外，如果point这个属性为true，计算相交的容线距离终点端点将返回而不是计算相交。
         * @returns {boolean | SuperMap.Geometry.Point} 返回线之间是否相交，如果设置点属性为true的话，会返回相交的点坐标。如果点为true，线重合，将会返回true（相交的等于最短的线）。
         */

    }, {
        key: 'segmentsIntersect',
        value: function segmentsIntersect(seg1, seg2, options) {
            var point = options && options.point;
            var tolerance = options && options.tolerance;
            var intersection = false;
            var x11_21 = seg1.x1 - seg2.x1;
            var y11_21 = seg1.y1 - seg2.y1;
            var x12_11 = seg1.x2 - seg1.x1;
            var y12_11 = seg1.y2 - seg1.y1;
            var y22_21 = seg2.y2 - seg2.y1;
            var x22_21 = seg2.x2 - seg2.x1;
            var d = y22_21 * x12_11 - x22_21 * y12_11;
            var n1 = x22_21 * y11_21 - y22_21 * x11_21;
            var n2 = x12_11 * y11_21 - y12_11 * x11_21;
            if (d == 0) {
                // parallel
                if (n1 == 0 && n2 == 0) {
                    // coincident
                    intersection = true;
                }
            } else {
                var along1 = n1 / d;
                var along2 = n2 / d;
                if (along1 >= 0 && along1 <= 1 && along2 >= 0 && along2 <= 1) {
                    // intersect
                    if (!point) {
                        intersection = true;
                    } else {
                        // calculate the intersection point
                        var x = seg1.x1 + along1 * x12_11;
                        var y = seg1.y1 + along1 * y12_11;
                        intersection = new Geometry.Point(x, y);
                    }
                }
            }
            if (tolerance) {
                var dist;
                if (intersection) {
                    if (point) {
                        var segs = [seg1, seg2];
                        var seg, x, y;
                        // check segment endpoints for proximity to intersection
                        // set intersection to first endpoint within the tolerance
                        outer: for (var i = 0; i < 2; ++i) {
                            seg = segs[i];
                            for (var j = 1; j < 3; ++j) {
                                x = seg["x" + j];
                                y = seg["y" + j];
                                dist = Math.sqrt(Math.pow(x - intersection.x, 2) + Math.pow(y - intersection.y, 2));
                                if (dist < tolerance) {
                                    intersection.x = x;
                                    intersection.y = y;
                                    break outer;
                                }
                            }
                        }
                    }
                } else {
                    // no calculated intersection, but segments could be within
                    // the tolerance of one another
                    var segs = [seg1, seg2];
                    var source, target, x, y, p, result;
                    // check segment endpoints for proximity to intersection
                    // set intersection to first endpoint within the tolerance
                    outer: for (var i = 0; i < 2; ++i) {
                        source = segs[i];
                        target = segs[(i + 1) % 2];
                        for (var j = 1; j < 3; ++j) {
                            p = { x: source["x" + j], y: source["y" + j] };
                            result = Geometry.distanceToSegment(p, target);
                            if (result.distance < tolerance) {
                                if (point) {
                                    intersection = new Geometry.Point(p.x, p.y);
                                } else {
                                    intersection = true;
                                }
                                break outer;
                            }
                        }
                    }
                }
            }
            return intersection;
        }

        /**
         * @function SuperMap.Geometry.distanceToSegment
         * @description 计算点到直线的距离。
         * @param point - {Object} 一个点包含x和y坐标。
         * @param segment - {Object} 一个对象包含 x1 y1 x2 and y2坐标。
         * @example
         *        var point={
         *         x:0
         *          y:13
         *          } 
         *            seg1={
         *             x1:6
         *             y1:5
         *            x2:6
         *            y2:12
         *       } ;
         *       var geo=SuperMap.Geometry.distanceToSegment(pointseg1);
         * @returns {Object} 返回的是点到直线的最短距离，以及点与直线最短距离相交的点坐标（xy）。
         */

    }, {
        key: 'distanceToSegment',
        value: function distanceToSegment(point, segment) {
            var x0 = point.x;
            var y0 = point.y;
            var x1 = segment.x1;
            var y1 = segment.y1;
            var x2 = segment.x2;
            var y2 = segment.y2;
            var dx = x2 - x1;
            var dy = y2 - y1;
            var along = (dx * (x0 - x1) + dy * (y0 - y1)) / (Math.pow(dx, 2) + Math.pow(dy, 2));
            var x, y;
            if (along <= 0.0) {
                x = x1;
                y = y1;
            } else if (along >= 1.0) {
                x = x2;
                y = y2;
            } else {
                x = x1 + along * dx;
                y = y1 + along * dy;
            }
            return {
                distance: Math.sqrt(Math.pow(x - x0, 2) + Math.pow(y - y0, 2)),
                x: x, y: y
            };
        }
    }]);

    return Geometry;
}();

exports["default"] = Geometry;

_SuperMap2["default"].Geometry = Geometry;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Pixel
 * @classdesc 此类用x,y坐标描绘屏幕坐标（像素点）。
 * @param x - {number} x坐标，默认为0.0
 * @param y - {number} y坐标，默认为0.0
 * @param mode - {string} 坐标模式，默认为{@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
 *
 * @example
 * //单独创建一个对象
 * var pixcel = new SuperMap.Pixel(100,50);
 *
 * //依据size创建
 *  var size = new SuperMap.Size(21,25);
 *  var offset = new SuperMap.Pixel(-(size.w/2), -size.h);
 */
var Pixel = function () {

    /**
     * @member SuperMap.Pixel.prototype.y -{number}
     * @description y坐标，默认为0.0
     */
    function Pixel(x, y, mode) {
        _classCallCheck(this, Pixel);

        this.x = 0.0;
        this.y = 0.0;
        this.mode = null;
        this.CLASS_NAME = "SuperMap.Pixel";

        this.x = x ? parseFloat(x) : this.x;
        this.y = y ? parseFloat(y) : this.y;
        this.mode = mode;
    }

    /**
     * @function SuperMap.Pixel.prototype.toString
     * @description 返回此对象的字符串形式
     * @example
     *
     * var pixcel = new SuperMap.Pixel(100,50);
     * var str = pixcel.toString();
     *
     * @returns {string} 例如: "x=200.4,y=242.2"
     */


    /**
     * @member SuperMap.Pixel.prototype.mode -{SuperMap.Pixel.Mode}
     * @description 坐标模式，有左上、右上、右下、左下这几种模式，分别表示相对于左上角、右上角、右下角、左下角的坐标。<br>
     * 值有<br>
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.RightTop}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.RightBottom}
     * * {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftBottom}
     *
     * 这四种 默认值为：{@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     *
     * @default {@link SuperMap.Pixel.Mode|SuperMap.Pixel.Mode.LeftTop}
     */


    /**
     * @member SuperMap.Pixel.prototype.x -{number}
     * @description x坐标，默认为0.0
     */


    _createClass(Pixel, [{
        key: "toString",
        value: function toString() {
            return "x=" + this.x + ",y=" + this.y;
        }

        /**
         * @function SuperMap.Pixel.prototype.clone
         * @description 克隆当前的 pixel 对象。
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * var pixcel2 = pixcel.clone();
         * @returns {SuperMap.Pixel} 返回一个新的与当前 pixel 对象有相同x、y坐标的 pixel 对象。
         */

    }, {
        key: "clone",
        value: function clone() {
            return new Pixel(this.x, this.y, this.mode);
        }

        /**
         * @function SuperMap.Pixel.prototype.equals
         * @description 比较两 pixel 是否相等
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * var pixcel2 = new SuperMap.Pixel(10050);
         * var isEquals = pixcel.equals(pixcel2);
         *
         * @param px - {SuperMap.Pixel} 用于比较相等的 pixel 对象。
         * @returns {Boolean} 如果传入的像素点和当前像素点相同返回true如果不同或传入参数为NULL则返回false
         */

    }, {
        key: "equals",
        value: function equals(px) {
            var equals = false;
            if (px != null) {
                equals = this.x == px.x && this.y == px.y || isNaN(this.x) && isNaN(this.y) && isNaN(px.x) && isNaN(px.y);
            }
            return equals;
        }

        /**
         * @function SuperMap.Pixel.prototype.distanceTo
         * @description 返回两个 pixel 的距离。
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * var pixcel2 = new SuperMap.Pixel(11030);
         * var distance = pixcel.distanceTo(pixcel2);
         *
         * @param px - {SuperMap.Pixel} 用于计算的一个 pixel
         * @returns {float} 作为参数传入的像素与当前像素点的距离。
         */

    }, {
        key: "distanceTo",
        value: function distanceTo(px) {
            return Math.sqrt(Math.pow(this.x - px.x, 2) + Math.pow(this.y - px.y, 2));
        }

        /**
         * @function SuperMap.Pixel.prototype.add
         * @description 在原来像素坐标基础上，x值加上传入的x参数，y值加上传入的y参数。
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * //pixcel2是新的对象
         * var pixcel2 = pixcel.add(2030);
         *
         * @param x - {number} 传入的x值。
         * @param y - {number} 传入的y值。
         * @returns {SuperMap.Pixel} 返回一个新的pixel对象，该pixel是由当前的pixel与传
         *      入的xy相加得到。
         */

    }, {
        key: "add",
        value: function add(x, y) {
            if (x == null || y == null) {
                throw new TypeError('Pixel.add cannot receive null values');
            }
            return new Pixel(this.x + x, this.y + y);
        }

        /**
         * @function SuperMap.Pixel.prototype.offset
         * @description 通过传入的 {@link SuperMap.Pixel} 参数对原屏幕坐标进行偏移。
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * var pixcel2 = new SuperMap.Pixel(13020);
         * //pixcel3 是新的对象
         * var pixcel3 = pixcel.offset(pixcel2);
         *
         * @param px - {SuperMap.Pixel}  传入的 <SuperMap.Pixel> 对象。
         * @returns {SuperMap.Pixel} 返回一个新的pixel，该pixel是由当前的pixel对象的x，y
         *      值与传入的Pixel对象的x，y值相加得到。
         */

    }, {
        key: "offset",
        value: function offset(px) {
            var newPx = this.clone();
            if (px) {
                newPx = this.add(px.x, px.y);
            }
            return newPx;
        }

        /**
         *
         * @function SuperMap.Pixel.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为null，而不是初始值。
         * @example
         * var pixcel = new SuperMap.Pixel(10050);
         * pixcel.destroy();
         */

    }, {
        key: "destroy",
        value: function destroy() {
            this.x = null;
            this.y = null;
            this.mode = null;
        }

        /**
         * @member SuperMap.Pixel.Mode
         * @enum {string}
         * @readonly
         * @description 模式
         *
         * * SuperMap.Pixel.Mode.LeftTop 左上模式
         * * SuperMap.Pixel.Mode.RightTop 右上模式
         * * SuperMap.Pixel.Mode.RightBottom 右下模式
         * * SuperMap.Pixel.Mode.LeftBottom 左下模式
         */

    }]);

    return Pixel;
}();

Pixel.Mode = {
    LeftTop: "lefttop",
    RightTop: "righttop",
    RightBottom: "rightbottom",
    LeftBottom: "leftbottom"
};
exports["default"] = Pixel;

_SuperMap2["default"].Pixel = Pixel;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(20);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiPoint
 * @classdesc 几何对象多点类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.Point>} 点对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(5,6);
 * var poine2 = new SuperMap.Geometry.Point(7,8);
 * var multiPoint = new SuperMap.Geometry.MultiPoint([point1,point2]);
 */
var MultiPoint = function (_Collection) {
    _inherits(MultiPoint, _Collection);

    function MultiPoint(components) {
        _classCallCheck(this, MultiPoint);

        var _this = _possibleConstructorReturn(this, (MultiPoint.__proto__ || Object.getPrototypeOf(MultiPoint)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.Point"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiPoint";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.MultiPoint.prototype.addPoint
     * @description 添加点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.addComponent}方法。
     * @param point - {SuperMap.Geometry.Point} 添加的点。
     * @param index - {integer} 可选的下标。
     */


    /**
     * @member SuperMap.Geometry.MultiPoint.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Point}"]
     */


    _createClass(MultiPoint, [{
        key: 'addPoint',
        value: function addPoint(point, index) {
            this.addComponent(point, index);
        }

        /**
         * @function SuperMap.Geometry.MultiPoint.prototype.removePoint
         * @description 移除点封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.removeComponent} 方法。
         * @param point - {SuperMap.Geometry.Point} 移除的点对象。
         */

    }, {
        key: 'removePoint',
        value: function removePoint(point) {
            this.removeComponent(point);
        }
    }]);

    return MultiPoint;
}(_Collection3["default"]);

exports["default"] = MultiPoint;

_SuperMap2["default"].Geometry.MultiPoint = MultiPoint;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(20);

var _Collection3 = _interopRequireDefault(_Collection2);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _LineString = __webpack_require__(25);

var _LineString2 = _interopRequireDefault(_LineString);

var _LinearRing = __webpack_require__(48);

var _LinearRing2 = _interopRequireDefault(_LinearRing);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.Polygon
 * @classdesc  多边形几何对象类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.LinearRing>} 用来生成多边形的线环数组。
 * @example
 * var points =[new SuperMap.Geometry.Point(0,4010338),
 *      new SuperMap.Geometry.Point(1063524,4010338),
 *      new SuperMap.Geometry.Point(1063524,3150322),
 *      new SuperMap.Geometry.Point(0,3150322)
 *  ],
 *  var linearRings = new SuperMap.Geometry.LinearRing(points),
 *  var  region = new SuperMap.Geometry.Polygon([linearRings]);
 */
var Polygon = function (_Collection) {
    _inherits(Polygon, _Collection);

    function Polygon(components) {
        _classCallCheck(this, Polygon);

        var _this = _possibleConstructorReturn(this, (Polygon.__proto__ || Object.getPrototypeOf(Polygon)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.LinearRing"];
        _this.CLASS_NAME = "SuperMap.Geometry.Polygon";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.Polygon.prototype.getArea
     * @description 获得区域面积，从区域的外部口径减去计此区域内部口径算所得的面积。
     * @returns {float} 几何对象的面积。
     */


    /**
     * @member SuperMap.Geometry.Polygon.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.LinearRing}"]
     */


    _createClass(Polygon, [{
        key: 'getArea',
        value: function getArea() {
            var area = 0.0;
            if (this.components && this.components.length > 0) {
                area += Math.abs(this.components[0].getArea());
                for (var i = 1, len = this.components.length; i < len; i++) {
                    area -= Math.abs(this.components[i].getArea());
                }
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.getGeodesicArea
         * @description 计算投影到球面上的多边形近似面积。
         * @param projection - {SuperMap.Projection} 空间参考系统的几何坐标。如果没有设置，默认 WGS84。
         * @returns {float} 多边形近似测地面积。
         */

    }, {
        key: 'getGeodesicArea',
        value: function getGeodesicArea(projection) {
            var area = 0.0;
            if (this.components && this.components.length > 0) {
                area += Math.abs(this.components[0].getGeodesicArea(projection));
                for (var i = 1, len = this.components.length; i < len; i++) {
                    area -= Math.abs(this.components[i].getGeodesicArea(projection));
                }
            }
            return area;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.containsPoint
         * @description 判断点是否在多边形里。
         * @param point - {SuperMap.Geometry.Point} 点对象。
         * @returns {boolean | number} 是否在多边形里。
         */

    }, {
        key: 'containsPoint',
        value: function containsPoint(point) {
            var numRings = this.components.length;
            var contained = false;
            if (numRings > 0) {
                // check exterior ring - 1 means on edge, boolean otherwise
                contained = this.components[0].containsPoint(point);
                if (contained !== 1) {
                    if (contained && numRings > 1) {
                        // check interior rings
                        var hole;
                        for (var i = 1; i < numRings; ++i) {
                            hole = this.components[i].containsPoint(point);
                            if (hole) {
                                if (hole === 1) {
                                    // on edge
                                    contained = 1;
                                } else {
                                    // in hole
                                    contained = false;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            return contained;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.intersects
         * @description 判断两个几何对象是否相交。
         * @param geometry - {SuperMap.Geometry} 任何类型的几何对象。
         * @returns {boolean} 两个几何对象是否相交。
         */

    }, {
        key: 'intersects',
        value: function intersects(geometry) {
            var intersect = false;
            var i, len;
            if (geometry.CLASS_NAME === "SuperMap.Geometry.Point") {
                intersect = this.containsPoint(geometry);
            } else if (geometry.CLASS_NAME === "SuperMap.Geometry.LineString" || geometry.CLASS_NAME === "SuperMap.Geometry.LinearRing") {
                // check if rings/linestrings intersect
                for (i = 0, len = this.components.length; i < len; ++i) {
                    intersect = geometry.intersects(this.components[i]);
                    if (intersect) {
                        break;
                    }
                }
                if (!intersect) {
                    // check if this poly contains points of the ring/linestring
                    for (i = 0, len = geometry.components.length; i < len; ++i) {
                        intersect = this.containsPoint(geometry.components[i]);
                        if (intersect) {
                            break;
                        }
                    }
                }
            } else {
                for (i = 0, len = geometry.components.length; i < len; ++i) {
                    intersect = this.intersects(geometry.components[i]);
                    if (intersect) {
                        break;
                    }
                }
            }
            // check case where this poly is wholly contained by another
            if (!intersect && geometry.CLASS_NAME === "SuperMap.Geometry.Polygon") {
                // exterior ring points will be contained in the other geometry
                var ring = this.components[0];
                for (i = 0, len = ring.components.length; i < len; ++i) {
                    intersect = geometry.containsPoint(ring.components[i]);
                    if (intersect) {
                        break;
                    }
                }
            }
            return intersect;
        }

        /**
         * @function SuperMap.Geometry.Polygon.prototype.distanceTo
         * @description 计算两个几何对象间的最小距离（x-y平面坐标系下）。
         * @param geometry - {SuperMap.Geometry} 目标几何对象。
         * @param options - {Object}可选参数。<br>
         *         details - {boolean} 返回距离计算的细节。默认为false。<br>
         *         edge - {boolean} 计算一个几何对象到目标几何对象边缘的最近距离。默认为true。 如果设为true，
         *                          一个几何图形完全包含在目标几何对象中时，调用distanceTo返回非零结果，如果false，
         *                          两个几何对象相交情况下调用distanceTo结果返回0，而且如果false，将不返距离。
         * @returns {number | Object} 返回一个几何对象到目标几何对象的距离。
         */

    }, {
        key: 'distanceTo',
        value: function distanceTo(geometry, options) {
            var edge = !(options && options.edge === false);
            var result;
            // this is the case where we might not be looking for distance to edge
            if (!edge && this.intersects(geometry)) {
                result = 0;
            } else {
                result = _get(Polygon.prototype.__proto__ || Object.getPrototypeOf(Polygon.prototype), 'distanceTo', this).call(this, geometry, options);
            }
            return result;
        }

        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygon
         * @description 创建 RegularPolygon 对象。
         * @param origin - {SuperMap.Geometry.Point} 多边形的中心 。
         * @param radius - {float} 半径。
         * @param sides - {integer} 边数，20个近似一个圆。
         * @param rotation - {float} 旋转角度，单位为degrees。
         * @example
         * var sides = 50;
         * var origin = new SuperMap.Geometry.Point(50);
         * var polygon = SuperMap.Geometry.Polygon.createRegularPolygon(origin6sides270);
         */

    }], [{
        key: 'createRegularPolygon',
        value: function createRegularPolygon(origin, radius, sides, rotation) {
            var angle = Math.PI * (1 / sides - 1 / 2);
            if (rotation) {
                angle += rotation / 180 * Math.PI;
            }
            var rotatedAngle, x, y;
            var points = [];
            for (var i = 0; i < sides; ++i) {
                rotatedAngle = angle + i * 2 * Math.PI / sides;
                x = origin.x + radius * Math.cos(rotatedAngle);
                y = origin.y + radius * Math.sin(rotatedAngle);
                points.push(new _Point2["default"](x, y));
            }
            var ring = new _LinearRing2["default"](points);
            return new Polygon([ring]);
        }
    }, {
        key: 'createRegularPolygonCurve',


        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygonCurve
         * @description 创建扇形对象。
         * @param origin - {SuperMap.Geometry.Point} 多边形的中心 。
         * @param radius - {float} 半径。
         * @param sides - {integer} 边数，50个近似一个扇形。
         * @param r - {integer}
         * @param angel - {float} 旋转角度，单位为degrees。沿着x轴正方向的逆时针方向。
         * @param resolution - {float} 当前地图的分辨率.,固定大小下输入，其他情况不需要此参数
         * 备注：Geometry内部单位均为地理单位，默认用户输入的参数也为地理单位，如果传入resolution，则半径则为
         * 为像素单位，内部会根据像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @returns {SuperMap.Geometry.Polygon} 几何面对象。
         * @example
         * var sides = 50;
         * var origin = new SuperMap.Geometry.Point(5,0);
         * var polygon = SuperMap.Geometry.Polygon.createRegularPolygonCurve(origin,6,sides,270);
         */
        value: function createRegularPolygonCurve(origin, radius, sides, r, angel, resolution) {
            if (resolution == undefined) resolution = 1;

            var rR = r * Math.PI / (180 * sides);

            var rotatedAngle, x, y;
            var points = [];
            for (var i = 0; i < sides; ++i) {
                rotatedAngle = rR * i;
                x = origin.x + radius * resolution * Math.cos(rotatedAngle);
                y = origin.y + radius * resolution * Math.sin(rotatedAngle);
                points.push(new _Point2["default"](x, y));
            }
            rotatedAngle = r * Math.PI / 180;
            x = origin.x + radius * resolution * Math.cos(rotatedAngle);
            y = origin.y + radius * resolution * Math.sin(rotatedAngle);
            points.push(new _Point2["default"](x, y));

            points.push(origin);

            var ring = new _LinearRing2["default"](points);
            ring.rotate(parseFloat(angel), origin);
            var geo = new Polygon([ring]);
            geo.origin = origin;
            geo.radius = radius;
            geo.r = r;
            geo.angel = angel;
            geo.sides = sides;
            geo.polygonType = "Curve";
            return geo;
        }
    }, {
        key: 'createRegularPolygonTriangle',


        /**
         * @function SuperMap.Geometry.Polygon.createRegularPolygonTriangle
         * @description 创建4G三角形,电信行业4G专业符号形容类似为：-▷。
         * @param origin - {SuperMap.Geometry.Point} 三角形的原点 。
         * @param height - {float} 外接矩形的高度。
         * @param width - {float} 外接矩形的宽度。
         * @param lineLength - {float} 线长度。
         * @param angel - {float} 旋转角度，单位为degrees,沿着x轴正方向的逆时针方向.。
         * @param resolution - {float} 当前地图的分辨率.,固定大小下输入，其他情况不需要此参数。备注：Geometry内部单位均为地理单位，
         *                              默认用户输入的参数也为地理单位，如果传入resolution，则height、width、lineLength则为像素单
         *                              位，内部会根据像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @returns {SuperMap.Geometry.Collection} 几何对象集合，面对象&线对象。
         */
        value: function createRegularPolygonTriangle(origin, height, width, lineLength, angel, resolution) {
            if (resolution == undefined) resolution = 1;

            var lineList = [];
            lineList.push(origin);
            lineList.push(new _Point2["default"](origin.x + lineLength * resolution, origin.y));
            var geoline = new _LineString2["default"](lineList);
            geoline.rotate(parseFloat(angel), origin);

            var triangleList = [];
            triangleList.push(new _Point2["default"](origin.x + height * resolution, origin.y));
            triangleList.push(new _Point2["default"](origin.x + lineLength * resolution, origin.y + width * resolution / 2));
            triangleList.push(new _Point2["default"](origin.x + lineLength * resolution, origin.y - width * resolution / 2));
            var geoTriangle = new _LinearRing2["default"](triangleList);
            geoTriangle.rotate(parseFloat(angel), origin);
            var geo = new _Collection3["default"]([geoline, geoTriangle]);
            geo.origin = origin;
            geo.height = height;
            geo.width = width;
            geo.lineLength = lineLength;
            geo.angel = angel;
            geo.polygonType = "Triangle";
            return geo;
        }
    }, {
        key: 'createBsplinesurface',


        /**
         * @function SuperMap.Geometry.Polygon.createBsplinesurface
         * @description 创建3G B样条曲面，电信3G专业符号，由B样条曲线模拟生成。
         * @param origin - {SuperMap.Geometry.Point} 曲面的原点 。
         * @param height - {float} 外接矩形的高度。
         * @param width - {float} 外接矩形的宽度。
         * @param angel - {float} 旋转角度，单位为degrees，沿着x轴正方向的逆时针方向。
         * @param resolution - {float} 当前地图的分辨率，固定大小下输入，其他情况不需要此参数。备注：Geometry内部单位均为地理单位，
         *                              默认用户输入的参数也为地理单位，如果传入resolution，则height、width为像素单位，内部会根据
         *                              像素值和分辨率获取地理大小后在进行构造Geometry，但最终的Geometry均为地理单位。
         * @param k - {number} 递推次数，可以控制曲线的光滑度。
         * @returns {SuperMap.Geometry.Polygon} 几何面对象。
         */
        value: function createBsplinesurface(origin, height, width, angel, resolution, k) {
            if (resolution == undefined) resolution = 1;

            if (k == undefined) k = 10;

            var pointList = [];
            pointList.push(origin);
            pointList.push(origin);

            pointList.push(new _Point2["default"](origin.x + height * resolution * 2 / 3, origin.y + width * resolution / 2));
            pointList.push(new _Point2["default"](origin.x + height * resolution, origin.y + width * resolution / 2));
            pointList.push(new _Point2["default"](origin.x + height * resolution, origin.y - width * resolution / 2));
            pointList.push(new _Point2["default"](origin.x + height * resolution * 2 / 3, origin.y - width * resolution / 2));

            pointList.push(origin);
            pointList.push(origin);

            var pointList2 = [];
            var i, j, a0, a1, a2, dt, t1, t2;
            var t_x, t_y;
            var n = pointList.length;
            dt = 1.0 / k;

            pointList2.push(new _Point2["default"]((pointList[0].x + pointList[1].x) / 2, (pointList[0].y + pointList[1].y) / 2));

            for (i = 1; i < n - 1; i++) {
                for (j = 0; j <= k; j++) {
                    t1 = j * dt;
                    t2 = t1 * t1;

                    a0 = (t2 - 2 * t1 + 1) / 2.0;
                    a1 = (2 * t1 - 2 * t2 + 1) / 2.0;
                    a2 = t2 / 2.0;

                    t_x = a0 * pointList[i - 1].x + a1 * pointList[i].x + a2 * pointList[i + 1].x;
                    t_y = a0 * pointList[i - 1].y + a1 * pointList[i].y + a2 * pointList[i + 1].y;
                    pointList2.push(new _Point2["default"](t_x, t_y));
                }
            }

            var ring = new _LinearRing2["default"](pointList2);
            ring.rotate(parseFloat(angel), origin);
            var geo = new _Collection3["default"]([ring]);
            geo.origin = origin;
            geo.height = height;
            geo.width = width;
            geo.angel = angel;
            geo.polygonType = "Bspline";
            return geo;
        }
    }]);

    return Polygon;
}(_Collection3["default"]);

exports["default"] = Polygon;


_SuperMap2["default"].Geometry.Polygon = Polygon;

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

__webpack_require__(22);

var _FetchRequest = __webpack_require__(15);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.iPortalServiceBase
 * @classdesc iPortal服务基类(有权限限制的类需要实现此类)
 * @param url - {string} iPortal服务地址
 */
var IPortalServiceBase = function () {
    function IPortalServiceBase(url) {
        _classCallCheck(this, IPortalServiceBase);

        this.CLASS_NAME = "SuperMap.iPortalServiceBase";

        var me = this;
        me.serviceUrl = url;
        me.serverType = _REST.ServerType.iPortal;
    }

    /**
     * @function SuperMap.iPortalServiceBase.prototype.request
     * @description 子类统一通过该方法发送请求
     * @param method -{string} 请求类型
     * @param url -{string} 服务地址
     * @param param -{Object} 请求参数
     * @param requestOptions -{Object} fetch请求配置项
     * @returns {Promise}
     */

    _createClass(IPortalServiceBase, [{
        key: 'request',
        value: function request(method, url, param, requestOptions) {
            url = this.createCredentialUrl(url);
            return _FetchRequest.FetchRequest.commit(method, url, param, requestOptions).then(function (response) {
                return response.json();
            });
        }

        /*
         * @function SuperMap.iPortalServiceBase.prototype.createCredentialUrl
         * @description 追加授权信息
         * @param url -{string} 创建证书url地址
         * @return {string} 携带token或key的新地址
         */

    }, {
        key: 'createCredentialUrl',
        value: function createCredentialUrl(url) {
            var newUrl = url,
                credential = this.getCredential();

            if (credential) {
                var endStr = newUrl.substring(newUrl.length - 1, newUrl.length);

                if (newUrl.indexOf("?") > -1 && endStr === "?") {
                    newUrl += credential.getUrlParameters();
                } else if (newUrl.indexOf("?") > -1 && endStr !== "?") {
                    newUrl += "&" + credential.getUrlParameters();
                } else {
                    newUrl += "?" + credential.getUrlParameters();
                }
            }
            return newUrl;
        }

        /*
         * @function SuperMap.iPortalServiceBase.prototype.getCredential
         * @description 获取token
         * @return {string } 返回获取的token
         *
         */

    }, {
        key: 'getCredential',
        value: function getCredential() {
            var credential,
                value = _SuperMap2["default"].SecurityManager.getToken(this.serviceUrl);
            credential = value ? new _SuperMap2["default"].Credential(value, "token") : null;
            if (!credential) {
                value = this.getKey();
                credential = value ? new _SuperMap2["default"].Credential(value, "key") : null;
            }
            return credential;
        }

        /**
         * @function SuperMap.iPortalServiceBase.prototype.getKey
         * @description 其子类需要重写该方法，修改其中获取key的字段，存储key可能是服务id字段，可能是url
         */

    }, {
        key: 'getKey',
        value: function getKey() {
            //return SuperMap.SecurityManager.getKey(this.id);
            //或
            //return SuperMap.SecurityManager.getKey(this.serviceUrl);
        }
    }]);

    return IPortalServiceBase;
}();

exports["default"] = IPortalServiceBase;


_SuperMap2["default"].iPortalServiceBase = IPortalServiceBase;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.JoinItem
 * @classdesc 连接信息类。
 * 该类用于矢量数据集与外部表的连接。外部表可以为另一个矢量数据集（其中纯属性数据集中没有空间几何信息）所对应的 DBMS 表，也可以是用户自建的业务表。需要注意的是，矢量数据集与外部表必须属于同一数据源。表之间的联系的建立有两种方式，一种是连接（join），一种是关联（link）。连接，实际上是依据相同的字段将一个外部表追加到指定的表；而关联是基于一个相同的字段定义了两个表格之间的联系，但不是实际的追加。用于连接两个表的字段的名称不一定相同，但类型必须一致。当两个表格之间建立了连接，通过对主表进行操作，可以对外部表进行查询，制作专题图以及分析等。当两个表格之间是一对一或多对一的关系时，可以使用 join 连接。当为多对一的关系时，允许指定多个字段之间的关联。(注意：SuperMap.JoinItem 目前支持左连接和内连接，不支持全连接和右连接，UDB 引擎不支持内连接。并且用于建立连接的两个表必须在同一个数据源下。)
 * @param options - {Object} 可選参数。如:</br>
 *        foreignTableName - {string} 外部表的名称。</br>
 *        joinFilter - {string} 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。</br>
 *        joinType - {SuperMap.JoinType} 两个表之间连接类型。</br>
 * @example 下面以SQL查询说明joinItem的使用方法：
 *(start code)
 *   function queryBySQL() {
     *       // 设置与外部表的连接信息
     *       var joinItem = new SuperMap.JoinItem({
     *           foreignTableName: "foreignTable",
     *           joinFilter: "foreignTable.CONTINENT = Countries.CONTINENT",
     *           joinType: "LEFTJOIN"
     *       })
     *       var queryParam, queryBySQLParams, queryBySQLService;
     *       // 设置查询参数，在查询参数中添加joinItem关联条件信息
     *       queryParam = new SuperMap.FilterParameter({
     *            name: "Countries@World",
     *            joinItems: [joinItem]
     *         }),
     *       queryBySQLParams = new SuperMap.QueryBySQLParameters({
     *             queryParams: [queryParam]
     *         }),
     *       queryBySQLService = new SuperMap.QueryBySQLService(url, {
     *             eventListeners: { "processCompleted": processCompleted, "processFailed": processFailed}
     *         });
     *       queryBySQLService.processAsync(queryBySQLParams);
     *  }
 *  function processCompleted(queryEventArgs) {//todo}
 *  function processFailed(e) {//todo}
 * (end)
 */
var JoinItem = function () {

    /**
     * @member SuperMap.JoinItem.prototype.joinFilter -{string}
     * @description 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。
     * 例如，将房屋面数据集（Building）的 district 字段与房屋拥有者的纯属性数据集（Owner）的 region 字段相连接，
     * 两个数据集对应的表名称分别为 Table_Building 和 Table_Owner，
     * 则连接表达式为 Table_Building.district = Table_Owner.region。
     * 当有多个字段相连接时，用 AND 将多个表达式相连。
     */
    function JoinItem(options) {
        _classCallCheck(this, JoinItem);

        this.foreignTableName = null;
        this.joinFilter = null;
        this.joinType = null;
        this.CLASS_NAME = "SuperMap.JoinItem";

        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.JoinItem.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.JoinItem.prototype.joinType -{JoinType}
     * @description 两个表之间连接类型。
     * 连接类型决定了对两个表进行连接查询后返回的记录的情况。
     */

    /**
     * @member SuperMap.JoinItem.prototype.foreignTableName -{string}
     * @description 外部表的名称。
     * 如果外部表的名称是以“表名@数据源名”命名方式，则该属性只需赋值表名。
     * 例如：外部表 Name@changchun，Name 为表名，changchun 为数据源名称，则该属性的赋值应为：Name。
     */


    _createClass(JoinItem, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.foreignTableName = null;
            me.joinFilter = null;
            me.joinType = null;
        }

        /**
         * @function SuperMap.JoinItem.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         */

    }, {
        key: "toServerJSONObject",
        value: function toServerJSONObject() {
            var dataObj = {};
            dataObj = _SuperMap2["default"].Util.copyAttributes(dataObj, this);
            //joinFilter基本是个纯属性对象，这里不再做转换
            return dataObj;
        }
    }]);

    return JoinItem;
}();

exports["default"] = JoinItem;

_SuperMap2["default"].JoinItem = JoinItem;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.LabelMatrixCell
 * @classdesc 矩阵标签元素抽象类。
 * @description 该类可以包含 n*n 个矩阵标签元素，矩阵标签元素的类型可以是图片，符号，标签专题图等。
 *              符号类型的矩阵标签元素类、图片类型的矩阵标签元素类和专题图类型的矩阵标签元素类均继承自该类。
 */
var LabelMatrixCell = function LabelMatrixCell() {
  _classCallCheck(this, LabelMatrixCell);

  this.CLASS_NAME = "LabelMatrixCell";
};

exports["default"] = LabelMatrixCell;


_SuperMap2["default"].LabelMatrixCell = LabelMatrixCell;

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _PointWithMeasure = __webpack_require__(284);

var _PointWithMeasure2 = _interopRequireDefault(_PointWithMeasure);

var _Collection2 = __webpack_require__(20);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Route
 * @classdesc
 * 路由对象类。路由对象为一系列有序的带有属性值 M 的 x，y 坐标对，其中 M 值为该结点的距离属性（到已知点的距离）。
 * @param points - {{Array<SuperMap.Geometry>}} 形成路由对象的线数组。
 * @param  options - {Object} 可选参数。如:</br>
 *         id - {number}路由对象在数据库中的id。</br>
 *         length - {number}路由对象的长度。</br>
 *         maxM - {number}最大线性度量值，即所有结点到起始点的量算距离中最大值。</br>
 *         minM - {number}最小线性度量值，即所有结点到起始点的量算距离中最小值。</br>
 *         type - {string} 数据类型，如："LINEM"</br>
 * @extends SuperMap.Geometry.Collection
 */
var Route = function (_Collection) {
    _inherits(Route, _Collection);

    /**
     * @member SuperMap.Route.prototype.type -{string}
     * @description 服务端几何对象类型。
     */


    /**
     * @member SuperMap.Route.prototype.parts -{Array<number>}
     * @description 服务端几何对象中各个子对象所包含的节点个数。
     */


    /**
     *  @member SuperMap.Route.prototype.maxM -{number}
     *  @description 最大线性度量值，即所有结点到起始点的量算距离中最大值。
     */


    /**
     * @member SuperMap.Route.prototype.style -{string}
     * @description 路由对象的样式
     */


    /**
     * @member SuperMap.Route.prototype.id -{number}
     * @description 路由对象在数据库中的id。
     */
    function Route(points, options) {
        _classCallCheck(this, Route);

        var _this = _possibleConstructorReturn(this, (Route.__proto__ || Object.getPrototypeOf(Route)).call(this, points, options));

        _this.id = null;
        _this.center = null;
        _this.style = null;
        _this.length = null;
        _this.maxM = null;
        _this.minM = null;
        _this.parts = null;
        _this.points = null;
        _this.type = null;
        _this.componentTypes = ["SuperMap.Geometry.LinearRing", "SuperMap.Geometry.LineString"];
        _this.CLASS_NAME = "SuperMap.Route";

        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     *
     * @function SuperMap.Route.prototype.toJson
     * @description 转换为json对象。
     * @return{Object} json对象
     */


    /**
     * @member SuperMap.Route.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @default ["{@link SuperMap.Geometry.LinearRing}", "{@link SuperMap.Geometry.LineString}"];
     */


    /**
     * @member SuperMap.Route.prototype.points -{Array<Object>}
     * @description 路由对象的所有路由点。
     * @example
     * (start code)
     * [
     *  {
     *      "measure": 0,
     *      "y": -4377.027184298267,
     *      "x": 4020.0045221720466
     *  },
     *  {
     *      "measure": 37.33288381391519,
     *      "y": -4381.569363260499,
     *      "x": 4057.0600591960642
     *  }
     * ]
     * (end)
     */


    /**
     * @member SuperMap.Route.prototype.minM -{number}
     * @description 最小线性度量值，即所有结点到起始点的量算距离中最小值。
     */


    /**
     * @member SuperMap.Route.prototype.length -{number}
     * @description 路由对象的长度。单位与数据集的单位相同。
     */


    /**
     * @member SuperMap.Route.prototype.center -{number}
     * @description 路由对象的中心点
     */


    _createClass(Route, [{
        key: 'toJson',
        value: function toJson() {
            var result = "{";
            if (this.id != null && this.id != undefined) {
                result += "\"id\":" + this.id + ",";
            }
            if (this.center != null && this.center != undefined) {
                result += "\"center\":" + this.center + ",";
            }
            if (this.style != null && this.style != undefined) {
                result += "\"style\":" + this.style + ",";
            }
            if (this.length != null && this.length != undefined) {
                result += "\"length\":" + this.length + ",";
            }
            if (this.maxM != null && this.maxM != undefined) {
                result += "\"maxM\":" + this.maxM + ",";
            }
            if (this.minM != null && this.minM != undefined) {
                result += "\"minM\":" + this.minM + ",";
            }
            if (this.type != null && this.type != undefined) {
                result += "\"type\":\"" + this.type + "\",";
            }
            if (this.parts != null && this.parts != undefined) {
                result += "\"parts\":[" + this.parts[0];

                for (var i = 1; i < this.parts.length; i++) {
                    result += "," + this.parts[i];
                }
                result += "],";
            }
            if (this.components != null && this.components.length > 0) {
                result += "\"points\":[";
                for (var j = 0, len = this.components.length; j < len; j++) {
                    for (var k = 0, len2 = this.components[j].components.length; k < len2; k++) {
                        result += this.components[j].components[k].toJson() + ",";
                    }
                }
                result = result.replace(/,$/g, '');
                result += "]";
            }
            result = result.replace(/,$/g, '');
            result += "}";
            return result;
        }

        /**
         * @function SuperMap.Route.prototype.destroy
         * @override
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.id = null;
            me.center = null;
            me.style = null;
            me.length = null;
            me.maxM = null;
            me.minM = null;
            me.type = null;
            me.parts = null;
            me.components.length = 0;
            me.components = null;
            me.componentTypes = null;
        }

        /**
         * @function SuperMap.Route.fromJson
         * @description  将 JSON 对象转换为 SuperMap.Route 对象。
         * @param jsonObject - {Object} JSON 对象表示的路由对象。
         * @return{SuperMap.Route} 转化后的 Route 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            if (!jsonObject) {
                return;
            }

            var geoParts = jsonObject.parts || [],
                geoPoints = jsonObject.points || [],
                len = geoParts.length,
                lineList = [];
            if (len > 0) {
                for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
                    for (var j = 0; j < geoParts[i]; j++) {
                        pointList.push(_PointWithMeasure2["default"].fromJson(geoPoints[pointIndex + j]));
                    }
                    pointIndex += geoParts[i];
                    //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString
                    if (pointList[0].equals(pointList[geoParts[i] - 1])) {
                        lineList.push(new _SuperMap2["default"].Geometry.LinearRing(pointList));
                    } else {
                        lineList.push(new _SuperMap2["default"].Geometry.LineString(pointList));
                    }
                    pointList = [];
                }
            } else {
                return null;
            }

            return new Route(lineList, {
                id: jsonObject.id,
                center: jsonObject.center,
                style: jsonObject.style,
                length: jsonObject.length,
                maxM: jsonObject.maxM,
                minM: jsonObject.minM,
                type: jsonObject.type,
                parts: jsonObject.parts
            });
        }
    }]);

    return Route;
}(_Collection3["default"]);

exports["default"] = Route;


_SuperMap2["default"].Route = Route;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServerStyle = __webpack_require__(11);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeFlow
 * @classdesc 标签或符号流动显示和牵引线风格设置类。
 *              通过该类可以设置专题图中符号是否流动显示、是否使用牵引线以及牵引线风格。
 * @param options - {Object} 可选参数。如：<br>
 *        flowEnabled - {boolean} 是否流动显示标签或符号。<br>
 *        leaderLineDisplayed - {boolean} 是否显示标签或符号和它标注的对象之间的牵引线。<br>
 *        leaderLineStyle - {{@link SuperMap.ServerStyle}} 标签或符号与其标注对象之间牵引线的风格。
 */
var ThemeFlow = function () {

    /**
     * @member SuperMap.ThemeFlow.prototype.leaderLineDisplayed -{boolean}
     * @description 是否显示标签或符号和它标注的对象之间的牵引线。默认值为 false，即不显示标签或符号和它标注的对象之间的牵引线。<br>
     *              只有当 flowEnabled 为 true 时，牵引线才起作用。在当标签流动显示时，其位置不固定，由于牵引线始终指向要素的内点，<br>
     *              因而通过牵引线显示功能可以找到流动的标签或符号实际对应的要素。或者渲染符号偏移它所指向的对象时，图与对象之间可以采用牵引线进行连接。
     */
    function ThemeFlow(options) {
        _classCallCheck(this, ThemeFlow);

        this.flowEnabled = false;
        this.leaderLineDisplayed = false;
        this.leaderLineStyle = null;
        this.CLASS_NAME = "SuperMap.ThemeFlow";

        var me = this;
        me.leaderLineStyle = new _ServerStyle2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ThemeFlow.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeFlow.prototype.leaderLineStyle -{SuperMap.ServerStyle}
     * @description 标签或符号与其标注对象之间牵引线的风格。
     */


    /**
     * @member SuperMap.ThemeFlow.prototype.flowEnabled -{boolean}
     * @description 是否流动显示标签或符号。<br>
     *              对于标签专题图而言，对于跨越比较大的区域和线条状的几何对象，在一个地图窗口中不能完全显示的情况下，如果其标签位置比较固定，<br>
     *              在当前地图窗口中该对象的标签不可见，则需要通过平移地图来查看对象的标签信息。如果采用了流动显示的效果，在当前地图窗口中，对象即使是部分显示，<br>
     *              其标签也会显示在当前地图窗口中。当平移地图时，对象的标签会随之移动，以保证在当前地图窗口中部分或全部显示的对象其标签都可见，从而可以方便地查看各要素的标签信息。
     */


    _createClass(ThemeFlow, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.flowEnabled = null;
            me.leaderLineDisplayed = null;
            if (me.leaderLineStyle) {
                me.leaderLineStyle.destroy();
                me.leaderLineStyle = null;
            }
        }

        /**
         * @function SuperMap.ThemeFlow.fromObj
         * @description 从传入对象获取标签或符号流动显示和牵引线风格设置类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeFlow} ThemeFlow对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) {
                return;
            }
            var res = new ThemeFlow();
            _SuperMap2["default"].Util.copy(res, obj);
            res.leaderLineStyle = _ServerStyle2["default"].fromJson(obj.leaderLineStyle);
            return res;
        }
    }]);

    return ThemeFlow;
}();

exports["default"] = ThemeFlow;


_SuperMap2["default"].ThemeFlow = ThemeFlow;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeLabelItem = __webpack_require__(328);

var _ThemeLabelItem2 = _interopRequireDefault(_ThemeLabelItem);

var _ThemeLabelUniqueItem = __webpack_require__(330);

var _ThemeLabelUniqueItem2 = _interopRequireDefault(_ThemeLabelUniqueItem);

var _ThemeFlow = __webpack_require__(66);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(68);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeLabelText = __webpack_require__(329);

var _ThemeLabelText2 = _interopRequireDefault(_ThemeLabelText);

var _ThemeLabelAlongLine = __webpack_require__(326);

var _ThemeLabelAlongLine2 = _interopRequireDefault(_ThemeLabelAlongLine);

var _ThemeLabelBackground = __webpack_require__(327);

var _ThemeLabelBackground2 = _interopRequireDefault(_ThemeLabelBackground);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeLabel
 * @classdesc 标签专题图类。
 * @extends SuperMap.Theme
 * @param  options - {Object} 可选参数。如：<br>
 *         alongLine - {{@link SuperMap.ThemeLabelAlongLine}} 标签沿线标注方向样式类。<br>
 *         background - {{@link SuperMap.ThemeLabelBackground}} 标签专题图中标签的背景风格类。<br>
 *         flow - {{@link SuperMap.ThemeFlow}} 标签专题图标签流动显示与牵引线设置类。<br>
 *         items - {Array<{@link SuperMap.ThemeUniqueItem}>} 分段标签专题图的子项数组。<br>
 *         labelExpression - {string} 标注字段表达式。<br>
 *         labelOverLengthMode - {{@link SuperMap.LabelOverLengthMode}} 标签专题图中超长标签的处理模式枚举类。<br>
 *         matrixCells - {Array<{@link SuperMap.LabelMatrixCell}>} 矩阵标签元素数组。<br>
 *         maxLabelLength - {number}标签在每一行显示的最大长度。<br>
 *         numericPrecision - {number}通过该字段设置其显示的精度。<br>
 *         offset - {{@link SuperMap.ThemeOffset}} 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。<br>
 *         overlapAvoided - {boolean} 是否允许以文本避让方式显示文本。<br>
 *         rangeExpression - {string} 制作分段标签专题的分段字段或字段表达式。<br>
 *         smallGeometryLabeled - {boolean} 是否显示长度大于被标注对象本身长度的标签。<br>
 *         text - {{@link SuperMap.ThemeLabelText}} 标签中文本风格。<br>
 *         textSpace - {number} 沿线标注，相邻两个文字之间的间距，单位当前设置的字高。<br>
 *         memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeLabel = function (_Theme) {
    _inherits(ThemeLabel, _Theme);

    /**
     * @member SuperMap.ThemeLabel.prototype.text -{SuperMap.ThemeLabelText}
     * @description 标签中文本风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.uniqueExpression -{string}
     * @description 用于制作单值专题图的字段或字段表达式。
     *              该字段值的数据类型可以为数值型或字符型。如果设置字段表达式，只能是相同数据类型字段间的运算。必设字段,必须与labelExpression一起使用
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.overlapAvoided -{boolean}
     * @description 是否允许以文本避让方式显示文本。默认值为 true， 即自动避免文本叠盖。只针对该标签专题图层中的文本数据。
     *               在标签重叠度很大的情况下，即使使用自动避让功能，可能也无法完全避免标签重叠现象。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.numericPrecision -{number}
     * @description 如果显示的标签内容为数字，通过该字段设置其显示的精度。例如标签对应的数字是8071.64529347，
     *              如果该属性为0时，显示8071；为1时，显示8071.6；为3时，则是8071.645。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.matrixCells -{Array<SuperMap.LabelMatrixCell>}
     * @description 矩阵标签元素数组，用于制作矩阵标签专题图。
     *              数组中可以放置符号类型的矩阵标签元素和图片类型的矩阵标签元素。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.labelExpression -{string}
     * @description 标注字段表达式。系统将 labelExpression 对应的字段或字段表达式的值以标签的形式显示在图层中。必设字段。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.items - {Array<SuperMap.ThemeUniqueItem>}
     * @description 分段标签专题图的子项数组。分段标签专题图使用 rangeExpression <br>
     *              指定数字型的字段作为分段数据，items 中的每个子对象的 [start，end) 分段值必须来源于属性 rangeExpression 的字段值。每个子项拥有自己的风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.background -{SuperMap.ThemeLabelBackground}
     * @description 标签专题图中标签的背景风格类。通过该字段可以设置标签的背景形状和风格。
     */
    function ThemeLabel(options) {
        _classCallCheck(this, ThemeLabel);

        var _this = _possibleConstructorReturn(this, (ThemeLabel.__proto__ || Object.getPrototypeOf(ThemeLabel)).call(this, "LABEL", options));

        _this.alongLine = null;
        _this.background = null;
        _this.flow = null;
        _this.items = null;
        _this.uniqueItems = null;
        _this.labelExpression = null;
        _this.labelOverLengthMode = _REST.LabelOverLengthMode.NONE;
        _this.matrixCells = null;
        _this.maxLabelLength = 256;
        _this.numericPrecision = 0;
        _this.offset = null;
        _this.overlapAvoided = true;
        _this.rangeExpression = null;
        _this.uniqueExpression = null;
        _this.smallGeometryLabeled = false;
        _this.text = null;
        _this.textSpace = 0;
        _this.CLASS_NAME = "SuperMap.ThemeLabel";

        var me = _this;
        me.alongLine = new _ThemeLabelAlongLine2["default"]();
        me.background = new _ThemeLabelBackground2["default"]();
        me.flow = new _ThemeFlow2["default"]();
        me.offset = new _ThemeOffset2["default"]();
        me.text = new _ThemeLabelText2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeLabel.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.textSpace -{number}
     * @description 沿线标注，相邻两个文字之间的间距，单位当前设置的字高
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.smallGeometryLabeled -{boolean}
     * @description 是否显示长度大于被标注对象本身长度的标签，默认为 false。在标签的长度大于线或者面对象本身的长度时，
     *              如果该值为 true，则标签文字会叠加在一起显示，为了清楚完整的显示该标签，
     *              可以采用换行模式来显示标签，但必须保证每行的长度小于对象本身的长度。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.rangeExpression -{string}
     * @description 制作分段标签专题的分段字段或字段表达式。该表达式对应的字段（或者字段表达式）的值应该为数值型。
     *              该字段与 items 分段子项联合使用，每个子项的起始值 [start，end)来源于 rangeExpression 字段值。
     *              最后 labelExpression 指定的标签字段（标签专题图要显示的具体内容）会根据分段子项的风格进行分段显示。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.maxLabelLength -{number}
     * @description 标签在每一行显示的最大长度，一个中文为两个字符。
     *              如果超过最大长度，可以采用两种方式来处理，一种是换行的模式进行显示，另一种是以省略号方式显示。默认最大长度为256个字符。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.labelOverLengthMode -{SuperMap.LabelOverLengthMode} 标签专题图中超长标签的处理模式枚举类。
     * 对于标签的长度超过设置的标签最大长度 maxLabelLength 时称为超长标签。默认为 SuperMap.LabelOverLengthMode.NONE。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.uniqueItems -{Array<SuperMap.ThemeLabelUniqueItem>}
     * @description 单值标签专题图子项数组。单值标签专题图使用 uniqueExpression单值标签专题图子项集合
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.flow -{SuperMap.ThemeFlow}
     * @description 标签专题图标签流动显示与牵引线设置类。通过该字段可以设置标签是否流动显示和牵引线风格。
     */


    /**
     * @member SuperMap.ThemeLabel.prototype.alongLine -{SuperMap.ThemeLabelAlongLine}
     * @description 标签沿线标注方向样式类。<br>
     *              在该类中可以设置标签是否沿线标注以及沿线标注的多种方式。沿线标注属性只适用于线数据集专题图。
     */


    _createClass(ThemeLabel, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeLabel.prototype.__proto__ || Object.getPrototypeOf(ThemeLabel.prototype), 'destroy', this).call(this);
            var me = this;
            me.alongLine = null;
            if (me.background) {
                me.background.destroy();
                me.background = null;
            }
            me.flow = null;
            if (me.items) {
                for (var i = 0, items = me.items, len = items.length; i < len; i++) {
                    items[i].destroy();
                }
                me.items = null;
            }
            if (me.uniqueItems) {
                for (var j = 0, uniqueItems = me.uniqueItems, uniqueLen = uniqueItems.length; j < uniqueLen; j++) {
                    uniqueItems[j].destory();
                }
                me.uniqueItems = null;
            }
            me.labelExpression = null;
            me.labelOverLengthMode = null;
            me.matrixCells = null;
            me.maxLabelLength = null;
            me.numericPrecision = null;
            me.overlapAvoided = null;
            me.rangeExpression = null;
            me.uniqueExpression = null;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            me.overlapAvoided = null;
            me.smallGeometryLabeled = null;
            if (me.text) {
                me.text.destroy();
                me.text = null;
            }
            me.textSpace = null;
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toJSON
         * @description 将themeLabel对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2["default"].Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeLabel.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            obj.memoryData = this.memoryData;
            if (this.alongLine) {
                obj.alongLine = this.alongLine.isAlongLine;
                obj.alongLineDirection = this.alongLine.alongLineDirection;
                obj.angleFixed = this.alongLine.angleFixed;
                obj.isLabelRepeated = this.alongLine.isLabelRepeated;
                obj.labelRepeatInterval = this.alongLine.labelRepeatInterval;
                obj.repeatedLabelAvoided = this.alongLine.repeatedLabelAvoided;
                obj.repeatIntervalFixed = this.alongLine.repeatIntervalFixed;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }

            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.text) {
                obj.maxTextHeight = this.text.maxTextHeight;
                obj.maxTextWidth = this.text.maxTextWidth;
                obj.minTextHeight = this.text.minTextHeight;
                obj.minTextWidth = this.text.minTextWidth;
                obj.uniformStyle = this.text.uniformStyle;
                obj.uniformMixedStyle = this.text.uniformMixedStyle;
            }
            if (this.background) {
                obj.labelBackShape = this.background.labelBackShape;
                obj.backStyle = this.background.backStyle;
            }
            obj.labelOverLengthMode = this.labelOverLengthMode;
            obj.maxLabelLength = this.maxLabelLength;
            obj.smallGeometryLabeled = this.smallGeometryLabeled;
            obj.rangeExpression = this.rangeExpression;
            obj.uniqueExpression = this.uniqueExpression;
            obj.numericPrecision = this.numericPrecision;
            obj.items = this.items;
            obj.uniqueItems = this.uniqueItems;
            obj.labelExpression = this.labelExpression;
            obj.overlapAvoided = this.overlapAvoided;
            obj.matrixCells = this.matrixCells;
            obj.textSpace = this.textSpace;
            return obj;
        }

        /**
         * @function SuperMap.ThemeLabel.fromObj
         * @description 从传入对象获取标签专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeLabel} ThemeLabel对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var lab = new ThemeLabel();
            var itemsL = obj.items,
                itemsU = obj.uniqueItems,
                cells = obj.matrixCells;
            obj.matrixCells = null;
            _SuperMap2["default"].Util.copy(lab, obj);
            lab.alongLine = _ThemeLabelAlongLine2["default"].fromObj(obj);
            lab.background = _ThemeLabelBackground2["default"].fromObj(obj);
            lab.flow = new _ThemeFlow2["default"]({ flowEnabled: obj.flowEnabled, leaderLineDisplayed: obj.leaderLineDisplayed, leaderLineStyle: obj.leaderLineStyle });
            if (itemsL) {
                lab.items = [];
                for (var i = 0, len = itemsL.length; i < len; i++) {
                    lab.items.push(_ThemeLabelItem2["default"].fromObj(itemsL[i]));
                }
            }
            if (itemsU) {
                lab.uniqueItems = [];
                for (var j = 0, uniqueLen = itemsU.length; j < uniqueLen; j++) {
                    lab.uniqueItems.push(ThemeUniqueItem.fromObj(itemsU[j]));
                }
            }
            if (cells) {
                lab.matrixCells = [];
                for (var i = 0, len = cells.length; i < len; i++) {
                    //TODO
                    //lab.matrixCells.push(SuperMap.LabelMatrixCell.fromObj(cells[i]));
                }
            }
            lab.offset = _ThemeOffset2["default"].fromObj(obj);
            lab.text = _ThemeLabelText2["default"].fromObj(obj);
            return lab;
        }
    }]);

    return ThemeLabel;
}(_Theme3["default"]);

exports["default"] = ThemeLabel;


_SuperMap2["default"].ThemeLabel = ThemeLabel;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeOffset
 * @classdesc 专题图中文本或符号相对于要素内点的偏移量设置类。
 *              通过该类可以设置专题图中标记文本或符号的偏移量以及偏移量是否随地图缩放而改变。
 * @param options - {Object} 可选参数。如：<br>
 *        offsetFixed - {boolean} 当前专题图是否固定标记文本或符号的偏移量。<br>
 *        offsetX - {string} 专题图中文本或符号相对于要素内点的水平偏移量。<br>
 *        offsetY - {string} 专题图中文本或符号相对于要素内点的垂直偏移量。
 */
var ThemeOffset = function () {

    /**
     * @member SuperMap.ThemeOffset.prototype.offsetX -{string}
     * @description 专题图中文本或符号相对于要素内点的水平偏移量。偏移量的单位为地图单位。
     *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么水平偏移量为2。
     */
    function ThemeOffset(options) {
        _classCallCheck(this, ThemeOffset);

        this.offsetFixed = false;
        this.offsetX = "0.0";
        this.offsetY = "0.0";
        this.CLASS_NAME = "SuperMap.ThemeOffset";

        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.ThemeOffset.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeOffset.prototype.offsetY -{string}
     * @description 专题图中文本或符号相对于要素内点的垂直偏移量。偏移量的单位为地图单位。
     *              该偏移量的值为一个常量值或者字段表达式所表示的值，即如果字段表达式为 SmID，其中 SmID = 2，那么垂直偏移量为2。
     */


    /**
     * @member SuperMap.ThemeOffset.prototype.offsetFixed -{boolean}
     * @description 当前专题图是否固定标记文本或符号的偏移量。所谓固定偏移量，则文本或符号的偏移量不随地图的缩放而变化。默认为 false，表示偏移量随地图的缩放而变化。
     */


    _createClass(ThemeOffset, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            me.offsetFixed = null;
            me.offsetX = null;
            me.offsetY = null;
        }

        /**
         * @function SuperMap.ThemeOffset.fromObj
         * @description 从传入对象获取专题图中文本或符号相对于要素内点的偏移量设置类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeOffset} ThemeOffset对象
         */

    }], [{
        key: "fromObj",
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeOffset();
            _SuperMap2["default"].Util.copy(res, obj);
            return res;
        }
    }]);

    return ThemeOffset;
}();

exports["default"] = ThemeOffset;


_SuperMap2["default"].ThemeOffset = ThemeOffset;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThiessenAnalystParameters
 * @classdesc 泰森多边形分析参数基类。
 * @param options - {Object} 可选参数。如:</br>
 *        clipRegion - {Object} 结果数据裁剪区域，可以为null，表示不对结果进行裁剪。</br>
 *                      面类型可以是：SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon。</br>
 *        createResultDataset - {boolean} 是否返回结果数据集，默认不返回。</br>
 *        resultDatasetName - {boolean} 指定结果数据集名称。</br>
 *        resultDatasourceName - {boolean} 指定结果数据集所在数据源，默认为当前数据源。</br>
 *        returnResultRegion - {boolean} 是否返回分析得到的多边形面数组，默认返回。</br>
 */
var ThiessenAnalystParameters = function () {

    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.resultDatasourceName -{string}
     * @description 指定结果数据集所在数据源。
     */


    /**
     *  @member SuperMap.ThiessenAnalystParameters.prototype.createResultDataset -{boolean}
     *  @description 是否返回结果数据集，默认值 false。如果为true，则必须设置属性resultDatasetName和resultDatasourceName。
     */
    function ThiessenAnalystParameters(options) {
        _classCallCheck(this, ThiessenAnalystParameters);

        this.clipRegion = null;
        this.createResultDataset = false;
        this.resultDatasetName = null;
        this.resultDatasourceName = null;
        this.returnResultRegion = true;
        this.CLASS_NAME = "SuperMap.ThiessenAnalystParameters";

        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     * @function SuperMap.ThiessenAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.returnResultRegion -{boolean}
     * @description 是否返回分析得到的多边形面数组，默认 true，返回。
     */


    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.resultDatasetName -{string}
     * @description 指定结果数据集名称。
     */

    /**
     * @member SuperMap.ThiessenAnalystParameters.prototype.clipRegion  -{Object}
     * @description 结果数据裁剪区域，可以为null，表示不对结果进行裁剪。</br>
     * 面类型可以是：SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon。
     */


    _createClass(ThiessenAnalystParameters, [{
        key: "destroy",
        value: function destroy() {
            var me = this;
            if (me.clipRegion) {
                me.clipRegion.destroy();
                me.clipRegion = null;
            }
            me.createResultDataset = null;
            me.resultDatasetName = null;
            me.resultDatasourceName = null;
            me.returnResultRegion = null;
        }
    }]);

    return ThiessenAnalystParameters;
}();

exports["default"] = ThiessenAnalystParameters;

_SuperMap2["default"].ThiessenAnalystParameters = ThiessenAnalystParameters;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Eventful2 = __webpack_require__(51);

var _Eventful3 = _interopRequireDefault(_Eventful2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @private
 * @class SuperMap.LevelRenderer.Animation
 * @classdesc 动画主类, 调度和管理所有动画控制器。
 * @extends SuperMap.LevelRenderer.Eventful
 */
var Animation = function (_Eventful) {
    _inherits(Animation, _Eventful);

    /*
     * Constructor: SuperMap.LevelRenderer.Animation
     * 构造函数。
     *
     * Parameters:
     * options - {Object} 动画参数选项，可设属性如下：
     *
     * Symbolizer properties:
     * onframe - {Object} onframe。
     * stage - {Object} stage。
     *
     * (code)
     *     var animation = new SuperMap.LevelRenderer.Animation();
     *     var obj = {
     *         x: 100,
     *         y: 100
     *     };
     *     animation.animate(node.position)
     *         .when(1000, {
     *             x: 500,
     *             y: 500
     *         })
     *         .when(2000, {
     *             x: 100,
     *             y: 100
     *         })
     *         .start('spline');
     * (end)
     */


    /**
     * Property: _running
     * {Boolean}
     *
     */


    /**
     * Property: onframe
     * {Object}
     *
     */
    function Animation(options) {
        _classCallCheck(this, Animation);

        var _this = _possibleConstructorReturn(this, (Animation.__proto__ || Object.getPrototypeOf(Animation)).call(this, options));

        _this.stage = null;
        _this.onframe = null;
        _this._clips = [];
        _this._running = false;
        _this._time = 0;
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Animation";


        options = options || {};

        _this.stage = options.stage || {};

        _this.onframe = options.onframe || function () {};

        // private properties
        _this._clips = [];

        _this._running = false;

        _this._time = 0;
        return _this;
    }

    /**
     * APIMethod: add
     * 添加动画片段
     *
     * Parameters:
     * clip - {<SuperMap.LevelRenderer.Animation.Clip>} 动画片段
     *
     */


    /**
     * Property: _time
     * {Number}
     *
     */


    /**
     * Property: _clips
     * {Array}
     *
     */


    /**
     * Property: stage
     * {Object}
     *
     */


    _createClass(Animation, [{
        key: 'add',
        value: function add(clip) {
            this._clips.push(clip);
        }

        /**
         * APIMethod: remove
         * 删除动画片段
         *
         * Parameters:
         * clip - {<SuperMap.LevelRenderer.Animation.Clip>} 动画片段
         *
         */

    }, {
        key: 'remove',
        value: function remove(clip) {
            var idx = _SuperMap2["default"].LevelRenderer.Util.indexOf(this._clips, clip);
            if (idx >= 0) {
                this._clips.splice(idx, 1);
            }
        }

        /**
         * Method: _update
         *
         */

    }, {
        key: '_update',
        value: function _update() {
            var time = new Date().getTime();
            var delta = time - this._time;
            var clips = this._clips;
            var len = clips.length;

            var deferredEvents = [];
            var deferredClips = [];
            for (var i = 0; i < len; i++) {
                var clip = clips[i];
                var e = clip.step(time);
                // Throw out the events need to be called after
                // stage.update, like destroy
                if (e) {
                    deferredEvents.push(e);
                    deferredClips.push(clip);
                }
            }
            if (this.stage.update) {
                this.stage.update();
            }

            // Remove the finished clip
            for (var i = 0; i < len;) {
                if (clips[i]._needsRemove) {
                    clips[i] = clips[len - 1];
                    clips.pop();
                    len--;
                } else {
                    i++;
                }
            }

            len = deferredEvents.length;
            for (var i = 0; i < len; i++) {
                deferredClips[i].fire(deferredEvents[i]);
            }

            this._time = time;

            this.onframe(delta);

            this.dispatch('frame', delta);
        }

        /**
         * APIMethod: start
         * 开始运行动画
         *
         */

    }, {
        key: 'start',
        value: function start() {
            var requestAnimationFrame = window.requestAnimationFrame || window.msRequestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || function (func) {
                setTimeout(func, 16);
            };

            var self = this;

            this._running = true;

            function step() {
                if (self._running) {
                    self._update();
                    requestAnimationFrame(step);
                }
            }

            this._time = new Date().getTime();
            requestAnimationFrame(step);
        }

        /**
         * APIMethod: stop
         * 停止运行动画
         *
         */

    }, {
        key: 'stop',
        value: function stop() {
            this._running = false;
        }

        /**
         * APIMethod: clear
         * 清除所有动画片段
         *
         */

    }, {
        key: 'clear',
        value: function clear() {
            this._clips = [];
        }

        /**
         * Method: animate
         * 对一个目标创建一个animator对象，可以指定目标中的属性使用动画
         *
         * Parameters:
         * target - {Object} target
         * options - {Object} 动画参数选项，可设属性如下：
         *
         * Symbolizer properties:
         * loop - {Boolean} 是否循环播放动画。默认值：false。
         * getter - {Function} 如果指定getter函数，会通过getter函数取属性值。默认值：null。
         * setter - {Function} 如如果指定setter函数，会通过setter函数设置属性值。默认值：null。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
         */

    }, {
        key: 'animate',
        value: function animate(target, options) {
            options = options || {};
            var deferred = new _SuperMap2["default"].LevelRenderer.Animation.Animator(target, options.loop, options.getter, options.setter);
            deferred.animation = this;
            return deferred;
        }
    }], [{
        key: '_interpolateNumber',
        value: function _interpolateNumber(p0, p1, percent) {
            return (p1 - p0) * percent + p0;
        }
    }, {
        key: '_interpolateArray',
        value: function _interpolateArray(p0, p1, percent, out, arrDim) {
            var len = p0.length;
            if (arrDim == 1) {
                for (var i = 0; i < len; i++) {
                    out[i] = _SuperMap2["default"].LevelRenderer.Animation._interpolateNumber(p0[i], p1[i], percent);
                }
            } else {
                var len2 = p0[0].length;
                for (var i = 0; i < len; i++) {
                    for (var j = 0; j < len2; j++) {
                        out[i][j] = _SuperMap2["default"].LevelRenderer.Animation._interpolateNumber(p0[i][j], p1[i][j], percent);
                    }
                }
            }
        }
    }, {
        key: '_isArrayLike',
        value: function _isArrayLike(data) {
            switch (typeof data === 'undefined' ? 'undefined' : _typeof(data)) {
                case 'undefined':
                case 'string':
                    return false;
            }

            return typeof data.length !== 'undefined';
        }
    }, {
        key: '_catmullRomInterpolateArray',
        value: function _catmullRomInterpolateArray(p0, p1, p2, p3, t, t2, t3, out, arrDim) {
            var len = p0.length;
            if (arrDim == 1) {
                for (var i = 0; i < len; i++) {
                    out[i] = _SuperMap2["default"].LevelRenderer.Animation._catmullRomInterpolate(p0[i], p1[i], p2[i], p3[i], t, t2, t3);
                }
            } else {
                var len2 = p0[0].length;
                for (var i = 0; i < len; i++) {
                    for (var j = 0; j < len2; j++) {
                        out[i][j] = _SuperMap2["default"].LevelRenderer.Animation._catmullRomInterpolate(p0[i][j], p1[i][j], p2[i][j], p3[i][j], t, t2, t3);
                    }
                }
            }
        }
    }, {
        key: '_catmullRomInterpolate',
        value: function _catmullRomInterpolate(p0, p1, p2, p3, t, t2, t3) {
            var v0 = (p2 - p0) * 0.5;
            var v1 = (p3 - p1) * 0.5;
            return (2 * (p1 - p2) + v0 + v1) * t3 + (-3 * (p1 - p2) - 2 * v0 - v1) * t2 + v0 * t + p1;
        }
    }, {
        key: '_cloneValue',
        value: function _cloneValue(value) {
            var arraySlice = Array.prototype.slice;

            if (_SuperMap2["default"].LevelRenderer.Animation._isArrayLike(value)) {
                var len = value.length;
                if (_SuperMap2["default"].LevelRenderer.Animation._isArrayLike(value[0])) {
                    var ret = [];
                    for (var i = 0; i < len; i++) {
                        ret.push(arraySlice.call(value[i]));
                    }
                    return ret;
                } else {
                    return arraySlice.call(value);
                }
            } else {
                return value;
            }
        }
    }, {
        key: 'rgba2String',
        value: function rgba2String(rgba) {
            rgba[0] = Math.floor(rgba[0]);
            rgba[1] = Math.floor(rgba[1]);
            rgba[2] = Math.floor(rgba[2]);

            return 'rgba(' + rgba.join(',') + ')';
        }
    }]);

    return Animation;
}(_Eventful3["default"]);

exports["default"] = Animation;


_SuperMap2["default"].LevelRenderer.Animation = Animation;

/**
 * @private
 * @class SuperMap.LevelRenderer.Animation.Animator
 */
_SuperMap2["default"].LevelRenderer.Animation.Animator = function () {

    /*
     * Constructor: SuperMap.LevelRenderer.Animation.Animator
     * 构造函数。
     *
     * Parameters:
     * target - {Object} target
     * loop - {Boolean} 是否循环播放动画。默认值：false。
     * getter - {Function} 如果指定getter函数，会通过getter函数取属性值。默认值：null。
     * setter - {Function} 如如果指定setter函数，会通过setter函数设置属性值。默认值：null。
     *
     */


    /**
     * Property: _onframeList
     * {Array}
     */


    /**
     * Property: _delay
     * {Number}
     */


    /**
     * Property: _setter
     * {Function}
     */


    /**
     * Property: _loop
     * {Boolean}
     */


    /**
     * Property: _tracks
     * {Object}
     */
    function Animator(target, loop, getter, setter) {
        _classCallCheck(this, Animator);

        this._tracks = null;
        this._target = null;
        this._loop = null;
        this._getter = null;
        this._setter = null;
        this._clipCount = 0;
        this._delay = 0;
        this._doneList = [];
        this._onframeList = [];
        this._clipList = [];
        this.CLASS_NAME = "SuperMap.LevelRenderer.Animation.Animator";

        this._tracks = {};
        this._target = target;

        this._loop = loop || false;

        this._getter = getter || _defaultGetter;
        this._setter = setter || _defaultSetter;

        this._clipCount = 0;

        this._delay = 0;

        this._doneList = [];

        this._onframeList = [];

        this._clipList = [];

        //Function
        function _defaultGetter(target, key) {
            return target[key];
        }

        function _defaultSetter(target, key, value) {
            target[key] = value;
        }
    }

    /**
     * Method: when
     * 设置动画关键帧
     *
     * Parameters:
     * time - {Number} 关键帧时间，单位是ms
     * props - {Object} 关键帧的属性值，key-value表示
     *
     * Returns:
     * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
     */


    /**
     * Property: _clipList
     * {Array}
     */


    /**
     * Property: _doneList
     * {Array}
     */


    /**
     * Property: _clipCount
     * {Number}
     */


    /**
     * Property: _getter
     * {Function}
     */


    /**
     * Property: _target
     * {Object}
     */


    _createClass(Animator, [{
        key: 'when',
        value: function when(time /* ms */, props) {
            for (var propName in props) {
                if (!this._tracks[propName]) {
                    this._tracks[propName] = [];
                    // If time is 0
                    //  Then props is given initialize value
                    // Else
                    //  Initialize value from current prop value
                    if (time !== 0) {
                        this._tracks[propName].push({
                            time: 0,
                            value: _SuperMap2["default"].LevelRenderer.Animation._cloneValue(this._getter(this._target, propName))
                        });
                    }
                }
                this._tracks[propName].push({
                    time: parseInt(time, 10),
                    value: props[propName]
                });
            }
            return this;
        }

        /**
         * Method: during
         * 添加动画每一帧的回调函数
         *
         * Parameters:
         * callback - {Function} callback
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
         */

    }, {
        key: 'during',
        value: function during(callback) {
            this._onframeList.push(callback);
            return this;
        }

        /**
         * Method: start
         * 开始执行动画
         *
         * Parameters:
         * easing - {String|Function} 动画缓动函数。详见：<SuperMap.LevelRenderer.Animation.easing>。
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
         */

    }, {
        key: 'start',
        value: function start(easing) {
            var self = this;
            var setter = this._setter;
            var getter = this._getter;
            var onFrameListLen = self._onframeList.length;
            var useSpline = easing === 'spline';

            var ondestroy = function ondestroy() {
                self._clipCount--;
                if (self._clipCount === 0) {
                    // Clear all tracks
                    self._tracks = {};

                    var len = self._doneList.length;
                    for (var i = 0; i < len; i++) {
                        self._doneList[i].call(self);
                    }
                }
            };

            var createTrackClip = function createTrackClip(keyframes, propName) {
                var trackLen = keyframes.length;
                if (!trackLen) {
                    return;
                }
                // Guess data type
                var firstVal = keyframes[0].value;
                var isValueArray = _SuperMap2["default"].LevelRenderer.Animation._isArrayLike(firstVal);
                var isValueColor = false;

                // For vertices morphing
                var arrDim = isValueArray && _SuperMap2["default"].LevelRenderer.Animation._isArrayLike(firstVal[0]) ? 2 : 1;
                // Sort keyframe as ascending
                keyframes.sort(function (a, b) {
                    return a.time - b.time;
                });
                var trackMaxTime;
                if (trackLen) {
                    trackMaxTime = keyframes[trackLen - 1].time;
                } else {
                    return;
                }
                // Percents of each keyframe
                var kfPercents = [];
                // Value of each keyframe
                var kfValues = [];
                for (var i = 0; i < trackLen; i++) {
                    kfPercents.push(keyframes[i].time / trackMaxTime);
                    // Assume value is a color when it is a string
                    var value = keyframes[i].value;
                    if (typeof value == 'string') {
                        value = _SuperMap2["default"].LevelRenderer.Util_color.toArray(value);
                        if (value.length === 0) {
                            // Invalid color
                            value[0] = value[1] = value[2] = 0;
                            value[3] = 1;
                        }
                        isValueColor = true;
                    }
                    kfValues.push(value);
                }

                // Cache the key of last frame to speed up when
                // animation playback is sequency
                var cacheKey = 0;
                var cachePercent = 0;
                var start;
                var i;
                var w;
                var p0;
                var p1;
                var p2;
                var p3;

                if (isValueColor) {
                    var rgba = [0, 0, 0, 0];
                }

                var onframe = function onframe(target, percent) {
                    // Find the range keyframes
                    // kf1-----kf2---------current--------kf3
                    // find kf2 and kf3 and do interpolation
                    if (percent < cachePercent) {
                        // Start from next key
                        start = Math.min(cacheKey + 1, trackLen - 1);
                        for (i = start; i >= 0; i--) {
                            if (kfPercents[i] <= percent) {
                                break;
                            }
                        }
                        i = Math.min(i, trackLen - 2);
                    } else {
                        for (i = cacheKey; i < trackLen; i++) {
                            if (kfPercents[i] > percent) {
                                break;
                            }
                        }
                        i = Math.min(i - 1, trackLen - 2);
                    }
                    cacheKey = i;
                    cachePercent = percent;

                    var range = kfPercents[i + 1] - kfPercents[i];
                    if (range === 0) {
                        return;
                    } else {
                        w = (percent - kfPercents[i]) / range;
                    }
                    if (useSpline) {
                        p1 = kfValues[i];
                        p0 = kfValues[i === 0 ? i : i - 1];
                        p2 = kfValues[i > trackLen - 2 ? trackLen - 1 : i + 1];
                        p3 = kfValues[i > trackLen - 3 ? trackLen - 1 : i + 2];
                        if (isValueArray) {
                            _SuperMap2["default"].LevelRenderer.Animation._catmullRomInterpolateArray(p0, p1, p2, p3, w, w * w, w * w * w, getter(target, propName), arrDim);
                        } else {
                            var value;
                            if (isValueColor) {
                                value = _SuperMap2["default"].LevelRenderer.Animation._catmullRomInterpolateArray(p0, p1, p2, p3, w, w * w, w * w * w, rgba, 1);
                                value = _SuperMap2["default"].LevelRenderer.Animation.rgba2String(rgba);
                            } else {
                                value = _SuperMap2["default"].LevelRenderer.Animation._catmullRomInterpolate(p0, p1, p2, p3, w, w * w, w * w * w);
                            }
                            setter(target, propName, value);
                        }
                    } else {
                        if (isValueArray) {
                            _SuperMap2["default"].LevelRenderer.Animation._interpolateArray(kfValues[i], kfValues[i + 1], w, getter(target, propName), arrDim);
                        } else {
                            var value;
                            if (isValueColor) {
                                _SuperMap2["default"].LevelRenderer.Animation._interpolateArray(kfValues[i], kfValues[i + 1], w, rgba, 1);
                                value = _SuperMap2["default"].LevelRenderer.Animation.rgba2String(rgba);
                            } else {
                                value = _SuperMap2["default"].LevelRenderer.Animation._interpolateNumber(kfValues[i], kfValues[i + 1], w);
                            }
                            setter(target, propName, value);
                        }
                    }

                    for (i = 0; i < onFrameListLen; i++) {
                        self._onframeList[i](target, percent);
                    }
                };

                var clip = new _SuperMap2["default"].LevelRenderer.Animation.Clip({
                    target: self._target,
                    life: trackMaxTime,
                    loop: self._loop,
                    delay: self._delay,
                    onframe: onframe,
                    ondestroy: ondestroy
                });

                if (easing && easing !== 'spline') {
                    clip.easing = easing;
                }
                self._clipList.push(clip);
                self._clipCount++;
                self.animation.add(clip);
            };

            for (var propName in this._tracks) {
                createTrackClip(this._tracks[propName], propName);
            }
            return this;
        }

        /**
         * Method: stop
         * 停止动画
         */

    }, {
        key: 'stop',
        value: function stop() {
            for (var i = 0; i < this._clipList.length; i++) {
                var clip = this._clipList[i];
                this.animation.remove(clip);
            }
            this._clipList = [];
        }

        /**
         * Method: delay
         * 设置动画延迟开始的时间
         *
         * Parameters:
         * time - {Number} time 单位ms
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
         */

    }, {
        key: 'delay',
        value: function delay(time) {
            this._delay = time;
            return this;
        }

        /**
         * Method: done
         * 添加动画结束的回调
         *
         * Parameters:
         * cb - {Function} Function
         *
         * Returns:
         * {<SuperMap.LevelRenderer.Animation.Animator>} Animator
         */

    }, {
        key: 'done',
        value: function done(cb) {
            if (cb) {
                this._doneList.push(cb);
            }
            return this;
        }
    }]);

    return Animator;
}();

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Vector = __webpack_require__(73);

var _Vector2 = _interopRequireDefault(_Vector);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Tool.Curve
 * LevelRenderer 工具-曲线
 *
 */
var Curve = function () {

    /**
     * Constructor: SuperMap.LevelRenderer.Tool.Curve
     * 构造函数。
     *
     */


    /**
     * Property: THREE_SQRT
     * {Number} 3 的平方根
     */


    /**
     * Property: vector
     * {<SuperMap.LevelRenderer.Tool.Vector>} 矢量工具
     */
    function Curve() {
        _classCallCheck(this, Curve);

        this.vector = null;
        this.EPSILON = null;
        this.THREE_SQRT = null;
        this.ONE_THIRD = null;
        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Curve";

        this.vector = new _Vector2["default"]();
        this.EPSILON = 1e-4;
        this.THREE_SQRT = Math.sqrt(3);
        this.ONE_THIRD = 1 / 3;
    }

    /**
     * Method: evalCubicCoeff
     *
     * Parameters:
     * a - {Number} 值。
     * b - {Number} 值。
     * c - {Number} 值。
     * d - {Number} 值。
     * t - {Number} 值。
     *
     * Returns:
     * {Number}
     */

    /*
     evalCubicCoeff: function(a, b, c, d, t){
     return ((a * t + b) * t + c) * t + d;
     },
     */

    /**
     * Method: isAroundZero
     * 判断一个值是否趋于0，判断参考值：1e-4。
     *
     * Parameters:
     * val - {Number} 值。
     *
     * Returns:
     * {Boolean} 值是否趋于0。
     */


    /**
     * Property: ONE_THIRD
     * {Number} 1/3
     */


    /**
     * Property: EPSILON
     * {Number} e
     */


    _createClass(Curve, [{
        key: 'isAroundZero',
        value: function isAroundZero(val) {
            return val > -this.EPSILON && val < this.EPSILON;
        }

        /**
         * Method: isNotAroundZero
         * 判断一个值是否不趋于0，判断参考值：1e-4。
         *
         * Parameters:
         * val - {Number} 值。
         *
         * Returns:
         * {Boolean} 值是否不趋于0。
         */

    }, {
        key: 'isNotAroundZero',
        value: function isNotAroundZero(val) {
            return val > this.EPSILON || val < -this.EPSILON;
        }

        /**
         * APIMethod: cubicAt
         * 计算三次贝塞尔值
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * p3 - {Number}
         * t - {Number}
         *
         * Returns:
         * {number} 三次贝塞尔值
         */

    }, {
        key: 'cubicAt',
        value: function cubicAt(p0, p1, p2, p3, t) {
            var onet = 1 - t;
            return onet * onet * (onet * p0 + 3 * t * p1) + t * t * (t * p3 + 3 * onet * p2);
        }

        /**
         * APIMethod: cubicDerivativeAt
         * 计算三次贝塞尔导数值
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * p3 - {Number}
         * t - {Number}
         *
         * Returns:
         * {number} 三次贝塞尔导数值
         */

    }, {
        key: 'cubicDerivativeAt',
        value: function cubicDerivativeAt(p0, p1, p2, p3, t) {
            var onet = 1 - t;
            return 3 * (((p1 - p0) * onet + 2 * (p2 - p1) * t) * onet + (p3 - p2) * t * t);
        }

        /**
         * APIMethod: cubicRootAt
         * 计算三次贝塞尔方程根，使用盛金公式
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * p3 - {Number}
         * val - {Number}
         * roots - {Number} 有效根数目
         *
         * Returns:
         * {number} 有效根
         */

    }, {
        key: 'cubicRootAt',
        value: function cubicRootAt(p0, p1, p2, p3, val, roots) {
            // Evaluate roots of cubic functions
            var a = p3 + 3 * (p1 - p2) - p0;
            var b = 3 * (p2 - p1 * 2 + p0);
            var c = 3 * (p1 - p0);
            var d = p0 - val;

            var A = b * b - 3 * a * c;
            var B = b * c - 9 * a * d;
            var C = c * c - 3 * b * d;

            var n = 0;

            if (this.isAroundZero(A) && this.isAroundZero(B)) {
                if (this.isAroundZero(b)) {
                    roots[0] = 0;
                } else {
                    var t1 = -c / b; //t1, t2, t3, b is not zero
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                }
            } else {
                var disc = B * B - 4 * A * C;

                if (this.isAroundZero(disc)) {
                    var K = B / A;
                    var t1 = -b / a + K; // t1, a is not zero
                    var t2 = -K / 2; // t2, t3
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        roots[n++] = t2;
                    }
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var Y1 = A * b + 1.5 * a * (-B + discSqrt);
                    var Y2 = A * b + 1.5 * a * (-B - discSqrt);
                    if (Y1 < 0) {
                        Y1 = -Math.pow(-Y1, this.ONE_THIRD);
                    } else {
                        Y1 = Math.pow(Y1, this.ONE_THIRD);
                    }
                    if (Y2 < 0) {
                        Y2 = -Math.pow(-Y2, this.ONE_THIRD);
                    } else {
                        Y2 = Math.pow(Y2, this.ONE_THIRD);
                    }
                    var t1 = (-b - (Y1 + Y2)) / (3 * a);
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                } else {
                    var T = (2 * A * b - 3 * a * B) / (2 * Math.sqrt(A * A * A));
                    var theta = Math.acos(T) / 3;
                    var ASqrt = Math.sqrt(A);
                    var tmp = Math.cos(theta);

                    var t1 = (-b - 2 * ASqrt * tmp) / (3 * a);
                    var t2 = (-b + ASqrt * (tmp + this.THREE_SQRT * Math.sin(theta))) / (3 * a);
                    var t3 = (-b + ASqrt * (tmp - this.THREE_SQRT * Math.sin(theta))) / (3 * a);
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        roots[n++] = t2;
                    }
                    if (t3 >= 0 && t3 <= 1) {
                        roots[n++] = t3;
                    }
                }
            }
            return n;
        }

        /**
         * APIMethod: cubicExtrema
         * 计算三次贝塞尔方程极限值的位置
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * p3 - {Number}
         * extrema - {Number}
         *
         * Returns:
         * {number} 有效数目
         */

    }, {
        key: 'cubicExtrema',
        value: function cubicExtrema(p0, p1, p2, p3, extrema) {
            var b = 6 * p2 - 12 * p1 + 6 * p0;
            var a = 9 * p1 + 3 * p3 - 3 * p0 - 9 * p2;
            var c = 3 * p1 - 3 * p0;

            var n = 0;
            if (this.isAroundZero(a)) {
                if (this.isNotAroundZero(b)) {
                    var t1 = -c / b;
                    if (t1 >= 0 && t1 <= 1) {
                        extrema[n++] = t1;
                    }
                }
            } else {
                var disc = b * b - 4 * a * c;
                if (this.isAroundZero(disc)) {
                    extrema[0] = -b / (2 * a);
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var t1 = (-b + discSqrt) / (2 * a);
                    var t2 = (-b - discSqrt) / (2 * a);
                    if (t1 >= 0 && t1 <= 1) {
                        extrema[n++] = t1;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        extrema[n++] = t2;
                    }
                }
            }
            return n;
        }

        /**
         * APIMethod cubicSubdivide
         * 细分三次贝塞尔曲线
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * p3 - {Number}
         * t - {Number}
         * out - {Array{Number}}
         *
         * Returns:
         * {number} out
         */

    }, {
        key: 'cubicSubdivide',
        value: function cubicSubdivide(p0, p1, p2, p3, t, out) {
            var p01 = (p1 - p0) * t + p0;
            var p12 = (p2 - p1) * t + p1;
            var p23 = (p3 - p2) * t + p2;

            var p012 = (p12 - p01) * t + p01;
            var p123 = (p23 - p12) * t + p12;

            var p0123 = (p123 - p012) * t + p012;
            // Seg0
            out[0] = p0;
            out[1] = p01;
            out[2] = p012;
            out[3] = p0123;
            // Seg1
            out[4] = p0123;
            out[5] = p123;
            out[6] = p23;
            out[7] = p3;
        }

        /**
         * APIMethod: cubicProjectPoint
         * 投射点到三次贝塞尔曲线上，返回投射距离。投射点有可能会有一个或者多个，这里只返回其中距离最短的一个。
         *
         * Parameters:
         * x0 - {Number}
         * y0 - {Number}
         * x1 - {Number}
         * y1 - {Number}
         * x2 - {Number}
         * y2 - {Number}
         * x3 - {Number}
         * y3 - {Number}
         * x - {Number}
         * y - {Number}
         * out - {Array{Number}}  投射点
         *
         * Returns:
         * {number} out
         */

    }, {
        key: 'cubicProjectPoint',
        value: function cubicProjectPoint(x0, y0, x1, y1, x2, y2, x3, y3, x, y, out) {
            // 临时变量
            var _v0 = this.vector.create();
            var _v1 = this.vector.create();
            var _v2 = this.vector.create();
            // var _v3 = vector.create();

            // http://pomax.github.io/bezierinfo/#projections
            var t;
            var interval = 0.005;
            var d = Infinity;

            _v0[0] = x;
            _v0[1] = y;

            // 先粗略估计一下可能的最小距离的 t 值
            // PENDING
            for (var _t = 0; _t < 1; _t += 0.05) {
                _v1[0] = this.cubicAt(x0, x1, x2, x3, _t);
                _v1[1] = this.cubicAt(y0, y1, y2, y3, _t);
                var d1 = this.vector.distSquare(_v0, _v1);
                if (d1 < d) {
                    t = _t;
                    d = d1;
                }
            }
            d = Infinity;

            // At most 32 iteration
            for (var i = 0; i < 32; i++) {
                if (interval < this.EPSILON) {
                    break;
                }
                var prev = t - interval;
                var next = t + interval;
                // t - interval
                _v1[0] = this.cubicAt(x0, x1, x2, x3, prev);
                _v1[1] = this.cubicAt(y0, y1, y2, y3, prev);

                var d1 = this.vector.distSquare(_v1, _v0);

                if (prev >= 0 && d1 < d) {
                    t = prev;
                    d = d1;
                } else {
                    // t + interval
                    _v2[0] = this.cubicAt(x0, x1, x2, x3, next);
                    _v2[1] = this.cubicAt(y0, y1, y2, y3, next);
                    var d2 = this.vector.distSquare(_v2, _v0);

                    if (next <= 1 && d2 < d) {
                        t = next;
                        d = d2;
                    } else {
                        interval *= 0.5;
                    }
                }
            }
            // t
            if (out) {
                out[0] = this.cubicAt(x0, x1, x2, x3, t);
                out[1] = this.cubicAt(y0, y1, y2, y3, t);
            }
            // console.log(interval, i);
            return Math.sqrt(d);
        }

        /**
         * APIMethod: quadraticAt
         * 计算二次方贝塞尔值
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * t - {Number}
         *
         * Returns:
         * {number} 二次方贝塞尔值
         */

    }, {
        key: 'quadraticAt',
        value: function quadraticAt(p0, p1, p2, t) {
            var onet = 1 - t;
            return onet * (onet * p0 + 2 * t * p1) + t * t * p2;
        }

        /**
         * APIMethod: quadraticDerivativeAt
         * 计算二次方贝塞尔导数值
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * t - {Number}
         *
         * Returns:
         * {number} 二次方贝塞尔导数值
         */

    }, {
        key: 'quadraticDerivativeAt',
        value: function quadraticDerivativeAt(p0, p1, p2, t) {
            return 2 * ((1 - t) * (p1 - p0) + t * (p2 - p1));
        }

        /**
         * APIMethod: quadraticRootAt
         * 计算二次方贝塞尔方程根
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         * val - {Number}
         * roots - {Array{Number}}
         *
         * Returns:
         * {number} 有效根数目
         */

    }, {
        key: 'quadraticRootAt',
        value: function quadraticRootAt(p0, p1, p2, val, roots) {
            var a = p0 - 2 * p1 + p2;
            var b = 2 * (p1 - p0);
            var c = p0 - val;

            var n = 0;
            if (this.isAroundZero(a)) {
                if (this.isNotAroundZero(b)) {
                    var t1 = -c / b;
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                }
            } else {
                var disc = b * b - 4 * a * c;
                if (this.isAroundZero(disc)) {
                    var t1 = -b / (2 * a);
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                } else if (disc > 0) {
                    var discSqrt = Math.sqrt(disc);
                    var t1 = (-b + discSqrt) / (2 * a);
                    var t2 = (-b - discSqrt) / (2 * a);
                    if (t1 >= 0 && t1 <= 1) {
                        roots[n++] = t1;
                    }
                    if (t2 >= 0 && t2 <= 1) {
                        roots[n++] = t2;
                    }
                }
            }
            return n;
        }

        /**
         * APIMethod: quadraticExtremum
         * 计算二次贝塞尔方程极限值
         *
         * Parameters:
         * p0 - {Number}
         * p1 - {Number}
         * p2 - {Number}
         *
         * Returns:
         * {number}  二次贝塞尔方程极限值
         */

    }, {
        key: 'quadraticExtremum',
        value: function quadraticExtremum(p0, p1, p2) {
            var divider = p0 + p2 - 2 * p1;
            if (divider === 0) {
                // p1 is center of p0 and p2
                return 0.5;
            } else {
                return (p0 - p1) / divider;
            }
        }

        /**
         * APIMethod: quadraticProjectPoint
         * 投射点到二次贝塞尔曲线上，返回投射距离。投射点有可能会有一个或者多个，这里只返回其中距离最短的一个。
         *
         * Parameters:
         * x0 - {Number}
         * y0 - {Number}
         * x1 - {Number}
         * y1 - {Number}
         * x2 - {Number}
         * y2 - {Number}
         * x - {Number}
         * y - {Number}
         * out - {Array{Number}}  投射点
         *
         * Returns:
         * {number} 投射距离
         */

    }, {
        key: 'quadraticProjectPoint',
        value: function quadraticProjectPoint(x0, y0, x1, y1, x2, y2, x, y, out) {
            // 临时变量
            var _v0 = this.vector.create();
            var _v1 = this.vector.create();
            var _v2 = this.vector.create();

            // http://pomax.github.io/bezierinfo/#projections
            var t;
            var interval = 0.005;
            var d = Infinity;

            _v0[0] = x;
            _v0[1] = y;

            // 先粗略估计一下可能的最小距离的 t 值
            // PENDING
            for (var _t = 0; _t < 1; _t += 0.05) {
                _v1[0] = this.quadraticAt(x0, x1, x2, _t);
                _v1[1] = this.quadraticAt(y0, y1, y2, _t);
                var d1 = this.vector.distSquare(_v0, _v1);
                if (d1 < d) {
                    t = _t;
                    d = d1;
                }
            }
            d = Infinity;

            // At most 32 iteration
            for (var i = 0; i < 32; i++) {
                if (interval < this.EPSILON) {
                    break;
                }
                var prev = t - interval;
                var next = t + interval;
                // t - interval
                _v1[0] = this.quadraticAt(x0, x1, x2, prev);
                _v1[1] = this.quadraticAt(y0, y1, y2, prev);

                var d1 = this.vector.distSquare(_v1, _v0);

                if (prev >= 0 && d1 < d) {
                    t = prev;
                    d = d1;
                } else {
                    // t + interval
                    _v2[0] = this.quadraticAt(x0, x1, x2, next);
                    _v2[1] = this.quadraticAt(y0, y1, y2, next);
                    var d2 = this.vector.distSquare(_v2, _v0);
                    if (next <= 1 && d2 < d) {
                        t = next;
                        d = d2;
                    } else {
                        interval *= 0.5;
                    }
                }
            }
            // t
            if (out) {
                out[0] = this.quadraticAt(x0, x1, x2, t);
                out[1] = this.quadraticAt(y0, y1, y2, t);
            }
            // console.log(interval, i);
            return Math.sqrt(d);
        }
    }]);

    return Curve;
}();

exports["default"] = Curve;

_SuperMap2["default"].LevelRenderer.Tool.Curve = Curve;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

__webpack_require__(30);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Transformable
 * 可变换超类，所有支持 Canvas Transform 变换操作的类均是此类的子类。
 *
 * 此类不可实例化。
 *
 */
var Transformable = function () {

    /**
     * Constructor: SuperMap.LevelRenderer.Transformable
     * 构造函数。
     */


    /**
     * Property: needLocalTransform
     * {Boolean} 是否变换。默认值：false。
     */


    /**
     * APIProperty: rotation
     * {Array{Number}} 旋转，可以通过数组二三项指定旋转的原点， 默认值：[0, 0, 0]。
     */
    function Transformable() {
        _classCallCheck(this, Transformable);

        this.position = [0, 0];
        this.rotation = [0, 0, 0];
        this.scale = [1, 1, 0, 0];
        this.needLocalTransform = false;
        this.needTransform = false;

        this.lookAt = function () {
            var v = _SuperMap2["default"].LevelRenderer.Util_vector.create();
            // {Array{Number}|Float32Array} target
            return function (target) {
                if (!this.transform) {
                    this.transform = _SuperMap2["default"].LevelRenderer.Util_matrix.create();
                }
                var m = this.transform;
                _SuperMap2["default"].LevelRenderer.Util_vector.sub(v, target, this.position);
                if (isAroundZero(v[0]) && isAroundZero(v[1])) {
                    return;
                }
                _SuperMap2["default"].LevelRenderer.Util_vector.normalize(v, v);
                // Y Axis
                // TODO Scale origin ?
                m[2] = v[0] * this.scale[1];
                m[3] = v[1] * this.scale[1];
                // X Axis
                m[0] = v[1] * this.scale[0];
                m[1] = -v[0] * this.scale[0];
                // Position
                m[4] = this.position[0];
                m[5] = this.position[1];

                this.decomposeTransform();

                function isAroundZero(val) {
                    var EPSILON = 5e-5;
                    return val > -EPSILON && val < EPSILON;
                }
            };
        }();

        this.CLASS_NAME = "SuperMap.LevelRenderer.Transformable";

        this.position = [0, 0];

        this.rotation = [0, 0, 0];

        this.scale = [1, 1, 0, 0];

        this.needLocalTransform = false;

        this.needTransform = false;
    }

    /**
     * APIMethod: destroy
     * 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    /**
     * APIProperty: needTransform
     * {Boolean} 是否有坐标变换。默认值：false。
     */


    /**
     * APIProperty: scale
     * {Array{Number}} 缩放，可以通过数组三四项指定缩放的原点， 默认值：[1, 1, 0, 0]。
     */


    /**
     * APIProperty: position
     * {Array{Number}} 平移， 默认值：[0, 0]。
     */


    _createClass(Transformable, [{
        key: 'destroy',
        value: function destroy() {
            this.position = null;
            this.rotation = null;
            this.scale = null;
            this.needLocalTransform = null;
            this.needTransform = null;
        }

        /**
         * Method: updateNeedTransform
         * 更新  needLocalTransform
         *
         */

    }, {
        key: 'updateNeedTransform',
        value: function updateNeedTransform() {
            this.needLocalTransform = isNotAroundZero(this.rotation[0]) || isNotAroundZero(this.position[0]) || isNotAroundZero(this.position[1]) || isNotAroundZero(this.scale[0] - 1) || isNotAroundZero(this.scale[1] - 1);

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }

        /**
         * APIMethod: updateTransform
         * 判断是否需要有坐标变换，更新 needTransform 属性。
         * 如果有坐标变换 则从 position rotation scale 以及父节点的 transform 计算出自身的 transform 矩阵
         *
         */

    }, {
        key: 'updateTransform',
        value: function updateTransform() {
            this.updateNeedTransform();

            if (this.parent) {
                this.needTransform = this.needLocalTransform || this.parent.needTransform;
            } else {
                this.needTransform = this.needLocalTransform;
            }

            if (!this.needTransform) {
                return;
            }

            var origin = [0, 0];

            var m = this.transform || _SuperMap2["default"].LevelRenderer.Util_matrix.create();
            _SuperMap2["default"].LevelRenderer.Util_matrix.identity(m);

            if (this.needLocalTransform) {
                if (isNotAroundZero(this.scale[0]) || isNotAroundZero(this.scale[1])) {
                    origin[0] = -this.scale[2] || 0;
                    origin[1] = -this.scale[3] || 0;
                    var haveOrigin = isNotAroundZero(origin[0]) || isNotAroundZero(origin[1]);
                    if (haveOrigin) {
                        _SuperMap2["default"].LevelRenderer.Util_matrix.translate(m, m, origin);
                    }
                    _SuperMap2["default"].LevelRenderer.Util_matrix.scale(m, m, this.scale);
                    if (haveOrigin) {
                        origin[0] = -origin[0];
                        origin[1] = -origin[1];
                        _SuperMap2["default"].LevelRenderer.Util_matrix.translate(m, m, origin);
                    }
                }

                if (this.rotation instanceof Array) {
                    if (this.rotation[0] !== 0) {
                        origin[0] = -this.rotation[1] || 0;
                        origin[1] = -this.rotation[2] || 0;
                        var haveOrigin = isNotAroundZero(origin[0]) || isNotAroundZero(origin[1]);
                        if (haveOrigin) {
                            _SuperMap2["default"].LevelRenderer.Util_matrix.translate(m, m, origin);
                        }
                        _SuperMap2["default"].LevelRenderer.Util_matrix.rotate(m, m, this.rotation[0]);
                        if (haveOrigin) {
                            origin[0] = -origin[0];
                            origin[1] = -origin[1];
                            _SuperMap2["default"].LevelRenderer.Util_matrix.translate(m, m, origin);
                        }
                    }
                } else {
                    if (this.rotation !== 0) {
                        _SuperMap2["default"].LevelRenderer.Util_matrix.rotate(m, m, this.rotation);
                    }
                }

                if (isNotAroundZero(this.position[0]) || isNotAroundZero(this.position[1])) {
                    _SuperMap2["default"].LevelRenderer.Util_matrix.translate(m, m, this.position);
                }
            }

            // 保存这个变换矩阵
            this.transform = m;

            // 应用父节点变换
            if (this.parent && this.parent.needTransform) {
                if (this.needLocalTransform) {
                    _SuperMap2["default"].LevelRenderer.Util_matrix.mul(this.transform, this.parent.transform, this.transform);
                } else {
                    _SuperMap2["default"].LevelRenderer.Util_matrix.copy(this.transform, this.parent.transform);
                }
            }

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }

        /**
         * APIMethod: setTransform
         * 将自己的 transform 应用到 context 上。
         *
         * Parameters:
         * ctx - {Context2D} Context2D 上下文。
         */

    }, {
        key: 'setTransform',
        value: function setTransform(ctx) {
            if (this.needTransform) {
                var m = this.transform;
                ctx.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
            }
        }

        /**
         * APIMethod: lookAt
         * 设置图形的朝向。
         *
         */

    }, {
        key: 'decomposeTransform',


        /**
         * APIMethod: decomposeTransform
         * 分解`transform`矩阵到`position`, `rotation`, `scale` 。
         *
         */
        value: function decomposeTransform() {
            if (!this.transform) {
                return;
            }
            var m = this.transform;
            var sx = m[0] * m[0] + m[1] * m[1];
            var position = this.position;
            var scale = this.scale;
            var rotation = this.rotation;
            if (isNotAroundZero(sx - 1)) {
                sx = Math.sqrt(sx);
            }
            var sy = m[2] * m[2] + m[3] * m[3];
            if (isNotAroundZero(sy - 1)) {
                sy = Math.sqrt(sy);
            }
            position[0] = m[4];
            position[1] = m[5];
            scale[0] = sx;
            scale[1] = sy;
            scale[2] = scale[3] = 0;
            rotation[0] = Math.atan2(-m[1] / sy, m[0] / sx);
            rotation[1] = rotation[2] = 0;

            function isNotAroundZero(val) {
                var EPSILON = 5e-5;
                return val > EPSILON || val < -EPSILON;
            }
        }
    }]);

    return Transformable;
}();

exports["default"] = Transformable;

_SuperMap2["default"].LevelRenderer.Transformable = Transformable;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Tool.Vector
 * LevelRenderer 二维向量类
 *
 */
var Vector = function () {

    /**
     * Constructor: SuperMap.LevelRenderer.Tool.Vector
     * 构造函数。
     *
     */
    function Vector() {
        _classCallCheck(this, Vector);

        this.ArrayCtor = null;
        this.CLASS_NAME = "SuperMap.LevelRenderer.Tool.Vector";

        this.ArrayCtor = typeof Float32Array === 'undefined' ? Array : Float32Array;
    }

    /**
     * APIMethod: create
     * 创建一个向量。
     *
     * Parameters:
     * x - {Number} x 坐标。
     * y - {Number} y 坐标。
     *
     * Returns:
     * {Vector2} 向量。
     */


    /**
     * Property: ArrayCtor
     * {Object} 数组类型控制
     */


    _createClass(Vector, [{
        key: 'create',
        value: function create(x, y) {
            var ArrayCtor = this.ArrayCtor;

            var out = new ArrayCtor(2);
            out[0] = x || 0;
            out[1] = y || 0;

            return out;
        }

        /**
         * APIMethod: copy
         * 复制一个向量。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v - {Vector2} 向量。
         *
         * Returns:
         * {Vector2} 克隆向量。
         */

    }, {
        key: 'copy',
        value: function copy(out, v) {
            out[0] = v[0];
            out[1] = v[1];
            return out;
        }

        /**
         * APIMethod: set
         * 设置向量的两个项。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * a - {Number} 项 a。
         * b - {Number} 项 b。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'set',
        value: function set(out, a, b) {
            out[0] = a;
            out[1] = b;
            return out;
        }

        /**
         * APIMethod: add
         * 向量相加。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'add',
        value: function add(out, v1, v2) {
            out[0] = v1[0] + v2[0];
            out[1] = v1[1] + v2[1];
            return out;
        }

        /**
         * APIMethod: scaleAndAdd
         * 向量缩放后相加。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2（缩放向量）。
         * a - {Number} 缩放参数。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'scaleAndAdd',
        value: function scaleAndAdd(out, v1, v2, a) {
            out[0] = v1[0] + v2[0] * a;
            out[1] = v1[1] + v2[1] * a;
            return out;
        }

        /**
         * APIMethod: sub
         * 向量相减。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'sub',
        value: function sub(out, v1, v2) {
            out[0] = v1[0] - v2[0];
            out[1] = v1[1] - v2[1];
            return out;
        }

        /**
         * APIMethod: len
         * 向量长度。
         *
         * Parameters:
         * v - {Vector2} 向量。
         *
         * Returns:
         * {Number} 向量长度。
         */

    }, {
        key: 'len',
        value: function len(v) {
            return Math.sqrt(this.lenSquare(v));
        }

        /**
         * APIMethod: lenSquare
         * 向量长度平方。
         *
         * Parameters:
         * v - {Vector2} 向量。
         *
         * Returns:
         * {Number} 向量长度平方。
         */

    }, {
        key: 'lenSquare',
        value: function lenSquare(v) {
            return v[0] * v[0] + v[1] * v[1];
        }

        /**
         * APIMethod: mul
         * 向量乘法。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'mul',
        value: function mul(out, v1, v2) {
            out[0] = v1[0] * v2[0];
            out[1] = v1[1] * v2[1];
            return out;
        }

        /**
         * APIMethod: div
         * 向量除法。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'div',
        value: function div(out, v1, v2) {
            out[0] = v1[0] / v2[0];
            out[1] = v1[1] / v2[1];
            return out;
        }

        /**
         * APIMethod: dot
         * 向量点乘。
         *
         * Parameters:
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Number} 向量点乘。
         */

    }, {
        key: 'dot',
        value: function dot(v1, v2) {
            return v1[0] * v2[0] + v1[1] * v2[1];
        }

        /**
         * APIMethod: scale
         * 向量缩放。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v - {Vector2} 向量 v。
         * s - {Number} 缩放参数。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'scale',
        value: function scale(out, v, s) {
            out[0] = v[0] * s;
            out[1] = v[1] * s;
            return out;
        }

        /**
         * APIMethod: normalize
         * 向量归一化。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v - {Vector2} 向量 v。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'normalize',
        value: function normalize(out, v) {
            var d = this.len(v);
            if (d === 0) {
                out[0] = 0;
                out[1] = 0;
            } else {
                out[0] = v[0] / d;
                out[1] = v[1] / d;
            }
            return out;
        }

        /**
         * APIMethod: distance
         * 计算向量间距离。
         *
         * Parameters:
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Number} 向量间距离。
         */

    }, {
        key: 'distance',
        value: function distance(v1, v2) {
            return Math.sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]));
        }

        /**
         * APIMethod: distanceSquare
         * 向量距离平方。
         *
         * Parameters:
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Number} 向量距离平方。
         */

    }, {
        key: 'distanceSquare',
        value: function distanceSquare(v1, v2) {
            return (v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]);
        }

        /**
         * APIMethod: negate
         * 求负向量。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v - {Vector2} 向量 v。
         *
         * Returns:
         * {Vector2} 负向量。
         */

    }, {
        key: 'negate',
        value: function negate(out, v) {
            out[0] = -v[0];
            out[1] = -v[1];
            return out;
        }

        /**
         * APIMethod: lerp
         * 插值两个点。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         * t - {Number} 。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'lerp',
        value: function lerp(out, v1, v2, t) {
            out[0] = v1[0] + t * (v2[0] - v1[0]);
            out[1] = v1[1] + t * (v2[1] - v1[1]);
            return out;
        }

        /**
         * APIMethod: applyTransform
         * 矩阵左乘向量。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v - {Vector2} 向量 v。
         * m - {Vector2} 向量 m。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'applyTransform',
        value: function applyTransform(out, v, m) {
            var x = v[0];
            var y = v[1];
            out[0] = m[0] * x + m[2] * y + m[4];
            out[1] = m[1] * x + m[3] * y + m[5];
            return out;
        }

        /**
         * APIMethod: min
         * 求两个向量最小值。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'min',
        value: function min(out, v1, v2) {
            out[0] = Math.min(v1[0], v2[0]);
            out[1] = Math.min(v1[1], v2[1]);
            return out;
        }

        /**
         * APIMethod: max
         * 求两个向量最大值。
         *
         * Parameters:
         * out - {Vector2} 基础向量。
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Vector2} 结果。
         */

    }, {
        key: 'max',
        value: function max(out, v1, v2) {
            out[0] = Math.max(v1[0], v2[0]);
            out[1] = Math.max(v1[1], v2[1]);
            return out;
        }

        /**
         * APIMethod: length
         * 向量长度。
         *
         * Parameters:
         * v - {Vector2} 向量。
         *
         * Returns:
         * {Number} 向量长度。
         */

    }, {
        key: 'length',
        value: function length(v) {
            return this.len(v);
        }

        /**
         * APIMethod: lengthSquare
         * 向量长度平方。
         *
         * Parameters:
         * v - {Vector2} 向量。
         *
         * Returns:
         * {Number} 向量长度平方。
         */

    }, {
        key: 'lengthSquare',
        value: function lengthSquare(v) {
            return this.lenSquare(v);
        }

        /**
         * APIMethod: dist
         * 计算向量间距离。
         *
         * Parameters:
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Number} 向量间距离。
         */

    }, {
        key: 'dist',
        value: function dist(v1, v2) {
            return this.distance(v1, v2);
        }

        /**
         * APIMethod: distSquare
         * 向量距离平方。
         *
         * Parameters:
         * v1 - {Vector2} 向量 v1。
         * v2 - {Vector2} 向量 v2。
         *
         * Returns:
         * {Number} 向量距离平方。
         */

    }, {
        key: 'distSquare',
        value: function distSquare(v1, v2) {
            return this.distanceSquare(v1, v2);
        }
    }]);

    return Vector;
}();

exports["default"] = Vector;

_SuperMap2["default"].LevelRenderer.Tool.Vector = Vector;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

var parseCode = __webpack_require__(438);
var extend = __webpack_require__(78);
var projections = __webpack_require__(439);
var deriveConstants = __webpack_require__(434);

function Projection(srsCode,callback) {
  if (!(this instanceof Projection)) {
    return new Projection(srsCode);
  }
  callback = callback || function(error){
    if(error){
      throw error;
    }
  };
  var json = parseCode(srsCode);
  if(typeof json !== 'object'){
    callback(srsCode);
    return;
  }
  var modifiedJSON = deriveConstants(json);
  var ourProj = Projection.projections.get(modifiedJSON.projName);
  if(ourProj){
    extend(this, modifiedJSON);
    extend(this, ourProj);
    this.init();
    callback(null, this);
  }else{
    callback(srsCode);
  }
}
Projection.projections = projections;
Projection.projections.start();
module.exports = Projection;


/***/ }),
/* 75 */
/***/ (function(module, exports) {

module.exports = function(a, e, sinphi) {
  var temp = e * sinphi;
  return a / Math.sqrt(1 - temp * temp);
};

/***/ }),
/* 76 */
/***/ (function(module, exports) {

module.exports = function(ml, e0, e1, e2, e3) {
  var phi;
  var dphi;

  phi = ml / e0;
  for (var i = 0; i < 15; i++) {
    dphi = (ml - (e0 * phi - e1 * Math.sin(2 * phi) + e2 * Math.sin(4 * phi) - e3 * Math.sin(6 * phi))) / (e0 - 2 * e1 * Math.cos(2 * phi) + 4 * e2 * Math.cos(4 * phi) - 6 * e3 * Math.cos(6 * phi));
    phi += dphi;
    if (Math.abs(dphi) <= 0.0000000001) {
      return phi;
    }
  }

  //..reportError("IMLFN-CONV:Latitude failed to converge after 15 iterations");
  return NaN;
};

/***/ }),
/* 77 */
/***/ (function(module, exports) {

module.exports = function(eccent, sinphi) {
  var con;
  if (eccent > 1.0e-7) {
    con = eccent * sinphi;
    return ((1 - eccent * eccent) * (sinphi / (1 - con * con) - (0.5 / eccent) * Math.log((1 - con) / (1 + con))));
  }
  else {
    return (2 * sinphi);
  }
};

/***/ }),
/* 78 */
/***/ (function(module, exports) {

module.exports = function(destination, source) {
  destination = destination || {};
  var value, property;
  if (!source) {
    return destination;
  }
  for (property in source) {
    value = source[property];
    if (value !== undefined) {
      destination[property] = value;
    }
  }
  return destination;
};


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.wmtsLayer = exports.WMTSLayer = undefined;

__webpack_require__(4);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.wmtsLayer
 * @classdesc wmts图层类
 * @extends L.TileLayer{@linkdoc-leaflet/#tilelayer}
 * @param url -{string} wmts图层地址
 * @param options -{Object} wmts图层可选参数。如：<br>
 *        layersID - {number}图层ID，如果有layersID，则是在使用专题图。<br>
 *        redirect - {boolean} 是否从定向，如果为 true，则将请求重定向到图片的真实地址；如果为 false，则响应体中是图片的字节流。<br>
 *        transparent - {number}设置透明度。<br>
 *        cacheEnabled - {string} 启用缓存。<br>
 *        clipRegionEnabled - {boolean} 是否启用地图裁剪。<br>
 *        prjCoordSys - {Object} 请求的地图的坐标参考系统。 如：prjCoordSys={"epsgCode":3857}。<br>
 *        overlapDisplayed - {boolean} 地图对象在同一范围内时，是否重叠显示。<br>
 *        overlapDisplayedOptions - {string} 避免地图对象压盖显示的过滤选项。<br>
 *        tileversion - {string} 切片版本名称，cacheEnabled 为 true 时有效。<br>
 *        crs - {{@link L.Proj.CRS}} 坐标系统类。<br>
 *        serverType - {{@link SuperMap.ServerType}} 服务来源 iServer|iPortal|online。<br>
 *        attribution - {string} 版权信息。
 */
var WMTSLayer = exports.WMTSLayer = _leaflet2["default"].TileLayer.extend({

    options: {
        version: '1.0.0',
        style: '',
        tilematrixSet: '',
        format: 'image/png',
        tileSize: 256,
        matrixIds: null,
        layer: '',
        attribution: "with <span>© <a href='http://iclient.supermapol.com' target='_blank'>SuperMap iClient</a></span>"
    },

    //todo 自动获取Capabilities
    initialize: function initialize(url, options) {
        // (String, Object)
        this._url = url;
        _leaflet2["default"].setOptions(this, options);
    },

    /**
     * @function L.supermap.wmtsLayer.prototype.getTileUrl
     * @description 根据行列号获取切片地址
     * @param coords - {Object} 行列号
     * @return {string} 切片地址
     */
    getTileUrl: function getTileUrl(coords) {
        // (Point, Number) -> String
        var zoom = this._getZoomForUrl();
        var ident = this.options.matrixIds ? this.options.matrixIds[zoom].identifier : zoom;
        var url = _leaflet2["default"].Util.template(this._url, { s: this._getSubdomain(coords) });
        var obj = {
            service: 'WMTS',
            request: 'GetTile',
            version: this.options.version,
            style: this.options.style,
            tilematrixSet: this.options.tilematrixSet,
            format: this.options.format,
            width: this.options.tileSize,
            height: this.options.tileSize,
            layer: this.options.layer,
            tilematrix: ident,
            tilerow: coords.y,
            tilecol: coords.x
        };
        return url + _leaflet2["default"].Util.getParamString(obj, url);
    }
});

var wmtsLayer = exports.wmtsLayer = function wmtsLayer(url, options) {
    return new WMTSLayer(url, options);
};
_leaflet2["default"].supermap.wmtsLayer = wmtsLayer;

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.tiledMapLayer = exports.TiledMapLayer = undefined;

__webpack_require__(4);

__webpack_require__(22);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

var _REST = __webpack_require__(2);

var _Util = __webpack_require__(24);

var Util = _interopRequireWildcard(_Util);

var _ServerGeometry = __webpack_require__(8);

var _ServerGeometry2 = _interopRequireDefault(_ServerGeometry);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.tiledMapLayer
 * @classdesc SuperMap iServer 的 REST 地图服务的图层(SuperMap iServer Java 6R 及以上分块动态 REST 图层)。使用TileImage资源出图.
 * @extends L.TileLayer{@linkdoc-leaflet/#tilelayer}
 * @example
 *      L.superMap.tiledMapLayer(url).addTo(map);
 * @param url -{string} 影像图层地址
 * @param options -{Object} 影像图层参数。如：<br>
 *        layersID - {number}图层ID，如果有layersID，则是在使用专题图。<br>
 *        redirect - {boolean} 是否从定向，如果为 true，则将请求重定向到图片的真实地址；如果为 false，则响应体中是图片的字节流。<br>
 *        transparent - {number}设置透明度。<br>
 *        cacheEnabled - {string} 启用缓存。<br>
 *        clipRegionEnabled - {boolean} 是否启用地图裁剪。<br>
 *        prjCoordSys - {Object} 请求的地图的坐标参考系统。 如：prjCoordSys={"epsgCode":3857}。<br>
 *        overlapDisplayed - {boolean} 地图对象在同一范围内时，是否重叠显示。<br>
 *        overlapDisplayedOptions - {string} 避免地图对象压盖显示的过滤选项。<br>
 *        tileversion - {string} 切片版本名称，cacheEnabled 为 true 时有效。<br>
 *        crs - {{@link L.Proj.CRS}} 坐标系统类。<br>
 *        serverType - {{@link SuperMap.ServerType}} 服务来源 iServer|iPortal|online。<br>
 *        attribution - {string} 版权信息。<br>
 */
var TiledMapLayer = exports.TiledMapLayer = _leaflet2["default"].TileLayer.extend({

    options: {
        //如果有layersID，则是在使用专题图
        layersID: null,
        //如果为 true，则将请求重定向到图片的真实地址；如果为 false，则响应体中是图片的字节流
        redirect: false,
        transparent: null,
        cacheEnabled: null,
        clipRegionEnabled: false,
        //请求的地图的坐标参考系统。 如：prjCoordSys={"epsgCode":3857}
        prjCoordSys: null,
        //地图对象在同一范围内时，是否重叠显示
        overlapDisplayed: false,
        //避免地图对象压盖显示的过滤选项
        overlapDisplayedOptions: null,
        //切片版本名称，cacheEnabled 为 true 时有效。
        tileversion: null,

        crs: null,
        serverType: _REST.ServerType.ISERVER,

        attribution: "Map Data <span>© <a href='http://support.supermap.com.cn/product/iServer.aspx' target='_blank'>SuperMap iServer</a></span> with <span>© <a href='http://iclient.supermapol.com' target='_blank'>SuperMap iClient</a></span>"
    },

    initialize: function initialize(url, options) {
        this._url = url;
        _leaflet2["default"].TileLayer.prototype.initialize.apply(this, arguments);
        _leaflet2["default"].setOptions(this, options);
        _leaflet2["default"].stamp(this);

        //当前切片在切片集中的index
        this.tileSetsIndex = -1;
        this.tempIndex = -1;
    },

    /**
     * @private
     * @function L.supermap.tiledMapLayer.prototype.onAdd
     * @description 添加地图。
     * @param map - {L.map} 待添加的影像地图参数
     */
    onAdd: function onAdd(map) {
        this._crs = this.options.crs || map.options.crs;
        _leaflet2["default"].TileLayer.prototype.onAdd.call(this, map);
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.getTileUrl
     * @description 根据行列号获取瓦片地址
     * @param coords - {Object} 行列号
     * @return {string} 瓦片地址
     */
    getTileUrl: function getTileUrl(coords) {
        var scale = this.getScaleFromCoords(coords);
        var layerUrl = this._getLayerUrl();
        var tileUrl = layerUrl + "&scale=" + scale + "&x=" + coords.x + "&y=" + coords.y;
        return encodeURI(tileUrl);
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.getScale
     * @description 根据缩放级别获取比例尺
     * @param zoom - {number} 缩放级别
     * @return {number} 比例尺
     */
    getScale: function getScale(zoom) {
        var me = this;
        //返回当前比例尺
        var z = zoom || me._map.getZoom();
        return me.scales[z];
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.getScaleFromCoords
     * @description 通过行列号获取比例尺
     * @param coords - {Object} 行列号
     * @return {number} 比例尺
     */
    getScaleFromCoords: function getScaleFromCoords(coords) {
        var me = this,
            scale;
        if (me.scales && me.scales[coords.z]) {
            return me.scales[coords.z];
        }
        me.scales = me.scales || {};
        scale = me.getDefaultScale(coords);
        me.scales[coords.z] = scale;
        return scale;
    },

    /**
     * @private
     * @function L.supermap.tiledMapLayer.prototype.getDefaultScale
     * @description 获取默认比例尺信息
     * @param coords - {Object} 坐标对象参数
     */
    getDefaultScale: function getDefaultScale(coords) {
        var me = this,
            crs = me._crs;
        var resolution;
        if (crs.options && crs.options.resolutions) {
            resolution = crs.options.resolutions[coords.z];
        } else {
            var tileBounds = me._tileCoordsToBounds(coords);
            var ne = crs.project(tileBounds.getNorthEast());
            var sw = crs.project(tileBounds.getSouthWest());
            var tileSize = me.options.tileSize;
            resolution = Math.max(Math.abs(ne.x - sw.x) / tileSize, Math.abs(ne.y - sw.y) / tileSize);
        }

        var mapUnit = _REST.Unit.METER;
        if (crs.code) {
            var array = crs.code.split(':');
            if (array && array.length > 1) {
                var code = parseInt(array[1]);
                mapUnit = code && code >= 4000 && code <= 5000 ? _REST.Unit.DEGREE : _REST.Unit.METER;
            }
        }
        return Util.resolutionToScale(resolution, 96, mapUnit);
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.setTileSetsInfo
     * @description 设置瓦片集信息
     * @param tileSets - {Object} 瓦片对象集
     */
    setTileSetsInfo: function setTileSetsInfo(tileSets) {
        this.tileSets = tileSets;
        if (_leaflet2["default"].Util.isArray(this.tileSets)) {
            this.tileSets = this.tileSets[0];
        }
        if (!this.tileSets) {
            return;
        }
        this.fire('tilesetsinfoloaded', { tileVersions: this.tileSets.tileVersions });
        this.changeTilesVersion();
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.lastTilesVersion
     * @description 请求上一个版本切片，并重新绘制。
     */
    lastTilesVersion: function lastTilesVersion() {
        this.tempIndex = this.tileSetsIndex - 1;
        this.changeTilesVersion();
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.nextTilesVersion
     * @description 请求下一个版本切片，并重新绘制。
     */
    nextTilesVersion: function nextTilesVersion() {
        this.tempIndex = this.tileSetsIndex + 1;
        this.changeTilesVersion();
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.changeTilesVersion
     * @description 切换到某一版本的切片，并重绘。通过this.tempIndex保存需要切换的版本索引
     */
    changeTilesVersion: function changeTilesVersion() {
        var me = this;
        //切片版本集信息是否存在
        if (me.tileSets == null) {
            //版本信息为空，重新查询，查询成功继续跳转到相应的版本
            //me.getTileSetsInfo();
            return;
        }
        if (me.tempIndex === me.tileSetsIndex || this.tempIndex < 0) {
            return;
        }
        //检测index是否可用
        var tileVersions = me.tileSets.tileVersions;
        if (tileVersions && me.tempIndex < tileVersions.length && me.tempIndex >= 0) {
            var name = tileVersions[me.tempIndex].name;
            var result = me.mergeTileVersionParam(name);
            if (result) {
                me.tileSetsIndex = me.tempIndex;
                me.fire('tileversionschanged', { tileVersion: tileVersions[me.tempIndex] });
            }
        }
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.updateCurrentTileSetsIndex
     * @description 手动设置当前切片集索引,目前主要提供给控件使用
     * @param index - {number}索引值
     */
    updateCurrentTileSetsIndex: function updateCurrentTileSetsIndex(index) {
        this.tempIndex = index;
    },

    /**
     * @function L.supermap.tiledMapLayer.prototype.mergeTileVersionParam
     * @description 更改URL请求参数中的切片版本号,并重绘
     * @param version - {string} 切片版本号
     * @return {boolean} 是否成功
     */
    mergeTileVersionParam: function mergeTileVersionParam(version) {
        if (version) {
            this.requestParams["tileversion"] = version;
            this._paramsChanged = true;
            this.redraw();
            this._paramsChanged = false;
            return true;
        }
        return false;
    },

    _getLayerUrl: function _getLayerUrl() {
        if (this._paramsChanged) {
            this._layerUrl = this._createLayerUrl();
        }
        return this._layerUrl || this._createLayerUrl();
    },

    _createLayerUrl: function _createLayerUrl() {
        var me = this;
        var layerUrl = me._url + "/tileImage.png?";
        layerUrl += me._getRequestParamString();
        layerUrl = this._appendCredential(layerUrl);
        this._layerUrl = layerUrl;
        return layerUrl;
    },

    _getRequestParamString: function _getRequestParamString() {
        this.requestParams = this.requestParams || this._getAllRequestParams();
        var params = [];
        for (var key in this.requestParams) {
            params.push(key + "=" + this.requestParams[key]);
        }
        return params.join('&');
    },

    _getAllRequestParams: function _getAllRequestParams() {
        var me = this,
            options = me.options || {},
            params = {};

        var tileSize = this.options.tileSize;
        params["width"] = tileSize.toString();
        params["height"] = tileSize.toString();

        params["redirect"] = options.redirect === true;
        params["transparent"] = options.transparent === true;
        params["cacheEnabled"] = !(options.cacheEnabled === false);

        if (options.prjCoordSys) {
            params["prjCoordSys"] = JSON.stringify(options.prjCoordSys);
        }

        if (options.layersID) {
            params["layersID"] = options.layersID.toString();
        }

        if (options.clipRegionEnabled && options.clipRegion instanceof _leaflet2["default"].Path) {
            options.clipRegion = Util.toSuperMapGeometry(options.clipRegion.toGeoJSON());
            options.clipRegion = SuperMap.Util.toJSON(_ServerGeometry2["default"].fromGeometry(options.clipRegion));
            params["clipRegionEnabled"] = options.clipRegionEnabled;
            params["clipRegion"] = JSON.stringify(options.clipRegion);
        }

        //切片的起始参考点，默认为地图范围的左上角。
        var crs = me._crs;
        if (crs.projection && crs.projection.bounds) {
            var bounds = crs.projection.bounds;
            var tileOrigin = _leaflet2["default"].point(bounds.min.x, bounds.max.y);
            params["origin"] = JSON.stringify({ x: tileOrigin.x, y: tileOrigin.y });
        }

        if (options.overlapDisplayed === false) {
            params["overlapDisplayed"] = false;
            if (options.overlapDisplayedOptions) {
                params["overlapDisplayedOptions"] = me.overlapDisplayedOptions.toString();
            }
        } else {
            params["overlapDisplayed"] = true;
        }

        if (options.cacheEnabled === true && options.tileversion) {
            params["tileversion"] = options.tileversion.toString();
        }

        return params;
    },

    //追加token或key
    _appendCredential: function _appendCredential(url) {
        var newUrl = url,
            credential,
            value;
        switch (this.options.serverType) {
            case SuperMap.ServerType.ISERVER:
                value = SuperMap.SecurityManager.getToken(url);
                credential = value ? new SuperMap.Credential(value, "token") : null;
                break;
            case SuperMap.ServerType.IPORTAL:
                value = SuperMap.SecurityManager.getToken(url);
                credential = value ? new SuperMap.Credential(value, "token") : null;
                if (!credential) {
                    value = SuperMap.SecurityManager.getKey(url);
                    credential = value ? new SuperMap.Credential(value, "key") : null;
                }
                break;
            case SuperMap.ServerType.ONLINE:
                value = SuperMap.SecurityManager.getKey(url);
                credential = value ? new SuperMap.Credential(value, "key") : null;
                break;
            default:
                value = SuperMap.SecurityManager.getToken(url);
                credential = value ? new SuperMap.Credential(value, "token") : null;
                break;
        }
        if (credential) {
            newUrl += "&" + credential.getUrlParameters();
        }
        return newUrl;
    }
});

var tiledMapLayer = exports.tiledMapLayer = function tiledMapLayer(url, options) {
    return new TiledMapLayer(url, options);
};
_leaflet2["default"].supermap.tiledMapLayer = tiledMapLayer;

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dataFlowService = exports.DataFlowService = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ServiceBase = __webpack_require__(7);

var _DataFlowService = __webpack_require__(200);

var _DataFlowService2 = _interopRequireDefault(_DataFlowService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.dataFlowService
 * @classdesc 实时数据服务类
 * @extends L.supermap.ServiceBase
 * @param url - {string} 实时数据服务地址
 * @param options - {Object} 加载实时数据可选参数。如：<br>
 *        serverType - {{@link SuperMap.ServerType}} 服务来源 iServer|iPortal|online。<br>
 *        style - {function} 设置数据加载样式。<br>
 *        onEachFeature - {function} 设置每个数据加载popup等。<br>
 *        geometry - {Array<Object>} 设置增添的几何要素对象数组。<br>
 *        excludeField - -{Object} 排除字段
 */
var DataFlowService = exports.DataFlowService = _ServiceBase.ServiceBase.extend({

    options: {
        geometry: null,
        prjCoordSys: null,
        excludeField: null
    },

    initialize: function initialize(url, options) {
        options = options || {};
        _leaflet2["default"].setOptions(this, options);
        if (options.projection) {
            this.options.prjCoordSys = options.projection;
        }
        _ServiceBase.ServiceBase.prototype.initialize.call(this, url, options);
        this.dataFlow = new _DataFlowService2["default"](url, options);
        this.dataFlow.events.on({
            "broadcastSocketConnected": this._defaultEvent,
            "broadcastSocketError": this._defaultEvent,
            "broadcastFailed": this._defaultEvent,
            "broadcastSuccessed": this._defaultEvent,
            "subscribeSocketConnected": this._defaultEvent,
            "subscribeSocketError": this._defaultEvent,
            "messageSuccessed": this._defaultEvent,
            "setFilterParamSuccessed": this._defaultEvent,
            scope: this
        });
    },

    /**
     * @function L.supermap.dataFlowService.prototype.initBroadcast
     * @description 初始化广播
     * @returns {this}
     */
    initBroadcast: function initBroadcast() {
        this.dataFlow.initBroadcast();
        return this;
    },

    /**
     * @function L.supermap.dataFlowService.prototype.broadcast
     * @description 加载广播数据
     * @param obj {JSONObject} json格式的要素数据
     */
    broadcast: function broadcast(obj) {
        this.dataFlow.broadcast(obj);
    },

    /**
     * @function L.supermap.dataFlowService.prototype.initSubscribe
     * @description 初始化订阅数据
     * @returns {this}
     */
    initSubscribe: function initSubscribe() {
        this.dataFlow.initSubscribe();
        return this;
    },

    /**
     * @function L.supermap.dataFlowService.prototype.setExcludeField
     * @description 设置排除字段
     * @param excludeField - {Object} 排除字段
     * @returns {this}
     */
    setExcludeField: function setExcludeField(excludeField) {
        this.dataFlow.setExcludeField(excludeField);
        this.options.excludeField = excludeField;
        return this;
    },

    /**
     * @function L.supermap.dataFlowService.prototype.setGeometry
     * @description 设置添加的GeoJSON几何要素数据
     * @param geometry - {Array<Object>} 设置增添的GeoJSON几何要素对象数组。
     * @returns {this}
     */
    setGeometry: function setGeometry(geometry) {
        this.dataFlow.setGeometry(geometry);
        this.options.geometry = geometry;
        return this;
    },

    /**
     * @function L.supermap.dataFlowService.prototype.unSubscribe
     * @description 结束订阅数据
     */
    unSubscribe: function unSubscribe() {
        this.dataFlow.unSubscribe();
    },

    /**
     * @function L.supermap.dataFlowService.prototype.unBroadcast
     * @description 结束加载广播
     */
    unBroadcast: function unBroadcast() {
        this.dataFlow.unBroadcast();
    },

    _defaultEvent: function _defaultEvent(e) {
        this.fire(e.eventType || e.type, e);
    }
});

var dataFlowService = exports.dataFlowService = function dataFlowService(url, options) {
    return new DataFlowService(url, options);
};

_leaflet2["default"].supermap.dataFlowService = dataFlowService;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.mapService = exports.MapService = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

var _ServiceBase = __webpack_require__(7);

var _MapService = __webpack_require__(277);

var _MapService2 = _interopRequireDefault(_MapService);

var _TilesetsService = __webpack_require__(337);

var _TilesetsService2 = _interopRequireDefault(_TilesetsService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class  L.supermap.mapService
 * @classdesc 地图信息服务类
 * @extends L.supermap.ServiceBase
 * @param url -{string} 地图服务地址
 * @param options -{Object} 地图服务信息相关参数。如：<br>
 *        serverType - {{@link SuperMap.ServerType}} 服务来源 iServer|iPortal|online
 * @example
 * L.supermap.mapService(url)
 *  .getMapInfo(function(result){
 *     //doSomething
 * })
 */
var MapService = exports.MapService = _ServiceBase.ServiceBase.extend({

    options: {
        projection: null
    },

    initialize: function initialize(url, options) {
        options = options || {};
        _leaflet2["default"].setOptions(this, options);
        if (options.projection) {
            this.options.projection = options.projection;
        }
        _ServiceBase.ServiceBase.prototype.initialize.call(this, url, options);
    },

    /**
     * @function  L.supermap.mapService.prototype.getMapInfo
     * @description 获取地图信息
     * @param callback -{function} 回调函数
     * @return {this}
     */
    getMapInfo: function getMapInfo(callback) {
        var me = this;
        var getMapStatusService = new _MapService2["default"](me.url, {
            serverType: me.options.serverType,
            eventListeners: {
                scope: me,
                processCompleted: callback,
                processFailed: callback
            }, projection: me.options.projection
        });
        getMapStatusService.processAsync();
        return me;
    },

    /**
     * @function  L.supermap.mapService.prototype.getTilesets
     * @description 获取切片列表信息
     * @param callback -{function} 回调函数
     * @return {this}
     */
    getTilesets: function getTilesets(callback) {
        var me = this;
        var tilesetsService = new _TilesetsService2["default"](me.url, {
            serverType: me.options.serverType,
            eventListeners: {
                scope: me,
                processCompleted: callback,
                processFailed: callback
            }
        });

        tilesetsService.processAsync();
        return me;
    }
});

var mapService = exports.mapService = function mapService(url, options) {
    return new MapService(url, options);
};

_leaflet2["default"].supermap.mapService = mapService;

/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * UTM zones are grouped, and assigned to one of a group of 6
 * sets.
 *
 * {int} @private
 */
var NUM_100K_SETS = 6;

/**
 * The column letters (for easting) of the lower left value, per
 * set.
 *
 * {string} @private
 */
var SET_ORIGIN_COLUMN_LETTERS = 'AJSAJS';

/**
 * The row letters (for northing) of the lower left value, per
 * set.
 *
 * {string} @private
 */
var SET_ORIGIN_ROW_LETTERS = 'AFAFAF';

var A = 65; // A
var I = 73; // I
var O = 79; // O
var V = 86; // V
var Z = 90; // Z

/**
 * Conversion of lat/lon to MGRS.
 *
 * @param {object} ll Object literal with lat and lon properties on a
 *     WGS84 ellipsoid.
 * @param {int} accuracy Accuracy in digits (5 for 1 m, 4 for 10 m, 3 for
 *      100 m, 2 for 1000 m or 1 for 10000 m). Optional, default is 5.
 * @return {string} the MGRS string for the given location and accuracy.
 */
exports.forward = function (ll, accuracy) {
  accuracy = accuracy || 5; // default accuracy 1m
  return encode(LLtoUTM({
    lat: ll[1],
    lon: ll[0]
  }), accuracy);
};

/**
 * Conversion of MGRS to lat/lon.
 *
 * @param {string} mgrs MGRS string.
 * @return {array} An array with left (longitude), bottom (latitude), right
 *     (longitude) and top (latitude) values in WGS84, representing the
 *     bounding box for the provided MGRS reference.
 */
exports.inverse = function (mgrs) {
  var bbox = UTMtoLL(decode(mgrs.toUpperCase()));
  if (bbox.lat && bbox.lon) {
    return [bbox.lon, bbox.lat, bbox.lon, bbox.lat];
  }
  return [bbox.left, bbox.bottom, bbox.right, bbox.top];
};

exports.toPoint = function (mgrs) {
  var bbox = UTMtoLL(decode(mgrs.toUpperCase()));
  if (bbox.lat && bbox.lon) {
    return [bbox.lon, bbox.lat];
  }
  return [(bbox.left + bbox.right) / 2, (bbox.top + bbox.bottom) / 2];
};
/**
 * Conversion from degrees to radians.
 *
 * @private
 * @param {number} deg the angle in degrees.
 * @return {number} the angle in radians.
 */
function degToRad(deg) {
  return deg * (Math.PI / 180.0);
}

/**
 * Conversion from radians to degrees.
 *
 * @private
 * @param {number} rad the angle in radians.
 * @return {number} the angle in degrees.
 */
function radToDeg(rad) {
  return 180.0 * (rad / Math.PI);
}

/**
 * Converts a set of Longitude and Latitude co-ordinates to UTM
 * using the WGS84 ellipsoid.
 *
 * @private
 * @param {object} ll Object literal with lat and lon properties
 *     representing the WGS84 coordinate to be converted.
 * @return {object} Object literal containing the UTM value with easting,
 *     northing, zoneNumber and zoneLetter properties, and an optional
 *     accuracy property in digits. Returns null if the conversion failed.
 */
function LLtoUTM(ll) {
  var Lat = ll.lat;
  var Long = ll.lon;
  var a = 6378137.0; //ellip.radius;
  var eccSquared = 0.00669438; //ellip.eccsq;
  var k0 = 0.9996;
  var LongOrigin;
  var eccPrimeSquared;
  var N, T, C, A, M;
  var LatRad = degToRad(Lat);
  var LongRad = degToRad(Long);
  var LongOriginRad;
  var ZoneNumber;
  // (int)
  ZoneNumber = Math.floor((Long + 180) / 6) + 1;

  //Make sure the longitude 180.00 is in Zone 60
  if (Long === 180) {
    ZoneNumber = 60;
  }

  // Special zone for Norway
  if (Lat >= 56.0 && Lat < 64.0 && Long >= 3.0 && Long < 12.0) {
    ZoneNumber = 32;
  }

  // Special zones for Svalbard
  if (Lat >= 72.0 && Lat < 84.0) {
    if (Long >= 0.0 && Long < 9.0) {
      ZoneNumber = 31;
    } else if (Long >= 9.0 && Long < 21.0) {
      ZoneNumber = 33;
    } else if (Long >= 21.0 && Long < 33.0) {
      ZoneNumber = 35;
    } else if (Long >= 33.0 && Long < 42.0) {
      ZoneNumber = 37;
    }
  }

  LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3; //+3 puts origin
  // in middle of
  // zone
  LongOriginRad = degToRad(LongOrigin);

  eccPrimeSquared = eccSquared / (1 - eccSquared);

  N = a / Math.sqrt(1 - eccSquared * Math.sin(LatRad) * Math.sin(LatRad));
  T = Math.tan(LatRad) * Math.tan(LatRad);
  C = eccPrimeSquared * Math.cos(LatRad) * Math.cos(LatRad);
  A = Math.cos(LatRad) * (LongRad - LongOriginRad);

  M = a * ((1 - eccSquared / 4 - 3 * eccSquared * eccSquared / 64 - 5 * eccSquared * eccSquared * eccSquared / 256) * LatRad - (3 * eccSquared / 8 + 3 * eccSquared * eccSquared / 32 + 45 * eccSquared * eccSquared * eccSquared / 1024) * Math.sin(2 * LatRad) + (15 * eccSquared * eccSquared / 256 + 45 * eccSquared * eccSquared * eccSquared / 1024) * Math.sin(4 * LatRad) - 35 * eccSquared * eccSquared * eccSquared / 3072 * Math.sin(6 * LatRad));

  var UTMEasting = k0 * N * (A + (1 - T + C) * A * A * A / 6.0 + (5 - 18 * T + T * T + 72 * C - 58 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;

  var UTMNorthing = k0 * (M + N * Math.tan(LatRad) * (A * A / 2 + (5 - T + 9 * C + 4 * C * C) * A * A * A * A / 24.0 + (61 - 58 * T + T * T + 600 * C - 330 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
  if (Lat < 0.0) {
    UTMNorthing += 10000000.0; //10000000 meter offset for
    // southern hemisphere
  }

  return {
    northing: Math.round(UTMNorthing),
    easting: Math.round(UTMEasting),
    zoneNumber: ZoneNumber,
    zoneLetter: getLetterDesignator(Lat)
  };
}

/**
 * Converts UTM coords to lat/long, using the WGS84 ellipsoid. This is a convenience
 * class where the Zone can be specified as a single string eg."60N" which
 * is then broken down into the ZoneNumber and ZoneLetter.
 *
 * @private
 * @param {object} utm An object literal with northing, easting, zoneNumber
 *     and zoneLetter properties. If an optional accuracy property is
 *     provided (in meters), a bounding box will be returned instead of
 *     latitude and longitude.
 * @return {object} An object literal containing either lat and lon values
 *     (if no accuracy was provided), or top, right, bottom and left values
 *     for the bounding box calculated according to the provided accuracy.
 *     Returns null if the conversion failed.
 */
function UTMtoLL(utm) {

  var UTMNorthing = utm.northing;
  var UTMEasting = utm.easting;
  var zoneLetter = utm.zoneLetter;
  var zoneNumber = utm.zoneNumber;
  // check the ZoneNummber is valid
  if (zoneNumber < 0 || zoneNumber > 60) {
    return null;
  }

  var k0 = 0.9996;
  var a = 6378137.0; //ellip.radius;
  var eccSquared = 0.00669438; //ellip.eccsq;
  var eccPrimeSquared;
  var e1 = (1 - Math.sqrt(1 - eccSquared)) / (1 + Math.sqrt(1 - eccSquared));
  var N1, T1, C1, R1, D, M;
  var LongOrigin;
  var mu, phi1Rad;

  // remove 500,000 meter offset for longitude
  var x = UTMEasting - 500000.0;
  var y = UTMNorthing;

  // We must know somehow if we are in the Northern or Southern
  // hemisphere, this is the only time we use the letter So even
  // if the Zone letter isn't exactly correct it should indicate
  // the hemisphere correctly
  if (zoneLetter < 'N') {
    y -= 10000000.0; // remove 10,000,000 meter offset used
    // for southern hemisphere
  }

  // There are 60 zones with zone 1 being at West -180 to -174
  LongOrigin = (zoneNumber - 1) * 6 - 180 + 3; // +3 puts origin
  // in middle of
  // zone

  eccPrimeSquared = eccSquared / (1 - eccSquared);

  M = y / k0;
  mu = M / (a * (1 - eccSquared / 4 - 3 * eccSquared * eccSquared / 64 - 5 * eccSquared * eccSquared * eccSquared / 256));

  phi1Rad = mu + (3 * e1 / 2 - 27 * e1 * e1 * e1 / 32) * Math.sin(2 * mu) + (21 * e1 * e1 / 16 - 55 * e1 * e1 * e1 * e1 / 32) * Math.sin(4 * mu) + 151 * e1 * e1 * e1 / 96 * Math.sin(6 * mu);
  // double phi1 = ProjMath.radToDeg(phi1Rad);

  N1 = a / Math.sqrt(1 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
  T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
  C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
  R1 = a * (1 - eccSquared) / Math.pow(1 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
  D = x / (N1 * k0);

  var lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2 - (5 + 3 * T1 + 10 * C1 - 4 * C1 * C1 - 9 * eccPrimeSquared) * D * D * D * D / 24 + (61 + 90 * T1 + 298 * C1 + 45 * T1 * T1 - 252 * eccPrimeSquared - 3 * C1 * C1) * D * D * D * D * D * D / 720);
  lat = radToDeg(lat);

  var lon = (D - (1 + 2 * T1 + C1) * D * D * D / 6 + (5 - 2 * C1 + 28 * T1 - 3 * C1 * C1 + 8 * eccPrimeSquared + 24 * T1 * T1) * D * D * D * D * D / 120) / Math.cos(phi1Rad);
  lon = LongOrigin + radToDeg(lon);

  var result;
  if (utm.accuracy) {
    var topRight = UTMtoLL({
      northing: utm.northing + utm.accuracy,
      easting: utm.easting + utm.accuracy,
      zoneLetter: utm.zoneLetter,
      zoneNumber: utm.zoneNumber
    });
    result = {
      top: topRight.lat,
      right: topRight.lon,
      bottom: lat,
      left: lon
    };
  } else {
    result = {
      lat: lat,
      lon: lon
    };
  }
  return result;
}

/**
 * Calculates the MGRS letter designator for the given latitude.
 *
 * @private
 * @param {number} lat The latitude in WGS84 to get the letter designator
 *     for.
 * @return {char} The letter designator.
 */
function getLetterDesignator(lat) {
  //This is here as an error flag to show that the Latitude is
  //outside MGRS limits
  var LetterDesignator = 'Z';

  if (84 >= lat && lat >= 72) {
    LetterDesignator = 'X';
  } else if (72 > lat && lat >= 64) {
    LetterDesignator = 'W';
  } else if (64 > lat && lat >= 56) {
    LetterDesignator = 'V';
  } else if (56 > lat && lat >= 48) {
    LetterDesignator = 'U';
  } else if (48 > lat && lat >= 40) {
    LetterDesignator = 'T';
  } else if (40 > lat && lat >= 32) {
    LetterDesignator = 'S';
  } else if (32 > lat && lat >= 24) {
    LetterDesignator = 'R';
  } else if (24 > lat && lat >= 16) {
    LetterDesignator = 'Q';
  } else if (16 > lat && lat >= 8) {
    LetterDesignator = 'P';
  } else if (8 > lat && lat >= 0) {
    LetterDesignator = 'N';
  } else if (0 > lat && lat >= -8) {
    LetterDesignator = 'M';
  } else if (-8 > lat && lat >= -16) {
    LetterDesignator = 'L';
  } else if (-16 > lat && lat >= -24) {
    LetterDesignator = 'K';
  } else if (-24 > lat && lat >= -32) {
    LetterDesignator = 'J';
  } else if (-32 > lat && lat >= -40) {
    LetterDesignator = 'H';
  } else if (-40 > lat && lat >= -48) {
    LetterDesignator = 'G';
  } else if (-48 > lat && lat >= -56) {
    LetterDesignator = 'F';
  } else if (-56 > lat && lat >= -64) {
    LetterDesignator = 'E';
  } else if (-64 > lat && lat >= -72) {
    LetterDesignator = 'D';
  } else if (-72 > lat && lat >= -80) {
    LetterDesignator = 'C';
  }
  return LetterDesignator;
}

/**
 * Encodes a UTM location as MGRS string.
 *
 * @private
 * @param {object} utm An object literal with easting, northing,
 *     zoneLetter, zoneNumber
 * @param {number} accuracy Accuracy in digits (1-5).
 * @return {string} MGRS string for the given UTM location.
 */
function encode(utm, accuracy) {
  // prepend with leading zeroes
  var seasting = "00000" + utm.easting,
      snorthing = "00000" + utm.northing;

  return utm.zoneNumber + utm.zoneLetter + get100kID(utm.easting, utm.northing, utm.zoneNumber) + seasting.substr(seasting.length - 5, accuracy) + snorthing.substr(snorthing.length - 5, accuracy);
}

/**
 * Get the two letter 100k designator for a given UTM easting,
 * northing and zone number value.
 *
 * @private
 * @param {number} easting
 * @param {number} northing
 * @param {number} zoneNumber
 * @return the two letter 100k designator for the given UTM location.
 */
function get100kID(easting, northing, zoneNumber) {
  var setParm = get100kSetForZone(zoneNumber);
  var setColumn = Math.floor(easting / 100000);
  var setRow = Math.floor(northing / 100000) % 20;
  return getLetter100kID(setColumn, setRow, setParm);
}

/**
 * Given a UTM zone number, figure out the MGRS 100K set it is in.
 *
 * @private
 * @param {number} i An UTM zone number.
 * @return {number} the 100k set the UTM zone is in.
 */
function get100kSetForZone(i) {
  var setParm = i % NUM_100K_SETS;
  if (setParm === 0) {
    setParm = NUM_100K_SETS;
  }

  return setParm;
}

/**
 * Get the two-letter MGRS 100k designator given information
 * translated from the UTM northing, easting and zone number.
 *
 * @private
 * @param {number} column the column index as it relates to the MGRS
 *        100k set spreadsheet, created from the UTM easting.
 *        Values are 1-8.
 * @param {number} row the row index as it relates to the MGRS 100k set
 *        spreadsheet, created from the UTM northing value. Values
 *        are from 0-19.
 * @param {number} parm the set block, as it relates to the MGRS 100k set
 *        spreadsheet, created from the UTM zone. Values are from
 *        1-60.
 * @return two letter MGRS 100k code.
 */
function getLetter100kID(column, row, parm) {
  // colOrigin and rowOrigin are the letters at the origin of the set
  var index = parm - 1;
  var colOrigin = SET_ORIGIN_COLUMN_LETTERS.charCodeAt(index);
  var rowOrigin = SET_ORIGIN_ROW_LETTERS.charCodeAt(index);

  // colInt and rowInt are the letters to build to return
  var colInt = colOrigin + column - 1;
  var rowInt = rowOrigin + row;
  var rollover = false;

  if (colInt > Z) {
    colInt = colInt - Z + A - 1;
    rollover = true;
  }

  if (colInt === I || colOrigin < I && colInt > I || (colInt > I || colOrigin < I) && rollover) {
    colInt++;
  }

  if (colInt === O || colOrigin < O && colInt > O || (colInt > O || colOrigin < O) && rollover) {
    colInt++;

    if (colInt === I) {
      colInt++;
    }
  }

  if (colInt > Z) {
    colInt = colInt - Z + A - 1;
  }

  if (rowInt > V) {
    rowInt = rowInt - V + A - 1;
    rollover = true;
  } else {
    rollover = false;
  }

  if (rowInt === I || rowOrigin < I && rowInt > I || (rowInt > I || rowOrigin < I) && rollover) {
    rowInt++;
  }

  if (rowInt === O || rowOrigin < O && rowInt > O || (rowInt > O || rowOrigin < O) && rollover) {
    rowInt++;

    if (rowInt === I) {
      rowInt++;
    }
  }

  if (rowInt > V) {
    rowInt = rowInt - V + A - 1;
  }

  var twoLetter = String.fromCharCode(colInt) + String.fromCharCode(rowInt);
  return twoLetter;
}

/**
 * Decode the UTM parameters from a MGRS string.
 *
 * @private
 * @param {string} mgrsString an UPPERCASE coordinate string is expected.
 * @return {object} An object literal with easting, northing, zoneLetter,
 *     zoneNumber and accuracy (in meters) properties.
 */
function decode(mgrsString) {

  if (mgrsString && mgrsString.length === 0) {
    throw "MGRSPoint coverting from nothing";
  }

  var length = mgrsString.length;

  var hunK = null;
  var sb = "";
  var testChar;
  var i = 0;

  // get Zone number
  while (!/[A-Z]/.test(testChar = mgrsString.charAt(i))) {
    if (i >= 2) {
      throw "MGRSPoint bad conversion from: " + mgrsString;
    }
    sb += testChar;
    i++;
  }

  var zoneNumber = parseInt(sb, 10);

  if (i === 0 || i + 3 > length) {
    // A good MGRS string has to be 4-5 digits long,
    // ##AAA/#AAA at least.
    throw "MGRSPoint bad conversion from: " + mgrsString;
  }

  var zoneLetter = mgrsString.charAt(i++);

  // Should we check the zone letter here? Why not.
  if (zoneLetter <= 'A' || zoneLetter === 'B' || zoneLetter === 'Y' || zoneLetter >= 'Z' || zoneLetter === 'I' || zoneLetter === 'O') {
    throw "MGRSPoint zone letter " + zoneLetter + " not handled: " + mgrsString;
  }

  hunK = mgrsString.substring(i, i += 2);

  var set = get100kSetForZone(zoneNumber);

  var east100k = getEastingFromChar(hunK.charAt(0), set);
  var north100k = getNorthingFromChar(hunK.charAt(1), set);

  // We have a bug where the northing may be 2000000 too low.
  // How
  // do we know when to roll over?

  while (north100k < getMinNorthing(zoneLetter)) {
    north100k += 2000000;
  }

  // calculate the char index for easting/northing separator
  var remainder = length - i;

  if (remainder % 2 !== 0) {
    throw "MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters" + mgrsString;
  }

  var sep = remainder / 2;

  var sepEasting = 0.0;
  var sepNorthing = 0.0;
  var accuracyBonus, sepEastingString, sepNorthingString, easting, northing;
  if (sep > 0) {
    accuracyBonus = 100000.0 / Math.pow(10, sep);
    sepEastingString = mgrsString.substring(i, i + sep);
    sepEasting = parseFloat(sepEastingString) * accuracyBonus;
    sepNorthingString = mgrsString.substring(i + sep);
    sepNorthing = parseFloat(sepNorthingString) * accuracyBonus;
  }

  easting = sepEasting + east100k;
  northing = sepNorthing + north100k;

  return {
    easting: easting,
    northing: northing,
    zoneLetter: zoneLetter,
    zoneNumber: zoneNumber,
    accuracy: accuracyBonus
  };
}

/**
 * Given the first letter from a two-letter MGRS 100k zone, and given the
 * MGRS table set for the zone number, figure out the easting value that
 * should be added to the other, secondary easting value.
 *
 * @private
 * @param {char} e The first letter from a two-letter MGRS 100´k zone.
 * @param {number} set The MGRS table set for the zone number.
 * @return {number} The easting value for the given letter and set.
 */
function getEastingFromChar(e, set) {
  // colOrigin is the letter at the origin of the set for the
  // column
  var curCol = SET_ORIGIN_COLUMN_LETTERS.charCodeAt(set - 1);
  var eastingValue = 100000.0;
  var rewindMarker = false;

  while (curCol !== e.charCodeAt(0)) {
    curCol++;
    if (curCol === I) {
      curCol++;
    }
    if (curCol === O) {
      curCol++;
    }
    if (curCol > Z) {
      if (rewindMarker) {
        throw "Bad character: " + e;
      }
      curCol = A;
      rewindMarker = true;
    }
    eastingValue += 100000.0;
  }

  return eastingValue;
}

/**
 * Given the second letter from a two-letter MGRS 100k zone, and given the
 * MGRS table set for the zone number, figure out the northing value that
 * should be added to the other, secondary northing value. You have to
 * remember that Northings are determined from the equator, and the vertical
 * cycle of letters mean a 2000000 additional northing meters. This happens
 * approx. every 18 degrees of latitude. This method does *NOT* count any
 * additional northings. You have to figure out how many 2000000 meters need
 * to be added for the zone letter of the MGRS coordinate.
 *
 * @private
 * @param {char} n Second letter of the MGRS 100k zone
 * @param {number} set The MGRS table set number, which is dependent on the
 *     UTM zone number.
 * @return {number} The northing value for the given letter and set.
 */
function getNorthingFromChar(n, set) {

  if (n > 'V') {
    throw "MGRSPoint given invalid Northing " + n;
  }

  // rowOrigin is the letter at the origin of the set for the
  // column
  var curRow = SET_ORIGIN_ROW_LETTERS.charCodeAt(set - 1);
  var northingValue = 0.0;
  var rewindMarker = false;

  while (curRow !== n.charCodeAt(0)) {
    curRow++;
    if (curRow === I) {
      curRow++;
    }
    if (curRow === O) {
      curRow++;
    }
    // fixing a bug making whole application hang in this loop
    // when 'n' is a wrong character
    if (curRow > V) {
      if (rewindMarker) {
        // making sure that this loop ends
        throw "Bad character: " + n;
      }
      curRow = A;
      rewindMarker = true;
    }
    northingValue += 100000.0;
  }

  return northingValue;
}

/**
 * The function getMinNorthing returns the minimum northing value of a MGRS
 * zone.
 *
 * Ported from Geotrans' c Lattitude_Band_Value structure table.
 *
 * @private
 * @param {char} zoneLetter The MGRS zone to get the min northing for.
 * @return {number}
 */
function getMinNorthing(zoneLetter) {
  var northing;
  switch (zoneLetter) {
    case 'C':
      northing = 1100000.0;
      break;
    case 'D':
      northing = 2000000.0;
      break;
    case 'E':
      northing = 2800000.0;
      break;
    case 'F':
      northing = 3700000.0;
      break;
    case 'G':
      northing = 4600000.0;
      break;
    case 'H':
      northing = 5500000.0;
      break;
    case 'J':
      northing = 6400000.0;
      break;
    case 'K':
      northing = 7300000.0;
      break;
    case 'L':
      northing = 8200000.0;
      break;
    case 'M':
      northing = 9100000.0;
      break;
    case 'N':
      northing = 0.0;
      break;
    case 'P':
      northing = 800000.0;
      break;
    case 'Q':
      northing = 1700000.0;
      break;
    case 'R':
      northing = 2600000.0;
      break;
    case 'S':
      northing = 3500000.0;
      break;
    case 'T':
      northing = 4400000.0;
      break;
    case 'U':
      northing = 5300000.0;
      break;
    case 'V':
      northing = 6200000.0;
      break;
    case 'W':
      northing = 7000000.0;
      break;
    case 'X':
      northing = 7900000.0;
      break;
    default:
      northing = -1.0;
  }
  if (northing >= 0.0) {
    return northing;
  } else {
    throw "Invalid zone letter: " + zoneLetter;
  }
}

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Point = __webpack_require__(161);

module.exports = VectorTileFeature;

function VectorTileFeature(pbf, end, extent, keys, values) {
    // Public
    this.properties = {};
    this.extent = extent;
    this.type = 0;

    // Private
    this._pbf = pbf;
    this._geometry = -1;
    this._keys = keys;
    this._values = values;

    pbf.readFields(readFeature, this, end);
}

function readFeature(tag, feature, pbf) {
    if (tag == 1) feature.id = pbf.readVarint();else if (tag == 2) readTag(pbf, feature);else if (tag == 3) feature.type = pbf.readVarint();else if (tag == 4) feature._geometry = pbf.pos;
}

function readTag(pbf, feature) {
    var end = pbf.readVarint() + pbf.pos;

    while (pbf.pos < end) {
        var key = feature._keys[pbf.readVarint()],
            value = feature._values[pbf.readVarint()];
        feature.properties[key] = value;
    }
}

VectorTileFeature.types = ['Unknown', 'Point', 'LineString', 'Polygon'];

VectorTileFeature.prototype.loadGeometry = function () {
    var pbf = this._pbf;
    pbf.pos = this._geometry;

    var end = pbf.readVarint() + pbf.pos,
        cmd = 1,
        length = 0,
        x = 0,
        y = 0,
        lines = [],
        line;

    while (pbf.pos < end) {
        if (!length) {
            var cmdLen = pbf.readVarint();
            cmd = cmdLen & 0x7;
            length = cmdLen >> 3;
        }

        length--;

        if (cmd === 1 || cmd === 2) {
            x += pbf.readSVarint();
            y += pbf.readSVarint();

            if (cmd === 1) {
                // moveTo
                if (line) lines.push(line);
                line = [];
            }

            line.push(new Point(x, y));
        } else if (cmd === 7) {

            // Workaround for https://github.com/mapbox/mapnik-vector-tile/issues/90
            if (line) {
                line.push(line[0].clone()); // closePolygon
            }
        } else {
            throw new Error('unknown command ' + cmd);
        }
    }

    if (line) lines.push(line);

    return lines;
};

VectorTileFeature.prototype.bbox = function () {
    var pbf = this._pbf;
    pbf.pos = this._geometry;

    var end = pbf.readVarint() + pbf.pos,
        cmd = 1,
        length = 0,
        x = 0,
        y = 0,
        x1 = Infinity,
        x2 = -Infinity,
        y1 = Infinity,
        y2 = -Infinity;

    while (pbf.pos < end) {
        if (!length) {
            var cmdLen = pbf.readVarint();
            cmd = cmdLen & 0x7;
            length = cmdLen >> 3;
        }

        length--;

        if (cmd === 1 || cmd === 2) {
            x += pbf.readSVarint();
            y += pbf.readSVarint();
            if (x < x1) x1 = x;
            if (x > x2) x2 = x;
            if (y < y1) y1 = y;
            if (y > y2) y2 = y;
        } else if (cmd !== 7) {
            throw new Error('unknown command ' + cmd);
        }
    }

    return [x1, y1, x2, y2];
};

VectorTileFeature.prototype.toGeoJSON = function (x, y, z) {
    var size = this.extent * Math.pow(2, z),
        x0 = this.extent * x,
        y0 = this.extent * y,
        coords = this.loadGeometry(),
        type = VectorTileFeature.types[this.type],
        i,
        j;

    function project(line) {
        for (var j = 0; j < line.length; j++) {
            var p = line[j],
                y2 = 180 - (p.y + y0) * 360 / size;
            line[j] = [(p.x + x0) * 360 / size - 180, 360 / Math.PI * Math.atan(Math.exp(y2 * Math.PI / 180)) - 90];
        }
    }

    switch (this.type) {
        case 1:
            var points = [];
            for (i = 0; i < coords.length; i++) {
                points[i] = coords[i][0];
            }
            coords = points;
            project(coords);
            break;

        case 2:
            for (i = 0; i < coords.length; i++) {
                project(coords[i]);
            }
            break;

        case 3:
            coords = classifyRings(coords);
            for (i = 0; i < coords.length; i++) {
                for (j = 0; j < coords[i].length; j++) {
                    project(coords[i][j]);
                }
            }
            break;
    }

    if (coords.length === 1) {
        coords = coords[0];
    } else {
        type = 'Multi' + type;
    }

    var result = {
        type: "Feature",
        geometry: {
            type: type,
            coordinates: coords
        },
        properties: this.properties
    };

    if ('id' in this) {
        result.id = this.id;
    }

    return result;
};

// classifies an array of rings into polygons with outer rings and holes

function classifyRings(rings) {
    var len = rings.length;

    if (len <= 1) return [rings];

    var polygons = [],
        polygon,
        ccw;

    for (var i = 0; i < len; i++) {
        var area = signedArea(rings[i]);
        if (area === 0) continue;

        if (ccw === undefined) ccw = area < 0;

        if (ccw === area < 0) {
            if (polygon) polygons.push(polygon);
            polygon = [rings[i]];
        } else {
            polygon.push(rings[i]);
        }
    }
    if (polygon) polygons.push(polygon);

    return polygons;
}

function signedArea(ring) {
    var sum = 0;
    for (var i = 0, len = ring.length, j = len - 1, p1, p2; i < len; j = i++) {
        p1 = ring[i];
        p2 = ring[j];
        sum += (p2.x - p1.x) * (p1.y + p2.y);
    }
    return sum;
}

/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var VectorTileFeature = __webpack_require__(84);

module.exports = VectorTileLayer;

function VectorTileLayer(pbf, end) {
    // Public
    this.version = 1;
    this.name = null;
    this.extent = 4096;
    this.length = 0;

    // Private
    this._pbf = pbf;
    this._keys = [];
    this._values = [];
    this._features = [];

    pbf.readFields(readLayer, this, end);

    this.length = this._features.length;
}

function readLayer(tag, layer, pbf) {
    if (tag === 15) layer.version = pbf.readVarint();else if (tag === 1) layer.name = pbf.readString();else if (tag === 5) layer.extent = pbf.readVarint();else if (tag === 2) layer._features.push(pbf.pos);else if (tag === 3) layer._keys.push(pbf.readString());else if (tag === 4) layer._values.push(readValueMessage(pbf));
}

function readValueMessage(pbf) {
    var value = null,
        end = pbf.readVarint() + pbf.pos;

    while (pbf.pos < end) {
        var tag = pbf.readVarint() >> 3;

        value = tag === 1 ? pbf.readString() : tag === 2 ? pbf.readFloat() : tag === 3 ? pbf.readDouble() : tag === 4 ? pbf.readVarint64() : tag === 5 ? pbf.readVarint() : tag === 6 ? pbf.readSVarint() : tag === 7 ? pbf.readBoolean() : null;
    }

    return value;
}

// return feature `i` from this layer as a `VectorTileFeature`
VectorTileLayer.prototype.feature = function (i) {
    if (i < 0 || i >= this._features.length) throw new Error('feature index out of bounds');

    this._pbf.pos = this._features[i];

    var end = this._pbf.readVarint() + this._pbf.pos;
    return new VectorTileFeature(this._pbf, end, this.extent, this._keys, this._values);
};

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.LonLat
 * @classdesc  这个类用来表示经度和纬度对。
 * @param lon - {number} 地图单位上的X轴坐标，如果地图是地理投影，则此值是经度，否则，此值是地图地理位置的x坐标。
 * @param lat - {number} 地图单位上的Y轴坐标，如果地图是地理投影，则此值是纬度，否则，此值是地图地理位置的y坐标。
 * @param location - {Array<float>} [lon, lat]  如果要同时设置，则使用传入横纵坐标组成的数组。
 * @example
 * var lonLat = new SuperMap.LonLat(30,45);
 */
var LonLat = function () {

    /**
     * @member SuperMap.LonLat.prototype.lon  -{float}
     * @description 地图的单位的X轴（横轴）坐标，默认为0.0。
     */
    function LonLat(lon, lat) {
        _classCallCheck(this, LonLat);

        this.lon = 0.0;
        this.lat = 0.0;
        this.CLASS_NAME = "SuperMap.LonLat";

        if (_Util.Util.isArray(lon)) {
            lat = lon[1];
            lon = lon[0];
        }
        this.lon = lon ? _Util.Util.toFloat(lon) : this.lon;
        this.lat = lat ? _Util.Util.toFloat(lat) : this.lat;
    }

    /**
     * @function SuperMap.LonLat.prototype.toString
     * @description 返回此对象的字符串形式
     * @example
     * var lonLat = new SuperMap.LonLat(100,50);
     * var str = lonLat.toString();
     * @returns {string} 例如: "lon=100,lat=50"
     */


    /**
     * @member SuperMap.LonLat.prototype.lat  -{float}
     * @description 地图的单位的Y轴（纵轴）坐标，默认为0.0。
     */


    _createClass(LonLat, [{
        key: 'toString',
        value: function toString() {
            return "lon=" + this.lon + ",lat=" + this.lat;
        }

        /**
         * @function SuperMap.LonLat.prototype.toShortString
         * @description 将经度纬度转换成简单字符串。
         * @example
         * var lonLat = new SuperMap.LonLat(10050);
         * var str = lonLat.toShortString();
         * @returns {string} 返回处理后的经纬度字符串。例如："10050"
         */

    }, {
        key: 'toShortString',
        value: function toShortString() {
            return this.lon + "," + this.lat;
        }

        /**
         * @function SuperMap.LonLat.prototype.clone
         * @description 复制坐标对象，并返回复制后的新对象。
         * @example
         * var lonLat1 = new SuperMap.LonLat(10050);
         * var lonLat2 = lonLat1.clone();
         * @returns {SuperMap.LonLat}  返回相同坐标值的新的坐标对象。
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new LonLat(this.lon, this.lat);
        }

        /**
         * @function SuperMap.LonLat.prototype.add
         * @description 在已有坐标对象的经纬度基础上加上新的坐标经纬度，并返回新的坐标对象。
         * @example
         * var lonLat1 = new SuperMap.LonLat(10050);
         * //lonLat2 是新的对象
         * var lonLat2 = lonLat1.add(10050);
         *
         * @param lon - {float} 传入的精度参数。
         * @param lat - {float} 传入的纬度参数。
         * @returns {SuperMap.LonLat} 返回一个新的LonLat对象，此对象的经纬度是由传
         *      入的经纬度与当前的经纬度相加所得。
         */

    }, {
        key: 'add',
        value: function add(lon, lat) {
            if (lon == null || lat == null) {
                throw new TypeError('LonLat.add cannot receive null values');
            }
            return new LonLat(this.lon + _Util.Util.toFloat(lon), this.lat + _Util.Util.toFloat(lat));
        }

        /**
         * @function SuperMap.LonLat.prototype.equals
         * @description 判断两个坐标对象是否相等。
         * @example
         * var lonLat1 = new SuperMap.LonLat(10050);
         * var lonLat2 = new SuperMap.LonLat(10050);
         * var isEquals = lonLat1.equals(lonLat2);
         *
         * @param ll - {SuperMap.LonLat} 需要进行比较的坐标对象。
         * @returns {boolean} 如果LonLat对象的经纬度和传入的经纬度一致则返回true不一
         *      致或传入的ll参数为NULL则返回false。
         */

    }, {
        key: 'equals',
        value: function equals(ll) {
            var equals = false;
            if (ll != null) {
                equals = this.lon === ll.lon && this.lat === ll.lat || isNaN(this.lon) && isNaN(this.lat) && isNaN(ll.lon) && isNaN(ll.lat);
            }
            return equals;
        }

        /**
         * @function SuperMap.LonLat.prototype.wrapDateLine
         * @description 通过传入的范围对象对坐标对象转换到该范围内。
         * 如果经度小于给定范围最小精度，则在原经度基础上加上范围宽度，
         * 直到精度在范围内为止，如果经度大于给定范围则在原经度基础上减去范围宽度。
         * 换句话说就是将不在经度范围内的坐标转换到范围以内。
         *  （只会转换lon，不会转换lat，主要用于转移到日界线以内）
         * @example
         * var lonLat1 = new SuperMap.LonLat(42050);
         * var lonLat2 = lonLat1.wrapDateLine(
         *      new SuperMap.Bounds(-180-9018090)
         *  );
         *
         * @param maxExtent - {SuperMap.Bounds} 最大边界的范围。
         * @returns {SuperMap.LonLat} 将坐标转换到范围对象以内，并返回新的坐标。
         */

    }, {
        key: 'wrapDateLine',
        value: function wrapDateLine(maxExtent) {

            var newLonLat = this.clone();

            if (maxExtent) {
                //shift right?
                while (newLonLat.lon < maxExtent.left) {
                    newLonLat.lon += maxExtent.getWidth();
                }

                //shift left?
                while (newLonLat.lon > maxExtent.right) {
                    newLonLat.lon -= maxExtent.getWidth();
                }
            }

            return newLonLat;
        }

        /**
         *
         * @function SuperMap.LonLat.prototype.destroy
         * @description 销毁此对象。
         * 销毁后此对象的所有属性为null，而不是初始值。
         * @example
         * var lonLat = new SuperMap.LonLat(10050);
         * lonLat.destroy();
         */

    }, {
        key: 'destroy',
        value: function destroy() {
            this.lon = null;
            this.lat = null;
        }

        /**
         * @function SuperMap.LonLat.fromString
         * @description 通过字符串生成一个<SuperMap.LonLat>对象
         * @example
         * var str = "10050";
         * var lonLat = SuperMap.LonLat.fromString(str);
         *
         * @param str - {string} 字符串的格式：Lon+""+Lat。如："10050"
         * @returns {SuperMap.LonLat} 返回一个 <SuperMap.LonLat> 对象
         */

    }], [{
        key: 'fromString',
        value: function fromString(str) {
            var pair = str.split(",");
            return new LonLat(pair[0], pair[1]);
        }

        /**
         * @function SuperMap.LonLat.fromArray
         * @description 通过数组生成一个<SuperMap.LonLat>对象
         * @param arr - {Array<float>} 数组的格式，长度只能为2：[LonLat]。如： [5-42]
         * @returns {SuperMap.LonLat} 返回一个 <SuperMap.LonLat> 对象
         */

    }, {
        key: 'fromArray',
        value: function fromArray(arr) {
            var gotArr = _Util.Util.isArray(arr),
                lon = gotArr && arr[0],
                lat = gotArr && arr[1];
            return new LonLat(lon, lat);
        }
    }]);

    return LonLat;
}();

exports["default"] = LonLat;

_SuperMap2["default"].LonLat = LonLat;

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Feature2 = __webpack_require__(47);

var _Feature3 = _interopRequireDefault(_Feature2);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// TRASH THIS
_SuperMap2["default"].State = {
    /** states */
    UNKNOWN: 'Unknown',
    INSERT: 'Insert',
    UPDATE: 'Update',
    DELETE: 'Delete'
};

/**
 * @class SuperMap.Feature.Vector
 * @classdesc 矢量要素类。该类具有 Geometry 属性存放几何信息，attributes 属性存放非几何信息，另外还包含了 style 属性，
 *             用来定义矢量要素的样式，其中，默认的样式在 <SuperMap.Feature.Vector.style> 类中定义，如果没有特别的指定将使用默认的样式。
 * @extends SuperMap.Feature
 * @param geometry - {SuperMap.Geometry} 代表要素的几何形状。
 * @param attributes - {Object} 描述要素的任意的可序列化属性，将要映射到 attributes 属性中的可选对象。
 * @param style - {Object} 一个可选的样式对象。
 * @example
 * var geometry = new SuperMap.Geometry.Point(-115,10);
 *  var style = {
     *      strokeColor:"#339933",
     *      strokeOpacity:1,
     *      strokeWidth:3,
     *      pointRadius:6
     *  }
 *  var pointFeature = new SuperMap.Feature.Vector(geometry,null,style);
 *  vectorLayer.addFeatures(pointFeature);
 */

var Vector = function (_Feature) {
    _inherits(Vector, _Feature);

    /**
     * @member SuperMap.Feature.Vector.prototype.renderIntent - {string}
     * @description Feature要素即被被渲染的样式状态，对应StyleMap中的状态定义的可选值。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.style - {Object}
     * @description 要素的样式属性，地图查询返回的feature的style，8C变为null。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.bounds - {SuperMap.Bounds}
     * @description 要素的Bounds范围。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.geometry - {SuperMap.Geometry}
     * @description 该属性用于存放几何信息。
     */
    function Vector(geometry, attributes, style) {
        _classCallCheck(this, Vector);

        var _this = _possibleConstructorReturn(this, (Vector.__proto__ || Object.getPrototypeOf(Vector)).call(this, null, null, attributes));

        _this.fid = null;
        _this.geometry = null;
        _this.attributes = null;
        _this.bounds = null;
        _this.state = null;
        _this.style = null;
        _this.url = null;
        _this.renderIntent = "default";
        _this.modified = null;
        _this.CLASS_NAME = "SuperMap.Feature.Vector";

        _this.lonlat = null;
        _this.geometry = geometry ? geometry : null;
        _this.state = null;
        _this.attributes = {};
        if (attributes) {
            _this.attributes = _Util.Util.extend(_this.attributes, attributes);
        }
        _this.style = style ? style : null;
        return _this;
    }

    /**
     * @function SuperMap.Feature.Vector.prototype.destroy
     * @description 释放相关资源。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.modified - {Object}
     * @description 一个具有可以被改变的原始几何形状和属性，被 <SuperMap.Control.ModifyFeature> 写入。
     * 应用程序可以在attributes中设置原始的能被修改的属性，需要注意的是，应用程序需要在使用某个对象及其属
     * 性前检测这个对象及其 attributes 属性是否创建，用 ModifyFeature改变之后，这个对象如下所示：
     * @example
     * {
     *     geometry: Object
     * }
     *
     * 当应用程序需要对要素的 attributes 进行修改，则需要如下设置 attributes：
     * @example
     * {
     *     attributes: {
     *         myAttribute: "original"
     *     }
     * }
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.url - {string}
     * @description 如果设置了这个属性，在更新或者删除要素时需要考虑 <SuperMap.HTTP> 。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.state - {string}
     * @description state
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.attributes - {Object}
     * @description 描述要素的任意的可序列化属性。
     */


    /**
     * @member SuperMap.Feature.Vector.prototype.fid - {string}
     * @description fid
     */


    _createClass(Vector, [{
        key: 'destroy',
        value: function destroy() {
            if (this.layer) {
                this.layer.removeFeatures(this);
                this.layer = null;
            }

            this.geometry = null;
            this.modified = null;
            _get(Vector.prototype.__proto__ || Object.getPrototypeOf(Vector.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.clone
         * @description 克隆对象。
         * @returns {SuperMap.Feature.Vector} 克隆的SuperMap.Feature.Vector对象。
         */

    }, {
        key: 'clone',
        value: function clone() {
            return new Vector(this.geometry ? this.geometry.clone() : null, this.attributes, this.style);
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.onScreen
         * @description 判断要素是否在地图视图范围内。
         * @param boundsOnly - {boolean} 要素的bounds范围是否与地图的视图范围相交。
         * @returns {boolean} 要素是否在地图视图范围内。
         */

    }, {
        key: 'onScreen',
        value: function onScreen(boundsOnly) {
            var onScreen = false;
            if (this.layer && this.layer.map) {
                var screenBounds = this.layer.map.getExtent();
                if (boundsOnly) {
                    var featureBounds = this.geometry.getBounds();
                    onScreen = screenBounds.intersectsBounds(featureBounds);
                } else {
                    var screenPoly = screenBounds.toGeometry();
                    onScreen = screenPoly.intersects(this.geometry);
                }
            }
            return onScreen;
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.getVisibility
         * @description 判断要素是否可见。
         * @returns {boolean} 要素是否可见。
         */

    }, {
        key: 'getVisibility',
        value: function getVisibility() {
            return !(this.style && this.style.display === 'none' || !this.layer || this.layer && this.layer.styleMap && this.layer.styleMap.createSymbolizer(this, this.renderIntent).display === 'none' || this.layer && !this.layer.getVisibility());
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.createMarker
         * @description HACK - 需要判断是否所有的矢量要素能创建标记。
         * @returns {SuperMap.Marker} 当前返回null。
         */

    }, {
        key: 'createMarker',
        value: function createMarker() {
            return null;
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.destroyMarker
         * @description HACK - 需要判断是否所有的矢量要素能销毁标记。当前不做任何操作。
         */

    }, {
        key: 'destroyMarker',
        value: function destroyMarker() {}
        // pass


        /**
         * @function SuperMap.Feature.Vector.prototype.createPopup
         * @description HACK - 需要判断是否所有的矢量要素能创建弹出窗口。
         * @returns {SuperMap.Popup} 当前返回null。
         */

    }, {
        key: 'createPopup',
        value: function createPopup() {
            return null;
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.atPoint
         * @description 判断是否要素与制定的位置点相交。
         * @param lonlat - {SuperMap.LonLat}
         * @param toleranceLon - {float} 经度。
         * @param toleranceLat - {float} 维度。
         * @returns {boolean} 是否要素与制定的位置点相交。
         */

    }, {
        key: 'atPoint',
        value: function atPoint(lonlat, toleranceLon, toleranceLat) {
            var atPoint = false;
            if (this.geometry) {
                atPoint = this.geometry.atPoint(lonlat, toleranceLon, toleranceLat);
            }
            return atPoint;
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.destroyPopup
         * @description HACK - 需要判断是否所有的矢量要素能销毁弹出窗口。
         */

    }, {
        key: 'destroyPopup',
        value: function destroyPopup() {}
        // pass


        /**
         * @function SuperMap.Feature.Vector.prototype.move
         * @description 移动要素并在新位置重绘要素。
         * @param location - {SuperMap.LonLat|SuperMap.Pixel} 移动到的新位置点。
         */

    }, {
        key: 'move',
        value: function move(location) {

            if (!this.layer || !this.geometry.move) {
                //do nothing if no layer or immoveable geometry
                return undefined;
            }

            var pixel;
            if (location.CLASS_NAME === "SuperMap.LonLat") {
                pixel = this.layer.getViewPortPxFromLonLat(location);
            } else {
                pixel = location;
            }

            var lastPixel = this.layer.getViewPortPxFromLonLat(this.geometry.getBounds().getCenterLonLat());
            var res = this.layer.map.getResolution();
            this.geometry.move(res * (pixel.x - lastPixel.x), res * (lastPixel.y - pixel.y));
            this.layer.drawFeature(this);
            return lastPixel;
        }

        /**
         * @function SuperMap.Feature.Vector.prototype.toState
         * @description 设置新状态。
         * @param state - {string} 状态。
         */

    }, {
        key: 'toState',
        value: function toState(state) {
            if (state === _SuperMap2["default"].State.UPDATE) {
                switch (this.state) {
                    case _SuperMap2["default"].State.UNKNOWN:
                    case _SuperMap2["default"].State.DELETE:
                        this.state = state;
                        break;
                    case _SuperMap2["default"].State.UPDATE:
                    case _SuperMap2["default"].State.INSERT:
                        break;
                }
            } else if (state === _SuperMap2["default"].State.INSERT) {
                switch (this.state) {
                    case _SuperMap2["default"].State.UNKNOWN:
                        break;
                    default:
                        this.state = state;
                        break;
                }
            } else if (state === _SuperMap2["default"].State.DELETE) {
                switch (this.state) {
                    case _SuperMap2["default"].State.INSERT:
                        // the feature should be destroyed
                        break;
                    case _SuperMap2["default"].State.DELETE:
                        break;
                    case _SuperMap2["default"].State.UNKNOWN:
                    case _SuperMap2["default"].State.UPDATE:
                        this.state = state;
                        break;
                }
            } else if (state === _SuperMap2["default"].State.UNKNOWN) {
                this.state = state;
            }
        }

        /**
         * @member SuperMap.Feature.Vector.style
         * @description SuperMap.features有大量的样式属性，如果没有特别的指定将使用默认的样式，大部分样式通过SVG标准定义属性。
         * - fill properties资料介绍: {@link http://www.w3.org/TR/SVG/painting.html#FillProperties}
         * - stroke properties资料介绍: {@link http://www.w3.org/TR/SVG/painting.html#StrokeProperties}
         *
         *  fill - {boolean} 不需要填充则设置为false。<br>
         *  fillColor - {string} 十六进制填充颜色，默认为"#ee9900"。<br>
         *  fillOpacity - {number} 填充不透明度。默认为0.4。<br>
         *  stroke - {boolean} 不需要描边则设为false。<br>
         *  strokeColor - {string} 十六进制描边颜色。<br>
         *  strokeOpacity - {number} 描边的不透明度(0-1)默认为0.4。<br>
         *  strokeWidth - {number} 像素描边宽度，默认为1。<br>
         *  strokeLinecap - {string} strokeLinecap有三种类型butt，round，square，默认为"round"。<br>
         *  strokeDashstyle - {string} 有dotdashdashotlongdashlongdashdotsolid几种样式，默认为"solid"。<br>
         *  graphic - {boolean} 不需要则设置为false。<br>
         *  pointRadius - {number} 像素点半径，默认为6。<br>
         *  pointerEvents - {string}  默认为"visiblePainted"。<br>
         *  cursor - {string} 默认为""。<br>
         *  allowRotate -{string} 是否允许图标随着运行方向旋转，默认为false。用于时空数据图层。<br>
         *  externalGraphic - {string} 连接到用来渲染点的外部的图形。<br>
         *  graphicWidth - {number} 外部图表的像素宽度。<br>
         *  graphicHeight - {number} 外部图表的高宽度。<br>
         *  graphicOpacity - {number} 外部图表的不透明度(0-1)。<br>
         *  graphicXOffset - {number} 外部图表沿着x方向的偏移量。<br>
         *  graphicYOffset - {number} 外部图表沿着y方向的偏移量Pixel。<br>
         *  rotation - {number} 一个图表沿着其中心点（或者偏移中心指定点）在顺时针方向旋转。<br>
         *  graphicZIndex - {number} 渲染时使用的索引值。The integer z-index value to use in rendering。<br>
         *  graphicName - {string} 渲染点时图标使用的名字。支持"circle"  "square" "star" "x" "cross" "triangle"。默认为"circle"。<br>
         *  graphicTitle - {string} 外部图表的提示框。<br>
         *  backgroundGraphic - {string} 外部图表的背景。<br>
         *  backgroundGraphicZIndex - {number} 背景图渲染时使用的索引值。<br>
         *  backgroundXOffset - {number} 背景图在x轴的偏移量。<br>
         *  backgroundYOffset - {number} 背景图在x轴的偏移量。<br>
         *  backgroundHeight - {number} 背景图的高度。如果没有设置，将用graphicHeight。<br>
         *  backgroundWidth - {number} 背景图的宽度。如果没有设置，将用graphicWidth。<br>
         *  isUnicode - {boolean} 这个属性要配合label属性来用，当为true时，label就可以使用unicode编码，比如"a"的unicode十六进制编码为61，则label属性可以为"&#x61;"其中"&#"为前缀，标志这个为unicode编码，
         *  "x"是指16进制这时页面显示的是"a"；当此值为false的时候，label的内容会被直接输出，比如，label为"&#x61;"，这时页面显示的也是"&#x61;"。默认为false。<br>
         *  label - {string} 可选的标签文本。<br>
         *  labelAlign - {string} 标签对齐，是由两个字符组成的字符串，如："lt" "cm" "rb"，其中第一个字符代表水平方向上的对齐，"l"=left "c"=center "r"=right；第二个字符代表垂直方向上的对齐，"t"=top "m"=middle "b"=bottom。<br>
         *  labelXOffset - {number} 标签在x轴方向的偏移量。<br>
         *  labelYOffset - {number} 标签在y轴方向的偏移量。<br>
         *  labelSelect - {boolean} 如果设为true，标签可以选用SelectFeature或者similar控件，默认为false。<br>
         *  fontColor - {string} 标签字体颜色。<br>
         *  fontOpacity - {number} 标签透明度 (0-1)。<br>
         *  fontFamily - {string} 标签的字体类型。<br>
         *  fontSize - {string} 标签的字体大小。<br>
         *  fontStyle - {string} 标签的字体样式。<br>
         *  fontWeight - {string} 标签的字体粗细。<br>
         *  display - {string} 如果display属性设置为"none"，符号将没有任何效果。
         * @example
         *  // label的用法如下：
         *  function addGeoTest(){
         *  var geometry = new SuperMap.Geometry.Point(105 35);
         *  var pointFeature = new SuperMap.Feature.Vector(geometry);
         *  var styleTest = {
         *        label:"supermap"
         *        fontColor:"#0000ff"
         *        fontOpacity:"0.5"
         *        fontFamily:"隶书"
         *        fontSize:"8em"
         *        fontWeight:"bold"
         *        fontStyle:"italic"
         *        labelSelect:"true"
         *     }
         *           pointFeature.style = styleTest;
         *          vectorLayer.addFeatures([pointFeature]);
         * }
         */

    }]);

    return Vector;
}(_Feature3["default"]);

Vector.style = {
    'default': {
        fillColor: "#ee9900",
        fillOpacity: 0.4,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "#ee9900",
        strokeOpacity: 1,
        strokeWidth: 1,
        strokeLinecap: "round",
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        cursor: "inherit",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3
    },
    'select': {
        fillColor: "blue",
        fillOpacity: 0.4,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "blue",
        strokeOpacity: 1,
        strokeWidth: 2,
        strokeLinecap: "round",
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        cursor: "pointer",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3

    },
    'temporary': {
        fillColor: "#66cccc",
        fillOpacity: 0.2,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "#66cccc",
        strokeOpacity: 1,
        strokeLinecap: "round",
        strokeWidth: 2,
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        //cursor:"inherit",
        cursor: "default",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3

    },
    'delete': {
        display: "none"
    }
};
exports["default"] = Vector;

_SuperMap2["default"].Feature.Vector = Vector;

/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(20);

var _Collection3 = _interopRequireDefault(_Collection2);

var _LineString = __webpack_require__(25);

var _LineString2 = _interopRequireDefault(_LineString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiLineString
 * @classdesc 几何对象多线类。
 * @extends {SuperMap.Geometry.Collection}
 * @param components - {Array<SuperMap.Geometry.LineString>} LineString数组。
 * @example
 * var multi = new SuperMap.Geometry.MultiLineString([
 *      new SuperMap.Geometry.LineString([
 *          new SuperMap.Geometry.Point(1, 0),
 *          new SuperMap.Geometry.Point(0, 1)
 *      ])
 *  ]);
 */
var MultiLineString = function (_Collection) {
    _inherits(MultiLineString, _Collection);

    function MultiLineString(components) {
        _classCallCheck(this, MultiLineString);

        var _this = _possibleConstructorReturn(this, (MultiLineString.__proto__ || Object.getPrototypeOf(MultiLineString)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.LineString"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiLineString";
        return _this;
    }

    /**
     * @function SuperMap.Geometry.MultiLineString.prototype.split
     * @description 用几何对象去分割另一个几何对象。
     * @param geometry - {SuperMap.Geometry} 目标几何对象。
     * @param options - {Object} 可选参数。<br>
     *         mutual - {boolean} Split the source geometry in addition to the target
     *                   geometry.  Default is false.<br>
     *         edge - {boolean} 是否只当与边界相交的时候才进行分割。默认是true。如果为false则在容差范围内相交被分割。
     *         tolerance - {number} 容差。
     * @returns {Array} 被分割的几何对象数组。
     */


    /**
     * @member SuperMap.Geometry.MultiLineString.prototype.componentTypes - {Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.LineString}"]
     */


    _createClass(MultiLineString, [{
        key: 'split',
        value: function split(geometry, options) {
            var results = null;
            var mutual = options && options.mutual;
            var splits, sourceLine, sourceLines, sourceSplit, targetSplit;
            var sourceParts = [];
            var targetParts = [geometry];
            for (var i = 0, len = this.components.length; i < len; ++i) {
                sourceLine = this.components[i];
                sourceSplit = false;
                for (var j = 0; j < targetParts.length; ++j) {
                    splits = sourceLine.split(targetParts[j], options);
                    if (splits) {
                        if (mutual) {
                            sourceLines = splits[0];
                            for (var k = 0, klen = sourceLines.length; k < klen; ++k) {
                                if (k === 0 && sourceParts.length) {
                                    sourceParts[sourceParts.length - 1].addComponent(sourceLines[k]);
                                } else {
                                    sourceParts.push(new MultiLineString([sourceLines[k]]));
                                }
                            }
                            sourceSplit = true;
                            splits = splits[1];
                        }
                        if (splits.length) {
                            // splice in new target parts
                            splits.unshift(j, 1);
                            Array.prototype.splice.apply(targetParts, splits);
                            break;
                        }
                    }
                }
                if (!sourceSplit) {
                    // source line was not hit
                    if (sourceParts.length) {
                        // add line to existing multi
                        sourceParts[sourceParts.length - 1].addComponent(sourceLine.clone());
                    } else {
                        // create a fresh multi
                        sourceParts = [new MultiLineString(sourceLine.clone())];
                    }
                }
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceSplit || targetSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }

        /**
         * @function SuperMap.Geometry.MultiLineString.prototype.splitWith
         * @description 用几何对象去分割另一个几何对象。
         * @param geometry - {SuperMap.Geometry} 目标几何对象。
         * @param options - {Object} 可选参数。<br>
         *         mutual - {boolean} Split the source geometry in addition to the target
         *                   geometry.  Default is false.<br>
         *         edge - {boolean} 是否只当与边界相交的时候才进行分割。默认是true。如果为false则在容差范围内相交被分割。
         *         tolerance - {number} 容差。
         * @returns {Array} 被分割的几何对象数组。
         */

    }, {
        key: 'splitWith',
        value: function splitWith(geometry, options) {
            var results = null;
            var mutual = options && options.mutual;
            var splits, targetLine, sourceLines, sourceSplit, targetSplit, sourceParts, targetParts;
            if (geometry instanceof _LineString2["default"]) {
                targetParts = [];
                sourceParts = [geometry];
                for (var i = 0, len = this.components.length; i < len; ++i) {
                    targetSplit = false;
                    targetLine = this.components[i];
                    for (var j = 0; j < sourceParts.length; ++j) {
                        splits = sourceParts[j].split(targetLine, options);
                        if (splits) {
                            if (mutual) {
                                sourceLines = splits[0];
                                if (sourceLines.length) {
                                    // splice in new source parts
                                    sourceLines.unshift(j, 1);
                                    Array.prototype.splice.apply(sourceParts, sourceLines);
                                    j += sourceLines.length - 2;
                                }
                                splits = splits[1];
                                if (splits.length === 0) {
                                    splits = [targetLine.clone()];
                                }
                            }
                            for (var k = 0, klen = splits.length; k < klen; ++k) {
                                if (k === 0 && targetParts.length) {
                                    targetParts[targetParts.length - 1].addComponent(splits[k]);
                                } else {
                                    targetParts.push(new MultiLineString([splits[k]]));
                                }
                            }
                            targetSplit = true;
                        }
                    }
                    if (!targetSplit) {
                        // target component was not hit
                        if (targetParts.length) {
                            // add it to any existing multi-line
                            targetParts[targetParts.length - 1].addComponent(targetLine.clone());
                        } else {
                            // or start with a fresh multi-line
                            targetParts = [new MultiLineString([targetLine.clone()])];
                        }
                    }
                }
            } else {
                results = geometry.split(this);
            }
            if (sourceParts && sourceParts.length > 1) {
                sourceSplit = true;
            } else {
                sourceParts = [];
            }
            if (targetParts && targetParts.length > 1) {
                targetSplit = true;
            } else {
                targetParts = [];
            }
            if (sourceSplit || targetSplit) {
                if (mutual) {
                    results = [sourceParts, targetParts];
                } else {
                    results = targetParts;
                }
            }
            return results;
        }
    }]);

    return MultiLineString;
}(_Collection3["default"]);

exports["default"] = MultiLineString;

_SuperMap2["default"].Geometry.MultiLineString = MultiLineString;

/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Collection2 = __webpack_require__(20);

var _Collection3 = _interopRequireDefault(_Collection2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Geometry.MultiPolygon
 * @classdesc 几何对象多多边形类。
 * @extends {SuperMap.Geometry.Collection}
 * @param  components - {Array<SuperMap.Geometry.Polygon>} 形成 MultiPolygon 的多边形数组。
 * @example
 * var points1 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0)];
 * var points2 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0),new SuperMap.Geometry.Point(3,3),new SuperMap.Geometry.Point(10,10)];
 *
 * var linearRing1 = new SuperMap.Geometry.LinearRing(points1);
 * var linearRing2 = new SuperMap.Geometry.LinearRing(points2);
 *
 * var polygon1 = new SuperMap.Geometry.Polygon([linearRing1]);
 * var polygon2 = new SuperMap.Geometry.Polygon([linearRing2]);
 *
 * var multiPolygon1 = new SuperMap.Geometry.MultiPolygon([polygon1,polygon2]);
 */
var MultiPolygon = function (_Collection) {
    _inherits(MultiPolygon, _Collection);

    function MultiPolygon(components) {
        _classCallCheck(this, MultiPolygon);

        var _this = _possibleConstructorReturn(this, (MultiPolygon.__proto__ || Object.getPrototypeOf(MultiPolygon)).call(this, components));

        _this.componentTypes = ["SuperMap.Geometry.Polygon"];
        _this.CLASS_NAME = "SuperMap.Geometry.MultiPolygon";
        return _this;
    }

    /**
     * @member SuperMap.Geometry.MultiPolygon.prototype.componentTypes -{Array<string>}
     * @description components存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     * @default ["{@link SuperMap.Geometry.Polygon}"]
     */


    return MultiPolygon;
}(_Collection3["default"]);

exports["default"] = MultiPolygon;

_SuperMap2["default"].Geometry.MultiPolygon = MultiPolygon;

/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.Format
 * @classdesc 读写各种格式的格式类基类。其子类应该包含并实现read和write方法。
 * @param options - {Object} 可选参数。<br>
 *        keepData - {boolean} 如果设置为true， data属性会指向被解析的对象（例如json或xml数据对象）。
 */
var Format = function () {

    /**
     * @member SuperMap.Format.prototype.data - {Object}
     * @description 当 <keepData> 属性设置为true，这是传递给<read>操作的要被解析的字符串。
     */
    function Format(options) {
        _classCallCheck(this, Format);

        this.options = null;
        this.data = null;
        this.keepData = false;
        this.CLASS_NAME = "SuperMap.Format";

        _SuperMap2["default"].Util.extend(this, options);
        this.options = options;
    }

    /**
     * @function SuperMap.Format.prototype.destroy
     * @description 销毁该格式类，释放相关资源。
     */


    /**
     * APIProperty: keepData
     * @member SuperMap.Format.prototype.keepData - {Object}
     * @description 保持最近读到的数据的引用（通过 <data> 属性）。默认值是false。
     */


    /**
     * @member SuperMap.Format.prototype.options - {Object}
     * @description 可选参数。
     */


    _createClass(Format, [{
        key: "destroy",
        value: function destroy() {}
        //用来销毁该格式类，释放相关资源


        /**
         * @function SuperMap.Format.prototype.read
         * @description 来从字符串中读取数据。
         * @param data - {string} 读取的数据。
         */

    }, {
        key: "read",
        value: function read(data) {}
        //用来从字符串中读取数据


        /**
         * @function SuperMap.Format.prototype.write
         * @description 将对象写成字符串。
         * @param object - {Object} 可序列化的对象。
         * @return {string} 对象被写成字符串。
         */

    }, {
        key: "write",
        value: function write(object) {
            //用来写字符串
        }
    }]);

    return Format;
}();

exports["default"] = Format;

_SuperMap2["default"].Format = Format;

/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _BufferSetting = __webpack_require__(189);

var _BufferSetting2 = _interopRequireDefault(_BufferSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.BufferAnalystParameters
 * @classdesc 缓冲区分析参数基类。
 * @param options - {Object} 参数。如:</br>
 *        bufferSetting - {@link SuperMap.BufferSetting} 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
 */
var BufferAnalystParameters = function () {
    function BufferAnalystParameters(options) {
        _classCallCheck(this, BufferAnalystParameters);

        this.bufferSetting = null;
        this.CLASS_NAME = "SuperMap.BufferAnalystParameters";

        var me = this;
        me.bufferSetting = new _BufferSetting2["default"]();
        if (!options) {
            return;
        }
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     * @function SuperMap.BufferAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */

    /**
     * @member SuperMap.BufferAnalystParameters.prototype.bufferSetting - {SuperMap.BufferSetting}
     * @description 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
     */


    _createClass(BufferAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            if (me.bufferSetting) {
                me.bufferSetting.destroy();
                me.bufferSetting = null;
            }
        }
    }]);

    return BufferAnalystParameters;
}();

exports["default"] = BufferAnalystParameters;

_SuperMap2["default"].BufferAnalystParameters = BufferAnalystParameters;

/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.OverlayAnalystParameters
 * @classdesc 叠加分析参数基类，数据集叠加分析参数和几何对象叠加分析参数均继承此基类
 * @param options - {Object} 叠加分析参数。
 */
var OverlayAnalystParameters = function () {
    function OverlayAnalystParameters(options) {
        _classCallCheck(this, OverlayAnalystParameters);

        this.operation = _REST.OverlayOperationType.UNION;
        this.CLASS_NAME = "SuperMap.OverlayAnalystParameters";

        var me = this;
        if (options) {
            _SuperMap2["default"].Util.extend(me, options);
        }
    }

    /**
     * @function SuperMap.OverlayAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.OverlayAnalystParameters.prototype.operation -{SuperMap.OverlayOperationType}
     * @description 指定叠加分析操作类型。
     */


    _createClass(OverlayAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.operation = null;
        }
    }]);

    return OverlayAnalystParameters;
}();

exports["default"] = OverlayAnalystParameters;

_SuperMap2["default"].OverlayAnalystParameters = OverlayAnalystParameters;

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Vector = __webpack_require__(87);

var _Vector2 = _interopRequireDefault(_Vector);

var _ServerGeometry = __webpack_require__(8);

var _ServerGeometry2 = _interopRequireDefault(_ServerGeometry);

var _Util = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class SuperMap.ServerFeature
 * 服务端矢量要素类。
 * 该类描述了服务端返回的矢量要素的相关信息，包括字段和几何信息。
 */
var ServerFeature = function () {

    /*
     * Constructor: SuperMap.ServerFeature
     * 服务端矢量要素类构造函数。
     *
     * Parameters:
     * options - {Object} 参数。
     *
     * Allowed options properties:
     * fieldNames - {Array(String)} 矢量要素的属性字段名集合。
     * fieldValues - {Array(String)} 矢量要素的属性字段值集合。
     * geometry - {<SuperMap.ServerGeometry>} 矢量要素的几何信息。
     */


    /*
     * APIProperty: fieldValues
     * {Array(String)} 矢量要素的属性字段值集合。
     */
    function ServerFeature(options) {
        _classCallCheck(this, ServerFeature);

        this.fieldNames = null;
        this.fieldValues = null;
        this.geometry = null;
        this.CLASS_NAME = "SuperMap.ServerFeature";

        if (options) {
            _Util.Util.extend(this, options);
        }
    }

    /*
     * @function SuperMap.ServerFeature.prototype.destroy
     * APIMethod: destroy
     * 释放资源，将引用资源的属性置空。
     */


    /*
     * APIProperty: geometry
     * {<SuperMap.ServerGeometry>} 矢量要素的几何信息。
     */


    /*
     * APIProperty: fieldNames
     * {Array(String)} 矢量要素的属性字段名集合。
     */


    _createClass(ServerFeature, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.fieldNames = null;
            me.fieldValues = null;
            if (me.geometry) {
                me.geometry.destroy();
                me.geometry = null;
            }
        }

        /*
         * APIMethod: toFeature
         * 将服务端矢量要素 ServerFeature 转换为客户端矢量要素 Feature。
         *
         * Returns
         * {<Vector>} 转换后的客户端矢量要素。
         */

    }, {
        key: 'toFeature',
        value: function toFeature() {
            var names,
                values,
                geo,
                attr = {},
                me = this,
                feature;

            names = me.fieldNames;
            values = me.fieldValues;
            for (var i in names) {
                attr[names[i]] = values[i];
            }
            if (me.geometry) {
                geo = me.geometry.toGeometry();
            }
            feature = new _Vector2["default"](geo, attr);
            if (me.geometry && me.geometry.id) feature.fid = me.geometry.id;

            return feature;
        }

        /*
         * Function: SuperMap.ServerFeature.fromJson
         * 将 JSON 对象表示服务端矢量要素转换为 ServerFeature
         *
         * Parameters:
         * jsonObject - {Object} 要转换的 JSON 对象。
         *
         * Returns:
         * {SuperMap.ServerFeature} 转化后的 ServerFeature 对象。
         */

    }], [{
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            var me = this,
                geo = null;
            if (!jsonObject) {
                return;
            }
            geo = jsonObject.geometry;
            if (geo) {
                geo = _ServerGeometry2["default"].fromJson(geo);
            }
            return new _SuperMap2["default"].ServerFeature({
                fieldNames: jsonObject.fieldNames,
                fieldValues: jsonObject.fieldValues,
                geometry: geo
            });
        }
    }]);

    return ServerFeature;
}();

exports["default"] = ServerFeature;


_SuperMap2["default"].ServerFeature = ServerFeature;

/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _DataReturnOption = __webpack_require__(34);

var _DataReturnOption2 = _interopRequireDefault(_DataReturnOption);

var _REST = __webpack_require__(2);

var _SurfaceAnalystParametersSetting = __webpack_require__(313);

var _SurfaceAnalystParametersSetting2 = _interopRequireDefault(_SurfaceAnalystParametersSetting);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.SurfaceAnalystParameters
 * @classdesc 表面分析提取操作参数类。
 * @description 通过该类可以为进行表面分析提供参数信息，包括表面分析的方法提取等值线、提取等值面和中间结果的分辨率，
 * {@link SuperMap.DatasetSurfaceAnalystParameters} 和 {@link SuperMap.GeometrySurfaceAnalystParameters} 继承自该类。
 * @param options - {Object} 可选参数。如:</br>
 *        extractParameter - {{@link SuperMap.SurfaceAnalystParametersSetting}} 获取或设置表面分析参数。</br>
 *        resolution - {number}指定中间结果（栅格数据集）的分辨率。</br>
 *        resultSetting - {{@link SuperMap.DataReturnOption}} 结果返回设置类。</br>
 *        surfaceAnalystMethod - {{@link SuperMap.SurfaceAnalystMethod}} 获取或设置表面分析的提取方法，提取等值线和提取等值面。</br>
 */
var SurfaceAnalystParameters = function () {

    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.resultSetting -{SuperMap.DataReturnOption}
     * @description 结果返回设置类。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.resolution -{number}
     * @description 获取或设置指定中间结果（栅格数据集）的分辨率。
     */
    function SurfaceAnalystParameters(options) {
        _classCallCheck(this, SurfaceAnalystParameters);

        this.resolution = 0;
        this.extractParameter = null;
        this.resultSetting = null;
        this.surfaceAnalystMethod = _REST.SurfaceAnalystMethod.ISOLINE;
        this.CLASS_NAME = "SuperMap.SurfaceAnalystParameters";

        var me = this;
        me.extractParameter = new _SurfaceAnalystParametersSetting2["default"]();
        me.resultSetting = new _DataReturnOption2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(this, options);
        }
    }

    /**
     * @function SuperMap.SurfaceAnalystParameters.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.surfaceAnalystMethod -{SuperMap.SurfaceAnalystMethod}
     * @description 获取或设置表面分析的提取方法，提取等值线和提取等值面，默认为等值线分析。
     */


    /**
     * @member SuperMap.SurfaceAnalystParameters.prototype.extractParameter -{SuperMap.SurfaceAnalystParametersSetting}
     * @description 获取或设置表面分析参数。
     * 在进行点数据集进行提取等值面分析时，暂时不支持 SurfaceAnalystParametersSetting 类中的 expectedZValues 字段。
     */


    _createClass(SurfaceAnalystParameters, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.resolution = null;
            if (me.extractParameter) {
                me.extractParameter.destroy();
                me.extractParameter = null;
            }
            if (me.resultSetting) {
                me.resultSetting.destroy();
                me.resultSetting = null;
            }
            me.surfaceAnalystMethod = null;
        }
    }]);

    return SurfaceAnalystParameters;
}();

exports["default"] = SurfaceAnalystParameters;

_SuperMap2["default"].SurfaceAnalystParameters = SurfaceAnalystParameters;

/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ServerStyle = __webpack_require__(11);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeDotDensity
 * @classdesc 点密度专题图。<br>
 * @description
 *              点密度专题图用一定大小、形状相同的点表示现象分布范围、数量特征和分布密度。点的多少和所代表的意义由地图的内容确定。<br>
 *              点密度专题图利用图层的某一数值属性信息（专题值）映射为不同等级，每一级别使用不同数量或表现为密度的点符号来表示。<br>
 *              该专题值在各个分区内的分布情况，体现不同区域的相对数量差异。多用于具有数量特征的地图上，<br>
 *              比如表示不同地区的粮食产量、GDP、人口等的分级，主要针对区域或面状的要素，因而，点密度专题图适用于面数据集。<br>
 *              注意：点密度专题图中点的分布是随机的，并不代表实际的分布位置。即使在相关设置完全相同的情况下，<br>
 *              每次制作出的专题图，点的数量相同，但点的位置都有差异。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        dotExpression - {string} 创建点密度专题图的字段或字段表达式。<br>
 *        style - {{@link SuperMap.ServerStyle}} 点密度专题图中点的风格。<br>
 *        value - {string} 专题图中每一个点所代表的数值。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeDotDensity = function (_Theme) {
    _inherits(ThemeDotDensity, _Theme);

    /**
     * @member SuperMap.ThemeDotDensity.prototype.style -{SuperMap.ServerStyle}
     * @description 点密度专题图中点的风格。
     */
    function ThemeDotDensity(options) {
        _classCallCheck(this, ThemeDotDensity);

        var _this = _possibleConstructorReturn(this, (ThemeDotDensity.__proto__ || Object.getPrototypeOf(ThemeDotDensity)).call(this, "DOTDENSITY", options));

        _this.dotExpression = null;
        _this.style = null;
        _this.value = null;
        _this.CLASS_NAME = "SuperMap.ThemeDotDensity";

        var me = _this;
        me.style = new _ServerStyle2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeDotDensity.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeDotDensity.prototype.value -{number}
     * @description 专题图中每一个点所代表的数值。<br>
     *              点值的确定与地图比例尺以及点的大小有关。地图比例尺越大，相应的图面范围也越大，<br>
     *              点相应就可以越多，此时点值就可以设置相对小一些。点形状越大，<br>
     *              点值相应就应该设置的小一些。点值过大或过小都是不合适的。
     */


    /**
     * @member SuperMap.ThemeDotDensity.prototype.dotExpression -{string}
     * @description 创建点密度专题图的字段或字段表达式。点的数目或密集程度的来源。
     */


    _createClass(ThemeDotDensity, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            me.dotExpression = null;
            me.value = null;

            if (me.style) {
                me.style.destroy();
                me.style = null;
            }
        }

        /**
         * @function SuperMap.ThemeDotDensity.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj = _SuperMap2["default"].Util.copyAttributes(obj, this);
            if (obj.style) {
                if (obj.style.toServerJSONObject) {
                    obj.style = obj.style.toServerJSONObject();
                }
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeDotDensity.fromObj
         * @description 从传入对象获取点密度专题图中点的风格。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeDotDensity} ThemeDotDensity对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeDotDensity();
            _SuperMap2["default"].Util.copy(res, obj);
            res.style = _ServerStyle2["default"].fromJson(obj.style);
            return res;
        }
    }]);

    return ThemeDotDensity;
}(_Theme3["default"]);

exports["default"] = ThemeDotDensity;


_SuperMap2["default"].ThemeDotDensity = ThemeDotDensity;

/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeFlow = __webpack_require__(66);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(68);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeGraduatedSymbolStyle = __webpack_require__(317);

var _ThemeGraduatedSymbolStyle2 = _interopRequireDefault(_ThemeGraduatedSymbolStyle);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeGraduatedSymbol
 * @classdesc 等级符号专题图。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        baseValue - {number}等级符号专题图的基准值，单位同专题变量的单位。<br>
 *        expression - {string} 等级符号专题图的字段或字段表达式。<br>
 *        flow - {{@link SuperMap.ThemeFlow}} 等级符号专题图符号流动显示与牵引线设置类。<br>
 *        graduatedMode - {{@link SuperMap.GraduatedMode}} 等级符号专题图分级模式。<br>
 *        offset - {{@link SuperMap.ThemeOffset}} 用于设置标签专题图中标记文本相对于要素内点的偏移量对象。<br>
 *        style - {{@link SuperMap.ThemeGraduatedSymbolStyle}} 用于设置等级符号图正负和零值显示风格。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeGraduatedSymbol = function (_Theme) {
    _inherits(ThemeGraduatedSymbol, _Theme);

    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置等级符号图相对于要素内点的偏移量。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.flow -{SuperMap.ThemeFlow}
     * @description 等级符号专题图符号流动显示与牵引线设置类。<br>
     *              通过该字段可以设置等级符号是否流动显示和牵引线风格。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.baseValue -{number}
     * @description 等级符号专题图的基准值，单位同专题变量的单位。<br>
     *              依据此值系统会自动根据分级方式计算其余值对应的符号大小，每个符号的显示大小等于<br>
     *              ThemeValueSection.positiveStyle（或 zeroStyle，negativeStyle）.markerSize * value / basevalue，<br>
     *              其中 value 是 expression 所指定字段对应的值经过分级计算之后的值。默认值为0，建议通过多次尝试设置该值才能达到较好的显示效果。
     */
    function ThemeGraduatedSymbol(options) {
        _classCallCheck(this, ThemeGraduatedSymbol);

        var _this = _possibleConstructorReturn(this, (ThemeGraduatedSymbol.__proto__ || Object.getPrototypeOf(ThemeGraduatedSymbol)).call(this, "GRADUATEDSYMBOL", options));

        _this.baseValue = 0;
        _this.expression = null;
        _this.flow = null;
        _this.graduatedMode = _REST.GraduatedMode.CONSTANT;
        _this.offset = null;
        _this.style = null;
        _this.CLASS_NAME = "SuperMap.ThemeGraduatedSymbol";

        var me = _this;
        me.flow = new _ThemeFlow2["default"]();
        me.offset = new _ThemeOffset2["default"]();
        me.style = new _ThemeGraduatedSymbolStyle2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeGraduatedSymbol.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.style -{SuperMap.ThemeGraduatedSymbolStyle}
     * @description 用于设置等级符号图正负和零值显示风格。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.graduatedMode -{SuperMap.GraduatedMode}
     * @description 等级符号专题图分级模式。<br>
     *              分级主要是为了减少制作等级符号专题图中数据大小之间的差异。如果数据之间差距较大，则可以采用对数或者平方根的分级方式来进行，<br>
     *              这样就减少了数据之间的绝对大小的差异，使得等级符号图的视觉效果比较好，同时不同类别之间的比较也是有意义的。<br>
     *              有三种分级模式：常数、对数和平方根，对于有值为负数的字段，在用对数或平方根方式分级时，默认对负数取正。<br>
     *              不同的分级模式用于确定符号大小的数值是不相同的：常数按照字段的原始数据进行；对数则是对每条记录对应的专题变量取自然对数；<br>
     *              平方根则是对其取平方根，然后用最终得到的结果来确定其等级符号的大小。<br>
     *              默认值为 SuperMap.GraduatedMode.CONSTANT。
     */


    /**
     * @member SuperMap.ThemeGraduatedSymbol.prototype.expression -{string}
     * @description 用于创建等级符号专题图的字段或字段表达式，字段或字段表达式应为数值型。必设字段。
     */


    _createClass(ThemeGraduatedSymbol, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeGraduatedSymbol.prototype.__proto__ || Object.getPrototypeOf(ThemeGraduatedSymbol.prototype), 'destroy', this).call(this);
            var me = this;
            me.expression = null;
            if (me.flow) {
                me.flow.destroy();
                me.flow = null;
            }
            me.graduatedMode = _REST.GraduatedMode.CONSTANT;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            if (me.style) {
                me.style.destroy();
                me.style = null;
            }
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.prototype.toJSON
         * @description 将themeLabel对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2["default"].Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            obj.memoryData = this.memoryData;
            obj.baseValue = this.baseValue;
            obj.expression = this.expression;
            obj.graduatedMode = this.graduatedMode;
            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }
            if (this.style) {
                obj.negativeStyle = this.style.negativeStyle;
                obj.negativeDisplayed = this.style.negativeDisplayed;
                obj.positiveStyle = this.style.positiveStyle;
                obj.zeroDisplayed = this.style.zeroDisplayed;
                obj.zeroStyle = this.style.zeroStyle;
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeGraduatedSymbol.fromObj
         * @description 从传入对象获取等级符号专题图。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeGraduatedSymbol} 等级符号专题图对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new _SuperMap2["default"].ThemeGraduatedSymbol();
            _SuperMap2["default"].Util.copy(res, obj);
            res.flow = _ThemeFlow2["default"].fromObj(obj);
            res.offset = _ThemeOffset2["default"].fromObj(obj);
            res.style = _ThemeGraduatedSymbolStyle2["default"].fromObj(obj);
            return res;
        }
    }]);

    return ThemeGraduatedSymbol;
}(_Theme3["default"]);

exports["default"] = ThemeGraduatedSymbol;


_SuperMap2["default"].ThemeGraduatedSymbol = ThemeGraduatedSymbol;

/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeFlow = __webpack_require__(66);

var _ThemeFlow2 = _interopRequireDefault(_ThemeFlow);

var _ThemeOffset = __webpack_require__(68);

var _ThemeOffset2 = _interopRequireDefault(_ThemeOffset);

var _ThemeGraphAxes = __webpack_require__(318);

var _ThemeGraphAxes2 = _interopRequireDefault(_ThemeGraphAxes);

var _ThemeGraphSize = __webpack_require__(320);

var _ThemeGraphSize2 = _interopRequireDefault(_ThemeGraphSize);

var _ThemeGraphText = __webpack_require__(321);

var _ThemeGraphText2 = _interopRequireDefault(_ThemeGraphText);

var _ThemeGraphItem = __webpack_require__(319);

var _ThemeGraphItem2 = _interopRequireDefault(_ThemeGraphItem);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeGraph
 * @classdesc 统计专题图类。
 * @extends SuperMap.Theme
 * @param options - {Object} 参数。<br>
 *        barWidth - {number}柱状专题图中每一个柱的宽度。<br>
 *        flow - {SuperMap.ThemeFlow} 统计专题图流动显示与牵引线设置。<br>
 *        graduatedMode - {{@link SuperMap.GraduatedMode}} 统计图中地理要素的值与图表尺寸间的映射关系。<br>
 *        graphAxes - {{@link SuperMap.ThemeGraphAxes}} 统计图中坐标轴样式相关信息。<br>
 *        graphSize - {{@link SuperMap.ThemeGraphSize}} 统计符号的最大最小尺寸。<br>
 *        graphSizeFixed - {boolean} 缩放地图时统计图符号是否固定大小。<br>
 *        graphText - {{@link SuperMap.ThemeGraphText}} 统计图上的文字是否可以见以及文字标注风格。<br>
 *        graphAxesTextDisplayMode -{{@link SuperMap.GraphAxesTextDisplayMode}} 统计专题图坐标轴文本显示模式 。默认值 SuperMap.GraphAxesTextDisplayMode.NONE。
 *        graphType - {{@link SuperMap.ThemeGraphType}} 统计专题图类型。<br>
 *        items - {Array<{@link SuperMap.ThemeGraphItem}>} 统计专题图子项集合。<br>
 *        memoryKeys - {Array<integer>} 以内存数组方式制作专题图时的键数组。<br>
 *        negativeDisplayed - {boolean} 专题图中是否显示属性为负值的数据。<br>
 *        offset - {{@link SuperMap.ThemeOffset}} 统计图相对于要素内点的偏移量。<br>
 *        overlapAvoided - {boolean} 统计图是否采用避让方式显示。<br>
 *        roseAngle - {number}统计图中玫瑰图或三维玫瑰图用于等分的角度。<br>
 *        startAngle - {number}饼状统计图扇形的起始角度。
 */
var ThemeGraph = function (_Theme) {
    _inherits(ThemeGraph, _Theme);

    /**
     * @member SuperMap.ThemeGraph.prototype.roseAngle -{number}
     * @description 统计图中玫瑰图或三维玫瑰图用于等分的角度，默认为0度，精确到0.1度。在角度为0或者大于360度的情况下均使用360度来等分制作统计图的字段数。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.offset -{SuperMap.ThemeOffset}
     * @description 用于设置统计图相对于要素内点的偏移量。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.memoryKeys -{Array<integer>}
     * @description 以内存数组方式制作专题图时的键数组。<br>
     *              键数组内的数值代表 SmID 值，它与 SuperMap.ThemeGraphItem 类中的值数组（SuperMap.ThemeGraphItem.memoryDoubleValues）要关联起来应用。<br>
     *              键数组中数值的个数必须要与值数组的数值个数一致。值数组中的值将代替原来的专题值来制作统计专题图。<br>
     *              目前所有的专题图都支持以内存数组的方式制作专题图，但统计专题图与其他专题图指定内存数组的方式不同，<br>
     *              统计专题图使用 memoryKeys 指定内存数组，而其他专题图则使用 memoryData 来指定内存数组。
     * @example
     *  memoryKeys的使用方法如：
     *   function addThemeGraph() {
     *      removeTheme();
     *        //创建统计专题图对象，SuperMap.ThemeGraph 必设 items。
     *       //专题图参数 ThemeParameters 必设 theme（即以设置好的分段专题图对象）、dataSourceName 和 datasetName
     *      var style1 = new SuperMap.ServerStyle({
     *                   fillForeColor: new SuperMap.ServerColor(92,73,234),
     *                   lineWidth: 0.1
     *               }),
     *               style2 = new SuperMap.ServerStyle({
     *                   fillForeColor: new SuperMap.ServerColor(211,111,240),
     *                   lineWidth: 0.1
     *               }),
     *               item1 = new SuperMap.ThemeGraphItem({
     *                   memoryDoubleValues:[1.18,0.95,0.37,1.31,0.8,1.5],
     *                  caption: "1992-1995人口增长率",
     *                  graphExpression: "Pop_Rate95",
     *                   uniformStyle: style1
     *               }),
     *               item2 = new SuperMap.ThemeGraphItem({
     *               //以内存数组方式制作专题图时的值数组
     *                   memoryDoubleValues:[2.71,0,0.74,3.1,2.2,3.5],
     *                   caption: "1995-1999人口增长率",  //专题图子项的名称
     *                   graphExpression: "Pop_Rate99",  //统计专题图的专题变量
     *                   uniformStyle: style2      //统计专题图子项的显示风格
     *               }),
     *               themeGraph  = new SuperMap.ThemeGraph({
     *               //以内存数组方式制作专题图时的键数组，键数组内的数值代表 SmID 值
     *                    memoryKeys:[1,2,4,8,10,12],
     *                   items: new Array(item1,item2),
     *                   barWidth: 0.03,
     *                    //统计图中地理要素的值与图表尺寸间的映射关系为平方根
     *                   graduatedMode: SuperMap.GraduatedMode.SQUAREROOT,
     *                   //graphAxes用于设置统计图中坐标轴样式相关信息
     *                   graphAxes: new SuperMap.ThemeGraphAxes({
     *                       axesDisplayed: true
     *                   }),
     *                   graphSize: new SuperMap.ThemeGraphSize({
     *                       maxGraphSize: 1,
     *                       minGraphSize: 0.35
     *                   }),
     *                   //统计图上的文字是否可以见以及文字标注风格
     *                   graphText: new SuperMap.ThemeGraphText({
     *                       graphTextDisplayed: true,
     *                       graphTextFormat: SuperMap.ThemeGraphTextFormat.VALUE,
     *                       graphTextStyle: new SuperMap.ServerTextStyle({
     *                           sizeFixed: true,
     *                           fontHeight: 9,
     *                           fontWidth: 5
     *                       })
     *                   }),
     *                   //统计专题图类型为三维柱状图
     *                   graphType: SuperMap.ThemeGraphType.BAR3D
     *               }),
     * //专题图参数对象
     *               themeParameters = new SuperMap.ThemeParameters({
     *                   themes: [themeGraph],
     *                   dataSourceNames: ["Jingjin"],
     *                   datasetNames: ["BaseMap_R"]
     *               }),
     *    //与服务端交互
     *               themeService=new SuperMap.ThemeService(url, {
     *                   eventListeners: {
     *                       "processCompleted": ThemeCompleted,
     *                        "processFailed": themeFailed
     *                  }
     *              });
     *       themeService.processAsync(themeParameters);
     *   }
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphAxesTextDisplayMode -{SuperMap.GraphAxesTextDisplayMode}
     * @description 统计专题图坐标轴文本显示模式 。默认值 SuperMap.GraphAxesTextDisplayMode.NONE。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphText -{SuperMap.ThemeGraphText}
     * @description 统计图上的文字是否可以见以及文字标注风格。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphSize -{SuperMap.ThemeGraphSize}
     * @description 用于设置统计符号的最大最小尺寸。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graduatedMode -{SuperMap.GraduatedMode}
     * @description 统计图中地理要素的值与图表尺寸间的映射关系（常数、对数、平方根），即分级方式。
     *              默认值为 SuperMap.GraduatedMode.CONSTANT。
     *              分级主要是为了减少制作统计专题图中数据大小之间的差异，使得统计图的视觉效果比较好，同时不同类别之间的比较也还是有意义的。
     *              提供三种分级模式：常数、对数和平方根，对于有值为负数的字段，不可以采用对数和平方根的分级方式。不同的等级方式用于确定符号大小的数值是不相同的。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.barWidth -{number}
     * @description 柱状专题图中每一个柱的宽度。使用地图坐标单位，默认值为0。<br>
     *              只有选择的统计图类型为柱状图（柱状图、三维柱状图、堆叠柱状图、三维堆叠柱状图）时，此项才可设置。
     */
    function ThemeGraph(options) {
        _classCallCheck(this, ThemeGraph);

        var _this = _possibleConstructorReturn(this, (ThemeGraph.__proto__ || Object.getPrototypeOf(ThemeGraph)).call(this, "GRAPH", options));

        _this.barWidth = 0;
        _this.flow = null;
        _this.graduatedMode = _REST.GraduatedMode.CONSTANT;
        _this.graphAxes = null;
        _this.graphSize = null;
        _this.graphSizeFixed = false;
        _this.graphText = null;
        _this.graphType = _REST.ThemeGraphType.AREA;
        _this.graphAxesTextDisplayMode = _REST.GraphAxesTextDisplayMode.NONE;
        _this.items = null;
        _this.memoryKeys = null;
        _this.negativeDisplayed = false;
        _this.offset = null;
        _this.overlapAvoided = true;
        _this.roseAngle = 0;
        _this.startAngle = 0;
        _this.CLASS_NAME = "SuperMap.ThemeGraph";

        var me = _this;
        me.flow = new _ThemeFlow2["default"]();
        me.graphAxes = new _ThemeGraphAxes2["default"]();
        me.graphSize = new _ThemeGraphSize2["default"]();
        me.graphText = new _ThemeGraphText2["default"]();
        me.offset = new _ThemeOffset2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeGraph.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.startAngle -{number}
     * @description 饼状统计图扇形的起始角度。默认为0度，精确到0.1度，以水平方向为正向。只有选择的统计图类型为饼状图（饼图、三维饼图、玫瑰图、三维玫瑰图）时，此项才可设置。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.overlapAvoided -{boolean}
     * @description 统计图是否采用避让方式显示。<br>
     *              1.对数据集制作统计专题图:当统计图采用避让方式显示时，如果 overlapAvoided 为 true，则在统计图重叠度很大的情况下，
     *              会出现无法完全避免统计图重叠的现象；如果 overlapAvoided 为 false，会过滤掉一些统计图，从而保证所有的统计图均不重叠。<br>
     *              2.对数据集同时制作统计专题图和标签专题图：当统计图不显示子项文本时，标签专题图的标签即使和统计图重叠，两者也都可正常显示；
     *              当统计图显示子项文本时，如果统计图中的子项文本和标签专题图中的标签不重叠，则两者均正常显示；如果重叠，则会过滤掉统计图的子项文本，只显示标签。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.negativeDisplayed -{boolean}
     * @description 专题图中是否显示属性为负值的数据。true 表示显示；默认为 false 即不显示。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.items -{Array<SuperMap.ThemeGraphItem>}
     * @description 统计专题图子项集合。必设字段。
     *              统计专题图可以基于多个变量，反映多种属性，即可以将多个专题变量的值绘制在一个统计图上。每一个专题变量对应的统计图即为一个专题图子项。
     *              对于每个专题图子项可以为其设置标题、风格，甚至可以将该子项再制作成范围分段专题图。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphType -{SuperMap.ThemeGraphType}
     * @description 统计专题图类型。SuperMap 提供了多种类型的统计图，<br>
     *              分别为面积图、阶梯图、折线图、点状图、柱状图、三维柱状图、饼图、三维饼图、玫瑰图、三维玫瑰图、堆叠柱状图、三维堆叠柱状图、环状图。默认为面积图。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphSizeFixed -{boolean}
     * @description 缩放地图时统计图符号是否固定大小。默认值为 false，即统计图符号将随地图缩放。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.graphAxes -{SuperMap.ThemeGraphAxes}
     * @description 用于设置统计图中坐标轴样式相关信息，如坐标轴颜色、是否显示、坐标文本样式等。
     */


    /**
     * @member SuperMap.ThemeGraph.prototype.flow -{SuperMap.ThemeFlow}
     * @description 统计专题图流动显示与牵引线设置。
     *              通过该字段可以设置统计符号是否流动显示和牵引线风格。
     */


    _createClass(ThemeGraph, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeGraph.prototype.__proto__ || Object.getPrototypeOf(ThemeGraph.prototype), 'destroy', this).call(this);
            var me = this;
            me.barWidth = null;
            if (me.flow) {
                me.flow.destroy();
                me.flow = null;
            }
            me.graduatedMode = null;
            if (me.graphAxes) {
                me.graphAxes.destroy();
                me.graphAxes = null;
            }
            if (me.graphSize) {
                me.graphSize.destroy();
                me.graphSize = null;
            }
            me.graphSizeFixed = null;
            if (me.graphText) {
                me.graphText.destroy();
                me.graphText = null;
            }
            me.graphType = null;
            if (me.items) {
                for (var i = 0, items = me.items, len = items.length; i < len; i++) {
                    items[i].destroy();
                }
                me.items = null;
            }
            me.memoryKeys = null;
            me.negativeDisplayed = null;
            if (me.offset) {
                me.offset.destroy();
                me.offset = null;
            }
            me.overlapAvoided = null;
            me.roseAngle = null;
            me.startAngle = null;
            me.graphAxesTextDisplayMode = null;
        }

        /**
         * @function SuperMap.ThemeGraph.prototype.toJSON
         * @description 将SuperMap.ThemeGraph对象转化为json字符串。
         * @return {string} 返回转换后的 JSON 字符串。
         */

    }, {
        key: 'toJSON',
        value: function toJSON() {
            return _SuperMap2["default"].Util.toJSON(this.toServerJSONObject());
        }

        /**
         * @function SuperMap.ThemeGraph.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj.type = this.type;
            if (this.graphText) {
                obj.graphTextDisplayed = this.graphText.graphTextDisplayed;
                obj.graphTextFormat = this.graphText.graphTextFormat;
                obj.graphTextStyle = this.graphText.graphTextStyle;
            }
            if (this.flow) {
                obj.flowEnabled = this.flow.flowEnabled;
                obj.leaderLineDisplayed = this.flow.leaderLineDisplayed;
                obj.leaderLineStyle = this.flow.leaderLineStyle;
            }
            if (this.graphAxes) {
                obj.axesColor = this.graphAxes.axesColor;
                obj.axesDisplayed = this.graphAxes.axesDisplayed;
                obj.axesGridDisplayed = this.graphAxes.axesGridDisplayed;
                obj.axesTextDisplayed = this.graphAxes.axesTextDisplayed;
                obj.axesTextStyle = this.graphAxes.axesTextStyle;
            }
            if (this.graphSize) {
                obj.maxGraphSize = this.graphSize.maxGraphSize;
                obj.minGraphSize = this.graphSize.minGraphSize;
            }
            if (this.offset) {
                obj.offsetFixed = this.offset.offsetFixed;
                obj.offsetX = this.offset.offsetX;
                obj.offsetY = this.offset.offsetY;
            }
            obj.barWidth = this.barWidth;
            obj.graduatedMode = this.graduatedMode;
            obj.graphSizeFixed = this.graphSizeFixed;
            obj.graphType = this.graphType;
            obj.graphAxesTextDisplayMode = this.graphAxesTextDisplayMode;
            obj.items = this.items;
            obj.memoryKeys = this.memoryKeys;
            obj.negativeDisplayed = this.negativeDisplayed;
            obj.overlapAvoided = this.overlapAvoided;
            obj.roseAngle = this.roseAngle;
            obj.startAngle = this.startAngle;
            return obj;
        }

        /**
         * @function SuperMap.ThemeGraph.fromObj
         * @description 从传入对象获取统计专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeGraph} ThemeGraph对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ThemeGraph();
            var itemsG = obj.items;
            var len = itemsG ? itemsG.length : 0;
            _SuperMap2["default"].Util.copy(res, obj);
            res.items = [];
            res.flow = _ThemeFlow2["default"].fromObj(obj);
            res.graphAxes = _ThemeGraphAxes2["default"].fromObj(obj);
            res.graphSize = _ThemeGraphSize2["default"].fromObj(obj);
            res.graphText = _ThemeGraphText2["default"].fromObj(obj);
            res.offset = _ThemeOffset2["default"].fromObj(obj);
            for (var i = 0; i < len; i++) {
                res.items.push(_ThemeGraphItem2["default"].fromObj(itemsG[i]));
            }
            return res;
        }
    }]);

    return ThemeGraph;
}(_Theme3["default"]);

exports["default"] = ThemeGraph;


_SuperMap2["default"].ThemeGraph = ThemeGraph;

/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ThemeRangeItem = __webpack_require__(333);

var _ThemeRangeItem2 = _interopRequireDefault(_ThemeRangeItem);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeRange
 * @classdesc 范围分段专题图。
 * @description 范围分段专题图是按照指定的分段方法（如：等距离分段法）对字段的属性值进行分段，使用不同的颜色或符号（线型、填充）表示不同范围段落的属性值在整体上的分布情况，体现区域的差异。
 *              在分段专题图中，专题值按照某种分段方式被分成多个范围段，要素根据各自的专题值被分配到其中一个范围段中，在同一个范围段中的要素使用相同的颜色，填充，符号等风格进行显示。
 *              分段专题图所基于的专题变量必须为数值型，分段专题图一般用来反映连续分布现象的数量或程度特征，如降水量的分布，土壤侵蚀强度的分布等。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        items - {Array<{@link SuperMap.ThemeRangeItem}>} 分段专题图子项数组。<br>
 *        rangeExpression - {string} 分段字段表达式。<br>
 *        rangeMode - {{@link SuperMap.RangeMode}} 分段专题图的分段模式。<br>
 *        rangeParameter - {number}分段参数。<br>
 *        colorGradientType - {{@link SuperMap.ColorGradientType}} 渐变颜色枚举类。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeRange = function (_Theme) {
    _inherits(ThemeRange, _Theme);

    /**
     * @member SuperMap.ThemeRange.prototype.rangeParameter -{number}
     * @description 分段参数。<br>
     *              当分段模式为等距离分段法，平方根分段，对数分段法，计数分段法其中一种模式时，该参数用于设置分段个数，必设；当分段模式为标准差分段法时，
     *              该参数不起作用；当分段模式为自定义距离时，该参数用于设置自定义距离。默认值为 -1。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.rangeExpression -{string}
     * @description 分段字段表达式。<br>
     *              由于范围分段专题图基于各种分段方法根据一定的距离进行分段，因而范围分段专题图所基于的字段值的数据类型必须为数值型。对于字段表达式，只能为数值型的字段间的运算。必设字段。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.precision -{string}
     * @description 精准度
     */
    function ThemeRange(options) {
        _classCallCheck(this, ThemeRange);

        var _this = _possibleConstructorReturn(this, (ThemeRange.__proto__ || Object.getPrototypeOf(ThemeRange)).call(this, "RANGE", options));

        _this.precision = '1.0E-12';
        _this.items = null;
        _this.rangeExpression = null;
        _this.rangeMode = _REST.RangeMode.EQUALINTERVAL;
        _this.rangeParameter = 0;
        _this.colorGradientType = _REST.ColorGradientType.YELLOW_RED;
        _this.CLASS_NAME = "SuperMap.ThemeRange";

        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeRange.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeRange.prototype.colorGradientType -{SuperMap.ColorGradientType}
     * @description 渐变颜色枚举类 <br>
     *              渐变色是由起始色根据一定算法逐渐过渡到终止色的一种混合型颜色。
     *              该类作为单值专题图参数类、分段专题图参数类的属性，负责设置单值专题图、分段专题图的配色方案，在默认情况下专题图所有子项会根据这个配色
     *              方案完成填*充。但如果为某几个子项的风格进行单独设置后（设置了 {@link SuperMap.ThemeUniqueItem} 或 {@link SuperMap.ThemeRangeItem} 类中Style属性），
     *              该配色方案对于这几个子项将不起作用。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.rangeMode -{SuperMap.RangeMode}
     * @description 分段专题图的分段模式。<br>
     *              默认值为 {@link RangeMode|SuperMap.RangeMode.EQUALINTERVAL}（等距离分段）。
     *              在分段专题图中，作为专题变量的字段或表达式的值按照某种分段方式被分成多个范围段。
     *              目前 SuperMap 提供的分段方式包括：等距离分段法、平方根分段法、标准差分段法、对数分段法、等计数分段法和自定义距离法，
     *              显然这些分段方法根据一定的距离进行分段，因而范围分段专题图所基于的专题变量必须为数值型。
     */


    /**
     * @member SuperMap.ThemeRange.prototype.items -{Array<SuperMap.ThemeRangeItem>}
     * @description 分段专题图子项数组。<br>
     *              在分段专题图中，字段值按照某种分段模式被分成多个范围段，每个范围段即为一个子项，同一范围段的要素属于同一个分段专题图子项。<br>
     *              每个子项都有其分段起始值、终止值、名称和风格等。每个分段所表示的范围为[start, end)。<br>
     *              如果设置了范围分段模式和分段数，则会自动计算每段的范围[start, end)，故无需设置[start, end)；当然可以设置，那么结果就会按照您设置的值对分段结果进行调整。
     */


    _createClass(ThemeRange, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeRange.prototype.__proto__ || Object.getPrototypeOf(ThemeRange.prototype), 'destroy', this).call(this);
            var me = this;
            if (me.items) {
                if (me.items.length > 0) {
                    for (var item in me.items) {
                        me.items[item].destroy();
                        me.items[item] = null;
                    }
                }
                me.items = null;
            }
            me.rangeExpression = null;
            me.rangeMode = null;
            me.rangeParameter = null;
            me.colorGradientType = null;
        }

        /**
         * @function SuperMap.ThemeRange.fromObj
         * @description 从传入对象获取范围分段专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeRange} ThemeRange对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            if (!obj) return;
            var res = new ThemeRange();
            _SuperMap2["default"].Util.copy(res, obj);
            var itemsR = obj.items;
            var len = itemsR ? itemsR.length : 0;
            res.items = [];
            for (var i = 0; i < len; i++) {
                res.items.push(_ThemeRangeItem2["default"].fromObj(itemsR[i]));
            }
            return res;
        }
    }]);

    return ThemeRange;
}(_Theme3["default"]);

exports["default"] = ThemeRange;


_SuperMap2["default"].ThemeRange = ThemeRange;

/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme2 = __webpack_require__(18);

var _Theme3 = _interopRequireDefault(_Theme2);

var _ServerStyle = __webpack_require__(11);

var _ServerStyle2 = _interopRequireDefault(_ServerStyle);

var _ThemeUniqueItem = __webpack_require__(335);

var _ThemeUniqueItem2 = _interopRequireDefault(_ThemeUniqueItem);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.ThemeUnique
 * @classdesc 单值专题图。
 * @description 单值专题图是利用不同的颜色或符号（线型、填充）表示图层中某一属性信息的不同属性值，属性值相同的要素具有相同的渲染风格。单值专题图多用于具有分类属性的地图上，
 *              比如土壤类型分布图、土地利用图、行政区划图等。单值专题图着重表示现象质的差别，一般不表示数量的特征。尤其是有交叉或重叠现象时，此类不推荐使用，例如：民族分布区等。
 * @extends SuperMap.Theme
 * @param options - {Object} 可选参数。如：<br>
 *        items - {Array<{@link SuperMap.ThemeUniqueItem}>} 单值专题图子项类数组。<br>
 *        uniqueExpression - {string} 用于制作单值专题图的字段或字段表达式。<br>
 *        defaultStyle - {{@link SuperMap.ServerStyle}} 未参与单值专题图制作的对象的显示风格。<br>
 *        colorGradientType - {{@link SuperMap.ColorGradientType}} 渐变颜色枚举类。<br>
 *        memoryData - {{@link SuperMap.ThemeMemoryData}} 专题图内存数据。
 */
var ThemeUnique = function (_Theme) {
    _inherits(ThemeUnique, _Theme);

    /**
     * @member SuperMap.ThemeUnique.prototype.uniqueExpression -{string}
     * @description 用于制作单值专题图的字段或字段表达式。<br>
     *              该字段值的数据类型可以为数值型或字符型。如果设置字段表达式，只能是相同数据类型字段间的运算。必设字段。
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.defaultStyle -{SuperMap.ServerStyle}
     * @description 未参与单值专题图制作的对象的显示风格。<br>
     *              通过单值专题图子项数组 （items）可以指定某些要素参与单值专题图制作，对于那些没有被包含的要素，即不参加单值专题表达的要素，使用该风格显示。
     */
    function ThemeUnique(options) {
        _classCallCheck(this, ThemeUnique);

        var _this = _possibleConstructorReturn(this, (ThemeUnique.__proto__ || Object.getPrototypeOf(ThemeUnique)).call(this, "UNIQUE", options));

        _this.defaultStyle = null;
        _this.items = null;
        _this.uniqueExpression = null;
        _this.colorGradientType = _REST.ColorGradientType.YELLOW_RED;
        _this.CLASS_NAME = "SuperMap.ThemeUnique";

        var me = _this;
        me.defaultStyle = new _ServerStyle2["default"]();
        if (options) {
            _SuperMap2["default"].Util.extend(_this, options);
        }
        return _this;
    }

    /**
     * @function SuperMap.ThemeUnique.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.colorGradientType -{SuperMap.ColorGradientType}
     * @description 渐变颜色枚举类。<br>
     *              渐变色是由起始色根据一定算法逐渐过渡到终止色的一种混合型颜色。
     *              该类作为单值专题图参数类、分段专题图参数类的属性，负责设置单值专题图、分段专题图的配色方案，在默认情况下专题图所有子项会根据这个配色方案完成填充。
     *              但如果为某几个子项的风格进行单独设置后（设置了 ThemeUniqueItem 或 ThemeRangeItem 类中Style属性），
     *              该配色方案对于这几个子项将不起作用。
     */


    /**
     * @member SuperMap.ThemeUnique.prototype.items -{Array<SuperMap.ThemeUniqueItem>}
     * @description 单值专题图子项类数组。<br>
     *              单值专题图是将专题值相同的要素归为一类，为每一类设定一种渲染风格，其中每一类就是一个专题图子项。比如，利用单值专题图制作行政区划图，
     *              Name 字段代表省/直辖市名，该字段用来做专题变量，如果该字段的字段值总共有5种不同值，则该行政区划图有5个专题图子项。
     */


    _createClass(ThemeUnique, [{
        key: 'destroy',
        value: function destroy() {
            _get(ThemeUnique.prototype.__proto__ || Object.getPrototypeOf(ThemeUnique.prototype), 'destroy', this).call(this);
            var me = this;
            me.uniqueExpression = null;
            me.colorGradientType = null;
            if (me.items) {
                if (me.items.length > 0) {
                    for (var item in me.items) {
                        me.items[item].destroy();
                        me.items[item] = null;
                    }
                }
                me.items = null;
            }

            if (me.defaultStyle) {
                me.defaultStyle.destroy();
                me.defaultStyle = null;
            }
        }

        /**
         * @function SuperMap.ThemeUnique.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return {Object} 对应的 JSON 格式对象
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var obj = {};
            obj = _SuperMap2["default"].Util.copyAttributes(obj, this);
            if (obj.defaultStyle) {
                if (obj.defaultStyle.toServerJSONObject) {
                    obj.defaultStyle = obj.defaultStyle.toServerJSONObject();
                }
            }
            if (obj.items) {
                var items = [],
                    len = obj.items.length;
                for (var i = 0; i < len; i++) {
                    items.push(obj.items[i].toServerJSONObject());
                }
                obj.items = items;
            }
            return obj;
        }

        /**
         * @function SuperMap.ThemeUnique.fromObj
         * @description 从传入对象获取单值专题图类。
         * @param obj - {Object} 传入对象
         * @return {SuperMap.ThemeUnique} ThemeUnique对象
         */

    }], [{
        key: 'fromObj',
        value: function fromObj(obj) {
            var res = new ThemeUnique();
            var uItems = obj.items;
            var len = uItems ? uItems.length : 0;
            _SuperMap2["default"].Util.extend(res, obj);
            res.items = [];
            res.defaultStyle = new _ServerStyle2["default"].fromJson(obj.defaultStyle);
            for (var i = 0; i < len; i++) {
                res.items.push(new _ThemeUniqueItem2["default"].fromObj(uItems[i]));
            }
            return res;
        }
    }]);

    return ThemeUnique;
}(_Theme3["default"]);

exports["default"] = ThemeUnique;


_SuperMap2["default"].ThemeUnique = ThemeUnique;

/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _REST = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.UGCLayer
 * @classdesc UGC 图层类。
 * @param options - {Object} 可选参数。如：<br>
 *        bounds - {{@link SuperMap.Bounds}} 图层范围。<br>
 *        caption - {string} 图层的标题。<br>
 *        description - {string} 图层的描述信息。<br>
 *        name - {string} 图层的名称。<br>
 *        queryable - {boolean} 图层中的对象是否可以查询。<br>
 *        subUGCLayers - {boolean} 是否允许图层的符号大小随图缩放。<br>
 *        type - {{@link SuperMap.UGCLayerType}} 图层类型。<br>
 *        visible - {boolean} 地图对象在同一范围内时，是否重叠显示，默认为False。
 */
var UGCLayer = function () {

    /**
     * @member SuperMap.UGCLayer.prototype.type -{SuperMap.UGCLayerType}
     * @description 图层类型。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.queryable -{boolean}
     * @description 图层中的对象是否可以查询。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.description -{string}
     * @description 图层的描述信息。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.bounds -{SuperMap.Bounds}
     * @description 图层范围。
     */
    function UGCLayer(options) {
        _classCallCheck(this, UGCLayer);

        this.bounds = null;
        this.caption = null;
        this.description = null;
        this.name = null;
        this.queryable = null;
        this.subLayers = null;
        this.type = null;
        this.visible = null;
        this.CLASS_NAME = "SuperMap.UGCLayer";

        options = options ? options : {};
        _SuperMap2["default"].Util.extend(this, options);
    }

    /**
     * @function SuperMap.UGCLayer.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.visible -{boolean}
     * @description 图层是否可视。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.subLayers -{Array}
     * @description 子图层集。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.name -{string}
     * @description 图层的名称。
     */


    /**
     * @member SuperMap.UGCLayer.prototype.caption -{string}
     * @description 图层的标题。
     */


    _createClass(UGCLayer, [{
        key: 'destroy',
        value: function destroy() {
            var me = this;
            _SuperMap2["default"].Util.reset(me);
        }

        /**
         * @function SuperMap.UGCLayer.prototype.fromJson
         * @description 将服务端JSON对象转换成当前客户端对象
         * @param jsonObject - {Object} 要转换的 JSON 对象。
         */

    }, {
        key: 'fromJson',
        value: function fromJson(jsonObject) {
            jsonObject = jsonObject ? jsonObject : {};
            _SuperMap2["default"].Util.extend(this, jsonObject);
            var b = this.bounds;
            if (b) {
                this.bounds = new _SuperMap2["default"].Bounds(b.leftBottom.x, b.leftBottom.y, b.rightTop.x, b.rightTop.y);
            }
        }

        /**
         * @function SuperMap.UGCLayer.prototype.toServerJSONObject
         * @description 转换成对应的 JSON 格式对象。
         * @return{Object} 对应的 JSON 格式对象。
         */

    }, {
        key: 'toServerJSONObject',
        value: function toServerJSONObject() {
            var jsonObject = {};
            jsonObject = _SuperMap2["default"].Util.copyAttributes(jsonObject, this);
            if (jsonObject.bounds) {
                if (jsonObject.bounds.toServerJSONObject) {
                    jsonObject.bounds = jsonObject.bounds.toServerJSONObject();
                }
            }
            return jsonObject;
        }
    }]);

    return UGCLayer;
}();

exports["default"] = UGCLayer;


_SuperMap2["default"].UGCLayer = UGCLayer;

/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Theme = __webpack_require__(102);

var _Theme2 = _interopRequireDefault(_Theme);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @class SuperMap.Feature.Theme.Vector
 * @classdesc 矢量专题要素类。
 * @extends SuperMap.Feature.Theme
 * @param data - {SuperMap.Feature.Vector}  用户数据，必设参数, 矢量专题要素的类型为矢量数据 feature。
 * @param layer - {SuperMap.Layer} 此专题要素所在图层，必设参数。
 * @param style - {Object} 样式。
 * @param options - {Object} 创建专题要素时的可选参数。<br>
 *        nodesClipPixel - {number}节点抽稀像素距离，默认值 2, 单位：像素。<br>
 *        isHoverAble - {boolean} 图形是否可 hover，默认 true。<br>
 *        isMultiHover - {boolean} 是否使用多图形高亮，isHoverAble 为 true 时生效 ，默认 true。<br>
 *        isClickAble - {boolean} 图形是否可点击，默认 true。<br>
 *        highlightStyle - {Object} 高亮样式。
 */
var ThemeVector = function (_ThemeFeature) {
    _inherits(ThemeVector, _ThemeFeature);

    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.shapeOptions - {Object}
     * @description 添加到渲染器前修改 shape 的一些属性，非特殊情况通常不允许这么做。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.isClickAble - {boolean}
     * @description 图形是否可点击，默认 true。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.isHoverAble - {boolean}
     * @description 图形是否可 hover，默认 true。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.dataBounds - {SuperMap.Bounds}
     * @description 用户数据的（feature.geometry）地理范围。
     */
    function ThemeVector(data, layer, style, options, shapeOptions) {
        _classCallCheck(this, ThemeVector);

        //数据的 geometry 属性必须存在且类型是 SuperMap.Geometry 或其子类的类型
        var _this = _possibleConstructorReturn(this, (ThemeVector.__proto__ || Object.getPrototypeOf(ThemeVector)).call(this, data, layer));

        _this.dataBounds = null;
        _this.nodesClipPixel = 2;
        _this.isHoverAble = true;
        _this.isMultiHover = true;
        _this.isClickAble = true;
        _this.highlightStyle = null;
        _this.shapeOptions = null;
        _this.style = null;
        _this.CLASS_NAME = "SuperMap.Feature.Theme.Vector";
        if (!data.geometry) return _possibleConstructorReturn(_this);
        if (!(data.geometry instanceof _SuperMap2["default"].Geometry)) return _possibleConstructorReturn(_this);
        _this.style = style ? style : {};
        _this.data = data;
        _this.layer = layer;
        _this.id = _SuperMap2["default"].Util.createUniqueID(_this.CLASS_NAME + "_");
        _this.location = [];
        _this.shapes = [];
        if (options) {
            _SuperMap2["default"].Util.copyAttributesWithClip(_this, options, ["shapeOptions", "dataBounds"]);
        }
        if (shapeOptions) {
            _this.shapeOptions = {};
            _SuperMap2["default"].Util.copyAttributesWithClip(_this.shapeOptions, shapeOptions);
        }

        //设置基础参数 dataBounds、lonlat、location
        var geometry = data.geometry;
        _this.dataBounds = geometry.getBounds();
        _this.lonlat = _this.dataBounds.getCenterLonLat();
        _this.location = _this.getLocalXY(_this.lonlat);

        //将地理要素转为专题要素
        if (geometry instanceof _SuperMap2["default"].Geometry.LinearRing) {
            _this.lineToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.LineString) {
            _this.lineToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.Curve) {
            //独立几何体
        } else if (geometry instanceof _SuperMap2["default"].Geometry.MultiPoint) {
            _this.multiPointToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.MultiLineString) {

            _this.multiLineStringToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.MultiPolygon) {
            _this.multiPolygonToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.Polygon) {
            _this.polygonToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.Collection) {
            //独立几何体
        } else if (geometry instanceof _SuperMap2["default"].Geometry.Point) {
            _this.pointToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.Rectangle) {
            _this.rectangleToTF(geometry);
        } else if (geometry instanceof _SuperMap2["default"].Geometry.GeoText) {
            _this.geoTextToTF(geometry);
        }

        return _this;
    }

    /**
     * @function SuperMap.Feature.Theme.Vector.prototype.destroy
     * @override
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.style - {Object}
     * @description 可视化图形的 style。在子类中规定其对象结构和默认属性值。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.highlightStyle - {Object}
     * @description 高亮样式。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.isMultiHover - {boolean}
     * @description 是否使用多图形高亮，isHoverAble 为 true 时生效 ，默认 true。
     */


    /**
     * @member SuperMap.Feature.Theme.Vector.prototype.nodesClipPixel - {number}
     * @description 节点抽稀像素距离，默认值 2。
     */


    _createClass(ThemeVector, [{
        key: 'destroy',
        value: function destroy() {
            this.style = null;
            this.dataBounds = null;
            this.nodesClipPixel = null;
            this.isHoverAble = null;
            this.isMultiHover = null;
            this.isClickAble = null;
            this.highlightStyle = null;
            this.shapeOptions = null;
            _get(ThemeVector.prototype.__proto__ || Object.getPrototypeOf(ThemeVector.prototype), 'destroy', this).call(this);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.lineToTF
         * @description 转换线和线环要素。
         * @param geometry - {SuperMap.Geometry} 用户数据几何地理信息，这里必须是 LineString 或 LineRing。
         */

    }, {
        key: 'lineToTF',
        value: function lineToTF(geometry) {
            var components = geometry.components;

            //节点像素坐标
            var localLX = [];
            //参考位置，参考中心为
            var refLocal = [];
            var location = this.location;
            var pointList = [];

            //节点抽稀距离
            var nCPx = this.nodesClipPixel;

            for (var i = 0; i < components.length; i++) {
                var components_i = components[i];
                refLocal = [];
                localLX = this.getLocalXY(components_i);

                refLocal[0] = localLX[0] - location[0];
                refLocal[1] = localLX[1] - location[1];

                //抽稀 - 2 px
                if (pointList.length > 0) {
                    var lastLocalXY = pointList[pointList.length - 1];
                    if (Math.abs(lastLocalXY[0] - refLocal[0]) <= nCPx && Math.abs(lastLocalXY[1] - refLocal[1]) <= nCPx) continue;
                }

                //使用参考点
                pointList.push(refLocal);
            }

            if (pointList.length < 2) {
                return null;
            }

            //赋 style
            var style = new Object();
            style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style, ['pointList']);
            style.pointList = pointList;

            //创建图形
            var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicBrokenLine({
                style: style,
                clickable: this.isClickAble,
                hoverable: this.isHoverAble
            });

            //设置高亮样式
            if (this.highlightStyle) {
                shape.highlightStyle = this.highlightStyle;
            }

            //设置参考中心，指定图形位置
            shape.refOriginalPosition = this.location;

            //储存数据 id 属性，用于事件
            shape.refDataID = this.data.id;

            //储存数据 id 属性，用于事件-多图形同时高亮
            shape.isHoverByRefDataID = this.isMultiHover;

            //添加到渲染器前修改 shape 的一些属性，非特殊情况通常不允许这么做
            if (this.shapeOptions) {
                _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
            }

            this.shapes.push(shape);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.multiPointToTF
         * @description 转多点要素。
         * @param geometry - {SuperMap.Geometry} 用户数据几何地理信息，这里必须是 MultiPoint。
         */

    }, {
        key: 'multiPointToTF',
        value: function multiPointToTF(geometry) {
            /*   //-- 不抽稀
             var components = geometry.components;
               for(var i = 0; i < components.length; i++){
             var components_i = components[i];
             this.pointToTF(components_i);
             }
             */

            var components = geometry.components;

            //节点像素坐标
            var localLX = [];
            //参考位置，参考中心为
            var refLocal = [];
            var location = this.location;
            var pointList = [];

            //节点抽稀距离
            var nCPx = this.nodesClipPixel;

            for (var i = 0; i < components.length; i++) {
                var components_i = components[i];
                refLocal = [];
                localLX = this.getLocalXY(components_i);

                refLocal[0] = localLX[0] - location[0];
                refLocal[1] = localLX[1] - location[1];

                //抽稀
                if (pointList.length > 0) {
                    var lastLocalXY = pointList[pointList.length - 1];
                    if (Math.abs(lastLocalXY[0] - refLocal[0]) <= nCPx && Math.abs(lastLocalXY[1] - refLocal[1]) <= nCPx) continue;
                }

                //使用参考点
                pointList.push(refLocal);

                //赋 style
                var style = new Object();
                style.r = 6; //防止漏设此参数，默认 6 像素
                style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style);
                style.x = refLocal[0];
                style.y = refLocal[1];

                //创建图形
                var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicPoint({
                    style: style,
                    clickable: this.isClickAble,
                    hoverable: this.isHoverAble
                });

                //设置高亮样式
                if (this.highlightStyle) {
                    shape.highlightStyle = this.highlightStyle;
                }

                //设置参考中心，指定图形位置
                shape.refOriginalPosition = location;

                //储存数据 id 属性，用于事件
                shape.refDataID = this.data.id;

                //储存数据 id 属性，用于事件-多图形同时高亮
                shape.isHoverByRefDataID = this.isMultiHover;

                //修改一些 shape 可选属性，通常不需要这么做
                if (this.shapeOptions) {
                    _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
                }

                this.shapes.push(shape);
            }
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.multiLineStringToTF
         * @description 转换多线要素。
         * @param geometry - {SuperMap.Geometry} 用户数据几何地理信息，这里必须是 MultiLineString。
         */

    }, {
        key: 'multiLineStringToTF',
        value: function multiLineStringToTF(geometry) {
            var components = geometry.components;

            for (var i = 0; i < components.length; i++) {
                var components_i = components[i];
                this.lineToTF(components_i);
            }
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.multiPolygonToTF
         * @description 转换多面要素。
         * @param geometry - {SuperMap.Geometry}  用户数据几何地理信息，这里必须是 MultiPolygon。
         */

    }, {
        key: 'multiPolygonToTF',
        value: function multiPolygonToTF(geometry) {
            var components = geometry.components;

            for (var i = 0; i < components.length; i++) {
                var components_i = components[i];
                this.polygonToTF(components_i);
            }
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.pointToTF
         * @description 转换点要素。
         * @param geometry - {SuperMap.Geometry}  用户数据几何地理信息，这里必须是 Point。
         */

    }, {
        key: 'pointToTF',
        value: function pointToTF(geometry) {
            //参考位置，参考中心为
            var location = this.location;
            //geometry 像素坐标
            var localLX = this.getLocalXY(geometry);

            //赋 style
            var style = new Object();
            style.r = 6; //防止漏设此参数，默认 6 像素
            style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style);
            style.x = localLX[0] - location[0];
            style.y = localLX[1] - location[1];

            //创建图形
            var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicPoint({
                style: style,
                clickable: this.isClickAble,
                hoverable: this.isHoverAble
            });

            //设置高亮样式
            if (this.highlightStyle) {
                shape.highlightStyle = this.highlightStyle;
            }

            //设置参考中心，指定图形位置
            shape.refOriginalPosition = location;

            //储存数据 id 属性，用于事件
            shape.refDataID = this.data.id;

            //储存数据 id 属性，用于事件-多图形同时高亮
            shape.isHoverByRefDataID = this.isMultiHover;

            //修改一些 shape 可选属性，通常不需要这么做
            if (this.shapeOptions) {
                _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
            }

            this.shapes.push(shape);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.polygonToThemeFeature
         * @description 转换面要素。
         * @param geometry - {SuperMap.Geometry} 用户数据几何地理信息，这里必须是 Polygon。
         */

    }, {
        key: 'polygonToTF',
        value: function polygonToTF(geometry) {
            var components = geometry.components;
            ;

            //节点像素坐标
            var localLX = [];
            //参考位置，参考中心为
            var refLocal = [];
            var location = this.location;
            var pointList = [];
            //岛洞
            var holePolygonPointList = [];
            var holePolygonPointLists = [];

            //节点抽稀距离
            var nCPx = this.nodesClipPixel;

            for (var i = 0; i < components.length; i++) {
                var components_i = components[i].components;

                if (i === 0) {
                    // 第一个 component 正常绘制
                    pointList = [];

                    for (var j = 0; j < components_i.length; j++) {
                        refLocal = [];
                        localLX = this.getLocalXY(components_i[j]);

                        refLocal[0] = localLX[0] - location[0];
                        refLocal[1] = localLX[1] - location[1];

                        //抽稀 - 2 px
                        if (pointList.length > 0) {
                            var lastLocalXY = pointList[pointList.length - 1];
                            if (Math.abs(lastLocalXY[0] - refLocal[0]) <= nCPx && Math.abs(lastLocalXY[1] - refLocal[1]) <= nCPx) continue;
                        }

                        //使用参考点
                        pointList.push(refLocal);
                    }
                } else {
                    // 其它 component 作为岛洞
                    holePolygonPointList = [];

                    for (var k = 0; k < components_i.length; k++) {
                        refLocal = [];
                        localLX = this.getLocalXY(components_i[k]);

                        refLocal[0] = localLX[0] - location[0];
                        refLocal[1] = localLX[1] - location[1];

                        //抽稀 - 2 px
                        if (holePolygonPointList.length > 0) {
                            var lastXY = holePolygonPointList[holePolygonPointList.length - 1];
                            if (Math.abs(lastXY[0] - refLocal[0]) <= nCPx && Math.abs(lastXY[1] - refLocal[1]) <= nCPx) continue;
                        }

                        //使用参考点
                        holePolygonPointList.push(refLocal);
                    }
                }

                if (holePolygonPointList.length < 2) {
                    continue;
                }

                holePolygonPointLists.push(holePolygonPointList);
            }

            if (pointList.length < 2) {
                return;
            }

            //赋 style
            var style = {};
            style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style, ['pointList']);
            style.pointList = pointList;

            //创建图形
            var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicPolygon({
                style: style,
                clickable: this.isClickAble,
                hoverable: this.isHoverAble
            });

            //设置高亮样式
            if (this.highlightStyle) {
                shape.highlightStyle = this.highlightStyle;
            }

            //设置参考中心，指定图形位置
            shape.refOriginalPosition = this.location;

            //储存数据 id 属性，用于事件
            shape.refDataID = this.data.id;

            //储存数据 id 属性，用于事件-多图形同时高亮
            shape.isHoverByRefDataID = this.isMultiHover;

            //岛洞面
            if (holePolygonPointLists.length > 0) {
                shape.holePolygonPointLists = holePolygonPointLists;
            }

            //修改一些 shape 可选属性，通常不需要这么做
            if (this.shapeOptions) {
                _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
            }

            this.shapes.push(shape);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.rectangleToTF
         * @description 转换矩形要素。
         * @param geometry - {SuperMap.Geometry}  用户数据几何地理信息，这里必须是 Rectangle。
         */

    }, {
        key: 'rectangleToTF',
        value: function rectangleToTF(geometry) {
            //参考位置，参考中心为
            var location = this.location;
            var ll = new _SuperMap2["default"].LonLat(geometry.x, geometry.y);

            //地图分辨率
            var res = this.layer.map.getResolution();

            //geometry 像素坐标
            var localLX = this.getLocalXY(ll);

            //赋 style
            var style = new Object();
            style.r = 6; //防止漏设此参数，默认 6 像素
            style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style);
            style.x = localLX[0] - location[0];
            // SuperMap.Geometry.Rectangle 使用左下角定位， SmicRectangle 使用左上角定位，需要转换
            style.y = localLX[1] - location[1] - 2 * geometry.width / res;
            style.width = geometry.width / res;
            style.height = geometry.height / res;

            //创建图形
            var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicRectangle({
                style: style,
                clickable: this.isClickAble,
                hoverable: this.isHoverAble
            });

            //设置高亮样式
            if (this.highlightStyle) {
                shape.highlightStyle = this.highlightStyle;
            }

            //设置参考中心，指定图形位置
            shape.refOriginalPosition = location;

            //储存数据 id 属性，用于事件
            shape.refDataID = this.data.id;

            //储存数据 id 属性，用于事件-多图形同时高亮
            shape.isHoverByRefDataID = this.isMultiHover;

            //修改一些 shape 可选属性，通常不需要这么做
            if (this.shapeOptions) {
                _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
            }

            this.shapes.push(shape);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.geoTextToTF
         * @description 转换文本要素。
         * @param geometry - {SuperMap.Geometry}  用户数据几何地理信息，这里必须是 GeoText。
         */

    }, {
        key: 'geoTextToTF',
        value: function geoTextToTF(geometry) {
            //参考位置，参考中心为
            var location = this.location;
            //geometry 像素坐标
            var localLX = this.getLocalXY(geometry);

            //赋 style
            var style = new Object();
            style.r = 6; //防止漏设此参数，默认 6 像素
            style = _SuperMap2["default"].Util.copyAttributesWithClip(style, this.style, ["x", "y", "text"]);
            style.x = localLX[0] - location[0];
            style.y = localLX[1] - location[1];
            style.text = geometry.text;

            //创建图形
            var shape = new _SuperMap2["default"].LevelRenderer.Shape.SmicText({
                style: style,
                clickable: this.isClickAble,
                hoverable: this.isHoverAble
            });

            //设置高亮样式
            if (this.highlightStyle) {
                shape.highlightStyle = this.highlightStyle;
            }

            //设置参考中心，指定图形位置
            shape.refOriginalPosition = location;

            //储存数据 id 属性，用于事件
            shape.refDataID = this.data.id;

            //储存数据 id 属性，用于事件-多图形同时高亮
            shape.isHoverByRefDataID = this.isMultiHover;

            //修改一些 shape 可选属性，通常不需要这么做
            if (this.shapeOptions) {
                _SuperMap2["default"].Util.copyAttributesWithClip(shape, this.shapeOptions);
            }

            this.shapes.push(shape);
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.updateAndAddShapes
         * @description 修改位置，针对地图平移操作，地图漫游操作后调用此函数。
         */

    }, {
        key: 'updateAndAddShapes',
        value: function updateAndAddShapes() {
            var newLocalLX = this.getLocalXY(this.lonlat);
            this.location = newLocalLX;

            var render = this.layer.renderer;
            for (var i = 0, len = this.shapes.length; i < len; i++) {
                var shape = this.shapes[i];
                //设置参考中心，指定图形位置
                shape.refOriginalPosition = newLocalLX;
                render.addShape(shape);
            }
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.getShapesCount
         * @description 获得专题要素中可视化图形的数量。
         * @return {number} 可视化图形的数量。
         */

    }, {
        key: 'getShapesCount',
        value: function getShapesCount() {
            return this.shapes.length;
        }

        /**
         * @function SuperMap.Feature.Theme.Vector.prototype.getLocalXY
         * @description 地理坐标转为像素坐标。
         * @param lonlat - {SuperMap.LonLat} 专题要素地理位置。
         */

    }, {
        key: 'getLocalXY',
        value: function getLocalXY(lonlat) {
            return this.layer.getLocalXY(lonlat);
        }
    }]);

    return ThemeVector;
}(_Theme2["default"]);

exports["default"] = ThemeVector;


_SuperMap2["default"].Feature.Theme.Vector = ThemeVector;

/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Util = __webpack_require__(5);

__webpack_require__(47);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @private
 * @class  SuperMap.Feature.Theme
 * 专题要素基类，此类不可实例化。
 */
var Theme = function () {

    /**
     * Constructor: SuperMap.Feature.Theme
     * 构造函数。
     *
     * Parameters:
     * data - {Object}  用户数据，用于生成可视化 shape，必设参数。
     * layer - {<SuperMap.Layer.Theme>} 此专题要素所在图层，必设参数。
     *
     * Returns:
     * {<SuperMap.Feature.Theme>} 返回一个专题要素。
     */


    /**
     * APIProperty: shapes
     * {Array} {ReadOnly} 构成此专题要素的可视化图形对象数组，数组顺序控制渲染。
     */


    /**
     * APIProperty: location
     * {Array} 专题要素像素参考位置。通常由地理参考位置决定。长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     */


    /**
     * Property: id
     * {String} 专题要素唯一标识。
     */
    function Theme(data, layer) {
        _classCallCheck(this, Theme);

        this.id = null;
        this.lonlat = null;
        this.location = null;
        this.data = null;
        this.shapes = null;
        this.layer = null;
        this.CLASS_NAME = "SuperMap.Feature.Theme";

        if (!data) return;
        // layer 必须已经添加到地图, 且已初始化渲染器
        if (!layer || !layer.map || !layer.renderer) return;

        this.id = _Util.Util.createUniqueID(this.CLASS_NAME + "_");

        this.data = data;
        this.layer = layer;

        this.location = [];
        this.shapes = [];
    }

    /**
     * APIMethod: destroy
     * 销毁专题要素。
     */


    /**
     * APIProperty: layer
     * {<SuperMap.Layer.Theme>} {ReadOnly} 此专题要素所在专题图层。
     */


    /**
     * APIProperty: data
     * {Object} {ReadOnly} 用户数据，用于生成可视化 shape，可在子类中规定数据格式或类型，如： <SuperMap.Feature.Vector> 。
     */


    /**
     * APIProperty: lonlat
     * {<SuperMap.LonLat>} 专题要素地理参考位置。子类中必须根据用户数据（或地理位置参数）对其赋值。
     */


    _createClass(Theme, [{
        key: 'destroy',
        value: function destroy() {
            this.data = null;
            this.id = null;
            this.lonlat = null;
            this.location = null;
            this.shapes = null;
            this.layer = null;
        }

        /**
         * Method: getLocalXY
         * 地理坐标转为像素坐标。
         *
         * Parameters:
         * coordinate - {<SuperMap.Geometry.Point>/<SuperMap.Geometry.GeoText>/<SuperMap.LonLat>} 地理坐标点。
         *
         * Returns:
         * {Array} 长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
         */

    }, {
        key: 'getLocalXY',
        value: function getLocalXY(coordinate) {
            var resolution = this.layer.map.getResolution();
            var extent = this.layer.map.getExtent();

            if (coordinate instanceof _SuperMap2["default"].Geometry.Point || coordinate instanceof _SuperMap2["default"].Geometry.GeoText) {
                var x = coordinate.x / resolution + -extent.left / resolution;
                var y = extent.top / resolution - coordinate.y / resolution;
                return [x, y];
            } else if (coordinate instanceof _SuperMap2["default"].LonLat) {
                var x = coordinate.lon / resolution + -extent.left / resolution;
                var y = extent.top / resolution - coordinate.lat / resolution;
                return [x, y];
            } else {
                return null;
            }
        }
    }]);

    return Theme;
}();

exports["default"] = Theme;

_SuperMap2["default"].Feature.Theme = Theme;

/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _Shape2 = __webpack_require__(12);

var _Shape3 = _interopRequireDefault(_Shape2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @private
 * @class  SuperMap.LevelRenderer.Shape.SmicPolygon
 * 多边形。
 *
 * Inherits from:
 *  - <SuperMap.LevelRenderer.Shape>
 *
 * (code)
 *   var shape = new SuperMap.LevelRenderer.Shape.SmicPolygon({
 *         style: {
 *             // 100x100 的正方形
 *             pointList: [[0, 0], [100, 0], [100, 100], [0, 100]],
 *             color: 'blue'
 *         }
 *   });
 *   levelRenderer.addShape(shape);
 * (end)
 */
var SmicPolygon = function (_Shape) {
    _inherits(SmicPolygon, _Shape);

    /**
     * Constructor: SuperMap.LevelRenderer.Shape.SmicPolygon
     * 构造函数。
     *
     * Parameters:
     * options - {Array} shape 的配置（options）项，可以是 shape 的自有属性，也可以是自定义的属性。
     *
     */


    /**
     * Property: style
     * {Object} 绘制样式。
     *
     * Symbolizer properties:
     * pointList - {Array} 节点数组，二维数组。默认值：null，必设参数。其形式如下：
     * (code)
     * (start code)
     *  [
     *  [10, 20],         //单个节点
     *  [30, 40],
     *  [25, 30]
     *   ]
     * (end)
     * smooth - {string} 是否做平滑插值, 平滑算法可以选择 "bezier", "spline"。默认值："";
     * smoothConstraint - {Number} 平滑约束。
     * brushType - {String} 画笔类型。可设值："fill", "stroke", "both"。默认值："fill"。
     * color - {String} 填充颜色。默认值："#000000'"。
     * strokeColor - {String} 描边颜色。默认值："#000000'"。
     * lineCape - {String} 线帽样式。可设值："butt", "round", "square"。默认值："butt"。
     * lineWidth - {Number} 描边宽度。默认值：1。
     * opacity - {Number} 绘制透明度。默认值：1。
     * shadowBlur - {Number} 阴影模糊度，大于0有效。默认值：0。
     * shadowColor - {Number} 阴影颜色。默认值："#000000'"。
     * shadowOffsetX - {Number} 阴影横向偏移。默认值：0。
     * shadowOffsetY - {Number} 阴影纵向偏移。默认值：0。
     * text - {String} 图形中的附加文本。默认值：""。
     * textColor - {String} 文本颜色。默认值："#000000'"。
     * textFont - {String} 附加文本样式。示例:'bold 18px verdana'。
     * textPosition - {String} 附加文本位置。可设值："inside", "left", "right", top", "bottom", "end"。默认值："end"。
     * textAlign - {String} 附加文本水平对齐。可设值："start", "end", "left", "right", "center"。默认根据 textPosition 自动设置。
     * textBaseline - {String} 附加文本垂直对齐。可设值："top", "bottom", "middle", "alphabetic", "hanging", "ideographic"。默认根据 textPosition 自动设置。
     */
    //打开接口 style

    /**
     * Property: type
     * {String} 图形类型.
     */
    function SmicPolygon(options) {
        _classCallCheck(this, SmicPolygon);

        var _this = _possibleConstructorReturn(this, (SmicPolygon.__proto__ || Object.getPrototypeOf(SmicPolygon)).call(this, options));

        _this.type = 'smicpolygon';
        _this.holePolygonPointLists = null;
        _this.CLASS_NAME = "SuperMap.LevelRenderer.Shape.SmicPolygon";

        if (!_this.refOriginalPosition || _this.refOriginalPosition.length !== 2) _this.refOriginalPosition = [0, 0];
        return _this;
    }

    /**
     * APIMethod: destroy
     * 销毁对象，释放资源。调用此函数后所有属性将被置为 null。
     */


    /**
     * APIProperty: _holePolygonPointList
     * {Array} 岛洞面多边形顶点数组（三维数组）
     *
     */


    _createClass(SmicPolygon, [{
        key: 'destroy',
        value: function destroy() {
            this.type = null;
            this.holePolygonPointLists = null;
            _get(SmicPolygon.prototype.__proto__ || Object.getPrototypeOf(SmicPolygon.prototype), 'destroy', this).call(this);
        }

        /**
         * APIMethod: brush
         * 笔触。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * isHighlight - {Boolean} 是否使用高亮属性。
         *
         */

    }, {
        key: 'brush',
        value: function brush(ctx, isHighlight) {
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) this.refOriginalPosition = [0, 0];

            var style = this.style;
            if (isHighlight) {
                // 根据style扩展默认高亮样式
                style = this.getHighlightStyle(style, this.highlightStyle || {});
            }

            ctx.save();
            this.setContext(ctx, style);

            // 设置 transform
            this.setTransform(ctx);

            // 先 fill 再stroke
            var hasPath = false;
            if (style.brushType == 'fill' || style.brushType == 'both' || typeof style.brushType == 'undefined') {
                // 默认为fill
                ctx.beginPath();
                if (style.lineType == 'dashed' || style.lineType == 'dotted' || style.lineType == 'dot' || style.lineType == 'dash' || style.lineType == 'dashot' || style.lineType == 'longdash' || style.lineType == 'longdashdot') {
                    // 特殊处理，虚线围不成path，实线再build一次
                    this.buildPath(ctx, {
                        lineType: 'solid',
                        lineWidth: style.lineWidth,
                        pointList: style.pointList
                    });
                    hasPath = false; // 这个path不能用
                } else {
                    this.buildPath(ctx, style);
                    hasPath = true; // 这个path能用
                }
                ctx.closePath();
                this.setCtxGlobalAlpha(ctx, "fill", style);
                ctx.fill();
                this.setCtxGlobalAlpha(ctx, "reset", style);
            }

            if (style.lineWidth > 0 && (style.brushType == 'stroke' || style.brushType == 'both')) {
                if (!hasPath) {
                    ctx.beginPath();
                    this.buildPath(ctx, style);
                }
                this.setCtxGlobalAlpha(ctx, "stroke", style);
                ctx.stroke();
                this.setCtxGlobalAlpha(ctx, "reset", style);
            }

            this.drawText(ctx, style, this.style);

            //岛洞
            var hpStyle = _SuperMap2["default"].Util.cloneObject(style);

            if (hpStyle.pointList) {
                if (this.holePolygonPointLists && this.holePolygonPointLists.length > 0) {
                    var holePLS = this.holePolygonPointLists;
                    var holePLSen = holePLS.length;
                    for (var i = 0; i < holePLSen; i++) {
                        var holePL = holePLS[i];
                        //岛洞面
                        hpStyle.pointList = holePL;

                        ctx.globalCompositeOperation = "destination-out";
                        // 先 fill 再stroke
                        var hasPath = false;
                        if (hpStyle.brushType == 'fill' || hpStyle.brushType == 'both' || typeof hpStyle.brushType == 'undefined') {
                            // 默认为fill
                            ctx.beginPath();
                            if (hpStyle.lineType == 'dashed' || hpStyle.lineType == 'dotted' || hpStyle.lineType == 'dot' || hpStyle.lineType == 'dash' || hpStyle.lineType == 'dashot' || hpStyle.lineType == 'longdash' || hpStyle.lineType == 'longdashdot') {
                                // 特殊处理，虚线围不成path，实线再build一次
                                this.buildPath(ctx, {
                                    lineType: 'solid',
                                    lineWidth: hpStyle.lineWidth,
                                    pointList: hpStyle.pointList
                                });
                                hasPath = false; // 这个path不能用
                            } else {
                                this.buildPath(ctx, hpStyle);
                                hasPath = true; // 这个path能用
                            }
                            ctx.closePath();
                            this.setCtxGlobalAlpha(ctx, "fill", hpStyle);
                            ctx.fill();
                            this.setCtxGlobalAlpha(ctx, "reset", hpStyle);
                        }

                        if (hpStyle.lineWidth > 0 && (hpStyle.brushType == 'stroke' || hpStyle.brushType == 'both')) {
                            if (!hasPath) {
                                ctx.beginPath();
                                this.buildPath(ctx, hpStyle);
                            }
                            //如果描边，先回复 globalCompositeOperation 默认值再描边。
                            ctx.globalCompositeOperation = "source-over";
                            this.setCtxGlobalAlpha(ctx, "stroke", hpStyle);
                            ctx.stroke();
                            this.setCtxGlobalAlpha(ctx, "reset", hpStyle);
                        } else {
                            ctx.globalCompositeOperation = "source-over";
                        }
                    }
                }
            }
            hpStyle = null;

            ctx.restore();
            return;
        }

        /**
         * APIMethod: buildPath
         * 创建多边形路径。
         *
         * Parameters:
         * ctx - {CanvasRenderingContext2D} Context2D 上下文。
         * style - {Object} style。
         *
         */

    }, {
        key: 'buildPath',
        value: function buildPath(ctx, style) {
            if (style.showShadow) {
                ctx.shadowBlur = style.shadowBlur;
                ctx.shadowColor = style.shadowColor;
                ctx.shadowOffsetX = style.shadowOffsetX;
                ctx.shadowOffsetY = style.shadowOffsetY;
            }
            if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) this.refOriginalPosition = [0, 0];
            var __OP = this.refOriginalPosition;

            // 虽然能重用 brokenLine，但底层图形基于性能考虑，重复代码减少调用吧
            var pointList = style.pointList;

            if (pointList.length < 2) {
                // 少于2个点就不画了~
                return;
            }

            if (style.smooth && style.smooth !== 'spline') {
                var controlPoints = _SuperMap2["default"].LevelRenderer.SUtil_smoothBezier(pointList, style.smooth, true, style.smoothConstraint, __OP);

                ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                var cp1;
                var cp2;
                var p;
                var len = pointList.length;
                for (var i = 0; i < len; i++) {
                    cp1 = controlPoints[i * 2];
                    cp2 = controlPoints[i * 2 + 1];
                    p = [pointList[(i + 1) % len][0] + __OP[0], pointList[(i + 1) % len][1] + __OP[1]];
                    ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], p[0], p[1]);
                }
            } else {
                if (style.smooth === 'spline') {
                    pointList = _SuperMap2["default"].LevelRenderer.SUtil_smoothSpline(pointList, true, null, __OP);
                }

                if (!style.lineType || style.lineType == 'solid') {
                    // 默认为实线
                    ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                    for (var i = 1, l = pointList.length; i < l; i++) {
                        ctx.lineTo(pointList[i][0] + __OP[0], pointList[i][1] + __OP[1]);
                    }
                    ctx.lineTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                }
                // SMIC-方法修改 - start
                else if (style.lineType === 'dashed' || style.lineType === 'dotted' || style.lineType === 'dot' || style.lineType === 'dash' || style.lineType === 'longdash') {
                        var dashLengthForStyle = style._dashLength || (style.lineWidth || 1) * (style.lineType == 'dashed' ? 5 : 1);
                        style._dashLength = dashLengthForStyle;

                        var dashLength = style.lineWidth || 1;
                        var pattern1 = dashLength;
                        var pattern2 = dashLength;

                        //dashed
                        if (style.lineType === 'dashed') {
                            pattern1 *= 5;
                            pattern2 *= 5;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 -= dashLength;
                                pattern2 += dashLength;
                            }
                        }

                        //dotted
                        if (style.lineType === 'dotted') {
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 = 1;
                                pattern2 += dashLength;
                            }
                        }

                        //dot
                        if (style.lineType === 'dot') {
                            pattern2 *= 4;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 = 1;
                                pattern2 += dashLength;
                            }
                        }

                        //dash
                        if (style.lineType === 'dash') {
                            pattern1 *= 4;
                            pattern2 *= 4;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 -= dashLength;
                                pattern2 += dashLength;
                            }
                        }

                        //longdash
                        if (style.lineType === 'longdash') {
                            pattern1 *= 8;
                            pattern2 *= 4;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 -= dashLength;
                                pattern2 += dashLength;
                            }
                        }

                        ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                        for (var i = 1, l = pointList.length; i < l; i++) {
                            _SuperMap2["default"].LevelRenderer.SUtil_dashedLineTo(ctx, pointList[i - 1][0] + __OP[0], pointList[i - 1][1] + __OP[1], pointList[i][0] + __OP[0], pointList[i][1] + __OP[1], dashLength, [pattern1, pattern2]);
                        }
                        _SuperMap2["default"].LevelRenderer.SUtil_dashedLineTo(ctx, pointList[pointList.length - 1][0] + __OP[0], pointList[pointList.length - 1][1] + __OP[1], pointList[0][0] + __OP[0], pointList[0][1] + __OP[1], dashLength, [pattern1, pattern2]);
                    } else if (style.lineType === 'dashot' || style.lineType === 'longdashdot') {
                        var dashLengthForStyle = style._dashLength || (style.lineWidth || 1) * (style.lineType == 'dashed' ? 5 : 1);
                        style._dashLength = dashLengthForStyle;

                        var dashLength = style.lineWidth || 1;
                        var pattern1 = dashLength;
                        var pattern2 = dashLength;
                        var pattern3 = dashLength;
                        var pattern4 = dashLength;

                        //dashot
                        if (style.lineType === 'dashot') {
                            pattern1 *= 4;
                            pattern2 *= 4;
                            pattern4 *= 4;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 -= dashLength;
                                pattern2 += dashLength;
                                pattern3 = 1;
                                pattern4 += dashLength;
                            }
                        }

                        //longdashdot
                        if (style.lineType === 'longdashdot') {
                            pattern1 *= 8;
                            pattern2 *= 4;
                            pattern4 *= 4;
                            if (style.lineCap && style.lineCap !== "butt") {
                                pattern1 -= dashLength;
                                pattern2 += dashLength;
                                pattern3 = 1;
                                pattern4 += dashLength;
                            }
                        }

                        ctx.moveTo(pointList[0][0] + __OP[0], pointList[0][1] + __OP[1]);
                        for (var i = 1, l = pointList.length; i < l; i++) {
                            _SuperMap2["default"].LevelRenderer.SUtil_dashedLineTo(ctx, pointList[i - 1][0] + __OP[0], pointList[i - 1][1] + __OP[1], pointList[i][0] + __OP[0], pointList[i][1] + __OP[1], dashLength, [pattern1, pattern2, pattern3, pattern4]);
                        }
                        _SuperMap2["default"].LevelRenderer.SUtil_dashedLineTo(ctx, pointList[pointList.length - 1][0] + __OP[0], pointList[pointList.length - 1][1] + __OP[1], pointList[0][0] + __OP[0], pointList[0][1] + __OP[1], dashLength, [pattern1, pattern2, pattern3, pattern4]);
                    }
            }
            return;
        }

        /**
         * APIMethod: getRect
         * 计算返回多边形包围盒矩阵。
         * 该包围盒是直接从四个控制点计算，并非最小包围盒。
         *
         * Parameters:
         * style - {Object} style
         *
         * Returns:
         * {Object} 边框对象。包含属性：x，y，width，height。
         */

    }, {
        key: 'getRect',
        value: function getRect(style, refOriginalPosition) {
            var __OP;
            if (!refOriginalPosition) {
                if (!this.refOriginalPosition || this.refOriginalPosition.length !== 2) this.refOriginalPosition = [0, 0];
                __OP = this.refOriginalPosition;
            } else {
                __OP = refOriginalPosition;
            }

            if (style.__rect) {
                return style.__rect;
            }

            var minX = Number.MAX_VALUE;
            var maxX = Number.MIN_VALUE;
            var minY = Number.MAX_VALUE;
            var maxY = Number.MIN_VALUE;

            var pointList = style.pointList;
            for (var i = 0, l = pointList.length; i < l; i++) {
                if (pointList[i][0] + __OP[0] < minX) {
                    minX = pointList[i][0] + __OP[0];
                }
                if (pointList[i][0] + __OP[0] > maxX) {
                    maxX = pointList[i][0] + __OP[0];
                }
                if (pointList[i][1] + __OP[1] < minY) {
                    minY = pointList[i][1] + __OP[1];
                }
                if (pointList[i][1] + __OP[1] > maxY) {
                    maxY = pointList[i][1] + __OP[1];
                }
            }

            var lineWidth;
            if (style.brushType == 'stroke' || style.brushType == 'fill') {
                lineWidth = style.lineWidth || 1;
            } else {
                lineWidth = 0;
            }

            style.__rect = {
                x: Math.round(minX - lineWidth / 2),
                y: Math.round(minY - lineWidth / 2),
                width: maxX - minX + lineWidth,
                height: maxY - minY + lineWidth
            };
            return style.__rect;
        }
    }]);

    return SmicPolygon;
}(_Shape3["default"]);

exports["default"] = SmicPolygon;

_SuperMap2["default"].LevelRenderer.Shape.SmicPolygon = SmicPolygon;

/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class SuperMap.ThemeStyle
 * @classdesc 客户端专题图风格类
 * @param options -{Object} 可选参数。如：<br>
 *         fill - {boolean} 是否填充，不需要填充则设置为 false，默认值为 true。如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染图层。<br>
 *         fillColor - {string} 十六进制填充颜色。默认值为 "#000000"。<br>
 *         fillOpacity - {number} 填充不透明度。取值范围[0, 1]，默认值 1。<br>
 *         stroke - {boolean} 是否描边，不需要描边则设置为false，默认值为 false。如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染图层。<br>
 *         strokeColor - {string} 十六进制描边颜色。默认值为 "#000000"。<br>
 *         strokeOpacity - {number} 描边的不透明度。取值范围[0, 1]，默认值 1。<br>
 *         strokeWidth - {number} 线宽度/描边宽度，默认值 1。<br>
 *         strokeLinecap - {string} 线帽样式。strokeLinecap 有三种类型 “butt", "round", "square"; 默认为"butt"。<br>
 *         strokeLineJoin - {string} 线段连接样式。strokeLineJoin 有三种类型 “miter", "round", "bevel"; 默认为"miter"。<br>
 *         strokeDashstyle - {string} 虚线类型。strokeDashstyle 有八种类型 “dot",“dash",“dashot",“longdash",“longdashdot",“solid", "dashed", "dotted"。默认值 "solid"。solid 表示实线。<br>
 *         pointRadius - {number} 点半径，默认为 6 （像素）。<br>
 *         shadowBlur - {number} 阴影模糊度，（大于 0 有效; 默认值 0）。注：请将 shadowColor 属性与 shadowBlur 属性一起使用，来创建阴影。<br>
 *         shadowColor - {string} 阴影颜色; 默认值 '#000000'。注：请将 shadowColor 属性与 shadowBlur 属性一起使用，来创建阴影。<br>
 *         shadowOffsetX - {number} 阴影 X 方向偏移值; 默认值 0。<br>
 *         shadowOffsetY - {number} 阴影 Y 方向偏移值; 默认值 0。<br>
 *         label - {string} 专题要素附加文本标签内容。<br>
 *         fontColor - {string} 附加文本字体颜色。<br>
 *         fontSize - {number} 附加文本字体大小。默认值 12，单位是像素。<br>
 *         fontStyle - {string} 附加文本字体样式。可设值："normal", "italic", "oblique"; 默认值："normal"。<br>
 *         fontVariant - {string} 附加文本字体变体。可设值："normal", "small-caps"; 默认值："normal"。<br>
 *         fontWeight - {string} 附加文本字体粗细。可设值："normal", "bold", "bolder", "lighter"; 默认值："normal"。<br>
 *         fontFamily - {string} 附加文本字体系列。fontFamily 值是字体族名称或/及类族名称的一个优先表，每个值逗号分割，
 *                               浏览器会使用它可识别的第一个可以使用具体的字体名称（"times"、"courier"、"arial"）或字体系列名称
 *                               （"serif"、"sans-serif"、"cursive"、"fantasy"、"monospace"）。默认值："arial,sans-serif"。<br>
 *         labelPosition - {string} 附加文本位置, 可以是 'inside', 'left', 'right', 'top', 'bottom'; 默认值 'top'。<br>
 *         labelAlign - {string} 附加文本水平对齐。可以是 'left', 'right', 'center'; 默认值 'center'。<br>
 *         labelBaseline - {string} 附加文本垂直对齐。 可以是 'top', 'bottom', 'middle';默认值 'middle'。<br>
 *         labelXOffset - {number} 附加文本在x轴方向的偏移量; 默认值 0。<br>
 *         labelYOffset - {number} 附加文本在y轴方向的偏移量; 默认值 0。<br>
 */
var ThemeStyle =
/**
 * @member SuperMap.ThemeStyle.prototype.labelXOffset -{number}
 * @description  附加文本在x轴方向的偏移量。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.labelAlign -{string}
 * @description 附加文本水平对齐。可以是 'left', 'right', 'center'; 默认值 'center'。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontFamily -{string}
 * @description 附加文本字体系列。fontFamily 值是字体族名称或/及类族名称的一个优先表，每个值逗号分割，浏览器会使用它可识别的第一个
 * 可以使用具体的字体名称（"times"、"courier"、"arial"）或字体系列名称（"serif"、"sans-serif"、"cursive"、"fantasy"、"monospace"）。
 * 默认值："arial,sans-serif".
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontVariant -{string}
 * @description 附加文本字体变体。可设值："normal", "small-caps"; 默认值："normal" 。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontSize -{number}
 * @description 附加文本字体大小。默认值 12，单位是像素。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.label -{string}
 * @description 专题要素附加文本标签内容。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.shadowOffsetX -{number}
 * @description 阴影 X 方向偏移值; 默认值 0。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.shadowBlur -{number}
 * @description   阴影模糊度，（大于 0 有效; 默认值 0）。注：请将 shadowColor 属性与 shadowBlur 属性一起使用，来创建阴影。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeDashstyle -{string}
 * @description   虚线类型； strokeDashstyle 有八种类型 “dot",“dash",“dashot",“longdash",“longdashdot",“solid", "dashed", "dotted";
 * 默认值 "solid"。solid 表示实线。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeLinecap -{string}
 * @description  线帽样式；strokeLinecap 有三种类型 “butt", "round", "square"; 默认为"butt"。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeOpacity -{number}
 * @description  描边的不透明度。取值范围[0, 1]，默认值 1。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.stroke -{boolean}
 * @description  是否描边，不需要描边则设置为false，默认值为 false。如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染图层。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fillColor -{string}
 * @description 十六进制填充颜色。默认值为 "#000000"。
 */
function ThemeStyle(options) {
  _classCallCheck(this, ThemeStyle);

  this.fill = true;
  this.fillColor = "#000000";
  this.fillOpacity = 1;
  this.stroke = false;
  this.strokeColor = "#000000";
  this.strokeOpacity = 1;
  this.strokeWidth = 1;
  this.strokeLinecap = "butt";
  this.strokeLineJoin = "miter";
  this.strokeDashstyle = "solid";
  this.pointRadius = 6;
  this.shadowBlur = 0;
  this.shadowColor = "#000000";
  this.shadowOffsetX = 0;
  this.shadowOffsetY = 0;
  this.label = "";
  this.fontColor = "";
  this.fontSize = 12;
  this.fontStyle = "normal";
  this.fontVariant = "normal";
  this.fontWeight = "normal";
  this.fontFamily = "arial,sans-serif";
  this.labelPosition = "top";
  this.labelAlign = "center";
  this.labelBaseline = "middle";
  this.labelXOffset = 0;
  this.labelYOffset = 0;

  options = options || {};
  _SuperMap2["default"].Util.extend(this, options);
}
/**
 * @member SuperMap.ThemeStyle.prototype.labelYOffset -{number}
 * @description 附加文本在y轴方向的偏移量。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.labelBaseline -{string}
 * @description  附加文本垂直对齐。 可以是 'top', 'bottom', 'middle';默认值 'middle'。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.labelPosition -{string}
 * @description 附加文本位置, 可以是 'inside', 'left', 'right', 'top', 'bottom'; 默认值 'top'。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontWeight -{string}
 * @description 附加文本字体粗细。可设值："normal", "bold", "bolder", "lighter"; 默认值："normal" 。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontStyle -{string}
 * @description 附加文本字体样式。可设值："normal", "italic", "oblique"; 默认值："normal" 。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.fontColor -{string}
 * @description 附加文本字体颜色。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.shadowOffsetY -{number}
 * @description Y 方向偏移值; 默认值 0。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.shadowColor -{string}
 * @description  阴影颜色; 默认值 '#000000'。  注：请将 shadowColor 属性与 shadowBlur 属性一起使用，来创建阴影。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.pointRadius -{number}
 * @description   点半径，默认为 6 （像素）。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeLineJoin -{string}
 * @description  线段连接样式；strokeLineJoin 有三种类型 “miter", "round", "bevel"; 默认为"miter"。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeWidth -{number}
 * @description  线宽度/描边宽度，默认值 1。
 */

/**
 * @member SuperMap.ThemeStyle.prototype.strokeColor -{string}
 * @description  十六进制描边颜色。默认值为 "#000000"。
 */

/**
 *  @member SuperMap.ThemeStyle.prototype.fillOpacity -{number}
 *  @description 填充不透明度。取值范围[0, 1]，默认值 1。
 */


/**
 * @member SuperMap.ThemeStyle.prototype.fill - {boolean}
 * @description 是否填充，不需要填充则设置为 false，默认值为 true。如果 fill 与 stroke 同时为 false，将按 fill 与 stroke 的默认值渲染图层。
 */
;

exports["default"] = ThemeStyle;

_SuperMap2["default"].ThemeStyle = ThemeStyle;

/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.nonEarthCRS = exports.NonEarthCRS = exports.nonProjection = exports.NonProjection = undefined;

__webpack_require__(4);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

_leaflet2["default"].Projection = {};

/**
 * @private
 * @class L.Projection.NonProjection
 * @classdesc 平面无投影对象
 * @extends L.Class{@linkdoc-leaflet/#class}
 * @param bounds - {L.bounds} 坐标范围
 */
var NonProjection = exports.NonProjection = _leaflet2["default"].Class.extend({

    initialize: function initialize(bounds) {
        this.bounds = bounds;
    },

    project: function project(latlng) {
        return new _leaflet2["default"].Point(latlng.lng, latlng.lat);
    },

    unproject: function unproject(point) {
        return new _leaflet2["default"].LatLng(point.y, point.x);
    }
});

var nonProjection = exports.nonProjection = function nonProjection(bounds) {
    return new NonProjection(bounds);
};

/**
 * @class L.CRS.NonEarthCRS
 * @classdesc 平面无投影坐标类
 * @extends L.Class{@linkdoc-leaflet/#class}
 * @param options - {Object} 构建平面无投影坐标对象参数<br>
 *        origin - {Object} 原点<br>
 *        bounds - {[L.bounds]{@linkdoc-leaflet/#bounds}|Array<number>} 范围<br>
 *        resolutions - {Array<number>} 分辨率
 */
var NonEarthCRS = exports.NonEarthCRS = _leaflet2["default"].Class.extend({

    /*
     * @member L.CRS.NonEarthCRS.prototype.includes -{Object}
     * @description 包含的坐标对象，默认为：L.CRS。
     */
    includes: _leaflet2["default"].CRS,

    initialize: function initialize(options) {
        if (options.origin) {
            this.transformation = new _leaflet2["default"].Transformation(1, -options.origin.x, -1, options.origin.y);
        }
        this.projection = _leaflet2["default"].Projection.NonProjection(options.bounds);
        this.bounds = options.bounds;
        this.origin = options.origin;
        this.resolutions = options.resolutions;
    },

    /**
     * @function L.CRS.NonEarthCRS.prototype.scale
     * @description 通过缩放级别计算比例尺
     * @param zoom - {number}缩放级别
     * @return {number} 得到的比例尺
     */
    scale: function scale(zoom) {
        if (!this.resolutions || this.resolutions.length === 0) {
            var width = Math.max(this.bounds.getSize().x, this.bounds.getSize().y);
            var defaultScale = 1 / (width / 256);
            return defaultScale * Math.pow(2, zoom);
        }
        return 1 / this.resolutions[zoom];
    },

    /**
     * @function L.CRS.NonEarthCRS.prototype.zoom
     * @description 通过比例尺计算范围
     * @param scale - {number}比例尺
     * @return {number} 返回空间范围值
     */
    zoom: function zoom(scale) {
        if (!this.resolutions || this.resolutions.length === 0) {
            var width = Math.max(this.bounds.getSize().x, this.bounds.getSize().y);
            var defaultScale = 1 / (width / 256);
            return scale / defaultScale;
        }
        for (var i = 0; i < this.resolutions.length; i++) {
            if (1 / this.resolutions == scale) {
                return i;
            }
        }
        return -1;
    },

    /**
     * @function L.CRS.NonEarthCRS.prototype.distance
     * @description 通过两个坐标点计算之间的距离
     * @param latlng1 - {L.latLng} 坐标点1
     * @param latlng2 - {L.latLng} 坐标点2
     * @return {number} 返回距离长度
     */
    distance: function distance(latlng1, latlng2) {
        var dx = latlng2.lng - latlng1.lng,
            dy = latlng2.lat - latlng1.lat;

        return Math.sqrt(dx * dx + dy * dy);
    },

    infinite: true
});
var nonEarthCRS = exports.nonEarthCRS = function nonEarthCRS(options) {
    return new NonEarthCRS(options);
};
_leaflet2["default"].Projection.NonProjection = nonProjection;

_leaflet2["default"].CRS.NonEarthCRS = nonEarthCRS;

/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorTileFormat = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @constant L.supermap.VectorTileFormat
 * @classdesc 矢量瓦片格式
 */
var VectorTileFormat = exports.VectorTileFormat = {
  JSON: "JSON",
  MVT: "MVT",
  PBF: "PBF"
};
_leaflet2["default"].supermap.VectorTileFormat = VectorTileFormat;

/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CartoCSSToLeaflet = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

__webpack_require__(4);

__webpack_require__(408);

__webpack_require__(409);

__webpack_require__(5);

var _CartoCSS = __webpack_require__(404);

var _CartoCSS2 = _interopRequireDefault(_CartoCSS);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class L.supermap.CartoCSSToLeaflet
 * @classdesc CartoCSS样式转Leaflet样式类
 * @param url - {String} 地图服务地址
 * @private
 */
var CartoCSSToLeaflet = exports.CartoCSSToLeaflet = function () {

    /**
     * @member L.supermap.CartoCSSToLeaflet.prototype.cartoCSS
     * @description CartoCSS样式
     */
    function CartoCSSToLeaflet(url) {
        _classCallCheck(this, CartoCSSToLeaflet);

        this.cartoCSS = null;
        this.mapUrl = null;

        this.mapUrl = url;
    }

    /**
     * @function L.supermap.CartoCSSToLeaflet.prototype.pretreatedCartoCSS
     * @description CartoCSS样式预处理
     * @param cartoStr - {string} Carto信息
     * @param processCharacters - {Object} 需要处理的特征对象
     */


    /**
     * @member L.supermap.CartoCSSToLeaflet.prototype.mapUrl
     * @description 地图服务地址
     */


    _createClass(CartoCSSToLeaflet, [{
        key: 'pretreatedCartoCSS',
        value: function pretreatedCartoCSS(cartoStr, processCharacters) {
            if (processCharacters) {
                cartoStr = this.processCharacters(cartoStr);
            }
            this.cartoCSS = this.cartoCSS || {};
            var shaders = new _CartoCSS2["default"](cartoStr).getShaders();
            if (!shaders) {
                return;
            }
            for (var i = 0; i < shaders.length; i++) {
                var element = shaders[i].elements[0];
                var attachment = shaders[i].attachment;
                this.cartoCSS[element.clean] = this.cartoCSS[element.clean] || {};
                this.cartoCSS[element.clean][attachment] = this.cartoCSS[element.clean][attachment] || [];
                this.cartoCSS[element.clean][attachment].push(shaders[i]);
            }
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.processCharacters
         * @description 替换一些关键符号
         * @param cartoCSSStr - {string} cartoCSSS信息
         */

    }, {
        key: 'processCharacters',
        value: function processCharacters(cartoCSSStr) {
            var style = cartoCSSStr;
            if (!style) {
                return;
            }
            var me = this;
            style = style.replace(/[@]/gi, "___");
            style = style.replace(/\\#/gi, "___");
            for (var attr in me.layersInfo) {
                var newAttr = attr.replace(/[@#\s]/gi, "___");
                style = style.replace(attr.replace(/[#]/gi, "\\#"), newAttr);
            }
            style = style.replace(/[#]/gi, "\n#");
            //将zoom转化为scale，以免引起混淆
            style = style.replace(/\[zoom/gi, "[scale");
            return style;
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.pickShader
         * @description 拾取着色对象
         * @param layerName - {string} 图层名称
         */

    }, {
        key: 'pickShader',
        value: function pickShader(layerName) {
            if (!this.cartoCSS) {
                return null;
            }
            var name = layerName.replace(/[@#\s]/gi, "___");
            return this.cartoCSS[name];
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.getDefaultStyle
         * @description 获取默认风格
         * @param type - {string} 默认风格类型
         */

    }, {
        key: 'getDefaultStyle',
        value: function getDefaultStyle(type) {
            var style = {};
            //设置默认值
            var expandStyle = _leaflet2["default"].supermap.DefaultStyle[type];
            for (var prop in expandStyle) {
                var val = expandStyle[prop];
                style[prop] = val;
            }
            return style;
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.getStyleFromiPortalMarker
         * @description 从iPortalMarker中获取样式
         * @param icon - {string} iPortal图标
         */

    }, {
        key: 'getStyleFromiPortalMarker',
        value: function getStyleFromiPortalMarker(icon) {
            if (icon.indexOf("./") == 0) {
                return null;
            }
            //兼容iportal示例的问题
            if (icon.indexOf("http://support.supermap.com.cn:8092/static/portal") == 0) {
                icon = icon.replace("http://support.supermap.com.cn:8092/static/portal", "http://support.supermap.com.cn:8092/apps/viewer/static");
            }
            return _leaflet2["default"].icon({
                iconUrl: icon,
                iconSize: _leaflet2["default"].point(48, 43),
                iconAnchor: _leaflet2["default"].point(24, 43),
                popupAnchor: _leaflet2["default"].point(0, -43)
            });
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.getStyleFromiPortalStyle
         * @description 从iPortal的风格中获取样式
         * @param iPortalStyle - {Object} iPortal的样式对象
         * @param type - {string} 样式类型
         * @param fStyle -{Object} 图标参数
         */

    }, {
        key: 'getStyleFromiPortalStyle',
        value: function getStyleFromiPortalStyle(iPortalStyle, type, fStyle) {
            var featureStyle = fStyle ? JSON.parse(fStyle) : null;
            var style = {};
            if (type === 'Point' || type === 'MultiPoint') {
                var pointStyle = featureStyle || iPortalStyle.pointStyle;
                if (pointStyle.externalGraphic) {
                    if (pointStyle.externalGraphic.indexOf("./") == 0) {
                        return null;
                    }
                    //兼容iportal示例的问题
                    if (pointStyle.externalGraphic.indexOf("http://support.supermap.com.cn:8092/static/portal") == 0) {
                        pointStyle.externalGraphic = pointStyle.externalGraphic.replace("http://support.supermap.com.cn:8092/static/portal", "http://support.supermap.com.cn:8092/apps/viewer/static");
                    }
                    return _leaflet2["default"].icon({
                        iconUrl: pointStyle.externalGraphic,
                        iconSize: _leaflet2["default"].point(pointStyle.graphicWidth, pointStyle.graphicHeight),
                        iconAnchor: _leaflet2["default"].point(-pointStyle.graphicXOffset, -pointStyle.graphicYOffset),
                        popupAnchor: _leaflet2["default"].point(0, -pointStyle.graphicHeight)
                    });
                }
                style.radius = pointStyle.pointRadius;
                style.color = pointStyle.strokeColor;
                style.opacity = pointStyle.strokeOpacity;
                style.lineCap = pointStyle.strokeLineCap;
                style.weight = pointStyle.strokeWidth;
                style.fillColor = pointStyle.fillColor;
                style.fillOpacity = pointStyle.fillOpacity;
                style.dashArray = this.dashStyle(pointStyle, 1);
                return style;
            }
            if (type === 'LineString' || type === 'MultiLineString' || type === 'Box') {
                var lineStyle = featureStyle || iPortalStyle.lineStyle;
                style.color = lineStyle.strokeColor;
                style.opacity = lineStyle.strokeOpacity;
                style.fillOpacity = lineStyle.fillOpacity;
                style.lineCap = lineStyle.strokeLineCap;
                style.weight = lineStyle.strokeWidth;
                style.dashArray = this.dashStyle(lineStyle, 1);
                return style;
            }
            if (type === 'Polygon' || type === 'MultiPolygon') {
                var polygonStyle = featureStyle || iPortalStyle.polygonStyle;
                style.color = polygonStyle.strokeColor;
                style.opacity = polygonStyle.strokeOpacity;
                style.lineCap = polygonStyle.strokeLineCap;
                style.weight = polygonStyle.strokeWidth;
                style.fillColor = polygonStyle.fillColor;
                style.fillOpacity = polygonStyle.fillOpacity;
                style.dashArray = this.dashStyle(polygonStyle, 1);
                return style;
            }
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.dashStyle
         * @description 符号样式
         * @param style -{Object} 样式参数
         * @param widthFactor -{number}宽度系数
         */

    }, {
        key: 'dashStyle',
        value: function dashStyle(style, widthFactor) {
            if (!style) return [];
            var w = style.strokeWidth * widthFactor;
            var str = style.strokeDashstyle;
            switch (str) {
                case 'solid':
                    return [];
                case 'dot':
                    return [1, 4 * w];
                case 'dash':
                    return [4 * w, 4 * w];
                case 'dashdot':
                    return [4 * w, 4 * w, 1, 4 * w];
                case 'longdash':
                    return [8 * w, 4 * w];
                case 'longdashdot':
                    return [8 * w, 4 * w, 1, 4 * w];
                default:
                    if (!str) return [];
                    if (_SuperMap2["default"].Util.isArray(str)) return str;
                    str = _SuperMap2["default"].String.trim(str).replace(/\s+/g, ",");
                    return str.replace(/\[|\]/gi, "").split(",");
            }
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.getValidStyleFromCarto
         * @description 从Carto中获取有效的样式
         * @param zoom - {number}缩放级别
         * @param scale - {number}比例尺
         * @param shader - {Array<Object>} 渲染器对象数组
         * @param feature - {L.feature} 要素
         * @param fromServer - {string} 服务源
         */

    }, {
        key: 'getValidStyleFromCarto',
        value: function getValidStyleFromCarto(zoom, scale, shader, feature, fromServer) {
            if (!shader) {
                return null;
            }
            var type = feature.type,
                attributes = feature.properties.attributes || {},
                style = this.getDefaultStyle(type);
            fromServer = fromServer === undefined ? true : fromServer;

            attributes.FEATUREID = feature.properties.id;
            attributes.SCALE = scale;

            var cartoStyleMap = _leaflet2["default"].supermap.CartoStyleMap[type];

            var fontSize, fontName;
            for (var i = 0, len = shader.length; i < len; i++) {
                var _shader = shader[i];
                var prop = cartoStyleMap[_shader.property];
                var value = _shader.getValue(attributes, zoom, true);
                if (value !== null && prop) {
                    if (prop === "fontSize") {
                        value = fromServer ? value *= 0.8 : value;
                        fontSize = value + "px";
                        style.fontSize = fontSize;
                    } else if (prop === "fontName") {
                        fontName = value;
                    } else {
                        if (prop === "globalCompositeOperation") {
                            value = _leaflet2["default"].supermap.CompOpMap[value];
                            if (!value || value === "") continue;
                        } else if (fromServer && prop === 'iconUrl') {
                            value = this.mapUrl + '/tileFeature/symbols/' + value.replace(/(___)/gi, '@');
                            value = value.replace(/(__0__0__)/gi, '__8__8__');
                            style["iconUrl"] = value;
                            continue;
                        }
                        if (prop === 'weight' && value < 1) {
                            value = Math.ceil(value);
                        }
                        style[prop] = value;
                    }
                }
            }
            return style;
        }

        /**
         * @function L.supermap.CartoCSSToLeaflet.prototype.getValidStyleFromLayerInfo
         * @description 通过图层信息获取有效的样式
         * @param feature - {SuperMap.Feature} 要素
         * @param layerInfo - {Object} 图层信息
         */

    }, {
        key: 'getValidStyleFromLayerInfo',
        value: function getValidStyleFromLayerInfo(feature, layerInfo) {
            var type = feature.type,
                style = this.getDefaultStyle(type),
                shader = layerInfo && layerInfo.layerStyle;
            if (!shader) {
                return style;
            }
            if (type === "POINT") {
                var size = Math.ceil(shader.markerSize * _SuperMap2["default"].DOTS_PER_INCH * _SuperMap2["default"].INCHES_PER_UNIT["mm"]) || 8;
                var symbolParameters = {
                    "transparent": true,
                    "resourceType": "SYMBOLMARKER",
                    "picWidth": size,
                    "picHeight": size,
                    "style": JSON.stringify(shader)
                };
                style.iconUrl = _SuperMap2["default"].Util.urlAppend(this.mapUrl + "/symbol.png", _SuperMap2["default"].Util.getParameterString(symbolParameters));
                style.iconSize = [size, size];
                return style;
            }
            if (type === "TEXT") {
                shader = feature.properties.textStyle || layerInfo.layerStyle;
                //设置文本是否使用粗体
                style.fontWeight = shader.bold ? shader.fontWeight : "normal";
                //设置文本的尺寸（对应fontHeight属性）和行高，行高iserver不支持，默认5像素
                //固定大小的时候单位是毫米
                if (shader.fontHeight) {
                    var text_h = shader.fontHeight * _SuperMap2["default"].DOTS_PER_INCH * _SuperMap2["default"].INCHES_PER_UNIT["mm"] * 0.85; //毫米转像素,服务端的字体貌似要稍微小一点
                    style.fontSize = text_h + "px";
                    style.textHeight = text_h;
                }

                //设置文本字体类型
                //在桌面字体钱加@时为了解决对联那种形式，但是在canvas不支持，并且添加了@会导致
                //字体大小被固定，这里需要去掉
                if (shader.fontName) {
                    style.fontFamily = shader.fontName.indexOf("@") ? shader.fontName.replace(/@/g, "") : shader.fontName;
                }

                //设置对齐方式
                if (shader.align) {
                    var alignStr = shader.align.replace(/TOP|MIDDLE|BASELINE|BOTTOM/, "");
                    style.textAlign = alignStr.toLowerCase();
                }
                style.weight = shader.outline ? shader.outlineWidth : 0;
                if (shader.backColor) {
                    style.color = "rgba(" + shader.backColor.red + "," + shader.backColor.green + "," + shader.backColor.blue + ",1)";
                }
                if (shader.foreColor) {
                    style.fillColor = "rgba(" + shader.foreColor.red + "," + shader.foreColor.green + "," + shader.foreColor.blue + ",1)";
                }
                style.rotation = shader.rotation || 0;
                return style;
            }
            //目前只实现桌面系统默认的几种symbolID，非系统默认的面用颜色填充替代，线则用实线来替代
            var fillSymbolID = shader["fillSymbolID"] > 7 ? 0 : shader["fillSymbolID"];
            var lineSymbolID = shader["lineSymbolID"] > 5 ? 0 : shader["lineSymbolID"];
            for (var attr in shader) {
                var obj = _leaflet2["default"].supermap.ServerStyleMap[attr];
                if (!obj) {
                    continue;
                }
                var leafletStyle = obj.leafletStyle;
                switch (obj.type) {
                    case "number":
                        var value = shader[attr];
                        if (obj.unit) {
                            value = value * _SuperMap2["default"].DOTS_PER_INCH * _SuperMap2["default"].INCHES_PER_UNIT[obj.unit] * 2.5;
                        }
                        style[leafletStyle] = value;
                        break;

                    case "color":
                        var color = shader[attr];
                        var value,
                            alpha = 1;
                        if (leafletStyle === "fillColor") {
                            if (fillSymbolID === 0 || fillSymbolID === 1) {
                                //当fillSymbolID为0时，用颜色填充，为1是无填充，即为透明填充，alpha通道为0
                                alpha = 1 - fillSymbolID;
                                value = "rgba(" + color.red + "," + color.green + "," + color.blue + "," + alpha + ")";
                            }
                        } else if (leafletStyle === "color") {
                            if (lineSymbolID === 0 || lineSymbolID === 5) {
                                //对于lineSymbolID为0时，线为实线，为lineSymbolID为5时，为无线模式，即线为透明，即alpha通道为0
                                alpha = lineSymbolID === 0 ? 1 : 0;
                            } else {
                                //以下几种linePattern分别模拟了桌面的SymbolID为1~4几种符号的linePattern
                                var linePattern = [1, 0];
                                switch (lineSymbolID) {
                                    case 1:
                                        linePattern = [9.7, 3.7];
                                        break;
                                    case 2:
                                        linePattern = [3.7, 3.7];
                                        break;
                                    case 3:
                                        linePattern = [9.7, 3.7, 2.3, 3.7];
                                        break;
                                    case 4:
                                        linePattern = [9.7, 3.7, 2.3, 3.7, 2.3, 3.7];
                                        break;
                                    default:
                                        break;
                                }
                                style.lineDasharray = linePattern;
                            }
                            value = "rgba(" + color.red + "," + color.green + "," + color.blue + "," + alpha + ")";
                        }
                        style[leafletStyle] = value;
                        break;
                    default:
                        break;
                }
            }

            //处理标签文本的情况
            if (layerInfo && layerInfo.textField) {
                style.textAlign = "LEFT";
            }
            return style;
        }
    }]);

    return CartoCSSToLeaflet;
}();

_leaflet2["default"].supermap.CartoCSSToLeaflet = CartoCSSToLeaflet;

/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.GeoFeatureThemeLayer = undefined;

__webpack_require__(104);

__webpack_require__(101);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _ThemeLayer = __webpack_require__(110);

var _ThemeFeature = __webpack_require__(109);

var _ServerFeature = __webpack_require__(93);

var _ServerFeature2 = _interopRequireDefault(_ServerFeature);

var _CommontypesConversion = __webpack_require__(23);

var _CommontypesConversion2 = _interopRequireDefault(_CommontypesConversion);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @function L.supermap.GeoFeatureThemeLayer
 * @classdesc  地理几何专题要素型专题图层基类。此类型专题图的专题要素形状就是由 feature.geometry 决定。此类不建议直接实例化调用。
 * @private
 * @extends L.supermap.ThemeLayer
 * @param name - {string} 专题图名
 * @param options - {Object} 需要设置得参数对象。如：<br>
 *        nodesClipPixel - {number}节点抽稀像素距离，默认值 2。<br>
 *        isHoverAble - {boolean} 图形是否在 hover 时高亮 ，默认值：false。<br>
 *        isMultiHover - {boolean} 是否多图形同时高亮，用于高亮同一个数据对应的所有图形（如：多面），默认值：false。<br>
 *        isClickAble - {boolean} 图形是否可点击，默认 true。<br>
 *        isAllowFeatureStyle - {boolean} 是否允许 feature 样式（style） 中的有效属性应用到专题图层。
 *                                        默认值为： false，禁止对专题要素使用数据（feature）的 style。
 *                                        此属性可强制将数据 feature 的 style 中有效属性应用到专题要素上，且拥有比图层 style 和 styleGroups 更高的优先级，使专题要素
 *                                        的样式脱离专题图层的控制。可以通过此方式实现对特殊数据（feature） 对应专题要素赋予独立 style。
 */
var GeoFeatureThemeLayer = exports.GeoFeatureThemeLayer = _ThemeLayer.ThemeLayer.extend({

    options: {

        // {Number} 节点抽稀像素距离，默认值 2。
        nodesClipPixel: 2,

        //{Boolean} 图形是否在 hover 时高亮 ，默认值：false。
        isHoverAble: false,

        //{Boolean} 是否多图形同时高亮，用于高亮同一个数据对应的所有图形（如：多面），默认值：false。
        isMultiHover: false,

        // {Boolean} 图形是否可点击，默认 true
        isClickAble: true,
        //是否允许 feature 样式（style） 中的有效属性应用到专题图层。
        //默认值为： false，禁止对专题要素使用数据（feature）的 style。
        //此属性可强制将数据 feature 的 style 中有效属性应用到专题要素上，且拥有比图层 style 和 styleGroups 更高的优先级，使专题要素
        //的样式脱离专题图层的控制。可以通过此方式实现对特殊数据（feature） 对应专题要素赋予独立 style。
        isAllowFeatureStyle: false
    },

    initialize: function initialize(name, options) {
        _ThemeLayer.ThemeLayer.prototype.initialize.call(this, name, options);
        _leaflet2["default"].Util.setOptions(this, options);
        var me = this;
        me.cache = {};
        me.cacheFields = [];
        me.style = {};
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.addFeatures
     * @description 向专题图图层中添加数据, 支持的feature类型为:iServer返回的feature json对象 或L.supermap.themeFeature类型
     * @param features - {JSONObject|L.supermap.themeFeature} 待填加的要素
     */
    addFeatures: function addFeatures(features) {
        //数组
        if (!_leaflet2["default"].Util.isArray(features)) {
            features = [features];
        }
        var me = this,
            event = { features: features };
        me.fire("beforefeaturesadded", event);
        features = event.features;
        for (var i = 0, len = features.length; i < len; i++) {
            var feature = features[i];
            feature = me._createFeature(feature);
            me.features.push(feature);
        }
        var succeed = me.features.length === 0;
        me.fire("featuresadded", { features: me.features, succeed: succeed });

        if (!me.isCustomSetMaxCacheCount) {
            me.maxCacheCount = me.features.length * 5;
        }

        if (!me.renderer) {
            return;
        }
        //绘制专题要素
        if (me._map) {
            me.redrawThematicFeatures(me._map.getBounds());
        } else {
            me.redrawThematicFeatures();
        }
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.removeFeatures
     * @description 从专题图中删除 feature。这个函数删除所有传递进来的矢量要素。参数中的 features 数组中的每一项，必须是已经添加到当前图层中的 feature，
     * @param features - {L.features} 要删除得要素
     */
    removeFeatures: function removeFeatures(features) {
        this.clearCache();
        _ThemeLayer.ThemeLayer.prototype.removeFeatures.call(this, arguments);
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.removeAllFeatures
     * @description 清除当前图层所有的矢量要素。
     */
    removeAllFeatures: function removeAllFeatures() {
        this.clearCache();
        _ThemeLayer.ThemeLayer.prototype.removeAllFeatures.call(this, arguments);
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.redrawThematicFeatures
     * @description 重绘所有专题要素。
     *              此方法包含绘制专题要素的所有步骤，包含用户数据到专题要素的转换，抽稀，缓存等步骤。
     *              地图漫游时调用此方法进行图层刷新。
     * @param bounds - {L.bounds} 重绘得范围
     */
    redrawThematicFeatures: function redrawThematicFeatures(bounds) {
        var me = this;
        //获取高亮专题要素对应的用户 id
        var hoverone = me.renderer.getHoverOne();
        var hoverFid = null;
        if (hoverone && hoverone.refDataID) {
            hoverFid = hoverone.refDataID;
        }
        bounds = _CommontypesConversion2["default"].toSuperMapBounds(bounds);
        //清除当前所有可视元素
        me.renderer.clearAll();

        var features = me.features;
        var cache = me.cache;
        var cacheFields = me.cacheFields;
        var cmZoom = me._map.getZoom();

        var maxCC = me.maxCacheCount;

        for (var i = 0, len = features.length; i < len; i++) {
            var feature = features[i];
            var feaBounds = feature.geometry.getBounds();

            //剔除当前视图（地理）范围以外的数据
            if (bounds && !bounds.intersectsBounds(feaBounds)) {
                continue;
            }

            //缓存字段
            var fields = feature.id + "_zoom_" + cmZoom.toString();
            if (cache[fields]) {
                cache[fields].updateAndAddShapes();
                continue;
            }

            var thematicFeature = me.createThematicFeature(features[i]);
            //检查 thematicFeature 是否有可视化图形
            if (thematicFeature.getShapesCount() < 1) {
                continue;
            }
            //加入缓存
            cache[fields] = thematicFeature;
            cacheFields.push(fields);
            //缓存数量限制
            if (cacheFields.length > maxCC) {
                var fieldsTemp = cacheFields[0];
                cacheFields.splice(0, 1);
                delete cache[fieldsTemp];
            }
        }

        me.renderer.render();

        //地图漫游后，重新高亮图形
        if (hoverFid && me.options.isHoverAble && me.options.isMultiHover) {
            var hShapes = this.getShapesByFeatureID(hoverFid);
            this.renderer.updateHoverShapes(hShapes);
        }
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.createThematicFeature
     * @description 创建专题要素
     * @param feature - {L.feature} 要创建得要素
     */
    createThematicFeature: function createThematicFeature(feature) {
        var me = this;
        var style = me.getStyleByData(feature);
        if (feature.style && me.isAllowFeatureStyle) {
            style = _SuperMap2["default"].Util.copyAttributesWithClip(feature.style);
        }

        //创建专题要素时的可选参数
        var options = {};
        options.nodesClipPixel = me.options.nodesClipPixel;
        options.isHoverAble = me.options.isHoverAble;
        options.isMultiHover = me.options.isMultiHover;
        options.isClickAble = me.options.isClickAble;
        options.highlightStyle = _SuperMap2["default"].Feature.ShapeFactory.transformStyle(me.highlightStyle);

        //将数据转为专题要素（Vector）
        var thematicFeature = new _SuperMap2["default"].Feature.Theme.Vector(feature, me, _SuperMap2["default"].Feature.ShapeFactory.transformStyle(style), options);

        //直接添加图形到渲染器
        for (var m = 0; m < thematicFeature.shapes.length; m++) {
            me.renderer.addShape(thematicFeature.shapes[m]);
        }

        return thematicFeature;
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.redraw
     * @description 重绘该图层
     */
    redraw: function redraw() {
        this.clearCache();
        return _ThemeLayer.ThemeLayer.prototype.redraw.apply(this, arguments);
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.clearCache
     * @description 清除缓存数据。
     */
    clearCache: function clearCache() {
        this.cache = {};
        this.cacheFields = [];
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.clear
     * @description 清除的内容包括数据（features） 、专题要素、缓存。
     */
    clear: function clear() {
        var me = this;
        me.renderer.clearAll();
        me.renderer.refresh();
        me.removeAllFeatures();
        me.clearCache();
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.getCacheCount
     * @description 获取当前缓存数量。
     * @return {Number} 返回当前缓存数量。
     */
    getCacheCount: function getCacheCount() {
        return this.cacheFields.length;
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.setMaxCacheCount
     * @description 设置最大缓存数量。
     * @param cacheCount - {number}最大缓存量。
     */
    setMaxCacheCount: function setMaxCacheCount(cacheCount) {
        if (isNaN(cacheCount)) {
            return;
        }
        this.maxCacheCount = cacheCount;
        this.isCustomSetMaxCacheCount = true;
    },

    /**
     * @function L.supermap.GeoFeatureThemeLayer.prototype.getShapesByFeatureID
     * @description 通过 FeatureID 获取 feature 关联的所有图形。如果不传入此参数，函数将返回所有图形。
     * @param featureID - {number}要素ID。
     */
    getShapesByFeatureID: function getShapesByFeatureID(featureID) {
        var me = this,
            list = [],
            shapeList = me.renderer.getAllShapes();

        if (!featureID) {
            return shapeList;
        }

        for (var i = 0, len = shapeList.length; i < len; i++) {
            var si = shapeList[i];
            if (si.refDataID && featureID === si.refDataID) {
                list.push(si);
            }
        }
        return list;
    },

    _createFeature: function _createFeature(feature) {
        if (feature instanceof _ThemeFeature.ThemeFeature) {
            feature = feature.toFeature();
        } else if (!(feature instanceof _SuperMap2["default"].Feature.Vector)) {
            feature = new _ServerFeature2["default"].fromJson(feature).toFeature();
        }
        if (!feature.hasOwnProperty("attributes") && feature.fieldNames && feature.filedValues) {
            var attrs = {},
                fieldNames = feature.fieldNames,
                filedValues = feature.filedValues;
            for (var i = 0; i < fieldNames.length; i++) {
                attrs[fieldNames[i]] = filedValues[i];
            }
            feature.attributes = attrs;
        }
        return feature;
    }

});

/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.themeFeature = exports.ThemeFeature = undefined;

__webpack_require__(4);

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.themeFeature
 * @classdesc 客户端专题图要素类。
 *            支持的geometry参数类型为L.Point,L.LatLng,L.Polyline,L.Polygon
 * @extends L.Class{@linkdoc-leaflet/#class}
 * @param geometry - {L.Path|L.Point|L.LatLng} 要素图形
 * @param attributes - {Object} 要素属性
 */
var ThemeFeature = exports.ThemeFeature = _leaflet2["default"].Class.extend({

    initialize: function initialize(geometry, attributes) {
        this.geometry = geometry;
        this.attributes = attributes;
    },

    /**
     * @function L.supermap.themeFeature.prototype.toFeature
     * @description 转为内部矢量要素
     * @return {SuperMap.Feature.Vector} 内部矢量要素
     */
    toFeature: function toFeature() {
        var geometry = this.geometry;
        var points = [];
        if (geometry instanceof _leaflet2["default"].Polyline) {
            points = this.reverseLatLngs(geometry.getLatLngs());
            geometry = new _SuperMap2["default"].Geometry.LineString(points);
        } else if (geometry instanceof _leaflet2["default"].Polygon) {
            points = this.reverseLatLngs(geometry.getLatLngs());
            geometry = new _SuperMap2["default"].Geometry.Polygon(points);
        } else {
            if (geometry instanceof _leaflet2["default"].LatLng) {
                points = [geometry.lng, geometry.lat];
            } else if (geometry instanceof _leaflet2["default"].Point) {
                points = [geometry.x, geometry.y];
            }
            if (points.length > 1) {
                geometry = new _SuperMap2["default"].Geometry.Point(points[0], points[1]);
            }
        }
        return new _SuperMap2["default"].Feature.Vector(geometry, this.attributes);
    },

    /**
     * @function L.supermap.themeFeature.prototype.reverseLatLngs
     * @description 坐标反转
     * @param latlngs - {L.latlng} 坐标值
     */
    reverseLatLngs: function reverseLatLngs(latlngs) {
        if (!_leaflet2["default"].Util.isArray(latlngs)) {
            latlngs = [latlngs];
        }
        for (var i = 0; i < latlngs.length; i++) {
            latlngs[i] = [latlngs[i][1], latlngs[i][0]];
        }
        return latlngs;
    }
});
var themeFeature = exports.themeFeature = function themeFeature(geometry, attributes) {
    return new ThemeFeature(geometry, attributes);
};
_leaflet2["default"].supermap.themeFeature = themeFeature;

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ThemeLayer = undefined;

var _SuperMap = __webpack_require__(0);

var _SuperMap2 = _interopRequireDefault(_SuperMap);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

var _Point = __webpack_require__(13);

var _Point2 = _interopRequireDefault(_Point);

var _GeoText = __webpack_require__(174);

var _GeoText2 = _interopRequireDefault(_GeoText);

var _LevelRenderer = __webpack_require__(29);

var _LevelRenderer2 = _interopRequireDefault(_LevelRenderer);

__webpack_require__(388);

__webpack_require__(4);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.ThemeLayer
 * @classdesc 专题图层基类，调用建议使用其子类实现类。
 * @private
 * @extends L.Layer{@linkdoc-leaflet/#layer}
 * @param name - {string} 专题图层名称
 * @param options -{Object} 待设置得参数。
 */
var ThemeLayer = exports.ThemeLayer = _leaflet2["default"].Layer.extend({

    options: {
        name: null,
        opacity: 1,
        // {Array} 专题要素事件临时存储，临时保存图层未添加到 map 前用户添加的事件监听，待图层添加到 map 后把这些事件监听添加到图层上，清空此图层。
        //这是一个二维数组，组成二维数组的每个一维数组长度为 2，分别是 event, callback。
        TFEvents: null,
        attribution: "Map Data <span>© <a href='http://support.supermap.com.cn/product/iServer.aspx' target='_blank'>SuperMap iServer</a></span> with <span>© <a href='http://iclient.supermapol.com' target='_blank'>SuperMap iClient</a></span>"
    },

    initialize: function initialize(name, options) {
        _leaflet2["default"].Util.setOptions(this, options);
        this.options.name = name;
        this.features = [];
        this.TFEvents = [];
        this.levelRenderer = new _LevelRenderer2["default"]();
        this.movingOffset = [0, 0];
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getEvents
     * @description 获取图层事件
     * @return {{zoomend: ThemeLayer._reset, moveend: ThemeLayer._reset, resize: ThemeLayer._resize}}
     */
    getEvents: function getEvents() {
        var me = this;
        var events = {
            zoomend: this._reset,
            moveend: me._reset,
            resize: me._resize
        };
        if (this._map._zoomAnimated) {
            events.zoomanim = me._zoomAnim;
        }
        return events;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.onRemove
     * @description 删除某个地图
     * @param map - {L.map} 要删除的地图
     */
    onRemove: function onRemove(map) {
        if (map) {
            map.removeLayer(this);
        }
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.onAdd
     * @description 添加专题图
     * @param map - {L.map} 要添加的地图
     */
    onAdd: function onAdd(map) {
        var me = this;
        me._initContainer();
        if (!me.levelRenderer) {
            map.removeLayer(me);
            return;
        }

        me.map = map;
        //初始化渲染器
        var size = map.getSize();
        me.container.style.width = size.x + "px";
        me.container.style.height = size.y + "px";
        me._updateOpacity();

        me.renderer = me.levelRenderer.init(me.container);
        me.renderer.clear();
        //处理用户预先（在图层添加到 map 前）监听的事件
        me.addTFEvents();
        map.on("mousemove", function (e) {
            var xy = e.layerPoint;
            me.currentMousePosition = _leaflet2["default"].point(xy.x + me.movingOffset[0], xy.y + me.movingOffset[1]);
        });
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.addFeatures
     * @description 向专题图图层中添加数据, 支持的feature类型为:iServer返回的feature json对象 或L.supermap.themeFeature类型
     * @param features - {L.feature} 要添加的要素
     */
    addFeatures: function addFeatures(features) {
        //子类实现此方法
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.redrawThematicFeatures
     * @description 抽象方法，可实例化子类必须实现此方法。
     * @param bounds - {L.bounds} 重绘专题要素范围。
     */
    redrawThematicFeatures: function redrawThematicFeatures(bounds) {
        //子类必须实现此方法
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.destroyFeatures
     * @description 销毁某个要素
     * @param features - {L.feature} 将被销毁得要素
     */
    destroyFeatures: function destroyFeatures(features) {
        if (features === undefined) {
            features = this.features;
        }
        if (!features) {
            return;
        }
        this.removeFeatures(features);
        for (var i = features.length - 1; i >= 0; i--) {
            features[i].destroy();
        }
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.removeFeatures
     * @description 从专题图中删除 feature。这个函数删除所有传递进来的矢量要素。
     * @param features - {L.feature} 将被删除得要素
     */
    removeFeatures: function removeFeatures(features) {
        var me = this;
        if (!features || features.length === 0) {
            return;
        }
        if (features === me.features) {
            return me.removeAllFeatures();
        }
        if (!_leaflet2["default"].Util.isArray(features)) {
            features = [features];
        }

        var featuresFailRemoved = [];

        for (var i = features.length - 1; i >= 0; i--) {
            var feature = features[i];

            //如果我们传入的feature在features数组中没有的话，则不进行删除，
            //并将其放入未删除的数组中。
            var findex = _leaflet2["default"].Util.indexOf(me.features, feature);

            if (findex === -1) {
                featuresFailRemoved.push(feature);
                continue;
            }
            me.features.splice(findex, 1);
        }

        var drawFeatures = [];
        for (var hex = 0, len = me.features.length; hex < len; hex++) {
            feature = me.features[hex];
            drawFeatures.push(feature);
        }
        me.features = [];
        me.addFeatures(drawFeatures);
        //绘制专题要素
        if (me.renderer) {
            if (me._map) {
                me.redrawThematicFeatures(me._map.getBounds());
            } else {
                me.redrawThematicFeatures();
            }
        }

        var succeed = featuresFailRemoved.length == 0;
        me.fire("featuresremoved", { features: featuresFailRemoved, succeed: succeed });
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.removeAllFeatures
     * @description 清除当前图层所有的矢量要素。
     */
    removeAllFeatures: function removeAllFeatures() {
        var me = this;
        if (me.renderer) {
            me.renderer.clear();
        }
        me.features = [];
        me.fire("featuresremoved", { features: [], succeed: true });
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getFeatures
     * @description 查看当前图层中的有效数据。
     * @return {Array} 返回图层中的有效数据。
     */
    getFeatures: function getFeatures() {
        var me = this;
        var len = me.features.length;
        var clonedFeatures = new Array(len);
        for (var i = 0; i < len; ++i) {
            clonedFeatures[i] = me.features[i];
        }
        return clonedFeatures;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getFeatureBy
     * @description 在专题图的要素数组 features 里面遍历每一个 feature，当 feature[property] === value 时，返回此 feature（并且只返回第一个）。
     * @param property - {string} 要素得某个属性名
     * @param value - {string} 对应属性名得值
     */
    getFeatureBy: function getFeatureBy(property, value) {
        var me = this;
        var feature = null;
        for (var id in me.features) {
            if (me.features[id][property] !== value) {
                continue;
            }
            feature = me.features[id];
            break;
        }
        return feature;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getFeatureById
     * @description 通过给定一个 id，返回对应的矢量要素,如果不存在则返回 null
     * @param featureId - {number}要素id
     */
    getFeatureById: function getFeatureById(featureId) {
        return this.getFeatureBy('id', featureId);
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getFeaturesByAttribute
     * @description 通过给定一个属性的 key 值和 value 值，返回所有匹配的要素数组。
     * @param attrName - {string} key 值
     * @param attrValue - {string} value 值
     * @return {Array} 返回所有匹配的要素数组。
     */
    getFeaturesByAttribute: function getFeaturesByAttribute(attrName, attrValue) {
        var me = this,
            feature,
            foundFeatures = [];
        for (var id in me.features) {
            feature = me.features[id];
            if (feature && feature.attributes && feature.attributes[attrName] === attrValue) {
                foundFeatures.push(feature);
            }
        }
        return foundFeatures;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.update
     * @description 更新图层
     * @param bounds - {L.bounds} 图层范围
     */
    update: function update(bounds) {
        var me = this;
        var offsetLeft = parseInt(me._map.getContainer().style.left, 10);
        offsetLeft = -Math.round(offsetLeft);
        var offsetTop = parseInt(me._map.getContainer().style.top, 10);
        offsetTop = -Math.round(offsetTop);
        me.container.style.left = offsetLeft + 'px';
        me.container.style.top = offsetTop + 'px';

        //绘制专题要素
        if (me.renderer) {
            me.redrawThematicFeatures(bounds);
        }

        if (me.currentMousePosition) {
            me.currentMousePosition = _leaflet2["default"].point(me.currentMousePosition.x - me.movingOffset[0], me.currentMousePosition.y - me.movingOffset[1]);
        }
        me.movingOffset = [0, 0];
        me._zoom = me._map.getZoom();
        me._center = me._map.getCenter();
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.setOpacity
     * @description 设置图层的不透明度,取值[0-1]之间。
     * @param opacity - {number}不透明度
     */
    setOpacity: function setOpacity(opacity) {
        var me = this;
        if (opacity === me.options.opacity) {
            return;
        }
        if (opacity) {
            me.options.opacity = opacity;
        }
        me._updateOpacity();
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.redraw
     * @description 重绘该图层
     * @return {boolean} 返回是否重绘成功
     */
    redraw: function redraw() {
        var me = this;
        if (!me.renderer) {
            return false;
        }
        if (me._map) {
            me.redrawThematicFeatures(me._map.getBounds());
        } else {
            me.redrawThematicFeatures();
        }
        return true;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.on
     * @description 添加专题要素事件监听。添加专题要素事件监听。
     * @param event - {Event} 监听事件
     * @param callback - {function} 回调函数
     * @param context - {string} 信息
     */
    on: function on(event, callback, context) {
        if (this.renderer) {
            this.renderer.on(event, callback);
        } else {
            _leaflet2["default"].Layer.prototype.on.call(this, event, callback);
        }
        return this;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.off
     * @description 移除专题要素事件监听。
     * @param event - {Event} 监听事件
     * @param callback - {function} 回调函数
     * @param context - {string} 信息
     */
    off: function off(event, callback, context) {
        var me = this;
        if (me.renderer) {
            me.renderer.off(event, callback);
        } else {
            _leaflet2["default"].Layer.prototype.off.call(this, event, callback);
        }
        return this;
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.addTFEvents
     * @description 将图层添加到地图上之前用户要求添加的事件监听添加到图层。
     */
    addTFEvents: function addTFEvents() {
        var me = this;
        var tfEs = me.TFEvents;
        var len = tfEs.length;

        for (var i = 0; i < len; i++) {
            me.renderer.on(tfEs[i][0], tfEs[i][1]);
        }
    },

    /**
     * @function L.supermap.ThemeLayer.prototype.getLocalXY
     * @description 地理坐标转为像素坐标。{Array} 长度为 2 的数组，第一个元素表示 x 坐标，第二个元素表示 y 坐标。
     * @param coordinate - {string} 坐标系统
     */
    getLocalXY: function getLocalXY(coordinate) {
        if (!this._map) {
            return coordinate;
        }
        var coor = coordinate;
        if (!(coordinate instanceof _leaflet2["default"].LatLng)) {
            if (coordinate instanceof _Point2["default"] || coordinate instanceof _GeoText2["default"]) {
                coor = _leaflet2["default"].latLng(coordinate.y, coordinate.x);
            } else {
                coor = _leaflet2["default"].latLng(coordinate.lat, coordinate.lon);
            }
        }
        var point = this._map.latLngToContainerPoint(coor);
        return [point.x, point.y];
    },

    _initContainer: function _initContainer() {
        var parentContainer = this.getPane();
        this.container = _leaflet2["default"].DomUtil.create("div", "themeLayer", parentContainer);
    },

    _zoomAnim: function _zoomAnim(evt) {
        var zoom = evt.zoom,
            center = evt.center;
        var scale = this._map.getZoomScale(zoom),
            offset = this._map._getCenterOffset(center)._multiplyBy(-scale).subtract(this._map._getMapPanePos());

        if (_leaflet2["default"].DomUtil.setTransform) {
            _leaflet2["default"].DomUtil.setTransform(this.container, offset, scale);
        } else {
            _leaflet2["default"].DomUtil.setPosition(this.container, offset);
        }
    },

    _updateOpacity: function _updateOpacity() {
        var me = this;
        _SuperMap2["default"].Util.modifyDOMElement(me.container, null, null, null, null, null, null, me.options.opacity);
        if (me._map !== null) {
            me._map.fire("changelayer", { layer: me, property: "opacity" });
        }
    },

    //缩放移动重绘
    _reset: function _reset() {
        var me = this;
        var latLngBounds = me._map.getBounds();
        me.update(latLngBounds);
        var bounds = new _leaflet2["default"].Bounds(me._map.latLngToLayerPoint(latLngBounds.getNorthWest()), me._map.latLngToLayerPoint(latLngBounds.getSouthEast()));
        var size = bounds.getSize();
        _leaflet2["default"].DomUtil.setPosition(me.container, bounds.min);
        me.container.style.width = size.x + 'px';
        me.container.style.height = size.y + 'px';
    },

    //通知渲染器的尺寸变化。
    _resize: function _resize() {
        var me = this;
        var newSize = me._map.getSize();
        me.container.style.width = newSize.x + "px";
        me.container.style.height = newSize.y + "px";
        me.renderer.resize();
    }
});

/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CanvasRenderer = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.CanvasRenderer
 * @private
 * @classdesc 画布渲染器
 * @extends L.Canvas{@linkdoc-leaflet/#canvas}
 * @param tileCoord - {Object} 切片坐标系
 * @param tileSize - {number}切片大小
 * @param options - {Object} 渲染器参数
 */
var CanvasRenderer = exports.CanvasRenderer = _leaflet2["default"].Canvas.extend({

    initialize: function initialize(tileCoord, tileSize, options) {
        _leaflet2["default"].Canvas.prototype.initialize.call(this, options);
        this._tileCoord = tileCoord;
        this._size = tileSize;

        this._initContainer();
        this._container.setAttribute('width', this._size.x);
        this._container.setAttribute('height', this._size.y);
        this._layers = {};
        this._drawnLayers = {};
        this._drawing = true;

        if (options.interactive) {
            this._container.style.pointerEvents = 'auto';
        }
    },

    /**
     * @function L.supermap.CanvasRenderer.prototype.getCoord
     * @description 获取坐标
     */
    getCoord: function getCoord() {
        return this._tileCoord;
    },

    /**
     * @function L.supermap.CanvasRenderer.prototype.getContainer
     * @description 获取容器
     */
    getContainer: function getContainer() {
        return this._container;
    },

    /**
     * @function L.supermap.CanvasRenderer.prototype.getOffset
     * @description 停止渲染
     */
    getOffset: function getOffset() {
        return this._tileCoord.scaleBy(this._size).subtract(this._map.getPixelOrigin());
    },

    onAdd: _leaflet2["default"].Util.falseFn,

    /**
     * @function L.supermap.CanvasRenderer.prototype.addTo
     * @description 添加到切片地图
     * @param map - {L.map} 切片地图
     */
    addTo: function addTo(map) {
        this._map = map;
    },

    /**
     * @function L.supermap.CanvasRenderer.prototype.removeFrom
     * @description 删除切片地图
     * @param map - {L.map} 切片地图
     */
    removeFrom: function removeFrom(map) {
        delete this._map;
    },

    _updateDashArray: function _updateDashArray(layer) {
        var array = layer.options.dashArray;
        if (array && typeof array === "String") {
            var parts = array.split(','),
                dashArray = [],
                i;
            for (i = 0; i < parts.length; i++) {
                dashArray.push(Number(parts[i]));
            }
            layer.options._dashArray = dashArray;
        } else {
            layer.options._dashArray = array;
        }
    },

    _onClick: function _onClick(e) {
        var point = this._map.mouseEventToLayerPoint(e).subtract(this.getOffset()),
            layer,
            clickedLayer;

        for (var id in this._layers) {
            layer = this._layers[id];
            if (layer.options.interactive && layer._containsPoint(point) && !this._map._draggableMoved(layer)) {
                clickedLayer = layer;
            }
        }
        if (clickedLayer) {
            _leaflet2["default"].DomEvent.stop(e);
            this._fireEvent([clickedLayer], e);
        }
    },

    _onMouseMove: function _onMouseMove(e) {
        if (!this._map || this._map.dragging.moving() || this._map._animatingZoom) {
            return;
        }

        var point = this._map.mouseEventToLayerPoint(e).subtract(this.getOffset());
        this._handleMouseHover(e, point);
    },

    _updateIcon: function _updateIcon(layer) {
        if (!this._drawing) {
            return;
        }

        var options = layer.options,
            ctx = this._ctx,
            img = layer._getImage();
        if (options.iconSize && img.complete) {
            var size = _leaflet2["default"].point(options.iconSize),
                anchor = size && size.divideBy(2, true),
                p = layer._point.subtract(anchor);
            ctx.drawImage(img, p.x, p.y, size.x, size.y);
        } else {
            _leaflet2["default"].DomEvent.on(img, 'load', function (evt) {
                var size = _leaflet2["default"].point([img.width, img.height]),
                    anchor = size && size.divideBy(2, true),
                    p = layer._point.subtract(anchor);
                ctx.drawImage(img, p.x, p.y, size.x, size.y);
            });
        }

        this._drawnLayers[layer._leaflet_id] = layer;
    }
});

/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SVGRenderer = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.SVGRenderer
 * @classdesc 矢量图层缩放渲染器类
 * @private
 * @extends L.SVG{@linkdoc-leaflet/#svg}
 * @param tileCoord - {Object} 切片坐标系
 * @param tileSize - {number}切片大小
 * @param options - {Object} 渲染参数
 */
var SVGRenderer = exports.SVGRenderer = _leaflet2["default"].SVG.extend({

    initialize: function initialize(tileCoord, tileSize, options) {
        _leaflet2["default"].SVG.prototype.initialize.call(this, options);
        this._tileCoord = tileCoord;
        this._size = tileSize;

        this._initContainer();
        this._container.setAttribute('width', this._size.x);
        this._container.setAttribute('height', this._size.y);
        this._container.setAttribute('viewBox', [0, 0, this._size.x, this._size.y].join(' '));

        this._layers = {};
    },

    /**
     * @function L.supermap.SVGRenderer.prototype.getCoord
     * @description 获取坐标
     */
    getCoord: function getCoord() {
        return this._tileCoord;
    },

    /**
     * @function L.supermap.SVGRenderer.prototype.getContainer
     * @description 获取容器
     */
    getContainer: function getContainer() {
        return this._container;
    },

    onAdd: _leaflet2["default"].Util.falseFn,

    /**
     * @function L.supermap.SVGRenderer.prototype.addTo
     * @description 添加到切片地图
     * @param map - {L.map} 切片地图
     */
    addTo: function addTo(map) {
        this._map = map;
        if (this.options.interactive) {
            for (var i in this._layers) {
                var layer = this._layers[i];
                layer._path.style.pointerEvents = 'auto';
                this._map._targets[_leaflet2["default"].stamp(layer._path)] = layer;
            }
        }
    },

    /**
     * @function L.supermap.SVGRenderer.prototype.removeFrom
     * @description 删除切片地图
     * @param map - {L.map} 切片地图
     */
    removeFrom: function removeFrom(map) {
        var map = map || this._map;
        if (this.options.interactive) {
            for (var i in this._layers) {
                var layer = this._layers[i];
                delete map._targets[_leaflet2["default"].stamp(layer._path)];
            }
        }
        delete this._map;
    },

    _initContainer: function _initContainer() {
        _leaflet2["default"].SVG.prototype._initContainer.call(this);
        var rect = _leaflet2["default"].SVG.create('rect');
    },

    _addPath: function _addPath(layer) {
        this._rootGroup.appendChild(layer._path);
        this._layers[_leaflet2["default"].stamp(layer)] = layer;
    },

    _updateIcon: function _updateIcon(layer) {
        var path = layer._path = _leaflet2["default"].SVG.create('image'),
            options = layer.options,
            iconUrl = options.iconUrl;
        if (options.iconSize) {
            var size = _leaflet2["default"].point(options.iconSize),
                anchor = size && size.divideBy(2, true),
                p = layer._point.subtract(anchor);
            path.setAttribute('x', p.x);
            path.setAttribute('y', p.y);
            path.setAttribute('width', size.x + 'px');
            path.setAttribute('height', size.y + 'px');
        } else {
            var img = new Image();
            img.src = iconUrl;
            _leaflet2["default"].DomEvent.on(img, 'load', function (evt) {
                var size = _leaflet2["default"].point([img.width, img.height]),
                    anchor = size && size.divideBy(2, true),
                    p = layer._point.subtract(anchor);
                path.setAttribute('x', p.x);
                path.setAttribute('y', p.y);
                path.setAttribute('width', size.x + 'px');
                path.setAttribute('height', size.y + 'px');
            });
        }
        path.setAttribute('href', iconUrl);
    }
});

/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PolyBase = undefined;

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.PolyBase
 * @classdesc 多边形基类
 * @private
 */
//@type {{_makeFeatureParts: PolyBase._makeFeatureParts, makeInteractive: PolyBase.makeInteractive}}
var PolyBase = exports.PolyBase = {
    _makeFeatureParts: function _makeFeatureParts(feat, pxPerExtent) {
        pxPerExtent = pxPerExtent || { x: 1, y: 1 };
        var rings = feat.geometry;
        var coord;

        this._parts = [];
        for (var i = 0; i < rings.length; i++) {
            var ring = rings[i];
            var part = [];
            for (var j = 0; j < ring.length; j++) {
                coord = ring[j];
                part.push(_leaflet2["default"].point(coord).scaleBy(pxPerExtent));
            }
            this._parts.push(part);
        }
    },

    /**
     * @function L.supermap.PolyBase.prototype.makeInteractive
     * @description 设置交互
     */
    makeInteractive: function makeInteractive() {
        this._pxBounds = this._getPixelBounds();
    }
};

/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TextSymbolizer = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _Symbolizer = __webpack_require__(52);

var _CanvasRenderer = __webpack_require__(111);

var _SVGRenderer = __webpack_require__(112);

var _leaflet = __webpack_require__(1);

var _leaflet2 = _interopRequireDefault(_leaflet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @class L.supermap.TextSymbolizer
 * @classdesc 文本符号类
 * @private
 * @extends L.Path{@linkdoc-leaflet/#path}
 * @param feature - {L.feature} 要素
 * @param pxPerExtent - {number}文本符号大小
 */
var TextSymbolizer = exports.TextSymbolizer = _leaflet2["default"].Path.extend({

    /**
     * @member L.supermap.TextSymbolizer.prototype.includes
     * @description 包含符号
     */
    includes: _Symbolizer.Symbolizer.prototype,

    options: {
        color: 'white',
        fillColor: 'black',
        fill: true,
        fillOpacity: 1,
        opacity: 0.6,
        weight: 1,
        rotation: 0.0,
        stroke: true,
        fontFamily: "Arial Unicode MS Regular",
        fontSize: 14,
        fontWeight: 'bold',
        textAlign: 'center',
        offsetX: 1,
        offsetY: 1
    },

    initialize: function initialize(feature, pxPerExtent) {
        _Symbolizer.Symbolizer.prototype.initialize.call(this, feature);
        this._makeFeatureParts(feature, pxPerExtent);
        this.options.offsetX = pxPerExtent || 1;
        this.options.offsetY = pxPerExtent || 1;
    },

    /**
     * @function L.supermap.TextSymbolizer.prototype.render
     * @description 绘制点符号
     * @param renderer - {Object} 渲染器
     * @param style - {string} 符号样式
     */
    render: function render(renderer, style) {
        //原本类型就是text的情况
        if (this.properties.texts) {
            this._text = this.properties.texts[0];
        }
        //类型是label的情况
        if (!this._text) {
            var attributes = this.properties.attributes;
            this._text = attributes && this.properties.textField ? attributes[this.properties.textField] || "" : "";
        }
        var options = this.options;
        this._pxBounds = _leaflet2["default"].bounds(this._point, this._point);
        _Symbolizer.Symbolizer.prototype.render.apply(this, [renderer, style]);
        this.options = _leaflet2["default"].Util.extend(options, style);
        this._updatePath();
    },

    _makeFeatureParts: function _makeFeatureParts(feat, pxPerExtent) {
        pxPerExtent = pxPerExtent || { x: 1, y: 1 };
        var coord = feat.geometry[0];
        if (_typeof(coord[0]) === 'object' && 'x' in coord[0]) {
            this._point = _leaflet2["default"].point(coord[0]).scaleBy(pxPerExtent);
            this._empty = _leaflet2["default"].Util.falseFn;
        } else {
            this._point = _leaflet2["default"].point(coord).scaleBy(pxPerExtent);
            this._empty = _leaflet2["default"].Util.falseFn;
        }
    },

    /**
     * @function L.supermap.TextSymbolizer.prototype.makeInteractive
     * @description 设置交互
     */
    makeInteractive: function makeInteractive() {
        this._updateBounds();
    },

    /**
     * @function L.supermap.TextSymbolizer.prototype.updateStyle
     * @description 更新替换符号样式
     * @param renderer - {Object} 渲染器
     * @param style - {string} 符号样式
     */
    updateStyle: function updateStyle(renderer, style) {
        this._updateBounds();
        return _Symbolizer.Symbolizer.prototype.updateStyle.call(this, renderer, style);
    },

    _updateBounds: function _updateBounds() {
        var w = this._renderer._getTextWidth(this);
        var p = [w / 2, w / 2];
        this._pxBounds = _leaflet2["default"].bounds(this._point.subtract(p), this._point.add(p));
    },

    _updatePath: function _updatePath() {
        this._renderer._updateText(this);
    },
    _containsPoint: function _containsPoint(point) {
        return false;
    }
});

_CanvasRenderer.CanvasRenderer.include({
    _getTextWidth: function _getTextWidth(layer) {
        return this._ctx.measureText(layer._text).width;
    },
    _updateText: function _updateText(layer) {
        if (!this._drawing || layer._empty()) {
            return;
        }
        var container = this.getContainer();
        var size = this._map.getSize();
        container.width = size.x;
        container.height = size.y;
        container.style.width = size.x + 'px';
        container.style.height = size.y + 'px';
        var ctx = this._ctx,
            options = layer.options,
            offsetX = options.offsetX || 1,
            offsetY = options.offsetY || 1,
            p = layer._point.subtract(_leaflet2["default"].point(offsetX, offsetY));
        if (!options.fill) {
            return;
        }

        this._drawnLayers[layer._leaflet_id] = layer;

        ctx.fillRect(0, 0, size.x, size.y);
        ctx.font = [options.fontWeight ? options.fontWeight : "bold", options.fontSize ? options.fontSize : "14px", options.fontFamily ? options.fontFamily : "Arial Unicode MS Regular,Microsoft Yahei"].join(" ");
        ctx.textAlign = options.textAlign;
        ctx.lineWidth = options.weight;
        ctx.fillStyle = options.fillColor;
        ctx.fillText(layer._text, p.x, p.y);
        ctx.strokeStyle = options.color;
        ctx.strokeText(layer._text, p.x, p.y);
        ctx.rotate(options.rotation);
    }
});

_SVGRenderer.SVGRenderer.include({
    _getTextWidth: function _getTextWidth(layer) {
        return layer._path.getComputedTextLength() || 0;
    },

    _initPath: function _initPath(layer) {
        var path;

        if (TextSymbolizer && layer instanceof TextSymbolizer) {
            path = layer._path = _leaflet2["default"].SVG.create("text");
            path.textContent = layer._text;
        } else {
            path = layer._path = _leaflet2["default"].SVG.create("path");
        }

        if (layer.options.className) {
            _leaflet2["default"].DomUtil.addClass(path, layer.options.className);
        }

        if (layer.options.interactive) {
            _leaflet2["default"].DomUtil.addClass(path, 'leaflet-interactive');
        }

        this._updateStyle(layer);
        this._layers[_leaflet2["default"].stamp(layer)] = layer;
    },

    _updateText: function _updateText(layer) {
        var path = layer._path,
            options = layer.options,
            offsetX = options.offsetX || 1,
            offsetY = options.offsetY || 1,
            p = layer._point.subtract(_leaflet2["default"].point(offsetX, offsetY));
        path.setAttribute('x', p.x);
        path.setAttribute('y', p.y);
        options.rotation = options.rotation || 0;
        path.setAttribute('transform', 'rotate(' + options.rotation / Math.PI * 180 + ' ' + p.x + ' ' + p.y + ')');
        path.setAttribute('text-anchor', options.textAlign === 'center' ? 'middle' : options.textAlign);
        path.style.fontSize = options.fontSize;
        path.style.fontFamily = options.fontFamily;
        path.style.fontWeight = options.fontWeight || "bold";
        path.style.glyphOrientationVertical = options.rotation;
        if (options.stroke) {
            path.setAttribute('stroke', options.color);
            path.setAttribute('stroke-linecap', 'round');
            path.setAttribute('stroke-linejoin', 'round');
            path.setAttribute('stroke-opacity', options.opacity);
            path.setAttribute('stroke-width', options.weight > 1 ? options.weight / 10 : options.weight);
        } else {
            path.setAttribute('stroke', 'none');
        }
        if (options.fill) {
            path.setAttribute('fill', options.fillColor || options.color);
            path.setAttribute('fill-opacity', options.fillOpacity);
        } else {
            path.setAttribute('fill', 'none');
        }
    }

});

/***/ }),
/* 115 */
/***/ (function(module, exports) {

module.exports = function(phi, sphi, cphi, en) {
  cphi *= sphi;
  sphi *= sphi;
  return (en[0] * phi - cphi * (en[1] + sphi * (en[2] + sphi * (en[3] + sphi * en[4]))));
};

/***/ }),
/* 116 */
/***/ (function(module, exports) {

module.exports = function (array){
  var out = {
    x: array[0],
    y: array[1]
  };
  if (array.length>2) {
    out.z = array[2];
  }
  if (array.length>3) {
    out.m = array[3];
  }
  return out;
};

/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

var globals = __webpack_require__(435);
var parseProj = __webpack_require__(118);
var wkt = __webpack_require__(121);

function defs(name) {
  /*global console*/
  var that = this;
  if (arguments.length === 2) {
    var def = arguments[1];
    if (typeof def === 'string') {
      if (def.charAt(0) === '+') {
        defs[name] = parseProj(arguments[1]);
      }
      else {
        defs[name] = wkt(arguments[1]);
      }
    } else {
      defs[name] = def;
    }
  }
  else if (arguments.length === 1) {
    if (Array.isArray(name)) {
      return name.map(function(v) {
        if (Array.isArray(v)) {
          defs.apply(that, v);
        }
        else {
          defs(v);
        }
      });
    }
    else if (typeof name === 'string') {
      if (name in defs) {
        return defs[name];
      }
    }
    else if ('EPSG' in name) {
      defs['EPSG:' + name.EPSG] = name;
    }
    else if ('ESRI' in name) {
      defs['ESRI:' + name.ESRI] = name;
    }
    else if ('IAU2000' in name) {
      defs['IAU2000:' + name.IAU2000] = name;
    }
    else {
      console.log(name);
    }
    return;
  }


}
globals(defs);
module.exports = defs;


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

var D2R = 0.01745329251994329577;
var PrimeMeridian = __webpack_require__(429);
var units = __webpack_require__(430);

module.exports = function(defData) {
  var self = {};
  var paramObj = {};
  defData.split("+").map(function(v) {
    return v.trim();
  }).filter(function(a) {
    return a;
  }).forEach(function(a) {
    var split = a.split("=");
    split.push(true);
    paramObj[split[0].toLowerCase()] = split[1];
  });
  var paramName, paramVal, paramOutname;
  var params = {
    proj: 'projName',
    datum: 'datumCode',
    rf: function(v) {
      self.rf = parseFloat(v);
    },
    lat_0: function(v) {
      self.lat0 = v * D2R;
    },
    lat_1: function(v) {
      self.lat1 = v * D2R;
    },
    lat_2: function(v) {
      self.lat2 = v * D2R;
    },
    lat_ts: function(v) {
      self.lat_ts = v * D2R;
    },
    lon_0: function(v) {
      self.long0 = v * D2R;
    },
    lon_1: function(v) {
      self.long1 = v * D2R;
    },
    lon_2: function(v) {
      self.long2 = v * D2R;
    },
    alpha: function(v) {
      self.alpha = parseFloat(v) * D2R;
    },
    lonc: function(v) {
      self.longc = v * D2R;
    },
    x_0: function(v) {
      self.x0 = parseFloat(v);
    },
    y_0: function(v) {
      self.y0 = parseFloat(v);
    },
    k_0: function(v) {
      self.k0 = parseFloat(v);
    },
    k: function(v) {
      self.k0 = parseFloat(v);
    },
    a: function(v) {
      self.a = parseFloat(v);
    },
    b: function(v) {
      self.b = parseFloat(v);
    },
    r_a: function() {
      self.R_A = true;
    },
    zone: function(v) {
      self.zone = parseInt(v, 10);
    },
    south: function() {
      self.utmSouth = true;
    },
    towgs84: function(v) {
      self.datum_params = v.split(",").map(function(a) {
        return parseFloat(a);
      });
    },
    to_meter: function(v) {
      self.to_meter = parseFloat(v);
    },
    units: function(v) {
      self.units = v;
      if (units[v]) {
        self.to_meter = units[v].to_meter;
      }
    },
    from_greenwich: function(v) {
      self.from_greenwich = v * D2R;
    },
    pm: function(v) {
      self.from_greenwich = (PrimeMeridian[v] ? PrimeMeridian[v] : parseFloat(v)) * D2R;
    },
    nadgrids: function(v) {
      if (v === '@null') {
        self.datumCode = 'none';
      }
      else {
        self.nadgrids = v;
      }
    },
    axis: function(v) {
      var legalAxis = "ewnsud";
      if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
        self.axis = v;
      }
    }
  };
  for (paramName in paramObj) {
    paramVal = paramObj[paramName];
    if (paramName in params) {
      paramOutname = params[paramName];
      if (typeof paramOutname === 'function') {
        paramOutname(paramVal);
      }
      else {
        self[paramOutname] = paramVal;
      }
    }
    else {
      self[paramName] = paramVal;
    }
  }
  if(typeof self.datumCode === 'string' && self.datumCode !== "WGS84"){
    self.datumCode = self.datumCode.toLowerCase();
  }
  return self;
};


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

var e0fn = __webpack_require__(41);
var e1fn = __webpack_require__(42);
var e2fn = __webpack_require__(43);
var e3fn = __webpack_require__(44);
var mlfn = __webpack_require__(45);
var adjust_lon = __webpack_require__(6);
var HALF_PI = Math.PI/2;
var EPSLN = 1.0e-10;
var sign = __webpack_require__(46);
var asinz = __webpack_require__(32);

exports.init = function() {
  this.e0 = e0fn(this.es);
  this.e1 = e1fn(this.es);
  this.e2 = e2fn(this.es);
  this.e3 = e3fn(this.es);
  this.ml0 = this.a * mlfn(this.e0, this.e1, this.e2, this.e3, this.lat0);
};

/**
    Transverse Mercator Forward  - long/lat to x/y
    long/lat in radians
  */
exports.forward = function(p) {
  var lon = p.x;
  var lat = p.y;

  var delta_lon = adjust_lon(lon - this.long0);
  var con;
  var x, y;
  var sin_phi = Math.sin(lat);
  var cos_phi = Math.cos(lat);

  if (this.sphere) {
    var b = cos_phi * Math.sin(delta_lon);
    if ((Math.abs(Math.abs(b) - 1)) < 0.0000000001) {
      return (93);
    }
    else {
      x = 0.5 * this.a * this.k0 * Math.log((1 + b) / (1 - b));
      con = Math.acos(cos_phi * Math.cos(delta_lon) / Math.sqrt(1 - b * b));
      if (lat < 0) {
        con = -con;
      }
      y = this.a * this.k0 * (con - this.lat0);
    }
  }
  else {
    var al = cos_phi * delta_lon;
    var als = Math.pow(al, 2);
    var c = this.ep2 * Math.pow(cos_phi, 2);
    var tq = Math.tan(lat);
    var t = Math.pow(tq, 2);
    con = 1 - this.es * Math.pow(sin_phi, 2);
    var n = this.a / Math.sqrt(con);
    var ml = this.a * mlfn(this.e0, this.e1, this.e2, this.e3, lat);

    x = this.k0 * n * al * (1 + als / 6 * (1 - t + c + als / 20 * (5 - 18 * t + Math.pow(t, 2) + 72 * c - 58 * this.ep2))) + this.x0;
    y = this.k0 * (ml - this.ml0 + n * tq * (als * (0.5 + als / 24 * (5 - t + 9 * c + 4 * Math.pow(c, 2) + als / 30 * (61 - 58 * t + Math.pow(t, 2) + 600 * c - 330 * this.ep2))))) + this.y0;

  }
  p.x = x;
  p.y = y;
  return p;
};

/**
    Transverse Mercator Inverse  -  x/y to long/lat
  */
exports.inverse = function(p) {
  var con, phi;
  var delta_phi;
  var i;
  var max_iter = 6;
  var lat, lon;

  if (this.sphere) {
    var f = Math.exp(p.x / (this.a * this.k0));
    var g = 0.5 * (f - 1 / f);
    var temp = this.lat0 + p.y / (this.a * this.k0);
    var h = Math.cos(temp);
    con = Math.sqrt((1 - h * h) / (1 + g * g));
    lat = asinz(con);
    if (temp < 0) {
      lat = -lat;
    }
    if ((g === 0) && (h === 0)) {
      lon = this.long0;
    }
    else {
      lon = adjust_lon(Math.atan2(g, h) + this.long0);
    }
  }
  else { // ellipsoidal form
    var x = p.x - this.x0;
    var y = p.y - this.y0;

    con = (this.ml0 + y / this.k0) / this.a;
    phi = con;
    for (i = 0; true; i++) {
      delta_phi = ((con + this.e1 * Math.sin(2 * phi) - this.e2 * Math.sin(4 * phi) + this.e3 * Math.sin(6 * phi)) / this.e0) - phi;
      phi += delta_phi;
      if (Math.abs(delta_phi) <= EPSLN) {
        break;
      }
      if (i >= max_iter) {
        return (95);
      }
    } // for()
    if (Math.abs(phi) < HALF_PI) {
      var sin_phi = Math.sin(phi);
      var cos_phi = Math.cos(phi);
      var tan_phi = Math.tan(phi);
      var c = this.ep2 * Math.pow(cos_phi, 2);
      var cs = Math.pow(c, 2);
      var t = Math.pow(tan_phi, 2);
      var ts = Math.pow(t, 2);
      con = 1 - this.es * Math.pow(sin_phi, 2);
      var n = this.a / Math.sqrt(con);
      var r = n * (1 - this.es) / con;
      var d = x / (n * this.k0);
      var ds = Math.pow(d, 2);
      lat = phi - (n * tan_phi * ds / r) * (0.5 - ds / 24 * (5 + 3 * t + 10 * c - 4 * cs - 9 * this.ep2 - ds / 30 * (61 + 90 * t + 298 * c + 45 * ts - 252 * this.ep2 - 3 * cs)));
      lon = adjust_lon(this.long0 + (d * (1 - ds / 6 * (1 + 2 * t + c - ds / 20 * (5 - 2 * c + 28 * t - 3 * cs + 8 * this.ep2 + 24 * ts))) / cos_phi));
    }
    else {
      lat = HALF_PI * sign(y);
      lon = this.long0;
    }
  }
  p.x = lon;
  p.y = lat;
  return p;
};
exports.names = ["Transverse_Mercator", "Transverse Mercator", "tmerc"];


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

var D2R = 0.01745329251994329577;
var R2D = 57.29577951308232088;
var PJD_3PARAM = 1;
var PJD_7PARAM = 2;
var datum_transform = __webpack_require__(433);
var adjust_axis = __webpack_require__(422);
var proj = __webpack_require__(74);
var toPoint = __webpack_require__(116);
module.exports = function transform(source, dest, point) {
  var wgs84;
  if (Array.isArray(point)) {
    point = toPoint(point);
  }
  function checkNotWGS(source, dest) {
    return ((source.datum.datum_type === PJD_3PARAM || source.datum.datum_type === PJD_7PARAM) && dest.datumCode !== "WGS84");
  }

  // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
  if (source.datum && dest.datum && (checkNotWGS(source, dest) || checkNotWGS(dest, source))) {
    wgs84 = new proj('WGS84');
    transform(source, wgs84, point);
    source = wgs84;
  }
  // DGR, 2010/11/12
  if (source.axis !== "enu") {
    adjust_axis(source, false, point);
  }
  // Transform source points to long/lat, if they aren't already.
  if (source.projName === "longlat") {
    point.x *= D2R; // convert degrees to radians
    point.y *= D2R;
  }
  else {
    if (source.to_meter) {
      point.x *= source.to_meter;
      point.y *= source.to_meter;
    }
    source.inverse(point); // Convert Cartesian to longlat
  }
  // Adjust for the prime meridian if necessary
  if (source.from_greenwich) {
    point.x += source.from_greenwich;
  }

  // Convert datums if needed, and if possible.
  point = datum_transform(source.datum, dest.datum, point);

  // Adjust for the prime meridian if necessary
  if (dest.from_greenwich) {
    point.x -= dest.from_greenwich;
  }

  if (dest.projName === "longlat") {
    // convert radians to decimal degrees
    point.x *= R2D;
    point.y *= R2D;
  }
  else { // else project
    dest.forward(point);
    if (dest.to_meter) {
      point.x /= dest.to_meter;
      point.y /= dest.to_meter;
    }
  }

  // DGR, 2010/11/12
  if (dest.axis !== "enu") {
    adjust_axis(dest, true, point);
  }

  return point;
};

/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

var D2R = 0.01745329251994329577;
var extend = __webpack_require__(78);

function mapit(obj, key, v) {
  obj[key] = v.map(function(aa) {
    var o = {};
    sExpr(aa, o);
    return o;
  }).reduce(function(a, b) {
    return extend(a, b);
  }, {});
}

function sExpr(v, obj) {
  var key;
  if (!Array.isArray(v)) {
    obj[v] = true;
    return;
  }
  else {
    key = v.shift();
    if (key === 'PARAMETER') {
      key = v.shift();
    }
    if (v.length === 1) {
      if (Array.isArray(v[0])) {
        obj[key] = {};
        sExpr(v[0], obj[key]);
      }
      else {
        obj[key] = v[0];
      }
    }
    else if (!v.length) {
      obj[key] = true;
    }
    else if (key === 'TOWGS84') {
      obj[key] = v;
    }
    else {
      obj[key] = {};
      if (['UNIT', 'PRIMEM', 'VERT_DATUM'].indexOf(key) > -1) {
        obj[key] = {
          name: v[0].toLowerCase(),
          convert: v[1]
        };
        if (v.length === 3) {
          obj[key].auth = v[2];
        }
      }
      else if (key === 'SPHEROID') {
        obj[key] = {
          name: v[0],
          a: v[1],
          rf: v[2]
        };
        if (v.length === 4) {
          obj[key].auth = v[3];
        }
      }
      else if (['GEOGCS', 'GEOCCS', 'DATUM', 'VERT_CS', 'COMPD_CS', 'LOCAL_CS', 'FITTED_CS', 'LOCAL_DATUM'].indexOf(key) > -1) {
        v[0] = ['name', v[0]];
        mapit(obj, key, v);
      }
      else if (v.every(function(aa) {
        return Array.isArray(aa);
      })) {
        mapit(obj, key, v);
      }
      else {
        sExpr(v, obj[key]);
      }
    }
  }
}

function rename(obj, params) {
  var outName = params[0];
  var inName = params[1];
  if (!(outName in obj) && (inName in obj)) {
    obj[outName] = obj[inName];
    if (params.length === 3) {
      obj[outName] = params[2](obj[outName]);
    }
  }
}

function d2r(input) {
  return input * D2R;
}

function cleanWKT(wkt) {
  if (wkt.type === 'GEOGCS') {
    wkt.projName = 'longlat';
  }
  else if (wkt.type === 'LOCAL_CS') {
    wkt.projName = 'identity';
    wkt.local = true;
  }
  else {
    if (ty