// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class XPackCategoryConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.XPackCategory>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBuild = System.Text.Json.JsonEncodedText.Encode("build");
	private static readonly System.Text.Json.JsonEncodedText MemberFeatures = System.Text.Json.JsonEncodedText.Encode("features");
	private static readonly System.Text.Json.JsonEncodedText MemberLicense = System.Text.Json.JsonEncodedText.Encode("license");

	public override Elastic.Clients.Elasticsearch.Xpack.XPackCategory Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBuild))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Build;
		}

		if (reader.ValueTextEquals(MemberFeatures))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Features;
		}

		if (reader.ValueTextEquals(MemberLicense))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.License;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBuild.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Build;
		}

		if (string.Equals(value, MemberFeatures.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Features;
		}

		if (string.Equals(value, MemberLicense.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Xpack.XPackCategory.License;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Xpack.XPackCategory)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.XPackCategory value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Build:
				writer.WriteStringValue(MemberBuild);
				break;
			case Elastic.Clients.Elasticsearch.Xpack.XPackCategory.Features:
				writer.WriteStringValue(MemberFeatures);
				break;
			case Elastic.Clients.Elasticsearch.Xpack.XPackCategory.License:
				writer.WriteStringValue(MemberLicense);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Xpack.XPackCategory)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Xpack.XPackCategory ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.XPackCategory value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}