// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class MlInferenceTrainedModelsCountConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModelsCount>
{
	private static readonly System.Text.Json.JsonEncodedText PropClassification = System.Text.Json.JsonEncodedText.Encode("classification");
	private static readonly System.Text.Json.JsonEncodedText PropNer = System.Text.Json.JsonEncodedText.Encode("ner");
	private static readonly System.Text.Json.JsonEncodedText PropOther = System.Text.Json.JsonEncodedText.Encode("other");
	private static readonly System.Text.Json.JsonEncodedText PropPassThrough = System.Text.Json.JsonEncodedText.Encode("pass_through");
	private static readonly System.Text.Json.JsonEncodedText PropPrepackaged = System.Text.Json.JsonEncodedText.Encode("prepackaged");
	private static readonly System.Text.Json.JsonEncodedText PropRegression = System.Text.Json.JsonEncodedText.Encode("regression");
	private static readonly System.Text.Json.JsonEncodedText PropTextEmbedding = System.Text.Json.JsonEncodedText.Encode("text_embedding");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");

	public override Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModelsCount Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long?> propClassification = default;
		LocalJsonValue<long?> propNer = default;
		LocalJsonValue<long> propOther = default;
		LocalJsonValue<long?> propPassThrough = default;
		LocalJsonValue<long> propPrepackaged = default;
		LocalJsonValue<long?> propRegression = default;
		LocalJsonValue<long?> propTextEmbedding = default;
		LocalJsonValue<long> propTotal = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propClassification.TryReadProperty(ref reader, options, PropClassification, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propNer.TryReadProperty(ref reader, options, PropNer, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propOther.TryReadProperty(ref reader, options, PropOther, null))
			{
				continue;
			}

			if (propPassThrough.TryReadProperty(ref reader, options, PropPassThrough, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPrepackaged.TryReadProperty(ref reader, options, PropPrepackaged, null))
			{
				continue;
			}

			if (propRegression.TryReadProperty(ref reader, options, PropRegression, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTextEmbedding.TryReadProperty(ref reader, options, PropTextEmbedding, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModelsCount(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Classification = propClassification.Value,
			Ner = propNer.Value,
			Other = propOther.Value,
			PassThrough = propPassThrough.Value,
			Prepackaged = propPrepackaged.Value,
			Regression = propRegression.Value,
			TextEmbedding = propTextEmbedding.Value,
			Total = propTotal.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModelsCount value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropClassification, value.Classification, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropNer, value.Ner, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropOther, value.Other, null, null);
		writer.WriteProperty(options, PropPassThrough, value.PassThrough, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPrepackaged, value.Prepackaged, null, null);
		writer.WriteProperty(options, PropRegression, value.Regression, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTextEmbedding, value.TextEmbedding, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteEndObject();
	}
}