// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class MlInferenceTrainedModelsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModels>
{
	private static readonly System.Text.Json.JsonEncodedText PropAll = System.Text.Json.JsonEncodedText.Encode("_all");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropEstimatedHeapMemoryUsageBytes = System.Text.Json.JsonEncodedText.Encode("estimated_heap_memory_usage_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropEstimatedOperations = System.Text.Json.JsonEncodedText.Encode("estimated_operations");
	private static readonly System.Text.Json.JsonEncodedText PropModelSizeBytes = System.Text.Json.JsonEncodedText.Encode("model_size_bytes");

	public override Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModels Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlCounter> propAll = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModelsCount?> propCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.JobStatistics?> propEstimatedHeapMemoryUsageBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.JobStatistics?> propEstimatedOperations = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.JobStatistics?> propModelSizeBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAll.TryReadProperty(ref reader, options, PropAll, null))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propEstimatedHeapMemoryUsageBytes.TryReadProperty(ref reader, options, PropEstimatedHeapMemoryUsageBytes, null))
			{
				continue;
			}

			if (propEstimatedOperations.TryReadProperty(ref reader, options, PropEstimatedOperations, null))
			{
				continue;
			}

			if (propModelSizeBytes.TryReadProperty(ref reader, options, PropModelSizeBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModels(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			All = propAll.Value,
			Count = propCount.Value,
			EstimatedHeapMemoryUsageBytes = propEstimatedHeapMemoryUsageBytes.Value,
			EstimatedOperations = propEstimatedOperations.Value,
			ModelSizeBytes = propModelSizeBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.MlInferenceTrainedModels value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAll, value.All, null, null);
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropEstimatedHeapMemoryUsageBytes, value.EstimatedHeapMemoryUsageBytes, null, null);
		writer.WriteProperty(options, PropEstimatedOperations, value.EstimatedOperations, null, null);
		writer.WriteProperty(options, PropModelSizeBytes, value.ModelSizeBytes, null, null);
		writer.WriteEndObject();
	}
}