// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class MlDataFrameAnalyticsJobsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobs>
{
	private static readonly System.Text.Json.JsonEncodedText PropAll = System.Text.Json.JsonEncodedText.Encode("_all");
	private static readonly System.Text.Json.JsonEncodedText PropAnalysisCounts = System.Text.Json.JsonEncodedText.Encode("analysis_counts");
	private static readonly System.Text.Json.JsonEncodedText PropMemoryUsage = System.Text.Json.JsonEncodedText.Encode("memory_usage");
	private static readonly System.Text.Json.JsonEncodedText PropStopped = System.Text.Json.JsonEncodedText.Encode("stopped");

	public override Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobs Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobsCount> propAll = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobsAnalysis?> propAnalysisCounts = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobsMemory?> propMemoryUsage = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobsCount?> propStopped = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAll.TryReadProperty(ref reader, options, PropAll, null))
			{
				continue;
			}

			if (propAnalysisCounts.TryReadProperty(ref reader, options, PropAnalysisCounts, null))
			{
				continue;
			}

			if (propMemoryUsage.TryReadProperty(ref reader, options, PropMemoryUsage, null))
			{
				continue;
			}

			if (propStopped.TryReadProperty(ref reader, options, PropStopped, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobs(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			All = propAll.Value,
			AnalysisCounts = propAnalysisCounts.Value,
			MemoryUsage = propMemoryUsage.Value,
			Stopped = propStopped.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.MlDataFrameAnalyticsJobs value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAll, value.All, null, null);
		writer.WriteProperty(options, PropAnalysisCounts, value.AnalysisCounts, null, null);
		writer.WriteProperty(options, PropMemoryUsage, value.MemoryUsage, null, null);
		writer.WriteProperty(options, PropStopped, value.Stopped, null, null);
		writer.WriteEndObject();
	}
}