// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class JobUsageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.JobUsage>
{
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropCreatedBy = System.Text.Json.JsonEncodedText.Encode("created_by");
	private static readonly System.Text.Json.JsonEncodedText PropDetectors = System.Text.Json.JsonEncodedText.Encode("detectors");
	private static readonly System.Text.Json.JsonEncodedText PropForecasts = System.Text.Json.JsonEncodedText.Encode("forecasts");
	private static readonly System.Text.Json.JsonEncodedText PropModelSize = System.Text.Json.JsonEncodedText.Encode("model_size");

	public override Elastic.Clients.Elasticsearch.Xpack.JobUsage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, long>> propCreatedBy = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.JobStatistics> propDetectors = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Xpack.MlJobForecasts> propForecasts = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.JobStatistics> propModelSize = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propCreatedBy.TryReadProperty(ref reader, options, PropCreatedBy, static System.Collections.Generic.IReadOnlyDictionary<string, long> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, long>(o, null, null)!))
			{
				continue;
			}

			if (propDetectors.TryReadProperty(ref reader, options, PropDetectors, null))
			{
				continue;
			}

			if (propForecasts.TryReadProperty(ref reader, options, PropForecasts, null))
			{
				continue;
			}

			if (propModelSize.TryReadProperty(ref reader, options, PropModelSize, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.JobUsage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Count = propCount.Value,
			CreatedBy = propCreatedBy.Value,
			Detectors = propDetectors.Value,
			Forecasts = propForecasts.Value,
			ModelSize = propModelSize.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.JobUsage value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropCreatedBy, value.CreatedBy, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, long> v) => w.WriteDictionaryValue<string, long>(o, v, null, null));
		writer.WriteProperty(options, PropDetectors, value.Detectors, null, null);
		writer.WriteProperty(options, PropForecasts, value.Forecasts, null, null);
		writer.WriteProperty(options, PropModelSize, value.ModelSize, null, null);
		writer.WriteEndObject();
	}
}