// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class EqlFeaturesSequencesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.EqlFeaturesSequences>
{
	private static readonly System.Text.Json.JsonEncodedText PropSequenceMaxspan = System.Text.Json.JsonEncodedText.Encode("sequence_maxspan");
	private static readonly System.Text.Json.JsonEncodedText PropSequenceQueriesFiveOrMore = System.Text.Json.JsonEncodedText.Encode("sequence_queries_five_or_more");
	private static readonly System.Text.Json.JsonEncodedText PropSequenceQueriesFour = System.Text.Json.JsonEncodedText.Encode("sequence_queries_four");
	private static readonly System.Text.Json.JsonEncodedText PropSequenceQueriesThree = System.Text.Json.JsonEncodedText.Encode("sequence_queries_three");
	private static readonly System.Text.Json.JsonEncodedText PropSequenceQueriesTwo = System.Text.Json.JsonEncodedText.Encode("sequence_queries_two");
	private static readonly System.Text.Json.JsonEncodedText PropSequenceUntil = System.Text.Json.JsonEncodedText.Encode("sequence_until");

	public override Elastic.Clients.Elasticsearch.Xpack.EqlFeaturesSequences Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propSequenceMaxspan = default;
		LocalJsonValue<int> propSequenceQueriesFiveOrMore = default;
		LocalJsonValue<int> propSequenceQueriesFour = default;
		LocalJsonValue<int> propSequenceQueriesThree = default;
		LocalJsonValue<int> propSequenceQueriesTwo = default;
		LocalJsonValue<int> propSequenceUntil = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propSequenceMaxspan.TryReadProperty(ref reader, options, PropSequenceMaxspan, null))
			{
				continue;
			}

			if (propSequenceQueriesFiveOrMore.TryReadProperty(ref reader, options, PropSequenceQueriesFiveOrMore, null))
			{
				continue;
			}

			if (propSequenceQueriesFour.TryReadProperty(ref reader, options, PropSequenceQueriesFour, null))
			{
				continue;
			}

			if (propSequenceQueriesThree.TryReadProperty(ref reader, options, PropSequenceQueriesThree, null))
			{
				continue;
			}

			if (propSequenceQueriesTwo.TryReadProperty(ref reader, options, PropSequenceQueriesTwo, null))
			{
				continue;
			}

			if (propSequenceUntil.TryReadProperty(ref reader, options, PropSequenceUntil, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.EqlFeaturesSequences(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			SequenceMaxspan = propSequenceMaxspan.Value,
			SequenceQueriesFiveOrMore = propSequenceQueriesFiveOrMore.Value,
			SequenceQueriesFour = propSequenceQueriesFour.Value,
			SequenceQueriesThree = propSequenceQueriesThree.Value,
			SequenceQueriesTwo = propSequenceQueriesTwo.Value,
			SequenceUntil = propSequenceUntil.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.EqlFeaturesSequences value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropSequenceMaxspan, value.SequenceMaxspan, null, null);
		writer.WriteProperty(options, PropSequenceQueriesFiveOrMore, value.SequenceQueriesFiveOrMore, null, null);
		writer.WriteProperty(options, PropSequenceQueriesFour, value.SequenceQueriesFour, null, null);
		writer.WriteProperty(options, PropSequenceQueriesThree, value.SequenceQueriesThree, null, null);
		writer.WriteProperty(options, PropSequenceQueriesTwo, value.SequenceQueriesTwo, null, null);
		writer.WriteProperty(options, PropSequenceUntil, value.SequenceUntil, null, null);
		writer.WriteEndObject();
	}
}