// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Xpack.Json;

public sealed partial class AnalyticsStatisticsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Xpack.AnalyticsStatistics>
{
	private static readonly System.Text.Json.JsonEncodedText PropBoxplotUsage = System.Text.Json.JsonEncodedText.Encode("boxplot_usage");
	private static readonly System.Text.Json.JsonEncodedText PropCumulativeCardinalityUsage = System.Text.Json.JsonEncodedText.Encode("cumulative_cardinality_usage");
	private static readonly System.Text.Json.JsonEncodedText PropMovingPercentilesUsage = System.Text.Json.JsonEncodedText.Encode("moving_percentiles_usage");
	private static readonly System.Text.Json.JsonEncodedText PropMultiTermsUsage = System.Text.Json.JsonEncodedText.Encode("multi_terms_usage");
	private static readonly System.Text.Json.JsonEncodedText PropNormalizeUsage = System.Text.Json.JsonEncodedText.Encode("normalize_usage");
	private static readonly System.Text.Json.JsonEncodedText PropRateUsage = System.Text.Json.JsonEncodedText.Encode("rate_usage");
	private static readonly System.Text.Json.JsonEncodedText PropStringStatsUsage = System.Text.Json.JsonEncodedText.Encode("string_stats_usage");
	private static readonly System.Text.Json.JsonEncodedText PropTopMetricsUsage = System.Text.Json.JsonEncodedText.Encode("top_metrics_usage");
	private static readonly System.Text.Json.JsonEncodedText PropTTestUsage = System.Text.Json.JsonEncodedText.Encode("t_test_usage");

	public override Elastic.Clients.Elasticsearch.Xpack.AnalyticsStatistics Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propBoxplotUsage = default;
		LocalJsonValue<long> propCumulativeCardinalityUsage = default;
		LocalJsonValue<long> propMovingPercentilesUsage = default;
		LocalJsonValue<long?> propMultiTermsUsage = default;
		LocalJsonValue<long> propNormalizeUsage = default;
		LocalJsonValue<long> propRateUsage = default;
		LocalJsonValue<long> propStringStatsUsage = default;
		LocalJsonValue<long> propTopMetricsUsage = default;
		LocalJsonValue<long> propTTestUsage = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBoxplotUsage.TryReadProperty(ref reader, options, PropBoxplotUsage, null))
			{
				continue;
			}

			if (propCumulativeCardinalityUsage.TryReadProperty(ref reader, options, PropCumulativeCardinalityUsage, null))
			{
				continue;
			}

			if (propMovingPercentilesUsage.TryReadProperty(ref reader, options, PropMovingPercentilesUsage, null))
			{
				continue;
			}

			if (propMultiTermsUsage.TryReadProperty(ref reader, options, PropMultiTermsUsage, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propNormalizeUsage.TryReadProperty(ref reader, options, PropNormalizeUsage, null))
			{
				continue;
			}

			if (propRateUsage.TryReadProperty(ref reader, options, PropRateUsage, null))
			{
				continue;
			}

			if (propStringStatsUsage.TryReadProperty(ref reader, options, PropStringStatsUsage, null))
			{
				continue;
			}

			if (propTopMetricsUsage.TryReadProperty(ref reader, options, PropTopMetricsUsage, null))
			{
				continue;
			}

			if (propTTestUsage.TryReadProperty(ref reader, options, PropTTestUsage, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Xpack.AnalyticsStatistics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BoxplotUsage = propBoxplotUsage.Value,
			CumulativeCardinalityUsage = propCumulativeCardinalityUsage.Value,
			MovingPercentilesUsage = propMovingPercentilesUsage.Value,
			MultiTermsUsage = propMultiTermsUsage.Value,
			NormalizeUsage = propNormalizeUsage.Value,
			RateUsage = propRateUsage.Value,
			StringStatsUsage = propStringStatsUsage.Value,
			TopMetricsUsage = propTopMetricsUsage.Value,
			TTestUsage = propTTestUsage.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Xpack.AnalyticsStatistics value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBoxplotUsage, value.BoxplotUsage, null, null);
		writer.WriteProperty(options, PropCumulativeCardinalityUsage, value.CumulativeCardinalityUsage, null, null);
		writer.WriteProperty(options, PropMovingPercentilesUsage, value.MovingPercentilesUsage, null, null);
		writer.WriteProperty(options, PropMultiTermsUsage, value.MultiTermsUsage, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropNormalizeUsage, value.NormalizeUsage, null, null);
		writer.WriteProperty(options, PropRateUsage, value.RateUsage, null, null);
		writer.WriteProperty(options, PropStringStatsUsage, value.StringStatsUsage, null, null);
		writer.WriteProperty(options, PropTopMetricsUsage, value.TopMetricsUsage, null, null);
		writer.WriteProperty(options, PropTTestUsage, value.TTestUsage, null, null);
		writer.WriteEndObject();
	}
}