// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class WaitForEventsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.WaitForEvents>
{
	private static readonly System.Text.Json.JsonEncodedText MemberHigh = System.Text.Json.JsonEncodedText.Encode("high");
	private static readonly System.Text.Json.JsonEncodedText MemberImmediate = System.Text.Json.JsonEncodedText.Encode("immediate");
	private static readonly System.Text.Json.JsonEncodedText MemberLanguid = System.Text.Json.JsonEncodedText.Encode("languid");
	private static readonly System.Text.Json.JsonEncodedText MemberLow = System.Text.Json.JsonEncodedText.Encode("low");
	private static readonly System.Text.Json.JsonEncodedText MemberNormal = System.Text.Json.JsonEncodedText.Encode("normal");
	private static readonly System.Text.Json.JsonEncodedText MemberUrgent = System.Text.Json.JsonEncodedText.Encode("urgent");

	public override Elastic.Clients.Elasticsearch.WaitForEvents Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberHigh))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.High;
		}

		if (reader.ValueTextEquals(MemberImmediate))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Immediate;
		}

		if (reader.ValueTextEquals(MemberLanguid))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Languid;
		}

		if (reader.ValueTextEquals(MemberLow))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Low;
		}

		if (reader.ValueTextEquals(MemberNormal))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Normal;
		}

		if (reader.ValueTextEquals(MemberUrgent))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Urgent;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberHigh.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.High;
		}

		if (string.Equals(value, MemberImmediate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Immediate;
		}

		if (string.Equals(value, MemberLanguid.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Languid;
		}

		if (string.Equals(value, MemberLow.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Low;
		}

		if (string.Equals(value, MemberNormal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Normal;
		}

		if (string.Equals(value, MemberUrgent.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForEvents.Urgent;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.WaitForEvents)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.WaitForEvents value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.WaitForEvents.High:
				writer.WriteStringValue(MemberHigh);
				break;
			case Elastic.Clients.Elasticsearch.WaitForEvents.Immediate:
				writer.WriteStringValue(MemberImmediate);
				break;
			case Elastic.Clients.Elasticsearch.WaitForEvents.Languid:
				writer.WriteStringValue(MemberLanguid);
				break;
			case Elastic.Clients.Elasticsearch.WaitForEvents.Low:
				writer.WriteStringValue(MemberLow);
				break;
			case Elastic.Clients.Elasticsearch.WaitForEvents.Normal:
				writer.WriteStringValue(MemberNormal);
				break;
			case Elastic.Clients.Elasticsearch.WaitForEvents.Urgent:
				writer.WriteStringValue(MemberUrgent);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.WaitForEvents)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.WaitForEvents ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.WaitForEvents value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}