// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class WaitForActiveShardOptionsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.WaitForActiveShardOptions>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText MemberIndexSetting = System.Text.Json.JsonEncodedText.Encode("index-setting");

	public override Elastic.Clients.Elasticsearch.WaitForActiveShardOptions Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.All;
		}

		if (reader.ValueTextEquals(MemberIndexSetting))
		{
			return Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.IndexSetting;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.All;
		}

		if (string.Equals(value, MemberIndexSetting.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.IndexSetting;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.WaitForActiveShardOptions)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.WaitForActiveShardOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.WaitForActiveShardOptions.IndexSetting:
				writer.WriteStringValue(MemberIndexSetting);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.WaitForActiveShardOptions)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.WaitForActiveShardOptions ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.WaitForActiveShardOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}