// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.VersionTypeConverter))]
public enum VersionType
{
	/// <summary>
	/// <para>
	/// Only index the document if the specified version is strictly higher than the version of the stored document or if there is no existing document.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "external")]
	External,
	/// <summary>
	/// <para>
	/// Only index the document if the specified version is equal or higher than the version of the stored document or if there is no existing document.
	/// NOTE: The <c>external_gte</c> version type is meant for special use cases and should be used with care.
	/// If used incorrectly, it can result in loss of data.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "external_gte")]
	ExternalGte,
	/// <summary>
	/// <para>
	/// This option is deprecated because it can cause primary and replica shards to diverge.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "force")]
	Force,
	/// <summary>
	/// <para>
	/// Use internal versioning that starts at 1 and increments with each update or delete.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "internal")]
	Internal
}