// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class VersionTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.VersionType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberExternal = System.Text.Json.JsonEncodedText.Encode("external");
	private static readonly System.Text.Json.JsonEncodedText MemberExternalGte = System.Text.Json.JsonEncodedText.Encode("external_gte");
	private static readonly System.Text.Json.JsonEncodedText MemberForce = System.Text.Json.JsonEncodedText.Encode("force");
	private static readonly System.Text.Json.JsonEncodedText MemberInternal = System.Text.Json.JsonEncodedText.Encode("internal");

	public override Elastic.Clients.Elasticsearch.VersionType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberExternal))
		{
			return Elastic.Clients.Elasticsearch.VersionType.External;
		}

		if (reader.ValueTextEquals(MemberExternalGte))
		{
			return Elastic.Clients.Elasticsearch.VersionType.ExternalGte;
		}

		if (reader.ValueTextEquals(MemberForce))
		{
			return Elastic.Clients.Elasticsearch.VersionType.Force;
		}

		if (reader.ValueTextEquals(MemberInternal))
		{
			return Elastic.Clients.Elasticsearch.VersionType.Internal;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberExternal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.VersionType.External;
		}

		if (string.Equals(value, MemberExternalGte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.VersionType.ExternalGte;
		}

		if (string.Equals(value, MemberForce.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.VersionType.Force;
		}

		if (string.Equals(value, MemberInternal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.VersionType.Internal;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.VersionType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.VersionType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.VersionType.External:
				writer.WriteStringValue(MemberExternal);
				break;
			case Elastic.Clients.Elasticsearch.VersionType.ExternalGte:
				writer.WriteStringValue(MemberExternalGte);
				break;
			case Elastic.Clients.Elasticsearch.VersionType.Force:
				writer.WriteStringValue(MemberForce);
				break;
			case Elastic.Clients.Elasticsearch.VersionType.Internal:
				writer.WriteStringValue(MemberInternal);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.VersionType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.VersionType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.VersionType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}