// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.TransformManagement.Json.TransformSummaryConverter))]
public sealed partial class TransformSummary
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TransformSummary(Elastic.Clients.Elasticsearch.Core.Reindex.Destination dest, string id, Elastic.Clients.Elasticsearch.TransformManagement.Source source)
	{
		Dest = dest;
		Id = id;
		Source = source;
	}
#if NET7_0_OR_GREATER
	public TransformSummary()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public TransformSummary()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TransformSummary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The security privileges that the transform uses to run its queries. If Elastic Stack security features were disabled at the time of the most recent update to the transform, this property is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TransformAuthorization? Authorization { get; set; }

	/// <summary>
	/// <para>
	/// The time the transform was created.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? CreateTime { get; set; }
	public System.DateTimeOffset? CreateTimeString { get; set; }

	/// <summary>
	/// <para>
	/// Free text description of the transform.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The destination for the transform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Core.Reindex.Destination Dest { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? Frequency { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }
	public Elastic.Clients.Elasticsearch.TransformManagement.Latest? Latest { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// The pivot method transforms the data by aggregating and grouping it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.Pivot? Pivot { get; set; }
	public Elastic.Clients.Elasticsearch.TransformManagement.RetentionPolicy? RetentionPolicy { get; set; }

	/// <summary>
	/// <para>
	/// Defines optional transform settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.Settings? Settings { get; set; }

	/// <summary>
	/// <para>
	/// The source of the data for the transform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.TransformManagement.Source Source { get; set; }

	/// <summary>
	/// <para>
	/// Defines the properties transforms require to run continuously.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.TransformManagement.Sync? Sync { get; set; }

	/// <summary>
	/// <para>
	/// The version of Elasticsearch that existed on the node when the transform was created.
	/// </para>
	/// </summary>
	public string? Version { get; set; }
}