// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.TransformManagement.Json;

public sealed partial class TransformProgressConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.TransformManagement.TransformProgress>
{
	private static readonly System.Text.Json.JsonEncodedText PropDocsIndexed = System.Text.Json.JsonEncodedText.Encode("docs_indexed");
	private static readonly System.Text.Json.JsonEncodedText PropDocsProcessed = System.Text.Json.JsonEncodedText.Encode("docs_processed");
	private static readonly System.Text.Json.JsonEncodedText PropDocsRemaining = System.Text.Json.JsonEncodedText.Encode("docs_remaining");
	private static readonly System.Text.Json.JsonEncodedText PropPercentComplete = System.Text.Json.JsonEncodedText.Encode("percent_complete");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDocs = System.Text.Json.JsonEncodedText.Encode("total_docs");

	public override Elastic.Clients.Elasticsearch.TransformManagement.TransformProgress Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propDocsIndexed = default;
		LocalJsonValue<long> propDocsProcessed = default;
		LocalJsonValue<long?> propDocsRemaining = default;
		LocalJsonValue<double?> propPercentComplete = default;
		LocalJsonValue<long?> propTotalDocs = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDocsIndexed.TryReadProperty(ref reader, options, PropDocsIndexed, null))
			{
				continue;
			}

			if (propDocsProcessed.TryReadProperty(ref reader, options, PropDocsProcessed, null))
			{
				continue;
			}

			if (propDocsRemaining.TryReadProperty(ref reader, options, PropDocsRemaining, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPercentComplete.TryReadProperty(ref reader, options, PropPercentComplete, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (propTotalDocs.TryReadProperty(ref reader, options, PropTotalDocs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.TransformManagement.TransformProgress(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DocsIndexed = propDocsIndexed.Value,
			DocsProcessed = propDocsProcessed.Value,
			DocsRemaining = propDocsRemaining.Value,
			PercentComplete = propPercentComplete.Value,
			TotalDocs = propTotalDocs.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.TransformManagement.TransformProgress value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDocsIndexed, value.DocsIndexed, null, null);
		writer.WriteProperty(options, PropDocsProcessed, value.DocsProcessed, null, null);
		writer.WriteProperty(options, PropDocsRemaining, value.DocsRemaining, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPercentComplete, value.PercentComplete, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteProperty(options, PropTotalDocs, value.TotalDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}